/*
 * Decompiled with CFR 0.152.
 */
package com.luway.pikachu.core.engine.impl;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.luway.pikachu.common.TimeUtil;
import com.luway.pikachu.core.annotations.MathUrl;
import com.luway.pikachu.core.engine.AbstractTempMethod;
import com.luway.pikachu.core.exception.SimpleException;
import com.luway.pikachu.core.worker.BathWorker;
import com.luway.pikachu.core.worker.GeneralWorker;
import com.luway.pikachu.core.worker.Worker;
import com.luway.pikachu.core.worker.bean.Target;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.htmlcleaner.CleanerProperties;
import org.htmlcleaner.DomSerializer;
import org.htmlcleaner.HtmlCleaner;
import org.htmlcleaner.TagNode;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PikachuCore
extends AbstractTempMethod {
    private static final Logger log = LoggerFactory.getLogger(PikachuCore.class);
    private Document doc;
    private volatile Boolean flag = true;
    private Long stopTime = 30L;
    private BlockingQueue<Worker> workerQueue = new ArrayBlockingQueue<Worker>(1024);
    private ExecutorService pikachuPool;

    public PikachuCore(ExecutorService pikachuPool) {
        this.pikachuPool = pikachuPool;
    }

    protected boolean putWorker(Worker worker) {
        return this.workerQueue.offer(worker);
    }

    public void start() {
        this.pikachuPool.execute(new Runnable(){

            @Override
            public void run() {
                while (PikachuCore.this.flag.booleanValue()) {
                    try {
                        Worker worker = (Worker)PikachuCore.this.workerQueue.take();
                        if (worker.validate().booleanValue()) {
                            if (worker instanceof GeneralWorker) {
                                GeneralWorker generalWorker = (GeneralWorker)worker;
                                PikachuCore.this.pikachuPool.execute(() -> {
                                    try {
                                        PikachuCore.this.load(generalWorker);
                                    }
                                    catch (Exception e) {
                                        log.error("core error", (Throwable)e);
                                    }
                                });
                            }
                            if (!(worker instanceof BathWorker)) continue;
                            BathWorker bathWorker = (BathWorker)worker;
                            PikachuCore.this.pikachuPool.execute(() -> {
                                try {
                                    PikachuCore.this.load(bathWorker);
                                }
                                catch (Exception e) {
                                    log.error("core error", (Throwable)e);
                                }
                            });
                            continue;
                        }
                        log.error("this worker's pip is null.[WORKER ID: " + worker.getId() + "]");
                        throw new Exception("this worker's pip is null.[WORKER ID: " + worker.getId() + "]");
                    }
                    catch (Exception e) {
                        log.error("core error", (Throwable)e);
                        PikachuCore.this.stop();
                    }
                }
            }
        });
    }

    private void load(BathWorker worker) throws Exception {
        for (String url : worker.getUrlList()) {
            this.pikachuPool.execute(() -> {
                try {
                    this.exector(url, worker);
                }
                catch (Exception e) {
                    log.error("exception", (Throwable)e);
                    throw new SimpleException(e);
                }
            });
        }
    }

    private void exector(String url, BathWorker worker) throws Exception {
        TimeUtil.sleep();
        Document doc = null;
        if (MathUrl.Method.GET.equals((Object)worker.getMethod())) {
            doc = worker.getCookies() != null ? this.getConnection(url).cookies(worker.getCookies()).get() : this.getConnection(url).get();
        } else if (MathUrl.Method.POST.equals((Object)worker.getMethod())) {
            doc = worker.getCookies() != null ? this.getConnection(url).cookies(worker.getCookies()).post() : this.getConnection(url).post();
        }
        if (doc == null) {
            worker.getPipeline().output(null, url);
        }
        Map<String, Elements> target = this.select(doc, worker.getAttr());
        this.out(target, url, worker);
    }

    public synchronized void load(GeneralWorker worker) throws Exception {
        if (worker.isLoadJs()) {
            this.loadJs(worker);
        } else {
            this.loadHtml(worker);
        }
    }

    private void loadJs(GeneralWorker worker) throws Exception {
        WebClient wc = new WebClient(BrowserVersion.FIREFOX_52);
        wc.setJavaScriptTimeout(5000L);
        wc.getOptions().setUseInsecureSSL(true);
        wc.getOptions().setJavaScriptEnabled(true);
        wc.getOptions().setCssEnabled(false);
        wc.getOptions().setThrowExceptionOnScriptError(false);
        wc.getOptions().setTimeout(100000);
        wc.getOptions().setDoNotTrackEnabled(false);
        HtmlPage page = (HtmlPage)wc.getPage(worker.getUrl());
        String pageAsXml = page.asXml();
        Document doc = Jsoup.parse((String)pageAsXml, (String)worker.getUrl());
        Map<String, Elements> target = this.select(doc, worker.getAttr());
        this.out(target, worker.getUrl(), worker);
    }

    private void loadHtml(GeneralWorker worker) throws Exception {
        if (worker.getCookies() == null) {
            if (MathUrl.Method.GET.equals((Object)worker.getMethod())) {
                this.doc = this.getConnection(worker.getUrl()).get();
            } else if (MathUrl.Method.POST.equals((Object)worker.getMethod())) {
                this.doc = this.getConnection(worker.getUrl()).post();
            }
        } else if (MathUrl.Method.GET.equals((Object)worker.getMethod())) {
            this.doc = this.getConnection(worker.getUrl()).cookies(worker.getCookies()).get();
        } else if (MathUrl.Method.POST.equals((Object)worker.getMethod())) {
            this.doc = this.getConnection(worker.getUrl()).cookies(worker.getCookies()).post();
        }
        if (this.doc == null) {
            worker.getPipeline().output(null, worker.getUrl());
        }
        Map<String, Elements> target = this.select(this.doc, worker.getAttr());
        this.out(target, worker.getUrl(), worker);
    }

    private synchronized void out(Map<String, Elements> target, String url, Worker worker) {
        worker.getPipeline().output(target, url);
        if (worker.getPipeline().checkWorker().size() > 0) {
            List<GeneralWorker> workerList = worker.getPipeline().checkWorker();
            for (GeneralWorker worker1 : workerList) {
                this.workerQueue.offer(worker1);
            }
        }
    }

    private Map<String, Elements> select(Document doc, Map<String, Target> params) throws Exception {
        HashMap<String, Elements> target = new HashMap<String, Elements>(16);
        HtmlCleaner hc = new HtmlCleaner();
        TagNode tn = hc.clean(doc.body().html());
        org.w3c.dom.Document dom = new DomSerializer(new CleanerProperties()).createDOM(tn);
        XPath xPath = XPathFactory.newInstance().newXPath();
        for (Map.Entry<String, Target> attr : params.entrySet()) {
            if (null != attr.getValue().getSelector()) {
                Elements elements = doc.select(attr.getValue().getSelector());
                target.put(attr.getValue().getName(), elements);
            }
            if (null == attr.getValue().getXpath()) continue;
            Elements result = (Elements)xPath.evaluate(attr.getValue().getXpath(), dom, XPathConstants.NODESET);
            target.put(attr.getValue().getName(), result);
        }
        return target;
    }

    public void stop() {
        this.flag = false;
        this.pikachuPool.shutdown();
    }

    @Override
    protected Document getConnect(String url, MathUrl.Method method) throws IOException {
        if (MathUrl.Method.GET.equals((Object)method)) {
            this.doc = this.getConnection(url).get();
        } else if (MathUrl.Method.POST.equals((Object)method)) {
            this.doc = this.getConnection(url).post();
        }
        return this.doc;
    }

    @Override
    protected Document getConnect(String url, MathUrl.Method method, Map<String, String> cookies) throws IOException {
        if (MathUrl.Method.GET.equals((Object)method)) {
            this.doc = this.getConnection(url).cookies(cookies).get();
        } else if (MathUrl.Method.POST.equals((Object)method)) {
            this.doc = this.getConnection(url).cookies(cookies).post();
        }
        return this.doc;
    }

    private Connection getConnection(String url) {
        try {
            Thread.sleep(800L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return Jsoup.connect((String)url).timeout(300000).header("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8").header("Accept-Encoding", "gzip, deflate, sdch").header("Accept-Language", "zh-CN,zh;q=0.8").userAgent("Mozilla/5.0 (Windows NT 6.1; WOW64; rv:29.0) Gecko/20100101 Firefox/29.0").validateTLSCertificates(false);
    }

    @Override
    public Queue<Worker> getQueue() {
        return this.workerQueue;
    }
}

