/*
 * Decompiled with CFR 0.152.
 */
package com.luway.pikachu.common;

public class SnowFlakeUtil {
    private static final long START_STMP = 1480166465631L;
    private static final long SEQUENCE_BIT = 12L;
    private static final long MACHINE_BIT = 5L;
    private static final long DATACENTER_BIT = 5L;
    private static final long MAX_DATACENTER_NUM = 31L;
    private static final long MAX_MACHINE_NUM = 31L;
    private static final long MAX_SEQUENCE = 4095L;
    private static final long MACHINE_LEFT = 12L;
    private static final long DATACENTER_LEFT = 17L;
    private static final long TIMESTMP_LEFT = 22L;
    private static long datacenterId;
    private static long machineId;
    private static long sequence;
    private static long lastStmp;

    public static String getId() {
        return String.valueOf(SnowFlakeUtil.nextId());
    }

    private static synchronized long nextId() {
        long currStmp = SnowFlakeUtil.getNewstmp();
        if (currStmp < lastStmp) {
            throw new RuntimeException("Clock moved backwards.  Refusing to generate id");
        }
        if (currStmp == lastStmp) {
            if ((sequence = sequence + 1L & 0xFFFL) == 0L) {
                currStmp = SnowFlakeUtil.getNextMill();
            }
        } else {
            sequence = 0L;
        }
        lastStmp = currStmp;
        return currStmp - 1480166465631L << 22 | datacenterId << 17 | machineId << 12 | sequence;
    }

    private static long getNextMill() {
        long mill = SnowFlakeUtil.getNewstmp();
        while (mill <= lastStmp) {
            mill = SnowFlakeUtil.getNewstmp();
        }
        return mill;
    }

    private static long getNewstmp() {
        return System.currentTimeMillis();
    }

    static {
        sequence = 0L;
        lastStmp = -1L;
    }
}

