/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.template.engine;

import cn.hutool.extra.template.Engine;
import cn.hutool.extra.template.TemplateConfig;
import cn.hutool.extra.template.TemplateException;
import cn.hutool.extra.template.engine.beetl.BeetlEngine;
import cn.hutool.extra.template.engine.freemarker.FreemarkerEngine;
import cn.hutool.extra.template.engine.rythm.RythmEngine;
import cn.hutool.extra.template.engine.velocity.VelocityEngine;
import cn.hutool.log.StaticLog;

public class EngineFactory {
    public static Engine create(TemplateConfig config) {
        Engine engine = EngineFactory.doCreate(config);
        StaticLog.debug("Use [{}] Engine As Default.", engine.getName());
        return engine;
    }

    private static Engine doCreate(TemplateConfig config) {
        try {
            return new BeetlEngine(config);
        }
        catch (NoClassDefFoundError e) {
            try {
                return new FreemarkerEngine(config);
            }
            catch (NoClassDefFoundError e2) {
                try {
                    return new VelocityEngine(config);
                }
                catch (NoClassDefFoundError e3) {
                    try {
                        return new RythmEngine(config);
                    }
                    catch (NoClassDefFoundError noClassDefFoundError) {
                        throw new TemplateException("No template found ! Please add one of [Beetl,Freemarker,Velocity,Rythm] jar to your project !");
                    }
                }
            }
        }
    }
}

