package cn.gtmap.zhsw.web.util;

import cn.gtmap.zhsw.exception.BuildLandException;
import cn.gtmap.zhsw.utils.CommonUtil;

import com.opensymphony.xwork2.Action;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.StrutsStatics;

import javax.servlet.http.HttpServletResponse;

/**
 * Created with IntelliJ IDEA.
 * User: shenjian
 * Date: 13-5-9
 * Time: 下午7:22
 * 异常拦截器.
 */
public class ExceptionInterceptor extends AbstractInterceptor {
    @Override
    public String intercept(ActionInvocation actionInvocation) throws Exception {
        String result = null;
        try{
            result = actionInvocation.invoke();
        }catch (Exception e){
            String errorMsg = "未知错误！";

            if(e instanceof BuildLandException){
                BuildLandException egovGisException = (BuildLandException)e;
                egovGisException.printStackTrace();
                if(StringUtils.isNotBlank(egovGisException.getMessage()))
                    errorMsg = egovGisException.getMessage();
            }else if(e instanceof RuntimeException){
                RuntimeException runtimeException = (RuntimeException)e;
                runtimeException.printStackTrace();
                if(StringUtils.isNotBlank(runtimeException.getMessage()))
                    errorMsg = runtimeException.getMessage();
            }else{
                if(StringUtils.isNotBlank(e.getMessage()))
                    errorMsg = e.getMessage();
                e.printStackTrace();
            }
            HttpServletResponse response = (HttpServletResponse)actionInvocation.getInvocationContext().get(StrutsStatics.HTTP_RESPONSE);
            response.setContentType("text/html;charset=UTF-8");

            Log log = LogFactory.getLog(actionInvocation.getAction().getClass());
            log.error(errorMsg,e);
            response.getWriter().println(CommonUtil.generateJsonResult(false, false, errorMsg));

            return Action.NONE;
        }
        return result;
    }
}
