package cn.gtmap.zhsw.web.action.map;

import cn.gtmap.zhsw.entity.MapVo;
import cn.gtmap.zhsw.utils.CommonUtil;
import cn.gtmap.zhsw.utils.PlatformHelper;
import cn.gtmap.onemap.service.GeoService;
import com.alibaba.fastjson.JSON;
import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.model.Space;
import com.gtis.fileCenter.service.NodeService;
import com.gtis.generic.util.Struts2Utils;
import com.gtis.spring.Container;
import net.sf.json.JSONObject;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.ServletRequestAware;
import org.apache.struts2.interceptor.ServletResponseAware;
import org.springframework.beans.factory.annotation.Autowired;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

@Results({
        @Result(name = "success", location = "/WEB-INF/views/map/view-one-map.jsp")
})

public class ViewMapAction implements ServletRequestAware, ServletResponseAware {
    private HttpServletRequest request;
    private HttpServletResponse response;

    private File ulfile;
    private String message;
    private String proid;
    private String result;

    private Integer nodeId;
    private String token;
    private String filename;

    //监测显示
    private String OBJECTID;
    private Boolean flag = null;
    private String layerName;
    private String busiType;

    private MapVo mapVo;

    public void fileCenter(String proid){
        try {
            NodeService nodeService = (NodeService) Container.getBean("NodeService");
            Space space = nodeService.getWorkSpace("WORK_FLOW_STUFF");
            Node prjNode = nodeService.getNode(space.getId(), proid, true);
            nodeId=prjNode.getId();
            token=nodeService.getToken(prjNode);
        } catch (Exception e) {
            System.out.println("文件中心异常："+e.getMessage());
        }
    }

    public String execute() throws Exception {
        //String jsonStr = request.getParameter("data");
        String jsonStr = "{'TDZL':'北京','OBJECTID':'101010100','YDMJ':'-8℃','DL':'4℃','NGDFS':'晴','BGDL':'n0','PGDJ':'n0','JZDJ':'n0','BZ':'qqq'}";
        Map jsonNode = new HashMap();
        if(StringUtils.isNotBlank(jsonStr)){
            jsonNode = JSONObject.fromObject(jsonStr);
        }
        mapVo = new MapVo();
        mapVo.setTdzl(MapUtils.getString(jsonNode, "TDZL"));
        mapVo.setTdyt(MapUtils.getString(jsonNode, "TDYT"));
        mapVo.setYdmj(MapUtils.getString(jsonNode, "YDMJ"));
        mapVo.setDl(MapUtils.getString(jsonNode, "DL"));
        mapVo.setNgdfs(MapUtils.getString(jsonNode, "NGDFS"));
        mapVo.setPgdj(MapUtils.getString(jsonNode, "PGDJ"));
        mapVo.setJzdj(MapUtils.getString(jsonNode, "JZDJ"));
        mapVo.setZdbhj(MapUtils.getString(jsonNode, "ZDBHJ"));
        mapVo.setJyqsj(MapUtils.getString(jsonNode, "JYQSJ"));
        mapVo.setNcrnx(MapUtils.getString(jsonNode, "NCRNX"));
        mapVo.setXz(MapUtils.getString(jsonNode, "XZ"));
        mapVo.setNzzpc(MapUtils.getString(jsonNode, "NZZPC"));
        mapVo.setYsqdw(MapUtils.getString(jsonNode, "YSQDW"));
        mapVo.setBz(MapUtils.getString(jsonNode, "BZ"));
        mapVo.setObjectid(MapUtils.getString(jsonNode, "OBJECTID"));
        OBJECTID = MapUtils.getString(jsonNode,"OBJECTID");
        System.out.println(OBJECTID);
        //fileCenter(OBJECTID);
        return  "success";
    }

    public String saveViewOneMap() throws Exception{
        result = "false";
        message = "保存失败!";
        GeoService geoService = (GeoService)Container.getBean("GeoService");
        layerName = PlatformHelper.getLayerName(busiType);
        Map<String, Object> context = new HashMap<String,Object>();
        context.put("TDZL",mapVo.getTdzl());
        context.put("TDYT",mapVo.getTdyt());
        context.put("YDMJ",mapVo.getYdmj());
        context.put("DL",mapVo.getDl());
        context.put("NGDFS",mapVo.getNgdfs());
        context.put("PGDJ",mapVo.getPgdj());
        context.put("JZDJ",mapVo.getJzdj());
        context.put("ZDBHJ",mapVo.getZdbhj());
        context.put("JYQSJ",mapVo.getJyqsj());
        context.put("NCRNX",mapVo.getNcrnx());
        context.put("XZ",mapVo.getXz());
        context.put("NZZPC",mapVo.getNzzpc());
        context.put("YSQDW",mapVo.getYsqdw());
        context.put("BZ",mapVo.getBz());
        //String jsonData = freeMarkConfigService.getTblStrData(context,"/Template/oneMap.ftl");
        String properties = JSON.toJSONString(context);
        System.out.println("[save]:" + properties);
        if(StringUtils.isNotBlank(properties)){
            try {
                flag = geoService.update2(layerName,"OBJECTID='".concat(OBJECTID+"'"),properties,null);
                result = "true";
                message = "保存成功！";
                Struts2Utils.renderJson(CommonUtil.generateJsonResult(true, result, message));
            } catch (Exception e) {
                e.printStackTrace();
                Struts2Utils.renderJson(CommonUtil.generateJsonResult(false, result, message));
            }
        }
        //fileCenter(OBJECTID);
        return "none";
    }

    public void setServletRequest(HttpServletRequest arg0) {
        this.request = arg0;
    }

    public void setServletResponse(HttpServletResponse arg0) {
        this.response = arg0;
    }

    public MapVo getMapVo() {
        return mapVo;
    }

    public void setMapVo(MapVo mapVo) {
        this.mapVo = mapVo;
    }

    public File getUlfile() {
        return ulfile;
    }

    public void setUlfile(File ulfile) {
        this.ulfile = ulfile;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getProid() {
        return proid;
    }

    public void setProid(String proid) {
        this.proid = proid;
    }

    public String getResult() {
        return result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public Integer getNodeId() {
        return nodeId;
    }

    public void setNodeId(Integer nodeId) {
        this.nodeId = nodeId;
    }

    public String getToken() {
        return token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getFilename() {
        return filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getOBJECTID() {
        return OBJECTID;
    }

    public void setOBJECTID(String OBJECTID) {
        this.OBJECTID = OBJECTID;
    }

    public Boolean isFlag() {
        return flag;
    }

    public void setFlag(Boolean flag) {
        this.flag = flag;
    }

    public String getLayerName() {
        return layerName;
    }

    public void setLayerName(String layerName) {
        this.layerName = layerName;
    }

    public String getBusiType() {
        return busiType;
    }

    public void setBusiType(String busiType) {
        this.busiType = busiType;
    }
}
