package cn.gtmap.zhsw.web.action.map;

import java.io.PrintWriter;
import java.util.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.struts2.interceptor.ServletRequestAware;
import org.apache.struts2.interceptor.ServletResponseAware;
import org.apache.struts2.json.JSONUtil;
import org.springframework.beans.factory.annotation.Autowired;

import cn.gtmap.zhsw.dao.ibatis.*;
import cn.gtmap.zhsw.entity.*;
import cn.gtmap.zhsw.service.*;
import cn.gtmap.zhsw.utils.*;

/**
 * 地图配置
* @文件名 MapConfigAction.java
 * @作者 卢向伟
 * @创建日期 2013-10-23
 * @创建时间 下午12:28:58 
 * @版本号 V 1.0
 */
public class MapConfigAction   implements ServletRequestAware, ServletResponseAware{
	private HttpServletResponse response;
	private HttpServletRequest request;
	
	private String xzqdm;//行政区代码
	private String proid;//项目id
	private String parentProid;//如果该proid为项目中子表id，则需要传递该参数获取该工作流对应的proid，用于获取busiType
	private String paramString;//
	private String busiType;//业务代码
	private String message;
	private String result;
	private String hideTopBar;
	private String hideLeftPanel;
	
	public String execute()throws  Exception{
		String whereClause = "DKID='"+proid+"'";
		initLocationUrl(whereClause,busiType,hideTopBar,hideLeftPanel);
		return  "none";
    }
	/**
	 * 定位整个批次图形
	 * @return
	 * @throws Exception
	 */
	public String locationProjBuildMap()throws  Exception{
		//根据批次查询所有地块，获取地块id
		String dkids = "DKID in (";
//		DKID in ('8a84c58a41e3ad1c0141e827b2a70053','8a84c58a41e3ad1c0141e828a84e009d','8a84c58a41e3ad1c0141e82943060103','8a84c58a41e3ad1c0141e829e0a0014b')
		//dkids = DKID='8a84c58a41e3ad1c0141e827b2a70053' or DKID='8a84c58a41e3ad1c0141e828a84e009d'
//		List<BlBuildlanditem> itemList = blProjPlotRelService.findBlBuildlanditemListByPbId(proid);
//		if (itemList != null) {
//			for (int i = 0; i < itemList.size(); i++) {
//				dkids += "'"+itemList.get(i).getProId()+"',";
//			}
//		}
		if (StringUtils.endsWith(dkids, ",")){
			dkids = StringUtils.removeEnd(dkids, ",");
		}
		dkids += ")";
		String whereClause = dkids;
		initLocationUrl(whereClause,busiType,hideTopBar,hideLeftPanel);
		return  "none";
    }
	
	public String locationXmMap()throws  Exception{
		String whereClause = "XM_ID='"+proid+"'";
		initLocationUrl(whereClause,busiType,hideTopBar,hideLeftPanel);
		return  "none";
    }
	
	/**
	 * 
	 * paramString 查询参数，格式为：DKID='11111111'
	 * @return
	 * @throws Exception
	 */
	public String locationMapByParam()throws  Exception{
		/*String whereClause = paramString;
		initLocationUrl(whereClause,busiType,hideTopBar,hideLeftPanel);*/
		if (StringUtils.isBlank(busiType)) {
			busiType = PublicUtil.getBusiTypeByConfig(proid);
		}
		if (StringUtils.isBlank(busiType) && StringUtils.isNotBlank(parentProid)) {
			busiType = PublicUtil.getBusiTypeByConfig(parentProid);
		}
		if (StringUtils.isBlank(hideTopBar) || StringUtils.equals(hideTopBar, "true")) {
			hideTopBar = "true";
		}
		if (StringUtils.isNotBlank(busiType) && StringUtils.isNotBlank(paramString)) {
			String layerName = PlatformHelper.getLayerAlias(busiType);
//			layerName = java.net.URLEncoder.encode(layerName,"utf-8");
			HashMap<String,String> childMap = new HashMap<String, String>();
			childMap.put("where", paramString);
			childMap.put("layerAlias", layerName);
			HashMap param = new HashMap();
			param.put("params", childMap);
			param.put("type","layerLocation");
			String url = PlatformHelper.getOmpURL()+"/map/"+PlatformHelper.getOmpTemplate(busiType)+"?action=location&hideTopBar="+hideTopBar+"&params="+java.net.URLEncoder.encode(JSONUtil.serialize(param),"utf-8")+"&"+request.getQueryString();
//			url = PlatformHelper.getOmpURL()+"/map/"+PlatformHelper.getOmpTemplate(busiType)+"?action=location&hideTopBar="+hideTopBar+"&params="+JSONUtil.serialize(param)+"&"+request.getQueryString();System.out.println(url);
			System.out.println(url);
			response.sendRedirect(url);
		}else {
			String url = PlatformHelper.getOmpURL()+"/map/"+PlatformHelper.getOmpTemplate(busiType);
			System.out.println(url);
			response.sendRedirect(url);
			message = "构建平台没有配置当前工作流对应的busiType！";
			response.setContentType("text/html;charset=UTF-8");
			PrintWriter out = response.getWriter();
			out.println(message);
			out.flush();
			out.close();
		}
		return  "none";
    }
	
	private void initLocationUrl(String whereClause,String bType,String hideTop,String hideLeft){
		try {
			if (StringUtils.isNotBlank(bType) && StringUtils.isNotBlank(whereClause)) {
				String url = GeometryOperationUtil.initLocationUrl(whereClause, bType, hideTop, hideLeft);
				if (StringUtils.isNotBlank(url)) {
					url += "&"+request.getQueryString();
				}
				response.sendRedirect(url);
			}else {
				message = "构建平台没有配置当前工作流对应的busiType！";
				response.setContentType("text/html;charset=UTF-8");
				PrintWriter out = response.getWriter();
				out.println(message);
				out.flush();
				out.close();
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	public void setServletResponse(HttpServletResponse arg0) {
		this.response=arg0;		
	}

	public void setServletRequest(HttpServletRequest arg0) {
        this.request=arg0;
	}
	public HttpServletResponse getResponse() {
		return response;
	}
	public void setResponse(HttpServletResponse response) {
		this.response = response;
	}
	public HttpServletRequest getRequest() {
		return request;
	}
	public void setRequest(HttpServletRequest request) {
		this.request = request;
	}
	public String getXzqdm() {
		return xzqdm;
	}
	public void setXzqdm(String xzqdm) {
		this.xzqdm = xzqdm;
	}
	public String getProid() {
		return proid;
	}
	public void setProid(String proid) {
		this.proid = proid;
	}
	public String getParamString() {
		return paramString;
	}
	public void setParamString(String paramString) {
		this.paramString = paramString;
	}
	public String getBusiType() {
		return busiType;
	}
	public void setBusiType(String busiType) {
		this.busiType = busiType;
	}
	public String getMessage() {
		return message;
	}
	public void setMessage(String message) {
		this.message = message;
	}
	public String getResult() {
		return result;
	}
	public void setResult(String result) {
		this.result = result;
	}
	public String getParentProid() {
		return parentProid;
	}
	public void setParentProid(String parentProid) {
		this.parentProid = parentProid;
	}
	public String getHideTopBar() {
		return hideTopBar;
	}
	public void setHideTopBar(String hideTopBar) {
		this.hideTopBar = hideTopBar;
	}
	public String getHideLeftPanel() {
		return hideLeftPanel;
	}
	public void setHideLeftPanel(String hideLeftPanel) {
		this.hideLeftPanel = hideLeftPanel;
	}
}
