package cn.gtmap.zhsw.web.action.map;

import java.math.BigDecimal;
import java.util.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.collections.MapUtils;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.record.PageBreakRecord.Break;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.interceptor.ServletRequestAware;
import org.apache.struts2.interceptor.ServletResponseAware;
import org.springframework.beans.factory.annotation.Autowired;

import com.gtis.common.util.UUIDGenerator;

import cn.gtmap.zhsw.dao.*;
import cn.gtmap.zhsw.entity.*;
import cn.gtmap.zhsw.service.*;
import cn.gtmap.zhsw.utils.*;

/**
 * 地图配置
* @文件名 MapConfigAction.java
 * @作者 卢向伟
 * @创建日期 2013-10-23
 * @创建时间 下午12:28:58 
 * @版本号 V 1.0
 */
public class MapAnalysisAction implements ServletRequestAware, ServletResponseAware{
/*	@Autowired
    BlSurveyBoundService blSurveyBoundService;*/
	
	private HttpServletResponse response;
	private HttpServletRequest request;
	
	private String xzqdm;//行政区代码
	private String proid;//地块id
	private String parentProid;//如果该proid为项目中子表id，则需要传递该参数获取该工作流对应的proid，用于获取busiType
	private String paramString;//
	private String busiType;//业务代码
	private String message;
	private String result;
	
	/**
	 * 叠加分析供地地块叠加的报批地块结果
	 * @return
	 * @throws Exception
	 */
	public String execute()throws  Exception{
		message = "操作失败！";
		result="false";
		try {
    		if (StringUtils.isNotBlank(proid)) {
    			if (StringUtils.isBlank(busiType)) {
    				busiType = "gddk";
				}
    			if (StringUtils.isNotBlank(busiType)) {
    				//查询源数据要素
    				String geoJson = GeometryOperationUtil.queryGeometry(proid, busiType,"SHAPE.AREA");
    				if (StringUtils.isNotBlank(geoJson)) {
    					//获取源数据地块面积
        				String[] propertys = {};
        				//获取源数据要素属性数据
        				List<HashMap<String,Object>> objList = GeometryOperationUtil.getGeometryProperty(geoJson, propertys,true);
        				if (objList != null && objList.size() > 0) {
    						//获取第一个要素即可
        					HashMap<String,Object> objMap = objList.get(0);
        					//获取该要素面积
        					Double objArea = objMap.get("AREA")!=null?CommonUtil.doubleToDouble((Double)objMap.get("AREA"),4,false):0.0;
        					if (objArea > 0.0) {
        						//开始进行分析
    							//分析批次地块
    							analyPcData(geoJson, "bpdk");
    							//收储宗地叠加分析
							}else {
								message = "当前项目查询图形面积为空！";
							}
    					}
					}else {
						message = "当前项目尚未创建图形！";
					}
				}else {
					message = "构建平台没有配置当前工作流对应的busiType！";
				}
    		}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return PublicUtil.returnAjaxResponse(ServletActionContext.getResponse(), message, result);
    }
	
	/**
	 * 处理业务图层的分析功能，也就是针对ANA_PROJ分析结果表的处理
	 * @param plotSchqb
	 * @param geoJson
	 * @param busiType
	 * @param anaType
	 * @throws Exception
	 */
	private void analyPcData(String geoJson,String busiType)throws Exception{
		HashMap<String, Double> plotMap = new HashMap<String, Double>();
		//开始进行分析数据
		String analyJson = GeometryOperationUtil.analysisGeometry(geoJson, busiType);
		if (StringUtils.isNotBlank(analyJson)) {
			String[] analyPros = {"XMMC","PZWH"};
			//获取目标数据属性数据集合
			List<HashMap<String,Object>> analyList = GeometryOperationUtil.getGeometryProperty(analyJson, analyPros,null);
			if (analyList != null && analyList.size() > 0) {
				for (int i = 0; i < analyList.size(); i++) {
					HashMap<String,Object> analyMap = analyList.get(i);
					Double SHAPE_AREA = analyMap.get("SHAPE_AREA")!=null?(Double)analyMap.get("SHAPE_AREA"):0.0;
					Double OG_SHAPE_AREA = analyMap.get("OG_SHAPE_AREA")!=null?(Double)analyMap.get("OG_SHAPE_AREA"):0.0;
					String OBJECTID = analyMap.get("OBJECTID")!=null?analyMap.get("OBJECTID").toString():"";
					if (SHAPE_AREA != null && SHAPE_AREA > 0.0) {
			            //获取批次地块id
			            String DKID = analyMap.get("DKID").toString();
			            //组织不重复的地块Hashmap，key为id，value为面积
			            if (SHAPE_AREA == null) {
			            	SHAPE_AREA = 0.0;
						}
			            if (plotMap.containsKey(DKID)) {
			            	SHAPE_AREA += plotMap.get(DKID);
						}
			            plotMap.put(DKID, SHAPE_AREA);
			            System.out.println("OBJECTID："+OBJECTID+"；DKID："+DKID+"；叠加面积："+SHAPE_AREA+"；目标数据总面积：" +OG_SHAPE_AREA);
					}
				}
			}else {
				message = "当前项目无叠加图形！";
			}
		}else {
			message = "当前项目无叠加图形！";
		}
		if (plotMap.keySet().size() > 0) {
        	//遍历地块Map，增加土地来源中关于批次地块的记录
	        Iterator it = plotMap.entrySet().iterator();
	        while (it.hasNext()) {
	        	Map.Entry entry = (Map.Entry) it.next();
	        	String key = entry.getKey().toString();
	        	Double value = (Double)entry.getValue();
	        }
	        message = "操作成功！";
	        result = "true";
		}else {
			message = "当前项目没有叠加报批项目地块！";
		}
		System.out.println(message);
	}
	
	/**
	 * 叠加分析基本农田核销表基本农田数据
	 * @return
	 * @throws Exception
	 */
	public String anaJbnthx()throws  Exception{
		message = "操作失败！";
		result="false";
		try {
    		if (StringUtils.isNotBlank(proid)) {
    			//message = blBackFarmLandCensorService.initJbnthx(proid, busiType, parentProid);
				if (StringUtils.isBlank(message)) {
					message = "操作成功！";
			        result = "true";
				}
    		}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return PublicUtil.returnAjaxResponse(ServletActionContext.getResponse(), message, result);
    }
	
	
	public String anaJsydgzq()throws  Exception{
		message = "操作失败！";
		result="false";
		try {
    		if (StringUtils.isNotBlank(proid)) {
    			String whereClause = "";
    			whereClause = "DKID = '"+proid+"'";
    			if (StringUtils.isBlank(busiType)) {
    				busiType = "bpdk";
				}
    			if (StringUtils.isNotBlank(busiType)) {
    				//查询源数据要素
    				String geoJson = GeometryOperationUtil.queryGeometry(proid, busiType,whereClause,"SHAPE.AREA");
    				if (StringUtils.isNotBlank(geoJson)) {
    					boolean isok = false;
    					//获取源数据地块面积
        				String[] propertys = {};
        				//获取源数据要素属性数据
        				List<HashMap<String,Object>> objList = GeometryOperationUtil.getGeometryProperty(geoJson, propertys,true);
        				if (objList != null && objList.size() > 0) {
        					BigDecimal objArea = new BigDecimal(0);
        					for (int i = 0; i < objList.size(); i++) {
        						//获取第一个要素即可
            					HashMap<String,Object> objMap = objList.get(i);
            					//获取该要素面积
            					Double tempArea = MapUtils.getDoubleValue(objMap, "AREA");
            					if (tempArea != null && tempArea > 0) {
									objArea = objArea.add(new BigDecimal(tempArea));
								}
							}
        					if (objArea.compareTo(new BigDecimal(0)) > 0) {
        						BigDecimal anaArea = analyJsydgzqData(geoJson, "ghjsydgzq");
        						if (anaArea != null) {
        							//如果叠加面积和原始面积相差小于1，认为是完全符合条件的
        							//否则则是不完全重叠
									if (Math.abs(objArea.subtract(anaArea).doubleValue())<1) {
										isok = true;
									}
								}
							}
    					}
        				if (isok) {
							message = "该报件符合规划!";
						}else {
							message = "该报批范围不完全在允许建设范围内，请人工核查。";
						}
					}else {
						message = "当前项目尚未创建图形！";
					}
				}else {
					message = "构建平台没有配置当前工作流对应的busiType！";
				}
    		}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return PublicUtil.returnAjaxResponse(ServletActionContext.getResponse(), message, result);
    }
	
	private BigDecimal analyJsydgzqData(String geoJson,String busiType)throws Exception{
		//开始进行分析数据
		String analyJson = GeometryOperationUtil.analysisGeometry(geoJson, busiType);
		if (StringUtils.isNotBlank(analyJson)) {
			String[] analyPros = {"BSM","YSDM","GZQLXDM","GZQMJ"};
			//获取目标数据属性数据集合
			List<HashMap<String,Object>> analyList = GeometryOperationUtil.getGeometryProperty(analyJson, analyPros,null);
			if (analyList != null && analyList.size() > 0) {
				BigDecimal anaArea = new BigDecimal(0);
				for (int i = 0; i < analyList.size(); i++) {
					HashMap<String,Object> analyMap = analyList.get(i);
					BigDecimal SHAPE_AREA = new BigDecimal(MapUtils.getDoubleValue(analyMap, "SHAPE_AREA"));
					String GZQLXDM = MapUtils.getString(analyMap, "GZQLXDM");
					if (SHAPE_AREA != null && StringUtils.isNotBlank(GZQLXDM) && StringUtils.equalsIgnoreCase(GZQLXDM, "010")) {
						anaArea = anaArea.add(SHAPE_AREA);
					}
				}
				return anaArea;
			}else {
				message = "当前项目无叠加图形！";
			}
		}else {
			message = "当前项目无叠加图形！";
		}
		System.out.println(message);
		return null;
	}
	
	public void setServletResponse(HttpServletResponse arg0) {
		this.response=arg0;		
	}

	public void setServletRequest(HttpServletRequest arg0) {
        this.request=arg0;		
	}
	public HttpServletResponse getResponse() {
		return response;
	}
	public void setResponse(HttpServletResponse response) {
		this.response = response;
	}
	public HttpServletRequest getRequest() {
		return request;
	}
	public void setRequest(HttpServletRequest request) {
		this.request = request;
	}
	public String getXzqdm() {
		return xzqdm;
	}
	public void setXzqdm(String xzqdm) {
		this.xzqdm = xzqdm;
	}
	public String getProid() {
		return proid;
	}
	public void setProid(String proid) {
		this.proid = proid;
	}
	public String getParamString() {
		return paramString;
	}
	public void setParamString(String paramString) {
		this.paramString = paramString;
	}
	public String getBusiType() {
		return busiType;
	}
	public void setBusiType(String busiType) {
		this.busiType = busiType;
	}
	public String getMessage() {
		return message;
	}
	public void setMessage(String message) {
		this.message = message;
	}
	public String getResult() {
		return result;
	}
	public void setResult(String result) {
		this.result = result;
	}

	public String getParentProid() {
		return parentProid;
	}

	public void setParentProid(String parentProid) {
		this.parentProid = parentProid;
	}
}
