package cn.gtmap.zhsw.web.action.manage;

import cn.gtmap.zhsw.entity.Hbxm;
import cn.gtmap.zhsw.entity.PublicVo;
import cn.gtmap.zhsw.service.HbglService;
import cn.gtmap.zhsw.utils.CommonUtil;
import cn.gtmap.zhsw.utils.FileUtil;
import cn.gtmap.zhsw.utils.GeometryOperationUtil;
import cn.gtmap.zhsw.utils.PublicUtil;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.generic.util.Struts2Utils;
import com.gtis.web.SessionUtil;
import com.gtis.web.SplitParam;
import com.gtis.web.SplitParamImpl;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.ServletRequestAware;
import org.apache.struts2.interceptor.ServletResponseAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

/**
 * Created by HT on 2015/10/9 10:59
 */
@Results({
        @Result(name = "success", location = "/WEB-INF/views/manage/hb-list.jsp"),
        @Result(name = "input", location = "/WEB-INF/views/manage/hb-input.jsp"),
        @Result(name = "dbList", location = "/WEB-INF/views/manage/hb-db-list.jsp"),
        @Result(name = "ybList", location = "/WEB-INF/views/manage/hb-yb-list.jsp"),
        @Result(name = "manage", location = "/WEB-INF/views/manage/hb-manage-list.jsp")
})
public class HbglAction implements ServletRequestAware, ServletResponseAware {
    private HttpServletRequest request;
    private HttpServletResponse response;

    @Autowired
    HbglService hbglService;

    @Resource
    @Qualifier("yearList")
    List<PublicVo> yearList;

    @Resource
    @Qualifier("xmlxList")
    List<PublicVo> xmlxList;

    private Hbxm hbxm;
    private SplitParam splitParam;
    private String type;//各台账的类型
    private String hbId;
    private String message;
    private String result;
    private String ids;
    private String hbStatus;
    private String proid;
    private String selectYear;
    private String year;
    private String xzqdm;
    private String busiType;//项目类型
    private String readOnly;//控制页面是否可以编辑权限，从构建平台配置的资源读取

    /**
     * 会办台账
     *
     * @throws Exception
     */
    public String execute() throws Exception {
        HashMap param = new HashMap();
        splitParam = new SplitParamImpl();
        splitParam.setQueryParam(param);
        if (type.equals("all")) {
            param.put("HB_STATUS_OTHER", "2");
        } else if (type.equals("task")) {
            param.put("HB_STATUS", "0");
        }
        splitParam.setQueryString("get_T_HBXM");
        String subYear = "";
        selectYear = "";
        for (int i = 0; i < yearList.size(); i++) {
            if (!yearList.get(i).getValue().equals("")) {
                selectYear += "{name:'" + yearList.get(i).getValue() + "',value:'" + yearList.get(i).getValue() + "'}" + ",";
            }
        }
        if (selectYear.endsWith(",")) {
            subYear = selectYear.substring(0, selectYear.length() - 1);
            selectYear = "[" + subYear + "]";
        }
        return "success";
    }

    /**
     * 新增
     *
     * @throws Exception
     */
    public String addRecord() throws Exception {
        if (StringUtils.isBlank(proid)) {
            proid = UUIDGenerator.generate();
        }
        Hbxm tempVo = hbglService.getHbglById(proid);
        if (tempVo == null) {
            hbxm = new Hbxm();
            hbxm.setHbId(proid);
            hbxm.setHbStatus(0);//会办状态（0-空值、1-待会办、2-已会办）
            hbxm.setIsHb(0);//是否会办（0-未会办，1-已会办）
            hbxm.setSqks(SessionUtil.getCurrentUser().getLstOragn().get(0).getOrganName());
        } else {
            hbxm = tempVo;
        }
        //检测流程进行到哪步
        readOnly = getStatusReadonly(proid);
        System.out.println(readOnly);
        return "input";
    }

    public String getStatusReadonly(String id) throws Exception {
        String readBuff = "true";
        Hbxm tempVo = hbglService.getHbglById(id);
        if (tempVo != null && tempVo.getHbStatus() == 0) {
            readBuff = "false";
        }
        return readBuff;
    }

    /**
     * 保存编辑方法
     *
     * @throws Exception
     */
    public String saveRecord() throws Exception {
        result = "false";
        message = "保存失败!";
        if (hbxm != null) {
            try {
                Hbxm tempVo = hbglService.getHbglById(hbxm.getHbId());
                if (tempVo != null) {
                    hbglService.updateHbgl(hbxm);
                } else {
                    Date date = new Date();
                    hbxm.setCreateDate(date);
                    hbglService.insertHbgl(hbxm);
                }
                result = "true";
                message = "保存成功！";
                Struts2Utils.renderJson(CommonUtil.generateJsonResult(true, result, message));
            } catch (Exception e) {
                e.printStackTrace();
                Struts2Utils.renderJson(CommonUtil.generateJsonResult(false, result, message));
            }
        }
        return "none";
    }

    /**
     * 删除方法
     *
     * @throws Exception
     */
    public String deleteRecord() throws Exception {
        message = "操作异常";
        result = "false";
        try {
            if (StringUtils.isNotBlank(ids)) {
                String idParam = java.net.URLDecoder.decode(ids, "utf-8");
                String[] idArr = idParam.split(",");
                hbglService.deleteHbgl(idArr);
                message = "操作成功";
                result = "true";
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return PublicUtil.returnAjaxResponse(response, message, result);
    }

    /**
     * 打开批次自定义manage页面
     *
     * @return
     * @throws Exception
     */
    public String openManage() throws Exception {
        readOnly = "true";
        return "manage";
    }

    /**
     * 是否会办(办理or退办)
     *
     * @throws Exception
     */
    public String isHb() throws Exception {
        result = "false";
        message = "保存失败!";
        if (StringUtils.isNotBlank(hbId)) {
            try {
                Hbxm tempVo = hbglService.getHbglById(hbId);
                if (tempVo != null && tempVo.getIsHb() == 0) {
                    tempVo.setIsHb(1);
                    tempVo.setHbStatus(1);
                } else if (tempVo != null && tempVo.getIsHb() == 1) {
                    if (StringUtils.isNotBlank(hbStatus) && hbStatus.equals("true")) {//会办
                        Date date = new Date();
                        //tempVo.setIsHb(1);
                        tempVo.setHbStatus(2);
                        tempVo.setHbDate(date);
                    } else {
                        tempVo.setIsHb(0);
                        tempVo.setHbStatus(0);
                    }
                }
                hbglService.updateHbgl(tempVo);
                result = "true";
                message = "保存成功！";
                Struts2Utils.renderJson(CommonUtil.generateJsonResult(true, result, message));
            } catch (Exception e) {
                e.printStackTrace();
                Struts2Utils.renderJson(CommonUtil.generateJsonResult(false, result, message));
            }
        }
        return "none";
    }

    /**
     * 会办待办列表
     *
     * @throws Exception
     */
    public String openWaitHandleList() throws Exception {
        HashMap param = new HashMap();
        splitParam = new SplitParamImpl();
        splitParam.setQueryParam(param);
        param.put("HB_STATUS", "1");
        splitParam.setQueryString("get_T_HBXM");
        return "dbList";
    }

    /**
     * 已办理列表
     *
     * @throws Exception
     */
    public String openHasBeenHandledList() throws Exception {
        HashMap param = new HashMap();
        splitParam = new SplitParamImpl();
        splitParam.setQueryParam(param);
        param.put("HB_STATUS", "2");
        splitParam.setQueryString("get_T_HBXM");
        return "ybList";
    }

    private String taskid;
    private String wdno;

    public String openReportWorkFlow() throws Exception {
        String url = "";
        if (StringUtils.isNotBlank(hbId)) {
            //根据受理id查询该报件项目id
            Hbxm tempVo = hbglService.getHbglById(hbId);
            if (tempVo != null) {
                String proid = tempVo.getHbId();
                try {
                    taskid = PublicUtil.getTaskIdByProid(proid);
                    if (taskid != null) {
                        url = "/platform/taskoverhandle.action?taskid=" + taskid;
                    } else {
                        taskid = PublicUtil.getAllTaskIdByProid(proid);
                        url = "/platform/taskhandle.action?taskid=" + taskid;
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (StringUtils.isBlank(taskid)) {
            url = "/platform/projecthandle.action?proid=" + proid + "&wdno=" + wdno;
        }
        response.sendRedirect(url);
        return "none";
    }

    //----------------------------------------------------------图形--------------------------------------------------------------

    /**
     * 导入图形
     *
     * @return response
     * @throws Exception
     */

    public String importGeometry() throws Exception {
        String xmmc = "";
        HashMap<String, String> zhsw = new HashMap<String, String>();
        String filePath = FileUtil.getUploadFilePath();
        if (!filePath.equals("0") && !filePath.equals("1") && !filePath.equals("2")) {
            String path = filePath.substring(0, filePath.indexOf(","));
            String zipName = filePath.substring(filePath.indexOf(",") + 2, filePath.length() - 1);//由于多了【】，格式JCTB_H_321284_2014.shp
            String fileType = zipName.substring(zipName.indexOf(".") + 1, zipName.length());
            zhsw.put("YEAR", year);
            try {
                if (fileType.equals("zip")) {
                    GeometryOperationUtil.parseShapeZipFile(path, "default", busiType, "true", zhsw);//zip的shap格式录入
                    xmmc = zipName.substring(0, zipName.indexOf(".zip"));
                } else {
                    GeometryOperationUtil.parseCadFile(path, "default", busiType, "true", zhsw);//dwg的cad格式录入
                    xmmc = zipName.substring(0, zipName.indexOf(".dwg"));
                }
                //图形入库的同时，要在数据库生成一条记录
                if (StringUtils.isBlank(proid)) {
                    proid = UUIDGenerator.generate();
                }
                Hbxm tempVo = hbglService.getHbglById(proid);
                if (tempVo == null) {
                    hbxm = new Hbxm();
                    hbxm.setHbId(proid);
                    hbxm.setHbStatus(0);//会办状态（0-空值、1-待会办、2-已会办）
                    hbxm.setIsHb(0);//是否会办（0-未会办，1-已会办）
                    hbxm.setSqks(SessionUtil.getCurrentUser().getLstOragn().get(0).getOrganName());
                    hbxm.setXmmc(xmmc);
                    hbglService.insertHbgl(hbxm);
                }
                result = "true";
                message = "上传成功！";
            } catch (IOException e) {
                e.printStackTrace();
                result = "false";
                message = "上传失败！";
            }
        } else {
            result = "false";
            message = "上传失败！";
        }
        return PublicUtil.returnAjaxResponse(ServletActionContext.getResponse(), message, result);
    }

    public void setServletRequest(HttpServletRequest arg0) {
        this.request = arg0;
    }

    public void setServletResponse(HttpServletResponse arg0) {
        this.response = arg0;
    }

    public Hbxm getHbxm() {
        return hbxm;
    }

    public void setHbxm(Hbxm hbxm) {
        this.hbxm = hbxm;
    }

    public SplitParam getSplitParam() {
        return splitParam;
    }

    public void setSplitParam(SplitParam splitParam) {
        this.splitParam = splitParam;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getHbId() {
        return hbId;
    }

    public void setHbId(String hbId) {
        this.hbId = hbId;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getResult() {
        return result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public String getIds() {
        return ids;
    }

    public void setIds(String ids) {
        this.ids = ids;
    }

    public String getHbStatus() {
        return hbStatus;
    }

    public void setHbStatus(String hbStatus) {
        this.hbStatus = hbStatus;
    }

    public String getProid() {
        return proid;
    }

    public void setProid(String proid) {
        this.proid = proid;
    }

    public String getSelectYear() {
        return selectYear;
    }

    public void setSelectYear(String selectYear) {
        this.selectYear = selectYear;
    }

    public List<PublicVo> getYearList() {
        return yearList;
    }

    public void setYearList(List<PublicVo> yearList) {
        this.yearList = yearList;
    }

    public String getBusiType() {
        return busiType;
    }

    public void setBusiType(String busiType) {
        this.busiType = busiType;
    }

    public String getXzqdm() {
        return xzqdm;
    }

    public void setXzqdm(String xzqdm) {
        this.xzqdm = xzqdm;
    }

    public String getYear() {
        return year;
    }

    public void setYear(String year) {
        this.year = year;
    }

    public String getReadOnly() {
        return readOnly;
    }

    public void setReadOnly(String readOnly) {
        this.readOnly = readOnly;
    }

    public List<PublicVo> getXmlxList() {
        return xmlxList;
    }

    public void setXmlxList(List<PublicVo> xmlxList) {
        this.xmlxList = xmlxList;
    }
}
