package cn.gtmap.zhsw.web.action;

import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Calendar;
import java.util.HashMap;

import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.struts2.interceptor.ServletRequestAware;
import org.apache.struts2.interceptor.ServletResponseAware;
import org.apache.struts2.json.JSONUtil;

import cn.gtmap.zhsw.utils.*;

import com.gtis.config.AppConfig;

/**
 * @文件名 PublicAction.java
 * @作者 卢向伟
 * @创建日期 2015年7月31日
 * @创建时间 上午11:32:50 
 * @版本号 V 1.0
 */
public class PublicAction implements ServletRequestAware, ServletResponseAware{
	private HttpServletRequest request;
	private HttpServletResponse response;
	
	private String paramString;
	private String result;
	private String message;
	
	
	public String execute(){
		return "success";
	}
	/**
	 * 获取打印模板，将打印模板拷贝至临时路径
	 * @return
	 * @throws Exception
	 */
	public String initPrintFr3File()throws Exception{
		message = "模板处理失败，请检查【"+AppConfig.getEgovHome()+"conf/buildland/print】下是否有该模板！";
		result = "false";
		try {
			if (StringUtils.isNotBlank(paramString)) {
				String jsonParam = java.net.URLDecoder.decode(paramString, "utf-8");
				HashMap<String, String> fileMap = (HashMap<String, String>) JSONUtil.deserialize(jsonParam);
				if (FileUtil.buildFr3File(fileMap.get("fr3Dir"),fileMap.get("fr3Name"),request)) {
					message = "操作成功！";
					result = "true";
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		return PublicUtil.returnAjaxResponse(response, message, result);
	}
	
	/**
	 * 输出签章图片
	 * @return
	 * @throws Exception
	 */
	public String printSealImg()throws Exception{
		if (StringUtils.isNotBlank(paramString)) {
			String jsonParam = java.net.URLDecoder.decode(paramString, "utf-8");
			HashMap<String, String> fileMap = (HashMap<String, String>) JSONUtil.deserialize(jsonParam);
			buildImgDataStream(fileMap.get("filename"),fileMap.get("filetype"));
		}
		return "none";
	}
	
	private void buildImgDataStream(String filename,String filetype) throws Exception {
		try {
			response.setContentType("image/"+filetype);
			response.setHeader("Content-Disposition","attachment; filename="+String.valueOf(Calendar.getInstance().getTimeInMillis()));
			String dirPath = FileUtil.getEgovHomePath("buildland/seal");
			if (StringUtils.isNotBlank(filename) && StringUtils.isNotBlank(filetype)) {
				File file = new File(dirPath+"/"+filename+"."+filetype);
				if (file.exists()) {
	                BufferedImage image=ImageIO.read(file);
	                ImageIO.write(image, filetype, response.getOutputStream());
				}else {
					System.out.println("文件名称和格式为空！");
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	public void setServletRequest(HttpServletRequest arg0) {
		this.request = arg0;
	}

	public void setServletResponse(HttpServletResponse arg0) {
		this.response = arg0;
	}
	public String getParamString() {
		return paramString;
	}
	public void setParamString(String paramString) {
		this.paramString = paramString;
	}
	public String getResult() {
		return result;
	}
	public void setResult(String result) {
		this.result = result;
	}
	public String getMessage() {
		return message;
	}
	public void setMessage(String message) {
		this.message = message;
	}

}
