package cn.gtmap.zhsw.web.action;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.ServletRequestAware;
import org.apache.struts2.interceptor.ServletResponseAware;
import org.apache.struts2.json.JSONUtil;
import org.springframework.beans.factory.annotation.Qualifier;

import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.model.Space;
import com.gtis.fileCenter.service.NodeService;

/**
 * @文件名 FcAction.java
 * @作者 卢向伟
 * @创建日期 2015年5月19日
 * @创建时间 下午2:10:17 
 * @版本号 V 1.0
 */
@Results({
	@Result(name="success",location="/common/jsp/fc.jsp")
   })
public class FcAction implements ServletRequestAware, ServletResponseAware {
	private HttpServletResponse response;
	private HttpServletRequest request;
	/** 项目Id */
    private String proid;
    /** 文件中心根节点Id */
    private Integer rootId;
    private boolean disable=false;
    /** 文件中心节点访问令牌 */
    private String token;
    /** 访问参数 */
    private String params;
    //readonly
    private String readOnly;
    /** 工作流附件在文件中心的表空间 */
    public String spaceCode;

    /** 文件中心节点服务 */
    @Resource
	@Qualifier("NodeService")
	private NodeService nodeService;
	/**
     * @return
     * @throws Exception
     */
    public String execute() throws Exception {
    	if (StringUtils.isBlank(spaceCode)) {
    		spaceCode = "WORK_FLOW_STUFF";
		}
    	//获得工作流附件工作流空间节点Id
		Space space = nodeService.getWorkSpace(spaceCode,true);
		Node prjNode = nodeService.getNode(space.getId(), proid,true);
		rootId = prjNode.getId();
        //获得工作流文件中心节点访问令牌
		token = nodeService.getToken(prjNode);
        //序列化访问中的参数
        params = JSONUtil.serialize(convertParameters(ServletActionContext.getRequest()));
        return "success";
    }
    
    /**
     * request 参数转换
     * @param request
     * @return
     */
    private Map<String, Object> convertParameters(HttpServletRequest request) {
        Map<String, Object> params = new HashMap<String, Object>();
        Enumeration names = request.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String) names.nextElement();
            String value = request.getParameter(name);
            Object v;
            try {
                v = Long.valueOf(value);
            } catch (NumberFormatException e) {
                if ("true".equalsIgnoreCase(value)) {
                    v = Boolean.TRUE;
                } else if ("false".equalsIgnoreCase(value)) {
                    v = Boolean.FALSE;
                } else {
                    v = value;
                }
            }
            params.put(name, v);
        }
        return params;
    }
    
    public void setServletResponse(HttpServletResponse arg0) {
		this.response=arg0;		
	}

	public void setServletRequest(HttpServletRequest arg0) {
        this.request=arg0;
	}

	public String getProid() {
		return proid;
	}

	public void setProid(String proid) {
		this.proid = proid;
	}

	public Integer getRootId() {
		return rootId;
	}

	public void setRootId(Integer rootId) {
		this.rootId = rootId;
	}

	public boolean isDisable() {
		return disable;
	}

	public void setDisable(boolean disable) {
		this.disable = disable;
	}

	public String getToken() {
		return token;
	}

	public void setToken(String token) {
		this.token = token;
	}

	public String getParams() {
		return params;
	}

	public void setParams(String params) {
		this.params = params;
	}

	public String getReadOnly() {
		return readOnly;
	}

	public void setReadOnly(String readOnly) {
		this.readOnly = readOnly;
	}

	public String getSpaceCode() {
		return spaceCode;
	}

	public void setSpaceCode(String spaceCode) {
		this.spaceCode = spaceCode;
	}
}
