/**
 * 
 */
package cn.gtmap.zhsw.web.action;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.ServletRequestAware;
import org.apache.struts2.interceptor.ServletResponseAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import cn.gtmap.zhsw.dao.BaseDao;
import cn.gtmap.zhsw.dao.ibatis.PublicDao;

import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import com.gtis.plat.service.SysDistrictService;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.service.WorkFlowCoreService;
import com.gtis.plat.vo.PfBusinessVo;
import com.gtis.plat.vo.PfDistrictVo;
import com.gtis.plat.vo.PfOrganVo;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.plat.vo.UserInfo;
import com.gtis.plat.wf.WorkFlowInfo;
import com.gtis.web.SessionUtil;

/**
 * @ClassName: CreateTaskAction.java
 * @Description: TODO(信访流程)
 * @author zlx
 * @version V1.0
 * @Date 2015-12-7 下午4:51:57
 */
@Results({
		@Result(name = "success", location = "/common/jsp/createtask.jsp"),
		@Result(name = "createWorkFlowDefault", location = "/common/jsp/createWorkFlowDefault.jsp") })
public class CreateTaskAction implements ServletRequestAware,
		ServletResponseAware {
	private HttpServletRequest request;
	private HttpServletResponse response;

 	@Resource
 	@Qualifier("SysUserServiceImpl")
 	private SysUserService userService;
 	@Resource
	@Qualifier("WorkFlowCoreService")
	private WorkFlowCoreService workFlowCoreService;
	@Resource
	@Qualifier("SysDistrictService")
	private SysDistrictService sysDistrictService;
	private String userName;
	private String organName;
	private String instanceName;
	private String workFlowName;
	private String proselect;
	private int timeLimit;
	private Date createTime;
	private String remark;
	private String district;
	private String wdid;
	private String sltzdId;
	private String xfsjjbdId;

	private LinkedHashMap<String, String> proMap;
	private String businessName;
	private String taskId;
	private String workFlowNameTemple;
	private List<PfDistrictVo> districtList;
	private String regionCode;
	private String xflx;//信访类型（1：来信信访，2：来访信访，3：来电信访）
	private String paramString;
	private String result;
	private String message;
	@Autowired
	private BaseDao baseDao;
	@Autowired
	private PublicDao publicDao;
    @Autowired
    SysWorkFlowDefineService workFlowDefineService;
	
	public CreateTaskAction() {
		this.proMap = new LinkedHashMap();
		this.proMap.put("1", "普通");
		this.proMap.put("2", "紧急");
		this.proMap.put("3", "特急");
	}

	public String execute() throws Exception {
		try {
			PfWorkFlowDefineVo workFlowDefineVo = workFlowDefineService.getWorkFlowDefine(this.wdid);
	     	PfBusinessVo businessVo = workFlowDefineService.getBusiness(workFlowDefineVo.getBusinessId());

		this.businessName = businessVo.getBusinessName();
		this.workFlowName = workFlowDefineVo.getWorkflowName();
		this.proselect = workFlowDefineVo.getPriority();
		this.remark = workFlowDefineVo.getRemark();
		this.timeLimit =workFlowDefineVo.getTimeLimit() ;
		this.createTime = Calendar.getInstance().getTime();

		UserInfo userInfo = SessionUtil.getUserInfo(ServletActionContext
				.getRequest());
		
		this.userName = userInfo.getUsername();
		if ((userInfo.getLstOragn() != null)
				&& (userInfo.getLstOragn().size() > 0)) {
			this.organName = ((PfOrganVo) userInfo.getLstOragn().get(0))
					.getOrganName();
			this.regionCode = ((PfOrganVo) userInfo.getLstOragn().get(0))
					.getRegionCode();
		}
		getWorkflowDistrict();
		}catch(Exception e)
		{
		  e.printStackTrace();
		}
		return "success";
	}

	private void getWorkflowDistrict() {
		String defaultDistrictCode = AppConfig.getProperty("district.code");
		if (StringUtils.isNotBlank(defaultDistrictCode))
			this.districtList = this.sysDistrictService
					.querySubDistrictByCode(AppConfig
							.getProperty("district.code").trim());
		else
			this.districtList = this.sysDistrictService.queryAllDistrict();
	}

	public String create() {
		PfWorkFlowInstanceVo intanceVo = new PfWorkFlowInstanceVo();
		try {
			getWorkflowDistrict();
			String userId = SessionUtil.getUserId(ServletActionContext
					.getRequest());
			String proId = UUIDGenerator.generate();
			intanceVo.setWorkflowDefinitionId(this.wdid);
			intanceVo.setWorkflowIntanceId(proId);
			intanceVo.setProId(proId);
			intanceVo.setRemark(this.remark);
			intanceVo.setTimeLimit(this.timeLimit);
			intanceVo.setPriority(this.proselect);
			intanceVo.setWorkflowIntanceName(this.instanceName);
			if (StringUtils.isBlank(this.district))
				this.district = this.userService.getUserRegionCode(SessionUtil
						.getCurrentUserId());
			intanceVo.setDistrict(this.district);
			WorkFlowInfo infoObj = this.workFlowCoreService
					.createWorkFlowInstance(intanceVo, userId);

			for (PfTaskVo taskVo : infoObj.getTargetTasks()) {
				if (taskVo.getUserVo().getUserId().equals(userId)) {
					this.taskId = taskVo.getTaskId();
					break;
				}
			}
			if ((this.taskId == null) || (this.taskId.equals(""))) {
				Iterator i$ = infoObj.getTargetTasks().iterator();
				if (i$.hasNext()) {
					PfTaskVo taskVo = (PfTaskVo) i$.next();
					this.taskId = taskVo.getTaskId();
				}
			}
			System.out.println(sltzdId);
			System.out.println(xflx);
			HashMap param = new HashMap();
			param.put("PROID", proId);
			//来信来访来电流程
			if(StringUtils.isNotBlank(xflx)&&("1".equals(xflx)||"2".equals(xflx)||"3".equals(xflx))){
				param.put("SLTZD_ID", sltzdId);
				publicDao.insertObjectByIbatisStr(param, "insertIntoJbdFromSltzd");
			//信访复查流程
			}else if(StringUtils.isNotBlank(xflx) && StringUtils.isNotBlank(xfsjjbdId) && "4".equals(xflx)){
				param.put("XFSJJBD_ID", xfsjjbdId);
				publicDao.insertObjectByIbatisStr(param, "insertIntoSqfcJbdFromJbd");
			}
			this.message = "ok";
		} catch (Exception e) {
			this.message = e.getMessage();
			e.printStackTrace();
		}
		return "success";
	}

	@Override
	public void setServletResponse(HttpServletResponse response) {
		this.response = response;
	}

	@Override
	public void setServletRequest(HttpServletRequest request) {
		this.request = request;
	}


	public HttpServletRequest getRequest() {
		return request;
	}

	public void setRequest(HttpServletRequest request) {
		this.request = request;
	}

	public HttpServletResponse getResponse() {
		return response;
	}

	public void setResponse(HttpServletResponse response) {
		this.response = response;
	}

	public String getUserName() {
		return userName;
	}

	public void setUserName(String userName) {
		this.userName = userName;
	}

	public String getOrganName() {
		return organName;
	}

	public void setOrganName(String organName) {
		this.organName = organName;
	}

	public String getInstanceName() {
		return instanceName;
	}

	public void setInstanceName(String instanceName) {
		this.instanceName = instanceName;
	}

	public String getProselect() {
		return proselect;
	}

	public void setProselect(String proselect) {
		this.proselect = proselect;
	}

	public int getTimeLimit() {
		return timeLimit;
	}

	public void setTimeLimit(int timeLimit) {
		this.timeLimit = timeLimit;
	}

	public Date getCreateTime() {
		return createTime;
	}

	public void setCreateTime(Date createTime) {
		this.createTime = createTime;
	}

	public String getRemark() {
		return remark;
	}

	public void setRemark(String remark) {
		this.remark = remark;
	}

	public String getDistrict() {
		return district;
	}

	public void setDistrict(String district) {
		this.district = district;
	}

	public LinkedHashMap<String, String> getProMap() {
		return proMap;
	}

	public void setProMap(LinkedHashMap<String, String> proMap) {
		this.proMap = proMap;
	}

	public String getBusinessName() {
		return businessName;
	}

	public void setBusinessName(String businessName) {
		this.businessName = businessName;
	}

	public String getTaskId() {
		return taskId;
	}

	public void setTaskId(String taskId) {
		this.taskId = taskId;
	}

	public List<PfDistrictVo> getDistrictList() {
		return districtList;
	}

	public void setDistrictList(List<PfDistrictVo> districtList) {
		this.districtList = districtList;
	}

	public String getRegionCode() {
		return regionCode;
	}

	public void setRegionCode(String regionCode) {
		this.regionCode = regionCode;
	}

	public String getWdid() {
		return wdid;
	}

	public void setWdid(String wdid) {
		this.wdid = wdid;
	}

	public String getWorkFlowName() {
		return workFlowName;
	}

	public void setWorkFlowName(String workFlowName) {
		this.workFlowName = workFlowName;
	}

	public String getParamString() {
		return paramString;
	}

	public void setParamString(String paramString) {
		this.paramString = paramString;
	}

	public String getResult() {
		return result;
	}

	public void setResult(String result) {
		this.result = result;
	}

	public String getMessage() {
		return message;
	}

	public void setMessage(String message) {
		this.message = message;
	}

	public String getXflx() {
		return xflx;
	}

	public void setXflx(String xflx) {
		this.xflx = xflx;
	}

	public String getSltzdId() {
		return sltzdId;
	}

	public void setSltzdId(String sltzdId) {
		this.sltzdId = sltzdId;
	}
	
	public String getXfsjjbdId() {
		return xfsjjbdId;
	}

	public void setXfsjjbdId(String xfsjjbdId) {
		this.xfsjjbdId = xfsjjbdId;
	}
}
