package cn.gtmap.zhsw.web.action;

import java.util.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.interceptor.ServletRequestAware;
import org.apache.struts2.interceptor.ServletResponseAware;
import org.springframework.beans.factory.annotation.Autowired;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.opensymphony.xwork2.Action;

import cn.gtmap.zhsw.dao.ibatis.PublicDao;
import cn.gtmap.zhsw.utils.*;
/**
 * 管理页面菜单配置
 * @文件名 BusiMenuAction.java
 * @作者 卢向伟
 * @创建日期 2013-2-21
 * @创建时间 下午2:28:10 
 * @版本号 V 1.0
 */
public class BusiMenuAction implements ServletRequestAware, ServletResponseAware{
	private Logger logger = Logger.getLogger(this.getClass().getName());
	private HttpServletRequest request;
	private HttpServletResponse response;
	private String paramString;
	private String proid;
	private String readOnly;//控制页面是否可以编辑权限，从构建平台配置的资源读取
	private String busiType;
	@Autowired
	private PublicDao publicDao;
	
	public String execute() {
		return Action.SUCCESS;
	}
	
	public String getBusiMenu()throws Exception{
		String jsonStr = "";
		if (StringUtils.isNotBlank(proid)) {
			if (StringUtils.isNotBlank(busiType)) {
				String filePath = FileUtil.getJsonFilePath("menu");
				if (StringUtils.isNotBlank(filePath)) {
					Map jsonMap = (Map)FileUtil.readJsonFile(filePath);
					if (jsonMap != null && jsonMap.get(busiType) != null) {
						JSONArray jsonArr = (JSONArray)jsonMap.get(busiType);
						doParentNode(jsonArr);
						jsonStr = JSON.toJSONString(jsonArr);
					}
				}
			}
		}
		System.out.println(jsonStr);
		ServletActionContext.getResponse().getWriter().println(jsonStr);
		return "none";
	}
	
	private void doChildNodeUrl(JSONObject jsonObj){
		if (jsonObj != null) {
			//如果该节点包含子节点，则继续针对子节点进行数据处理
			if (jsonObj.get("children") != null) {
				doParentNode((JSONArray)jsonObj.get("children"));
			}else if (jsonObj.get("link") != null) {
				String link = jsonObj.get("link").toString();
				if (!StringUtils.contains(link, "?")) {
					link += "?";
				}
				if (!StringUtils.contains(link, "proid=")) {
					link += "proid="+proid;
				}else {
					link += proid;
				}
				link += "&busiType="+busiType;
				jsonObj.put("link", link);
			}
		}
	}
	
	private void doParentNode(JSONArray jsonArr){
		if (jsonArr != null) {
			for (int i = 0; i < jsonArr.size(); i++) {
				JSONObject jsonObj = (JSONObject)jsonArr.get(i);
				if (jsonObj != null) {
					//如果该节点包含子节点，则继续针对子节点进行数据处理
					if (jsonObj.get("children") != null) {
						doParentNode((JSONArray)jsonObj.get("children"));
					}else {
						doChildNodeUrl(jsonObj);
					}
					
				}
			}
		}
	}
	
	public String getParamString() {
		return paramString;
	}

	public void setParamString(String paramString) {
		this.paramString = paramString;
	}

	public String getProid() {
		return proid;
	}

	public void setProid(String proid) {
		this.proid = proid;
	}

	public void setServletResponse(HttpServletResponse response) {
		this.response = response;
	}

	public void setServletRequest(HttpServletRequest request) {
		this.request = request;
	}

	public String getBusiType() {
		return busiType;
	}

	public void setBusiType(String busiType) {
		this.busiType = busiType;
	}

	public String getReadOnly() {
		return readOnly;
	}

	public void setReadOnly(String readOnly) {
		this.readOnly = readOnly;
	}
}
