package cn.gtmap.zhsw.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.gtis.plat.service.SysTaskService;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.plat.wf.model.ActivityModel;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.*;
import org.apache.struts2.json.JSONUtil;
import org.geotools.feature.*;
import org.geotools.geojson.feature.FeatureJSON;
import org.geotools.geojson.geom.GeometryJSON;
import org.opengis.feature.*;
import org.opengis.feature.simple.SimpleFeature;

import cn.gtmap.zhsw.entity.*;
import cn.gtmap.zhsw.service.*;

import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.model.Space;
import com.gtis.fileCenter.service.NodeService;
import com.gtis.spring.Container;

/**
 * @文件名 PublicUtil.java
 * @作者 卢向伟
 * @创建日期 Dec 21, 2011
 * @创建时间 2:57:55 PM 
 * @版本号 V 1.0
 */
public class PublicUtil {
	public static String msg;
	/**
	 * 获取文件中心下该主键所有nodeList
	 * @param id 主键id
	 * @param spacecode 文件中心空间
	 * @return
	 */
	public static List<Node> getFileNodeList(String id,String spacecode){
		try {
			NodeService nodeService = (NodeService)Container.getBean("NodeService");
			Space space = nodeService.getWorkSpace(spacecode, true);
			Node prjNode = nodeService.getNode(space.getId(), id, true);
			return nodeService.getAllChildNodes(prjNode.getId());
		} catch (Exception e) {
			System.out.println("获取文件中心List<Node>失败！"+e.getMessage());
		}
		return null;
	}
	/**
	 * 获取文件中心下该主键
	 * @param id 主键id
	 * @param spacecode 文件中心空间
	 * @return node
	 */
	public  static Node getNode(String id,String spacecode){
		Node prjNode = null;
		try {
			NodeService nodeService = (NodeService)Container.getBean("NodeService");
			Space space = nodeService.getWorkSpace(spacecode, true);
		    prjNode = nodeService.getNode(space.getId(), id, true);
		} catch (Exception e) {
			// TODO: handle exception
		}
		return prjNode;
	}
	/**
	 * 删除文件中心下该主键
	 * @param proid 主键id
	 * @param spacecode 文件中心空间
	 * @return node
	 */
	public static boolean delFileCenter(String proid,String spacecode){
		boolean isok = false;
		if(proid != null && !proid.equals("")){
			try {
				NodeService nodeService = (NodeService)Container.getBean("NodeService");
				Space space = nodeService.getWorkSpace(spacecode, true);
				Node prjNode = nodeService.getNode(space.getId(), proid, true);
			    nodeService.remove(prjNode.getId());
			    isok = true;
			} catch (Exception e) {
				isok = false;
			}
		}
		return isok;
	}

	/**
	 * Ajax返回操作
	 * @param response
	 * @param message
	 * @param result
	 * @return
	 * @throws Exception
	 */
	public static String returnAjaxResponse(HttpServletResponse response,String message,String result) throws Exception{
		try {
			HashMap<String, String> resultobj = new HashMap<String, String>();
			resultobj.put("success", result);
			resultobj.put("msg", message);
			resultobj.put("result", result);
			response.setContentType("text/html;charset=UTF-8");
			PrintWriter out = response.getWriter();
			out.println(JSONUtil.serialize(resultobj));
			out.flush();
			out.close();
		} catch (Exception e) {
		}
		return "none";
	}
	/**
	 * Ajax返回操作
	 * @param response
	 * @param success
	 * @param message
	 * @param result
	 * @return
	 * @throws Exception
	 */
	public static String returnAjaxResponse(HttpServletResponse response,String success,String message,String result) throws Exception{
		try {
			HashMap<String, String> resultobj = new HashMap<String, String>();
			resultobj.put("success", success);
			resultobj.put("msg", message);
			resultobj.put("result", result);
			response.setContentType("text/html;charset=UTF-8");
			PrintWriter out = response.getWriter();
			out.println(JSONUtil.serialize(resultobj));
			out.flush();
			out.close();
		} catch (Exception e) {
		}
		return "none";
	}
	
	/**
	 * 获取增量包临时文件夹路径
	 * @param request
	 * @param type
	 * @return
	 */
	public static String getTempPath(HttpServletRequest request,String type){
		String path = request.getSession().getServletContext().getRealPath("/");
		if (path == null || path.equals("")) {
			path = System.getProperty("user.dir").replace("bin", "webapps") + "\\zhsw\\";
		}
		path = path.replace("\\webapps\\zhsw\\", "\\temp\\");
		//系统临时路径
		path = path + type + "\\";
		GregorianCalendar today = new GregorianCalendar();
		path = path + CalendarUtil.sdf_time.format(today.getTime()) +"\\";
		return path;
	}
	/**
	 * 获取增量包临时文件夹路径
	 * @param request
	 * @param type
	 * @return
	 */
	public static String getProjectPath(HttpServletRequest request){
		String path = null;
		if (request == null) {
			path = System.getProperty("user.dir").replace("bin", "webapps") + "\\zhsw\\";
		}else {
			path = request.getSession().getServletContext().getRealPath("/");
		}
		return path;
	}
	public static String getTempPath(String type){
		String path =  System.getProperty("user.dir").replace("bin", "webapps") + "\\zhsw\\";
		path = path.replace("\\webapps\\zhsw\\", "\\temp\\");
		//系统临时路径
		path = path + type + "\\";
		GregorianCalendar today = new GregorianCalendar();
		path = path + CalendarUtil.sdf_time.format(today.getTime()) +"\\";
		return path;
	}
	/**
	 * 调用cs空间分析工具的socket连接
	 * @param ip
	 * @param port
	 * @param param
	 * @return
	 */
	public static boolean doSocketRequest(String ip,Integer port,String param){
		boolean isok =false;
		try {
			SocketAddress address = new InetSocketAddress(ip,port);
			SocketChannel client = SocketChannel.open(address);
			System.out.println("打开连接，IP地址：" + ip + "，端口号：" + port);
			client.configureBlocking(false);
			ByteBuffer buffer = ByteBuffer.allocate(20);
			buffer.put(param.getBytes());
			buffer.clear();
			int d = client.write(buffer);
			if (d > -1) {
				isok =true;
			}
			System.out.println("发送数据,参数："+param);
			client.close();
		} catch (Exception e) {
		}
		return isok;
	}
	public static HashMap initParamString(String paramString)throws Exception{
		HashMap param = new HashMap();
		if (paramString != null && !paramString.equals("")) {
			String jsonParam = java.net.URLDecoder.decode(paramString, "utf-8");
			param = (HashMap<String, String>) JSONUtil.deserialize(jsonParam);
		}
		return param;
	}
	public static Double getRowCellDoubleValue(HSSFCell cell,Integer point)throws Exception{
		Double value = null;
		try {
			if (cell != null) {
				switch (cell.getCellType()) {  
	                case HSSFCell.CELL_TYPE_NUMERIC: // 数字  
	                	value =CommonUtil.doubleToDouble(cell.getNumericCellValue(),point);
	                    break;  
	                case HSSFCell.CELL_TYPE_STRING: // 字符串  
	                	value = CommonUtil.StringToDouble(cell.getStringCellValue(), point);
	                    break;  
	                case HSSFCell.CELL_TYPE_BOOLEAN: // Boolean  
	                    break;  
	                case HSSFCell.CELL_TYPE_FORMULA: // 公式  
	                	System.out.println(cell.getCellFormula()+"----********************************");
	                    try {
	                    	value = CommonUtil.doubleToDouble(cell.getNumericCellValue(),point);
						} catch (Exception e) {
							value = CommonUtil.StringToDouble(String.valueOf(cell.getRichStringCellValue()),point);
						}
	                    break;  
	                case HSSFCell.CELL_TYPE_BLANK: // 空值  
	                    break;  
	                case HSSFCell.CELL_TYPE_ERROR: // 故障  
	                    break;  
	                default:  
	                    System.out.print("未知类型   ");  
	                    break;  
	            }
			}
			
		} catch (Exception e) {
			msg += "行："+(cell.getRowIndex()+1)+" 列："+(cell.getCellNum()+1)+" 数据格式有误！<br>";
			System.out.println("行："+(cell.getRowIndex()+1)+" 列："+(cell.getCellNum()+1)+" 数据格式有误！");
			System.out.println(e.getMessage());
		}
		return value;
	}
	/**
	 * 获取该列的数值型数据
	 * @param cell
	 * @return
	 * @throws Exception
	 */
	public static Double getRowCellDoubleValue(HSSFCell cell)throws Exception{
		return getRowCellDoubleValue(cell,8);
	}
	public static String getRowCellStringValue(HSSFCell cell,Integer point)throws Exception{
		String nextText = null;
		try {
			if (cell != null) {
				switch (cell.getCellType()) {  
					case HSSFCell.CELL_TYPE_NUMERIC: // 数字  
						nextText = String.valueOf(CommonUtil.DoubleToString(cell.getNumericCellValue(), point));
	                    break;  
	                case HSSFCell.CELL_TYPE_STRING: // 字符串  
	                	nextText = cell.getStringCellValue();
	                    break;  
	                case HSSFCell.CELL_TYPE_BOOLEAN: // Boolean  
	                    break;  
	                case HSSFCell.CELL_TYPE_FORMULA: // 公式  
	                	Double value = null;
	                    try {
	                    	value = CommonUtil.doubleToDouble(cell.getNumericCellValue(),point);
						} catch (Exception e) {
							value = CommonUtil.StringToDouble(String.valueOf(cell.getRichStringCellValue()),point);
						}
	                    if (value != null && value > 0) {
	                    	nextText = CommonUtil.DoubleToString(value, point);
						}
	                    break;  
	                case HSSFCell.CELL_TYPE_BLANK: // 空值  
	                    break;  
	                case HSSFCell.CELL_TYPE_ERROR: // 故障  
	                    break;  
	                default:  
	                    System.out.print("未知类型   ");  
	                    break;  
				}
			}
		} catch (Exception e) {
			msg += "行："+(cell.getRowIndex()+1)+" 列："+(cell.getCellNum()+1)+" 数据格式有误！<br>";
			System.out.println("行："+(cell.getRowIndex()+1)+" 列："+(cell.getCellNum()+1)+" 数据格式有误！");
			System.out.println(e.getMessage());
		}
		if (StringUtils.isNotBlank(nextText)) {
			nextText = nextText.replace(" ", "");
			nextText = nextText.replace("　 ", "");
		}
		return nextText;
	}
	/**
	 * 获取该列的字符型数据
	 * @param cell
	 * @return
	 * @throws Exception
	 */
	public static String getRowCellStringValue(HSSFCell cell)throws Exception{
		return getRowCellStringValue(cell,8);
	}
	/**
	 * 获取该列的字符型数据
	 * @param cell
	 * @return
	 * @throws Exception
	 */
	public static Integer getRowCellIntegerValue(HSSFCell cell)throws Exception{
		Integer value = null;
		try {
			if (cell != null) {
				switch (cell.getCellType()) {  
					case HSSFCell.CELL_TYPE_NUMERIC: // 数字  
						value = CommonUtil.DoubleToInteger(cell.getNumericCellValue());
	                    break;  
	                case HSSFCell.CELL_TYPE_STRING: // 字符串  
	                	value = CommonUtil.StringToInteger(cell.getStringCellValue());
	                    break;  
	                case HSSFCell.CELL_TYPE_BOOLEAN: // Boolean  
	                    break;  
	                case HSSFCell.CELL_TYPE_FORMULA: // 公式  
	                	Double db = null;
	                    try {
	                    	db = CommonUtil.doubleToDouble(cell.getNumericCellValue(),1);
						} catch (Exception e) {
							db = CommonUtil.StringToDouble(String.valueOf(cell.getRichStringCellValue()),1);
						}
	                    if (db != null && db > 0) {
	                    	value = CommonUtil.DoubleToInteger(db);
						}
	                    break;  
	                case HSSFCell.CELL_TYPE_BLANK: // 空值  
	                    break;  
	                case HSSFCell.CELL_TYPE_ERROR: // 故障  
	                    break;  
	                default:  
	                    System.out.print("未知类型   ");  
	                    break;  
				}
			}
		} catch (Exception e) {
			msg += "行："+(cell.getRowIndex()+1)+" 列："+(cell.getCellNum()+1)+" 数据格式有误！<br>";
			System.out.println("行："+(cell.getRowIndex()+1)+" 列："+(cell.getCellNum()+1)+" 数据格式有误！");
			System.out.println(e.getMessage());
		}
		return value;
	}
	/**
	 * 初始化对象，并针对null的String、Integer、Double类型赋值0
	 * @param obj
	 * @param initString 是否初始化字符串为""
	 * @param initInteger 是否初始化整形为0
	 * @param initDouble 是否初始化Double为0
	 * @return
	 * @throws Exception
	 */
	public static Object initObj(Object obj,boolean initString,boolean initInteger,boolean initDouble)throws Exception{
		try {
			if (obj == null) {
				obj = new Object();
			}
			Method[] methods = obj.getClass().getMethods();
			for (int i = 0; i < methods.length; i++) {
				Method method = methods[i];
				String methodName = method.getName();
				if(methodName.startsWith("set")){
					Object[] typeArray = method.getParameterTypes();
					if (typeArray != null && typeArray.length > 0) {
						String type = typeArray[0].toString();
						if (initString) {
							if(type.equals("class java.lang.String")){
								methodName.replaceFirst("set", "get");
								Method getMethod = obj.getClass().getMethod(methodName.replaceFirst("set", "get"));
			                    if (getMethod.invoke(obj) == null) {
			                    	method.invoke(obj,"");
								}
							}
						}
						if (initInteger) {
							if(type.equals("class java.lang.Integer")){
								methodName.replaceFirst("set", "get");
								Method getMethod = obj.getClass().getMethod(methodName.replaceFirst("set", "get"));
			                    if (getMethod.invoke(obj) == null) {
			                    	method.invoke(obj,0);
								}
							}
						}
						if (initDouble) {
							if(type.equals("class java.lang.Double")){
								methodName.replaceFirst("set", "get");
								Method getMethod = obj.getClass().getMethod(methodName.replaceFirst("set", "get"));
			                    if (getMethod.invoke(obj) == null) {
			                    	method.invoke(obj,0.0);
								}
							}
						}
					}
				}
			}
		} catch (Exception e) {
			System.out.println(e.getMessage());
		}
		return obj;
	}
	
	/**
	 * 初始化对象，并针对null的String、Integer、Double类型赋值0
	 * @param obj
	 * @param initString 是否初始化字符串为""
	 * @param initInteger 是否初始化整形为0
	 * @param initDouble 是否初始化Double为0
	 * @return
	 * @throws Exception
	 */
	public static Object initHashMap(HashMap param)throws Exception{
		try {
			if (param == null) {
				param = new HashMap();
			}
			Iterator it = param.entrySet().iterator();
			while (it.hasNext()) {
				Map.Entry entry = (Map.Entry) it.next();
				Object key = entry.getKey();
				Object value = entry.getValue();
				if (value == null || StringUtils.isBlank(value.toString())) {
					value = "";
				}
				entry.setValue(value);
			}
		} catch (Exception e) {
			System.out.println(e.getMessage());
		}
		return param;
	}

	/**
	 * 转换坐标串为新接口所用格式
	 * @param pntList 界址点数据
	 * @param param 属性数据
	 * @param noEndPoint 界址点数据是否包含尾节点
	 * @return
	 * @throws Exception
	 */
//	public static String getPolygonGeometry(List<BlPntCoord> pntList,HashMap param)throws Exception{
//		boolean hasEndPoint = false;
//		HashMap featureMap = new HashMap();
//		if (pntList != null && pntList.size() > 0) {
//			List<List<List<BigDecimal[]>>> coords = new ArrayList<List<List<BigDecimal[]>>>();
//			List<List<BigDecimal[]>> coordList = new ArrayList<List<BigDecimal[]>>();
//			List<BigDecimal[]> coordinateList = new ArrayList<BigDecimal[]>();
//			Integer polygonNO = 0;
//			Integer ringNO = 0;
//			BigDecimal[] firstCoord = null;
//			String xyCoord = "";
//			for (int i = 0; i < pntList.size(); i++) {
//				BlPntCoord pntCoord = pntList.get(i);
//				BigDecimal[] coord = new BigDecimal[]{pntCoord.getyCoord(),pntCoord.getxCoord()};
//				Integer curPolygonNO = pntCoord.getPolygonNo();
//				Integer curRingNO = pntCoord.getRoundNo();
//				if (polygonNO == 0) {
//					polygonNO = curPolygonNO;
//					ringNO = curRingNO;
//					firstCoord = coord;
//					xyCoord = coord[0]+","+coord[1];
//				}
//				if (polygonNO == curPolygonNO) {//同一个多边形
//					if (ringNO != curRingNO) {//同一个环
//						ringNO = curRingNO;
//						if (!hasEndPoint) {
//							coordinateList.add(firstCoord);
//							firstCoord = coord;
//							xyCoord = coord[0]+","+coord[1];
//						}
//						coordList.add(coordinateList);
//						coordinateList = new ArrayList<BigDecimal[]>();
//					}
//				}else {
//					polygonNO = curPolygonNO;
//					ringNO = curRingNO;
//					if (!hasEndPoint) {
//						coordinateList.add(firstCoord);
//						firstCoord = coord;
//						xyCoord = coord[0]+","+coord[1];
//					}
//					coordList.add(coordinateList);
//					coords.add(coordList);
//					coordList = new ArrayList<List<BigDecimal[]>>();
//					coordinateList = new ArrayList<BigDecimal[]>();
//				}
//				if (i > 0) {
//					if (ringNO.equals(curRingNO) && xyCoord.equals(coord[0]+","+coord[1])) {
//						hasEndPoint = true;
//					}
//				}
//				coordinateList.add(coord);
//			}
//			if (!hasEndPoint) {
//				coordinateList.add(firstCoord);
//			}
//			coordList.add(coordinateList);
//			coords.add(coordList);
//			HashMap geoMap = new HashMap();
//			if (polygonNO <= 1) {
//				geoMap.put("type", "Polygon");
//				geoMap.put("coordinates", coordList);
//			}else {
//				geoMap.put("type", "MultiPolygon");
//				geoMap.put("coordinates", coords);
//			}
//			featureMap.put("type","Feature");
//			featureMap.put("properties", param);
//			featureMap.put("geometry", geoMap);
//		}
//		System.out.println(JSONUtil.serialize(featureMap));
//		return JSONUtil.serialize(featureMap);
//	}
	public static String ListToString(List<String> valueList,int MaxLen,String otherStr){
        StringBuffer sb=new StringBuffer();
        int len=1;
        for(String value :valueList){
            if (len==1)
                sb.append(value);
            else
                sb.append("," + value);
            if (len==MaxLen){
            	sb.append(otherStr);
            	break;
            }
            len++;
        }
        return sb.toString();
    }
	/**
	 * 获取流水号
	 * @param code
	 * @return
	 */
	public static String getTxm(String code){
		String txm = "";
		if (StringUtils.isNotBlank(code)) {
			if (code.length() == 12) {
				txm += code.substring(0,6);
				txm += code.substring(8,12);
				Integer lxh = (int)(Math.random()*900)+100;
				txm += lxh;
			}else if (code.length() == 13) {
				txm += code.substring(0,6);
				txm += code.substring(8,13);
				Integer lxh = (int)(Math.random()*90)+10;
				txm += lxh;
			}else {
				txm = code;
			}
		}
		if (code.length() == 10) {
			Integer lxh = (int)(Math.random()*900)+100;
			txm += lxh;
		}
		if (StringUtils.isBlank(txm)) {
			txm = "0000000000000";
		}
		if (StringUtils.isNotBlank(txm) && txm.length() >= 13) {
			txm = txm.substring(0,13);
		}
		return txm;
	}
	/**
	 * 获取流水号
	 * @param code
	 * @return
	 */
	public static String getPlotTxm(String code){
		String txm = "";
//		if (StringUtils.isNotBlank(code)) {
//			if (code.length() > 6) {
//				txm += code.substring(0,6);
//				txm += (CalendarUtil.getYear()-2000)+""+CalendarUtil.getMonth();
//				Integer lxh = (int)(Math.random()*900)+100;
//				txm += lxh;
//			}else {
//				txm = code;
//			}
//		}
		txm += (CalendarUtil.getYear()-2000)+""+CalendarUtil.getMonth();
		Integer lxh = (int)(Math.random()*900)+100;
		txm += lxh;
		if (StringUtils.isBlank(txm)) {
			txm = "0000000000000";
		}
		txm = PlatformHelper.getConfigXzqdm()+txm;
		if (StringUtils.isNotBlank(txm) && txm.length() >= 13) {
			txm = txm.substring(0,13);
		}
		return txm;
	}
	
//	public static String checkHasOverlayMap(BlSurveyBoundService blSurveyBoundService,String proid, String busiType) throws Exception{
//		if (StringUtils.isNotBlank(busiType)) {
//			List<BlPntCoord> pntList = blSurveyBoundService.getPntCoordListByProId(proid, busiType);
//			HashMap<String, String> zhsw = GeometryOperationUtil.getzhsw(busiType, proid);
//			String geometry = PublicUtil.getPolygonGeometry(pntList, zhsw);
//			if (StringUtils.isNotBlank(geometry)) {
//				//获取目标数据属性数据集合
//				String analyJson = GeometryOperationUtil.analysisGeometry(geometry, busiType);
//				return analyJson;
//			}
//		}
//		return null;
//	}
//
	public static Object copy(Object object) throws Exception {
		Class<?> classType = object.getClass();
		Object objectCopy = classType.getConstructor(new Class[]{}).newInstance(new Object[]{});
		Field fields[] = classType.getDeclaredFields();
		for (int i = 0; i < fields.length; i++) {
			Field field = fields[i];
			String fieldName = field.getName();
			String firstLetter = fieldName.substring(0, 1).toUpperCase();
			String getMethodName = "get" + firstLetter + fieldName.substring(1);
			String setMethodName = "set" + firstLetter + fieldName.substring(1);
			Method getMethod = classType.getMethod(getMethodName, new Class[]{});
			Method setMethod = classType.getMethod(setMethodName, new Class[]{field.getType()});
			Object value = getMethod.invoke(object, new Object[]{});
			setMethod.invoke(objectCopy, new Object[]{value});
		}
		return objectCopy;
	}
	/**
	 * 获取字符串中的整数部分
	 * @param str
	 * @return
	 */
	public static String getIntegerStr(String str){
		String numberRegEx = "[^0-9]";
        Pattern pattern = Pattern.compile(numberRegEx);
        Matcher matcher = pattern.matcher(str);
        String result = matcher.replaceAll("");
        return result;
	}
	/**
	 * 获取字符串中的数字部分
	 * @param str
	 * @return
	 */
	public static String getNumberStr(String str){
		String numberRegEx = "([^(\\d|\\.)])";
        Pattern pattern = Pattern.compile(numberRegEx);
        Matcher matcher = pattern.matcher(str);
        String result = matcher.replaceAll("");
        return result;
	}

	/**
	 * 获取构建平台针对工作流配置的拓展属性“busiType”
	 * @param proid
	 * @return
	 * @throws Exception
	 */
	public static String getBusiTypeByConfig(String proid)throws Exception{
		String busiType = "";
		if (StringUtils.isNotBlank(proid)) {
			try {
				SysWorkFlowInstanceService sysWorkFlowInstanceService = PlatformHelper.getSysWorkFlowInstanceService();
				PfWorkFlowInstanceVo workFlowInstanceVo = sysWorkFlowInstanceService.getWorkflowInstance(proid);
				WorkFlowXml xmlModel = WorkFlowXmlUtil.getInstanceModel(workFlowInstanceVo);
				String taskid = getAllTaskIdByProid(proid);
				if (StringUtils.isNotBlank(taskid)) {
					SysTaskService sysTaskService = PlatformHelper.getTaskService();
					PfTaskVo pfTaskVo = sysTaskService.getTask(taskid);
					if (pfTaskVo != null && StringUtils.isNotBlank(pfTaskVo.getActivityId())) {
						PfActivityVo pfActivityVo = sysTaskService.getActivity(pfTaskVo.getActivityId());
						ActivityModel aModel = xmlModel.getActivity(pfActivityVo.getActivityDefinitionId());
						busiType = aModel.getExtendedAttribute("BusiType");
					}
				}
				if (StringUtils.isBlank(busiType)) {
					busiType = xmlModel.getExtendedAttribute("BusiType");
				}
				if (StringUtils.isBlank(busiType)) {
					busiType = xmlModel.getExtendedAttribute("busiType");
				}
				if (StringUtils.isBlank(busiType)) {
					busiType = xmlModel.getExtendedAttribute("busitype");
				}
				if (StringUtils.isBlank(busiType)) {
					busiType = xmlModel.getExtendedAttribute("BUSITYPE");
				}

				//如果当前工作流节点中没有找到该属性，则直接获取工作流定义下的属性值
				SysWorkFlowDefineService sysWorkFlowDefineService = (SysWorkFlowDefineService) Container .getBean("SysWorkFlowDefineService");
				PfWorkFlowDefineVo workFlowDefineVo = sysWorkFlowDefineService.getWorkFlowDefine(workFlowInstanceVo.getWorkflowDefinitionId());
				xmlModel = WorkFlowXmlUtil.getDefineModel(workFlowDefineVo);
				if (StringUtils.isBlank(busiType)) {
					busiType = xmlModel.getExtendedAttribute("BUSITYPE");
				}
				if (StringUtils.isBlank(busiType)) {
					busiType = xmlModel.getExtendedAttribute("BusiType");
				}
				if (StringUtils.isBlank(busiType)) {
					busiType = xmlModel.getExtendedAttribute("busiType");
				}
				if (StringUtils.isBlank(busiType)) {
					busiType = xmlModel.getExtendedAttribute("busitype");
				}
				if (StringUtils.isBlank(busiType)) {
					busiType = xmlModel.getExtendedAttribute("BUSITYPE");
				}
			} catch (Exception e) {
				System.out.println("当前工作流没有配置busiType扩展属性！");
			}
		}
		return busiType;
	}

	/**
	 * 根据proid获取待办结项目的taskId
	 * @param proid
	 * @return
	 */
	public static String getAllTaskIdByProid(String proid){
		String taskid=null;
		List<PfTaskVo> list;
		try {
			SysTaskService sysTaskService = (SysTaskService)Container.getBean("TaskService");
			list=sysTaskService.getTaskListByInstance(proid);
			if(list!=null && list.size()>0){
				taskid = list.get(list.size()-1).getTaskId();
			}

		} catch (Exception e) {
		}
		return taskid;
	}

	/**
	 * 根据proid获取taskId
	 * @param proid
	 * @return
	 */
	public static String getTaskIdByProid(String proid){
		String taskid=null;
		try {
			SysTaskService sysTaskService = (SysTaskService)Container.getBean("TaskService");
			List<PfTaskVo> list=sysTaskService.getHistoryTaskListByInstance(proid);
			if(list!=null && list.size()>0)
				taskid = list.get(0).getTaskId();
		} catch (Exception e) {
		}
		return taskid;
	}
}
