package cn.gtmap.zhsw.utils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/**
 * 
 * @ClassName: PublicSortForObjectList
 * @Description:给list<object> 按一个字段排序
 * @author chaowei
 * @date 2014年5月14日 上午10:41:21
 * 
 * @param <E>
 */
public class PublicSortForObjectList<E> {

	/**
	 * 
	 * @Title: sort
	 * @Description: 给list<object> 按一个字段排序
	 * @author chaowei
	 * @param list
	 *            要排序的List
	 * @param method
	 *            排序字段的get方法。例如：getUserId
	 * @param sort
	 *            排序的种类 desc 降序 或者 null 升序
	 */
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public void sort(List<E> list, final String method, final String sort) {
		Collections.sort(list, new Comparator() {
			public int compare(Object a, Object b) {
				int ret = 0;
				try {
					Method m1 = ((E) a).getClass().getMethod(method, null);
					Method m2 = ((E) b).getClass().getMethod(method, null);
					if (null != m1 && null != m2) {
						if (null != m2.invoke(((E) b), null)
								&& null != m1.invoke(((E) a), null)) {

							if (sort != null && "desc".equals(sort))// 倒序
								ret = m2.invoke(((E) b), null)
										.toString()
										.compareTo(
												m1.invoke(((E) a), null)
														.toString());
							else
								// 正序
								ret = m1.invoke(((E) a), null)
										.toString()
										.compareTo(
												m2.invoke(((E) b), null)
														.toString());
						} else {
							if (sort != null && "desc".equals(sort))// 倒序
								if (null != m2.invoke(((E) b), null)
										&& null == m1.invoke(((E) a), null))
									ret = 1;
								else {
									ret = -1;
								}
							else {
								if (null != m1.invoke(((E) a), null)
										&& null == m2.invoke(((E) a), null)) {
									// 正序
									ret = 1;
								} else {
									ret = -1;
								}

							}

						}
					}
				} catch (NoSuchMethodException ne) {
					System.out.println(ne);
				} catch (IllegalAccessException ie) {
					System.out.println(ie);
				} catch (InvocationTargetException it) {
					System.out.println(it);
				}
				return ret;
			}
		});
	}
}
