package cn.gtmap.zhsw.utils;

import javax.servlet.http.HttpServletRequest;

import com.gtis.plat.vo.*;

import org.apache.commons.lang.StringUtils;

import com.gtis.config.AppConfig;
import com.gtis.fileCenter.service.*;
import com.gtis.plat.service.*;
import com.gtis.spring.Container;
import com.gtis.web.SessionUtil;

/**
 * @文件名 PlatformHelper.java
 * @作者 卢向伟
 * @创建日期 2013-10-22
 * @创建时间 下午7:39:56 
 * @版本号 V 1.0
 */
public class PlatformHelper {
	public final static String PAGE_ENTER_FROM_TASKLIST = "task";
	public final static String PAGE_ENTER_FROM_PROJECTLIST = "project";
	/** 全局文件中心的表空间 */
    public static final String GLOBLE_STUFF = "GLOBLE_STUFF";
    /** 工作流附件在文件中心的表空间 */
    public static final String WORK_FLOW_STUFF = "WORK_FLOW_STUFF";
    /** 部门网盘在文件中心中的表空间 */
    public static final String ORGAN_STUFF =  "ORGAN_STUFF";
	/** 文件中心 */
	private static final String GLOBLE_FCVIEW = "GLOBLE_FCVIEW";
	/** 文件中心 */
	private static final String PW_SPACE = "PW_SPACE";
	
	public static String getConfigXzqdm(){
		return AppConfig.getProperty("zhsw.xzqdm");
	}
	public static String getConfigXzqname(){
		return AppConfig.getProperty("zhsw.xzqname");
	}
	public static String getConfigSubcode(){
		return AppConfig.getProperty("zhsw.subcode");
	}
	public static String getGTZYJ(){
		return getConfigXzqname()+"国土资源局";
	}
	
	public static String getRMZF(){
		return getConfigXzqname()+"人民政府";
	}
	/**
	 * 获取配置文件中的图层名称
	 * ysdk.layer.name=SDE.YSDK
	 * @param busiType
	 * @return
	 */
	public static String getLayerName(String busiType){
		String config = AppConfig.getProperty(busiType+".layer.name");
		if (StringUtils.isNotBlank(config)) {
			config = StringUtils.trimToEmpty(config);
		}else {
			config = "";
		}
		return config;
	}
	/**
	 * 获取配置文件中图形数据源配置
	 * bpdk.layer.datasource=
	 * @param busiType
	 * @return
	 */
	public static String getLayerDatasource(String busiType){
		String config = AppConfig.getProperty(busiType+".layer.datasource");
		if (StringUtils.isNotBlank(config)) {
			config = StringUtils.trimToEmpty(config);
		}else {
			config = "";
		}
		return config;
	}
	/**
	 * 获取配置文件中的服务别名
	 * ysdk.layer.alias=预审地块
	 * @param busiType
	 * @return
	 */
	public static String getLayerAlias(String busiType){
		String config = AppConfig.getProperty(busiType+".layer.alias");
		if (StringUtils.isNotBlank(config)) {
			config = StringUtils.trimToEmpty(config);
		}else {
			config = "";
		}
		return config;
	}
	/**
	 * 获取配置文件中业务数据请求URL地址
	 * bpdk.layer.propertyUrl=/zhsw/plot/plot-basic-spb!getJSONProperty.action
	 * @param busiType
	 * @return
	 */
	public static String getLayerPropertyUrl(String busiType){
		String config = AppConfig.getProperty(busiType+".layer.propertyUrl");
		if (StringUtils.isNotBlank(config)) {
			config = StringUtils.trimToEmpty(config);
		}else {
			config = "";
		}
		return config;
	}
	/**
	 * 获取配置文件中收件单编号第一部分，也就是年份之前的汉字
	 * bpdk.sjd.bh=PlatformHelper.getConfigSubcode()收
	 * @param busiType
	 * @return
	 */
	public static String getSjdBh(String busiType){
		String config = AppConfig.getProperty(busiType+".sjd.bh");
		if (StringUtils.isNotBlank(config)) {
			config = StringUtils.trimToEmpty(config);
		}else {
			config = "";
		}
		return config;
	}
	
	/**
	 * 获取配置文件中的数据中心omp中的配置模板名称
	 * bpdk.omp.template=bpdkConfig
	 * @param busiType
	 * @return
	 */
	public static String getOmpTemplate(String busiType){
		String config = AppConfig.getProperty(busiType+".omp.template");
		if (StringUtils.isNotBlank(config)) {
			config = StringUtils.trimToEmpty(config);
		}
		if (StringUtils.isBlank(config)) {
			config = AppConfig.getProperty("default.template");
		}
		if (StringUtils.isBlank(config)) {
			config = "";
		}
		return config;
	}
	
	public static String getServerURL(){
		return AppConfig.getProperty("server.url");
	}
	
	public static String getEgovgisURL(){
		return getBusiSystemServerURL("egovgis");
	}
	public static String getFileCenterURL(){
		return getBusiSystemServerURL("fileCenter");
	}
	
	public static String getBusiSystemServerURL(String busiSystemName){
		return getServerURL()+"/"+busiSystemName;
	}
	
	public static String getOmpURL(){
		return AppConfig.getProperty("omp.url");
	}
	
	public static NodeService getNodeService(){
		return (NodeService)Container.getBean("NodeService");
	}
	
	public static FileService getFileService(){
		return (FileService)Container.getBean("FileService");
	}

    public static String getUserRegionCode(HttpServletRequest request){
    	String regionCode = "";
    	UserInfo userInfo = SessionUtil.getUserInfo(request);
		if (userInfo != null) {
			regionCode = userInfo.getRegionCode();
		}
        if (StringUtils.isNotBlank(regionCode)){
            if (regionCode.length()>9){
                regionCode =regionCode.substring(0,8);
            }
        }
        return regionCode;
	}

	public static SysWorkFlowInstanceService getSysWorkFlowInstanceService() {
		return (SysWorkFlowInstanceService) Container.getBean("SysWorkFlowInstanceService");
	}

	public static SysTaskService getTaskService() {
		return (SysTaskService) Container.getBean("TaskService");
	}
}
