package cn.gtmap.zhsw.utils;

import java.io.*;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import jxl.Cell;
import jxl.Sheet;
import jxl.Workbook;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.json.JSONUtil;


public class JzdFileUtil {
	static Log log = LogFactory.getLog(JzdFileUtil.class);
    public final static int POINTNO_X_Y_RINGNO = 0; //格式为：点序号，X，Y，多边形环号
    public final static int POLYGONNO_POINTNO_X_Y_RINGNO = 1;//格式为：多边形号,环内点序号,X,Y,多边形环号
    public final static int POLYGONNO_RINGNO_POINTNO_X_Y = 2; //格式为：多边形号,多边形环号,环内点序号,X,Y
    public final static int POINTNO_RINGNO_X_Y = 3; //格式为：点序号，多边形环号,X，Y
    public final static int STANDARD_EXCEL  = 4; //格式为：标准Excel格式坐标文件
    public final static int POINTNO_X_Y_LENGTH_TYPE_RINGNO = 5; //格式为：界址点序号，界址点号，X，Y，边长，类型，多边形环号
    public final static int SHAPE_ZIP_FILE = 6; //格式为：shp压缩包，zip格式
    public final static int STANDARD_TXT = 7; //格式为：标准Txt格式坐标文件
    public final static int CAD_DWG = 8; //格式为：CAD格式坐标文件

    /**
     * 导入数据
     *
     * @param path     服务器端文件路径，一般是从客户端已经上传过来的文件
     * @return 信息（错误信息或成功信息）
     */
    public static List<String[]> getPntCoordArrList(String path, String proId, int pointFormat, String busiType, String check) {
        List<String[]> list = new ArrayList<String[]>();
        try {
        	switch (pointFormat) {
				case POINTNO_X_Y_RINGNO :
					list = parsePXYRCoordFile(path);
					break;
				case POLYGONNO_POINTNO_X_Y_RINGNO :
					list = parsePPXYRCoordFile(path);
					break;
				case POLYGONNO_RINGNO_POINTNO_X_Y :
					list = parseStandardCoordFile(path);
					break;
				case POINTNO_RINGNO_X_Y :
					list = parsePRXYCoordFile(path);
					break;
				case STANDARD_EXCEL :
					list = parseStandardExcel(path);
					break;
				case POINTNO_X_Y_LENGTH_TYPE_RINGNO :
					list = parsePXYLTRCoordFile(path);
					break;
				case SHAPE_ZIP_FILE :
					list = GeometryOperationUtil.parseShapeZipFile(path,proId,busiType,check,null);
					break;
				case STANDARD_TXT :
					list = parseStandardTxtCoordFile(path);
					break;
				case CAD_DWG :
					list = GeometryOperationUtil.parseCadFile(path,proId,busiType,check,null);
					break;
				default :
					list = parsePXYRCoordFile(path);
					break;
			}
        } catch (Exception ex) {
            ex.printStackTrace();
        }
        return list;
    }

    /**
     * 传入参数为String 字符串
     * 判断该字符串是否是数据组成
     * 返回参数为true or false
     */
    private static boolean checkNum(String str) {
        boolean resultValue = false;
        if ((str == null) || (str.equals(""))) {
            return false;
        }
        str = str.trim();
        int len = str.length();

        if (str.charAt(0) == '.' || str.charAt(len - 1) == '.') {
            return resultValue;
        }

        if (str.indexOf(".") != -1) {
            String tempStr = str.substring(0, str.indexOf("."));
            if (StringUtils.isNotBlank(tempStr)) {
				if (!tempStr.equals("0")) {
					if (tempStr.charAt(0) == '0') {
		                return resultValue;
		            }
				}
			}
        } else {
            if (str.charAt(0) == '0') {
                return resultValue;
            }
        }

        int j = 0;
        for (int i = 0; i < len; i++) {
            resultValue = false;
            char s = str.charAt(i);
            if (((i == 0) && (s == '0')) || ((i == 0) && (s == '.'))) {
                return resultValue;
            }
            if ((i == (len - 1)) && (s == '.')) {
                return resultValue;
            }

            if (s == '.') {
                j++;
            }

            if (j >= 2) {
                break;
            }
            if ((s >= '0' && s <= '9') || (s == '.')) {
                resultValue = true;
            }

            if (resultValue == false) {
                break;
            }
        }
        return resultValue;
    }

    /**
     * 解析坐标串文件
     *
     * @param coordFilePath 坐标文件路径
     * @return 返回类型为List，格式为标准格式的字符串的List，即list中的每一个坐标串string的格式为：点序号,X,Y,多边形环号
     */
    private static List parsePXYRCoordFile(String coordFilePath) {
        List resultList = null;
        FileReader fr = null;
        BufferedReader br = null;
        try {
            fr = new FileReader(coordFilePath);
            br = new BufferedReader(fr);
            String record = new String();
            int index = 0;
            int len = 0;
            resultList = new ArrayList();
            int polygonNO = 1;
            int ringNO = 0;
            String ringSign = ""; //表示环的标识
            String firstPntSign = "0";
            String firstPnt = "";
            int times = 0;
            int pointNO = 0;
            while ((record = br.readLine()) != null) { //处理每行的数据
                index++;
                if (record.trim().length() > 0) {
                    log.debug(" record = " + record);
                    if (record.indexOf(",") == -1) {
                        log.error("文件中第" + index + "行数据内容或格式不符合要求！\\n\\n正确格式应如：1,2.55,3.96,111");
                        return null;
                    }
                    if (record.charAt(record.length() - 1) == ',') {
                        log.error("文件中第" + index + "行数据内容或格式不符合要求！\\n\\n正确格式应如：1,2.55,3.96,111");
                        return null;
                    }
                    String[] dataArray = record.split(",");
                    String[] standardArray = new String[5];
                    if (dataArray.length == 0) {
                        log.error("文件中第" + index + "行数据内容或格式不符合要求！\\n\\n正确格式应如：1,2.55,3.96,111");
                        return null;
                    }
                    len = dataArray.length;
                    if (len == 4) {
                        for (int i = 1; i < dataArray.length - 1; i++) {//界址点序号、环号（环标示符）可以不为数字（例如1,2.55,3.96,NULL）
                            if (checkNum(dataArray[i]) == false) {
                                log.error("第 " + index + " 行" + "第 " + (i + 1) + " 列数据含有非法字符或数据格式不对！\\n\\n正确格式应如：1,2.55,3.96,111");
                                return null;
                            }
                        }
                    } else {
                        log.error("第 " + index + " 行（" + record + "）数据不完整或文件内容出错！");
                        return null;
                    }

                    if (!ringSign.equals(dataArray[3])) {
                        ringSign = dataArray[3];
                        ringNO++;
                        firstPntSign = dataArray[0];
                        firstPnt = dataArray[1] + "," + dataArray[2];
                        times = 0;
                        pointNO = 1;
                    } else {
                        pointNO++;
                    }

//                    if ((firstPntSign.equals(dataArray[0])) && (firstPnt.equals(dataArray[1] + "," + dataArray[2]))) {
//                        if (times > 0)
//                            continue;
//                        else
//                            times++;
//                    }
                    standardArray[0] = String.valueOf(polygonNO);
                    standardArray[1] = String.valueOf(ringNO);
                    standardArray[2] = String.valueOf(pointNO);
                    standardArray[3] = dataArray[1];
                    standardArray[4] = dataArray[2];
                    resultList.add(standardArray);
                }
            }
        } catch (Exception ex) {
            ex.printStackTrace();
            log.error(ex.getMessage());
        } finally {
            try {
                if (br != null)
                    br.close();
                if (fr != null)
                    fr.close();
            } catch (Exception ex) {
                ex.printStackTrace();
                log.error(ex.getMessage());
            }
        }
        return resultList;
    }


    /**
     * 解析坐标串文件
     *
     * @param coordFilePath 坐标文件路径
     * @return 返回类型为List，格式为标准格式的字符串的List，即list中的每一个坐标串string的格式为：点序号,多边形环号,X,Y
     */
    private static List parsePRXYCoordFile(String coordFilePath) {
        List resultList = null;
        FileReader fr = null;
        BufferedReader br = null;
        try {
            fr = new FileReader(coordFilePath);
            br = new BufferedReader(fr);
            String record = new String();
            int index = 0;
            int len = 0;
            resultList = new ArrayList();
            int polygonNO = 1;
            int ringNO = 0;
            String ringSign = ""; //表示环的标识
            String firstPntSign = "0";
            String firstPnt = "";
            int times = 0;
            int pointNO = 0;
            while ((record = br.readLine()) != null) { //处理每行的数据
                index++;
                if (record.trim().length() > 0) {
                    log.debug(" record = " + record);
                    if (record.indexOf(",") == -1) {
                        log.error("文件中第" + index + "行数据内容或格式不符合要求！\\n\\n正确格式应如：1,1,2.55,3.96");
                        return null;
                    }
                    if (record.charAt(record.length() - 1) == ',') {
                        log.error("文件中第" + index + "行数据内容或格式不符合要求！\\n\\n正确格式应如：1,1,2.55,3.96");
                        return null;
                    }
                    String[] dataArray = record.split(",");
                    String[] standardArray = new String[5];
                    if (dataArray.length == 0) {
                        log.error("文件中第" + index + "行数据内容或格式不符合要求！\\n\\n正确格式应如：1,1,2.55,3.96");
                        return null;
                    }
                    len = dataArray.length;
                    if (len == 4) {
                        for (int i = 0; i < dataArray.length; i++) {
                            if (i > 1 && (checkNum(dataArray[i]) == false)) {
                                log.error("第 " + index + " 行" + "第 " + (i + 1) + " 列数据含有非法字符或数据格式不对！\\n\\n正确格式应如：1,1,2.55,3.96");
                                return null;
                            }
                        }
                    } else {
                        log.error("第 " + index + " 行（" + record + "）数据不完整或文件内容出错！");
                        return null;
                    }

                    if (!ringSign.equals(dataArray[1])) {
                        ringSign = dataArray[1];
                        ringNO++;
                        firstPntSign = dataArray[0];
                        firstPnt = dataArray[2] + "," + dataArray[3];
                        times = 0;
                        pointNO = 1;
                    } else {
                        pointNO++;
                    }

//                    if ((firstPntSign.equals(dataArray[0])) && (firstPnt.equals(dataArray[2] + "," + dataArray[3]))) {
//                        if (times > 0)
//                            continue;
//                        else
//                            times++;
//                    }
                    standardArray[0] = String.valueOf(polygonNO);
                    standardArray[1] = String.valueOf(ringNO);
                    standardArray[2] = String.valueOf(pointNO);
                    standardArray[3] = dataArray[2];
                    standardArray[4] = dataArray[3];
                    resultList.add(standardArray);
                }
            }
        } catch (Exception ex) {
            ex.printStackTrace();
            log.error(ex.getMessage());
        } finally {
            try {
                if (br != null)
                    br.close();
                if (fr != null)
                    fr.close();
            } catch (Exception ex) {
                ex.printStackTrace();
                log.error(ex.getMessage());
            }
        }
        return resultList;
    }

    /**
     * 解析标准的坐标串文件，格式为：多边形号,多边形环号,环内点序号,X,Y
     *
     * @param coordFilePath 坐标文件路径
     * @return
     */
    private static List parseStandardCoordFile(String coordFilePath) {
        List resultList = null;
        FileReader fr = null;
        BufferedReader br = null;
        try {
            fr = new FileReader(coordFilePath);
            br = new BufferedReader(fr);
            String record = new String();
            int index = 0;
            int len = 0;
            resultList = new ArrayList();
            while ((record = br.readLine()) != null) { //处理每行的数据
                index++;
                if (record.trim().length() > 0) {
                    log.debug(" record = " + record);
                    if (record.indexOf(",") == -1) {
                        log.error("文件中第" + index + "行数据内容或格式不符合要求！\\n\\n正确格式应如：1,1,1,2.55,3.96");
                        return null;
                    }
                    if (record.charAt(record.length() - 1) == ',') {
                        log.error("文件中第" + index + "行数据内容或格式不符合要求！\\n\\n正确格式应如：1,1,1,2.55,3.96");
                        return null;
                    }
                    String[] dataArray = record.split(",");
                    if (dataArray.length == 0) {
                        log.error("文件中第" + index + "行数据内容或格式不符合要求！\\n\\n正确格式应如：1,1,1,2.55,3.96");
                        return null;
                    }
                    len = dataArray.length;
                    if (dataArray[1].equals("")) {
                        len = len - 1;
                    }
                    if (len == 5) {
                        for (int i = 0; i < dataArray.length; i++) {
                            if ((dataArray == null) || (dataArray[0].equals(""))) {
                                log.error("第 " + index + " 行多边形编号为空!");
                                return null;
                            }
                            if ((dataArray == null) || (dataArray[1].equals(""))) {
                                log.error("第 " + index + " 行多边形环号为空!");
                                return null;
                            }
                            if ((dataArray == null) || (dataArray[2].equals(""))) {
                                log.error("第 " + index + " 行界址点编号为空!");
                                return null;
                            }

                            if (i != 0 && i != 1 && i != 2) {
                                if (checkNum(dataArray[i]) == false) {
                                    log.error("第 " + index + " 行" + "第 " + (i + 1) + " 列数据含有非法字符或数据格式不对！\\n\\n正确格式应如：1,1,1,2.55,3.96");
                                    return null;
                                }
                            }
                        }
                    } else {
                        log.error("第 " + index + " 行（" + record + "）数据不完整或文件内容出错！");
                        return null;
                    }
                    resultList.add(dataArray);
                }
            }
        } catch (Exception ex) {
            ex.printStackTrace();
            log.error(ex.getMessage());
        } finally {
            try {
                if (br != null)
                    br.close();
                if (fr != null)
                    fr.close();
            } catch (Exception ex) {
                ex.printStackTrace();
                log.error(ex.getMessage());
            }
        }
        return resultList;
    }

    /**
     * 解析坐标串文件
     *
     * @param coordFilePath 坐标文件路径
     * @return 返回类型为List，格式为标准格式的字符串的List，即list中的每一个坐标串string的格式为：多边形号,环内点序号,X,Y,多边形环号
     */
    private static List parsePPXYRCoordFile(String coordFilePath) {
        List resultList = null;
        FileReader fr = null;
        BufferedReader br = null;
        try {
            fr = new FileReader(coordFilePath);
            br = new BufferedReader(fr);
            String record = new String();
            int index = 0;
            int len = 0;
            resultList = new ArrayList();
            int polygonNO = 0;
            String polygonSign = "";
            int ringNO = 0;
            String ringSign = ""; //表示环的标识
            String firstPntSign = "0";
            String firstPnt = "";
            int times = 0;
            int pointNO = 0;
            while ((record = br.readLine()) != null) { //处理每行的数据
                index++;
                if (record.trim().length() > 0) {
                    log.debug(" record = " + record);
                    if (record.indexOf(",") == -1) {
                        log.error("文件中第" + index + "行数据内容或格式不符合要求！\\n\\n正确格式应如：1,1,2.55,3.96,111");
                        return null;
                    }
                    if (record.charAt(record.length() - 1) == ',') {
                        log.error("文件中第" + index + "行数据内容或格式不符合要求！\\n\\n正确格式应如：1,1,2.55,3.96,111");
                        return null;
                    }
                    String[] dataArray = record.split(",");
                    String[] standardArray = new String[5];
                    if (dataArray.length == 0) {
                        log.error("文件中第" + index + "行数据内容或格式不符合要求！\\n\\n正确格式应如：1,1,2.55,3.96,111");
                        return null;
                    }
                    len = dataArray.length;
                    if (len == 5) {
                        for (int i = 2; i < dataArray.length - 1; i++) {//环号（环标示符）可以不为数字（例如1,2.55,3.96,NULL）
                            if (checkNum(dataArray[i]) == false) {
                                log.error("第 " + index + " 行" + "第 " + (i + 1) + " 列数据含有非法字符或数据格式不对！\\n\\n正确格式应如：1,1,2.55,3.96,111");
                                return null;
                            }
                        }
                    } else {
                        log.error("第 " + index + " 行（" + record + "）数据不完整或文件内容出错！");
                        return null;
                    }
                    if (!polygonSign.equals(dataArray[0])) {
                        polygonSign = dataArray[0];
                        polygonNO++;
                    }
                    if (!ringSign.equals(dataArray[4])) {
                        ringSign = dataArray[4];
                        ringNO++;
                        firstPntSign = dataArray[1];
                        firstPnt = dataArray[2] + "," + dataArray[3];
                        times = 0;
                        pointNO = 1;
                    } else {
                        pointNO++;
                    }

//                    if ((firstPntSign.equals(dataArray[1])) && (firstPnt.equals(dataArray[2] + "," + dataArray[3]))) {
//                        if (times > 0)
//                            continue;
//                        else
//                            times++;
//                    }


                    standardArray[0] = String.valueOf(polygonNO);
                    standardArray[1] = String.valueOf(ringNO);
                    standardArray[2] = String.valueOf(pointNO);
                    standardArray[3] = dataArray[2];
                    standardArray[4] = dataArray[3];
                    resultList.add(standardArray);
                }
            }
        } catch (Exception ex) {
            ex.printStackTrace();
            log.error(ex.getMessage());
        } finally {
            try {
                if (br != null)
                    br.close();
                if (fr != null)
                    fr.close();
            } catch (Exception ex) {
                ex.printStackTrace();
                log.error(ex.getMessage());
            }
        }
        return resultList;
    }


    private static List parseStandardExcel(String filePath) {
        FileInputStream fis = null;
        List<String[]> resultList = null;
        try {
            fis = new FileInputStream(new File(filePath));
            Workbook rwb = Workbook.getWorkbook(fis);
            int countOfSheets = rwb.getNumberOfSheets();
            resultList = new ArrayList();
            int polygonNO = 0;

            for(int i=0;i<countOfSheets;i++){
                Sheet sheet = rwb.getSheet(i);
                int countOfRows = sheet.getRows();
                int j = 0;
                while(j<countOfRows && sheet.getCell(0,j) != null) {
                    if(!(sheet.getCell(0,j).getContents().endsWith("@"))){
                        j++;
                        continue;
                    }else if(sheet.getCell(0,j).getContents().endsWith("@")){
                        polygonNO++;
                        String dkBasicInfo =sheet.getCell(0,j).getContents().trim();
                        String[] dkBasicInfoArray = dkBasicInfo.split(",");
                        if(dkBasicInfoArray.length>0){
                            int countOfPnts = (dkBasicInfoArray[0]!=""&&(!dkBasicInfoArray[0].equals("")))?Integer.valueOf(dkBasicInfoArray[0]):0;
                            int tempCnt = 1;
                            try{
                                while((tempCnt<=countOfPnts)&& sheet.getCell(0, j + tempCnt) != null && (!( sheet.getCell(0, j + tempCnt).getContents().trim().endsWith("@")))){
                                    Cell[] tempRow= sheet.getRow(j+tempCnt);
                                    String pntNO = tempRow[0].getContents();
                                    int indexOfPnt = 0;
                                    if(StringUtils.isNumeric(pntNO))
                                        indexOfPnt = Integer.valueOf(pntNO);
                                    else
                                        indexOfPnt = Integer.valueOf(pntNO.substring(1));
                                    int ringNO =Integer.parseInt(tempRow[1].getContents());
                                    String[] standardArray = new String[6];
                                    standardArray[0] = String.valueOf(polygonNO);
                                    standardArray[1] = String.valueOf(ringNO);
                                    standardArray[2] = String.valueOf(indexOfPnt);
                                    standardArray[3] = tempRow[2].getContents();
                                    standardArray[4] = tempRow[3].getContents();
                                    if (tempRow.length > 4) {
                                    	standardArray[5] = tempRow[4].getContents();//边长
									}
                                    resultList.add(standardArray);
                                    tempCnt++;
                                }
                            }catch (Exception ex){
                            	ex.printStackTrace();
                                log.error(ex.getMessage());
                            }
                            j+= tempCnt;
                        } else{
                            log.error("Excel数据文件地块基本信息格式错误!");
                        }
                    }
                }
            }
        }catch (Exception e) {
            e.printStackTrace();
        } finally {
            if(fis!=null){
                try {
                    fis.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return resultList;
    }
    
    /**
     * 解析坐标串文件
     *界址点序号，界址点号，X，Y，边长，类型，多边形环号
     * @param coordFilePath 坐标文件路径
     * @return 返回类型为List，格式为标准格式的字符串的List，即list中的每一个坐标串string的格式为：界址点序号，界址点号，X，Y，边长，类型，多边形环号
     */
    private static List parsePXYLTRCoordFile(String coordFilePath) {
        List resultList = null;
        FileReader fr = null;
        BufferedReader br = null;
        try {
            fr = new FileReader(coordFilePath);
            br = new BufferedReader(fr);
            String record = new String();
            int index = 0;
            int len = 0;
            resultList = new ArrayList();
            int polygonNO = 1;
            int ringNO = 0;
            String ringSign = ""; //表示环的标识
            String firstPntSign = "0";
            String firstPnt = "";
            int times = 0;
            int pointNO = 0;
            while ((record = br.readLine()) != null) { //处理每行的数据
                index++;
                if (record.trim().length() > 0) {
                    log.debug(" record = " + record);
                    if (record.indexOf(",") == -1) {
                        log.error("文件中第" + index + "行数据内容或格式不符合要求！\\n\\n正确格式应如：1,1,3529339.74,40558671.44,1175.20,喷涂,1");
                        return null;
                    }
                    if (record.charAt(record.length() - 1) == ',') {
                        log.error("文件中第" + index + "行数据内容或格式不符合要求！\\n\\n正确格式应如：1,1,3529339.74,40558671.44,1175.20,喷涂,1");
                        return null;
                    }
                    String[] dataArray = record.split(",");
                    String[] standardArray = new String[7];
                    if (dataArray.length == 0) {
                        log.error("文件中第" + index + "行数据内容或格式不符合要求！\\n\\n正确格式应如：1,1,3529339.74,40558671.44,1175.20,喷涂,1");
                        return null;
                    }
                    len = dataArray.length;
                    if (len == 7) {
                        for (int i = 0; i < dataArray.length - 3; i++) {//界址点序号、环号（环标示符）可以不为数字（例如1,2.55,3.96,NULL）
                            if (checkNum(dataArray[i]) == false) {
                                log.error("第 " + index + " 行" + "第 " + (i + 1) + " 列数据含有非法字符或数据格式不对！\\n\\n正确格式应如：1,1,3529339.74,40558671.44,1175.20,喷涂,1");
                                return null;
                            }
                        }
                    } else {
                        log.error("第 " + index + " 行（" + record + "）数据不完整或文件内容出错！");
                        return null;
                    }

                    if (!ringSign.equals(dataArray[6])) {
                        ringSign = dataArray[6];
                        ringNO++;
                        firstPntSign = dataArray[1];
                        firstPnt = dataArray[2] + "," + dataArray[3];
                        times = 0;
                        pointNO = 1;
                    } else {
                        pointNO++;
                    }
                    standardArray[0] = "1";
                    standardArray[1] = String.valueOf(ringNO);
                    standardArray[2] = String.valueOf(pointNO);
                    standardArray[3] = dataArray[2];
                    standardArray[4] = dataArray[3];
                    standardArray[5] = dataArray[4];//边长
                    standardArray[6] = dataArray[5];//界址点类型
                    resultList.add(standardArray);
                }
            }
        } catch (Exception ex) {
            ex.printStackTrace();
            log.error(ex.getMessage());
        } finally {
            try {
                if (br != null)
                    br.close();
                if (fr != null)
                    fr.close();
            } catch (Exception ex) {
                ex.printStackTrace();
                log.error(ex.getMessage());
            }
        }
        return resultList;
    }
    
    /**
     * 解析坐标串文件
     *点序号，多边形环号,X，Y
     * @param coordFilePath 坐标文件路径
     * @return 返回类型为List，格式为标准格式的字符串的List，即list中的每一个坐标串string的格式为：点序号，多边形环号,X，Y
     */
    private static List parseStandardTxtCoordFile(String coordFilePath) {
        List resultList = null;
        FileReader fr = null;
        BufferedReader br = null;
        try {
            fr = new FileReader(coordFilePath);
            br = new BufferedReader(fr);
            String record = new String();
            int index = 0;
            int len = 0;
            resultList = new ArrayList();
            int polygonNO = 1;
            int ringNO = 0;
            String ringSign = ""; //表示环的标识
            String firstPntSign = "0";
            String firstPnt = "";
            int times = 0;
            int pointNO = 0;
            
            boolean isbegin = false;
            while ((record = br.readLine()) != null) { //处理每行的数据
                index++;
                if (StringUtils.isNotBlank(record)) {
                	if (StringUtils.startsWithIgnoreCase(record, "J1")) {
                		//获取第一个坐标，开始循环坐标
                		isbegin = true;
    				}
                	if (isbegin) {
                		//开始解析界址点之后，凡是J开头的都是坐标，反之则是新的地块界址点的开始
                		if (StringUtils.startsWithIgnoreCase(record, "J")) {
                			log.debug(" record = " + record);
                            if (record.indexOf(",") == -1) {
                                log.error("文件中第" + index + "行数据内容或格式不符合要求！\\n\\n正确格式应如：1,1,2.55,3.96");
                                return null;
                            }
                            if (record.charAt(record.length() - 1) == ',') {
                                log.error("文件中第" + index + "行数据内容或格式不符合要求！\\n\\n正确格式应如：1,1,2.55,3.96");
                                return null;
                            }
                            String[] dataArray = record.split(",");
                            String[] standardArray = new String[5];
                            if (dataArray.length == 0) {
                                log.error("文件中第" + index + "行数据内容或格式不符合要求！\\n\\n正确格式应如：1,1,2.55,3.96");
                                return null;
                            }
                            len = dataArray.length;
                            if (len == 4) {
                                for (int i = 0; i < dataArray.length; i++) {
                                    if (i > 1 && (checkNum(dataArray[i]) == false)) {
                                        log.error("第 " + index + " 行" + "第 " + (i + 1) + " 列数据含有非法字符或数据格式不对！\\n\\n正确格式应如：1,1,2.55,3.96");
                                        return null;
                                    }
                                }
                            } else {
                                log.error("第 " + index + " 行（" + record + "）数据不完整或文件内容出错！");
                                return null;
                            }

                            if (!ringSign.equals(dataArray[1])) {
                                ringSign = dataArray[1];
                                ringNO++;
                                firstPntSign = dataArray[0];
                                firstPnt = dataArray[2] + "," + dataArray[3];
                                times = 0;
                                pointNO = 1;
                            } else {
                                pointNO++;
                            }

                            standardArray[0] = String.valueOf(polygonNO);
                            standardArray[1] = String.valueOf(ringNO);
                            standardArray[2] = String.valueOf(pointNO);
                            standardArray[3] = dataArray[2];
                            standardArray[4] = dataArray[3];
                            resultList.add(standardArray);
						}else {
							polygonNO ++;
							ringNO = 0;
							ringSign = ""; //表示环的标识
							firstPntSign = "0";
							times = 0;
							pointNO = 0;
						}
					}
				}
            }
        } catch (Exception ex) {
            ex.printStackTrace();
            log.error(ex.getMessage());
        } finally {
            try {
                if (br != null)
                    br.close();
                if (fr != null)
                    fr.close();
            } catch (Exception ex) {
                ex.printStackTrace();
                log.error(ex.getMessage());
            }
        }
        return resultList;
    }
}
