package cn.gtmap.zhsw.utils;

import java.io.*;
import java.math.BigDecimal;
import java.util.*;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.json.JSONUtil;

import com.alibaba.fastjson.JSON;
import com.gtis.config.AppConfig;
import com.vividsolutions.jts.geom.Geometry;

import org.geotools.feature.*;
import org.geotools.geojson.feature.FeatureJSON;
import org.geotools.geojson.geom.GeometryJSON;
import org.opengis.feature.*;
import org.opengis.feature.simple.SimpleFeature;

/**
 * @文件名 PublicUtil.java
 * @作者 卢向伟
 * @创建日期 Dec 21, 2011
 * @创建时间 2:57:55 PM 
 * @版本号 V 1.0
 */
public class GeometryOperationUtil {
	public static String msg;
	
	public static String initLocationUrl(String whereClause,String bType,String hideTop,String hideLeft){
		String url = null;
		try {
			if (StringUtils.isBlank(hideTop) || StringUtils.equals(hideTop, "true")) {
				hideTop = "true";
			}
			if (StringUtils.isBlank(hideLeft) || StringUtils.equals(hideLeft, "true")) {
				hideLeft = "true";
			}
			if (StringUtils.isNotBlank(bType) && StringUtils.isNotBlank(whereClause)) {
				if (bType.indexOf(",") > -1) {
					bType = bType.substring(0,bType.indexOf(","));
				}
				String layerName = PlatformHelper.getLayerAlias(bType);
//				layerName = java.net.URLEncoder.encode(layerName,"utf-8");
				HashMap childMap = new HashMap();
				childMap.put("where", whereClause);
				childMap.put("layerAlias", layerName);
				childMap.put("showDimension",true);
				HashMap param = new HashMap();
				param.put("params", childMap);
				param.put("type","layerLocation");
				url = PlatformHelper.getOmpURL()+"/map/"+PlatformHelper.getOmpTemplate(bType)+"?action=location&hideTopBar="+hideTop
						+"&hideLeftPanel="+hideLeft
						+"&params="+java.net.URLEncoder.encode(JSONUtil.serialize(param),"utf-8");
//				url = PlatformHelper.getOmpURL()+"/map/"+PlatformHelper.getOmpTemplate(busiType)+"?action=location&hideTopBar="+hideTopBar+"&params="+JSONUtil.serialize(param)+"&"+request.getQueryString();System.out.println(url);
			}else {
				System.out.println("gis.properties文件没有配置该【"+bType+"】业务类型的图形参数！");
				url = PlatformHelper.getOmpURL()+"/map/"+PlatformHelper.getOmpTemplate(bType);
			}
			System.out.println(url);
		} catch (Exception e) {
		}
		return url;
	}
	
	/**
	 * 调用新数据中心的图形查询功能
	 * @param proid 项目id
	 * @param busiType 业务类型
	 * @param outFields 返回值
	 * @return 
	 * @throws Exception
	 */
	public static String queryGeometry(String proid,String busiType,String outFields)throws Exception{
		if (StringUtils.isNotBlank(proid)) {
			String whereClause = "DKID='"+proid+"'";
			return queryGeometry(proid, busiType,whereClause,outFields);
		}
		System.out.println("项目id为空！");
		return null;
	}
	
	/**
	 * 调用新数据中心的图形查询功能
	 * @param proid 项目id
	 * @param busiType 业务类型
	 * @return
	 * @throws Exception
	 */
	public static String queryGeometry(String proid,String busiType)throws Exception{
		if (StringUtils.isNotBlank(proid)) {
			String whereClause = "DKID='"+proid+"'";
			return queryGeometry(proid, busiType,whereClause,"*");
		}
		System.out.println("项目id为空！");
		return "";
	}
	
	/**
	 * 调用新数据中心的图形查询功能
	 * @param proid 项目id
	 * @param busiType 业务类型
	 * @param whereClause 查询条件
	 * @param outFields 返回值
	 * @return
	 * @throws Exception
	 */
	public static String queryGeometry(String proid,String busiType,String whereClause,String outFields)throws Exception{
		String message = "";
		try {
			if (StringUtils.isNotBlank(busiType)) {
				String layerName = PlatformHelper.getLayerName(busiType);
				if (StringUtils.isNotBlank(layerName)) {
					//查询现有图形要素objectid
					String url = PlatformHelper.getOmpURL()+"/geometryService/rest/query";    			
	    			HttpClient client = new HttpClient();
	    			PostMethod method = new PostMethod(url);
	    			method.addParameter("layerName", layerName);
//	    			method.addParameter("returnGeometry", "true");
//	    			method.addParameter("outFields", "*");
	    			if (StringUtils.isNotBlank(outFields)){
	    				outFields = outFields.toUpperCase();
	    				if (!outFields.equals("*") && outFields.indexOf("OBJECTID") < 0) {
	    					outFields += ",OBJECTID";
						}
	    			}
	    			method.addParameter("outFields", outFields);//OBJECTID,SHAPE.AREA");
	    			method.addParameter("where", whereClause);
	    			if (StringUtils.isNotBlank(PlatformHelper.getLayerDatasource(busiType))) {
						method.addParameter("dataSource",PlatformHelper.getLayerDatasource(busiType));
					}
	    			int status = client.executeMethod(method);
	    			//打印服务器返回的状态
	    			System.out.println("服务器查询返回的状态" + method.getStatusLine());
	    			//打印服务器返回的数据
	    			String returnJson = method.getResponseBodyAsString();
	    			System.out.println(returnJson);
	    			if (StringUtils.isNotBlank(returnJson)) {
						HashMap resultMap = (HashMap)JSONUtil.deserialize(returnJson);
						if (resultMap != null) {
							if (!resultMap.containsKey("result")) {
								System.out.println("当前项目尚未创建图形！");
//								message = "ERROR:"+returnJson;
							}else {
								List<String> objList = getObjectIdListByGeoJson(resultMap.get("result"));
								if (objList != null && objList.size() > 0) {
									return resultMap.get("result").toString();
								}else {
									message = "当前项目尚未创建图形！";
								}
							}
						}
	    			}
				}else {
					message = "ERROR:gis.properties文件没有配置该【"+busiType+"】业务类型的图形参数！";
				}
			}else {
				message = "ERROR:构建平台没有配置当前工作流对应的busiType！";
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		System.out.println(message);
		return null;
	}
	
	/**
	 * 调用新数据中心的图形插入功能
	 * @param proid 项目id
	 * @param busiType 业务类型
	 * @param check 是否进行拓扑判断
	 * @param geometry 图形数据
	 * @return
	 * @throws Exception
	 */
	public static String insertGeometry(String proid,String busiType,String check,String geometry)throws Exception{
		String message = "";
		if (StringUtils.isNotBlank(busiType) && StringUtils.isNotBlank(proid) && StringUtils.isNotBlank(geometry)) {
			String layerName = PlatformHelper.getLayerName(busiType);
			if (StringUtils.isNotBlank(layerName)) {
    			String url = PlatformHelper.getOmpURL()+"/geometryService/rest/insert";  
    			HttpClient client = new HttpClient();
    			PostMethod method = new PostMethod(url);
    			method.addParameter("layerName", layerName);
    			method.addParameter("geometry", geometry);
    			if (!(StringUtils.isNotBlank(check) && StringUtils.equals(check, "false"))) {
    				check = "true";
				}else {
					check = "false";
				}
    			method.addParameter("check", check);
    			if (StringUtils.isNotBlank(PlatformHelper.getLayerDatasource(busiType))) {
					method.addParameter("dataSource",PlatformHelper.getLayerDatasource(busiType));
				}
    			client.getParams().setParameter(HttpMethodParams.HTTP_CONTENT_CHARSET,"utf-8");
    			int status = client.executeMethod(method);
    			//打印服务器返回的状态
    			System.out.println("服务器插入返回状态：" + method.getStatusLine());
    			//打印服务器返回的数据
    			String returnJson = method.getResponseBodyAsString();
    			System.out.println(returnJson);
    			if (StringUtils.isNotBlank(returnJson)) {
					HashMap resultMap = (HashMap)JSONUtil.deserialize(returnJson);
					if (resultMap != null) {
						if (!resultMap.containsKey("result")) {
							System.out.println("当前项目创建图形失败！");
							message = returnJson;
						}else {
							message = "true";
						}
					}
    			}
			}else {
				message = "gis.properties文件没有配置该【"+busiType+"】业务类型的图形参数！";
			}
		}else {
			message = "构建平台没有配置当前工作流对应的busiType！";
		}
		return message;
	}
	
	/**
	 * 调用新数据中心的图形编辑功能
	 * @param proid 项目id
	 * @param busiType 业务类型
	 * @param param 更新数据的map
	 * @return
	 * @throws Exception
	 */
	public static String updateGeometry(String proid,String busiType,HashMap<String,Object> param)throws Exception{
		String message = "";
		if (StringUtils.isNotBlank(proid)) {
			String whereClause = "DKID='"+proid+"'";
			return updateGeometry(proid, busiType,param,whereClause);
		}
		message = "项目id为空！";
		return message;
	}
	/**
	 * 调用新数据中心的图形编辑功能
	 * @param proid 项目id
	 * @param busiType 业务类型
	 * @param param 更新数据的map
	 * @param whereClause 查询条件
	 * @return
	 * @throws Exception
	 */
	public static String updateGeometry(String proid,String busiType,HashMap<String,Object> param,String whereClause)throws Exception{
		String message = "";
		if (StringUtils.isNotBlank(busiType)) {
			String layerName = PlatformHelper.getLayerName(busiType);
			String geoJson = queryGeometry(proid, busiType,whereClause,"*");
			if (StringUtils.isNotBlank(geoJson)) {
				FeatureJSON queryJson = new FeatureJSON();
				FeatureCollection queryCollection = queryJson.readFeatureCollection(geoJson);
				if (queryCollection != null && queryCollection.size() > 0) {
					FeatureIterator queryIterator = queryCollection.features();
					while (queryIterator.hasNext()) {
			        	Feature feature = queryIterator.next();
			        	//更新属性数据
			        	if (param != null) {
							Iterator it = param.entrySet().iterator();
							while (it.hasNext()) {
								Map.Entry entry = (Map.Entry) it.next();
								Object key = entry.getKey();
								Object value = entry.getValue();
								if (feature.getProperty(key.toString()) != null) {
									feature.getProperty(key.toString()).setValue(value);
								}
							}
						}
			        	
			            String objectId =  feature.getProperty("OBJECTID").getValue().toString();
			            String url = PlatformHelper.getOmpURL()+"/geometryService/rest/update";    			
	        			HttpClient client = new HttpClient();
	        			PostMethod method = new PostMethod(url);
	        			method.addParameter("layerName", layerName);
	        			method.addParameter("primaryKey", objectId);
	        			String geometry = toFeatureJSON(feature);
	        			if (StringUtils.isNotBlank(geometry)) {
	        				geometry = StringUtils.replace(geometry, ",\"OBJECTID\":"+objectId+"", "");
	        				method.addParameter("geometry", geometry);
						}
	        			if (StringUtils.isNotBlank(PlatformHelper.getLayerDatasource(busiType))) {
	        				method.addParameter("dataSource",PlatformHelper.getLayerDatasource(busiType));
	    				}
	        			method.getParams().setParameter(HttpMethodParams.HTTP_CONTENT_CHARSET, "utf-8");
	        			int status = client.executeMethod(method);
	        			//打印服务器返回的状态
	        			System.out.println("服务器更新返回的状态" + method.getStatusLine());
	        			//打印服务器返回的数据
	        			String returnJson = method.getResponseBodyAsString();
	        			System.out.println(returnJson);
	        			if (StringUtils.isNotBlank(returnJson)) {
	    					HashMap resultMap = (HashMap)JSONUtil.deserialize(returnJson);
	    					if (!resultMap.containsKey("result")) {
								message += returnJson+"\r\n";
								System.out.println("更新图形失败！");
							}else {
								System.out.println("更新图形成功！");
							}
	    				}
					}
				}else {
					message = "当前项目尚未创建图形！";
				}
			}
		}
		return message;
	}
	
	/**
	 * 解析
	 * @param geoJson
	 * @param propertys 
	 * 默认返回字段{"OBJECTID","PROID","DKMC","XZQDM","SHAPE_AREA","OG_SHAPE_AREA","AREA"};
	 * 其中查询中面积字段使用的是AREA
	 * 分析中面积字段使用的是SHAPE_AREA","OG_SHAPE_AREA
	 * @return 
	 * @throws Exception
	 */
	public static List<HashMap<String,Object>> getGeometryProperty(String geoJson,String[] propertys)throws Exception{
		return getGeometryProperty(geoJson,propertys,false);
	}
	/**
	 * 解析
	 * @param geoJson
	 * @param propertys 
	 * @param merge 是否合并相同的objecdtid（要素）默认不进行合并
	 * 默认返回字段{"OBJECTID","PROID","DKMC","XZQDM","SHAPE_AREA","OG_SHAPE_AREA","AREA"};
	 * 其中查询中面积字段使用的是AREA
	 * 分析中面积字段使用的是SHAPE_AREA","OG_SHAPE_AREA
	 * @return 
	 * @throws Exception
	 */
	public static List<HashMap<String,Object>> getGeometryProperty(String geoJson,String[] propertys,Boolean merge)throws Exception{
		List<HashMap<String,Object>> objList = new ArrayList<HashMap<String,Object>>();
		String message = "";
		try {
			HashMap<String,HashMap<String,Object>> param = new HashMap<String, HashMap<String,Object>>();
			if (StringUtils.isNotBlank(geoJson)) {
				List<String> tempList = getObjectIdListByGeoJson(geoJson);
				if (tempList != null && tempList.size() > 0) {
					FeatureJSON queryJson = new FeatureJSON();
					FeatureCollection queryCollection = queryJson.readFeatureCollection(geoJson);
					if (queryCollection != null && queryCollection.size() > 0) {
						//处理默认值，默认赋值下面数据中的字段
			        	String[] defaultProperties = {"OBJECTID","DKID","DKMC","XZQDM","SHAPE_AREA","OG_SHAPE_AREA","AREA"};
						FeatureIterator queryIterator = queryCollection.features();
						int index = 0;
						while (queryIterator.hasNext()) {
				        	Feature feature = queryIterator.next();
				        	String objectId =  feature.getProperty("OBJECTID").getValue().toString();
				        	HashMap<String,Object> map = new HashMap<String, Object>();
				        	for (int i = 0; i < defaultProperties.length; i++) {
				        		if (feature.getProperty(defaultProperties[i]) != null) {
				        			map.put(defaultProperties[i], feature.getProperty(defaultProperties[i]).getValue());
				        		}
							}
				        	//更新属性数据
				        	if (propertys != null) {
				        		for (int i = 0; i < propertys.length; i++) {
									String key = propertys[i].toUpperCase();
									Object value = null;
									if (feature.getProperty(key) != null) {
										value = feature.getProperty(key).getValue();
									}
									if (value == null) {
										map.put(key, "");
									}else {
										map.put(key, value);
									}
								}
							}
				        	param.put(objectId + "_"+index, map);
				        	index ++;
						}
					}
				}else {
					message = "当前项目没有生成图形或者是没有叠加图形！";
				}
			}
			System.out.println(message);
//			System.out.println(JSONUtil.serialize(param));
			if (param != null) {
				if (merge != null && merge) {
					HashMap<String,HashMap<String,Object>> objParam = new HashMap<String, HashMap<String,Object>>();
					//处理默认值，默认赋值下面数据中的字段
			    	String[] areaProperties = {"SHAPE_AREA","OG_SHAPE_AREA","AREA"};
					Set keySet = param.keySet();
					for (Object obj : keySet) {
						String key = obj.toString();
						if (StringUtils.isNotBlank(key) && key.indexOf("_") > -1) {
							String curObjectId = key.split("_")[0];
							HashMap<String,Object> curMap = param.get(key);
							//针对重复的objectid进行合并处理
							if (objParam.containsKey(curObjectId)) {
								HashMap<String,Object> map = objParam.get(curObjectId);
								//开始对比处理上一个map和当前value，合并其中的属性值，如果是面积字段，则需要合计面积
								for (int i = 0; i < areaProperties.length; i++) {
					        		if (curMap.containsKey(areaProperties[i]) && map.containsKey(areaProperties[i])) {
					        			Double curArea = CommonUtil.StringToDouble(curMap.get(areaProperties[i]).toString(), 8, false);
					        			Double oldArea = CommonUtil.StringToDouble(map.get(areaProperties[i]).toString(), 8, false);
					        			curArea = curArea == null?0.0:curArea;
					        			oldArea = oldArea == null?0.0:oldArea;
					        			map.put(areaProperties[i], curArea+oldArea);
					        		}
								}
								objParam.put(curObjectId, map);
								
							}else {
								objParam.put(curObjectId, curMap);
							}
						}
					}
					objList.addAll(objParam.values());
				}else {
					objList.addAll(param.values());
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		System.out.println(JSONUtil.serialize(objList));
		return objList;
	}
	
	/**
	 *  * 调用新数据中心的图形删除功能
	 * @param proid 项目id
	 * @param busiType 业务类型
	 * @return"OBJECTID："+analyobjectId+"；PROID："+PROID+"；叠加面积："+SHAPE_AREA+"；目标数据总面积：" +OG_SHAPE_AREA
	 * @param whereClause 查询条件
	 * @return
	 * @throws Exception
	 */
	public static String delGeometry(String proid,String busiType,String whereClause)throws Exception{
		String message = "";
		if (StringUtils.isNotBlank(busiType)) {
			String layerName = PlatformHelper.getLayerName(busiType);
			String geoJson = queryGeometry(proid, busiType,whereClause,"*");
			if (StringUtils.isNotBlank(geoJson)) {
				FeatureJSON queryJson = new FeatureJSON();
				FeatureCollection queryCollection = queryJson.readFeatureCollection(geoJson);
				if (queryCollection != null && queryCollection.size() > 0) {
					FeatureIterator queryIterator = queryCollection.features();
					String url = PlatformHelper.getOmpURL()+"/geometryService/rest/delete";
					while (queryIterator.hasNext()) {
			        	Feature feature = queryIterator.next();
			            String objectId =  feature.getProperty("OBJECTID").getValue().toString();
			            //如果勘界是独立的勘界管理选择进来的，则不删除图形
			            //如果图层包含了SBID字段，且该字段有值，则不删除图形，而是将SBID的值，赋值给DKID
			            String tmpField = "SBID";
			            if (feature.getProperty(tmpField)  != null && feature.getProperty(tmpField).getValue() != null && StringUtils.isNotBlank(feature.getProperty(tmpField).getValue().toString())) {
			            	String sbid =  feature.getProperty(tmpField).getValue().toString();
			            	String sbWhere = tmpField+"='"+sbid+"'";
			            	HashMap zhsw = new HashMap();
		        			zhsw.put("DKID",sbid);
		        			updateGeometry(sbid, busiType,zhsw,sbWhere);
						}else {
							HttpClient client = new HttpClient();
		        			PostMethod method = new PostMethod(url);
		        			method.addParameter("layerName", layerName);
		        			method.addParameter("primaryKey", objectId);
		        			if (StringUtils.isNotBlank(PlatformHelper.getLayerDatasource(busiType))) {
		        				method.addParameter("dataSource",PlatformHelper.getLayerDatasource(busiType));
		    				}
		        			int delStatus = client.executeMethod(method);
		        			//打印服务器返回的状态
		        			System.out.println("服务器删除返回的状态" + method.getStatusLine());
		        			//打印服务器返回的数据
		        			String returnJson = method.getResponseBodyAsString();
		        			System.out.println(returnJson);
		        			if (StringUtils.isNotBlank(returnJson)) {
		    					HashMap resultMap = (HashMap)JSONUtil.deserialize(returnJson);
		    					if (!resultMap.containsKey("result")) {
									message += returnJson+"\r\n";
									System.out.println("删除失败！");
								}else {
									System.out.println("删除成功！");
								}
		    				}
						}
					}
				}
			}else {
				message = "当前项目尚未创建图形！";
			}
		}else {
			message = "构建平台没有配置当前工作流对应的busiType！";
		}
		return message;
	}
	
	/**
	 * 调用新数据中心的图形删除功能
	 * @param proid 项目id
	 * @param busiType 业务类型
	 * @return"OBJECTID："+analyobjectId+"；PROID："+PROID+"；叠加面积："+SHAPE_AREA+"；目标数据总面积：" +OG_SHAPE_AREA
	 * @throws Exception
	 */
	public static String delGeometry(String proid,String busiType)throws Exception{
		String message = "";
		if (StringUtils.isNotBlank(proid)) {
			String whereClause = "DKID='"+proid+"'";
			return delGeometry(proid, busiType,whereClause);
		}
		message = "项目id为空！";
		return message;
	}
	
	/**
	 * 调用新数据中心的图形分析功能
	 * @param geoJson 源数据图形
	 * @param busiType 目标图层数据源业务类型
	 * @return
	 * @throws Exception
	 */
	public static String analysisGeometry(String geoJson,String busiType)throws Exception{
		String message = "";
		System.out.println("分析开始......");
		if (StringUtils.isNotBlank(busiType)) {
			String layerName = PlatformHelper.getLayerName(busiType);
			if (StringUtils.isNotBlank(layerName)) {
				System.out.println("分析目标图层："+layerName);
				//开始进行分析
	            String url = PlatformHelper.getOmpURL()+"/geometryService/rest/intersect";    	
	            //叠加分析
	            HttpClient client = new HttpClient();
    			PostMethod method = new PostMethod(url);
    			method.addParameter("layerName", layerName);
    			method.addParameter("geometry", geoJson);
    			
    			if (StringUtils.isNotBlank(PlatformHelper.getLayerDatasource(busiType))) {
    				method.addParameter("dataSource",PlatformHelper.getLayerDatasource(busiType));
				}
    			int analyStatus = client.executeMethod(method);
    			//打印服务器返回的状态
    			System.out.println("服务器分析返回状态：" + method.getStatusLine());
    			//打印服务器返回的数据
    			String returnJson = method.getResponseBodyAsString();
    			System.out.println(returnJson);
    			if (StringUtils.isNotBlank(returnJson)) {
					HashMap resultMap = (HashMap)JSONUtil.deserialize(returnJson);
					if (resultMap != null) {
						if (!resultMap.containsKey("result")) {
							System.out.println("当前项目无叠加图形！");
//							message = "ERROR:"+returnJson;
						}else {
							List<String> objList = getObjectIdListByGeoJson(resultMap.get("result"));
							if (objList != null && objList.size() > 0) {
								return resultMap.get("result").toString();
							}else {
								message = "当前项目无叠加图形！";
							}
							//return resultMap.get("result").toString();
						}
					}
    			}
			}else {
				message = "gis.properties文件没有配置该【"+busiType+"】业务类型的图形参数！";
			}
		}else {
			message = "分析目标源busiType为空！";
		}
		System.out.println(message);
		System.out.println("分析结束！");
		return null;
	}
	
	/**
	 * 根据feature对象获取对应的geojson字符串
	 * @param feature
	 * @return
	 */
	public static String toFeatureJSON(final Object feature) {
		String geoJson = "";
        try {
            FeatureJSON featureJSON = new FeatureJSON(new GeometryJSON(14));
            StringWriter out = new StringWriter();
            if (feature instanceof SimpleFeature) {
                featureJSON.setEncodeFeatureBounds(((SimpleFeature) feature).getBounds() == null ? false : true);
                featureJSON.setEncodeFeatureCRS(((SimpleFeature) feature).getFeatureType().
                        getCoordinateReferenceSystem() == null ? false : true);
                featureJSON.writeFeature((SimpleFeature) feature, out);
            } else if (feature instanceof FeatureCollection) {
                if (((FeatureCollection) feature).size() > 0) {
                    featureJSON.setEncodeFeatureCollectionBounds(((SimpleFeature) ((FeatureCollection) feature).toArray()[0]).getBounds() == null ? false : true);
                    featureJSON.setEncodeFeatureCollectionCRS(((SimpleFeature) ((FeatureCollection) feature).toArray()[0]).getFeatureType().
                            getCoordinateReferenceSystem() == null ? false : true);
                }
                featureJSON.writeFeatureCollection((FeatureCollection) feature, out);
            }
            geoJson = out.toString();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return geoJson;
    }
	
	/**
	 * 获取Geometry对象的geoJson字符串
	 * @param geometry
	 * @return
	 */
	public static String toGeoJSON(Geometry geometry) {
		String geoJson = "";
        try {
            GeometryJSON geometryJSON = new GeometryJSON(14);
            StringWriter out = new StringWriter();
            geometryJSON.write(geometry, out);
            geoJson = out.toString();
        } catch (Exception e) {
        	e.printStackTrace();
        }
        return geoJson;
    }
	
	/**
	 * 根据图形查询返回json字符串，解析出所有的objectid，返回list集合
	 * @param returnJson
	 * @return
	 * @throws Exception
	 */
	public static List<String> getObjectIdListByReturnJson(String returnJson)throws Exception{
		List<String> objectidList = new ArrayList<String>();
//		returnJson = "{\"result\":{\"type\":\"FeatureCollection\",\"features\":[{\"type\":\"Feature\",\"geometry\":{\"type\":\"LineString\",\"coordinates\":[[102,0],[103,1],[104,0],[105,1]]},\"properties\":{\"prop0\":\"value0\",\"prop1\":0}},{\"type\":\"Feature\",\"geometry\":{\"type\":\"Polygon\",\"coordinates\":[[[100,0],[101,0],[101,1],[100,1],[100,0]]]},\"properties\":{\"prop0\":\"value0\",\"prop1\":{\"this\":\"that\"}}}]}}";
//		returnJson = "{'result':'{\"type\":\"FeatureCollection\",\"bbox\":[0.0,0.0,-1.0,-1.0],\"features\":[{\"type\":\"Feature\",\"properties\":{\"OBJECTID\":337},\"id\":\"Featuref142b8608bc84028dbe542b8608b0001\"}]}'}";
		try {
			HashMap resultMap = (HashMap)JSONUtil.deserialize(returnJson);
			if (resultMap != null) {
				if (resultMap.containsKey("result") && resultMap.get("result") != null) {
					objectidList = getObjectIdListByGeoJson(resultMap.get("result"));
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return objectidList;
	}
	public static List<String> getObjectIdListByGeoJson(Object geoJson)throws Exception{
		List<String> objectidList = new ArrayList<String>();
		try {
			if (geoJson != null && StringUtils.isNotBlank(geoJson.toString())) {
				HashMap geoMap = new HashMap();
				try {
					geoMap = (HashMap)JSONUtil.deserialize(geoJson.toString());
				} catch (Exception e) {
					geoMap = (HashMap)JSONUtil.deserialize(JSONUtil.serialize(geoJson));
				}
				if (geoMap.containsKey("features") && geoMap.get("features") != null) {
					//解析FeatureCollection中的features
					List<HashMap> featureListMap = (List<HashMap>)JSONUtil.deserialize(JSONUtil.serialize(geoMap.get("features")));
					if (featureListMap != null && featureListMap.size() > 0) {
						for (int i = 0; i < featureListMap.size(); i++) {
							//解析FeatureCollection中的features中的单个feature，获取其中的属性数据
							HashMap featureMap = featureListMap.get(i);
							if (featureMap.containsKey("properties") && featureMap.get("properties") != null) {
								HashMap propertyMap = (HashMap)JSONUtil.deserialize(JSONUtil.serialize(featureMap.get("properties")));
								if (propertyMap.containsKey("OBJECTID") && propertyMap.get("OBJECTID") != null && StringUtils.isNotBlank(propertyMap.get("OBJECTID").toString())) {
									objectidList.add(propertyMap.get("OBJECTID").toString());
								}
							}
						}
					}
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return objectidList;
	}
	
	/**
	 * 根据id和业务类型，获取对应的业务数据
	 * @param busiType
	 * @param proid
	 * @return
	 * @throws Exception
	 */
	public static HashMap<String, String> getzhsw(String busiType,String proid)throws Exception{
		HashMap<String, String> zhsw = new HashMap<String, String>();
		try {
			if (StringUtils.isNotBlank(busiType) && StringUtils.isNotBlank(proid)) {
				String busiUrl = PlatformHelper.getLayerPropertyUrl(busiType);
				if (StringUtils.isNotBlank(busiUrl)) {
					busiUrl = PlatformHelper.getServerURL()+busiUrl;
					System.out.println("业务数据获取URL地址：" + busiUrl);
					HttpClient client = new HttpClient();
					PostMethod method = new PostMethod(busiUrl);
					method.addParameter("proid", proid);
					int status = client.executeMethod(method);
					//打印服务器返回的状态
					System.out.println("服务器获取属性数据返回状态：" + method.getStatusLine());
					//打印服务器返回的数据
					String returnJson = method.getResponseBodyAsString();
					System.out.println(returnJson);
					if (StringUtils.isNotBlank(returnJson)) {
						returnJson = java.net.URLDecoder.decode(returnJson,"UTF-8");
						zhsw = (HashMap<String, String>)JSONUtil.deserialize(returnJson);
					}
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		if (zhsw == null) {
			zhsw = new HashMap<String, String>();
		}
		if (StringUtils.isBlank(zhsw.get("DKMC"))) {
			zhsw.put("DKMC","");
		}
		if (StringUtils.isBlank(zhsw.get("DKID"))) {
			zhsw.put("DKID",proid);
		}
		if (StringUtils.isBlank(zhsw.get("XZQDM"))) {
			zhsw.put("XZQDM",PlatformHelper.getConfigXzqdm());
		}
		return zhsw;
	}
	
	/**
     * 解析坐标串文件
     *界址点序号，界址点号，X，Y，边长，类型，多边形环号
     * @param coordFilePath 坐标文件路径
     * @return 返回类型为List，格式为标准格式的字符串的List，即list中的每一个坐标串string的格式为：界址点序号，界址点号，X，Y，边长，类型，多边形环号
     * @throws IOException 
     */
	public static List parseShapeZipFile(String coordFilePath, String proId, String busiType, String check,HashMap<String, String> zhsw) throws IOException {
        List resultList = null;
        try {
        	String message = "";
    		if (StringUtils.isNotBlank(busiType) && StringUtils.isNotBlank(proId)) {
    			String layerName = PlatformHelper.getLayerName(busiType);
    			if (StringUtils.isNotBlank(layerName)) {
    				GeometryOperationUtil.delGeometry(proId, busiType);
    				if (zhsw == null) {
    					zhsw = getzhsw(busiType, proId);
					}else {
						zhsw.putAll(getzhsw(busiType, proId));
					}
        			String url = PlatformHelper.getOmpURL()+"/geometryService/shp/file/upload";  
        			HttpClient client = new HttpClient();
        			PostMethod method = new PostMethod(url);
        			method.addParameter("properties", JSONUtil.serialize(zhsw));
        			method.addParameter("layerName", layerName);
        			method.addParameter("file", coordFilePath);
        			if (!(StringUtils.isNotBlank(check) && StringUtils.equals(check, "false"))) {
        				check = "true";
    				}else {
    					check = "false";
    				}
        			method.addParameter("check", check);
        			if (StringUtils.isNotBlank(PlatformHelper.getLayerDatasource(busiType))) {
    					method.addParameter("dataSource",PlatformHelper.getLayerDatasource(busiType));
    				}
        			client.getParams().setParameter(HttpMethodParams.HTTP_CONTENT_CHARSET,"utf-8");
        			int status = client.executeMethod(method);
        			//打印服务器返回的状态
        			System.out.println("服务器导入shp返回状态：" + method.getStatusLine());
        			//打印服务器返回的数据
        			String returnJson = method.getResponseBodyAsString();
        			System.out.println(returnJson);
        			if (StringUtils.isNotBlank(returnJson)) {
    					HashMap resultMap = (HashMap)JSONUtil.deserialize(returnJson);
    					if (resultMap != null) {
    						if (!resultMap.containsKey("result")) {
    							System.out.println("当前项目创建图形失败！");
    							message = returnJson;
    						}else {
    							List<String> objList = GeometryOperationUtil.getObjectIdListByGeoJson(resultMap.get("result"));
								if (objList != null && objList.size() > 0) {
									return new ArrayList();
								}else {
									message = "当前项目尚未创建图形！";
								}
//								FeatureJSON queryJson = new FeatureJSON();
//								FeatureCollection queryCollection = queryJson.readFeatureCollection(resultMap.get("result"));
//								if (queryCollection != null && queryCollection.size() > 0) {
//									//处理默认值，默认赋值下面数据中的字段
//									FeatureIterator queryIterator = queryCollection.features();
//									int index = 0;
//									while (queryIterator.hasNext()) {
//							        	Feature feature = queryIterator.next();
//							        	String geoJson = GeometryOperationUtil.toFeatureJSON(feature);
//							        	
//									}
//								}
    		                    message = "true";
    						}
    					}
        			}
    			}else {
    				message = "gis.properties文件没有配置该【"+busiType+"】业务类型的图形参数！";
    			}
    		}else {
    			message = "构建平台没有配置当前工作流对应的busiType！";
    		}
    		System.out.println(message);
        } catch (Exception ex) {
            ex.printStackTrace();
        }
        return resultList;
    }
	
	/**
     * 解析坐标串文件
     *界址点序号，界址点号，X，Y，边长，类型，多边形环号
     * @param coordFilePath 坐标文件路径
     * @return 返回类型为List，格式为标准格式的字符串的List，即list中的每一个坐标串string的格式为：界址点序号，界址点号，X，Y，边长，类型，多边形环号
     * @throws IOException 
     */
	public static List parseCadFile(String coordFilePath, String proId, String busiType, String check,HashMap<String, String> zhsw) throws IOException {
        List resultList = null;
        try {
        	String message = "";
    		if (StringUtils.isNotBlank(busiType) && StringUtils.isNotBlank(proId)) {
    			String layerName = PlatformHelper.getLayerName(busiType);
    			if (StringUtils.isNotBlank(layerName)) {
    				GeometryOperationUtil.delGeometry(proId, busiType);
    				if (zhsw == null) {
    					zhsw = getzhsw(busiType, proId);
					}else {
						zhsw.putAll(getzhsw(busiType, proId));
					}
    				
    				String cadJson = getCadJsonFromCadFile(coordFilePath);
    				String geometry = getGeoJsonByCadJson(cadJson, zhsw);
    				
    				System.out.println("========================================");
    				if (StringUtils.isNotBlank(geometry)) {
    					try {
    						message = insertGeometry(proId,busiType,check,geometry);
    	    				if (StringUtils.isNotBlank(message) && StringUtils.equalsIgnoreCase(message, "true")) {
		    					message = "操作成功！";
		    					return new ArrayList();
							}
    						
//                            FeatureJSON queryJson = new FeatureJSON();
//                            System.out.println(geojson.toString());
//                            FeatureCollection queryCollection = queryJson.readFeatureCollection(geojson.toString());
//                            String collectionJson = toFeatureJSON(queryCollection);
//                            
//                            FeatureIterator queryIterator = queryCollection.features();
//                            System.out.println("========================================");
//                            while (queryIterator.hasNext()) {
//                                SimpleFeature feature = (SimpleFeature)queryIterator.next();
//                                Geometry geometry = (Geometry) feature.getDefaultGeometry();
//                                String featureJson = toGeoJSON(geometry);//toFeatureJSON(feature);
//                                System.out.println(featureJson);
//                                System.out.println("========================================");
//                                HashMap featureMap = (HashMap)JSONUtil.deserialize(featureJson);
//                                featureMap.put("properties", zhsw);
//                                System.out.println("========================================");
//        						System.out.println(JSONUtil.serialize(featureMap));
//        						message = insertGeometry(proId,busiType,check,JSONUtil.serialize(featureMap));
//        	    				if (StringUtils.isNotBlank(message) && StringUtils.equalsIgnoreCase(message, "true")) {
//        	    					message = "操作成功！";
//        	    					return new ArrayList();
//        						}
////                                Geometry geometry = (Geometry) feature.getDefaultGeometryProperty();
////                                System.out.println(JSON.toJSONString(geometry.getBoundary()));
////                                System.out.println(JSON.toJSONString(geometry));
////                                BoundingBox box = feature.getBounds();
//                            }
//    						List<HashMap> geoList = (List<HashMap>)JSONUtil.deserialize(JSONUtil.serialize(geojson));
//        					if (geoList != null && geoList.size() > 0) {
//        						System.out.println(JSONUtil.serialize(geoList));
//        						HashMap featureMap = geoList.get(0);
//        						System.out.println("========================================");
//            					if (featureMap != null && featureMap.keySet().size() > 0) {
//            						System.out.println(JSONUtil.serialize(featureMap));
//            						System.out.println("========================================");
//            						featureMap.put("properties", zhsw);
//            						System.out.println(JSONUtil.serialize(featureMap));
//            						message = insertGeometry(proId,busiType,check,JSONUtil.serialize(featureMap));
//            	    				if (StringUtils.isNotBlank(message) && StringUtils.equalsIgnoreCase(message, "true")) {
//            	    					message = "操作成功！";
//            	    					return new ArrayList();
//            						}
//        						}
//    						}
    					} catch (Exception e) {
    						e.printStackTrace();
    					}
					}
    			}else {
    				message = "gis.properties文件没有配置该【"+busiType+"】业务类型的图形参数！";
    			}
    		}else {
    			message = "构建平台没有配置当前工作流对应的busiType！";
    		}
    		System.out.println(message);
        } catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }
	
	/**
	 * 调用gp服务，获取cad文件的图形信息，返回geojson格式
	 * @param coordFilePath
	 * @return
	 * @throws IOException
	 */
	public static String getCadJsonFromCadFile(String coordFilePath) throws IOException {
		try {
			String gpUrl = AppConfig.getProperty("gis.cadimport.gp.url");
        	if (StringUtils.isNotBlank(gpUrl)) {
        		HttpClient client = new HttpClient();
                PostMethod method = new PostMethod(gpUrl);
                method.addParameter("input_cad_file", coordFilePath);
                method.addParameter("f", "pjson");
                int status = client.executeMethod(method);
                //打印服务器返回的状态
                System.out.println("服务器查询返回的状态" + method.getStatusLine());
                //打印服务器返回的数据
                String returnJson = method.getResponseBodyAsString();
                System.out.println(returnJson);
                if (StringUtils.isNotBlank(returnJson)) {
                	return returnJson;
//                	HashMap resultMap = (HashMap)JSON.parseObject(returnJson, HashMap.class);
////					HashMap resultMap = (HashMap)JSONUtil.deserialize(returnJson);
//					if (resultMap != null) {
//						if (resultMap.containsKey("results")) {
//							return resultMap.get("results");
//						}
//					}
    			}
        	}else {
				System.out.println("请检查gis.properties是否配置cad导入的GP服务地址：gis.cadimport.gp.url");
			}
        } catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }
	
	public static String getGeoJsonByCadJson(String cadJson,HashMap paramMap)throws Exception{
		String geoJson = "";
		try {
			Map resultMap = JSON.parseObject(cadJson, Map.class);
	        List<Map> results = (List<Map>) resultMap.get("results");
	        List geometries = new ArrayList();
	        for (Map result : results) {
	            geometries.addAll((List) result.get("value"));
	        }
	        System.out.println("geometries:" + geometries.size());

	        for (int i = 0; i < geometries.size(); i++) {
	            Map geometry = (Map) geometries.get(i);
	            List<Map> featureMapList = (List<Map>) geometry.get("features");
	            LinkedHashMap featureCollectionMap = new LinkedHashMap();
	            featureCollectionMap.put("type","FeatureCollection");
	            List<LinkedHashMap> linkedHashMapList = new ArrayList();
	            for (Map featureMap : featureMapList) {
	                Map geo = (Map) featureMap.get("geometry");
	                List rings = (List) geo.get("rings");

	                LinkedHashMap polygon = new LinkedHashMap();
	                polygon.put("type","Polygon");
	                polygon.put("coordinates",rings);

	                LinkedHashMap simpleFeature = new LinkedHashMap();
	                simpleFeature.put("type","Feature");
	                simpleFeature.put("geometry",polygon);
	                
	                Map propertyMap = (Map)featureMap.get("attributes");
	                propertyMap.putAll(paramMap);
	                
	                simpleFeature.put("properties",propertyMap);
	                linkedHashMapList.add(simpleFeature);
	            }
	            assert linkedHashMapList.size() > 0;
	            featureCollectionMap.put("features", linkedHashMapList);
	            geoJson = JSON.toJSONString(featureCollectionMap);
	            System.out.println(JSON.toJSONString(featureCollectionMap));
	            FeatureJSON queryJson = new FeatureJSON();
	            FeatureCollection queryCollection = queryJson.readFeatureCollection(JSON.toJSONString(featureCollectionMap));
	            System.out.println(queryCollection.size());
	        }
        } catch (Exception ex) {
            ex.printStackTrace();
        }
        return geoJson;
	}
}

