package cn.gtmap.zhsw.utils;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.*;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.multipart.MultiPartRequestWrapper;

import com.alibaba.fastjson.JSON;
import com.gtis.config.AppConfig;
import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.model.Space;
import com.gtis.fileCenter.service.FileService;
import com.gtis.fileCenter.service.NodeService;
import com.gtis.spring.Container;

import de.innosystec.unrar.Archive;
import de.innosystec.unrar.rarfile.FileHeader;

/**
 * Created with IntelliJ IDEA.
 * User: janeshen
 * Date: 13-9-26
 * Time: 上午11:04
 * To change this template use File | Settings | File Templates.
 */
public class FileUtil {
    public static boolean zip(String zipFileName, File inputFile) throws Exception{
        boolean result = false;
        ZipArchiveOutputStream out = null;
        try {
            out = new ZipArchiveOutputStream(new FileOutputStream(zipFileName));
            out.setEncoding("GBK");
            zip(out, inputFile, "");
            result = true;
        } catch (Exception ex) {
            throw ex;
        } finally {
            if (out != null) {
                try {
                    out.close();
                } catch (Exception ex) {
                    throw ex;
                }

            }
        }
        return result;
    }

    private static void zip(ZipArchiveOutputStream out, File f, String base) throws Exception {
        if (f.isDirectory()) {
            File[] fl = f.listFiles();
            out.putArchiveEntry(new ZipArchiveEntry(base + "/"));
            out.closeArchiveEntry();
            base = base.length() == 0 ? "" : base + "/";
            for (int i = 0; i < fl.length; i++) {
                zip(out, fl[i], base + fl[i].getName());
            }
        } else {
            out.putArchiveEntry(new ZipArchiveEntry(base));
            FileInputStream in = null;
            try {
                in = new FileInputStream(f);
                IOUtils.copy(in,out);
                out.closeArchiveEntry();
            } catch (Exception ex) {
                throw ex;
            } finally {
                if (in != null)
                    in.close();
            }
        }
    }
    
    /**
	 * 根据原始rar路径，解压到指定文件夹下.
	 * 
	 * @param srcRarPath
	 *            原始rar路径
	 * @param dstDirectoryPath
	 *            解压到的文件夹
	 */
	public static String unRarFile(String srcRarPath, String dstDirectoryPath) {
		String dirName = null;
		// if (!srcRarPath.toLowerCase().endsWith(".rar")) {
		// System.out.println("非rar文件！");
		// return null;
		// }
		File dstDiretory = new File(dstDirectoryPath);
		if (!dstDiretory.exists()) { // 目标目录不存在时，创建该文件夹
			dstDiretory.mkdirs();
		}
		Archive a = null;
		try {
			a = new Archive(new File(srcRarPath));
			if (a != null) {
				// a.getMainHeader().print(); // 打印文件信息.
				FileHeader fh = a.nextFileHeader();
				while (fh != null) {
					if (fh.isDirectory()) { // 文件夹
						String dirFullPath = "";
						String dir = "";
						if (fh.getFileNameW() == null
								|| fh.getFileNameW().equals("")) {
							dirFullPath = dstDirectoryPath
									+ fh.getFileNameString();
							dir = fh.getFileNameString();
						} else {
							dirFullPath = dstDirectoryPath + fh.getFileNameW();
							dir = fh.getFileNameW();
						}
						if (dirFullPath != null && !dirFullPath.equals("")) {
							System.out.println(dirFullPath);
							File fol = new File(dirFullPath);
							fol.mkdirs();
						}
						if (dirName == null || dirName.equals("")) {
							dirName = dir;
						}
					} else { // 文件
						String fileFullPath = "";
						if (fh.getFileNameW() == null
								|| fh.getFileNameW().equals("")) {
							fileFullPath = dstDirectoryPath
									+ fh.getFileNameString().trim();
						} else {
							fileFullPath = dstDirectoryPath
									+ fh.getFileNameW().trim();
						}
						if (fileFullPath != null && !fileFullPath.equals("")) {
							// System.out.println(fileFullPath);
							File out = new File(fileFullPath);
							try {// 之所以这么写try，是因为万一这里面有了异常，不影响继续解压.
								if (!out.exists()) {
									if (!out.getParentFile().exists()) {// 相对路径可能多级，可能需要创建父目录.
										out.getParentFile().mkdirs();
									}
									out.createNewFile();
								}
								FileOutputStream os = new FileOutputStream(out);
								a.extractFile(fh, os);
								os.close();
							} catch (Exception ex) {
								ex.printStackTrace();
							}
						}
					}
					fh = a.nextFileHeader();
				}
				a.close();
			}
			if (dirName == null) {
				dirName = "";
			}
		} catch (Exception e) {
			e.printStackTrace();
			dirName = null;
		}
		if (dirName != null) {
			dirName = dirName.replace("\\", "/");
		}
		System.out.println(dirName);
		return dirName;
	}

	/**
	 * 解压zip或者rar包的内容到指定的目录下，可以处理其文件夹下包含子文件夹的情况
	 * 
	 * @param zipFilename 要解压的zip或者rar包文件
	 * @param unzipDir 解压后存放的目录
	 */
	public static synchronized String unzip(String zipFilename, String unzipDir)
			throws IOException {
		File srcFile = new File(zipFilename);
		return unzip(srcFile, unzipDir);
	}
	
	/**
	 * 解压zip或者rar包的内容到指定的目录下，可以处理其文件夹下包含子文件夹的情况
	 * 
	 * @param zipFilename 要解压的zip或者rar包文件
	 * @param unzipDir 解压后存放的目录
	 */
	public static synchronized String unzip(File srcfile, String unzipDir)
			throws IOException {
		boolean flag = false;
		String dirName = null;
		try {
			File outFile = new File(unzipDir);
			if (!outFile.exists()) {
				outFile.mkdirs();
			}

			ZipFile zipFile = new ZipFile(srcfile, "GBK");
			Enumeration en = zipFile.getEntries();
			ZipArchiveEntry zipEntry = null;
			while (en.hasMoreElements()) {
				zipEntry = (ZipArchiveEntry) en.nextElement();
				if (zipEntry.isDirectory()) {
					String tempDirName = "";
					tempDirName = zipEntry.getName();
					tempDirName = java.net.URLDecoder.decode(tempDirName,
							"utf-8");
					// System.out.println(dirName);
					tempDirName = tempDirName.substring(0,
							tempDirName.length() - 1);
					File f = new File(outFile.getPath() + File.separator
							+ tempDirName);
					f.mkdirs();
					if (dirName == null || dirName.equals("")) {
						dirName = tempDirName;
					}
				} else {
					// unzip file
					String strFilePath = outFile.getPath() + File.separator
							+ zipEntry.getName();
					File f = new File(strFilePath);
					// the codes remedified by can_do on 2010-07-02 =begin=
					// /////begin/////
					// 判断文件不存在的话，就创建该文件所在文件夹的目录
					if (!f.exists()) {
						String[] arrFolderName = zipEntry.getName().split("/");
						String strRealFolder = "";
						for (int i = 0; i < (arrFolderName.length - 1); i++) {
							strRealFolder += arrFolderName[i] + File.separator;
						}
						strRealFolder = outFile.getPath() + File.separator
								+ strRealFolder;
						File tempDir = new File(strRealFolder);
						// 此处使用.mkdirs()方法，而不能用.mkdir()
						tempDir.mkdirs();
					}
					// /////end///
					// the codes remedified by can_do on 2010-07-02 =end=
					f.createNewFile();
					InputStream in = zipFile.getInputStream(zipEntry);
					FileOutputStream out = new FileOutputStream(f);
					try {
						int c;
						byte[] by = new byte[1024];
						while ((c = in.read(by)) != -1) {
							out.write(by, 0, c);
						}
						// out.flush();
					} catch (IOException e) {
						throw e;
					} finally {
						out.close();
						in.close();
					}
					if (dirName == null || dirName.equals("")) {
						dirName = strFilePath;
					}
				}
			}
			flag = true;
			if (dirName == null) {
				dirName = "";
			}
		} catch (Exception e) {
			System.out.println(e.getMessage() + "解压临时文件失败！");
			dirName = null;
		}
		return dirName;
	}

    /**
     * 删除目录（文件夹）以及目录下的文件
     *
     * @param sPath 被删除目录的文件路径
     * @return 目录删除成功返回true，否则返回false
     */
    public static boolean deleteDirectory(String sPath) throws Exception{
        //如果sPath不以文件分隔符结尾，自动添加文件分隔符
        if (!sPath.endsWith(File.separator)) {
            sPath = sPath + File.separator;
        }
        File dirFile = new File(sPath);
        //如果dir对应的文件不存在，或者不是一个目录，则退出
        if (!dirFile.exists() || !dirFile.isDirectory()) {
            return false;
        }
        boolean flag = false;
        //删除文件夹下的所有文件(包括子目录)
        File[] files = dirFile.listFiles();
        for (int i = 0; i < files.length; i++) {
            //删除子文件
            if (files[i].isFile()) {
                flag = deleteFile(files[i].getAbsolutePath());
                if (!flag) break;
            } //删除子目录
            else {
                flag = deleteDirectory(files[i].getAbsolutePath());
                if (!flag) break;
            }
        }
        if (!flag) return false;
        //删除当前目录
        flag = false;
        if (dirFile.delete()) {
            flag = true;
        }

        return flag;
    }

    /**
     * 删除单个文件
     *
     * @param sPath 被删除文件的文件名
     * @return 单个文件删除成功返回true，否则返回false
     */
    public static boolean deleteFile(String sPath) throws Exception{
        boolean flag = false;
        File file = new File(sPath);
        // 路径为文件且不为空则进行删除
        if (file.isFile() && file.exists()) {
            file.delete();
            flag = true;
        }
        return flag;
    }
    /**
	 * 复制单个文件
	 * 
	 * @param oldPath
	 *            String 原文件路径 如：c:/fqf.txt
	 * @param newPath
	 *            String 复制后路径 如：f:/fqf.txt
	 * @return boolean
	 */
	public static boolean copyFile(String oldPath, String newPath) {
		boolean isok = false;
		try {
			File file = new File(newPath);
			if (!file.exists()) {// 如果目标路径不存在
				createFiles(newPath);
			}
			int byteread = 0;
			File oldfile = new File(oldPath);
			if (oldfile.exists()) { // 文件存在时
				InputStream inStream = new FileInputStream(oldfile); // 读入原文件
				FileOutputStream fs = new FileOutputStream(file);
				byte[] buffer = new byte[1444];
				while ((byteread = inStream.read(buffer)) != -1) {
					fs.write(buffer, 0, byteread);
				}
				inStream.close();
				isok = true;
			}
		} catch (Exception e) {
			System.out.println("复制单个文件操作出错");
			e.printStackTrace();
		}
		return isok;
	}

	/**
	 * 非根路径中创建文件，即多层文件夹是 前提是: path必须一个正确的路径 拷贝单个文件
	 * 
	 * @param path 文件
	 */
	public static Boolean createFiles(String path) {
		Boolean flag = false;
		File file = null;
		if (!path.equals("") || path != null) {
			file = new File(path);
			if (!file.exists()) {
				if (file.isDirectory()) {
					file.mkdirs();
				}else {
					// 创建目录
					File fileDir = new File(file.getParent());
					fileDir.mkdirs();
					System.out.println("上层文件夹： " + fileDir);
					try {
						flag = file.createNewFile();// 在已有文件路径上直接创建文件
						System.out.println("文件名称：" + file);
					} catch (IOException e) {
						System.out.println("创建文件失败：" + e.getLocalizedMessage());
						e.printStackTrace();
					}
				}
			} else {
				System.out.println("【" + path + "】：" + "该文件已经存在");
			}
		}
		return flag;
	}
	/**
	 * 根据路径删除指定的目录或文件，无论存在与否
	 * 
	 * @param sPath
	 *            要删除的目录或文件
	 * @return 删除成功返回 true，否则返回 false。
	 */
	public static boolean DeleteFolder(String sPath)throws Exception{
		boolean flag = false;
		File file = new File(sPath);
		// 判断目录或文件是否存在
		if (!file.exists()) { // 不存在返回 false
			return flag;
		} else {
			// 判断是否为文件
			if (file.isFile()) { // 为文件时调用删除文件方法
				return deleteFile(sPath);
			} else { // 为目录时调用删除目录方法
				return deleteDirectory(sPath);
			}
		}
	}
	/**
	 * 非根路径中创建文件夹是
	 * @param dirPath 文件夹路径
	 * @param isreplace 是否覆盖
	 * @return
	 */
	public static Boolean createDirectory(String dirPath,boolean isreplace)throws Exception {
		Boolean flag = false;
		if (StringUtils.isNotBlank(dirPath)) {
			File file = new File(dirPath);
			if (file.exists()) {
				if (isreplace) {
					FileUtil.DeleteFolder(dirPath);
					file.mkdirs();
				}
			} else {
				file.mkdirs();
			}
		}
		return flag;
	}
	/**
	 * 遍历文件夹，找出对应名字的文件全路径地址
	 * @param file
	 * @param fileName
	 * @return
	 */
	public static String findFileByName(String dirName,String fileName){
		//传入的文件夹是否存在
		File file = new File(dirName);
		return findFileByName(file,fileName);
	}
	/**
	 * 遍历文件夹，找出对应名字的文件全路径地址
	 * @param file
	 * @param fileName
	 * @return
	 */
	public static String findFileByName(File dir,String fileName){
		String filePath = "";
		//传入的文件夹是否存在
		if (dir != null && dir.exists() && dir.isDirectory()) {
			//通过File类的listFiles方法获取文件夹中所有文件的全路径
			File[] files = dir.listFiles();
			if (files != null && files.length > 0) {
				for (int i = 0; i < files.length; i++) {
					if (files[i].isDirectory()) {
						filePath = findFileByName(files[i],fileName);
					}else {
						if (files[i].getName().equalsIgnoreCase(fileName)) {
							//输出全路径
							filePath = files[i].getAbsolutePath();
						}
					}
					if (StringUtils.isNotBlank(filePath)) {
						break;
					}
				}
			}
		}
		return filePath;
	}
	public static void createFileCenterNodeByFolder(String proID,String dirName,String spacecode){
		if (StringUtils.isNotBlank(dirName)) {
			File dirFile = new File(dirName);
			if (dirFile != null && dirFile.exists()) {
				if (dirFile.isDirectory()) {
					NodeService nodeService = (NodeService)Container.getBean("NodeService");
					FileService fileService = (FileService)Container.getBean("FileService");
					//首先创建该proid下的一个文件夹节点
					Space space = nodeService.getWorkSpace(spacecode, true);
					Node node = nodeService.getNode(space.getId(), proID, true);
					Integer nodeId=node.getId();
					String token=nodeService.getToken(node);
					//如果已经存在该电子包数据，则删除
					Node nodeChild = nodeService.getNode(nodeId, dirFile.getName(), false);
					if (nodeChild != null) {
						nodeService.remove(nodeChild.getId());
					}
//					Node dirNode = getOrCreateNode(nodeId,dirFile.getName(),nodeService);
					//开始遍历文件夹结构，逐层创建文件中心节点
					createFileCenterNodeByFile(dirFile,node,nodeService,fileService);
				}
			}
		}
	}
	/**
	 * 遍历文件夹，找出对应名字的文件全路径地址
	 * @param file
	 * @param fileName
	 * @return
	 */
	public static void createFileCenterNodeByFile(File file,Node node,NodeService nodeService,FileService fileService){
		//传入的文件夹是否存在
		if (file != null && file.exists()) {
			try {
				//创建文件夹/文件节点
				Node fileNode = getOrCreateNode(node.getId(),file.getName(),nodeService);
				System.out.println(fileNode.getName());
				if (file.isDirectory()) {
					//通过File类的listFiles方法获取文件夹中所有文件的全路径
					File[] files = file.listFiles();
					if (files != null && files.length > 0) {
						for (int i = 0; i < files.length; i++) {
							if (files[i].isDirectory()) {
								createFileCenterNodeByFile(files[i],fileNode,nodeService,fileService);
							}else if (files[i].isFile()) {
								//上传附件
								fileService.uploadFile(files[i], fileNode.getId(),null,null,true,false);
							}
						}
					}
				}else if (file.isFile()) {
					//上传附件
					fileService.uploadFile(file, fileNode.getId(),null,null,true,false);
				}
			} catch (Exception e) {
				System.out.println(e.getMessage());
			}
		}
	}
	/**
	 * 根据父节点nodeid生成名称为fName的子文件节点
	 * @param nid
	 * @param fName
	 * @return
	 */
	public static Node getOrCreateNode(Integer nid,String fName,NodeService nodeService){
		Node nodeChild = null;
		try {
			nodeChild = nodeService.getNode(nid, fName, true);//getChildNode(nid, fName);
		} catch (Exception e) {
			nodeChild = nodeService.createNode(nid,fName);
			nodeChild.setViewName(fName);
			nodeChild.setName(fName);
			nodeChild.setDescription(fName);
			nodeService.save(nodeChild);
		}
		if (nodeChild == null) {
			nodeChild = nodeService.getNode(nid,fName, true);
			nodeChild.setViewName(fName);
			nodeChild.setName(fName);
			nodeChild.setDescription(fName);
			nodeService.save(nodeChild);
		}
		return nodeChild;
	}
	
	/**
	 * 获取路径中某种格式的文件列表
	 * 或者获取制定名字的文件
	 * @param dirPath
	 * @param type
	 * @param name
	 * @return
	 * @throws Exception
	 */
	public static List<String> getFileName(String dirPath,String type,String name)throws Exception{
		List<String> strList = new ArrayList<String>();
		File dirFile = new File(dirPath);
		// 如果dir对应的文件不存在，或者不是一个目录，则退出
		if (!dirFile.exists() || !dirFile.isDirectory()) {
			return null;
		}
		type = type.toLowerCase();
		File[] files = dirFile.listFiles();
		for (int i = 0; i < files.length; i++) {
			if (files[i].isFile()) {
				//System.out.println("--------------" + files[i].getName() + "--------------");
				String filename = files[i].getAbsolutePath();
				int point = filename.lastIndexOf(".") + 1;
				String filetype = filename.substring(point,filename.length());
				filetype = filetype.toLowerCase();
				//System.out.println("--------------" + filetype + "--------------");
				if (filetype != null && StringUtils.indexOf(type, filetype) > -1) {
					//System.out.println("--------------" + shpFileName + "--------------");
					if (StringUtils.isNotBlank(name)) {
						if (filename.indexOf(name) > -1) {
							strList = new ArrayList<String>();
							strList.add(filename);
							break;
						}
					}
					strList.add(filename);
				}
			}else if (files[i].isDirectory()) {
				continue;
			}
		}
		return strList;
	}
	/**
	 * 获取路径中某种格式的文件列表
	 * 或者获取制定名字的文件
	 * @param dirPath
	 * @param type
	 * @param name
	 * @return
	 * @throws Exception
	 */
	public static List<HashMap<String, String>> getFileMapList(String dirPath,String type,String name)throws Exception{
		List<HashMap<String, String>> strList = new ArrayList<HashMap<String, String>>();
		File dirFile = new File(dirPath);
		// 如果dir对应的文件不存在，或者不是一个目录，则退出
		if (!dirFile.exists() || !dirFile.isDirectory()) {
			return null;
		}
		type = type.toLowerCase();
		File[] files = dirFile.listFiles();
		for (int i = 0; i < files.length; i++) {
			if (files[i].isFile()) {
				HashMap<String, String> fileMap = new HashMap<String, String>();
				//System.out.println("--------------" + files[i].getName() + "--------------");
				String filename = files[i].getName();//.getAbsolutePath();
				String filepath = files[i].getAbsolutePath();//.getAbsolutePath();
				int point = filename.lastIndexOf(".") + 1;
				String filetype = filename.substring(point,filename.length());
				filename = filename.substring(0,point-1);
				filetype = filetype.toLowerCase();
				//System.out.println("--------------" + filetype + "--------------");
				if (filetype != null && StringUtils.indexOf(type, filetype) > -1) {
					//System.out.println("--------------" + shpFileName + "--------------");
					fileMap.put("filename", filename);
					fileMap.put("filetype", filetype);
					fileMap.put("filepath", filepath);
					if (StringUtils.isNotBlank(name)) {
						if (filename.indexOf(name) > -1) {
							strList = new ArrayList<HashMap<String, String>>();
							strList.add(fileMap);
							break;
						}
					}
					strList.add(fileMap);
				}
			}else if (files[i].isDirectory()) {
				continue;
			}
		}
		return strList;
	}
	/**
	 * 创建文件中心节点
	 * @param fileId 主键id
	 * @param spacecode 工作空间
	 * @return 返回nodeId和token
	 * @throws Exception
	 */
	public static Integer createFileCenterFolder(String proID,String foldName) throws Exception{
		Space space = null;
		Integer nodeId = null;
		try {
			NodeService nodeService = (NodeService)Container.getBean("NodeService");
			space = nodeService.getWorkSpace(PlatformHelper.WORK_FLOW_STUFF, true);
			Node prjNode = nodeService.getNode(space.getId(), proID, true);
			Integer proNodeid=prjNode.getId();
//			token=nodeService.getToken(prjNode);
			Node cityNode = FileUtil.getOrCreateNode(proNodeid,foldName,nodeService);
			nodeId = cityNode.getId();
		} catch (Exception e) {
			System.out.println("文件中心异常："+e.getMessage());
		}
		return nodeId;
	}
	
	/**
	 * 获取增量包XML文件
	 * @param zipDir
	 * @return
	 */
	public static String getXmlFileName(String dir,String fileName){
		String filename = "";
		File dirFile = new File(dir);
		// 如果dir对应的文件不存在，或者不是一个目录，则退出
		if (!dirFile.exists() || !dirFile.isDirectory()) {
			return null;
		}
		boolean flag = false;
		File[] files = dirFile.listFiles();
		for (int i = 0; i < files.length; i++) {
			if (files[i].isFile()) {
				//System.out.println("--------------" + files[i].getName() + "--------------");
				filename = files[i].getName();
				if (StringUtils.equals(fileName, filename)) {
					flag = true;
					break;
				}
			}
		}
		if (!flag) {
			filename = "";
		}
		return filename;
	}
	/**
	 * 获取增量包XML文件
	 * @param zipDir
	 * @return
	 */
	public static String getXmlFileName(String dir){
		String filename = "";
		File dirFile = new File(dir);
		// 如果dir对应的文件不存在，或者不是一个目录，则退出
		if (!dirFile.exists() || !dirFile.isDirectory()) {
			return null;
		}
		boolean flag = false;
		File[] files = dirFile.listFiles();
		for (int i = 0; i < files.length; i++) {
			if (files[i].isFile()) {
				//System.out.println("--------------" + files[i].getName() + "--------------");
				filename = files[i].getAbsolutePath();
				int point = filename.lastIndexOf(".") + 1;
				String filetype = filename.substring(point,filename.length());
				//System.out.println("--------------" + filetype + "--------------");
				if (filetype != null && filetype.equalsIgnoreCase("xml") ) {
					//System.out.println("--------------" + shpFileName + "--------------");
					flag = true;
					break;
				}
			}
		}
		if (!flag) {
			filename = "";
		}
		return filename;
	}
	
	public static String getEgovHomePath(String path){
		String dirPath = "";
		try {
			dirPath = AppConfig.getConfHome()+"/"+path+"/";
			if (dirPath.startsWith("zip")) { // 当class文件在war中时，返回"zip:D:/ ..."样的路径
				dirPath =dirPath.substring(4);
			} else if (dirPath.startsWith("file")) { // 当class文件在class文件中时，返回"file:/F:/ ..."样的路径 
				dirPath = dirPath.substring(6);
			}else if(dirPath.startsWith("jar")){ // 当class文件在jar文件中时，返回"jar:file:/F:/ ..."样的路径
				dirPath = dirPath.substring(10);
			}
		} catch (Exception e) {
			// TODO: handle exception
		}
		return dirPath;
	}
	/**
	 * file 转换成byte数组
	 * @param f
	 * @return
	 */
	public static byte[] getBytesFromFile(File f) {
		if (f == null) {
			return null;
		}
		try {
			FileInputStream stream = new FileInputStream(f);
			ByteArrayOutputStream out = new ByteArrayOutputStream(1000);
			byte[] b = new byte[1000];
			int n;
			while ((n = stream.read(b)) != -1)
				out.write(b, 0, n);
			stream.close();
			out.close();
			return out.toByteArray();
		} catch (IOException e) {
		}
		return null;
	}
	
	public static boolean buildFr3File(String fileDir,String filename,HttpServletRequest request) throws Exception {
		try {
			if (StringUtils.isNotBlank(filename)) {
				String tempFr3Path = PublicUtil.getProjectPath(request)+"\\common\\print\\"+fileDir;
				File tempFr3File = new File(tempFr3Path+"\\"+filename);
				if (tempFr3File.exists()) {
					return true;
				}else {
					String dirPath = FileUtil.getEgovHomePath("zhsw/print");
					File fr3File = new File(dirPath+"/"+fileDir+"/"+filename);
					if (!fr3File.exists()) {
						//去工程里面读取打印模板
						//\webapps\zhsw\WEB-INF\classes\META-INF\conf\zhsw\print
						dirPath = PublicUtil.getProjectPath(request)+"WEB-INF\\classes\\META-INF\\conf\\zhsw\\print";
						fr3File = new File(dirPath+"/"+fileDir+"/"+filename);
					}
					if (fr3File.exists()) {
						File tmpDir = new File(tempFr3Path);
						if (!tmpDir.exists()) {
							FileUtil.createDirectory(tempFr3Path, false);
						}
						File tmpFile = new File(tempFr3Path+"\\"+filename);
						if (!tmpFile.exists()) {
							FileUtil.copyFile(dirPath+"/"+fileDir+"/"+filename, tempFr3Path+"\\"+filename);
						}
						tmpFile = new File(tempFr3Path+"\\"+filename);
						if (tmpFile.exists()) {
							return true;
						}
					}
				}
			}else {
				System.out.println("打印模板为空！");
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return false;
	}
	
	/**
	 * 将cad文件拷贝一份到common/temp路径下，返回文件名称
	 * @param curFilePath
	 * @param filename
	 * @param request
	 * @return
	 * @throws Exception
	 */
	public static String copyCadFile(String curFilePath,String filename,HttpServletRequest request) throws Exception {
		try {
			if (StringUtils.isNotBlank(curFilePath)) {
				File file = new File(curFilePath);
				if (file.exists()) {
					
					String tempFr3Path = PublicUtil.getProjectPath(request)+"\\common\\temp";
					File tmpDir = new File(tempFr3Path);
					if (!tmpDir.exists()) {
						FileUtil.createDirectory(tempFr3Path, false);
					}
					if (StringUtils.isBlank(filename)) {
						filename = file.getName();
					}
					File tmpFile = new File(tempFr3Path+"\\"+filename);
					if (!tmpFile.exists()) {
						FileUtil.copyFile(curFilePath, tempFr3Path+"\\"+filename);
						return filename;
					}
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}
	
	/**
     * 实现数据文件上传 返回 boolean 类型数据，表示文件是否上传成功
     */
    public static String getUploadFileExtension() {
        if (ServletFileUpload.isMultipartContent(ServletActionContext.getRequest())) {
            MultiPartRequestWrapper multiWrapper = (MultiPartRequestWrapper) ServletActionContext.getRequest();
            Enumeration fileParameterNames = multiWrapper.getFileParameterNames();
            while (fileParameterNames != null && fileParameterNames.hasMoreElements()) {
                String inputName = (String) fileParameterNames.nextElement();
                String[] contentType = multiWrapper.getContentTypes(inputName);
                if (contentType != null && inputName.length() > 0) {
                    String[] fileNames = multiWrapper.getFileNames(inputName);
                    if (fileNames != null && fileNames.length > 0) {
                        File[] files = multiWrapper.getFiles(inputName);
                        if (files != null) {
                            for (int index = 0; index < files.length; index++) {
                                String strtxt = getExtension(fileNames[index],"");
                                return strtxt;
                            }
                        }
                    }
                }
            }
        }
        return null;
    }
    /**
     * 根据文件类型，判断是否为所要求上传文件，type以英文逗号隔开
     * @param type
     * @return
     */
    public static String getUploadFilePath(String type) {
        if (ServletFileUpload.isMultipartContent(ServletActionContext.getRequest())) {
            MultiPartRequestWrapper multiWrapper = (MultiPartRequestWrapper) ServletActionContext.getRequest();
            Enumeration fileParameterNames = multiWrapper.getFileParameterNames();
            while (fileParameterNames != null && fileParameterNames.hasMoreElements()) {
                String inputName = (String) fileParameterNames.nextElement();
                String[] contentType = multiWrapper.getContentTypes(inputName);
                if (contentType != null && inputName.length() > 0) {
                    String[] fileNames = multiWrapper.getFileNames(inputName);
                    if (fileNames != null && fileNames.length > 0) {
                        File[] files = multiWrapper.getFiles(inputName);
                        if (files != null) {
                            for (int index = 0; index < files.length; index++) {
                                String strtxt = getExtension(fileNames[index],"");
                                if (StringUtils.isNotBlank(type)) {
                                	String[] types = type.split(",");
                                	for (int i = 0; i < types.length; i++) {
                                		if (!StringUtils.equalsIgnoreCase(types[i], strtxt)) {
                                            return "0";
                                        }
									}
								}else {
									return files[index].getPath();// 成功上传文件、并获取上传文件的目录，并返回return。该处文件只会是上传一个
								}
                            }
                        }
                    } else {
                        return "1";
                    }
                }
            }
        }
        return "2";
    }

	/**
	 * 实现数据文件上传 获取文件全路径
	 */
	public static String getUploadFilePath() {
		if (ServletFileUpload.isMultipartContent(ServletActionContext.getRequest())) {
			MultiPartRequestWrapper multiWrapper = (MultiPartRequestWrapper) ServletActionContext.getRequest();
			Enumeration fileParameterNames = multiWrapper.getFileParameterNames();
			while (fileParameterNames != null && fileParameterNames.hasMoreElements()) {
				String inputName = (String) fileParameterNames.nextElement();
				String[] contentType = multiWrapper.getContentTypes(inputName);
				if (contentType != null && inputName.length() > 0) {
					String[] fileNames = multiWrapper.getFileNames(inputName);
					if (fileNames != null && fileNames.length > 0) {
						File[] files = multiWrapper.getFiles(inputName);
						if (files != null) {
							for (int index = 0; index < files.length; index++) {
								String strtxt = getExtension(fileNames[index], "");
								if (!StringUtils.equalsIgnoreCase("txt", strtxt) && !StringUtils.equalsIgnoreCase("xls", strtxt) && !StringUtils.equalsIgnoreCase("zip", strtxt) && !StringUtils.equalsIgnoreCase("dwg", strtxt)) {
									return "0";
								} else {
									return files[index].getPath() + "," + Arrays.toString(fileNames);// 成功上传文件、并获取上传文件的目录，并返回return。该处文件只会是上传一个
								}
							}
						}
					} else {
						return "1";
					}
				}
			}
		}
		return "2";
	}

	/**
	 * 获取文件扩展名
	 * @param filename
	 * @param defExt
	 * @return
	 */
	public static String getExtension(String filename, String defExt) {
        if ((filename != null) && (filename.length() > 0)) {
            int i = filename.lastIndexOf('.');
            if ((i > -1) && (i < (filename.length() - 1))) {
                return filename.substring(i + 1);
            }
        }
        return defExt;
    }
	
	public static String getJsonFilePath(String filename) throws Exception {
		try {
			if (StringUtils.isNotBlank(filename)) {
				String dirPath = FileUtil.getEgovHomePath("zhsw/json");
				String filePath = dirPath+"/"+filename+".json";
				File file = new File(filePath);
				if (!file.exists()) {
					//去工程里面读取打印模板
					//\webapps\zhsw\WEB-INF\classes\META-INF\conf\zhsw\print
					dirPath = PublicUtil.getProjectPath(null)+"WEB-INF\\classes\\META-INF\\conf\\zhsw\\json";
					filePath = dirPath+"/"+filename+".json";
					file = new File(filePath);
				}
				if (file.exists()) {
					return filePath;
				}
			}else {
				System.out.println("打印模板为空！");
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}
	
	public static Object readJsonFile(String path) throws Exception {
        if(StringUtils.isNotBlank(path)){
            if(path.indexOf("file:/")>-1)
                path = path.substring(path.indexOf("file:/")+6);
            File file = new File(path);
            if(!file.exists())
                throw new FileNotFoundException();
            BufferedReader bufferedReader=null;
            StringBuffer config = new StringBuffer();
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file), "UTF-8"));
                String tmp=null;
                while ((tmp=bufferedReader.readLine())!=null){
                    config.append(tmp);
                }
            }finally {
                if(bufferedReader!=null)
                    bufferedReader.close();
            }
            if(StringUtils.isNotBlank(config.toString())){
                return JSON.parse(config.toString());
            }
        }
        return null;
    }
}
