package cn.gtmap.zhsw.utils;

import java.text.DecimalFormat;
import java.util.*;
import java.util.regex.Pattern;

import org.apache.commons.lang.StringUtils;
import org.apache.struts2.json.JSONException;
import org.apache.struts2.json.JSONUtil;
import org.dom4j.Attribute;
import org.dom4j.Element;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.converters.DateConverter;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;

public class CommonUtil {
	public static final String CONTENTTYPE_XML = "text/xml; charset=UTF-8";
	public static final String CONTENTTYPE_HTML = "text/html; charset=UTF-8";

    public static String generateJsonResult(Boolean success,Object result,String msg) throws JSONException {
        Map resultMap = new HashMap<String,Object>();
        resultMap.put("success",success);
        resultMap.put("result",result);
        resultMap.put("msg",msg);
        return JSONUtil.serialize(resultMap);
    }
	/**
	 * 初始化数字格式
	 * @param count
	 * @return
	 */
	public static DecimalFormat initDecimalFormat(Integer count){
		return initDecimalFormat(count,true);
	}
	/**
	 * 初始化数字格式
	 * @param count
	 * @return
	 */
	public static DecimalFormat initDecimalFormat(Integer count,boolean buling){
		String formatStr = "#0.";
		if (count == null) {
			count = 8;
		}
		if (count <= 0) {
			formatStr = "#0";
		}else {
			for (int i = 0; i < count; i++) {
				if (buling) {
					formatStr += "0";
				}else {
					formatStr += "#";
				}
			}
		}
		DecimalFormat myformat = new java.text.DecimalFormat(formatStr);
		return myformat;
	}
	/**
	 * 亩转为公顷
	 * @param val
	 * @return
	 */
	public static Double squareMeterToAcres(Double val){
		   Double area = 0.0;
		   if(val!=null){
			   area = val /15;
		   }
		   return area;
	   }
	/**
	 * 将对象转为字符串，如果为Null或者等于"null",返回空
	 * @param attribute
	 * @return
	 */
	public static String objToString(Attribute attribute){
		String result = "";
		try {
			if (attribute != null && attribute.getText() != null && !attribute.getText().equalsIgnoreCase("null")) {
				result = attribute.getText();
			}
		} catch (Exception e) {
			result = "";
		}
		return result;
	}
	
	/**
	 * 将字符串类型的转为整型
	 * 如果str为null或空，则返回null
	 * @param str
	 * @return
	 */
	public static Integer StringToInteger(String str) {
		Integer integer=null;
		try {
			if (str!=null&&!str.equals("")&& !str.equalsIgnoreCase(null)) {
				integer=Integer.valueOf(str);
			}
			
		} catch (Exception e) {
			// TODO: handle exception
		}
		return integer;
	}
	/**
	 * String类型转Double
	 * 如果为null或者是为空，返回null
	 * @param doubleData
	 * @param count
	 * @return
	 */
	public static Double StringToDouble(String str, Integer count) {
		if (StringUtils.isBlank(str) || str.equals("null")) {
			return null;
		}
		Double dbl = null;
		try {
			DecimalFormat myformat = initDecimalFormat(count);
			dbl = Double.valueOf(myformat.parse(str).doubleValue());
		} catch (Exception e) {
			// TODO: handle exception
		}
		return dbl;
	} 
	public static Double StringToDouble(String str, Integer count,boolean buling) {
		if (StringUtils.isBlank(str) || str.equals("null")) {
			return null;
		}
		Double dbl = null;
		try {
			DecimalFormat myformat = initDecimalFormat(count,buling);
			dbl = Double.valueOf(myformat.parse(str).doubleValue());
		} catch (Exception e) {
			// TODO: handle exception
		}
		return dbl;
	} 
	/**
	 * 
	 * @param doubleData
	 *            字符型的double
	 *         count
	 *         		保留小数位数
	 * @return
	 */
	public static String doubleStringToString(String doubleData, Integer count) {
		double input = 0.0;
		if (StringUtils.isBlank(doubleData) || doubleData.equals("null")) {
			return "";
		}
		input = Double.parseDouble(doubleData);
		DecimalFormat myformat = initDecimalFormat(count);
		return myformat.format(input);
	}

	public static Double doubleToDouble(Double doubleData, Integer count) {
		if (doubleData == null) {
			return 0.0;
		}
		DecimalFormat myformat = initDecimalFormat(count);
		return new Double(myformat.format(doubleData));
	} 
	public static Double doubleToDouble(Double doubleData, Integer count,boolean buling) {
		if (doubleData == null) {
			return 0.0;
		}
		DecimalFormat myformat = initDecimalFormat(count,buling);
		return new Double(myformat.format(doubleData));
	}
	/**
	 * Double 转字符串 
	 * 为null返回空字符串
	* @应用 
	* @return String
	* @throws Exception
	 */
	public static String DoubleToString(Double doubleData, Integer count){
		if (doubleData == null) {
			return "";
		}
		DecimalFormat myformat = initDecimalFormat(count);
		return myformat.format(doubleData);
	}
	public static String DoubleToString(Double doubleData, Integer count,boolean buling){
		if (doubleData == null) {
			return "";
		}
		DecimalFormat myformat = initDecimalFormat(count,buling);
		return myformat.format(doubleData);
	}
	/**
	 * Double 转字符串 
	 * 为null返回空字符串
	* @应用 
	* @return String
	* @throws Exception
	 */
	public static Integer DoubleToInteger(Double value){
		Integer input = 0;
		try {
			DecimalFormat myformat = new java.text.DecimalFormat("#0");
			String s = myformat.format(value);
			input = Integer.parseInt(s);
		} catch (Exception e) {
			// TODO: handle exception
		}
		return input;
	}
	/**
	 *  Integer 转字符串 
	 * 为null返回空字符串
	* @应用 
	* @return String
	* @throws Exception
	 */
	public static String IntegerToString(Integer integer){
		if (integer != null) {
			return String.valueOf(integer);
		}else{
			return "";
		}
	}
	public static String DoubleToString(Double value){
		if (value != null) {
			DecimalFormat myformat = new java.text.DecimalFormat("#.#");
			return myformat.format(value);
		}else{
			return "";
		}
	}
	
	/**
	 * 获取子串
	 * 
	 * @param src
	 *            原字符串
	 * @param split
	 *            分隔符
	 * @return
	 */
	public static String getSubString(String src, String split) {
		// System.out.println("str1=" + src);
		if (src == null || "".equals(src)) {
			return "";
		} else if (src.indexOf(split) != -1) {
			src = src.substring(0, src.indexOf(split));
			// System.out.println("str2=" + src);
			return src;
		}
		return "";
	}
	
	
	/**
     * 将Set容器中的PO对象转变为VO
     *
     * @param set
     * @return
     * @throws java.lang.Exception
     */
    public static Set toVOSet(Set set) throws Exception {
        if (set == null)
            return null;
        Set tempSet = new HashSet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            tempSet.add(toSingleVO(iterator.next()));
        }
        return tempSet;
    }

    /**
     * 将单独的PO转变为VO
     *
     * @param po
     * @return
     * @throws java.lang.Exception
     */
    public static Object toSingleVO(Object po) throws Exception {
        if (po == null)
            return null;
        String className = getRealName(po.getClass().getName());
        Object vo = Class.forName(className).newInstance();
        clearNullNumber(vo, po);
        ConvertUtils.register(new DateConverter(null), java.util.Date.class);
        BeanUtils.copyProperties(vo, po);
//        BeanUtilsEx.copyProperties(vo, po);
        return vo;
    }

    /**
     * 获取PO类型的真实类名
     *
     * @param className
     * @return
     */
    private static String getRealName(String className) {
        int x = className.indexOf("_$");
        if (x < 0) {
            return className;
        } else
            return className.substring(0, x);
    }

    /**
     * 对传入的PO对象中的数字类型进行整理
     * 如果发现类型为NULL,将数字强制转为0
     *
     * @param po
     */
    private static void clearNullNumber(Object vo, Object po) throws Exception {
        Field[] fields = vo.getClass().getDeclaredFields();
        String fieldName;
        for (int i = 0; i < fields.length; i++) {
            fieldName = fields[i].getName();
            checkZero(fieldName, po);
        }
    }
    
    private static void checkZero(String fieldName, Object po) throws Exception {
        String getterName = getMethodGetter(fieldName);
        String setterName = getMethodSetter(fieldName);
        Method[] methods = po.getClass().getDeclaredMethods();
        Method getter = null, setter = null;
        for (int i = 0; i < methods.length && (getter == null || setter == null); i++) {
            if (getterName.equals(methods[i].getName())) {
                getter = methods[i];
            } else if (setterName.equals(methods[i].getName())) {
                setter = methods[i];
            }
        }
        if (getter == null || setter == null)
            return;
        Object obj = getter.invoke(po, null);
        if (obj != null)
            return;
        Class returnType = getter.getReturnType();

        if (returnType.equals(java.math.BigDecimal.class)) {
            System.out.println("发现 fieldName=" + fieldName + " 为BigDecimal的情况 并且值为NULL");
            Object[] args = {new java.math.BigDecimal(0)};
            setter.invoke(po, args);
        }
//        if(returnType.equals(java.util.Date.class)){//解决导报件批次的时候 日期为空的错
//        	System.out.println("发现 fieldName="+fieldName+" 为java.util.Date的情况 并且值为NULL");
//        	setter.invoke(po,"");
//        }
    }

    /**
     * 根据POJO的一个field获取该field的getter方法
     *
     * @param fieldName
     * @return
     */
    private static String getMethodGetter(String fieldName) {
        char ch = fieldName.charAt(0);
        if (ch <= 'Z')
            return "get" + fieldName;
        ch = (char) (ch - 'a' + 'A');
        fieldName = ch + fieldName.substring(1, fieldName.length());
        return "get" + fieldName;
    }

    /**
     * 根据POJO的一个field获取该field的setter方法
     *
     * @param fieldName
     * @return
     */
    private static String getMethodSetter(String fieldName) {
        char ch = fieldName.charAt(0);
        if (ch <= 'Z')
            return "set" + fieldName;
        ch = (char) (ch - 'a' + 'A');
        fieldName = ch + fieldName.substring(1, fieldName.length());
        return "set" + fieldName;
    }
    
    /**
	 * 获取String属性的属性值
	 * @param element
	 * @param attributeName
	 * @return
	 */
	public static String getAttributeValueStr(Element element, String attributeName) {
		String tempValue = element.attributeValue(attributeName);
		if (StringUtils.isNotBlank(tempValue)) {
			tempValue = StringUtils.replace(tempValue, "null", "");
			tempValue = StringUtils.replace(tempValue, " ", "");
			tempValue = StringUtils.replace(tempValue, "　", "");
			tempValue = StringUtils.trim(tempValue);
			return tempValue.trim();
		}
		return "";
	}

	/**
	 * 获取Date属性的属性值
	 * @param element
	 * @param attributeName
	 * @return
	 */
	public static Date getAttributeValueDate(Element element, String attributeName) {
		Date returnValue = null;
		try {
			String tempValue = getAttributeValueStr(element,attributeName);
			if (StringUtils.isNotBlank(tempValue)) {
				returnValue = CalendarUtil.formatDate(tempValue);
			}
		} catch (Exception e) {
		}
		return returnValue;
	}
	/**
	 * 获取double属性的属性值
	 * @param element
	 * @param attributeName
	 * @return
	 */
	public static Double getAttributeValuDouble(Element element, String attributeName) {
		Double returnValue = 0.0;
		String tempValue = getAttributeValueStr(element,attributeName);
		if (StringUtils.isNotBlank(tempValue)) {
			returnValue = CommonUtil.StringToDouble(tempValue, 8);
		}
		return returnValue;
	}
	/**
	 * 获取BigDecimal属性的属性值
	 * @param element
	 * @param attributeName
	 * @return
	 */
	public static BigDecimal getAttributeValuBigDecimal(Element element, String attributeName) {
		Double returnValue = getAttributeValuDouble(element,attributeName);
		if (returnValue != null) {
			return new BigDecimal(returnValue);
		}
		return null;
	}
	/**
	 * 获取Integer属性的属性值
	 * @param element
	 * @param attributeName
	 * @return
	 */
	public static Integer getAttributeValueInteger(Element element, String attributeName) {
		Integer returnValue = 0;
		String tempValue = getAttributeValueStr(element,attributeName);
		if (StringUtils.isNotBlank(tempValue)) {
			returnValue = CommonUtil.StringToInteger(tempValue);
		}
		return returnValue;
	}
	/**
	 * 检查是否位数字
	 * @param str
	 * @return
	 */
	public static boolean isNumeric(String str) {
	    Pattern pattern = Pattern.compile("[0-9]*");
	    return pattern.matcher(str).matches();
	}
	
	public static Object getMapKeyByValue(Map map, String value) {
		Set set = map.entrySet();
		Iterator it = set.iterator();
		while (it.hasNext()) {
			Map.Entry entry = (Map.Entry) it.next();
			if (entry.getValue().equals(value)) {
				Object s = entry.getKey();
				return s;
			}
		}
		return null;
	}
	public static List getMapKeyListByValue(Map map, String value) {
		Set set = map.entrySet();
		List arr = new ArrayList();
		Iterator it = set.iterator();
		while (it.hasNext()) {
			Map.Entry entry = (Map.Entry) it.next();
			if (entry.getValue().equals(value)) {
				Object s = entry.getKey();
				arr.add(s);
			}
		}
		return arr;
	}
}
