package cn.gtmap.zhsw.support;
import java.io.File;
import java.io.IOException;

import javax.annotation.Resource;
import javax.servlet.ServletContext;


import org.apache.struts2.views.freemarker.FreemarkerManager;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfigurer;

import freemarker.template.Configuration;
import freemarker.template.TemplateException;
/**
 * Created with IntelliJ IDEA.
 * User: jibo
 * Date: 13-11-15
 * Time: 上午12:51
 * To change this template use File | Settings | File Templates.
 */
//@Component("springConfigToFreemarkerManager")
//@Scope("prototype")
public class SpringConfigToFreemarkerManager extends FreemarkerManager{
    private static final String SPRING_FREEMARKER_BEAN = "freemarkerConfig";

    private Configuration userConfiguration;

    @Resource
    @Qualifier("freemarkerConfigurer")
    FreeMarkerConfigurer fmconfig;

    @Override
    protected Configuration createConfiguration(ServletContext servletContext)
            throws TemplateException {
        //FreeMarkerConfigurer fmconfig = (FreeMarkerConfigurer) ApplicationBeanContext.getBean(SPRING_FREEMARKER_BEAN);
        try {
            Configuration configuration =fmconfig.createConfiguration();
            configuration.setWhitespaceStripping(true);
            return  configuration;
        } catch (IOException e) {
            e.printStackTrace();
        }
        return super.createConfiguration(servletContext);
    }

    protected Configuration createUserConfiguration(ServletContext servletContext) throws TemplateException{
        userConfiguration =createConfiguration(servletContext);

        String realpath = servletContext.getRealPath("/");

        try {
            userConfiguration.setDirectoryForTemplateLoading(new File(realpath));
        } catch (IOException e) {
            e.printStackTrace();
        }
        return userConfiguration;
    }

    public Configuration getUserConfiguration(ServletContext servletContext) {
        if(userConfiguration==null){
            try {
                createUserConfiguration(servletContext);
            } catch (TemplateException e) {
                e.printStackTrace();
            }
        }
        return userConfiguration;
    }
}
