package cn.gtmap.zhsw.service.impl;

import cn.gtmap.zhsw.entity.PublicVo;
import cn.gtmap.zhsw.service.XmlConfigSerivce;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

import java.util.List;

/**
 * Created by jane on 14-3-26.供地字典项服务
 */
@Service
public class XmlConfigServiceImpl implements XmlConfigSerivce{
    @Resource
    @Qualifier("kcdjScffList")
    List<PublicVo> kcdjScffList;
    @Resource
    @Qualifier("kcdjJdfdList")
    List<PublicVo> kcdjJdfdList;
    
    @Override
    public String queryKcdjScff(String scff) {
        if(StringUtils.isBlank(scff))
            return "";
        for(PublicVo publicVo:kcdjScffList){
            if(publicVo.getValue().equals(scff)){
                String mc = publicVo.getName();
                if(mc.indexOf("├")>-1){
                    mc = mc.substring(mc.indexOf("├")+1);
                }
                return mc;
            }
        }
        return "";
    }
    
    public String queryKcdjJdfd(String value) {
    	if(StringUtils.isBlank(value))
            return "";
        for(PublicVo publicVo:kcdjJdfdList){
            if(publicVo.getValue().equals(value)){
                return publicVo.getName();
            }
        }
        return "";
    }
}
