package cn.gtmap.zhsw.service.impl;

import cn.gtmap.zhsw.dao.BaseDao;
import cn.gtmap.zhsw.entity.Hbxm;
import cn.gtmap.zhsw.service.HbglService;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * Created by HT on 2015/11/6 9:52
 */
@Service
public class HbglServiceImpl implements HbglService {
    @Autowired
    BaseDao baseDao;

    @Override
    public Hbxm getHbglById(String hbId) throws Exception {
        return baseDao.getById(Hbxm.class,hbId);
    }

    @Transactional
    public void insertHbgl(Hbxm hbxm) throws Exception {
        if (hbxm != null) {
            baseDao.save(hbxm);
        }
    }

    @Transactional
    public void updateHbgl(Hbxm hbxm) throws Exception {
        if (hbxm != null) {
            baseDao.update(hbxm);
        }
    }

    @Transactional
    public void deleteHbgl(String[] idArr) throws Exception {
        if(idArr != null){
            baseDao.delete(Hbxm.class, idArr);
        }
    }
}
