package cn.gtmap.zhsw.service.impl;

import cn.gtmap.zhsw.dao.*;
import cn.gtmap.zhsw.entity.*;
import cn.gtmap.zhsw.service.*;
import cn.gtmap.zhsw.utils.*;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;

/**
 * Created with IntelliJ IDEA.
 * User: jibo
 * Date: 13-10-23
 * Time: 上午5:42
 * To change this template use File | Settings | File Templates.
 */
@Service
public class BlDictionaryServiceImpl implements BlDictionaryService {
	@Autowired
    BaseDao baseDao;
    
	public TdicXzc findByQlr(String qlr) throws Exception {
		if (StringUtils.isNotBlank(qlr)) {
			return baseDao.getById(TdicXzc.class, qlr);
		}
		return null;
	}
	public TdicXzc findByZCZ(String zhen, String cun, String zu) throws Exception {
		StringBuffer stringBuffer = new StringBuffer();
		stringBuffer.append("select t from TdicXzc t where 1=1 ");
		if (StringUtils.isNotBlank(zhen)) {
			stringBuffer.append(" and t.xzqZhen = '"+zhen +"'");
		}
		if (StringUtils.isNotBlank(zhen)) {
			stringBuffer.append(" and t.xzcCun = '"+cun +"'");
		}
		if (StringUtils.isNotBlank(zhen)) {
			stringBuffer.append(" and t.xzcZu = '"+zu +"'");
		}
		List<TdicXzc> xzcList = baseDao.getByJpql(stringBuffer.toString());
		if (xzcList != null && xzcList.size() > 0) {
			return xzcList.get(0);
		}
		return null;
	}
	@Transactional
	public void insertTdicXzc(TdicXzc dicXzc) throws Exception {
		if (dicXzc != null && StringUtils.isNotBlank(dicXzc.getQlr())) {
			baseDao.save(dicXzc);
		}
	}
	@Transactional
	public void updateTdicXzc(TdicXzc dicXzc) throws Exception {
		if (dicXzc != null && StringUtils.isNotBlank(dicXzc.getQlr())) {
			baseDao.update(dicXzc);
		}
	}
	
	
	public List<TDicDlbmCategory> findDicDlbmListByDlbm(String dlbm){
		return baseDao.getByJpql(" from TDicDlbmCategory t where t.dlbm=?0",dlbm);
	}
	
    public List<Object[]> getDlbmYjList(){
    	//获取一级类列表
		return baseDao.getByJpql("select distinct t.dlbmYj,t.dlmcYj from TDicDlbmCategory t order by t.dlbmYj");
    }
    
    public List<Object[]> getDlbmEjList(String dlbm1){
    	//获取二级类列表
		return baseDao.getByJpql("select distinct t.dlbmEj,t.dlmcEj from TDicDlbmCategory t where t.dlbmYj =?0 order by t.dlbmEj",dlbm1);
    }
    
    public List<Object[]> getDlbmXLList(String dlbm2){
    	//获取三级类列表
		return baseDao.getByJpql("select distinct t.dlbm,t.dlmc from TDicDlbmCategory t where t.dlbmEj =?0 order by t.dlbm",dlbm2);
    }

}
