package cn.gtmap.zhsw.printexcel.xmlparse;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

import cn.gtmap.zhsw.printexcel.xmlparse.element.Cell;
import cn.gtmap.zhsw.printexcel.xmlparse.element.Group;
import cn.gtmap.zhsw.printexcel.xmlparse.element.Sheet;
import cn.gtmap.zhsw.printexcel.xmlparse.element.Single;
import cn.gtmap.zhsw.printexcel.xmlparse.element.cellstyle.Border;
import cn.gtmap.zhsw.printexcel.xmlparse.element.cellstyle.CellStyle;
import cn.gtmap.zhsw.printexcel.xmlparse.element.cellstyle.ComeFrom;
import cn.gtmap.zhsw.printexcel.xmlparse.element.cellstyle.Font;
import cn.gtmap.zhsw.printexcel.xmlparse.element.cellstyle.Item;
import cn.gtmap.zhsw.printexcel.xmlparse.element.cellstyle.MergedCell;
import cn.gtmap.zhsw.printexcel.xmlparse.element.cellstyle.Picture;


public class XMLParse {
	Log log = LogFactory.getLog(getClass().getName());
	private HttpServletRequest request;
	public XMLParse(){
	}
	public void setRequest(HttpServletRequest request){
		this.request = request;
	}
	/**
	 * 解析xml
	 */
	public List loadXml(String xmlPath){
		List list=new ArrayList();
		Document doc=read(xmlPath);
		Element root=doc.getRootElement();
		list=parseRoot(root);		
		return list;
	}
	
	
	/**读取xml，返回document对象
	 * 人参：xmlPath = request.getRealPath("/") +"jt\\common\\excel\\xml\\" + xmlName;
	 * @param xmlPath
	 * @return
	 */
	private Document read(String xmlPath){
		 SAXReader reader = new SAXReader();
		 Document document=null;
         try {
			document = reader.read(new File(xmlPath));
		} catch (DocumentException e) {
			log.error("解析 " + xmlPath + "文件出错！");
			e.printStackTrace();
		}	
		return document;
	}
	/**
	 * 得到根元素
	 */
	@SuppressWarnings("unused")
	private Element getRootElement(Document doc){
		return doc.getRootElement();
	}
	/**
	 * 解析xml中的sheet节点，返回载有sheet类型的list
	 * @param root
	 * @return
	 */
	@SuppressWarnings("unchecked")
	private List parseRoot(Element root){
		List sheetList = new ArrayList();
		for(Iterator it=root.elementIterator("sheet");it.hasNext();){
			sheetList.add(parseSheetElement((Element)it.next()));
		}		
		log.info("sheet的数目为:"+sheetList.size());				
		return sheetList;
	}
	 /**
     * 解析sheet元素，把它封装成Sheet对象<br>
     * 输入参数：sheetElement-要解析的sheet对应的element 对象。<br>
     * 返回参数：Sheet-返回解析的sheet对象<br>
     */
    @SuppressWarnings("unchecked")
	private Sheet parseSheetElement(Element sheetElement) {
    	Sheet sheet = new Sheet();
    	String sheetName=sheetElement.attributeValue("name");
    	sheet.setName(sheetName);   	
    	Element sequenceElement = sheetElement.element("sequence");
    	if(sequenceElement!=null){
    		String sequence=sequenceElement.getText();
    		sheet.setSequenceList(parseStringToList(sequence));
        }
    	else{
    		log.error("该xml中sheet子节点下没有sequence，请检查！sheet="+sheetName);
    	}
    	List groupElementList = sheetElement.elements("group");
    	for(int i=0;i<groupElementList.size();i++){
    		Group group=parseGroupElement((Element)groupElementList.get(i));
    		sheet.getElementMap().put(group.getId(),group);
    	}
    	List singleElementList=sheetElement.elements("single");
    	for(int i=0;i<singleElementList.size();i++){
    		Single single=parseSingleElement((Element)singleElementList.get(i));
    		sheet.getElementMap().put(single.getId(),single);
    	}   	
    	return sheet;
    }
    
    /**
     * 解析Single element元素，把它封装成Single对象<br>
     * 输入参数：SingleElement-要解析的Single对应的element 对象。<br>
     * 返回参数：Single-返回解析的Single对象<br>
     */
    @SuppressWarnings("unchecked")
	private Single parseSingleElement(Element singleElement) {
        Single single = new Single();
        String strId = singleElement.attributeValue("id");
        if ( (strId == null) || (strId.length() == 0)) {
            log.error("Single的ID值为空，该Single的内容将不能进行操作");
        }
        single.setId(strId);
        List cellList = singleElement.elements("cell");
        for (int i = 0; i < cellList.size(); i++) {
            Cell tempCell = parseCellElement( (Element) cellList.get(i));
            if (tempCell != null) {
                //如果空则不添加该cell
                single.getCellList().add(tempCell);
            }
        }

        return single;
    }
    /**
     * 解析Cell element元素，把它封装成Cell对象<br>
     * 输入参数：CellElement-要解析的Cell对应的element 对象。<br>
     * 返回参数：Cell-返回解析的Cell对象<br>
     */
    private Cell parseCellElement(Element cellElement) {
    	if(cellElement==null){
    		return null;
    	}
    	Cell cell=new Cell();
    	Element rowElement=cellElement.element("row");
    	if(rowElement!=null){
    		String strRow=rowElement.getTextTrim(); 
    		try {
				cell.setRow(Integer.parseInt(strRow));
			} catch (NumberFormatException e) {
				log.error("Row的值不是数字!row="+strRow);
				e.printStackTrace();
			}
    	}
    	Element columnElement=cellElement.element("column");
    	if(columnElement!=null){
    		String strColumn=columnElement.getTextTrim(); 
    		if ( (strColumn == null) || (strColumn.length() == 0)) {
                log.error("column不能为空");
            }
    		try {
				cell.setColumn(Integer.parseInt(strColumn));
			} catch (NumberFormatException e) {
				log.error("column的值不是数字!row="+strColumn);
				e.printStackTrace();
			}
    	}
    	Element valueTypeElement = cellElement.element("valuetype");
    	if(valueTypeElement!=null){
    		cell.setValueType(valueTypeElement.getTextTrim());
    	}
    	Element precisionElement = cellElement.element("precision");
    	if(precisionElement!=null){   	   	
    		try {
				cell.setPrecision(Integer.parseInt(precisionElement.getTextTrim()));
			} catch (NumberFormatException e) {
                log.error("小数点保留的个数不是有效数字！");
				e.printStackTrace();
			}
    	}
    	Element comeFromElement=cellElement.element("comeFrom");
    	if(comeFromElement!=null){//来自pojo或HashMap
    		cell.setComeFrom(parseComeFromElement(comeFromElement));
    	}   	
    	Element cellStyleElement = cellElement.element("style");
    	if(cellStyleElement!=null){
    		cell.setCellStyle(parseCellStyleElement(cellStyleElement));
    		
    	}else{
    		log.error("没有配置style节点，请检查！");
    	}    	
    	return cell;
    }
    /**
     * 解析CellStyle element元素，把它封装成CellStyle对象<br>
     * 输入参数：styleElement-要解析的CellStyle对应的element 对象。<br>
     * 返回参数：CellStyle-返回解析的cellStyle对象<br>
     */
    private CellStyle parseCellStyleElement(Element cellStyleElement){    	
    	if(cellStyleElement==null){
    		return null;
    	}
    	CellStyle cellStyle=new CellStyle();
    	Element fontElement = cellStyleElement.element("font");
    	if (fontElement != null) {
    		Element nameElement = fontElement.element("name");
    		Element heightElement = fontElement.element("height");
    		Element boldElement = fontElement.element("bold");  //字体加粗
    		if(nameElement!=null){
    			String fontName=nameElement.getTextTrim();
    			String fontHeight=heightElement.getTextTrim();
    			if((fontName != null) && (fontName.length() > 0)){
    				if(cellStyle.getFont()==null){
    					cellStyle.setFont(new Font());
    				}
    				cellStyle.getFont().setFontName(fontName);
    			}
    			if((fontHeight != null) && (fontHeight.length() > 0)){
    				if(cellStyle.getFont()==null){
    					cellStyle.setFont(new Font());
    				}
    				 try {
    						cellStyle.getFont().setFontHeight(Short.parseShort(fontHeight));
    					} catch (NumberFormatException e) {
    	                    log.error("字体高度值为非法数字！"+fontHeight);
    						e.printStackTrace();
    				}
    			}
    		}
    		if(boldElement!=null){
    			String isBold=boldElement.getTextTrim();
    			if(isBold!=null&&isBold.equalsIgnoreCase("true")){
    				cellStyle.getFont().setBold(true);
    			}
    		}
           }
             Element borderElement = cellStyleElement.element("border");
             if (borderElement != null) {
                 String strLeft = borderElement.elementTextTrim("left");
                 String strRight = borderElement.elementTextTrim("right");
                 String strTop = borderElement.elementTextTrim("top");
                 String strBottom = borderElement.elementTextTrim("bottom");
                 if(cellStyle.getBorder()==null){ //实例化Border
            		 cellStyle.setBorder(new Border());
            	 }
                 if ( (strLeft != null) && (strLeft.length() > 0)) {               	 
                     cellStyle.getBorder().setBorderLeft(Short.parseShort(strLeft));
                 }
                 if ( (strRight != null) && (strRight.length() > 0)) {
                     cellStyle.getBorder().setBorderRight(Short.parseShort(strRight));
                 }
                 if ( (strTop != null) && (strTop.length() > 0)) {
                     cellStyle.getBorder().setBorderTop(Short.parseShort(strTop));
                 }
                 if ( (strBottom != null) && (strBottom.length() > 0)) {
                     cellStyle.getBorder().setBorderBottom(Short.parseShort(
                         strBottom));
                 }
             }
             Element pictureElement = cellStyleElement.element("picture");
             if (pictureElement != null) {
                 String width = pictureElement.elementTextTrim("width");
                 String height = pictureElement.elementTextTrim("height");
                 if ( (width != null) && (width.length() > 0)) {
                     if (cellStyle.getPicture() == null) {
                         cellStyle.setPicture(new Picture());
                     }
                     cellStyle.getPicture().setWidth(Double.parseDouble(width));
                 }
                 if ( (height != null) && (height.length() > 0)) {
                     if (cellStyle.getPicture() == null) {
                         cellStyle.setPicture(new Picture());
                     }
                     cellStyle.getPicture().setHeight(Double.parseDouble(height));
                 }
             }
             else{
            	 if(cellStyle.getPicture()==null){
            		 cellStyle.setPicture(new Picture());
            	 }
            	 cellStyle.getPicture().setHeight(1);
            	 cellStyle.getPicture().setWidth(1);
            	 
             }
             String strAutoFill = cellStyleElement.elementTextTrim("autoFill");
             if ( (strAutoFill != null) &&
                 (strAutoFill.equalsIgnoreCase("true"))) {
                 cellStyle.setAutoFill(true);
             }
             String strWrapText = cellStyleElement.elementTextTrim("wrapText");
             if ( (strWrapText != null) && (strWrapText.equalsIgnoreCase("true"))) {
                 cellStyle.setWrapText(true);
             }
             cellStyle.setParalletAlignment(cellStyleElement.elementTextTrim("paralletAlignment"));
             cellStyle.setVerticalAlignment(cellStyleElement.elementTextTrim("verticalAlignment"));
             Element mergedCellElement= cellStyleElement.element("mergedCell");
             if(mergedCellElement!=null){
            	 String strFromX = mergedCellElement.elementTextTrim("fromx");
                 if ( (strFromX != null) && (strFromX.length() > 0)) {
                     if (cellStyle.getMergedCell() == null) {
                         cellStyle.setMergedCell(new MergedCell());
                     }
                     strFromX = getRequestParamValue(strFromX);
                     cellStyle.getMergedCell().setFromX(strFromX);
                 }
                 String strFromY = mergedCellElement.elementTextTrim("fromy");
                 if ( (strFromY != null) && (strFromY.length() > 0)) {
                     if (cellStyle.getMergedCell() == null) {
                         cellStyle.setMergedCell(new MergedCell());
                     }
                     strFromY = getRequestParamValue(strFromY);
                     cellStyle.getMergedCell().setFromY(Short.parseShort(strFromY));
                 }
                 String strToX = mergedCellElement.elementTextTrim("tox");
                 if ( (strToX != null) && (strToX.length() > 0)) {
                     if (cellStyle.getMergedCell() == null) {
                         cellStyle.setMergedCell(new MergedCell());
                     }
                     strToX = getRequestParamValue(strToX);
                     cellStyle.getMergedCell().setToX(strToX);
                 }

                 String strToY = mergedCellElement.elementTextTrim("toy");
                 if ( (strToY != null) && (strToY.length() > 0)) {
                     if (cellStyle.getMergedCell() == null) {
                         cellStyle.setMergedCell(new MergedCell());
                     }
                     strToY = getRequestParamValue(strToY);
                     cellStyle.getMergedCell().setToY(Short.parseShort(strToY));
                 }
             }
    	
    	return cellStyle;
    }
    /**
     * 解析ComeFrom element元素，把它封装成ComeFrom对象<br>
     * 输入参数：comeFromElement-要解析的ComeFrom对应的element 对象。<br>
     * 返回参数：ComeFrom-返回解析的ComeFrom对象<br>
     */
    private ComeFrom parseComeFromElement(Element comeFromElement){
    	ComeFrom comeFrom = new ComeFrom();
    	Element pojoElement=comeFromElement.element("pojoName");
    	if(pojoElement!=null){
    		String strPojo=pojoElement.getTextTrim();
    		if(strPojo==null||strPojo.equals("")){
    			log.error("配置文件中comeFrom下的pojoName值为空，请检查！");
    		}
    		else
    			comeFrom.setPojoName(strPojo);
    	}
    	Element attributeElement=comeFromElement.element("attribute");
    	if(attributeElement!=null){
    		String strAttribute=attributeElement.getTextTrim();
    		if(strAttribute==null||strAttribute.equals("")){
    			log.error("配置文件中comeFrom下的attribute值为空，请检查！");
    		}
    		else
    			comeFrom.setAttribute(strAttribute);
    	}
    	return comeFrom;
    }
    /**
     * 解析Group element元素，把它封装成group对象<br>
     * 输入参数：groupElement-要解析的group对应的element 对象。<br>
     * 返回参数：Group-返回解析的Group对象<br>
     */
    @SuppressWarnings("unchecked")
	private Group parseGroupElement(Element groupElement) {
    	if(groupElement==null){
    		return null;
    	}
    	Group group = new Group();
    	String groupId = groupElement.attributeValue("id");
    	 if ( (groupId == null) || (groupId.length() == 0)) {
             log.error("groupId为空，这将导致access读写出错");
         }
         group.setId(groupId);
         String beginRow=groupElement.elementTextTrim("beginRow");
         if (beginRow != null && beginRow.length() > 0) {
			try {
				group.setBeginRow(Integer.parseInt(beginRow));
			} catch (NumberFormatException e) {
				log.error("group的起始行或起始列为非法数字！");
				e.printStackTrace();
			}
		}
		String strInsert = groupElement.elementTextTrim("insert");
        if ( (strInsert != null) && (strInsert.equalsIgnoreCase("true"))) {
            group.setInsert(true);
        }
    	List itemList=groupElement.elements("item");
    	for(int i=0;i<itemList.size();i++){
    	  Item tempItem = parseItemElement((Element)itemList.get(i));
    	  if(tempItem!=null){  
    		  group.getItemList().add(tempItem);
    	  }   	  
    	}    	
    	return group;
    }
    /**
     * 解析Item element元素，把它封装成Item对象<br>
     * 输入参数：itemElement-要解析的Item对应的element 对象。<br>
     * 返回参数：Item-返回解析的Item对象<br>
     */
    private Item parseItemElement(Element itemElement){
    	if(itemElement==null){
    		return null;
    	}
    	Item item = new Item();
    	Element rowElement=itemElement.element("beginColumn");
    	if(rowElement!=null){
    		String strColumn=rowElement.getTextTrim(); 
    		try {
    			item.setBeginColumn(Integer.parseInt(strColumn));
			} catch (NumberFormatException e) {
				log.error("beginColumn的值不是数字!row="+strColumn);
				e.printStackTrace();
			}
    	}
    	Element fieldElement=itemElement.element("field");
    	if(fieldElement!=null){
    		String strField=fieldElement.getTextTrim(); 
    		if ( (strField == null) || (strField.length() == 0)) {
                log.error("column不能为空");
            }
    		try {
				item.setField(Integer.parseInt(strField.substring(1,strField.length()-1)));
			} catch (NumberFormatException e) {
				log.error("column的值无效！格式应该为[5] ="+strField);
				e.printStackTrace();
			}
    	}
    	Element valueTypeElement = itemElement.element("valuetype");
    	if(valueTypeElement!=null){
    		item.setValueType(valueTypeElement.getTextTrim());
    	}
    	Element precisionElement = itemElement.element("precision");
    	if(precisionElement!=null){   	   	
    		try {
				item.setPrecision(Integer.parseInt(precisionElement.getTextTrim()));
			} catch (NumberFormatException e) {
                log.error("小数点保留的个数不是有效数字！");
				e.printStackTrace();
			}
    	}   	
    	Element cellStyleElement = itemElement.element("style");
    	if(cellStyleElement!=null){
    		item.setCellStyle(parseCellStyleElement(cellStyleElement));
    		
    	}else{
    		log.error("没有配置style节点，请检查！");
    	}    	   	
    	return item;
    }
    /**
     * str为","分割的字符串
     * @param str
     * @return 用","分割后的list
     */
    @SuppressWarnings("unchecked")
	private List parseStringToList(String str){
    	List list = new ArrayList();
    	if(str==null||str.length()==0){
    		return list;
    	}
    	 StringBuffer strBuf = new StringBuffer(str);

         while (strBuf.indexOf(",") != -1) {
             int index = strBuf.indexOf(",");
             String temp = strBuf.substring(0, index);
             if (temp.length() > 0) {
                 list.add(temp);
             }
             strBuf.delete(0, index + 1);
         }
         if (strBuf.length() > 0) {
             list.add(strBuf.toString());
         }    	
    	return list;
    }
    
    private String getRequestParamValue(String value){
    	if (request != null) {
         	if (StringUtils.startsWithIgnoreCase(value, "request_") && StringUtils.isNotBlank(value.split("_")[1])) {
         		value = request.getAttribute(value.split("_")[1]).toString();
			}
		}
    	return value;
    }
	
}
