package cn.gtmap.zhsw.print;

import java.util.*;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang.StringUtils;
import org.apache.struts2.json.JSONUtil;

import cn.gtmap.zhsw.print.sign.*;
import cn.gtmap.zhsw.utils.*;

public class XMLBuildHelper {

	
	/**对vo进行处理**/
	public String voToXml(Object vo)
	{
		if (vo == null) {
			return "";
		}
		VoXml vxml=new VoXml(vo);
		return vxml.getXMLData();
	}
	
	/**
	 * 对HashMap<String, String>进行处理
	 * 目前只支持键值对都为String类型的HashMap
	 * @param map
	 * @return
	 */
	public String hashMapToXml(HashMap<String, String> map)
	{
		VoXml vxml=new VoXml();
		vxml.setMap(map);
		return vxml.getXMLDataByHashMap();
	}
	
	/**对vo集进行处理**/
	public String voListToXml(List volist){
		if (volist == null) {
			volist = new ArrayList();
		}
		VoListXml vlxml=new VoListXml(volist);
		return vlxml.getXMLData();
	}
	/**
	 * 对HashMap<String, String>进行处理
	 * 目前只支持键值对都为String类型的HashMap
	 * @param map
	 * @return
	 */
	public String hashMapListToXml(List<HashMap<String, String>> maplist)
	{
		VoListXml vlxml=new VoListXml();
		vlxml.setMaplist(maplist);
		return vlxml.getXMLDataByHashMap();
	}
	
	/**
	 * 利用平台，获取签名和打印模板
	 * @param conn
	 * @param proid
	 * @param request
	 * @return
	 */
	public String getSignToXml(String proid,HttpServletRequest request,HashMap<String, Boolean> keyMap){
		StringBuilder xml = new StringBuilder(); 
		try {
			GetSignInfo signInfo=new GetSignInfo();
	    	List signVoList=signInfo.getSign(proid);
	    	signVoList=unsignedInfoAdd(signVoList,keyMap);
	    	SignListXml signXml = new SignListXml(signVoList);
	    	try {
	    		xml = new StringBuilder(signXml.getXMLDataWithAutoSign(request));
			} catch (Exception e) {
				e.printStackTrace();
			}
		} catch (Exception e) {
			System.out.println(e.getMessage());
		}
    	
		return getSignToXml(xml,keyMap);
    }
	/**
	 * 针对签名处理失败的再处理
	 * @param xml
	 * @param keyMap
	 * @return
	 */
	private String getSignToXml(StringBuilder xml,HashMap<String, Boolean> keyMap){
		StringBuffer sb=new StringBuffer();
		try {
			String str = xml.toString();
			if (keyMap != null) {
				Collection values = keyMap.keySet();
				for (Iterator iterator = values.iterator(); iterator.hasNext();) {
					Object value = iterator.next();
					if (value != null && StringUtils.isNotBlank(String.valueOf(value))) {
						String sign = String.valueOf(value)+"_";
						if (str.indexOf(sign) < 0) {
							//增加该签名对应的数据
							sb.append("<data name=\""+sign+"NAME\" type=\"String\"/>");
							sb.append("<data name=\""+sign+"Date\" type=\"String\"/>");
							sb.append("<data name=\""+sign+"OPINION\" type=\"String\"/>");
							sb.append("<data name=\""+sign+"PIC\" type=\"image\"/>");
						}
					}
				}
			}
		} catch (Exception e) {
			System.out.println(e.getMessage());
		}
		xml.append(sb);
		return xml.toString();
    }
	
	//对于签名控制没有值的异常处理
	private List  unsignedInfoAdd(List signVoList,HashMap<String, Boolean> keyMap){
		List finsihSignVoList = new Vector();
		HashMap<String,List<SignVo>> signVoMap= new HashMap<String,List<SignVo>>();
		if (signVoList == null){
			return finsihSignVoList;
		}
//			HashMap<String, Boolean> keyMap = new HashMap<String, Boolean>();
//			keyMap.put("cbdw_cbr", false);
//			keyMap.put("cbdw_fzr", false);
		
		for (int i=0;i<signVoList.size();i++){
			SignVo tempSignVo = (SignVo) signVoList.get(i);
			List<SignVo> curSignVoList = signVoMap.get(tempSignVo.getSignKey());
			if (curSignVoList==null){
				curSignVoList = new Vector<SignVo>();
				signVoMap.put(tempSignVo.getSignKey(), curSignVoList);
			}
			curSignVoList.add(tempSignVo);
			Iterator iter = keyMap.entrySet().iterator();
			while (iter.hasNext()) {
				Map.Entry entry = (Map.Entry) iter.next();
				String key = (String)entry.getKey();
				boolean val = (Boolean)entry.getValue();
				if(tempSignVo.getSignKey().equalsIgnoreCase(key.toString())){
					val = true;
				}
				keyMap.put(key, val);
			}
		}
		Iterator iter = keyMap.entrySet().iterator();
		while (iter.hasNext()) {
			Map.Entry entry = (Map.Entry) iter.next();
			String key = (String)entry.getKey();
			boolean val = (Boolean)entry.getValue();
			if (!val){
				SignVo tempCbdwCbrSignVo = new SignVo();
				tempCbdwCbrSignVo.setSignKey(key);
				finsihSignVoList.add(tempCbdwCbrSignVo);
			}else{
				finsihSignVoList.addAll(signVoMap.get(key));
			}
		}
		return finsihSignVoList;
	}
	/**
	 * 组织打印所需要的xml数据
	 * @param dataXml
	 * @return
	 */
	public String getPrintXml(String dataXml){
		StringBuilder xml = new StringBuilder();
		xml.append(getPrintXml(dataXml,null));
		return xml.toString();
	}
	/**
	 * 组织打印所需要的xml数据
	 * @param dataXml
	 * @return
	 */
	public String getPrintXml(String dataXml,String detailXml){
		StringBuilder xml = new StringBuilder();
		xml.append("<?xml version=\"1.0\" encoding=\"GBK\" ?>\n");
		xml.append("<fetchdatas>\n");
		xml.append("<datas>\n");
		
		xml.append(getPublicConfigXml(dataXml));
		
		xml.append(initSealPicXml(null));
		
		xml.append(dataXml);
		if(xml.indexOf("</datas>")<0) {
			xml.append("</datas>");
		}
		
		if (StringUtils.isNotBlank(detailXml)) {
			xml.append(detailXml);
			if(xml.indexOf("</detail>")<0) {
				xml.append("</detail>");
			}
		}
		
		xml.append("</fetchdatas>");
		System.out.println(xml.toString());
		return xml.toString();
	}
	/**
	 * 组织打印所需要的xml数据
	 * @param dataXml
	 * @param detailXml
	 * @param sealName 签名图片名称
	 * @return
	 */
	public String getPrintXml(String dataXml,String detailXml,String sealName){
		StringBuilder xml = new StringBuilder();
		xml.append("<?xml version=\"1.0\" encoding=\"GBK\" ?>\n");
		xml.append("<fetchdatas>\n");
		xml.append("<datas>\n");
		
		xml.append(getPublicConfigXml(dataXml));
		
		xml.append(initSealPicXml(sealName));
		
		xml.append(dataXml);
		if(xml.indexOf("</datas>")<0) {
			xml.append("</datas>");
		}
		
		if (StringUtils.isNotBlank(detailXml)) {
			xml.append(detailXml);
			if(xml.indexOf("</detail>")<0) {
				xml.append("</detail>");
			}
		}
		
		xml.append("</fetchdatas>");
		System.out.println(xml.toString());
		return xml.toString();
	}
	
	public String getPublicConfigXml(String dataXml){
		StringBuilder xml = new StringBuilder();
		if(dataXml.indexOf("PUBLIC_CONFIG_XZQNAME")<0) {
			xml.append("<data name=\"PUBLIC_CONFIG_XZQNAME\" type=\"String\">");
			xml.append(PlatformHelper.getConfigXzqname());
			xml.append("</data>");
		}
		if(dataXml.indexOf("PUBLIC_CONFIG_SUBCODE")<0) {
			xml.append("<data name=\"PUBLIC_CONFIG_SUBCODE\" type=\"String\">");
			xml.append(PlatformHelper.getConfigSubcode());
			xml.append("</data>");
		}
		return xml.toString();
	}
	
	/**
	 * egov-home\标准\conf\zhsw\seal
	 * 读取印章所在文件夹，将所有印章名称放置打印xml中
	 * @return
	 */
	public String initSealPicXml(String fileName){
		StringBuilder xml = new StringBuilder();
		try {
			String dirPath = FileUtil.getEgovHomePath("zhsw/seal");
			List<HashMap<String, String>> filenameList = FileUtil.getFileMapList(dirPath, "jpg,png,jpeg,gif", null);
			String projUrl = PlatformHelper.getBusiSystemServerURL("zhsw");
			if (filenameList != null && filenameList.size() > 0) {
				for (int i = 0; i < filenameList.size(); i++) {
					HashMap<String, String> fileMap = filenameList.get(i);
					if (fileMap != null && StringUtils.isNotBlank(fileMap.get("filename"))) {
						fileMap.remove("filepath");
						String tempName = fileMap.get("filename");
						String paramString = JSONUtil.serialize(fileMap);
						if (StringUtils.isNotBlank(fileName)) {
							if (StringUtils.equals(tempName, fileName)) {
								xml.append("<data name=\""+tempName+"\" type=\"png\">");
								xml.append(projUrl+"/public!printSealImg.action?paramString="+paramString);
								xml.append("</data>");
								break;
							}
						}else {
							xml.append("<data name=\""+tempName+"\" type=\"png\">");
							xml.append(projUrl+"/public!printSealImg.action?paramString="+paramString);
							xml.append("</data>");
						}
					}
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return xml.toString();
	}
}
