/**   
 * @{#} PrintTagParse.java Create on 2008-8-14 上午11:30:23   
 *   
 * Copyright(c) 2008 by Jiangsu E.G.A.Technology LTD.  
 *
 * All right reserved. 
 */
package cn.gtmap.zhsw.print;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**   
 * @author HeGuobing  
 * @version 1.0   
 */

public class PrintTagParse extends TagSupport {
	Log log = LogFactory.getLog("-->>打印标签解析");

	private String modalUrl;//fr3模板路径
	
	private String dataUrl;//数据来源类 非spring管理
	
	private String beanName;//数据来源类 spring管理
	
	private String buttonName;//按钮名称

	private String buttonValue;//按钮值	
	
	private String buttonStyle;//按钮的样式
	
	private String servletName;//servlet
	
	private String paramsRender;//参数Function
	
	
    public int doStartTag() throws JspException
    {
    	HttpServletRequest request = (HttpServletRequest) pageContext
				.getRequest();
		String context = "http://" + request.getServerName() + ":"
				+ request.getServerPort() + request.getContextPath();
    	try
        {
            JspWriter out = pageContext.getOut();
            out.print(this.getJsFunction(context));
          //  out.print(this.getHiddens());
            out.print(this.getButton());
        }
        catch (IOException ioException)
        {
            throw new JspException(ioException.getMessage());
        }
        catch(Exception e)
        {
            e.printStackTrace();
        }
        return (SKIP_BODY);
    }
    private String getHidden(String name,String value)
    {
        StringBuffer buffer=new StringBuffer();
        buffer.append("<input type=\"hidden\" ");
        buffer.append("name=\""+name+"\" ");
        buffer.append("value=\""+value+"\">\n");
        return buffer.toString();
    }
    private String getHiddens()
    {
        StringBuffer buffer=new StringBuffer();
        buffer.append(this.getHidden("print_dataUrl",dataUrl));
        buffer.append(this.getHidden("print_params",paramsRender));
        return buffer.toString();
    }
    private String getJsFunction(String context)
    {
    	StringBuffer buffer=new StringBuffer();
        buffer.append("<script language=\"javascript\">\n");
        buffer.append("function ");
        buffer.append(beanName);
        buffer.append("_tag_print_build()\n");
        buffer.append("{\n");
        buffer.append("  var obj= new ActiveXObject(\"AppFRView.RACPrint\");\n");
        //buffer.append("CollectGarbage(); \n");
        buffer.append(" var params=");
        if(paramsRender!=null){
        	buffer.append(paramsRender);
        	buffer.append("();\n");
        }else
        	buffer.append("\n");
        buffer.append("  obj.DataUrl=\"");
        buffer.append(context);
        buffer.append("/");
        buffer.append(servletName);
        if(dataUrl!=null){
        	 buffer.append("?dataUrl=");
             buffer.append(dataUrl);
        }
        else if(beanName!=null){
        	 buffer.append("?beanName=");
             buffer.append(beanName);
        }
        buffer.append("&\"+params;\n");
        buffer.append("  obj.ModalUrl=\""+context+"/"+modalUrl+"\";\n");
        buffer.append("  obj.PrintView();\n");
        //buffer.append("CollectGarbage(); \n");
        buffer.append("}\n");
        buffer.append("</script>\n");
        return buffer.toString();
    }
    private String getButton()
    {
        StringBuffer buffer=new StringBuffer();
        buffer.append("<input type=\"button\" ");
        buffer.append("name=\""+buttonName+"\" ");
        buffer.append("value=\""+buttonValue+"\" ");
        buffer.append("onclick=\"");
        buffer.append(beanName);
        buffer.append("_tag_print_build();\"" );
        if(buttonStyle!=null){
        	 buffer.append("class=\""+buttonStyle+"\">\n");
        }else
        	buffer.append(">\n");
        return buffer.toString();
    }
	public void setButtonName(String buttonName) {
		this.buttonName = buttonName;
	}
	public void setButtonStyle(String buttonStyle) {
		this.buttonStyle = buttonStyle;
	}
	public void setButtonValue(String buttonValue) {
		this.buttonValue = buttonValue;
	}
	public void setDataUrl(String dataUrl) {
		this.dataUrl = dataUrl;
	}
	public void setModalUrl(String modalUrl) {
		this.modalUrl = modalUrl;
	}
	public void setParamsRender(String paramsRender) {
		this.paramsRender = paramsRender;
	}
	public void setServletName(String servletName) {
		this.servletName = servletName;
	}
	public void setBeanName(String beanName) {
		this.beanName = beanName;
	}
}
