package cn.gtmap.zhsw.model;

import cn.gtmap.zhsw.dao.*;
import cn.gtmap.zhsw.entity.*;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;

import java.util.ArrayList;
import java.util.List;

/**
 * Created with IntelliJ IDEA.
 * User: janeshen
 * Date: 13-10-29
 * Time: 下午7:57
 * 二调地类分类、过渡与二调地类对照
 */
@Component
public class XzqModel {
    @Autowired
    BaseDao baseDao;
    String xzqdm;
    
    public static List<TdicXzqVo> xzqList;
    
    public XzqModel(){
    }

    @PostConstruct
    public void init(){
        xzqList =baseDao.getByJpql(" from TdicXzqVo t order by xzqdm");
    }
    
    public XzqModel(String xzqdm){
    	this.xzqdm=xzqdm;
    }
    /**
     * 根据行政区代码获取行政区名称
     * @return
     * @throws Exception
     */
    public String getXzqname()throws Exception{
    	TdicXzqVo vo = getXzqVo();
    	if (vo != null) {
			return vo.getXzqmc();
		}
    	return "";
    }
    /**
     * 根据行政区代码获取行政区
     * @return
     * @throws Exception
     */
    public TdicXzqVo getXzqVo()throws Exception{
    	TdicXzqVo vo = null;
    	if(xzqList!=null&&xzqList.size()>0){
            for(int i=0;i<xzqList.size();i++){
            	if (xzqList.get(i).getXzqdm().equals(xzqdm)) {
            		vo =  xzqList.get(i);
				}
            }
        }
    	if (vo == null) {
			vo = xzqList.get(0);
		}
    	return vo;
    }
    public TdicXzqVo getXzqVo(String dm)throws Exception{
    	TdicXzqVo vo = null;
    	if(xzqList!=null&&xzqList.size()>0){
            for(int i=0;i<xzqList.size();i++){
            	if (xzqList.get(i).getXzqdm().equals(dm)) {
            		vo =  xzqList.get(i);
				}
            }
        }
    	if (vo == null) {
			vo = xzqList.get(0);
		}
    	return vo;
    }
    public String getXzqName(String dm,boolean isdefault)throws Exception{
    	TdicXzqVo vo = getXzqVo(dm);
    	if (vo == null && isdefault) {
			vo = xzqList.get(0);
			return vo.getXzqmc();
		}
    	return null;
    }
    /**
     * 根据行政区代码获取行政区集合
     * @return
     * @throws Exception
     */
    public List<TdicXzqVo> getXzqList()throws Exception{
    	return getXzqList(false);
    }
    /**
     * 根据行政区代码获取行政区集合
     * @return
     * @throws Exception
     */
    public List<TdicXzqVo> getXzqList(Boolean shixian)throws Exception{
    	String tmpXzqdm = xzqdm;
    	if (StringUtils.length(tmpXzqdm) == 6 && StringUtils.endsWith(tmpXzqdm, "00")) {
    		tmpXzqdm = StringUtils.substring(tmpXzqdm, 0,4);
		}
    	List<TdicXzqVo> list = new ArrayList<TdicXzqVo>();
    	if(xzqList!=null&&xzqList.size()>0){
            for(int i=0;i<xzqList.size();i++){
            	if (shixian != null && shixian) {
            		if (StringUtils.length(xzqList.get(i).getXzqdm()) > 6) {
						continue;
					}
				}
            	if (tmpXzqdm==null || StringUtils.startsWith(xzqList.get(i).getXzqdm(), tmpXzqdm)) {
            		list.add(xzqList.get(i));
				}
            }
        }
    	if (list.size() == 0) {
			list.addAll(xzqList);
		}
    	return list;
    }
}
