package cn.gtmap.zhsw.dao.ibatis;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.StringUtils;

/**
 * @文件名 IOperationDao.java
 * @作者 卢向伟
 * @创建日期 2013-1-7
 * @创建时间 上午8:37:52 
 * @版本号 V 1.0
 */
public interface PublicDao {
	/**
	 * 根据参数和ibatis配置id获取对象
	 * @param param
	 * @param ibatisStr
	 * @return
	 */
	public <T> T getObjectByIbatisStr(HashMap param,String ibatisStr);
	/**
	 * 根据参数和ibatis配置id获取对象集合
	 * @param param
	 * @param ibatisStr
	 * @return
	 */
	public <T> List<T> getObjectListByIbatisStr(HashMap param,String ibatisStr);
	/**
	 * 根据参数和ibatis配置id获取对象
	 * @param param
	 * @param ibatisStr
	 * @return
	 */
	public HashMap getHashMapByIbatisStr(HashMap param,String ibatisStr);
	/**
	 * 根据参数和ibatis配置id获取对象集合
	 * @param param
	 * @param ibatisStr
	 * @return
	 */
	public List<HashMap> getHashMapListByIbatisStr(HashMap param,String ibatisStr);
 	/**
 	 * 根据对象和ibatis配置进行插入数据
 	 * @param obj
 	 * @param ibatisStr
 	 */
	public boolean insertObjectByIbatisStr(Object obj,String ibatisStr);
//	/**
//	 * 根据对象和ibatis配置进行更新数据
//	 * @param obj
//	 * @param ibatisStr
//	 */
//	public boolean updateObjectByIbatisStr(Object obj,String ibatisStr);
//	/**
//	 * 删除对象，根据对象和ibatis配置
//	 * @param参数
//	 */
//	public boolean deleteObjectByIbatisStr(HashMap param,String ibatisStr);
}
