//解决ie低版本浏览器获取获取ajax数据失败的问题
jQuery.support.cors = true;
/**
 *rmb小写转大写（小写的值,转大写的字段id）
 */
function changeDx(num,name){
    var title = "人民币";
    if(f_check_number(num,title)){
        var strOutput = "",
            strUnit = '仟佰拾亿仟佰拾万仟佰拾元角分';
        num=(num.value*100).toString();
        var intPos = num.indexOf('.');
        if (intPos >= 0){
            num = num.substring(0, intPos) + num.substr(intPos + 1, 2);
        }
        strUnit = strUnit.substr(strUnit.length - num.length);
        for (var i=0; i < num.length; i++){
            strOutput += '零壹贰叁肆伍陆柒捌玖'.substr(num.substr(i,1),1) + strUnit.substr(i,1);
        }
        var dx = strOutput.replace(/零角零分$/, '整').replace(/零[仟佰拾]/g, '零').replace(/零{2,}/g, '零').replace(/零([亿|万])/g, '$1').replace(/零+元/, '元').replace(/亿零{0,3}万/, '亿').replace(/^元/, "零元");
        $("#" + name).val(dx);
    }
}

/**
 *rmb小写转大写（小写的值,转大写的字段id）
 */
function changeDxWy(num,name){
    var title = "人民币";
    if(f_check_number(num,title)){
        var strOutput = "",
            strUnit = '仟佰拾亿仟佰拾万仟佰拾元角分';
        num=(num.value*100*10000).toString();
        var intPos = num.indexOf('.');
        if (intPos >= 0){
            num = num.substring(0, intPos) + num.substr(intPos + 1, 2);
        }
        strUnit = strUnit.substr(strUnit.length - num.length);
        for (var i=0; i < num.length; i++){
            strOutput += '零壹贰叁肆伍陆柒捌玖'.substr(num.substr(i,1),1) + strUnit.substr(i,1);
        }
        var dx = strOutput.replace(/零角零分$/, '整').replace(/零[仟佰拾]/g, '零').replace(/零{2,}/g, '零').replace(/零([亿|万])/g, '$1').replace(/零+元/, '元').replace(/亿零{0,3}万/, '亿').replace(/^元/, "零元");
        $("#" + name).val(dx);
    }
}
function getUrlVars()  {
    var vars = [], hash;
    var hashes = window.location.href.slice(window.location.href.indexOf('?') + 1).split('&');
    for(var i = 0; i < hashes.length; i++)
    {
        hash = hashes[i].split('=');
        vars.push(hash[0]);
        vars[hash[0]] = hash[1];
    }
    return vars;
}

// JS 四舍五入自定义小数位数，空缺补0
function formatnumber(value, num,sfbl) {
    var a, b, c, i;
    a = value.toString();
    b = a.indexOf(".");
    c = a.length;
    if (num == 0) {
        if (b != -1) {
            a = a.substring(0, b);
        }
    } else {
        if (b == -1) {
            if(sfbl){
                a = a + ".";
                for (i = 1; i <= num; i++) {
                    a = a + "0";
                }
            }
        } else {
            a = a.substring(0, b + num + 1);
            if(sfbl){
                for (i = c; i <= b + num; i++) {
                    a = a + "0";
                }
            }
        }
    }
    return a;
}

/**
 * 格式化数字
 * @param value
 * @param num 保留小数位，当要整数时该值可以不传
 * @param sfbl 是否补0，不需要补0可以不传
 * @returns
 */
function formatNum(value, num, sfbl){
    if($.trim(value) == "" || isNaN(value)){
        return 0;
    }

    var n = 0;
    if($.trim(num) != "" && !isNaN(num) && parseInt(num) > 0 && parseInt(num) <= 20){
        n = parseInt(num);
    }

    var v = parseFloat(value);
    v = v.toFixed(n);

    if($.trim(sfbl) != "true") {
        return parseFloat(v);
    }
    return v;
}

Date.prototype.Format = function(fmt) { // author: meizz
    var o = {
        "M+" : this.getMonth() + 1, // 月份
        "d+" : this.getDate(), // 日
        "h+" : this.getHours(), // 小时
        "m+" : this.getMinutes(), // 分
        "s+" : this.getSeconds(), // 秒
        "q+" : Math.floor((this.getMonth() + 3) / 3), // 季度
        "S" : this.getMilliseconds() // 毫秒
    };
    if (/(y+)/.test(fmt)){
        fmt = fmt.replace(RegExp.$1, (this.getFullYear() + "").substr(4 - RegExp.$1.length));
    }

    for (var k in o){
        if (new RegExp("(" + k + ")").test(fmt)){
            fmt = fmt.replace(RegExp.$1, (RegExp.$1.length == 1) ? (o[k]): (("00" + o[k]).substr(("" + o[k]).length)));
        }
    }
    return fmt;
}

//判断object是否是空对象,空数组,空字符串,null,undefined,如果是则返回false,不是则返回true
//空字符串不包括"(空格)",只特指""
function isNotBlank(object) {
    if (typeof object === "object" && !(object instanceof Array)) {
        var hasProp = false;
        for (var prop in object) {
            hasProp = true;
            break;
        }
        if (hasProp) {
            hasProp = [hasProp];
        } else {
            return false;
        }
        return hasProp;
    }
    return typeof object != "undefined" && object != "";
}

function isBlank(object){
    return !isNotBlank(object);
}

if (!Array.prototype.forEach) {
    Array.prototype.forEach = function (callback, thisArg) {
        var T, k;
        if (this == null) {
            throw new TypeError(" this is null or not defined");
        }
        var O = Object(this);
        var len = O.length >>> 0; // Hack to convert O.length to a UInt32
        if ({}.toString.call(callback) != "[object Function]") {
            throw new TypeError(callback + " is not a function");
        }
        if (thisArg) {
            T = thisArg;
        }
        k = 0;
        while (k < len) {
            var kValue;
            if (k in O) {
                kValue = O[k];
                callback.call(T, kValue, k, O);
            }
            k++;
        }
    };
}


/**
 1、字段为纯数字，判断是否为数字
 2、字段为数字或者数字+小数点
 3、字段为字符串（不能输入特殊字符，#、@、*等），或者字母+数字
 4、校验数字的长度，从x到y
 5、字段为邮箱类型，***@***
 6、检验两字段的数值大小，进行比较
 7、判断是否为邮政编码，六位数字
 8、检验字段是否为空
 9、校验字符串的长度，从x到y
 */

/*
 * 判断是否为数字，是则返回true,否则返回false
 */
function f_check_number(obj,code){
    if(obj && obj.value){
        if (/^\-?[0-9]*\.?[0-9]*$/.test(obj.value)){
            return true;
        }else{
            obj.value="";
            f_alert(code,"请输入数字");
            //obj.focus();
            return false;
        }
    }
    return false;
}

/*
 * 判断是否为整数，是则返回true,否则返回false
 */
function f_check_integer(obj,code) {
    if(obj && obj.value){
        if (/^(\+|-)?\d+$/.test(obj.value)){
            return true;
        }else{
            obj.value="";
            f_alert(code,"请输入整数");
            //obj.focus();
            return false;
        }
    }
    return false;
}

/*
 * 判断是否为实数，是则返回true,否则返回false
 */
function f_check_float(obj,code){
    if(obj && obj.value){
        if (/^(\+|-)?\d+($|\.\d+$)/.test(obj.value)){
            return true;
        }else{
            obj.value="";
            f_alert(code,"请输入实数");
            //obj.focus();
            return false;
        }
    }
    return false;
}

/**
 * 取得字符串的字节长度
 */
function strlen(str){
    var i;
    var len = 0;
    for (i=0;i<str.length;i++){
        if (str.charCodeAt(i)>255) len+=2;else len++;
    }
    return len;
}

/*
 用途：检查输入字符串是否只由字母、数字组成
 输入：
 value：字符串
 返回：
 如果通过验证返回true,否则返回false
 */
function f_check_NumOrLett(obj,code){ //判断是否是字母、数字组成
    if(obj && obj.value){
        var regu = "^[0-9a-zA-Z]+$";
        var re = new RegExp(regu);
        var mm = obj.value.replace(/\s/g,'') ;
        if (re.test(mm)) {
            return true;
        }
        f_alert(code,"请输入字母或数字");
        //obj.focus();
        return false;
    }
    return false;
}


function f_check_NumLength(obj,code){
    if(obj && obj.value){
        if((obj.value.length >=2)&&(obj.value.length<=8)){
            return true;
        }else{
            f_alert(code,"长度在2和8之间");
            //obj.focus();
            return false;
        }
    }
    return false;
}

/*
 * 校验数字的长度和精度
 */
function f_check_double(obj,code){
    if(obj && obj.value){
        var numReg;
        var value = obj.value;
        var strValueTemp, strInt, strDec;
        var dtype = obj.eos_datatype;
        var pos_dtype = dtype.substring(dtype.indexOf("(")+1,dtype.indexOf(")")).split(",");
        var len = pos_dtype[0], prec = pos_dtype[1];
        try{
            numReg =/[\-]/;
            strValueTemp = value.replace(numReg, "");
            numReg =/[\+]/;
            strValueTemp = strValueTemp.replace(numReg, "");
            //整数
            if(prec==0){
                numReg =/[\.]/;
                if(numReg.test(value) == true){
                    f_alert(code, "输入必须为整数类型");
                    //obj.focus();
                    return false;
                }
            }
            if(strValueTemp.indexOf(".") < 0 ){
                if(strValueTemp.length >( len - prec)){
                    f_alert(code, "整数位不能超过"+ (len - prec) +"位");
                    //obj.focus();
                    return false;
                }
            }else{
                strInt = strValueTemp.substr( 0, strValueTemp.indexOf(".") );
                if(strInt.length >( len - prec)){
                    f_alert(code, "整数位不能超过"+ (len - prec) +"位");
                    //obj.focus();
                    return false;
                }
                strDec = strValueTemp.substr( (strValueTemp.indexOf(".")+1), strValueTemp.length );
                if(strDec.length > prec){
                    f_alert(code, "小数位不能超过"+  prec +"位");
                    //obj.focus();
                    return false;
                }
            }
            return true;
        }catch(e){
            f_alert('',"in f_check_double = " + e);
            //obj.focus();
            return false;
        }
    }
    return false;
}

/*
 用途：检查输入对象的值是否符合E-Mail格式
 输入：str 输入的字符串
 返回：如果通过验证返回true,否则返回false
 */
function f_check_email(obj){
    if(obj && obj.value){
        var myReg = /^([-_A-Za-z0-9\.]+)@([_A-Za-z0-9]+\.)+[A-Za-z0-9]{2,3}$/;
        if(myReg.test(obj.value))
            return true;
        f_alert('',"请输入合法的电子邮件地址\r\n如：zhanglianfeng@163.com");
        //obj.focus();
        return false;
    }
    return false;
}

/**
 * 校验两个表单域数据的大小，目前只允许比较数字。
 * @param obj1 小值表单域
 * @param obj2 大值表单域
 */
function checkIntervalObjs(obj1 , obj2,code){
    var val1 = parseFloat(obj1.value);
    var val2 = parseFloat(obj2.value);
    // 数字类型的比较
    if((isNaN(val1) && !isnull(val1)) || (isNaN(val2) && !isnull(val2))){
        f_alert(code,"值不为数字则不能比较！");
        //obj1.focus();
        return false;
    }
    if(val1 > val2){
        //obj2.focus();
        f_alert(code,"起始值不能大于终止值！");
        return false;
    }
    return true;
}

/* 判断是否为邮政编码 */
function f_check_zipcode(obj){
    if(!f_check_number(obj,'邮编'))
        return false;
    if(obj.value.length!=6){
        f_alert('',"邮政编码长度必须是6位");
        //obj.focus();
        return false;
    }
    return true;
}

/*
 要求：一、移动电话号码为11或12位，如果为12位,那么第一位为0
 二、11位移动电话号码的第一位和第二位为"13"
 三、12位移动电话号码的第二位和第三位为"13"
 用途：检查输入手机号码是否正确
 输入：
 s：字符串
 返回：
 如果通过验证返回true,否则返回false
 */
function f_check_mobile(obj){
    if(obj && obj.value){
        var regu =/(^[1][0-9]{10}$)|(^0[1][0-9]{10}$)/;
        var re = new RegExp(regu);
        if (re.test(obj.value)) {
            return true;
        }
        f_alert('',"请输入正确的手机号码\r\n如：18795971072");
        //obj.focus();
        return false;
    }
    return false;
}

/*
 要求：一、电话号码由数字、"("、")"和"-"构成
 二、电话号码为3到8位
 三、如果电话号码中包含有区号，那么区号为三位或四位
 四、区号用"("、")"或"-"和其他部分隔开
 用途：检查输入的电话号码格式是否正确
 输入：
 strPhone：字符串
 返回：
 如果通过验证返回true,否则返回false
 */
function f_check_phone(obj){
    if(obj && obj.value){
        var regu =/^((([0\+]\d{2,3}-)?(0\d{2,3})-)(\d{7,8})(-(\d{3,}))?$)/;
        var re = new RegExp(regu);
        if (re.test(obj.value)) {
            return true;
        }
        f_alert('',"请输入正确的电话号码\r\n如：024-49309744");
        // obj.focus();
        return false;
    }
}

/**
 * 检测字符串是否为空
 */
function isnull(str){
    var i;
    if(str.length == 0)
        return true;
    for (i=0;i<str.length;i++){
        if (str.charAt(i)!=' ')
            return true;
    }
    return false;
}

/**
 * 检测字符串是否为空
 */
function isNotNull(obj,code){
    var i;
    var str = obj.value;
    if(str == null || str == ""){
        f_alert(code,"请输入内容！");
        //obj.focus();
        return false;
    }
    return true;
}
/**
 * 检测字符串是否为空 ,返回为空对象提示字符串
 */
function isNotNullRetureStr(obj,code){
    try{
        var str = obj.value;
        if(str == null || str == ""){
            return code+"：请选择或输入内容！<br>";
        }
        return "";
    }catch(e){
        return "";
    }
    return "";
}
/**
 * 检测字符串为空
 */
function isNull(obj,code){
    var i;
    var str = obj.value;
    if(str != ""){
        //obj.focus();
        return false;
    }
    return true;
}
/**
 * 判断是否是汉字、字母、数字组成[^%&',;=?$\x22]
 */
function f_check_ZhOrNumOrLett(obj,code){ //判断是否是汉字、字母、数字组成
    if(obj && obj.value){
        var regu = "^[0-9a-zA-Z\u4e00-\u9fa5]+$";
        var re = new RegExp(regu);
        if (re.test(obj.value)) {
            return true;
        }
        f_alert(code,"请输入常用字符或文字,\n不能含有特殊字符和空格!");
        return false;
    }
    return false;
}

function f_alert(code,str){
    var msg = "";
    if(code && code != ""){
        msg = code+":"+str;
    }else{
        msg = str;
    }
    msg = msg.replace(/\\n/g,"\n");
    layerAlert(msg);
}

/*
 重写toFixed方法
 */
Number.prototype.toFixed = function(s) {
    var tmp = 0.5;
    if (this < 0) {
        tmp = -0.5;
    }
    var changenum = (parseInt(this * Math.pow(10, s) + tmp) / Math.pow(10, s)).toString();
    var index = changenum.indexOf(".");
    if (index < 0 && s > 0) {
        changenum += ".";
        for (i = 0; i < s; i++) {
            changenum += "0";
        }
    } else {
        index = changenum.length - index;
        for (i = 0; i < (s - index) + 1; i++) {
            changenum += "0";
        }
    }
    return changenum;
}

/*
 去掉double类型小数点后面多余的0
 参数：old 要处理的字符串或double
 返回值：newStr 没有多余零的小数或字符串
 例： cutZero(123.000) -> 123
 cutZero(123.0001) -> 123.0001
 cutZero(10203000.0101000) -> 10203000.0101
 cutZero(10203000) -> 10203000
 */
function cutZero(old){
    //拷贝一份 返回去掉零的新串
    var newstr=old;
    //循环变量 小数部分长度
    var leng = old.length-old.indexOf(".")-1
    //判断是否有效数
    if(old.indexOf(".")>-1){
        //循环小数部分
        for(i=leng;i>0;i--){
            //如果newstr末尾有0
            if(newstr.lastIndexOf("0")>-1 && newstr.substr(newstr.length-1,1)==0){
                var k = newstr.lastIndexOf("0");
                //如果小数点后只有一个0 去掉小数点
                if(newstr.charAt(k-1)=="."){
                    return  newstr.substring(0,k-1);
                }else{
                    //否则 去掉一个0
                    newstr=newstr.substring(0,k);
                }
            }else{
                //如果末尾没有0
                return newstr;
            }
        }
    }
    return old;
}
/**
 * 格式化数字小数位
 */
function formatNumberHandler(obj,decimal,title){
    var area = $(obj).val();
    if (area && jQuery.trim(area)!=""){
        if(f_check_number(obj,title)){
            area = Number(parseFloat(area)).toFixed(decimal);
            $(obj).val(area);
        }
    }
}
//****************以下是js关于数值精准计算的加减乘除算法*********************
/**
 * 精准计算js两个数值的相加，避免精度问题
 */
function accAdd(arg1,arg2){
    if(!arg1 || arg1 == ""){
        arg1 = 0;
    }
    if(!arg2 || arg2 == ""){
        arg2 = 0;
    }
    var r1,r2,m;
    try{r1=arg1.toString().split(".")[1].length;}catch(e){r1=0;}
    try{r2=arg2.toString().split(".")[1].length;}catch(e){r2=0;}
    m=Math.pow(10,Math.max(r1,r2)) ;
    return (accMul(arg1,m)+accMul(arg2,m))/m ;
}
//给Number类型增加一个add方法，调用起来更加方便。
Number.prototype.add = function (arg){
    return accAdd(arg,this);
}
//调用：accDiv(arg1,arg2)
//返回值：arg1除以arg2的精确结果
function accDiv(arg1,arg2){
    if(!arg1 || arg1 == ""){
        arg1 = 0;
    }
    if(!arg2 || arg2 == ""){
        return null;
    }
    var t1=0,t2=0,r1,r2;
    try{t1=arg1.toString().split(".")[1].length}catch(e){}
    try{t2=arg2.toString().split(".")[1].length}catch(e){}
    with(Math){
        r1=Number(arg1.toString().replace(".",""))
        r2=Number(arg2.toString().replace(".",""))
        return (r1/r2)*pow(10,t2-t1);
    }
}
//给Number类型增加一个div方法，调用起来更加方便。
Number.prototype.div = function (arg){
    return accDiv(this, arg);
}
//乘法函数，用来得到精确的乘法结果
//说明：javascript的乘法结果会有误差，在两个浮点数相乘的时候会比较明显。这个函数返回较为精确的乘法结果。
//调用：accMul(arg1,arg2)
//返回值：arg1乘以arg2的精确结果
function accMul(arg1,arg2){
    if(!arg1 || arg1 == ""){
        arg1 = 0;
    }
    if(!arg2 || arg2 == ""){
        arg2 = 0;
    }
    var m=0,s1=arg1.toString(),s2=arg2.toString();
    try{m+=s1.split(".")[1].length}catch(e){}
    try{m+=s2.split(".")[1].length}catch(e){}
    return Number(s1.replace(".",""))*Number(s2.replace(".",""))/Math.pow(10,m)
}
//给Number类型增加一个mul方法，调用起来更加方便。
Number.prototype.mul = function (arg){
    return accMul(arg, this);
}
/**
 * 精准计算两数值相减
 */
function accSubtr(arg1,arg2){
    if(!arg1 || arg1 == ""){
        arg1 = 0;
    }
    if(!arg2 || arg2 == ""){
        arg2 = 0;
    }
    var r1,r2,m,n;
    try{r1=arg1.toString().split(".")[1].length}catch(e){r1=0}
    try{r2=arg2.toString().split(".")[1].length}catch(e){r2=0}
    m=Math.pow(10,Math.max(r1,r2));
    //last modify by deeka
    //动态控制精度长度
    n=(r1>=r2)?r1:r2;
    return ((arg1*m-arg2*m)/m).toFixed(n);
}
//给Number类型增加一个subtr方法，调用起来更加方便。
Number.prototype.subtr = function (arg){
    return accSubtr(this, arg);
}
//*************************************
/**
 * 替换
 */
String.prototype.replaceAll = function(reallyDo, replaceWith, ignoreCase) {
    if (!RegExp.prototype.isPrototypeOf(reallyDo)) {
        return this.replace(new RegExp(reallyDo, (ignoreCase ? "gi": "g")), replaceWith);
    }else {
        return this.replace(reallyDo, replaceWith);
    }
}
String.prototype.endWith=function(s){
    if(s==null||s==""||this.length==0||s.length>this.length)
        return false;
    if(this.substring(this.length-s.length)==s)
        return true;
    else
        return false;
}

String.prototype.startWith=function(s){
    if(s==null||s==""||this.length==0||s.length>this.length)
        return false;
    if(this.substr(0,s.length)==s)
        return true;
    else
        return false;
}

$(function(){
    var otherHeight = $('.toolbar').height()+48;
    resizeFormWidthAndHeight(otherHeight);

    $(window).resize(function() {
        resizeFormWidthAndHeight(otherHeight);
    });

    setTimeout(function() {
        clearZero();
        checkNumber();

        // 只读文字变灰
        dealReadonly();
    }, 100);

    $("form").each(function(){
        goCheck($(this).attr("id"));
    });

    /**
     * 监控searchForm区域 键盘监听事件（适用于台账查询）
     * @param e
     */
    $("#searchForm").bind("keypress", function(e) {
        var theEvent = e || window.event;
        var code = theEvent.keyCode || theEvent.which || theEvent.charCode;
        if (code == 13) {
            e.preventDefault();//回车执行查询
            pagination_pagination();
        }
    });
    $("#searchForm select").change(function(){
        pagination_pagination();
    });
});

/**
 * 只读文字变灰
 */
function dealReadonly() {
    //$("input[readonly='readonly'],input[readonly='true']").css("color", "#bbb");
    $("input[readonly='readonly'],input[readonly='true']").css("background-color", "#f0f0f0");
    $("td[readonly]").css("background-color", "#f0f0f0");
}

/**
 * 校验数字
 */
function checkNumber() {
    $(".digits,.number0").keyup(function(){
        $(this).val($(this).val().replace(/[^\d]/g,''));
    });
    $(".digits,.number0").blur(function(){
        $(this).val($(this).val().replace(/[^\d]/g,''));
    });
    $(".number,.number2,.number4,.number5").keyup(function(){
        $(this).val($(this).val().replace(/[^\d.]/g,''));
    });
    $(".number,.number2,.number4,.number5").blur(function(){
        $(this).val($(this).val().replace(/[^\d.]/g,''));
    });
    // 允许负数
    $("._digits,._number0").keyup(function(){
        $(this).val($(this).val().replace(/[^-\d]/g,''));
    });
    $("._digits,._number0").blur(function(){
        $(this).val($(this).val().replace(/[^-\d]/g,''));
    });
    $("._number,._number2,._number4,._number5").keyup(function(){
        $(this).val($(this).val().replace(/[^-\d.]/g,''));
    });
    $("._number,._number2,._number4,._number5").blur(function(){
        $(this).val($(this).val().replace(/[^-\d.]/g,''));
    });
}

function resizeFormWidthAndHeight(otherHeight){
    $(".gt-min-h").css("min-height",$(window).height()-otherHeight);

    /**/
    if($(".gt-min-h").width() > 0){
        $(".gt-head").width($(".gt-min-h").width());
    }else if($(".contentBox").width() > 0){
        $(".gt-head").width($(".contentBox").width());
    }

    if($(".gt-head").width() > $(window).width()){
        $(".gt-head").width($(window).width()-50);
    }
}

// 0显示为空
function clearZero(){
    /*$.each($("input.input-text"), function(){
        if (($.trim($(this).attr("type")) == "" || $(this).attr("type").indexOf("text") != -1) && $(this).val() == 0) {
            $(this).val("");
        }
    });
    $.each($("td"), function(){
        if ($(this).html() == 0) {
            $(this).html("");
        }
    });*/
}

(function($){
    $.fn.serializeJson=function(){
        var serializeObj={};
        var array=this.serializeArray();
        var str=this.serialize();
        $(array).each(function(){
            if(serializeObj[this.name]){
                if($.isArray(serializeObj[this.name])){
                    serializeObj[this.name].push(this.value);
                }else{
                    serializeObj[this.name]=[serializeObj[this.name],this.value];
                }
            }else{
                serializeObj[this.name]=this.value;
            }
        });
        return serializeObj;
    };
})(jQuery);

/**
 * 平均质量等别四舍五入规则
 * @param val
 */
function getPjzldb(val) {
    try{
        if($.trim(val) != ""){
            var tmp = Math.floor(parseFloat(val));
            if ((parseFloat(val) - tmp) == 0.5 && tmp % 2 == 0) {
                return tmp;
            } else {
                return Math.round(parseFloat(val));
            }
        } else {
            return "";
        }
    } catch (e) {
        return "";
    }
}

/*全选/取消*/
function checkAll(obj, name){
    $("input[type='checkbox'][name='"+name+"']:visible").prop("checked", obj.checked);
}
/*获取已选择对象*/
function checkedObj(name) {
    return $("input[type='checkbox'][name='"+name+"']:visible:checked");
}
/*获取所选记录，以逗号隔开*/
function getChecked(name){
    return getCheckedByAttr(name, "value");
}
/*获取所选记录对应属性值，以逗号隔开*/
function getCheckedByAttr(name, attr){
    var val = "";
    var check = checkedObj(name);
    check.each(function(){
        val += $(this).attr(attr) + ",";
    });
    if(val.length>0){
        val = val.substring(0, val.length - 1);
    }
    return val;
}

/**
 * 弹出新页面（使用之前需要引用layer）
 */
function layerOpen(url, width, height, title,resize,layId){
    if(!width){
        width = $(window).width() * 0.9;
    }
    if(!height){
        height = $(window).height() * 0.9;
    }
    if(!title){
        title = '　';
    }
    var left = ($(window).width()-width)/2;
    var top = ($(window).height()-height)/2;
    layui.use('layer', function(){
        var layer = layui.layer;

        layer.open({
            id:"layer_"+layId+"",
            type: 2,
            title: title,
            fix: false,
            offset: [top+'px',left + 'px'],
            shadeClose: true,
            resize: resize?resize:false,
            maxmin: resize?resize:false,//true,
            area: [width + 'px', height + 'px'],
            content: url
        });
    });

}
function topLayerOpen(url, width, height, title,resize,layId){
    if(!width){
        width = $(window).width() * 0.9;
    }
    if(!height){
        height = $(window).height() * 0.9;
    }
    if(!title){
        title = '　';
    }
    var left = ($(window.top.document).width()-width)/2;
    var topSize = ($(window.top.document).height()-height)/2;
    layui.use('layer', function(){
        var layer = layui.layer;

        top.layer.open({
            id:"layer_"+layId+"",
            type: 2,
            title: title,
            fix: false,
            offset: [topSize+'px',left + 'px'],
            shadeClose: false,
            resize: resize?resize:false,
            maxmin: resize?resize:false,//true,
            area: [width + 'px', height + 'px'],
            content: url
        });
    });

}
/**
 * 信息提示
 * @param msg
 * @param reload 等于true刷新页面，可以不传
 * @param func 回调函数
 */
function layerAlert(msg, reload, func, icon) {
    layerMsgShow(msg, reload, func, icon);
}

/**
 * 信息提示
 * @param msg
 * @param reload 等于true刷新页面，可以不传
 * @param func 回调函数
 */
function layerWarn(msg, reload, func) {
    layerMsgShow(msg, reload, func, 0);
}

/**
 * 信息提示
 * @param msg
 * @param reload 等于true刷新页面，可以不传
 * @param func 回调函数
 */
function layerMsgShow(msg, reload, func, icon) {
    var _msg = "　";
    var _icon = 7;

    if("string" != typeof msg){
        if(msg.result == false){
            _icon = 2;
        } else {
            _icon = 1;
        }
        if(msg.msg){
            _msg = msg.msg;
        }
    } else {
        _msg = msg;
    }

    if ($.trim(icon) != "" && formatNum(icon) >= 0 && formatNum(icon) <= 7) {
        _icon = formatNum(icon);
    }

    layer.alert(_msg, {icon: _icon});
    $(".layui-layer-close").remove();
    if (reload == true) {
        $(".layui-layer-btn0").click(function(){
            location.reload();
        });
    } else {
        $(".layui-layer-btn0").click(function(){
            if ($.trim(func) != "") {
                try{
                    eval(func);
                }catch(e){}
            }
        });
    }
}

/**
 * 询问框
 * @param msg 消息
 * @param callback 确认回调事件
 * @param cancel 取消回调事件
 */
function layerConfirm(msg, callback, cancel) {
    msg = $.trim(msg) == "" ? "　" : msg;
    layui.use("layer", function () {
        var layer = layui.layer;
        layer.confirm(msg, {icon: 3, title: '提示'}, function (index) {
            if (typeof callback == "function") {
                callback();
            }
            layer.close(index);
        }, function () {
            if (typeof cancel == "function") {
                cancel();
            }
        });
    });
}

/**
 * 表单校验
 * @param form
 */
function goCheck(form) {
    if ($.trim(form) != "") {
        $("#" + form).validate({
            onfocusout : function(element) { $(element).valid(); }
            //onfocusin: function(element) { $(element).valid(); },
            //onfocusout: function(element) { $(element).valid(); },
            //onclick: function(element) { $(element).valid(); },
            //onkeyup: function(element) { $(element).valid(); }
        });
    }
    // 表单验证
    $.validator.addMethod("number0", function(value, element) {
        var reg = /^\d+$/;
        return value == "" || reg.test(value);
    }, "请输整数");
    $.validator.addMethod("number2", function(value, element) {
        var reg = /^\d+\.{0,1}\d{0,2}$/;
        return value == "" || reg.test(value);
    }, "请输2位小数");
    $.validator.addMethod("number4", function(value, element) {
        var reg = /^\d+\.{0,1}\d{0,4}$/;
        return value == "" || reg.test(value);
    }, "请输4位小数");
    $.validator.addMethod("number5", function(value, element) {
        var reg = /^\d+\.{0,1}\d{0,5}$/;
        return value == "" || reg.test(value);
    }, "请输5位小数");
    // 表单验证(允许负数)
    $.validator.addMethod("_number0", function(value, element) {
        var reg = /^-{0,1}\d+$/;
        return value == "" || reg.test(value);
    }, "请输整数");
    $.validator.addMethod("_number2", function(value, element) {
        var reg = /^-{0,1}\d+\.{0,1}\d{0,2}$/;
        return value == "" || reg.test(value);
    }, "请输2位小数");
    $.validator.addMethod("_number4", function(value, element) {
        var reg = /^-{0,1}\d+\.{0,1}\d{0,4}$/;
        return value == "" || reg.test(value);
    }, "请输4位小数");
    $.validator.addMethod("_number5", function(value, element) {
        var reg = /^-{0,1}\d+\.{0,1}\d{0,5}$/;
        return value == "" || reg.test(value);
    }, "请输5位小数");
}

/**
 * 格式化控件小数位
 * @param obj
 * @param point 小数位
 * @param sfbl 是否补零
 * @param doChild 是否处理子节点标签
 */
function setNumFormat(obj,point,sfbl,doChild){
    if(point == null || point == ""){
        point = 0;
    }
    var type = 0;
    var str = "";
    try{
        var tagName=$(obj)[0].tagName;//.attr("tagName");
        if(tagName=="INPUT"){//如果该控件为input
            str = $(obj).val();
            type = 2;
        }else if(tagName=="TD"){//如果该控件为td
            if(doChild){
                if($(obj).children()){
                    var tempObj = $(obj).children().eq(0);
                    if($(tempObj) && $(tempObj).attr("tagName")){
                        if($(tempObj).attr("tagName")=="INPUT"){//如果该控件为td
                            setNumFormat(tempObj,point,sfbl);
                        }else if($(tempObj).attr("tagName")=="SELECT"){//如果该控件为td
                            return;
                        }else if($(tempObj).attr("tagName")=="A"){//如果该控件为td
                            return;
                        }else if($(tempObj).attr("tagName")=="IMG"){//如果该控件为td
                            return;
                        }else{
                            return;
                        }
                    }else{
                        str = $(obj).text();
                        type = 1;
                    }
                }
            }else{
                if(!$(obj).children() || $(obj).children().length<1){
                    str = $(obj).text();
                    type = 1;
                }
            }
        }else if(tagName=="LABEL"){//可能是其他控件，比如label等，需要用text方法获取数据
            str = $(obj).text();
            type = 1;
        }else{
            return;
        }
    }catch(e){
    }
    if(type == 0){
        return;
    }
    try{
        var isnum = false;
        if(str != null && str != ""){
            var tempPoint = point;
            var index = str.length;
            if(str.indexOf('.') > -1){
                str = replaceEscape(str);
                str = str.replaceAll(" ", "", true);
                index = str.indexOf('.');//用于截取数据
                var lastStr = str.substring(index+1);
                if(lastStr.length < tempPoint){
                    tempPoint = lastStr.length;
                }
                if(tempPoint > 0){
                    index += tempPoint+1;
                }

                //正则判断是否为数字类型
                if (/^\-?[0-9]*\.?[0-9]*$/.test(str)){
                    str = Number(Number(parseFloat(str)).toFixed(tempPoint));//格式化
                    /*if(str.indexOf('.') > -1){//如果格式化失败，则强制截取
                     str = str.substring(0,index);
                     }*/
                    isnum = true;
                }
                str = str+"";
                if ((str+"").indexOf("E") > -1 || (str+"").indexOf("e") > -1){
                    //正则表达式-科学技术法
                    var regex1 = /^[-]?(0|[1-9]\d*)(\.\d+)?([eE][+-]?\d+)?$/;
                    var regex2 = /^(-)?(0|[1-9][0-9]*)(\.[0-9]+)?([eE][+-]?[0-9]+)?$/;
                    if(regex1.test(str) || regex2.test(str)){
                        str = scienceNum(str);
                        if((str+"").indexOf('.') > -1 && point > 0){//如果格式化失败，则强制截取
                            index = str.indexOf('.');//用于截取数据
                            var lastStr = str.substring(index+1);
                            if(lastStr.length < point){
                                point = lastStr.length;
                            }
                            if(point > 0){
                                index += point+1;
                            }
                            str = str.substring(0,index);
                        }
                        isnum = false;
                    }
                }
            }else if(str == "0"){
                str = "";
            }
        }

        if(isnum){
            if(!sfbl){
                str = parseFloat(str);
            }else{
                str = formatnumber(parseFloat(str),point);
            }
            if(str==0){
                str = "";
            }
        }
        if(type == 1){
            $(obj).text(str);
            return str;
        }else if(type == 2){
            $(obj).val(str);
            return str;
        }
    }catch(e){
    }
}
/**
 * 根据控件id获取控件的数值型返回值
 * @param id
 * @returns {Number}
 */
function getNumberValueById(id){
    var str = $("#"+ id).val();
    var value = 0.0;
    if(str != null && str != ''){
        value = parseFloat(str);
    }
    return value;
}
function getStringValueById(id){
    var str = $("#"+ id).val();
    var value = "";
    if(str != null && str != ''){
        value = str;
    }
    return value;
}
function formatInputValue(obj,point,sfbl){
    if(f_check_number(obj,'')){
        var value = $(obj).val();
        if (value && jQuery.trim(value)!=""){
            var str = numberPointFormat(value,null,null,point);
            if(!sfbl){
                $(obj).val(str);
                str = setNumFormat(obj,point,sfbl,false);
            }
            if(!str || str==0){
                str = "";
            }
            $(obj).val(str);
        }
    }else{
        $(obj).val("");
    }
}

/**
 * 合并表格中的单元格
 * @param $rows 表格中的所有行对象
 * @param startIndex 从第几列开始处理
 * @param total 需要处理的列数
 * 调用方式：
 groupTable($('#test tr:has(td)'), 0, 4);
 $('#test .deleted').remove();
 *  引用网址：http://techbrij.com/html-table-row-grouping-jquery
 */
function groupTableTdInput($rows, startIndex, total) {
    if (total === 0) {
        return;
    }
    var i, currentIndex = startIndex, count = 1, lst = [];
    var tds = $rows.find('td:eq(' + currentIndex + ')');//获取当前列号的所有列集合（该列的所有td）
    var ctrl = $(tds[0]);//获取列集合的第一个列td（第一次执行则是第一个td数据）
    lst.push($rows[0]);//将该td所在行放入数组（第一次执行则是第一行数据）
    //遍历该列集合
    for (i = 1; i <= tds.length; i++) {
        if (!ctrl.html()){
            ctrl.html('<label>&nbsp</label>');
        }
        if (!$(tds[i]).html()){
            $(tds[i]).html('<label>&nbsp</label>');
        }
        if (ctrl.html() && ctrl.html() == $(tds[i]).html()) {
            //如果上一个td内容等于当前td内容，则count加1，
            //且当前td增加deleted样式进行标识（用于后期删除使用）
            //将该td所在行放入数组
            count++;
            $(tds[i]).addClass('deleted');
            lst.push($rows[i]);
        } else {
            //如果上一个td内容不等于当前td内容，则进行如下判断和操作：
            //如果count大于1，则表示有相同的td需要合并，
            //对该td的rowspan赋值，值为需要合并的行数
            //此时递归调用该方法，对之前合并单元格所涉及到的行数据进行处理（用于处理后面列的td合并）
            //处理方式是当前列后面一列进行操作，total减少一个（当前操作的列）直至total为0
            if (count > 1) {
                ctrl.attr('rowspan', count);
                //ctrl.css("vertical-align","middle");
                //ctrl.css("text-align","center");
                groupTableTdInput($(lst), startIndex + 1, total - 1)
            }
            //将count初始化为1
            //数据初始为空
            //td初始化为当前td
            //将该td所在行放入数组
            count = 1;
            lst = [];
            ctrl = $(tds[i]);
            lst.push($rows[i]);
        }
        //$(tds[i]).css("text-align","center");
        //$(tds[i]).css("vertical-align","middle");
    }
}

//打开新窗口
function openUrl(url, width, height, resizable) {
    if (url) {
        var w_width = screen.availWidth-14;
        var w_height = screen.availHeight-66;
        var left = 1;
        var top = 0;
        if (width) {
            w_width = width;
            left = (screen.availWidth - w_width) / 2;
        }
        if (height) {
            w_height = height;
            top = (screen.availHeight - w_height) / 2;
        }
        if (!resizable) {
            resizable = "yes";
        }
        window.open(url, "_blank", "left=" + left + ",top=" + top + ",height=" + w_height + ",width=" + w_width + ",resizable=" + resizable + ",scrollbars=yes");
    }
}

/**
 * 创建工作流后打开并刷新portal待办任务列表
 * @param returnstr
 */
function openTaskWin(taskId){
    var tmpUrl = platformUrl + "/taskhandle.action?taskid=" + taskId;
    if(portalStyle == 'true'){
        tmpUrl = portalUrl + "/taskHandle?taskid=" + taskId;
    }
    openUrl(tmpUrl);
    $.cookie('portal_index_tasklist',"tasklist", { expires: 7, path: '/'});
}

/**
 * 创建工作流后打开并刷新portal待办任务列表
 * @param returnstr
 */
function openTask(taskId){
    if (useLayerOpen == "true") {
        openTaskWin(taskId);
    } else {
        if($.trim(taskId) != ""){
            var tmpUrl = platformUrl + "/taskhandle.action?taskid=" + taskId;
            if(portalStyle == 'true'){
                tmpUrl = portalUrl + "/taskHandle?taskid=" + taskId;
            }
            openUrl(tmpUrl);
        }
        $.cookie('portal_index_tasklist',"tasklist", { expires: 7, path: '/'});
        if (self != top) {
            window.top.close();
        }
        window.close();
    }
}

//下载的公共方法
function downloadURL(url) {
    var hiddenIFrameID = 'hiddenDownloader';
    var iframe = document.getElementById(hiddenIFrameID);
    if (iframe === null) {
        iframe = document.createElement('iframe');
        iframe.id = hiddenIFrameID;
        iframe.style.display = 'none';
        document.body.appendChild(iframe);
    }
    iframe.src = url;
}

/**
 * 向工具栏中插入一个功能按钮
 * @param btnClass 按钮样式
 * @param btnSize 按钮大小
 * @param btnFunction 按钮功能
 * @param btnIcon 按钮图标
 * @param btnIconSize 按钮图标大小
 * @param btnName 按钮文字
 * @param index 插入序号 如果序号大于工具栏数量则在最后进行插入
 */
function insertBtnInToolbar(btnClass,btnSize,btnFunction,btnIcon,btnIconSize,btnName,index){
    if(!btnClass){
        btnClass = "layui-btn";
    }
    if(!btnSize){
        btnSize = "size-S";
    }
    if(!btnIconSize){
        btnIconSize = "icon-large";
    }
    //var btn = $('<button class="btn btn-danger size-S" type="button" onclick="goDel()"><i class="icon-trash icon-large"></i> 除dddd</button>');
    var btn = $('<button class="layui-btn '+btnClass+' '+btnSize+'" type="button" onclick="'+btnFunction+'"><i class="'+btnIcon+' '+btnIconSize+'"></i> '+btnName+'</button>');
    var size = $('.toolbar button').length;
    if(!size || size ==0 || size < index){
        $('.toolbar button:last').after(btn);
    }else{
        $('.toolbar button:nth-child('+index+')').after(btn);
        $('.toolbar button:nth-child('+index+')').after(' ');
    }
}
/**
 * 向工具栏中最后面追加一个功能按钮
 * @param btnClass 按钮样式
 * @param btnSize 按钮大小
 * @param btnFunction 按钮功能
 * @param btnIcon 按钮图标
 * @param btnIconSize 按钮图标大小
 */
function appendBtnInToolbar(btnClass,btnSize,btnFunction,btnIcon,btnIconSize,btnName){
    if(!btnClass){
        btnClass = "layui-btn";
    }
    if(!btnSize){
        btnSize = "size-S";
    }
    if(!btnIconSize){
        btnIconSize = "icon-large";
    }
    var btn = $('<button class="layui-btn '+btnClass+' '+btnSize+'" type="button" onclick="'+btnFunction+'"><i class="'+btnIcon+' '+btnIconSize+'"></i> '+btnName+'</button>');
    $('.toolbar button:last').after(' ');
    $('.toolbar button:last').after(btn);
}

/**
 * 展示自定义layer，该layer采用了layer插件的原生ui
 * @param modalId
 */
function showCustonLayer(modalId){
    var divTop = ($(window).height()-$('#'+modalId).height()-$('#'+modalId).height())/2;
    if(divTop<50){
        divTop = 50;
    }
    var divLeft = ($(window).width()-$('#'+modalId).width())/2;
    $('#'+modalId).css("top", divTop+"px");
    $('#'+modalId).css("left", divLeft+"px");
    $('#'+modalId).show();
}

function openFileUploadLayer(fileUploadUrl,uploadSaveUrl,checkType){
    layui.use('layer', function(){
        var layer = layui.layer;

        layer.open({
            title: '<i class="icon-cloud-upload"></i>上 传',
            type: 2,
            shadeClose: true,
            shade: false,
            maxmin: false, //开启最大化最小化按钮
            area: ['500px', '200px'],
            content: [fileUploadUrl + uploadSaveUrl + checkType, 'no']
        });
    });
}

/**
 * 获取查询栏数据，包括高级查询框，根据class名字为form-search的匹配
 * @param pageId
 */
function getQueryparam(pageId) {
    var param = $(".form-search").serializeJson();
    var pageSize = $("#"+pageId+"_showSize");
    if(pageSize && pageSize.length > 0){
        param['pageSize'] = pageSize.val();
    }
    return JSON.stringify(param);
}

/**
 * 打开页面
 * @param url
 */
function openWindow(url){
    window.open(url,'input');
}

/**
 * 获取复选框中选择的数据，作为参数补充到url中进行打开访问
 * @param url
 * @param checkName
 */
function openEditWindow(url,checkName){
    var check = $("input[name='"+checkName+"']:checked");
    if (check.length > 0) {
        if (check.length > 1) {
            layerAlert('只能选择一条记录！');
            return;
        }
        var ids = getChecked(checkName);
        openWindow(url+ids);
    }else{
        layerWarn('请选择一条记录！');
    }
}

function doDelOperation(url,delIds,checkName) {
    var check = $("input[name='"+checkName+"']:checked");
    if (check.length > 0) {
        layerConfirm("确定删除所选记录吗？", function(){
            var ids = getChecked(checkName);
            var param = {};
            param[delIds]=ids;
            $.ajax({
                type: "post",
                url: url,
                data: param,
                success: function(data){
                    if ($.trim(data.result) == "true") {
                        pagination_pagination();
                    }
                    layerAlert(data.msg);
                }
            });
        });
    }else{
        layerWarn('请选择一条记录！');
    }
}

function initLayuiTab(){
    layui.use('element', function(){
        var $ = layui.jquery;
        var element = layui.element; //Tab的切换功能，切换事件监听等，需要依赖element模块

        //触发事件
        var active = {
            tabChange: function(){
                //切换到指定Tab项
                element.tabChange('assess-detail', '22'); //切换到：用户管理
            }
        };

        /*$('.site-assess-detail-active').on('click', function(){
            var othis = $(this), type = othis.data('type');
            active[type] ? active[type].call(this, othis) : '';
        });*/

        /*//Hash地址的定位
        var layid = location.hash.replace(/^#test=/, '');
        element.tabChange('test', layid);

        element.on('tab(test)', function(elem){
            location.hash = 'test='+ $(this).attr('lay-id');
        });*/

    });
}

/**
 * 打开文件中心
 * @param proid
 */
function openFileCenter(proid, readOnly){
    if($.trim(proid) != "") {
        var tmp = "";
        if($.trim(readOnly) == "true" || role == "role_user"){
            tmp = "readOnly=true&";
        }
        var url = fileCenterUrl + "/fc.do?" + tmp + "proid=" + proid;
        //layerOpen(url, null, null, "<i class='icon-folder-open-alt'></i> 文件中心",true);
        openUrl(url);
    }
}

/**
 * 获取相同name的input控件的合计值
 * @param name input控件name
 * @param num 保留小数位数，默认0
 */
function getSumByName(name, num) {
    var n = 0;
    if($.trim(num) != "" && !isNaN(num) && parseInt(num) > 0 && parseInt(num) <= 20){
        n = parseInt(num);
    }

    var tmp = 0;
    $("input[name='"+name+"']").each(function(){
        tmp += formatNum($(this).val(), n);
    });
    return tmp;
}

/**
 * 初始化平台
 * @param id 控件id
 * @param nd 年度
 * @param init 初始值
 */
function initPt(id, nd, init) {
    $("#" + id).empty();
    $.ajax({
        url: gtProjUrl + '/dic/pt/query?nd=' + nd + "&token=" + token,
        type: 'get',
        success: function (value) {
            $("#" + id).append('<option value="">--请选择--</option>');
            if (value.length > 0) {
                $.each(value, function(idx, val) {
                    var tmp = "";
                    if (init == val) {
                        tmp = ' selected="selected"';
                    }
                    $("#" + id).append('<option value="'+val+'"'+tmp+'>'+val+'</option>');
                });
            }
        }
    });
}

/**
 * layer 弹出窗口关闭
 */
function goClose(){
    var curindex = parent.layer.getFrameIndex(window.name); //先得到当前iframe层的索引
    parent.layer.close(curindex);
}

//帆软编码转换
function cjkEncode(text) {
    if (text == null) {
        return "";
    }
    var newText = "";
    for (var i = 0; i < text.length; i++) {
        var code = text.charCodeAt (i);
        if (code >= 128 || code == 91 || code == 93) {//91 is "[", 93 is "]".
            newText += "[" + code.toString(16) + "]";
        } else {
            newText += text.charAt(i);
        }
    }
    return newText;
}

/**
 * 帆软导出
 * @param filePath 文件路径
 */
function reportExport(filePath){
    if($.trim(filePath) != "") {
        location.href = reportUrl + "/ReportServer?reportlet=" + filePath + "&format=excel&extype=simple";
    }
}

