/**
 * 时间轴
 * @author by <a href="mailto:xxx@gmail.com">cyj</a>
 * @version v1.0 2019  Copyright gtmap Corp
 */
define([
    'knockout',
    'leaflet',
    'css!webjars/lp-webjars/js/jRange/jquery.range.css',
    'webjars/lp-webjars/js/jRange/jquery.range'
], function (ko, L) {
    'use strict';
    var that,LISTEN = [];
    function TimeLine() {
        that = this;
    }

    TimeLine.prototype = {

        /**
         * 渲染时间轴
         * @param DOM
         * @param LIST
         * @param OPTION
         */
        init: function (DOM,LIST,OPTION) {
            this._list = LIST;this._dom = DOM;
            var width = document.body.clientWidth * 0.25;
            // 默认加载第一个年份
            // this.addYearLayer(list[0]);
            // 定义范围与刻度
            var min = 0,max = LIST.length - 1,scale = [];
            $.each(LIST,function (i,e) {
                scale.push(e.year);
            });
            this._option =
                {
                    from: min,
                    to: max,
                    step: 1,
                    scale: scale,
                    format: '%s',
                    width: width,
                    showLabels: false,
                    showScale: true,
                    snap: true,
                    // 只要用户更改了值，就会调用此函数。同样的值也会自动为提供的隐藏输入设置。
                    onstatechange: function a(event) {
                        var message = that._list[event];
                        message.id = that._list.id;
                        // 触发更改图层事件
                        $(document).trigger("timeLine-change",message)
                    }
                };
            // 继承方便调用修改参数
            $.extend(this._option,OPTION);
            $(DOM).jRange(that._option);
            // 绑定播放事件
            bindEvent();
            //重置
            $(DOM).jRange('setValue', '0');
            $(DOM).jRange('setValue', (LIST.length - 1).toString());

        },

        /**
         *
         * @param Event
         */
        addEventListen: function (Event) {
            LISTEN.push(Event);
        },

        removeEventListen: function (Event) {
            LISTEN.splice($.inArray(Event,LISTEN),1);
        }

    };

    /****************************************【逻辑处理层】********/

    var intervalId,index = 0;// 定时器和刻度
    function bindEvent() {
        $("#timeLine-icon").unbind("click").on("click",function () {
            if($(this).hasClass("layui-icon-play")){
                // 播放
                $(this).removeClass("layui-icon-play").addClass("layui-icon-pause");
                play();
            }else {
                // 暂停
                $(this).removeClass("layui-icon-pause").addClass("layui-icon-play");
                pause();
            }
        });
    }

    /*播放*/
    function play() {
        var all = that._list.length;
        $(that._dom).jRange('setValue', "0");
        // 初始化播放
        intervalId = setInterval(
            function () {
                if(index === all){
                    index = 0;
                    clearInterval(intervalId);
                    /* Pop.msg({type:'info',message:"播放结束"});*/
                    $("#timeLine-icon").removeClass("layui-icon-pause").addClass("layui-icon-play");
                }else {
                    $(that._dom).jRange('setValue', (index++).toString());
                }
            }, 2000);
    }

    /*暂停*/
    function pause() {
        clearInterval(intervalId);
        $("#timeLine-icon").removeClass("layui-icon-pause").addClass("layui-icon-play");
    }


    return new TimeLine;
});