/**
 * 渲染图例
 *
 * @author by <a href="mailto:xxx@gmail.com">cyj</a>
 * @version v1.0 2019  Copyright gtmap Corp
 */

define([
    'knockout'
], function (
    ko
) {

    var that,element;
    layui.use('element', function(){
        element = layui.element;
        element.render();
    });
    function ViewModel() {
        that = this;
        this.legendList = ko.observableArray([]);
        this.showLegend = ko.observable(false);
        this.legendTitle = ko.observable("")
    }

    ViewModel.prototype= {
        /**
         * 展开
         * @param btn
         * @param event
         */
        showbody: function (btn, event) {
            var dom = $(event.target);
            if(dom.hasClass("layui-icon-up")){
                dom.removeClass("layui-icon-up").addClass("layui-icon-down");
                dom.parent().css('width','200px');
                $('.monitor-legend-body').show("slow");
            }else {
                dom.removeClass("layui-icon-down").addClass("layui-icon-up");
                dom.parent().css('width','80px');
                $('.monitor-legend-body').hide("slow");
            }
        },

        /**
         * 根据地址读取属性
         * @param url
         */
        init: function (layer) {

            element.render();
            readLegend(layer)
        }
    };

    function readLegend(layer) {
        $.support.cors = true;
        $.ajax({
            url: layer.url + '/legend',
            type: 'get',
            dataType: 'jsonp',
            data: {f: 'pjson'},
            success: function (data, status) {
                if (status === 'success') {

                    var result = data.layers;

                    var LendLayerArr = selectLendLayer(layer,result);

                    $.each(LendLayerArr,function (i,e) {
                        e.url = layer.url;
                    });
                    that.legendList(LendLayerArr);

                    //  $.each(result,function (i,e) {
                    //      e.url = layer.url;
                    //  });
                    // that.legendList(result);
                    element.render();
                }
            }
        });
    }

    /**
     * 过滤 展示的图列
     * @param layer
     * @param result
     * @returns {*}
     */
    function selectLendLayer(layer,result){

        var layerArr = [];
        var selectLayerArr = layer.legendLayer;
        if(selectLayerArr.length > 0){

            for(var i=0;i<selectLayerArr.length;i++){

                if(selectLayerArr[i] !=undefined && parseFloat(selectLayerArr[i]).toString() != "NaN"){

                    if(selectLayerArr[i]<=result.length){
                        var j = selectLayerArr[i];
                        layerArr.push(result[j]);
                    }
                }
            }
        }
        if(layerArr.length == 0){
            return result;
        }else{
            return layerArr;
        }


    }

    return new ViewModel;
});