/**
 * 异常处理组件
 * by 李锐
 * date:2018/09/13
 * v1.1bar
 **/
layui.define(function (exports) {
    "use strict";
    var $ = layui.jquery;
    var errorInfo = "Exception Error:无法获取组件信息,请检查所使用组件的info配置是否被更改";
    var exception = {
        //找不到组件配置
        throwNotFindConfig: function (plugin, configName) {
            throw  new Error("Error:加载组件" + plugin.info.name + "时,-" + configName + "-未定义或者为空,请检查.当前组件版本" + plugin.info.version);
            return;
        },
        throwConfigIsEmpty: function (plugin) {
            if (isNotEmpty(plugin)) {
                errorInfo = plugin.name + " Error:未找到组件配置信息,请检查.";
            }
            throw  new Error(errorInfo);
            return;
        },
        /**
         * 组件容器找不到
         * @param plugin
         */
        throwElemNotFind: function (plugin) {
            if (isNotEmpty(plugin)) {
                errorInfo = plugin.name + " Error:找不到组件容器,请检查页面是否设置id=" + plugin.el + "的容器.version:" + plugin.version;
            }
            throw new Error(errorInfo);
            return;
        },

        /**
         * 组件容器配置错误
         * @param plugin
         * @param configName
         */
        throwElemConfigError: function (plugin) {
            if (isNotEmpty(plugin)) {
                errorInfo = plugin.name + " Error:组件容器配置错误，请检查el.version:" + plugin.version;
            }
            throw  new Error(errorInfo);
            return;
        },
        /**
         * 组件数据为空
         * @param plugin
         */
        throwDataIsEmpty: function (plugin, dataName) {
            if (isNotEmpty(plugin)) {
                errorInfo = plugin.name + " Error:组件配置data " + dataName + "为空,请检查data.version：" + plugin.version;
            }
            throw new Error(errorInfo);
            return;
        },
        /**
         * 组件数据配置错误
         * @param plugin
         * @param dataName
         */
        throwDataCinfigError: function (plugin, dataName) {
            if (isNotEmpty(plugin) && dataName !== null) {
                errorInfo = plugin.name + " Error:组件data " + dataName + "配置错误,请检查data.version:" + plugin.version;
            }
            throw new Error(errorInfo);
        },
        throwError: function (msg) {
            throw new Error(msg);
            return;
        }
    };

    function isNotEmpty(plugin) {
        if (plugin !== undefined && plugin.name !== undefined && plugin.version !== undefined) {
            if (plugin !== null && plugin.name !== null && plugin.version !== null) {
                return true;
            }
        }
        return false;
    }

    exports('exception', exception);
});