/**
 * 行政区定位
 * @author by <a href="mailto:chaomashi@gmail.com">Du</a>
 * @version v1.0 2019/6/11/14:28  Copyright gtmap Corp
 */

define([
    'easyMap/main',
    'leaflet',
    'esri-leaflet',
    'leaflet-pip',
    'easyMap/core/EventBus'
], function (
    MainMap,
    L,
    LEsri,
    leafletPip,
    EventBus
) {
    var instance,
        me = {
            name: 'region',

            // init fun
            init: function () {
                // console.log(this);
                $map = MainMap.map.get$Map();
                getAllRegionsUrl = this.config.getAllRegionsUrl;
                regionUrlPre = this.config.queryUrlPre;
                // regionIndex = "xzq_c_2017_2k,xzq_d_2017_2k";
                var _appConfig = MainMap.appConfig;
                if (_appConfig.hasOwnProperty('regionIndex')) {
                    regionIndex = _appConfig.regionIndex;
                }
                getRegionData();
                //地图移动事件
                $map.on('moveend', function (e) {
                    showPosition();
                });

            },

            // open event
            onOpen: function () {
                // getRegionData();
            },

            // close event 关闭组件
            onClose: function () {
                clearRegionData();
                // $("#regionLi")[0].innerText = "行政区定位";
            },

            //pause event 离开当前组件触发
            onPause: function () {
                clearRegionData();
            }
        };

    var $map,
        regionCode = MainMap.appConfig.regionCode,
        getAllRegionsUrl, //获取所有行政区接口url
        regionUrlPre,  //获取行政区geojson数据的url地址前缀
        regionUrl,    //获取行政区geojson数据的url地址
        xzqmcFather, //父行政区名称
        xzqmcChild,  //子行政区名称
        xzqdmFather,  //父行政区代码
        xzqdmChild,  //子行政区代码
        regionGeoJson = [], //存储图层信息
        interval, //定时器
        regionIndex,
        polygonStyle = MainMap.map.getSymbol("polygon"); //渲染多边形样式

    var fatherCodeList = [], //存储所有父行政区编码
        fatherGeoJson = [], //存储所有父行政区geojson
        centerPt, //地图中心点坐标
        labelText; //工具栏行政区定位的显示文字
    /**
     * loading动画效果加载
     * @param fun 绑定效果的id
     */
    function regionLoading(fun) {
        var x = "";
        interval = setInterval(function () {
            x = (x == '......') ? '.' : (x + '.');
            $("#" + fun).html(x);
        }, 200);
    }

    /**
     * 关闭控件清空行政区图层
     */
    function clearRegionData() {
        $("body").find(".region-children").removeClass("region-children-point");
        $("body").find(".region-father").removeClass("region-title-point");
        if (regionGeoJson.length > 0) {
            regionGeoJson.forEach(function (lyr) {
                $map.removeLayer(lyr);
            });
            regionGeoJson = [];
        }
    }

    /**
     *获取父子行政区数据并展示
     */
    function getRegionData() {
        try {
            //用来存储ajax方法获得的data
            var resultData = [];
            //初始化html拼接页面;
            var regionHtm = "";
            jQuery.support.cors = true;
            //请求数据时加载loading界面
            //请求结束后清空loading页面
            //success后解析数据并拼接展示页面
            $.ajax({
                url: getAllRegionsUrl + regionCode,
                type: 'get',
                //请求数据前加载loading界面
                beforeSend: function () {
                    $("#loadingText").html("loading");
                    clearInterval(interval);
                    // 加载loading动态动画
                    regionLoading("loading");
                },
                success: function (data) {
                    resultData = data;

                    //添加市级刑行政区
                    // regionHtm  += "<fieldset class='layui-elem-field layui-field-title'>" +
                    //     "<legend><a class='region-name-a region-father' data-xzqdm-father-index='"+resultData[0].value+"'>"+resultData[0].name+"</a></legend>" +
                    //     "</fieldset>";

                    if (regionCode.toString().indexOf('0000') === -1 && regionCode.toString().indexOf('00') !== -1) {
                        if (regionIndex.split(',').length > 2) {
                            resultData = data[0].children;
                        }
                    }

                    resultData.forEach(function (region) {
                        fatherCodeList.push(region.value);
                        //获取到父行政区名称
                        xzqmcFather = region.name;
                        regionHtm
                            += "<fieldset class='layui-elem-field layui-field-title'>"
                            + "    <legend><a class='region-name-a region-father' data-xzqdm-father-index='"
                            + region.value
                            + "'>"
                            + xzqmcFather
                            + "</a></legend>" + "<div class='region-children-outDiv'>";
                        //获取到子行政区名称及区代码
                        try {
                            if (region.hasOwnProperty('children')) {
                                for (var i = 0; i < region.children.length; i++) {
                                    xzqmcChild = region.children[i].name;
                                    regionHtm
                                        += "<div class='layui-col-xs3'>"
                                        + "<div class='region-children' data-xzqdm-child-index='"
                                        + region.children[i].value
                                        + "'>"
                                        + "<p class='region-location'>"
                                        + xzqmcChild
                                        + "</p>"
                                        + "</div>"
                                        + "</div>";
                                }
                            }
                        } catch (e) {
                        }
                        regionHtm
                            += "</div>"
                            + "</fieldset>";
                    });

                    //将拼接的页面上图
                    $("#regionList").html(regionHtm);
                    // WidgetUtils.loadScrollBar2("#regionList", 190);
                },
                complete: function () {
                    //访问后清空loading页面
                    $("#regionLoading").empty();
                    // getFatherBounds();
                }
            });
        } catch (e) {
            console.log(e);
        }
    }

    /**
     *为子区绑定动态样式和动态事件
     */
    $("body").on("click", ".region-children", function () {
        xzqdmChild = $(this).data("xzqdm-child-index");
        $(".regionName").text($(this).text());
        EventBus.trigger("regionCode-change",xzqdmChild.toString());
        regionToLocation(xzqdmChild.toString());
        $("body").find(".region-children").removeClass("region-children-point");
        $("body").find(".region-father").removeClass("region-title-point");
        $(this).addClass("region-children-point");
    });

    $("body").on("click", ".region-father", function () {
        xzqdmFather = $(this).data("xzqdm-father-index");
        $(".regionName").text($(this).text());
        EventBus.trigger("regionCode-change",xzqdmFather.toString());
        if (xzqdmFather.toString().indexOf('0000') === -1 && xzqdmFather.toString().indexOf('00') === -1) {
            regionToLocation(xzqdmFather.toString());
        } else {
            regionToLocation(xzqdmFather.toString().substring(0, 4));
        }
        $("body").find(".region-father").removeClass("region-title-point");
        $("body").find(".region-children").removeClass("region-children-point");
        $(this).addClass("region-title-point");
    });


    /**
     * 拼接url并渲染上图
     * @param XZQDM 行政区代码
     */
    function regionToLocation(xzqdm) {
        //清空上一次检索的数据与图层
        clearRegionData();
        //判断行政市和区对应的图层
        if (xzqdm.length > 5) {
            //index根据tpl模板中的regionIndex进行获取
            // 烟台
            xzqdm.length === 6 ?
                regionUrl = regionUrlPre + "?XZQDM=" + xzqdm + "&index="
                    + regionIndex.split(',')[0] + ',' +
                    regionIndex.split(',')[1] :
                regionUrl = regionUrlPre + "?XZQDM=" + xzqdm + "&index="
                    + regionIndex;
        } else {
            //检索市数据时需要将index拆分获取regionIndex的xzq_c_2016_2k索引
            regionUrl = regionUrlPre + "?XZQDM=" + xzqdm + "&index="
                + regionIndex.split(',')[0];
        }
        //获取geojson数据
        //渲染图层
        jQuery.support.cors = true;
        //根据拼接的url拿到需要的市区数据
        jQuery.getJSON(regionUrl).done(function (data) {
            try {
                var feature = data.content[0];
                //渲染图层
                var regionLayer = L.geoJson(feature, {
                    style: polygonStyle
                }).on({
                    //设置鼠标移到图层高亮显示效果
                    mouseover: highlight,
                    mouseout: resetHeightlight
                });
                $map.addLayer(regionLayer);
                //设定bounds中心及视图缩放比例
                var geoBounds = regionLayer.getBounds();
                var zoom = $map.getBoundsZoom(geoBounds);
                $map.flyTo(geoBounds.getCenter(), zoom);
                //将图层数据存储进数组中
                regionGeoJson.push(regionLayer);
                //重新定位到大市级的时候
                if(xzqdm.length < 5){
                    clearRegionData()
                }
            } catch (e) {
                console.error(e);
            }
        });
    }

    /**
     * 鼠标移动至图层上高亮显示
     * @param e
     */
    function highlight(e) {
        var layer = e.target;
        layer.setStyle({
            weight: 6,
            fillOpacity: 0.7,
            dashArray: '0'
        })
    }

    /**
     * 鼠标移出时恢复样式
     * @param e
     */
    function resetHeightlight(e) {
        var layer = e.target;
        layer.setStyle(polygonStyle);
    }

    /**
     * 获取所有父行政区geojson
     */
    function getFatherBounds() {
        $.each(fatherCodeList, function (i, fatherCode) {
            var xzqdm;
            if (fatherCode.toString().indexOf('0000') === -1 && fatherCode.toString().indexOf('00') === -1) {
                xzqdm = fatherCode.toString();
            } else {
                xzqdm = fatherCode.toString().substring(0, 4);
            }
            if (xzqdm.length > 5) {

                //index根据tpl模板中的regionIndex进行获取
                // 烟台
                xzqdm.length === 6 ?
                    regionUrl = regionUrlPre + "?XZQDM=" + xzqdm + "&index="
                        + regionIndex.split(',')[0] + ',' +
                        regionIndex.split(',')[1] :
                    regionUrl = regionUrlPre + "?XZQDM=" + xzqdm + "&index="
                        + regionIndex;
            } else {
                //检索市数据时需要将index拆分获取regionIndex的xzq_c_2016_2k索引
                regionUrl = regionUrlPre + "?XZQDM=" + xzqdm + "&index="
                    + regionIndex.split(',')[0];
            }

            jQuery.support.cors = true;
            //根据拼接的url拿到需要的市区数据
            $.ajax({
                url: regionUrl,
                type: 'get',
                async: false,
                success: function (data) {
                    try {
                        var feature = data.content[0];
                        fatherGeoJson.push(feature);
                    } catch (e) {
                        console.error(e);
                    }
                },
                complete: function () {

                }
            });
        });
        // showPosition();
    }

    /**
     *判断当前地图中心点所在的父行政区，改变标签文字
     */
    function showPosition() {
        getCenterPt();
        $.each(fatherGeoJson, function (i, item) {
            var gjLayer = L.geoJson(item);
            var pipResult = leafletPip.pointInLayer(centerPt, gjLayer, false);
            if (pipResult.length !== 0) {
                labelText = item.properties.XZQMC;
                $("#regionLi")[0].innerText = labelText;
                return false;
            }
            if (pipResult.length === 0) {
                $("#regionLi")[0].innerText = "行政区定位";
            }

        });
    }


    /**
     * 获取当前地图中心点坐标
     */
    function getCenterPt() {
        var layerBounds = $map.getBounds();
        var extent = LEsri.Util.boundsToExtent(layerBounds);
        centerPt = [(extent.xmin + extent.xmax) / 2, (extent.ymin + extent.ymax) / 2];
    }


    /**
     * get instance
     *
     * @returns {*}
     */
    me.getInstance = function () {
        if (instance === undefined) {
            instance = me;
        }
        return instance;
    };
    return me;
});
