/**
 *@Author: liujie<liu.im.jie@gmail.com>
 *@Created in 2019-12-06 9:56
 *@Description: 图层控制
 *@Modify By:
 */
define([
    'easyMap/main',
    'easyMap/controls/ServiceLayer',
    'knockout'
], function (MainMap, ServiceLayer, ko) {
    var instance,
        me,
        $that = me = {
            init: function () {
                //从配置文件中获取图层
                $that.addLayerByConfig(this.config.layers);
                $map = MainMap.map.get$Map();
                ko.applyBindings(ServiceLayer, $(".layer-Control").get(0));
                ServiceLayer.addEventListener(changeLayerControl);
            },
            onOpen: function () {
            },
            onClose: function () {
            },
            onPause: function () {
            },
            /**
             * 获取需要展示的图层
             * @param allLayers
             */
            addLayerByConfig: function (allLayers,chooseFirst) {
                if(!allLayers){
                    return;
                }
                changeLayer();
                //删除已经显示的图层
                ServiceLayer.showService(true);
                ServiceLayer.layers(allLayers);
                //默认触发第一个节点
                if(chooseFirst){
                    ServiceLayer.changeLyr(allLayers[0]);
                }

            }

        };

    var $map, layer = [];

    /**
     * 改变图层显示函数(用于监听事件)
     * @param btn
     */
    function changeLayerControl(btn) {
        try {
            $(":radio[name='rdoLayerName'][value='" + btn.alias + "']").prop("checked", "checked");
            // 判断动态服务多图层
            if (btn.isNode) {
                // 刷新图层
                layer[layer.length - 1].options.layers = [btn.id];
                layer[layer.length - 1].redraw();
            } else {
                changeLayer();
                var lyr = MainMap.map.createLayer(btn);
                layer.push(lyr);
                MainMap.map.addLayer(lyr);
                MainMap.showLayerTitle(btn);
                MainMap.controls.Legend.init(btn);
            }
            // 请求服务参数并定位
            $.support.cors = true;
            $.ajax({
                url: btn.url,
                type: 'get',
                dataType: 'jsonp',
                data: {f: 'pjson'},
                success: function (res) {
                    var extent = res.fullExtent;
                    $map.fitBounds([
                        [extent.ymin, extent.xmin],
                        [extent.ymax, extent.xmax]
                    ]);
                }
            });
        } catch (e) {
            console.log(e)
        }
    };
    function changeLayer() {
        if (layer.length > 0) {
            $.each(layer, function (i, e) {
                $map.removeLayer(e);
            });
            layer = [];
        }
    };



    me.getInstance = function () {
        if (instance === undefined) {
            instance = me;
        }
        return instance;
    };
    return me;
});