/**
 *
 * @author by zhuzhifeng
 * @version v1.0 2019/6/5/12:16
 */
define([
    'easyMap/main',
    'popup',
    'leaflet'
    ], function (
    mainMap,
    Popup,
    L){
    var instance,
        crsFactory ,
        me,
        $that = me = {
            // init fun
            init: function () {
                crsFactory = mainMap.map.CrsFactory;
                $that.initLayui();
                $that.openIdentify();
                $(document).on("click",".map-popup-close",function () {
                    $that.$map.closePopup();
                });
                //加载图片
                $(".identify-img").each(function (i,v) {
                    var $this = $(v);
                    var name = $this.attr("name");
                    $this.attr("src",base+"/webjars/lp-webjars/js/easyMap/assets/images/"+name+".png");
                })
            },
            // open evopenIdentifyent
            onOpen: function () {
                $that.myServices =[];
                $that.openIdentify();
                $(".map-container").addClass("map-choose-point");
                $that.$map.on('click', $that.onMapClick);
            },
            // close event
            onClose: function () {
                $that.closeIdentify();
            },

            // pause event
            onPause: function () {
                $that.closeIdentify();
            },

            $map:mainMap.map.get$Map(),

            // 识别的服务列表，服务列表下是图层要素
            myServices:[],

            // 判断是否保留结果
            saveResult: false,

            // 待查询列表
            queryList: [],

            // 控制禁止查询
            queryTag: false,

            // 配置
            config: this.config,

            // 当前识别图层所配置的识别字段
            fieldsKeys: [],

            layerBool: false,

            featureGroup: {
                featureList: []
            },

            currentFeature: null,
            tmpClickFeature:null,

            // 初始化layui组件
            initLayui: function () {
                var identifyForm;
                layui.use('form', function () {
                    identifyForm = layui.form;
                    identifyForm.on('checkbox(identifyCheck)', function (data) {
                        if (data.elem.checked === true) {
                            // 设置保留结果参数
                            $that.saveResult = true;
                        }
                        if (data.elem.checked === false) {
                            $that.saveResult = false;
                        }
                    });
                    // 设置保留结果勾选框的初始值
                    if($that.config.saveResult !== undefined) {
                        $that.saveResult = $that.config.saveResult;
                    }
                    identifyForm.val("identifyCheckForm", {
                        "identifyCheckBox": $that.saveResult
                    });
                    identifyForm.render();
                });
            },

            // 打开属性识别方法
            openIdentify: function () {
                $(".map-container").addClass("map-choose-point");
                // 检查
                if ($that.config.services === undefined || $that.config.services === null || $that.config.services.length === 0) {
                    Popup.msg({message: '请在地图应用构建器中配置当前模板的要素识别功能需要识别的图层。', type: 'warning'});
                }
                // 绑定保留结果勾选框点击事件
                // $('#checkImg').on('click', initCheckBox);

                // 绑定地图点击事件
                $that.$map.on('click', $that.onMapClick);
                // 判断结果是否保留
                if (!$that.saveResult) {
                    $('.directionDiv').css('display', 'block');
                    $('#identifyResult').empty();
                }

                $that.$map.on('popupopen', function () {

                    $(".leaflet-popup-tip").show();
                    $(".tb-content").height("250px");
                    $("#identify_pane").width("260px");
                    var X,Y,bottom;
                    var isMove =false;
                    $('.map-popup-close').on('click', function () {
                        $that.$map.closePopup();
                    });
                    // 点击弹出框标题触发拖拽弹出框事件
                    $('.win_title')
                        .click(function (e) {
                            e.stopPropagation();
                            // todo 点击更改z-index
                        })
                        .mousedown(function (e) {
                            isMove = true;
                            X = e.pageX - parseInt($(".leaflet-popup").css("left"));
                            Y = e.pageY;
                            bottom = parseInt($(".leaflet-popup").css("bottom"));
                            $(".leaflet-popup-tip").hide();
                        });
                    $(document)
                        .mousemove(function (e) {
                            if (isMove) {
                                var popLeft = e.pageX - X,
                                    popBottom = Y - e.pageY + bottom;
                                // leaflet是根据left、bottom设置弹出框位置
                                $(".leaflet-popup").css({left: popLeft, bottom: popBottom});
                            }
                        })
                        .mouseup(function () {
                            isMove = false;
                        });

                    $('.leaflet-popup-close-button').addClass('popup-close-button');
                });
                $that.$map.on('popupclose',function(){
                    $('.leaflet-popup-close-button').removeClass('popup-close-button');
                });
                $that.$map.on('zoom', function () {
                    $(".leaflet-popup-tip").show();
                });

                $('#identify-clear').on('click', function () {
                    $('.directionDiv').css('display', 'block');
                    $('#identifyResult').empty();
                    $('.identifyScrollBar').hide();
                    $(".identify-result-pane").height("0px");
                    $("#identify_pane").width("200px");
                    $that.queryList=[];
                    if($that.tmpClickFeature){
                        $that.$map.removeLayer($that.tmpClickFeature);
                    }
                    if ($that.myServices.length > 0) {
                        $that.myServices.forEach(function (lyr) {
                            lyr.featureList.forEach(function (plg) {
                                $that.$map.removeLayer(plg.layer);
                            });
                        });
                        // 清除服务列表下的识别图层信息
                        $that.myServices = [];
                    }
                });
            },

            // 地图点击方法
            onMapClick: function (e) {
                // 获得可识别图层
                $that.getIsServicesIdentify();
                L.DomEvent.stopPropagation(e);
                console.log('onMapClick');
                $that.$map.closePopup();
                // 根据checkbox选项，决定是否清楚图层
                $that.clearGeoJSONs();
                // 标识 不允许用户 多次快速点击查询
                if ($that.queryTag) {
                    return;
                }
                $that.queryTag = true;

                // 判断是否识别到可查询图层
                if ($that.queryList.length === 0) {
                    Popup.msg({message: '无可查询图层', type: 'warning'});
                    $that.queryTag = false;
                    return;
                }
                $that.myServices =[];

                // 发起请求
                $that.getFeatureJson(e, 0, $that.queryList, 0);
            },

            // 用递归代替循环发起请求
            getFeatureJson:function (e, j, queryList, unGetNum) {
                var layer;
                var waiting;
                // 获取属性识别Rest服务url
                layui.define('layer', function () {
                    layer = layui.layer;
                    waiting = layer.load(2);
                });
                var tmpUrl = queryList[j].options.url;
                if(tmpUrl[tmpUrl.length-1]=="/"){
                    tmpUrl=tmpUrl.substring(0,tmpUrl.length-1);
                }
                var identifyUrl = tmpUrl + '/identify';
                var maxBound = $that.$map.getBounds()._northEast;
                var minBound = $that.$map.getBounds()._southWest;
                // 配置属性识别查询条件
                var sr = parseInt(mainMap.map.getWkid());
                if(sr === 4528){
                    $that._latlngToMeter(e.latlng);
                    $that._latlngToMeter(minBound);
                    $that._latlngToMeter(maxBound);
                }
                // 获取属性识别的图层
                var identifyLayers = [];
                queryList.forEach(function (item) {
                    identifyLayers.push(item.layerid);
                });

                var params = {
                    f: 'json',
                    geometry: '{x: ' + e.latlng.lng + ', y: ' + e.latlng.lat + '}',
                    tolerance: 1,
                    mapExtent: minBound.lng + ',' + minBound.lat + ',' + maxBound.lng + ',' + maxBound.lat,
                    imageDisplay: '256,256,1',
                    layers: "all"
                };

                $.support.cors = true;// 执行属性识别Rest服务
                $.ajax({
                    url: identifyUrl,
                    type: 'get',
                    dataType: 'jsonp',
                    data: params,
                    success: function (data, status) {
                        if(status === 'success'){
                            layer.close(waiting);
                            if(!data.hasOwnProperty('error')) {
                                $that.disposeData(data, j, unGetNum, e);
                            }else{
                                Popup.msg({message: 'code：' + data.error.code + '，message：' + data.error.message, type: 'error'});
                                $that.queryTag = false;
                                j++;
                                $that.getFeatureJson(e, j,queryList, unGetNum);
                            }
                        }else {
                            Popup.msg({message: '向后台请求数据失败，请联系管理员', type: 'error'});
                            $that.queryTag = false;
                            j++;
                            $that.getFeatureJson(e, j,queryList, unGetNum);
                        }

                    }
                });

            },

            // 获取识别到图层，并判断图层是否可识别，图层透明度是否为0
            getIsServicesIdentify: function () {
                var layers = [];
                // 获取map中所有图层
                $that.$map.eachLayer(function (layer) {
                    layers.push(layer);
                });
                for (var i = 0; i < layers.length; i++) {
                    // 在layers中有些是leaflet自动创建添加的图层，所以需要判断过滤掉
                    if (!layers[i].hasOwnProperty('options') || layers[i].options.url === undefined || layers[i].options.url == null) {
                        continue;
                    }
                    if(layers[i].options.label !== undefined) {
                        // 提示用户， 某个图层在图层管理中，透明度为0， 不查询
                        if (layers[i].options.type === 'ags_tile' && layers[i].options.opacity === 0) {
                            Popup.msg(layers[i].options.label + '被设置透明度为0，不查询');
                            continue;
                        } else if (layers[i].options.type === 'ags_rest' && layers[i]._currentImage.options.opacity === 0) {
                            Popup.msg(layers[i].options.label + '被设置透明度为0，不查询');
                            continue;
                        }
                        var layer = {
                            layerid: layers[i].options.title,
                            objFileds: null,
                            options: layers[i].options,
                            buttons:""
                        };
                        $that.queryList.push(layer);
                    }
                    if(layers[i].options.isBaseLayer){}else {
                        var layer = {
                            layerid: layers[i].title||layers[i].options.alias,
                            objFileds: null,
                            options: layers[i].options,
                            buttons:""
                        };
                        // 添加识别的图层服务

                        $that.queryList.push(layer)
                    }
                    // 判断是否为添加服务添加的图层
                    if (layers[i].options.isAddService) {
                        if (layers[i].options.opacity === 0) {
                            Popup.msg(layers[i].options.label + '被设置透明度为0，不查询');
                            continue;
                        }
                        $that.queryList.push(layers[i]);
                    }
                }
                // 去重
                $that.queryList = $that.unique($that.queryList);
            },

            // 去重
            unique: function (arr) {
                var result = [];
                for(var i = 0; i < arr.length; i++){
                    // 如果在结果数组result中没有找到arr[i]，则把arr[i]压入result中
                    if(JSON.stringify(result).indexOf(JSON.stringify(arr[i])) === -1) {
                        result.push(arr[i]);
                    }
                }
                return result;
            },

            // 根据checkBox，决定是否清楚图层识别绘制的图形
            clearGeoJSONs: function () {
                if($that.tmpClickFeature){
                    $that.$map.removeLayer($that.tmpClickFeature);
                }
                // 判断checkbox是否勾选
                if (!$that.saveResult) {
                    // 勾选清除识别要素图层
                    if ($that.myServices.length > 0) {
                        $that.myServices.forEach(function (lyr) {
                            lyr.featureList.forEach(function (plg) {
                                $that.$map.removeLayer(plg.layer);
                            });
                        });
                        // 清除服务列表下的识别图层信息
                        $that.myServices = [];
                    }
                }
            },

            // 转换坐标系
            _latlngToMeter: function () {
                var crs = mainMap.getCrs();
                var point = crs.project(latlng);
                latlng.lng = point.x;
                latlng.lat = point.y;
            },

            // 成功获取结果后的处理方法
            disposeData: function (data, j, unGetNum, e) {
                var buttons="";
                // 将获取json串转成GeoJson
                var features = $that.jsonToGeo(data);
                features = mainMap.map.coordsMeterToSys(features, crsFactory.getWkid());

                if(features.features.length === 0) {
                    unGetNum++;
                }

                // 取按钮数组buttons
                $that.config.services.forEach(function (service) {
                    features.features.forEach(function (feature) {
                        if (service.layerid === feature.layerId) {
                            buttons = service.buttons;
                        }
                    });
                });

                $that.featureGroup = {
                    featureList: [],
                    location: []
                };
                var queryLayer = $that.queryList[j];
                j++;
                if (queryLayer.options.label !== undefined) {
                    $that.featureGroup.serviceName = queryLayer.options.label;
                } else if (queryLayer.options.title !== undefined) {
                    $that.featureGroup.serviceName = queryLayer.options.title;
                } else if (queryLayer.options.alias !== undefined) {
                    // 底图切换增加的图层的名字要通过alias读取
                    $that.featureGroup.serviceName = queryLayer.options.alias;
                }

                features.features.forEach(function (feature, fId) {
                    if (queryLayer.layerid === feature.layerId || queryLayer.options.isAddService||!queryLayer.options.isBaseLayer){
                        $that.showFeatures(feature, fId, queryLayer, features);
                        $that.featureGroup.location=[feature].concat($that.featureGroup.location)
                    }
                });

                // 将识别到的要素信息加到服务列表中
                if ($that.layerBool) {
                    $that.myServices.push($that.featureGroup);
                }

                if ($that.queryList.length === j) {
                    $that.queryTag = false;
                }
                // 判断是否查询到要素
                if (!$that.saveResult) {
                    if ($that.queryList.length === j && $that.myServices.length === 0) {
                        Popup.msg({message: '查询当前地图容器中所有图层，无数据', type: 'warning'});
                        $('.directionDiv').css('display', 'block');
                        $('#identifyResult').empty();
                    }
                }

                if($that.queryList.length === j && $that.myServices.length > 0) {
                    if(unGetNum === $that.queryList.length) {
                        Popup.msg({message: '查询当前地图容器中所有图层，无数据', type: 'warning'});
                        return;
                    }
                    // 将识别要素属性加到手风琴列表中
                    var resultsHtml = $that.showResults($that.myServices);
                    $(".identify-result-pane").height("250px");
                    $("#identify_pane").width("260px");
                    $('#identifyResult').html(resultsHtml);
                    $('.identifyScrollBar').show();
                    $(".identifyScrollBar .os-content").height('99%');
                    // 初始化手风琴列表展开、收缩功能
                    $that.initResults();
                    if($that.currentFeature != null) {
                        var id = $that.currentFeature.OBJECTID;
                        $that.currentItem(id);
                    }
                    // 绑定定位按钮点击事件
                    $('.location').on('click', function (e) {
                        var sId = $(this).data('service-index');
                        var fId = $(this).data('feature-index');
                        var locationFeature = $that.myServices[sId].location[fId];
                        var showFeature=$that.myServices[sId].featureList[fId];
                        $that.flyToGeo(locationFeature,showFeature);
                    });
                }

                if(j < $that.queryList.length) {
                    $that.getFeatureJson(e, j,$that.queryList, unGetNum);
                }

            },

            // json转GeoJson
            jsonToGeo: function (features) {
                var geoFeatures = [];
                // 将得到的json转成GeoJson
                features.results.forEach(function (result) {
                    var geoFeature = {
                        type: 'Feature',
                        properties: result.attributes,
                        id: result.attributes.OBJECTID||result.attributes.Objectid,
                        layerId: result.layerId,
                        layerName: result.layerName,
                        geometry: {
                            type: '',
                            coordinates: []
                        }
                    };
                    // 判断要素类型
                    switch (result.geometryType) {
                        case 'esriGeometryPolygon' :
                            geoFeature.geometry.type = 'Polygon';
                            geoFeature.geometry.coordinates = result.geometry.rings;
                            geoFeatures.push(geoFeature);
                            break;
                        case 'esriGeometryPolyline' :
                            geoFeature.geometry.type = 'LineString';
                            geoFeature.geometry.coordinates = result.geometry.paths[0];
                            geoFeatures.push(geoFeature);
                            break;
                        case 'esriGeometryPoint' :
                            geoFeature.geometry.type = 'Point';
                            geoFeature.geometry.coordinates = [result.geometry.x, result.geometry.y];
                            geoFeatures.push(geoFeature);
                            break;
                        case 'esriGeometryMultipoint':
                            geoFeature.geometry.type = 'MultiPoint';
                            geoFeature.geometry.coordinates = result.geometry.points;
                            geoFeatures.push(geoFeature);
                            break;
                    }
                });
                // 返回GeoJson
                return {
                    features: geoFeatures,
                    type: 'FeatureCollection'
                };
            },

            // 进行展示
            showFeatures: function (feature, fId, queryLayer, features) {
                // 判断查询出来的这个要素是否已经查询过，如果查询过，就直接show，不在重新绘制
                var breakTag = false;
                if ($that.myServices.length > 0) {
                    $that.myServices.forEach(function (lyr, sIndex) {
                        lyr.featureList.forEach(function (plg, fIndex) {
                            if (plg.OBJECTID === feature.properties.OBJECTID) {
                                if (sIndex === 0 && fIndex === 0) {
                                    $that.showFeatureMessage(plg);
                                    $that.currentFeature = plg;
                                }
                                breakTag = true;
                            }
                        });
                    });
                }
                // true  查询过   false 未查询过
                if (breakTag) {
                    return;
                }
                // 判断在 勾选保留结果 按钮之后， 需要将数据继续添加到数组里面
                $that.myServices.forEach(function (featureGroupf, k) {
                    var serverName = "";
                    if (queryLayer.options.hasOwnProperty("label")) {
                            serverName = queryLayer.options.label;
                        } else if (queryLayer.options.title !== undefined) {
                            serverName = queryLayer.options.title;
                        } else if (queryLayer.options.alias !== undefined) {
                            // 底图切换增加的图层的名字要通过alias读取
                            serverName = queryLayer.options.alias;
                        }
                        if (featureGroupf.serviceName === serverName) {
                            $that.featureGroup = featureGroupf;
                            $that.myServices.splice(k, 1);
                        }
                });
                $that.fieldsKeys = queryLayer.objFileds;

                // 将识别到的要素添加到地图中
                // 根据要素类型选择渲染样式
                var getLayer = L.geoJson(features, {
                    style: function (feature) {
                        switch (feature.geometry.type) {
                            case 'LineString':
                                return mainMap.map.getSymbol('polyline');;
                            case 'Polygon':
                                return mainMap.map.getSymbol('polygon');;
                            }
                        },
                    pointToLayer: function (feature, latlng) {
                        return L.circleMarker(latlng, {
                            radius: 10,
                            color: mainMap.map.getSymbol('point').color,
                            weight: mainMap.map.getSymbol('point').weight,
                            fillOpacity: mainMap.map.getSymbol('point').fillOpacity
                        });
                        },
                    properties: feature.properties,
                    button: queryLayer.buttons,
                    // 绑定要素弹出框
                    onEachFeature: $that.onEachFeature
                }).addTo($that.$map);
                // 声明变量，按照配置文件字段顺序整理要素字段。便于显示
                var featureObj = {
                    properties: []
                };
                featureObj.layer = getLayer;
                featureObj.type = feature.geometry.type;
                featureObj.OBJECTID = feature.properties.OBJECTID||feature.properties.Objectid;
                    for (var filed in feature.properties) {
                        // 用数组存放，防止属性顺序被打乱
                        var property = {};
                        property[filed] = feature.properties[filed];
                        featureObj.properties.push(property);
                    }
                // }
                // 只展示识别到的第一个要素的属性详情
                if (fId === 0) {
                    $that.flyToGeo(feature,featureObj);
                    currentFeature = featureObj;
                }
                $that.featureGroup.featureList = [featureObj].concat($that.featureGroup.featureList);

                $that.layerBool = true;
                $('.directionDiv').css('display', 'none');
            },

            // 识别地图要素绑定点击弹出框
            onEachFeature: function (feature, layer) {
                layer.on('click', function (e) {
                    $that.$map.closePopup();
                    if($('#pane_identify').css('display') === 'none') {
                        var crosshair = L.DomUtil.hasClass($map._container, 'draw-cursor-enabled');
                        $that.$map.fire('click', e);
                        if(crosshair) {
                            this.unbindPopup();
                        }else {
                            if(this.getPopup() === null) {
                                this.bindPopup(this.popupContent).openPopup();
                                $('.leaflet-popup-tip-container').show();
                            }
                        }
                    }
                    $that.currentItem(e.target.feature.id);
                });
                // 获取属性信息
                var popupContent = '<div class="win_title">';
                if($that.config.isShowLayerName) {
                    popupContent += '<span class="icon-f-dotcircle"> 属性详情-' + feature.layerName + '</span>';
                }else {
                    popupContent += '<span class="icon-f-dotcircle"> 属性详情</span>';
                }
                popupContent += '<span class="map-popup-close icon-f-dotcircle"></span></div>' +
                    '<div class="tb-content">' +
                    '<table data-feature-id="' + feature.id + '" class="content-table">';

                // var filterObj = {
                //     SHAPE_LENG:true,
                //     SHAPE_LE_1:true,
                //     SHAPE:true,
                //     "SHAPE.AREA":true,
                //     "SHAPE.LEN":true,
                //     "OBJECTID_1":true,
                //     "FID":true,
                //     "OBJECTID":true
                // };
                // 遍历得到要素各属性
                if($that.fieldsKeys !== undefined && $that.fieldsKeys !== null) {
                    for(var field in feature.properties){
                        //是否已经配置
                        var fAlias = field;
                        if(filterObj[field]){
                            continue;
                        }
                        var fValue = feature.properties[field];
                        $that.fieldsKeys.forEach(function (configField) {
                            var name =configField.name;
                            var alias = configField.alias;
                            if(name==field){
                                fAlias = alias;
                            }

                            //
                            // var value = feature.properties[field];
                            // //多配了
                            // if(value === undefined){
                            //     return;
                            // }
                            // //结果为空
                            // if(value == null ||  value === 'Null') {
                            //     value = '';
                            // }

                        });

                        popupContent += '<tr><td class="td-key"><span>' +
                            fAlias + '</span></td><td class="td-property" title="' + fValue + '"><span>' +
                            fValue +
                            '</span></td></tr>';
                    }

                } else {
                    for (var key in feature.properties) {
                        var property = feature.properties[key];
                        if(property == null || property === undefined || property === 'Null') {
                            property = '';
                        }
                        if(key.indexOf("SHAPE")) {
                            popupContent += '<tr><td class="td-key">' +
                                key + '</td><td class="td-property" title="' + property + '">' +
                                property +
                                '</td></tr>';
                        }
                    }
                }
                popupContent += '</table></div>';
                if(this.button.length !==0) {
                    var url = '"' + $that.changeWindow(this.button[0], this.properties) + '"';
                    popupContent += "<div class='identify-button-div'><button onclick='window.open(" + url + ")' class='layui-btn layui-btn-normal identify-button'>" + this.button[0].buttonName + "</button></div>";
                }
                // 图层绑定弹出框
                layer.bindPopup(popupContent, {minWidth: 350, maxWidth: 350, closeButton: false});
                layer.popupContent = layer.getPopup();
            },

            // 按钮
            changeWindow: function (button, properties) {
                var newButtonUrl = button.bottonUrl;
                var urlResult = "";
                var arr = newButtonUrl.split('@@');
                var urlPre1 = "";
                var urlKey = "";
                for (var i = 0; i < arr.length; i++) {
                    // 默认是常州给的{}的接口类型，如有需要继续进行修改
                    if (arr[i].toString().indexOf('{') !== -1) {
                        urlPre1 = arr[i].toString().split('{');
                        urlKey = urlPre1[1].toString().split('}')[0];
                        var value = properties[urlKey];
                        if (value !== ' ' && value !== 'Null' && value !== null && value !== '') {
                            while (arr[i].toString().indexOf('{') !== -1) {
                                var urlKeyReplace = ("{" + urlKey + "}").toString();
                                if (value === 'Null' || value === null || value === 'null') {
                                    value = "";
                                }
                                arr[i] = arr[i].replace(urlKeyReplace, value);
                            }
                            urlResult = arr[i];
                            break;
                        }
                    }
                    // 默认给常州写的两个值会跳出的版本，如有需要继续进行修改
                    else {
                        urlPre1 = arr[i].toString().split('?');
                        var urlPre2 = urlPre1.toString().split('&');
                        // 可进行多个urlKey的替代，
                        for (var t = 0; t < urlPre2.length; t++) {
                            urlKey = urlPre2[t];
                            urlKey = urlKey.split('$');
                            urlKey = urlKey[1];
                            var value = properties[urlKey];
                            var urlValue = '';
                            // ID数据有格式要求需要筛选成为数字项
                            if (urlKey === 'ID' && value !== null) {
                                urlValue = value.toString().replace(/[^0-9]/ig, "");
                            } else {
                                urlValue = value;
                            }
                            if (urlValue !== ' ' && urlValue !== 'Null' && value !== null && value !== '') {
                                urlResult = arr[i].replace("$" + urlKey + "$", urlValue);
                            }
                        }
                        if (urlResult !== "") {
                            break;
                        }
                    }
                }
                return urlResult;
            },

            // 展示属性识别结果信息
            showFeatureMessage: function (feature) {
                if($that.config.popupType ==='dialog') {
                    var properties = feature.properties;
                    var windowHeight = $(window).height();
                    var windowWidth = $(window).width();
                    var popHeight = 548;
                    var popWidth = 345;
                    // 计算弹出窗口的左上角Y的偏移量
                    var popY = windowHeight - popHeight;
                    var popX = windowWidth - popWidth;
                    // 设定窗口的位置
                    $('#winIdentify').css('top', popY - windowHeight * 0.15).css('left', popX - windowHeight * 0.16).show('normal');
                    // 获取属性信息
                    var propertiesHtml = '<table id="featureProperties" class="content-table">';
                    properties.forEach(function (property) {
                        for(var key in property) {
                            var identifyProperty = property[key];
                            if(identifyProperty == null || identifyProperty === undefined || identifyProperty === 'Null'|| identifyProperty === 'null') {
                                identifyProperty = '';
                            }
                            propertiesHtml += '<tr><td class="td-key">' +
                                key + '</td><td class="td-property" title="' + identifyProperty + '">' +
                                identifyProperty +
                                '</td></tr>';
                        }
                    });
                    propertiesHtml += '</table>';
                    // 加载属性信息
                    propertiesHtml +=' <button class="layui-btn layui-btn-normal identify-button">' + this.button[0].buttonName+'</button>';
                    $('#identifyProperties').html(propertiesHtml);
                    // 绑定关闭按钮点击事件
                    $('#winIdentify .close-button').on('click', $that.closeShowMessage);
                } else {
                    $.each(Object.keys(feature.layer._layers), function (index, key) {
                        if(feature.layer._layers[key].feature.id === feature.OBJECTID) {
                            // 用leaflet弹出框展示属性详情
                            var layer = feature.layer._layers[key];
                            // 判断点时以坐标为center
                            if(layer.feature.geometry.type === "Point"){
                                // 转换经纬度位置
                                var popupCenter = L.latLng(layer.feature.geometry.coordinates[1],layer.feature.geometry.coordinates[0]);
                            } else {
                                var popupCenter = layer.getBounds().getCenter();
                            }
                            feature.layer.setZIndex(999);
                            layer._popup.setLatLng(popupCenter);
                            layer._popup.openOn($that.$map);
                        }
                    });
                }
            },

            // 关闭展示信息页面
            closeShowMessage: function () {
                $('#winIdentify').hide('normal');
            },

            // 定位
            flyToGeo: function (data,feature) {
                $that.$map.closePopup();
                // 获取要素边界
                var geometry = data.geometry;
                if(!geometry){
                    return;
                }
                if($that.tmpClickFeature){
                    $that.$map.removeLayer($that.tmpClickFeature);
                }
                 $that.tmpClickFeature = L.geoJson(geometry).addTo($that.$map);
//         marker.push(tmpClickFeature);
                //定位

                var bounds = $that.tmpClickFeature.getBounds();
                var center = bounds.getCenter();
                var zoom = $that.$map.getBoundsZoom(bounds);
                $that.showFeatureMessage(feature);
                $that.currentItem(feature.OBJECTID);
                $that.$map.setView(center, zoom-1);
            },

            // 展示弹窗框对应要素
            currentItem: function (id) {
                $("#identifyResult .submenu-item").each(function () {
                    if ($(this).data('feature-id') === parseInt(id)) {
                        $(this).children('.col-right').children('.location').css('color', 'red');
                    } else {
                        $(this).children('.col-right').children('.location').css('color', '#2084ff');
                    }
                });
            },

            // 加载识别结果
            showResults: function (resultServices) {
                // 以手风琴样式加载识别结果
                var result = '<ul id="accordion" class="accordion">';
                resultServices.forEach(function (resultService, serviceIndex) {
                    if(resultService.serviceName === undefined){
                        resultService.serviceName = "";
                    }
                    result += '<li>' +
                        '<div class="link"><span class="ser-span">' +
                        resultService.serviceName +
                        '</span><i class="icon-f-unfold"></i>' +
                        '</div>' +
                        '<ul class="submenu">';
                    resultService.featureList.forEach(function (resultFeature, featureIndex) {
                        result += '<li class="submenu-item" data-feature-id="' + resultFeature.OBJECTID + '"><div class="col-0">';
                        for (var fistKey in resultFeature.properties[0]) {
                            var firstProperty = resultFeature.properties[0][fistKey];
                            if(firstProperty == null || firstProperty === undefined || firstProperty === 'Null'||firstProperty === 'null') {
                                firstProperty = '';
                            }
                            result += '<span title="' + firstProperty + '">' +
                                firstProperty +
                                '</span>';
                        }
                        result += '</div><div class = "col col-left">';
                        // for(var alias in resultFeature.properties){
                        //     result += '<div><span title="' + resultFeature.properties[alias] + '">' +
                        //         alias + '： ' + resultFeature.properties[alias] +
                        //         '</span></div>';
                        // }
                        for (var i = 1; i < 3; i++) {
                            for(var key in resultFeature.properties[i]) {
                                var property = resultFeature.properties[i][key];
                                if(property == null || property === undefined || property === 'Null' || property === 'null') {
                                    property = '';
                                }
                                result += '<div><span title="' + property + '">' +
                                    key + '： ' + property +
                                    '</span></div>';
                            }
                        }
                        // 利用data-*方式存放feature在数组中的id，用Jquery的.data()方法取到id
                        result += '</div>' +
                            '<div class = "col col-right"><i class="icon-location icon iconfont location" data-service-index = "' +
                            serviceIndex +
                            '" data-feature-index = "' +
                            featureIndex +
                            '"></i></div>' +
                            '</li>';
                    });
                    result += '</ul>' +
                        '</li>';
                });
                result += '</ul>';
                return result;
            },

            // 手风琴效果
            initResults: function () {
                var Accordion = function (el, multiple) {
                    this.el = el || {};
                    this.multiple = multiple || false;
                    var links = this.el.find('.link');
                    // 绑定点击事件
                    links.on('click', {el: this.el, multiple: this.multiple}, this.dropdown);
                };

                // 切换展开收缩样式
                Accordion.prototype.dropdown = function (e) {
                    var $el = e.data.el;
                    $this = $(this),
                        $next = $this.next();

                    $next.slideToggle();
                    $this.parent().toggleClass('open');
                };

                var accordion = new Accordion($('#accordion'), false);
            },

            // 关闭窗口
            closeIdentify: function () {
                $(".map-container").removeClass("map-choose-point");
                $("#identifyResult .submenu-item").each(function () {
                    $(this).children('.col-right').children('.location').css('color', '#2084ff');
                });
                // 根据checkbox状态，确认是否保留查询结果
                // 影藏属性窗口
                // 根据checkbox状态，确认是否清楚地图
                if ($that.config.services === undefined && $that.config.services === null && $that.config.services.length > 0) {
                    return;
                }
                // 解除checkbox点击事件
                // $('#checkImg').off('click');
                // 解除地图点击事件
                $that.$map.off('click', $that.onMapClick);
                $that.$map.closePopup();
                if (!$that.saveResult) {
                    $('.directionDiv').css('display', 'block');
                    $('#identifyResult').empty();
                    $('.identifyScrollBar').hide();
                    $that.$map.off('popupopen');
                    $that.$map.off('popupclose');
                    $that.queryList=[];
                    $(".identify-result-pane").height("0px");
                    $("#identify_pane").width("200px");
                }
                // 关闭属性详情弹出框
                $that.closeShowMessage();
                // 清除识别的地图要素
                $that.clearGeoJSONs();
            }
        };

    /**
     * get instance
     *
     * @returns {*}
     */
    me.getInstance = function () {
        if (instance === undefined) {
            instance = me;
        }
        return instance;
    };
    return me;
});
