/*!
 * 
 *          iclient-leaflet.(https://iclient.supermap.io)
 *          Copyright© 2000 - 2020 SuperMap Software Co.Ltd
 *          license: Apache-2.0
 *          version: v10.0.1
 *         
 */
/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 14);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, exports) {

module.exports = L;

/***/ }),
/* 1 */
/***/ (function(module, exports) {

module.exports = function(){try{return echarts}catch(e){return {}}}();

/***/ }),
/* 2 */
/***/ (function(module, exports) {

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

var g; // This works in non-strict mode

g = function () {
  return this;
}();

try {
  // This works if eval is allowed (see CSP)
  g = g || new Function("return this")();
} catch (e) {
  // This works if the window reference is available
  if ((typeof window === "undefined" ? "undefined" : _typeof(window)) === "object") g = window;
} // g can still be undefined, but nothing to do about it...
// We return undefined, instead of nothing here, so it's
// easier to handle this case. if(!global) { ...}


module.exports = g;

/***/ }),
/* 3 */
/***/ (function(module, exports, __webpack_require__) {

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

var utils = __webpack_require__(20);

var AND = '&&',
    OR = '||',
    AND_STR = 'and',
    OR_STR = 'or',
    NOT = '!',
    EQUAL = '=',
    LIKE = '~',
    NOTEQUAL = NOT + EQUAL,
    NOTLIKE = NOT + LIKE,
    GT = '>',
    GE = '>=',
    LT = '<',
    LE = '<=',
    WILDCARD = '*',
    COMMA = ',',
    DELIMITER = '.',
    LEFT = '(',
    RIGHT = ')',
    WHERE = 'where',
    synopsis = {
  pathway: [],
  groups: {}
},
    AST = {},
    options = {};
var print = console.log; // ------------------ splitter -------------------- //

function Tokenize(query) {
  var parts = __splitTrim(query, WHERE);

  var pathway = parts[0];
  var where = parts[1];
  synopsis.pathway = __splitTrim(pathway, COMMA);

  for (var i = 0, len = synopsis.pathway.length; i < len; i++) {
    synopsis.pathway[i] = __splitTrim(synopsis.pathway[i], DELIMITER);
    if (synopsis.pathway[i][0] == WILDCARD) synopsis.pathway[i].shift();
    if (synopsis.pathway[i].length === 0) synopsis.pathway.splice(i, 1);
  }

  var lastLeft = -1,
      lastRight = -1,
      current = 0;

  while (current < where.length) {
    if (where[current] === LEFT) {
      lastLeft = current;
    } else if (where[current] === RIGHT) {
      lastRight = current;

      if (lastRight > lastLeft && lastLeft !== -1) {
        var k = 'gr' + '_' + new Date().getTime();
        synopsis.groups[k] = where.substring(lastLeft + 1, lastRight);
        where = where.replace(LEFT + synopsis.groups[k] + RIGHT, k);
        current = -1;
      }
    }

    current += 1;
  }

  LogicalGrouping(AST, where);
}

function LogicalGrouping(current, where) {
  var lastAnd = __findIndex(where, AND),
      lastOr = __findIndex(where, OR);

  if (lastAnd !== Number.MAX_VALUE || lastOr !== Number.MAX_VALUE) {
    if (lastAnd < lastOr) {
      current.and = current.and || [];

      var parts = __splitTrim(where, AND);

      current.and.push(parts[0]);
      LogicalGrouping(current.and, parts[1]);
    } else {
      current.or = current.or || [];

      var parts = __splitTrim(where, OR);

      current.or.push(parts[0]);
      LogicalGrouping(current.or, parts[1]);
    }
  } else {
    if (synopsis.groups[where]) {
      where = synopsis.groups[where];
      LogicalGrouping(current, where);
    } else {
      if (Array.isArray(current)) current.push(where);else current.or = [where];
      ExtractExpression(AST.or ? AST.or : AST.and);
    }
  }
}

function ExtractExpression(logicalGroup) {
  for (var k in logicalGroup) {
    if (logicalGroup.hasOwnProperty(k)) {
      if (Array.isArray(logicalGroup[k])) {
        ExtractExpression(logicalGroup[k]);
      } else if (typeof logicalGroup[k] === 'string') {
        if (__contains(logicalGroup[k], NOTEQUAL)) {
          var parts = __splitTrim(logicalGroup[k], NOTEQUAL);

          logicalGroup[k] = {
            ne: [parts[0], parts[1]]
          };
        } else if (__contains(logicalGroup[k], NOTLIKE)) {
          var parts = __splitTrim(logicalGroup[k], NOTLIKE);

          logicalGroup[k] = {
            nreq: [parts[0], parts[1]]
          };
        } else if (__contains(logicalGroup[k], LIKE)) {
          var parts = __splitTrim(logicalGroup[k], LIKE);

          logicalGroup[k] = {
            // rough eq
            req: [parts[0], parts[1]]
          };
        } else if (__contains(logicalGroup[k], GE)) {
          var parts = __splitTrim(logicalGroup[k], GE);

          logicalGroup[k] = {
            // greater than or equal
            ge: [parts[0], parts[1]]
          };
        } else if (__contains(logicalGroup[k], GT)) {
          var parts = __splitTrim(logicalGroup[k], GT);

          logicalGroup[k] = {
            // greater than
            gt: [parts[0], parts[1]]
          };
        } else if (__contains(logicalGroup[k], LE)) {
          var parts = __splitTrim(logicalGroup[k], LE);

          logicalGroup[k] = {
            // less than or equal
            le: [parts[0], parts[1]]
          };
        } else if (__contains(logicalGroup[k], LT)) {
          var parts = __splitTrim(logicalGroup[k], LT);

          logicalGroup[k] = {
            // less than
            lt: [parts[0], parts[1]]
          };
        } else if (__contains(logicalGroup[k], EQUAL)) {
          var parts = __splitTrim(logicalGroup[k], EQUAL);

          logicalGroup[k] = {
            eq: [parts[0], parts[1]]
          };
        }
      }
    }
  }
}

function __findIndex(str, token) {
  var index = str.indexOf(token);
  return index === -1 ? Number.MAX_VALUE : index;
}

function __splitTrim(str, token) {
  return str.split(token).map(function (p) {
    return p.trim();
  });
}

function __contains(a, b) {
  return a.indexOf(b) > -1;
}

function __hierarchize(obj, dottedPath) {
  var parts = __splitTrim(dottedPath, DELIMITER);

  var res = obj;

  for (var p in parts) {
    if (res.hasOwnProperty(parts[p])) res = res[parts[p]];else return '';
  } // support comparison for Date/DateString


  if (utils.isDate(res)) res = res.valueOf();else if (utils.isDateString(res)) res = utils.parseDateFromString(res);else res = res.toString();
  return res;
}

function FilterOR(ASTNode, row) {
  var res = false;

  for (var k in ASTNode) {
    var filterFunc = k === AND_STR ? FilterAND : k === OR_STR ? FilterOR : Filter;
    res = res || filterFunc(ASTNode[k], row);
    if (options.trace) print(synopsis.step, '======((( or', ASTNode[k], res);
    if (res) return res;
  }

  return res;
}

function FilterAND(ASTNode, row) {
  var res = true;

  for (var k in ASTNode) {
    var filterFunc = k === AND_STR ? FilterAND : k === OR_STR ? FilterOR : Filter;
    res = res && filterFunc(ASTNode[k], row);
    if (options.trace) print(synopsis.step, '======((( and', ASTNode[k], res);
    if (!res) return res;
  }

  return res;
}

function Filter(ASTNode, row) {
  synopsis.step += 1;

  if (ASTNode.or) {
    var res = FilterOR(ASTNode.or, row);
    if (options.trace) print(synopsis.step, 'OR', ASTNode, res);
    return res;
  } else if (ASTNode.and) {
    var res = FilterAND(ASTNode.and, row);
    if (options.trace) print(synopsis.step, 'AND', ASTNode, res);
    return res;
  } else if (_typeof(ASTNode) === 'object') {
    if (ASTNode.eq) {
      // =
      return __hierarchize(row, ASTNode.eq[0]) === ASTNode.eq[1];
    } else if (ASTNode.ne) {
      // !=
      return __hierarchize(row, ASTNode.ne[0]) !== ASTNode.ne[1];
    } else if (ASTNode.req) {
      // ~
      return __contains(__hierarchize(row, ASTNode.req[0]), ASTNode.req[1]);
    } else if (ASTNode.nreq) {
      // ~
      return !__contains(__hierarchize(row, ASTNode.nreq[0]), ASTNode.nreq[1]);
    } else if (ASTNode.gt) {
      // >
      return __hierarchize(row, ASTNode.gt[0]) > ASTNode.gt[1];
    } else if (ASTNode.ge) {
      // >=
      return __hierarchize(row, ASTNode.ge[0]) >= ASTNode.ge[1];
    } else if (ASTNode.lt) {
      // <
      return __hierarchize(row, ASTNode.lt[0]) < ASTNode.lt[1];
    } else if (ASTNode.le) {
      // <=
      return __hierarchize(row, ASTNode.le[0]) <= ASTNode.le[1];
    } else {
      return Filter(ASTNode, row);
    }
  }
}

function Parse(dataSource) {
  var result = [];

  for (var k in dataSource) {
    if (Filter(AST, dataSource[k])) result.push(dataSource[k]);
  }

  return result;
}

function Fields(result) {
  if (result && synopsis.pathway.length > 0) {
    //print(synopsis.pathway);
    return result.map(function (ele) {
      var res = {};

      for (var i = 0, len = synopsis.pathway.length; i < len; i++) {
        var key = synopsis.pathway[i].join(DELIMITER);
        res[key] = __hierarchize(ele, key);
      }

      return res;
    });
  }

  return result;
}

function Query(dataSource, query, opts) {
  synopsis = {
    pathway: [],
    groups: {},
    step: 0
  };
  AST = {};
  opts = opts || {
    trace: false
  };
  options = opts;
  Tokenize(query);
  return Fields(Parse(dataSource));
}

if ( true && typeof module.exports != 'undefined') module.exports = Query;
if (typeof window != 'undefined') window.Query = Query;

/***/ }),
/* 4 */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;(function (global, factory) {
  if (true) {
    !(__WEBPACK_AMD_DEFINE_ARRAY__ = [exports, module], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
				__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
				(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
  } else { var mod; }
})(this, function (exports, module) {
  'use strict';

  var defaultOptions = {
    timeout: 5000,
    jsonpCallback: 'callback',
    jsonpCallbackFunction: null
  };

  function generateCallbackFunction() {
    return 'jsonp_' + Date.now() + '_' + Math.ceil(Math.random() * 100000);
  }

  function clearFunction(functionName) {
    // IE8 throws an exception when you try to delete a property on window
    // http://stackoverflow.com/a/1824228/751089
    try {
      delete window[functionName];
    } catch (e) {
      window[functionName] = undefined;
    }
  }

  function removeScript(scriptId) {
    var script = document.getElementById(scriptId);

    if (script) {
      document.getElementsByTagName('head')[0].removeChild(script);
    }
  }

  function fetchJsonp(_url) {
    var options = arguments.length <= 1 || arguments[1] === undefined ? {} : arguments[1]; // to avoid param reassign

    var url = _url;
    var timeout = options.timeout || defaultOptions.timeout;
    var jsonpCallback = options.jsonpCallback || defaultOptions.jsonpCallback;
    var timeoutId = undefined;
    return new Promise(function (resolve, reject) {
      var callbackFunction = options.jsonpCallbackFunction || generateCallbackFunction();
      var scriptId = jsonpCallback + '_' + callbackFunction;

      window[callbackFunction] = function (response) {
        resolve({
          ok: true,
          // keep consistent with fetch API
          json: function json() {
            return Promise.resolve(response);
          }
        });
        if (timeoutId) clearTimeout(timeoutId);
        removeScript(scriptId);
        clearFunction(callbackFunction);
      }; // Check if the user set their own params, and if not add a ? to start a list of params


      url += url.indexOf('?') === -1 ? '?' : '&';
      var jsonpScript = document.createElement('script');
      jsonpScript.setAttribute('src', '' + url + jsonpCallback + '=' + callbackFunction);

      if (options.charset) {
        jsonpScript.setAttribute('charset', options.charset);
      }

      jsonpScript.id = scriptId;
      document.getElementsByTagName('head')[0].appendChild(jsonpScript);
      timeoutId = setTimeout(function () {
        reject(new Error('JSONP request to ' + _url + ' timed out'));
        clearFunction(callbackFunction);
        removeScript(scriptId);

        window[callbackFunction] = function () {
          clearFunction(callbackFunction);
        };
      }, timeout); // Caught if got 404/500

      jsonpScript.onerror = function () {
        reject(new Error('JSONP request to ' + _url + ' failed'));
        clearFunction(callbackFunction);
        removeScript(scriptId);
        if (timeoutId) clearTimeout(timeoutId);
      };
    });
  } // export as global function

  /*
  let local;
  if (typeof global !== 'undefined') {
    local = global;
  } else if (typeof self !== 'undefined') {
    local = self;
  } else {
    try {
      local = Function('return this')();
    } catch (e) {
      throw new Error('polyfill failed because global object is unavailable in this environment');
    }
  }
  local.fetchJsonp = fetchJsonp;
  */


  module.exports = fetchJsonp;
});

/***/ }),
/* 5 */
/***/ (function(module, exports) {

module.exports = function(){try{return XLSX}catch(e){return {}}}();

/***/ }),
/* 6 */
/***/ (function(module, exports) {

module.exports = function(){try{return mapv}catch(e){return {}}}();

/***/ }),
/* 7 */
/***/ (function(module, exports) {

module.exports = function(){try{return turf}catch(e){return {}}}();

/***/ }),
/* 8 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var VectorTileFeature = __webpack_require__(9);

module.exports = VectorTileLayer;

function VectorTileLayer(pbf, end) {
  // Public
  this.version = 1;
  this.name = null;
  this.extent = 4096;
  this.length = 0; // Private

  this._pbf = pbf;
  this._keys = [];
  this._values = [];
  this._features = [];
  pbf.readFields(readLayer, this, end);
  this.length = this._features.length;
}

function readLayer(tag, layer, pbf) {
  if (tag === 15) layer.version = pbf.readVarint();else if (tag === 1) layer.name = pbf.readString();else if (tag === 5) layer.extent = pbf.readVarint();else if (tag === 2) layer._features.push(pbf.pos);else if (tag === 3) layer._keys.push(pbf.readString());else if (tag === 4) layer._values.push(readValueMessage(pbf));
}

function readValueMessage(pbf) {
  var value = null,
      end = pbf.readVarint() + pbf.pos;

  while (pbf.pos < end) {
    var tag = pbf.readVarint() >> 3;
    value = tag === 1 ? pbf.readString() : tag === 2 ? pbf.readFloat() : tag === 3 ? pbf.readDouble() : tag === 4 ? pbf.readVarint64() : tag === 5 ? pbf.readVarint() : tag === 6 ? pbf.readSVarint() : tag === 7 ? pbf.readBoolean() : null;
  }

  return value;
} // return feature `i` from this layer as a `VectorTileFeature`


VectorTileLayer.prototype.feature = function (i) {
  if (i < 0 || i >= this._features.length) throw new Error('feature index out of bounds');
  this._pbf.pos = this._features[i];

  var end = this._pbf.readVarint() + this._pbf.pos;

  return new VectorTileFeature(this._pbf, end, this.extent, this._keys, this._values);
};

/***/ }),
/* 9 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var Point = __webpack_require__(23);

module.exports = VectorTileFeature;

function VectorTileFeature(pbf, end, extent, keys, values) {
  // Public
  this.properties = {};
  this.extent = extent;
  this.type = 0; // Private

  this._pbf = pbf;
  this._geometry = -1;
  this._keys = keys;
  this._values = values;
  pbf.readFields(readFeature, this, end);
}

function readFeature(tag, feature, pbf) {
  if (tag == 1) feature.id = pbf.readVarint();else if (tag == 2) readTag(pbf, feature);else if (tag == 3) feature.type = pbf.readVarint();else if (tag == 4) feature._geometry = pbf.pos;
}

function readTag(pbf, feature) {
  var end = pbf.readVarint() + pbf.pos;

  while (pbf.pos < end) {
    var key = feature._keys[pbf.readVarint()],
        value = feature._values[pbf.readVarint()];

    feature.properties[key] = value;
  }
}

VectorTileFeature.types = ['Unknown', 'Point', 'LineString', 'Polygon'];

VectorTileFeature.prototype.loadGeometry = function () {
  var pbf = this._pbf;
  pbf.pos = this._geometry;
  var end = pbf.readVarint() + pbf.pos,
      cmd = 1,
      length = 0,
      x = 0,
      y = 0,
      lines = [],
      line;

  while (pbf.pos < end) {
    if (length <= 0) {
      var cmdLen = pbf.readVarint();
      cmd = cmdLen & 0x7;
      length = cmdLen >> 3;
    }

    length--;

    if (cmd === 1 || cmd === 2) {
      x += pbf.readSVarint();
      y += pbf.readSVarint();

      if (cmd === 1) {
        // moveTo
        if (line) lines.push(line);
        line = [];
      }

      line.push(new Point(x, y));
    } else if (cmd === 7) {
      // Workaround for https://github.com/mapbox/mapnik-vector-tile/issues/90
      if (line) {
        line.push(line[0].clone()); // closePolygon
      }
    } else {
      throw new Error('unknown command ' + cmd);
    }
  }

  if (line) lines.push(line);
  return lines;
};

VectorTileFeature.prototype.bbox = function () {
  var pbf = this._pbf;
  pbf.pos = this._geometry;
  var end = pbf.readVarint() + pbf.pos,
      cmd = 1,
      length = 0,
      x = 0,
      y = 0,
      x1 = Infinity,
      x2 = -Infinity,
      y1 = Infinity,
      y2 = -Infinity;

  while (pbf.pos < end) {
    if (length <= 0) {
      var cmdLen = pbf.readVarint();
      cmd = cmdLen & 0x7;
      length = cmdLen >> 3;
    }

    length--;

    if (cmd === 1 || cmd === 2) {
      x += pbf.readSVarint();
      y += pbf.readSVarint();
      if (x < x1) x1 = x;
      if (x > x2) x2 = x;
      if (y < y1) y1 = y;
      if (y > y2) y2 = y;
    } else if (cmd !== 7) {
      throw new Error('unknown command ' + cmd);
    }
  }

  return [x1, y1, x2, y2];
};

VectorTileFeature.prototype.toGeoJSON = function (x, y, z) {
  var size = this.extent * Math.pow(2, z),
      x0 = this.extent * x,
      y0 = this.extent * y,
      coords = this.loadGeometry(),
      type = VectorTileFeature.types[this.type],
      i,
      j;

  function project(line) {
    for (var j = 0; j < line.length; j++) {
      var p = line[j],
          y2 = 180 - (p.y + y0) * 360 / size;
      line[j] = [(p.x + x0) * 360 / size - 180, 360 / Math.PI * Math.atan(Math.exp(y2 * Math.PI / 180)) - 90];
    }
  }

  switch (this.type) {
    case 1:
      var points = [];

      for (i = 0; i < coords.length; i++) {
        points[i] = coords[i][0];
      }

      coords = points;
      project(coords);
      break;

    case 2:
      for (i = 0; i < coords.length; i++) {
        project(coords[i]);
      }

      break;

    case 3:
      coords = classifyRings(coords);

      for (i = 0; i < coords.length; i++) {
        for (j = 0; j < coords[i].length; j++) {
          project(coords[i][j]);
        }
      }

      break;
  }

  if (coords.length === 1) {
    coords = coords[0];
  } else {
    type = 'Multi' + type;
  }

  var result = {
    type: "Feature",
    geometry: {
      type: type,
      coordinates: coords
    },
    properties: this.properties
  };

  if ('id' in this) {
    result.id = this.id;
  }

  return result;
}; // classifies an array of rings into polygons with outer rings and holes


function classifyRings(rings) {
  var len = rings.length;
  if (len <= 1) return [rings];
  var polygons = [],
      polygon,
      ccw;

  for (var i = 0; i < len; i++) {
    var area = signedArea(rings[i]);
    if (area === 0) continue;
    if (ccw === undefined) ccw = area < 0;

    if (ccw === area < 0) {
      if (polygon) polygons.push(polygon);
      polygon = [rings[i]];
    } else {
      polygon.push(rings[i]);
    }
  }

  if (polygon) polygons.push(polygon);
  return polygons;
}

function signedArea(ring) {
  var sum = 0;

  for (var i = 0, len = ring.length, j = len - 1, p1, p2; i < len; j = i++) {
    p1 = ring[i];
    p2 = ring[j];
    sum += (p2.x - p1.x) * (p1.y + p2.y);
  }

  return sum;
}

/***/ }),
/* 10 */
/***/ (function(module, exports) {

module.exports = function(){try{return elasticsearch}catch(e){return {}}}();

/***/ }),
/* 11 */
/***/ (function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(global) {function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

/**
 * lodash (Custom Build) <https://lodash.com/>
 * Build: `lodash modularize exports="npm" -o ./`
 * Copyright jQuery Foundation and other contributors <https://jquery.org/>
 * Released under MIT license <https://lodash.com/license>
 * Based on Underscore.js 1.8.3 <http://underscorejs.org/LICENSE>
 * Copyright Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
 */

/** Used as references for various `Number` constants. */
var MAX_SAFE_INTEGER = 9007199254740991;
/** `Object#toString` result references. */

var argsTag = '[object Arguments]',
    funcTag = '[object Function]',
    genTag = '[object GeneratorFunction]',
    mapTag = '[object Map]',
    objectTag = '[object Object]',
    promiseTag = '[object Promise]',
    setTag = '[object Set]',
    weakMapTag = '[object WeakMap]';
var dataViewTag = '[object DataView]';
/**
 * Used to match `RegExp`
 * [syntax characters](http://ecma-international.org/ecma-262/7.0/#sec-patterns).
 */

var reRegExpChar = /[\\^$.*+?()[\]{}|]/g;
/** Used to detect host constructors (Safari). */

var reIsHostCtor = /^\[object .+?Constructor\]$/;
/** Used to detect unsigned integer values. */

var reIsUint = /^(?:0|[1-9]\d*)$/;
/** Detect free variable `global` from Node.js. */

var freeGlobal = (typeof global === "undefined" ? "undefined" : _typeof(global)) == 'object' && global && global.Object === Object && global;
/** Detect free variable `self`. */

var freeSelf = (typeof self === "undefined" ? "undefined" : _typeof(self)) == 'object' && self && self.Object === Object && self;
/** Used as a reference to the global object. */

var root = freeGlobal || freeSelf || Function('return this')();
/**
 * A specialized version of `_.map` for arrays without support for iteratee
 * shorthands.
 *
 * @private
 * @param {Array} [array] The array to iterate over.
 * @param {Function} iteratee The function invoked per iteration.
 * @returns {Array} Returns the new mapped array.
 */

function arrayMap(array, iteratee) {
  var index = -1,
      length = array ? array.length : 0,
      result = Array(length);

  while (++index < length) {
    result[index] = iteratee(array[index], index, array);
  }

  return result;
}
/**
 * The base implementation of `_.times` without support for iteratee shorthands
 * or max array length checks.
 *
 * @private
 * @param {number} n The number of times to invoke `iteratee`.
 * @param {Function} iteratee The function invoked per iteration.
 * @returns {Array} Returns the array of results.
 */


function baseTimes(n, iteratee) {
  var index = -1,
      result = Array(n);

  while (++index < n) {
    result[index] = iteratee(index);
  }

  return result;
}
/**
 * The base implementation of `_.toPairs` and `_.toPairsIn` which creates an array
 * of key-value pairs for `object` corresponding to the property names of `props`.
 *
 * @private
 * @param {Object} object The object to query.
 * @param {Array} props The property names to get values for.
 * @returns {Object} Returns the key-value pairs.
 */


function baseToPairs(object, props) {
  return arrayMap(props, function (key) {
    return [key, object[key]];
  });
}
/**
 * Gets the value at `key` of `object`.
 *
 * @private
 * @param {Object} [object] The object to query.
 * @param {string} key The key of the property to get.
 * @returns {*} Returns the property value.
 */


function getValue(object, key) {
  return object == null ? undefined : object[key];
}
/**
 * Checks if `value` is a host object in IE < 9.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a host object, else `false`.
 */


function isHostObject(value) {
  // Many host objects are `Object` objects that can coerce to strings
  // despite having improperly defined `toString` methods.
  var result = false;

  if (value != null && typeof value.toString != 'function') {
    try {
      result = !!(value + '');
    } catch (e) {}
  }

  return result;
}
/**
 * Converts `map` to its key-value pairs.
 *
 * @private
 * @param {Object} map The map to convert.
 * @returns {Array} Returns the key-value pairs.
 */


function mapToArray(map) {
  var index = -1,
      result = Array(map.size);
  map.forEach(function (value, key) {
    result[++index] = [key, value];
  });
  return result;
}
/**
 * Creates a unary function that invokes `func` with its argument transformed.
 *
 * @private
 * @param {Function} func The function to wrap.
 * @param {Function} transform The argument transform.
 * @returns {Function} Returns the new function.
 */


function overArg(func, transform) {
  return function (arg) {
    return func(transform(arg));
  };
}
/**
 * Converts `set` to its value-value pairs.
 *
 * @private
 * @param {Object} set The set to convert.
 * @returns {Array} Returns the value-value pairs.
 */


function setToPairs(set) {
  var index = -1,
      result = Array(set.size);
  set.forEach(function (value) {
    result[++index] = [value, value];
  });
  return result;
}
/** Used for built-in method references. */


var funcProto = Function.prototype,
    objectProto = Object.prototype;
/** Used to detect overreaching core-js shims. */

var coreJsData = root['__core-js_shared__'];
/** Used to detect methods masquerading as native. */

var maskSrcKey = function () {
  var uid = /[^.]+$/.exec(coreJsData && coreJsData.keys && coreJsData.keys.IE_PROTO || '');
  return uid ? 'Symbol(src)_1.' + uid : '';
}();
/** Used to resolve the decompiled source of functions. */


var funcToString = funcProto.toString;
/** Used to check objects for own properties. */

var hasOwnProperty = objectProto.hasOwnProperty;
/**
 * Used to resolve the
 * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
 * of values.
 */

var objectToString = objectProto.toString;
/** Used to detect if a method is native. */

var reIsNative = RegExp('^' + funcToString.call(hasOwnProperty).replace(reRegExpChar, '\\$&').replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, '$1.*?') + '$');
/** Built-in value references. */

var propertyIsEnumerable = objectProto.propertyIsEnumerable;
/* Built-in method references for those with the same name as other `lodash` methods. */

var nativeKeys = overArg(Object.keys, Object);
/* Built-in method references that are verified to be native. */

var DataView = getNative(root, 'DataView'),
    Map = getNative(root, 'Map'),
    Promise = getNative(root, 'Promise'),
    Set = getNative(root, 'Set'),
    WeakMap = getNative(root, 'WeakMap');
/** Used to detect maps, sets, and weakmaps. */

var dataViewCtorString = toSource(DataView),
    mapCtorString = toSource(Map),
    promiseCtorString = toSource(Promise),
    setCtorString = toSource(Set),
    weakMapCtorString = toSource(WeakMap);
/**
 * Creates an array of the enumerable property names of the array-like `value`.
 *
 * @private
 * @param {*} value The value to query.
 * @param {boolean} inherited Specify returning inherited property names.
 * @returns {Array} Returns the array of property names.
 */

function arrayLikeKeys(value, inherited) {
  // Safari 8.1 makes `arguments.callee` enumerable in strict mode.
  // Safari 9 makes `arguments.length` enumerable in strict mode.
  var result = isArray(value) || isArguments(value) ? baseTimes(value.length, String) : [];
  var length = result.length,
      skipIndexes = !!length;

  for (var key in value) {
    if ((inherited || hasOwnProperty.call(value, key)) && !(skipIndexes && (key == 'length' || isIndex(key, length)))) {
      result.push(key);
    }
  }

  return result;
}
/**
 * The base implementation of `getTag`.
 *
 * @private
 * @param {*} value The value to query.
 * @returns {string} Returns the `toStringTag`.
 */


function baseGetTag(value) {
  return objectToString.call(value);
}
/**
 * The base implementation of `_.isNative` without bad shim checks.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a native function,
 *  else `false`.
 */


function baseIsNative(value) {
  if (!isObject(value) || isMasked(value)) {
    return false;
  }

  var pattern = isFunction(value) || isHostObject(value) ? reIsNative : reIsHostCtor;
  return pattern.test(toSource(value));
}
/**
 * The base implementation of `_.keys` which doesn't treat sparse arrays as dense.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property names.
 */


function baseKeys(object) {
  if (!isPrototype(object)) {
    return nativeKeys(object);
  }

  var result = [];

  for (var key in Object(object)) {
    if (hasOwnProperty.call(object, key) && key != 'constructor') {
      result.push(key);
    }
  }

  return result;
}
/**
 * Creates a `_.toPairs` or `_.toPairsIn` function.
 *
 * @private
 * @param {Function} keysFunc The function to get the keys of a given object.
 * @returns {Function} Returns the new pairs function.
 */


function createToPairs(keysFunc) {
  return function (object) {
    var tag = getTag(object);

    if (tag == mapTag) {
      return mapToArray(object);
    }

    if (tag == setTag) {
      return setToPairs(object);
    }

    return baseToPairs(object, keysFunc(object));
  };
}
/**
 * Gets the native function at `key` of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @param {string} key The key of the method to get.
 * @returns {*} Returns the function if it's native, else `undefined`.
 */


function getNative(object, key) {
  var value = getValue(object, key);
  return baseIsNative(value) ? value : undefined;
}
/**
 * Gets the `toStringTag` of `value`.
 *
 * @private
 * @param {*} value The value to query.
 * @returns {string} Returns the `toStringTag`.
 */


var getTag = baseGetTag; // Fallback for data views, maps, sets, and weak maps in IE 11,
// for data views in Edge < 14, and promises in Node.js.

if (DataView && getTag(new DataView(new ArrayBuffer(1))) != dataViewTag || Map && getTag(new Map()) != mapTag || Promise && getTag(Promise.resolve()) != promiseTag || Set && getTag(new Set()) != setTag || WeakMap && getTag(new WeakMap()) != weakMapTag) {
  getTag = function getTag(value) {
    var result = objectToString.call(value),
        Ctor = result == objectTag ? value.constructor : undefined,
        ctorString = Ctor ? toSource(Ctor) : undefined;

    if (ctorString) {
      switch (ctorString) {
        case dataViewCtorString:
          return dataViewTag;

        case mapCtorString:
          return mapTag;

        case promiseCtorString:
          return promiseTag;

        case setCtorString:
          return setTag;

        case weakMapCtorString:
          return weakMapTag;
      }
    }

    return result;
  };
}
/**
 * Checks if `value` is a valid array-like index.
 *
 * @private
 * @param {*} value The value to check.
 * @param {number} [length=MAX_SAFE_INTEGER] The upper bounds of a valid index.
 * @returns {boolean} Returns `true` if `value` is a valid index, else `false`.
 */


function isIndex(value, length) {
  length = length == null ? MAX_SAFE_INTEGER : length;
  return !!length && (typeof value == 'number' || reIsUint.test(value)) && value > -1 && value % 1 == 0 && value < length;
}
/**
 * Checks if `func` has its source masked.
 *
 * @private
 * @param {Function} func The function to check.
 * @returns {boolean} Returns `true` if `func` is masked, else `false`.
 */


function isMasked(func) {
  return !!maskSrcKey && maskSrcKey in func;
}
/**
 * Checks if `value` is likely a prototype object.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a prototype, else `false`.
 */


function isPrototype(value) {
  var Ctor = value && value.constructor,
      proto = typeof Ctor == 'function' && Ctor.prototype || objectProto;
  return value === proto;
}
/**
 * Converts `func` to its source code.
 *
 * @private
 * @param {Function} func The function to process.
 * @returns {string} Returns the source code.
 */


function toSource(func) {
  if (func != null) {
    try {
      return funcToString.call(func);
    } catch (e) {}

    try {
      return func + '';
    } catch (e) {}
  }

  return '';
}
/**
 * Checks if `value` is likely an `arguments` object.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an `arguments` object,
 *  else `false`.
 * @example
 *
 * _.isArguments(function() { return arguments; }());
 * // => true
 *
 * _.isArguments([1, 2, 3]);
 * // => false
 */


function isArguments(value) {
  // Safari 8.1 makes `arguments.callee` enumerable in strict mode.
  return isArrayLikeObject(value) && hasOwnProperty.call(value, 'callee') && (!propertyIsEnumerable.call(value, 'callee') || objectToString.call(value) == argsTag);
}
/**
 * Checks if `value` is classified as an `Array` object.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an array, else `false`.
 * @example
 *
 * _.isArray([1, 2, 3]);
 * // => true
 *
 * _.isArray(document.body.children);
 * // => false
 *
 * _.isArray('abc');
 * // => false
 *
 * _.isArray(_.noop);
 * // => false
 */


var isArray = Array.isArray;
/**
 * Checks if `value` is array-like. A value is considered array-like if it's
 * not a function and has a `value.length` that's an integer greater than or
 * equal to `0` and less than or equal to `Number.MAX_SAFE_INTEGER`.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is array-like, else `false`.
 * @example
 *
 * _.isArrayLike([1, 2, 3]);
 * // => true
 *
 * _.isArrayLike(document.body.children);
 * // => true
 *
 * _.isArrayLike('abc');
 * // => true
 *
 * _.isArrayLike(_.noop);
 * // => false
 */

function isArrayLike(value) {
  return value != null && isLength(value.length) && !isFunction(value);
}
/**
 * This method is like `_.isArrayLike` except that it also checks if `value`
 * is an object.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an array-like object,
 *  else `false`.
 * @example
 *
 * _.isArrayLikeObject([1, 2, 3]);
 * // => true
 *
 * _.isArrayLikeObject(document.body.children);
 * // => true
 *
 * _.isArrayLikeObject('abc');
 * // => false
 *
 * _.isArrayLikeObject(_.noop);
 * // => false
 */


function isArrayLikeObject(value) {
  return isObjectLike(value) && isArrayLike(value);
}
/**
 * Checks if `value` is classified as a `Function` object.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a function, else `false`.
 * @example
 *
 * _.isFunction(_);
 * // => true
 *
 * _.isFunction(/abc/);
 * // => false
 */


function isFunction(value) {
  // The use of `Object#toString` avoids issues with the `typeof` operator
  // in Safari 8-9 which returns 'object' for typed array and other constructors.
  var tag = isObject(value) ? objectToString.call(value) : '';
  return tag == funcTag || tag == genTag;
}
/**
 * Checks if `value` is a valid array-like length.
 *
 * **Note:** This method is loosely based on
 * [`ToLength`](http://ecma-international.org/ecma-262/7.0/#sec-tolength).
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a valid length, else `false`.
 * @example
 *
 * _.isLength(3);
 * // => true
 *
 * _.isLength(Number.MIN_VALUE);
 * // => false
 *
 * _.isLength(Infinity);
 * // => false
 *
 * _.isLength('3');
 * // => false
 */


function isLength(value) {
  return typeof value == 'number' && value > -1 && value % 1 == 0 && value <= MAX_SAFE_INTEGER;
}
/**
 * Checks if `value` is the
 * [language type](http://www.ecma-international.org/ecma-262/7.0/#sec-ecmascript-language-types)
 * of `Object`. (e.g. arrays, functions, objects, regexes, `new Number(0)`, and `new String('')`)
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an object, else `false`.
 * @example
 *
 * _.isObject({});
 * // => true
 *
 * _.isObject([1, 2, 3]);
 * // => true
 *
 * _.isObject(_.noop);
 * // => true
 *
 * _.isObject(null);
 * // => false
 */


function isObject(value) {
  var type = _typeof(value);

  return !!value && (type == 'object' || type == 'function');
}
/**
 * Checks if `value` is object-like. A value is object-like if it's not `null`
 * and has a `typeof` result of "object".
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is object-like, else `false`.
 * @example
 *
 * _.isObjectLike({});
 * // => true
 *
 * _.isObjectLike([1, 2, 3]);
 * // => true
 *
 * _.isObjectLike(_.noop);
 * // => false
 *
 * _.isObjectLike(null);
 * // => false
 */


function isObjectLike(value) {
  return !!value && _typeof(value) == 'object';
}
/**
 * Creates an array of the own enumerable property names of `object`.
 *
 * **Note:** Non-object values are coerced to objects. See the
 * [ES spec](http://ecma-international.org/ecma-262/7.0/#sec-object.keys)
 * for more details.
 *
 * @static
 * @since 0.1.0
 * @memberOf _
 * @category Object
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property names.
 * @example
 *
 * function Foo() {
 *   this.a = 1;
 *   this.b = 2;
 * }
 *
 * Foo.prototype.c = 3;
 *
 * _.keys(new Foo);
 * // => ['a', 'b'] (iteration order is not guaranteed)
 *
 * _.keys('hi');
 * // => ['0', '1']
 */


function keys(object) {
  return isArrayLike(object) ? arrayLikeKeys(object) : baseKeys(object);
}
/**
 * Creates an array of own enumerable string keyed-value pairs for `object`
 * which can be consumed by `_.fromPairs`. If `object` is a map or set, its
 * entries are returned.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @alias entries
 * @category Object
 * @param {Object} object The object to query.
 * @returns {Array} Returns the key-value pairs.
 * @example
 *
 * function Foo() {
 *   this.a = 1;
 *   this.b = 2;
 * }
 *
 * Foo.prototype.c = 3;
 *
 * _.toPairs(new Foo);
 * // => [['a', 1], ['b', 2]] (iteration order is not guaranteed)
 */


var toPairs = createToPairs(keys);
module.exports = toPairs;
/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(2)))

/***/ }),
/* 12 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


module.exports = Pbf;

var ieee754 = __webpack_require__(21);

function Pbf(buf) {
  this.buf = ArrayBuffer.isView && ArrayBuffer.isView(buf) ? buf : new Uint8Array(buf || 0);
  this.pos = 0;
  this.type = 0;
  this.length = this.buf.length;
}

Pbf.Varint = 0; // varint: int32, int64, uint32, uint64, sint32, sint64, bool, enum

Pbf.Fixed64 = 1; // 64-bit: double, fixed64, sfixed64

Pbf.Bytes = 2; // length-delimited: string, bytes, embedded messages, packed repeated fields

Pbf.Fixed32 = 5; // 32-bit: float, fixed32, sfixed32

var SHIFT_LEFT_32 = (1 << 16) * (1 << 16),
    SHIFT_RIGHT_32 = 1 / SHIFT_LEFT_32; // Threshold chosen based on both benchmarking and knowledge about browser string
// data structures (which currently switch structure types at 12 bytes or more)

var TEXT_DECODER_MIN_LENGTH = 12;
var utf8TextDecoder = typeof TextDecoder === 'undefined' ? null : new TextDecoder('utf8');
Pbf.prototype = {
  destroy: function destroy() {
    this.buf = null;
  },
  // === READING =================================================================
  readFields: function readFields(readField, result, end) {
    end = end || this.length;

    while (this.pos < end) {
      var val = this.readVarint(),
          tag = val >> 3,
          startPos = this.pos;
      this.type = val & 0x7;
      readField(tag, result, this);
      if (this.pos === startPos) this.skip(val);
    }

    return result;
  },
  readMessage: function readMessage(readField, result) {
    return this.readFields(readField, result, this.readVarint() + this.pos);
  },
  readFixed32: function readFixed32() {
    var val = readUInt32(this.buf, this.pos);
    this.pos += 4;
    return val;
  },
  readSFixed32: function readSFixed32() {
    var val = readInt32(this.buf, this.pos);
    this.pos += 4;
    return val;
  },
  // 64-bit int handling is based on github.com/dpw/node-buffer-more-ints (MIT-licensed)
  readFixed64: function readFixed64() {
    var val = readUInt32(this.buf, this.pos) + readUInt32(this.buf, this.pos + 4) * SHIFT_LEFT_32;
    this.pos += 8;
    return val;
  },
  readSFixed64: function readSFixed64() {
    var val = readUInt32(this.buf, this.pos) + readInt32(this.buf, this.pos + 4) * SHIFT_LEFT_32;
    this.pos += 8;
    return val;
  },
  readFloat: function readFloat() {
    var val = ieee754.read(this.buf, this.pos, true, 23, 4);
    this.pos += 4;
    return val;
  },
  readDouble: function readDouble() {
    var val = ieee754.read(this.buf, this.pos, true, 52, 8);
    this.pos += 8;
    return val;
  },
  readVarint: function readVarint(isSigned) {
    var buf = this.buf,
        val,
        b;
    b = buf[this.pos++];
    val = b & 0x7f;
    if (b < 0x80) return val;
    b = buf[this.pos++];
    val |= (b & 0x7f) << 7;
    if (b < 0x80) return val;
    b = buf[this.pos++];
    val |= (b & 0x7f) << 14;
    if (b < 0x80) return val;
    b = buf[this.pos++];
    val |= (b & 0x7f) << 21;
    if (b < 0x80) return val;
    b = buf[this.pos];
    val |= (b & 0x0f) << 28;
    return readVarintRemainder(val, isSigned, this);
  },
  readVarint64: function readVarint64() {
    // for compatibility with v2.0.1
    return this.readVarint(true);
  },
  readSVarint: function readSVarint() {
    var num = this.readVarint();
    return num % 2 === 1 ? (num + 1) / -2 : num / 2; // zigzag encoding
  },
  readBoolean: function readBoolean() {
    return Boolean(this.readVarint());
  },
  readString: function readString() {
    var end = this.readVarint() + this.pos;
    var pos = this.pos;
    this.pos = end;

    if (end - pos >= TEXT_DECODER_MIN_LENGTH && utf8TextDecoder) {
      // longer strings are fast with the built-in browser TextDecoder API
      return readUtf8TextDecoder(this.buf, pos, end);
    } // short strings are fast with our custom implementation


    return readUtf8(this.buf, pos, end);
  },
  readBytes: function readBytes() {
    var end = this.readVarint() + this.pos,
        buffer = this.buf.subarray(this.pos, end);
    this.pos = end;
    return buffer;
  },
  // verbose for performance reasons; doesn't affect gzipped size
  readPackedVarint: function readPackedVarint(arr, isSigned) {
    if (this.type !== Pbf.Bytes) return arr.push(this.readVarint(isSigned));
    var end = readPackedEnd(this);
    arr = arr || [];

    while (this.pos < end) {
      arr.push(this.readVarint(isSigned));
    }

    return arr;
  },
  readPackedSVarint: function readPackedSVarint(arr) {
    if (this.type !== Pbf.Bytes) return arr.push(this.readSVarint());
    var end = readPackedEnd(this);
    arr = arr || [];

    while (this.pos < end) {
      arr.push(this.readSVarint());
    }

    return arr;
  },
  readPackedBoolean: function readPackedBoolean(arr) {
    if (this.type !== Pbf.Bytes) return arr.push(this.readBoolean());
    var end = readPackedEnd(this);
    arr = arr || [];

    while (this.pos < end) {
      arr.push(this.readBoolean());
    }

    return arr;
  },
  readPackedFloat: function readPackedFloat(arr) {
    if (this.type !== Pbf.Bytes) return arr.push(this.readFloat());
    var end = readPackedEnd(this);
    arr = arr || [];

    while (this.pos < end) {
      arr.push(this.readFloat());
    }

    return arr;
  },
  readPackedDouble: function readPackedDouble(arr) {
    if (this.type !== Pbf.Bytes) return arr.push(this.readDouble());
    var end = readPackedEnd(this);
    arr = arr || [];

    while (this.pos < end) {
      arr.push(this.readDouble());
    }

    return arr;
  },
  readPackedFixed32: function readPackedFixed32(arr) {
    if (this.type !== Pbf.Bytes) return arr.push(this.readFixed32());
    var end = readPackedEnd(this);
    arr = arr || [];

    while (this.pos < end) {
      arr.push(this.readFixed32());
    }

    return arr;
  },
  readPackedSFixed32: function readPackedSFixed32(arr) {
    if (this.type !== Pbf.Bytes) return arr.push(this.readSFixed32());
    var end = readPackedEnd(this);
    arr = arr || [];

    while (this.pos < end) {
      arr.push(this.readSFixed32());
    }

    return arr;
  },
  readPackedFixed64: function readPackedFixed64(arr) {
    if (this.type !== Pbf.Bytes) return arr.push(this.readFixed64());
    var end = readPackedEnd(this);
    arr = arr || [];

    while (this.pos < end) {
      arr.push(this.readFixed64());
    }

    return arr;
  },
  readPackedSFixed64: function readPackedSFixed64(arr) {
    if (this.type !== Pbf.Bytes) return arr.push(this.readSFixed64());
    var end = readPackedEnd(this);
    arr = arr || [];

    while (this.pos < end) {
      arr.push(this.readSFixed64());
    }

    return arr;
  },
  skip: function skip(val) {
    var type = val & 0x7;
    if (type === Pbf.Varint) while (this.buf[this.pos++] > 0x7f) {} else if (type === Pbf.Bytes) this.pos = this.readVarint() + this.pos;else if (type === Pbf.Fixed32) this.pos += 4;else if (type === Pbf.Fixed64) this.pos += 8;else throw new Error('Unimplemented type: ' + type);
  },
  // === WRITING =================================================================
  writeTag: function writeTag(tag, type) {
    this.writeVarint(tag << 3 | type);
  },
  realloc: function realloc(min) {
    var length = this.length || 16;

    while (length < this.pos + min) {
      length *= 2;
    }

    if (length !== this.length) {
      var buf = new Uint8Array(length);
      buf.set(this.buf);
      this.buf = buf;
      this.length = length;
    }
  },
  finish: function finish() {
    this.length = this.pos;
    this.pos = 0;
    return this.buf.subarray(0, this.length);
  },
  writeFixed32: function writeFixed32(val) {
    this.realloc(4);
    writeInt32(this.buf, val, this.pos);
    this.pos += 4;
  },
  writeSFixed32: function writeSFixed32(val) {
    this.realloc(4);
    writeInt32(this.buf, val, this.pos);
    this.pos += 4;
  },
  writeFixed64: function writeFixed64(val) {
    this.realloc(8);
    writeInt32(this.buf, val & -1, this.pos);
    writeInt32(this.buf, Math.floor(val * SHIFT_RIGHT_32), this.pos + 4);
    this.pos += 8;
  },
  writeSFixed64: function writeSFixed64(val) {
    this.realloc(8);
    writeInt32(this.buf, val & -1, this.pos);
    writeInt32(this.buf, Math.floor(val * SHIFT_RIGHT_32), this.pos + 4);
    this.pos += 8;
  },
  writeVarint: function writeVarint(val) {
    val = +val || 0;

    if (val > 0xfffffff || val < 0) {
      writeBigVarint(val, this);
      return;
    }

    this.realloc(4);
    this.buf[this.pos++] = val & 0x7f | (val > 0x7f ? 0x80 : 0);
    if (val <= 0x7f) return;
    this.buf[this.pos++] = (val >>>= 7) & 0x7f | (val > 0x7f ? 0x80 : 0);
    if (val <= 0x7f) return;
    this.buf[this.pos++] = (val >>>= 7) & 0x7f | (val > 0x7f ? 0x80 : 0);
    if (val <= 0x7f) return;
    this.buf[this.pos++] = val >>> 7 & 0x7f;
  },
  writeSVarint: function writeSVarint(val) {
    this.writeVarint(val < 0 ? -val * 2 - 1 : val * 2);
  },
  writeBoolean: function writeBoolean(val) {
    this.writeVarint(Boolean(val));
  },
  writeString: function writeString(str) {
    str = String(str);
    this.realloc(str.length * 4);
    this.pos++; // reserve 1 byte for short string length

    var startPos = this.pos; // write the string directly to the buffer and see how much was written

    this.pos = writeUtf8(this.buf, str, this.pos);
    var len = this.pos - startPos;
    if (len >= 0x80) makeRoomForExtraLength(startPos, len, this); // finally, write the message length in the reserved place and restore the position

    this.pos = startPos - 1;
    this.writeVarint(len);
    this.pos += len;
  },
  writeFloat: function writeFloat(val) {
    this.realloc(4);
    ieee754.write(this.buf, val, this.pos, true, 23, 4);
    this.pos += 4;
  },
  writeDouble: function writeDouble(val) {
    this.realloc(8);
    ieee754.write(this.buf, val, this.pos, true, 52, 8);
    this.pos += 8;
  },
  writeBytes: function writeBytes(buffer) {
    var len = buffer.length;
    this.writeVarint(len);
    this.realloc(len);

    for (var i = 0; i < len; i++) {
      this.buf[this.pos++] = buffer[i];
    }
  },
  writeRawMessage: function writeRawMessage(fn, obj) {
    this.pos++; // reserve 1 byte for short message length
    // write the message directly to the buffer and see how much was written

    var startPos = this.pos;
    fn(obj, this);
    var len = this.pos - startPos;
    if (len >= 0x80) makeRoomForExtraLength(startPos, len, this); // finally, write the message length in the reserved place and restore the position

    this.pos = startPos - 1;
    this.writeVarint(len);
    this.pos += len;
  },
  writeMessage: function writeMessage(tag, fn, obj) {
    this.writeTag(tag, Pbf.Bytes);
    this.writeRawMessage(fn, obj);
  },
  writePackedVarint: function writePackedVarint(tag, arr) {
    if (arr.length) this.writeMessage(tag, _writePackedVarint, arr);
  },
  writePackedSVarint: function writePackedSVarint(tag, arr) {
    if (arr.length) this.writeMessage(tag, _writePackedSVarint, arr);
  },
  writePackedBoolean: function writePackedBoolean(tag, arr) {
    if (arr.length) this.writeMessage(tag, _writePackedBoolean, arr);
  },
  writePackedFloat: function writePackedFloat(tag, arr) {
    if (arr.length) this.writeMessage(tag, _writePackedFloat, arr);
  },
  writePackedDouble: function writePackedDouble(tag, arr) {
    if (arr.length) this.writeMessage(tag, _writePackedDouble, arr);
  },
  writePackedFixed32: function writePackedFixed32(tag, arr) {
    if (arr.length) this.writeMessage(tag, _writePackedFixed, arr);
  },
  writePackedSFixed32: function writePackedSFixed32(tag, arr) {
    if (arr.length) this.writeMessage(tag, _writePackedSFixed, arr);
  },
  writePackedFixed64: function writePackedFixed64(tag, arr) {
    if (arr.length) this.writeMessage(tag, _writePackedFixed2, arr);
  },
  writePackedSFixed64: function writePackedSFixed64(tag, arr) {
    if (arr.length) this.writeMessage(tag, _writePackedSFixed2, arr);
  },
  writeBytesField: function writeBytesField(tag, buffer) {
    this.writeTag(tag, Pbf.Bytes);
    this.writeBytes(buffer);
  },
  writeFixed32Field: function writeFixed32Field(tag, val) {
    this.writeTag(tag, Pbf.Fixed32);
    this.writeFixed32(val);
  },
  writeSFixed32Field: function writeSFixed32Field(tag, val) {
    this.writeTag(tag, Pbf.Fixed32);
    this.writeSFixed32(val);
  },
  writeFixed64Field: function writeFixed64Field(tag, val) {
    this.writeTag(tag, Pbf.Fixed64);
    this.writeFixed64(val);
  },
  writeSFixed64Field: function writeSFixed64Field(tag, val) {
    this.writeTag(tag, Pbf.Fixed64);
    this.writeSFixed64(val);
  },
  writeVarintField: function writeVarintField(tag, val) {
    this.writeTag(tag, Pbf.Varint);
    this.writeVarint(val);
  },
  writeSVarintField: function writeSVarintField(tag, val) {
    this.writeTag(tag, Pbf.Varint);
    this.writeSVarint(val);
  },
  writeStringField: function writeStringField(tag, str) {
    this.writeTag(tag, Pbf.Bytes);
    this.writeString(str);
  },
  writeFloatField: function writeFloatField(tag, val) {
    this.writeTag(tag, Pbf.Fixed32);
    this.writeFloat(val);
  },
  writeDoubleField: function writeDoubleField(tag, val) {
    this.writeTag(tag, Pbf.Fixed64);
    this.writeDouble(val);
  },
  writeBooleanField: function writeBooleanField(tag, val) {
    this.writeVarintField(tag, Boolean(val));
  }
};

function readVarintRemainder(l, s, p) {
  var buf = p.buf,
      h,
      b;
  b = buf[p.pos++];
  h = (b & 0x70) >> 4;
  if (b < 0x80) return toNum(l, h, s);
  b = buf[p.pos++];
  h |= (b & 0x7f) << 3;
  if (b < 0x80) return toNum(l, h, s);
  b = buf[p.pos++];
  h |= (b & 0x7f) << 10;
  if (b < 0x80) return toNum(l, h, s);
  b = buf[p.pos++];
  h |= (b & 0x7f) << 17;
  if (b < 0x80) return toNum(l, h, s);
  b = buf[p.pos++];
  h |= (b & 0x7f) << 24;
  if (b < 0x80) return toNum(l, h, s);
  b = buf[p.pos++];
  h |= (b & 0x01) << 31;
  if (b < 0x80) return toNum(l, h, s);
  throw new Error('Expected varint not more than 10 bytes');
}

function readPackedEnd(pbf) {
  return pbf.type === Pbf.Bytes ? pbf.readVarint() + pbf.pos : pbf.pos + 1;
}

function toNum(low, high, isSigned) {
  if (isSigned) {
    return high * 0x100000000 + (low >>> 0);
  }

  return (high >>> 0) * 0x100000000 + (low >>> 0);
}

function writeBigVarint(val, pbf) {
  var low, high;

  if (val >= 0) {
    low = val % 0x100000000 | 0;
    high = val / 0x100000000 | 0;
  } else {
    low = ~(-val % 0x100000000);
    high = ~(-val / 0x100000000);

    if (low ^ 0xffffffff) {
      low = low + 1 | 0;
    } else {
      low = 0;
      high = high + 1 | 0;
    }
  }

  if (val >= 0x10000000000000000 || val < -0x10000000000000000) {
    throw new Error('Given varint doesn\'t fit into 10 bytes');
  }

  pbf.realloc(10);
  writeBigVarintLow(low, high, pbf);
  writeBigVarintHigh(high, pbf);
}

function writeBigVarintLow(low, high, pbf) {
  pbf.buf[pbf.pos++] = low & 0x7f | 0x80;
  low >>>= 7;
  pbf.buf[pbf.pos++] = low & 0x7f | 0x80;
  low >>>= 7;
  pbf.buf[pbf.pos++] = low & 0x7f | 0x80;
  low >>>= 7;
  pbf.buf[pbf.pos++] = low & 0x7f | 0x80;
  low >>>= 7;
  pbf.buf[pbf.pos] = low & 0x7f;
}

function writeBigVarintHigh(high, pbf) {
  var lsb = (high & 0x07) << 4;
  pbf.buf[pbf.pos++] |= lsb | ((high >>>= 3) ? 0x80 : 0);
  if (!high) return;
  pbf.buf[pbf.pos++] = high & 0x7f | ((high >>>= 7) ? 0x80 : 0);
  if (!high) return;
  pbf.buf[pbf.pos++] = high & 0x7f | ((high >>>= 7) ? 0x80 : 0);
  if (!high) return;
  pbf.buf[pbf.pos++] = high & 0x7f | ((high >>>= 7) ? 0x80 : 0);
  if (!high) return;
  pbf.buf[pbf.pos++] = high & 0x7f | ((high >>>= 7) ? 0x80 : 0);
  if (!high) return;
  pbf.buf[pbf.pos++] = high & 0x7f;
}

function makeRoomForExtraLength(startPos, len, pbf) {
  var extraLen = len <= 0x3fff ? 1 : len <= 0x1fffff ? 2 : len <= 0xfffffff ? 3 : Math.floor(Math.log(len) / (Math.LN2 * 7)); // if 1 byte isn't enough for encoding message length, shift the data to the right

  pbf.realloc(extraLen);

  for (var i = pbf.pos - 1; i >= startPos; i--) {
    pbf.buf[i + extraLen] = pbf.buf[i];
  }
}

function _writePackedVarint(arr, pbf) {
  for (var i = 0; i < arr.length; i++) {
    pbf.writeVarint(arr[i]);
  }
}

function _writePackedSVarint(arr, pbf) {
  for (var i = 0; i < arr.length; i++) {
    pbf.writeSVarint(arr[i]);
  }
}

function _writePackedFloat(arr, pbf) {
  for (var i = 0; i < arr.length; i++) {
    pbf.writeFloat(arr[i]);
  }
}

function _writePackedDouble(arr, pbf) {
  for (var i = 0; i < arr.length; i++) {
    pbf.writeDouble(arr[i]);
  }
}

function _writePackedBoolean(arr, pbf) {
  for (var i = 0; i < arr.length; i++) {
    pbf.writeBoolean(arr[i]);
  }
}

function _writePackedFixed(arr, pbf) {
  for (var i = 0; i < arr.length; i++) {
    pbf.writeFixed32(arr[i]);
  }
}

function _writePackedSFixed(arr, pbf) {
  for (var i = 0; i < arr.length; i++) {
    pbf.writeSFixed32(arr[i]);
  }
}

function _writePackedFixed2(arr, pbf) {
  for (var i = 0; i < arr.length; i++) {
    pbf.writeFixed64(arr[i]);
  }
}

function _writePackedSFixed2(arr, pbf) {
  for (var i = 0; i < arr.length; i++) {
    pbf.writeSFixed64(arr[i]);
  }
} // Buffer code below from https://github.com/feross/buffer, MIT-licensed


function readUInt32(buf, pos) {
  return (buf[pos] | buf[pos + 1] << 8 | buf[pos + 2] << 16) + buf[pos + 3] * 0x1000000;
}

function writeInt32(buf, val, pos) {
  buf[pos] = val;
  buf[pos + 1] = val >>> 8;
  buf[pos + 2] = val >>> 16;
  buf[pos + 3] = val >>> 24;
}

function readInt32(buf, pos) {
  return (buf[pos] | buf[pos + 1] << 8 | buf[pos + 2] << 16) + (buf[pos + 3] << 24);
}

function readUtf8(buf, pos, end) {
  var str = '';
  var i = pos;

  while (i < end) {
    var b0 = buf[i];
    var c = null; // codepoint

    var bytesPerSequence = b0 > 0xEF ? 4 : b0 > 0xDF ? 3 : b0 > 0xBF ? 2 : 1;
    if (i + bytesPerSequence > end) break;
    var b1, b2, b3;

    if (bytesPerSequence === 1) {
      if (b0 < 0x80) {
        c = b0;
      }
    } else if (bytesPerSequence === 2) {
      b1 = buf[i + 1];

      if ((b1 & 0xC0) === 0x80) {
        c = (b0 & 0x1F) << 0x6 | b1 & 0x3F;

        if (c <= 0x7F) {
          c = null;
        }
      }
    } else if (bytesPerSequence === 3) {
      b1 = buf[i + 1];
      b2 = buf[i + 2];

      if ((b1 & 0xC0) === 0x80 && (b2 & 0xC0) === 0x80) {
        c = (b0 & 0xF) << 0xC | (b1 & 0x3F) << 0x6 | b2 & 0x3F;

        if (c <= 0x7FF || c >= 0xD800 && c <= 0xDFFF) {
          c = null;
        }
      }
    } else if (bytesPerSequence === 4) {
      b1 = buf[i + 1];
      b2 = buf[i + 2];
      b3 = buf[i + 3];

      if ((b1 & 0xC0) === 0x80 && (b2 & 0xC0) === 0x80 && (b3 & 0xC0) === 0x80) {
        c = (b0 & 0xF) << 0x12 | (b1 & 0x3F) << 0xC | (b2 & 0x3F) << 0x6 | b3 & 0x3F;

        if (c <= 0xFFFF || c >= 0x110000) {
          c = null;
        }
      }
    }

    if (c === null) {
      c = 0xFFFD;
      bytesPerSequence = 1;
    } else if (c > 0xFFFF) {
      c -= 0x10000;
      str += String.fromCharCode(c >>> 10 & 0x3FF | 0xD800);
      c = 0xDC00 | c & 0x3FF;
    }

    str += String.fromCharCode(c);
    i += bytesPerSequence;
  }

  return str;
}

function readUtf8TextDecoder(buf, pos, end) {
  return utf8TextDecoder.decode(buf.subarray(pos, end));
}

function writeUtf8(buf, str, pos) {
  for (var i = 0, c, lead; i < str.length; i++) {
    c = str.charCodeAt(i); // code point

    if (c > 0xD7FF && c < 0xE000) {
      if (lead) {
        if (c < 0xDC00) {
          buf[pos++] = 0xEF;
          buf[pos++] = 0xBF;
          buf[pos++] = 0xBD;
          lead = c;
          continue;
        } else {
          c = lead - 0xD800 << 10 | c - 0xDC00 | 0x10000;
          lead = null;
        }
      } else {
        if (c > 0xDBFF || i + 1 === str.length) {
          buf[pos++] = 0xEF;
          buf[pos++] = 0xBF;
          buf[pos++] = 0xBD;
        } else {
          lead = c;
        }

        continue;
      }
    } else if (lead) {
      buf[pos++] = 0xEF;
      buf[pos++] = 0xBF;
      buf[pos++] = 0xBD;
      lead = null;
    }

    if (c < 0x80) {
      buf[pos++] = c;
    } else {
      if (c < 0x800) {
        buf[pos++] = c >> 0x6 | 0xC0;
      } else {
        if (c < 0x10000) {
          buf[pos++] = c >> 0xC | 0xE0;
        } else {
          buf[pos++] = c >> 0x12 | 0xF0;
          buf[pos++] = c >> 0xC & 0x3F | 0x80;
        }

        buf[pos++] = c >> 0x6 & 0x3F | 0x80;
      }

      buf[pos++] = c & 0x3F | 0x80;
    }
  }

  return pos;
}

/***/ }),
/* 13 */
/***/ (function(module, exports, __webpack_require__) {

module.exports.VectorTile = __webpack_require__(22);
module.exports.VectorTileFeature = __webpack_require__(9);
module.exports.VectorTileLayer = __webpack_require__(8);

/***/ }),
/* 14 */
/***/ (function(module, exports, __webpack_require__) {

__webpack_require__(24);
module.exports = __webpack_require__(25);


/***/ }),
/* 15 */
/***/ (function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(setImmediate, global) {var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_RESULT__;function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

(function (global, factory) {
  ( false ? undefined : _typeof(exports)) === 'object' && typeof module !== 'undefined' ? factory() :  true ? !(__WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
				__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
				(__WEBPACK_AMD_DEFINE_FACTORY__.call(exports, __webpack_require__, exports, module)) :
				__WEBPACK_AMD_DEFINE_FACTORY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__)) : undefined;
})(this, function () {
  'use strict';
  /**
   * @this {Promise}
   */

  function finallyConstructor(callback) {
    var constructor = this.constructor;
    return this.then(function (value) {
      // @ts-ignore
      return constructor.resolve(callback()).then(function () {
        return value;
      });
    }, function (reason) {
      // @ts-ignore
      return constructor.resolve(callback()).then(function () {
        // @ts-ignore
        return constructor.reject(reason);
      });
    });
  } // Store setTimeout reference so promise-polyfill will be unaffected by
  // other code modifying setTimeout (like sinon.useFakeTimers())


  var setTimeoutFunc = setTimeout;

  function isArray(x) {
    return Boolean(x && typeof x.length !== 'undefined');
  }

  function noop() {} // Polyfill for Function.prototype.bind


  function bind(fn, thisArg) {
    return function () {
      fn.apply(thisArg, arguments);
    };
  }
  /**
   * @constructor
   * @param {Function} fn
   */


  function Promise(fn) {
    if (!(this instanceof Promise)) throw new TypeError('Promises must be constructed via new');
    if (typeof fn !== 'function') throw new TypeError('not a function');
    /** @type {!number} */

    this._state = 0;
    /** @type {!boolean} */

    this._handled = false;
    /** @type {Promise|undefined} */

    this._value = undefined;
    /** @type {!Array<!Function>} */

    this._deferreds = [];
    doResolve(fn, this);
  }

  function handle(self, deferred) {
    while (self._state === 3) {
      self = self._value;
    }

    if (self._state === 0) {
      self._deferreds.push(deferred);

      return;
    }

    self._handled = true;

    Promise._immediateFn(function () {
      var cb = self._state === 1 ? deferred.onFulfilled : deferred.onRejected;

      if (cb === null) {
        (self._state === 1 ? resolve : reject)(deferred.promise, self._value);
        return;
      }

      var ret;

      try {
        ret = cb(self._value);
      } catch (e) {
        reject(deferred.promise, e);
        return;
      }

      resolve(deferred.promise, ret);
    });
  }

  function resolve(self, newValue) {
    try {
      // Promise Resolution Procedure: https://github.com/promises-aplus/promises-spec#the-promise-resolution-procedure
      if (newValue === self) throw new TypeError('A promise cannot be resolved with itself.');

      if (newValue && (_typeof(newValue) === 'object' || typeof newValue === 'function')) {
        var then = newValue.then;

        if (newValue instanceof Promise) {
          self._state = 3;
          self._value = newValue;
          finale(self);
          return;
        } else if (typeof then === 'function') {
          doResolve(bind(then, newValue), self);
          return;
        }
      }

      self._state = 1;
      self._value = newValue;
      finale(self);
    } catch (e) {
      reject(self, e);
    }
  }

  function reject(self, newValue) {
    self._state = 2;
    self._value = newValue;
    finale(self);
  }

  function finale(self) {
    if (self._state === 2 && self._deferreds.length === 0) {
      Promise._immediateFn(function () {
        if (!self._handled) {
          Promise._unhandledRejectionFn(self._value);
        }
      });
    }

    for (var i = 0, len = self._deferreds.length; i < len; i++) {
      handle(self, self._deferreds[i]);
    }

    self._deferreds = null;
  }
  /**
   * @constructor
   */


  function Handler(onFulfilled, onRejected, promise) {
    this.onFulfilled = typeof onFulfilled === 'function' ? onFulfilled : null;
    this.onRejected = typeof onRejected === 'function' ? onRejected : null;
    this.promise = promise;
  }
  /**
   * Take a potentially misbehaving resolver function and make sure
   * onFulfilled and onRejected are only called once.
   *
   * Makes no guarantees about asynchrony.
   */


  function doResolve(fn, self) {
    var done = false;

    try {
      fn(function (value) {
        if (done) return;
        done = true;
        resolve(self, value);
      }, function (reason) {
        if (done) return;
        done = true;
        reject(self, reason);
      });
    } catch (ex) {
      if (done) return;
      done = true;
      reject(self, ex);
    }
  }

  Promise.prototype['catch'] = function (onRejected) {
    return this.then(null, onRejected);
  };

  Promise.prototype.then = function (onFulfilled, onRejected) {
    // @ts-ignore
    var prom = new this.constructor(noop);
    handle(this, new Handler(onFulfilled, onRejected, prom));
    return prom;
  };

  Promise.prototype['finally'] = finallyConstructor;

  Promise.all = function (arr) {
    return new Promise(function (resolve, reject) {
      if (!isArray(arr)) {
        return reject(new TypeError('Promise.all accepts an array'));
      }

      var args = Array.prototype.slice.call(arr);
      if (args.length === 0) return resolve([]);
      var remaining = args.length;

      function res(i, val) {
        try {
          if (val && (_typeof(val) === 'object' || typeof val === 'function')) {
            var then = val.then;

            if (typeof then === 'function') {
              then.call(val, function (val) {
                res(i, val);
              }, reject);
              return;
            }
          }

          args[i] = val;

          if (--remaining === 0) {
            resolve(args);
          }
        } catch (ex) {
          reject(ex);
        }
      }

      for (var i = 0; i < args.length; i++) {
        res(i, args[i]);
      }
    });
  };

  Promise.resolve = function (value) {
    if (value && _typeof(value) === 'object' && value.constructor === Promise) {
      return value;
    }

    return new Promise(function (resolve) {
      resolve(value);
    });
  };

  Promise.reject = function (value) {
    return new Promise(function (resolve, reject) {
      reject(value);
    });
  };

  Promise.race = function (arr) {
    return new Promise(function (resolve, reject) {
      if (!isArray(arr)) {
        return reject(new TypeError('Promise.race accepts an array'));
      }

      for (var i = 0, len = arr.length; i < len; i++) {
        Promise.resolve(arr[i]).then(resolve, reject);
      }
    });
  }; // Use polyfill for setImmediate for performance gains


  Promise._immediateFn = // @ts-ignore
  typeof setImmediate === 'function' && function (fn) {
    // @ts-ignore
    setImmediate(fn);
  } || function (fn) {
    setTimeoutFunc(fn, 0);
  };

  Promise._unhandledRejectionFn = function _unhandledRejectionFn(err) {
    if (typeof console !== 'undefined' && console) {
      console.warn('Possible Unhandled Promise Rejection:', err); // eslint-disable-line no-console
    }
  };
  /** @suppress {undefinedVars} */


  var globalNS = function () {
    // the only reliable means to get the global object is
    // `Function('return this')()`
    // However, this causes CSP violations in Chrome apps.
    if (typeof self !== 'undefined') {
      return self;
    }

    if (typeof window !== 'undefined') {
      return window;
    }

    if (typeof global !== 'undefined') {
      return global;
    }

    throw new Error('unable to locate global object');
  }();

  if (!('Promise' in globalNS)) {
    globalNS['Promise'] = Promise;
  } else if (!globalNS.Promise.prototype['finally']) {
    globalNS.Promise.prototype['finally'] = finallyConstructor;
  }
});
/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(16).setImmediate, __webpack_require__(2)))

/***/ }),
/* 16 */
/***/ (function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(global) {var scope = typeof global !== "undefined" && global || typeof self !== "undefined" && self || window;
var apply = Function.prototype.apply; // DOM APIs, for completeness

exports.setTimeout = function () {
  return new Timeout(apply.call(setTimeout, scope, arguments), clearTimeout);
};

exports.setInterval = function () {
  return new Timeout(apply.call(setInterval, scope, arguments), clearInterval);
};

exports.clearTimeout = exports.clearInterval = function (timeout) {
  if (timeout) {
    timeout.close();
  }
};

function Timeout(id, clearFn) {
  this._id = id;
  this._clearFn = clearFn;
}

Timeout.prototype.unref = Timeout.prototype.ref = function () {};

Timeout.prototype.close = function () {
  this._clearFn.call(scope, this._id);
}; // Does not start the time, just sets up the members needed.


exports.enroll = function (item, msecs) {
  clearTimeout(item._idleTimeoutId);
  item._idleTimeout = msecs;
};

exports.unenroll = function (item) {
  clearTimeout(item._idleTimeoutId);
  item._idleTimeout = -1;
};

exports._unrefActive = exports.active = function (item) {
  clearTimeout(item._idleTimeoutId);
  var msecs = item._idleTimeout;

  if (msecs >= 0) {
    item._idleTimeoutId = setTimeout(function onTimeout() {
      if (item._onTimeout) item._onTimeout();
    }, msecs);
  }
}; // setimmediate attaches itself to the global object


__webpack_require__(17); // On some exotic environments, it's not clear which object `setimmediate` was
// able to install onto.  Search each possibility in the same order as the
// `setimmediate` library.


exports.setImmediate = typeof self !== "undefined" && self.setImmediate || typeof global !== "undefined" && global.setImmediate || this && this.setImmediate;
exports.clearImmediate = typeof self !== "undefined" && self.clearImmediate || typeof global !== "undefined" && global.clearImmediate || this && this.clearImmediate;
/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(2)))

/***/ }),
/* 17 */
/***/ (function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(global, process) {(function (global, undefined) {
    "use strict";

    if (global.setImmediate) {
        return;
    }

    var nextHandle = 1; // Spec says greater than zero
    var tasksByHandle = {};
    var currentlyRunningATask = false;
    var doc = global.document;
    var registerImmediate;

    function setImmediate(callback) {
      // Callback can either be a function or a string
      if (typeof callback !== "function") {
        callback = new Function("" + callback);
      }
      // Copy function arguments
      var args = new Array(arguments.length - 1);
      for (var i = 0; i < args.length; i++) {
          args[i] = arguments[i + 1];
      }
      // Store and register the task
      var task = { callback: callback, args: args };
      tasksByHandle[nextHandle] = task;
      registerImmediate(nextHandle);
      return nextHandle++;
    }

    function clearImmediate(handle) {
        delete tasksByHandle[handle];
    }

    function run(task) {
        var callback = task.callback;
        var args = task.args;
        switch (args.length) {
        case 0:
            callback();
            break;
        case 1:
            callback(args[0]);
            break;
        case 2:
            callback(args[0], args[1]);
            break;
        case 3:
            callback(args[0], args[1], args[2]);
            break;
        default:
            callback.apply(undefined, args);
            break;
        }
    }

    function runIfPresent(handle) {
        // From the spec: "Wait until any invocations of this algorithm started before this one have completed."
        // So if we're currently running a task, we'll need to delay this invocation.
        if (currentlyRunningATask) {
            // Delay by doing a setTimeout. setImmediate was tried instead, but in Firefox 7 it generated a
            // "too much recursion" error.
            setTimeout(runIfPresent, 0, handle);
        } else {
            var task = tasksByHandle[handle];
            if (task) {
                currentlyRunningATask = true;
                try {
                    run(task);
                } finally {
                    clearImmediate(handle);
                    currentlyRunningATask = false;
                }
            }
        }
    }

    function installNextTickImplementation() {
        registerImmediate = function(handle) {
            process.nextTick(function () { runIfPresent(handle); });
        };
    }

    function canUsePostMessage() {
        // The test against `importScripts` prevents this implementation from being installed inside a web worker,
        // where `global.postMessage` means something completely different and can't be used for this purpose.
        if (global.postMessage && !global.importScripts) {
            var postMessageIsAsynchronous = true;
            var oldOnMessage = global.onmessage;
            global.onmessage = function() {
                postMessageIsAsynchronous = false;
            };
            global.postMessage("", "*");
            global.onmessage = oldOnMessage;
            return postMessageIsAsynchronous;
        }
    }

    function installPostMessageImplementation() {
        // Installs an event handler on `global` for the `message` event: see
        // * https://developer.mozilla.org/en/DOM/window.postMessage
        // * http://www.whatwg.org/specs/web-apps/current-work/multipage/comms.html#crossDocumentMessages

        var messagePrefix = "setImmediate$" + Math.random() + "$";
        var onGlobalMessage = function(event) {
            if (event.source === global &&
                typeof event.data === "string" &&
                event.data.indexOf(messagePrefix) === 0) {
                runIfPresent(+event.data.slice(messagePrefix.length));
            }
        };

        if (global.addEventListener) {
            global.addEventListener("message", onGlobalMessage, false);
        } else {
            global.attachEvent("onmessage", onGlobalMessage);
        }

        registerImmediate = function(handle) {
            global.postMessage(messagePrefix + handle, "*");
        };
    }

    function installMessageChannelImplementation() {
        var channel = new MessageChannel();
        channel.port1.onmessage = function(event) {
            var handle = event.data;
            runIfPresent(handle);
        };

        registerImmediate = function(handle) {
            channel.port2.postMessage(handle);
        };
    }

    function installReadyStateChangeImplementation() {
        var html = doc.documentElement;
        registerImmediate = function(handle) {
            // Create a <script> element; its readystatechange event will be fired asynchronously once it is inserted
            // into the document. Do so, thus queuing up the task. Remember to clean up once it's been called.
            var script = doc.createElement("script");
            script.onreadystatechange = function () {
                runIfPresent(handle);
                script.onreadystatechange = null;
                html.removeChild(script);
                script = null;
            };
            html.appendChild(script);
        };
    }

    function installSetTimeoutImplementation() {
        registerImmediate = function(handle) {
            setTimeout(runIfPresent, 0, handle);
        };
    }

    // If supported, we should attach to the prototype of global, since that is where setTimeout et al. live.
    var attachTo = Object.getPrototypeOf && Object.getPrototypeOf(global);
    attachTo = attachTo && attachTo.setTimeout ? attachTo : global;

    // Don't get fooled by e.g. browserify environments.
    if ({}.toString.call(global.process) === "[object process]") {
        // For Node.js before 0.9
        installNextTickImplementation();

    } else if (canUsePostMessage()) {
        // For non-IE10 modern browsers
        installPostMessageImplementation();

    } else if (global.MessageChannel) {
        // For web workers, where supported
        installMessageChannelImplementation();

    } else if (doc && "onreadystatechange" in doc.createElement("script")) {
        // For IE 6–8
        installReadyStateChangeImplementation();

    } else {
        // For older browsers
        installSetTimeoutImplementation();
    }

    attachTo.setImmediate = setImmediate;
    attachTo.clearImmediate = clearImmediate;
}(typeof self === "undefined" ? typeof global === "undefined" ? this : global : self));

/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(2), __webpack_require__(18)))

/***/ }),
/* 18 */
/***/ (function(module, exports) {

// shim for using process in browser
var process = module.exports = {}; // cached from whatever global is present so that test runners that stub it
// don't break things.  But we need to wrap it in a try catch in case it is
// wrapped in strict mode code which doesn't define any globals.  It's inside a
// function because try/catches deoptimize in certain engines.

var cachedSetTimeout;
var cachedClearTimeout;

function defaultSetTimout() {
  throw new Error('setTimeout has not been defined');
}

function defaultClearTimeout() {
  throw new Error('clearTimeout has not been defined');
}

(function () {
  try {
    if (typeof setTimeout === 'function') {
      cachedSetTimeout = setTimeout;
    } else {
      cachedSetTimeout = defaultSetTimout;
    }
  } catch (e) {
    cachedSetTimeout = defaultSetTimout;
  }

  try {
    if (typeof clearTimeout === 'function') {
      cachedClearTimeout = clearTimeout;
    } else {
      cachedClearTimeout = defaultClearTimeout;
    }
  } catch (e) {
    cachedClearTimeout = defaultClearTimeout;
  }
})();

function runTimeout(fun) {
  if (cachedSetTimeout === setTimeout) {
    //normal enviroments in sane situations
    return setTimeout(fun, 0);
  } // if setTimeout wasn't available but was latter defined


  if ((cachedSetTimeout === defaultSetTimout || !cachedSetTimeout) && setTimeout) {
    cachedSetTimeout = setTimeout;
    return setTimeout(fun, 0);
  }

  try {
    // when when somebody has screwed with setTimeout but no I.E. maddness
    return cachedSetTimeout(fun, 0);
  } catch (e) {
    try {
      // When we are in I.E. but the script has been evaled so I.E. doesn't trust the global object when called normally
      return cachedSetTimeout.call(null, fun, 0);
    } catch (e) {
      // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error
      return cachedSetTimeout.call(this, fun, 0);
    }
  }
}

function runClearTimeout(marker) {
  if (cachedClearTimeout === clearTimeout) {
    //normal enviroments in sane situations
    return clearTimeout(marker);
  } // if clearTimeout wasn't available but was latter defined


  if ((cachedClearTimeout === defaultClearTimeout || !cachedClearTimeout) && clearTimeout) {
    cachedClearTimeout = clearTimeout;
    return clearTimeout(marker);
  }

  try {
    // when when somebody has screwed with setTimeout but no I.E. maddness
    return cachedClearTimeout(marker);
  } catch (e) {
    try {
      // When we are in I.E. but the script has been evaled so I.E. doesn't  trust the global object when called normally
      return cachedClearTimeout.call(null, marker);
    } catch (e) {
      // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error.
      // Some versions of I.E. have different rules for clearTimeout vs setTimeout
      return cachedClearTimeout.call(this, marker);
    }
  }
}

var queue = [];
var draining = false;
var currentQueue;
var queueIndex = -1;

function cleanUpNextTick() {
  if (!draining || !currentQueue) {
    return;
  }

  draining = false;

  if (currentQueue.length) {
    queue = currentQueue.concat(queue);
  } else {
    queueIndex = -1;
  }

  if (queue.length) {
    drainQueue();
  }
}

function drainQueue() {
  if (draining) {
    return;
  }

  var timeout = runTimeout(cleanUpNextTick);
  draining = true;
  var len = queue.length;

  while (len) {
    currentQueue = queue;
    queue = [];

    while (++queueIndex < len) {
      if (currentQueue) {
        currentQueue[queueIndex].run();
      }
    }

    queueIndex = -1;
    len = queue.length;
  }

  currentQueue = null;
  draining = false;
  runClearTimeout(timeout);
}

process.nextTick = function (fun) {
  var args = new Array(arguments.length - 1);

  if (arguments.length > 1) {
    for (var i = 1; i < arguments.length; i++) {
      args[i - 1] = arguments[i];
    }
  }

  queue.push(new Item(fun, args));

  if (queue.length === 1 && !draining) {
    runTimeout(drainQueue);
  }
}; // v8 likes predictible objects


function Item(fun, array) {
  this.fun = fun;
  this.array = array;
}

Item.prototype.run = function () {
  this.fun.apply(null, this.array);
};

process.title = 'browser';
process.browser = true;
process.env = {};
process.argv = [];
process.version = ''; // empty string to avoid regexp issues

process.versions = {};

function noop() {}

process.on = noop;
process.addListener = noop;
process.once = noop;
process.off = noop;
process.removeListener = noop;
process.removeAllListeners = noop;
process.emit = noop;
process.prependListener = noop;
process.prependOnceListener = noop;

process.listeners = function (name) {
  return [];
};

process.binding = function (name) {
  throw new Error('process.binding is not supported');
};

process.cwd = function () {
  return '/';
};

process.chdir = function (dir) {
  throw new Error('process.chdir is not supported');
};

process.umask = function () {
  return 0;
};

/***/ }),
/* 19 */
/***/ (function(module, exports, __webpack_require__) {

(function (self) {
  'use strict'; // if __disableNativeFetch is set to true, the it will always polyfill fetch
  // with Ajax.

  if (!self.__disableNativeFetch && self.fetch) {
    return;
  }

  function normalizeName(name) {
    if (typeof name !== 'string') {
      name = String(name);
    }

    if (/[^a-z0-9\-#$%&'*+.\^_`|~]/i.test(name)) {
      throw new TypeError('Invalid character in header field name');
    }

    return name.toLowerCase();
  }

  function normalizeValue(value) {
    if (typeof value !== 'string') {
      value = String(value);
    }

    return value;
  }

  function Headers(headers) {
    this.map = {};

    if (headers instanceof Headers) {
      headers.forEach(function (value, name) {
        this.append(name, value);
      }, this);
    } else if (headers) {
      Object.getOwnPropertyNames(headers).forEach(function (name) {
        this.append(name, headers[name]);
      }, this);
    }
  }

  Headers.prototype.append = function (name, value) {
    name = normalizeName(name);
    value = normalizeValue(value);
    var list = this.map[name];

    if (!list) {
      list = [];
      this.map[name] = list;
    }

    list.push(value);
  };

  Headers.prototype['delete'] = function (name) {
    delete this.map[normalizeName(name)];
  };

  Headers.prototype.get = function (name) {
    var values = this.map[normalizeName(name)];
    return values ? values[0] : null;
  };

  Headers.prototype.getAll = function (name) {
    return this.map[normalizeName(name)] || [];
  };

  Headers.prototype.has = function (name) {
    return this.map.hasOwnProperty(normalizeName(name));
  };

  Headers.prototype.set = function (name, value) {
    this.map[normalizeName(name)] = [normalizeValue(value)];
  };

  Headers.prototype.forEach = function (callback, thisArg) {
    Object.getOwnPropertyNames(this.map).forEach(function (name) {
      this.map[name].forEach(function (value) {
        callback.call(thisArg, value, name, this);
      }, this);
    }, this);
  };

  function consumed(body) {
    if (body.bodyUsed) {
      return Promise.reject(new TypeError('Already read'));
    }

    body.bodyUsed = true;
  }

  function fileReaderReady(reader) {
    return new Promise(function (resolve, reject) {
      reader.onload = function () {
        resolve(reader.result);
      };

      reader.onerror = function () {
        reject(reader.error);
      };
    });
  }

  function readBlobAsArrayBuffer(blob) {
    var reader = new FileReader();
    reader.readAsArrayBuffer(blob);
    return fileReaderReady(reader);
  }

  function readBlobAsText(blob, options) {
    var reader = new FileReader();
    var contentType = options.headers.map['content-type'] ? options.headers.map['content-type'].toString() : '';
    var regex = /charset\=[0-9a-zA-Z\-\_]*;?/;

    var _charset = blob.type.match(regex) || contentType.match(regex);

    var args = [blob];

    if (_charset) {
      args.push(_charset[0].replace(/^charset\=/, '').replace(/;$/, ''));
    }

    reader.readAsText.apply(reader, args);
    return fileReaderReady(reader);
  }

  var support = {
    blob: 'FileReader' in self && 'Blob' in self && function () {
      try {
        new Blob();
        return true;
      } catch (e) {
        return false;
      }
    }(),
    formData: 'FormData' in self,
    arrayBuffer: 'ArrayBuffer' in self
  };

  function Body() {
    this.bodyUsed = false;

    this._initBody = function (body, options) {
      this._bodyInit = body;

      if (typeof body === 'string') {
        this._bodyText = body;
      } else if (support.blob && Blob.prototype.isPrototypeOf(body)) {
        this._bodyBlob = body;
        this._options = options;
      } else if (support.formData && FormData.prototype.isPrototypeOf(body)) {
        this._bodyFormData = body;
      } else if (!body) {
        this._bodyText = '';
      } else if (support.arrayBuffer && ArrayBuffer.prototype.isPrototypeOf(body)) {// Only support ArrayBuffers for POST method.
        // Receiving ArrayBuffers happens via Blobs, instead.
      } else {
        throw new Error('unsupported BodyInit type');
      }
    };

    if (support.blob) {
      this.blob = function () {
        var rejected = consumed(this);

        if (rejected) {
          return rejected;
        }

        if (this._bodyBlob) {
          return Promise.resolve(this._bodyBlob);
        } else if (this._bodyFormData) {
          throw new Error('could not read FormData body as blob');
        } else {
          return Promise.resolve(new Blob([this._bodyText]));
        }
      };

      this.arrayBuffer = function () {
        return this.blob().then(readBlobAsArrayBuffer);
      };

      this.text = function () {
        var rejected = consumed(this);

        if (rejected) {
          return rejected;
        }

        if (this._bodyBlob) {
          return readBlobAsText(this._bodyBlob, this._options);
        } else if (this._bodyFormData) {
          throw new Error('could not read FormData body as text');
        } else {
          return Promise.resolve(this._bodyText);
        }
      };
    } else {
      this.text = function () {
        var rejected = consumed(this);
        return rejected ? rejected : Promise.resolve(this._bodyText);
      };
    }

    if (support.formData) {
      this.formData = function () {
        return this.text().then(decode);
      };
    }

    this.json = function () {
      return this.text().then(JSON.parse);
    };

    return this;
  } // HTTP methods whose capitalization should be normalized


  var methods = ['DELETE', 'GET', 'HEAD', 'OPTIONS', 'POST', 'PUT'];

  function normalizeMethod(method) {
    var upcased = method.toUpperCase();
    return methods.indexOf(upcased) > -1 ? upcased : method;
  }

  function Request(input, options) {
    options = options || {};
    var body = options.body;

    if (Request.prototype.isPrototypeOf(input)) {
      if (input.bodyUsed) {
        throw new TypeError('Already read');
      }

      this.url = input.url;
      this.credentials = input.credentials;

      if (!options.headers) {
        this.headers = new Headers(input.headers);
      }

      this.method = input.method;
      this.mode = input.mode;

      if (!body) {
        body = input._bodyInit;
        input.bodyUsed = true;
      }
    } else {
      this.url = input;
    }

    this.credentials = options.credentials || this.credentials || 'omit';

    if (options.headers || !this.headers) {
      this.headers = new Headers(options.headers);
    }

    this.method = normalizeMethod(options.method || this.method || 'GET');
    this.mode = options.mode || this.mode || null;
    this.referrer = null;

    if ((this.method === 'GET' || this.method === 'HEAD') && body) {
      throw new TypeError('Body not allowed for GET or HEAD requests');
    }

    this._initBody(body, options);
  }

  Request.prototype.clone = function () {
    return new Request(this);
  };

  function decode(body) {
    var form = new FormData();
    body.trim().split('&').forEach(function (bytes) {
      if (bytes) {
        var split = bytes.split('=');
        var name = split.shift().replace(/\+/g, ' ');
        var value = split.join('=').replace(/\+/g, ' ');
        form.append(decodeURIComponent(name), decodeURIComponent(value));
      }
    });
    return form;
  }

  function headers(xhr) {
    var head = new Headers();
    var pairs = xhr.getAllResponseHeaders().trim().split('\n');
    pairs.forEach(function (header) {
      var split = header.trim().split(':');
      var key = split.shift().trim();
      var value = split.join(':').trim();
      head.append(key, value);
    });
    return head;
  }

  Body.call(Request.prototype);

  function Response(bodyInit, options) {
    if (!options) {
      options = {};
    }

    this._initBody(bodyInit, options);

    this.type = 'default';
    this.status = options.status;
    this.ok = this.status >= 200 && this.status < 300;
    this.statusText = options.statusText;
    this.headers = options.headers instanceof Headers ? options.headers : new Headers(options.headers);
    this.url = options.url || '';
  }

  Body.call(Response.prototype);

  Response.prototype.clone = function () {
    return new Response(this._bodyInit, {
      status: this.status,
      statusText: this.statusText,
      headers: new Headers(this.headers),
      url: this.url
    });
  };

  Response.error = function () {
    var response = new Response(null, {
      status: 0,
      statusText: ''
    });
    response.type = 'error';
    return response;
  };

  var redirectStatuses = [301, 302, 303, 307, 308];

  Response.redirect = function (url, status) {
    if (redirectStatuses.indexOf(status) === -1) {
      throw new RangeError('Invalid status code');
    }

    return new Response(null, {
      status: status,
      headers: {
        location: url
      }
    });
  };

  self.Headers = Headers;
  self.Request = Request;
  self.Response = Response;

  self.fetch = function (input, init) {
    return new Promise(function (resolve, reject) {
      var request;

      if (Request.prototype.isPrototypeOf(input) && !init) {
        request = input;
      } else {
        request = new Request(input, init);
      }

      var xhr = new XMLHttpRequest();

      function responseURL() {
        if ('responseURL' in xhr) {
          return xhr.responseURL;
        } // Avoid security warnings on getResponseHeader when not allowed by CORS


        if (/^X-Request-URL:/m.test(xhr.getAllResponseHeaders())) {
          return xhr.getResponseHeader('X-Request-URL');
        }

        return;
      }

      var __onLoadHandled = false;

      function onload() {
        if (xhr.readyState !== 4) {
          return;
        }

        var status = xhr.status === 1223 ? 204 : xhr.status;

        if (status < 100 || status > 599) {
          if (__onLoadHandled) {
            return;
          } else {
            __onLoadHandled = true;
          }

          reject(new TypeError('Network request failed'));
          return;
        }

        var options = {
          status: status,
          statusText: xhr.statusText,
          headers: headers(xhr),
          url: responseURL()
        };
        var body = 'response' in xhr ? xhr.response : xhr.responseText;

        if (__onLoadHandled) {
          return;
        } else {
          __onLoadHandled = true;
        }

        resolve(new Response(body, options));
      }

      xhr.onreadystatechange = onload;
      xhr.onload = onload;

      xhr.onerror = function () {
        if (__onLoadHandled) {
          return;
        } else {
          __onLoadHandled = true;
        }

        reject(new TypeError('Network request failed'));
      };

      xhr.open(request.method, request.url, true); // `withCredentials` should be setted after calling `.open` in IE10
      // http://stackoverflow.com/a/19667959/1219343

      try {
        if (request.credentials === 'include') {
          if ('withCredentials' in xhr) {
            xhr.withCredentials = true;
          } else {
            console && console.warn && console.warn('withCredentials is not supported, you can ignore this warning');
          }
        }
      } catch (e) {
        console && console.warn && console.warn('set withCredentials error:' + e);
      }

      if ('responseType' in xhr && support.blob) {
        xhr.responseType = 'blob';
      }

      request.headers.forEach(function (value, name) {
        xhr.setRequestHeader(name, value);
      });
      xhr.send(typeof request._bodyInit === 'undefined' ? null : request._bodyInit);
    });
  };

  self.fetch.polyfill = true; // Support CommonJS

  if ( true && module.exports) {
    module.exports = self.fetch;
  }
})(typeof self !== 'undefined' ? self : this);

/***/ }),
/* 20 */
/***/ (function(module, exports) {

function getObjectType(obj) {
  return Object.prototype.toString.call(obj);
}

function isDate(obj) {
  return getObjectType(obj) === '[object Date]';
}

function isString(obj) {
  return getObjectType(obj) === '[object String]';
}

function isDateString(obj) {
  return isString(obj) && !isNaN(Date.parse(obj));
}

function isNumber(obj) {
  return typeof obj === 'number';
}

function parseDateFromString(str) {
  return Date.parse(str);
}

module.exports = {
  getObjectType: getObjectType,
  isDate: isDate,
  isString: isString,
  isDateString: isDateString,
  parseDateFromString: parseDateFromString,
  isNumber: isNumber
};

/***/ }),
/* 21 */
/***/ (function(module, exports) {

exports.read = function (buffer, offset, isLE, mLen, nBytes) {
  var e, m;
  var eLen = nBytes * 8 - mLen - 1;
  var eMax = (1 << eLen) - 1;
  var eBias = eMax >> 1;
  var nBits = -7;
  var i = isLE ? nBytes - 1 : 0;
  var d = isLE ? -1 : 1;
  var s = buffer[offset + i];
  i += d;
  e = s & (1 << -nBits) - 1;
  s >>= -nBits;
  nBits += eLen;

  for (; nBits > 0; e = e * 256 + buffer[offset + i], i += d, nBits -= 8) {}

  m = e & (1 << -nBits) - 1;
  e >>= -nBits;
  nBits += mLen;

  for (; nBits > 0; m = m * 256 + buffer[offset + i], i += d, nBits -= 8) {}

  if (e === 0) {
    e = 1 - eBias;
  } else if (e === eMax) {
    return m ? NaN : (s ? -1 : 1) * Infinity;
  } else {
    m = m + Math.pow(2, mLen);
    e = e - eBias;
  }

  return (s ? -1 : 1) * m * Math.pow(2, e - mLen);
};

exports.write = function (buffer, value, offset, isLE, mLen, nBytes) {
  var e, m, c;
  var eLen = nBytes * 8 - mLen - 1;
  var eMax = (1 << eLen) - 1;
  var eBias = eMax >> 1;
  var rt = mLen === 23 ? Math.pow(2, -24) - Math.pow(2, -77) : 0;
  var i = isLE ? 0 : nBytes - 1;
  var d = isLE ? 1 : -1;
  var s = value < 0 || value === 0 && 1 / value < 0 ? 1 : 0;
  value = Math.abs(value);

  if (isNaN(value) || value === Infinity) {
    m = isNaN(value) ? 1 : 0;
    e = eMax;
  } else {
    e = Math.floor(Math.log(value) / Math.LN2);

    if (value * (c = Math.pow(2, -e)) < 1) {
      e--;
      c *= 2;
    }

    if (e + eBias >= 1) {
      value += rt / c;
    } else {
      value += rt * Math.pow(2, 1 - eBias);
    }

    if (value * c >= 2) {
      e++;
      c /= 2;
    }

    if (e + eBias >= eMax) {
      m = 0;
      e = eMax;
    } else if (e + eBias >= 1) {
      m = (value * c - 1) * Math.pow(2, mLen);
      e = e + eBias;
    } else {
      m = value * Math.pow(2, eBias - 1) * Math.pow(2, mLen);
      e = 0;
    }
  }

  for (; mLen >= 8; buffer[offset + i] = m & 0xff, i += d, m /= 256, mLen -= 8) {}

  e = e << mLen | m;
  eLen += mLen;

  for (; eLen > 0; buffer[offset + i] = e & 0xff, i += d, e /= 256, eLen -= 8) {}

  buffer[offset + i - d] |= s * 128;
};

/***/ }),
/* 22 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var VectorTileLayer = __webpack_require__(8);

module.exports = VectorTile;

function VectorTile(pbf, end) {
  this.layers = pbf.readFields(readTile, {}, end);
}

function readTile(tag, layers, pbf) {
  if (tag === 3) {
    var layer = new VectorTileLayer(pbf, pbf.readVarint() + pbf.pos);
    if (layer.length) layers[layer.name] = layer;
  }
}

/***/ }),
/* 23 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


module.exports = Point;
/**
 * A standalone point geometry with useful accessor, comparison, and
 * modification methods.
 *
 * @class Point
 * @param {Number} x the x-coordinate. this could be longitude or screen
 * pixels, or any other sort of unit.
 * @param {Number} y the y-coordinate. this could be latitude or screen
 * pixels, or any other sort of unit.
 * @example
 * var point = new Point(-77, 38);
 */

function Point(x, y) {
  this.x = x;
  this.y = y;
}

Point.prototype = {
  /**
   * Clone this point, returning a new point that can be modified
   * without affecting the old one.
   * @return {Point} the clone
   */
  clone: function clone() {
    return new Point(this.x, this.y);
  },

  /**
   * Add this point's x & y coordinates to another point,
   * yielding a new point.
   * @param {Point} p the other point
   * @return {Point} output point
   */
  add: function add(p) {
    return this.clone()._add(p);
  },

  /**
   * Subtract this point's x & y coordinates to from point,
   * yielding a new point.
   * @param {Point} p the other point
   * @return {Point} output point
   */
  sub: function sub(p) {
    return this.clone()._sub(p);
  },

  /**
   * Multiply this point's x & y coordinates by point,
   * yielding a new point.
   * @param {Point} p the other point
   * @return {Point} output point
   */
  multByPoint: function multByPoint(p) {
    return this.clone()._multByPoint(p);
  },

  /**
   * Divide this point's x & y coordinates by point,
   * yielding a new point.
   * @param {Point} p the other point
   * @return {Point} output point
   */
  divByPoint: function divByPoint(p) {
    return this.clone()._divByPoint(p);
  },

  /**
   * Multiply this point's x & y coordinates by a factor,
   * yielding a new point.
   * @param {Point} k factor
   * @return {Point} output point
   */
  mult: function mult(k) {
    return this.clone()._mult(k);
  },

  /**
   * Divide this point's x & y coordinates by a factor,
   * yielding a new point.
   * @param {Point} k factor
   * @return {Point} output point
   */
  div: function div(k) {
    return this.clone()._div(k);
  },

  /**
   * Rotate this point around the 0, 0 origin by an angle a,
   * given in radians
   * @param {Number} a angle to rotate around, in radians
   * @return {Point} output point
   */
  rotate: function rotate(a) {
    return this.clone()._rotate(a);
  },

  /**
   * Rotate this point around p point by an angle a,
   * given in radians
   * @param {Number} a angle to rotate around, in radians
   * @param {Point} p Point to rotate around
   * @return {Point} output point
   */
  rotateAround: function rotateAround(a, p) {
    return this.clone()._rotateAround(a, p);
  },

  /**
   * Multiply this point by a 4x1 transformation matrix
   * @param {Array<Number>} m transformation matrix
   * @return {Point} output point
   */
  matMult: function matMult(m) {
    return this.clone()._matMult(m);
  },

  /**
   * Calculate this point but as a unit vector from 0, 0, meaning
   * that the distance from the resulting point to the 0, 0
   * coordinate will be equal to 1 and the angle from the resulting
   * point to the 0, 0 coordinate will be the same as before.
   * @return {Point} unit vector point
   */
  unit: function unit() {
    return this.clone()._unit();
  },

  /**
   * Compute a perpendicular point, where the new y coordinate
   * is the old x coordinate and the new x coordinate is the old y
   * coordinate multiplied by -1
   * @return {Point} perpendicular point
   */
  perp: function perp() {
    return this.clone()._perp();
  },

  /**
   * Return a version of this point with the x & y coordinates
   * rounded to integers.
   * @return {Point} rounded point
   */
  round: function round() {
    return this.clone()._round();
  },

  /**
   * Return the magitude of this point: this is the Euclidean
   * distance from the 0, 0 coordinate to this point's x and y
   * coordinates.
   * @return {Number} magnitude
   */
  mag: function mag() {
    return Math.sqrt(this.x * this.x + this.y * this.y);
  },

  /**
   * Judge whether this point is equal to another point, returning
   * true or false.
   * @param {Point} other the other point
   * @return {boolean} whether the points are equal
   */
  equals: function equals(other) {
    return this.x === other.x && this.y === other.y;
  },

  /**
   * Calculate the distance from this point to another point
   * @param {Point} p the other point
   * @return {Number} distance
   */
  dist: function dist(p) {
    return Math.sqrt(this.distSqr(p));
  },

  /**
   * Calculate the distance from this point to another point,
   * without the square root step. Useful if you're comparing
   * relative distances.
   * @param {Point} p the other point
   * @return {Number} distance
   */
  distSqr: function distSqr(p) {
    var dx = p.x - this.x,
        dy = p.y - this.y;
    return dx * dx + dy * dy;
  },

  /**
   * Get the angle from the 0, 0 coordinate to this point, in radians
   * coordinates.
   * @return {Number} angle
   */
  angle: function angle() {
    return Math.atan2(this.y, this.x);
  },

  /**
   * Get the angle from this point to another point, in radians
   * @param {Point} b the other point
   * @return {Number} angle
   */
  angleTo: function angleTo(b) {
    return Math.atan2(this.y - b.y, this.x - b.x);
  },

  /**
   * Get the angle between this point and another point, in radians
   * @param {Point} b the other point
   * @return {Number} angle
   */
  angleWith: function angleWith(b) {
    return this.angleWithSep(b.x, b.y);
  },

  /*
   * Find the angle of the two vectors, solving the formula for
   * the cross product a x b = |a||b|sin(θ) for θ.
   * @param {Number} x the x-coordinate
   * @param {Number} y the y-coordinate
   * @return {Number} the angle in radians
   */
  angleWithSep: function angleWithSep(x, y) {
    return Math.atan2(this.x * y - this.y * x, this.x * x + this.y * y);
  },
  _matMult: function _matMult(m) {
    var x = m[0] * this.x + m[1] * this.y,
        y = m[2] * this.x + m[3] * this.y;
    this.x = x;
    this.y = y;
    return this;
  },
  _add: function _add(p) {
    this.x += p.x;
    this.y += p.y;
    return this;
  },
  _sub: function _sub(p) {
    this.x -= p.x;
    this.y -= p.y;
    return this;
  },
  _mult: function _mult(k) {
    this.x *= k;
    this.y *= k;
    return this;
  },
  _div: function _div(k) {
    this.x /= k;
    this.y /= k;
    return this;
  },
  _multByPoint: function _multByPoint(p) {
    this.x *= p.x;
    this.y *= p.y;
    return this;
  },
  _divByPoint: function _divByPoint(p) {
    this.x /= p.x;
    this.y /= p.y;
    return this;
  },
  _unit: function _unit() {
    this._div(this.mag());

    return this;
  },
  _perp: function _perp() {
    var y = this.y;
    this.y = this.x;
    this.x = -y;
    return this;
  },
  _rotate: function _rotate(angle) {
    var cos = Math.cos(angle),
        sin = Math.sin(angle),
        x = cos * this.x - sin * this.y,
        y = sin * this.x + cos * this.y;
    this.x = x;
    this.y = y;
    return this;
  },
  _rotateAround: function _rotateAround(angle, p) {
    var cos = Math.cos(angle),
        sin = Math.sin(angle),
        x = p.x + cos * (this.x - p.x) - sin * (this.y - p.y),
        y = p.y + sin * (this.x - p.x) + cos * (this.y - p.y);
    this.x = x;
    this.y = y;
    return this;
  },
  _round: function _round() {
    this.x = Math.round(this.x);
    this.y = Math.round(this.y);
    return this;
  }
};
/**
 * Construct a point from an array if necessary, otherwise if the input
 * is already a Point, or an unknown type, return it unchanged
 * @param {Array<Number>|Point|*} a any kind of input value
 * @return {Point} constructed point, or passed-through value.
 * @example
 * // this
 * var point = Point.convert([0, 1]);
 * // is equivalent to
 * var point = new Point(0, 1);
 */

Point.convert = function (a) {
  if (a instanceof Point) {
    return a;
  }

  if (Array.isArray(a)) {
    return new Point(a[0], a[1]);
  }

  return a;
};

/***/ }),
/* 24 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);

// CONCATENATED MODULE: ./src/common/SuperMap.js
/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/
var SuperMap = window.SuperMap = window.SuperMap || {};
SuperMap.Components = window.SuperMap.Components || {};
// CONCATENATED MODULE: ./src/common/REST.js
/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/

/**
 * @enum DataFormat
 * @memberOf SuperMap
 * @description 服务请求返回结果数据类型
 * @type {string}
 */

var DataFormat = SuperMap.DataFormat = {
  /** GEOJSON */
  GEOJSON: "GEOJSON",

  /** ISERVER */
  ISERVER: "ISERVER"
};

/**
 * @enum ServerType
 * @memberOf SuperMap
 * @description 服务器类型
 * @type {string}
 */

var ServerType = SuperMap.ServerType = {
  /** ISERVER */
  ISERVER: "ISERVER",

  /** IPORTAL */
  IPORTAL: "IPORTAL",

  /** ONLINE */
  ONLINE: "ONLINE"
};

/**
 * @enum GeometryType
 * @memberOf SuperMap
 * @description 几何对象枚举,定义了一系列几何对象类型。
 * @type {string}
 */

var GeometryType = SuperMap.GeometryType = {
  /** LINE */
  LINE: "LINE",

  /** LINEM */
  LINEM: "LINEM",

  /** POINT */
  POINT: "POINT",

  /** REGION */
  REGION: "REGION",

  /** POINTEPS */
  POINTEPS: "POINTEPS",

  /** LINEEPS */
  LINEEPS: "LINEEPS",

  /** REGIONEPS */
  REGIONEPS: "REGIONEPS",

  /** ELLIPSE */
  ELLIPSE: "ELLIPSE",

  /** CIRCLE */
  CIRCLE: "CIRCLE",

  /** TEXT */
  TEXT: "TEXT",

  /** RECTANGLE */
  RECTANGLE: "RECTANGLE",

  /** UNKNOWN */
  UNKNOWN: "UNKNOWN"
};

/**
 * @enum QueryOption
 * @memberOf SuperMap
 * @description 查询结果类型枚举,描述查询结果返回类型，包括只返回属性、只返回几何实体以及返回属性和几何实体。
 * @type {string}
 */

var QueryOption = SuperMap.QueryOption = {
  /** 属性 */
  ATTRIBUTE: "ATTRIBUTE",

  /** 属性和几何对象 */
  ATTRIBUTEANDGEOMETRY: "ATTRIBUTEANDGEOMETRY",

  /** 几何对象 */
  GEOMETRY: "GEOMETRY"
};

/**
 * @enum JoinType
 * @memberOf SuperMap
 * @description 关联查询时的关联类型常量。
 * 该类定义了两个表之间的连接类型常量，决定了对两个表之间进行连接查询时，查询结果中得到的记录的情况。
 * @type {string}
 */

var JoinType = SuperMap.JoinType = {
  /** INNERJOIN */
  INNERJOIN: "INNERJOIN",

  /** LEFTJOIN */
  LEFTJOIN: "LEFTJOIN"
};

/**
 * @enum SpatialQueryMode
 * @memberOf SuperMap
 * @description  空间查询模式枚举。该类定义了空间查询操作模式常量。
 * @type {string}
 */

var SpatialQueryMode = SuperMap.SpatialQueryMode = {
  /** 包含空间查询模式 */
  CONTAIN: "CONTAIN",

  /** 交叉空间查询模式 */
  CROSS: "CROSS",

  /** 分离空间查询模式 */
  DISJOINT: "DISJOINT",

  /** 重合空间查询模式 */
  IDENTITY: "IDENTITY",

  /** 相交空间查询模式 */
  INTERSECT: "INTERSECT",

  /** 无空间查询 */
  NONE: "NONE",

  /** 叠加空间查询模式 */
  OVERLAP: "OVERLAP",

  /** 邻接空间查询模式 */
  TOUCH: "TOUCH",

  /** 被包含空间查询模式 */
  WITHIN: "WITHIN"
};

/**
 * @enum SpatialRelationType
 * @memberOf SuperMap
 * @description  数据集对象间的空间关系枚举。
 * 该类定义了数据集对象间的空间关系类型常量。
 * @type {string}
 */

var SpatialRelationType = SuperMap.SpatialRelationType = {
  /** 包含关系 */
  CONTAIN: "CONTAIN",

  /** 相交关系 */
  INTERSECT: "INTERSECT",

  /** 被包含关系 */
  WITHIN: "WITHIN"
};

/**
 * @enum MeasureMode
 * @memberOf SuperMap
 * @type {string}
 * @description  量算模式枚举。
 * 该类定义了两种测量模式：距离测量和面积测量。
 */

var MeasureMode = SuperMap.MeasureMode = {
  /** 距离测量 */
  DISTANCE: "DISTANCE",

  /** 面积测量 */
  AREA: "AREA"
};

/**
 * @enum Unit
 * @memberOf SuperMap
 * @description  距离单位枚举。
 * 该类定义了一系列距离单位类型。
 * @type {string}
 */

var Unit = SuperMap.Unit = {
  /**  米 */
  METER: "METER",

  /**  千米 */
  KILOMETER: "KILOMETER",

  /**  英里 */
  MILE: "MILE",

  /**  码 */
  YARD: "YARD",

  /**  度 */
  DEGREE: "DEGREE",

  /**  毫米 */
  MILLIMETER: "MILLIMETER",

  /**  厘米 */
  CENTIMETER: "CENTIMETER",

  /**  英寸 */
  INCH: "INCH",

  /**  分米 */
  DECIMETER: "DECIMETER",

  /**  英尺 */
  FOOT: "FOOT",

  /**  秒 */
  SECOND: "SECOND",

  /**  分 */
  MINUTE: "MINUTE",

  /**  弧度 */
  RADIAN: "RADIAN"
};

/**
 * @enum BufferRadiusUnit
 * @memberOf SuperMap
 * @description  缓冲区距离单位枚举。
 * 该类定义了一系列缓冲距离单位类型。
 * @type {string}
 */

var BufferRadiusUnit = SuperMap.BufferRadiusUnit = {
  /**  厘米 */
  CENTIMETER: "CENTIMETER",

  /**  分米 */
  DECIMETER: "DECIMETER",

  /**  英尺 */
  FOOT: "FOOT",

  /**  英寸 */
  INCH: "INCH",

  /**  千米 */
  KILOMETER: "KILOMETER",

  /**  米 */
  METER: "METER",

  /**  英里 */
  MILE: "MILE",

  /**  毫米 */
  MILLIMETER: "MILLIMETER",

  /**  码 */
  YARD: "YARD"
};

/**
 * @enum EngineType
 * @memberOf SuperMap
 * @description  数据源引擎类型枚举。
 * @type {string}
 */

var EngineType = SuperMap.EngineType = {
  /** 影像只读引擎类型，文件引擎，针对通用影像格式如 BMP，JPG，TIFF 以及超图自定义影像格式 SIT 等。 */
  IMAGEPLUGINS: "IMAGEPLUGINS",

  /**  OGC 引擎类型，针对于 Web 数据源，Web 引擎，目前支持的类型有 WMS，WFS，WCS。 */
  OGC: "OGC",

  /**  Oracle 引擎类型，针对 Oracle 数据源，数据库引擎。 */
  ORACLEPLUS: "ORACLEPLUS",

  /**  SDB 引擎类型，文件引擎，即 SDB 数据源。 */
  SDBPLUS: "SDBPLUS",

  /**  SQL Server 引擎类型，针对 SQL Server 数据源，数据库引擎 */
  SQLPLUS: "SQLPLUS",

  /**  UDB 引擎类型，文件引擎。 */
  UDB: "UDB"
};

/**
 * @enum ThemeGraphTextFormat
 * @memberOf SuperMap
 * @description  统计专题图文本显示格式枚举。
 * @type {string}
 */

var ThemeGraphTextFormat = SuperMap.ThemeGraphTextFormat = {
  /**  标题。以各子项的标题来进行标注。 */
  CAPTION: "CAPTION",

  /**  标题 + 百分数。以各子项的标题和所占的百分比来进行标注。 */
  CAPTION_PERCENT: "CAPTION_PERCENT",

  /**  标题 + 实际数值。以各子项的标题和真实数值来进行标注。 */
  CAPTION_VALUE: "CAPTION_VALUE",

  /**  百分数。以各子项所占的百分比来进行标注。 */
  PERCENT: "PERCENT",

  /**  实际数值。以各子项的真实数值来进行标注。 */
  VALUE: "VALUE"
};

/**
 * @enum ThemeGraphType
 * @memberOf SuperMap
 * @description  统计专题图类型枚举。
 * @type {string}
 */

var ThemeGraphType = SuperMap.ThemeGraphType = {
  /**  面积图。 */
  AREA: "AREA",

  /**  柱状图。 */
  BAR: "BAR",

  /**  三维柱状图。 */
  BAR3D: "BAR3D",

  /**  折线图。 */
  LINE: "LINE",

  /**  饼图。 */
  PIE: "PIE",

  /**  三维饼图。 */
  PIE3D: "PIE3D",

  /**  点状图。 */
  POINT: "POINT",

  /**  环状图。 */
  RING: "RING",

  /**  玫瑰图。 */
  ROSE: "ROSE",

  /**  三维玫瑰图。 */
  ROSE3D: "ROSE3D",

  /**  堆叠柱状图。 */
  STACK_BAR: "STACK_BAR",

  /**  三维堆叠柱状图。 */
  STACK_BAR3D: "STACK_BAR3D",

  /**  阶梯图。 */
  STEP: "STEP"
};

/**
 * @enum GraphAxesTextDisplayMode
 * @memberOf SuperMap
 * @description  统计专题图坐标轴文本显示模式。
 * @type {string}
 */

var GraphAxesTextDisplayMode = SuperMap.GraphAxesTextDisplayMode = {
  /**  显示全部文本。 */
  ALL: "ALL",

  /**  不显示。 */
  NONE: "NONE",

  /**  显示Y轴的文本。 */
  YAXES: "YAXES"
};

/**
 * @enum GraduatedMode
 * @memberOf SuperMap
 * @description  专题图分级模式枚举。
 *
 * @type {string}
 */

var GraduatedMode = SuperMap.GraduatedMode = {
  /**  常量分级模式。 */
  CONSTANT: "CONSTANT",

  /** 对数分级模式。 */
  LOGARITHM: "LOGARITHM",

  /**  平方根分级模式。 */
  SQUAREROOT: "SQUAREROOT"
};

/**
 * @enum RangeMode
 * @memberOf SuperMap
 * @description  范围分段专题图分段方式枚举。
 * @type {string}
 */

var RangeMode = SuperMap.RangeMode = {
  /**  自定义分段法。 */
  CUSTOMINTERVAL: "CUSTOMINTERVAL",

  /**  等距离分段法。 */
  EQUALINTERVAL: "EQUALINTERVAL",

  /**  对数分段法。 */
  LOGARITHM: "LOGARITHM",

  /**  等计数分段法。 */
  QUANTILE: "QUANTILE",

  /**  平方根分段法。 */
  SQUAREROOT: "SQUAREROOT",

  /**  标准差分段法。 */
  STDDEVIATION: "STDDEVIATION"
};

/**
 * @enum ThemeType
 * @memberOf SuperMap
 * @description  专题图类型枚举。
 * @type {string}
 */

var ThemeType = SuperMap.ThemeType = {
  /** 点密度专题图。 */
  DOTDENSITY: "DOTDENSITY",

  /** 等级符号专题图。 */
  GRADUATEDSYMBOL: "GRADUATEDSYMBOL",

  /** 统计专题图。 */
  GRAPH: "GRAPH",

  /** 标签专题图。 */
  LABEL: "LABEL",

  /** 分段专题图。 */
  RANGE: "RANGE",

  /** 単值专题图。 */
  UNIQUE: "UNIQUE"
};

/**
 * @enum ColorGradientType
 * @memberOf SuperMap
 * @description  渐变颜色枚举。
 * @type {string}
 */

var ColorGradientType = SuperMap.ColorGradientType = {
  /** 黑白渐变色。 */
  BLACK_WHITE: "BLACKWHITE",

  /** 蓝黑渐变色。 */
  BLUE_BLACK: "BLUEBLACK",

  /** 蓝红渐变色。 */
  BLUE_RED: "BLUERED",

  /** 蓝白渐变色。 */
  BLUE_WHITE: "BLUEWHITE",

  /** 青黑渐变色。 */
  CYAN_BLACK: "CYANBLACK",

  /** 青蓝渐变色。 */
  CYAN_BLUE: "CYANBLUE",

  /** 青绿渐变色。 */
  CYAN_GREEN: "CYANGREEN",

  /** 青白渐变色。 */
  CYAN_WHITE: "CYANWHITE",

  /** 绿黑渐变色。 */
  GREEN_BLACK: "GREENBLACK",

  /** 绿蓝渐变色。 */
  GREEN_BLUE: "GREENBLUE",

  /** 绿橙紫渐变色。 */
  GREEN_ORANGE_VIOLET: "GREENORANGEVIOLET",

  /** 绿红渐变色。 */
  GREEN_RED: "GREENRED",

  /** 蓝红渐变色。 */
  GREEN_WHITE: "GREENWHITE",

  /** 粉黑渐变色。 */
  PINK_BLACK: "PINKBLACK",

  /** 粉蓝渐变色。 */
  PINK_BLUE: "PINKBLUE",

  /** 粉红渐变色。 */
  PINK_RED: "PINKRED",

  /** 粉白渐变色。 */
  PINK_WHITE: "PINKWHITE",

  /** 彩虹色。 */
  RAIN_BOW: "RAINBOW",

  /** 红黑渐变色。 */
  RED_BLACK: "REDBLACK",

  /** 红白渐变色。 */
  RED_WHITE: "REDWHITE",

  /** 光谱渐变。 */
  SPECTRUM: "SPECTRUM",

  /** 地形渐变,用于三维显示效果较好。 */
  TERRAIN: "TERRAIN",

  /** 黄黑渐变色。 */
  YELLOW_BLACK: "YELLOWBLACK",

  /** 黄蓝渐变色。 */
  YELLOW_BLUE: "YELLOWBLUE",

  /** 黄绿渐变色。 */
  YELLOW_GREEN: "YELLOWGREEN",

  /** 黄红渐变色。 */
  YELLOW_RED: "YELLOWRED",

  /** 黄白渐变色。 */
  YELLOW_WHITE: "YELLOWWHITE"
};

/**
 * @enum TextAlignment
 * @memberOf SuperMap
 * @description  文本对齐枚举。
 * @type {string}
 */

var TextAlignment = SuperMap.TextAlignment = {
  /** 左上角对齐。 */
  TOPLEFT: "TOPLEFT",

  /** 顶部居中对齐。 */
  TOPCENTER: "TOPCENTER",

  /** 右上角对齐。 */
  TOPRIGHT: "TOPRIGHT",

  /** 基准线左对齐。 */
  BASELINELEFT: "BASELINELEFT",

  /** 基准线居中对齐。 */
  BASELINECENTER: "BASELINECENTER",

  /** 基准线右对齐。 */
  BASELINERIGHT: "BASELINERIGHT",

  /** 左下角对齐。 */
  BOTTOMLEFT: "BOTTOMLEFT",

  /** 底部居中对齐。 */
  BOTTOMCENTER: "BOTTOMCENTER",

  /** 右下角对齐。 */
  BOTTOMRIGHT: "BOTTOMRIGHT",

  /** 左中对齐。 */
  MIDDLELEFT: "MIDDLELEFT",

  /** 中心对齐。 */
  MIDDLECENTER: "MIDDLECENTER",

  /** 右中对齐。 */
  MIDDLERIGHT: "MIDDLERIGHT"
};

/**
 * @enum FillGradientMode
 * @memberOf SuperMap
 * @description  渐变填充风格的渐变类型枚举。
 * @type {string}
 */

var FillGradientMode = SuperMap.FillGradientMode = {
  /** 无渐变。 */
  NONE: "NONE",

  /** 线性渐变填充。 */
  LINEAR: "LINEAR",

  /** 辐射渐变填充。 */
  RADIAL: "RADIAL",

  /** 圆锥渐变填充。 */
  CONICAL: "CONICAL",

  /** 四角渐变填充。 */
  SQUARE: "SQUARE"
};

/**
 * @enum AlongLineDirection
 * @memberOf SuperMap
 * @description  标签沿线标注方向枚举。
 * @type {string}
 */

var AlongLineDirection = SuperMap.AlongLineDirection = {
  /** 沿线的法线方向放置标签。 */
  NORMAL: "ALONG_LINE_NORMAL",

  /** 从下到上，从左到右放置。 */
  LB_TO_RT: "LEFT_BOTTOM_TO_RIGHT_TOP",

  /** 从上到下，从左到右放置。 */
  LT_TO_RB: "LEFT_TOP_TO_RIGHT_BOTTOM",

  /** 从下到上，从右到左放置。 */
  RB_TO_LT: "RIGHT_BOTTOM_TO_LEFT_TOP",

  /** 从上到下，从右到左放置。 */
  RT_TO_LB: "RIGHT_TOP_TO_LEFT_BOTTOM"
};

/**
 * @enum LabelBackShape
 * @memberOf SuperMap
 * @description  标签专题图中标签背景的形状枚举。
 * @type {string}
 */

var LabelBackShape = SuperMap.LabelBackShape = {
  /** 菱形背景，即标签背景的形状为菱形。 */
  DIAMOND: "DIAMOND",

  /** 椭圆形背景，即标签背景的行状为椭圆形。 */
  ELLIPSE: "ELLIPSE",

  /** 符号背景，即标签背景的形状为设定的符号。 */
  MARKER: "MARKER",

  /** 空背景，即不使用任何形状作为标签的背景。 */
  NONE: "NONE",

  /** 矩形背景，即标签背景的形状为矩形。 */
  RECT: "RECT",

  /** 圆角矩形背景，即标签背景的形状为圆角矩形。 */
  ROUNDRECT: "ROUNDRECT",

  /** 三角形背景，即标签背景的形状为三角形。 */
  TRIANGLE: "TRIANGLE"
};

/**
 * @enum LabelOverLengthMode
 * @memberOf SuperMap
 * @description  标签专题图中超长标签的处理模式枚举。
 * @type {string}
 */

var LabelOverLengthMode = SuperMap.LabelOverLengthMode = {
  /** 换行显示。 */
  NEWLINE: "NEWLINE",

  /** 对超长标签不进行处理。 */
  NONE: "NONE",

  /** 省略超出部分。 */
  OMIT: "OMIT"
};

/**
 * @enum DirectionType
 * @memberOf SuperMap
 * @description  网络分析中方向枚举。
 * 在行驶引导子项中使用。
 * @type {string}
 */

var DirectionType = SuperMap.DirectionType = {
  /** 东。 */
  EAST: "EAST",

  /** 无方向。 */
  NONE: "NONE",

  /** 北。 */
  NORTH: "NORTH",

  /** 南。 */
  SOURTH: "SOURTH",

  /** 西。 */
  WEST: "WEST"
};

/**
 * @enum SideType
 * @memberOf SuperMap
 * @description  行驶位置枚举。
 * 表示在行驶在路的左边、右边或者路上的枚举,该类用在行驶导引子项类中。
 * @type {string}
 */

var SideType = SuperMap.SideType = {
  /** 路的左侧。 */
  LEFT: "LEFT",

  /** 在路上（即路的中间）。 */
  MIDDLE: "MIDDLE",

  /** 无效值。 */
  NONE: "NONE",

  /** 路的右侧。 */
  RIGHT: "RIGHT"
};

/**
 * @enum SupplyCenterType
 * @memberOf SuperMap
 * @description  资源供给中心类型枚举。
 * 该枚举定义了网络分析中资源中心点的类型，主要用于资源分配和选址分区。
 * 资源供给中心点的类型包括非中心，固定中心和可选中心。固定中心用于资源分配分析； 固定中心和可选中心用于选址分析；非中心在两种网络分析时都不予考虑。
 * @type {string}
 */

var SupplyCenterType = SuperMap.SupplyCenterType = {
  /** 固定中心点。 */
  FIXEDCENTER: "FIXEDCENTER",

  /** 非中心点。 */
  NULL: "NULL",

  /** 可选中心点。 */
  OPTIONALCENTER: "OPTIONALCENTER"
};

/**
 * @enum TurnType
 * @memberOf SuperMap
 * @description  转弯方向枚举。
 * 用在行驶引导子项类中，表示转弯的方向。
 * @type {string}
 */

var TurnType = SuperMap.TurnType = {
  /** 向前直行。 */
  AHEAD: "AHEAD",

  /** 掉头。 */
  BACK: "BACK",

  /** 终点，不拐弯。 */
  END: "END",

  /** 左转弯。 */
  LEFT: "LEFT",

  /** 无效值。 */
  NONE: "NONE",

  /** 右转弯。 */
  RIGHT: "RIGHT"
};

/**
 * @enum BufferEndType
 * @memberOf SuperMap
 * @description  缓冲区分析BufferEnd类型。
 * @type {string}
 */

var BufferEndType = SuperMap.BufferEndType = {
  /** FLAT */
  FLAT: "FLAT",

  /** ROUND */
  ROUND: "ROUND"
};

/**
 * @enum OverlayOperationType
 * @memberOf SuperMap
 * @description  叠加分析类型枚举。
 * @type {string}
 */

var OverlayOperationType = SuperMap.OverlayOperationType = {
  /** 操作数据集（几何对象）裁剪被操作数据集（几何对象）。 */
  CLIP: "CLIP",

  /** 在被操作数据集（几何对象）上擦除掉与操作数据集（几何对象）相重合的部分。 */
  ERASE: "ERASE",

  /**对被操作数据集（几何对象）进行同一操作，即操作执行后，被操作数据集（几何对象）包含来自操作数据集（几何对象）的几何形状。 */
  IDENTITY: "IDENTITY",

  /** 对两个数据集（几何对象）求交，返回两个数据集（几何对象）的交集。 */
  INTERSECT: "INTERSECT",

  /** 对两个面数据集（几何对象）进行合并操作。 */
  UNION: "UNION",

  /** 对两个面数据集（几何对象）进行更新操作。 */
  UPDATE: "UPDATE",

  /** 对两个面数据集（几何对象）进行对称差操作。 */
  XOR: "XOR"
};

/**
 * @enum OutputType
 * @memberOf SuperMap
 * @description  分布式分析输出类型枚举。
 * @type {string}
 */

var OutputType = SuperMap.OutputType = {
  /** INDEXEDHDFS */
  INDEXEDHDFS: "INDEXEDHDFS",

  /** UDB */
  UDB: "UDB",

  /** MONGODB */
  MONGODB: "MONGODB",

  /** PG */
  PG: "PG"
};

/**
 * @enum SmoothMethod
 * @memberOf SuperMap
 * @description  光滑方法枚举。
 * 用于从Grid 或DEM数据生成等值线或等值面时对等值线或者等值面的边界线进行平滑处理的方法。
 * @type {string}
 */

var SmoothMethod = SuperMap.SmoothMethod = {
  /** B 样条法。 */
  BSPLINE: "BSPLINE",

  /** 磨角法。 */
  POLISH: "POLISH"
};

/**
 * @enum SurfaceAnalystMethod
 * @memberOf SuperMap
 * @description  表面分析方法枚举。
 * 通过对数据进行表面分析，能够挖掘原始数据所包含的信息，使某些细节明显化，易于分析。
 * @type {string}
 */

var SurfaceAnalystMethod = SuperMap.SurfaceAnalystMethod = {
  /** 等值线提取。 */
  ISOLINE: "ISOLINE",

  /** 等值面提取。 */
  ISOREGION: "ISOREGION"
};

/**
 * @enum DataReturnMode
 * @memberOf SuperMap
 * @description  数据返回模式枚举。
 * 该枚举用于指定空间分析返回结果模式,包含返回数据集标识和记录集、只返回数据集标识(数据集名称@数据源名称)及只返回记录集三种模式。
 * @type {string}
 */

var DataReturnMode = SuperMap.DataReturnMode = {
  /** 返回结果数据集标识(数据集名称@数据源名称)和记录集（RecordSet）。 */
  DATASET_AND_RECORDSET: "DATASET_AND_RECORDSET",

  /** 只返回数据集标识（数据集名称@数据源名称）。 */
  DATASET_ONLY: "DATASET_ONLY",

  /** 只返回记录集（RecordSet）。 */
  RECORDSET_ONLY: "RECORDSET_ONLY"
};

/**
 * @enum EditType
 * @memberOf SuperMap
 * @description  要素集更新模式枚举。
 * 该枚举用于指定数据服务中要素集更新模式,包含添加要素集、更新要素集和删除要素集。
 * @type {string}
 */

var EditType = SuperMap.EditType = {
  /** 增加操作。 */
  ADD: "add",

  /** 修改操作。 */
  UPDATE: "update",

  /** 删除操作。 */
  DELETE: "delete"
};

/**
 * @enum TransferTactic
 * @memberOf SuperMap
 * @description  公交换乘策略枚举。
 * 该枚举用于指定公交服务中要素集更新模式,包含添加要素集、更新要素集和删除要素集。
 * @type {string}
 */

var TransferTactic = SuperMap.TransferTactic = {
  /** 时间短。 */
  LESS_TIME: "LESS_TIME",

  /** 少换乘。 */
  LESS_TRANSFER: "LESS_TRANSFER",

  /** 少步行。 */
  LESS_WALK: "LESS_WALK",

  /** 距离最短。 */
  MIN_DISTANCE: "MIN_DISTANCE"
};

/**
 * @enum TransferPreference
 * @memberOf SuperMap
 * @description  公交换乘策略枚举。
 * 该枚举用于指定交通换乘服务中设置地铁优先、公交优先、不乘地铁、无偏好等偏好设置。
 * @type {string}
 */

var TransferPreference = SuperMap.TransferPreference = {
  /** 公交汽车优先。 */
  BUS: "BUS",

  /** 地铁优先。 */
  SUBWAY: "SUBWAY",

  /** 不乘坐地铁。 */
  NO_SUBWAY: "NO_SUBWAY",

  /** 无乘车偏好。 */
  NONE: "NONE"
};

/**
 * @enum GridType
 * @memberOf SuperMap
 * @description  地图背景格网类型枚举。
 * @type {string}
 */

var GridType = SuperMap.GridType = {
  /** 十字叉丝。 */
  CROSS: "CROSS",

  /** 网格线。 */
  GRID: "GRID",

  /** 点。 */
  POINT: "POINT"
};

/**
 * @enum ColorSpaceType
 * @memberOf SuperMap
 * @description  色彩空间枚举。
 * 由于成色原理的不同，决定了显示器、投影仪这类靠色光直接合成颜色的颜色设备和打印机、
 * 印刷机这类靠使用颜料的印刷设备在生成颜色方式上的区别。
 * 针对上述不同成色方式，SuperMap 提供两种色彩空间，
 * 分别为 RGB 和 CMYK。RGB 主要用于显示系统中，CMYK 主要用于印刷系统中。
 * @type {string}
 */

var ColorSpaceType = SuperMap.ColorSpaceType = {
  /** 该类型主要在印刷系统使用。 */
  CMYK: "CMYK",

  /** 该类型主要在显示系统中使用。 */
  RGB: "RGB"
};

/**
 * @enum LayerType
 * @memberOf SuperMap
 * @description  图层类型。
 * @type {string}
 */

var LayerType = SuperMap.LayerType = {
  /** SuperMap UGC 类型图层。如矢量图层、栅格(Grid)图层、影像图层。 */
  UGC: "UGC",

  /** WMS 图层。 */
  WMS: "WMS",

  /** WFS 图层。 */
  WFS: "WFS",

  /** 自定义图层。 */
  CUSTOM: "CUSTOM"
};

/**
 * @enum UGCLayerType
 * @memberOf SuperMap
 * @description  UGC图层类型。
 * @type {string}
 */

var UGCLayerType = SuperMap.UGCLayerType = {
  /** 专题图层。 */
  THEME: "THEME",

  /** 矢量图层。 */
  VECTOR: "VECTOR",

  /** 栅格图层。。 */
  GRID: "GRID",

  /** 影像图层。 */
  IMAGE: "IMAGE"
};

/**
 * @enum StatisticMode
 * @memberOf SuperMap
 * @description  字段统计方法类型。
 * @type {string}
 */

var StatisticMode = SuperMap.StatisticMode = {
  /** 统计所选字段的平均值。 */
  AVERAGE: "AVERAGE",

  /** 统计所选字段的最大值。 */
  MAX: "MAX",

  /** 统计所选字段的最小值。 */
  MIN: "MIN",

  /** 统计所选字段的标准差 */
  STDDEVIATION: "STDDEVIATION",

  /** 统计所选字段的总和。 */
  SUM: "SUM",

  /** 统计所选字段的方差。 */
  VARIANCE: "VARIANCE"
};

/**
 * @enum PixelFormat
 * @memberOf SuperMap
 * @description  栅格与影像数据存储的像素格式枚举。
 * @type {string}
 */

var PixelFormat = SuperMap.PixelFormat = {
  /** 每个像元用16个比特(即2个字节)表示。 */
  BIT16: "BIT16",

  /** 每个像元用32个比特(即4个字节)表示。 */
  BIT32: "BIT32",

  /** 每个像元用64个比特(即8个字节)表示，只提供给栅格数据集使用。 */
  BIT64: "BIT64",

  /** 每个像元用4个字节来表示，只提供给栅格数据集使用。 */
  SINGLE: "SINGLE",

  /** 每个像元用8个字节来表示，只提供给栅格数据集使用。 */
  DOUBLE: "DOUBLE",

  /** 每个像元用1个比特表示。 */
  UBIT1: "UBIT1",

  /** 每个像元用4个比特来表示。 */
  UBIT4: "UBIT4",

  /** 每个像元用8个比特(即1个字节)来表示。 */
  UBIT8: "UBIT8",

  /** 每个像元用24个比特(即3个字节)来表示。 */
  UBIT24: "UBIT24",

  /** 每个像元用32个比特(即4个字节)来表示。 */
  UBIT32: "UBIT32"
};

/**
 * @enum SearchMode
 * @memberOf SuperMap
 * @description  内插时使用的样本点的查找方式枚举
 * @type {string}
 */

var SearchMode = SuperMap.SearchMode = {
  /** 使用 KDTREE 的固定点数方式查找参与内插分析的点。 */
  KDTREE_FIXED_COUNT: "KDTREE_FIXED_COUNT",

  /** 使用 KDTREE 的定长方式查找参与内插分析的点。 */
  KDTREE_FIXED_RADIUS: "KDTREE_FIXED_RADIUS",

  /** 不进行查找，使用所有的输入点进行内插分析。 */
  NONE: "NONE",

  /** 使用 QUADTREE 方式查找参与内插分析的点，仅对样条（RBF）插值和普通克吕金（Kriging）有用。 */
  QUADTREE: "QUADTREE"
};

/**
 * @enum InterpolationAlgorithmType
 * @memberOf SuperMap
 * @description  插值分析的算法的类型
 * @type {string}
 */

var InterpolationAlgorithmType = SuperMap.InterpolationAlgorithmType = {
  /** 普通克吕金插值法。 */
  KRIGING: "KRIGING",

  /** 简单克吕金插值法。 */
  SimpleKriging: "SimpleKriging",

  /** 泛克吕金插值法。 */
  UniversalKriging: "UniversalKriging"
};

/**
 * @enum VariogramMode
 * @memberOf SuperMap
 * @description  克吕金（Kriging）插值时的半变函数类型枚举
 * @type {string}
 */

var VariogramMode = SuperMap.VariogramMode = {
  /** 指数函数。 */
  EXPONENTIAL: "EXPONENTIAL",

  /** 高斯函数。 */
  GAUSSIAN: "GAUSSIAN",

  /** 球型函数。 */
  SPHERICAL: "SPHERICAL"
};

/**
 * @enum Exponent
 * @memberOf SuperMap
 * @description  定义了泛克吕金（UniversalKriging）插值时样点数据中趋势面方程的阶数
 * @type {string}
 */

var Exponent = SuperMap.Exponent = {
  /** 阶数为1。 */
  EXP1: "EXP1",

  /** 阶数为2。 */
  EXP2: "EXP2"
};

/**
 * @enum ClientType
 * @memberOf SuperMap
 * @description token申请的客户端标识类型
 * @type {string}
 */

var ClientType = SuperMap.ClientType = {
  /** 指定的 IP 地址。 */
  IP: "IP",

  /** 指定的 URL。 */
  REFERER: "Referer",

  /** 发送申请令牌请求的客户端 IP。 */
  REQUESTIP: "RequestIP",

  /** 不做任何验证。 */
  NONE: "NONE",

  /** SERVER。 */
  SERVER: "SERVER",

  /** WEB。 */
  WEB: "WEB"
};

/**
 * @enum ChartType
 * @memberOf SuperMap
 * @description 客户端专题图图表类型
 * @type {string}
 */

var ChartType = SuperMap.ChartType = {
  /** 柱状图。 */
  BAR: "Bar",

  /** 三维柱状图。 */
  BAR3D: "Bar3D",

  /** 圆形图。 */
  CIRCLE: "Circle",

  /** 饼图。 */
  PIE: "Pie",

  /** 散点图。 */
  POINT: "Point",

  /** 折线图。 */
  LINE: "Line",

  /** 环状图。 */
  RING: "Ring"
};

/**
 * @enum ClipAnalystMode
 * @memberOf SuperMap
 * @description  裁剪分析模式
 * @type {string}
 */

var ClipAnalystMode = SuperMap.ClipAnalystMode = {
  /** CLIP。 */
  CLIP: "clip",

  /** INTERSECT。 */
  INTERSECT: "intersect"
};

/**
 * @enum AnalystAreaUnit
 * @memberOf SuperMap
 * @description 分布式分析面积单位
 * @type {string}
 */

var AnalystAreaUnit = SuperMap.AnalystAreaUnit = {
  /** 平方米。 */
  "SQUAREMETER": "SquareMeter",

  /** 平方千米。 */
  "SQUAREKILOMETER": "SquareKiloMeter",

  /** 公顷。 */
  "HECTARE": "Hectare",

  /** 公亩。 */
  "ARE": "Are",

  /** 英亩。 */
  "ACRE": "Acre",

  /** 平方英尺。 */
  "SQUAREFOOT": "SquareFoot",

  /** 平方码。 */
  "SQUAREYARD": "SquareYard",

  /** 平方英里。 */
  "SQUAREMILE": "SquareMile"
};

/**
 * @enum AnalystSizeUnit
 * @memberOf SuperMap
 * @description 分布式分析单位
 * @type {string}
 */

var AnalystSizeUnit = SuperMap.AnalystSizeUnit = {
  /** 米。 */
  "METER": "Meter",

  /** 千米。 */
  "KILOMETER": "Kilometer",

  /** 码。 */
  "YARD": "Yard",

  /** 英尺。 */
  "FOOT": "Foot",

  /** 英里。 */
  "MILE": "Mile"
};

/**
 * @enum StatisticAnalystMode
 * @memberOf SuperMap
 * @description 分布式分析统计模式
 * @type {string}
 */

var StatisticAnalystMode = SuperMap.StatisticAnalystMode = {
  /** 统计所选字段的最大值。 */
  "MAX": "max",

  /** 统计所选字段的最小值。 */
  "MIN": "min",

  /** 统计所选字段的平均值。 */
  "AVERAGE": "average",

  /** 统计所选字段的总和。 */
  "SUM": "sum",

  /** 统计所选字段的方差。 */
  "VARIANCE": "variance",

  /** 统计所选字段的标准差 */
  "STDDEVIATION": "stdDeviation"
};

/**
 * @enum SummaryType
 * @memberOf SuperMap
 * @description 分布式分析聚合类型
 * @type {string}
 */

var SummaryType = SuperMap.SummaryType = {
  /** 格网聚合。 */
  "SUMMARYMESH": "SUMMARYMESH",

  /** 多边形聚合。 */
  "SUMMARYREGION": "SUMMARYREGION"
};

/**
 * @enum TopologyValidatorRule
 * @memberOf SuperMap
 * @description  拓扑检查模式枚举。该类定义了拓扑检查操作模式常量。
 * @type {string}
 */

var TopologyValidatorRule = SuperMap.TopologyValidatorRule = {
  /** 面内无重叠，用于对面数据进行拓扑检查。 */
  REGIONNOOVERLAP: "REGIONNOOVERLAP",

  /** 面与面无重叠，用于对面数据进行拓扑检查。 */
  REGIONNOOVERLAPWITH: "REGIONNOOVERLAPWITH",

  /** 面被面包含，用于对面数据进行拓扑检查。 */
  REGIONCONTAINEDBYREGION: "REGIONCONTAINEDBYREGION",

  /** 面被面覆盖，用于对面数据进行拓扑检查。 */
  REGIONCOVEREDBYREGION: "REGIONCOVEREDBYREGION",

  /** 线与线无重叠，用于对线数据进行拓扑检查。 */
  LINENOOVERLAP: "LINENOOVERLAP",

  /** 线内无重叠，用于对线数据进行拓扑检查。 */
  LINENOOVERLAPWITH: "LINENOOVERLAPWITH",

  /** 点不相同，用于对点数据进行拓扑检查。 */
  POINTNOIDENTICAL: "POINTNOIDENTICAL"
};

/**
 * @enum AggregationType
 * @memberOf SuperMap
 * @description  聚合查询枚举类，该类定义了Es数据服务中聚合查询模式常量
 * @type {string}
 */

var AggregationType = SuperMap.AggregationType = {
  /** 格网聚合类型。 */
  GEOHASH_GRID: "geohash_grid",

  /** 过滤聚合类型。 */
  FILTER: "filter"
};

/**
 * @enum AggregationType
 * @memberOf SuperMap
 * @description  聚合查询中filter查询枚举类
 * @type {string}
 */

var AggregationQueryBuilderType = SuperMap.AggregationQueryBuilderType = {
  /** 范围查询。 */
  GEO_BOUNDING_BOX: "geo_bounding_box"
};

/**
 * @enum GetFeatureMode
 * @memberOf SuperMap
 * @description feature 查询方式。
 * @type {string}
 */

var GetFeatureMode = SuperMap.GetFeatureMode = {
  /** 通过范围查询来获取要素。 */
  BOUNDS: "BOUNDS",

  /** 通过几何对象的缓冲区来获取要素。 */
  BUFFER: "BUFFER",

  /** 通过 ID 来获取要素。 */
  ID: "ID",

  /** 通过空间查询模式来获取要素。 */
  SPATIAL: "SPATIAL",

  /** 通过 SQL 查询来获取要素。 */
  SQL: 'SQL'
};

/**
 * @enum RasterFunctionType
 * @memberOf SuperMap
 * @description 栅格分析方法。
 * @type {string}
 */

var RasterFunctionType = SuperMap.RasterFunctionType = {
  /** 归一化植被指数。 */
  NDVI: "NDVI",

  /** 阴影面分析。 */
  HILLSHADE: "HILLSHADE"
};

/**
 * @enum ResourceType
 * @memberOf SuperMap
 * @description iportal资源类型。
 * @version 10.0.1
 * @type {string}
 */

var ResourceType = SuperMap.ResourceType = {
  /** 地图。 */
  MAP: "MAP",

  /** 服务。 */
  SERVICE: "SERVICE",

  /** 场景。 */
  SCENE: "SCENE",

  /** 数据。 */
  DATA: "DATA",

  /** 洞察。 */
  INSIGHTS_WORKSPACE: "INSIGHTS_WORKSPACE",

  /** 大屏。 */
  MAP_DASHBOARD: "MAP_DASHBOARD"
};

/**
 * @enum OrderBy
 * @memberOf SuperMap
 * @description iportal资源排序字段。
 * @version 10.0.1
 * @type {string}
 */

var OrderBy = SuperMap.OrderBy = {
  /** 按更新时间排序 */
  UPDATETIME: "UPDATETIME",

  /** 按热度(可能是访问量、下载量)排序 */
  HEATLEVEL: "HEATLEVEL",

  /** 按相关性排序 */
  RELEVANCE: "RELEVANCE"
};

/**
 * @enum OrderType
 * @memberOf SuperMap
 * @description iportal资源升序还是降序过滤
 * @version 10.0.1
 * @type {string}
 */

var OrderType = SuperMap.OrderType = {
  /** 升序 */
  ASC: "ASC",

  /** 降序 */
  DESC: "DESC"
};

/**
 * @enum SearchType
 * @memberOf SuperMap
 * @description iportal资源查询的范围进行过滤
 * @version 10.0.1
 * @type {string}
 */

var SearchType = SuperMap.SearchType = {
  /** 公开资源。 */
  PUBLIC: "PUBLIC",

  /** 我的资源。 */
  MY_RES: "MY_RES",

  /** 我的群组资源。 */
  MYGROUP_RES: "MYGROUP_RES",

  /** 我的部门资源。 */
  MYDEPARTMENT_RES: "MYDEPARTMENT_RES",

  /** 分享给我的资源。 */
  SHARETOME_RES: "SHARETOME_RES"
};

/**
 * @enum AggregationTypes
 * @memberOf SuperMap
 * @description iportal资源聚合查询的类型
 * @version 10.0.1
 * @type {string}
 */

var AggregationTypes = SuperMap.AggregationTypes = {
  /** 标签 */
  TAG: "TAG",

  /** 资源类型 */
  TYPE: "TYPE"
};

/**
 * @enum PermissionType
 * @memberOf SuperMap
 * @description iportal资源权限类型。
 * @version 10.0.1
 * @type {string}
 */

var PermissionType = SuperMap.PermissionType = {
  /** 可检索 */
  SEARCH: "SEARCH",

  /** 可查看 */
  READ: "READ",

  /** 可编辑 */
  READWRITE: "READWRITE",

  /** 可删除 */
  DELETE: "DELETE",

  /** 可下载，包括可读、可检索 */
  DOWNLOAD: "DOWNLOAD"
};

/**
 * @enum EntityType
 * @memberOf SuperMap
 * @description iportal资源实体类型。
 * @version 10.0.1
 * @type {string}
 */

var EntityType = SuperMap.EntityType = {
  /** 部门 */
  DEPARTMENT: "DEPARTMENT",

  /** 用户组 */
  GROUP: "GROUP",

  /** 群组 */
  IPORTALGROUP: "IPORTALGROUP",

  /** 角色 */
  ROLE: "ROLE",

  /** 用户 */
  USER: "USER"
};

// CONCATENATED MODULE: ./src/common/commontypes/Size.js
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/

/**
 * @class  SuperMap.Size
 * @category BaseTypes Style
 * @classdesc 此类描绘一对高宽值的实例。
 * @param {number} [w=0.0] - 宽度。
 * @param {number} [h=0.0] - 高度。
 *
 * @example
 * var size = new SuperMap.Size(31,46);
 */

var Size =
/*#__PURE__*/
function () {
  function Size(w, h) {
    _classCallCheck(this, Size);

    /**
     * @member {number} [SuperMap.Size.prototype.w=0.0]
     * @description 宽度。
     */
    this.w = w ? parseFloat(w) : 0.0;
    /**
     * @member {number} [SuperMap.Size.prototype.h=0.0]
     * @description 高度。
     */

    this.h = w ? parseFloat(h) : 0.0;
    this.CLASS_NAME = "SuperMap.Size";
  }
  /**
   * @function SuperMap.Size.prototype.toString
   * @description 返回此对象的字符串形式。
   * @example
   * var size = new SuperMap.Size(10,5);
   * var str = size.toString();
   * @returns {string} 例如："w=10,h=5"。
   */


  _createClass(Size, [{
    key: "toString",
    value: function toString() {
      return "w=" + this.w + ",h=" + this.h;
    }
    /**
     * @function SuperMap.Size.prototype.clone
     * @description 克隆当前size对象。
     * @example
     * var size = new SuperMap.Size(31,46);
     * var size2 = size.clone();
     * @returns {SuperMap.Size}  返回一个新的与当前 size 对象有相同宽、高的 Size 对象。
     */

  }, {
    key: "clone",
    value: function clone() {
      return new Size(this.w, this.h);
    }
    /**
     *
     * @function SuperMap.Size.prototype.equals
     * @description 比较两个 size 对象是否相等。
     * @example
     * var size = new SuperMap.Size(31,46);
     * var size2 = new SuperMap.Size(31,46);
     * var isEquals = size.equals(size2);
     *
     * @param {SuperMap.Size} sz - 用于比较相等的 Size 对象。
     * @returns {boolean} 传入的 size 和当前 size 高宽相等，注意：如果传入的 size 为空则返回 false。
     *
     */

  }, {
    key: "equals",
    value: function equals(sz) {
      var equals = false;

      if (sz != null) {
        equals = this.w === sz.w && this.h === sz.h || isNaN(this.w) && isNaN(this.h) && isNaN(sz.w) && isNaN(sz.h);
      }

      return equals;
    }
    /**
     *
     * @function SuperMap.Size.prototype.destroy
     * @description 销毁此对象。销毁后此对象的所有属性为 null，而不是初始值。
     * @example
     * var size = new SuperMap.Size(31,46);
     * size.destroy();
     */

  }, {
    key: "destroy",
    value: function destroy() {
      this.w = null;
      this.h = null;
    }
  }]);

  return Size;
}();
SuperMap.Size = Size;
// CONCATENATED MODULE: ./src/common/commontypes/Pixel.js
function Pixel_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function Pixel_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function Pixel_createClass(Constructor, protoProps, staticProps) { if (protoProps) Pixel_defineProperties(Constructor.prototype, protoProps); if (staticProps) Pixel_defineProperties(Constructor, staticProps); return Constructor; }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/

/**
 * @class SuperMap.Pixel
 * @category BaseTypes Geometry
 * @classdesc 此类用 x,y 坐标描绘屏幕坐标（像素点）。
 * @param {number} [x=0.0] - x 坐标。
 * @param {number} [y=0.0] - y 坐标。
 * @param {SuperMap.Pixel.Mode} [mode=SuperMap.Pixel.Mode.LeftTop] - 坐标模式。
 *
 * @example
 * //单独创建一个对象
 * var pixcel = new SuperMap.Pixel(100,50);
 *
 * //依据 size 创建
 *  var size = new SuperMap.Size(21,25);
 *  var offset = new SuperMap.Pixel(-(size.w/2), -size.h);
 */

var Pixel_Pixel =
/*#__PURE__*/
function () {
  function Pixel(x, y, mode) {
    Pixel_classCallCheck(this, Pixel);

    /**
     * @member {number} [SuperMap.Pixel.prototype.x=0.0]
     * @description x 坐标。
     */
    this.x = x ? parseFloat(x) : 0.0;
    /**
     * @member {number} [SuperMap.Pixel.prototype.y=0.0]
     * @description y 坐标。
     */

    this.y = y ? parseFloat(y) : 0.0;
    /**
     * @member {SuperMap.Pixel.Mode} [SuperMap.Pixel.prototype.mode=SuperMap.Pixel.Mode.LeftTop]
     * @description 坐标模式，有左上、右上、右下、左下这几种模式，分别表示相对于左上角、右上角、右下角、左下角的坐标。 
     */

    this.mode = mode;
    this.CLASS_NAME = "SuperMap.Pixel";
    /**
     * @enum SuperMap.Pixel.Mode
     * @readonly
     * @description 模式。
     * @type {string}
     */

    SuperMap.Pixel.Mode = {
      /** 左上模式。*/
      LeftTop: "lefttop",

      /** 右上模式。 */
      RightTop: "righttop",

      /** 右下模式。 */
      RightBottom: "rightbottom",

      /** 左下模式。 */
      LeftBottom: "leftbottom"
    };
  }
  /**
   * @function SuperMap.Pixel.prototype.toString
   * @description 返回此对象的字符串形式。
   * @example
   *
   * var pixcel = new SuperMap.Pixel(100,50);
   * var str = pixcel.toString();
   *
   * @returns {string} 例如: "x=200.4,y=242.2"
   */


  Pixel_createClass(Pixel, [{
    key: "toString",
    value: function toString() {
      return "x=" + this.x + ",y=" + this.y;
    }
    /**
     * @function SuperMap.Pixel.prototype.clone
     * @description 克隆当前的 pixel 对象。
     * @example
     * var pixcel = new SuperMap.Pixel(100,50);
     * var pixcel2 = pixcel.clone();
     * @returns {SuperMap.Pixel} 返回一个新的与当前 pixel 对象有相同 x、y 坐标的 pixel 对象。
     */

  }, {
    key: "clone",
    value: function clone() {
      return new Pixel(this.x, this.y, this.mode);
    }
    /**
     * @function SuperMap.Pixel.prototype.equals
     * @description 比较两 pixel 是否相等。
     * @example
     * var pixcel = new SuperMap.Pixel(100,50);
     * var pixcel2 = new SuperMap.Pixel(100,50);
     * var isEquals = pixcel.equals(pixcel2);
     *
     * @param {SuperMap.Pixel} px - 用于比较相等的 pixel 对象。
     * @returns {boolean} 如果传入的像素点和当前像素点相同返回 true，如果不同或传入参数为 NULL 则返回 false。
     */

  }, {
    key: "equals",
    value: function equals(px) {
      var equals = false;

      if (px != null) {
        equals = this.x == px.x && this.y == px.y || isNaN(this.x) && isNaN(this.y) && isNaN(px.x) && isNaN(px.y);
      }

      return equals;
    }
    /**
     * @function SuperMap.Pixel.prototype.distanceTo
     * @description 返回两个 pixel 的距离。
     * @example
     * var pixcel = new SuperMap.Pixel(100,50);
     * var pixcel2 = new SuperMap.Pixel(110,30);
     * var distance = pixcel.distanceTo(pixcel2);
     *
     * @param {SuperMap.Pixel} px - 用于计算的一个 pixel。
     * @returns {float} 作为参数传入的像素与当前像素点的距离。
     */

  }, {
    key: "distanceTo",
    value: function distanceTo(px) {
      return Math.sqrt(Math.pow(this.x - px.x, 2) + Math.pow(this.y - px.y, 2));
    }
    /**
     * @function SuperMap.Pixel.prototype.add
     * @description 在原来像素坐标基础上，x 值加上传入的 x 参数，y 值加上传入的 y 参数。
     * @example
     * var pixcel = new SuperMap.Pixel(100,50);
     * //pixcel2是新的对象
     * var pixcel2 = pixcel.add(20,30);
     *
     * @param {number} x - 传入的 x 值。
     * @param {number} y - 传入的 y 值。
     * @returns {SuperMap.Pixel} 返回一个新的 pixel 对象，该 pixel 是由当前的 pixel 与传入的 x，y 相加得到。
     */

  }, {
    key: "add",
    value: function add(x, y) {
      if (x == null || y == null) {
        throw new TypeError('Pixel.add cannot receive null values');
      }

      return new Pixel(this.x + x, this.y + y);
    }
    /**
     * @function SuperMap.Pixel.prototype.offset
     * @description 通过传入的 {@link SuperMap.Pixel} 参数对原屏幕坐标进行偏移。
     * @example
     * var pixcel = new SuperMap.Pixel(100,50);
     * var pixcel2 = new SuperMap.Pixel(130,20);
     * //pixcel3 是新的对象
     * var pixcel3 = pixcel.offset(pixcel2);
     *
     * @param {SuperMap.Pixel} px - 传入的 <SuperMap.Pixel> 对象。
     * @returns {SuperMap.Pixel} 返回一个新的 pixel，该 pixel 是由当前的 pixel 对象的 x，y 值与传入的 Pixel 对象的 x，y 值相加得到。
     */

  }, {
    key: "offset",
    value: function offset(px) {
      var newPx = this.clone();

      if (px) {
        newPx = this.add(px.x, px.y);
      }

      return newPx;
    }
    /**
     *
     * @function SuperMap.Pixel.prototype.destroy
     * @description 销毁此对象。销毁后此对象的所有属性为 null，而不是初始值。
     * @example
     * var pixcel = new SuperMap.Pixel(100,50);
     * pixcel.destroy();
     */

  }, {
    key: "destroy",
    value: function destroy() {
      this.x = null;
      this.y = null;
      this.mode = null;
    }
  }]);

  return Pixel;
}();
SuperMap.Pixel = Pixel_Pixel;
// CONCATENATED MODULE: ./src/common/commontypes/BaseTypes.js
function BaseTypes_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/

/**
 *@namespace SuperMap
 *@category BaseTypes Namespace
 */

/**
 * @function SuperMap.inherit
 * @description 除了 C 和 P 两个必要参数外，可以传递任意数量的对象，这些对象都将继承C。
 * @memberOf SuperMap
 * @param {Object} C - 继承的类。
 * @param {Object} P - 被继承的父类。
 */

SuperMap.inherit = function (C, P) {
  var F = function F() {};

  F.prototype = P.prototype;
  C.prototype = new F();
  var i, l, o;

  for (i = 2, l = arguments.length; i < l; i++) {
    o = arguments[i];

    if (typeof o === "function") {
      o = o.prototype;
    }

    SuperMap.Util.extend(C.prototype, o);
  }
};
/**
 * @function SuperMap.mixin 
 * @description 实现多重继承。
 * @memberOf SuperMap
 * @param {Class|Object} ...mixins - 继承的类。
 */


SuperMap.mixin = function () {
  for (var _len = arguments.length, mixins = new Array(_len), _key = 0; _key < _len; _key++) {
    mixins[_key] = arguments[_key];
  }

  var Mix = function Mix(options) {
    BaseTypes_classCallCheck(this, Mix);

    for (var index = 0; index < mixins.length; index++) {
      copyProperties(this, new mixins[index](options));
    }
  };

  for (var index = 0; index < mixins.length; index++) {
    var mixin = mixins[index];
    copyProperties(Mix, mixin);
    copyProperties(Mix.prototype, mixin.prototype);
    copyProperties(Mix.prototype, new mixin());
  }

  return Mix;

  function copyProperties(target, source) {
    var ownKeys = Object.getOwnPropertyNames(source);

    if (Object.getOwnPropertySymbols) {
      ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source));
    }

    for (var index = 0; index < ownKeys.length; index++) {
      var key = ownKeys[index];

      if (key !== "constructor" && key !== "prototype" && key !== "name" && key !== "length") {
        var desc = Object.getOwnPropertyDescriptor(source, key);

        if (window["ActiveXObject"]) {
          Object.defineProperty(target, key, desc || {});
        } else {
          Object.defineProperty(target, key, desc);
        }
      }
    }
  }
};
/**
 * @name String
 * @namespace
 * @memberOf SuperMap
 * @category BaseTypes Util
 * @description 字符串操作的一系列常用扩展函数。
 */


var StringExt = SuperMap.String = {
  /**
   * @function SuperMap.String.startsWith
   * @description 判断目标字符串是否以指定的子字符串开头。
   * @param {string} str - 目标字符串。
   * @param {string} sub - 查找的子字符串。
   * @returns {boolean} 目标字符串以指定的子字符串开头，则返回 true；否则返回 false。
   */
  startsWith: function startsWith(str, sub) {
    return str.indexOf(sub) == 0;
  },

  /**
   * @function SuperMap.String.contains
   * @description 判断目标字符串是否包含指定的子字符串。
   * @param {string} str - 目标字符串。
   * @param {string} sub - 查找的子字符串。
   * @returns {boolean} 目标字符串中包含指定的子字符串，则返回 true；否则返回 false。
   */
  contains: function contains(str, sub) {
    return str.indexOf(sub) != -1;
  },

  /**
   * @function SuperMap.String.trim
   * @description 删除一个字符串的开头和结尾处的所有空白字符。
   * @param {string} str - （可能）存在空白字符填塞的字符串。
   * @returns {string} 删除开头和结尾处空白字符后的字符串。
   */
  trim: function trim(str) {
    return str.replace(/^\s\s*/, '').replace(/\s\s*$/, '');
  },

  /**
   * @function SuperMap.String.camelize
   * @description 骆驼式("-")连字符的字符串处理。
   * 例如："chicken-head" becomes "chickenHead",
   *       "-chicken-head" becomes "ChickenHead"。
   * @param {string} str - 要处理的字符串，原始内容不应被修改。
   * @returns {string}
   */
  camelize: function camelize(str) {
    var oStringList = str.split('-');
    var camelizedString = oStringList[0];

    for (var i = 1, len = oStringList.length; i < len; i++) {
      var s = oStringList[i];
      camelizedString += s.charAt(0).toUpperCase() + s.substring(1);
    }

    return camelizedString;
  },

  /**
   * @function SuperMap.String.format
   * @description 提供带 ${token} 标记的字符串, 返回 context 对象属性中指定标记的属性值。
   * @example
   * 示例：
   * (code)
   * 1、template = "${value,getValue}";
   *         context = {value: {getValue:function(){return Math.max.apply(null,argument);}}};
   *         args = [2,23,12,36,21];
   *       返回值:36
   * (end)
   * 示例:
   * (code)
   * 2、template = "$${{value,getValue}}";
   *         context = {value: {getValue:function(){return Math.max.apply(null,argument);}}};
   *         args = [2,23,12,36,21];
   *       返回值:"${36}"
   * (end)
   * 示例:
   * (code)
   * 3、template = "${a,b}";
   *         context = {a: {b:"format"}};
   *         args = null;
   *       返回值:"format"
   * (end)
   * 示例:
   * (code)
   * 3、template = "${a,b}";
   *         context = null;
   *         args = null;
   *       返回值:"${a.b}"
   * (end)
   * @param {string} template - 带标记的字符串将要被替换。参数 template 格式为"${token}"，此处的 token 标记会替换为 context["token"] 属性的值。
   * @param {Object} [context=window] - 带有属性的可选对象的属性用于匹配格式化字符串中的标记。如果该参数为空，将使用 window 对象。
   * @param {Array} [args] - 可选参数传递给在 context 对象上找到的函数。
   * @returns {string} 从 context 对象属性中替换字符串标记位的字符串。 
   */
  format: function format(template, context, args) {
    if (!context) {
      context = window;
    } // Example matching:
    // str   = ${foo.bar}
    // match = foo.bar


    var replacer = function replacer(str, match) {
      var replacement; // Loop through all subs. Example: ${a.b.c}
      // 0 -> replacement = context[a];
      // 1 -> replacement = context[a][b];
      // 2 -> replacement = context[a][b][c];

      var subs = match.split(/\.+/);

      for (var i = 0; i < subs.length; i++) {
        if (i == 0) {
          replacement = context;
        }

        replacement = replacement[subs[i]];
      }

      if (typeof replacement === "function") {
        replacement = args ? replacement.apply(null, args) : replacement();
      } // If replacement is undefined, return the string 'undefined'.
      // This is a workaround for a bugs in browsers not properly
      // dealing with non-participating groups in regular expressions:
      // http://blog.stevenlevithan.com/archives/npcg-javascript


      if (typeof replacement == 'undefined') {
        return 'undefined';
      } else {
        return replacement;
      }
    };

    return template.replace(SuperMap.String.tokenRegEx, replacer);
  },

  /**
   * @member {RegExp} [SuperMap.String.tokenRegEx]
   * @description 寻找带 token 的字符串，默认为 tokenRegEx=/\$\{([\w.]+?)\}/g。
   * @example
   * Examples: ${a}, ${a.b.c}, ${a-b}, ${5}
   */
  tokenRegEx: /\$\{([\w.]+?)\}/g,

  /**
   * @member {RegExp} [SuperMap.String.numberRegEx]
   * @description 判断一个字符串是否只包含一个数值，默认为 numberRegEx=/^([+-]?)(?=\d|\.\d)\d*(\.\d*)?([Ee]([+-]?\d+))?$/。
   */
  numberRegEx: /^([+-]?)(?=\d|\.\d)\d*(\.\d*)?([Ee]([+-]?\d+))?$/,

  /**
   * @function SuperMap.String.isNumeric
   * @description 判断一个字符串是否只包含一个数值。
   * @example
   * (code)
   * SuperMap.String.isNumeric("6.02e23") // true
   * SuperMap.String.isNumeric("12 dozen") // false
   * SuperMap.String.isNumeric("4") // true
   * SuperMap.String.isNumeric(" 4 ") // false
   * (end)
   * @returns {boolean} 字符串包含唯一的数值，返回 true；否则返回 false。
   */
  isNumeric: function isNumeric(value) {
    return SuperMap.String.numberRegEx.test(value);
  },

  /**
   * @function SuperMap.String.numericIf
   * @description 把一个看似数值型的字符串转化为一个数值。
   * @returns {(number|string)} 如果能转换为数值则返回数值，否则返回字符串本身。
   */
  numericIf: function numericIf(value) {
    return SuperMap.String.isNumeric(value) ? parseFloat(value) : value;
  }
};
/**
 * @name Number
 * @memberOf SuperMap
 * @namespace
 * @category BaseTypes Util
 * @description 数值操作的一系列常用扩展函数。
 */

var NumberExt = SuperMap.Number = {
  /**
   * @member {string} [SuperMap.Number.decimalSeparator='.']
   * @description 格式化数字时默认的小数点分隔符。
   * @constant
   */
  decimalSeparator: ".",

  /**
   * @member {string} [SuperMap.Number.thousandsSeparator=',']
   * @description 格式化数字时默认的千位分隔符。
   * @constant
   */
  thousandsSeparator: ",",

  /**
   * @function SuperMap.Number.limitSigDigs
   * @description 限制浮点数的有效数字位数。
   * @param {number} num - 浮点数。
   * @param {integer} sig - 有效位数。
   * @returns {number} 将数字四舍五入到指定数量的有效位数。
   */
  limitSigDigs: function limitSigDigs(num, sig) {
    var fig = 0;

    if (sig > 0) {
      fig = parseFloat(num.toPrecision(sig));
    }

    return fig;
  },

  /**
   * @function SuperMap.Number.format
   * @description 数字格式化输出。
   * @param {number} num - 数字。
   * @param {integer} [dec=0]  - 数字的小数部分四舍五入到指定的位数。设置为 null 值时小数部分不变。
   * @param {string} [tsep=','] - 千位分隔符。
   * @param {string} [dsep='.'] - 小数点分隔符。
   * @returns {string} 数字格式化后的字符串。
   */
  format: function format(num, dec, tsep, dsep) {
    dec = typeof dec != "undefined" ? dec : 0;
    tsep = typeof tsep != "undefined" ? tsep : SuperMap.Number.thousandsSeparator;
    dsep = typeof dsep != "undefined" ? dsep : SuperMap.Number.decimalSeparator;

    if (dec != null) {
      num = parseFloat(num.toFixed(dec));
    }

    var parts = num.toString().split(".");

    if (parts.length === 1 && dec == null) {
      // integer where we do not want to touch the decimals
      dec = 0;
    }

    var integer = parts[0];

    if (tsep) {
      var thousands = /(-?[0-9]+)([0-9]{3})/;

      while (thousands.test(integer)) {
        integer = integer.replace(thousands, "$1" + tsep + "$2");
      }
    }

    var str;

    if (dec == 0) {
      str = integer;
    } else {
      var rem = parts.length > 1 ? parts[1] : "0";

      if (dec != null) {
        rem = rem + new Array(dec - rem.length + 1).join("0");
      }

      str = integer + dsep + rem;
    }

    return str;
  }
};

if (!Number.prototype.limitSigDigs) {
  /**
   * APIMethod: Number.limitSigDigs
   * 限制浮点数的有效数字位数.
   * @param {integer} sig -有效位数。
   * @returns {integer} 将数字四舍五入到指定数量的有效位数。
   *           如果传入值 为 null、0、或者是负数, 返回值 0。
   */
  Number.prototype.limitSigDigs = function (sig) {
    return NumberExt.limitSigDigs(this, sig);
  };
}
/**
 * @name Function
 * @memberOf SuperMap
 * @namespace
 * @category BaseTypes Util
 * @description 函数操作的一系列常用扩展函数。
 */


var FunctionExt = SuperMap.Function = {
  /**
   * @function SuperMap.Function.bind
   * @description 绑定函数到对象。方便创建 this 的作用域。
   * @param {function} func - 输入函数。
   * @param {Object} object - 对象绑定到输入函数（作为输入函数的 this 对象）。
   * @returns {function} object 参数作为 func 函数的 this 对象。
   */
  bind: function bind(func, object) {
    // create a reference to all arguments past the second one
    var args = Array.prototype.slice.apply(arguments, [2]);
    return function () {
      // Push on any additional arguments from the actual function call.
      // These will come after those sent to the bind call.
      var newArgs = args.concat(Array.prototype.slice.apply(arguments, [0]));
      return func.apply(object, newArgs);
    };
  },

  /**
   * @function SuperMap.Function.bindAsEventListener
   * @description 绑定函数到对象，在调用该函数时配置并使用事件对象作为第一个参数。
   * @param {function} func - 用于监听事件的函数。
   * @param {Object} object - this 对象的引用。
   * @returns {function}
   */
  bindAsEventListener: function bindAsEventListener(func, object) {
    return function (event) {
      return func.call(object, event || window.event);
    };
  },

  /**
   * @function SuperMap.Function.False
   * @description 该函数仅仅返回 false。该函数主要是避免在 IE8 以下浏览中 DOM 事件句柄的匿名函数问题。
   * @example
   * document.onclick = SuperMap.Function.False;
   * @returns {boolean}
   */
  False: function False() {
    return false;
  },

  /**
   * @function SuperMap.Function.True
   * @description 该函数仅仅返回 true。该函数主要是避免在 IE8 以下浏览中 DOM 事件句柄的匿名函数问题。
   * @example
   * document.onclick = SuperMap.Function.True;
   * @returns {boolean}
   */
  True: function True() {
    return true;
  },

  /**
   * @function SuperMap.Function.Void
   * @description 可重用函数，仅仅返回 "undefined"。
   * @returns {undefined}
   */
  Void: function Void() {}
};
/**
 * @name Array
 * @memberOf SuperMap
 * @namespace
 * @category BaseTypes Util
 * @description 数组操作的一系列常用扩展函数。
 */

var ArrayExt = SuperMap.Array = {
  /**
   * @function SuperMap.Array.filter
   * @description 过滤数组，提供了 ECMA-262 标准中 Array.prototype.filter 函数的扩展。详见：{@link http://developer.mozilla.org/en/Core_JavaScript_1.5_Reference/Global_Objects/Array/filter}
   * @param {Array} array - 要过滤的数组。
   * @param {function} callback - 数组中的每一个元素调用该函数。</br>
   *     如果函数的返回值为 true，该元素将包含在返回的数组中。该函数有三个参数: 数组中的元素，元素的索引，数组自身。</br>
   *     如果设置了可选参数 caller，在调用 callback 时，使用可选参数 caller 设置为 callback 的参数。</br>
   * @param {Object} [caller] - 在调用 callback 时，使用参数 caller 设置为 callback 的参数。
   * @returns {Array} callback 函数返回 true 时的元素将作为返回数组中的元素。
   */
  filter: function filter(array, callback, caller) {
    var selected = [];

    if (Array.prototype.filter) {
      selected = array.filter(callback, caller);
    } else {
      var len = array.length;

      if (typeof callback != "function") {
        throw new TypeError();
      }

      for (var i = 0; i < len; i++) {
        if (i in array) {
          var val = array[i];

          if (callback.call(caller, val, i, array)) {
            selected.push(val);
          }
        }
      }
    }

    return selected;
  }
};
// CONCATENATED MODULE: ./src/common/commontypes/Util.js
function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


var Util = SuperMap.Util = SuperMap.Util || {};
/**
 * @name Util
 * @memberOf SuperMap
 * @namespace
 * @category BaseTypes Util
 * @description common 工具类。
 */

/**
 * @description 复制源对象的所有属性到目标对象上，源对象上的没有定义的属性在目标对象上也不会被设置。
 * @example
 * 要复制 SuperMap.Size 对象的所有属性到自定义对象上，使用方法如下:
 *     var size = new SuperMap.Size(100, 100);
 *     var obj = {}；
 *     SuperMap.Util.extend(obj, size);
 * @param {Object} [destination] - 目标对象。
 * @param {Object} source - 源对象，其属性将被设置到目标对象上。
 * @returns {Object} 目标对象。
 */

SuperMap.Util.extend = function (destination, source) {
  destination = destination || {};

  if (source) {
    for (var property in source) {
      var value = source[property];

      if (value !== undefined) {
        destination[property] = value;
      }
    }
    /**
     * IE doesn't include the toString property when iterating over an object's
     * properties with the for(property in object) syntax.  Explicitly check if
     * the source has its own toString property.
     */

    /*
     * FF/Windows < 2.0.0.13 reports "Illegal operation on WrappedNative
     * prototype object" when calling hawOwnProperty if the source object
     * is an instance of window.Event.
     */


    var sourceIsEvt = typeof window.Event === "function" && source instanceof window.Event;

    if (!sourceIsEvt && source.hasOwnProperty && source.hasOwnProperty("toString")) {
      destination.toString = source.toString;
    }
  }

  return destination;
};
/**
 * @description 对象拷贝。
 * @param {Object} [des] - 目标对象。
 * @param {Object} soc - 源对象。
 */


SuperMap.Util.copy = function (des, soc) {
  des = des || {};
  var v;

  if (soc) {
    for (var p in des) {
      v = soc[p];

      if (typeof v !== 'undefined') {
        des[p] = v;
      }
    }
  }
};
/**
 * @description 销毁对象，将其属性置空。
 * @param {Object} [obj] - 目标对象。
 */


SuperMap.Util.reset = function (obj) {
  obj = obj || {};

  for (var p in obj) {
    if (obj.hasOwnProperty(p)) {
      if (_typeof(obj[p]) === "object" && obj[p] instanceof Array) {
        for (var i in obj[p]) {
          if (obj[p][i].destroy) {
            obj[p][i].destroy();
          }
        }

        obj[p].length = 0;
      } else if (_typeof(obj[p]) === "object" && obj[p] instanceof Object) {
        if (obj[p].destroy) {
          obj[p].destroy();
        }
      }

      obj[p] = null;
    }
  }
};
/**
 * @description 获取 HTML 元素数组。
 * @returns {Array.<HTMLElement>} HTML 元素数组。
 */


SuperMap.Util.getElement = function () {
  var elements = [];

  for (var i = 0, len = arguments.length; i < len; i++) {
    var element = arguments[i];

    if (typeof element === 'string') {
      element = document.getElementById(element);
    }

    if (arguments.length === 1) {
      return element;
    }

    elements.push(element);
  }

  return elements;
};
/**
 * @description instance of 的跨浏览器实现。
 * @param {Object} o - 对象。
 * @returns {boolean} 是否是页面元素。
 */


SuperMap.Util.isElement = function (o) {
  return !!(o && o.nodeType === 1);
};
/**
 * @description 判断一个对象是否是数组。
 * @param {Object} a - 对象。
 * @returns {boolean} 是否是数组。
 */


SuperMap.Util.isArray = function (a) {
  return Object.prototype.toString.call(a) === '[object Array]';
};
/**
 * @description 从数组中删除某一项。
 * @param {Array} array - 数组。
 * @param {Object} item - 数组中要删除的一项。
 * @returns {Array} 执行删除操作后的数组。
 */


SuperMap.Util.removeItem = function (array, item) {
  for (var i = array.length - 1; i >= 0; i--) {
    if (array[i] === item) {
      array.splice(i, 1); //break;more than once??
    }
  }

  return array;
};
/**
 * @description 获取某对象再数组中的索引值。
 * @param {Array} array - 数组。
 * @param {Object} obj - 对象。
 * @returns {number} 某对象再数组中的索引值。
 */


SuperMap.Util.indexOf = function (array, obj) {
  if (array == null) {
    return -1;
  } else {
    // use the build-in function if available.
    if (typeof array.indexOf === "function") {
      return array.indexOf(obj);
    } else {
      for (var i = 0, len = array.length; i < len; i++) {
        if (array[i] === obj) {
          return i;
        }
      }

      return -1;
    }
  }
};
/**
 * @description 修改某 DOM 元素的许多属性。
 * @param {HTMLElement} element - 待修改的 DOM 元素。
 * @param {string} [id] - DOM 元素的 ID。
 * @param {SuperMap.Pixel} [px] - 包含 DOM 元素的 style 属性的 left 和 top 属性。
 * @param {SuperMap.Size} [sz] - 包含 DOM 元素的 width 和 height 属性。
 * @param {string} [position] - DOM 元素的 position 属性。
 * @param {string} [border] - DOM 元素的 style 属性的 border 属性。
 * @param {string} [overflow] - DOM 元素的 style 属性的 overflow 属性。
 * @param {number} [opacity] - 不透明度值。取值范围为(0.0 - 1.0)。
 */


SuperMap.Util.modifyDOMElement = function (element, id, px, sz, position, border, overflow, opacity) {
  if (id) {
    element.id = id;
  }

  if (px) {
    element.style.left = px.x + "px";
    element.style.top = px.y + "px";
  }

  if (sz) {
    element.style.width = sz.w + "px";
    element.style.height = sz.h + "px";
  }

  if (position) {
    element.style.position = position;
  }

  if (border) {
    element.style.border = border;
  }

  if (overflow) {
    element.style.overflow = overflow;
  }

  if (parseFloat(opacity) >= 0.0 && parseFloat(opacity) < 1.0) {
    element.style.filter = 'alpha(opacity=' + opacity * 100 + ')';
    element.style.opacity = opacity;
  } else if (parseFloat(opacity) === 1.0) {
    element.style.filter = '';
    element.style.opacity = '';
  }
};
/**
 * @description Takes an object and copies any properties that don't exist from
 *     another properties, by analogy with SuperMap.Util.extend() from
 *     Prototype.js.
 *
 * @param {Object} [to] - 目标对象。
 * @param {Object} from - 源对象。Any properties of this object that
 *     are undefined in the to object will be set on the to object.
 *
 * @returns {Object} A reference to the to object.  Note that the to argument is modified
 *     in place and returned by this function.
 */


SuperMap.Util.applyDefaults = function (to, from) {
  to = to || {};
  /*
   * FF/Windows < 2.0.0.13 reports "Illegal operation on WrappedNative
   * prototype object" when calling hawOwnProperty if the source object is an
   * instance of window.Event.
   */

  var fromIsEvt = typeof window.Event === "function" && from instanceof window.Event;

  for (var key in from) {
    if (to[key] === undefined || !fromIsEvt && from.hasOwnProperty && from.hasOwnProperty(key) && !to.hasOwnProperty(key)) {
      to[key] = from[key];
    }
  }
  /**
   * IE doesn't include the toString property when iterating over an object's
   * properties with the for(property in object) syntax.  Explicitly check if
   * the source has its own toString property.
   */


  if (!fromIsEvt && from && from.hasOwnProperty && from.hasOwnProperty('toString') && !to.hasOwnProperty('toString')) {
    to.toString = from.toString;
  }

  return to;
};
/**
 * @description 将参数对象转换为 HTTP 的 GET 请求中的参数字符串。例如："key1=value1&key2=value2&key3=value3"。
 * @param {Object} params - 参数对象。
 * @returns {string} HTTP 的 GET 请求中的参数字符串。
 */


SuperMap.Util.getParameterString = function (params) {
  var paramsArray = [];

  for (var key in params) {
    var value = params[key];

    if (value != null && typeof value !== 'function') {
      var encodedValue;

      if (_typeof(value) === 'object' && value.constructor === Array) {
        /* value is an array; encode items and separate with "," */
        var encodedItemArray = [];
        var item;

        for (var itemIndex = 0, len = value.length; itemIndex < len; itemIndex++) {
          item = value[itemIndex];
          encodedItemArray.push(encodeURIComponent(item === null || item === undefined ? "" : item));
        }

        encodedValue = encodedItemArray.join(",");
      } else {
        /* value is a string; simply encode */
        encodedValue = encodeURIComponent(value);
      }

      paramsArray.push(encodeURIComponent(key) + "=" + encodedValue);
    }
  }

  return paramsArray.join("&");
};
/**
 * @description 给 URL 追加参数。
 * @param {string} url - 待追加参数的 URL 字符串。
 * @param {string} paramStr - 待追加的参数。
 * @returns {string} 新的 URL。
 */


SuperMap.Util.urlAppend = function (url, paramStr) {
  var newUrl = url;

  if (paramStr) {
    var parts = (url + " ").split(/[?&]/);
    newUrl += parts.pop() === " " ? paramStr : parts.length ? "&" + paramStr : "?" + paramStr;
  }

  return newUrl;
};
/**
 * @description 为了避免浮点精度错误而保留的有效位数。
 * @type {number}
 * @default 14
 */


SuperMap.Util.DEFAULT_PRECISION = 14;
/**
 * @description 将字符串以接近的精度转换为数字。
 * @param {string} number - 字符串。
 * @param {number} [precision=14] - 精度。
 * @returns {number} 数字。
 */

SuperMap.Util.toFloat = function (number, precision) {
  if (precision == null) {
    precision = SuperMap.Util.DEFAULT_PRECISION;
  }

  if (typeof number !== "number") {
    number = parseFloat(number);
  }

  return precision === 0 ? number : parseFloat(number.toPrecision(precision));
};
/**
 * @description 角度转弧度。
 * @param {number} x - 角度。
 * @returns {number} 弧度。
 */


SuperMap.Util.rad = function (x) {
  return x * Math.PI / 180;
};
/**
 * @description 从 URL 字符串中解析出参数对象。
 * @param {string} url - URL。
 * @returns {Object} 解析出的参数对象。
 */


SuperMap.Util.getParameters = function (url) {
  // if no url specified, take it from the location bar
  url = url === null || url === undefined ? window.location.href : url; //parse out parameters portion of url string

  var paramsString = "";

  if (SuperMap.String.contains(url, '?')) {
    var start = url.indexOf('?') + 1;
    var end = SuperMap.String.contains(url, "#") ? url.indexOf('#') : url.length;
    paramsString = url.substring(start, end);
  }

  var parameters = {};
  var pairs = paramsString.split(/[&;]/);

  for (var i = 0, len = pairs.length; i < len; ++i) {
    var keyValue = pairs[i].split('=');

    if (keyValue[0]) {
      var key = keyValue[0];

      try {
        key = decodeURIComponent(key);
      } catch (err) {
        key = unescape(key);
      } // being liberal by replacing "+" with " "


      var value = (keyValue[1] || '').replace(/\+/g, " ");

      try {
        value = decodeURIComponent(value);
      } catch (err) {
        value = unescape(value);
      } // follow OGC convention of comma delimited values


      value = value.split(","); //if there's only one value, do not return as array                    

      if (value.length == 1) {
        value = value[0];
      }

      parameters[key] = value;
    }
  }

  return parameters;
};
/**
 * @description 不断递增计数变量，用于生成唯一 ID。
 * @type {number}
 * @default 0
 */


SuperMap.Util.lastSeqID = 0;
/**
 * @description 创建唯一 ID 值。
 * @param {string} [prefix] - 前缀。
 * @returns {string} 唯一的 ID 值。
 */

SuperMap.Util.createUniqueID = function (prefix) {
  if (prefix == null) {
    prefix = "id_";
  }

  SuperMap.Util.lastSeqID += 1;
  return prefix + SuperMap.Util.lastSeqID;
};
/**
 * @memberOf SuperMap
 * @description 每单位的英尺数。
 * @type {Object}
 * @constant
 */


SuperMap.INCHES_PER_UNIT = {
  'inches': 1.0,
  'ft': 12.0,
  'mi': 63360.0,
  'm': 39.3701,
  'km': 39370.1,
  'dd': 4374754,
  'yd': 36
};
SuperMap.INCHES_PER_UNIT["in"] = SuperMap.INCHES_PER_UNIT.inches;
SuperMap.INCHES_PER_UNIT["degrees"] = SuperMap.INCHES_PER_UNIT.dd;
SuperMap.INCHES_PER_UNIT["nmi"] = 1852 * SuperMap.INCHES_PER_UNIT.m; // Units from CS-Map

SuperMap.METERS_PER_INCH = 0.02540005080010160020;
SuperMap.Util.extend(SuperMap.INCHES_PER_UNIT, {
  "Inch": SuperMap.INCHES_PER_UNIT.inches,
  "Meter": 1.0 / SuperMap.METERS_PER_INCH,
  //EPSG:9001
  "Foot": 0.30480060960121920243 / SuperMap.METERS_PER_INCH,
  //EPSG:9003
  "IFoot": 0.30480000000000000000 / SuperMap.METERS_PER_INCH,
  //EPSG:9002
  "ClarkeFoot": 0.3047972651151 / SuperMap.METERS_PER_INCH,
  //EPSG:9005
  "SearsFoot": 0.30479947153867624624 / SuperMap.METERS_PER_INCH,
  //EPSG:9041
  "GoldCoastFoot": 0.30479971018150881758 / SuperMap.METERS_PER_INCH,
  //EPSG:9094
  "IInch": 0.02540000000000000000 / SuperMap.METERS_PER_INCH,
  "MicroInch": 0.00002540000000000000 / SuperMap.METERS_PER_INCH,
  "Mil": 0.00000002540000000000 / SuperMap.METERS_PER_INCH,
  "Centimeter": 0.01000000000000000000 / SuperMap.METERS_PER_INCH,
  "Kilometer": 1000.00000000000000000000 / SuperMap.METERS_PER_INCH,
  //EPSG:9036
  "Yard": 0.91440182880365760731 / SuperMap.METERS_PER_INCH,
  "SearsYard": 0.914398414616029 / SuperMap.METERS_PER_INCH,
  //EPSG:9040
  "IndianYard": 0.91439853074444079983 / SuperMap.METERS_PER_INCH,
  //EPSG:9084
  "IndianYd37": 0.91439523 / SuperMap.METERS_PER_INCH,
  //EPSG:9085
  "IndianYd62": 0.9143988 / SuperMap.METERS_PER_INCH,
  //EPSG:9086
  "IndianYd75": 0.9143985 / SuperMap.METERS_PER_INCH,
  //EPSG:9087
  "IndianFoot": 0.30479951 / SuperMap.METERS_PER_INCH,
  //EPSG:9080
  "IndianFt37": 0.30479841 / SuperMap.METERS_PER_INCH,
  //EPSG:9081
  "IndianFt62": 0.3047996 / SuperMap.METERS_PER_INCH,
  //EPSG:9082
  "IndianFt75": 0.3047995 / SuperMap.METERS_PER_INCH,
  //EPSG:9083
  "Mile": 1609.34721869443738887477 / SuperMap.METERS_PER_INCH,
  "IYard": 0.91440000000000000000 / SuperMap.METERS_PER_INCH,
  //EPSG:9096
  "IMile": 1609.34400000000000000000 / SuperMap.METERS_PER_INCH,
  //EPSG:9093
  "NautM": 1852.00000000000000000000 / SuperMap.METERS_PER_INCH,
  //EPSG:9030
  "Lat-66": 110943.316488932731 / SuperMap.METERS_PER_INCH,
  "Lat-83": 110946.25736872234125 / SuperMap.METERS_PER_INCH,
  "Decimeter": 0.10000000000000000000 / SuperMap.METERS_PER_INCH,
  "Millimeter": 0.00100000000000000000 / SuperMap.METERS_PER_INCH,
  "Dekameter": 10.00000000000000000000 / SuperMap.METERS_PER_INCH,
  "Decameter": 10.00000000000000000000 / SuperMap.METERS_PER_INCH,
  "Hectometer": 100.00000000000000000000 / SuperMap.METERS_PER_INCH,
  "GermanMeter": 1.0000135965 / SuperMap.METERS_PER_INCH,
  //EPSG:9031
  "CaGrid": 0.999738 / SuperMap.METERS_PER_INCH,
  "ClarkeChain": 20.1166194976 / SuperMap.METERS_PER_INCH,
  //EPSG:9038
  "GunterChain": 20.11684023368047 / SuperMap.METERS_PER_INCH,
  //EPSG:9033
  "BenoitChain": 20.116782494375872 / SuperMap.METERS_PER_INCH,
  //EPSG:9062
  "SearsChain": 20.11676512155 / SuperMap.METERS_PER_INCH,
  //EPSG:9042
  "ClarkeLink": 0.201166194976 / SuperMap.METERS_PER_INCH,
  //EPSG:9039
  "GunterLink": 0.2011684023368047 / SuperMap.METERS_PER_INCH,
  //EPSG:9034
  "BenoitLink": 0.20116782494375872 / SuperMap.METERS_PER_INCH,
  //EPSG:9063
  "SearsLink": 0.2011676512155 / SuperMap.METERS_PER_INCH,
  //EPSG:9043
  "Rod": 5.02921005842012 / SuperMap.METERS_PER_INCH,
  "IntnlChain": 20.1168 / SuperMap.METERS_PER_INCH,
  //EPSG:9097
  "IntnlLink": 0.201168 / SuperMap.METERS_PER_INCH,
  //EPSG:9098
  "Perch": 5.02921005842012 / SuperMap.METERS_PER_INCH,
  "Pole": 5.02921005842012 / SuperMap.METERS_PER_INCH,
  "Furlong": 201.1684023368046 / SuperMap.METERS_PER_INCH,
  "Rood": 3.778266898 / SuperMap.METERS_PER_INCH,
  "CapeFoot": 0.3047972615 / SuperMap.METERS_PER_INCH,
  "Brealey": 375.00000000000000000000 / SuperMap.METERS_PER_INCH,
  "ModAmFt": 0.304812252984505969011938 / SuperMap.METERS_PER_INCH,
  "Fathom": 1.8288 / SuperMap.METERS_PER_INCH,
  "NautM-UK": 1853.184 / SuperMap.METERS_PER_INCH,
  "50kilometers": 50000.0 / SuperMap.METERS_PER_INCH,
  "150kilometers": 150000.0 / SuperMap.METERS_PER_INCH
}); //unit abbreviations supported by PROJ.4

SuperMap.Util.extend(SuperMap.INCHES_PER_UNIT, {
  "mm": SuperMap.INCHES_PER_UNIT["Meter"] / 1000.0,
  "cm": SuperMap.INCHES_PER_UNIT["Meter"] / 100.0,
  "dm": SuperMap.INCHES_PER_UNIT["Meter"] * 100.0,
  "km": SuperMap.INCHES_PER_UNIT["Meter"] * 1000.0,
  "kmi": SuperMap.INCHES_PER_UNIT["nmi"],
  //International Nautical Mile
  "fath": SuperMap.INCHES_PER_UNIT["Fathom"],
  //International Fathom
  "ch": SuperMap.INCHES_PER_UNIT["IntnlChain"],
  //International Chain
  "link": SuperMap.INCHES_PER_UNIT["IntnlLink"],
  //International Link
  "us-in": SuperMap.INCHES_PER_UNIT["inches"],
  //U.S. Surveyor's Inch
  "us-ft": SuperMap.INCHES_PER_UNIT["Foot"],
  //U.S. Surveyor's Foot
  "us-yd": SuperMap.INCHES_PER_UNIT["Yard"],
  //U.S. Surveyor's Yard
  "us-ch": SuperMap.INCHES_PER_UNIT["GunterChain"],
  //U.S. Surveyor's Chain
  "us-mi": SuperMap.INCHES_PER_UNIT["Mile"],
  //U.S. Surveyor's Statute Mile
  "ind-yd": SuperMap.INCHES_PER_UNIT["IndianYd37"],
  //Indian Yard
  "ind-ft": SuperMap.INCHES_PER_UNIT["IndianFt37"],
  //Indian Foot
  "ind-ch": 20.11669506 / SuperMap.METERS_PER_INCH //Indian Chain

});
/**
 * @memberOf SuperMap
 * @member [SuperMap.DOTS_PER_INCH=96]
 * @description 分辨率与比例尺之间转换的常量。
 * @type {Object}
 */

SuperMap.DOTS_PER_INCH = 96;
/**
 * @param {number} scale - 比例尺。
 * @returns {number} 返回正常的 scale 值。
 */

SuperMap.Util.normalizeScale = function (scale) {
  var normScale = scale > 1.0 ? 1.0 / scale : scale;
  return normScale;
};
/**
 * @description 比例尺转分辨率。
 * @param {number} scale - 比例尺。
 * @param {string} [units='degrees'] - 比例尺单位。
 * @returns {number} 分辨率。
 */


SuperMap.Util.getResolutionFromScale = function (scale, units) {
  var resolution;

  if (scale) {
    if (units == null) {
      units = "degrees";
    }

    var normScale = SuperMap.Util.normalizeScale(scale);
    resolution = 1 / (normScale * SuperMap.INCHES_PER_UNIT[units] * SuperMap.DOTS_PER_INCH);
  }

  return resolution;
};
/**
 * @description 分辨率转比例尺。
 * @param {number} resolution - 分辨率。
 * @param {string} [units='degrees'] - 分辨率单位。
 * @returns {number} 比例尺。
 */


SuperMap.Util.getScaleFromResolution = function (resolution, units) {
  if (units == null) {
    units = "degrees";
  }

  var scale = resolution * SuperMap.INCHES_PER_UNIT[units] * SuperMap.DOTS_PER_INCH;
  return scale;
};
/**
 * @memberOf SuperMap
 * @description 如果 userAgent 捕获到浏览器使用的是 Gecko 引擎则返回 true。
 * @constant
 */


SuperMap.IS_GECKO = function () {
  var ua = navigator.userAgent.toLowerCase();
  return ua.indexOf("webkit") === -1 && ua.indexOf("gecko") !== -1;
}();
/**
 * @memberOf SuperMap
 * @description 浏览器名称，依赖于 userAgent 属性，BROWSER_NAME 可以是空，或者以下浏览器：
 *     * "opera" -- Opera
 *     * "msie"  -- Internet Explorer
 *     * "safari" -- Safari
 *     * "firefox" -- Firefox
 *     * "mozilla" -- Mozilla
 * @constant
 */


SuperMap.Browser = function () {
  var name = '',
      version = '',
      device = 'pc',
      uaMatch; //以下进行测试

  var ua = navigator.userAgent.toLowerCase();

  if (ua.indexOf("msie") > -1 || ua.indexOf("trident") > -1 && ua.indexOf("rv") > -1) {
    name = 'msie';
    uaMatch = ua.match(/msie ([\d.]+)/) || ua.match(/rv:([\d.]+)/);
  } else if (ua.indexOf("chrome") > -1) {
    name = 'chrome';
    uaMatch = ua.match(/chrome\/([\d.]+)/);
  } else if (ua.indexOf("firefox") > -1) {
    name = 'firefox';
    uaMatch = ua.match(/firefox\/([\d.]+)/);
  } else if (ua.indexOf("opera") > -1) {
    name = 'opera';
    uaMatch = ua.match(/version\/([\d.]+)/);
  } else if (ua.indexOf("safari") > -1) {
    name = 'safari';
    uaMatch = ua.match(/version\/([\d.]+)/);
  }

  version = uaMatch ? uaMatch[1] : '';

  if (ua.indexOf("ipad") > -1 || ua.indexOf("ipod") > -1 || ua.indexOf("iphone") > -1) {
    device = 'apple';
  } else if (ua.indexOf("android") > -1) {
    uaMatch = ua.match(/version\/([\d.]+)/);
    version = uaMatch ? uaMatch[1] : '';
    device = 'android';
  }

  return {
    name: name,
    version: version,
    device: device
  };
}();
/**
 * @description 获取浏览器相关信息。支持的浏览器包括：Opera，Internet Explorer，Safari，Firefox。
 * @returns {Object} 获取浏览器名称、版本、设备名称。对应的属性分别为 name, version, device。
 */


SuperMap.Util.getBrowser = function () {
  return SuperMap.Browser;
};
/**
 * @description 浏览器是否支持 Canvas。
 * @returns {boolean} 获取当前浏览器是否支持 HTML5 Canvas。
 */


SuperMap.Util.isSupportCanvas = function () {
  var checkRes = true,
      broz = SuperMap.Util.getBrowser();

  if (document.createElement("canvas").getContext) {
    if (broz.name === 'firefox' && parseFloat(broz.version) < 5) {
      checkRes = false;
    }

    if (broz.name === 'safari' && parseFloat(broz.version) < 4) {
      checkRes = false;
    }

    if (broz.name === 'opera' && parseFloat(broz.version) < 10) {
      checkRes = false;
    }

    if (broz.name === 'msie' && parseFloat(broz.version) < 9) {
      checkRes = false;
    }
  } else {
    checkRes = false;
  }

  return checkRes;
}();
/**
 * @description 判断；浏览器是否支持 Canvas。
 * @returns {boolean} 获取当前浏览器是否支持 HTML5 Canvas 。
 */


SuperMap.Util.supportCanvas = function () {
  return SuperMap.Util.isSupportCanvas;
}; //将服务端的地图单位转成SuperMap的地图单位


SuperMap.INCHES_PER_UNIT["degree"] = SuperMap.INCHES_PER_UNIT.dd;
SuperMap.INCHES_PER_UNIT["meter"] = SuperMap.INCHES_PER_UNIT.m;
SuperMap.INCHES_PER_UNIT["foot"] = SuperMap.INCHES_PER_UNIT.ft;
SuperMap.INCHES_PER_UNIT["inch"] = SuperMap.INCHES_PER_UNIT.inches;
SuperMap.INCHES_PER_UNIT["mile"] = SuperMap.INCHES_PER_UNIT.mi;
SuperMap.INCHES_PER_UNIT["kilometer"] = SuperMap.INCHES_PER_UNIT.km;
SuperMap.INCHES_PER_UNIT["yard"] = SuperMap.INCHES_PER_UNIT.yd;
/**
 * @description 判断一个 URL 请求是否在当前域中。
 * @param {string} url - URL 请求字符串。
 * @returns {boolean} URL 请求是否在当前域中。
 */

SuperMap.Util.isInTheSameDomain = function (url) {
  if (!url) {
    return true;
  }

  var index = url.indexOf("//");
  var documentUrl = document.location.toString();
  var documentIndex = documentUrl.indexOf("//");

  if (index === -1) {
    return true;
  } else {
    var protocol;
    var substring = protocol = url.substring(0, index);
    var documentSubString = documentUrl.substring(documentIndex + 2);
    documentIndex = documentSubString.indexOf("/");
    var documentPortIndex = documentSubString.indexOf(":");
    var documentDomainWithPort = documentSubString.substring(0, documentIndex); //var documentPort;

    var documentprotocol = document.location.protocol;

    if (documentPortIndex !== -1) {// documentPort = +documentSubString.substring(documentPortIndex, documentIndex);
    } else {
      documentDomainWithPort += ':' + (documentprotocol.toLowerCase() === 'http:' ? 80 : 443);
    }

    if (documentprotocol.toLowerCase() !== substring.toLowerCase()) {
      return false;
    }

    substring = url.substring(index + 2);
    var portIndex = substring.indexOf(":");
    index = substring.indexOf("/");
    var domainWithPort = substring.substring(0, index);
    var domain;

    if (portIndex !== -1) {
      domain = substring.substring(0, portIndex);
    } else {
      domain = substring.substring(0, index);
      domainWithPort += ':' + (protocol.toLowerCase() === 'http:' ? 80 : 443);
    }

    var documentDomain = document.domain;

    if (domain === documentDomain && domainWithPort === documentDomainWithPort) {
      return true;
    }
  }

  return false;
};
/**
 * @description 计算 iServer 服务的 REST 图层的显示分辨率，需要从 iServer 的 REST 图层表述中获取 viewBounds、viewer、scale、coordUnit、datumAxis 五个参数，来进行计算。
 * @param {SuperMap.Bounds} viewBounds - 地图的参照可视范围，即地图初始化时默认的地图显示范围。
 * @param {SuperMap.Size} viewer - 地图初始化时默认的地图图片的尺寸。
 * @param {number} scale - 地图初始化时默认的显示比例尺。
 * @param {string} [coordUnit='degrees'] - 投影坐标系统的地图单位。
 * @param {number} [datumAxis=6378137] - 地理坐标系统椭球体长半轴。用户自定义地图的 Options 时，若未指定该参数的值，则系统默认为 WGS84 参考系的椭球体长半轴 6378137。
 * @returns {number} 返回图层显示分辨率。
 */


SuperMap.Util.calculateDpi = function (viewBounds, viewer, scale, coordUnit, datumAxis) {
  //10000 是 0.1毫米与米的转换。DPI的计算公式：Viewer / DPI *  0.0254 * 10000 = ViewBounds * scale ，公式中的10000是为了提高计算结果的精度，以下出现的ratio皆为如此。
  if (!viewBounds || !viewer || !scale) {
    return;
  }

  var ratio = 10000,
      rvbWidth = viewBounds.getWidth(),
      rvbHeight = viewBounds.getHeight(),
      rvWidth = viewer.w,
      rvHeight = viewer.h; //用户自定义地图的Options时，若未指定该参数的值，则系统默认为6378137米，即WGS84参考系的椭球体长半轴。

  datumAxis = datumAxis || 6378137;
  coordUnit = coordUnit || "degrees";
  var dpi;

  if (coordUnit.toLowerCase() === "degree" || coordUnit.toLowerCase() === "degrees" || coordUnit.toLowerCase() === "dd") {
    var num1 = rvbWidth / rvWidth,
        num2 = rvbHeight / rvHeight,
        resolution = num1 > num2 ? num1 : num2;
    dpi = 0.0254 * ratio / resolution / scale / (Math.PI * 2 * datumAxis / 360) / ratio;
  } else {
    var _resolution = rvbWidth / rvWidth;

    dpi = 0.0254 * ratio / _resolution / scale / ratio;
  }

  return dpi;
};
/**
 * @description 将对象转换成 JSON 字符串。
 * @param {Object} obj - 要转换成 JSON 的 Object 对象。
 * @returns {string} 返回转换后的 JSON 对象。
 */


SuperMap.Util.toJSON = function (obj) {
  var objInn = obj;

  if (objInn == null) {
    return null;
  }

  switch (objInn.constructor) {
    case String:
      //s = "'" + str.replace(/(["\\])/g, "\\$1") + "'";   string含有单引号出错
      objInn = '"' + objInn.replace(/(["\\])/g, '\\$1') + '"';
      objInn = objInn.replace(/\n/g, "\\n");
      objInn = objInn.replace(/\r/g, "\\r");
      objInn = objInn.replace("<", "&lt;");
      objInn = objInn.replace(">", "&gt;");
      objInn = objInn.replace(/%/g, "%25");
      objInn = objInn.replace(/&/g, "%26");
      return objInn;

    case Array:
      var arr = [];

      for (var i = 0, len = objInn.length; i < len; i++) {
        arr.push(SuperMap.Util.toJSON(objInn[i]));
      }

      return "[" + arr.join(",") + "]";

    case Number:
      return isFinite(objInn) ? String(objInn) : null;

    case Boolean:
      return String(objInn);

    case Date:
      var dateStr = "{" + "'__type':\"System.DateTime\"," + "'Year':" + objInn.getFullYear() + "," + "'Month':" + (objInn.getMonth() + 1) + "," + "'Day':" + objInn.getDate() + "," + "'Hour':" + objInn.getHours() + "," + "'Minute':" + objInn.getMinutes() + "," + "'Second':" + objInn.getSeconds() + "," + "'Millisecond':" + objInn.getMilliseconds() + "," + "'TimezoneOffset':" + objInn.getTimezoneOffset() + "}";
      return dateStr;

    default:
      if (objInn["toJSON"] != null && typeof objInn["toJSON"] === "function") {
        return objInn.toJSON();
      }

      if (_typeof(objInn) === "object") {
        if (objInn.length) {
          var _arr2 = [];

          for (var _i = 0, _len = objInn.length; _i < _len; _i++) {
            _arr2.push(SuperMap.Util.toJSON(objInn[_i]));
          }

          return "[" + _arr2.join(",") + "]";
        }

        var _arr = [];

        for (var attr in objInn) {
          //为解决SuperMap.Geometry类型头json时堆栈溢出的问题，attr == "parent"时不进行json转换
          if (typeof objInn[attr] !== "function" && attr !== "CLASS_NAME" && attr !== "parent") {
            _arr.push("'" + attr + "':" + SuperMap.Util.toJSON(objInn[attr]));
          }
        }

        if (_arr.length > 0) {
          return "{" + _arr.join(",") + "}";
        } else {
          return "{}";
        }
      }

      return objInn.toString();
  }
};
/**
 * @description 根据比例尺和 dpi 计算屏幕分辨率。
 * @param {number} scale - 比例尺。
 * @param {number} dpi - 图像分辨率，表示每英寸内的像素个数。
 * @param {string} [coordUnit] - 投影坐标系统的地图单位。
 * @param {number} [datumAxis=6378137] - 地理坐标系统椭球体长半轴。用户自定义地图的 Options 时，若未指定该参数的值，则 DPI 默认按照 WGS84 参考系的椭球体长半轴 6378137 来计算。
 * @returns {number} 返回当前比例尺下的屏幕分辨率。
 */


SuperMap.Util.getResolutionFromScaleDpi = function (scale, dpi, coordUnit, datumAxis) {
  var resolution = null,
      ratio = 10000; //用户自定义地图的Options时，若未指定该参数的值，则系统默认为6378137米，即WGS84参考系的椭球体长半轴。

  datumAxis = datumAxis || 6378137;
  coordUnit = coordUnit || "";

  if (scale > 0 && dpi > 0) {
    scale = SuperMap.Util.normalizeScale(scale);

    if (coordUnit.toLowerCase() === "degree" || coordUnit.toLowerCase() === "degrees" || coordUnit.toLowerCase() === "dd") {
      //scale = SuperMap.Util.normalizeScale(scale);
      resolution = 0.0254 * ratio / dpi / scale / (Math.PI * 2 * datumAxis / 360) / ratio;
      return resolution;
    } else {
      resolution = 0.0254 * ratio / dpi / scale / ratio;
      return resolution;
    }
  }

  return -1;
};
/**
 * @description 根据 resolution、dpi、coordUnit 和 datumAxis 计算比例尺。
 * @param {number} resolution - 用于计算比例尺的地图分辨率。
 * @param {number} dpi - 图像分辨率，表示每英寸内的像素个数。
 * @param {string} [coordUnit] - 投影坐标系统的地图单位。
 * @param {number} [datumAxis=6378137] - 地理坐标系统椭球体长半轴。用户自定义地图的 Options 时，若未指定该参数的值，则 DPI 默认按照 WGS84 参考系的椭球体长半轴 6378137 来计算。
 * @returns {number} 返回当前屏幕分辨率下的比例尺。
 */


SuperMap.Util.getScaleFromResolutionDpi = function (resolution, dpi, coordUnit, datumAxis) {
  var scale = null,
      ratio = 10000; //用户自定义地图的Options时，若未指定该参数的值，则系统默认为6378137米，即WGS84参考系的椭球体长半轴。

  datumAxis = datumAxis || 6378137;
  coordUnit = coordUnit || "";

  if (resolution > 0 && dpi > 0) {
    if (coordUnit.toLowerCase() === "degree" || coordUnit.toLowerCase() === "degrees" || coordUnit.toLowerCase() === "dd") {
      scale = 0.0254 * ratio / dpi / resolution / (Math.PI * 2 * datumAxis / 360) / ratio;
      return scale;
    } else {
      scale = 0.0254 * ratio / dpi / resolution / ratio;
      return scale;
    }
  }

  return -1;
};
/**
 * @description 转换查询结果。
 * @param {Object} result - 查询结果。
 * @returns {Object} 转换后的查询结果。
 */


SuperMap.Util.transformResult = function (result) {
  if (result.responseText && typeof result.responseText === "string") {
    result = JSON.parse(result.responseText);
  }

  return result;
};
/**
 * @description 属性拷贝，不拷贝方法类名(CLASS_NAME)等。
 * @param {Object} [destination] - 拷贝目标。
 * @param {Object} source - 源对象。
 *
 */


SuperMap.Util.copyAttributes = function (destination, source) {
  destination = destination || {};

  if (source) {
    for (var property in source) {
      var value = source[property];

      if (value !== undefined && property !== "CLASS_NAME" && typeof value !== "function") {
        destination[property] = value;
      }
    }
  }

  return destination;
};
/**
 * @description 将源对象上的属性拷贝到目标对象上。（不拷贝 CLASS_NAME 和方法）
 * @param {Object} [destination] - 目标对象。
 * @param {Object} source - 源对象。
 * @param {Array.<string>} clip - 源对象中禁止拷贝到目标对象的属性，目的是防止目标对象上不可修改的属性被篡改。
 *
 */


SuperMap.Util.copyAttributesWithClip = function (destination, source, clip) {
  destination = destination || {};

  if (source) {
    for (var property in source) {
      //去掉禁止拷贝的属性
      var isInClip = false;

      if (clip && clip.length) {
        for (var i = 0, len = clip.length; i < len; i++) {
          if (property === clip[i]) {
            isInClip = true;
            break;
          }
        }
      }

      if (isInClip === true) {
        continue;
      }

      var value = source[property];

      if (value !== undefined && property !== "CLASS_NAME" && typeof value !== "function") {
        destination[property] = value;
      }
    }
  }

  return destination;
};
/**
 * @description 克隆一个 Object 对象
 * @param {Object} obj - 需要克隆的对象。
 * @returns {Object} 返回对象的拷贝对象，注意是新的对象，不是指向。
 */


SuperMap.Util.cloneObject = function (obj) {
  // Handle the 3 simple types, and null or undefined
  if (null === obj || "object" !== _typeof(obj)) {
    return obj;
  } // Handle Date


  if (obj instanceof Date) {
    var copy = new Date();
    copy.setTime(obj.getTime());
    return copy;
  } // Handle Array


  if (obj instanceof Array) {
    var _copy = obj.slice(0);

    return _copy;
  } // Handle Object


  if (obj instanceof Object) {
    var _copy2 = {};

    for (var attr in obj) {
      if (obj.hasOwnProperty(attr)) {
        _copy2[attr] = SuperMap.Util.cloneObject(obj[attr]);
      }
    }

    return _copy2;
  }

  throw new Error("Unable to copy obj! Its type isn't supported.");
};
/**
 * @description 判断两条线段是不是有交点。
 * @param {SuperMap.Geometry.Point} a1 - 第一条线段的起始节点。
 * @param {SuperMap.Geometry.Point} a2 - 第一条线段的结束节点。
 * @param {SuperMap.Geometry.Point} b1 - 第二条线段的起始节点。
 * @param {SuperMap.Geometry.Point} b2 - 第二条线段的结束节点。
 * @returns {Object} 如果相交返回交点，如果不相交返回两条线段的位置关系。
 */


SuperMap.Util.lineIntersection = function (a1, a2, b1, b2) {
  var intersectValue = null;
  var k1;
  var k2;
  var b = (b2.x - b1.x) * (a1.y - b1.y) - (b2.y - b1.y) * (a1.x - b1.x);
  var a = (a2.x - a1.x) * (a1.y - b1.y) - (a2.y - a1.y) * (a1.x - b1.x);
  var ab = (b2.y - b1.y) * (a2.x - a1.x) - (b2.x - b1.x) * (a2.y - a1.y); //ab==0代表两条线断的斜率一样

  if (ab != 0) {
    k1 = b / ab;
    k2 = a / ab;

    if (k1 >= 0 && k2 <= 1 && k1 <= 1 && k2 >= 0) {
      intersectValue = new SuperMap.Geometry.Point(a1.x + k1 * (a2.x - a1.x), a1.y + k1 * (a2.y - a1.y));
    } else {
      intersectValue = "No Intersection";
    }
  } else {
    if (b == 0 && a == 0) {
      var maxy = Math.max(a1.y, a2.y);
      var miny = Math.min(a1.y, a2.y);
      var maxx = Math.max(a1.x, a2.x);
      var minx = Math.min(a1.x, a2.x);

      if ((b1.y >= miny && b1.y <= maxy || b2.y >= miny && b2.y <= maxy) && b1.x >= minx && b1.x <= maxx || b2.x >= minx && b2.x <= maxx) {
        intersectValue = "Coincident"; //重合
      } else {
        intersectValue = "Parallel"; //平行
      }
    } else {
      intersectValue = "Parallel"; //平行
    }
  }

  return intersectValue;
};
/**
 * @description 获取文本外接矩形宽度与高度。
 * @param {SuperMap.ThemeStyle} style - 文本样式。
 * @param {string} text - 文本内容。
 * @param {Object} element - DOM 元素。
 * @returns {Object} 返回裁剪后的宽度，高度信息。
 */


SuperMap.Util.getTextBounds = function (style, text, element) {
  document.body.appendChild(element);
  element.style.width = 'auto';
  element.style.height = 'auto';

  if (style.fontSize) {
    element.style.fontSize = style.fontSize;
  }

  if (style.fontFamily) {
    element.style.fontFamily = style.fontFamily;
  }

  if (style.fontWeight) {
    element.style.fontWeight = style.fontWeight;
  }

  element.style.position = 'relative';
  element.style.visibility = 'hidden'; //fix 在某些情况下，element内的文本变成竖起排列，导致宽度计算不正确的bug

  element.style.display = 'inline-block';
  element.innerHTML = text;
  var textWidth = element.clientWidth;
  var textHeight = element.clientHeight;
  document.body.removeChild(element);
  return {
    textWidth: textWidth,
    textHeight: textHeight
  };
};
// CONCATENATED MODULE: ./src/common/commontypes/LonLat.js
function LonLat_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function LonLat_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function LonLat_createClass(Constructor, protoProps, staticProps) { if (protoProps) LonLat_defineProperties(Constructor.prototype, protoProps); if (staticProps) LonLat_defineProperties(Constructor, staticProps); return Constructor; }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/

/**
 * @class SuperMap.LonLat
 * @category BaseTypes Geometry
 * @classdesc  这个类用来表示经度和纬度对。
 * @param {number} [lon=0.0] - 地图单位上的 X 轴坐标，如果地图是地理投影，则此值是经度，否则，此值是地图地理位置的 x 坐标。
 * @param {number} [lat=0.0] - 地图单位上的 Y 轴坐标，如果地图是地理投影，则此值是纬度，否则，此值是地图地理位置的 y 坐标。
 * @param {Array.<float>} [location] - 如果要同时设置，则使用传入横纵坐标组成的数组。
 * @example
 * var lonLat = new SuperMap.LonLat(30,45);
 */

var LonLat_LonLat =
/*#__PURE__*/
function () {
  function LonLat(lon, lat) {
    LonLat_classCallCheck(this, LonLat);

    if (Util.isArray(lon)) {
      lat = lon[1];
      lon = lon[0];
    }
    /**
     * @member {float} [SuperMap.LonLat.prototype.lon=0.0]
     * @description 地图的单位的 X 轴（横轴）坐标。
     */


    this.lon = lon ? Util.toFloat(lon) : 0.0;
    /**
     * @member {float} [SuperMap.LonLat.prototype.lat=0.0]
     * @description 地图的单位的 Y 轴（纵轴）坐标。
     */

    this.lat = lat ? Util.toFloat(lat) : 0.0;
    this.CLASS_NAME = "SuperMap.LonLat";
  }
  /**
   * @function SuperMap.LonLat.prototype.toString
   * @description 返回此对象的字符串形式
   * @example
   * var lonLat = new SuperMap.LonLat(100,50);
   * var str = lonLat.toString();
   * @returns {string} 例如: "lon=100,lat=50"
   */


  LonLat_createClass(LonLat, [{
    key: "toString",
    value: function toString() {
      return "lon=" + this.lon + ",lat=" + this.lat;
    }
    /**
     * @function SuperMap.LonLat.prototype.toShortString
     * @description 将经度纬度转换成简单字符串。
     * @example
     * var lonLat = new SuperMap.LonLat(100,50);
     * var str = lonLat.toShortString();
     * @returns {string} 返回处理后的经纬度字符串。例如："100,50"
     */

  }, {
    key: "toShortString",
    value: function toShortString() {
      return this.lon + "," + this.lat;
    }
    /**
     * @function SuperMap.LonLat.prototype.clone
     * @description 复制坐标对象，并返回复制后的新对象。
     * @example
     * var lonLat1 = new SuperMap.LonLat(100,50);
     * var lonLat2 = lonLat1.clone();
     * @returns {SuperMap.LonLat}  返回相同坐标值的新的坐标对象。
     */

  }, {
    key: "clone",
    value: function clone() {
      return new LonLat(this.lon, this.lat);
    }
    /**
     * @function SuperMap.LonLat.prototype.add
     * @description 在已有坐标对象的经纬度基础上加上新的坐标经纬度，并返回新的坐标对象。
     * @example
     * var lonLat1 = new SuperMap.LonLat(100,50);
     * //lonLat2 是新的对象
     * var lonLat2 = lonLat1.add(100,50);
     * @param {float} lon - 传入的经度参数。
     * @param {float} lat - 传入的纬度参数。
     * @returns {SuperMap.LonLat} 返回一个新的 LonLat 对象，此对象的经纬度是由传入的经纬度与当前的经纬度相加所得。
     */

  }, {
    key: "add",
    value: function add(lon, lat) {
      if (lon == null || lat == null) {
        throw new TypeError('LonLat.add cannot receive null values');
      }

      return new LonLat(this.lon + Util.toFloat(lon), this.lat + Util.toFloat(lat));
    }
    /**
     * @function SuperMap.LonLat.prototype.equals
     * @description 判断两个坐标对象是否相等。
     * @example
     * var lonLat1 = new SuperMap.LonLat(100,50);
     * var lonLat2 = new SuperMap.LonLat(100,50);
     * var isEquals = lonLat1.equals(lonLat2);
     * @param {SuperMap.LonLat} ll - 需要进行比较的坐标对象。
     * @returns {boolean} 如果LonLat对象的经纬度和传入的经纬度一致则返回true,不一
     *      致或传入的ll参数为NULL则返回false。
     */

  }, {
    key: "equals",
    value: function equals(ll) {
      var equals = false;

      if (ll != null) {
        equals = this.lon === ll.lon && this.lat === ll.lat || isNaN(this.lon) && isNaN(this.lat) && isNaN(ll.lon) && isNaN(ll.lat);
      }

      return equals;
    }
    /**
     * @function SuperMap.LonLat.prototype.wrapDateLine
     * @description 通过传入的范围对象对坐标对象转换到该范围内。
     * 如果经度小于给定范围最小精度，则在原经度基础上加上范围宽度，直到精度在范围内为止，如果经度大于给定范围则在原经度基础上减去范围宽度。
     * 即指将不在经度范围内的坐标转换到范围以内（只会转换 lon，不会转换 lat，主要用于转移到日界线以内）。
     * @example
     * var lonLat1 = new SuperMap.LonLat(420,50);
     * var lonLat2 = lonLat1.wrapDateLine(
     *      new SuperMap.Bounds(-180,-90,180,90)
     *  );
     * @param {SuperMap.Bounds} maxExtent - 最大边界的范围。
     * @returns {SuperMap.LonLat} 将坐标转换到范围对象以内，并返回新的坐标。
     */

  }, {
    key: "wrapDateLine",
    value: function wrapDateLine(maxExtent) {
      var newLonLat = this.clone();

      if (maxExtent) {
        //shift right?
        while (newLonLat.lon < maxExtent.left) {
          newLonLat.lon += maxExtent.getWidth();
        } //shift left?


        while (newLonLat.lon > maxExtent.right) {
          newLonLat.lon -= maxExtent.getWidth();
        }
      }

      return newLonLat;
    }
    /**
     *
     * @function SuperMap.LonLat.prototype.destroy
     * @description 销毁此对象。
     * 销毁后此对象的所有属性为 null，而不是初始值。
     * @example
     * var lonLat = new SuperMap.LonLat(100,50);
     * lonLat.destroy();
     */

  }, {
    key: "destroy",
    value: function destroy() {
      this.lon = null;
      this.lat = null;
    }
    /**
     * @function SuperMap.LonLat.fromString
     * @description 通过字符串生成一个 {@link SuperMap.LonLat} 对象。
     * @example
     * var str = "100,50";
     * var lonLat = SuperMap.LonLat.fromString(str);
     * @param {string} str - 字符串的格式：Lon+","+Lat。如："100,50"。
     * @returns {SuperMap.LonLat} 返回一个 {@link SuperMap.LonLat} 对象。
     */

  }], [{
    key: "fromString",
    value: function fromString(str) {
      var pair = str.split(",");
      return new LonLat(pair[0], pair[1]);
    }
    /**
     * @function SuperMap.LonLat.fromArray
     * @description 通过数组生成一个 <SuperMap.LonLat> 对象。
     * @param {Array.<float>} arr - 数组的格式，长度只能为2,：[Lon,Lat]。如：[5,-42]。
     * @returns {SuperMap.LonLat} 返回一个 <SuperMap.LonLat> 对象。
     */

  }, {
    key: "fromArray",
    value: function fromArray(arr) {
      var gotArr = Util.isArray(arr),
          lon = gotArr && arr[0],
          lat = gotArr && arr[1];
      return new LonLat(lon, lat);
    }
  }]);

  return LonLat;
}();
// CONCATENATED MODULE: ./src/common/commontypes/Bounds.js
function Bounds_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function Bounds_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function Bounds_createClass(Constructor, protoProps, staticProps) { if (protoProps) Bounds_defineProperties(Constructor.prototype, protoProps); if (staticProps) Bounds_defineProperties(Constructor, staticProps); return Constructor; }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/





/**
 * @class SuperMap.Bounds
 * @category BaseTypes Geometry
 * @classdesc 表示边界类实例。使用 bounds 之前需要设置 left，bottom，right，top 四个属性，这些属性的初始值为 null。
 * @param {number} [left] - 左边界，注意考虑宽度，理论上小于 right 值。
 * @param {number} [bottom] - 下边界。考虑高度，理论上小于 top 值。
 * @param {number} [right] - 右边界。
 * @param {number} [top] - 上边界。
 * @param {Array.<number>} [array] - [left, bottom, right, top]，如果同时传多个参数，则使用左下右上组成的数组。
 * @example
 * var bounds = new SuperMap.Bounds();
 * bounds.extend(new SuperMap.LonLat(4,5));
 * bounds.extend(new SuperMap.LonLat(5,6));
 * bounds.toBBOX(); // returns 4,5,5,6
 */

var Bounds_Bounds =
/*#__PURE__*/
function () {
  function Bounds(left, bottom, right, top) {
    Bounds_classCallCheck(this, Bounds);

    if (Util.isArray(left)) {
      top = left[3];
      right = left[2];
      bottom = left[1];
      left = left[0];
    }
    /**
     * @member {number} SuperMap.Bounds.prototype.left
     * @description 最小的水平坐标系。
     */


    this.left = left != null ? Util.toFloat(left) : this.left;
    /**
     * @member {number} SuperMap.Bounds.prototype.bottom
     * @description 最小的垂直坐标系。
     */

    this.bottom = bottom != null ? Util.toFloat(bottom) : this.bottom;
    /**
     * @member {number} SuperMap.Bounds.prototype.right
     * @description 最大的水平坐标系。
     */

    this.right = right != null ? Util.toFloat(right) : this.right;
    /**
     * @member {number} SuperMap.Bounds.prototype.top
     * @description 最大的垂直坐标系。
     */

    this.top = top != null ? Util.toFloat(top) : this.top;
    /**
     * @member {SuperMap.LonLat} SuperMap.Bounds.prototype.centerLonLat
     * @description bounds 的地图空间的中心点。用 getCenterLonLat() 获得。
     */

    this.centerLonLat = null;
    this.CLASS_NAME = "SuperMap.Bounds";
  }
  /**
   * @function SuperMap.Bounds.prototype.clone
   * @description 复制当前 bounds 对象。
   * @example
   * var bounds1 = new SuperMap.Bounds(-180,-90,180,90);
   * var bounds2 = bounds1.clone();
   * @returns {SuperMap.Bounds} 返回一个克隆的 bounds。
   */


  Bounds_createClass(Bounds, [{
    key: "clone",
    value: function clone() {
      return new Bounds(this.left, this.bottom, this.right, this.top);
    }
    /**
     * @function SuperMap.Bounds.prototype.equals
     * @description 判断两个 bounds 对象是否相等。
     * @example
     * var bounds1 = new SuperMap.Bounds(-180,-90,180,90);
     * var bounds2 = new SuperMap.Bounds(-180,-90,180,90);
     * var isEquals = bounds1.equals(bounds2);
     * @param {SuperMap.Bounds} bounds - 需要进行计较的 bounds。
     * @returns {boolean} 如果 bounds 对象的边和传入的 bounds 一致则返回 true，不一致或传入的 bounds 参数为 NULL 则返回 false。
     */

  }, {
    key: "equals",
    value: function equals(bounds) {
      var equals = false;

      if (bounds != null) {
        equals = this.left === bounds.left && this.right === bounds.right && this.top === bounds.top && this.bottom === bounds.bottom;
      }

      return equals;
    }
    /**
     * @function SuperMap.Bounds.prototype.toString
     * @description 返回此对象的字符串形式。
     * @example
     * var bounds = new SuperMap.Bounds(-180,-90,180,90);
     * var str = bounds.toString();
     * @returns {string} 边界对象的字符串表示形式（left,bottom,right,top），例如: "-180,-90,180,90"。
     */

  }, {
    key: "toString",
    value: function toString() {
      return [this.left, this.bottom, this.right, this.top].join(",");
    }
    /**
     * @function SuperMap.Bounds.prototype.toArray
     * @description 边界对象的数组表示形式。
     * @example
     * var bounds = new SuperMap.Bounds(-180,-90,100,80);
     * //array1 = [-180,-90,100,80];
     * var array1 = bounds.toArray();
     * //array1 = [-90,-180,80,100];
     * var array2 = bounds.toArray(true);
     * @param {boolean} [reverseAxisOrder=false] - 是否反转轴顺序。
     * 如果设为 true，则倒转顺序（bottom,left,top,right），否则按正常轴顺序（left,bottom,right,top）。
     * @returns {Array.<number>} left, bottom, right, top 数组。
     */

  }, {
    key: "toArray",
    value: function toArray(reverseAxisOrder) {
      if (reverseAxisOrder === true) {
        return [this.bottom, this.left, this.top, this.right];
      } else {
        return [this.left, this.bottom, this.right, this.top];
      }
    }
    /**
     * @function SuperMap.Bounds.prototype.toBBOX
     * @description 取小数点后 decimal 位数字进行四舍五入再转换为 BBOX 字符串。
     * @example
     * var bounds = new SuperMap.Bounds(-1.1234567,-1.7654321,1.4444444,1.5555555);
     * //str1 = "-1.123457,-1.765432,1.444444,1.555556";
     * var str1 = bounds.toBBOX();
     * //str2 = "-1.1,-1.8,1.4,1.6";
     * var str2 = bounds.toBBOX(1);
     * //str2 = "-1.8,-1.1,1.6,1.4";
     * var str2 = bounds.toBBOX(1,true);
     * @param {integer} [decimal=6] - 边界方位坐标的有效数字个数。
     * @param {boolean} [reverseAxisOrder=false] - 是否是反转轴顺序。
     * 如果设为true，则倒转顺序（bottom,left,top,right）,否则按正常轴顺序（left,bottom,right,top）。
     * @returns {string} 边界对象的字符串表示形式，如："5,42,10,45"。
     */

  }, {
    key: "toBBOX",
    value: function toBBOX(decimal, reverseAxisOrder) {
      if (decimal == null) {
        decimal = 6;
      }

      var mult = Math.pow(10, decimal);
      var xmin = Math.round(this.left * mult) / mult;
      var ymin = Math.round(this.bottom * mult) / mult;
      var xmax = Math.round(this.right * mult) / mult;
      var ymax = Math.round(this.top * mult) / mult;

      if (reverseAxisOrder === true) {
        return ymin + "," + xmin + "," + ymax + "," + xmax;
      } else {
        return xmin + "," + ymin + "," + xmax + "," + ymax;
      }
    }
    /**
     * @function SuperMap.Bounds.prototype.toGeometry
     * @description 基于当前边界范围创建一个新的多边形对象。
     * @example
     * var bounds = new SuperMap.Bounds(-180,-90,100,80);
     * //SuperMap.Geometry.Polygon对象
     * var geo = bounds.toGeometry();
     * @returns {SuperMap.Geometry.Polygon} 基于当前 bounds 坐标创建的新的多边形。
     */
    // toGeometry() {
    //     return new Polygon([
    //         new LinearRing([
    //             new Point(this.left, this.bottom),
    //             new Point(this.right, this.bottom),
    //             new Point(this.right, this.top),
    //             new Point(this.left, this.top)
    //         ])
    //     ]);
    // }

    /**
     * @function SuperMap.Bounds.prototype.getWidth
     * @description 获取 bounds 的宽度。
     * @example
     * var bounds = new SuperMap.Bounds(-180,-90,100,80);
     * //width = 280;
     * var width = bounds.getWidth();
     * @returns {float} 获取当前 bounds 的宽度（right 减去 left）。
     */

  }, {
    key: "getWidth",
    value: function getWidth() {
      return this.right - this.left;
    }
    /**
     * @function SuperMap.Bounds.prototype.getHeight
     * @description 获取 bounds 的高度。
     * @example
     * var bounds = new SuperMap.Bounds(-180,-90,100,80);
     * //height = 170;
     * var height = bounds.getHeight();
     * @returns {float} 返回边界高度（top 减去 bottom）。
     */

  }, {
    key: "getHeight",
    value: function getHeight() {
      return this.top - this.bottom;
    }
    /**
     * @function SuperMap.Bounds.prototype.getSize
     * @description 获取边框大小。
     * @example
     * var bounds = new SuperMap.Bounds(-180,-90,100,80);
     * var size = bounds.getSize();
     * @returns {SuperMap.Size} 返回边框大小。
     */

  }, {
    key: "getSize",
    value: function getSize() {
      return new Size(this.getWidth(), this.getHeight());
    }
    /**
     * @function SuperMap.Bounds.prototype.getCenterPixel
     * @description 获取像素格式的范围中心点。
     * @example
     * var bounds = new SuperMap.Bounds(-180,-90,100,80);
     * var pixel = bounds.getCenterPixel();
     * @returns {SuperMap.Pixel} 返回像素格式的当前范围的中心点。
     */

  }, {
    key: "getCenterPixel",
    value: function getCenterPixel() {
      return new Pixel_Pixel((this.left + this.right) / 2, (this.bottom + this.top) / 2);
    }
    /**
     * @function SuperMap.Bounds.prototype.getCenterLonLat
     * @description 获取地理格式的范围中心点。
     * @example
     * var bounds = new SuperMap.Bounds(-180,-90,100,80);
     * var lonlat = bounds.getCenterLonLat();
     * @returns {SuperMap.LonLat} 返回当前地理范围的中心点。
     */

  }, {
    key: "getCenterLonLat",
    value: function getCenterLonLat() {
      if (!this.centerLonLat) {
        this.centerLonLat = new LonLat_LonLat((this.left + this.right) / 2, (this.bottom + this.top) / 2);
      }

      return this.centerLonLat;
    }
    /**
     * @function SuperMap.Bounds.prototype.scale
     * @description 按照比例扩大/缩小出一个新的 bounds。
     * @example
     * var bounds = new SuperMap.Bounds(-50,-50,40,40);
     * var bounds2 = bounds.scale(2);
     * @param {float} [ratio=1] - 需要扩大的比例。
     * @param {(SuperMap.Pixel|SuperMap.LonLat)} [origin] - 扩大时的基准点，默认为当前 bounds 的中心点。
     * @returns {SuperMap.Bounds} 返回通过 ratio、origin 计算得到的新的边界范围。
     */

  }, {
    key: "scale",
    value: function scale(ratio, origin) {
      ratio = ratio ? ratio : 1;

      if (origin == null) {
        origin = this.getCenterLonLat();
      }

      var origx, origy; // get origin coordinates

      if (origin.CLASS_NAME === "SuperMap.LonLat") {
        origx = origin.lon;
        origy = origin.lat;
      } else {
        origx = origin.x;
        origy = origin.y;
      }

      var left = (this.left - origx) * ratio + origx;
      var bottom = (this.bottom - origy) * ratio + origy;
      var right = (this.right - origx) * ratio + origx;
      var top = (this.top - origy) * ratio + origy;
      return new Bounds(left, bottom, right, top);
    }
    /**
     * @function SuperMap.Bounds.prototype.add
     * @description 在当前的 Bounds 上按照传入的坐标点进行平移，返回新的范围。
     * @example
     * var bounds1 = new SuperMap.Bounds(-50,-50,40,40);
     * //bounds2 是新的 bounds
     * var bounds2 = bounds.add(20,10);
     * @param {float} x - 传入坐标点的 x 坐标。
     * @param {float} y - 传入坐标点的 y 坐标。
     * @returns {SuperMap.Bounds} 返回一个新的 bounds，此 bounds 的坐标是由传入的 x，y 参数与当前 bounds 坐标计算所得。
     */

  }, {
    key: "add",
    value: function add(x, y) {
      if (x == null || y == null) {
        throw new TypeError('Bounds.add cannot receive null values');
      }

      return new Bounds(this.left + x, this.bottom + y, this.right + x, this.top + y);
    }
    /**
     * @function SuperMap.Bounds.prototype.extend
     * @description 在当前 bounds 上扩展 bounds，支持 point，lanlat 和 bounds。扩展后的 bounds 的范围是两者的结合。
     * @example
     * var bounds1 = new SuperMap.Bounds(-50,-50,40,40);
     * //bounds 改变
     * bounds.extend(new SuperMap.LonLat(50,60));
     * @param {(SuperMap.Geometry.Point|SuperMap.LonLat|SuperMap.Bounds)} object - 可以是 point、lonlat 和 bounds。
     */

  }, {
    key: "extend",
    value: function extend(object) {
      var bounds = null;

      if (object) {
        // clear cached center location
        switch (object.CLASS_NAME) {
          case "SuperMap.LonLat":
            bounds = new Bounds(object.lon, object.lat, object.lon, object.lat);
            break;

          case "SuperMap.Geometry.Point":
            bounds = new Bounds(object.x, object.y, object.x, object.y);
            break;

          case "SuperMap.Bounds":
            bounds = object;
            break;
        }

        if (bounds) {
          this.centerLonLat = null;

          if (this.left == null || bounds.left < this.left) {
            this.left = bounds.left;
          }

          if (this.bottom == null || bounds.bottom < this.bottom) {
            this.bottom = bounds.bottom;
          }

          if (this.right == null || bounds.right > this.right) {
            this.right = bounds.right;
          }

          if (this.top == null || bounds.top > this.top) {
            this.top = bounds.top;
          }
        }
      }
    }
    /**
     * @function SuperMap.Bounds.prototype.containsLonLat
     * @description 判断传入的坐标是否在范围内。
     * @example
     * var bounds1 = new SuperMap.Bounds(-50,-50,40,40);
     * //isContains1 = true
     * //这里的第二个参数可以直接为 boolean 类型，也就是inclusive
     * var isContains1 = bounds.containsLonLat(new SuperMap.LonLat(40,40),true);
     *
     * //(40,40)在范围内，同样(40+360,40)也在范围内
     * var bounds2 = new SuperMap.Bounds(-50,-50,40,40);
     * //isContains2 = true;
     * var isContains2 = bounds2.containsLonLat(
     *      new SuperMap.LonLat(400,40),
     *      {
     *           inclusive:true,
     *           //全球的范围
     *           worldBounds: new SuperMap.Bounds(-180,-90,180,90)
     *      }
     * );
     * @param {(SuperMap.LonLat|Object)} ll - <SuperMap.LonLat> 对象或者是一个包含 'lon' 与 'lat' 属性的对象。
     * @param {Object} options - 可选参数。
     * @param {boolean} [options.inclusive=true] - 是否包含边界。
     * @param {SuperMap.Bounds} [options.worldBounds] - 如果提供 worldBounds 参数, 如果 ll 参数提供的坐标超出了世界边界（worldBounds），
     *        但是通过日界线的转化可以被包含, 它将被认为是包含在该范围内的。
     * @returns {boolean} 传入坐标是否包含在范围内。
     */

  }, {
    key: "containsLonLat",
    value: function containsLonLat(ll, options) {
      if (typeof options === "boolean") {
        options = {
          inclusive: options
        };
      }

      options = options || {};
      var contains = this.contains(ll.lon, ll.lat, options.inclusive),
          worldBounds = options.worldBounds; //日界线以外的也有可能算包含，

      if (worldBounds && !contains) {
        var worldWidth = worldBounds.getWidth();
        var worldCenterX = (worldBounds.left + worldBounds.right) / 2; //这一步很关键

        var worldsAway = Math.round((ll.lon - worldCenterX) / worldWidth);
        contains = this.containsLonLat({
          lon: ll.lon - worldsAway * worldWidth,
          lat: ll.lat
        }, {
          inclusive: options.inclusive
        });
      }

      return contains;
    }
    /**
     * @function SuperMap.Bounds.prototype.containsPixel
     * @description 判断传入的像素是否在范围内。直接匹配大小，不涉及像素和地理转换。
     * @example
     * var bounds = new SuperMap.Bounds(-50,-50,40,40);
     * //isContains = true
     * var isContains = bounds.containsPixel(new SuperMap.Pixel(40,40),true);
     * @param {SuperMap.Pixel} px - 提供的像素参数。
     * @param {boolean} [inclusive=true] - 是否包含边界。
     * @returns {boolean} 传入的 pixel 在当前边界范围之内。
     */

  }, {
    key: "containsPixel",
    value: function containsPixel(px, inclusive) {
      return this.contains(px.x, px.y, inclusive);
    }
    /**
     * @function SuperMap.Bounds.prototype.contains
     * @description 判断传入的 x，y 坐标值是否在范围内。
     * @example
     * var bounds = new SuperMap.Bounds(-50,-50,40,40);
     * //isContains = true
     * var isContains = bounds.contains(40,40,true);
     * @param {float} x - 传入的 x 坐标值。
     * @param {float} y - 传入的 y 坐标值。
     * @param {boolean} [inclusive=true] - 是否包含边界。
     * @returns {boolean} 传入的 x，y 坐标是否在当前范围内。
     */

  }, {
    key: "contains",
    value: function contains(x, y, inclusive) {
      //set default
      if (inclusive == null) {
        inclusive = true;
      }

      if (x == null || y == null) {
        return false;
      } //x = Util.toFloat(x);
      //y = Util.toFloat(y);


      var contains = false;

      if (inclusive) {
        contains = x >= this.left && x <= this.right && y >= this.bottom && y <= this.top;
      } else {
        contains = x > this.left && x < this.right && y > this.bottom && y < this.top;
      }

      return contains;
    }
    /**
     * @function SuperMap.Bounds.prototype.intersectsBounds
     * @description 判断目标边界范围是否与当前边界范围相交。如果两个边界范围中的任意
     *              边缘相交或者一个边界包含了另外一个就认为这两个边界相交。
     * @example
     * var bounds = new SuperMap.Bounds(-180,-90,100,80);
     * var isIntersects = bounds.intersectsBounds(
     *      new SuperMap.Bounds(-170,-90,120,80)
     *  );
     * @param {SuperMap.Bounds} bounds - 目标边界。
     * @param {Object} options - 参数。
     * @param {boolean} [options.inclusive=true] - 边缘重合也看成相交。如果是false，
     *                               两个边界范围没有重叠部分仅仅是在边缘相接（重合），
     *                               这种情况被认为没有相交。
     * @param {SuperMap.Bounds} [options.worldBounds] - 提供了 worldBounds 参数, 如果他们相交时
     *                               是在全球范围内, 两个边界将被视为相交。这仅适用于交叉或完全不在世界范围的边界。
     * @returns {boolean} 传入的 bounds 对象与当前 bounds 相交。
     */

  }, {
    key: "intersectsBounds",
    value: function intersectsBounds(bounds, options) {
      if (typeof options === "boolean") {
        options = {
          inclusive: options
        };
      }

      options = options || {};

      if (options.worldBounds) {
        var self = this.wrapDateLine(options.worldBounds);
        bounds = bounds.wrapDateLine(options.worldBounds);
      } else {
        self = this;
      }

      if (options.inclusive == null) {
        options.inclusive = true;
      }

      var intersects = false;
      var mightTouch = self.left === bounds.right || self.right === bounds.left || self.top === bounds.bottom || self.bottom === bounds.top; // if the two bounds only touch at an edge, and inclusive is false,
      // then the bounds don't *really* intersect.

      if (options.inclusive || !mightTouch) {
        // otherwise, if one of the boundaries even partially contains another,
        // inclusive of the edges, then they do intersect.
        var inBottom = bounds.bottom >= self.bottom && bounds.bottom <= self.top || self.bottom >= bounds.bottom && self.bottom <= bounds.top;
        var inTop = bounds.top >= self.bottom && bounds.top <= self.top || self.top > bounds.bottom && self.top < bounds.top;
        var inLeft = bounds.left >= self.left && bounds.left <= self.right || self.left >= bounds.left && self.left <= bounds.right;
        var inRight = bounds.right >= self.left && bounds.right <= self.right || self.right >= bounds.left && self.right <= bounds.right;
        intersects = (inBottom || inTop) && (inLeft || inRight);
      } // document me


      if (options.worldBounds && !intersects) {
        var world = options.worldBounds;
        var width = world.getWidth();
        var selfCrosses = !world.containsBounds(self);
        var boundsCrosses = !world.containsBounds(bounds);

        if (selfCrosses && !boundsCrosses) {
          bounds = bounds.add(-width, 0);
          intersects = self.intersectsBounds(bounds, {
            inclusive: options.inclusive
          });
        } else if (boundsCrosses && !selfCrosses) {
          self = self.add(-width, 0);
          intersects = bounds.intersectsBounds(self, {
            inclusive: options.inclusive
          });
        }
      }

      return intersects;
    }
    /**
     * @function SuperMap.Bounds.prototype.containsBounds
     * @description 判断目标边界是否被当前边界包含在内。
     * @example
     * var bounds = new SuperMap.Bounds(-180,-90,100,80);
     * var isContains = bounds.containsBounds(
     *      new SuperMap.Bounds(-170,-90,100,80),true,true
     *  );
     * @param {SuperMap.Bounds} bounds - 目标边界。
     * @param {boolean} [partial=false] - 目标边界的任意部分都包含在当前边界中则被认为是包含关系。
     * 如果设为 false，整个目标边界全部被包含在当前边界范围内。
     * @param {boolean} [inclusive=true] - 边缘共享被视为包含。
     * @returns {boolean} 传入的边界被当前边界包含。
     */

  }, {
    key: "containsBounds",
    value: function containsBounds(bounds, partial, inclusive) {
      if (partial == null) {
        partial = false;
      }

      if (inclusive == null) {
        inclusive = true;
      }

      var bottomLeft = this.contains(bounds.left, bounds.bottom, inclusive);
      var bottomRight = this.contains(bounds.right, bounds.bottom, inclusive);
      var topLeft = this.contains(bounds.left, bounds.top, inclusive);
      var topRight = this.contains(bounds.right, bounds.top, inclusive);
      return partial ? bottomLeft || bottomRight || topLeft || topRight : bottomLeft && bottomRight && topLeft && topRight;
    }
    /**
     * @function SuperMap.Bounds.prototype.determineQuadrant
     * @description 判断传入坐标是否在 bounds 范围内的象限。以 bounds 中心点为坐标原点。
     * @example
     * var bounds = new SuperMap.Bounds(-180,-90,100,80);
     * //str = "tr";
     * var str = bounds.determineQuadrant(
     *      new SuperMap.LonLat(20,20)
     *  );
     * @param {SuperMap.LonLat} lonlat - 传入的坐标对象。
     * @returns {string} 传入坐标所在的象限（"br" "tr" "tl" "bl" 分别对应"右下"，"右上"，"左上" "左下"）。
     */

  }, {
    key: "determineQuadrant",
    value: function determineQuadrant(lonlat) {
      var quadrant = "";
      var center = this.getCenterLonLat();
      quadrant += lonlat.lat < center.lat ? "b" : "t";
      quadrant += lonlat.lon < center.lon ? "l" : "r";
      return quadrant;
    }
    /**
     * @function SuperMap.Bounds.prototype.wrapDateLine
     * @description 将当前 bounds 移动到最大边界范围内部（所谓的内部是相交或者内部）。
     * @example
     * var bounds = new SuperMap.Bounds(380,-40,400,-20);
     * var maxExtent = new SuperMap.Bounds(-180,-90,100,80);
     * //新的bounds
     * var newBounds = bounds.wrapDateLine(maxExtent);
     * @param {SuperMap.Bounds} maxExtent - 最大的边界范围（一般是全球范围）。
     * @param {Object} options - 可选选项参数。 
     * @param {float} [options.leftTolerance=0] - left 允许的误差。 
     * @param {float} [options.rightTolerance=0] - right 允许的误差。
     * @returns {SuperMap.Bounds} 克隆当前边界。如果当前边界完全在最大范围之外此函数则返回一个不同值的边界，
     *                            若落在最大边界的左边，则给当前的bounds值加上最大范围的宽度，即向右移动，
     *                            若落在右边，则向左移动，即给当前的bounds值加上负的最大范围的宽度。
     */

  }, {
    key: "wrapDateLine",
    value: function wrapDateLine(maxExtent, options) {
      options = options || {};
      var leftTolerance = options.leftTolerance || 0;
      var rightTolerance = options.rightTolerance || 0;
      var newBounds = this.clone();

      if (maxExtent) {
        var width = maxExtent.getWidth(); //如果 newBounds 在 maxExtent 的左边，那么一直向右移动，直到相交或者包含为止，每次移动width
        //shift right?

        while (newBounds.left < maxExtent.left && newBounds.right - rightTolerance <= maxExtent.left) {
          newBounds = newBounds.add(width, 0);
        } //如果 newBounds 在 maxExtent 的右边，那么一直向左移动，直到相交或者包含为止，每次移动width
        //shift left?


        while (newBounds.left + leftTolerance >= maxExtent.right && newBounds.right > maxExtent.right) {
          newBounds = newBounds.add(-width, 0);
        } //如果和右边相交，左边又在内部，那么再次向左边移动一次
        // crosses right only? force left


        var newLeft = newBounds.left + leftTolerance;

        if (newLeft < maxExtent.right && newLeft > maxExtent.left && newBounds.right - rightTolerance > maxExtent.right) {
          newBounds = newBounds.add(-width, 0);
        }
      }

      return newBounds;
    }
    /**
     * @function SuperMap.Bounds.prototype.toServerJSONObject
     * @description 转换成对应的 JSON 格式对象。
     * @example
     * var bounds = new SuperMap.Bounds(-180,-90,100,80);
     * var obj = bounds.toServerJSONObject();
     * @returns {Object} 返回 JSON 格式的 Object 对象。
     */

  }, {
    key: "toServerJSONObject",
    value: function toServerJSONObject() {
      var jsonObject = {
        rightTop: {
          x: this.right,
          y: this.top
        },
        leftBottom: {
          x: this.left,
          y: this.bottom
        },
        left: this.left,
        right: this.right,
        top: this.top,
        bottom: this.bottom
      };
      return jsonObject;
    }
    /**
     *
     * @function SuperMap.Bounds.prototype.destroy
     * @description 销毁此对象。
     * 销毁后此对象的所有属性为 null，而不是初始值。
     * @example
     * var bounds = new SuperMap.Bounds(-180,-90,100,80);
     * bounds.destroy();
     */

  }, {
    key: "destroy",
    value: function destroy() {
      this.left = null;
      this.right = null;
      this.top = null;
      this.bottom = null;
      this.centerLonLat = null;
    }
    /**
     * @function SuperMap.Bounds.fromString
     * @description 通过字符串参数创建新的 bounds 的构造函数。
     * @example
     * var bounds = SuperMap.Bounds.fromString("-180,-90,100,80");
     * @param {string} str - 边界字符串，用逗号隔开（e.g. <i>"5,42,10,45"</i>）。
     * @param {boolean} [reverseAxisOrder=false] - 是否反转轴顺序。
     * 如果设为true，则倒转顺序（bottom,left,top,right），否则按正常轴顺序（left,bottom,right,top）。
     * @returns {SuperMap.Bounds} 返回给定的字符串创建的新的边界对象。
     */

  }], [{
    key: "fromString",
    value: function fromString(str, reverseAxisOrder) {
      var bounds = str.split(",");
      return Bounds.fromArray(bounds, reverseAxisOrder);
    }
    /**
     * @function SuperMap.Bounds.fromArray
     * @description 通过边界框数组创建 Bounds。
     * @example
     * var bounds = SuperMap.Bounds.fromArray([-180,-90,100,80]);
     * @param {Array.<float>} bbox - 边界值数组。（e.g. <i>[5,42,10,45]</i>）。
     * @param {boolean} [reverseAxisOrder=false] - 是否是反转轴顺序。如果设为true，则倒转顺序（bottom,left,top,right），否则按正常轴顺序（left,bottom,right,top）。
     * @returns {SuperMap.Bounds} 返回根据传入的数组创建的新的边界对象。
     */

  }, {
    key: "fromArray",
    value: function fromArray(bbox, reverseAxisOrder) {
      return reverseAxisOrder === true ? new Bounds(bbox[1], bbox[0], bbox[3], bbox[2]) : new Bounds(bbox[0], bbox[1], bbox[2], bbox[3]);
    }
    /**
     * @function SuperMap.Bounds.fromSize
     * @description 通过传入的边界大小来创建新的边界。
     * @example
     * var bounds = SuperMap.Bounds.fromSize(new SuperMap.Size(20,10));
     * @param {SuperMap.Size} size - 传入的边界大小。
     * @returns {SuperMap.Bounds} 返回根据传入的边界大小的创建新的边界。
     */

  }, {
    key: "fromSize",
    value: function fromSize(size) {
      return new Bounds(0, size.h, size.w, 0);
    }
    /**
     * @function SuperMap.Bounds.oppositeQuadrant
     * @description 反转象限。"t"和"b" 交换，"r"和"l"交换, 如："tl"变为"br"。
     * @param {string} quadrant - 代表象限的字符串，如："tl"。
     * @returns {string} 反转后的象限。
     */

  }, {
    key: "oppositeQuadrant",
    value: function oppositeQuadrant(quadrant) {
      var opp = "";
      opp += quadrant.charAt(0) === 't' ? 'b' : 't';
      opp += quadrant.charAt(1) === 'l' ? 'r' : 'l';
      return opp;
    }
  }]);

  return Bounds;
}();
SuperMap.Bounds = Bounds_Bounds;
// CONCATENATED MODULE: ./src/common/commontypes/Geometry.js
function Geometry_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function Geometry_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function Geometry_createClass(Constructor, protoProps, staticProps) { if (protoProps) Geometry_defineProperties(Constructor.prototype, protoProps); if (staticProps) Geometry_defineProperties(Constructor, staticProps); return Constructor; }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/
 // import {WKT} from '../format/WKT';
// import {Vector} from './Vector';


/**
 * @class SuperMap.Geometry
 * @category BaseTypes Geometry
 * @classdesc 几何对象类，描述地理对象的几何图形。
 */

var Geometry_Geometry =
/*#__PURE__*/
function () {
  function Geometry() {
    Geometry_classCallCheck(this, Geometry);

    this.CLASS_NAME = "SuperMap.Geometry";
    /**
     * @member {string} SuperMap.Geometry.prototype.id
     * @description  此几何对象的唯一标示符。
     *
     */

    this.id = Util.createUniqueID(this.CLASS_NAME + "_");
    /**
     * @member {SuperMap.Geometry} SuperMap.Geometry.prototype.parent
     * @description This is set when a Geometry is added as component
     * of another geometry
     */

    this.parent = null;
    /**
     * @member {SuperMap.Bounds} SuperMap.Geometry.prototype.bounds
     * @description 几何对象的范围。
     *
     */

    this.bounds = null;
    /**
     * @member {interger} SuperMap.Geometry.prototype.SRID
     * @description 投影坐标参数。通过该参数，服务器判断 Geometry 对象的坐标参考系是否与数据集相同，如果不同，则在数据入库前进行投影变换。
     * @example
     *   var geometry= new SuperMap.Geometry();
     *   geometry. SRID=4326;
     *
     */

    this.SRID = null;
  }
  /**
   * @function SuperMap.Geometry.prototype.destroy
   * @description 解构 Geometry 类，释放资源。
   */


  Geometry_createClass(Geometry, [{
    key: "destroy",
    value: function destroy() {
      this.id = null;
      this.bounds = null;
      this.SRID = null;
    }
    /**
     * @function SuperMap.Geometry.prototype.clone
     * @description 创建克隆的几何图形。克隆的几何图形不设置非标准的属性。
     * @returns {SuperMap.Geometry} 克隆的几何图形。
     */

  }, {
    key: "clone",
    value: function clone() {
      return new Geometry();
    }
    /**
     * @function SuperMap.Geometry.prototype.setBounds
     * @description 设置此几何对象的 bounds。
     * @param {SuperMap.Bounds} bounds - 范围。
     */

  }, {
    key: "setBounds",
    value: function setBounds(bounds) {
      if (bounds) {
        this.bounds = bounds.clone();
      }
    }
    /**
     * @function SuperMap.Geometry.prototype.clearBounds
     * @description 清除几何对象的 bounds。
     * 如果该对象有父类，也会清除父类几何对象的 bounds。
     */

  }, {
    key: "clearBounds",
    value: function clearBounds() {
      this.bounds = null;

      if (this.parent) {
        this.parent.clearBounds();
      }
    }
    /**
     * @function SuperMap.Geometry.prototype.extendBounds
     * @description Extend the existing bounds to include the new bounds.
     * If geometry's bounds is not yet set, then set a new Bounds.
     *
     * @param {SuperMap.Bounds} newBounds - 范围。
     */

  }, {
    key: "extendBounds",
    value: function extendBounds(newBounds) {
      var bounds = this.getBounds();

      if (!bounds) {
        this.setBounds(newBounds);
      } else {
        this.bounds.extend(newBounds);
      }
    }
    /**
     * @function SuperMap.Geometry.prototype.getBounds
     * @description 获得几何图形的边界。如果没有设置边界，可通过计算获得。
     * @returns {SuperMap.Bounds} 返回的几何对象的边界。
     */

  }, {
    key: "getBounds",
    value: function getBounds() {
      if (this.bounds == null) {
        this.calculateBounds();
      }

      return this.bounds;
    }
    /**
     * @function SuperMap.Geometry.prototype.calculateBounds
     * @description 重新计算几何图形的边界（需要在子类中实现此方法）。
     */

  }, {
    key: "calculateBounds",
    value: function calculateBounds() {} //
    // This should be overridden by subclasses.
    //

    /**
     * @function SuperMap.Geometry.prototype.getVertices
     * @description 返回几何图形的所有顶点的列表（需要在子类中实现此方法）。
     * @param {boolean} [nodes] - 如果是 true，线则只返回线的末端点，如果 false，仅仅返回顶点，如果没有设置，则返回顶点。
     * @returns {Array} 几何图形的顶点列表。
     */

  }, {
    key: "getVertices",
    value: function getVertices(nodes) {} // eslint-disable-line no-unused-vars

    /**
     * @function SuperMap.Geometry.prototype.getArea
     * @description 计算几何对象的面积 ，此方法需要在子类中定义。
     * @returns {float} The area of the collection by summing its parts
     */

  }, {
    key: "getArea",
    value: function getArea() {
      //to be overridden by geometries that actually have an area
      //
      return 0.0;
    } // /**
    //  * @function SuperMap.Geometry.prototype.toString
    //  * @description 返回geometry对象的字符串表述，需要引入{@link SuperMap.Format.WKT}。此方法只能在子类实现，在父类使用会报错。
    //  * @returns {string} geometry对象的字符串表述(Well-Known Text)
    //  */
    // toString() {
    // var string;
    // if (WKT) {
    //     var wkt = new WKT();
    //     string = wkt.write(new Vector(this));
    // } else {
    //     string = Object.prototype.toString.call(this);
    // }
    // return string;
    // }

  }]);

  return Geometry;
}();
SuperMap.Geometry = Geometry_Geometry;
// CONCATENATED MODULE: ./src/common/commontypes/geometry/Collection.js
function Collection_typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { Collection_typeof = function _typeof(obj) { return typeof obj; }; } else { Collection_typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return Collection_typeof(obj); }

function Collection_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function Collection_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function Collection_createClass(Constructor, protoProps, staticProps) { if (protoProps) Collection_defineProperties(Constructor.prototype, protoProps); if (staticProps) Collection_defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (Collection_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get; } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return _get(target, property, receiver || target); }

function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/




/**
 * @class SuperMap.Geometry.Collection
 * @classdesc 几何对象集合类，存储在本地的 components 属性中（可作为参数传递给构造函数）。<br>
 *            随着新的几何图形添加到集合中，将不能被克隆，当移动几何图形时，需要指定参照物。<br>
 *            getArea 和 getLength 函数只能通过遍历存储几何对象的 components 数组，总计所有几何图形的面积和长度。
 * @category BaseTypes Geometry
 * @extends {SuperMap.Geometry}
 * @param {Array.<SuperMap.Geometry>} components - 几何对象数组。
 * @example
 * var point1 = new SuperMap.Geometry.Point(10,20);
 * var point2 = new SuperMap.Geometry.Point(30,40);
 * var col = new SuperMap.Geometry.Collection([point1,point2]);
 */

var Collection_Collection =
/*#__PURE__*/
function (_Geometry) {
  _inherits(Collection, _Geometry);

  function Collection(components) {
    var _this;

    Collection_classCallCheck(this, Collection);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(Collection).call(this));
    /**
     * @description 存储几何对象的数组。
     * @member {Array.<SuperMap.Geometry>} SuperMap.Geometry.Collection.prototype.components
     */

    _this.components = [];
    /**
     * @member {Array.<string>} SuperMap.Geometry.Collection.prototype.componentTypes
     * @description components 存储的的几何对象所支持的几何类型数组，为空表示类型不受限制。
     */

    _this.componentTypes = null;

    if (components != null) {
      _this.addComponents(components);
    }

    _this.CLASS_NAME = "SuperMap.Geometry.Collection";
    _this.geometryType = "Collection";
    return _this;
  }
  /**
   * @function SuperMap.Geometry.Collection.prototype.destroy
   * @description 销毁几何图形。
   */


  Collection_createClass(Collection, [{
    key: "destroy",
    value: function destroy() {
      this.components.length = 0;
      this.components = null;

      _get(_getPrototypeOf(Collection.prototype), "destroy", this).call(this);
    }
    /**
     * @function SuperMap.Geometry.Collection.prototype.clone
     * @description 克隆当前几何对象。
     * @returns {SuperMap.Geometry.Collection} 克隆的几何对象集合。
     */

  }, {
    key: "clone",
    value: function clone() {
      var geometry = new Collection();

      for (var i = 0, len = this.components.length; i < len; i++) {
        geometry.addComponent(this.components[i].clone());
      } // catch any randomly tagged-on properties


      Util.applyDefaults(geometry, this);
      return geometry;
    }
    /**
     * @function SuperMap.Geometry.Collection.prototype.getComponentsString
     * @description 获取 components 字符串。
     * @returns {string} components 字符串。
     */

  }, {
    key: "getComponentsString",
    value: function getComponentsString() {
      var strings = [];

      for (var i = 0, len = this.components.length; i < len; i++) {
        strings.push(this.components[i].toShortString());
      }

      return strings.join(",");
    }
    /**
     * @function SuperMap.Geometry.Collection.prototype.calculateBounds
     * @description 通过遍历数组重新计算边界，在遍历每一子项中时调用 extend 方法。
     */

  }, {
    key: "calculateBounds",
    value: function calculateBounds() {
      this.bounds = null;
      var bounds = new Bounds_Bounds();
      var components = this.components;

      if (components) {
        for (var i = 0, len = components.length; i < len; i++) {
          bounds.extend(components[i].getBounds());
        }
      } // to preserve old behavior, we only set bounds if non-null
      // in the future, we could add bounds.isEmpty()


      if (bounds.left != null && bounds.bottom != null && bounds.right != null && bounds.top != null) {
        this.setBounds(bounds);
      }
    }
    /**
     * @function SuperMap.Geometry.Collection.prototype.addComponents
     * @description 给几何图形对象添加元素。
     * @param {Array.<SuperMap.Geometry>} components - 几何对象组件。
     * @example
     * var collection = new SuperMap.Geometry.Collection();
     * collection.addComponents(new SuerpMap.Geometry.Point(10,10));
     */

  }, {
    key: "addComponents",
    value: function addComponents(components) {
      if (!Util.isArray(components)) {
        components = [components];
      }

      for (var i = 0, len = components.length; i < len; i++) {
        this.addComponent(components[i]);
      }
    }
    /**
     * @function SuperMap.Geometry.Collection.prototype.addComponent
     * @description 添加一个几何对象到集合中。如果设置了 componentTypes 类型，则添加的几何对象必须是 componentTypes 中的类型。
     * @param {SuperMap.Geometry} component - 待添加的几何对象。
     * @param {int} [index] - 几何对象插入的位置。
     * @returns {boolean} 是否添加成功。
     */

  }, {
    key: "addComponent",
    value: function addComponent(component, index) {
      var added = false;

      if (component) {
        if (this.componentTypes == null || Util.indexOf(this.componentTypes, component.CLASS_NAME) > -1) {
          if (index != null && index < this.components.length) {
            var components1 = this.components.slice(0, index);
            var components2 = this.components.slice(index, this.components.length);
            components1.push(component);
            this.components = components1.concat(components2);
          } else {
            this.components.push(component);
          }

          component.parent = this;
          this.clearBounds();
          added = true;
        }
      }

      return added;
    }
    /**
     * @function SuperMap.Geometry.Collection.prototype.removeComponents
     * @description 清除几何对象。
     * @param {Array.<SuperMap.Geometry>} components - 需要清除的几何对象。
     * @returns {boolean} 元素是否被删除。
     */

  }, {
    key: "removeComponents",
    value: function removeComponents(components) {
      var removed = false;

      if (!Util.isArray(components)) {
        components = [components];
      }

      for (var i = components.length - 1; i >= 0; --i) {
        removed = this.removeComponent(components[i]) || removed;
      }

      return removed;
    }
    /**
     * @function SuperMap.Geometry.Collection.prototype.removeComponent
     * @description 从集合中移除一个几何对象。
     * @param {SuperMap.Geometry} component - 要移除的几何对象。
     * @returns {boolean} 几何对象是否移除成功。
     */

  }, {
    key: "removeComponent",
    value: function removeComponent(component) {
      Util.removeItem(this.components, component); // clearBounds() so that it gets recalculated on the next call
      // to this.getBounds();

      this.clearBounds();
      return true;
    }
    /**
     * @function SuperMap.Geometry.Collection.prototype.getArea
     * @description 计算几何对象的面积。注意，这个方法在 {@link SuperMap.Geometry.Polygon} 类中需要重写。
     * @returns {number} 几何图形的面积，是几何对象中所有组成部分的面积之和。
     */

  }, {
    key: "getArea",
    value: function getArea() {
      var area = 0.0;

      for (var i = 0, len = this.components.length; i < len; i++) {
        area += this.components[i].getArea();
      }

      return area;
    }
    /**
     * @function SuperMap.Geometry.Collection.prototype.equals
     * @description 判断两个几何图形是否相等。如果所有的 components 具有相同的坐标，则认为是相等的。
     * @param {SuperMap.Geometry} geometry - 需要判断的几何图形。
     * @returns {boolean} 输入的几何图形与当前几何图形是否相等。
     */

  }, {
    key: "equals",
    value: function equals(geometry) {
      var equivalent = true;

      if (!geometry || !geometry.CLASS_NAME || this.CLASS_NAME !== geometry.CLASS_NAME) {
        equivalent = false;
      } else if (!Util.isArray(geometry.components) || geometry.components.length !== this.components.length) {
        equivalent = false;
      } else {
        for (var i = 0, len = this.components.length; i < len; ++i) {
          if (!this.components[i].equals(geometry.components[i])) {
            equivalent = false;
            break;
          }
        }
      }

      return equivalent;
    }
    /**
     * @function SuperMap.Geometry.Collection.prototype.getVertices
     * @description 返回几何对象的所有结点的列表。
     * @param {boolean} [nodes] - 对于线来说，仅仅返回作为端点的顶点，如果设为 false，则返回非端点的顶点如果没有设置此参数，则返回所有顶点。
     * @returns {Array} 几何对象的顶点列表。
     */

  }, {
    key: "getVertices",
    value: function getVertices(nodes) {
      var vertices = [];

      for (var i = 0, len = this.components.length; i < len; ++i) {
        Array.prototype.push.apply(vertices, this.components[i].getVertices(nodes));
      }

      return vertices;
    }
  }]);

  return Collection;
}(Geometry_Geometry);
SuperMap.Geometry.Collection = Collection_Collection;
// CONCATENATED MODULE: ./src/common/commontypes/geometry/MultiPoint.js
function MultiPoint_typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { MultiPoint_typeof = function _typeof(obj) { return typeof obj; }; } else { MultiPoint_typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return MultiPoint_typeof(obj); }

function MultiPoint_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function MultiPoint_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function MultiPoint_createClass(Constructor, protoProps, staticProps) { if (protoProps) MultiPoint_defineProperties(Constructor.prototype, protoProps); if (staticProps) MultiPoint_defineProperties(Constructor, staticProps); return Constructor; }

function MultiPoint_possibleConstructorReturn(self, call) { if (call && (MultiPoint_typeof(call) === "object" || typeof call === "function")) { return call; } return MultiPoint_assertThisInitialized(self); }

function MultiPoint_assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function MultiPoint_getPrototypeOf(o) { MultiPoint_getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return MultiPoint_getPrototypeOf(o); }

function MultiPoint_inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) MultiPoint_setPrototypeOf(subClass, superClass); }

function MultiPoint_setPrototypeOf(o, p) { MultiPoint_setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return MultiPoint_setPrototypeOf(o, p); }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


/**
 * @class SuperMap.Geometry.MultiPoint
 * @classdesc 几何对象多点类。
 * @category BaseTypes Geometry
 * @extends {SuperMap.Geometry.Collection}
 * @param {Array.<SuperMap.Geometry.Point>} components - 点对象数组。
 * @example
 * var point1 = new SuperMap.Geometry.Point(5,6);
 * var poine2 = new SuperMap.Geometry.Point(7,8);
 * var multiPoint = new SuperMap.Geometry.MultiPoint([point1,point2]);
 */

var MultiPoint =
/*#__PURE__*/
function (_Collection) {
  MultiPoint_inherits(MultiPoint, _Collection);

  function MultiPoint(components) {
    var _this;

    MultiPoint_classCallCheck(this, MultiPoint);

    _this = MultiPoint_possibleConstructorReturn(this, MultiPoint_getPrototypeOf(MultiPoint).call(this, components));
    /**
     * @member {Array.<string>} [SuperMap.Geometry.MultiPoint.prototype.componentTypes=["SuperMap.Geometry.Point"]]
     * @description components 存储的的几何对象所支持的几何类型数组。
     * @readonly
     */

    _this.componentTypes = ["SuperMap.Geometry.Point"];
    _this.CLASS_NAME = "SuperMap.Geometry.MultiPoint";
    _this.geometryType = "MultiPoint";
    return _this;
  }
  /**
   * @function SuperMap.Geometry.MultiPoint.prototype.addPoint
   * @description 添加点，封装了 {@link SuperMap.Geometry.Collection|SuperMap.Geometry.Collection.addComponent} 方法。
   * @param {SuperMap.Geometry.Point} point - 添加的点。
   * @param {integer} [index] - 下标。
   */


  MultiPoint_createClass(MultiPoint, [{
    key: "addPoint",
    value: function addPoint(point, index) {
      this.addComponent(point, index);
    }
    /**
     * @function SuperMap.Geometry.MultiPoint.prototype.removePoint
     * @description 移除点，封装了 {@link SuperMap.Geometry.Collection|SuperMap.Geometry.Collection.removeComponent} 方法。
     * @param {SuperMap.Geometry.Point} point - 移除的点对象。
     */

  }, {
    key: "removePoint",
    value: function removePoint(point) {
      this.removeComponent(point);
    }
  }]);

  return MultiPoint;
}(Collection_Collection);
SuperMap.Geometry.MultiPoint = MultiPoint;
// CONCATENATED MODULE: ./src/common/commontypes/geometry/Curve.js
function Curve_typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { Curve_typeof = function _typeof(obj) { return typeof obj; }; } else { Curve_typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return Curve_typeof(obj); }

function Curve_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function Curve_possibleConstructorReturn(self, call) { if (call && (Curve_typeof(call) === "object" || typeof call === "function")) { return call; } return Curve_assertThisInitialized(self); }

function Curve_assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function Curve_getPrototypeOf(o) { Curve_getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return Curve_getPrototypeOf(o); }

function Curve_inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) Curve_setPrototypeOf(subClass, superClass); }

function Curve_setPrototypeOf(o, p) { Curve_setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return Curve_setPrototypeOf(o, p); }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


/**
 * @class SuperMap.Geometry.Curve
 * @classdesc 几何对象曲线类。
 * @category BaseTypes Geometry
 * @extends {SuperMap.Geometry.MultiPoint}
 * @param {Array.<SuperMap.Geometry.Point>} components - 几何对象数组。
 * @example
 * var point1 = new SuperMap.Geometry.Point(10,20);
 * var point2 = new SuperMap.Geometry.Point(30,40);
 * var curve = new SuperMap.Geometry.Curve([point1,point2]);
 */

var Curve_Curve =
/*#__PURE__*/
function (_MultiPoint) {
  Curve_inherits(Curve, _MultiPoint);

  function Curve(components) {
    var _this;

    Curve_classCallCheck(this, Curve);

    _this = Curve_possibleConstructorReturn(this, Curve_getPrototypeOf(Curve).call(this, components));
    /**
     * @member {Array.<string>} [SuperMap.Geometry.Curve.prototype.componentType=["SuperMap.Geometry.Point", "SuperMap.PointWithMeasure"]]
     * @description components 存储的的几何对象所支持的几何类型数组。
     * @readonly
     */

    _this.componentTypes = ["SuperMap.Geometry.Point", "SuperMap.PointWithMeasure"];
    _this.CLASS_NAME = "SuperMap.Geometry.Curve";
    _this.geometryType = "Curve";
    return _this;
  }

  return Curve;
}(MultiPoint);
SuperMap.Geometry.Curve = Curve_Curve;
// CONCATENATED MODULE: ./src/common/commontypes/geometry/Point.js
function Point_typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { Point_typeof = function _typeof(obj) { return typeof obj; }; } else { Point_typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return Point_typeof(obj); }

function Point_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function Point_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function Point_createClass(Constructor, protoProps, staticProps) { if (protoProps) Point_defineProperties(Constructor.prototype, protoProps); if (staticProps) Point_defineProperties(Constructor, staticProps); return Constructor; }

function Point_possibleConstructorReturn(self, call) { if (call && (Point_typeof(call) === "object" || typeof call === "function")) { return call; } return Point_assertThisInitialized(self); }

function Point_assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function Point_get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { Point_get = Reflect.get; } else { Point_get = function _get(target, property, receiver) { var base = Point_superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return Point_get(target, property, receiver || target); }

function Point_superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = Point_getPrototypeOf(object); if (object === null) break; } return object; }

function Point_getPrototypeOf(o) { Point_getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return Point_getPrototypeOf(o); }

function Point_inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) Point_setPrototypeOf(subClass, superClass); }

function Point_setPrototypeOf(o, p) { Point_setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return Point_setPrototypeOf(o, p); }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/




/**
 * @class SuperMap.Geometry.Point
 * @classdesc 点几何对象类。
 * @category BaseTypes Geometry
 * @extends {SuperMap.Geometry}
 * @param {float} x - x 坐标。
 * @param {float} y - y 坐标。
 * @param {string} [type = 'Point'] - 用来存储点的类型。
 * @param {float} [tag] - 用来存储额外的属性，比如差值分析中的 Z 值。
 * @example
 * var point = new SuperMap.Geometry.Point(-111.04, 45.68);
 */

var Point_Point =
/*#__PURE__*/
function (_Geometry) {
  Point_inherits(Point, _Geometry);

  function Point(x, y, type, tag) {
    var _this;

    Point_classCallCheck(this, Point);

    _this = Point_possibleConstructorReturn(this, Point_getPrototypeOf(Point).call(this, x, y, type, tag));
    /**
     * @member {float} SuperMap.Geometry.Point.prototype.x
     * @description 横坐标。
     */

    _this.x = parseFloat(x);
    /**
     * @member {float} SuperMap.Geometry.Point.prototype.y
     * @description 纵坐标。
     */

    _this.y = parseFloat(y);
    /**
     * @member {string} SuperMap.Geometry.Point.prototype.tag
     * @description  用来存储额外的属性，比如差值分析中的 Z 值。
     */

    _this.tag = tag || tag == 0 ? parseFloat(tag) : null;
    /**
     * @member {string} SuperMap.Geometry.Point.prototype.tag
     * @description  用来存储点的类型
     */

    _this.type = type || "Point";
    _this.CLASS_NAME = "SuperMap.Geometry.Point";
    _this.geometryType = "Point";
    return _this;
  }
  /**
   * @function SuperMap.Geometry.Point.prototype.clone
   * @description 克隆点对象。
   * @returns {SuperMap.Geometry.Point} 克隆后的点对象。
   */


  Point_createClass(Point, [{
    key: "clone",
    value: function clone(obj) {
      if (obj == null) {
        obj = new Point(this.x, this.y);
      } // catch any randomly tagged-on properties


      Util.applyDefaults(obj, this);
      return obj;
    }
    /**
     * @function SuperMap.Geometry.Point.prototype.calculateBounds
     * @description 计算点对象的范围。
     */

  }, {
    key: "calculateBounds",
    value: function calculateBounds() {
      this.bounds = new Bounds_Bounds(this.x, this.y, this.x, this.y);
    }
    /**
     * @function SuperMap.Geometry.Point.prototype.equals
     * @description 判断两个点对象是否相等。如果两个点对象具有相同的坐标，则认为是相等的。
     * @example
     * var point= new SuperMap.Geometry.Point(0,0);
     * var point1={x:0,y:0};
     * var result= point.equals(point1);
     * @param {SuperMap.Geometry.Point} geom - 需要判断的点对象。
     * @returns {boolean} 两个点对象是否相等（true 为相等，false 为不等）。
     */

  }, {
    key: "equals",
    value: function equals(geom) {
      var equals = false;

      if (geom != null) {
        equals = this.x === geom.x && this.y === geom.y || isNaN(this.x) && isNaN(this.y) && isNaN(geom.x) && isNaN(geom.y);
      }

      return equals;
    }
    /**
     * @function SuperMap.Geometry.Point.prototype.move
     * @description 沿着 x、y 轴的正方向上按照给定的位移移动点对象，move 不仅改变了几何对象的位置并且清理了边界缓存。
     * @param {float} x - x 轴正方向上的偏移量。
     * @param {float} y - y 轴正方向上偏移量。
     */

  }, {
    key: "move",
    value: function move(x, y) {
      this.x = this.x + x;
      this.y = this.y + y;
      this.clearBounds();
    }
    /**
     * @function SuperMap.Geometry.Point.prototype.toShortString
     * @returns {string} 字符串代表点对象。(ex. <i>"5, 42"</i>)
     */

  }, {
    key: "toShortString",
    value: function toShortString() {
      return this.x + ", " + this.y;
    }
    /**
     * @function SuperMap.Geometry.Point.prototype.destroy
     * @description 释放点对象的资源。
     */

  }, {
    key: "destroy",
    value: function destroy() {
      this.x = null;
      this.y = null;
      this.tag = null;

      Point_get(Point_getPrototypeOf(Point.prototype), "destroy", this).call(this);
    }
    /**
     * @function SuperMap.Geometry.Point.prototype.getVertices
     * @description 返回点对象的所有顶点的列表。
     * @param {boolean} [nodes] - 对于点对象此参数不起作用，直接返回点。
     * @returns {Array} 几何图形的顶点列表。
     */

  }, {
    key: "getVertices",
    value: function getVertices(nodes) {
      // eslint-disable-line no-unused-vars
      return [this];
    }
  }]);

  return Point;
}(Geometry_Geometry);
SuperMap.Geometry.Point = Point_Point;
// CONCATENATED MODULE: ./src/common/commontypes/geometry/LineString.js
function LineString_typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { LineString_typeof = function _typeof(obj) { return typeof obj; }; } else { LineString_typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return LineString_typeof(obj); }

function LineString_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function LineString_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function LineString_createClass(Constructor, protoProps, staticProps) { if (protoProps) LineString_defineProperties(Constructor.prototype, protoProps); if (staticProps) LineString_defineProperties(Constructor, staticProps); return Constructor; }

function LineString_possibleConstructorReturn(self, call) { if (call && (LineString_typeof(call) === "object" || typeof call === "function")) { return call; } return LineString_assertThisInitialized(self); }

function LineString_assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function LineString_get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { LineString_get = Reflect.get; } else { LineString_get = function _get(target, property, receiver) { var base = LineString_superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return LineString_get(target, property, receiver || target); }

function LineString_superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = LineString_getPrototypeOf(object); if (object === null) break; } return object; }

function LineString_getPrototypeOf(o) { LineString_getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return LineString_getPrototypeOf(o); }

function LineString_inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) LineString_setPrototypeOf(subClass, superClass); }

function LineString_setPrototypeOf(o, p) { LineString_setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return LineString_setPrototypeOf(o, p); }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/



/**
 * @class SuperMap.Geometry.LineString
 * @classdesc 几何对象线串类。
 * @category BaseTypes Geometry
 * @param {Array.<SuperMap.Geometry.Point>} points - 用来生成线串的点数组。
 * @extends {SuperMap.Geometry.Curve}
 * @example
 * var points = [new SuperMap.Geometry.Point(4933.319287022352, -3337.3849141502124),
 *     new SuperMap.Geometry.Point(4960.9674060199022, -3349.3316322355736),
 *     new SuperMap.Geometry.Point(5006.0235999418364, -3358.8890067038628),
 *     new SuperMap.Geometry.Point(5075.3145648369318, -3378.0037556404409),
 *     new SuperMap.Geometry.Point(5305.19551436013, -3376.9669111768926)],
 * var roadLine = new SuperMap.Geometry.LineString(points)；
 */

var LineString_LineString =
/*#__PURE__*/
function (_Curve) {
  LineString_inherits(LineString, _Curve);

  function LineString(points) {
    var _this;

    LineString_classCallCheck(this, LineString);

    _this = LineString_possibleConstructorReturn(this, LineString_getPrototypeOf(LineString).call(this, points));
    _this.CLASS_NAME = "SuperMap.Geometry.LineString";
    _this.geometryType = "LineString";
    return _this;
  }
  /**
   * @function SuperMap.Geometry.LineString.prototype.removeComponent
   * @description 只有在线串上有三个或更多的点的时候，才会允许移除点（否则结果将会是单一的点）。
   * @param {SuperMap.Geometry.Point} point - 将被删除的点。
   * @returns {boolean} 删除的点。
   */


  LineString_createClass(LineString, [{
    key: "removeComponent",
    value: function removeComponent(point) {
      // eslint-disable-line no-unused-vars
      var removed = this.components && this.components.length > 2;

      if (removed) {
        LineString_get(LineString_getPrototypeOf(LineString.prototype), "removeComponent", this).apply(this, arguments);
      }

      return removed;
    }
    /**
     * @function SuperMap.Geometry.LineString.prototype.getSortedSegments
     * @returns {Array} An array of segment objects.  Segment objects have properties
     *     x1, y1, x2, and y2.  The start point is represented by x1 and y1.
     *     The end point is represented by x2 and y2.  Start and end are
     *     ordered so that x1 < x2.
     */

  }, {
    key: "getSortedSegments",
    value: function getSortedSegments() {
      var numSeg = this.components.length - 1;
      var segments = new Array(numSeg),
          point1,
          point2;

      for (var i = 0; i < numSeg; ++i) {
        point1 = this.components[i];
        point2 = this.components[i + 1];

        if (point1.x < point2.x) {
          segments[i] = {
            x1: point1.x,
            y1: point1.y,
            x2: point2.x,
            y2: point2.y
          };
        } else {
          segments[i] = {
            x1: point2.x,
            y1: point2.y,
            x2: point1.x,
            y2: point1.y
          };
        }
      } // more efficient to define this somewhere static


      function byX1(seg1, seg2) {
        return seg1.x1 - seg2.x1;
      }

      return segments.sort(byX1);
    }
    /**
     * @function SuperMap.Geometry.LineString.prototype.getVertices
     * @description 返回几何图形的所有顶点的列表。
     * @param {boolean} [nodes] - 对于线来说，仅仅返回作为端点的顶点，如果设为 false，则返回非端点的顶点。如果没有设置此参数，则返回所有顶点。
     * @returns {Array} 几何图形的顶点列表。
     */

  }, {
    key: "getVertices",
    value: function getVertices(nodes) {
      var vertices;

      if (nodes === true) {
        vertices = [this.components[0], this.components[this.components.length - 1]];
      } else if (nodes === false) {
        vertices = this.components.slice(1, this.components.length - 1);
      } else {
        vertices = this.components.slice();
      }

      return vertices;
    }
    /**
     * @function SuperMap.Geometry.LineString.calculateCircle
     * @description 三点画圆弧。
     * @param {Array.<SuperMap.Geometry.Point>} points - 传入的待计算的初始点串。
     * @returns {Array.<SuperMap.Geometry.Point>} 计算出相应的圆弧控制点。
     * @example
     * var points = [];
     * points.push(new SuperMap.Geometry.Point(-50,30));
     * points.push(new SuperMap.Geometry.Point(-30,50));
     * points.push(new SuperMap.Geometry.Point(2,60));
     * var circle = SuperMap.Geometry.LineString.calculateCircle(points);
     */

  }], [{
    key: "calculateCircle",
    value: function calculateCircle(points) {
      if (points.length < 3) {
        return points;
      }

      var centerPoint = {},
          p1 = points[0],
          p2 = points[1],
          p3 = points[2];
      var R = 0,
          dStep = 0,
          direc = true,
          dRotation = 0,
          dRotationBegin = 0,
          dRotationAngle = 0,
          nSegmentCount = 72,
          circlePoints = [];
      var KTan13 = (p3.y - p1.y) / (p3.x - p1.x);
      var B13 = p3.y - KTan13 * p3.x;

      if (p3.x != p1.x && p3.y != p1.y && p2.y == KTan13 * p2.x + B13 || p3.x == p1.x && p2.x == p1.x || p3.y == p1.y && p2.y == p1.y || p3.x == p1.x && p3.y == p1.y || p3.x == p2.x && p3.y == p2.y || p1.x == p2.x && p1.y == p2.y) {
        circlePoints.push(p1);
        circlePoints.push(p2);
        circlePoints.push(p3);
      } else {
        var D = (p2.x * p2.x + p2.y * p2.y - (p1.x * p1.x + p1.y * p1.y)) * (2 * (p3.y - p1.y)) - (p3.x * p3.x + p3.y * p3.y - (p1.x * p1.x + p1.y * p1.y)) * (2 * (p2.y - p1.y));
        var E = 2 * (p2.x - p1.x) * (p3.x * p3.x + p3.y * p3.y - (p1.x * p1.x + p1.y * p1.y)) - 2 * (p3.x - p1.x) * (p2.x * p2.x + p2.y * p2.y - (p1.x * p1.x + p1.y * p1.y));
        var F = 4 * ((p2.x - p1.x) * (p3.y - p1.y) - (p3.x - p1.x) * (p2.y - p1.y));
        centerPoint.x = D / F;
        centerPoint.y = E / F;
        R = Math.sqrt((p1.x - centerPoint.x) * (p1.x - centerPoint.x) + (p1.y - centerPoint.y) * (p1.y - centerPoint.y));
        var dis = (p1.x - p3.x) * (p1.x - p3.x) + (p1.y - p3.y) * (p1.y - p3.y);
        var cons = (2 * R * R - dis) / (2 * R * R);
        cons = cons >= 1 ? 1 : cons;
        cons = cons <= -1 ? -1 : cons;
        dRotationAngle = Math.acos(cons) * 180 / Math.PI;

        if (p3.x == p1.x) {
          dRotationAngle = centerPoint.x > p1.x && p2.x > p1.x || centerPoint.x < p1.x && p2.x < p1.x ? 360 - dRotationAngle : dRotationAngle;
        } else {
          dRotationAngle = centerPoint.y > KTan13 * centerPoint.x + B13 && p2.y > KTan13 * p2.x + B13 || centerPoint.y < KTan13 * centerPoint.x + B13 && p2.y < KTan13 * p2.x + B13 ? 360 - dRotationAngle : dRotationAngle;
        }

        dStep = dRotationAngle / 72;

        if (p3.y != p1.y) {
          if (p3.x == p1.x) {
            if (p3.y > p1.y) {
              if (p2.x < p1.x) {
                direc = false;
              }
            } else {
              if (p2.x > p1.x) {
                direc = false;
              }
            }
          } else if (p3.x < p1.x) {
            if (p2.y < KTan13 * p2.x + B13) {
              direc = false;
            }
          } else {
            if (p2.y > KTan13 * p2.x + B13) {
              direc = false;
            }
          }
        } else {
          if (p3.x > p1.x) {
            if (p2.y > p1.y) {
              direc = false;
            }
          } else {
            if (p2.y < p1.y) {
              direc = false;
            }
          }
        }

        var K10 = (p1.y - centerPoint.y) / (p1.x - centerPoint.x);
        var atan10 = K10 >= 0 ? Math.atan(K10) * 180 / Math.PI : Math.abs(Math.atan(K10) * 180 / Math.PI) + 90;
        var CY = Math.abs(centerPoint.y);

        if (p1.y == CY && CY == p3.y) {
          if (p1.x < p3.x) {
            atan10 = atan10 + 180;
          }
        }

        var newPY = p1.y - centerPoint.y;
        circlePoints.push(p1);

        for (var i = 1; i < nSegmentCount; i++) {
          dRotation = dStep * i;
          dRotationBegin = atan10;

          if (direc) {
            if (newPY >= 0) {
              if (K10 >= 0) {
                dRotationBegin = dRotationBegin + dRotation;
              } else {
                dRotationBegin = 180 - (dRotationBegin - 90) + dRotation;
              }
            } else {
              if (K10 > 0) {
                dRotationBegin = dRotationBegin - 180 + dRotation;
              } else {
                dRotationBegin = 90 - dRotationBegin + dRotation;
              }
            }
          } else {
            if (newPY >= 0) {
              if (K10 >= 0) {
                dRotationBegin = dRotationBegin - dRotation;
              } else {
                dRotationBegin = 180 - (dRotationBegin - 90) - dRotation;
              }
            } else {
              if (K10 >= 0) {
                dRotationBegin = dRotationBegin - 180 - dRotation;
              } else {
                dRotationBegin = 90 - dRotationBegin - dRotation;
              }
            }
          }

          dRotationBegin = dRotationBegin * Math.PI / 180;
          var x = centerPoint.x + R * Math.cos(dRotationBegin);
          var y = centerPoint.y + R * Math.sin(dRotationBegin);
          circlePoints.push(new Point_Point(x, y));
        }

        circlePoints.push(p3);
      }

      return circlePoints;
    }
    /**
     * @function SuperMap.Geometry.LineString.createLineEPS
     * @description 根据点的类型画出不同类型的曲线。
     * 点的类型有三种：LTypeArc，LTypeCurve，NONE。
     * @param {Array.<SuperMap.Geometry.Point>} points - 传入的待计算的初始点串。
     * @returns {Array.<SuperMap.Geometry.Point>} 计算出相应的 lineEPS 控制点。
     * @example
     * var points = [];
     * points.push(new SuperMap.Geometry.Point(-50,30));
     * points.push(new SuperMap.Geometry.Point(-30,50,"LTypeArc"));
     * points.push(new SuperMap.Geometry.Point(2,60));
     * points.push(new SuperMap.Geometry.Point(8,20));
     * var lineEPS = SuperMap.Geometry.LineString.createLineEPS(points);
     */

  }, {
    key: "createLineEPS",
    value: function createLineEPS(points) {
      var list = [],
          len = points.length;

      if (len < 2) {
        return points;
      }

      for (var i = 0; i < len;) {
        var type = points[i].type;

        if (type == 'LTypeArc') {
          var listObj = LineString.createLineArc(list, i, len, points);
          list = listObj[0];
          i = listObj[1];
        } else {
          list.push(points[i]);
          i++;
        }
      }

      return list;
    }
  }, {
    key: "createLineArc",
    value: function createLineArc(list, i, len, points) {
      if (i == 0) {
        var bezierPtsObj = LineString.addPointEPS(points, i, len, 'LTypeArc');
        Array.prototype.push.apply(list, bezierPtsObj[0]);
        i = bezierPtsObj[1] + 1;
      } else if (i == len - 1) {
        var bezierP = [points[i - 1], points[i]],
            bezierPts = LineString.calculateCircle(bezierP);
        Array.prototype.push.apply(list, bezierPts);
        i++;
      } else {
        var _bezierPtsObj = LineString.addPointEPS(points, i, len, 'LTypeArc');

        list.pop();
        Array.prototype.push.apply(list, _bezierPtsObj[0]);
        i = _bezierPtsObj[1] + 1;
      }

      return [list, i];
    }
  }, {
    key: "addPointEPS",
    value: function addPointEPS(points, i, len, type) {
      var bezierP = [],
          j = i + 1;

      if (i == 0) {
        Array.prototype.push.apply(bezierP, [points[i], points[i + 1]]);
      } else if (i == len - 1) {
        Array.prototype.push.apply(bezierP, [points[i - 1], points[i]]);
      } else {
        Array.prototype.push.apply(bezierP, [points[i - 1], points[i], points[i + 1]]);
      }

      var bezierPts;

      if (type == 'LTypeCurve') {
        bezierPts = LineString.calculatePointsFBZN(bezierP);
      } else if (type == 'LTypeArc') {
        bezierPts = LineString.calculateCircle(bezierP);
      }

      return [bezierPts, j];
    }
  }]);

  return LineString;
}(Curve_Curve);
SuperMap.Geometry.LineString = LineString_LineString;
// CONCATENATED MODULE: ./src/common/commontypes/geometry/GeoText.js
function GeoText_typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { GeoText_typeof = function _typeof(obj) { return typeof obj; }; } else { GeoText_typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return GeoText_typeof(obj); }

function GeoText_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function GeoText_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function GeoText_createClass(Constructor, protoProps, staticProps) { if (protoProps) GeoText_defineProperties(Constructor.prototype, protoProps); if (staticProps) GeoText_defineProperties(Constructor, staticProps); return Constructor; }

function GeoText_possibleConstructorReturn(self, call) { if (call && (GeoText_typeof(call) === "object" || typeof call === "function")) { return call; } return GeoText_assertThisInitialized(self); }

function GeoText_assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function GeoText_get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { GeoText_get = Reflect.get; } else { GeoText_get = function _get(target, property, receiver) { var base = GeoText_superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return GeoText_get(target, property, receiver || target); }

function GeoText_superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = GeoText_getPrototypeOf(object); if (object === null) break; } return object; }

function GeoText_getPrototypeOf(o) { GeoText_getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return GeoText_getPrototypeOf(o); }

function GeoText_inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) GeoText_setPrototypeOf(subClass, superClass); }

function GeoText_setPrototypeOf(o, p) { GeoText_setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return GeoText_setPrototypeOf(o, p); }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/








/**
 * @class SuperMap.Geometry.GeoText
 * @classdesc 文本标签类。
 * @category BaseTypes Geometry
 * @extends {SuperMap.Geometry}
 * @param {float} x - x 坐标。
 * @param {float} y - y 坐标。
 * @param {string} text - 标签中的文本内容。
 */

var GeoText_GeoText =
/*#__PURE__*/
function (_Geometry) {
  GeoText_inherits(GeoText, _Geometry);

  function GeoText(x, y, text) {
    var _this;

    GeoText_classCallCheck(this, GeoText);

    _this = GeoText_possibleConstructorReturn(this, GeoText_getPrototypeOf(GeoText).call(this, x, y, text));
    /**
     * @member {float} SuperMap.Geometry.GeoText.prototype.x
     * @description 横坐标。
     */

    _this.x = parseFloat(x);
    /**
     * @member {float} SuperMap.Geometry.GeoText.prototype.y
     * @description 纵坐标。
     */

    _this.y = parseFloat(y);
    /**
     * @member {string} SuperMap.Geometry.GeoText.prototype.text
     * @description 标签中的文本内容。
     */

    _this.text = text.toString();
    /**
     * @member {Object} SuperMap.Geometry.GeoText.prototype.bsInfo
     * @description 标签范围的基础信息。
     * @property {number} w - bounds 的宽。
     * @property {number} h - bounds 的高度。
     */

    _this.bsInfo = {
      "h": null,
      "w": null
    };
    _this.element = document.createElement('span');
    _this.CLASS_NAME = "SuperMap.Geometry.GeoText";
    _this.geometryType = "GeoText";
    return _this;
  }
  /**
   * @function SuperMap.Geometry.GeoText.prototype.destroy
   * @description 销毁文本标签类。
   */


  GeoText_createClass(GeoText, [{
    key: "destroy",
    value: function destroy() {
      GeoText_get(GeoText_getPrototypeOf(GeoText.prototype), "destroy", this).call(this);

      this.x = null;
      this.y = null;
      this.text = null;
    }
    /**
     * @function SuperMap.Geometry.GeoText.prototype.getCentroid
     * @description 获取标签对象的质心。
     * @returns {SuperMap.Geometry.Point} 标签对象的质心。
     */

  }, {
    key: "getCentroid",
    value: function getCentroid() {
      return new Point_Point(this.x, this.y);
    }
    /**
     * @function SuperMap.Geometry.GeoText.prototype.clone
     * @description 克隆标签对象。
     * @returns {SuperMap.Geometry.GeoText} 克隆后的标签对象。
     */

  }, {
    key: "clone",
    value: function clone(obj) {
      if (obj == null) {
        obj = new GeoText(this.x, this.y, this.text);
      }

      Util.applyDefaults(obj, this);
      return obj;
    }
    /**
     * @function SuperMap.Geometry.GeoText.prototype.calculateBounds
     * @description 计算标签对象的范围。
     */

  }, {
    key: "calculateBounds",
    value: function calculateBounds() {
      this.bounds = new Bounds_Bounds(this.x, this.y, this.x, this.y);
    }
    /**
     * @function SuperMap.Geometry.GeoText.prototype.getLabelPxBoundsByLabel
     * @description 根据绘制好的标签获取文字标签的像素范围，参数的单位是像素；此方法相对于 getLabelPxBoundsByText 效率较低，但支持所有格式的文本。
     * @param {Object} locationPixel - 标签的位置点，该对象含有属性 x（横坐标），属性 y（纵坐标）。
     * @param {string} labelWidth - 标签的宽度，如：“90px”。
     * @param {string} labelHeight - 标签的高度。
     * @param {Object} style - 标签的 style。
     * @returns {SuperMap.Bounds} 标签的像素范围。
     */

  }, {
    key: "getLabelPxBoundsByLabel",
    value: function getLabelPxBoundsByLabel(locationPixel, labelWidth, labelHeight, style) {
      var labelPxBounds, left, bottom, top, right;
      var locationPx = Util.cloneObject(locationPixel); //计算文本行数

      var theText = style.label || this.text;
      var textRows = theText.split('\n');
      var laberRows = textRows.length; //处理文字对齐

      labelWidth = parseFloat(labelWidth);
      labelHeight = parseFloat(labelHeight);

      if (laberRows > 1) {
        labelHeight = parseFloat(labelHeight) * laberRows;
      }

      if (style.labelAlign && style.labelAlign !== "cm") {
        switch (style.labelAlign) {
          case "lt":
            locationPx.x += labelWidth / 2;
            locationPx.y += labelHeight / 2;
            break;

          case "lm":
            locationPx.x += labelWidth / 2;
            break;

          case "lb":
            locationPx.x += labelWidth / 2;
            locationPx.y -= labelHeight / 2;
            break;

          case "ct":
            locationPx.y += labelHeight / 2;
            break;

          case "cb":
            locationPx.y -= labelHeight / 2;
            break;

          case "rt":
            locationPx.x -= labelWidth / 2;
            locationPx.y += labelHeight / 2;
            break;

          case "rm":
            locationPx.x -= labelWidth / 2;
            break;

          case "rb":
            locationPx.x -= labelWidth / 2;
            locationPx.y -= labelHeight / 2;
            break;

          default:
            break;
        }
      }

      this.bsInfo.h = labelHeight;
      this.bsInfo.w = labelWidth; //bounds的四边

      left = locationPx.x - parseFloat(labelWidth) / 2;
      bottom = locationPx.y + parseFloat(labelHeight) / 2;
      right = locationPx.x + parseFloat(labelWidth) / 2;
      top = locationPx.y - parseFloat(labelHeight) / 2;
      labelPxBounds = new Bounds_Bounds(left, bottom, right, top);
      return labelPxBounds;
    }
    /**
     * @function SuperMap.Geometry.GeoText.prototype.getLabelPxBoundsByText
     * @description 根据文本内容获取文字标签的像素范围。
     * @param {Object} locationPixel - 标签的位置点，该对象含有属性 x（横坐标），属性 y（纵坐标）。
     * @param {Object} style - 标签的样式。
     * @returns {SuperMap.Bounds} 标签的像素范围。
     */

  }, {
    key: "getLabelPxBoundsByText",
    value: function getLabelPxBoundsByText(locationPixel, style) {
      var labelPxBounds, left, bottom, top, right;
      var labelSize = this.getLabelPxSize(style);
      var locationPx = Util.cloneObject(locationPixel); //处理文字对齐

      if (style.labelAlign && style.labelAlign !== "cm") {
        switch (style.labelAlign) {
          case "lt":
            locationPx.x += labelSize.w / 2;
            locationPx.y += labelSize.h / 2;
            break;

          case "lm":
            locationPx.x += labelSize.w / 2;
            break;

          case "lb":
            locationPx.x += labelSize.w / 2;
            locationPx.y -= labelSize.h / 2;
            break;

          case "ct":
            locationPx.y += labelSize.h / 2;
            break;

          case "cb":
            locationPx.y -= labelSize.h / 2;
            break;

          case "rt":
            locationPx.x -= labelSize.w / 2;
            locationPx.y += labelSize.h / 2;
            break;

          case "rm":
            locationPx.x -= labelSize.w / 2;
            break;

          case "rb":
            locationPx.x -= labelSize.w / 2;
            locationPx.y -= labelSize.h / 2;
            break;

          default:
            break;
        }
      }

      this.bsInfo.h = labelSize.h;
      this.bsInfo.w = labelSize.w;
      left = locationPx.x - labelSize.w / 2;
      bottom = locationPx.y + labelSize.h / 2; //处理斜体字

      if (style.fontStyle && style.fontStyle === "italic") {
        right = locationPx.x + labelSize.w / 2 + parseInt(parseFloat(style.fontSize) / 2);
      } else {
        right = locationPx.x + labelSize.w / 2;
      }

      top = locationPx.y - labelSize.h / 2;
      labelPxBounds = new Bounds_Bounds(left, bottom, right, top);
      return labelPxBounds;
    }
    /**
     * @function SuperMap.Geometry.GeoText.prototype.getLabelPxSize
     * @description 获取 label 的像素大小。
     * @param {Object} style - 标签样式。
     * @returns {Object} 标签大小对象，属性 w 表示标签的宽度，属性 h 表示标签的高度。
     */

  }, {
    key: "getLabelPxSize",
    value: function getLabelPxSize(style) {
      var text,
          //文本内容
      fontSize,
          //字体大小
      spacing = 1,
          //两个字符间的间距（单位：px）
      lineSpacing = 0.2,
          bgstrokeWidth = parseFloat(style.strokeWidth); //标签背景框边框的宽度

      text = style.label || this.text;

      if (style.fontSize) {
        fontSize = parseFloat(style.fontSize);
      } else {
        fontSize = parseFloat("12px");
      } //标签宽高


      var labelW, labelH;
      var textRows = text.split('\n');
      var numRows = textRows.length;

      if (numRows > 1) {
        labelH = fontSize * numRows + numRows + bgstrokeWidth + lineSpacing * fontSize;
      } else {
        labelH = fontSize + bgstrokeWidth + lineSpacing * fontSize + 1;
      } //取最大宽度


      labelW = 0;

      if (this.labelWTmp && labelW < this.labelWTmp) {
        labelW = this.labelWTmp;
      }

      for (var i = 0; i < numRows; i++) {
        var textCharC = this.getTextCount(textRows[i]);
        var labelWTmp = this.labelWTmp = Util.getTextBounds(style, textRows[i], this.element).textWidth + textCharC.textC * spacing + bgstrokeWidth;

        if (labelW < labelWTmp) {
          labelW = labelWTmp;
        }
      }

      var labelSize = new Object(); //标签大小

      labelSize.h = labelH;
      labelSize.w = labelW;
      return labelSize;
    }
    /**
     * @function SuperMap.Geometry.GeoText.prototype.getTextCount
     * @description 获取 text 中的字符个数。
     * @param {string} text - 字符串。
     * @returns {Object} 字符个数统计结果，属性 cnC 表示中文字符个数，属性 enC 表示英文字符个数，属性 textC 表示字符总个数。
     */

  }, {
    key: "getTextCount",
    value: function getTextCount(text) {
      var textCharCount = {};
      var cnCount = 0;
      var enCount = 0;

      for (var i = 0; i < text.length; i++) {
        if (text.charCodeAt(i) > 255) {
          //遍历判断字符串中每个字符的Unicode码,大于255则为中文
          cnCount++;
        } else {
          enCount++;
        }
      } //中午字符个数


      textCharCount.cnC = cnCount; //英文字符个数

      textCharCount.enC = enCount; //字符总个数

      textCharCount.textC = text.length;
      return textCharCount;
    }
  }]);

  return GeoText;
}(Geometry_Geometry);
SuperMap.Geometry.GeoText = GeoText_GeoText;
// CONCATENATED MODULE: ./src/common/commontypes/geometry/LinearRing.js
function LinearRing_typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { LinearRing_typeof = function _typeof(obj) { return typeof obj; }; } else { LinearRing_typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return LinearRing_typeof(obj); }

function LinearRing_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function LinearRing_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function LinearRing_createClass(Constructor, protoProps, staticProps) { if (protoProps) LinearRing_defineProperties(Constructor.prototype, protoProps); if (staticProps) LinearRing_defineProperties(Constructor, staticProps); return Constructor; }

function LinearRing_possibleConstructorReturn(self, call) { if (call && (LinearRing_typeof(call) === "object" || typeof call === "function")) { return call; } return LinearRing_assertThisInitialized(self); }

function LinearRing_assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function LinearRing_get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { LinearRing_get = Reflect.get; } else { LinearRing_get = function _get(target, property, receiver) { var base = LinearRing_superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return LinearRing_get(target, property, receiver || target); }

function LinearRing_superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = LinearRing_getPrototypeOf(object); if (object === null) break; } return object; }

function LinearRing_getPrototypeOf(o) { LinearRing_getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return LinearRing_getPrototypeOf(o); }

function LinearRing_inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) LinearRing_setPrototypeOf(subClass, superClass); }

function LinearRing_setPrototypeOf(o, p) { LinearRing_setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return LinearRing_setPrototypeOf(o, p); }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


/**
 * @class  SuperMap.Geometry.LinearRing
 * @classdesc 几何对象线环类，是一个特殊的封闭的线串，在每次 addPoint/removePoint 之后会通过添加一个点（此点是复制的第一个点得到的）
 * 作为最后的一个点来自动关闭线环。
 * @category BaseTypes Geometry
 * @extends {SuperMap.Geometry.LineString}
 * @param {Array.<SuperMap.Geometry.Point>} points - 组成线性环的点。
 * @example
 * var points = [new SuperMap.Geometry.Point(4933.319287022352, -3337.3849141502124),
 *      new SuperMap.Geometry.Point(4960.9674060199022, -3349.3316322355736),
 *      new SuperMap.Geometry.Point(5006.0235999418364, -3358.8890067038628),
 *      new SuperMap.Geometry.Point(5075.3145648369318, -3378.0037556404409),
 *      new SuperMap.Geometry.Point(5305.19551436013, -3376.9669111768926)],
 * var linearRing = new SuperMap.Geometry.LinearRing(points);
 */

var LinearRing =
/*#__PURE__*/
function (_LineString) {
  LinearRing_inherits(LinearRing, _LineString);

  function LinearRing(points) {
    var _this;

    LinearRing_classCallCheck(this, LinearRing);

    _this = LinearRing_possibleConstructorReturn(this, LinearRing_getPrototypeOf(LinearRing).call(this, points));
    /**
     * @member {Array.<string>} [SuperMap.Geometry.LinearRing.prototype.componentTypes=["SuperMap.Geometry.Point"]]
     * @description components 存储的的几何对象所支持的几何类型数组,为空表示类型不受限制。
     * @readonly
     */

    _this.componentTypes = ["SuperMap.Geometry.Point"];
    _this.CLASS_NAME = "SuperMap.Geometry.LinearRing";
    _this.geometryType = "LinearRing";
    return _this;
  }
  /**
   * @function SuperMap.Geometry.LinearRing.prototype.addComponent
   * @description 添加一个点到几何图形数组中，如果这个点将要被添加到组件数组的末端，并且与数组中已经存在的最后一个点相同，
   * 重复的点是不能被添加的。这将影响未关闭环的关闭。
   * 这个方法可以通过将非空索引（组件数组的下标）作为第二个参数重写。
   * @param {SuperMap.Geometry.Point} point - 点对象。
   * @param {integer} [index] - 插入组件数组的下标。
   * @returns {boolean} 点对象是否添加成功。
   */


  LinearRing_createClass(LinearRing, [{
    key: "addComponent",
    value: function addComponent(point, index) {
      var added = false; //remove last point

      var lastPoint = this.components.pop(); // given an index, add the point
      // without an index only add non-duplicate points

      if (index != null || !point.equals(lastPoint)) {
        added = LinearRing_get(LinearRing_getPrototypeOf(LinearRing.prototype), "addComponent", this).apply(this, arguments);
      } //append copy of first point


      var firstPoint = this.components[0];

      LinearRing_get(LinearRing_getPrototypeOf(LinearRing.prototype), "addComponent", this).apply(this, [firstPoint]);

      return added;
    }
    /**
     * @function SuperMap.Geometry.LinearRing.prototype.removeComponent
     * @description 从几何组件中删除一个点。
     * @param {SuperMap.Geometry.Point} point - 点对象。
     * @returns {boolean} 点对象是否删除。
     */

  }, {
    key: "removeComponent",
    value: function removeComponent(point) {
      // eslint-disable-line no-unused-vars
      var removed = this.components && this.components.length > 3;

      if (removed) {
        //remove last point
        this.components.pop(); //remove our point

        LinearRing_get(LinearRing_getPrototypeOf(LinearRing.prototype), "removeComponent", this).apply(this, arguments); //append copy of first point


        var firstPoint = this.components[0];

        LinearRing_get(LinearRing_getPrototypeOf(LinearRing.prototype), "addComponent", this).apply(this, [firstPoint]);
      }

      return removed;
    }
    /**
     * @function SuperMap.Geometry.LinearRing.prototype.getArea
     * @description 获得当前几何对象区域大小，如果是沿顺时针方向的环则是正值，否则为负值。
     * @returns {float} 环的面积。
     */

  }, {
    key: "getArea",
    value: function getArea() {
      var area = 0.0;

      if (this.components && this.components.length > 2) {
        var sum = 0.0;

        for (var i = 0, len = this.components.length; i < len - 1; i++) {
          var b = this.components[i];
          var c = this.components[i + 1];
          sum += (b.x + c.x) * (c.y - b.y);
        }

        area = -sum / 2.0;
      }

      return area;
    }
    /**
     * @function SuperMap.Geometry.LinearRing.prototype.getVertices
     * @description 返回几何图形的所有点的列表。
     * @param {boolean} [nodes] - 对于线来说，仅仅返回作为端点的顶点，如果设为 false ，则返回非端点的顶点，如果没有设置此参数，则返回所有顶点。
     * @returns {Array} 几何对象所有点的列表。
     */

  }, {
    key: "getVertices",
    value: function getVertices(nodes) {
      return nodes === true ? [] : this.components.slice(0, this.components.length - 1);
    }
  }]);

  return LinearRing;
}(LineString_LineString);
SuperMap.Geometry.LinearRing = LinearRing;
// CONCATENATED MODULE: ./src/common/commontypes/geometry/MultiLineString.js
function MultiLineString_typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { MultiLineString_typeof = function _typeof(obj) { return typeof obj; }; } else { MultiLineString_typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return MultiLineString_typeof(obj); }

function MultiLineString_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function MultiLineString_possibleConstructorReturn(self, call) { if (call && (MultiLineString_typeof(call) === "object" || typeof call === "function")) { return call; } return MultiLineString_assertThisInitialized(self); }

function MultiLineString_assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function MultiLineString_getPrototypeOf(o) { MultiLineString_getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return MultiLineString_getPrototypeOf(o); }

function MultiLineString_inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) MultiLineString_setPrototypeOf(subClass, superClass); }

function MultiLineString_setPrototypeOf(o, p) { MultiLineString_setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return MultiLineString_setPrototypeOf(o, p); }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/



/**
 * @class SuperMap.Geometry.MultiLineString
 * @classdesc 几何对象多线类。
 * @category BaseTypes Geometry
 * @extends {SuperMap.Geometry.Collection}
 * @param {Array.<SuperMap.Geometry.LineString>} components - LineString 数组。
 * @example
 * var multi = new SuperMap.Geometry.MultiLineString([
 *      new SuperMap.Geometry.LineString([
 *          new SuperMap.Geometry.Point(1, 0),
 *          new SuperMap.Geometry.Point(0, 1)
 *      ])
 *  ]);
 */

var MultiLineString =
/*#__PURE__*/
function (_Collection) {
  MultiLineString_inherits(MultiLineString, _Collection);

  function MultiLineString(components) {
    var _this;

    MultiLineString_classCallCheck(this, MultiLineString);

    _this = MultiLineString_possibleConstructorReturn(this, MultiLineString_getPrototypeOf(MultiLineString).call(this, components));
    /**
     * @member {Array.<string>} [SuperMap.Geometry.MultiLineString.prototype.componentTypes=["SuperMap.Geometry.LineString"]]
     * @description components 存储的的几何对象所支持的几何类型数组。
     * @readonly
     */

    _this.componentTypes = ["SuperMap.Geometry.LineString"];
    _this.CLASS_NAME = "SuperMap.Geometry.MultiLineString";
    _this.geometryType = "MultiLineString";
    return _this;
  }

  return MultiLineString;
}(Collection_Collection);
SuperMap.Geometry.MultiLineString = MultiLineString;
// CONCATENATED MODULE: ./src/common/commontypes/geometry/MultiPolygon.js
function MultiPolygon_typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { MultiPolygon_typeof = function _typeof(obj) { return typeof obj; }; } else { MultiPolygon_typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return MultiPolygon_typeof(obj); }

function MultiPolygon_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function MultiPolygon_possibleConstructorReturn(self, call) { if (call && (MultiPolygon_typeof(call) === "object" || typeof call === "function")) { return call; } return MultiPolygon_assertThisInitialized(self); }

function MultiPolygon_assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function MultiPolygon_getPrototypeOf(o) { MultiPolygon_getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return MultiPolygon_getPrototypeOf(o); }

function MultiPolygon_inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) MultiPolygon_setPrototypeOf(subClass, superClass); }

function MultiPolygon_setPrototypeOf(o, p) { MultiPolygon_setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return MultiPolygon_setPrototypeOf(o, p); }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


/**
 * @class SuperMap.Geometry.MultiPolygon
 * @classdesc 几何对象多多边形类。
 * @category BaseTypes Geometry
 * @extends {SuperMap.Geometry.Collection}
 * @param  {Array.<SuperMap.Geometry.Polygon>} components - 形成 MultiPolygon 的多边形数组。
 * @example
 * var points1 = [new SuperMap.Geometry.Point(10,10),new SuperMap.Geometry.Point(0,0)];
 * var points2 = [new SuperMap.Geometry.Point(10,10),new SuperMap.Geometry.Point(0,0),new SuperMap.Geometry.Point(3,3),new SuperMap.Geometry.Point(10,10)];
 *
 * var linearRing1 = new SuperMap.Geometry.LinearRing(points1);
 * var linearRing2 = new SuperMap.Geometry.LinearRing(points2);
 *
 * var polygon1 = new SuperMap.Geometry.Polygon([linearRing1]);
 * var polygon2 = new SuperMap.Geometry.Polygon([linearRing2]);
 *
 * var multiPolygon1 = new SuperMap.Geometry.MultiPolygon([polygon1,polygon2]);
 */

var MultiPolygon =
/*#__PURE__*/
function (_Collection) {
  MultiPolygon_inherits(MultiPolygon, _Collection);

  function MultiPolygon(components) {
    var _this;

    MultiPolygon_classCallCheck(this, MultiPolygon);

    _this = MultiPolygon_possibleConstructorReturn(this, MultiPolygon_getPrototypeOf(MultiPolygon).call(this, components));
    /**
     * @member {Array.<string>} [SuperMap.Geometry.MultiPolygon.prototype.componentTypes=["SuperMap.Geometry.Polygon"]]
     * @description components 存储的的几何对象所支持的几何类型数组。
     * @readonly
     */

    _this.componentTypes = ["SuperMap.Geometry.Polygon"];
    _this.CLASS_NAME = "SuperMap.Geometry.MultiPolygon";
    _this.geometryType = "MultiPolygon";
    return _this;
  }

  return MultiPolygon;
}(Collection_Collection);
SuperMap.Geometry.MultiPolygon = MultiPolygon;
// CONCATENATED MODULE: ./src/common/commontypes/geometry/Polygon.js
function Polygon_typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { Polygon_typeof = function _typeof(obj) { return typeof obj; }; } else { Polygon_typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return Polygon_typeof(obj); }

function Polygon_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function Polygon_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function Polygon_createClass(Constructor, protoProps, staticProps) { if (protoProps) Polygon_defineProperties(Constructor.prototype, protoProps); if (staticProps) Polygon_defineProperties(Constructor, staticProps); return Constructor; }

function Polygon_possibleConstructorReturn(self, call) { if (call && (Polygon_typeof(call) === "object" || typeof call === "function")) { return call; } return Polygon_assertThisInitialized(self); }

function Polygon_assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function Polygon_getPrototypeOf(o) { Polygon_getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return Polygon_getPrototypeOf(o); }

function Polygon_inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) Polygon_setPrototypeOf(subClass, superClass); }

function Polygon_setPrototypeOf(o, p) { Polygon_setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return Polygon_setPrototypeOf(o, p); }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/





/**
 * @class SuperMap.Geometry.Polygon
 * @classdesc  多边形几何对象类。
 * @category BaseTypes Geometry
 * @extends {SuperMap.Geometry.Collection}
 * @param {Array.<SuperMap.Geometry.LinearRing>} components - 用来生成多边形的线环数组。
 * @example
 * var points =[new SuperMap.Geometry.Point(0,4010338),
 *      new SuperMap.Geometry.Point(1063524,4010338),
 *      new SuperMap.Geometry.Point(1063524,3150322),
 *      new SuperMap.Geometry.Point(0,3150322)
 *  ],
 *  var linearRings = new SuperMap.Geometry.LinearRing(points),
 *  var  region = new SuperMap.Geometry.Polygon([linearRings]);
 */

var Polygon =
/*#__PURE__*/
function (_Collection) {
  Polygon_inherits(Polygon, _Collection);

  function Polygon(components) {
    var _this;

    Polygon_classCallCheck(this, Polygon);

    _this = Polygon_possibleConstructorReturn(this, Polygon_getPrototypeOf(Polygon).call(this, components));
    /**
     * @member {Array.<string>} [SuperMap.Geometry.Polygon.prototype.componentTypes=["SuperMap.Geometry.LinearRing"]]
     * @description components 存储的的几何对象所支持的几何类型数组。
     * @readonly
     */

    _this.componentTypes = ["SuperMap.Geometry.LinearRing"];
    _this.CLASS_NAME = "SuperMap.Geometry.Polygon";
    _this.geometryType = "Polygon";
    return _this;
  }
  /**
   * @function SuperMap.Geometry.Polygon.prototype.getArea
   * @description 获得区域面积，从区域的外部口径减去计此区域内部口径算所得的面积。
   * @returns {float} 几何对象的面积。
   */


  Polygon_createClass(Polygon, [{
    key: "getArea",
    value: function getArea() {
      var area = 0.0;

      if (this.components && this.components.length > 0) {
        area += Math.abs(this.components[0].getArea());

        for (var i = 1, len = this.components.length; i < len; i++) {
          area -= Math.abs(this.components[i].getArea());
        }
      }

      return area;
    }
  }]);

  return Polygon;
}(Collection_Collection);
SuperMap.Geometry.Polygon = Polygon;
// CONCATENATED MODULE: ./src/common/commontypes/geometry/Rectangle.js
function Rectangle_typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { Rectangle_typeof = function _typeof(obj) { return typeof obj; }; } else { Rectangle_typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return Rectangle_typeof(obj); }

function Rectangle_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function Rectangle_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function Rectangle_createClass(Constructor, protoProps, staticProps) { if (protoProps) Rectangle_defineProperties(Constructor.prototype, protoProps); if (staticProps) Rectangle_defineProperties(Constructor, staticProps); return Constructor; }

function Rectangle_possibleConstructorReturn(self, call) { if (call && (Rectangle_typeof(call) === "object" || typeof call === "function")) { return call; } return Rectangle_assertThisInitialized(self); }

function Rectangle_assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function Rectangle_getPrototypeOf(o) { Rectangle_getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return Rectangle_getPrototypeOf(o); }

function Rectangle_inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) Rectangle_setPrototypeOf(subClass, superClass); }

function Rectangle_setPrototypeOf(o, p) { Rectangle_setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return Rectangle_setPrototypeOf(o, p); }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/



/**
 * @class  SuperMap.Geometry.Rectangle
 * @classdesc 矩形几何对象类。
 * @category BaseTypes Geometry
 * @param {float} x - 矩形左下角点的横坐标。
 * @param {float} y - 矩形左下角点的纵坐标。
 * @param {float} width - 矩形的宽度。
 * @param {float} height -  矩形的高度。
 * @extends {SuperMap.Geometry}
 * @example
 *  //x 为矩形左下角点的横坐标；y 为矩形左下角点的纵坐标；w 为矩形的宽度；h 为矩形的高度
 *  var x = 1;
 *  var y = 2;
 *  var w = 10;
 *  var h = 20;
 *  var recttangle = new SuperMap.Geometry.Rectangle(x, y, w, h);
 */

var Rectangle_Rectangle =
/*#__PURE__*/
function (_Geometry) {
  Rectangle_inherits(Rectangle, _Geometry);

  function Rectangle(x, y, width, height) {
    var _this;

    Rectangle_classCallCheck(this, Rectangle);

    _this = Rectangle_possibleConstructorReturn(this, Rectangle_getPrototypeOf(Rectangle).call(this, x, y, width, height));
    /**
     * @member {float} SuperMap.Geometry.Rectangle.prototype.x
     * @description 矩形左下角点的横坐标。
     */

    _this.x = x;
    /**
     * @member {float} SuperMap.Geometry.Rectangle.prototype.y
     * @description 矩形左下角点的纵坐标。
     */

    _this.y = y;
    /**
     * @member {float} SuperMap.Geometry.Rectangle.prototype.width
     * @description 矩形的宽度。
     */

    _this.width = width;
    /**
     * @member {float} SuperMap.Geometry.Rectangle.prototype.height
     * @description 矩形的高度。
     */

    _this.height = height;
    _this.CLASS_NAME = "SuperMap.Geometry.Rectangle";
    _this.geometryType = "Rectangle";
    return _this;
  }
  /**
   * @function SuperMap.Geometry.Rectangle.prototype.calculateBounds
   * @description 计算出此矩形对象的 bounds。
   */


  Rectangle_createClass(Rectangle, [{
    key: "calculateBounds",
    value: function calculateBounds() {
      this.bounds = new Bounds_Bounds(this.x, this.y, this.x + this.width, this.y + this.height);
    }
    /**
     * @function SuperMap.Geometry.Rectangle.prototype.getArea
     * @description 获取矩形对象的面积。
     * @returns {float} 矩形对象面积。
     */

  }, {
    key: "getArea",
    value: function getArea() {
      var area = this.width * this.height;
      return area;
    }
  }]);

  return Rectangle;
}(Geometry_Geometry);
SuperMap.Geometry.Rectangle = Rectangle_Rectangle;
// CONCATENATED MODULE: ./src/common/commontypes/geometry/index.js
/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/






















// CONCATENATED MODULE: ./src/common/commontypes/Credential.js
function Credential_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function Credential_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function Credential_createClass(Constructor, protoProps, staticProps) { if (protoProps) Credential_defineProperties(Constructor.prototype, protoProps); if (staticProps) Credential_defineProperties(Constructor, staticProps); return Constructor; }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/

/**
 * @class SuperMap.Credential
 * @category Security
 * @classdesc SuperMap 的安全证书类，其中包括 token 等安全验证信息。</br>
 * 需要使用用户名和密码在："http://localhost:8090/iserver/services/security/tokens" 下申请 value。</br>
 * 获得形如："2OMwGmcNlrP2ixqv1Mk4BuQMybOGfLOrljruX6VcYMDQKc58Sl9nMHsqQaqeBx44jRvKSjkmpZKK1L596y7skQ.." 的 value。</br>
 * 目前支持的功能包括：地图服务、专题图、量算、查询、公交换乘、空间分析、网络分析，不支持轮询功能。</br>
 * @param {string} value - 访问受安全限制的服务时用于通过安全认证的验证信息。
 * @param {string} [name='token'] - 验证信息前缀，name=value 部分的 name 部分。
 * @example
 * var pixcel = new SuperMap.Credential("valueString","token");
 * pixcel.destroy();
 */

var Credential =
/*#__PURE__*/
function () {
  function Credential(value, name) {
    Credential_classCallCheck(this, Credential);

    /**
     * @member {string} SuperMap.Bounds.prototype.value
     * @description 访问受安全限制的服务时用于通过安全认证的验证信息。
     */
    this.value = value ? value : "";
    /**
     * @member {string} [SuperMap.Bounds.prototype.name='token']
     * @description 验证信息前缀，name=value 部分的 name 部分。
     */

    this.name = name ? name : "token";
    this.CLASS_NAME = "SuperMap.Credential";
  }
  /**
   * @function SuperMap.Credential.prototype.getUrlParameters
   * @example
   * var credential = new SuperMap.Credential("valueString","token");
   * //这里 str = "token=valueString";
   * var str = credential.getUrlParameters();
   * @returns {string} 返回安全信息组成的 url 片段。
   */


  Credential_createClass(Credential, [{
    key: "getUrlParameters",
    value: function getUrlParameters() {
      //当需要其他安全信息的时候，则需要return this.name + "=" + this.value + "&" + "...";的形式添加。
      return this.name + "=" + this.value;
    }
    /**
     * @function SuperMap.Bounds.prototype.getValue
     * @description 获取 value。
     * @example
     * var credential = new SuperMap.Credential("2OMwGmcNlrP2ixqv1Mk4BuQMybOGfLOrljruX6VcYMDQKc58Sl9nMHsqQaqeBx44jRvKSjkmpZKK1L596y7skQ..","token");
     * //这里 str = "2OMwGmcNlrP2ixqv1Mk4BuQMybOGfLOrljruX6VcYMDQKc58Sl9nMHsqQaqeBx44jRvKSjkmpZKK1L596y7skQ..";
     * var str = credential.getValue();
     * @returns {string} 返回 value 字符串，在 iServer 服务下该 value 值即为 token 值。
     */

  }, {
    key: "getValue",
    value: function getValue() {
      return this.value;
    }
    /**
     *
     * @function SuperMap.Credential.prototype.destroy
     * @description 销毁此对象。销毁后此对象的所有属性为 null，而不是初始值。
     * @example
     * var credential = new SuperMap.Credential("valueString","token");
     * credential.destroy();
     */

  }, {
    key: "destroy",
    value: function destroy() {
      this.value = null;
      this.name = null;
    }
  }]);

  return Credential;
}();
/**
 * @member {SuperMap.Credential} SuperMap.Credential.CREDENTIAL
 * @description 这个对象保存一个安全类的实例，在服务端需要安全验证的时候必须进行设置。
 * @constant
 * @example
 * 代码实例:
 *  // 当iServer启用服务安全的时候，下边的代码是必须的。安全证书类能够接收一个value和一个name参数。
 *  var value = "(以iServer为例，这里是申请的token值)";
 *  var name = "token";
 *  // 默认name参数为token，所以当使用iServer服务的时候可以不进行设置。
 *  SuperMap.Credential.CREDENTIAL = new SuperMap.Credential(value, name);
 *
 */

Credential.CREDENTIAL = null;
SuperMap.Credential = Credential;
// CONCATENATED MODULE: ./src/common/commontypes/Date.js
/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/

/**
 * @name Date
 * @memberOf SuperMap
 * @namespace
 * @category BaseTypes Util
 * @description 包含 parse、toISOString 方法的实现，两个方法用来解析 RFC 3339 日期，遵循 ECMAScript 5 规范。
 */

var DateExt = SuperMap.Date = {
  /**
   * @description 生成代表一个具体的日期字符串，该日期遵循 ISO 8601 标准（详情查看{@link http://tools.ietf.org/html/rfc3339}）。
   * @example
   *  var dateString = SuperMap.Date.toISOString(new Date());
   * @param {Date} date - 日期对象。
   * @returns {string} 一个代表日期的字符串。（例如 "2010-08-07T16:58:23.123Z"）。
   */
  toISOString: function () {
    //标准的Date会存在toISOString方法，可以直接调用
    if ("toISOString" in Date.prototype) {
      return function (date) {
        return date.toISOString();
      };
    } else {
      // 部分浏览器没有，就得自己组合，组合后的字符串规则不变
      var pad = function pad(num, len) {
        var str = num + "";

        while (str.length < len) {
          str = "0" + str;
        }

        return str;
      };

      return function (date) {
        var str;

        if (isNaN(date.getTime())) {
          // ECMA-262 says throw RangeError, Firefox returns
          // "Invalid Date"
          str = "Invalid Date";
        } else {
          str = date.getUTCFullYear() + "-" + pad(date.getUTCMonth() + 1, 2) + "-" + pad(date.getUTCDate(), 2) + "T" + pad(date.getUTCHours(), 2) + ":" + pad(date.getUTCMinutes(), 2) + ":" + pad(date.getUTCSeconds(), 2) + "." + pad(date.getUTCMilliseconds(), 3) + "Z";
        }

        return str;
      };
    }
  }(),

  /**
   * @description 从一个字符串生成一个日期对象。
   * @example
   *  var date = SuperMap.Date.parse("2010-08-07");
   * @param {string} str - 代表日期的字符串。（例如： "2010", "2010-08", "2010-08-07", "2010-08-07T16:58:23.123Z","2010-08-07T11:58:23.123-06"）。
   * @returns {Date} 日期对象，如果字符串无法被解析，则返回一个无效的日期。(例如 isNaN(date.getTime()))。
   */
  parse: function parse(str) {
    var date;
    var match = str.match(/^(?:(\d{4})(?:-(\d{2})(?:-(\d{2}))?)?)?(?:(?:T(\d{1,2}):(\d{2}):(\d{2}(?:\.\d+)?)(Z|(?:[+-]\d{1,2}(?::(\d{2}))?)))|Z)?$/);

    if (match && (match[1] || match[7])) {
      // must have at least year or time
      var year = parseInt(match[1], 10) || 0;
      var month = parseInt(match[2], 10) - 1 || 0;
      var day = parseInt(match[3], 10) || 1;
      date = new Date(Date.UTC(year, month, day)); // optional time

      var type = match[7];

      if (type) {
        var hours = parseInt(match[4], 10);
        var minutes = parseInt(match[5], 10);
        var secFrac = parseFloat(match[6]);
        var seconds = secFrac | 0;
        var milliseconds = Math.round(1000 * (secFrac - seconds));
        date.setUTCHours(hours, minutes, seconds, milliseconds); // check offset

        if (type !== "Z") {
          var hoursOffset = parseInt(type, 10);
          var minutesOffset = parseInt(match[8], 10) || 0;
          var offset = -1000 * (60 * (hoursOffset * 60) + minutesOffset * 60);
          date = new Date(date.getTime() + offset);
        }
      }
    } else {
      date = new Date("invalid");
    }

    return date;
  }
};
// CONCATENATED MODULE: ./src/common/commontypes/Event.js
/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


/**
 * @name Event
 * @memberOf SuperMap
 * @namespace
 * @description 事件处理函数.
 */

var Event = SuperMap.Event = {
  /**
   * @description  A hash table cache of the event observers. Keyed by element._eventCacheID
   * @type {boolean}
   * @default false
   */
  observers: false,

  /**
   * @description KEY_SPACE
   * @type {number}
   * @default 32
   */
  KEY_SPACE: 32,

  /**
   * @description KEY_BACKSPACE
   * @type {number}
   * @default 8
   */
  KEY_BACKSPACE: 8,

  /**
   * @description KEY_TAB
   * @type {number}
   * @default 9
   */
  KEY_TAB: 9,

  /**
   * @description KEY_RETURN
   * @type {number}
   * @default 13
   */
  KEY_RETURN: 13,

  /**
   * @description KEY_ESC
   * @type {number}
   * @default 27
   */
  KEY_ESC: 27,

  /**
   * @description KEY_LEFT
   * @type {number}
   * @default 37
   */
  KEY_LEFT: 37,

  /**
   * @description KEY_UP
   * @type {number}
   * @default 38
   */
  KEY_UP: 38,

  /**
   * @description KEY_RIGHT
   * @type {number}
   * @default 39
   */
  KEY_RIGHT: 39,

  /**
   * @description KEY_DOWN
   * @type {number}
   * @default 40
   */
  KEY_DOWN: 40,

  /**
   * @description KEY_DELETE
   * @type {number}
   * @default 46
   */
  KEY_DELETE: 46,

  /**
   * @description Cross browser event element detection.
   * @param {Event} event - The event
   * @returns {HTMLElement} The element that caused the event
   */
  element: function element(event) {
    return event.target || event.srcElement;
  },

  /**
   * @description Determine whether event was caused by a single touch
   * @param {Event} event - The event
   * @returns {boolean}
   */
  isSingleTouch: function isSingleTouch(event) {
    return event.touches && event.touches.length === 1;
  },

  /**
   * @description Determine whether event was caused by a multi touch
   * @param {Event} event - The event
   * @returns {boolean}
   */
  isMultiTouch: function isMultiTouch(event) {
    return event.touches && event.touches.length > 1;
  },

  /**
   * @description Determine whether event was caused by a left click.
   * @param {Event} event - The event
   * @returns {boolean}
   */
  isLeftClick: function isLeftClick(event) {
    return event.which && event.which === 1 || event.button && event.button === 1;
  },

  /**
   * @description Determine whether event was caused by a right mouse click.
   * @param {Event} event - The event
   * @returns {boolean}
   */
  isRightClick: function isRightClick(event) {
    return event.which && event.which === 3 || event.button && event.button === 2;
  },

  /**
   * @description Stops an event from propagating.
   * @param {Event} event - The event
   * @param {boolean} allowDefault - If true, we stop the event chain but still allow the default browser  behaviour (text selection, radio-button clicking, etc) Default false
   */
  stop: function stop(event, allowDefault) {
    if (!allowDefault) {
      if (event.preventDefault) {
        event.preventDefault();
      } else {
        event.returnValue = false;
      }
    }

    if (event.stopPropagation) {
      event.stopPropagation();
    } else {
      event.cancelBubble = true;
    }
  },

  /**
   * @param {Event} event - The event。
   * @param {string} tagName - html 标签名。
   * @returns {HTMLElement} The first node with the given tagName, starting from the node the event was triggered on and traversing the DOM upwards
   */
  findElement: function findElement(event, tagName) {
    var element = SuperMap.Event.element(event);

    while (element.parentNode && (!element.tagName || element.tagName.toUpperCase() != tagName.toUpperCase())) {
      element = element.parentNode;
    }

    return element;
  },

  /**
   * @description 监听事件，注册事件处理方法。
   * @param {(HTMLElement|string)} elementParam - 待监听的 DOM 对象或者其 ID 标识。
   * @param {string} name - 监听事件的类别名称。
   * @param {function} observer - 注册的事件处理方法。
   * @param {boolean} [useCapture=false] - 是否捕获。
   */
  observe: function observe(elementParam, name, observer, useCapture) {
    var element = Util.getElement(elementParam);
    useCapture = useCapture || false;

    if (name === 'keypress' && (navigator.appVersion.match(/Konqueror|Safari|KHTML/) || element.attachEvent)) {
      name = 'keydown';
    } //if observers cache has not yet been created, create it


    if (!this.observers) {
      this.observers = {};
    } //if not already assigned, make a new unique cache ID


    if (!element._eventCacheID) {
      var idPrefix = "eventCacheID_";

      if (element.id) {
        idPrefix = element.id + "_" + idPrefix;
      }

      element._eventCacheID = Util.createUniqueID(idPrefix);
    }

    var cacheID = element._eventCacheID; //if there is not yet a hash entry for this element, add one

    if (!this.observers[cacheID]) {
      this.observers[cacheID] = [];
    } //add a new observer to this element's list


    this.observers[cacheID].push({
      'element': element,
      'name': name,
      'observer': observer,
      'useCapture': useCapture
    }); //add the actual browser event listener

    if (element.addEventListener) {
      if (name === 'mousewheel') {
        // https://www.chromestatus.com/features/6662647093133312
        element.addEventListener(name, observer, {
          useCapture: useCapture,
          passive: false
        });
      } else {
        element.addEventListener(name, observer, useCapture);
      }
    } else if (element.attachEvent) {
      element.attachEvent('on' + name, observer);
    }
  },

  /**
   * @description Given the id of an element to stop observing, cycle through the
   *   element's cached observers, calling stopObserving on each one,
   *   skipping those entries which can no longer be removed.
   *
   * @param {(HTMLElement|string)} elementParam - 
   */
  stopObservingElement: function stopObservingElement(elementParam) {
    var element = Util.getElement(elementParam);
    var cacheID = element._eventCacheID;

    this._removeElementObservers(SuperMap.Event.observers[cacheID]);
  },

  /**
   * @param {Array.<Object>} elementObservers - Array of (element, name,
   *                                         observer, usecapture) objects,
   *                                         taken directly from hashtable
   */
  _removeElementObservers: function _removeElementObservers(elementObservers) {
    if (elementObservers) {
      for (var i = elementObservers.length - 1; i >= 0; i--) {
        var entry = elementObservers[i];
        var args = new Array(entry.element, entry.name, entry.observer, entry.useCapture);
        SuperMap.Event.stopObserving.apply(this, args);
      }
    }
  },

  /**
   * @description 移除事件监听和注册的事件处理方法。注意：事件的移除和监听相对应，移除时的各属性信息必须监听时
   * 保持一致才能确保事件移除成功。
   * @param {(HTMLElement|string)} elementParam - 被监听的 DOM 元素或者其 ID。
   * @param {string} name - 需要移除的被监听事件名称。
   * @param {function} observer - 需要移除的事件处理方法。
   * @param {boolean} [useCapture=false] - 是否捕获。
   * @returns {boolean} Whether or not the event observer was removed
   */
  stopObserving: function stopObserving(elementParam, name, observer, useCapture) {
    useCapture = useCapture || false;
    var element = Util.getElement(elementParam);
    var cacheID = element._eventCacheID;

    if (name === 'keypress') {
      if (navigator.appVersion.match(/Konqueror|Safari|KHTML/) || element.detachEvent) {
        name = 'keydown';
      }
    } // find element's entry in this.observers cache and remove it


    var foundEntry = false;
    var elementObservers = SuperMap.Event.observers[cacheID];

    if (elementObservers) {
      // find the specific event type in the element's list
      var i = 0;

      while (!foundEntry && i < elementObservers.length) {
        var cacheEntry = elementObservers[i];

        if (cacheEntry.name === name && cacheEntry.observer === observer && cacheEntry.useCapture === useCapture) {
          elementObservers.splice(i, 1);

          if (elementObservers.length == 0) {
            delete SuperMap.Event.observers[cacheID];
          }

          foundEntry = true;
          break;
        }

        i++;
      }
    } //actually remove the event listener from browser


    if (foundEntry) {
      if (element.removeEventListener) {
        element.removeEventListener(name, observer, useCapture);
      } else if (element && element.detachEvent) {
        element.detachEvent('on' + name, observer);
      }
    }

    return foundEntry;
  },

  /**
   * @description Cycle through all the element entries in the events cache and call
   *   stopObservingElement on each.
   */
  unloadCache: function unloadCache() {
    // check for SuperMap.Event before checking for observers, because
    // SuperMap.Event may be undefined in IE if no map instance was
    // created
    if (SuperMap.Event && SuperMap.Event.observers) {
      for (var cacheID in SuperMap.Event.observers) {
        var elementObservers = SuperMap.Event.observers[cacheID];

        SuperMap.Event._removeElementObservers.apply(this, [elementObservers]);
      }

      SuperMap.Event.observers = false;
    }
  },
  CLASS_NAME: "SuperMap.Event"
};
SuperMap.Event = Event;
/* prevent memory leaks in IE */

SuperMap.Event.observe(window, 'unload', SuperMap.Event.unloadCache, false);
// CONCATENATED MODULE: ./src/common/commontypes/Events.js
function Events_typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { Events_typeof = function _typeof(obj) { return typeof obj; }; } else { Events_typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return Events_typeof(obj); }

function Events_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function Events_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function Events_createClass(Constructor, protoProps, staticProps) { if (protoProps) Events_defineProperties(Constructor.prototype, protoProps); if (staticProps) Events_defineProperties(Constructor, staticProps); return Constructor; }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/





/**
 * @class SuperMap.Events
 * @classdesc 事件类。
 * @param {Object} object - 当前事件对象被添加到的 JS 对象。
 * @param {HTMLElement} element - 响应浏览器事件的 DOM 元素。
 * @param {Array.<string>} eventTypes - 自定义应用事件的数组。
 * @param {boolean} [fallThrough=false] - 是否允许事件处理之后向上传递（冒泡），为 false 的时候阻止事件冒泡。
 * @param {Object} options - 事件对象选项。
 */

var Events_Events =
/*#__PURE__*/
function () {
  function Events(object, element, eventTypes, fallThrough, options) {
    Events_classCallCheck(this, Events);

    /**
     * @member {Array.<string>} SuperMap.Events.prototype.BROWSER_EVENTS
     * @description 支持的事件。
     * @constant
     * @default [
     "mouseover", "mouseout","mousedown", "mouseup", "mousemove",
     "click", "dblclick", "rightclick", "dblrightclick","resize",
     "focus", "blur","touchstart", "touchmove", "touchend","keydown",
     "MSPointerDown", "MSPointerUp", "pointerdown", "pointerup",
     "MSGestureStart", "MSGestureChange", "MSGestureEnd","contextmenu"
     ]
     */
    this.BROWSER_EVENTS = ["mouseover", "mouseout", "mousedown", "mouseup", "mousemove", "click", "dblclick", "rightclick", "dblrightclick", "resize", "focus", "blur", "touchstart", "touchmove", "touchend", "keydown", "MSPointerDown", "MSPointerUp", "pointerdown", "pointerup", "MSGestureStart", "MSGestureChange", "MSGestureEnd", "contextmenu"];
    /**
     * @member {Object} SuperMap.Events.prototype.listeners
     * @description Hashtable of Array(function): events listener functions
     */

    this.listeners = {};
    /**
     * @member {Object} SuperMap.Events.prototype.object
     * @description  发布应用程序事件的对象。
     */

    this.object = object;
    /**
     * @member {HTMLElement} SuperMap.Events.prototype.element
     * @description 接受浏览器事件的 DOM 节点。
     */

    this.element = null;
    /**
     * @member {Array.<string>} SuperMap.Events.prototype.eventTypes
     * @description 支持的事件类型列表。
     */

    this.eventTypes = [];
    /**
     * @member {function} SuperMap.Events.prototype.eventHandler
     * @description 绑定在元素上的事件处理器对象。
     */

    this.eventHandler = null;
    /**
     * @member {boolean} [SuperMap.Events.prototype.fallThrough=false]
     * @description 是否允许事件处理之后向上传递（冒泡），为 false 的时候阻止事件冒泡。
     */

    this.fallThrough = fallThrough;
    /**
     * @member {boolean} [SuperMap.Events.prototype.includeXY=false]
     * @description 判断是否让 xy 属性自动创建到浏览器上的鼠标事件，一般设置为 false，如果设置为 true，鼠标事件将会在事件传递过程中自动产生 xy 属性。
     *              可根据事件对象的 'evt.object' 属性在相关的事件句柄上调用 getMousePosition 函数。这个选项习惯默认为 false 的原因在于，当创建一个
     *              事件对象，其主要目的是管理。在一个 div 的相对定位的鼠标事件，将其设为 true 也是有意义的。这个选项也可以用来控制是否抵消缓存。如果
     *              设为 false 不抵消，如果设为 true，用 this.clearMouseCache() 清除缓存偏移（边界元素偏移，元素在页面的位置偏移）。
     * @example
     *  function named(evt) {
     *        this.xy = this.object.events.getMousePosition(evt);
     *  }
     */

    this.includeXY = false;
    /**
     * @member {Object} SuperMap.Events.prototype.extensions
     * @description 事件扩展。Keys 代表事件类型，values 代表事件对象。
     * @example
     * 以扩展 "foostart" 和 "fooend" 事件为例。展示替换 css 属性为 foo 的元素的 click 事件。
     *
     *   SuperMap.Events.foostart = SuperMap.Class({
    *       initialize: function(target) {
    *           this.target = target;
    *           this.target.register("click", this, this.doStuff, {extension: true});
    *           // only required if extension provides more than one event type
    *           this.target.extensions["foostart"] = true;
    *           this.target.extensions["fooend"] = true;
    *       },
    *       destroy: function() {
    *           var target = this.target;
    *           target.unregister("click", this, this.doStuff);
    *           delete this.target;
    *           // only required if extension provides more than one event type
    *           delete target.extensions["foostart"];
    *           delete target.extensions["fooend"];
    *       },
    *       doStuff: function(evt) {
    *           var propagate = true;
    *           if (SuperMap.Event.element(evt).className === "foo") {
    *               propagate = false;
    *               var target = this.target;
    *               target.triggerEvent("foostart");
    *               window.setTimeout(function() {
    *                   target.triggerEvent("fooend");
    *               }, 1000);
    *           }
    *           return propagate;
    *       }
    *   });
     *   // only required if extension provides more than one event type
     *   SuperMap.Events.fooend = SuperMap.Events.foostart;
     */

    this.extensions = {};
    /**
     * @member {Object} SuperMap.Events.prototype.extensionCount
     */

    this.extensionCount = {};
    /**
     * @member {Object} SuperMap.Events.prototype.clearMouseListener
     */

    this.clearMouseListener = null;
    Util.extend(this, options);

    if (eventTypes != null) {
      for (var i = 0, len = eventTypes.length; i < len; i++) {
        this.addEventType(eventTypes[i]);
      }
    }

    if (element != null) {
      this.attachToElement(element);
    }

    this.CLASS_NAME = "SuperMap.Events";
  }
  /**
   * @function SuperMap.Events.prototype.destroy
   * @description 移除当前要素 element 上的所有事件监听和处理。
   */


  Events_createClass(Events, [{
    key: "destroy",
    value: function destroy() {
      for (var e in this.extensions) {
        if (typeof this.extensions[e] !== "boolean") {
          this.extensions[e].destroy();
        }
      }

      this.extensions = null;

      if (this.element) {
        Event.stopObservingElement(this.element);

        if (this.element.hasScrollEvent) {
          Event.stopObserving(window, "scroll", this.clearMouseListener);
        }
      }

      this.element = null;
      this.listeners = null;
      this.object = null;
      this.eventTypes = null;
      this.fallThrough = null;
      this.eventHandler = null;
    }
    /**
     * @function SuperMap.Events.prototype.addEventType
     * @description 在此事件对象中添加新的事件类型，如果这个事件类型已经添加过了，则不做任何事情。
     * @param {string} eventName - 事件名。
     */

  }, {
    key: "addEventType",
    value: function addEventType(eventName) {
      if (!this.listeners[eventName]) {
        this.eventTypes.push(eventName);
        this.listeners[eventName] = [];
      }
    }
    /**
     * @function SuperMap.Events.prototype.attachToElement
     * @description 给 DOM 元素绑定浏览器事件。
     * @param {HTMLDOMElement} element - 绑定浏览器事件的 DOM 元素。
     */

  }, {
    key: "attachToElement",
    value: function attachToElement(element) {
      if (this.element) {
        Event.stopObservingElement(this.element);
      } else {
        // keep a bound copy of handleBrowserEvent() so that we can
        // pass the same function to both Event.observe() and .stopObserving()
        this.eventHandler = FunctionExt.bindAsEventListener(this.handleBrowserEvent, this); // to be used with observe and stopObserving

        this.clearMouseListener = FunctionExt.bind(this.clearMouseCache, this);
      }

      this.element = element;

      for (var i = 0, len = this.BROWSER_EVENTS.length; i < len; i++) {
        var eventType = this.BROWSER_EVENTS[i]; // every browser event has a corresponding application event
        // (whether it's listened for or not).

        this.addEventType(eventType); // use Prototype to register the event cross-browser

        Event.observe(element, eventType, this.eventHandler);
      } // disable dragstart in IE so that mousedown/move/up works normally


      Event.observe(element, "dragstart", Event.stop);
    }
    /**
     * @function SuperMap.Events.prototype.on
     * @description 在一个相同的范围内注册监听器的方法，此方法调用 register 函数。
     * @example
     * // 注册一个 "loadstart" 监听事件
     * events.on({"loadstart": loadStartListener});
     *
     * // 同样注册一个 "loadstart" 监听事件
     * events.register("loadstart", undefined, loadStartListener);
     *
     * // 同时为对象注册多个监听事件
     * events.on({
     *     "loadstart": loadStartListener,
     *     "loadend": loadEndListener,
     *     scope: object
     * });
     *
     * // 同时为对象注册多个监听事件，多次调用 register 方法
     * events.register("loadstart", object, loadStartListener);
     * events.register("loadend", object, loadEndListener);
     *
     *
     * @param {Object} object - 添加监听的对象。
     */

  }, {
    key: "on",
    value: function on(object) {
      for (var type in object) {
        if (type !== "scope" && object.hasOwnProperty(type)) {
          this.register(type, object.scope, object[type]);
        }
      }
    }
    /**
     * @function SuperMap.Events.prototype.register
     * @description 在事件对象上注册一个事件。当事件被触发时，'func' 函数被调用，假设我们触发一个事件，
     *              指定 SuperMap.Bounds 作为 "obj"，当事件被触发时，回调函数的上下文作为 Bounds 对象。
     * @param {string} type - 事件注册者的名字。
     * @param {Object} [obj=this.object] - 对象绑定的回调。
     * @param {function} [func] - 回调函数，如果没有特定的回调，则这个函数不做任何事情。
     * @param {(boolean|Object)} [priority] - 当为 true 时将新的监听加在事件队列的前面。
     */

  }, {
    key: "register",
    value: function register(type, obj, func, priority) {
      if (type in Events && !this.extensions[type]) {
        this.extensions[type] = new Events[type](this);
      }

      if (func != null && Util.indexOf(this.eventTypes, type) !== -1) {
        if (obj == null) {
          obj = this.object;
        }

        var listeners = this.listeners[type];

        if (!listeners) {
          listeners = [];
          this.listeners[type] = listeners;
          this.extensionCount[type] = 0;
        }

        var listener = {
          obj: obj,
          func: func
        };

        if (priority) {
          listeners.splice(this.extensionCount[type], 0, listener);

          if (Events_typeof(priority) === "object" && priority.extension) {
            this.extensionCount[type]++;
          }
        } else {
          listeners.push(listener);
        }
      }
    }
    /**
     * @function SuperMap.Events.prototype.registerPriority
     * @description 相同的注册方法，但是在前面增加新的监听者事件查询而代替到方法的结束。
     * @param {string} type - 事件注册者的名字。
     * @param {Object} [obj=this.object] - 对象绑定方面的回调。
     * @param {function} [func] - 回调函数，如果没有特定的回调，则这个函数不做任何事情。
     */

  }, {
    key: "registerPriority",
    value: function registerPriority(type, obj, func) {
      this.register(type, obj, func, true);
    }
    /**
     * @function SuperMap.Events.prototype.un
     * @description 在一个相同的范围内取消注册监听器的方法，此方法调用 unregister 函数。
     * @example
     * // 移除 "loadstart" 事件监听
     * events.un({"loadstart": loadStartListener});
     *
     * // 使用 "unregister" 方法移除 "loadstart" 事件监听
     * events.unregister("loadstart", undefined, loadStartListener);
     *
     * // 取消对象多个事件监听
     * events.un({
     *     "loadstart": loadStartListener,
     *     "loadend": loadEndListener,
     *     scope: object
     * });
     *
     * // 取消对象多个事件监听，多次调用unregister方法。
     * events.unregister("loadstart", object, loadStartListener);
     * events.unregister("loadend", object, loadEndListener);
     *
     * @param {Object} object - 移除监听的对象。
     */

  }, {
    key: "un",
    value: function un(object) {
      for (var type in object) {
        if (type !== "scope" && object.hasOwnProperty(type)) {
          this.unregister(type, object.scope, object[type]);
        }
      }
    }
    /**
     * @function SuperMap.Events.prototype.unregister
     * @description 取消注册。
     * @param {string} type - 事件类型。
     * @param {Object} [obj=this.object] - 对象绑定方面的回调。
     * @param {function} [func] - 回调函数，如果没有特定的回调，则这个函数不做任何事情。
     */

  }, {
    key: "unregister",
    value: function unregister(type, obj, func) {
      if (obj == null) {
        obj = this.object;
      }

      var listeners = this.listeners[type];

      if (listeners != null) {
        for (var i = 0, len = listeners.length; i < len; i++) {
          if (listeners[i].obj === obj && listeners[i].func === func) {
            listeners.splice(i, 1);
            break;
          }
        }
      }
    }
    /**
     * @function SuperMap.Events.prototype.remove
     * @description 删除某个事件类型的所有监听，如果该事件类型没有注册，则不做任何操作。
     * @param {string} type - 事件类型。
     */

  }, {
    key: "remove",
    value: function remove(type) {
      if (this.listeners[type] != null) {
        this.listeners[type] = [];
      }
    }
    /**
     * @function SuperMap.Events.prototype.triggerEvent
     * @description 触发一个特定的注册事件。
     * @param {string} type - 触发事件类型。
     * @param {Event} evt - 事件对象。
     * @returns {boolean} 返回监听对象，如果返回是 false，则停止监听。
     */

  }, {
    key: "triggerEvent",
    value: function triggerEvent(type, evt) {
      var listeners = this.listeners[type]; // fast path

      if (!listeners || listeners.length == 0) {
        return undefined;
      } // prep evt object with object & div references


      if (evt == null) {
        evt = {};
      }

      evt.object = this.object;
      evt.element = this.element;

      if (!evt.type) {
        evt.type = type;
      } // execute all callbacks registered for specified type
      // get a clone of the listeners array to
      // allow for splicing during callbacks


      listeners = listeners.slice();
      var continueChain;

      for (var i = 0, len = listeners.length; i < len; i++) {
        var callback = listeners[i]; // bind the context to callback.obj

        continueChain = callback.func.apply(callback.obj, [evt]);

        if (continueChain != undefined && continueChain === false) {
          // if callback returns false, execute no more callbacks.
          break;
        }
      } // don't fall through to other DOM elements


      if (!this.fallThrough) {
        Event.stop(evt, true);
      }

      return continueChain;
    }
    /**
     * @function SuperMap.Events.prototype.handleBrowserEvent
     * @description 对 triggerEvent 函数的包装，给事件对象设置了 xy 属性（即当前鼠标点的 xy 坐标）。
     * @param {Event} evt - 事件对象。
     */

  }, {
    key: "handleBrowserEvent",
    value: function handleBrowserEvent(evt) {
      var type = evt.type,
          listeners = this.listeners[type];

      if (!listeners || listeners.length == 0) {
        // noone's listening, bail out
        return;
      } // add clientX & clientY to all events - corresponds to average x, y


      var touches = evt.touches;

      if (touches && touches[0]) {
        var x = 0;
        var y = 0;
        var num = touches.length;
        var touch;

        for (var i = 0; i < num; ++i) {
          touch = touches[i];
          x += touch.clientX;
          y += touch.clientY;
        }

        evt.clientX = x / num;
        evt.clientY = y / num;
      }

      if (this.includeXY) {
        evt.xy = this.getMousePosition(evt);
      }

      this.triggerEvent(type, evt);
    }
    /**
     * @function SuperMap.Events.prototype.clearMouseCache
     * @description 清除鼠标缓存。
     */

  }, {
    key: "clearMouseCache",
    value: function clearMouseCache() {
      this.element.scrolls = null;
      this.element.lefttop = null;
      var body = document.body;

      if (body && !((body.scrollTop != 0 || body.scrollLeft != 0) && navigator.userAgent.match(/iPhone/i))) {
        this.element.offsets = null;
      }
    }
    /**
     * @function SuperMap.Events.prototype.getMousePosition
     * @param {Event} evt - 事件对象。
     * @returns {SuperMap.Pixel} 当前的鼠标的 xy 坐标点。
     */

  }, {
    key: "getMousePosition",
    value: function getMousePosition(evt) {
      if (!this.includeXY) {
        this.clearMouseCache();
      } else if (!this.element.hasScrollEvent) {
        Event.observe(window, "scroll", this.clearMouseListener);
        this.element.hasScrollEvent = true;
      }

      if (!this.element.scrolls) {
        var viewportElement = Util.getViewportElement();
        this.element.scrolls = [viewportElement.scrollLeft, viewportElement.scrollTop];
      }

      if (!this.element.lefttop) {
        this.element.lefttop = [document.documentElement.clientLeft || 0, document.documentElement.clientTop || 0];
      }

      if (!this.element.offsets) {
        this.element.offsets = Util.pagePosition(this.element);
      }

      return new Pixel_Pixel(evt.clientX + this.element.scrolls[0] - this.element.offsets[0] - this.element.lefttop[0], evt.clientY + this.element.scrolls[1] - this.element.offsets[1] - this.element.lefttop[1]);
    }
  }]);

  return Events;
}();
SuperMap.Events = Events_Events;
SuperMap.Events.prototype.BROWSER_EVENTS = ["mouseover", "mouseout", "mousedown", "mouseup", "mousemove", "click", "dblclick", "rightclick", "dblrightclick", "resize", "focus", "blur", "touchstart", "touchmove", "touchend", "keydown", "MSPointerDown", "MSPointerUp", "pointerdown", "pointerup", "MSGestureStart", "MSGestureChange", "MSGestureEnd", "contextmenu"];
// CONCATENATED MODULE: ./src/common/commontypes/Feature.js
function Feature_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function Feature_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function Feature_createClass(Constructor, protoProps, staticProps) { if (protoProps) Feature_defineProperties(Constructor.prototype, protoProps); if (staticProps) Feature_defineProperties(Constructor, staticProps); return Constructor; }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


/**
 * @class SuperMap.Feature
 * @category BaseTypes Geometry
 * @classdesc 要素类组合了地理和属性，Feature 类同时具有 marker 和 lonlat 属性。
 * @param {SuperMap.Layer} layer - 图层。
 * @param {SuperMap.LonLat} lonlat - 经纬度。
 * @param {Object} data - 数据对象。
 */

var Feature_Feature =
/*#__PURE__*/
function () {
  function Feature(layer, lonlat, data) {
    Feature_classCallCheck(this, Feature);

    this.CLASS_NAME = "SuperMap.Feature";
    /**
     * @deprecated
     * @member {SuperMap.Layer} SuperMap.Feature.prototype.layer
     * @description 图层。
     */

    this.layer = layer;
    /**
     * @member {string} SuperMap.Feature.prototype.id
     * @description 要素 ID。
     */

    this.id = Util.createUniqueID(this.CLASS_NAME + "_");
    /**
     * @member {SuperMap.LonLat} SuperMap.Feature.prototype.lonlat
     * @description 经纬度。
     *
     */

    this.lonlat = lonlat;
    /**
     * @member {Object} SuperMap.Feature.prototype.data
     * @description 数据对象。
     */

    this.data = data != null ? data : {};
  }
  /**
   * @function SuperMap.Feature.prototype.destroy
   * @description 释放相关资源。
   */


  Feature_createClass(Feature, [{
    key: "destroy",
    value: function destroy() {
      this.id = null;
      this.lonlat = null;
      this.data = null;
    }
  }]);

  return Feature;
}();
SuperMap.Feature = Feature_Feature;
// CONCATENATED MODULE: ./src/common/commontypes/Vector.js
function Vector_typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { Vector_typeof = function _typeof(obj) { return typeof obj; }; } else { Vector_typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return Vector_typeof(obj); }

function Vector_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function Vector_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function Vector_createClass(Constructor, protoProps, staticProps) { if (protoProps) Vector_defineProperties(Constructor.prototype, protoProps); if (staticProps) Vector_defineProperties(Constructor, staticProps); return Constructor; }

function Vector_possibleConstructorReturn(self, call) { if (call && (Vector_typeof(call) === "object" || typeof call === "function")) { return call; } return Vector_assertThisInitialized(self); }

function Vector_assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function Vector_get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { Vector_get = Reflect.get; } else { Vector_get = function _get(target, property, receiver) { var base = Vector_superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return Vector_get(target, property, receiver || target); }

function Vector_superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = Vector_getPrototypeOf(object); if (object === null) break; } return object; }

function Vector_getPrototypeOf(o) { Vector_getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return Vector_getPrototypeOf(o); }

function Vector_inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) Vector_setPrototypeOf(subClass, superClass); }

function Vector_setPrototypeOf(o, p) { Vector_setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return Vector_setPrototypeOf(o, p); }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/



/**
 * @class SuperMap.Feature.Vector
 * @category BaseTypes Geometry
 * @classdesc 矢量要素类。该类具有 Geometry 属性存放几何信息，
 * attributes 属性存放非几何信息，另外还包含了 style 属性，用来定义矢量要素的样式，
 * 其中，默认的样式在 {@link SuperMap.Feature.Vector.style} 类中定义，如果没有特别的指定将使用默认的样式。
 * @extends {SuperMap.Feature}
 * @param {SuperMap.Geometry} geometry - 代表要素的几何形状。
 * @param {Object} [attributes] - 描述要素的任意的可序列化属性，将要映射到 attributes 属性中的对象。
 * @param {Object} [style] - 样式对象。
 * @example
 * var geometry = new SuperMap.Geometry.Point(-115,10);
 *  var style = {
     *      strokeColor:"#339933",
     *      strokeOpacity:1,
     *      strokeWidth:3,
     *      pointRadius:6
     *  }
 *  var pointFeature = new SuperMap.Feature.Vector(geometry,null,style);
 *  vectorLayer.addFeatures(pointFeature);
 */

var Vector_Vector =
/*#__PURE__*/
function (_Feature) {
  Vector_inherits(Vector, _Feature);

  function Vector(geometry, attributes, style) {
    var _this;

    Vector_classCallCheck(this, Vector);

    _this = Vector_possibleConstructorReturn(this, Vector_getPrototypeOf(Vector).call(this, null, null, attributes));
    /**
     * @member {string} SuperMap.Feature.Vector.prototype.fid
     * @description fid
     */

    _this.fid = null;
    /**
     * @member {SuperMap.Geometry} SuperMap.Feature.Vector.prototype.geometry
     * @description 该属性用于存放几何信息。
     */

    _this.geometry = geometry ? geometry : null;
    /**
     * @member {Object} SuperMap.Feature.Vector.prototype.attributes
     * @description 描述要素的任意的可序列化属性。
     */

    _this.attributes = {};

    if (attributes) {
      _this.attributes = Util.extend(_this.attributes, attributes);
    }
    /**
     * @member {SuperMap.Bounds} SuperMap.Feature.Vector.prototype.bounds
     * @description The box bounding that feature's geometry, that
     *     property can be set by an <SuperMap.Format> object when
     *     deserializing the feature, so in most cases it represents an
     *     information set by the server.
     */


    _this.bounds = null;
    /**
     * @member {string} SuperMap.Feature.Vector.prototype.state
     * @description state
     */

    _this.state = null;
    /**
     * @member {Object} SuperMap.Feature.Vector.prototype.style
     * @description 要素的样式属性，地图查询返回的 feature 的 style，8C 变为null。
     */

    _this.style = style ? style : null;
    /**
     * @member {string} SuperMap.Feature.Vector.prototype.url 
     * @description 如果设置了这个属性，在更新或者删除要素时需要考虑 {@link SuperMap.HTTP} 。
     */

    _this.url = null;
    _this.lonlat = null;
    _this.CLASS_NAME = "SuperMap.Feature.Vector"; // TRASH THIS

    SuperMap.State = {
      /** states */
      UNKNOWN: 'Unknown',
      INSERT: 'Insert',
      UPDATE: 'Update',
      DELETE: 'Delete'
    };
    Vector.style = {
      'default': {
        fillColor: "#ee9900",
        fillOpacity: 0.4,
        hoverFillColor: "white",
        hoverFillOpacity: 0.8,
        strokeColor: "#ee9900",
        strokeOpacity: 1,
        strokeWidth: 1,
        strokeLinecap: "round",
        strokeDashstyle: "solid",
        hoverStrokeColor: "red",
        hoverStrokeOpacity: 1,
        hoverStrokeWidth: 0.2,
        pointRadius: 6,
        hoverPointRadius: 1,
        hoverPointUnit: "%",
        pointerEvents: "visiblePainted",
        cursor: "inherit",
        fontColor: "#000000",
        labelAlign: "cm",
        labelOutlineColor: "white",
        labelOutlineWidth: 3
      },
      'select': {
        fillColor: "blue",
        fillOpacity: 0.4,
        hoverFillColor: "white",
        hoverFillOpacity: 0.8,
        strokeColor: "blue",
        strokeOpacity: 1,
        strokeWidth: 2,
        strokeLinecap: "round",
        strokeDashstyle: "solid",
        hoverStrokeColor: "red",
        hoverStrokeOpacity: 1,
        hoverStrokeWidth: 0.2,
        pointRadius: 6,
        hoverPointRadius: 1,
        hoverPointUnit: "%",
        pointerEvents: "visiblePainted",
        cursor: "pointer",
        fontColor: "#000000",
        labelAlign: "cm",
        labelOutlineColor: "white",
        labelOutlineWidth: 3
      },
      'temporary': {
        fillColor: "#66cccc",
        fillOpacity: 0.2,
        hoverFillColor: "white",
        hoverFillOpacity: 0.8,
        strokeColor: "#66cccc",
        strokeOpacity: 1,
        strokeLinecap: "round",
        strokeWidth: 2,
        strokeDashstyle: "solid",
        hoverStrokeColor: "red",
        hoverStrokeOpacity: 1,
        hoverStrokeWidth: 0.2,
        pointRadius: 6,
        hoverPointRadius: 1,
        hoverPointUnit: "%",
        pointerEvents: "visiblePainted",
        //cursor:"inherit",
        cursor: "default",
        fontColor: "#000000",
        labelAlign: "cm",
        labelOutlineColor: "white",
        labelOutlineWidth: 3
      },
      'delete': {
        display: "none"
      }
    };
    return _this;
  }
  /**
   * @function SuperMap.Feature.Vector.prototype.destroy
   * @description nullify references to prevent circular references and memory leaks
   */


  Vector_createClass(Vector, [{
    key: "destroy",
    value: function destroy() {
      if (this.layer) {
        this.layer.removeFeatures(this);
        this.layer = null;
      }

      this.geometry = null;

      Vector_get(Vector_getPrototypeOf(Vector.prototype), "destroy", this).call(this);
    }
    /**
     * @function SuperMap.Feature.Vector.prototype.clone
     * @description Create a clone of this vector feature.  Does not set any non-standard
     *     properties.
     * @returns {SuperMap.Feature.Vector} An exact clone of this vector feature.
     */

  }, {
    key: "clone",
    value: function clone() {
      return new Vector(this.geometry ? this.geometry.clone() : null, this.attributes, this.style);
    }
    /**
     * @function SuperMap.Feature.Vector.prototype.toState
     * @description 设置新状态。
     * @param {string} state - 状态。
     */

  }, {
    key: "toState",
    value: function toState(state) {
      if (state === SuperMap.State.UPDATE) {
        switch (this.state) {
          case SuperMap.State.UNKNOWN:
          case SuperMap.State.DELETE:
            this.state = state;
            break;

          case SuperMap.State.UPDATE:
          case SuperMap.State.INSERT:
            break;
        }
      } else if (state === SuperMap.State.INSERT) {
        switch (this.state) {
          case SuperMap.State.UNKNOWN:
            break;

          default:
            this.state = state;
            break;
        }
      } else if (state === SuperMap.State.DELETE) {
        switch (this.state) {
          case SuperMap.State.INSERT:
            // the feature should be destroyed
            break;

          case SuperMap.State.DELETE:
            break;

          case SuperMap.State.UNKNOWN:
          case SuperMap.State.UPDATE:
            this.state = state;
            break;
        }
      } else if (state === SuperMap.State.UNKNOWN) {
        this.state = state;
      }
    }
  }]);

  return Vector;
}(Feature_Feature);
/**
 *
 * @typedef {Object} SuperMap.Feature.Vector.style
 * @description SuperMap.features 有大量的样式属性，如果没有特别的指定将使用默认的样式，
 * 大部分样式通过 SVG 标准定义属性。
 * - fill properties 资料介绍：{@link http://www.w3.org/TR/SVG/painting.html#FillProperties}
 * - stroke properties 资料介绍：{@link http://www.w3.org/TR/SVG/painting.html#StrokeProperties}
 * @property {boolean} [fill] - 不需要填充则设置为 false。
 * @property {string} [fillColor='#ee9900'] - 十六进制填充颜色。
 * @property {number} [fillOpacity=0.4] - 填充不透明度。
 * @property {boolean} [stroke] - 不需要描边则设为 false。
 * @property {string} [strokeColor='#ee9900'] - 十六进制描边颜色。
 * @property {number} [strokeOpacity=0.4] - 描边的不透明度(0-1)。
 * @property {number} [strokeWidth=1] - 像素描边宽度。
 * @property {string} [strokeLinecap='round'] - strokeLinecap 有三种类型 butt，round，square。
 * @property {string} [strokeDashstyle='solid'] - 有 dot，dash，dashdot，longdash，longdashdot，solid 几种样式。
 * @property {boolean} [graphic] - 不需要则设置为 false。
 * @property {number} [pointRadius=6] - 像素点半径。
 * @property {string} [pointerEvents='visiblePainted'] - pointerEvents。
 * @property {string} [cursor] - cursor。
 * @property {boolean} [allowRotate='false'] - 是否允许图标随着运行方向旋转。用于时空数据图层。
 * @property {string} [externalGraphic] - 连接到用来渲染点的外部的图形。
 * @property {number} [graphicWidth] - 外部图表的像素宽度。
 * @property {number} [graphicHeight] - 外部图表的高宽度。
 * @property {number} [graphicOpacity] - 外部图表的不透明度(0-1)。
 * @property {number} [graphicXOffset] - 外部图表沿着x方向的偏移量。
 * @property {number} [graphicYOffset] - 外部图表沿着y方向的偏移量 Pixel。
 * @property {number} [rotation] - 一个图表沿着其中心点（或者偏移中心指定点）在顺时针方向旋转。
 * @property {number} [graphicZIndex] - 渲染时使用的索引值。
 * @property {string} [graphicName='circle'] - 渲染点时图标使用的名字。支持"circle" , "square", "star", "x", "cross", "triangle"。
 * @property {string} [graphicTitle] - 外部图表的提示框。
 * @property {string} [backgroundGraphic] - 外部图表的背景。
 * @property {number} [backgroundGraphicZIndex] - 背景图渲染时使用的索引值。
 * @property {number} [backgroundXOffset] - 背景图在 x 轴的偏移量。
 * @property {number} [backgroundYOffset] - 背景图在 y 轴的偏移量。
 * @property {number} [backgroundHeight] - 背景图的高度。如果没有设置，将用 graphicHeight。
 * @property {number} [backgroundWidth] - 背景图的宽度。如果没有设置，将用 graphicWidth。
 * @property {boolean} [isUnicode=false] - 这个属性要配合 label 属性来用，当为 true时，label 就可以使用 unicode 编码，
 * 比如 "a" 的 unicode 十六进制编码为 61，则 label 属性可以为 "&#x61;",其中 "&#" 为前缀，标志这个为 unicode 编码，
 * "x" 是指 16 进制,这时页面显示的是 "a"；当此值为 false 的时候，label 的内容会被直接输出，
 * 比如，label 为 "&#x61;"，这时页面显示的也是 "&#x61;"。
 * @property {string} [label] - 可选的标签文本。
 * @property {string} [labelAlign='cm'] - 标签对齐，是由两个字符组成的字符串，如："lt", "cm", "rb"，
 * 其中第一个字符代表水平方向上的对齐，"l"=left, "c"=center, "r"=right；
 * 第二个字符代表垂直方向上的对齐，"t"=top, "m"=middle, "b"=bottom。
 * @property {number} [labelXOffset] - 标签在 x 轴方向的偏移量。
 * @property {number} [labelYOffset] - 标签在 y 轴方向的偏移量。
 * @property {boolean} [labelSelect=false] - 如果设为 true，标签可以选用 SelectFeature 或者 similar 控件。
 * @property {string} [fontColor='#000000'] - 标签字体颜色。
 * @property {number} [fontOpacity] - 标签透明度 (0-1)。
 * @property {string} [fontFamily] - 标签的字体类型。
 * @property {string} [fontSize] - 标签的字体大小。
 * @property {string} [fontStyle] - 标签的字体样式。
 * @property {string} [fontWeight] - 标签的字体粗细。
 * @property {string} [display] - 如果 display 属性设置为 “none”，符号将没有任何效果。
 * @example
 *  // label的用法如下：
 *  function addGeoTest(){
 *  var geometry = new SuperMap.Geometry.Point(105, 35);
 *  var pointFeature = new SuperMap.Feature.Vector(geometry);
 *  var styleTest = {
 *        label:"supermap",
 *        fontColor:"#0000ff",
 *        fontOpacity:"0.5",
 *        fontFamily:"隶书",
 *        fontSize:"8em",
 *        fontWeight:"bold",
 *        fontStyle:"italic",
 *        labelSelect:"true",
 *     }
 *           pointFeature.style = styleTest;
 *          vectorLayer.addFeatures([pointFeature]);
 * }
     */

SuperMap.Feature.Vector = Vector_Vector;
// CONCATENATED MODULE: ./src/common/commontypes/index.js
/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/




























// CONCATENATED MODULE: ./src/common/format/Format.js
function Format_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function Format_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function Format_createClass(Constructor, protoProps, staticProps) { if (protoProps) Format_defineProperties(Constructor.prototype, protoProps); if (staticProps) Format_defineProperties(Constructor, staticProps); return Constructor; }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


/**
 * @class SuperMap.Format
 * @classdesc 读写各种格式的格式类基类。其子类应该包含并实现 read 和 write 方法。
 * @category BaseTypes Format
 * @param {Object} options - 可选参数。
 * @param {boolean} [options.keepData=false] - 如果设置为 true， data 属性会指向被解析的对象（例如 JSON 或 xml 数据对象）。
 * @param {Object} [options.data] - 当 keepData 属性设置为 true，这是传递给 read 操作的要被解析的字符串。
 */

var Format_Format =
/*#__PURE__*/
function () {
  function Format(options) {
    Format_classCallCheck(this, Format);

    /**
     * @member {Object} SuperMap.Format.prototype.data 
     * @description 当 keepData 属性设置为 true，这是传递给 read 操作的要被解析的字符串。
     */
    this.data = null;
    /**
     * APIProperty: keepData
     * @member {Object} [SuperMap.Format.prototype.keepData=false]
     * @description 保持最近读到的数据的引用（通过 <data> 属性）。
     */

    this.keepData = false;
    Util.extend(this, options);
    this.options = options;
    this.CLASS_NAME = "SuperMap.Format";
  }
  /**
   * @function SuperMap.Format.prototype.destroy
   * @description 销毁该格式类，释放相关资源。
   */


  Format_createClass(Format, [{
    key: "destroy",
    value: function destroy() {} //用来销毁该格式类，释放相关资源

    /**
     * @function SuperMap.Format.prototype.read
     * @description 来从字符串中读取数据。
     * @param {string} data - 读取的数据。
     */

  }, {
    key: "read",
    value: function read(data) {} // eslint-disable-line no-unused-vars
    //用来从字符串中读取数据

    /**
     * @function SuperMap.Format.prototype.write
     * @description 将对象写成字符串。
     * @param {Object} object - 可序列化的对象。
     * @returns {string} 对象被写成字符串。
     */

  }, {
    key: "write",
    value: function write(object) {// eslint-disable-line no-unused-vars
      //用来写字符串
    }
  }]);

  return Format;
}();
SuperMap.Format = Format_Format;
// CONCATENATED MODULE: ./src/common/format/JSON.js
function JSON_typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { JSON_typeof = function _typeof(obj) { return typeof obj; }; } else { JSON_typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return JSON_typeof(obj); }

function JSON_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function JSON_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function JSON_createClass(Constructor, protoProps, staticProps) { if (protoProps) JSON_defineProperties(Constructor.prototype, protoProps); if (staticProps) JSON_defineProperties(Constructor, staticProps); return Constructor; }

function JSON_possibleConstructorReturn(self, call) { if (call && (JSON_typeof(call) === "object" || typeof call === "function")) { return call; } return JSON_assertThisInitialized(self); }

function JSON_assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function JSON_getPrototypeOf(o) { JSON_getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return JSON_getPrototypeOf(o); }

function JSON_inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) JSON_setPrototypeOf(subClass, superClass); }

function JSON_setPrototypeOf(o, p) { JSON_setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return JSON_setPrototypeOf(o, p); }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


/**
 * @class SuperMap.Format.JSON
 * @classdesc 安全的读写 JSON 的解析类。使用 {@link SuperMap.Format.JSON} 构造函数创建新实例。
 * @category BaseTypes Format
 * @param {Object} [options] - 参数。
 * @param {string} [options.indent="    "] - 用于格式化输出，indent 字符串会在每次缩进的时候使用一次。
 * @param {string} [options.space=" "] - 用于格式化输出，space 字符串会在名值对的 ":" 后边添加。
 * @param {string} [options.newline="\n"] - 用于格式化输出, newline 字符串会用在每一个名值对或数组项末尾。
 * @param {number} [options.level=0] - 用于格式化输出, 表示的是缩进级别。
 * @param {boolean} [options.pretty=false] - 是否在序列化的时候使用额外的空格控制结构。在 write 方法中使用。
 * @param {boolean} [options.nativeJSON] - 需要被注册的监听器对象。
 * @extends {SuperMap.Format}
 */

var JSONFormat =
/*#__PURE__*/
function (_Format) {
  JSON_inherits(JSONFormat, _Format);

  function JSONFormat(options) {
    var _this;

    JSON_classCallCheck(this, JSONFormat);

    _this = JSON_possibleConstructorReturn(this, JSON_getPrototypeOf(JSONFormat).call(this, options));
    /**
     * @member {string} [SuperMap.Format.JSON.prototype.indent="    "]
     * @description 用于格式化输出，indent 字符串会在每次缩进的时候使用一次。
     */

    _this.indent = "    ";
    /**
     * @member {string} [SuperMap.Format.JSON.prototype.space=" "]
     * @description 用于格式化输出，space 字符串会在名值对的 ":" 后边添加。
     */

    _this.space = " ";
    /**
     * @member {string} [SuperMap.Format.JSON.prototype.newline="\n"]
     * @description 用于格式化输出, newline 字符串会用在每一个名值对或数组项末尾。
     */

    _this.newline = "\n";
    /**
     * @member {integer} [SuperMap.Format.JSON.prototype.level=0] 
     * @description 用于格式化输出, 表示的是缩进级别。
     */

    _this.level = 0;
    /**
     * @member {boolean} [SuperMap.Format.JSON.prototype.pretty=false]
     * @description 是否在序列化的时候使用额外的空格控制结构。在 write 方法中使用。
     */

    _this.pretty = false;
    /**
     * @member {boolean} SuperMap.Format.JSON.prototype.nativeJSON 
     * @description 判断浏览器是否原生支持 JSON 格式数据。
     */

    _this.nativeJSON = function () {
      return !!(window.JSON && typeof JSON.parse === "function" && typeof JSON.stringify === "function");
    }();

    _this.CLASS_NAME = "SuperMap.Format.JSON";
    /**
     * @member SuperMap.Format.JSON.prototype.serialize
     * @description 提供一些类型对象转 JSON 字符串的方法。
     */

    _this.serialize = {
      /**
       * @function SuperMap.Format.JSON.serialize.object
       * @description 把对象转换为 JSON 字符串。
       * @param {Object} object - 可序列化的对象。
       * @returns {string} JSON 字符串。
       */
      'object': function object(_object) {
        // three special objects that we want to treat differently
        if (_object == null) {
          return "null";
        }

        if (_object.constructor === Date) {
          return this.serialize.date.apply(this, [_object]);
        }

        if (_object.constructor === Array) {
          return this.serialize.array.apply(this, [_object]);
        }

        var pieces = ['{'];
        this.level += 1;
        var key, keyJSON, valueJSON;
        var addComma = false;

        for (key in _object) {
          if (_object.hasOwnProperty(key)) {
            // recursive calls need to allow for sub-classing
            keyJSON = this.write.apply(this, [key, this.pretty]);
            valueJSON = this.write.apply(this, [_object[key], this.pretty]);

            if (keyJSON != null && valueJSON != null) {
              if (addComma) {
                pieces.push(',');
              }

              pieces.push(this.writeNewline(), this.writeIndent(), keyJSON, ':', this.writeSpace(), valueJSON);
              addComma = true;
            }
          }
        }

        this.level -= 1;
        pieces.push(this.writeNewline(), this.writeIndent(), '}');
        return pieces.join('');
      },

      /**
       * @function SuperMap.Format.JSON.serialize.array
       * @description 把数组转换成 JSON 字符串。
       * @param {Array} array - 可序列化的数组。
       * @returns {string} JSON 字符串。
       */
      'array': function array(_array) {
        var json;
        var pieces = ['['];
        this.level += 1;

        for (var i = 0, len = _array.length; i < len; ++i) {
          // recursive calls need to allow for sub-classing
          json = this.write.apply(this, [_array[i], this.pretty]);

          if (json != null) {
            if (i > 0) {
              pieces.push(',');
            }

            pieces.push(this.writeNewline(), this.writeIndent(), json);
          }
        }

        this.level -= 1;
        pieces.push(this.writeNewline(), this.writeIndent(), ']');
        return pieces.join('');
      },

      /**
       * @function SuperMap.Format.JSON.serialize.string
       * @description 把字符串转换成 JSON 字符串。
       * @param {string} string - 可序列化的字符串。
       * @returns {string} JSON 字符串。
       */
      'string': function string(_string) {
        // If the string contains no control characters, no quote characters, and no
        // backslash characters, then we can simply slap some quotes around it.
        // Otherwise we must also replace the offending characters with safe
        // sequences.
        var m = {
          '\b': '\\b',
          '\t': '\\t',
          '\n': '\\n',
          '\f': '\\f',
          '\r': '\\r',
          '"': '\\"',
          '\\': '\\\\'
        };
        /*eslint-disable no-control-regex*/

        if (/["\\\x00-\x1f]/.test(_string)) {
          return '"' + _string.replace(/([\x00-\x1f\\"])/g, function (a, b) {
            var c = m[b];

            if (c) {
              return c;
            }

            c = b.charCodeAt();
            return "\\u00" + Math.floor(c / 16).toString(16) + (c % 16).toString(16);
          }) + '"';
        }

        return '"' + _string + '"';
      },

      /**
       * @function SuperMap.Format.JSON.serialize.number
       * @description 把数字转换成 JSON 字符串。
       * @param {number} number - 可序列化的数字。
       * @returns {string} JSON 字符串。
       */
      'number': function number(_number) {
        return isFinite(_number) ? String(_number) : "null";
      },

      /**
       * @function SuperMap.Format.JSON.serialize.boolean
       * @description Transform a boolean into a JSON string.
       * @param {boolean} bool - The boolean to be serialized.
       * @returns {string} A JSON string representing the boolean.
       */
      'boolean': function boolean(bool) {
        return String(bool);
      },

      /**
       * @function SuperMap.Format.JSON.serialize.object
       * @description 将日期对象转换成 JSON 字符串。
       * @param {Date} date - 可序列化的日期对象。
       * @returns {string} JSON 字符串。
       */
      'date': function date(_date) {
        function format(number) {
          // Format integers to have at least two digits.
          return number < 10 ? '0' + number : number;
        }

        return '"' + _date.getFullYear() + '-' + format(_date.getMonth() + 1) + '-' + format(_date.getDate()) + 'T' + format(_date.getHours()) + ':' + format(_date.getMinutes()) + ':' + format(_date.getSeconds()) + '"';
      }
    };
    return _this;
  }
  /**
   * @function SuperMap.Format.JSON.prototype.read
   * @description 将一个符合 JSON 结构的字符串进行解析。
   * @param {string} json - 符合 JSON 结构的字符串。
   * @param {function} filter - 过滤方法，最终结果的每一个键值对都会调用该过滤方法，并在对应的值的位置替换成该方法返回的值。
   * @returns {Object} 对象，数组，字符串或数字。
   */


  JSON_createClass(JSONFormat, [{
    key: "read",
    value: function read(json, filter) {
      var object;

      if (this.nativeJSON) {
        try {
          object = JSON.parse(json, filter);
        } catch (e) {// Fall through if the regexp test fails.
        }
      }

      if (this.keepData) {
        this.data = object;
      }

      return object;
    }
    /**
     * @function SuperMap.Format.JSON.prototype.write
     * @description 序列化一个对象到一个符合 JSON 格式的字符串。
     * @param {(object|string|Array|number|boolean)} value - 需要被序列化的对象，数组，字符串，数字，布尔值。
     * @param {boolean} [pretty=false] - 是否在序列化的时候使用额外的空格控制结构。在 write 方法中使用。
     * @returns {string} 符合 JSON 格式的字符串。
     *
     */

  }, {
    key: "write",
    value: function write(value, pretty) {
      this.pretty = !!pretty;
      var json = null;

      var type = JSON_typeof(value);

      if (this.serialize[type]) {
        try {
          json = !this.pretty && this.nativeJSON ? JSON.stringify(value) : this.serialize[type].apply(this, [value]);
        } catch (err) {//SuperMap.Console.error("Trouble serializing: " + err);
        }
      }

      return json;
    }
    /**
     * @function SuperMap.Format.JSON.prototype.writeIndent
     * @description 根据缩进级别输出一个缩进字符串。
     * @private
     * @returns {string} 一个适当的缩进字符串。
     */

  }, {
    key: "writeIndent",
    value: function writeIndent() {
      var pieces = [];

      if (this.pretty) {
        for (var i = 0; i < this.level; ++i) {
          pieces.push(this.indent);
        }
      }

      return pieces.join('');
    }
    /**
     * @function SuperMap.Format.JSON.prototype.writeNewline
     * @description 在格式化输出模式情况下输出代表新一行的字符串。
     * @private
     * @returns {string} 代表新的一行的字符串。
     */

  }, {
    key: "writeNewline",
    value: function writeNewline() {
      return this.pretty ? this.newline : '';
    }
    /**
     * @function SuperMap.Format.JSON.prototype.writeSpace
     * @private
     * @description 在格式化输出模式情况下输出一个代表空格的字符串。
     * @returns {string} 一个空格。
     */

  }, {
    key: "writeSpace",
    value: function writeSpace() {
      return this.pretty ? this.space : '';
    }
  }]);

  return JSONFormat;
}(Format_Format);
SuperMap.Format.JSON = JSONFormat;
// CONCATENATED MODULE: ./src/common/iServer/ServerColor.js
function ServerColor_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function ServerColor_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function ServerColor_createClass(Constructor, protoProps, staticProps) { if (protoProps) ServerColor_defineProperties(Constructor.prototype, protoProps); if (staticProps) ServerColor_defineProperties(Constructor, staticProps); return Constructor; }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/

/**
 * @class SuperMap.ServerColor
 * @category iServer Map Theme
 * @classdesc 颜色类。该类使用三原色（ RGB ）来表达颜色。
 * @param {Object} options - 参数。
 * @param {number} [options.red=255] - 获取或设置红色值。
 * @param {number} [options.green=0] - 获取或设置绿色值。
 * @param {number} [options.blue=0] - 获取或设置蓝色值。
 */

var ServerColor =
/*#__PURE__*/
function () {
  function ServerColor(red, green, blue) {
    ServerColor_classCallCheck(this, ServerColor);

    /**
     * @member {number} [SuperMap.ServerColor.prototype.red=255]
     * @description 获取或设置红色值。
     */
    this.red = !red && red != 0 ? 255 : red;
    /**
     * @member {number} [SuperMap.ServerColor.prototype.green=0]
     * @description 获取或设置绿色值。
     */

    this.green = green || 0;
    /**
     * @member {number} [SuperMap.ServerColor.prototype.blue=0]
     * @description 获取或设置蓝色值。
     */

    this.blue = blue || 0;
    this.CLASS_NAME = "SuperMap.ServerColor";
  }
  /**
   * @function SuperMap.ServerColor.prototype.destroy
   * @description 释放资源，将引用资源的属性置空。
   */


  ServerColor_createClass(ServerColor, [{
    key: "destroy",
    value: function destroy() {
      var me = this;
      me.red = null;
      me.green = null;
      me.blue = null;
    }
    /**
     * @function SuperMap.ServerColor.formJson
     * @description 将 JSON 对象转化为 ServerColor 对象。
     * @param {Object} jsonObject - 要转换的 JSON 对象。
     * @returns {SuperMap.ServerColor} 转化后的 ServerColor 对象。
     */

  }], [{
    key: "fromJson",
    value: function fromJson(jsonObject) {
      if (!jsonObject) {
        return;
      }

      var color = new ServerColor();
      var red = 255;

      if (jsonObject.red !== null) {
        red = Number(jsonObject.red);
      }

      color.red = red;
      var green = 0;

      if (jsonObject.green !== null) {
        green = Number(jsonObject.green);
      }

      color.green = green;
      var blue = 0;

      if (jsonObject.blue !== null) {
        blue = Number(jsonObject.blue);
      }

      color.blue = blue;
      return color;
    }
  }]);

  return ServerColor;
}();
SuperMap.ServerColor = ServerColor;
// CONCATENATED MODULE: ./src/common/iServer/ServerStyle.js
function ServerStyle_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function ServerStyle_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function ServerStyle_createClass(Constructor, protoProps, staticProps) { if (protoProps) ServerStyle_defineProperties(Constructor.prototype, protoProps); if (staticProps) ServerStyle_defineProperties(Constructor, staticProps); return Constructor; }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/



/**
 * @class SuperMap.ServerStyle
 * @category  iServer Map Theme
 * @classdesc 服务端矢量要素风格类。
 * @description 该类用于定义点状符号、线状符号、填充符号风格及其相关属性。
 * @param {Object} options - 参数。
 * @param {SuperMap.FillGradientMode} options.fillGradientMode - 渐变填充风格的渐变类型。
 * @param {SuperMap.ServerColor} [options.fillBackColor=[255,255,255]] - 填充背景颜色。
 * @param {boolean} [options.fillBackOpaque=false] - 背景是否不透明。
 * @param {SuperMap.ServerColor} [options.fillForeColor=[255,0,0]] - 填充颜色。
 * @param {number} [options.fillGradientAngle=0] - 渐变填充的旋转角度。
 * @param {number} [options.fillGradientOffsetRatioX=0] - 渐变填充中心点相对于填充区域范围中心点的水平偏移百分比。
 * @param {number} [options.fillGradientOffsetRatioY=0] - 填充中心点相对于填充区域范围中心点的垂直偏移百分比。
 * @param {number} [options.fillOpaqueRate=100] - 填充不透明度。
 * @param {number} [options.fillSymbolID=0] - 填充符号的编码。
 * @param {SuperMap.ServerColor} [options.lineColor] - 矢量要素的边线颜色。默认 lineColor = new ServerColor(0, 0, 0)。
 * @param {number} [options.lineSymbolID=0] - 线状符号的编码。
 * @param {number} [options.lineWidth=1] - 边线的宽度。
 * @param {number} [options.markerAngle=0] - 点状符号的旋转角度。
 * @param {number} [options.markerSize=1] - 点状符号的大小。
 * @param {number} [options.markerSymbolID=-1] - 点状符号的编码。
 */

var ServerStyle_ServerStyle =
/*#__PURE__*/
function () {
  function ServerStyle(options) {
    ServerStyle_classCallCheck(this, ServerStyle);

    /**
     * @member {SuperMap.ServerColor} SuperMap.ServerStyle.prototype.fillBackColor
     * @description 填充背景颜色。当填充模式为渐变填充时，该颜色为填充终止色。
     */
    this.fillBackColor = new ServerColor(255, 255, 255);
    /**
     * @member {boolean} [SuperMap.ServerStyle.prototype.fillBackOpaque=false]
     * @description 背景是否不透明。false 表示透明。
     */

    this.fillBackOpaque = false;
    /**
     * @member {SuperMap.ServerColor} SuperMap.ServerStyle.prototype.fillForeColor
     * @description 填充颜色。当填充模式为渐变填充时，该颜色为填充起始颜色。
     */

    this.fillForeColor = new ServerColor(255, 0, 0);
    /**
     * @member {SuperMap.FillGradientMode} SuperMap.ServerStyle.prototype.fillGradientMode
     * @description 渐变填充风格的渐变类型。
     */

    this.fillGradientMode = null;
    /**
     * @member {number} SuperMap.ServerStyle.prototype.fillGradientAngle -
     * @description 渐变填充的旋转角度。单位为度，精确到 0.1 度，逆时针方向为正方向。
     */

    this.fillGradientAngle = 0;
    /**
     * @member {number} SuperMap.ServerStyle.prototype.fillGradientOffsetRatioX
     * @description 渐变填充中心点相对于填充区域范围中心点的水平偏移百分比。它们的关系如下：设填充区域范围中心点的坐标为（x0, y0），
     *              填充中心点的坐标为（x, y），填充区域范围的宽度为 a，水平偏移百分比为 dx，则 x=x0 + a*dx/100。
     */

    this.fillGradientOffsetRatioX = 0;
    /**
     * @member {number} SuperMap.ServerStyle.prototype.fillGradientOffsetRatioY
     * @description 填充中心点相对于填充区域范围中心点的垂直偏移百分比。它们的关系如下：<br>
     *              设填充区域范围中心点的坐标为（x0, y0），填充中心点的坐标为（x, y），填充区域范围的高度为 b，垂直偏移百分比为 dy，则 y=y0 + b*dx/100。
     */

    this.fillGradientOffsetRatioY = 0;
    /**
     * @member {number} [SuperMap.ServerStyle.prototype.fillOpaqueRate=100]
     * @description 填充不透明度。合法值为 0 - 100 的数值。其中为 0 表示完全透明；
     *              100 表示完全不透明。赋值小于 0 时按照 0 处理，大于 100 时按照 100 处理。
     */

    this.fillOpaqueRate = 100;
    /**
     * @member {number} SuperMap.ServerStyle.prototype.fillSymbolID
     * @description 填充符号的编码。此编码用于唯一标识各普通填充风格的填充符号。
     *              关于填充符号的样式与对应的 ID 号请在 SuperMap 桌面软件中查找。
     */

    this.fillSymbolID = 0;
    /**
     * @member {SuperMap.ServerColor} SuperMap.ServerStyle.prototype.lineColor
     * @description 矢量要素的边线颜色。如果等级符号是点符号，点符号的颜色由 lineColor 控制。
     */

    this.lineColor = new ServerColor(0, 0, 0);
    /**
     * @member {number} [SuperMap.ServerStyle.prototype.lineSymbolID=0]
     * @description 线状符号的编码。此编码用于唯一标识各普通填充风格的填充符号。
     *              关于线状符号的样式与对应的 ID 号请在 SuperMap 桌面软件中查找。
     */

    this.lineSymbolID = 0;
    /**
     * @member {number} [SuperMap.ServerStyle.prototype.lineWidth=1.0]
     * @description 边线的宽度。单位为毫米，精度到 0.1。
     */

    this.lineWidth = 1;
    /**
     * @member {number} [SuperMap.ServerStyle.prototype.markerAngle=0]
     * @description 点状符号的旋转角度。以度为单位，精确到 0.1 度，逆时针方向为正方向。
     */

    this.markerAngle = 0;
    /**
     * @member {number} [SuperMap.ServerStyle.prototype.markerSize=1.0]
     * @description 点状符号的大小。单位为毫米，精度为 0.1。当该属性设置为0时，采用符号默认大小 1.0 显示。
     *              当该属性设置为非法值时，交由服务器默认处理。
     */

    this.markerSize = 1;
    /**
     * @member {number} [SuperMap.ServerStyle.prototype.markerSymbolID=-1]
     * @description 点状符号的编码。此编码用于唯一标识各点状符号。
     *              关于线状符号的样式与对应的 ID 号请在 SuperMap 桌面软件中查找。
     */

    this.markerSymbolID = -1;

    if (options) {
      Util.extend(this, options);
    }

    this.CLASS_NAME = "SuperMap.ServerStyle";
  }
  /**
   * @function SuperMap.ServerStyle.prototype.destroy
   * @description 释放资源，将引用资源的属性置空。
   */


  ServerStyle_createClass(ServerStyle, [{
    key: "destroy",
    value: function destroy() {
      var me = this;

      if (me.fillBackColor) {
        me.fillBackColor.destroy();
        me.fillBackColor = null;
      }

      me.fillBackOpaque = null;

      if (me.fillForeColor) {
        me.fillForeColor.destroy();
        me.fillForeColor = null;
      }

      me.fillGradientMode = null;
      me.fillGradientAngle = null;
      me.fillGradientOffsetRatioX = null;
      me.fillGradientOffsetRatioY = null;
      me.fillOpaqueRate = null;
      me.fillSymbolID = null;

      if (me.lineColor) {
        me.lineColor.destroy();
        me.lineColor = null;
      }

      me.lineSymbolID = null;
      me.lineWidth = null;
      me.markerAngle = null;
      me.markerSize = null;
      me.markerSymbolID = null;
    }
    /**
     * @function SuperMap.ServerStyle.prototype.toServerJSONObject
     * @description 转换成对应的 JSON 格式对象。
     * @returns {Object} 对应的 JSON 格式对象.
     */

  }, {
    key: "toServerJSONObject",
    value: function toServerJSONObject() {
      var styleObj = {};
      styleObj = Util.copyAttributes(styleObj, this); //暂时先忽略serverColor往Json的转换

      return styleObj;
    }
    /**
     * @function SuperMap.ServerStyle.fromJson
     * @description 将JSON对象转换为 SuperMap.ServerStyle 对象。
     * @param jsonObject - {Object} 要转换的 JSON 对象。
     * @returns {SuperMap.ServerStyle} 转化后的 SuperMap.ServerStyle 对象。
     */

  }], [{
    key: "fromJson",
    value: function fromJson(jsonObject) {
      if (!jsonObject) {
        return;
      }

      return new ServerStyle({
        fillBackColor: ServerColor.fromJson(jsonObject.fillBackColor),
        fillBackOpaque: jsonObject.fillBackOpaque,
        fillForeColor: ServerColor.fromJson(jsonObject.fillForeColor),
        fillGradientMode: jsonObject.fillGradientMode,
        fillGradientAngle: jsonObject.fillGradientAngle,
        fillGradientOffsetRatioX: jsonObject.fillGradientOffsetRatioX,
        fillGradientOffsetRatioY: jsonObject.fillGradientOffsetRatioY,
        fillOpaqueRate: jsonObject.fillOpaqueRate,
        fillSymbolID: jsonObject.fillSymbolID,
        lineColor: ServerColor.fromJson(jsonObject.lineColor),
        lineSymbolID: jsonObject.lineSymbolID,
        lineWidth: jsonObject.lineWidth,
        markerAngle: jsonObject.markerAngle,
        markerSize: jsonObject.markerSize,
        markerSymbolID: jsonObject.markerSymbolID
      });
    }
  }]);

  return ServerStyle;
}();
SuperMap.ServerStyle = ServerStyle_ServerStyle;
// CONCATENATED MODULE: ./src/common/iServer/PointWithMeasure.js
function PointWithMeasure_typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { PointWithMeasure_typeof = function _typeof(obj) { return typeof obj; }; } else { PointWithMeasure_typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return PointWithMeasure_typeof(obj); }

function PointWithMeasure_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function PointWithMeasure_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function PointWithMeasure_createClass(Constructor, protoProps, staticProps) { if (protoProps) PointWithMeasure_defineProperties(Constructor.prototype, protoProps); if (staticProps) PointWithMeasure_defineProperties(Constructor, staticProps); return Constructor; }

function PointWithMeasure_possibleConstructorReturn(self, call) { if (call && (PointWithMeasure_typeof(call) === "object" || typeof call === "function")) { return call; } return PointWithMeasure_assertThisInitialized(self); }

function PointWithMeasure_getPrototypeOf(o) { PointWithMeasure_getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return PointWithMeasure_getPrototypeOf(o); }

function PointWithMeasure_assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function PointWithMeasure_inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) PointWithMeasure_setPrototypeOf(subClass, superClass); }

function PointWithMeasure_setPrototypeOf(o, p) { PointWithMeasure_setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return PointWithMeasure_setPrototypeOf(o, p); }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/



/**
 * @class SuperMap.PointWithMeasure
 * @category  iServer SpatialAnalyst
 * @classdesc 路由点类。路由点是指具有线性度量值 (Measure) 的二维地理坐标点。
 * @param {Object} options - 参数。
 * @param {number} options.measure - 度量值，即路由对象属性值 M。
 * @param {number} options.x - 获取当前点对象在地理坐标系下的 X 坐标值。
 * @param {number} options.y - 获取当前点对象在地理坐标系下的 Y 坐标值。
 * @extends {SuperMap.Geometry.Point}
 */

var PointWithMeasure_PointWithMeasure =
/*#__PURE__*/
function (_Point) {
  PointWithMeasure_inherits(PointWithMeasure, _Point);

  function PointWithMeasure(options) {
    var _this;

    PointWithMeasure_classCallCheck(this, PointWithMeasure);

    _this = PointWithMeasure_possibleConstructorReturn(this, PointWithMeasure_getPrototypeOf(PointWithMeasure).call(this, options));
    /**
     * @member {number} SuperMap.PointWithMeasure.prototype.measure
     * @description 度量值，即路由对象属性值 M。
     */

    _this.measure = null;

    if (options) {
      Util.extend(PointWithMeasure_assertThisInitialized(_this), options);
    }

    _this.CLASS_NAME = "SuperMap.PointWithMeasure";
    return _this;
  }
  /**
   * @function SuperMap.PointWithMeasure.prototype.equals
   * @description 判断两个路由点对象是否相等。如果两个路由点对象具有相同的坐标以及度量值，则认为是相等的。
   * @param {SuperMap.PointWithMeasure} geom - 需要判断的路由点对象。
   * @returns {boolean} 两个路由点对象是否相等（true 为相等，false 为不等）。
   */


  PointWithMeasure_createClass(PointWithMeasure, [{
    key: "equals",
    value: function equals(geom) {
      var equals = false;

      if (geom != null) {
        var isValueEquals = this.x === geom.x && this.y === geom.y && this.measure === geom.measure;
        var isNaNValue = isNaN(this.x) && isNaN(this.y) && isNaN(this.measure);
        var isNaNGeometry = isNaN(geom.x) && isNaN(geom.y) && isNaN(geom.measure);
        equals = isValueEquals || isNaNValue && isNaNGeometry;
      }

      return equals;
    }
    /**
     * @function SuperMap.PointWithMeasure.prototype.toJson
     * @description 转换为 JSON 对象。
     * */

  }, {
    key: "toJson",
    value: function toJson() {
      var result = "{";

      if (this.measure != null && this.measure != undefined) {
        result += "\"measure\":" + this.measure + ",";
      }

      result += "\"x\":" + this.x + ",";
      result += "\"y\":" + this.y;
      result += "}";
      return result;
    }
    /**
    * @function SuperMap.PointWithMeasure.prototype.destroy
    * @description 释放资源，将引用资源的属性置空。
    */

  }, {
    key: "destroy",
    value: function destroy() {
      var me = this;
      me.measure = null;
      me.x = null;
      me.y = null;
    }
    /**
     * @function SuperMap.PointWithMeasure.fromJson
     * @description 将 JSON 对象转换为{@link SuperMap.PointWithMeasure} 对象。
     * @param {Object} jsonObject - JSON 对象表示的路由点。
     * @returns {SuperMap.PointWithMeasure} 转化后的 PointWithMeasure 对象。
     */

  }], [{
    key: "fromJson",
    value: function fromJson(jsonObject) {
      if (!jsonObject) {
        return;
      }

      return new PointWithMeasure({
        x: jsonObject.x,
        y: jsonObject.y,
        measure: jsonObject.measure
      });
    }
  }]);

  return PointWithMeasure;
}(Point_Point);
SuperMap.PointWithMeasure = PointWithMeasure_PointWithMeasure;
// CONCATENATED MODULE: ./src/common/iServer/Route.js
function Route_typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { Route_typeof = function _typeof(obj) { return typeof obj; }; } else { Route_typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return Route_typeof(obj); }

function Route_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function Route_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function Route_createClass(Constructor, protoProps, staticProps) { if (protoProps) Route_defineProperties(Constructor.prototype, protoProps); if (staticProps) Route_defineProperties(Constructor, staticProps); return Constructor; }

function Route_possibleConstructorReturn(self, call) { if (call && (Route_typeof(call) === "object" || typeof call === "function")) { return call; } return Route_assertThisInitialized(self); }

function Route_getPrototypeOf(o) { Route_getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return Route_getPrototypeOf(o); }

function Route_assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function Route_inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) Route_setPrototypeOf(subClass, superClass); }

function Route_setPrototypeOf(o, p) { Route_setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return Route_setPrototypeOf(o, p); }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/






/**
 * @class SuperMap.Route
 * @category  iServer SpatialAnalyst
 * @classdesc 路由对象类。路由对象为一系列有序的带有属性值 M 的 x，y 坐标对，其中 M 值为该结点的距离属性（到已知点的距离）。
 * @param {Array.<SuperMap.Geometry>} points - 形成路由对象的线数组。
 * @param {Object} options - 参数。
 * @param {number} options.id - 路由对象在数据库中的 id。
 * @param {number} options.length - 路由对象的长度。单位与数据集的单位相同。
 * @param {number} [options.maxM] - 最大线性度量值，即所有结点到起始点的量算距离中最大值。
 * @param {number} [options.minM] - 最小线性度量值，即所有结点到起始点的量算距离中最小值。
 * @param {string} [options.type] - 数据类型，如："LINEM"。
 * @extends {SuperMap.Geometry.Collection}
 */

var Route_Route =
/*#__PURE__*/
function (_Collection) {
  Route_inherits(Route, _Collection);

  function Route(points, options) {
    var _this;

    Route_classCallCheck(this, Route);

    _this = Route_possibleConstructorReturn(this, Route_getPrototypeOf(Route).call(this, points, options));
    /**
     * @member {number} SuperMap.Route.prototype.id
     * @description 路由对象在数据库中的 ID。
     */

    _this.id = null;
    /**
     * @member {number} SuperMap.Route.prototype.center
     * @description 路由对象的中心点。
     */

    _this.center = null;
    /**
     * @member {string} SuperMap.Route.prototype.style
     * @description 路由对象的样式。
     */

    _this.style = null;
    /**
     * @member {number} SuperMap.Route.prototype.length
     * @description 路由对象的长度。单位与数据集的单位相同。
     */

    _this.length = null;
    /**
     *  @member {number} SuperMap.Route.prototype.maxM
     *  @description 最大线性度量值，即所有结点到起始点的量算距离中最大值。
     */

    _this.maxM = null;
    /**
     * @member {number} SuperMap.Route.prototype.minM
     * @description 最小线性度量值，即所有结点到起始点的量算距离中最小值。
     */

    _this.minM = null;
    /**
     * @member {Array.<number>} SuperMap.Route.prototype.parts
     * @description 服务端几何对象中各个子对象所包含的节点个数。
     */

    _this.parts = null;
    /**
     * @member {Array.<Object>} SuperMap.Route.prototype.points
     * @description 路由对象的所有路由点。
     * @example
     * (start code)
     * [
     *  {
     *      "measure": 0,
     *      "y": -4377.027184298267,
     *      "x": 4020.0045221720466
     *  },
     *  {
     *      "measure": 37.33288381391519,
     *      "y": -4381.569363260499,
     *      "x": 4057.0600591960642
     *  }
     * ]
     * (end)
     */

    _this.points = null;
    /**
     * @member {string} SuperMap.Route.prototype.type
     * @description 服务端几何对象类型。
     */

    _this.type = null;
    /**
     * @member {Array.<string>} [SuperMap.Route.prototype.componentTypes=SuperMap.Geometry.LineString]
     * @description components 存储的的几何对象所支持的几何类型数组。
     */

    _this.componentTypes = ["SuperMap.Geometry.LinearRing", "SuperMap.Geometry.LineString"];

    if (options) {
      Util.extend(Route_assertThisInitialized(_this), options);
    }

    _this.CLASS_NAME = "SuperMap.Route";
    _this.geometryType = "LINEM";
    return _this;
  }
  /**
   *
   * @function SuperMap.Route.prototype.toJson
   * @description 转换为 JSON 对象。
   * @returns {Object} JSON 对象。
   */


  Route_createClass(Route, [{
    key: "toJson",
    value: function toJson() {
      var result = "{";

      if (this.id != null && this.id != undefined) {
        result += "\"id\":" + this.id + ",";
      }

      if (this.center != null && this.center != undefined) {
        result += "\"center\":" + this.center + ",";
      }

      if (this.style != null && this.style != undefined) {
        result += "\"style\":" + this.style + ",";
      }

      if (this.length != null && this.length != undefined) {
        result += "\"length\":" + this.length + ",";
      }

      if (this.maxM != null && this.maxM != undefined) {
        result += "\"maxM\":" + this.maxM + ",";
      }

      if (this.minM != null && this.minM != undefined) {
        result += "\"minM\":" + this.minM + ",";
      }

      if (this.type != null && this.type != undefined) {
        result += "\"type\":\"" + this.type + "\",";
      }

      if (this.parts != null && this.parts != undefined) {
        result += "\"parts\":[" + this.parts[0];

        for (var i = 1; i < this.parts.length; i++) {
          result += "," + this.parts[i];
        }

        result += "],";
      }

      if (this.components != null && this.components.length > 0) {
        result += "\"points\":[";

        for (var j = 0, len = this.components.length; j < len; j++) {
          for (var k = 0, len2 = this.components[j].components.length; k < len2; k++) {
            result += this.components[j].components[k].toJson() + ",";
          }
        }

        result = result.replace(/,$/g, '');
        result += "]";
      }

      result = result.replace(/,$/g, '');
      result += "}";
      return result;
    }
    /**
     * @function SuperMap.Route.prototype.destroy
     * @override
     */

  }, {
    key: "destroy",
    value: function destroy() {
      var me = this;
      me.id = null;
      me.center = null;
      me.style = null;
      me.length = null;
      me.maxM = null;
      me.minM = null;
      me.type = null;
      me.parts = null;
      me.components.length = 0;
      me.components = null;
      me.componentTypes = null;
    }
    /**
     * @function SuperMap.Route.fromJson
     * @description 将 JSON 对象转换为 SuperMap.Route 对象。
     * @param {Object} [jsonObject] - JSON 对象表示的路由对象。
     * @returns {SuperMap.Route} 转化后的 Route 对象。
     */

  }], [{
    key: "fromJson",
    value: function fromJson(jsonObject) {
      if (!jsonObject) {
        return;
      }

      var geoParts = jsonObject.parts || [],
          geoPoints = jsonObject.points || [],
          len = geoParts.length,
          lineList = [];

      if (len > 0) {
        for (var i = 0, pointIndex = 0, pointList = []; i < len; i++) {
          for (var j = 0; j < geoParts[i]; j++) {
            pointList.push(PointWithMeasure_PointWithMeasure.fromJson(geoPoints[pointIndex + j]));
          }

          pointIndex += geoParts[i]; //判断线是否闭合，如果闭合，则返回LinearRing，否则返回LineString

          if (pointList[0].equals(pointList[geoParts[i] - 1])) {
            lineList.push(new LinearRing(pointList));
          } else {
            lineList.push(new LineString_LineString(pointList));
          }

          pointList = [];
        }
      } else {
        return null;
      }

      return new Route(lineList, {
        id: jsonObject.id,
        center: jsonObject.center,
        style: jsonObject.style,
        length: jsonObject.length,
        maxM: jsonObject.maxM,
        minM: jsonObject.minM,
        type: jsonObject.type,
        parts: jsonObject.parts
      });
    }
  }]);

  return Route;
}(Collection_Collection);
SuperMap.Route = Route_Route;
// CONCATENATED MODULE: ./src/common/iServer/ServerGeometry.js
function ServerGeometry_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function ServerGeometry_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function ServerGeometry_createClass(Constructor, protoProps, staticProps) { if (protoProps) ServerGeometry_defineProperties(Constructor.prototype, protoProps); if (staticProps) ServerGeometry_defineProperties(Constructor, staticProps); return Constructor; }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/












/**
 * @class SuperMap.ServerGeometry
 * @category  iServer  
 * @classdesc 服务端几何对象类。该类描述几何对象（矢量）的特征数据（坐标点对、几何对象的类型等）。基于服务端的空间分析、空间关系运算、查询等 GIS 服务功能使用服务端几何对象。
 * @param {Object} options - 参数。
 * @param {string} options.id - 服务端几何对象唯一标识符。
 * @param {Array.<number>} options.parts - 服务端几何对象中各个子对象所包含的节点个数。
 * @param {Array.<SuperMap.Geometry.Point>} options.points - 组成几何对象的节点的坐标对数组。
 * @param {SuperMap.GeometryType} options.type - 几何对象的类型。
 * @param {SuperMap.ServerStyle} [options.style] - 服务端几何对象的风格。
 */

var ServerGeometry_ServerGeometry =
/*#__PURE__*/
function () {
  function ServerGeometry(options) {
    ServerGeometry_classCallCheck(this, ServerGeometry);

    /**
     * @member {string} SuperMap.ServerGeometry.prototype.id
     * @description 服务端几何对象唯一标识符。
     */
    this.id = 0;
    /**
     * @member {SuperMap.ServerStyle} [SuperMap.ServerGeometry.prototype.style]
     * @description 服务端几何对象的风格（ServerStyle）。
     */

    this.style = null;
    /**
     * @member {Array.<number>} SuperMap.ServerGeometry.prototype.parts
     * @description 服务端几何对象中各个子对象所包含的节点个数。<br>
     * 1.几何对象从结构上可以分为简单几何对象和复杂几何对象。
     * 简单几何对象与复杂几何对象的区别：简单的几何对象一般为单一对象，
     * 而复杂的几何对象由多个简单对象组成或经过一定的空间运算之后产生，
     * 如：矩形为简单的区域对象，而中空的矩形为复杂的区域对象。<br>
     * 2.通常情况，一个简单几何对象的子对象就是它本身，
     * 因此对于简单对象来说的该字段为长度为1的整型数组，
     * 该字段的值就是这个简单对象节点的个数。
     * 如果一个几何对象是由几个简单对象组合而成的，
     * 例如，一个岛状几何对象由 3 个简单的多边形组成而成，
     * 那么这个岛状的几何对象的 Parts 字段值就是一个长度为 3 的整型数组，
     * 数组中每个成员的值分别代表这三个多边形所包含的节点个数。
     */

    this.parts = null;
    /**
     * @member {Array.<SuperMap.Geometry.Point>} SuperMap.ServerGeometry.prototype.points
     * @description 组成几何对象的节点的坐标对数组。<br>
     * 1.所有几何对象（点、线、面）都是由一些简单的点坐标组成的，
     * 该字段存放了组成几何对象的点坐标的数组。
     * 对于简单的面对象，他的起点和终点的坐标点相同。<br>
     * 2.对于复杂的几何对象，根据 Parts 属性来确定每一个组成复杂几何对象的简单对象所对应的节点的个数，
     * 从而确定 Points 字段中坐标对的分配归属问题。
     */

    this.points = null;
    /**
     * @member {SuperMap.GeometryType} SuperMap.ServerGeometry.prototype.type
     * @description 几何对象的类型（GeometryType）。
     */

    this.type = null;
    /**
     * @member {Object} SuperMap.ServerGeometry.prototype.prjCoordSys
     * @description 投影坐标参数，现仅在缓冲区分析中有效。
     */

    this.prjCoordSys = null;

    if (options) {
      Util.extend(this, options);
    }

    this.CLASS_NAME = "SuperMap.ServerGeometry";
  }
  /**
   * @function SuperMap.ServerGeometry.prototype.destroy
   * @description 释放资源，将引用资源的属性置空。
   */


  ServerGeometry_createClass(ServerGeometry, [{
    key: "destroy",
    value: function destroy() {
      var me = this;
      me.id = null;
      me.style = null;
      me.parts = null;
      me.partTopo = null;
      me.points = null;
      me.type = null;
      me.prjCoordSys = null;
    }
    /**
     * @function SuperMap.ServerGeometry.prototype.toGeometry
     * @description 将服务端几何对象 ServerGeometry 转换为客户端几何对象 Geometry。
     * @returns {SuperMap.Geometry} 转换后的客户端几何对象。
     */

  }, {
    key: "toGeometry",
    value: function toGeometry() {
      var me = this,
          geoType = me.type;

      switch (geoType.toUpperCase()) {
        case GeometryType.POINT:
          return me.toGeoPoint();

        case GeometryType.LINE:
          return me.toGeoLine();

        case GeometryType.LINEM:
          return me.toGeoLinem();

        case GeometryType.REGION:
          return me.toGeoRegion();

        case GeometryType.POINTEPS:
          return me.toGeoPoint();

        case GeometryType.LINEEPS:
          return me.toGeoLineEPS();

        case GeometryType.REGIONEPS:
          return me.toGeoRegionEPS();
      }
    }
    /**
     * @function SuperMap.ServerGeometry.prototype.toGeoPoint
     * @description 将服务端的点几何对象转换为客户端几何对象。包括 Point、MultiPoint。
     * @returns {SuperMap.Geometry} 转换后的客户端几何对象。
     */

  }, {
    key: "toGeoPoint",
    value: function toGeoPoint() {
      var me = this,
          geoParts = me.parts || [],
          geoPoints = me.points || [],
          len = geoParts.length;

      if (len > 0) {
        if (len === 1) {
          return new Point_Point(geoPoints[0].x, geoPoints[0].y);
        } else {
          var pointList = [];

          for (var i = 0; i < len; i++) {
            pointList.push(new Point_Point(geoPoints[i].x, geoPoints[i].y));
          }

          return new MultiPoint(pointList);
        }
      } else {
        return null;
      }
    }
    /**
     * @function SuperMap.ServerGeometry.prototype.toGeoLine
     * @description 将服务端的线几何对象转换为客户端几何对象。包括 LinearRing、LineString、MultiLineString。
     * @returns {SuperMap.Geometry} 转换后的客户端几何对象。
     */

  }, {
    key: "toGeoLine",
    value: function toGeoLine() {
      var me = this,
          geoParts = me.parts || [],
          geoPoints = me.points || [],
          len = geoParts.length;

      if (len > 0) {
        if (len === 1) {
          var pointList = [];

          for (var i = 0; i < geoParts[0]; i++) {
            pointList.push(new Point_Point(geoPoints[i].x, geoPoints[i].y));
          } //判断线是否闭合，如果闭合，则返回LinearRing，否则返回LineString


          if (pointList[0].equals(pointList[geoParts[0] - 1])) {
            return new LinearRing(pointList);
          } else {
            return new LineString_LineString(pointList);
          }
        } else {
          var lineList = [];

          for (var _i = 0; _i < len; _i++) {
            var _pointList = [];

            for (var j = 0; j < geoParts[_i]; j++) {
              _pointList.push(new Point_Point(geoPoints[j].x, geoPoints[j].y));
            }

            lineList.push(new LineString_LineString(_pointList));
            geoPoints.splice(0, geoParts[_i]);
          }

          return new MultiLineString(lineList);
        }
      } else {
        return null;
      }
    }
    /**
     * @function SuperMap.ServerGeometry.prototype.toGeoLineEPS
     * @description 将服务端的线几何对象转换为客户端几何对象。包括 LinearRing、LineString、MultiLineString。
     * @returns {SuperMap.Geometry} 转换后的客户端几何对象。
     */

  }, {
    key: "toGeoLineEPS",
    value: function toGeoLineEPS() {
      var me = this,
          geoParts = me.parts || [],
          geoPoints = me.points || [],
          i,
          j,
          pointList,
          lineList,
          lineEPS,
          len = geoParts.length;

      if (len > 0) {
        if (len === 1) {
          for (i = 0, pointList = []; i < geoParts[0]; i++) {
            pointList.push(new Point_Point(geoPoints[i].x, geoPoints[i].y, geoPoints[i].type));
          } //判断线是否闭合，如果闭合，则返回LinearRing，否则返回LineString


          if (pointList[0].equals(pointList[geoParts[0] - 1])) {
            lineEPS = LineString_LineString.createLineEPS(pointList);
            return new LinearRing(lineEPS);
          } else {
            lineEPS = LineString_LineString.createLineEPS(pointList);
            return new LineString_LineString(lineEPS);
          }
        } else {
          for (i = 0, lineList = []; i < len; i++) {
            for (j = 0, pointList = []; j < geoParts[i]; j++) {
              pointList.push(new Point_Point(geoPoints[j].x, geoPoints[j].y));
            }

            lineEPS = LineString_LineString.createLineEPS(pointList);
            lineList.push(new LineString_LineString(lineEPS));
            geoPoints.splice(0, geoParts[i]);
          }

          return new MultiLineString(lineList);
        }
      } else {
        return null;
      }
    }
    /**
     * @function SuperMap.ServerGeometry.prototype.toGeoLine
     * @description 将服务端的路由线几何对象转换为客户端几何对象。包括 LinearRing、LineString、MultiLineString。
     * @returns {SuperMap.Geometry} 转换后的客户端几何对象。
     */

  }, {
    key: "toGeoLinem",
    value: function toGeoLinem() {
      var me = this;
      return Route_Route.fromJson(me);
    }
    /**
     * @function SuperMap.ServerGeometry.prototype.toGeoRegion
     * @description 将服务端的面几何对象转换为客户端几何对象。类型为 Polygon。
     * @returns {SuperMap.Geometry} 转换后的客户端几何对象。
     */

  }, {
    key: "toGeoRegion",
    value: function toGeoRegion() {
      var me = this,
          geoParts = me.parts || [],
          geoTopo = me.partTopo || [],
          geoPoints = me.points || [],
          len = geoParts.length;

      if (len <= 0) {
        return null;
      }

      var polygonArray = [];
      var pointList = [];

      if (len == 1) {
        for (var i = 0; i < geoPoints.length; i++) {
          pointList.push(new Point_Point(geoPoints[i].x, geoPoints[i].y));
        }

        polygonArray.push(new Polygon([new LinearRing(pointList)]));
        return new MultiPolygon(polygonArray);
      } //处理复杂面


      var CCWArray = [];
      var areaArray = [];
      var polygonArrayTemp = [];
      var polygonBounds = []; //polyon岛洞标识数组，初始都是岛。

      var CCWIdent = [];

      for (var _i2 = 0, pointIndex = 0; _i2 < len; _i2++) {
        for (var j = 0; j < geoParts[_i2]; j++) {
          pointList.push(new Point_Point(geoPoints[pointIndex + j].x, geoPoints[pointIndex + j].y));
        }

        pointIndex += geoParts[_i2];
        var polygon = new Polygon([new LinearRing(pointList)]);
        pointList = [];
        polygonArrayTemp.push(polygon);

        if (geoTopo.length === 0) {
          polygonBounds.push(polygon.getBounds());
        }

        CCWIdent.push(1);
        areaArray.push(polygon.getArea());
      } //根据面积排序


      ServerGeometry.bubbleSort(areaArray, polygonArrayTemp, geoTopo, polygonBounds); //iServer 9D新增字段

      if (geoTopo.length === 0) {
        //岛洞底层判断原则：将所有的子对象按照面积排序，面积最大的直接判定为岛（1），从面积次大的开始处理，
        // 如果发现该对象在某个面积大于它的对象之中（即被包含），则根据包含它的对象的标识（1 or -1），指定其标识（-1 or 1），
        // 依次处理完所有对象，就得到了一个标识数组，1表示岛，-1表示洞
        //目标polygon索引列表 -1标示没有被任何polygon包含，
        var targetArray = [];

        for (var _i3 = 1; _i3 < polygonArrayTemp.length; _i3++) {
          for (var _j = _i3 - 1; _j >= 0; _j--) {
            targetArray[_i3] = -1;

            if (polygonBounds[_j].containsBounds(polygonBounds[_i3])) {
              CCWIdent[_i3] = CCWIdent[_j] * -1;

              if (CCWIdent[_i3] < 0) {
                targetArray[_i3] = _j;
              }

              break;
            }
          }
        }

        for (var _i4 = 0; _i4 < polygonArrayTemp.length; _i4++) {
          if (CCWIdent[_i4] > 0) {
            polygonArray.push(polygonArrayTemp[_i4]);
          } else {
            polygonArray[targetArray[_i4]].components = polygonArray[targetArray[_i4]].components.concat(polygonArrayTemp[_i4].components); //占位

            polygonArray.push('');
          }
        }
      } else {
        //根据面积排序
        //ServerGeometry.bubbleSort(areaArray, polygonArrayTemp,geoTopo);
        polygonArray = new Array();

        for (var _i5 = 0; _i5 < polygonArrayTemp.length; _i5++) {
          if (geoTopo[_i5] && geoTopo[_i5] == -1) {
            CCWArray = CCWArray.concat(polygonArrayTemp[_i5].components);
          } else {
            if (CCWArray.length > 0 && polygonArray.length > 0) {
              polygonArray[polygonArray.length - 1].components = polygonArray[polygonArray.length - 1].components.concat(CCWArray);
              CCWArray = [];
            }

            polygonArray.push(polygonArrayTemp[_i5]);
          }

          if (_i5 == len - 1) {
            var polyLength = polygonArray.length;

            if (polyLength) {
              polygonArray[polyLength - 1].components = polygonArray[polyLength - 1].components.concat(CCWArray);
            } else {
              for (var k = 0, length = CCWArray.length; k < length; k++) {
                polygonArray.push(new Polygon(CCWArray));
              }
            }
          }
        }
      }

      return new MultiPolygon(polygonArray);
    }
    /**
     * @function SuperMap.ServerGeometry.prototype.toGeoRegionEPS
     * @description 将服务端的面几何对象转换为客户端几何对象。类型为 Polygon。
     * @returns {SuperMap.Geometry} 转换后的客户端几何对象。
     */

  }, {
    key: "toGeoRegionEPS",
    value: function toGeoRegionEPS() {
      var me = this,
          geoParts = me.parts || [],
          geoTopo = me.partTopo || [],
          geoPoints = me.points || [],
          len = geoParts.length;

      if (len <= 0) {
        return null;
      }

      var polygonArray = [];
      var pointList = [];
      var lineEPS;

      if (len == 1) {
        for (var i = 0; i < geoPoints.length; i++) {
          pointList.push(new Point_Point(geoPoints[i].x, geoPoints[i].y));
        }

        lineEPS = LineString_LineString.createLineEPS(pointList);
        polygonArray.push(new Polygon([new LinearRing(lineEPS)]));
        return new MultiPolygon(polygonArray);
      } //处理复杂面


      var CCWArray = [];
      var areaArray = [];
      var polygonArrayTemp = [];
      var polygonBounds = []; //polyon岛洞标识数组，初始都是岛。

      var CCWIdent = [];

      for (var _i6 = 0, pointIndex = 0; _i6 < len; _i6++) {
        for (var j = 0; j < geoParts[_i6]; j++) {
          pointList.push(new Point_Point(geoPoints[pointIndex + j].x, geoPoints[pointIndex + j].y));
        }

        pointIndex += geoParts[_i6];
        lineEPS = LineString_LineString.createLineEPS(pointList);
        var polygon = new Polygon([new LinearRing(lineEPS)]);
        pointList = [];
        polygonArrayTemp.push(polygon);

        if (geoTopo.length === 0) {
          polygonBounds.push(polygon.getBounds());
        }

        CCWIdent.push(1);
        areaArray.push(polygon.getArea());
      } //根据面积排序


      ServerGeometry.bubbleSort(areaArray, polygonArrayTemp, geoTopo, polygonBounds); //iServer 9D新增字段

      if (geoTopo.length === 0) {
        //岛洞底层判断原则：将所有的子对象按照面积排序，面积最大的直接判定为岛（1），从面积次大的开始处理，
        // 如果发现该对象在某个面积大于它的对象之中（即被包含），则根据包含它的对象的标识（1 or -1），指定其标识（-1 or 1），
        // 依次处理完所有对象，就得到了一个标识数组，1表示岛，-1表示洞
        //目标polygon索引列表 -1标示没有被任何polygon包含，
        var targetArray = [];

        for (var _i7 = 1; _i7 < polygonArrayTemp.length; _i7++) {
          for (var _j2 = _i7 - 1; _j2 >= 0; _j2--) {
            targetArray[_i7] = -1;

            if (polygonBounds[_j2].containsBounds(polygonBounds[_i7])) {
              CCWIdent[_i7] = CCWIdent[_j2] * -1;

              if (CCWIdent[_i7] < 0) {
                targetArray[_i7] = _j2;
              }

              break;
            }
          }
        }

        for (var _i8 = 0; _i8 < polygonArrayTemp.length; _i8++) {
          if (CCWIdent[_i8] > 0) {
            polygonArray.push(polygonArrayTemp[_i8]);
          } else {
            polygonArray[targetArray[_i8]].components = polygonArray[targetArray[_i8]].components.concat(polygonArrayTemp[_i8].components); //占位

            polygonArray.push('');
          }
        }
      } else {
        //根据面积排序
        polygonArray = new Array();

        for (var _i9 = 0; _i9 < polygonArrayTemp.length; _i9++) {
          if (geoTopo[_i9] && geoTopo[_i9] == -1) {
            CCWArray = CCWArray.concat(polygonArrayTemp[_i9].components);
          } else {
            if (CCWArray.length > 0 && polygonArray.length > 0) {
              polygonArray[polygonArray.length - 1].components = polygonArray[polygonArray.length - 1].components.concat(CCWArray);
              CCWArray = [];
            }

            polygonArray.push(polygonArrayTemp[_i9]);
          }

          if (_i9 == len - 1) {
            var polyLength = polygonArray.length;

            if (polyLength) {
              polygonArray[polyLength - 1].components = polygonArray[polyLength - 1].components.concat(CCWArray);
            } else {
              for (var k = 0, length = CCWArray.length; k < length; k++) {
                polygonArray.push(new Polygon(CCWArray));
              }
            }
          }
        }
      }

      return new MultiPolygon(polygonArray);
    }
    /**
     * @function SuperMap.ServerGeometry.prototype.fromJson
     * @description 将 JSON 对象表示服务端几何对象转换为 ServerGeometry。
     * @param {Object} jsonObject - 要转换的 JSON 对象。
     * @returns {SuperMap.ServerGeometry} 转换后的 ServerGeometry 对象。
     */

  }], [{
    key: "fromJson",
    value: function fromJson(jsonObject) {
      if (!jsonObject) {
        return;
      }

      return new ServerGeometry({
        id: jsonObject.id,
        style: ServerStyle_ServerStyle.fromJson(jsonObject.style),
        parts: jsonObject.parts,
        partTopo: jsonObject.partTopo,
        points: jsonObject.points,
        center: jsonObject.center,
        length: jsonObject.length,
        maxM: jsonObject.maxM,
        minM: jsonObject.minM,
        type: jsonObject.type
      });
    }
    /**
     * @function SuperMap.ServerGeometry.prototype.fromGeometry
     * @description 将客户端 Geometry 转换成服务端 ServerGeometry。
     * @param {SuperMap.Geometry} geometry - 要转换的客户端 Geometry 对象。
     * @returns {SuperMap.ServerGeometry} 转换后的 ServerGeometry 对象。
     */

  }, {
    key: "fromGeometry",
    value: function fromGeometry(geometry) {
      if (!geometry) {
        return;
      }

      var id = 0,
          parts = [],
          points = [],
          type = null,
          icomponents = geometry.components,
          className = geometry.CLASS_NAME,
          prjCoordSys = {
        "epsgCode": geometry.SRID
      };

      if (!isNaN(geometry.id)) {
        id = geometry.id;
      } //坑爹的改法，没法，为了支持态势标绘，有时间就得全改


      if (className != "SuperMap.Geometry.LinearRing" && className != "SuperMap.Geometry.LineString" && (geometry instanceof MultiPoint || geometry instanceof MultiLineString)) {
        var ilen = icomponents.length;

        for (var i = 0; i < ilen; i++) {
          var partPointsCount = icomponents[i].getVertices().length;
          parts.push(partPointsCount);

          for (var j = 0; j < partPointsCount; j++) {
            points.push(new Point_Point(icomponents[i].getVertices()[j].x, icomponents[i].getVertices()[j].y));
          }
        } //这里className不是多点就全部是算线


        type = className == "SuperMap.Geometry.MultiPoint" ? GeometryType.POINT : GeometryType.LINE;
      } else if (geometry instanceof MultiPolygon) {
        var _ilen = icomponents.length;

        for (var _i10 = 0; _i10 < _ilen; _i10++) {
          var polygon = icomponents[_i10],
              linearRingOfPolygon = polygon.components,
              linearRingOfPolygonLen = linearRingOfPolygon.length;

          for (var _j3 = 0; _j3 < linearRingOfPolygonLen; _j3++) {
            var _partPointsCount = linearRingOfPolygon[_j3].getVertices().length + 1;

            parts.push(_partPointsCount);

            for (var k = 0; k < _partPointsCount - 1; k++) {
              points.push(new Point_Point(linearRingOfPolygon[_j3].getVertices()[k].x, linearRingOfPolygon[_j3].getVertices()[k].y));
            }

            points.push(new Point_Point(linearRingOfPolygon[_j3].getVertices()[0].x, linearRingOfPolygon[_j3].getVertices()[0].y));
          }
        }

        type = GeometryType.REGION;
      } else if (geometry instanceof Polygon) {
        var _ilen2 = icomponents.length;

        for (var _i11 = 0; _i11 < _ilen2; _i11++) {
          var _partPointsCount2 = icomponents[_i11].getVertices().length + 1;

          parts.push(_partPointsCount2);

          for (var _j4 = 0; _j4 < _partPointsCount2 - 1; _j4++) {
            points.push(new Point_Point(icomponents[_i11].getVertices()[_j4].x, icomponents[_i11].getVertices()[_j4].y));
          }

          points.push(new Point_Point(icomponents[_i11].getVertices()[0].x, icomponents[_i11].getVertices()[0].y));
        }

        type = GeometryType.REGION;
      } else {
        var geometryVerticesCount = geometry.getVertices().length;

        for (var _j5 = 0; _j5 < geometryVerticesCount; _j5++) {
          points.push(new Point_Point(geometry.getVertices()[_j5].x, geometry.getVertices()[_j5].y));
        }

        if (geometry instanceof LinearRing) {
          points.push(new Point_Point(geometry.getVertices()[0].x, geometry.getVertices()[0].y));
          geometryVerticesCount++;
        }

        parts.push(geometryVerticesCount);
        type = geometry instanceof Point_Point ? GeometryType.POINT : GeometryType.LINE;
      }

      return new ServerGeometry({
        id: id,
        style: null,
        parts: parts,
        points: points,
        type: type,
        prjCoordSys: prjCoordSys
      });
    }
    /**
     * @function SuperMap.ServerGeometry.prototype.IsClockWise
     * @description 判断 linearRing 中的点的顺序。返回值大于 0，逆时针；小于 0，顺时针。
     * @param {SuperMap.Geometry} geometry - 要转换的客户端 Geometry 对象。
     * @returns {number} 返回值大于 0，逆时针；小于 0，顺时针。
     */

  }, {
    key: "IsClockWise",
    value: function IsClockWise(points) {
      var length = points.length;

      if (length < 3) {
        return 0.0;
      }

      var s = points[0].y * (points[length - 1].x - points[1].x);
      points.push(points[0]);

      for (var i = 1; i < length; i++) {
        s += points[i].y * (points[i - 1].x - points[i + 1].x);
      }

      return s * 0.5;
    }
  }, {
    key: "bubbleSort",
    value: function bubbleSort(areaArray, pointList, geoTopo, polygonBounds) {
      for (var i = 0; i < areaArray.length; i++) {
        for (var j = 0; j < areaArray.length; j++) {
          if (areaArray[i] > areaArray[j]) {
            var d = areaArray[j];
            areaArray[j] = areaArray[i];
            areaArray[i] = d;
            var b = pointList[j];
            pointList[j] = pointList[i];
            pointList[i] = b;

            if (geoTopo && geoTopo.length > 0) {
              var c = geoTopo[j];
              geoTopo[j] = geoTopo[i];
              geoTopo[i] = c;
            }

            if (polygonBounds && polygonBounds.length > 0) {
              var f = polygonBounds[j];
              polygonBounds[j] = polygonBounds[i];
              polygonBounds[i] = f;
            }
          }
        }
      }
    }
  }]);

  return ServerGeometry;
}();
SuperMap.ServerGeometry = ServerGeometry_ServerGeometry;
// CONCATENATED MODULE: ./src/common/format/GeoJSON.js
function GeoJSON_typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { GeoJSON_typeof = function _typeof(obj) { return typeof obj; }; } else { GeoJSON_typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return GeoJSON_typeof(obj); }

function GeoJSON_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function GeoJSON_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function GeoJSON_createClass(Constructor, protoProps, staticProps) { if (protoProps) GeoJSON_defineProperties(Constructor.prototype, protoProps); if (staticProps) GeoJSON_defineProperties(Constructor, staticProps); return Constructor; }

function GeoJSON_possibleConstructorReturn(self, call) { if (call && (GeoJSON_typeof(call) === "object" || typeof call === "function")) { return call; } return GeoJSON_assertThisInitialized(self); }

function GeoJSON_assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function GeoJSON_get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { GeoJSON_get = Reflect.get; } else { GeoJSON_get = function _get(target, property, receiver) { var base = GeoJSON_superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return GeoJSON_get(target, property, receiver || target); }

function GeoJSON_superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = GeoJSON_getPrototypeOf(object); if (object === null) break; } return object; }

function GeoJSON_getPrototypeOf(o) { GeoJSON_getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return GeoJSON_getPrototypeOf(o); }

function GeoJSON_inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) GeoJSON_setPrototypeOf(subClass, superClass); }

function GeoJSON_setPrototypeOf(o, p) { GeoJSON_setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return GeoJSON_setPrototypeOf(o, p); }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/














/**
 * @class SuperMap.Format.GeoJSON
 * @classdesc  GeoJSON 的读和写。使用 {@link SuperMap.Format.GeoJSON} 构造器创建一个 GeoJSON 解析器。
 * @category BaseTypes Format
 * @param {Object} [options] - 参数。
 * @param {string} [options.indent="    "] - 用于格式化输出，indent 字符串会在每次缩进的时候使用一次。
 * @param {string} [options.space=" "] - 用于格式化输出，space 字符串会在名值对的 ":" 后边添加。
 * @param {string} [options.newline="\n"] - 用于格式化输出, newline 字符串会用在每一个名值对或数组项末尾。
 * @param {number} [options.level=0] - 用于格式化输出, 表示的是缩进级别。
 * @param {boolean} [options.pretty=false] - 是否在序列化的时候使用额外的空格控制结构。在 write 方法中使用。
 * @param {boolean} [options.nativeJSON] - 需要被注册的监听器对象。
 * @param {boolean} [options.ignoreExtraDims=true] - 忽略维度超过 2 的几何要素。
 * @extends {SuperMap.Format.JSON}
 */

var GeoJSON_GeoJSON =
/*#__PURE__*/
function (_JSONFormat) {
  GeoJSON_inherits(GeoJSON, _JSONFormat);

  function GeoJSON(options) {
    var _this;

    GeoJSON_classCallCheck(this, GeoJSON);

    _this = GeoJSON_possibleConstructorReturn(this, GeoJSON_getPrototypeOf(GeoJSON).call(this, options));
    /**
     * @member {boolean} [SuperMap.Format.GeoJSON.prototype.ignoreExtraDims=true]
     * @description 忽略维度超过 2 的几何要素。
     */

    _this.ignoreExtraDims = true;
    _this.CLASS_NAME = "SuperMap.Format.GeoJSON";
    /**
     * @member {Object} SuperMap.Format.GeoJSON.prototype.parseCoords 
     * @private
     * @description 一个属性名对应着 GeoJSON 对象的几何类型的对象。每个属性其实都是一个实际上做解析用的方法。
     */

    _this.parseCoords = {
      /**
       * @function SuperMap.Format.GeoJSON.parseCoords.point
       * @description 将一组坐标转成一个 {@link SuperMap.Geometry} 对象。
       * @param {Object} array - GeoJSON 片段中的一组坐标。
       * @returns {SuperMap.Geometry} 一个几何对象。
       */
      "point": function point(array) {
        if (this.ignoreExtraDims === false && array.length != 2) {
          throw "Only 2D points are supported: " + array;
        }

        return new Point_Point(array[0], array[1]);
      },

      /**
       * @function SuperMap.Format.GeoJSON.parseCoords.multipoint
       * @description 将坐标组数组转化成为一个 {@link SuperMap.Geometry} 对象。
       * @param {Object} array - GeoJSON 片段中的坐标组数组。
       * @returns {SuperMap.Geometry} 一个几何对象。
       */
      "multipoint": function multipoint(array) {
        var points = [];
        var p = null;

        for (var i = 0, len = array.length; i < len; ++i) {
          try {
            p = this.parseCoords["point"].apply(this, [array[i]]);
          } catch (err) {
            throw err;
          }

          points.push(p);
        }

        return new MultiPoint(points);
      },

      /**
       * @function SuperMap.Format.GeoJSON.parseCoords.linestring
       * @description 将坐标组数组转化成为一个 {@link SuperMap.Geometry} 对象。
       * @param {Object} array - GeoJSON 片段中的坐标组数组。
       * @returns {SuperMap.Geometry} 一个几何对象。
       */
      "linestring": function linestring(array) {
        var points = [];
        var p = null;

        for (var i = 0, len = array.length; i < len; ++i) {
          try {
            p = this.parseCoords["point"].apply(this, [array[i]]);
          } catch (err) {
            throw err;
          }

          points.push(p);
        }

        return new LineString_LineString(points);
      },

      /**
       * @function SuperMap.Format.GeoJSON.parseCoords.multilinestring
       * @description 将坐标组数组转化成为一个 {@link SuperMap.Geometry} 对象。
       * @param {Object} array - GeoJSON 片段中的坐标组数组。
       * @returns {SuperMap.Geometry} 一个几何对象。
       */
      "multilinestring": function multilinestring(array) {
        var lines = [];
        var l = null;

        for (var i = 0, len = array.length; i < len; ++i) {
          try {
            l = this.parseCoords["linestring"].apply(this, [array[i]]);
          } catch (err) {
            throw err;
          }

          lines.push(l);
        }

        return new MultiLineString(lines);
      },

      /**
       * @function SuperMap.Format.GeoJSON.parseCoords.polygon
       * @description 将坐标组数组转化成为一个 {@link SuperMap.Geometry} 对象。
       * @returns {SuperMap.Geometry} 一个几何对象。
       */
      "polygon": function polygon(array) {
        var rings = [];
        var r, l;

        for (var i = 0, len = array.length; i < len; ++i) {
          try {
            l = this.parseCoords["linestring"].apply(this, [array[i]]);
          } catch (err) {
            throw err;
          }

          r = new LinearRing(l.components);
          rings.push(r);
        }

        return new Polygon(rings);
      },

      /**
       * @function SuperMap.Format.GeoJSON.parseCoords.multipolygon
       * @description 将坐标组数组转化成为一个 {@link SuperMap.Geometry} 对象。
       * @param {Object} array - GeoJSON 片段中的坐标组数组。
       * @returns {SuperMap.Geometry} 一个几何对象。
       */
      "multipolygon": function multipolygon(array) {
        var polys = [];
        var p = null;

        for (var i = 0, len = array.length; i < len; ++i) {
          try {
            p = this.parseCoords["polygon"].apply(this, [array[i]]);
          } catch (err) {
            throw err;
          }

          polys.push(p);
        }

        return new MultiPolygon(polys);
      },

      /**
       * @function SuperMap.Format.GeoJSON.parseCoords.box
       * @description 将坐标组数组转化成为一个 {@link SuperMap.Geometry} 对象。
       * @param {Object} array - GeoJSON 片段中的坐标组数组。
       * @returns {SuperMap.Geometry} 一个几何对象。
       */
      "box": function box(array) {
        if (array.length != 2) {
          throw "GeoJSON box coordinates must have 2 elements";
        }

        return new Polygon([new LinearRing([new Point_Point(array[0][0], array[0][1]), new Point_Point(array[1][0], array[0][1]), new Point_Point(array[1][0], array[1][1]), new Point_Point(array[0][0], array[1][1]), new Point_Point(array[0][0], array[0][1])])]);
      }
    };
    /**
     * @member {Object} SuperMap.Format.GeoJSON.prototype.extract
     * @private
     * @description 一个属性名对应着GeoJSON类型的对象。其值为相应的实际的解析方法。
     */

    _this.extract = {
      /**
       * @function SuperMap.Format.GeoJSON.extract.feature
       * @description 返回一个表示单个要素对象的 GeoJSON 的一部分。
       * @param {SuperMap.ServerFeature} feature - iServer 要素对象。
       * @returns {Object} 一个表示点的对象。
       */
      'feature': function feature(_feature) {
        var geom = this.extract.geometry.apply(this, [_feature.geometry]);
        var json = {
          "type": "Feature",
          "properties": this.createAttributes(_feature),
          "geometry": geom
        };

        if (_feature.geometry && _feature.geometry.type === 'TEXT') {
          json.properties.texts = _feature.geometry.texts;
          json.properties.textStyle = _feature.geometry.textStyle;
        }

        if (_feature.fid) {
          json.id = _feature.fid;
        }

        if (_feature.ID) {
          json.id = _feature.ID;
        }

        return json;
      },

      /**
       * @function SuperMap.Format.GeoJSON.extract.geometry
       * @description 返回一个表示单个几何对象的 GeoJSON 的一部分。
       * @param {Object} geometry - iServer 几何对象。
       * @returns {Object} 一个表示几何体的对象。
       */
      'geometry': function geometry(_geometry) {
        if (_geometry == null) {
          return null;
        }

        if (!_geometry.parts && _geometry.points) {
          _geometry.parts = [_geometry.points.length];
        }

        var geo = new ServerGeometry_ServerGeometry(_geometry).toGeometry() || _geometry;

        var geometryType = geo.geometryType || geo.type;
        var data;

        if (geometryType === "LinearRing") {
          geometryType = "LineString";
        }

        if (geometryType === "LINEM") {
          geometryType = "MultiLineString";
        }

        data = this.extract[geometryType.toLowerCase()].apply(this, [geo]);
        geometryType = geometryType === 'TEXT' ? 'Point' : geometryType;
        var json;

        if (geometryType === "Collection") {
          json = {
            "type": "GeometryCollection",
            "geometries": data
          };
        } else {
          json = {
            "type": geometryType,
            "coordinates": data
          };
        }

        return json;
      },

      /**
       * @function SuperMap.Format.GeoJSON.extract.point
       * @description 从一个点对象中返回一个坐标组。
       * @param {SuperMap.Geometry.Point} point - 一个点对象。
       * @returns {Array} 一个表示一个点的坐标组。
       */
      'point': function point(_point) {
        var p = [_point.x, _point.y];

        for (var name in _point) {
          if (name !== "x" && name !== "y" && _point[name] !== null && !isNaN(_point[name])) {
            p.push(_point[name]);
          }
        }

        return p;
      },

      /**
       * @function SuperMap.Format.GeoJSON.extract.point
       * @description 从一个文本对象中返回一个坐标组。
       * @param {Object} geo - 一个文本对象。
       * @returns {Array} 一个表示一个点的坐标组。
       */
      'text': function text(geo) {
        return [geo.points[0].x, geo.points[0].y];
      },

      /**
       * @function SuperMap.Format.GeoJSON.extract.multipoint
       * @description 从一个多点对象中返一个坐标组数组。
       * @param {SuperMap.Geometry.MultiPoint} multipoint - 多点对象。
       * @returns {Array} 一个表示多点的坐标组数组。
       */
      'multipoint': function multipoint(_multipoint) {
        var array = [];

        for (var i = 0, len = _multipoint.components.length; i < len; ++i) {
          array.push(this.extract.point.apply(this, [_multipoint.components[i]]));
        }

        return array;
      },

      /**
       * @function SuperMap.Format.GeoJSON.extract.linestring
       * @description 从一个线对象中返回一个坐标组数组。
       * @param {SuperMap.Geometry.Linestring} linestring - 线对象。
       * @returns {Array} 一个表示线对象的坐标组数组。
       */
      'linestring': function linestring(_linestring) {
        var array = [];

        for (var i = 0, len = _linestring.components.length; i < len; ++i) {
          array.push(this.extract.point.apply(this, [_linestring.components[i]]));
        }

        return array;
      },

      /**
       * @function SuperMap.Format.GeoJSON.extract.multilinestring
       * @description 从一个多线对象中返回一个线数组。
       * @param {SuperMap.Geometry.MultiLinestring} multilinestring - 多线对象。
       *
       * @returns {Array} 一个表示多线的线数组。
       */
      'multilinestring': function multilinestring(_multilinestring) {
        var array = [];

        for (var i = 0, len = _multilinestring.components.length; i < len; ++i) {
          array.push(this.extract.linestring.apply(this, [_multilinestring.components[i]]));
        }

        return array;
      },

      /**
       * @function SuperMap.Format.GeoJSON.extract.polygon
       * @description 从一个面对象中返回一组线环。
       * @param {SuperMap.Geometry.Polygon} polygon - 面对象。
       * @returns {Array} 一组表示面的线环。
       */
      'polygon': function polygon(_polygon) {
        var array = [];

        for (var i = 0, len = _polygon.components.length; i < len; ++i) {
          array.push(this.extract.linestring.apply(this, [_polygon.components[i]]));
        }

        return array;
      },

      /**
       * @function SuperMap.Format.GeoJSON.extract.multipolygon
       * @description 从一个多面对象中返回一组面。
       * @param {SuperMap.Geometry.MultiPolygon} multipolygon - 多面对象。
       * @returns {Array} 一组表示多面的面。
       */
      'multipolygon': function multipolygon(_multipolygon) {
        var array = [];

        for (var i = 0, len = _multipolygon.components.length; i < len; ++i) {
          array.push(this.extract.polygon.apply(this, [_multipolygon.components[i]]));
        }

        return array;
      },

      /**
       * @function SuperMap.Format.GeoJSON.extract.collection
       * @description 从一个几何要素集合中一组几何要素数组。
       * @param {SuperMap.Geometry.Collection} collection - 几何要素集合。
       * @returns {Array} 一组表示几何要素集合的几何要素数组。
       */
      'collection': function collection(_collection) {
        var len = _collection.components.length;
        var array = new Array(len);

        for (var i = 0; i < len; ++i) {
          array[i] = this.extract.geometry.apply(this, [_collection.components[i]]);
        }

        return array;
      }
    };
    return _this;
  }
  /**
   * @function SuperMap.Format.GeoJSON.prototype.read
   * @description 将 GeoJSON 对象或者GeoJSON 对象字符串转换为 SuperMap Feature 对象。
   * @param {GeoJSONObject} json - GeoJSON 对象。
   * @param {string} [type='FeaureCollection'] - 可选的字符串，它决定了输出的格式。支持的值有："Geometry","Feature"，和 "FeatureCollection"，如果此值为null。
   * @param {Function} filter - 对象中每个层次每个键值对都会调用此函数得出一个结果。每个值都会被 filter 函数的结果所替换掉。这个函数可被用来将某些对象转化成某个类相应的对象，或者将日期字符串转化成Date对象。
   * @returns {Object}  返回值依赖于 type 参数的值。
   *     -如果 type 等于 "FeatureCollection"，返回值将会是 {@link SuperMap.Feature.Vector} 数组。
   *     -如果 type 为 "Geometry",输入的 JSON 对象必须表示一个唯一的几何体，然后返回值就会是 {@link SuperMap.Feature.Geometry}。
   *     -如果 type 为 "Feature"，输入的 JSON 对象也必须表示的一个要素，这样返回值才会是 {@link SuperMap.Feature.Vector}。
   */


  GeoJSON_createClass(GeoJSON, [{
    key: "read",
    value: function read(json, type, filter) {
      type = type ? type : "FeatureCollection";
      var results = null;
      var obj = null;

      if (typeof json == "string") {
        obj = GeoJSON_get(GeoJSON_getPrototypeOf(GeoJSON.prototype), "read", this).call(this, json, filter);
      } else {
        obj = json;
      }

      if (!obj) {//SuperMap.Console.error("Bad JSON: " + json);
      } else if (typeof obj.type != "string") {//SuperMap.Console.error("Bad GeoJSON - no type: " + json);
      } else if (this.isValidType(obj, type)) {
        switch (type) {
          case "Geometry":
            try {
              results = this.parseGeometry(obj);
            } catch (err) {//SuperMap.Console.error(err);
            }

            break;

          case "Feature":
            try {
              results = this.parseFeature(obj);
              results.type = "Feature";
            } catch (err) {//SuperMap.Console.error(err);
            }

            break;

          case "FeatureCollection":
            // for type FeatureCollection, we allow input to be any type
            results = [];

            switch (obj.type) {
              case "Feature":
                try {
                  results.push(this.parseFeature(obj));
                } catch (err) {
                  results = null; //SuperMap.Console.error(err);
                }

                break;

              case "FeatureCollection":
                for (var i = 0, len = obj.features.length; i < len; ++i) {
                  try {
                    results.push(this.parseFeature(obj.features[i]));
                  } catch (err) {
                    results = null; // SuperMap.Console.error(err);
                  }
                }

                break;

              default:
                try {
                  var geom = this.parseGeometry(obj);
                  results.push(new Vector_Vector(geom));
                } catch (err) {
                  results = null; //SuperMap.Console.error(err);
                }

            }

            break;

          default:
            break;
        }
      }

      return results;
    }
    /**
     * @function SuperMap.Format.GeoJSON.prototype.write
     * @description iServer Geometry JSON 对象 转 GeoJSON对象字符串。
     * @param {Object} obj - iServer Geometry JSON 对象。
     * @param {boolean} [pretty=false] - 是否使用换行和缩进来控制输出。
     * @returns {GeoJSONObject} 一个 GeoJSON 字符串，它表示了输入的几何对象，要素对象，或者要素对象数组。
     */

  }, {
    key: "write",
    value: function write(obj, pretty) {
      return GeoJSON_get(GeoJSON_getPrototypeOf(GeoJSON.prototype), "write", this).call(this, this.toGeoJSON(obj), pretty);
    }
    /**
     * @function SuperMap.Format.GeoJSON.prototype.fromGeoJSON
     * @version 9.1.1
     * @description 将 GeoJSON 对象或者GeoJSON 对象字符串转换为iServer Feature JSON。
     * @param {GeoJSONObject} json - GeoJSON 对象。
     * @param {string} [type='FeaureCollection'] - 可选的字符串，它决定了输出的格式。支持的值有："Geometry","Feature"，和 "FeatureCollection"，如果此值为null。
     * @param {Function} filter - 对象中每个层次每个键值对都会调用此函数得出一个结果。每个值都会被 filter 函数的结果所替换掉。这个函数可被用来将某些对象转化成某个类相应的对象，或者将日期字符串转化成Date对象。
     * @returns {Object}  iServer Feature JSON。
     */

  }, {
    key: "fromGeoJSON",
    value: function fromGeoJSON(json, type, filter) {
      var _this2 = this;

      var feature = this.read(json, type, filter);

      if (!Util.isArray(feature)) {
        return this._toiSevrerFeature(feature);
      }

      return feature.map(function (element) {
        return _this2._toiSevrerFeature(element);
      });
    }
    /**
     * @function SuperMap.Format.GeoJSON.prototype.toGeoJSON
     * @version 9.1.1
     * @description 将 iServer Feature JSON 对象转换为 GeoJSON 对象。
     * @param {Object} obj - iServer Feature JSON。
     * @returns {GeoJSONObject}  GeoJSON 对象。
     */

  }, {
    key: "toGeoJSON",
    value: function toGeoJSON(obj) {
      var geojson = {
        "type": null
      };

      if (Util.isArray(obj)) {
        geojson.type = "FeatureCollection";
        var numFeatures = obj.length;
        geojson.features = new Array(numFeatures);

        for (var i = 0; i < numFeatures; ++i) {
          var element = obj[i];

          if (isGeometry(element)) {
            var feature = {};
            feature.geometry = element;
            geojson.features[i] = this.extract.feature.apply(this, [feature]);
          } else {
            geojson.features[i] = this.extract.feature.apply(this, [element]);
          }
        }
      } else if (isGeometry(obj)) {
        var _feature2 = {};
        _feature2.geometry = obj;
        geojson = this.extract.feature.apply(this, [_feature2]);
      } else {
        geojson = this.extract.feature.apply(this, [obj]);
      }

      function isGeometry(input) {
        return input.hasOwnProperty("parts") && input.hasOwnProperty("points");
      }

      return geojson;
    }
    /**
     *  @function SuperMap.Format.GeoJSON.prototype.isValidType
     *  @description 检查一个 GeoJSON 对象是否和给定的类型相符的合法的对象。
     *  @returns {boolean} GeoJSON 是否是给定类型的合法对象。
     *  @private
     */

  }, {
    key: "isValidType",
    value: function isValidType(obj, type) {
      var valid = false;

      switch (type) {
        case "Geometry":
          if (Util.indexOf(["Point", "MultiPoint", "LineString", "MultiLineString", "Polygon", "MultiPolygon", "Box", "GeometryCollection"], obj.type) == -1) {// unsupported geometry type
            //SuperMap.Console.error("Unsupported geometry type: " +
            // obj.type);
          } else {
            valid = true;
          }

          break;

        case "FeatureCollection":
          // allow for any type to be converted to a feature collection
          valid = true;
          break;

        default:
          // for Feature types must match
          if (obj.type == type) {
            valid = true;
          } else {//SuperMap.Console.error("Cannot convert types from " +
            //obj.type + " to " + type);
          }

      }

      return valid;
    }
    /**
     * @function SuperMap.Format.GeoJSON.prototype.parseFeature
     * @description 将一个 GeoJSON 中的 feature 转化成 {@link SuperMap.Feature.Vector}> 对象。
     * @private
     * @param {GeoJSONObject} obj - 从 GeoJSON 对象中创建一个对象。
     * @returns {SuperMap.Feature.Vector} 一个要素。
     */

  }, {
    key: "parseFeature",
    value: function parseFeature(obj) {
      var feature, geometry, attributes, bbox;
      attributes = obj.properties ? obj.properties : {};
      bbox = obj.geometry && obj.geometry.bbox || obj.bbox;

      try {
        geometry = this.parseGeometry(obj.geometry);
      } catch (err) {
        // deal with bad geometries
        throw err;
      }

      feature = new Vector_Vector(geometry, attributes);

      if (bbox) {
        feature.bounds = Bounds_Bounds.fromArray(bbox);
      }

      if (obj.id) {
        feature.fid = obj.id;
      }

      return feature;
    }
    /**
     * @function SuperMap.Format.GeoJSON.prototype.parseGeometry
     * @description 将一个 GeoJSON 中的几何要素转化成 {@link SuperMap.Geometry} 对象。
     * @param {GeoJSONObject} obj - 从 GeoJSON 对象中创建一个对象。
     * @returns {SuperMap.Geometry} 一个几何要素。
     * @private
     */

  }, {
    key: "parseGeometry",
    value: function parseGeometry(obj) {
      if (obj == null) {
        return null;
      }

      var geometry;

      if (obj.type == "GeometryCollection") {
        if (!Util.isArray(obj.geometries)) {
          throw "GeometryCollection must have geometries array: " + obj;
        }

        var numGeom = obj.geometries.length;
        var components = new Array(numGeom);

        for (var i = 0; i < numGeom; ++i) {
          components[i] = this.parseGeometry.apply(this, [obj.geometries[i]]);
        }

        geometry = new Collection_Collection(components);
      } else {
        if (!Util.isArray(obj.coordinates)) {
          throw "Geometry must have coordinates array: " + obj;
        }

        if (!this.parseCoords[obj.type.toLowerCase()]) {
          throw "Unsupported geometry type: " + obj.type;
        }

        try {
          geometry = this.parseCoords[obj.type.toLowerCase()].apply(this, [obj.coordinates]);
        } catch (err) {
          // deal with bad coordinates
          throw err;
        }
      }

      return geometry;
    }
    /**
     * @function SuperMap.Format.GeoJSON.prototype.createCRSObject
     * @description 从一个要素对象中创建一个坐标参考系对象。
     * @param {SuperMap.Feature.Vector} object - 要素对象。
     * @private
     * @returns {GeoJSONObject} 一个可作为 GeoJSON 对象的 CRS 属性使用的对象。
     */

  }, {
    key: "createCRSObject",
    value: function createCRSObject(object) {
      var proj = object.layer.projection.toString();
      var crs = {};

      if (proj.match(/epsg:/i)) {
        var code = parseInt(proj.substring(proj.indexOf(":") + 1));

        if (code == 4326) {
          crs = {
            "type": "name",
            "properties": {
              "name": "urn:ogc:def:crs:OGC:1.3:CRS84"
            }
          };
        } else {
          crs = {
            "type": "name",
            "properties": {
              "name": "EPSG:" + code
            }
          };
        }
      }

      return crs;
    }
  }, {
    key: "_toiSevrerFeature",
    value: function _toiSevrerFeature(feature) {
      var attributes = feature.attributes;
      var attrNames = [];
      var attrValues = [];

      for (var attr in attributes) {
        attrNames.push(attr);
        attrValues.push(attributes[attr]);
      }

      var newFeature = {
        fieldNames: attrNames,
        fieldValues: attrValues,
        geometry: ServerGeometry_ServerGeometry.fromGeometry(feature.geometry)
      };
      newFeature.geometry.id = feature.fid;
      return newFeature;
    }
  }, {
    key: "createAttributes",
    value: function createAttributes(feature) {
      if (!feature) {
        return null;
      }

      var attr = {};
      processFieldsAttributes(feature, attr);
      var exceptKeys = ["fieldNames", "fieldValues", "geometry", "stringID", "ID"];

      for (var key in feature) {
        if (exceptKeys.indexOf(key) > -1) {
          continue;
        }

        attr[key] = feature[key];
      }

      function processFieldsAttributes(feature, attributes) {
        if (!(feature.hasOwnProperty("fieldNames") && feature.hasOwnProperty("fieldValues"))) {
          return;
        }

        var names = feature.fieldNames,
            values = feature.fieldValues;

        for (var i in names) {
          attributes[names[i]] = values[i];
        }
      }

      return attr;
    }
  }]);

  return GeoJSON;
}(JSONFormat);
SuperMap.Format.GeoJSON = GeoJSON_GeoJSON;
// CONCATENATED MODULE: ./src/common/format/WKT.js
function WKT_typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { WKT_typeof = function _typeof(obj) { return typeof obj; }; } else { WKT_typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return WKT_typeof(obj); }

function WKT_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function WKT_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function WKT_createClass(Constructor, protoProps, staticProps) { if (protoProps) WKT_defineProperties(Constructor.prototype, protoProps); if (staticProps) WKT_defineProperties(Constructor, staticProps); return Constructor; }

function WKT_possibleConstructorReturn(self, call) { if (call && (WKT_typeof(call) === "object" || typeof call === "function")) { return call; } return WKT_assertThisInitialized(self); }

function WKT_assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function WKT_getPrototypeOf(o) { WKT_getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return WKT_getPrototypeOf(o); }

function WKT_inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) WKT_setPrototypeOf(subClass, superClass); }

function WKT_setPrototypeOf(o, p) { WKT_setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return WKT_setPrototypeOf(o, p); }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/











/**
 * @class SuperMap.Format.WKT
 * @classdesc 用于读写常见文本的类。通过 {@link SuperMap.Format.WKT} 构造器来创建一个新的实例。
 * @category BaseTypes Format
 * @extends {SuperMap.Format}
 * @param {Object} options - 可选的选项对象，其属性将被设置到实例。option 具体配置项继承自 {@link SuperMap.Format}。
 */

var WKT_WKT =
/*#__PURE__*/
function (_Format) {
  WKT_inherits(WKT, _Format);

  function WKT(options) {
    var _this;

    WKT_classCallCheck(this, WKT);

    _this = WKT_possibleConstructorReturn(this, WKT_getPrototypeOf(WKT).call(this, options));
    _this.regExes = {
      'typeStr': /^\s*(\w+)\s*\(\s*(.*)\s*\)\s*$/,
      'spaces': /\s+/,
      'parenComma': /\)\s*,\s*\(/,
      'doubleParenComma': /\)\s*\)\s*,\s*\(\s*\(/,
      // can't use {2} here
      'trimParens': /^\s*\(?(.*?)\)?\s*$/
    };
    _this.CLASS_NAME = "SuperMap.Format.WKT";
    /**
    * @private
    * @description Object with properties corresponding to the geometry types.
    * Property values are functions that do the actual data extraction.
    */

    _this.extract = {
      /**
       * @description Return a space delimited string of point coordinates.
       * @param {SuperMap.Geometry.Point} point
       * @returns  {string} A string of coordinates representing the point
       */
      'point': function point(_point) {
        return _point.x + ' ' + _point.y;
      },

      /**
       * @description  Return a comma delimited string of point coordinates from a multipoint.
       * @param {SuperMap.Geometry.MultiPoint} multipoint
       * @returns  {string} A string of point coordinate strings representing
       *                  the multipoint
       */
      'multipoint': function multipoint(_multipoint) {
        var array = [];

        for (var i = 0, len = _multipoint.components.length; i < len; ++i) {
          array.push('(' + this.extract.point.apply(this, [_multipoint.components[i]]) + ')');
        }

        return array.join(',');
      },

      /**
       * @description  Return a comma delimited string of point coordinates from a line.
       * @param {SuperMap.Geometry.LineString} linestring
       * @returns  {string} A string of point coordinate strings representing
       *                  the linestring
       */
      'linestring': function linestring(_linestring) {
        var array = [];

        for (var i = 0, len = _linestring.components.length; i < len; ++i) {
          array.push(this.extract.point.apply(this, [_linestring.components[i]]));
        }

        return array.join(',');
      },

      /**
       * @description  Return a comma delimited string of linestring strings from a multilinestring.
       * @param {SuperMap.Geometry.MultiLineString} multilinestring
       * @returns  {string} A string of of linestring strings representing
       *                  the multilinestring
       */
      'multilinestring': function multilinestring(_multilinestring) {
        var array = [];

        for (var i = 0, len = _multilinestring.components.length; i < len; ++i) {
          array.push('(' + this.extract.linestring.apply(this, [_multilinestring.components[i]]) + ')');
        }

        return array.join(',');
      },

      /**
       * @description  Return a comma delimited string of linear ring arrays from a polygon.
       * @param {SuperMap.Geometry.Polygon} polygon
       * @returns  {string} An array of linear ring arrays representing the polygon
       */
      'polygon': function polygon(_polygon) {
        var array = [];

        for (var i = 0, len = _polygon.components.length; i < len; ++i) {
          array.push('(' + this.extract.linestring.apply(this, [_polygon.components[i]]) + ')');
        }

        return array.join(',');
      },

      /**
       * @description  Return an array of polygon arrays from a multipolygon.
       * @param {SuperMap.Geometry.MultiPolygon} multipolygon
       * @returns  {string} An array of polygon arrays representing
       *                  the multipolygon
       */
      'multipolygon': function multipolygon(_multipolygon) {
        var array = [];

        for (var i = 0, len = _multipolygon.components.length; i < len; ++i) {
          array.push('(' + this.extract.polygon.apply(this, [_multipolygon.components[i]]) + ')');
        }

        return array.join(',');
      },

      /**
       * @description  Return the WKT portion between 'GEOMETRYCOLLECTION(' and ')' for an <SuperMap.Geometry.Collection>
       * @param {SuperMap.Geometry.Collection} collection
       * @returns  {string} internal WKT representation of the collection
       */
      'collection': function collection(_collection) {
        var array = [];

        for (var i = 0, len = _collection.components.length; i < len; ++i) {
          array.push(this.extractGeometry.apply(this, [_collection.components[i]]));
        }

        return array.join(',');
      }
    };
    /**
     * @private
     * @description Object with properties corresponding to the geometry types.
     * Property values are functions that do the actual parsing.
     */

    _this.parse = {
      /**
       * @private
       * @description  Return point feature given a point WKT fragment.
       * @param {string} str A WKT fragment representing the point
       * @returns  {SuperMap.Feature.Vector} A point feature
       *
       */
      'point': function point(str) {
        var coords = StringExt.trim(str).split(this.regExes.spaces);
        return new Vector_Vector(new Point_Point(coords[0], coords[1]));
      },

      /**
       * @description  Return a multipoint feature given a multipoint WKT fragment.
       * @param {string} A WKT fragment representing the multipoint
       * @returns  {SuperMap.Feature.Vector} A multipoint feature
       * @private
       */
      'multipoint': function multipoint(str) {
        var point;
        var points = StringExt.trim(str).split(',');
        var components = [];

        for (var i = 0, len = points.length; i < len; ++i) {
          point = points[i].replace(this.regExes.trimParens, '$1');
          components.push(this.parse.point.apply(this, [point]).geometry);
        }

        return new Vector_Vector(new MultiPoint(components));
      },

      /**
       * @description  Return a linestring feature given a linestring WKT fragment.
       * @param {string} A WKT fragment representing the linestring
       * @returns  {SuperMap.Feature.Vector} A linestring feature
       * @private
       */
      'linestring': function linestring(str) {
        var points = StringExt.trim(str).split(',');
        var components = [];

        for (var i = 0, len = points.length; i < len; ++i) {
          components.push(this.parse.point.apply(this, [points[i]]).geometry);
        }

        return new Vector_Vector(new LineString_LineString(components));
      },

      /**
       * @description  Return a multilinestring feature given a multilinestring WKT fragment.
       * @param {string} A WKT fragment representing the multilinestring
       * @returns  {SuperMap.Feature.Vector} A multilinestring feature
       * @private
       */
      'multilinestring': function multilinestring(str) {
        var line;
        var lines = StringExt.trim(str).split(this.regExes.parenComma);
        var components = [];

        for (var i = 0, len = lines.length; i < len; ++i) {
          line = lines[i].replace(this.regExes.trimParens, '$1');
          components.push(this.parse.linestring.apply(this, [line]).geometry);
        }

        return new Vector_Vector(new MultiLineString(components));
      },

      /**
       * @description  Return a polygon feature given a polygon WKT fragment.
       * @param {string} A WKT fragment representing the polygon
       * @returns  {SuperMap.Feature.Vector} A polygon feature
       * @private
       */
      'polygon': function polygon(str) {
        var ring, linestring, linearring;
        var rings = StringExt.trim(str).split(this.regExes.parenComma);
        var components = [];

        for (var i = 0, len = rings.length; i < len; ++i) {
          ring = rings[i].replace(this.regExes.trimParens, '$1');
          linestring = this.parse.linestring.apply(this, [ring]).geometry;
          linearring = new LinearRing(linestring.components);
          components.push(linearring);
        }

        return new Vector_Vector(new Polygon(components));
      },

      /**
       * @private
       * @description  Return a multipolygon feature given a multipolygon WKT fragment.
       * @param {string} A WKT fragment representing the multipolygon
       * @returns  {SuperMap.Feature.Vector} A multipolygon feature
       *
       */
      'multipolygon': function multipolygon(str) {
        var polygon;
        var polygons = StringExt.trim(str).split(this.regExes.doubleParenComma);
        var components = [];

        for (var i = 0, len = polygons.length; i < len; ++i) {
          polygon = polygons[i].replace(this.regExes.trimParens, '$1');
          components.push(this.parse.polygon.apply(this, [polygon]).geometry);
        }

        return new Vector_Vector(new MultiPolygon(components));
      },

      /**
       * @description  Return an array of features given a geometrycollection WKT fragment.
       * @param {string} A WKT fragment representing the geometrycollection
       * @returns  {Array} An array of SuperMap.Feature.Vector
       * @private
       */
      'geometrycollection': function geometrycollection(str) {
        // separate components of the collection with |
        str = str.replace(/,\s*([A-Za-z])/g, '|$1');
        var wktArray = StringExt.trim(str).split('|');
        var components = [];

        for (var i = 0, len = wktArray.length; i < len; ++i) {
          components.push(this.read(wktArray[i]));
        }

        return components;
      }
    };
    return _this;
  }
  /**
   * @function SuperMap.Format.WKT.prototype.read
   * @description Deserialize a WKT string and return a vector feature or an
   * array of vector features.  Supports WKT for POINT, MULTIPOINT,
   * LINESTRING, MULTILINESTRING, POLYGON, MULTIPOLYGON, and
   * GEOMETRYCOLLECTION.
   * @param {string} wkt - A WKT string
   * @returns {SuperMap.Feature.Vector|Array} A feature or array of features for
   * GEOMETRYCOLLECTION WKT.
   */


  WKT_createClass(WKT, [{
    key: "read",
    value: function read(wkt) {
      var features, type, str;
      wkt = wkt.replace(/[\n\r]/g, " ");
      var matches = this.regExes.typeStr.exec(wkt);

      if (matches) {
        type = matches[1].toLowerCase();
        str = matches[2];

        if (this.parse[type]) {
          features = this.parse[type].apply(this, [str]);
        }
      }

      return features;
    }
    /**
     * @function SuperMap.Format.WKT.prototype.write
     * @description Serialize a feature or array of features into a WKT string.
     * @param {(SuperMap.Feature.Vector|Array)} features - A feature or array of features
     * @returns {string} The WKT string representation of the input geometries
     */

  }, {
    key: "write",
    value: function write(features) {
      var collection, geometry, isCollection;

      if (features.constructor === Array) {
        collection = features;
        isCollection = true;
      } else {
        collection = [features];
        isCollection = false;
      }

      var pieces = [];

      if (isCollection) {
        pieces.push('GEOMETRYCOLLECTION(');
      }

      for (var i = 0, len = collection.length; i < len; ++i) {
        if (isCollection && i > 0) {
          pieces.push(',');
        }

        geometry = collection[i].geometry;
        pieces.push(this.extractGeometry(geometry));
      }

      if (isCollection) {
        pieces.push(')');
      }

      return pieces.join('');
    }
    /**
     * @function SuperMap.Format.WKT.prototype.extractGeometry
     * @description Entry point to construct the WKT for a single Geometry object.
     * @param {SuperMap.Geometry} geometry 
     * @returns {string} A WKT string of representing the geometry
     */

  }, {
    key: "extractGeometry",
    value: function extractGeometry(geometry) {
      var type = geometry.CLASS_NAME.split('.')[2].toLowerCase();

      if (!this.extract[type]) {
        return null;
      }

      var wktType = type === 'collection' ? 'GEOMETRYCOLLECTION' : type.toUpperCase();
      var data = wktType + '(' + this.extract[type].apply(this, [geometry]) + ')';
      return data;
    }
  }]);

  return WKT;
}(Format_Format);
SuperMap.Format.WKT = WKT_WKT;
// CONCATENATED MODULE: ./src/common/format/index.js
/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/








// CONCATENATED MODULE: ./src/common/control/img/Logo.js
/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/
var LogoBase64 = "data:image/png;base64,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";
// CONCATENATED MODULE: ./src/common/control/TimeControlBase.js
function TimeControlBase_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function TimeControlBase_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function TimeControlBase_createClass(Constructor, protoProps, staticProps) { if (protoProps) TimeControlBase_defineProperties(Constructor.prototype, protoProps); if (staticProps) TimeControlBase_defineProperties(Constructor, staticProps); return Constructor; }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


/**
 * @class SuperMap.TimeControlBase
 * @classdesc 时间控制基类类。
 * @category  Control
 * @param {Object} options - 该类开放的可选属性。
 * @param {number} [options.speed=1] - 速度。不能小于 0，（每帧渲染的数据之间的间隔为1），设置越大速度越快。
 * @param {number} [options.frequency=1000] - 刷新频率（单位 ms），服务器刷新的时间间隔。
 * @param {number} [options.startTime=0] - 起始时间，必须为数字，且小于等于 endTime。如果不设置，初始化时为 0，建议设置。
 * @param {number} [options.endTime] - 结束时间，必须为数字，且大于等于 startTime。如果不设置，初始化时以当前时间进行设置，建议设置。
 * @param {boolean} [options.repeat=true] - 是否重复循环。
 * @param {boolean} [options.reverse=false] - 是否反向。
 */

var TimeControlBase_TimeControlBase =
/*#__PURE__*/
function () {
  function TimeControlBase(options) {
    TimeControlBase_classCallCheck(this, TimeControlBase);

    //设置步长，刷新频率、开始结束时间、是否循环、是否反向
    var me = this;
    options = options || {};
    /**
     * @member {number} [SuperMap.TimeControlBase.prototype.speed=1]
     * @description 步长，必须为非负数，默认为1（表示前后两次渲染的数据之间的间隔为1）
     */

    this.speed = options.speed && options.speed >= 0 ? options.speed : 1;
    /**
     * @member {number} [SuperMap.TimeControlBase.prototype.frequency=1000]
     * @description 刷新频率(单位ms)，服务器刷新的时间间隔。
     */

    this.frequency = options.speed && options.frequency >= 0 ? options.frequency : 1000;
    /**
     * @member {number} [SuperMap.TimeControlBase.prototype.startTime=0]
     * @description 记录的起始时间，必须为数字，
     *              如果不设置，初始化时为0，建议设置
     */

    this.startTime = options.startTime && options.startTime != null ? options.startTime : 0;
    /**
     * @member {number} SuperMap.TimeControlBase.prototype.endTime
     * @description 记录的结束时间，必须为数字，
     *              如果不设置，初始化时以当前时间进行设置，建议设置
     */

    this.endTime = options.endTime && options.endTime != null && options.endTime >= me.startTime ? options.endTime : +new Date();
    /**
     * @member {boolean} [SuperMap.TimeControlBase.prototype.repeat=true]
     * @description 是否重复循环。
     */

    this.repeat = options.repeat !== undefined ? options.repeat : true;
    /**
     * @member {boolean} [SuperMap.TimeControlBase.prototype.reverse=false]
     * @description 是否反向。
     */

    this.reverse = options.reverse !== undefined ? options.reverse : false;
    /**
     * @member {number} SuperMap.TimeControlBase.prototype.currentTime
     * @description 记录近期的时间，也就是当前帧运行到的时间。
     */

    this.currentTime = null;
    /**
     * @member {number} SuperMap.TimeControlBase.prototype.oldTime
     * @description 记录上一帧的时间，也就是之前运行到的时间。
     */

    this.oldTime = null;
    /**
     * @member {boolean} [SuperMap.TimeControlBase.prototype.running=false]
     * @description 记录当前是否处于运行中。
     */

    this.running = false;
    /**
     * @private
     * @member {Array.<string>} SuperMap.TimeControlBase.prototype.EVENT_TYPES
     * @description 此类支持的事件类型。
     *
     */

    this.EVENT_TYPES = ["start", "pause", "stop"];
    /**
     * @private
     * @member {SuperMap.Events} SuperMap.TimeControlBase.prototype.events
     * @description 事件
     */

    me.events = new Events_Events(this, null, this.EVENT_TYPES);
    me.speed = Number(me.speed);
    me.frequency = Number(me.frequency);
    me.startTime = Number(me.startTime);
    me.endTime = Number(me.endTime);
    me.startTime = Date.parse(new Date(me.startTime));
    me.endTime = Date.parse(new Date(me.endTime)); //初始化当前时间

    me.currentTime = me.startTime;
    this.CLASS_NAME = "SuperMap.TimeControlBase";
  }
  /**
   * @function SuperMap.TimeControlBase.prototype.updateOptions
   * @param {Object} options - 设置参数得可选参数。设置步长，刷新频率、开始结束时间、是否循环、是否反向。
   */


  TimeControlBase_createClass(TimeControlBase, [{
    key: "updateOptions",
    value: function updateOptions(options) {
      //设置步长，刷新频率、开始结束时间、是否循环、是否反向
      var me = this;
      options = options || {};

      if (options.speed && options.speed >= 0) {
        me.speed = options.speed;
        me.speed = Number(me.speed);
      }

      if (options.speed && options.frequency >= 0) {
        me.frequency = options.frequency;
        me.frequency = Number(me.frequency);
      }

      if (options.startTime && options.startTime != null) {
        me.startTime = options.startTime;
        me.startTime = Date.parse(new Date(me.startTime));
      }

      if (options.endTime && options.endTime != null && options.endTime >= me.startTime) {
        me.endTime = options.endTime;
        me.endTime = Date.parse(new Date(me.endTime));
      }

      if (options.repeat != null) {
        me.repeat = options.repeat;
      }

      if (options.reverse != null) {
        me.reverse = options.reverse;
      }
    }
    /**
     * @function SuperMap.TimeControlBase.prototype.start
     * @description 开始。
     */

  }, {
    key: "start",
    value: function start() {
      var me = this;

      if (!me.running) {
        me.running = true;
        me.tick();
        me.events.triggerEvent('start', me.currentTime);
      }
    }
    /**
     * @function SuperMap.TimeControlBase.prototype.pause
     * @description 暂停。
     */

  }, {
    key: "pause",
    value: function pause() {
      var me = this;
      me.running = false;
      me.events.triggerEvent('pause', me.currentTime);
    }
    /**
     * @function SuperMap.TimeControlBase.prototype.stop
     * @description 停止，停止后返回起始状态。
     */

  }, {
    key: "stop",
    value: function stop() {
      var me = this; //停止时 时间设置为开始时间

      me.currentTime = me.startTime; //如果正在运行，修改为初始时间即可绘制一帧

      if (me.running) {
        me.running = false;
      }

      me.events.triggerEvent('stop', me.currentTime);
    }
    /**
     * @function SuperMap.TimeControlBase.prototype.toggle
     * @description 开关切换，切换的是开始和暂停。
     */

  }, {
    key: "toggle",
    value: function toggle() {
      var me = this;

      if (me.running) {
        me.pause();
      } else {
        me.start();
      }
    }
    /**
     * @function SuperMap.TimeControlBase.prototype.setSpeed
     * @description 设置步长。
     * @param {number} [speed=1] - 步长，必须为非负数。
     * @returns {boolean} true 代表设置成功，false 设置失败（speed 小于 0 时失败）。
     */

  }, {
    key: "setSpeed",
    value: function setSpeed(speed) {
      var me = this;

      if (speed >= 0) {
        me.speed = speed;
        return true;
      }

      return false;
    }
    /**
     * @function SuperMap.TimeControlBase.prototype.getSpeed
     * @description 获取步长。
     * @returns {number} 返回当前的步长
     */

  }, {
    key: "getSpeed",
    value: function getSpeed() {
      return this.speed;
    }
    /**
     * @function SuperMap.TimeControlBase.prototype.setFrequency
     * @description 设置刷新频率。
     * @param {number} [frequency=1000] - 刷新频率，单位为 ms。
     * @returns {boolean} true 代表设置成功，false 设置失败（frequency 小于 0 时失败）。
     */

  }, {
    key: "setFrequency",
    value: function setFrequency(frequency) {
      var me = this;

      if (frequency >= 0) {
        me.frequency = frequency;
        return true;
      }

      return false;
    }
    /**
     * @function SuperMap.TimeControlBase.prototype.getFrequency
     * @description 获取刷新频率。
     * @returns {number} 返回当前的刷新频率。
     */

  }, {
    key: "getFrequency",
    value: function getFrequency() {
      return this.frequency;
    }
    /**
     * @function SuperMap.TimeControlBase.prototype.setStartTime
     * @description 设置起始时间，设置完成后如果当前时间小于起始时间，则从起始时间开始。
     * @param {number} startTime - 需要设置的起始时间。
     * @returns {boolean} true 代表设置成功，false 设置失败（startTime 大于结束时间时失败）。
     */

  }, {
    key: "setStartTime",
    value: function setStartTime(startTime) {
      var me = this;
      startTime = Date.parse(new Date(startTime)); //起始时间不得大于结束时间

      if (startTime > me.endTime) {
        return false;
      }

      me.startTime = startTime; //如果当前时间小于了起始时间，则从当前起始时间开始

      if (me.currentTime < me.startTime) {
        me.currentTime = me.startTime;
        me.tick();
      }

      return true;
    }
    /**
     * @function SuperMap.TimeControlBase.prototype.getStartTime
     * @description 获取起始时间。
     * @returns {number} 返回当前的起始时间。
     */

  }, {
    key: "getStartTime",
    value: function getStartTime() {
      return this.startTime;
    }
    /**
     * @function SuperMap.TimeControlBase.prototype.setEndTime
     * @description 设置结束时间，设置完成后如果当前时间大于结束，则从起始时间开始。
     * @param {number} endTime - 需要设置的结束时间。
     * @returns {boolean} true 代表设置成功，false 设置失败（endTime 小于开始时间时失败）。
     */

  }, {
    key: "setEndTime",
    value: function setEndTime(endTime) {
      var me = this;
      me.endTime = Date.parse(new Date(me.endTime)); //结束时间不得小于开始时间

      if (endTime < me.startTime) {
        return false;
      }

      me.endTime = endTime; //如果当前时间大于了结束时间，则从起始时间开始

      if (me.currentTime >= me.endTime) {
        me.currentTime = me.startTime;
        me.tick();
      }

      return true;
    }
    /**
     * @function SuperMap.TimeControlBase.prototype.getEndTime
     * @description 获取结束时间。
     * @returns {number} 返回当前的结束时间。
     */

  }, {
    key: "getEndTime",
    value: function getEndTime() {
      return this.endTime;
    }
    /**
     * @function SuperMap.TimeControlBase.prototype.setCurrentTime
     * @description 设置当前时间。
     * @param {number} currentTime - 需要设置的当前时间。
     * @returns {boolean} true 代表设置成功，false 设置失败。
     */

  }, {
    key: "setCurrentTime",
    value: function setCurrentTime(currentTime) {
      var me = this;
      me.currentTime = Date.parse(new Date(me.currentTime)); //结束时间不得小于开始时间

      if (currentTime >= me.startTime && currentTime <= me.endTime) {
        me.currentTime = currentTime;
        me.startTime = me.currentTime;
        me.tick();
        return true;
      }

      return false;
    }
    /**
     * @function SuperMap.TimeControlBase.prototype.getCurrentTime
     * @description 获取当前时间。
     * @returns {number} 返回当前时间。
     */

  }, {
    key: "getCurrentTime",
    value: function getCurrentTime() {
      return this.currentTime;
    }
    /**
     * @function SuperMap.TimeControlBase.prototype.setRepeat
     * @description 设置是否重复循环。
     * @param {boolean} [repeat=true] - 是否重复循环。
     */

  }, {
    key: "setRepeat",
    value: function setRepeat(repeat) {
      this.repeat = repeat;
    }
    /**
     * @function SuperMap.TimeControlBase.prototype.getRepeat
     * @description 获取是否重复循环，默认是 true。
     * @returns {boolean} 返回是否重复循环。
     */

  }, {
    key: "getRepeat",
    value: function getRepeat() {
      return this.repeat;
    }
    /**
     * @function SuperMap.TimeControlBase.prototype.setReverse
     * @description 设置是否反向。
     * @param {boolean} [reverse=false] - 是否反向。
     */

  }, {
    key: "setReverse",
    value: function setReverse(reverse) {
      this.reverse = reverse;
    }
    /**
     * @function SuperMap.TimeControlBase.prototype.getReverse
     * @description 获取是否反向，默认是false。
     * @returns {boolean} 返回是否反向。
     */

  }, {
    key: "getReverse",
    value: function getReverse() {
      return this.reverse;
    }
    /**
     * @function SuperMap.TimeControlBase.prototype.getRunning
     * @description 获取运行状态。
     * @returns {boolean} true 代表正在运行，false 发表没有运行。
     */

  }, {
    key: "getRunning",
    value: function getRunning() {
      return this.running;
    }
    /**
     * @function SuperMap.TimeControlBase.prototype.destroy
     * @description 销毁 Animator 对象，释放资源。
     */

  }, {
    key: "destroy",
    value: function destroy() {
      var me = this;
      me.speed = null;
      me.frequency = null;
      me.startTime = null;
      me.endTime = null;
      me.currentTime = null;
      me.repeat = null;
      me.running = false;
      me.reverse = null;
    }
  }, {
    key: "tick",
    value: function tick() {//TODO 每次刷新执行的操作。子类实现
    }
  }]);

  return TimeControlBase;
}();
SuperMap.TimeControlBase = TimeControlBase_TimeControlBase;
// CONCATENATED MODULE: ./src/common/control/TimeFlowControl.js
function TimeFlowControl_typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { TimeFlowControl_typeof = function _typeof(obj) { return typeof obj; }; } else { TimeFlowControl_typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return TimeFlowControl_typeof(obj); }

function TimeFlowControl_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function TimeFlowControl_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function TimeFlowControl_createClass(Constructor, protoProps, staticProps) { if (protoProps) TimeFlowControl_defineProperties(Constructor.prototype, protoProps); if (staticProps) TimeFlowControl_defineProperties(Constructor, staticProps); return Constructor; }

function TimeFlowControl_possibleConstructorReturn(self, call) { if (call && (TimeFlowControl_typeof(call) === "object" || typeof call === "function")) { return call; } return TimeFlowControl_assertThisInitialized(self); }

function TimeFlowControl_assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function TimeFlowControl_get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { TimeFlowControl_get = Reflect.get; } else { TimeFlowControl_get = function _get(target, property, receiver) { var base = TimeFlowControl_superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return TimeFlowControl_get(target, property, receiver || target); }

function TimeFlowControl_superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = TimeFlowControl_getPrototypeOf(object); if (object === null) break; } return object; }

function TimeFlowControl_getPrototypeOf(o) { TimeFlowControl_getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return TimeFlowControl_getPrototypeOf(o); }

function TimeFlowControl_inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) TimeFlowControl_setPrototypeOf(subClass, superClass); }

function TimeFlowControl_setPrototypeOf(o, p) { TimeFlowControl_setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return TimeFlowControl_setPrototypeOf(o, p); }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


/**
 * @class SuperMap.TimeFlowControl
 * @classdesc 时间管理类。
 * @category  Control
 * @description 此类只负责时间上的控制，具体执行的操作需要用户在初始化时的回调函数内部进行实现。
 * 如设置起始时间为 1000，结束时间是 2000，步长设置为 1，
 * 那么表示按照每次1年（可以通过 setSpeed 进行修改）的变化从公元 1000 年开始到公元 2000 年为止，默认每 1 秒会 1 次（通过 setFrequency 修改）
 * @extends {SuperMap.TimeControlBase}
 * @param {function} callback - 每次刷新回调函数。具体的效果需要用户在此回调函数里面实现。
 * @param {Object} options - 该类开放的可选属性。
 * @param {number} [options.speed=1] - 步长（单位 ms）。不能小于 0，（每次刷新的数据之间的间隔为 1ms）。
 * @param {number} [options.frequency=1000] - 刷新频率（单位 ms）。
 * @param {number} [options.startTime=0] - 起始时间，必须为数字，且小于等于 endTime。如果不设置，初始化时为 0，建议设置。
 * @param {number} [options.endTime] - 结束时间，必须为数字，且大于等于 startTime。如果不设置，初始化时使用 new Date() 以当前时间进行设置，建议设置。
 * @param {boolean} [options.repeat=true] - 是否重复循环。
 * @param {boolean} [options.reverse=false] - 是否反向。
 */

var TimeFlowControl =
/*#__PURE__*/
function (_TimeControlBase) {
  TimeFlowControl_inherits(TimeFlowControl, _TimeControlBase);

  function TimeFlowControl(callback, options) {
    var _this;

    TimeFlowControl_classCallCheck(this, TimeFlowControl);

    _this = TimeFlowControl_possibleConstructorReturn(this, TimeFlowControl_getPrototypeOf(TimeFlowControl).call(this, options));

    var me = TimeFlowControl_assertThisInitialized(_this);
    /**
     * @member SuperMap.TimeFlowControl.prototype.callback -{function}
     * @description 每次刷新执行的回调函数。
     */


    me.callback = callback; //先让IE下支持bind方法

    if (!Function.prototype.bind) {
      Function.prototype.bind = function (oThis) {
        if (typeof this !== "function") {
          throw new TypeError("Function.prototype.bind - what is trying to be bound is not callable");
        }

        var aArgs = Array.prototype.slice.call(arguments, 1),
            fToBind = this,
            fNOP = function fNOP() {//empty Function
        },
            fBound = function fBound() {
          return fToBind.apply(this instanceof fNOP && oThis ? this : oThis, aArgs.concat(Array.prototype.slice.call(arguments)));
        };

        fNOP.prototype = this.prototype;
        fBound.prototype = new fNOP();
        return fBound;
      };
    } //保证 this.tick 的上下文还是 TimeControl 这个对象


    me.update = me.update.bind(me);
    me.oldTime = me.currentTime;
    me.CLASS_NAME = "SuperMap.TimeFlowControl";
    return _this;
  }
  /**
   * @function SuperMap.TimeFlowControl.prototype.updateOptions
   * @override
   */


  TimeFlowControl_createClass(TimeFlowControl, [{
    key: "updateOptions",
    value: function updateOptions(options) {
      options = options || {};

      TimeFlowControl_get(TimeFlowControl_getPrototypeOf(TimeFlowControl.prototype), "updateOptions", this).call(this, options);
    }
    /**
     * @function SuperMap.TimeFlowControl.prototype.start
     * @override
     */

  }, {
    key: "start",
    value: function start() {
      var me = this;

      if (me.running) {
        return;
      }

      me.running = true;

      if (me.reverse) {
        if (me.currentTime === me.startTime) {
          me.oldTime = me.endTime;
          me.currentTime = me.oldTime;
        }
      } else {
        if (me.oldTime === me.endTime) {
          me.currentTime = me.startTime;
          me.oldTime = me.currentTime;
        }
      }

      me.tick();
    }
    /**
     * @function SuperMap.TimeFlowControl.prototype.stop
     * @override
     */

  }, {
    key: "stop",
    value: function stop() {
      TimeFlowControl_get(TimeFlowControl_getPrototypeOf(TimeFlowControl.prototype), "stop", this).call(this);

      var me = this;
      me.oldTime = me.currentTime;

      if (me.running) {
        me.running = false;
      } //清除定时tick


      me.intervalId && window.clearTimeout(me.intervalId);
    }
    /**
     * @function SuperMap.TimeFlowControl.prototype.destroy
     * @override
     */

  }, {
    key: "destroy",
    value: function destroy() {
      TimeFlowControl_get(TimeFlowControl_getPrototypeOf(TimeFlowControl.prototype), "destroy", this).call(this);

      var me = this;
      me.oldTime = null;
      me.callback = null;
    }
    /**
     * @function SuperMap.TimeFlowControl.prototype.tick
     * @description 定时刷新。
     */

  }, {
    key: "tick",
    value: function tick() {
      var me = this;
      me.intervalId && window.clearInterval(me.intervalId);
      me.intervalId = null;
      me.update();
      me.intervalId = window.setInterval(me.update, me.frequency);
    }
    /**
     * @function SuperMap.TimeFlowControl.prototype.update
     * @override
     */

  }, {
    key: "update",
    value: function update() {
      var me = this; //判定是否还需要继续

      if (!me.running) {
        return;
      } //调用回调函数


      me.callback && me.callback(me.currentTime); //destroy之后callback就为空，所以需要判定一下

      if (!me.reverse) {
        //如果相等，则代表上一帧已经运行到了最后，下一帧运行初始化的状态
        if (me.currentTime === me.endTime) {
          //不循环时
          if (!me.repeat) {
            me.running = false;
            me.stop();
            return null;
          }

          me.stop();
          me.currentTime = me.startTime;
          me.oldTime = me.currentTime;
          me.start();
        } else {
          //否则时间递增
          me.oldTime = me.currentTime;
          me.currentTime += me.speed;
        }

        if (me.currentTime >= me.endTime) {
          me.currentTime = me.endTime;
        }
      } else {
        //如果相等，则代表上一帧已经运行到了最前，下一帧运行结束的状态
        if (me.currentTime === me.startTime) {
          //不循环时
          if (!me.repeat) {
            me.running = false;
            return null;
          }

          me.oldTime = me.endTime;
          me.currentTime = me.oldTime;
        } else {
          //否则时间递减
          me.currentTime = me.oldTime;
          me.oldTime -= me.speed;
        }

        if (me.oldTime <= me.startTime) {
          me.oldTime = me.startTime;
        }
      }
    }
  }]);

  return TimeFlowControl;
}(TimeControlBase_TimeControlBase);
SuperMap.TimeFlowControl = TimeFlowControl;
// CONCATENATED MODULE: ./src/common/control/index.js
/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/






// EXTERNAL MODULE: ./node_modules/promise-polyfill/dist/polyfill.js
var polyfill = __webpack_require__(15);

// EXTERNAL MODULE: ./node_modules/fetch-ie8/fetch.js
var fetch = __webpack_require__(19);

// EXTERNAL MODULE: ./node_modules/fetch-jsonp/build/fetch-jsonp.js
var fetch_jsonp = __webpack_require__(4);
var fetch_jsonp_default = /*#__PURE__*/__webpack_require__.n(fetch_jsonp);

// CONCATENATED MODULE: ./src/common/util/FetchRequest.js
function FetchRequest_typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { FetchRequest_typeof = function _typeof(obj) { return typeof obj; }; } else { FetchRequest_typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return FetchRequest_typeof(obj); }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/





var FetchRequest_fetch = window.fetch;
/**
 * @function SuperMap.setCORS
 * @description 设置是否允许跨域请求，全局配置，优先级低于 service 下的 crossOring 参数。
 * @param {boolean} cors - 是否允许跨域请求。
 */

var setCORS = SuperMap.setCORS = function (cors) {
  SuperMap.CORS = cors;
};
/**
 * @function SuperMap.isCORS
 * @description 是是否允许跨域请求。
 * @returns {boolean} 是否允许跨域请求。
 */

var isCORS = SuperMap.isCORS = function () {
  if (SuperMap.CORS != undefined) {
    return SuperMap.CORS;
  }

  return window.XMLHttpRequest && 'withCredentials' in new window.XMLHttpRequest();
};
/**
 * @function SuperMap.setRequestTimeout
 * @description 设置请求超时时间。
 * @param {number} [timeout=45] - 请求超时时间，单位秒。
 */

var setRequestTimeout = SuperMap.setRequestTimeout = function (timeout) {
  return SuperMap.RequestTimeout = timeout;
};
/**
 * @function SuperMap.getRequestTimeout
 * @description 获取请求超时时间。
 * @returns {number} 请求超时时间。
 */

var getRequestTimeout = SuperMap.getRequestTimeout = function () {
  return SuperMap.RequestTimeout || 45000;
};
var FetchRequest = SuperMap.FetchRequest = {
  commit: function commit(method, url, params, options) {
    method = method ? method.toUpperCase() : method;

    switch (method) {
      case 'GET':
        return this.get(url, params, options);

      case 'POST':
        return this.post(url, params, options);

      case 'PUT':
        return this.put(url, params, options);

      case 'DELETE':
        return this["delete"](url, params, options);

      default:
        return this.get(url, params, options);
    }
  },
  supportDirectRequest: function supportDirectRequest(url, options) {
    if (Util.isInTheSameDomain(url)) {
      return true;
    }

    if (options.crossOrigin != undefined) {
      return options.crossOrigin;
    } else {
      return isCORS() || options.proxy;
    }
  },
  get: function get(url, params, options) {
    options = options || {};
    var type = 'GET';
    url = Util.urlAppend(url, this._getParameterString(params || {}));
    url = this._processUrl(url, options);

    if (!this.supportDirectRequest(url, options)) {
      url = url.replace('.json', '.jsonp');
      var config = {
        url: url,
        data: params
      };
      return SuperMap.Util.RequestJSONPPromise.GET(config);
    }

    if (!this.urlIsLong(url)) {
      return this._fetch(url, params, options, type);
    } else {
      return this._postSimulatie(type, url.substring(0, url.indexOf('?') - 1), params, options);
    }
  },
  "delete": function _delete(url, params, options) {
    options = options || {};
    var type = 'DELETE';
    url = Util.urlAppend(url, this._getParameterString(params || {}));
    url = this._processUrl(url, options);

    if (!this.supportDirectRequest(url, options)) {
      url = url.replace('.json', '.jsonp');
      var config = {
        url: url += "&_method=DELETE",
        data: params
      };
      return SuperMap.Util.RequestJSONPPromise.DELETE(config);
    }

    if (this.urlIsLong(url)) {
      return this._postSimulatie(type, url.substring(0, url.indexOf('?') - 1), params, options);
    }

    return this._fetch(url, params, options, type);
  },
  post: function post(url, params, options) {
    options = options || {};

    if (!this.supportDirectRequest(url, options)) {
      url = url.replace('.json', '.jsonp');
      var config = {
        url: url += "&_method=POST",
        data: params
      };
      return SuperMap.Util.RequestJSONPPromise.POST(config);
    }

    return this._fetch(this._processUrl(url, options), params, options, 'POST');
  },
  put: function put(url, params, options) {
    options = options || {};
    url = this._processUrl(url, options);

    if (!this.supportDirectRequest(url, options)) {
      url = url.replace('.json', '.jsonp');
      var config = {
        url: url += "&_method=PUT",
        data: params
      };
      return SuperMap.Util.RequestJSONPPromise.PUT(config);
    }

    return this._fetch(url, params, options, 'PUT');
  },
  urlIsLong: function urlIsLong(url) {
    //当前url的字节长度。
    var totalLength = 0,
        charCode = null;

    for (var i = 0, len = url.length; i < len; i++) {
      //转化为Unicode编码
      charCode = url.charCodeAt(i);

      if (charCode < 0x007f) {
        totalLength++;
      } else if (0x0080 <= charCode && charCode <= 0x07ff) {
        totalLength += 2;
      } else if (0x0800 <= charCode && charCode <= 0xffff) {
        totalLength += 3;
      }
    }

    return totalLength < 2000 ? false : true;
  },
  _postSimulatie: function _postSimulatie(type, url, params, options) {
    var separator = url.indexOf("?") > -1 ? "&" : "?";
    url += separator + '_method=' + type;

    if (typeof params !== 'string') {
      params = JSON.stringify(params);
    }

    return this.post(url, params, options);
  },
  _processUrl: function _processUrl(url, options) {
    if (this._isMVTRequest(url)) {
      return url;
    }

    if (url.indexOf('.json') === -1 && !options.withoutFormatSuffix) {
      if (url.indexOf("?") < 0) {
        url += '.json';
      } else {
        var urlArrays = url.split("?");

        if (urlArrays.length === 2) {
          url = urlArrays[0] + ".json?" + urlArrays[1];
        }
      }
    }

    if (options && options.proxy) {
      if (typeof options.proxy === "function") {
        url = options.proxy(url);
      } else {
        url = decodeURIComponent(url);
        url = options.proxy + encodeURIComponent(url);
      }
    }

    return url;
  },
  _fetch: function _fetch(url, params, options, type) {
    options = options || {};
    options.headers = options.headers || {};

    if (!options.headers['Content-Type']) {
      options.headers['Content-Type'] = 'application/x-www-form-urlencoded;charset=UTF-8';
    }

    if (options.timeout) {
      return this._timeout(options.timeout, FetchRequest_fetch(url, {
        method: type,
        headers: options.headers,
        body: type === 'PUT' || type === 'POST' ? params : undefined,
        credentials: options.withCredentials ? 'include' : 'omit',
        mode: 'cors',
        timeout: getRequestTimeout()
      }).then(function (response) {
        return response;
      }));
    }

    return FetchRequest_fetch(url, {
      method: type,
      body: type === 'PUT' || type === 'POST' ? params : undefined,
      headers: options.headers,
      credentials: options.withCredentials ? 'include' : 'omit',
      mode: 'cors',
      timeout: getRequestTimeout()
    }).then(function (response) {
      return response;
    });
  },
  _fetchJsonp: function _fetchJsonp(url, options) {
    options = options || {};
    return fetch_jsonp_default()(url, {
      method: 'GET',
      timeout: options.timeout
    }).then(function (response) {
      return response;
    });
  },
  _timeout: function _timeout(seconds, promise) {
    return new Promise(function (resolve, reject) {
      setTimeout(function () {
        reject(new Error("timeout"));
      }, seconds);
      promise.then(resolve, reject);
    });
  },
  _getParameterString: function _getParameterString(params) {
    var paramsArray = [];

    for (var key in params) {
      var value = params[key];

      if (value != null && typeof value !== 'function') {
        var encodedValue;

        if (FetchRequest_typeof(value) === 'object' && value.constructor === Array) {
          var encodedItemArray = [];
          var item;

          for (var itemIndex = 0, len = value.length; itemIndex < len; itemIndex++) {
            item = value[itemIndex];
            encodedItemArray.push(encodeURIComponent(item === null || item === undefined ? "" : item));
          }

          encodedValue = '[' + encodedItemArray.join(",") + ']';
        } else {
          encodedValue = encodeURIComponent(value);
        }

        paramsArray.push(encodeURIComponent(key) + "=" + encodedValue);
      }
    }

    return paramsArray.join("&");
  },
  _isMVTRequest: function _isMVTRequest(url) {
    return url.indexOf('.mvt') > -1 || url.indexOf('.pbf') > -1;
  }
};
SuperMap.Util.RequestJSONPPromise = {
  limitLength: 1500,
  queryKeys: [],
  queryValues: [],
  supermap_callbacks: {},
  addQueryStrings: function addQueryStrings(values) {
    var me = this;

    for (var key in values) {
      me.queryKeys.push(key);

      if (typeof values[key] !== "string") {
        values[key] = SuperMap.Util.toJSON(values[key]);
      }

      var tempValue = encodeURIComponent(values[key]);
      me.queryValues.push(tempValue);
    }
  },
  issue: function issue(config) {
    var me = this,
        uid = me.getUid(),
        url = config.url,
        splitQuestUrl = [];
    var p = new Promise(function (resolve) {
      me.supermap_callbacks[uid] = function (response) {
        delete me.supermap_callbacks[uid];
        resolve(response);
      };
    }); // me.addQueryStrings({
    //     callback: "SuperMap.Util.RequestJSONPPromise.supermap_callbacks[" + uid + "]"
    // });

    var sectionURL = url,
        keysCount = 0; //此次sectionURL中有多少个key

    var length = me.queryKeys ? me.queryKeys.length : 0;

    for (var i = 0; i < length; i++) {
      if (sectionURL.length + me.queryKeys[i].length + 2 >= me.limitLength) {
        //+2 for ("&"or"?")and"="
        if (keysCount == 0) {
          return false;
        }

        splitQuestUrl.push(sectionURL);
        sectionURL = url;
        keysCount = 0;
        i--;
      } else {
        if (sectionURL.length + me.queryKeys[i].length + 2 + me.queryValues[i].length > me.limitLength) {
          var leftValue = me.queryValues[i];

          while (leftValue.length > 0) {
            var leftLength = me.limitLength - sectionURL.length - me.queryKeys[i].length - 2; //+2 for ("&"or"?")and"="

            if (sectionURL.indexOf("?") > -1) {
              sectionURL += "&";
            } else {
              sectionURL += "?";
            }

            var tempLeftValue = leftValue.substring(0, leftLength); //避免 截断sectionURL时，将类似于%22这样的符号截成两半，从而导致服务端组装sectionURL时发生错误

            if (tempLeftValue.substring(leftLength - 1, leftLength) === "%") {
              leftLength -= 1;
              tempLeftValue = leftValue.substring(0, leftLength);
            } else if (tempLeftValue.substring(leftLength - 2, leftLength - 1) === "%") {
              leftLength -= 2;
              tempLeftValue = leftValue.substring(0, leftLength);
            }

            sectionURL += me.queryKeys[i] + "=" + tempLeftValue;
            leftValue = leftValue.substring(leftLength);

            if (tempLeftValue.length > 0) {
              splitQuestUrl.push(sectionURL);
              sectionURL = url;
              keysCount = 0;
            }
          }
        } else {
          keysCount++;

          if (sectionURL.indexOf("?") > -1) {
            sectionURL += "&";
          } else {
            sectionURL += "?";
          }

          sectionURL += me.queryKeys[i] + "=" + me.queryValues[i];
        }
      }
    }

    splitQuestUrl.push(sectionURL);
    me.send(splitQuestUrl, "SuperMap.Util.RequestJSONPPromise.supermap_callbacks[" + uid + "]", config && config.proxy);
    return p;
  },
  getUid: function getUid() {
    var uid = new Date().getTime(),
        random = Math.floor(Math.random() * 1e17);
    return uid * 1000 + random;
  },
  send: function send(splitQuestUrl, callback, proxy) {
    var len = splitQuestUrl.length;

    if (len > 0) {
      var jsonpUserID = new Date().getTime();

      for (var i = 0; i < len; i++) {
        var url = splitQuestUrl[i];

        if (url.indexOf("?") > -1) {
          url += "&";
        } else {
          url += "?";
        }

        url += "sectionCount=" + len;
        url += "&sectionIndex=" + i;
        url += "&jsonpUserID=" + jsonpUserID;

        if (proxy) {
          url = decodeURIComponent(url);
          url = proxy + encodeURIComponent(url);
        }

        fetch_jsonp_default()(url, {
          jsonpCallbackFunction: callback,
          timeout: 30000
        });
      }
    }
  },
  GET: function GET(config) {
    var me = this;
    me.queryKeys.length = 0;
    me.queryValues.length = 0;
    me.addQueryStrings(config.params);
    return me.issue(config);
  },
  POST: function POST(config) {
    var me = this;
    me.queryKeys.length = 0;
    me.queryValues.length = 0;
    me.addQueryStrings({
      requestEntity: config.data
    });
    return me.issue(config);
  },
  PUT: function PUT(config) {
    var me = this;
    me.queryKeys.length = 0;
    me.queryValues.length = 0;
    me.addQueryStrings({
      requestEntity: config.data
    });
    return me.issue(config);
  },
  DELETE: function DELETE(config) {
    var me = this;
    me.queryKeys.length = 0;
    me.queryValues.length = 0;
    me.addQueryStrings({
      requestEntity: config.data
    });
    return me.issue(config);
  }
};
// CONCATENATED MODULE: ./src/common/security/SecurityManager.js
function SecurityManager_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function SecurityManager_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function SecurityManager_createClass(Constructor, protoProps, staticProps) { if (protoProps) SecurityManager_defineProperties(Constructor.prototype, protoProps); if (staticProps) SecurityManager_defineProperties(Constructor, staticProps); return Constructor; }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/



/**
 * @name SecurityManager
 * @memberOf SuperMap
 * @namespace
 * @category Security
 * @description 安全管理中心，提供 iServer,iPortal,Online 统一权限认证管理。
 *  > 使用说明：
 *  > 创建任何一个服务之前调用 {@link SuperMap.SecurityManager.registerToken}或
 *  > {@link SuperMap.SecurityManager.registerKey}注册凭据。
 *  > 发送请求时根据 url 或者服务 id 获取相应的 key 或者 token 并自动添加到服务地址中。
 */

var SecurityManager_SecurityManager =
/*#__PURE__*/
function () {
  function SecurityManager() {
    SecurityManager_classCallCheck(this, SecurityManager);
  }

  SecurityManager_createClass(SecurityManager, null, [{
    key: "generateToken",

    /**
     * @description 从服务器获取一个token,在此之前要注册服务器信息。
     * @function SuperMap.SecurityManager.generateToken
     * @param {string} url - 服务器域名+端口，如：http://localhost:8092。
     * @param {SuperMap.TokenServiceParameter} tokenParam - token 申请参数。
     * @returns {Promise} 返回包含 token 信息的 Promise 对象。
     */
    value: function generateToken(url, tokenParam) {
      var serverInfo = this.servers[url];

      if (!serverInfo) {
        return;
      }

      return FetchRequest.post(serverInfo.tokenServiceUrl, JSON.stringify(tokenParam.toJSON())).then(function (response) {
        return response.text();
      });
    }
    /**
     * @description 注册安全服务器相关信息。
     * @function SuperMap.SecurityManager.registerServers
     * @param {SuperMap.ServerInfo} serverInfos - 服务器信息。
     */

  }, {
    key: "registerServers",
    value: function registerServers(serverInfos) {
      this.servers = this.servers || {};

      if (!Util.isArray(serverInfos)) {
        serverInfos = [serverInfos];
      }

      for (var i = 0; i < serverInfos.length; i++) {
        var serverInfo = serverInfos[i];
        this.servers[serverInfo.server] = serverInfo;
      }
    }
    /**
     * @description 服务请求都会自动带上这个 token。
     * @function SuperMap.SecurityManager.registerToken
     * @param {string} url -服务器域名+端口：如http://localhost:8090。
     * @param {string} token - token
     */

  }, {
    key: "registerToken",
    value: function registerToken(url, token) {
      this.tokens = this.tokens || {};

      if (!url || !token) {
        return;
      }

      var domain = this._getTokenStorageKey(url);

      this.tokens[domain] = token;
    }
    /**
     * @description 注册 key,ids 为数组(存在一个 key 对应多个服务)。
     * @function SuperMap.SecurityManager.registerKey
     * @param {Array} ids - 可以是服务 id 数组或者 url 地址数组或者 webAPI 类型数组。
     * @param {string} key - key
     */

  }, {
    key: "registerKey",
    value: function registerKey(ids, key) {
      this.keys = this.keys || {};

      if (!ids || ids.length < 1 || !key) {
        return;
      }

      ids = Util.isArray(ids) ? ids : [ids];

      for (var i = 0; i < ids.length; i++) {
        var id = this._getUrlRestString(ids[0]) || ids[0];
        this.keys[id] = key;
      }
    }
    /**
     * @description 获取服务器信息。
     * @function SuperMap.SecurityManager.getServerInfo
     * @param {string} url - 服务器域名+端口，如：http://localhost:8092。
     * @returns {SuperMap.ServerInfo} 服务器信息。
     */

  }, {
    key: "getServerInfo",
    value: function getServerInfo(url) {
      this.servers = this.servers || {};
      return this.servers[url];
    }
    /**
     * @description 根据 Url 获取token。
     * @function SuperMap.SecurityManager.getToken
     * @param {string} url - 服务器域名+端口，如：http://localhost:8092。
     * @returns {string} token
     */

  }, {
    key: "getToken",
    value: function getToken(url) {
      if (!url) {
        return;
      }

      this.tokens = this.tokens || {};

      var domain = this._getTokenStorageKey(url);

      return this.tokens[domain];
    }
    /**
     * @description 根据 Url 获取 key。
     * @function SuperMap.SecurityManager.getKey
     * @param {string} id - id
     * @returns {string} key
     */

  }, {
    key: "getKey",
    value: function getKey(id) {
      this.keys = this.keys || {};
      var key = this._getUrlRestString(id) || id;
      return this.keys[key];
    }
    /**
     * @description iServer 登录验证。
     * @function SuperMap.SecurityManager.loginiServer
     * @param {string} url - iServer 首页地址，如：http://localhost:8090/iserver。
     * @param {string} username - 用户名。
     * @param {string} password - 密码。
     * @param {boolean} [rememberme=false] - 是否记住。
     * @returns {Promise} 返回包含 iServer 登录请求结果的 Promise 对象。
     */

  }, {
    key: "loginiServer",
    value: function loginiServer(url, username, password, rememberme) {
      var end = url.substr(url.length - 1, 1);
      url += end === "/" ? "services/security/login.json" : "/services/security/login.json";
      var loginInfo = {
        username: username && username.toString(),
        password: password && password.toString(),
        rememberme: rememberme
      };
      loginInfo = JSON.stringify(loginInfo);
      var requestOptions = {
        headers: {
          'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'
        }
      };
      return FetchRequest.post(url, loginInfo, requestOptions).then(function (response) {
        return response.json();
      });
    }
    /**
     * @description iServer登出。
     * @function SuperMap.SecurityManager.logoutiServer
     * @param {string} url - iServer 首页地址,如：http://localhost:8090/iserver。
     * @returns {Promise} 是否登出成功。
     */

  }, {
    key: "logoutiServer",
    value: function logoutiServer(url) {
      var end = url.substr(url.length - 1, 1);
      url += end === "/" ? "services/security/logout" : "/services/security/logout";
      var requestOptions = {
        headers: {
          'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'
        },
        withoutFormatSuffix: true
      };
      return FetchRequest.get(url, "", requestOptions).then(function () {
        return true;
      })["catch"](function () {
        return false;
      });
    }
    /**
     * @description Online 登录验证。
     * @function SuperMap.SecurityManager.loginOnline
     * @param {string} callbackLocation - 跳转位置。
     * @param {boolean} [newTab=true] - 是否新窗口打开。
     */

  }, {
    key: "loginOnline",
    value: function loginOnline(callbackLocation, newTab) {
      var loginUrl = SecurityManager.SSO + "/login?service=" + callbackLocation;

      this._open(loginUrl, newTab);
    }
    /**
     * @description iPortal登录验证。
     * @function SuperMap.SecurityManager.loginiPortal
     * @param {string} url - iportal 首页地址,如：http://localhost:8092/iportal.
     * @param {string} username - 用户名。
     * @param {string} password - 密码。
     * @returns {Promise} 返回包含 iPortal 登录请求结果的 Promise 对象。
     */

  }, {
    key: "loginiPortal",
    value: function loginiPortal(url, username, password) {
      var end = url.substr(url.length - 1, 1);
      url += end === "/" ? "web/login.json" : "/web/login.json";
      var loginInfo = {
        username: username && username.toString(),
        password: password && password.toString()
      };
      loginInfo = JSON.stringify(loginInfo);
      var requestOptions = {
        headers: {
          'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'
        },
        withCredentials: true
      };
      return FetchRequest.post(url, loginInfo, requestOptions).then(function (response) {
        return response.json();
      });
    }
    /**
     * @description iPortal 登出。
     * @function SuperMap.SecurityManager.logoutiPortal
     * @param {string} url - iportal 首页地址,如：http://localhost:8092/iportal.
     * @returns {Promise} 如果登出成功，返回 true;否则返回 false。
     */

  }, {
    key: "logoutiPortal",
    value: function logoutiPortal(url) {
      var end = url.substr(url.length - 1, 1);
      url += end === "/" ? "services/security/logout" : "/services/security/logout";
      var requestOptions = {
        headers: {
          'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'
        },
        withCredentials: true,
        withoutFormatSuffix: true
      };
      return FetchRequest.get(url, "", requestOptions).then(function () {
        return true;
      })["catch"](function () {
        return false;
      });
    }
    /**
     * @description iManager 登录验证。
     * @function SuperMap.SecurityManager.loginManager
     * @param {string} url - iManager 地址。地址参数为 iManager 首页地址，如： http://localhost:8390/imanager。
     * @param {Object} [loginInfoParams] - iManager 登录参数。
     * @param {string} loginInfoParams.userName - 用户名。
     * @param {string} loginInfoParams.password - 密码。
     * @param {Object} options
     * @param {boolean} [options.isNewTab=true] - 不同域时是否在新窗口打开登录页面。
     * @returns {Promise} 返回包含 iManager 登录请求结果的 Promise 对象。
     */

  }, {
    key: "loginManager",
    value: function loginManager(url, loginInfoParams, options) {
      if (!Util.isInTheSameDomain(url)) {
        var isNewTab = options ? options.isNewTab : true;

        this._open(url, isNewTab);

        return;
      }

      var end = url.substr(url.length - 1, 1);
      var requestUrl = end === "/" ? url + "icloud/security/tokens.json" : url + "/icloud/security/tokens.json";
      var params = loginInfoParams || {};
      var loginInfo = {
        username: params.userName && params.userName.toString(),
        password: params.password && params.password.toString()
      };
      loginInfo = JSON.stringify(loginInfo);
      var requestOptions = {
        headers: {
          'Accept': '*/*',
          'Content-Type': 'application/json'
        }
      };
      var me = this;
      return FetchRequest.post(requestUrl, loginInfo, requestOptions).then(function (response) {
        response.text().then(function (result) {
          me.imanagerToken = result;
          return result;
        });
      });
    }
    /**
     * @description 清空全部验证信息。
     * @function SuperMap.SecurityManager.destroyAllCredentials
     */

  }, {
    key: "destroyAllCredentials",
    value: function destroyAllCredentials() {
      this.keys = null;
      this.tokens = null;
      this.servers = null;
    }
    /**
     * @description 清空令牌信息。
     * @function SuperMap.SecurityManager.destroyToken
     * @param {string} url - iportal 首页地址,如：http://localhost:8092/iportal.
     */

  }, {
    key: "destroyToken",
    value: function destroyToken(url) {
      if (!url) {
        return;
      }

      var domain = this._getTokenStorageKey(url);

      this.tokens = this.tokens || {};

      if (this.tokens[domain]) {
        delete this.tokens[domain];
      }
    }
    /**
     * @description 清空服务授权码。
     * @function SuperMap.SecurityManager.destroyKey
     * @param {string} url - iServer 首页地址,如：http://localhost:8090/iserver。
     */

  }, {
    key: "destroyKey",
    value: function destroyKey(url) {
      if (!url) {
        return;
      }

      this.keys = this.keys || {};
      var key = this._getUrlRestString(url) || url;

      if (this.keys[key]) {
        delete this.keys[key];
      }
    }
  }, {
    key: "_open",
    value: function _open(url, newTab) {
      newTab = newTab != null ? newTab : true;
      var offsetX = window.screen.availWidth / 2 - this.INNER_WINDOW_WIDTH / 2;
      var offsetY = window.screen.availHeight / 2 - this.INNER_WINDOW_HEIGHT / 2;
      var options = "height=" + this.INNER_WINDOW_HEIGHT + ", width=" + this.INNER_WINDOW_WIDTH + ",top=" + offsetY + ", left=" + offsetX + ",toolbar=no, menubar=no, scrollbars=no, resizable=no, location=no, status=no";

      if (newTab) {
        window.open(url, 'login');
      } else {
        window.open(url, 'login', options);
      }
    }
  }, {
    key: "_getTokenStorageKey",
    value: function _getTokenStorageKey(url) {
      var patten = /(.*?):\/\/([^\/]+)/i;
      var result = url.match(patten);

      if (!result) {
        return url;
      }

      return result[0];
    }
  }, {
    key: "_getUrlRestString",
    value: function _getUrlRestString(url) {
      if (!url) {
        return url;
      } // var patten = /http:\/\/(.*\/rest)/i;


      var patten = /(http|https):\/\/(.*\/rest)/i;
      var result = url.match(patten);

      if (!result) {
        return url;
      }

      return result[0];
    }
  }]);

  return SecurityManager;
}();
SecurityManager_SecurityManager.INNER_WINDOW_WIDTH = 600;
SecurityManager_SecurityManager.INNER_WINDOW_HEIGHT = 600;
SecurityManager_SecurityManager.SSO = "https://sso.supermap.com";
SecurityManager_SecurityManager.ONLINE = "https://www.supermapol.com";
SuperMap.SecurityManager = SecurityManager_SecurityManager;
// CONCATENATED MODULE: ./src/common/iManager/iManagerServiceBase.js
function iManagerServiceBase_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function iManagerServiceBase_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function iManagerServiceBase_createClass(Constructor, protoProps, staticProps) { if (protoProps) iManagerServiceBase_defineProperties(Constructor.prototype, protoProps); if (staticProps) iManagerServiceBase_defineProperties(Constructor, staticProps); return Constructor; }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/



/**
 * @class SuperMap.iManagerServiceBase
 * @classdesc iManager 服务基类（有权限限制的类需要实现此类）。
 * @category iManager
 * @param {string} url - iManager 首页地址，如：http://localhost:8390/imanager。
 * @param {Object} options - 服务参数。
 * @param {boolean} [options.crossOrigin] - 是否允许跨域请求。
 * @param {Object} [options.headers] - 请求头。
 */

var iManagerServiceBase_IManagerServiceBase =
/*#__PURE__*/
function () {
  function IManagerServiceBase(url, options) {
    iManagerServiceBase_classCallCheck(this, IManagerServiceBase);

    if (url) {
      var end = url.substr(url.length - 1, 1);
      this.serviceUrl = end === "/" ? url.substr(0, url.length - 2) : url;
    }

    this.options = options || {};
    this.CLASS_NAME = "SuperMap.iManagerServiceBase";
  }
  /**
   * @function SuperMap.iManagerServiceBase.prototype.request
   * @description 子类统一通过该方法发送请求。
   * @param {string} url - 请求 URL。
   * @param {string} [method='GET'] - 请求类型。
   * @param {Object} [requestOptions] - 请求选项。
   * @param {Object} param - 请求参数。
   * @description 发送请求。
   * @returns {Promise} Promise 对象。
   */


  iManagerServiceBase_createClass(IManagerServiceBase, [{
    key: "request",
    value: function request(method, url, param, requestOptions) {
      requestOptions = requestOptions || {
        headers: {
          'Accept': '*/*',
          'Content-Type': 'application/json'
        }
      };

      if (!requestOptions.hasOwnProperty("withCredentials")) {
        requestOptions['withCredentials'] = true;
      }

      requestOptions['crossOrigin'] = this.options.crossOrigin;
      requestOptions['headers'] = this.options.headers;
      var token = SecurityManager_SecurityManager.imanagerToken;

      if (token) {
        if (!requestOptions.headers) {
          requestOptions.headers = [];
        }

        requestOptions.headers['X-Auth-Token'] = token;
      }

      if (param) {
        param = JSON.stringify(param);
      }

      return FetchRequest.commit(method, url, param, requestOptions).then(function (response) {
        return response.json();
      });
    }
  }]);

  return IManagerServiceBase;
}();
SuperMap.iManagerServiceBase = iManagerServiceBase_IManagerServiceBase;
// CONCATENATED MODULE: ./src/common/iManager/iManagerCreateNodeParam.js
function iManagerCreateNodeParam_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


/**
 * @class SuperMap.iManagerCreateNodeParam
 * @classdesc iManager 创建节点参数。
 * @category iManager
 * @param {Object} [params] - iManager 创建节点参数。
 *
 */

var iManagerCreateNodeParam_IManagerCreateNodeParam = function IManagerCreateNodeParam(params) {
  iManagerCreateNodeParam_classCallCheck(this, IManagerCreateNodeParam);

  params = params || {};
  this.nodeSpec = 'SMALL'; //取值范围: ['SMALL','MEDIUM','LARGE'] 以及自定义的环境规格名称

  this.nodeCount = 1; //要创建vm的个数

  this.nodeName = ''; //vm名称

  this.password = ''; //vm的密码,空表示随机分配

  this.description = ''; //描述信息

  this.physicalMachineName = ''; //vm所属的物理机名称.

  this.ips = []; //vm的ip,空数组表示随机分配

  this.userName = ''; //vm所属用户

  Util.extend(this, params);
};
SuperMap.iManagerCreateNodeParam = iManagerCreateNodeParam_IManagerCreateNodeParam;
// CONCATENATED MODULE: ./src/common/iManager/iManager.js
function iManager_typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { iManager_typeof = function _typeof(obj) { return typeof obj; }; } else { iManager_typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return iManager_typeof(obj); }

function iManager_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function iManager_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function iManager_createClass(Constructor, protoProps, staticProps) { if (protoProps) iManager_defineProperties(Constructor.prototype, protoProps); if (staticProps) iManager_defineProperties(Constructor, staticProps); return Constructor; }

function iManager_possibleConstructorReturn(self, call) { if (call && (iManager_typeof(call) === "object" || typeof call === "function")) { return call; } return iManager_assertThisInitialized(self); }

function iManager_assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function iManager_getPrototypeOf(o) { iManager_getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return iManager_getPrototypeOf(o); }

function iManager_inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) iManager_setPrototypeOf(subClass, superClass); }

function iManager_setPrototypeOf(o, p) { iManager_setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return iManager_setPrototypeOf(o, p); }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/



/**
 * @class SuperMap.iManager
 * @classdesc iManager 服务类。
 * @category iManager
 * @param {string} serviceUrl - iManager 首页地址。
 *
 */

var iManager_IManager =
/*#__PURE__*/
function (_IManagerServiceBase) {
  iManager_inherits(IManager, _IManagerServiceBase);

  function IManager(iManagerUrl) {
    iManager_classCallCheck(this, IManager);

    return iManager_possibleConstructorReturn(this, iManager_getPrototypeOf(IManager).call(this, iManagerUrl));
  }
  /**
   * @function SuperMap.iManager.prototype.load
   * @description 获取所有服务接口，验证是否已登录授权。
   * @returns {Promise} Promise 对象。
   */


  iManager_createClass(IManager, [{
    key: "load",
    value: function load() {
      return this.request("GET", this.serviceUrl + '/web/api/service.json');
    }
    /**
     * @function SuperMap.iManager.prototype.createIServer
     * @param {SuperMap.iManagerCreateNodeParam} createParam - 创建参数。
     * @description 创建 iServer。
     * @returns {Promise} Promise 对象。
     */

  }, {
    key: "createIServer",
    value: function createIServer(createParam) {
      return this.request("POST", this.serviceUrl + '/icloud/web/nodes/server.json', new iManagerCreateNodeParam_IManagerCreateNodeParam(createParam));
    }
    /**
     * @function SuperMap.iManager.prototype.createIPortal
     * @param {SuperMap.iManagerCreateNodeParam} createParam - 创建参数。
     * @description 创建 iPortal。
     * @returns {Promise} Promise 对象。
     */

  }, {
    key: "createIPortal",
    value: function createIPortal(createParam) {
      return this.request("POST", this.serviceUrl + '/icloud/web/nodes/portal.json', new iManagerCreateNodeParam_IManagerCreateNodeParam(createParam));
    }
    /**
     * @function SuperMap.iManager.prototype.iServerList
     * @description 获取所有创建的 iServer。
     * @returns {Promise} Promise 对象。
     */

  }, {
    key: "iServerList",
    value: function iServerList() {
      return this.request("GET", this.serviceUrl + '/icloud/web/nodes/server.json');
    }
    /**
     * @function SuperMap.iManager.prototype.iPortalList
     * @description 获取所有创建的 iPortal。
     * @returns {Promise} Promise 对象。
     */

  }, {
    key: "iPortalList",
    value: function iPortalList() {
      return this.request("GET", this.serviceUrl + '/icloud/web/nodes/portal.json');
    }
    /**
     * @function SuperMap.iManager.prototype.startNodes
     * @param {Array} ids - 需要启动节点的 ID 数组。e.g:['1']。
     * @description 启动节点。
     * @returns {Promise} Promise 对象。
     */

  }, {
    key: "startNodes",
    value: function startNodes(ids) {
      return this.request("POST", this.serviceUrl + '/icloud/web/nodes/started.json', ids);
    }
    /**
     * @function SuperMap.iManager.prototype.stopNodes
     * @param {Array} ids - 需要停止节点的 ID 数组。e.g:['1']。
     * @description 停止节点。
     * @returns {Promise} Promise 对象。
     */

  }, {
    key: "stopNodes",
    value: function stopNodes(ids) {
      return this.request("POST", this.serviceUrl + '/icloud/web/nodes/stopped.json', ids);
    }
  }]);

  return IManager;
}(iManagerServiceBase_IManagerServiceBase);
SuperMap.iManager = iManager_IManager;
// CONCATENATED MODULE: ./src/common/iManager/index.js
/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/






// CONCATENATED MODULE: ./src/common/iPortal/iPortalServiceBase.js
function iPortalServiceBase_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function iPortalServiceBase_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function iPortalServiceBase_createClass(Constructor, protoProps, staticProps) { if (protoProps) iPortalServiceBase_defineProperties(Constructor.prototype, protoProps); if (staticProps) iPortalServiceBase_defineProperties(Constructor, staticProps); return Constructor; }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/





/**
 * @class SuperMap.iPortalServiceBase
 * @classdesc iPortal 服务基类（有权限限制的类需要实现此类）。
 * @category iPortal/Online
 * @param {string} url - iPortal 服务地址。
 * @param {Object} options - 可选参数。
 * @param {boolean} [options.withCredentials=false] - 请求是否携带 cookie。
 * @param {boolean} [options.crossOrigin] - 是否允许跨域请求。
 * @param {Object} [options.headers] - 请求头。
 */

var iPortalServiceBase_IPortalServiceBase =
/*#__PURE__*/
function () {
  function IPortalServiceBase(url, options) {
    iPortalServiceBase_classCallCheck(this, IPortalServiceBase);

    options = options || {};
    this.serviceUrl = url;
    this.serverType = ServerType.iPortal;
    this.CLASS_NAME = "SuperMap.iPortalServiceBase";
    this.withCredentials = options.withCredentials || false;
    this.crossOrigin = options.crossOrigin;
    this.headers = options.headers;
  }
  /**
   * @function SuperMap.iPortalServiceBase.prototype.request
   * @description 子类统一通过该方法发送请求。
   * @param {string} [method='GET'] - 请求类型。
   * @param {string} url - 服务地址。
   * @param {Object} param - 请求参数。
   * @param {Object} [requestOptions] - fetch 请求配置项。
   * @returns {Promise} 返回包含请求结果的 Promise 对象。
   */


  iPortalServiceBase_createClass(IPortalServiceBase, [{
    key: "request",
    value: function request(method, url, param) {
      var requestOptions = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {
        headers: this.headers,
        crossOrigin: this.crossOrigin,
        withCredentials: this.withCredentials
      };
      url = this.createCredentialUrl(url);
      return FetchRequest.commit(method, url, param, requestOptions).then(function (response) {
        return response.json();
      });
    }
    /**
     * @function SuperMap.iPortalServiceBase.prototype.createCredentialUrl
     * @description 追加授权信息。
     * @param {string} url - 创建证书 URL 地址。
     * @returns {string} 携带 token 或 key 的新地址。
     */

  }, {
    key: "createCredentialUrl",
    value: function createCredentialUrl(url) {
      var newUrl = url,
          credential = this.getCredential();

      if (credential) {
        var endStr = newUrl.substring(newUrl.length - 1, newUrl.length);

        if (newUrl.indexOf("?") > -1 && endStr === "?") {
          newUrl += credential.getUrlParameters();
        } else if (newUrl.indexOf("?") > -1 && endStr !== "?") {
          newUrl += "&" + credential.getUrlParameters();
        } else {
          newUrl += "?" + credential.getUrlParameters();
        }
      }

      return newUrl;
    }
    /**
     * @function SuperMap.iPortalServiceBase.prototype.getCredential
     * @description 获取 token。
     * @returns {string} 返回获取的 token。
     *
     */

  }, {
    key: "getCredential",
    value: function getCredential() {
      var credential,
          value = SecurityManager_SecurityManager.getToken(this.serviceUrl);
      credential = value ? new Credential(value, "token") : null;

      if (!credential) {
        value = this.getKey();
        credential = value ? new Credential(value, "key") : null;
      }

      return credential;
    }
    /**
     * @function SuperMap.iPortalServiceBase.prototype.getKey
     * @description 其子类需要重写该方法，修改其中获取 key 的字段，存储 key 可能是服务 ID 字段，可能是 URL。
     */

  }, {
    key: "getKey",
    value: function getKey() {//return SuperMap.SecurityManager.getKey(this.id);
      //或
      //return SuperMap.SecurityManager.getKey(this.serviceUrl);
    }
  }]);

  return IPortalServiceBase;
}();
SuperMap.iPortalServiceBase = iPortalServiceBase_IPortalServiceBase;
// CONCATENATED MODULE: ./src/common/iPortal/iPortalQueryParam.js
function iPortalQueryParam_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


/**
 * @class SuperMap.iPortalQueryParam
 * @classdesc iPortal 资源查询参数。
 * @version 10.0.1
 * @category iPortal/Online
 * @param {Object} params - iPortal 资源查询具体参数。
 * @param {SuperMap.ResourceType} [params.resourceType] - 资源类型
 * @param {number} [params.pageSize] - 分页中每页大小。
 * @param {number} [params.currentPage] - 分页页码。
 * @param {SuperMap.OrderBy} [params.orderBy] - 排序字段。
 * @param {SuperMap.OrderType} [params.orderType] - 根据升序还是降序过滤。
 * @param {SuperMap.SearchType} [params.searchType] - 根据查询的范围进行过滤。
 * @param {Array} [params.tags] - 标签。
 * @param {Array} [params.dirIds] - 目录 id
 * @param {Array} [params.resourceSubTypes] - 根据资源的子类型进行过滤。
 * @param {SuperMap.AggregationTypes} [params.aggregationTypes] - 聚合查询的类型。
 * @param {string} [params.text] - 	搜索的关键词。
 * @param {Array} [params.groupIds] - 	根据群组进行过滤。
 * @param {Array} [params.departmentIds] - 根据部门进行过滤。
 */

var iPortalQueryParam_IPortalQueryParam = function IPortalQueryParam(params) {
  iPortalQueryParam_classCallCheck(this, IPortalQueryParam);

  params = params || {};
  this.resourceType = ""; // 空为全部 MAP SERVICE SCENE DATA INSIGHTS_WORKSPACE MAP_DASHBOARD

  this.pageSize = 12; // 每页多少条

  this.currentPage = 1; // 第几页

  this.orderBy = "UPDATETIME"; // UPDATETIME HEATLEVEL

  this.orderType = "DESC"; // DESC ASC

  this.searchType = "PUBLIC"; // PUBLIC SHARETOME_RES MYDEPARTMENT_RES MYGROUP_RES MY_RES

  this.tags = []; // 标签

  this.dirIds = []; // 类别

  this.resourceSubTypes = []; // 类型

  this.aggregationTypes = []; // TAG TYPE SUBTYPE

  this.text = ""; // 搜索字段

  this.groupIds = []; // 群组Id过滤

  this.departmentIds = []; // 部门Id过滤

  Util.extend(this, params);
};
SuperMap.iPortalQueryParam = iPortalQueryParam_IPortalQueryParam;
// CONCATENATED MODULE: ./src/common/iPortal/iPortalQueryResult.js
function iPortalQueryResult_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


/**
 * @class SuperMap.iPortalQueryResult
 * @classdesc iPortal 资源结果集封装类。
 * @version 10.0.1
 * @category iPortal/Online
 * @param {Object} queryResult - 资源参数。
 * @param {Array} [queryResult.content] - 页面内容。
 * @param {number} [queryResult.total] - 总记录数。
 * @param {number} [queryResult.currentPage] - 当前第几页。
 * @param {number} [queryResult.pageSize] - 每页大小。
 * @param {Object} [queryResult.aggregations] - 聚合查询的结果。
 */

var iPortalQueryResult_IPortalQueryResult = function IPortalQueryResult(queryResult) {
  iPortalQueryResult_classCallCheck(this, IPortalQueryResult);

  queryResult = queryResult || {};
  this.content = [];
  this.total = 0;
  this.currentPage = 1;
  this.pageSize = 12;
  this.aggregations = null;
  Util.extend(this, queryResult);
};
SuperMap.iPortalQueryResult = iPortalQueryResult_IPortalQueryResult;
// CONCATENATED MODULE: ./src/common/iPortal/iPortalResource.js
function iPortalResource_typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { iPortalResource_typeof = function _typeof(obj) { return typeof obj; }; } else { iPortalResource_typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return iPortalResource_typeof(obj); }

function iPortalResource_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function iPortalResource_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function iPortalResource_createClass(Constructor, protoProps, staticProps) { if (protoProps) iPortalResource_defineProperties(Constructor.prototype, protoProps); if (staticProps) iPortalResource_defineProperties(Constructor, staticProps); return Constructor; }

function iPortalResource_possibleConstructorReturn(self, call) { if (call && (iPortalResource_typeof(call) === "object" || typeof call === "function")) { return call; } return iPortalResource_assertThisInitialized(self); }

function iPortalResource_getPrototypeOf(o) { iPortalResource_getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return iPortalResource_getPrototypeOf(o); }

function iPortalResource_assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function iPortalResource_inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) iPortalResource_setPrototypeOf(subClass, superClass); }

function iPortalResource_setPrototypeOf(o, p) { iPortalResource_setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return iPortalResource_setPrototypeOf(o, p); }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/



/**
 * @class SuperMap.iPortalResource
 * @classdesc iPortal 资源详情类。
 * @version 10.0.1
 * @category iPortal/Online
 * @param {string} portalUrl - 资源地址。
 * @param {Object} resourceInfo - 资源详情参数。
 * @param {Array} [resourceInfo.authorizeSetting] - 资源的授权信息
 * @param {string} [resourceInfo.bounds] - 资源的坐标范围
 * @param {string} [resourceInfo.bounds4326] - 资源的坐标范围，转换为EPSG 4326坐标系统后的地理范围。
 * @param {string} [resourceInfo.checkStatus] - 资源的审核状态，可以是：空,SUCCESSFUL,UNCHECKED,FAILED
 * @param {Date} [resourceInfo.createTime] - 资源的创建时间
 * @param {string} [resourceInfo.description] - 资源描述
 * @param {number} [resourceInfo.dirId] - 资源所在的门户目录的id
 * @param {number} [resourceInfo.epsgCode] - 门户资源基于的坐标系的EPSG值。
 * @param {number} [resourceInfo.heatLevel] - 记录资源的访问量或下载量。
 * @param {string} [resourceInfo.id] - 资源存储到ElasticSearch中的文档id
 * @param {string} [resourceInfo.name] - 资源名称
 * @param {number} [resourceInfo.personalDirId] - 资源所在的个人目录的id
 * @param {number} [resourceInfo.resourceId] - 资源表(maps,services等)里的id
 * @param {string} [resourceInfo.resourceSubType] - 某类资源的具体子类型。
 * @param {SuperMap.ResourceType} [resourceInfo.resourceType] - 资源类型
 * @param {number} [resourceInfo.serviceRootUrlId] - 批量注册服务时，服务根地址的ID
 * @param {Array} [resourceInfo.tags] - 资源的标签
 * @param {string} [resourceInfo.thumbnail] - 资源的缩略图
 * @param {Date} [resourceInfo.updateTime] - 资源的更新时间
 * @param {string} [resourceInfo.userName] - 搜索的关键词
 * @param {Object} [resourceInfo.sourceJSON] - 提供了门户项目返回的所有信息。
 * @extends {SuperMap.iPortalServiceBase}
 */

var iPortalResource_IPortalResource =
/*#__PURE__*/
function (_IPortalServiceBase) {
  iPortalResource_inherits(IPortalResource, _IPortalServiceBase);

  function IPortalResource(portalUrl, resourceInfo) {
    var _this;

    iPortalResource_classCallCheck(this, IPortalResource);

    _this = iPortalResource_possibleConstructorReturn(this, iPortalResource_getPrototypeOf(IPortalResource).call(this, portalUrl));
    resourceInfo = resourceInfo || {};
    _this.authorizeSetting = [];
    _this.bounds = "";
    _this.bounds4326 = "";
    _this.checkStatus = "";
    _this.createTime = 0;
    _this.description = null;
    _this.dirId = null;
    _this.epsgCode = 0;
    _this.heatLevel = 0;
    _this.id = 0;
    _this.name = "";
    _this.personalDirId = null;
    _this.resourceId = 0;
    _this.resourceSubType = null;
    _this.resourceType = null;
    _this.serviceRootUrlId = null;
    _this.tags = null;
    _this.thumbnail = null;
    _this.updateTime = 0;
    _this.userName = "";
    _this.sourceJSON = {}; //返回门户资源详细信息

    Util.extend(iPortalResource_assertThisInitialized(_this), resourceInfo); // INSIGHTS_WORKSPACE MAP_DASHBOARD

    _this.resourceUrl = portalUrl + "/web/" + _this.resourceType.replace("_", "").toLowerCase() + "s/" + _this.resourceId;

    if (_this.withCredentials) {
      _this.resourceUrl = portalUrl + "/web/mycontent/" + _this.resourceType.replace("_", "").toLowerCase() + "s/" + _this.resourceId;
    } // if (this.id) {
    //     this.mapUrl = mapUrl + "/" + this.id;
    // }


    return _this;
  }
  /**
   * @function SuperMap.iPortalResource.prototype.load
   * @description 加载资源信息。
   * @returns {Promise} 返回 Promise 对象。如果成功，Promise 没有返回值，请求返回结果自动填充到该类的属性中；如果失败，Promise 返回值包含错误信息。
   */


  iPortalResource_createClass(IPortalResource, [{
    key: "load",
    value: function load() {
      var me = this;
      return me.request("GET", me.resourceUrl + ".json").then(function (resourceInfo) {
        if (resourceInfo.error) {
          return resourceInfo;
        }

        me.sourceJSON = resourceInfo;
      });
    }
    /**
     * @function SuperMap.iPortalResource.prototype.update
     * @description 更新资源属性信息。
     * @returns {Promise} 返回包含更新操作状态的 Promise 对象。
     */

  }, {
    key: "update",
    value: function update() {
      var resourceName = this.resourceType.replace("_", "").toLowerCase();
      var options = {
        headers: {
          'Content-Type': 'application/x-www-form-urlencoded'
        }
      };

      if (resourceName === 'data') {
        this.resourceUrl = this.resourceUrl + "/attributes.json";
      }

      var entity = JSON.stringify(this.sourceJSON); //对服务资源进行编辑时，请求体内容只留关键字字段（目前如果是全部字段 更新返回成功 但其实没有真正的更新）

      if (resourceName === 'service') {
        var serviceInfo = {
          authorizeSetting: this.sourceJSON.authorizeSetting,
          metadata: this.sourceJSON.metadata,
          tags: this.sourceJSON.tags,
          thumbnail: this.sourceJSON.thumbnail,
          tokenRefreshUrl: this.sourceJSON.tokenRefreshUrl
        };
        entity = JSON.stringify(serviceInfo);
      }

      return this.request("PUT", this.resourceUrl, entity, options);
    }
  }]);

  return IPortalResource;
}(iPortalServiceBase_IPortalServiceBase);
SuperMap.iPortalResource = iPortalResource_IPortalResource;
// CONCATENATED MODULE: ./src/common/iPortal/iPortalShareParam.js
function iPortalShareParam_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


/**
 * @class SuperMap.iPortalShareParam
 * @classdesc iPortal 资源共享参数。
 * @version 10.0.1
 * @category iPortal/Online
 * @param {Object} params - iPortal 资源共享具体参数。
 * @param {SuperMap.ResourceType} [params.resourceType] - 资源类型。
 * @param {Array} [params.ids] - 资源的id数组。
 * @param {SuperMap.iPortalShareEntity} [params.entities] - 资源的实体共享参数
 */

var iPortalShareParam_IPortalShareParam = function IPortalShareParam(params) {
  iPortalShareParam_classCallCheck(this, IPortalShareParam);

  params = params || {};
  this.ids = [];
  this.entities = [];
  this.resourceType = ""; // MAP SERVICE SCENE DATA INSIGHTS_WORKSPACE MAP_DASHBOARD

  Util.extend(this, params);
};
SuperMap.iPortalShareParam = iPortalShareParam_IPortalShareParam;
// CONCATENATED MODULE: ./src/common/iPortal/iPortal.js
function iPortal_typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { iPortal_typeof = function _typeof(obj) { return typeof obj; }; } else { iPortal_typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return iPortal_typeof(obj); }

function iPortal_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function iPortal_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function iPortal_createClass(Constructor, protoProps, staticProps) { if (protoProps) iPortal_defineProperties(Constructor.prototype, protoProps); if (staticProps) iPortal_defineProperties(Constructor, staticProps); return Constructor; }

function iPortal_possibleConstructorReturn(self, call) { if (call && (iPortal_typeof(call) === "object" || typeof call === "function")) { return call; } return iPortal_assertThisInitialized(self); }

function iPortal_assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function iPortal_getPrototypeOf(o) { iPortal_getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return iPortal_getPrototypeOf(o); }

function iPortal_inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) iPortal_setPrototypeOf(subClass, superClass); }

function iPortal_setPrototypeOf(o, p) { iPortal_setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return iPortal_setPrototypeOf(o, p); }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/







/**
 * @class SuperMap.iPortal
 * @classdesc 对接 SuperMap iPortal 基础服务。
 * @category iPortal/Online
 * @extends {SuperMap.iPortalServiceBase}
 * @param {string} iportalUrl - 地址。
 * @param {Object} options - 参数。
 * @param {boolean} [options.withCredentials] - 请求是否携带 cookie。
 */

var iPortal_IPortal =
/*#__PURE__*/
function (_IPortalServiceBase) {
  iPortal_inherits(IPortal, _IPortalServiceBase);

  function IPortal(iportalUrl, options) {
    var _this;

    iPortal_classCallCheck(this, IPortal);

    _this = iPortal_possibleConstructorReturn(this, iPortal_getPrototypeOf(IPortal).call(this, iportalUrl, options));
    _this.iportalUrl = iportalUrl;
    options = options || {};
    _this.withCredentials = options.withCredentials || false;
    return _this;
  }
  /**
   * @function SuperMap.iPortal.prototype.load
   * @description 加载页面。
   * @returns {Promise} 返回包含 iportal web 资源信息的 Promise 对象。
   */


  iPortal_createClass(IPortal, [{
    key: "load",
    value: function load() {
      return FetchRequest.get(this.iportalUrl + "/web");
    }
    /**
     * @function SuperMap.iPortal.prototype.queryResources
     * @description 查询资源。
     * @version 10.0.1
     * @param {SuperMap.iPortalQueryParam} queryParams - 查询参数。
     * @returns {Promise} 返回包含所有资源结果的 Promise 对象。
     */

  }, {
    key: "queryResources",
    value: function queryResources(queryParams) {
      if (!(queryParams instanceof iPortalQueryParam_IPortalQueryParam)) {
        return new Promise(function (resolve) {
          resolve("queryParams is not instanceof iPortalQueryParam !");
        });
      }

      var me = this;
      var resourceUrl = this.iportalUrl + "/gateway/catalog/resource/search.json";
      queryParams.t = new Date().getTime();
      return this.request("GET", resourceUrl, queryParams).then(function (result) {
        var content = [];
        result.content.forEach(function (item) {
          content.push(new iPortalResource_IPortalResource(me.iportalUrl, item));
        });
        var queryResult = new iPortalQueryResult_IPortalQueryResult();
        queryResult.content = content;
        queryResult.total = result.total;
        queryResult.currentPage = result.currentPage;
        queryResult.pageSize = result.pageSize;
        queryResult.aggregations = result.aggregations;
        return queryResult;
      });
    }
    /**
     * @function SuperMap.iPortal.prototype.updateResourcesShareSetting
     * @description 更新共享设置。
     * @version 10.0.1
     * @param {SuperMap.iPortalShareParam} shareParams - 共享的参数。
     * @returns {Promise} 返回包含共享资源结果的 Promise 对象。
     */

  }, {
    key: "updateResourcesShareSetting",
    value: function updateResourcesShareSetting(shareParams) {
      if (!(shareParams instanceof iPortalShareParam_IPortalShareParam)) {
        return new Promise(function (resolve) {
          resolve("shareParams is not instanceof iPortalShareParam !");
        });
      }

      var resourceUrlName = shareParams.resourceType.replace("_", "").toLowerCase() + "s";

      if (resourceUrlName === "datas") {
        resourceUrlName = "mycontent/" + resourceUrlName;
      }

      var cloneShareParams = {
        ids: shareParams.ids,
        entities: shareParams.entities
      };
      var shareUrl = this.iportalUrl + "/web/" + resourceUrlName + "/sharesetting.json";
      return this.request("PUT", shareUrl, JSON.stringify(cloneShareParams)).then(function (result) {
        return result;
      });
    }
  }]);

  return IPortal;
}(iPortalServiceBase_IPortalServiceBase);
SuperMap.iPortal = iPortal_IPortal;
// CONCATENATED MODULE: ./src/common/iPortal/iPortalShareEntity.js
function iPortalShareEntity_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


/**
 * @class SuperMap.iPortalShareEntity
 * @classdesc iPortal 资源共享实体参数。
 * @version 10.0.1
 * @category iPortal/Online
 * @param {Object} shareEntity - iPortal 资源共享实体具体参数。
 * @param {SuperMap.PermissionType} [shareEntity.permissionType] - 权限类型。
 * @param {SuperMap.EntityType} [shareEntity.entityType] - 实体类型
 * @param {string} [shareEntity.entityName] - 实体 Name。对应的 USER（用户）、 ROLE（角色）、GROUP（用户组）、IPORTALGROUP（群组）的名称。
 * @param {number} [shareEntity.entityId] - 实体的 id。用于群组的授权。
 */

var iPortalShareEntity_IPortalShareEntity = function IPortalShareEntity(shareEntity) {
  iPortalShareEntity_classCallCheck(this, IPortalShareEntity);

  shareEntity = shareEntity || {};
  this.permissionType = ""; // SEARCH READ READWRITE DOWNLOAD

  this.entityType = ""; // USER DEPARTMENT IPORTALGROUP

  this.entityName = "GUEST"; // GUEST or 具体用户 name

  this.entityId = null;
  Util.extend(this, shareEntity);
};
SuperMap.iPortalShareEntity = iPortalShareEntity_IPortalShareEntity;
// CONCATENATED MODULE: ./src/common/iPortal/iPortalUser.js
function iPortalUser_typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { iPortalUser_typeof = function _typeof(obj) { return typeof obj; }; } else { iPortalUser_typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return iPortalUser_typeof(obj); }

function iPortalUser_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function iPortalUser_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function iPortalUser_createClass(Constructor, protoProps, staticProps) { if (protoProps) iPortalUser_defineProperties(Constructor.prototype, protoProps); if (staticProps) iPortalUser_defineProperties(Constructor, staticProps); return Constructor; }

function iPortalUser_possibleConstructorReturn(self, call) { if (call && (iPortalUser_typeof(call) === "object" || typeof call === "function")) { return call; } return iPortalUser_assertThisInitialized(self); }

function iPortalUser_assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function iPortalUser_getPrototypeOf(o) { iPortalUser_getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return iPortalUser_getPrototypeOf(o); }

function iPortalUser_inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) iPortalUser_setPrototypeOf(subClass, superClass); }

function iPortalUser_setPrototypeOf(o, p) { iPortalUser_setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return iPortalUser_setPrototypeOf(o, p); }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


/**
 * @class SuperMap.iPortalUser
 * @classdesc iPortal 门户中用户信息的封装类。用于管理用户资源，包括可删除，添加资源。
 * @version 10.0.1
 * @category iPortal/Online
 * @param {string} iportalUrl - iportal根地址。
 * @extends {SuperMap.iPortalServiceBase}
 *
 */

var IPortalUser =
/*#__PURE__*/
function (_IPortalServiceBase) {
  iPortalUser_inherits(IPortalUser, _IPortalServiceBase);

  function IPortalUser(iportalUrl) {
    var _this;

    iPortalUser_classCallCheck(this, IPortalUser);

    _this = iPortalUser_possibleConstructorReturn(this, iPortalUser_getPrototypeOf(IPortalUser).call(this, iportalUrl));
    _this.iportalUrl = iportalUrl;
    return _this;
  }
  /**
   * @function SuperMap.iPortalUser.prototype.deleteResources
   * @description 删除资源。
   * @param {Object} params - 删除资源所需的参数对象：{ids,resourceType}。
   * @returns {Promise} 返回包含删除操作状态的 Promise 对象。
   */


  iPortalUser_createClass(IPortalUser, [{
    key: "deleteResources",
    value: function deleteResources(params) {
      var resourceName = params.resourceType.replace("_", "").toLowerCase();
      var deleteResourceUrl = this.iportalUrl + "/web/" + resourceName + "s.json?ids=" + encodeURI(JSON.stringify(params.ids));

      if (resourceName === 'data') {
        deleteResourceUrl = this.iportalUrl + "/web/mycontent/datas/delete.json";
        return this.request("POST", deleteResourceUrl, JSON.stringify(params.ids));
      }

      return this.request("DELETE", deleteResourceUrl);
    }
  }]);

  return IPortalUser;
}(iPortalServiceBase_IPortalServiceBase);
SuperMap.iPortalUser = IPortalUser;
// CONCATENATED MODULE: ./src/common/iPortal/index.js
/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/
















// CONCATENATED MODULE: ./src/common/iServer/CommonServiceBase.js
function CommonServiceBase_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function CommonServiceBase_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function CommonServiceBase_createClass(Constructor, protoProps, staticProps) { if (protoProps) CommonServiceBase_defineProperties(Constructor.prototype, protoProps); if (staticProps) CommonServiceBase_defineProperties(Constructor, staticProps); return Constructor; }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/









/**
 * @class SuperMap.CommonServiceBase
 * @category  iServer
 * @classdesc 对接 iServer 各种服务的 Service 的基类。
 * @param {string} url - 服务地址。
 * @param {Object} options - 参数。
 * @param {Object} options.eventListeners - 事件监听器对象。有 processCompleted 属性可传入处理完成后的回调函数。processFailed 属性传入处理失败后的回调函数。
 * @param {string} [options.proxy] - 服务代理地址。
 * @param {SuperMap.ServerType} [options.serverType=SuperMap.ServerType.ISERVER] - 服务器类型，iServer|iPortal|Online。
 * @param {boolean} [options.withCredentials=false] - 请求是否携带 cookie。
 * @param {boolean} [options.crossOrigin] - 是否允许跨域请求。
 * @param {Object} [options.headers] - 请求头。
 */

var CommonServiceBase_CommonServiceBase =
/*#__PURE__*/
function () {
  function CommonServiceBase(url, options) {
    CommonServiceBase_classCallCheck(this, CommonServiceBase);

    var me = this;
    this.EVENT_TYPES = ["processCompleted", "processFailed"];
    this.events = null;
    this.eventListeners = null;
    this.url = null;
    this.urls = null;
    this.proxy = null;
    this.serverType = null;
    this.index = null;
    this.length = null;
    this.options = null;
    this.totalTimes = null;
    this.POLLING_TIMES = 3;
    this._processSuccess = null;
    this._processFailed = null;
    this.isInTheSameDomain = null;
    this.withCredentials = false;

    if (Util.isArray(url)) {
      me.urls = url;
      me.length = url.length;
      me.totalTimes = me.length;

      if (me.length === 1) {
        me.url = url[0];
      } else {
        me.index = parseInt(Math.random() * me.length);
        me.url = url[me.index];
      }
    } else {
      me.totalTimes = 1;
      me.url = url;
    }

    if (Util.isArray(url) && !me.isServiceSupportPolling()) {
      me.url = url[0];
      me.totalTimes = 1;
    }

    me.serverType = me.serverType || ServerType.ISERVER;
    options = options || {};
    this.crossOrigin = options.crossOrigin;
    this.headers = options.headers;
    Util.extend(this, options);
    me.isInTheSameDomain = Util.isInTheSameDomain(me.url);
    me.events = new Events_Events(me, null, me.EVENT_TYPES, true);

    if (me.eventListeners instanceof Object) {
      me.events.on(me.eventListeners);
    }

    this.CLASS_NAME = "SuperMap.CommonServiceBase";
  }
  /**
   * @function SuperMap.CommonServiceBase.prototype.destroy
   * @description 释放资源，将引用的资源属性置空。
   */


  CommonServiceBase_createClass(CommonServiceBase, [{
    key: "destroy",
    value: function destroy() {
      var me = this;

      if (Util.isArray(me.urls)) {
        me.urls = null;
        me.index = null;
        me.length = null;
        me.totalTimes = null;
      }

      me.url = null;
      me.options = null;
      me._processSuccess = null;
      me._processFailed = null;
      me.isInTheSameDomain = null;
      me.EVENT_TYPES = null;

      if (me.events) {
        me.events.destroy();
        me.events = null;
      }

      if (me.eventListeners) {
        me.eventListeners = null;
      }
    }
    /**
     * @function  SuperMap.CommonServiceBase.prototype.request
     * @description: 该方法用于向服务发送请求。
     * @param {Object} options - 参数。
     * @param {string} [options.method='GET'] - 请求方式，包括 "GET"，"POST"，"PUT"，"DELETE"。
     * @param {string} [options.url] - 发送请求的地址。
     * @param {Object} [options.params] - 作为查询字符串添加到 URL 中的一组键值对，此参数只适用于 GET 方式发送的请求。
     * @param {string} [options.data] - 发送到服务器的数据。
     * @param {function} options.success - 请求成功后的回调函数。
     * @param {function} options.failure - 请求失败后的回调函数。
     * @param {Object} [options.scope] - 如果回调函数是对象的一个公共方法，设定该对象的范围。
     * @param {boolean} [options.isInTheSameDomain] - 请求是否在当前域中。
     * @param {boolean} [options.withCredentials=false] - 请求是否携带 cookie。
     * @param {boolean} [options.crossOrigin] - 是否允许跨域请求。
     * @param {Object} [options.headers] - 请求头。
     */

  }, {
    key: "request",
    value: function request(options) {
      var me = this;
      options.url = options.url || me.url;
      options.proxy = options.proxy || me.proxy;
      options.withCredentials = options.withCredentials != undefined ? options.withCredentials : me.withCredentials;
      options.crossOrigin = options.crossOrigin != undefined ? options.crossOrigin : me.crossOrigin;
      options.headers = options.headers || me.headers;
      options.isInTheSameDomain = me.isInTheSameDomain; //为url添加安全认证信息片段

      var credential = this.getCredential(options.url);

      if (credential) {
        //当url中含有?，并且?在url末尾的时候直接添加token *网络分析等服务请求url会出现末尾是?的情况*
        //当url中含有?，并且?不在url末尾的时候添加&token
        //当url中不含有?，在url末尾添加?token
        var endStr = options.url.substring(options.url.length - 1, options.url.length);

        if (options.url.indexOf("?") > -1 && endStr === "?") {
          options.url += credential.getUrlParameters();
        } else if (options.url.indexOf("?") > -1 && endStr !== "?") {
          options.url += "&" + credential.getUrlParameters();
        } else {
          options.url += "?" + credential.getUrlParameters();
        }
      }

      me.calculatePollingTimes();
      me._processSuccess = options.success;
      me._processFailed = options.failure;
      options.scope = me;
      options.success = me.getUrlCompleted;
      options.failure = me.getUrlFailed;
      me.options = options;

      me._commit(me.options);
    }
    /**
     * @function SuperMap.CommonServiceBase.prototype.getCredential
     * @description  获取凭据信息
     * @param {string} url - 服务地址。
     * @returns {SuperMap.Credential} 凭据信息对象。
     */

  }, {
    key: "getCredential",
    value: function getCredential(url) {
      var keyUrl = url,
          credential,
          value;

      switch (this.serverType) {
        case ServerType.IPORTAL:
          value = SecurityManager_SecurityManager.getToken(keyUrl);
          credential = value ? new Credential(value, "token") : null;

          if (!credential) {
            value = SecurityManager_SecurityManager.getKey(keyUrl);
            credential = value ? new Credential(value, "key") : null;
          }

          break;

        case ServerType.ONLINE:
          value = SecurityManager_SecurityManager.getKey(keyUrl);
          credential = value ? new Credential(value, "key") : null;
          break;

        default:
          //iServer or others
          value = SecurityManager_SecurityManager.getToken(keyUrl);
          credential = value ? new Credential(value, "token") : null;
          break;
      }

      return credential;
    }
    /**
     * @function SuperMap.CommonServiceBase.prototype.getUrlCompleted
     * @description 请求成功后执行此方法。
     * @param {Object} result - 服务器返回的结果对象。
     */

  }, {
    key: "getUrlCompleted",
    value: function getUrlCompleted(result) {
      var me = this;

      me._processSuccess(result);
    }
    /**
     * @function SuperMap.CommonServiceBase.prototype.getUrlFailed
     * @description 请求失败后执行此方法。
     * @param {Object} result - 服务器返回的结果对象。
     */

  }, {
    key: "getUrlFailed",
    value: function getUrlFailed(result) {
      var me = this;

      if (me.totalTimes > 0) {
        me.totalTimes--;
        me.ajaxPolling();
      } else {
        me._processFailed(result);
      }
    }
    /**
     *
     * @function SuperMap.CommonServiceBase.prototype.ajaxPolling
     * @description 请求失败后，如果剩余请求失败次数不为 0，重新获取 URL 发送请求
     */

  }, {
    key: "ajaxPolling",
    value: function ajaxPolling() {
      var me = this,
          url = me.options.url,
          re = /^http:\/\/([a-z]{9}|(\d+\.){3}\d+):\d{0,4}/;
      me.index = parseInt(Math.random() * me.length);
      me.url = me.urls[me.index];
      url = url.replace(re, re.exec(me.url)[0]);
      me.options.url = url;
      me.options.isInTheSameDomain = Util.isInTheSameDomain(url);

      me._commit(me.options);
    }
    /**
     * @function SuperMap.CommonServiceBase.prototype.calculatePollingTimes
     * @description 计算剩余请求失败执行次数。
     */

  }, {
    key: "calculatePollingTimes",
    value: function calculatePollingTimes() {
      var me = this;

      if (me.times) {
        if (me.totalTimes > me.POLLING_TIMES) {
          if (me.times > me.POLLING_TIMES) {
            me.totalTimes = me.POLLING_TIMES;
          } else {
            me.totalTimes = me.times;
          }
        } else {
          if (me.times < me.totalTimes) {
            me.totalTimes = me.times;
          }
        }
      } else {
        if (me.totalTimes > me.POLLING_TIMES) {
          me.totalTimes = me.POLLING_TIMES;
        }
      }

      me.totalTimes--;
    }
    /**
     * @function SuperMap.CommonServiceBase.prototype.isServiceSupportPolling
     * @description 判断服务是否支持轮询。
     */

  }, {
    key: "isServiceSupportPolling",
    value: function isServiceSupportPolling() {
      var me = this;
      return !(me.CLASS_NAME === "SuperMap.REST.ThemeService" || me.CLASS_NAME === "SuperMap.REST.EditFeaturesService");
    }
    /**
     * @function SuperMap.CommonServiceBase.prototype.serviceProcessCompleted
     * @description 状态完成，执行此方法。
     * @param {Object} result - 服务器返回的结果对象。
     */

  }, {
    key: "serviceProcessCompleted",
    value: function serviceProcessCompleted(result) {
      result = Util.transformResult(result);
      this.events.triggerEvent("processCompleted", {
        result: result
      });
    }
    /**
     * @function SuperMap.CommonServiceBase.prototype.serviceProcessFailed
     * @description 状态失败，执行此方法。
     * @param {Object} result - 服务器返回的结果对象。
     */

  }, {
    key: "serviceProcessFailed",
    value: function serviceProcessFailed(result) {
      result = Util.transformResult(result);
      var error = result.error || result;
      this.events.triggerEvent("processFailed", {
        error: error
      });
    }
  }, {
    key: "_commit",
    value: function _commit(options) {
      if (options.method === "POST" || options.method === "PUT") {
        if (options.params) {
          options.url = Util.urlAppend(options.url, Util.getParameterString(options.params || {}));
        }

        options.params = options.data;
      }

      FetchRequest.commit(options.method, options.url, options.params, {
        headers: options.headers,
        withCredentials: options.withCredentials,
        crossOrigin: options.crossOrigin,
        timeout: options.async ? 0 : null,
        proxy: options.proxy
      }).then(function (response) {
        if (response.text) {
          return response.text();
        }

        if (response.json) {
          return response.json();
        }

        return response;
      }).then(function (text) {
        var result = text;

        if (typeof text === "string") {
          result = new JSONFormat().read(text);
        }

        if (!result || result.error || result.code >= 300 && result.code !== 304) {
          if (result && result.error) {
            result = {
              error: result.error
            };
          } else {
            result = {
              error: result
            };
          }
        }

        if (result.error) {
          var failure = options.scope ? FunctionExt.bind(options.failure, options.scope) : options.failure;
          failure(result);
        } else {
          result.succeed = result.succeed == undefined ? true : result.succeed;
          var success = options.scope ? FunctionExt.bind(options.success, options.scope) : options.success;
          success(result);
        }
      })["catch"](function (e) {
        var failure = options.scope ? FunctionExt.bind(options.failure, options.scope) : options.failure;
        failure(e);
      });
    }
  }]);

  return CommonServiceBase;
}();
SuperMap.CommonServiceBase = CommonServiceBase_CommonServiceBase;
/**
 * 服务器请求回调函数
 * @callback RequestCallback
 * @example
 * var requestCallback = function (serviceResult){
 *      console.log(serviceResult.result);
 * }
 * new QueryService(url).queryByBounds(param, requestCallback);
 * @param {Object} serviceResult
 * @param {Object} serviceResult.result 服务器返回结果。
 * @param {Object} serviceResult.object 发布应用程序事件的对象。
 * @param {Object} serviceResult.type 事件类型。
 * @param {Object} serviceResult.element 接受浏览器事件的 DOM 节点。
 */
// CONCATENATED MODULE: ./src/common/iServer/GeoCodingParameter.js
function GeoCodingParameter_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function GeoCodingParameter_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function GeoCodingParameter_createClass(Constructor, protoProps, staticProps) { if (protoProps) GeoCodingParameter_defineProperties(Constructor.prototype, protoProps); if (staticProps) GeoCodingParameter_defineProperties(Constructor, staticProps); return Constructor; }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


/**
 * @class SuperMap.GeoCodingParameter
 * @category  iServer AddressMatch
 * @classdesc 地理正向匹配参数类。
 * @param {Object} options - 参数。 
 * @param {string} options.address - 地点关键词。 
 * @param {number} [options.fromIndex] - 设置返回对象的起始索引值。 
 * @param {number} [options.toIndex] - 设置返回对象的结束索引值。 
 * @param {Array.<string>} [options.filters] - 过滤字段，限定查询区域。 
 * @param {string} [options.prjCoordSys] - 查询结果的坐标系。 
 * @param {number} [options.maxReturn] - 最大返回结果数。
 */

var GeoCodingParameter_GeoCodingParameter =
/*#__PURE__*/
function () {
  function GeoCodingParameter(options) {
    GeoCodingParameter_classCallCheck(this, GeoCodingParameter);

    if (options.filters) {
      var strs = [];
      var fields = options.filters.split(',');
      fields.map(function (field) {
        strs.push("\"" + field + "\"");
        return field;
      });
      options.filters = strs;
    }
    /**
     * @member {string} SuperMap.GeoCodingParameter.prototype.address
     * @description 地点关键词。
     */


    this.address = null;
    /**
     * @member {number} [SuperMap.GeoCodingParameter.prototype.fromIndex]
     * @description 设置返回对象的起始索引值。
     */

    this.fromIndex = null;
    /**
     * @member {number} [SuperMap.GeoCodingParameter.prototype.toIndex]
     * @description 设置返回对象的结束索引值。
     */

    this.toIndex = null;
    /**
     * @member {Array.<string>} [SuperMap.GeoCodingParameter.prototype.filters]
     * @description 过滤字段，限定查询区域。
     */

    this.filters = null;
    /**
     * @member {string} [SuperMap.GeoCodingParameter.prototype.prjCoordSys]
     * @description  查询结果的坐标系。
     */

    this.prjCoordSys = null;
    /**
     * @member {number} [SuperMap.GeoCodingParameter.prototype.maxReturn]
     * @description 最大返回结果数。
     */

    this.maxReturn = null;
    Util.extend(this, options);
  }
  /**
   * @function SuperMap.GeoCodingParameter.prototype.destroy
   * @description 释放资源，将引用资源的属性置空。
   */


  GeoCodingParameter_createClass(GeoCodingParameter, [{
    key: "destroy",
    value: function destroy() {
      this.address = null;
      this.fromIndex = null;
      this.toIndex = null;
      this.filters = null;
      this.prjCoordSys = null;
      this.maxReturn = null;
    }
  }]);

  return GeoCodingParameter;
}();
SuperMap.GeoCodingParameter = GeoCodingParameter_GeoCodingParameter;
// CONCATENATED MODULE: ./src/common/iServer/GeoDecodingParameter.js
function GeoDecodingParameter_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function GeoDecodingParameter_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function GeoDecodingParameter_createClass(Constructor, protoProps, staticProps) { if (protoProps) GeoDecodingParameter_defineProperties(Constructor.prototype, protoProps); if (staticProps) GeoDecodingParameter_defineProperties(Constructor, staticProps); return Constructor; }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


/**
 * @class SuperMap.GeoDecodingParameter
 * @category iServer AddressMatch
 * @classdesc 地理反向匹配参数类。
 * @param {Object} options - 参数。 
 * @param {number} options.x - 查询位置的横坐标。 
 * @param {number} options.y - 查询位置的纵坐标。 
 * @param {number} [options.fromIndex] - 设置返回对象的起始索引值。 
 * @param {Array.<string>} [options.filters] - 过滤字段，限定查询区域。 
 * @param {string} [options.prjCoordSys] - 查询结果的坐标系。 
 * @param {number} [options.maxReturn] - 最大返回结果数。 
 * @param {number} [options.geoDecodingRadius] - 查询半径。
 */

var GeoDecodingParameter_GeoDecodingParameter =
/*#__PURE__*/
function () {
  function GeoDecodingParameter(options) {
    GeoDecodingParameter_classCallCheck(this, GeoDecodingParameter);

    if (options.filters) {
      var strs = [];
      var fields = options.filters.split(',');
      fields.map(function (field) {
        strs.push("\"" + field + "\"");
        return field;
      });
      options.filters = strs;
    }
    /**
     * @member {number} SuperMap.GeoDecodingParameter.prototype.x
     * @description 查询位置的横坐标。
     */


    this.x = null;
    /**
     * @member {number} SuperMap.GeoDecodingParameter.prototype.y
     * @description 查询位置的纵坐标。
     */

    this.y = null;
    /**
     * @member {number} [SuperMap.GeoDecodingParameter.prototype.fromIndex]
     * @description  设置返回对象的起始索引值。
     */

    this.fromIndex = null;
    /**
     * @member {number} [SuperMap.GeoDecodingParameter.prototype.toIndex]
     * @description 设置返回对象的结束索引值。
     */

    this.toIndex = null;
    /**
     * @member {Array.<string>} [SuperMap.GeoDecodingParameter.prototype.filters]
     * @description 过滤字段，限定查询区域。
     */

    this.filters = null;
    /**
     * @member {string} [SuperMap.GeoDecodingParameter.prototype.prjCoordSys]
     * @description 查询结果的坐标系。
     */

    this.prjCoordSys = null;
    /**
     *  @member {number} [SuperMap.GeoDecodingParameter.prototype.maxReturn]
     *  @description 最大返回结果数。
     */

    this.maxReturn = null;
    /**
     * @member {number} SuperMap.GeoDecodingParameter.prototype.geoDecodingRadius
     * @description 查询半径。
     */

    this.geoDecodingRadius = null;
    Util.extend(this, options);
  }
  /**
   * @function SuperMap.GeoDecodingParameter.prototype.destroy
   * @description 释放资源，将引用资源的属性置空。
   */


  GeoDecodingParameter_createClass(GeoDecodingParameter, [{
    key: "destroy",
    value: function destroy() {
      this.x = null;
      this.y = null;
      this.fromIndex = null;
      this.toIndex = null;
      this.filters = null;
      this.prjCoordSys = null;
      this.maxReturn = null;
      this.geoDecodingRadius = null;
    }
  }]);

  return GeoDecodingParameter;
}();
SuperMap.GeoDecodingParameter = GeoDecodingParameter_GeoDecodingParameter;
// CONCATENATED MODULE: ./src/common/iServer/AddressMatchService.js
function AddressMatchService_typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { AddressMatchService_typeof = function _typeof(obj) { return typeof obj; }; } else { AddressMatchService_typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return AddressMatchService_typeof(obj); }

function AddressMatchService_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function AddressMatchService_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function AddressMatchService_createClass(Constructor, protoProps, staticProps) { if (protoProps) AddressMatchService_defineProperties(Constructor.prototype, protoProps); if (staticProps) AddressMatchService_defineProperties(Constructor, staticProps); return Constructor; }

function AddressMatchService_possibleConstructorReturn(self, call) { if (call && (AddressMatchService_typeof(call) === "object" || typeof call === "function")) { return call; } return AddressMatchService_assertThisInitialized(self); }

function AddressMatchService_assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function AddressMatchService_get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { AddressMatchService_get = Reflect.get; } else { AddressMatchService_get = function _get(target, property, receiver) { var base = AddressMatchService_superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return AddressMatchService_get(target, property, receiver || target); }

function AddressMatchService_superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = AddressMatchService_getPrototypeOf(object); if (object === null) break; } return object; }

function AddressMatchService_getPrototypeOf(o) { AddressMatchService_getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return AddressMatchService_getPrototypeOf(o); }

function AddressMatchService_inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) AddressMatchService_setPrototypeOf(subClass, superClass); }

function AddressMatchService_setPrototypeOf(o, p) { AddressMatchService_setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return AddressMatchService_setPrototypeOf(o, p); }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/




/**
 * @class SuperMap.AddressMatchService
 * @category iServer AddressMatch
 * @classdesc 地址匹配服务，包括正向匹配和反向匹配。
 * @param {string} url - 地址匹配服务地址。
 * @param {Object} options - 参数。
 * @param {boolean} [options.crossOrigin] - 是否允许跨域请求。
 * @param {Object} [options.headers] - 请求头。
 */

var AddressMatchService_AddressMatchService =
/*#__PURE__*/
function (_CommonServiceBase) {
  AddressMatchService_inherits(AddressMatchService, _CommonServiceBase);

  function AddressMatchService(url, options) {
    var _this;

    AddressMatchService_classCallCheck(this, AddressMatchService);

    _this = AddressMatchService_possibleConstructorReturn(this, AddressMatchService_getPrototypeOf(AddressMatchService).call(this, url, options));
    _this.options = options || {};
    _this.CLASS_NAME = 'SuperMap.AddressMatchService';
    return _this;
  }
  /**
   * @function SuperMap.AddressMatchService.prototype.destroy
   * @override
   */


  AddressMatchService_createClass(AddressMatchService, [{
    key: "destroy",
    value: function destroy() {
      AddressMatchService_get(AddressMatchService_getPrototypeOf(AddressMatchService.prototype), "destroy", this).call(this);
    }
    /**
     * @function SuperMap.AddressMatchService.prototype.code
     * @param {string} url - 正向地址匹配服务地址。
     * @param {SuperMap.GeoCodingParameter} params - 正向地址匹配服务参数。
     */

  }, {
    key: "code",
    value: function code(url, params) {
      if (!(params instanceof GeoCodingParameter_GeoCodingParameter)) {
        return;
      }

      this.processAsync(url, params);
    }
    /**
     * @function SuperMap.AddressMatchService.prototype.decode
     * @param {string} url - 反向地址匹配服务地址。
     * @param {SuperMap.GeoDecodingParameter} params - 反向地址匹配服务参数。
     */

  }, {
    key: "decode",
    value: function decode(url, params) {
      if (!(params instanceof GeoDecodingParameter_GeoDecodingParameter)) {
        return;
      }

      this.processAsync(url, params);
    }
    /**
     * @function SuperMap.AddressMatchService.prototype.processAsync
     * @description 负责将客户端的动态分段服务参数传递到服务端。
     * @param {string} url - 服务地址。
     * @param {Object} params - 参数。
     */

  }, {
    key: "processAsync",
    value: function processAsync(url, params) {
      this.request({
        method: 'GET',
        url: url,
        params: params,
        scope: this,
        success: this.serviceProcessCompleted,
        failure: this.serviceProcessFailed
      });
    }
    /**
     * @function SuperMap.AddressMatchService.prototype.serviceProcessCompleted
     * @param {Object} result - 服务器返回的结果对象。
     * @description 服务流程是否完成
     */

  }, {
    key: "serviceProcessCompleted",
    value: function serviceProcessCompleted(result) {
      if (result.succeed) {
        delete result.succeed;
      }

      AddressMatchService_get(AddressMatchService_getPrototypeOf(AddressMatchService.prototype), "serviceProcessCompleted", this).call(this, result);
    }
    /**
     * @function SuperMap.AddressMatchService.prototype.serviceProcessCompleted
     * @param {Object} result - 服务器返回的结果对象。
     * @description 服务流程是否失败
     */

  }, {
    key: "serviceProcessFailed",
    value: function serviceProcessFailed(result) {
      AddressMatchService_get(AddressMatchService_getPrototypeOf(AddressMatchService.prototype), "serviceProcessFailed", this).call(this, result);
    }
  }]);

  return AddressMatchService;
}(CommonServiceBase_CommonServiceBase);
SuperMap.AddressMatchService = AddressMatchService_AddressMatchService;
// CONCATENATED MODULE: ./src/common/iServer/AggQueryBuilderParameter.js
function AggQueryBuilderParameter_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function AggQueryBuilderParameter_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function AggQueryBuilderParameter_createClass(Constructor, protoProps, staticProps) { if (protoProps) AggQueryBuilderParameter_defineProperties(Constructor.prototype, protoProps); if (staticProps) AggQueryBuilderParameter_defineProperties(Constructor, staticProps); return Constructor; }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


/**
 * @class SuperMap.AggQueryBuilderParameter
 * @classdesc 聚合查询 QueryBuilder 参数基类，该参数仅支持数据来源 Elasticsearch 服务的数据服务。
 * @category iServer Data FeatureResults
 * @param {Object} option - 初始化参数。
 * @param {string} option.name - 查询结果名称。
 * @param {SuperMap.AggregationQueryBuilderType} option.queryType - 查询类型。
 */

var AggQueryBuilderParameter_AggQueryBuilderParameter =
/*#__PURE__*/
function () {
  function AggQueryBuilderParameter(option) {
    AggQueryBuilderParameter_classCallCheck(this, AggQueryBuilderParameter);

    /**
     * @member {string} SuperMap.AggQueryBuilderParameter.prototype.name
     * @description 查询结果名称。
     */
    this.name = null;
    /**
     * @member {SuperMap.AggregationQueryBuilderType} SuperMap.AggQueryBuilderParameter.prototype.queryType
     * @description 查询类型。
     */

    this.queryType = null;
    this.CLASS_NAME = "SuperMap.AggQueryBuilderParameter";
    Util.extend(this, option);
  }

  AggQueryBuilderParameter_createClass(AggQueryBuilderParameter, [{
    key: "destroy",
    value: function destroy() {
      var me = this;
      me.name = null;
      me.queryType = null;
    }
  }]);

  return AggQueryBuilderParameter;
}();
SuperMap.AggQueryBuilderParameter = AggQueryBuilderParameter_AggQueryBuilderParameter;
// CONCATENATED MODULE: ./src/common/iServer/AggregationParameter.js
function AggregationParameter_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function AggregationParameter_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function AggregationParameter_createClass(Constructor, protoProps, staticProps) { if (protoProps) AggregationParameter_defineProperties(Constructor.prototype, protoProps); if (staticProps) AggregationParameter_defineProperties(Constructor, staticProps); return Constructor; }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


/**
 * @class SuperMap.AggregationParameter
 * @classdesc 聚合查询参数设置，该参数仅支持数据来源 Elasticsearch 服务的数据服务。
 * @category iServer Data FeatureResults
 * @param {Object} options - 初始化参数。
 * @param {string} options.aggName - 聚合名称。
 * @param {SuperMap.AggregationType} options.aggType - 聚合类型设置。
 * @param {string} options.aggFieldName - 聚合字段。
 * @param {SuperMap.AggregationParameter} options.subAgg - 子聚合类。
 *
 */

var AggregationParameter_AggregationParameter =
/*#__PURE__*/
function () {
  function AggregationParameter(options) {
    AggregationParameter_classCallCheck(this, AggregationParameter);

    /**
     * @member {string} SuperMap.AggregationParameter.prototype.aggName
     * @description 聚合名称。
     */
    this.aggName = null;
    /**
     * @member {SuperMap.AggregationType} SuperMap.AggregationParameter.prototype.aggType
     * @description 聚合类型设置类。
     */

    this.aggType = null;
    /**
     * @member {string} SuperMap.AggregationParameter.prototype.aggFieldName
     * @description 聚合字段。
     */

    this.aggFieldName = null;
    /**
     * @member {SuperMap.AggregationParameter} SuperMap.AggregationParameter.prototype.subAgg
     * @description 子聚合。
     */

    this.subAgg = null;
    this.CLASS_NAME = "SuperMap.AggregationParameter";
    Util.extend(this, options);
  }

  AggregationParameter_createClass(AggregationParameter, [{
    key: "destroy",
    value: function destroy() {
      var me = this;
      me.aggName = null;
      me.aggFieldName = null;
      me.aggType = null;

      if (me.subAgg) {
        me.subAgg = null;
      }
    }
  }]);

  return AggregationParameter;
}();
SuperMap.AggregationParameter = AggregationParameter_AggregationParameter;
// CONCATENATED MODULE: ./src/common/iServer/AreaSolarRadiationParameters.js
function AreaSolarRadiationParameters_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function AreaSolarRadiationParameters_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function AreaSolarRadiationParameters_createClass(Constructor, protoProps, staticProps) { if (protoProps) AreaSolarRadiationParameters_defineProperties(Constructor.prototype, protoProps); if (staticProps) AreaSolarRadiationParameters_defineProperties(Constructor, staticProps); return Constructor; }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


/**
 * @class SuperMap.AreaSolarRadiationParameters
 * @category iServer SpatialAnalyst SolarRadiationAnalyst
 * @classdesc 地区太阳辐射参数类。
 * @param {Object} options - 参数。 
 * @param {string} options.dataset - 要用来做地区太阳辐射数据源中数据集的名称。该名称用形如"数据集名称@数据源别名"的形式来表示，例如：JingjinTerrain@Jingjin。 
 * @param {string} options.targetDatasourceName - 指定的存储结果数据集的数据源名称, 例如："Jingjin"。 
 * @param {string} options.totalGridName - 指定地区太阳辐射总辐射量数据集的名称。 
 * @param {string} options.diffuseDatasetGridName - 指定地区太阳辐射散射辐射量数据集的名称。 
 * @param {string} options.durationDatasetGridName - 指定地区太阳辐射太阳直射持续时间数据集的名称。 
 * @param {string} options.directDatasetGridName - 指定地区太阳辐射直射辐射量数据集的名称。
 * @param {number} options.latitude - 待计算区域的纬度值。 
 * @param {string} [options.timeMode = 'MULTIDAYS'] - 时间模式。可选值"WITHINDAY"（单日）或"MULTIDAYS"（多日）。
 * @param {number} options.dayStart - 起始日期（年内的第几天）。 
 * @param {number} options.dayEnd - 结束日期（年内的第几天）。 
 * @param {number} [options.hourStart] - 起始时间（一天中的第几个小时）。 
 * @param {number} [options.hourEnd] - 结束时间（一天中的第几个小时）。 
 * @param {number} [options.transmittance] - 太阳辐射穿过大气的透射率。 
 * @param {number} [options.hourInterval=0.5] - 计算时的小时间隔（设置的越小计算量越大并且计算结果更精确，如果修改此参数，必须使用整数）。 
 * @param {number} [options.dayInterval=5] - 计算时的天数间隔（设置的越小计算量越大并且计算结果更精确，必须使用整数）。 
 * @param {boolean} [options.deleteExistResultDataset=false] - 如果用户命名的结果数据集名称与已有的数据集重名，是否删除已有的数据集。
 */

var AreaSolarRadiationParameters_AreaSolarRadiationParameters =
/*#__PURE__*/
function () {
  function AreaSolarRadiationParameters(options) {
    AreaSolarRadiationParameters_classCallCheck(this, AreaSolarRadiationParameters);

    /**
     *  @member {string} SuperMap.AreaSolarRadiationParameters.prototype.dataset
     *  @description 要用来做地区太阳辐射数据源中数据集的名称。该名称用形如“数据集名称@数据源别名”形式来表示，例如：JingjinTerrain@Jingjin。注：地区太阳辐射数据必须为栅格数据集。
     */
    this.dataset = null;
    /**
     * @member {string} SuperMap.AreaSolarRadiationParameters.prototype.targetDatasourceName
     * @description 指定的存储结果数据集的数据源名称，例如："Jingjin"。
     */

    this.targetDatasourceName = null;
    /**
     * @member {string} SuperMap.AreaSolarRadiationParameters.prototype.totalGridName
     * @description 指定地区太阳辐射总辐射量数据集的名称。
     */

    this.totalGridName = null;
    /**
     * @member {string} SuperMap.AreaSolarRadiationParameters.prototype.diffuseDatasetGridName
     * @description 指定地区太阳辐射散射辐射量数据集的名称。
     */

    this.diffuseDatasetGridName = null;
    /**
     * @member {string} SuperMap.AreaSolarRadiationParameters.prototype.durationDatasetGridName
     * @description  指定地区太阳辐射太阳直射持续时间数据集的名称。
     */

    this.durationDatasetGridName = null;
    /**
     * @member {string} SuperMap.AreaSolarRadiationParameters.prototype.durationDatasetGridName
     * @description 指定地区太阳辐射直射辐射量数据集的名称。
     */

    this.directDatasetGridName = null;
    /**
     * @member {number} SuperMap.AreaSolarRadiationParameters.prototype.latitude
     * @description 待计算区域的纬度值。
     */

    this.latitude = null;
    /**
     *  @member {string} [SuperMap.AreaSolarRadiationParameters.prototype.timeMode='MULTIDAYS']
     *  @description 时间模式。可选值"WITHINDAY"（单日）或"MULTIDAYS"（多日）。
     */

    this.timeMode = "MULTIDAYS";
    /**
     *  @member {number} SuperMap.AreaSolarRadiationParameters.prototype.dayStart
     *  @description 起始日期（年内的第几天）。
     */

    this.dayStart = null;
    /**
     *  @member {number} SuperMap.AreaSolarRadiationParameters.prototype.dayEnd
     * @description 结束日期（年内的第几天）。
     */

    this.dayEnd = null;
    /**
     * @member {number} [SuperMap.AreaSolarRadiationParameters.prototype.hourStart]
     * @description 起始时间（一天中的第几个小时）。
     */

    this.hourStart = null;
    /**
     * @member {number} [SuperMap.AreaSolarRadiationParameters.prototype.hourEnd]
     * @description 结束时间（一天中的第几个小时）。
     */

    this.hourEnd = null;
    /**
     * @member {number} [SuperMap.AreaSolarRadiationParameters.prototype.transmittance]
     * @description 太阳辐射穿过大气的透射率。
     */

    this.transmittance = null;
    /**
     *  @member {number} [SuperMap.AreaSolarRadiationParameters.prototype.hourInterval=0.5]
     *  @description 计算时的小时间隔（设置的越小计算量越大并且计算结果更精确, 如果修改此参数，必须使用整数）
     */

    this.hourInterval = null;
    /**
     * @member {number} [SuperMap.AreaSolarRadiationParameters.prototype.dayInterval=5]
     * @description 计算时的天数间隔（设置的越小计算量越大并且计算结果更精确, 必须使用整数）
     */

    this.dayInterval = null;
    /**
     * @member {boolean} [SuperMap.AreaSolarRadiationParameters.prototype.deleteExistResultDataset=false]
     * @description 如果用户命名的结果数据集名称与已有的数据集重名，是否删除已有的数据集。
     */

    this.deleteExistResultDataset = false;
    Util.extend(this, options);
    this.CLASS_NAME = "SuperMap.AreaSolarRadiationParameters";
  }
  /**
   * @function SuperMap.AreaSolarRadiationParameters.prototype.destroy
   * @description 释放资源，将引用资源的属性置空。
   */


  AreaSolarRadiationParameters_createClass(AreaSolarRadiationParameters, [{
    key: "destroy",
    value: function destroy() {
      var me = this;
      me.dataset = null;
      me.zFactor = 1.0;
      me.averageCurvatureName = null;
      me.profileCurvatureName = null;
      me.planCurvatureName = null;
      me.deleteExistResultDataset = true;
    }
    /**
     * @function SuperMap.AreaSolarRadiationParameters.toObject
     * @param {SuperMap.AreaSolarRadiationParameters} param - 地区太阳辐射参数类。
     * @param {SuperMap.AreaSolarRadiationParameters} tempObj - 地区太阳辐射参数对象。
     * @returns {Object} JSON对象。
     * @description 将SuperMap.AreaSolarRadiationParameters对象转换成JSON对象。
     */

  }], [{
    key: "toObject",
    value: function toObject(param, tempObj) {
      var parameter = {};

      for (var name in param) {
        if (name !== "dataset") {
          var name1 = name === "latitude" || name === "timeMode" || name === "dayStart";
          var name2 = name === "dayEnd" || name === "hourStart" || name === "hourEnd";
          var name3 = name === "transmittance" || name === "hourInterval" || name === "dayInterval";

          if (name1 || name2 || name3) {
            parameter[name] = param[name];
          } else {
            tempObj[name] = param[name];
          }
        }
      }

      tempObj["parameter"] = parameter;
    }
  }]);

  return AreaSolarRadiationParameters;
}();
SuperMap.AreaSolarRadiationParameters = AreaSolarRadiationParameters_AreaSolarRadiationParameters;
// CONCATENATED MODULE: ./src/common/iServer/SpatialAnalystBase.js
function SpatialAnalystBase_typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { SpatialAnalystBase_typeof = function _typeof(obj) { return typeof obj; }; } else { SpatialAnalystBase_typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return SpatialAnalystBase_typeof(obj); }

function SpatialAnalystBase_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function SpatialAnalystBase_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function SpatialAnalystBase_createClass(Constructor, protoProps, staticProps) { if (protoProps) SpatialAnalystBase_defineProperties(Constructor.prototype, protoProps); if (staticProps) SpatialAnalystBase_defineProperties(Constructor, staticProps); return Constructor; }

function SpatialAnalystBase_possibleConstructorReturn(self, call) { if (call && (SpatialAnalystBase_typeof(call) === "object" || typeof call === "function")) { return call; } return SpatialAnalystBase_assertThisInitialized(self); }

function SpatialAnalystBase_assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function SpatialAnalystBase_get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { SpatialAnalystBase_get = Reflect.get; } else { SpatialAnalystBase_get = function _get(target, property, receiver) { var base = SpatialAnalystBase_superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return SpatialAnalystBase_get(target, property, receiver || target); }

function SpatialAnalystBase_superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = SpatialAnalystBase_getPrototypeOf(object); if (object === null) break; } return object; }

function SpatialAnalystBase_getPrototypeOf(o) { SpatialAnalystBase_getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return SpatialAnalystBase_getPrototypeOf(o); }

function SpatialAnalystBase_inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) SpatialAnalystBase_setPrototypeOf(subClass, superClass); }

function SpatialAnalystBase_setPrototypeOf(o, p) { SpatialAnalystBase_setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return SpatialAnalystBase_setPrototypeOf(o, p); }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/





/**
 * @class SuperMap.SpatialAnalystBase
 * @category  iServer SpatialAnalyst
 * @classdesc 空间分析服务基类。
 * @param {string} url - 地址。
 * @param {Object} options - 参数。
 * @param {boolean} [options.crossOrigin] - 是否允许跨域请求。
 * @param {Object} [options.headers] - 请求头。
 * @extends {SuperMap.CommonServiceBase}
 */

var SpatialAnalystBase_SpatialAnalystBase =
/*#__PURE__*/
function (_CommonServiceBase) {
  SpatialAnalystBase_inherits(SpatialAnalystBase, _CommonServiceBase);

  function SpatialAnalystBase(url, options) {
    var _this;

    SpatialAnalystBase_classCallCheck(this, SpatialAnalystBase);

    _this = SpatialAnalystBase_possibleConstructorReturn(this, SpatialAnalystBase_getPrototypeOf(SpatialAnalystBase).call(this, url, options));
    /**
     * @member {SuperMap.DataFormat} [SuperMap.SpatialAnalystBase.prototype.format=SuperMap.DataFormat.GEOJSON]
     * @description 查询结果返回格式，目前支持 iServerJSON 和 GeoJSON 两种格式，参数格式为 "ISERVER"，"GEOJSON"。
     */

    _this.format = DataFormat.GEOJSON;
    _this.CLASS_NAME = "SuperMap.SpatialAnalystBase";
    return _this;
  }
  /**
   * @function SuperMap.SpatialAnalystBase.prototype.destroy
   * @override
   */


  SpatialAnalystBase_createClass(SpatialAnalystBase, [{
    key: "destroy",
    value: function destroy() {
      SpatialAnalystBase_get(SpatialAnalystBase_getPrototypeOf(SpatialAnalystBase.prototype), "destroy", this).call(this);

      this.format = null;
    }
    /**
     * @function SuperMap.SpatialAnalystBase.prototype.serviceProcessCompleted
     * @description 分析完成，执行此方法。
     * @param {Object} result - 服务器返回的结果对象。
     */

  }, {
    key: "serviceProcessCompleted",
    value: function serviceProcessCompleted(result) {
      var me = this,
          analystResult;
      result = Util.transformResult(result);

      if (result && me.format === DataFormat.GEOJSON && typeof me.toGeoJSONResult === 'function') {
        //批量分析时会返回多个结果
        if (Util.isArray(result)) {
          for (var i = 0; i < result.length; i++) {
            result[i] = me.toGeoJSONResult(result[i]);
          }

          analystResult = result;
        } else {
          analystResult = me.toGeoJSONResult(result);
        }
      }

      if (!analystResult) {
        analystResult = result;
      }

      me.events.triggerEvent("processCompleted", {
        result: analystResult
      });
    }
    /**
     * @function SuperMap.SpatialAnalystBase.prototype.toGeoJSONResult
     * @description 将含有 geometry 的数据转换为 GeoJSON 格式。
     * @param {Object} result - 服务器返回的结果对象。
     *
     */

  }, {
    key: "toGeoJSONResult",
    value: function toGeoJSONResult(result) {
      if (!result) {
        return null;
      } //批量叠加分析时结果这样处理


      if (result.result && result.result.resultGeometry) {
        result = result.result;
      }

      var geoJSONFormat = new GeoJSON_GeoJSON();

      if (result.recordsets) {
        for (var i = 0, recordsets = result.recordsets, len = recordsets.length; i < len; i++) {
          if (recordsets[i].features) {
            recordsets[i].features = geoJSONFormat.toGeoJSON(recordsets[i].features);
          }
        }
      } else if (result.recordset && result.recordset.features) {
        result.recordset.features = geoJSONFormat.toGeoJSON(result.recordset.features);
      }

      if (result.resultGeometry) {
        result.resultGeometry = geoJSONFormat.toGeoJSON(result.resultGeometry);
      }

      if (result.regions) {
        result.regions = geoJSONFormat.toGeoJSON(result.regions);
      }

      return result;
    }
  }]);

  return SpatialAnalystBase;
}(CommonServiceBase_CommonServiceBase);
SuperMap.SpatialAnalystBase = SpatialAnalystBase_SpatialAnalystBase;
// CONCATENATED MODULE: ./src/common/iServer/AreaSolarRadiationService.js
function AreaSolarRadiationService_typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { AreaSolarRadiationService_typeof = function _typeof(obj) { return typeof obj; }; } else { AreaSolarRadiationService_typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return AreaSolarRadiationService_typeof(obj); }

function AreaSolarRadiationService_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function AreaSolarRadiationService_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function AreaSolarRadiationService_createClass(Constructor, protoProps, staticProps) { if (protoProps) AreaSolarRadiationService_defineProperties(Constructor.prototype, protoProps); if (staticProps) AreaSolarRadiationService_defineProperties(Constructor, staticProps); return Constructor; }

function AreaSolarRadiationService_possibleConstructorReturn(self, call) { if (call && (AreaSolarRadiationService_typeof(call) === "object" || typeof call === "function")) { return call; } return AreaSolarRadiationService_assertThisInitialized(self); }

function AreaSolarRadiationService_assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function AreaSolarRadiationService_get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { AreaSolarRadiationService_get = Reflect.get; } else { AreaSolarRadiationService_get = function _get(target, property, receiver) { var base = AreaSolarRadiationService_superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return AreaSolarRadiationService_get(target, property, receiver || target); }

function AreaSolarRadiationService_superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = AreaSolarRadiationService_getPrototypeOf(object); if (object === null) break; } return object; }

function AreaSolarRadiationService_getPrototypeOf(o) { AreaSolarRadiationService_getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return AreaSolarRadiationService_getPrototypeOf(o); }

function AreaSolarRadiationService_inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) AreaSolarRadiationService_setPrototypeOf(subClass, superClass); }

function AreaSolarRadiationService_setPrototypeOf(o, p) { AreaSolarRadiationService_setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return AreaSolarRadiationService_setPrototypeOf(o, p); }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/




/**
 * @class SuperMap.AreaSolarRadiationService
 * @category iServer SpatialAnalyst SolarRadiationAnalyst
 * @classdesc 地区太阳辐射服务类。
 * @param {string} url - 服务的访问地址。如：</br>http://localhost:8090/iserver/services/spatialanalyst-sample/restjsr/spatialanalyst。</br>
 * @param {Object} options - 参数。</br>
 * @param {Object} options.eventListeners - 需要被注册的监听器对象。
 * @param {boolean} [options.crossOrigin] - 是否允许跨域请求。
 * @param {Object} [options.headers] - 请求头。
 * @extends {SuperMap.SpatialAnalystBase}
 * @example 例如：
 * (start code)
 * var myAreaSolarRadiationService = new SuperMap.AreaSolarRadiationService(url);
 * myAreaSolarRadiationService.on({
     *     "processCompleted": processCompleted,
     *     "processFailed": processFailed
     *     }
 * );
 * (end)
 *
 */

var AreaSolarRadiationService_AreaSolarRadiationService =
/*#__PURE__*/
function (_SpatialAnalystBase) {
  AreaSolarRadiationService_inherits(AreaSolarRadiationService, _SpatialAnalystBase);

  function AreaSolarRadiationService(url, options) {
    var _this;

    AreaSolarRadiationService_classCallCheck(this, AreaSolarRadiationService);

    _this = AreaSolarRadiationService_possibleConstructorReturn(this, AreaSolarRadiationService_getPrototypeOf(AreaSolarRadiationService).call(this, url, options));
    _this.CLASS_NAME = "SuperMap.AreaSolarRadiationService";
    return _this;
  }
  /**
   * @function SuperMap.AreaSolarRadiationService.prototype.destroy
   * @override
   */


  AreaSolarRadiationService_createClass(AreaSolarRadiationService, [{
    key: "destroy",
    value: function destroy() {
      AreaSolarRadiationService_get(AreaSolarRadiationService_getPrototypeOf(AreaSolarRadiationService.prototype), "destroy", this).call(this);
    }
    /**
     * @function SuperMap.AreaSolarRadiationService.prototype.processAsync
     * @description 负责将客户端的查询参数传递到服务端。
     * @param {SuperMap.AreaSolarRadiationParameters} parameter - 地区太阳辐射参数。
     */

  }, {
    key: "processAsync",
    value: function processAsync(parameter) {
      if (!(parameter instanceof AreaSolarRadiationParameters_AreaSolarRadiationParameters)) {
        return;
      }

      var me = this;
      var end = me.url.substr(me.url.length - 1, 1);

      if (end !== '/') {
        me.url += "/";
      }

      var parameterObject = {};

      if (parameter instanceof AreaSolarRadiationParameters_AreaSolarRadiationParameters) {
        me.url += 'datasets/' + parameter.dataset + '/solarradiation';
      }

      AreaSolarRadiationParameters_AreaSolarRadiationParameters.toObject(parameter, parameterObject);
      var jsonParameters = Util.toJSON(parameterObject);
      me.url += '.json?returnContent=true';
      me.request({
        method: "POST",
        data: jsonParameters,
        scope: me,
        success: me.serviceProcessCompleted,
        failure: me.serviceProcessFailed
      });
    }
  }]);

  return AreaSolarRadiationService;
}(SpatialAnalystBase_SpatialAnalystBase);
SuperMap.AreaSolarRadiationService = AreaSolarRadiationService_AreaSolarRadiationService;
// CONCATENATED MODULE: ./src/common/iServer/BufferDistance.js
function BufferDistance_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function BufferDistance_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function BufferDistance_createClass(Constructor, protoProps, staticProps) { if (protoProps) BufferDistance_defineProperties(Constructor.prototype, protoProps); if (staticProps) BufferDistance_defineProperties(Constructor, staticProps); return Constructor; }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


/**
 * @class SuperMap.BufferDistance
 * @category iServer SpatialAnalyst BufferAnalyst
 * @classdesc 缓冲区分析的缓冲距离类。通过该类可以设置缓冲区分析的缓冲距离，距离可以是数值也可以是数值型的字段表达式。
 * @param {Object} options - 参数。 
 * @param {string} [options.exp] - 以数值型的字段表达式作为缓冲区分析的距离值。 
 * @param {number} [options.value=100] - 以数值作为缓冲区分析的距离值。单位：米。
 */

var BufferDistance_BufferDistance =
/*#__PURE__*/
function () {
  function BufferDistance(options) {
    BufferDistance_classCallCheck(this, BufferDistance);

    /**
     * @member {string} [SuperMap.BufferDistance.prototype.exp]
     * @description 以数值型的字段表达式作为缓冲区分析的距离值。
     */
    this.exp = null;
    /**
     * @member {number} [SuperMap.BufferDistance.prototype.value=100]
     * @description 以数值作为缓冲区分析的距离值。单位：米。
     */

    this.value = 100;
    Util.extend(this, options);
    this.CLASS_NAME = "SuperMap.BufferDistance";
  }
  /**
   * @function SuperMap.BufferDistance.prototype.destroy
   * @description 释放资源，将引用资源的属性置空。
   */


  BufferDistance_createClass(BufferDistance, [{
    key: "destroy",
    value: function destroy() {
      this.exp = null;
      this.value = null;
    }
  }]);

  return BufferDistance;
}();
SuperMap.BufferDistance = BufferDistance_BufferDistance;
// CONCATENATED MODULE: ./src/common/iServer/BufferSetting.js
function BufferSetting_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function BufferSetting_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function BufferSetting_createClass(Constructor, protoProps, staticProps) { if (protoProps) BufferSetting_defineProperties(Constructor.prototype, protoProps); if (staticProps) BufferSetting_defineProperties(Constructor, staticProps); return Constructor; }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/




/**
 * @class SuperMap.BufferSetting
 * @category iServer SpatialAnalyst BufferAnalyst
 * @classdesc 缓冲区分析通用设置类。
 * @param {Object} options - 参数。 
 * @param {SuperMap.BufferEndType} [options.endType=SuperMap.BufferEndType.FLAT] - 缓冲区端点枚举值。 
 * @param {SuperMap.BufferDistance} [options.leftDistance=100] - 左侧缓冲距离。 
 * @param {SuperMap.BufferDistance} [options.rightDistance=100] - 右侧缓冲距离。 
 * @param {number} [options.semicircleLineSegment=4] - 圆头缓冲圆弧处线段的个数。 
 * @param {SuperMap.BufferRadiusUnit} [options.radiusUnit=SuperMap.BufferRadiusUnit.METER] - 缓冲半径单位。
 */

var BufferSetting_BufferSetting =
/*#__PURE__*/
function () {
  function BufferSetting(options) {
    BufferSetting_classCallCheck(this, BufferSetting);

    /**
     * @member {SuperMap.BufferEndType} [SuperMap.BufferSetting.prototype.endType = SuperMap.BufferEndType.FLAT]
     * @description 缓冲区端点枚举值。分为平头和圆头两种。
     */
    this.endType = BufferEndType.FLAT;
    /**
     * @member {SuperMap.BufferDistance} [SuperMap.BufferSetting.prototype.leftDistance=100]
     * @description 左侧缓冲距离。
     * 当为 GeometryBufferAnalyst 时，单位为默认地图的投影系的单位（如3857为米，4326为度），
     * 当为 DatasetBufferAnalyst 时，单位通过{@link BufferSetting.radiusUnit}设置（默认全部为米）。
     */

    this.leftDistance = new BufferDistance_BufferDistance();
    /**
     * @member {SuperMap.BufferDistance} [SuperMap.BufferSetting.prototype.rightDistance=100]
     * @description 右侧缓冲距离。
     * 当为 GeometryBufferAnalyst 时，单位为默认地图的投影系的单位（如3857为米，4326为度），
     * 当为 DatasetBufferAnalyst 时，单位通过{@link BufferSetting.radiusUnit}设置（默认全部为米）。
     */

    this.rightDistance = new BufferDistance_BufferDistance();
    /**
     * @member {number} [SuperMap.BufferSetting.prototype.semicircleLineSegment=4]
     * @description 圆头缓冲圆弧处线段的个数。即用多少个线段来模拟一个半圆。
     */

    this.semicircleLineSegment = 4;
    /**
     * @member {SuperMap.BufferRadiusUnit} [SuperMap.BufferSetting.prototype.radiusUnit = SuperMap.BufferRadiusUnit.METER]
     * @description 缓冲半径单位，可以是{@link SuperMap.BufferRadiusUnit.METER}、{@link SuperMap.BufferRadiusUnit.MILIMETER}、
     * {@link SuperMap.BufferRadiusUnit.CENTIMETER}、{@link SuperMap.BufferRadiusUnit.DECIMETER}、{@link SuperMap.BufferRadiusUnit.KILOMETER}、
     * {@link SuperMap.BufferRadiusUnit.FOOT}、{@link SuperMap.BufferRadiusUnit.INCH}、{@link SuperMap.BufferRadiusUnit.MILE}、{@link SuperMap.BufferRadiusUnit.YARD}。
     * 仅对BufferAnalyst有效。
     */

    this.radiusUnit = BufferRadiusUnit.METER;

    if (options) {
      Util.extend(this, options);
    }

    this.CLASS_NAME = "SuperMap.BufferSetting";
  }
  /**
   * @function SuperMap.BufferSetting.prototype.destroy
   * @description 释放资源，将引用资源的属性置空。
   */


  BufferSetting_createClass(BufferSetting, [{
    key: "destroy",
    value: function destroy() {
      var me = this;
      me.endType = null;

      if (me.leftDistance) {
        me.leftDistance.destroy();
        me.leftDistance = null;
      }

      if (me.rightDistance) {
        me.rightDistance.destroy();
        me.rightDistance = null;
      }

      me.semicircleLineSegment = null;
      me.radiusUnit = null;
    }
  }]);

  return BufferSetting;
}();
SuperMap.BufferSetting = BufferSetting_BufferSetting;
// CONCATENATED MODULE: ./src/common/iServer/BufferAnalystParameters.js
function BufferAnalystParameters_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function BufferAnalystParameters_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function BufferAnalystParameters_createClass(Constructor, protoProps, staticProps) { if (protoProps) BufferAnalystParameters_defineProperties(Constructor.prototype, protoProps); if (staticProps) BufferAnalystParameters_defineProperties(Constructor, staticProps); return Constructor; }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/



/**
 * @class SuperMap.BufferAnalystParameters
 * @category iServer SpatialAnalyst BufferAnalyst
 * @classdesc 缓冲区分析参数基类。
 * @param {Object} options - 参数。 
 * @param {SuperMap.BufferSetting} [options.bufferSetting] - 设置缓冲区通用参数。为缓冲区分析提供必要的参数信息，包括左缓冲距离、右缓冲距离、端点类型、圆头缓冲圆弧处线段的个数信息。
 */

var BufferAnalystParameters_BufferAnalystParameters =
/*#__PURE__*/
function () {
  function BufferAnalystParameters(options) {
    BufferAnalystParameters_classCallCheck(this, BufferAnalystParameters);

    var me = this;
    /**
     * @member {SuperMap.BufferSetting} [SuperMap.BufferAnalystParameters.prototype.bufferSetting]
     * @description 设置缓冲区通用参数。为缓冲区分析提供必要的参数信息，包括左缓冲距离、右缓冲距离、端点类型、圆头缓冲圆弧处线段的个数信息。
     */

    me.bufferSetting = new BufferSetting_BufferSetting();
    Util.extend(this, options);
    this.CLASS_NAME = "SuperMap.BufferAnalystParameters";
  }
  /**
   * @function SuperMap.BufferAnalystParameters.prototype.destroy
   * @description 释放资源，将引用资源的属性置空。
   */


  BufferAnalystParameters_createClass(BufferAnalystParameters, [{
    key: "destroy",
    value: function destroy() {
      var me = this;

      if (me.bufferSetting) {
        me.bufferSetting.destroy();
        me.bufferSetting = null;
      }
    }
  }]);

  return BufferAnalystParameters;
}();
SuperMap.BufferAnalystParameters = BufferAnalystParameters_BufferAnalystParameters;
// CONCATENATED MODULE: ./src/common/iServer/DataReturnOption.js
function DataReturnOption_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function DataReturnOption_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function DataReturnOption_createClass(Constructor, protoProps, staticProps) { if (protoProps) DataReturnOption_defineProperties(Constructor.prototype, protoProps); if (staticProps) DataReturnOption_defineProperties(Constructor, staticProps); return Constructor; }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/



/**
 * @class SuperMap.DataReturnOption
 * @category iServer SpatialAnalyst
 * @classdesc 数据返回设置类。
 * @param {Object} options - 参数。 
 * @param {number} [options.expectCount=1000] - 设置返回的最大记录数，小于或者等于 0 时表示返回所有记录数。 
 * @param {string} [options.dataset] - 设置结果数据集标识，当 dataReturnMode 为 {@link SuperMap.DataReturnMode.DATASET_ONLY}或{@link SuperMap.DataReturnMode.DATASET_AND_RECORDSET}时有效，
 *                                   作为返回数据集的名称。该名称用形如“数据集名称@数据源别名”形式来表示。 
 * @param {SuperMap.DataReturnMode} [options.dataReturnMode=SuperMap.DataReturnMode.RECORDSET_ONLY] - 数据返回模式。 
 * @param {boolean} [options.deleteExistResultDataset=true] - 如果用户命名的结果数据集名称与已有的数据集重名，是否删除已有的数据集。
 */

var DataReturnOption_DataReturnOption =
/*#__PURE__*/
function () {
  function DataReturnOption(options) {
    DataReturnOption_classCallCheck(this, DataReturnOption);

    /**
     * @member {number} [SuperMap.DataReturnOption.prototype.expectCount=1000]
     * @description 设置返回的最大记录数，小于或者等于0时表示返回所有记录数。
     */
    this.expectCount = 1000;
    /**
     * @member {string} [SuperMap.DataReturnOption.prototype.dataset]
     * @description 设置结果数据集标识，当dataReturnMode为 {@link SuperMap.DataReturnMode.DATASET_ONLY}
     * 或{@link SuperMap.DataReturnMode.DATASET_AND_RECORDSET}时有效，
     * 作为返回数据集的名称。该名称用形如"数据集名称@数据源别名"形式来表示。
     */

    this.dataset = null;
    /**
     * @member {SuperMap.DataReturnMode} [SuperMap.DataReturnOption.prototype.dataReturnMode=SuperMap.DataReturnMode.RECORDSET_ONLY]
     * @description 数据返回模式。
     */

    this.dataReturnMode = DataReturnMode.RECORDSET_ONLY;
    /**
     * @member {boolean} [SuperMap.DataReturnOption.prototype.deleteExistResultDataset=true]
     * @description 如果用户命名的结果数据集名称与已有的数据集重名，是否删除已有的数据集。
     */

    this.deleteExistResultDataset = true;
    Util.extend(this, options);
    this.CLASS_NAME = "SuperMap.DataReturnOption";
  }
  /**
   * @function SuperMap.DataReturnOption.prototype.destroy
   * @description 释放资源，将引用资源的属性置空。
   */


  DataReturnOption_createClass(DataReturnOption, [{
    key: "destroy",
    value: function destroy() {
      var me = this;
      me.expectCount = null;
      me.dataset = null;
      me.dataReturnMode = null;
      me.deleteExistResultDataset = null;
    }
  }]);

  return DataReturnOption;
}();
SuperMap.DataReturnOption = DataReturnOption_DataReturnOption;
// CONCATENATED MODULE: ./src/common/iServer/JoinItem.js
function JoinItem_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function JoinItem_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function JoinItem_createClass(Constructor, protoProps, staticProps) { if (protoProps) JoinItem_defineProperties(Constructor.prototype, protoProps); if (staticProps) JoinItem_defineProperties(Constructor, staticProps); return Constructor; }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


/**
 * @class SuperMap.JoinItem
 * @category iServer
 * @classdesc 连接信息类。
 * 该类用于矢量数据集与外部表的连接。外部表可以为另一个矢量数据集（其中纯属性数据集中没有空间几何信息）所对应的 DBMS 表，也可以是用户自建的业务表。
 * 需要注意的是，矢量数据集与外部表必须属于同一数据源。表之间的联系的建立有两种方式，一种是连接（join），一种是关联（link）。
 * 连接，实际上是依据相同的字段将一个外部表追加到指定的表；而关联是基于一个相同的字段定义了两个表格之间的联系，但不是实际的追加。
 * 用于连接两个表的字段的名称不一定相同，但类型必须一致。当两个表格之间建立了连接，通过对主表进行操作，可以对外部表进行查询，制作专题图以及分析等。
 * 当两个表格之间是一对一或多对一的关系时，可以使用 join 连接。当为多对一的关系时，允许指定多个字段之间的关联。
 *（注意：SuperMap.JoinItem 目前支持左连接和内连接，不支持全连接和右连接，UDB 引擎不支持内连接。并且用于建立连接的两个表必须在同一个数据源下。)
 * @param {Object} options - 参数。 
 * @param {string} options.foreignTableName - 外部表的名称。 
 * @param {string} options.joinFilter - 矢量数据集与外部表之间的连接表达式，即设定两个表之间关联的字段。 
 * @param {SuperMap.JoinType} options.joinType - 两个表之间连接类型。 
 * @example 下面以 SQL 查询说明 joinItem 的使用方法：
 *(start code)
 *   function queryBySQL() {
     *       // 设置与外部表的连接信息
     *       var joinItem = new SuperMap.JoinItem({
     *           foreignTableName: "foreignTable",
     *           joinFilter: "foreignTable.CONTINENT = Countries.CONTINENT",
     *           joinType: "LEFTJOIN"
     *       })
     *       var queryParam, queryBySQLParams, queryBySQLService;
     *       // 设置查询参数，在查询参数中添加joinItem关联条件信息
     *       queryParam = new SuperMap.FilterParameter({
     *            name: "Countries@World",
     *            joinItems: [joinItem]
     *         }),
     *       queryBySQLParams = new SuperMap.QueryBySQLParameters({
     *             queryParams: [queryParam]
     *         }),
     *       queryBySQLService = new SuperMap.QueryBySQLService(url, {
     *             eventListeners: { "processCompleted": processCompleted, "processFailed": processFailed}
     *         });
     *       queryBySQLService.processAsync(queryBySQLParams);
     *  }
 *  function processCompleted(queryEventArgs) {//todo}
 *  function processFailed(e) {//todo}
 * (end)
 */

var JoinItem_JoinItem =
/*#__PURE__*/
function () {
  function JoinItem(options) {
    JoinItem_classCallCheck(this, JoinItem);

    /**
     * @member {string} SuperMap.JoinItem.prototype.foreignTableName
     * @description 外部表的名称。
     * 如果外部表的名称是以 “表名@数据源名” 命名方式，则该属性只需赋值表名。
     * 例如：外部表 Name@changchun，Name 为表名，changchun 为数据源名称，则该属性的赋值应为：Name。
     */
    this.foreignTableName = null;
    /**
     * @member {string} SuperMap.JoinItem.prototype.joinFilter
     * @description 矢量数据集与外部表之间的连接表达式，即设定两个表之间关联的字段。
     * 例如，将房屋面数据集（Building）的 district 字段与房屋拥有者的纯属性数据集（Owner）的 region 字段相连接，
     * 两个数据集对应的表名称分别为 Table_Building 和 Table_Owner，
     * 则连接表达式为 Table_Building.district = Table_Owner.region。
     * 当有多个字段相连接时，用 AND 将多个表达式相连。
     */

    this.joinFilter = null;
    /**
     * @member {SuperMap.JoinType} SuperMap.JoinItem.prototype.joinType
     * @description 两个表之间连接类型。
     * 连接类型决定了对两个表进行连接查询后返回的记录的情况。
     */

    this.joinType = null;

    if (options) {
      Util.extend(this, options);
    }

    this.CLASS_NAME = "SuperMap.JoinItem";
  }
  /**
   * @function SuperMap.JoinItem.prototype.destroy
   * @description 释放资源，将引用资源的属性置空。
   */


  JoinItem_createClass(JoinItem, [{
    key: "destroy",
    value: function destroy() {
      var me = this;
      me.foreignTableName = null;
      me.joinFilter = null;
      me.joinType = null;
    }
    /**
     * @function SuperMap.JoinItem.prototype.toServerJSONObject
     * @description 转换成对应的 JSON 格式对象。
     */

  }, {
    key: "toServerJSONObject",
    value: function toServerJSONObject() {
      var dataObj = {};
      dataObj = Util.copyAttributes(dataObj, this); //joinFilter基本是个纯属性对象，这里不再做转换

      return dataObj;
    }
  }]);

  return JoinItem;
}();
SuperMap.JoinItem = JoinItem_JoinItem;
// CONCATENATED MODULE: ./src/common/iServer/DatasourceConnectionInfo.js
function DatasourceConnectionInfo_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function DatasourceConnectionInfo_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function DatasourceConnectionInfo_createClass(Constructor, protoProps, staticProps) { if (protoProps) DatasourceConnectionInfo_defineProperties(Constructor.prototype, protoProps); if (staticProps) DatasourceConnectionInfo_defineProperties(Constructor, staticProps); return Constructor; }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


 // eslint-disable-line no-unused-vars

/**
 * @class SuperMap.DatasourceConnectionInfo
 * @category  iServer Data
 * @classdesc 数据源连接信息类。该类包括了进行数据源连接的所有信息，如所要连接的服务器名称、数据库名称、用户名以及密码等。
 *            当保存为工作空间时， 工作空间中的数据源的连接信息都将存储到工作空间文件中。对于不同类型的数据源，其连接信息有所区别。
 *            所以在使 用该类所包含的成员时，请注意该成员所适用的数据源类型。对于从数据源对象中返回的数据连接信息对象，只有 connect 方法可以被修改，
 *            其他内容是不可以被修改的。对于用户创建的数据源连接信息对象，其内容都可以修改。
 * @category iServer Data
 * @param {Object} options - 参数。 
 * @param {string} options.alias - 数据源别名。 
 * @param {string} options.dataBase - 数据源连接的数据库名。 
 * @param {boolean} [options.connect] - 数据源是否自动连接数据。 
 * @param {string} [options.driver] - 使用 ODBC(Open Database Connectivity，开放数据库互连)的数据库的驱动程序名。 
 * @param {SuperMap.EngineType} [options.engineType] - 数据源连接的引擎类型。 
 * @param {boolean} [options.exclusive] - 是否以独占方式打开数据源。 
 * @param {boolean} [options.OpenLinkTable] - 是否把数据库中的其他非 SuperMap 数据表作为 LinkTable 打开。 
 * @param {string} [options.password] - 登录数据源连接的数据库或文件的密码。 
 * @param {boolean} [options.readOnly] - 是否以只读方式打开数据源。 
 * @param {string} [options.server] - 数据库服务器名或 SDB 文件名。 
 * @param {string} [options.user] - 登录数据库的用户名。 
 */

var DatasourceConnectionInfo_DatasourceConnectionInfo =
/*#__PURE__*/
function () {
  function DatasourceConnectionInfo(options) {
    DatasourceConnectionInfo_classCallCheck(this, DatasourceConnectionInfo);

    /**
     * @member {string} SuperMap.DatasourceConnectionInfo.prototype.alias
     * @description 数据源别名。
     */
    this.alias = null;
    /**
     * @member {boolean} [SuperMap.DatasourceConnectionInfo.prototype.connect]
     * @description 数据源是否自动连接数据。
     */

    this.connect = null;
    /**
     * @member {string} SuperMap.DatasourceConnectionInfo.prototype.dataBase
     * @description 数据源连接的数据库名。
     */

    this.dataBase = null;
    /**
     * @member {string} [SuperMap.DatasourceConnectionInfo.prototype.driver]
     * @description 使用 ODBC(Open Database Connectivity，开放数据库互连) 的数据库的驱动程序名。
     * 其中，对于 SQL Server 数据库与 iServer 发布的 WMTS 服务，此为必设参数。
     * 对于 SQL Server 数据库，它使用 ODBC 连接，所设置的驱动程序名为 "SQL Server" 或 "SQL Native Client"；
     * 对于 iServer 发布的 WMTS 服务，设置的驱动名称为 "WMTS"。
     */

    this.driver = null;
    /**
     * @member {SuperMap.EngineType} [SuperMap.DatasourceConnectionInfo.prototype.engineType]
     * @description 数据源连接的引擎类型。
     */

    this.engineType = null;
    /**
     * @member {boolean} [SuperMap.DatasourceConnectionInfo.prototype.exclusive]
     * @description 是否以独占方式打开数据源。
     */

    this.exclusive = null;
    /**
     * @member {boolean} [SuperMap.DatasourceConnectionInfo.prototype.OpenLinkTable]
     * @description 是否把数据库中的其他非 SuperMap 数据表作为 LinkTable 打开。
     */

    this.OpenLinkTable = null;
    /**
     * @member {string} [SuperMap.DatasourceConnectionInfo.prototype.password]
     * @description 登录数据源连接的数据库或文件的密码。
     */

    this.password = null;
    /**
     * @member {boolean} [SuperMap.DatasourceConnectionInfo.prototype.readOnly]
     * @description 是否以只读方式打开数据源。
     */

    this.readOnly = null;
    /**
     * @member {string} [SuperMap.DatasourceConnectionInfo.prototype.server]
     * @description 数据库服务器名、文件名或服务地址。
     * 1.对于 SDB 和 UDB 文件，为其文件的绝对路径。注意：当绝对路径的长度超过 UTF-8 编码格式的 260 字节长度，该数据源无法打开。
     * 2.对于 Oracle 数据库，其服务器名为其 TNS 服务名称。
     * 3.对于 SQL Server 数据库，其服务器名为其系统的 DSN(Database Source Name) 名称。
     * 4.对于 PostgreSQL 数据库，其服务器名为 “IP:端口号”，默认的端口号是 5432。
     * 5.对于 DB2 数据库，已经进行了编目，所以不需要进行服务器的设置。
     * 6.对于 Kingbase 数据库，其服务器名为其 IP 地址。
     * 7.对于 GoogleMaps 数据源，其服务器地址，默认设置为 “{@link http://maps.google.com}”，且不可更改。
     * 8.对于 SuperMapCould 数据源，为其服务地址。
     * 9.对于 MAPWORLD 数据源，为其服务地址，默认设置为 “{@link http://www.tianditu.cn}”，且不可更改。
     * 10.对于 OGC 和 REST 数据源，为其服务地址。
     */

    this.server = null;
    /**
     * @member {string} SuperMap.DatasourceConnectionInfo.prototype.user
     * @description 登录数据库的用户名。
     */

    this.user = null;

    if (options) {
      Util.extend(this, options);
    }

    this.CLASS_NAME = "SuperMap.DatasourceConnectionInfo";
  }
  /**
   * @function SuperMap.DatasourceConnectionInfo.prototype.destroy
   * @description 释放资源，将引用资源的属性置空。
   */


  DatasourceConnectionInfo_createClass(DatasourceConnectionInfo, [{
    key: "destroy",
    value: function destroy() {
      var me = this;
      me.alias = null;
      me.connect = null;
      me.dataBase = null;
      me.driver = null;
      me.engineType = null;
      me.exclusive = null;
      me.OpenLinkTable = null;
      me.password = null;
      me.readOnly = null;
      me.server = null;
      me.user = null;
    }
  }]);

  return DatasourceConnectionInfo;
}();
SuperMap.DatasourceConnectionInfo = DatasourceConnectionInfo_DatasourceConnectionInfo;
// CONCATENATED MODULE: ./src/common/iServer/LinkItem.js
function LinkItem_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function LinkItem_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function LinkItem_createClass(Constructor, protoProps, staticProps) { if (protoProps) LinkItem_defineProperties(Constructor.prototype, protoProps); if (staticProps) LinkItem_defineProperties(Constructor, staticProps); return Constructor; }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/



/**
 * @class SuperMap.LinkItem
 * @constructs SuperMap.LinkItem
 * @category iServer
 * @classdesc 关联信息类。
 * @description 该类用于矢量数据集与外部表的关联。 外部表是另一个数据集（其中纯属性数据集中没有空间几何信息）中的 DBMS 表,
 *              矢量数据集与外部表可以属于不同的数据源，但数据源类型目前只支持 SQL Server 和 Oracle 类型。使用 LinkItem 时，
 *              空间数据和属性数据必须满足关联条件，即主空间数据集与外部属性表之间存在关联字段。{@link SuperMap.LinkItem}
 *              只支持左连接，UDB、PostgreSQL 和 DB2 数据源不支持 {@link SuperMap.LinkItem}；另外，用于建立关联关系的两个表可以不在同一个数据源下。注意：<br>
 * 1. 使用 {@link SuperMap.LinkItem} 的约束条件为：空间数据和属性数据必须有关联条件，即主空间数据集与外部属性表之间存在关联字段；<br>
 * 2. 使用外关联表制作专题图时，所关联的字段必须设置表名，例如，如果所关联的字段为 BaseMap_R 数据集的 SmID，就要写成 BaseMap_R.SMID。
 * @param {Object} options - 参数。
 * @param {SuperMap.DatasourceConnectionInfo} options.datasourceConnectionInfo - 关联的外部数据源信息。
 * @param {Array.<string>} options.foreignKeys - 主空间数据集的外键。
 * @param {string} options.foreignTable - 关联的外部属性表的名称。
 * @param {Array.<string>} options.linkFields - 欲保留的外部属性表的字段。
 * @param {string} options.linkFilter - 与外部属性表的连接条件。
 * @param {string} options.name - 此关联信息对象的名称。
 * @param {Array.<string>} options.primaryKeys - 需要关联的外部属性表的主键。
 * @example 下面以 SQL 查询说明 linkitem 的使用方法：
 *  function queryBySQL() {
 *      // 设置关联的外部数据库信息,alias表示数据库别名
 *      var dc = new SuperMap.DatasourceConnectionInfo({
 *          dataBase: "RelQuery",
 *          server: "{ip}:{port}",
 *          user: "sa",
 *          password: "map",
 *          driver: "SQL Server",
 *          connect: true,
 *          OpenLinkTable: false,
 *          alias: "RelQuery",
 *          engineType: EngineType.SQLPLUS,
 *          readOnly: false,
 *          exclusive: false
 *      });
 *     // 设置关联信息
 *      var linkItem = new SuperMap.LinkItem({
 *          datasourceConnectionInfo: dc,
 *          foreignKeys: ["name"],
 *          foreignTable: "Pop_2011",
 *          linkFields: ["SmID as Pid","pop"],
 *          name: "link",
 *          primatryKeys: ["name"],
 *      });
 *      // 设置查询参数，在查询参数中添加linkItem关联条件信息
 *      var queryParam, queryBySQLParams, queryBySQLService;
 *      queryParam = new SuperMap.FilterParameter({
 *          name: "Province@RelQuery",
 *          fields: ["SmID","name"],
 *          attributeFilter: "SmID<7",
 *          linkItems: [linkItem]
 *       }),
 *      queryBySQLParams = new SuperMap.QueryBySQLParameters({
 *           queryParams: [queryParam]
 *              }),
 *      queryBySQLService = new SuperMap.QueryBySQLService(url, {
     *          eventListeners: {
     *              "processCompleted": processCompleted,
     *              "processFailed": processFailed
     *              }
     *      });
     *      queryBySQLService.processAsync(queryBySQLParams);
     *  }
 *  function processCompleted(queryEventArgs) {//todo}
 *  function processFailed(e) {//todo}
 *
 */

var LinkItem_LinkItem =
/*#__PURE__*/
function () {
  function LinkItem(options) {
    LinkItem_classCallCheck(this, LinkItem);

    /**
     * @member {SuperMap.DatasourceConnectionInfo} SuperMap.LinkItem.prototype.datasourceConnectionInfo
     * @description 关联的外部数据源信息。
     */
    this.datasourceConnectionInfo = null;
    /**
     * @member {Array.<string>} SuperMap.LinkItem.prototype.foreignKeys
     * @description 主空间数据集的外键。
     */

    this.foreignKeys = null;
    /**
     * @member {string} SuperMap.LinkItem.prototype.foreignTable
     * @description 关联的外部属性表的名称，目前仅支持 Supermap 管理的表，即另一个矢量数据集所对应的 DBMS 表。
     */

    this.foreignTable = null;
    /**
     * @member {Array.<string>} SuperMap.LinkItem.prototype.linkFields
     * @description 欲保留的外部属性表的字段。如果不设置字段或者设置的字段在外部属性表中不存在的话则不返
     * 回任何外部属性表的属性信息。如果欲保留的外部表字段与主表字段存在同名，则还需要指定一个不存在字段名作为外部表的字段别名。
     */

    this.linkFields = null;
    /**
     * @member {string} SuperMap.LinkItem.prototype.linkFilter
     * @description 与外部属性表的连接条件。
     */

    this.linkFilter = null;
    /**
     * @member {string} SuperMap.LinkItem.prototype.name
     * @description 此关联信息对象的名称。
     */

    this.name = null;
    /**
     * @member {Array.<string>} SuperMap.LinkItem.prototype.primaryKeys
     * @description 需要关联的外部属性表的主键。
     */

    this.primaryKeys = null;

    if (options) {
      Util.extend(this, options);
    }

    this.CLASS_NAME = "SuperMap.LinkItem";
  }
  /**
   * @function SuperMap.LinkItem.prototype.destroy
   * @description 释放资源，将引用资源的属性置空。
   */


  LinkItem_createClass(LinkItem, [{
    key: "destroy",
    value: function destroy() {
      var me = this;

      if (me.datasourceConnectionInfo instanceof DatasourceConnectionInfo_DatasourceConnectionInfo) {
        me.datasourceConnectionInfo.destroy();
        me.datasourceConnectionInfo = null;
      }

      me.foreignKeys = null;
      me.foreignTable = null;
      me.linkFields = null;
      me.linkFilter = null;
      me.name = null;
      me.primaryKeys = null;
    }
  }]);

  return LinkItem;
}();
SuperMap.LinkItem = LinkItem_LinkItem;
// CONCATENATED MODULE: ./src/common/iServer/FilterParameter.js
function FilterParameter_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function FilterParameter_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function FilterParameter_createClass(Constructor, protoProps, staticProps) { if (protoProps) FilterParameter_defineProperties(Constructor.prototype, protoProps); if (staticProps) FilterParameter_defineProperties(Constructor, staticProps); return Constructor; }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/




/**
 * @class SuperMap.FilterParameter
 * @category iServer
 * @classdesc 查询过滤条件参数类。该类用于设置查询数据集的查询过滤参数。
 * @param {Object} options - 参数。 
 * @param {string} options.attributeFilter - 属性过滤条件。 
 * @param {string} options.name - 查询数据集名称或者图层名称。 
 * @param {Array.<SuperMap.JoinItem>} [options.joinItems] - 与外部表的连接信息 SuperMap.JoinItem 数组。 
 * @param {Array.<SuperMap.LinkItem>} [options.linkItems] - 与外部表的关联信息 SuperMap.LinkItem 数组。 
 * @param {Array.<string>} [options.ids] - 查询 id 数组，即属性表中的 SmID 值。 
 * @param {string} [options.orderBy] - 查询排序的字段，orderBy 的字段须为数值型的。 
 * @param {string} [options.groupBy] - 查询分组条件的字段。 
 * @param {Array.<string>} [options.fields] - 查询字段数组。 
 */

var FilterParameter_FilterParameter =
/*#__PURE__*/
function () {
  function FilterParameter(options) {
    FilterParameter_classCallCheck(this, FilterParameter);

    /**
     * @member {string} SuperMap.FilterParameter.prototype.attributeFilter
     * @description 属性过滤条件。
     * 相当于 SQL 语句中的 WHERE 子句，其格式为：WHERE <条件表达式>，
     * attributeFilter 就是其中的“条件表达式”。
     * 该字段的用法为 attributeFilter = "过滤条件"。
     * 例如，要查询字段 fieldValue 小于100的记录，设置 attributeFilter = "fieldValue < 100"；
     * 要查询字段 name 的值为“酒店”的记录，设置 attributeFilter = "name like '%酒店%'"，等等。
     */
    this.attributeFilter = null;
    /**
     * @member {string} SuperMap.FilterParameter.prototype.name
     * @description 查询数据集名称或者图层名称，根据实际的查询对象而定。
     * 一般情况下该字段为数据集名称，但在进行与地图相关功能的操作时，
     * 需要设置为图层名称（图层名称格式：数据集名称@数据源别名）。
     * 因为一个地图的图层可能是来自于不同数据源的数据集，
     * 而不同的数据源中可能存在同名的数据集，
     * 使用数据集名称不能唯一的确定数据集，
     * 所以在进行与地图相关功能的操作时，该值需要设置为图层名称。
     */

    this.name = null;
    /**
     * @member {Array.<SuperMap.JoinItem>} [SuperMap.FilterParameter.prototype.joinItems]
     * @description 与外部表的连接信息 SuperMap.JoinItem 数组。
     */

    this.joinItems = null;
    /**
     * @member {Array.<SuperMap.LinkItem>} [SuperMap.FilterParameter.prototype.linkItems]
     * @description 与外部表的关联信息 LinkItem 数组。
     */

    this.linkItems = null;
    /**
     * @member {Array.<string>} [SuperMap.FilterParameter.prototype.ids]
     * @description 查询 id 数组，即属性表中的 SmID 值。
     */

    this.ids = null;
    /**
     * @member {string} [SuperMap.FilterParameter.prototype.orderBy]
     * @description 查询排序的字段，orderBy的字段须为数值型的。
     * 相当于 SQL 语句中的 ORDER BY 子句，其格式为：ORDER BY <列名>，
     * 列名即属性表中每一列的名称，列又可称为属性，在 SuperMap 中又称为字段。
     * 对单个字段排序时，该字段的用法为 orderBy = "字段名"；
     * 对多个字段排序时，字段之间以英文逗号进行分割，用法为 orderBy = "字段名1, 字段名2"。
     * 例如，现有一个国家数据集，它有两个字段分别为“SmArea”和“pop_1994”，
     * 分别表示国家的面积和1994年的各国人口数量。
     * 如果要按照各国人口数量对记录进行排序，则 orderBy = "pop_1994"；
     * 如果要以面积和人口进行排序，则 orderBy = "SmArea, pop_1994"。
     */

    this.orderBy = null;
    /**
     * @member {string} [SuperMap.FilterParameter.prototype.groupBy]
     * @description 查询分组条件的字段。
     * 相当于 SQL 语句中的 GROUP BY 子句，其格式为：GROUP BY <列名>，
     * 列名即属性表中每一列的名称，列又可称为属性，在 SuperMap 中又称为字段。
     * 对单个字段分组时，该字段的用法为 groupBy = "字段名"；
     * 对多个字段分组时，字段之间以英文逗号进行分割，用法为 groupBy = "字段名1, 字段名2"。
     * 例如，现有一个全球城市数据集，该数据集有两个字段分别为“Continent”和“Country”，
     * 分别表示某个城市所属的洲和国家。
     * 如果要按照国家对全球的城市进行分组， 可以设置 groupBy = "Country"；
     * 如果以洲和国家对城市进行分组，设置 groupBy = "Continent, Country"。
     */

    this.groupBy = null;
    /**
     * @member {Array.<string>} [SuperMap.FilterParameter.prototype.fields]
     * @description 查询字段数组，如果不设置则使用系统返回的所有字段。
     */

    this.fields = null;

    if (options) {
      Util.extend(this, options);
    }

    this.CLASS_NAME = "SuperMap.FilterParameter";
  }
  /**
   * @function SuperMap.FilterParameter.prototype.destroy
   * @description 释放资源，将引用资源的属性置空。
   */


  FilterParameter_createClass(FilterParameter, [{
    key: "destroy",
    value: function destroy() {
      var me = this;
      me.attributeFilter = null;
      me.name = null;

      if (me.joinItems) {
        for (var i = 0, joinItems = me.joinItems, len = joinItems.length; i < len; i++) {
          joinItems[i].destroy();
        }

        me.joinItems = null;
      }

      if (me.linkItems) {
        for (var _i = 0, linkItems = me.linkItems, _len = linkItems.length; _i < _len; _i++) {
          linkItems[_i].destroy();
        }

        me.linkItems = null;
      }

      me.ids = null;
      me.orderBy = null;
      me.groupBy = null;
      me.fields = null;
    }
  }]);

  return FilterParameter;
}();
SuperMap.FilterParameter = FilterParameter_FilterParameter;
// CONCATENATED MODULE: ./src/common/iServer/DatasetBufferAnalystParameters.js
function DatasetBufferAnalystParameters_typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { DatasetBufferAnalystParameters_typeof = function _typeof(obj) { return typeof obj; }; } else { DatasetBufferAnalystParameters_typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return DatasetBufferAnalystParameters_typeof(obj); }

function DatasetBufferAnalystParameters_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function DatasetBufferAnalystParameters_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function DatasetBufferAnalystParameters_createClass(Constructor, protoProps, staticProps) { if (protoProps) DatasetBufferAnalystParameters_defineProperties(Constructor.prototype, protoProps); if (staticProps) DatasetBufferAnalystParameters_defineProperties(Constructor, staticProps); return Constructor; }

function DatasetBufferAnalystParameters_possibleConstructorReturn(self, call) { if (call && (DatasetBufferAnalystParameters_typeof(call) === "object" || typeof call === "function")) { return call; } return DatasetBufferAnalystParameters_assertThisInitialized(self); }

function DatasetBufferAnalystParameters_assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function DatasetBufferAnalystParameters_get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { DatasetBufferAnalystParameters_get = Reflect.get; } else { DatasetBufferAnalystParameters_get = function _get(target, property, receiver) { var base = DatasetBufferAnalystParameters_superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return DatasetBufferAnalystParameters_get(target, property, receiver || target); }

function DatasetBufferAnalystParameters_superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = DatasetBufferAnalystParameters_getPrototypeOf(object); if (object === null) break; } return object; }

function DatasetBufferAnalystParameters_getPrototypeOf(o) { DatasetBufferAnalystParameters_getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return DatasetBufferAnalystParameters_getPrototypeOf(o); }

function DatasetBufferAnalystParameters_inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) DatasetBufferAnalystParameters_setPrototypeOf(subClass, superClass); }

function DatasetBufferAnalystParameters_setPrototypeOf(o, p) { DatasetBufferAnalystParameters_setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return DatasetBufferAnalystParameters_setPrototypeOf(o, p); }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/





/**
 * @class SuperMap.DatasetBufferAnalystParameters
 * @category iServer SpatialAnalyst BufferAnalyst
 * @classdesc 数据集缓冲区分析参数类。
 * @param {Object} options - 参数。 
 * @param {string} options.dataset - 要用来做缓冲区分析的数据源中数据集的名称。该名称用形如“数据集名称@数据源别名”形式来表示。 
 * @param {SuperMap.FilterParameter} [options.filterQueryParameter] - 设置数据集中几何对象的过滤条件。只有满足此条件的几何对象才参与缓冲区分析。 
 * @param {SuperMap.DataReturnOption} [options.resultSetting] - 结果返回设置类。 
 * @param {boolean} [options.isAttributeRetained=true] - 是否保留进行缓冲区分析的对象的字段属性。当 isUnion 字段为 false 时该字段有效。 
 * @param {boolean} [options.isUnion=false] - 是否将缓冲区与源记录集中的对象合并后返回。对于面对象而言，要求源数据集中的面对象不相交。 
 * @param {SuperMap.BufferSetting} [options.bufferSetting] - 设置缓冲区通用参数。 
 *
 * @extends {SuperMap.BufferAnalystParameters}
 */

var DatasetBufferAnalystParameters_DatasetBufferAnalystParameters =
/*#__PURE__*/
function (_BufferAnalystParamet) {
  DatasetBufferAnalystParameters_inherits(DatasetBufferAnalystParameters, _BufferAnalystParamet);

  function DatasetBufferAnalystParameters(options) {
    var _this;

    DatasetBufferAnalystParameters_classCallCheck(this, DatasetBufferAnalystParameters);

    _this = DatasetBufferAnalystParameters_possibleConstructorReturn(this, DatasetBufferAnalystParameters_getPrototypeOf(DatasetBufferAnalystParameters).call(this, options));
    /**
     * @member {string} SuperMap.DatasetBufferAnalystParameters.prototype.dataset
     * @description 要用来做缓冲区分析的数据源中数据集的名称。该名称用形如“数据集名称@数据源别名”形式来表示。
     */

    _this.dataset = null;
    /**
     *  @member {SuperMap.FilterParameter} [SuperMap.DatasetBufferAnalystParameters.prototype.filterQueryParameter]
     *  @description 设置数据集中几何对象的过滤条件。只有满足此条件的几何对象才参与缓冲区分析。
     */

    _this.filterQueryParameter = new FilterParameter_FilterParameter();
    /**
     * @member {SuperMap.DataReturnOption} [SuperMap.DatasetBufferAnalystParameters.prototype.resultSetting]
     * @description 结果返回设置类。
     */

    _this.resultSetting = new DataReturnOption_DataReturnOption();
    /**
     * @member {boolean} [SuperMap.DatasetBufferAnalystParameters.prototype.isAttributeRetained=true]
     * @description 是否保留进行缓冲区分析的对象的字段属性。当 isUnion 字段为 false 时该字段有效。
     */

    _this.isAttributeRetained = true;
    /**
     * @member {boolean} [SuperMap.DatasetBufferAnalystParameters.prototype.isUnion=false]
     * @description 是否将缓冲区与源记录集中的对象合并后返回。对于面对象而言，要求源数据集中的面对象不相交。
     */

    _this.isUnion = false;
    Util.extend(DatasetBufferAnalystParameters_assertThisInitialized(_this), options);
    _this.CLASS_NAME = "SuperMap.DatasetBufferAnalystParameters";
    return _this;
  }
  /**
   * @function SuperMap.DatasetBufferAnalystParameters.prototype.destroy
   * @override
   */


  DatasetBufferAnalystParameters_createClass(DatasetBufferAnalystParameters, [{
    key: "destroy",
    value: function destroy() {
      DatasetBufferAnalystParameters_get(DatasetBufferAnalystParameters_getPrototypeOf(DatasetBufferAnalystParameters.prototype), "destroy", this).call(this);

      var me = this;
      me.dataset = null;

      if (me.filterQueryParameter) {
        me.filterQueryParameter.destroy();
        me.filterQueryParameter = null;
      }

      if (me.resultSetting) {
        me.resultSetting.destroy();
        me.resultSetting = null;
      }

      me.isAttributeRetained = null;
      me.isUnion = null;
    }
    /**
     * @function SuperMap.DatasetBufferAnalystParameters.toObject
     * @param {SuperMap.DatasetBufferAnalystParameters} datasetBufferAnalystParameters - 数据集缓冲区分析参数类。
     * @param {SuperMap.DatasetBufferAnalystParameters} tempObj - 数据集缓冲区分析参数对象。
     * @description 将数据集缓冲区分析参数对象转换为 JSON 对象。
     * @returns {Object} JSON 对象。
     */

  }], [{
    key: "toObject",
    value: function toObject(datasetBufferAnalystParameters, tempObj) {
      for (var name in datasetBufferAnalystParameters) {
        if (name === "bufferSetting") {
          datasetBufferAnalystParameters.bufferSetting.radiusUnit = datasetBufferAnalystParameters.bufferSetting.radiusUnit.toUpperCase();
          tempObj.bufferAnalystParameter = datasetBufferAnalystParameters.bufferSetting;
        } else if (name === "resultSetting") {
          tempObj.dataReturnOption = datasetBufferAnalystParameters.resultSetting;
        } else if (name === "dataset") {
          continue;
        } else {
          tempObj[name] = datasetBufferAnalystParameters[name];
        }
      }
    }
  }]);

  return DatasetBufferAnalystParameters;
}(BufferAnalystParameters_BufferAnalystParameters);
SuperMap.DatasetBufferAnalystParameters = DatasetBufferAnalystParameters_DatasetBufferAnalystParameters;
// CONCATENATED MODULE: ./src/common/iServer/GeometryBufferAnalystParameters.js
function GeometryBufferAnalystParameters_typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { GeometryBufferAnalystParameters_typeof = function _typeof(obj) { return typeof obj; }; } else { GeometryBufferAnalystParameters_typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return GeometryBufferAnalystParameters_typeof(obj); }

function GeometryBufferAnalystParameters_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function GeometryBufferAnalystParameters_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function GeometryBufferAnalystParameters_createClass(Constructor, protoProps, staticProps) { if (protoProps) GeometryBufferAnalystParameters_defineProperties(Constructor.prototype, protoProps); if (staticProps) GeometryBufferAnalystParameters_defineProperties(Constructor, staticProps); return Constructor; }

function GeometryBufferAnalystParameters_possibleConstructorReturn(self, call) { if (call && (GeometryBufferAnalystParameters_typeof(call) === "object" || typeof call === "function")) { return call; } return GeometryBufferAnalystParameters_assertThisInitialized(self); }

function GeometryBufferAnalystParameters_assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function GeometryBufferAnalystParameters_get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { GeometryBufferAnalystParameters_get = Reflect.get; } else { GeometryBufferAnalystParameters_get = function _get(target, property, receiver) { var base = GeometryBufferAnalystParameters_superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return GeometryBufferAnalystParameters_get(target, property, receiver || target); }

function GeometryBufferAnalystParameters_superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = GeometryBufferAnalystParameters_getPrototypeOf(object); if (object === null) break; } return object; }

function GeometryBufferAnalystParameters_getPrototypeOf(o) { GeometryBufferAnalystParameters_getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return GeometryBufferAnalystParameters_getPrototypeOf(o); }

function GeometryBufferAnalystParameters_inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) GeometryBufferAnalystParameters_setPrototypeOf(subClass, superClass); }

function GeometryBufferAnalystParameters_setPrototypeOf(o, p) { GeometryBufferAnalystParameters_setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return GeometryBufferAnalystParameters_setPrototypeOf(o, p); }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/




/**
 * @class SuperMap.GeometryBufferAnalystParameters
 * @category  iServer SpatialAnalyst BufferAnalyst
 * @classdesc 几何对象缓冲区分析参数类
 * 对指定的某个几何对象做缓冲区分析。通过该类可以指定要做缓冲区分析的几何对象、缓冲区参数等。
 * @param {Object} options - 参数。 
 * @param {Object} options.sourceGeometry - 要做缓冲区分析的几何对象。</br>
 * @param {SuperMap.BufferSetting} [options.bufferSetting] - 设置缓冲区通用参数。
 * @extends {SuperMap.BufferAnalystParameters}
 */

var GeometryBufferAnalystParameters_GeometryBufferAnalystParameters =
/*#__PURE__*/
function (_BufferAnalystParamet) {
  GeometryBufferAnalystParameters_inherits(GeometryBufferAnalystParameters, _BufferAnalystParamet);

  function GeometryBufferAnalystParameters(options) {
    var _this;

    GeometryBufferAnalystParameters_classCallCheck(this, GeometryBufferAnalystParameters);

    _this = GeometryBufferAnalystParameters_possibleConstructorReturn(this, GeometryBufferAnalystParameters_getPrototypeOf(GeometryBufferAnalystParameters).call(this, options));
    /**
     * @member {Object} SuperMap.GeometryBufferAnalystParameters.prototype.sourceGeometry
     * @description 要做缓冲区分析的几何对象。<br>
     * 点类型可以是：{@link SuperMap.Geometry.Point}|{@link L.Point}|{@link L.GeoJSON}|{@link ol.geom.Point}|{@link ol.format.GeoJSON}。</br>
     * 线类型可以是：{@link SuperMap.Geometry.LineString}|{@link SuperMap.Geometry.LinearRing}|{@link L.Polyline}|{@link L.GeoJSON}|{@link ol.geom.LineString}|{@link ol.format.GeoJSON}。</br>
     * 面类型可以是：{@link SuperMap.Geometry.Polygon}|{@link L.Polygon}|{@link L.GeoJSON}|{@link ol.geom.Polygon}|{@link ol.format.GeoJSON}。 
     */

    _this.sourceGeometry = null;
    /**
     * @member {number} SuperMap.GeometryBufferAnalystParameters.prototype.sourceGeometrySRID
     * @description 缓冲区几何对象投影坐标参数, 如 4326，3857。
     */

    _this.sourceGeometrySRID = null;

    if (options) {
      Util.extend(GeometryBufferAnalystParameters_assertThisInitialized(_this), options);
    }

    _this.CLASS_NAME = " SuperMap.GeometryBufferAnalystParameters";
    return _this;
  }
  /**
   * @function SuperMap.GeometryBufferAnalystParameters.prototype.destroy
   * @override
   */


  GeometryBufferAnalystParameters_createClass(GeometryBufferAnalystParameters, [{
    key: "destroy",
    value: function destroy() {
      GeometryBufferAnalystParameters_get(GeometryBufferAnalystParameters_getPrototypeOf(GeometryBufferAnalystParameters.prototype), "destroy", this).call(this);

      var me = this;

      if (me.sourceGeometry) {
        me.sourceGeometry.destroy();
        me.sourceGeometry = null;
      }
    }
    /**
     * @function SuperMap.GeometryBufferAnalystParameters.toObject
     * @param {SuperMap.GeometryBufferAnalystParameters} geometryBufferAnalystParameters - 几何对象缓冲区分析参数类。
     * @param {SuperMap.GeometryBufferAnalystParameters} tempObj - 几何对象缓冲区分析参数对象。
     * @description 将几何对象缓冲区分析参数对象转换为 JSON 对象。
     * @returns {Object} JSON 对象。
     */

  }], [{
    key: "toObject",
    value: function toObject(geometryBufferAnalystParameters, tempObj) {
      for (var name in geometryBufferAnalystParameters) {
        if (name === "bufferSetting") {
          var tempBufferSetting = {};

          for (var key in geometryBufferAnalystParameters.bufferSetting) {
            tempBufferSetting[key] = geometryBufferAnalystParameters.bufferSetting[key];
          }

          tempObj.analystParameter = tempBufferSetting;
        } else if (name === "sourceGeometry") {
          tempObj.sourceGeometry = ServerGeometry_ServerGeometry.fromGeometry(geometryBufferAnalystParameters.sourceGeometry);
        } else {
          tempObj[name] = geometryBufferAnalystParameters[name];
        }
      }
    }
  }]);

  return GeometryBufferAnalystParameters;
}(BufferAnalystParameters_BufferAnalystParameters);
SuperMap.GeometryBufferAnalystParameters = GeometryBufferAnalystParameters_GeometryBufferAnalystParameters;
// CONCATENATED MODULE: ./src/common/iServer/BufferAnalystService.js
function BufferAnalystService_typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { BufferAnalystService_typeof = function _typeof(obj) { return typeof obj; }; } else { BufferAnalystService_typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return BufferAnalystService_typeof(obj); }

function BufferAnalystService_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function BufferAnalystService_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function BufferAnalystService_createClass(Constructor, protoProps, staticProps) { if (protoProps) BufferAnalystService_defineProperties(Constructor.prototype, protoProps); if (staticProps) BufferAnalystService_defineProperties(Constructor, staticProps); return Constructor; }

function BufferAnalystService_possibleConstructorReturn(self, call) { if (call && (BufferAnalystService_typeof(call) === "object" || typeof call === "function")) { return call; } return BufferAnalystService_assertThisInitialized(self); }

function BufferAnalystService_assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function BufferAnalystService_get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { BufferAnalystService_get = Reflect.get; } else { BufferAnalystService_get = function _get(target, property, receiver) { var base = BufferAnalystService_superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return BufferAnalystService_get(target, property, receiver || target); }

function BufferAnalystService_superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = BufferAnalystService_getPrototypeOf(object); if (object === null) break; } return object; }

function BufferAnalystService_getPrototypeOf(o) { BufferAnalystService_getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return BufferAnalystService_getPrototypeOf(o); }

function BufferAnalystService_inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) BufferAnalystService_setPrototypeOf(subClass, superClass); }

function BufferAnalystService_setPrototypeOf(o, p) { BufferAnalystService_setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return BufferAnalystService_setPrototypeOf(o, p); }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/





/**
 * @class SuperMap.BufferAnalystService
 * @category iServer SpatialAnalyst BufferAnalyst
 * @classdesc 缓冲区分析服务类。
 * 该类负责将客户设置的缓冲区分析参数传递给服务端，并接收服务端返回的缓冲区分析结果数据。
 * 缓冲区分析结果通过该类支持的事件的监听函数参数获取。
 * @param {string} url - 服务的访问地址。如：http://localhost:8090/iserver/services/spatialanalyst-changchun/restjsr/spatialanalyst。
 * @param {Object} options - 参数。</br>
 * @param {Object} options.eventListeners - 需要被注册的监听器对象。
 * @param {boolean} [options.crossOrigin] - 是否允许跨域请求。
 * @param {Object} [options.headers] - 请求头。
 * @extends {SuperMap.SpatialAnalystBase}
 * @example 例如：
 * (start code)
 * var myBufferAnalystService = new SuperMap.BufferAnalystService(url, {
     *     eventListeners: {
     *           "processCompleted": bufferCompleted,
     *           "processFailed": bufferFailed
     *           }
     *    });
 * (end)
 *
 *
 */

var BufferAnalystService_BufferAnalystService =
/*#__PURE__*/
function (_SpatialAnalystBase) {
  BufferAnalystService_inherits(BufferAnalystService, _SpatialAnalystBase);

  function BufferAnalystService(url, options) {
    var _this;

    BufferAnalystService_classCallCheck(this, BufferAnalystService);

    _this = BufferAnalystService_possibleConstructorReturn(this, BufferAnalystService_getPrototypeOf(BufferAnalystService).call(this, url, options));
    /**
     * @member {string} SuperMap.BufferAnalystService.prototype.mode
     * @description 缓冲区分析类型
     */

    _this.mode = null;

    if (options) {
      Util.extend(BufferAnalystService_assertThisInitialized(_this), options);
    }

    _this.CLASS_NAME = "SuperMap.BufferAnalystService";
    return _this;
  }
  /**
   * @function SuperMap.BufferAnalystService.prototype.destroy
   * @override
   */


  BufferAnalystService_createClass(BufferAnalystService, [{
    key: "destroy",
    value: function destroy() {
      BufferAnalystService_get(BufferAnalystService_getPrototypeOf(BufferAnalystService.prototype), "destroy", this).call(this);

      this.mode = null;
    }
    /**
     * @method SuperMap.BufferAnalystService.prototype.processAsync
     * @description 负责将客户端的查询参数传递到服务端。
     * @param {SuperMap.BufferAnalystParameters} parameter - 缓冲区分析参数
     */

  }, {
    key: "processAsync",
    value: function processAsync(parameter) {
      var parameterObject = {};
      var me = this;
      var end = me.url.substr(me.url.length - 1, 1);

      if (end !== '/') {
        me.url += "/";
      }

      if (parameter instanceof DatasetBufferAnalystParameters_DatasetBufferAnalystParameters) {
        me.mode = "datasets";
        me.url += 'datasets/' + parameter.dataset + '/buffer';
        DatasetBufferAnalystParameters_DatasetBufferAnalystParameters.toObject(parameter, parameterObject);
      } else if (parameter instanceof GeometryBufferAnalystParameters_GeometryBufferAnalystParameters) {
        me.mode = "geometry";
        me.url += 'geometry/buffer';
        GeometryBufferAnalystParameters_GeometryBufferAnalystParameters.toObject(parameter, parameterObject);
      }

      var jsonParameters = Util.toJSON(parameterObject);
      me.url += '.json?returnContent=true';
      me.request({
        method: "POST",
        data: jsonParameters,
        scope: me,
        success: me.serviceProcessCompleted,
        failure: me.serviceProcessFailed
      });
    }
  }]);

  return BufferAnalystService;
}(SpatialAnalystBase_SpatialAnalystBase);
SuperMap.BufferAnalystService = BufferAnalystService_BufferAnalystService;
// CONCATENATED MODULE: ./src/common/iServer/OutputSetting.js
function OutputSetting_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function OutputSetting_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function OutputSetting_createClass(Constructor, protoProps, staticProps) { if (protoProps) OutputSetting_defineProperties(Constructor.prototype, protoProps); if (staticProps) OutputSetting_defineProperties(Constructor, staticProps); return Constructor; }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/




/**
 * @class SuperMap.OutputSetting
 * @category  iServer ProcessingService
 * @classdesc 分布式分析输出类型设置类。
 * @param {Object} options - 参数。
 * @param {SuperMap.DatasourceConnectionInfo} options.datasourceInfo - 数据源连接信息。
 * @param {string} [options.datasetName='analystResult'] - 结果数据集名称。
 * @param {SuperMap.OutputType} [options.type=SuperMap.OutputType.UDB] - 输出类型。
 * @param {string} [options.outputPath] - 分析结果输出路径。
 */

var OutputSetting_OutputSetting =
/*#__PURE__*/
function () {
  function OutputSetting(options) {
    OutputSetting_classCallCheck(this, OutputSetting);

    /**
     * @member {SuperMap.OutputType} SuperMap.OutputSetting.prototype.type
     * @description 分布式分析的输出类型。
     */
    this.type = OutputType.UDB;
    /**
     * @member {string} [SuperMap.OutputSetting.prototype.datasetName='analystResult']
     * @description 分布式分析的输出结果数据集名称。
     */

    this.datasetName = "analystResult";
    /**
     * @member {SuperMap.DatasourceConnectionInfo} SuperMap.OutputSetting.prototype.datasourceInfo
     * @description 分布式分析的输出结果数据源连接信息。
     */

    this.datasourceInfo = null;
    /**
     * @member {string} [SuperMap.OutputSetting.prototype.outputPath]
     * @description 分布式分析的分析结果输出路径。
     */

    this.outputPath = "";
    Util.extend(this, options);
    this.CLASS_NAME = "SuperMap.OutputSetting";
  }
  /**
   * @function SuperMap.OutputSetting.prototype.destroy
   * @description 释放资源，将引用资源的属性置空。
   */


  OutputSetting_createClass(OutputSetting, [{
    key: "destroy",
    value: function destroy() {
      var me = this;
      me.type = null;
      me.datasetName = null;
      me.outputPath = null;

      if (me.datasourceInfo instanceof DatasourceConnectionInfo_DatasourceConnectionInfo) {
        me.datasourceInfo.destroy();
        me.datasourceInfo = null;
      }
    }
  }]);

  return OutputSetting;
}();
SuperMap.OutputSetting = OutputSetting_OutputSetting;
// CONCATENATED MODULE: ./src/common/iServer/MappingParameters.js
function MappingParameters_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function MappingParameters_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function MappingParameters_createClass(Constructor, protoProps, staticProps) { if (protoProps) MappingParameters_defineProperties(Constructor.prototype, protoProps); if (staticProps) MappingParameters_defineProperties(Constructor, staticProps); return Constructor; }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/



/**
 * @class SuperMap.MappingParameters
 * @category  iServer ProcessingService
 * @classdesc 分析后结果可视化的参数类。
 * @param {Object} options - 参数。
 * @param {Array.<SuperMap.ThemeGridRangeItem>} [options.items] - 栅格分段专题图子项数组。
 * @param {number} [options.numericPrecision=1] - 精度，此字段用于设置分析结果标签专题图中标签数值的精度，如“1”表示精确到小数点的后一位。
 * @param {SuperMap.RangeMode} [options.rangeMode=SuperMap.RangeMode.EQUALINTERVAL] - 专题图分段模式。
 * @param {number} [options.rangeCount] - 专题图分段个数。
 * @param {SuperMap.ColorGradientType} [options.colorGradientType=SuperMap.ColorGradientType.YELLOW_RED] - 专题图颜色渐变模式。
 */

var MappingParameters_MappingParameters =
/*#__PURE__*/
function () {
  function MappingParameters(options) {
    MappingParameters_classCallCheck(this, MappingParameters);

    /**
     * @member {Array.<SuperMap.ThemeGridRangeItem>} [SuperMap.MappingParameters.prototype.items]
     * @description 栅格分段专题图子项数组。
     */
    this.items = null;
    /**
     * @member {number} [SuperMap.MappingParameters.prototype.numericPrecision=1]
     * @description 精度，此字段用于设置分析结果标签专题图中标签数值的精度，如“1”表示精确到小数点的后一位。
     */

    this.numericPrecision = 1;
    /**
     * @member {SuperMap.RangeMode} [SuperMap.MappingParameters.prototype.RangeMode=SuperMap.RangeMode.EQUALINTERVAL]
     * @description 专题图分段模式。
     */

    this.rangeMode = RangeMode.EQUALINTERVAL;
    /**
     * @member {number} [SuperMap.MappingParameters.prototype.rangeCount]
     * @description 专题图分段个数。
     */

    this.rangeCount = "";
    /**
     * @member {SuperMap.ColorGradientType} [SuperMap.MappingParameters.prototype.colorGradientType=SuperMap.ColorGradientType.YELLOW_RED]
     * @description 专题图颜色渐变模式。
     */

    this.colorGradientType = ColorGradientType.YELLOW_RED;
    Util.extend(this, options);
    this.CLASS_NAME = "SuperMap.MappingParameters";
  }
  /**
   * @function SuperMap.MappingParameters.prototype.destroy
   * @description 释放资源，将引用资源的属性置空。
   */


  MappingParameters_createClass(MappingParameters, [{
    key: "destroy",
    value: function destroy() {
      var me = this;

      if (me.items) {
        if (me.items.length > 0) {
          for (var item in me.items) {
            me.items[item].destroy();
            me.items[item] = null;
          }
        }

        me.items = null;
      }

      me.numericPrecision = null;
      me.rangeMode = null;
      me.rangeCount = null;
      me.colorGradientType = null;
    }
  }]);

  return MappingParameters;
}();
SuperMap.MappingParameters = MappingParameters_MappingParameters;
// CONCATENATED MODULE: ./src/common/iServer/BuffersAnalystJobsParameter.js
function BuffersAnalystJobsParameter_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function BuffersAnalystJobsParameter_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function BuffersAnalystJobsParameter_createClass(Constructor, protoProps, staticProps) { if (protoProps) BuffersAnalystJobsParameter_defineProperties(Constructor.prototype, protoProps); if (staticProps) BuffersAnalystJobsParameter_defineProperties(Constructor, staticProps); return Constructor; }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/





/**
 * @class SuperMap.BuffersAnalystJobsParameter
 * @category iServer ProcessingService BufferAnalyst
 * @classdesc 缓冲区分析任务参数类。
 * @param {Object} options - 参数。
 * @param {string} options.datasetName - 数据集名。
 * @param {(SuperMap.Bounds|L.Bounds|ol.extent)} [options.bounds] - 分析范围（默认为全图范围）。
 * @param {string} [options.distance='15'] - 缓冲距离，或缓冲区半径。
 * @param {string} [options.distanceField='pickup_latitude'] - 缓冲区分析距离字段。
 * @param {SuperMap.AnalystSizeUnit} [options.distanceUnit=SuperMap.AnalystSizeUnit.METER] - 缓冲距离单位单位。
 * @param {SuperMap.OutputSetting} [options.output] - 输出参数设置。
 * @param {SuperMap.MappingParameters} [options.mappingParameters] - 分析后结果可视化的参数类。
 */

var BuffersAnalystJobsParameter_BuffersAnalystJobsParameter =
/*#__PURE__*/
function () {
  function BuffersAnalystJobsParameter(options) {
    BuffersAnalystJobsParameter_classCallCheck(this, BuffersAnalystJobsParameter);

    /**
     * @member {string} SuperMap.BuffersAnalystJobsParameter.prototype.datasetName
     * @description 数据集名。
     */
    this.datasetName = '';
    /**
     * @member {(SuperMap.Bounds|L.Bounds|ol.extent)} SuperMap.BuffersAnalystJobsParameter.prototype.bounds
     * @description 分析范围。
     */

    this.bounds = '';
    /**
     * @member {string} [SuperMap.BuffersAnalystJobsParameter.prototype.distance='15']
     * @description 缓冲距离，或称为缓冲区半径。当缓冲距离字段位空时，此参数有效。
     */

    this.distance = '';
    /**
     * @member {string} [SuperMap.BuffersAnalystJobsParameter.prototype.distanceField='pickup_latitude']
     * @description 缓冲距离字段。
     */

    this.distanceField = '';
    /**
     * @member {SuperMap.AnalystSizeUnit} [SuperMap.BuffersAnalystJobsParameter.prototype.distanceUnit=SuperMap.AnalystSizeUnit.METER]
     * @description 缓冲距离单位。
     */

    this.distanceUnit = AnalystSizeUnit.METER;
    /**
     * @member {string} SuperMap.BuffersAnalystJobsParameter.prototype.dissolveField
     * @description 融合字段，根据字段值对缓冲区结果面对象进行融合。
     */

    this.dissolveField = '';
    /**
     * @member {SuperMap.OutputSetting} [SuperMap.BuffersAnalystJobsParameter.prototype.output]
     * @description 输出参数设置类。
     */

    this.output = null;
    /**
     * @member {SuperMap.MappingParameters} [SuperMap.BuffersAnalystJobsParameter.prototype.mappingParameters]
     * @description 分析后结果可视化的参数类。
     */

    this.mappingParameters = null;

    if (!options) {
      return this;
    }

    Util.extend(this, options);
    this.CLASS_NAME = 'SuperMap.BuffersAnalystJobsParameter';
  }
  /**
   * @function SuperMap.BuffersAnalystJobsParameter.prototype.destroy
   * @description 释放资源，将引用资源的属性置空。
   */


  BuffersAnalystJobsParameter_createClass(BuffersAnalystJobsParameter, [{
    key: "destroy",
    value: function destroy() {
      this.datasetName = null;
      this.bounds = null;
      this.distance = null;
      this.distanceField = null;
      this.distanceUnit = null;
      this.dissolveField = null;

      if (this.output instanceof OutputSetting_OutputSetting) {
        this.output.destroy();
        this.output = null;
      }

      if (this.mappingParameters instanceof MappingParameters_MappingParameters) {
        this.mappingParameters.destroy();
        this.mappingParameters = null;
      }
    }
    /**
     * @function SuperMap.BuffersAnalystJobsParameter.toObject
     * @param {SuperMap.BuffersAnalystJobsParameter} BuffersAnalystJobsParameter - 缓冲区分析任务参数。
     * @param {Object} tempObj - 目标对象。
     * @description 生成缓冲区分析任务对象。
     */

  }], [{
    key: "toObject",
    value: function toObject(BuffersAnalystJobsParameter, tempObj) {
      for (var name in BuffersAnalystJobsParameter) {
        if (name === 'datasetName') {
          tempObj['input'] = tempObj['input'] || {};
          tempObj['input'][name] = BuffersAnalystJobsParameter[name];
          continue;
        }

        if (name === 'output') {
          tempObj['output'] = tempObj['output'] || {};
          tempObj['output'] = BuffersAnalystJobsParameter[name];
          continue;
        }

        tempObj['analyst'] = tempObj['analyst'] || {};

        if (name === 'bounds' && BuffersAnalystJobsParameter[name]) {
          tempObj['analyst'][name] = BuffersAnalystJobsParameter[name].toBBOX();
        } else {
          tempObj['analyst'][name] = BuffersAnalystJobsParameter[name];
        }

        if (name === 'mappingParameters') {
          tempObj['analyst'][name] = tempObj['analyst'][name] || {};
          tempObj['analyst']['mappingParameters'] = BuffersAnalystJobsParameter[name];
        }
      }
    }
  }]);

  return BuffersAnalystJobsParameter;
}();
SuperMap.BuffersAnalystJobsParameter = BuffersAnalystJobsParameter_BuffersAnalystJobsParameter;
// CONCATENATED MODULE: ./src/common/iServer/ProcessingServiceBase.js
function ProcessingServiceBase_typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { ProcessingServiceBase_typeof = function _typeof(obj) { return typeof obj; }; } else { ProcessingServiceBase_typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return ProcessingServiceBase_typeof(obj); }

function ProcessingServiceBase_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function ProcessingServiceBase_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function ProcessingServiceBase_createClass(Constructor, protoProps, staticProps) { if (protoProps) ProcessingServiceBase_defineProperties(Constructor.prototype, protoProps); if (staticProps) ProcessingServiceBase_defineProperties(Constructor, staticProps); return Constructor; }

function ProcessingServiceBase_possibleConstructorReturn(self, call) { if (call && (ProcessingServiceBase_typeof(call) === "object" || typeof call === "function")) { return call; } return ProcessingServiceBase_assertThisInitialized(self); }

function ProcessingServiceBase_assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function ProcessingServiceBase_get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { ProcessingServiceBase_get = Reflect.get; } else { ProcessingServiceBase_get = function _get(target, property, receiver) { var base = ProcessingServiceBase_superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return ProcessingServiceBase_get(target, property, receiver || target); }

function ProcessingServiceBase_superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = ProcessingServiceBase_getPrototypeOf(object); if (object === null) break; } return object; }

function ProcessingServiceBase_getPrototypeOf(o) { ProcessingServiceBase_getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return ProcessingServiceBase_getPrototypeOf(o); }

function ProcessingServiceBase_inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) ProcessingServiceBase_setPrototypeOf(subClass, superClass); }

function ProcessingServiceBase_setPrototypeOf(o, p) { ProcessingServiceBase_setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return ProcessingServiceBase_setPrototypeOf(o, p); }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/





/**
 * @class SuperMap.ProcessingServiceBase
 * @category  iServer ProcessingService
 * @classdesc 分布式分析服务基类
 * @extends {SuperMap.CommonServiceBase}
 * @param {string} url - 分布式分析服务地址。
 * @param {Object} options - 参数。
 * @param {SuperMap.Events} options.events - 处理所有事件的对象。
 * @param {number} options.index - 服务访问地址在数组中的位置。
 * @param {number} options.length - 服务访问地址数组长度。
 * @param {SuperMap.ServerType} [options.serverType=SuperMap.ServerType.ISERVER] - 服务器类型，iServer|iPortal|Online。
 * @param {Object} [options.eventListeners] - 事件监听器对象。有 processCompleted 属性可传入处理完成后的回调函数。processFailed 属性传入处理失败后的回调函数。
 * @param {boolean} [options.crossOrigin] - 是否允许跨域请求。
 * @param {Object} [options.headers] - 请求头。
 */

var ProcessingServiceBase_ProcessingServiceBase =
/*#__PURE__*/
function (_CommonServiceBase) {
  ProcessingServiceBase_inherits(ProcessingServiceBase, _CommonServiceBase);

  function ProcessingServiceBase(url, options) {
    var _this;

    ProcessingServiceBase_classCallCheck(this, ProcessingServiceBase);

    options = options || {};
    /*
     * Constant: EVENT_TYPES
     * {Array.<string>}
     * 此类支持的事件类型
     * - *processCompleted* 创建成功后触发的事件。
     * - *processFailed* 创建失败后触发的事件 。
     * - *processRunning* 创建过程的整个阶段都会触发的事件，用于获取创建过程的状态 。
     */

    options.EVENT_TYPES = ["processCompleted", "processFailed", "processRunning"];
    _this = ProcessingServiceBase_possibleConstructorReturn(this, ProcessingServiceBase_getPrototypeOf(ProcessingServiceBase).call(this, url, options));
    _this.CLASS_NAME = "SuperMap.ProcessingServiceBase";
    return _this;
  }
  /**
   * @function SuperMap.ProcessingServiceBase.prototype.destroy
   * @override
   */


  ProcessingServiceBase_createClass(ProcessingServiceBase, [{
    key: "destroy",
    value: function destroy() {
      ProcessingServiceBase_get(ProcessingServiceBase_getPrototypeOf(ProcessingServiceBase.prototype), "destroy", this).call(this);
    }
    /**
     * @function SuperMap.ProcessingServiceBase.prototype.getJobs
     * @description 获取分布式分析任务。
     * @param {string} url - 资源地址。
     */

  }, {
    key: "getJobs",
    value: function getJobs(url) {
      var me = this;
      FetchRequest.get(me._processUrl(url), null, {
        proxy: me.proxy
      }).then(function (response) {
        return response.json();
      }).then(function (result) {
        me.events.triggerEvent("processCompleted", {
          result: result
        });
      })["catch"](function (e) {
        me.eventListeners.processFailed({
          error: e
        });
      });
    }
    /**
     * @function SuperMap.ProcessingServiceBase.prototype.addJob
     * @description 添加分布式分析任务。
     * @param {string} url - 资源根地址。
     * @param {Object} params - 创建一个空间分析的请求参数。
     * @param {string} paramType - 请求参数类型。
     * @param {number} seconds - 开始创建后，获取创建成功结果的时间间隔。
     */

  }, {
    key: "addJob",
    value: function addJob(url, params, paramType, seconds) {
      var me = this,
          parameterObject = null;

      if (params && params instanceof paramType) {
        parameterObject = new Object();
        paramType.toObject(params, parameterObject);
      }

      var headers = Object.assign({
        'Content-Type': 'application/x-www-form-urlencoded'
      }, me.headers || {});
      var options = {
        proxy: me.proxy,
        headers: headers,
        withCredentials: me.withCredentials,
        crossOrigin: me.crossOrigin,
        isInTheSameDomain: me.isInTheSameDomain
      };
      FetchRequest.post(me._processUrl(url), JSON.stringify(parameterObject), options).then(function (response) {
        return response.json();
      }).then(function (result) {
        if (result.succeed) {
          me.serviceProcessCompleted(result, seconds);
        } else {
          me.serviceProcessFailed(result);
        }
      })["catch"](function (e) {
        me.serviceProcessFailed({
          error: e
        });
      });
    }
  }, {
    key: "serviceProcessCompleted",
    value: function serviceProcessCompleted(result, seconds) {
      result = Util.transformResult(result);
      seconds = seconds || 1000;
      var me = this;

      if (result) {
        var id = setInterval(function () {
          FetchRequest.get(me._processUrl(result.newResourceLocation), {
            _t: new Date().getTime()
          }).then(function (response) {
            return response.json();
          }).then(function (job) {
            me.events.triggerEvent("processRunning", {
              id: job.id,
              state: job.state
            });

            if (job.state.runState === 'LOST' || job.state.runState === 'KILLED' || job.state.runState === 'FAILED') {
              clearInterval(id);
              me.events.triggerEvent("processFailed", {
                error: job.state.errorMsg,
                state: job.state.runState
              });
            }

            if (job.state.runState === 'FINISHED' && job.setting.serviceInfo) {
              clearInterval(id);
              me.events.triggerEvent("processCompleted", {
                result: job
              });
            }
          })["catch"](function (e) {
            clearInterval(id);
            me.events.triggerEvent("processFailed", {
              error: e
            });
          });
        }, seconds);
      }
    }
  }, {
    key: "serviceProcessFailed",
    value: function serviceProcessFailed(result) {
      ProcessingServiceBase_get(ProcessingServiceBase_getPrototypeOf(ProcessingServiceBase.prototype), "serviceProcessFailed", this).call(this, result);
    } //为不是以.json结尾的url加上.json，并且如果有token的话，在.json后加上token参数。

  }, {
    key: "_processUrl",
    value: function _processUrl(url) {
      if (url.indexOf('.json') === -1) {
        url += '.json';
      }

      if (SecurityManager_SecurityManager.getToken(url)) {
        url += '?token=' + SecurityManager_SecurityManager.getToken(url);
      }

      return url;
    }
  }]);

  return ProcessingServiceBase;
}(CommonServiceBase_CommonServiceBase);
SuperMap.ProcessingServiceBase = ProcessingServiceBase_ProcessingServiceBase;
// CONCATENATED MODULE: ./src/common/iServer/BuffersAnalystJobsService.js
function BuffersAnalystJobsService_typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { BuffersAnalystJobsService_typeof = function _typeof(obj) { return typeof obj; }; } else { BuffersAnalystJobsService_typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return BuffersAnalystJobsService_typeof(obj); }

function BuffersAnalystJobsService_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function BuffersAnalystJobsService_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function BuffersAnalystJobsService_createClass(Constructor, protoProps, staticProps) { if (protoProps) BuffersAnalystJobsService_defineProperties(Constructor.prototype, protoProps); if (staticProps) BuffersAnalystJobsService_defineProperties(Constructor, staticProps); return Constructor; }

function BuffersAnalystJobsService_possibleConstructorReturn(self, call) { if (call && (BuffersAnalystJobsService_typeof(call) === "object" || typeof call === "function")) { return call; } return BuffersAnalystJobsService_assertThisInitialized(self); }

function BuffersAnalystJobsService_assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function BuffersAnalystJobsService_get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { BuffersAnalystJobsService_get = Reflect.get; } else { BuffersAnalystJobsService_get = function _get(target, property, receiver) { var base = BuffersAnalystJobsService_superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return BuffersAnalystJobsService_get(target, property, receiver || target); }

function BuffersAnalystJobsService_superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = BuffersAnalystJobsService_getPrototypeOf(object); if (object === null) break; } return object; }

function BuffersAnalystJobsService_getPrototypeOf(o) { BuffersAnalystJobsService_getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return BuffersAnalystJobsService_getPrototypeOf(o); }

function BuffersAnalystJobsService_inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) BuffersAnalystJobsService_setPrototypeOf(subClass, superClass); }

function BuffersAnalystJobsService_setPrototypeOf(o, p) { BuffersAnalystJobsService_setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return BuffersAnalystJobsService_setPrototypeOf(o, p); }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/



/**
 * @class SuperMap.BuffersAnalystJobsService
 * @category iServer ProcessingService BufferAnalyst
 * @classdesc 缓冲区分析服务类
 * @extends {SuperMap.ProcessingServiceBase}
 * @param {string} url - 服务地址。
 * @param {Object} options - 参数。
 * @param {boolean} [options.crossOrigin] - 是否允许跨域请求。
 * @param {Object} [options.headers] - 请求头。
 */

var BuffersAnalystJobsService_BuffersAnalystJobsService =
/*#__PURE__*/
function (_ProcessingServiceBas) {
  BuffersAnalystJobsService_inherits(BuffersAnalystJobsService, _ProcessingServiceBas);

  function BuffersAnalystJobsService(url, options) {
    var _this;

    BuffersAnalystJobsService_classCallCheck(this, BuffersAnalystJobsService);

    _this = BuffersAnalystJobsService_possibleConstructorReturn(this, BuffersAnalystJobsService_getPrototypeOf(BuffersAnalystJobsService).call(this, url, options));
    _this.url += "/spatialanalyst/buffers";
    _this.CLASS_NAME = "SuperMap.BuffersAnalystJobsService";
    return _this;
  }
  /**
   *@override
   */


  BuffersAnalystJobsService_createClass(BuffersAnalystJobsService, [{
    key: "destroy",
    value: function destroy() {
      BuffersAnalystJobsService_get(BuffersAnalystJobsService_getPrototypeOf(BuffersAnalystJobsService.prototype), "destroy", this).call(this);
    }
    /**
     * @function SuperMap.BuffersAnalystJobsService.prototype.getBufferJobs
     * @description 获取缓冲区分析所有任务
     */

  }, {
    key: "getBuffersJobs",
    value: function getBuffersJobs() {
      BuffersAnalystJobsService_get(BuffersAnalystJobsService_getPrototypeOf(BuffersAnalystJobsService.prototype), "getJobs", this).call(this, this.url);
    }
    /**
     * @function SuperMap.BuffersAnalystJobsService.prototype.getBufferJob
     * @description 获取指定id的缓冲区分析服务
     * @param {string} id - 指定要获取数据的id。
     */

  }, {
    key: "getBuffersJob",
    value: function getBuffersJob(id) {
      BuffersAnalystJobsService_get(BuffersAnalystJobsService_getPrototypeOf(BuffersAnalystJobsService.prototype), "getJobs", this).call(this, this.url + '/' + id);
    }
    /**
     * @function SuperMap.BuffersAnalystJobsService.prototype.addBufferJob
     * @description 新建缓冲区分析服务
     * @param {SuperMap.BuffersAnalystJobsParameter} params - 创建一个空间分析的请求参数。
     * @param {number} seconds - 开始创建后，获取创建成功结果的时间间隔。
     */

  }, {
    key: "addBuffersJob",
    value: function addBuffersJob(params, seconds) {
      BuffersAnalystJobsService_get(BuffersAnalystJobsService_getPrototypeOf(BuffersAnalystJobsService.prototype), "addJob", this).call(this, this.url, params, BuffersAnalystJobsParameter_BuffersAnalystJobsParameter, seconds);
    }
  }]);

  return BuffersAnalystJobsService;
}(ProcessingServiceBase_ProcessingServiceBase);
SuperMap.BuffersAnalystJobsService = BuffersAnalystJobsService_BuffersAnalystJobsService;
// CONCATENATED MODULE: ./src/common/iServer/BurstPipelineAnalystParameters.js
function BurstPipelineAnalystParameters_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function BurstPipelineAnalystParameters_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function BurstPipelineAnalystParameters_createClass(Constructor, protoProps, staticProps) { if (protoProps) BurstPipelineAnalystParameters_defineProperties(Constructor.prototype, protoProps); if (staticProps) BurstPipelineAnalystParameters_defineProperties(Constructor, staticProps); return Constructor; }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


/**
 * @class SuperMap.BurstPipelineAnalystParameters
 * @category iServer NetworkAnalyst BurstAnalyse
 * @classdesc 爆管分析参数类。
 * @param {Object} options - 参数。 
 * @param {Array.<number>} options.sourceNodeIDs - 指定的设施点 ID 数组。 
 * @param {number} [options.edgeID] - 指定的弧段ID，edgeID 与 nodeID 必须指定一个。 
 * @param {number} [options.nodeID] - 指定的结点ID，edgeID 与 nodeID 必须指定一个。 
 * @param {boolean} [options.isUncertainDirectionValid=false] - 指定不确定流向是否有效。
 */

var BurstPipelineAnalystParameters_BurstPipelineAnalystParameters =
/*#__PURE__*/
function () {
  function BurstPipelineAnalystParameters(options) {
    BurstPipelineAnalystParameters_classCallCheck(this, BurstPipelineAnalystParameters);

    var me = this;
    /**
     * @member {Array.<number>} SuperMap.BurstPipelineAnalystParameters.prototype.sourceNodeIDs
     * @description 指定的设施点 ID 数组。
     */

    this.sourceNodeIDs = null;
    /**
     * @member {number} [SuperMap.BurstPipelineAnalystParameters.prototype.edgeID]
     * @description 指定的弧段 ID，edgeID 与 nodeID 必须指定一个。 
     */

    this.edgeID = null;
    /**
     * @member {number} [SuperMap.BurstPipelineAnalystParameters.prototype.nodeID]
     * @description 指定的结点 ID，edgeID 与 nodeID 必须指定一个。 
     */

    this.nodeID = null;
    /**
     * @member {boolean} [SuperMap.BurstPipelineAnalystParameters.prototype.isUncertainDirectionValid=false]
     * @description 指定不确定流向是否有效。
     * 指定为 true，表示不确定流向有效，遇到不确定流向时分析继续进行。
     * 指定为 false，表示不确定流向无效，遇到不确定流向将停止在该方向上继续查找。
     */

    this.isUncertainDirectionValid = false;
    Util.extend(me, options);
    this.CLASS_NAME = "SuperMap.BurstPipelineAnalystParameters";
  }
  /**
   * @function SuperMap.BurstPipelineAnalystParameters.prototype.destroy
   * @description 释放资源，将引用资源的属性置空。
   */


  BurstPipelineAnalystParameters_createClass(BurstPipelineAnalystParameters, [{
    key: "destroy",
    value: function destroy() {
      var me = this;
      me.sourceNodeIDs = null;
      me.edgeID = null;
      me.nodeID = null;
      me.isUncertainDirectionValid = null;
    }
  }]);

  return BurstPipelineAnalystParameters;
}();
SuperMap.BurstPipelineAnalystParameters = BurstPipelineAnalystParameters_BurstPipelineAnalystParameters;
// CONCATENATED MODULE: ./src/common/iServer/NetworkAnalystServiceBase.js
function NetworkAnalystServiceBase_typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { NetworkAnalystServiceBase_typeof = function _typeof(obj) { return typeof obj; }; } else { NetworkAnalystServiceBase_typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return NetworkAnalystServiceBase_typeof(obj); }

function NetworkAnalystServiceBase_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function NetworkAnalystServiceBase_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function NetworkAnalystServiceBase_createClass(Constructor, protoProps, staticProps) { if (protoProps) NetworkAnalystServiceBase_defineProperties(Constructor.prototype, protoProps); if (staticProps) NetworkAnalystServiceBase_defineProperties(Constructor, staticProps); return Constructor; }

function NetworkAnalystServiceBase_possibleConstructorReturn(self, call) { if (call && (NetworkAnalystServiceBase_typeof(call) === "object" || typeof call === "function")) { return call; } return NetworkAnalystServiceBase_assertThisInitialized(self); }

function NetworkAnalystServiceBase_assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function NetworkAnalystServiceBase_get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { NetworkAnalystServiceBase_get = Reflect.get; } else { NetworkAnalystServiceBase_get = function _get(target, property, receiver) { var base = NetworkAnalystServiceBase_superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return NetworkAnalystServiceBase_get(target, property, receiver || target); }

function NetworkAnalystServiceBase_superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = NetworkAnalystServiceBase_getPrototypeOf(object); if (object === null) break; } return object; }

function NetworkAnalystServiceBase_getPrototypeOf(o) { NetworkAnalystServiceBase_getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return NetworkAnalystServiceBase_getPrototypeOf(o); }

function NetworkAnalystServiceBase_inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) NetworkAnalystServiceBase_setPrototypeOf(subClass, superClass); }

function NetworkAnalystServiceBase_setPrototypeOf(o, p) { NetworkAnalystServiceBase_setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return NetworkAnalystServiceBase_setPrototypeOf(o, p); }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/




/**
 * @class SuperMap.NetworkAnalystServiceBase
 * @category iServer NetworkAnalyst
 * @classdesc 网络分析服务基类。
 * @description 网络分析服务基类。
 * @extends {SuperMap.CommonServiceBase}
 * @param {string} url - 网络分析服务地址。
 * @param {Object} options - 参数。
 * @param {boolean} [options.crossOrigin] - 是否允许跨域请求。
 * @param {Object} [options.headers] - 请求头。
 */

var NetworkAnalystServiceBase_NetworkAnalystServiceBase =
/*#__PURE__*/
function (_CommonServiceBase) {
  NetworkAnalystServiceBase_inherits(NetworkAnalystServiceBase, _CommonServiceBase);

  function NetworkAnalystServiceBase(url, options) {
    var _this;

    NetworkAnalystServiceBase_classCallCheck(this, NetworkAnalystServiceBase);

    _this = NetworkAnalystServiceBase_possibleConstructorReturn(this, NetworkAnalystServiceBase_getPrototypeOf(NetworkAnalystServiceBase).call(this, url, options));
    /**
     * @member {SuperMap.DataFormat} [SuperMap.NetworkAnalystServiceBase.prototype.format=SuperMap.DataFormat.GEOJSON]
     * @description 查询结果返回格式，目前支持 iServerJSON 和 GeoJSON 两种格式，参数格式为 "ISERVER","GEOJSON"
     */

    _this.format = DataFormat.GEOJSON;
    _this.CLASS_NAME = "SuperMap.NetworkAnalystServiceBase";
    return _this;
  }
  /**
   * @function SuperMap.NetworkAnalystServiceBase.prototype.destroy
   * @description 释放资源，将引用的资源属性置空。
   */


  NetworkAnalystServiceBase_createClass(NetworkAnalystServiceBase, [{
    key: "destroy",
    value: function destroy() {
      NetworkAnalystServiceBase_get(NetworkAnalystServiceBase_getPrototypeOf(NetworkAnalystServiceBase.prototype), "destroy", this).call(this);

      this.format = null;
    }
    /**
     * @function SuperMap.NetworkAnalystServiceBase.prototype.serviceProcessCompleted
     * @description 分析完成，执行此方法。
     * @param {Object} result - 服务器返回的结果对象。
     */

  }, {
    key: "serviceProcessCompleted",
    value: function serviceProcessCompleted(result) {
      var me = this,
          analystResult;
      result = Util.transformResult(result);

      if (result && me.format === DataFormat.GEOJSON && typeof me.toGeoJSONResult === 'function') {
        analystResult = me.toGeoJSONResult(result);
      }

      if (!analystResult) {
        analystResult = result;
      }

      me.events.triggerEvent("processCompleted", {
        result: analystResult
      });
    }
    /**
     * @function SuperMap.NetworkAnalystServiceBase.prototype.toGeoJSONResult
     * @description 将含有 geometry 的数据转换为 GeoJSON 格式。只处理结果中的路由，由子类实现。
     * @param {Object} result - 服务器返回的结果对象。
     * @returns {GeoJSONObject} GeoJSON 对象。
     */

  }, {
    key: "toGeoJSONResult",
    value: function toGeoJSONResult(result) {
      // eslint-disable-line no-unused-vars
      return null;
    }
  }]);

  return NetworkAnalystServiceBase;
}(CommonServiceBase_CommonServiceBase);
SuperMap.NetworkAnalystServiceBase = NetworkAnalystServiceBase_NetworkAnalystServiceBase;
// CONCATENATED MODULE: ./src/common/iServer/BurstPipelineAnalystService.js
function BurstPipelineAnalystService_typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { BurstPipelineAnalystService_typeof = function _typeof(obj) { return typeof obj; }; } else { BurstPipelineAnalystService_typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return BurstPipelineAnalystService_typeof(obj); }

function BurstPipelineAnalystService_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function BurstPipelineAnalystService_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function BurstPipelineAnalystService_createClass(Constructor, protoProps, staticProps) { if (protoProps) BurstPipelineAnalystService_defineProperties(Constructor.prototype, protoProps); if (staticProps) BurstPipelineAnalystService_defineProperties(Constructor, staticProps); return Constructor; }

function BurstPipelineAnalystService_possibleConstructorReturn(self, call) { if (call && (BurstPipelineAnalystService_typeof(call) === "object" || typeof call === "function")) { return call; } return BurstPipelineAnalystService_assertThisInitialized(self); }

function BurstPipelineAnalystService_assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function BurstPipelineAnalystService_get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { BurstPipelineAnalystService_get = Reflect.get; } else { BurstPipelineAnalystService_get = function _get(target, property, receiver) { var base = BurstPipelineAnalystService_superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return BurstPipelineAnalystService_get(target, property, receiver || target); }

function BurstPipelineAnalystService_superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = BurstPipelineAnalystService_getPrototypeOf(object); if (object === null) break; } return object; }

function BurstPipelineAnalystService_getPrototypeOf(o) { BurstPipelineAnalystService_getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return BurstPipelineAnalystService_getPrototypeOf(o); }

function BurstPipelineAnalystService_inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) BurstPipelineAnalystService_setPrototypeOf(subClass, superClass); }

function BurstPipelineAnalystService_setPrototypeOf(o, p) { BurstPipelineAnalystService_setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return BurstPipelineAnalystService_setPrototypeOf(o, p); }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/



/**
 * @class SuperMap.BurstPipelineAnalystService
 * @category iServer NetworkAnalyst BurstAnalyse
 * @classdesc 爆管分析服务类，即将给定弧段或节点作为爆管点来进行分析，返回关键结点 ID 数组、普通结点 ID 数组及其上下游弧段 ID 数组。
 * @extends {SuperMap.NetworkAnalystServiceBase}
 * @param {string} url - 网络分析服务地址。请求网络分析服务，URL应为：
 *                       http://{服务器地址}:{服务端口号}/iserver/services/{网络分析服务名}/rest/networkanalyst/{网络数据集@数据源}，
 *                       例如: "http://localhost:8090/iserver/services/test/rest/networkanalyst/WaterNet@FacilityNet"。
 * @param {Object} options - 参数。
 * @param {Object} options.eventListeners - 需要被注册的监听器对象。
 * @param {boolean} [options.crossOrigin] - 是否允许跨域请求。
 * @param {Object} [options.headers] - 请求头。
 */

var BurstPipelineAnalystService_BurstPipelineAnalystService =
/*#__PURE__*/
function (_NetworkAnalystServic) {
  BurstPipelineAnalystService_inherits(BurstPipelineAnalystService, _NetworkAnalystServic);

  function BurstPipelineAnalystService(url, options) {
    var _this;

    BurstPipelineAnalystService_classCallCheck(this, BurstPipelineAnalystService);

    _this = BurstPipelineAnalystService_possibleConstructorReturn(this, BurstPipelineAnalystService_getPrototypeOf(BurstPipelineAnalystService).call(this, url, options));
    _this.CLASS_NAME = "SuperMap.BurstPipelineAnalystService";
    return _this;
  }
  /**
   * @function SuperMap.BurstPipelineAnalystService.prototype.destroy
   * @override
   */


  BurstPipelineAnalystService_createClass(BurstPipelineAnalystService, [{
    key: "destroy",
    value: function destroy() {
      BurstPipelineAnalystService_get(BurstPipelineAnalystService_getPrototypeOf(BurstPipelineAnalystService.prototype), "destroy", this).call(this);
    }
    /**
     * @function SuperMap.BurstPipelineAnalystService.prototype.processAsync
     * @description 负责将客户端的查询参数传递到服务端。
     * @params {SuperMap.BurstPipelineAnalystParameters} params - 爆管分析参数类
     */

  }, {
    key: "processAsync",
    value: function processAsync(params) {
      if (!(params instanceof BurstPipelineAnalystParameters_BurstPipelineAnalystParameters)) {
        return null;
      }

      var me = this,
          jsonObject;
      var end = me.url.substr(me.url.length - 1, 1);
      me.url = me.url + (end === "/" ? "burstAnalyse" : "/burstAnalyse") + ".json?";
      jsonObject = {
        sourceNodeIDs: params.sourceNodeIDs,
        isUncertainDirectionValid: params.isUncertainDirectionValid
      }; //必传参数不正确，就终止

      if (params.edgeID !== null && params.nodeID !== null) {
        throw new Error('edgeID and nodeID cannot be null at the same time.');
      }

      if (params.edgeID === null && params.nodeID === null) {
        throw new Error('edgeID and nodeID cannot be null at the same time.');
      }

      if (params.edgeID !== null) {
        jsonObject.edgeID = params.edgeID;
      } else {
        jsonObject.nodeID = params.nodeID;
      }

      me.request({
        method: "GET",
        params: jsonObject,
        scope: me,
        success: me.serviceProcessCompleted,
        failure: me.serviceProcessFailed
      });
    }
  }]);

  return BurstPipelineAnalystService;
}(NetworkAnalystServiceBase_NetworkAnalystServiceBase);
SuperMap.BurstPipelineAnalystService = BurstPipelineAnalystService_BurstPipelineAnalystService;
// CONCATENATED MODULE: ./src/common/iServer/ChartFeatureInfoSpecsService.js
function ChartFeatureInfoSpecsService_typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { ChartFeatureInfoSpecsService_typeof = function _typeof(obj) { return typeof obj; }; } else { ChartFeatureInfoSpecsService_typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return ChartFeatureInfoSpecsService_typeof(obj); }

function ChartFeatureInfoSpecsService_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function ChartFeatureInfoSpecsService_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function ChartFeatureInfoSpecsService_createClass(Constructor, protoProps, staticProps) { if (protoProps) ChartFeatureInfoSpecsService_defineProperties(Constructor.prototype, protoProps); if (staticProps) ChartFeatureInfoSpecsService_defineProperties(Constructor, staticProps); return Constructor; }

function ChartFeatureInfoSpecsService_possibleConstructorReturn(self, call) { if (call && (ChartFeatureInfoSpecsService_typeof(call) === "object" || typeof call === "function")) { return call; } return ChartFeatureInfoSpecsService_assertThisInitialized(self); }

function ChartFeatureInfoSpecsService_assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function ChartFeatureInfoSpecsService_get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { ChartFeatureInfoSpecsService_get = Reflect.get; } else { ChartFeatureInfoSpecsService_get = function _get(target, property, receiver) { var base = ChartFeatureInfoSpecsService_superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return ChartFeatureInfoSpecsService_get(target, property, receiver || target); }

function ChartFeatureInfoSpecsService_superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = ChartFeatureInfoSpecsService_getPrototypeOf(object); if (object === null) break; } return object; }

function ChartFeatureInfoSpecsService_getPrototypeOf(o) { ChartFeatureInfoSpecsService_getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return ChartFeatureInfoSpecsService_getPrototypeOf(o); }

function ChartFeatureInfoSpecsService_inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) ChartFeatureInfoSpecsService_setPrototypeOf(subClass, superClass); }

function ChartFeatureInfoSpecsService_setPrototypeOf(o, p) { ChartFeatureInfoSpecsService_setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return ChartFeatureInfoSpecsService_setPrototypeOf(o, p); }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/



/**
 * @class SuperMap.ChartFeatureInfoSpecsService
 * @category  iServer Map Chart
 * @classdesc 海图物标信息服务类，通过该服务类可以查询到服务端支持的所有海图物标信息。
 *            用户可以通过两种方式获取查询结果：
 *            一种是通过监听 ChartFeatureInfoSpecsEvent.PROCESS_COMPLETE 事件；
 *            另一种是使用 AsyncResponder 类实现异步处理。
 * @extends {SuperMap.CommonServiceBase}
 * @param {string} url - 地图（特指海图）服务地址。
 *        如："http://localhost:8090/iserver/services/map-ChartW/rest/maps/海图"。
 *        发送请求格式类似于："http://localhost:8090/iserver/services/map-ChartW/rest/maps/海图/chartFeatureInfoSpecs.json"。
 * @param {Object} options - 参数。
 * @param {Object} options.eventListeners - 事件监听器对象。有processCompleted属性可传入处理完成后的回调函数。processFailed属性传入处理失败后的回调函数。
 * @param {SuperMap.ServerType} [options.serverType=SuperMap.ServerType.ISERVER] - 服务器类型，iServer|iPortal|Online。
 * @param {SuperMap.DataFormat} [options.format] - 查询结果返回格式，目前支持 iServerJSON 和 GeoJSON 两种格式，参数格式为"ISERVER","GEOJSON"。
 * @param {boolean} [options.crossOrigin] - 是否允许跨域请求。
 * @param {Object} [options.headers] - 请求头。
 */

var ChartFeatureInfoSpecsService_ChartFeatureInfoSpecsService =
/*#__PURE__*/
function (_CommonServiceBase) {
  ChartFeatureInfoSpecsService_inherits(ChartFeatureInfoSpecsService, _CommonServiceBase);

  function ChartFeatureInfoSpecsService(url, options) {
    var _this;

    ChartFeatureInfoSpecsService_classCallCheck(this, ChartFeatureInfoSpecsService);

    _this = ChartFeatureInfoSpecsService_possibleConstructorReturn(this, ChartFeatureInfoSpecsService_getPrototypeOf(ChartFeatureInfoSpecsService).call(this, url, options));
    _this.CLASS_NAME = "SuperMap.ChartFeatureInfoSpecsService";
    return _this;
  }
  /**
   * @function SuperMap.ChartFeatureInfoSpecsService.prototype.destroy
   * @override
   */


  ChartFeatureInfoSpecsService_createClass(ChartFeatureInfoSpecsService, [{
    key: "destroy",
    value: function destroy() {
      ChartFeatureInfoSpecsService_get(ChartFeatureInfoSpecsService_getPrototypeOf(ChartFeatureInfoSpecsService.prototype), "destroy", this).call(this);

      Util.reset(this);
    }
    /**
     * @function SuperMap.ChartFeatureInfoSpecsService.prototype.processAsync
     * @description 根据地图（特指海图）服务地址与服务端完成异步通讯，获取物标信息。
     *              当查询物标信息成功时，将触发 ChartFeatureInfoSpecsEvent.PROCESS_COMPLETE
     *              事件。用可以通过户两种方式获取图层信息:
     *              1. 通过 AsyncResponder 类获取（推荐使用）；
     *              2. 通过监听 ChartFeatureInfoSpecsEvent.PROCESS_COMPLETE 事件获取。
     */

  }, {
    key: "processAsync",
    value: function processAsync() {
      var me = this,
          method = "GET",
          end = me.url.substr(me.url.length - 1, 1);

      if (!me.isTempLayers) {
        me.url += end === "/" ? '' : '/';
        me.url += "chartFeatureInfoSpecs.json?";
      } else {
        me.url += ".json?";
      }

      me.request({
        method: method,
        params: null,
        scope: me,
        success: me.serviceProcessCompleted,
        failure: me.serviceProcessFailed
      });
    }
  }]);

  return ChartFeatureInfoSpecsService;
}(CommonServiceBase_CommonServiceBase);
SuperMap.ChartFeatureInfoSpecsService = ChartFeatureInfoSpecsService_ChartFeatureInfoSpecsService;
// CONCATENATED MODULE: ./src/common/iServer/ChartQueryFilterParameter.js
function ChartQueryFilterParameter_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function ChartQueryFilterParameter_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function ChartQueryFilterParameter_createClass(Constructor, protoProps, staticProps) { if (protoProps) ChartQueryFilterParameter_defineProperties(Constructor.prototype, protoProps); if (staticProps) ChartQueryFilterParameter_defineProperties(Constructor, staticProps); return Constructor; }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


/**
 * @class SuperMap.ChartQueryFilterParameter
 * @category  iServer Map Chart
 * @classdesc 海图查询过滤参数类，用于设置海图查询的过滤参数。包括：物标代码、物标可应用对象的选择（是否查询点、线或面）、属性字段过滤条件。
 * @param {Object} options - 参数。 
 * @param {string} options.attributeFilter - 属性字段过滤条件。 
 * @param {number} options.chartFeatureInfoSpecCode - 查询的物标代号。
 * @param {boolean} [options.isQueryPoint] - 是否查询点。 
 * @param {boolean} [options.isQueryLine] - 是否查询线。 
 * @param {boolean} [options.isQueryRegion] - 是否查询面。 
 */

var ChartQueryFilterParameter_ChartQueryFilterParameter =
/*#__PURE__*/
function () {
  function ChartQueryFilterParameter(options) {
    ChartQueryFilterParameter_classCallCheck(this, ChartQueryFilterParameter);

    /**
     * @member {boolean} [SuperMap.ChartQueryFilterParameter.prototype.isQueryPoint]
     * @description 是否查询点。
     */
    this.isQueryPoint = null;
    /**
     * @member {boolean} [SuperMap.ChartQueryFilterParameter.prototype.isQueryLine]
     * @description 是否查询线。
     */

    this.isQueryLine = null;
    /**
     * @member {boolean} [SuperMap.ChartQueryFilterParameter.prototype.isQueryRegion]
     * @description 是否查询面。
     */

    this.isQueryRegion = null;
    /**
     * @member {string} SuperMap.ChartQueryFilterParameter.prototype.attributeFilter
     * @description 属性字段过滤条件。
     */

    this.attributeFilter = null;
    /**
     * @member {number} SuperMap.ChartQueryFilterParameter.prototype.chartFeatureInfoSpecCode
     * @description 查询的物标代号。
     */

    this.chartFeatureInfoSpecCode = null;
    Util.extend(this, options);
    this.CLASS_NAME = "SuperMap.ChartQueryFilterParameter";
  }
  /**
   * @function SuperMap.ChartQueryFilterParameter.prototype.destroy
   * @description 释放资源，将引用资源的属性置空。
   */


  ChartQueryFilterParameter_createClass(ChartQueryFilterParameter, [{
    key: "destroy",
    value: function destroy() {
      var me = this;
      me.isQueryPoint = null;
      me.isQueryLine = null;
      me.isQueryRegion = null;
      me.attributeFilter = null;
      me.chartFeatureInfoSpecCode = null;
    }
    /**
     * @function SuperMap.ChartQueryFilterParameter.prototype.toJson
     * @description 将属性信息转化成 JSON 格式字符串。
     */

  }, {
    key: "toJson",
    value: function toJson() {
      var json = "";
      json += "\"isQueryPoint\":" + this.isQueryPoint + ",";
      json += "\"isQueryLine\":" + this.isQueryLine + ",";
      json += "\"isQueryRegion\":" + this.isQueryRegion + ",";

      if (this.attributeFilter) {
        json += "\"attributeFilter\": \"" + this.attributeFilter + "\",";
      }

      json += "\"chartFeatureInfoSpecCode\":" + this.chartFeatureInfoSpecCode;
      json = "{" + json + "}";
      return json;
    }
  }]);

  return ChartQueryFilterParameter;
}();
SuperMap.ChartQueryFilterParameter = ChartQueryFilterParameter_ChartQueryFilterParameter;
// CONCATENATED MODULE: ./src/common/iServer/ChartQueryParameters.js
function ChartQueryParameters_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function ChartQueryParameters_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function ChartQueryParameters_createClass(Constructor, protoProps, staticProps) { if (protoProps) ChartQueryParameters_defineProperties(Constructor.prototype, protoProps); if (staticProps) ChartQueryParameters_defineProperties(Constructor, staticProps); return Constructor; }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/



/**
 * @class SuperMap.ChartQueryParameters
 * @category iServer Map Chart
 * @classdesc 海图查询参数类，该类用于设置海图查询时的相关参数，海图查询分为海图属性查询和海图范围查询两类，通过属性 queryMode 指定查询模式。
 *            必设属性有：queryMode、chartLayerNames、chartQueryFilterParameters。当进行海图范围查询时，必设属性还包括 bounds。
 * @param {Object} options - 参数。 
 * @param {string} options.queryMode - 海图查询模式类型，支持两种查询方式：海图属性查询（"ChartAttributeQuery"）和海图空间查询（"ChartBoundsQuery"）。 
 * @param {Array.<string>} options.chartLayerNames - 查询的海图图层的名称。
 * @param {Array.<{SuperMap.ChartQueryFilterParameter}>} options.chartQueryFilterParameters - 海图查询过滤参数。包括：物标代码、物标可应用对象的选择（是否查询点、线或面）、属性字段过滤条件。 
 * @param {(SuperMap.Bounds|L.Bounds|ol.extent)} [options.bounds] - 海图查询范围。当进行海图范围查询时，此参数为必选。
 * @param {boolean} [options.returnContent=true] - 获取或设置是返回查询结果记录集 recordsets，还是返回查询结果的资源 resourceInfo。 
 * @param {number} [options.startRecord=0] - 查询起始记录位置。 
 * @param {number} [options.expectCount] - 期望查询结果返回的记录数，该值大于0。
 */

var ChartQueryParameters_ChartQueryParameters =
/*#__PURE__*/
function () {
  function ChartQueryParameters(options) {
    ChartQueryParameters_classCallCheck(this, ChartQueryParameters);

    /**
     * @member {string} SuperMap.ChartQueryParameters.prototype.queryMode
     * @description 海图查询模式类型，支持两种查询方式：海图属性查询（"ChartAttributeQuery"）和海图空间查询（"ChartBoundsQuery"） 。
     */
    this.queryMode = null;
    /**
     * @member {(SuperMap.Bounds|L.Bounds|ol.extent)} SuperMap.ChartQueryParameters.prototype.bounds
     * @description 海图查询范围。
     */

    this.bounds = null;
    /**
     * @member {Array.<string>} SuperMap.ChartQueryParameters.prototype.chartLayerNames
     * @description 查询的海图图层的名称。
     */

    this.chartLayerNames = null;
    /**
     * @member {Array.<SuperMap.ChartQueryFilterParameter>} SuperMap.ChartQueryParameters.prototype.chartQueryFilterParameters
     * @description 海图查询过滤参数。包括：物标代码、物标可应用对象的选择（是否查询点、线或面）、属性字段过滤条件。
     */

    this.chartQueryFilterParameters = null;
    /**
     * @member {boolean} [SuperMap.ChartQueryParameters.prototype.returnContent=true]
     * @description 获取或设置是返回查询结果记录集 recordsets，还是返回查询结果的资源 resourceInfo。
     */

    this.returnContent = true;
    /**
     * @member {number} [SuperMap.ChartQueryParameters.prototype.startRecord=0]
     * @description 查询起始记录位置。
     */

    this.startRecord = 0;
    /**
     * @member {number} [SuperMap.ChartQueryParameters.prototype.expectCount]
     * @description 期望查询结果返回的记录数，该值大于0。
     */

    this.expectCount = null;
    Util.extend(this, options);
    this.CLASS_NAME = "SuperMap.ChartQueryParameters";
  }
  /**
   * @function SuperMap.ChartQueryParameters.prototype.destroy
   * @description 释放资源，将引用资源的属性置空。
   */


  ChartQueryParameters_createClass(ChartQueryParameters, [{
    key: "destroy",
    value: function destroy() {
      var me = this;
      me.queryMode = null;
      me.bounds = null;
      me.chartLayerNames = null;
      me.chartQueryFilterParameters = null;
      me.returnContent = true;
      me.startRecord = 0;
      me.expectCount = null;
    }
    /**
     * @function SuperMap.ChartQueryParameters.prototype.getVariablesJson
     * @description 将属性信息转换成能够被服务识别的 JSON 格式字符串。
     * @returns {string} JSON 字符串。
     */

  }, {
    key: "getVariablesJson",
    value: function getVariablesJson() {
      var json = "";
      json += "\"queryMode\":\"" + this.queryMode + "\",";

      if (this.chartLayerNames && this.chartLayerNames.length) {
        var chartLayersArray = [];
        var layerLength = this.chartLayerNames.length;

        for (var i = 0; i < layerLength; i++) {
          chartLayersArray.push("\"" + this.chartLayerNames[i] + "\"");
        }

        var layerNames = "[" + chartLayersArray.join(",") + "]";
        json += "\"chartLayerNames\":" + layerNames + ",";
      }

      if (this.queryMode === "ChartBoundsQuery" && this.bounds) {
        json += "\"bounds\":" + "{" + "\"leftBottom\":" + "{" + "\"x\":" + this.bounds.left + "," + "\"y\":" + this.bounds.bottom + "}" + "," + "\"rightTop\":" + "{" + "\"x\":" + this.bounds.right + "," + "\"y\":" + this.bounds.top + "}" + "},";
      }

      if (this.chartQueryFilterParameters && this.chartQueryFilterParameters.length) {
        var chartParamArray = [];
        var chartLength = this.chartQueryFilterParameters.length;

        for (var j = 0; j < chartLength; j++) {
          var chartQueryFilterParameter = this.chartQueryFilterParameters[j];

          if (!(chartQueryFilterParameter instanceof ChartQueryFilterParameter_ChartQueryFilterParameter)) {
            continue;
          }

          chartParamArray.push(chartQueryFilterParameter.toJson());
        }

        var chartParamsJson = "[" + chartParamArray.join(",") + "]";
        chartParamsJson = "\"chartQueryParams\":" + chartParamsJson + ",";
        chartParamsJson += "\"startRecord\":" + this.startRecord + ",";
        chartParamsJson += "\"expectCount\":" + this.expectCount;
        chartParamsJson = "{" + chartParamsJson + "}";
        json += "\"chartQueryParameters\":" + chartParamsJson;
      }

      json = "{" + json + "}";
      return json;
    }
  }]);

  return ChartQueryParameters;
}();
SuperMap.ChartQueryParameters = ChartQueryParameters_ChartQueryParameters;
// CONCATENATED MODULE: ./src/common/iServer/QueryParameters.js
function QueryParameters_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function QueryParameters_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function QueryParameters_createClass(Constructor, protoProps, staticProps) { if (protoProps) QueryParameters_defineProperties(Constructor.prototype, protoProps); if (staticProps) QueryParameters_defineProperties(Constructor, staticProps); return Constructor; }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/




/**
 * @class SuperMap.QueryParameters
 * @category  iServer Map QueryResults
 * @classdesc 查询参数基类。距离查询、SQL 查询、几何地物查询等各自的参数均继承此类。
 * @param {Object} options - 参数。
 * @param {Array.<SuperMap.FilterParameter>} options.queryParams - 查询过滤条件参数数组。
 * @param {string} [options.customParams] - 自定义参数，供扩展使用。
 * @param {Object} [options.prjCoordSys] - 自定义参数，供 SuperMap Online 提供的动态投影查询扩展使用。如 {"epsgCode":3857}。
 * @param {number} [options.expectCount=10000] - 期望返回结果记录个数。
 * @param {SuperMap.GeometryType} [options.networkType=SuperMap.GeometryType.LINE] - 网络数据集对应的查询类型。
 * @param {SuperMap.QueryOption} [options.queryOption=SuperMap.ATTRIBUTEANDGEOMETRY] - 查询结果类型枚举类。
 * @param {number} [options.startRecord=0] - 查询起始记录号。
 * @param {number} [options.holdTime=10] - 资源在服务端保存的时间,单位为分钟。
 * @param {boolean} [options.returnCustomResult=false] - 仅供三维使用。
 * @param {boolean} [options.returnFeatureWithFieldCaption = false] - 返回的查询结果要素字段标识是否为字段别名。为 false 时，返回的是字段名；为 true 时，返回的是字段别名。
 */

var QueryParameters_QueryParameters =
/*#__PURE__*/
function () {
  function QueryParameters(options) {
    QueryParameters_classCallCheck(this, QueryParameters);

    if (!options) {
      return;
    }
    /**
     * @member {string} [SuperMap.QueryParameters.prototype.customParams]
     * @description 自定义参数，供扩展使用。
     */


    this.customParams = null;
    /**
     * @member {Object} [SuperMap.QueryParameters.prototype.prjCoordSys]
     * @description 自定义参数，供 SuperMap Online 提供的动态投影查询扩展使用。如 {"epsgCode":3857}
     */

    this.prjCoordSys = null;
    /**
     * @member {number} [SuperMap.QueryParameters.prototype.expectCount=100000]
     * @description 期望返回结果记录个数，默认返回100000条查询记录，
     *              如果实际不足100000条则返回实际记录条数。
     */

    this.expectCount = 100000;
    /**
     * @member {SuperMap.GeometryType} [SuperMap.QueryParameters.prototype.networkType=SuperMap.GeometryType.LINE]
     * @description 网络数据集对应的查询类型，分为点和线两种类型。
     */

    this.networkType = GeometryType.LINE;
    /**
     * @member {SuperMap.QueryOption} [SuperMap.QueryParameters.prototype.queryOption=SuperMap.QueryOption.ATTRIBUTEANDGEOMETRY]
     * @description 查询结果类型枚举类。
     *              该类描述查询结果返回类型，包括只返回属性、
     *              只返回几何实体以及返回属性和几何实体。
     */

    this.queryOption = QueryOption.ATTRIBUTEANDGEOMETRY;
    /**
     * @member {Array.<SuperMap.FilterParameter>} SuperMap.QueryParameters.prototype.queryParams
     * @description 查询过滤条件参数数组。
     *              该类用于设置查询数据集的查询过滤参数。
     */

    this.queryParams = null;
    /**
     * @member {number} [SuperMap.QueryParameters.prototype.startRecord=0]
     * @description 查询起始记录号。
     */

    this.startRecord = 0;
    /**
     * @member {number} [SuperMap.QueryParameters.prototype.holdTime=10]
     * @description 资源在服务端保存的时间，单位为分钟。
     */

    this.holdTime = 10;
    /**
     * @member {boolean} [SuperMap.QueryParameters.prototype.returnCustomResult=false]
     * @description 仅供三维使用。
     */

    this.returnCustomResult = false;
    /**
     * @member {boolean} [SuperMap.QueryParameters.prototype.returnFeatureWithFieldCaption=false]
     * @description 返回的查询结果要素字段标识是否为字段别名。为 false 时，返回的是字段名；为 true 时，返回的是字段别名。
     */

    this.returnFeatureWithFieldCaption = false;
    Util.extend(this, options);
    this.CLASS_NAME = "SuperMap.QueryParameters";
  }
  /**
   * @function SuperMap.QueryParameters.prototype.destroy
   * @description 释放资源，将引用资源的属性置空。
   */


  QueryParameters_createClass(QueryParameters, [{
    key: "destroy",
    value: function destroy() {
      var me = this;
      me.customParams = null;
      me.expectCount = null;
      me.networkType = null;
      me.queryOption = null;

      if (me.queryParams) {
        for (var i = 0, qps = me.queryParams, len = qps.length; i < len; i++) {
          qps[i].destroy();
        }

        me.queryParams = null;
      }

      me.startRecord = null;
      me.holdTime = null;
      me.returnCustomResult = null;
      me.prjCoordSys = null;
    }
  }]);

  return QueryParameters;
}();
SuperMap.QueryParameters = QueryParameters_QueryParameters;
// CONCATENATED MODULE: ./src/common/iServer/ChartQueryService.js
function ChartQueryService_typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { ChartQueryService_typeof = function _typeof(obj) { return typeof obj; }; } else { ChartQueryService_typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return ChartQueryService_typeof(obj); }

function ChartQueryService_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function ChartQueryService_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function ChartQueryService_createClass(Constructor, protoProps, staticProps) { if (protoProps) ChartQueryService_defineProperties(Constructor.prototype, protoProps); if (staticProps) ChartQueryService_defineProperties(Constructor, staticProps); return Constructor; }

function ChartQueryService_possibleConstructorReturn(self, call) { if (call && (ChartQueryService_typeof(call) === "object" || typeof call === "function")) { return call; } return ChartQueryService_assertThisInitialized(self); }

function ChartQueryService_getPrototypeOf(o) { ChartQueryService_getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return ChartQueryService_getPrototypeOf(o); }

function ChartQueryService_assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function ChartQueryService_inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) ChartQueryService_setPrototypeOf(subClass, superClass); }

function ChartQueryService_setPrototypeOf(o, p) { ChartQueryService_setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return ChartQueryService_setPrototypeOf(o, p); }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/







/**
 * @class SuperMap.ChartQueryService
 * @category  iServer Map Chart
 * @classdesc 海图查询服务类。该类负责将海图查询所需参数（ChartQueryParameters）传递至服务端，并获取服务端的返回结果。
 *      用户可以通过两种方式获取查询结果：
 *      1.通过 AsyncResponder 类获取（推荐使用）；
 *      2.通过监听 QueryEvent.PROCESS_COMPLETE 事件获取。
 * @extends {SuperMap.CommonServiceBase}
 * @param {string} url - 地图查询服务访问地址。如："http://localhost:8090/iserver/services/map-ChartW/rest/maps/海图"。
 * @param {Object} options - 参数。
 * @param {Object} options.eventListeners - 事件监听器对象。有processCompleted属性可传入处理完成后的回调函数。processFailed属性传入处理失败后的回调函数。
 * @param {SuperMap.ServerType} [options.serverType=SuperMap.ServerType.ISERVER] - 服务器类型，iServer|iPortal|Online。
 * @param {SuperMap.DataFormat} [options.format] - 查询结果返回格式，目前支持 iServerJSON 和 GeoJSON 两种格式。参数格式为"ISERVER","GEOJSON"。
 * @param {boolean} [options.crossOrigin] - 是否允许跨域请求。
 * @param {Object} [options.headers] - 请求头。
 * @example
 * 下面示例显示了如何进行海图属性查询：
 * var nameArray = ["GB4X0000_52000"];
 * var chartQueryFilterParameter = new ChartQueryFilterParameter({
 *       isQueryPoint:true,
 *        isQueryLine:true,
 *        isQueryRegion:true,
 *        attributeFilter:"SmID<10",
 *        chartFeatureInfoSpecCode:1
 *    });
 *
 * var chartQueryParameters = new SuperMap.ChartQueryParameters({
 *        queryMode:"ChartAttributeQuery",
 *        chartLayerNames:nameArray,
 *        returnContent:true,
 *        chartQueryFilterParameters:[chartQueryFilterParameter]
 *    });
 *
 * var chartQueryService = new SuperMap.ChartQueryService(url);
 *
 * chartQueryService.events.on({
 *        "processCompleted":processCompleted,
 *        "processFailed":processFailed
 *    });
 * chartQueryService.processAsync(chartQueryParameters);
 */

var ChartQueryService_ChartQueryService =
/*#__PURE__*/
function (_CommonServiceBase) {
  ChartQueryService_inherits(ChartQueryService, _CommonServiceBase);

  function ChartQueryService(url, options) {
    var _this;

    ChartQueryService_classCallCheck(this, ChartQueryService);

    _this = ChartQueryService_possibleConstructorReturn(this, ChartQueryService_getPrototypeOf(ChartQueryService).call(this, url, options));
    options = options || {};
    /**
     * @member {boolean} SuperMap.ChartQueryService.prototype.returnContent
     * @description 是否立即返回新创建资源的表述还是返回新资源的URI。
     */

    _this.returnContent = null;
    /**
     * @member {SuperMap.DataFormat} SuperMap.ChartQueryService.prototype.format
     * @description 查询结果返回格式，目前支持iServerJSON 和GeoJSON两种格式
     *              参数格式为"ISERVER","GEOJSON",GEOJSON
     */

    _this.format = DataFormat.GEOJSON;
    Util.extend(ChartQueryService_assertThisInitialized(_this), options);

    var me = ChartQueryService_assertThisInitialized(_this),
        end;

    if (options.format) {
      me.format = options.format.toUpperCase();
    }

    if (!me.url) {
      return ChartQueryService_possibleConstructorReturn(_this);
    }

    end = me.url.substr(me.url.length - 1, 1); // TODO 待iServer featureResul资源GeoJSON表述bug修复当使用以下注释掉的逻辑
    // if (me.format==="geojson") {
    //     me.url += (end == "/") ? "featureResults.geojson?" : "/featureResults.geojson?";
    // } else {
    //     me.url += (end == "/") ? "featureResults.json?" : "/featureResults.json?";
    // }

    me.url += end === "/" ? "queryResults.json?" : "/queryResults.json?";
    _this.CLASS_NAME = "SuperMap.ChartQueryService";
    return _this;
  }
  /**
   * @function SuperMap.ChartQueryService.prototype.destroy
   * @override
   */


  ChartQueryService_createClass(ChartQueryService, [{
    key: "destroy",
    value: function destroy() {
      var me = this;
      CommonServiceBase_CommonServiceBase.prototype.destroy.apply(this, arguments);
      me.returnContent = null;
      me.format = null;
    }
    /**
     * @function SuperMap.ChartQueryService.prototype.processAsync
     * @description 使用服务地址 URL 实例化 ChartQueryService 对象。
     * @param {SuperMap.ChartQueryParameters} params - 查询参数。
     */

  }, {
    key: "processAsync",
    value: function processAsync(params) {
      //todo重点需要添加代码的地方
      if (!(params instanceof ChartQueryParameters_ChartQueryParameters)) {
        return;
      }

      var me = this,
          jsonParameters;
      me.returnContent = params.returnContent;
      jsonParameters = params.getVariablesJson();

      if (me.returnContent) {
        me.url += "returnContent=" + me.returnContent;
      }

      me.request({
        method: "POST",
        data: jsonParameters,
        scope: me,
        success: me.serviceProcessCompleted,
        failure: me.serviceProcessFailed
      });
    }
    /**
     * @function SuperMap.ChartQueryService.prototype.serviceProcessCompleted
     * @description 查询完成，执行此方法。
     * @param {Object} result - 服务器返回的结果对象。
     */

  }, {
    key: "serviceProcessCompleted",
    value: function serviceProcessCompleted(result) {
      var me = this;
      result = Util.transformResult(result);

      if (result && result.recordsets && me.format === DataFormat.GEOJSON) {
        for (var i = 0, recordsets = result.recordsets, len = recordsets.length; i < len; i++) {
          if (recordsets[i].features) {
            var geoJSONFormat = new GeoJSON_GeoJSON();
            recordsets[i].features = geoJSONFormat.toGeoJSON(recordsets[i].features);
          }
        }
      }

      me.events.triggerEvent("processCompleted", {
        result: result
      });
    }
    /**
     * @function SuperMap.ChartQueryService.prototype.getQueryParameters
     * @description 将 JSON 对象表示的查询参数转化为 QueryParameters 对象。
     * @param {Object} params - JSON 字符串表示的查询参数。
     * @returns {SuperMap.QueryParameters} 返回查询结果
     */

  }, {
    key: "getQueryParameters",
    value: function getQueryParameters(params) {
      return new QueryParameters_QueryParameters({
        queryMode: params.queryMode,
        bounds: params.bounds,
        chartLayerNames: params.chartLayerNames,
        chartQueryFilterParameters: params.chartQueryFilterParameters,
        returnContent: params.returnContent
      });
    }
  }]);

  return ChartQueryService;
}(CommonServiceBase_CommonServiceBase);
SuperMap.ChartQueryService = ChartQueryService_ChartQueryService;
// CONCATENATED MODULE: ./src/common/iServer/ClipParameter.js
function ClipParameter_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function ClipParameter_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function ClipParameter_createClass(Constructor, protoProps, staticProps) { if (protoProps) ClipParameter_defineProperties(Constructor.prototype, protoProps); if (staticProps) ClipParameter_defineProperties(Constructor, staticProps); return Constructor; }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/



/**
 * @class SuperMap.ClipParameter
 * @category iServer SpatialAnalyst InterpolationAnalyst
 * @classdesc 用于裁剪的参数。
 * @description 优先使用用户指定的裁剪区域多边形进行裁剪，也可以通过指定数据源和数据集名，从而使用指定数据集的边界多边形进行裁剪。
 * @param {Object} options - 参数。 
 * @param {string} [options.clipDatasetName] - 裁剪的数据集名。 
 * @param {string} [options.clipDatasourceName] - 裁剪的数据集所在数据源的名字。 
 * @param {(SuperMap.Geometry.Polygon|L.Polygon|L.GeoJSON|ol.geom.Polygon|ol.format.GeoJSON)} [options.clipRegion] - 用户指定的裁剪区域。 
 * @param {boolean} [options.isClipInRegion=true] - 是否对裁剪区内的数据集进行裁剪。 
 * @param {boolean} [options.isExactClip=true] - 是否使用精确裁剪。
 */

var ClipParameter_ClipParameter =
/*#__PURE__*/
function () {
  function ClipParameter(options) {
    ClipParameter_classCallCheck(this, ClipParameter);

    /**
     * @member {string} SuperMap.ClipParameter.prototype.clipDatasetName
     * @description 用于裁剪的数据集名，clipDatasetName 与 clipRegion 必须设置一个。
     */
    this.clipDatasetName = null;
    /**
     * @member {string} SuperMap.ClipParameter.prototype.clipDatasourceName
     * @description 用于裁剪的数据集所在数据源的名字。当 clipRegion 不设置时起作用。
     */

    this.clipDatasourceName = null;
    /**
     * @member {(SuperMap.Geometry.Polygon|L.Polygon|L.GeoJSON|ol.geom.Polygon|ol.format.GeoJSON)} SuperMap.ClipParameter.prototype.clipRegion
     * @description 用户指定的裁剪区域，优先使用，clipDatasetName 与 clipRegion 必须设置一个。 
     */

    this.clipRegion = null;
    /**
     * @member {boolean} [SuperMap.ClipParameter.prototype.isClipInRegion=true]
     * @description 是否对裁剪区内的数据集进行裁剪。若为 true，则对裁剪区域内的结果进行裁剪，若为 false，则对裁剪区域外的结果进行裁剪。 
     */

    this.isClipInRegion = true;
    /**
     * @member {boolean} [SuperMap.ClipParameter.prototype.isExactClip=true]
     * @description 是否使用精确裁剪。
     */

    this.isExactClip = null;

    if (options) {
      Util.extend(this, options);
    }

    this.CLASS_NAME = "SuperMap.ClipParameter";
  }
  /**
   * @function SuperMap.ClipParameter.prototype.destroy
   * @description 释放资源，将引用资源的属性置空。
   */


  ClipParameter_createClass(ClipParameter, [{
    key: "destroy",
    value: function destroy() {
      var me = this;
      me.clipDatasetName = null;
      me.clipDatasourceName = null;
      me.clipRegion = null;
      me.isClipInRegion = null;
      me.isExactClip = null;
    }
    /**
     * @function SuperMap.ClipParameter.prototype.toJSON
     * @description 将 ClipParameter 对象转化为 JSON 字符串。
     * @returns {string} 返回转换后的 JSON 字符串。
     */

  }, {
    key: "toJSON",
    value: function toJSON() {
      return Util.toJSON({
        isClipInRegion: this.isClipInRegion,
        clipDatasetName: this.clipDatasetName,
        clipDatasourceName: this.clipDatasourceName,
        isExactClip: this.isExactClip,
        clipRegion: ServerGeometry_ServerGeometry.fromGeometry(this.clipRegion)
      });
    }
  }]);

  return ClipParameter;
}();
SuperMap.ClipParameter = ClipParameter_ClipParameter;
// CONCATENATED MODULE: ./src/common/iServer/ColorDictionary.js
function ColorDictionary_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function ColorDictionary_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function ColorDictionary_createClass(Constructor, protoProps, staticProps) { if (protoProps) ColorDictionary_defineProperties(Constructor.prototype, protoProps); if (staticProps) ColorDictionary_defineProperties(Constructor, staticProps); return Constructor; }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/



/**
 * @class SuperMap.ColorDictionary
 * @category  iServer Map Theme
 * @classdesc 颜色对照表类。
 * @description 颜色对照表中的键名为具体的高程值，键值表示该高程值要显示的颜色。对于栅格图层中高程值小于颜色对照表中高程最小值的点使用颜色对照表中高程最小值对应的颜色，对于栅格图层中高程值大于颜色对照表中高程最大值的点使用颜色对照表中高程最大值对应的颜色，对于栅格图层中高程值在颜色对照表中没有对应颜色的点，则查找颜色对照表中与当前高程值相邻的两个高程对应的颜色，然后通过渐变运算要显示的颜色。如果设置了颜色对照表的话，则颜色表设置无效。
 * @param {Object} options - 参数。 
 * @param {number} options.elevation - 高程值。 
 * @param {SuperMap.ServerColor} options.color - 服务端颜色类。
 */

var ColorDictionary_ColorDictionary =
/*#__PURE__*/
function () {
  function ColorDictionary(options) {
    ColorDictionary_classCallCheck(this, ColorDictionary);

    options = options || {};
    /**
     * @member {number} SuperMap.ColorDictionary.prototype.elevation
     * @description 高程值。
     */

    this.elevation = null;
    /**
     * @member {SuperMap.ServerColor} SuperMap.ColorDictionary.prototype.color
     * @description 服务端颜色类。
     */

    this.color = null;
    Util.extend(this, options);
    var me = this,
        c = me.color;

    if (c) {
      me.color = new ServerColor(c.red, c.green, c.blue);
    }

    this.CLASS_NAME = "SuperMap.ColorDictionary";
  }
  /**
   * @function SuperMap.ColorDictionary.prototype.destroy
   * @description 释放资源，将引用资源的属性置空。
   */


  ColorDictionary_createClass(ColorDictionary, [{
    key: "destroy",
    value: function destroy() {
      Util.reset(this);
    }
    /**
     * @function SuperMap.ColorDictionary.prototype.toServerJSONObject
     * @description 转换成对应的 JSON 格式对象。
     * @returns {Object} JSON 对象。
     */

  }, {
    key: "toServerJSONObject",
    value: function toServerJSONObject() {
      var dataObj = {};
      dataObj = Util.copyAttributes(dataObj, this);
      return dataObj;
    }
  }]);

  return ColorDictionary;
}();
SuperMap.ColorDictionary = ColorDictionary_ColorDictionary;
// CONCATENATED MODULE: ./src/common/iServer/TransportationAnalystResultSetting.js
function TransportationAnalystResultSetting_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function TransportationAnalystResultSetting_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function TransportationAnalystResultSetting_createClass(Constructor, protoProps, staticProps) { if (protoProps) TransportationAnalystResultSetting_defineProperties(Constructor.prototype, protoProps); if (staticProps) TransportationAnalystResultSetting_defineProperties(Constructor, staticProps); return Constructor; }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


/**
 * @class SuperMap.TransportationAnalystResultSetting
 * @category  iServer NetworkAnalyst
 * @classdesc 交通网络分析结果参数类。
 * @description 通过该类设置交通网络分析返回的结果，包括是否返回图片、是否返回弧段空间信息、是否返回结点空间信息等。
 * @param {Object} options - 参数。
 * @param {boolean} [options.returnEdgeFeatures=false] - 是否在分析结果中包含弧段要素集合。
 * @param {boolean} [options.returnEdgeGeometry=false] - 返回的弧段要素集合中是否包含几何对象信息。
 * @param {boolean} [options.returnEdgeIDs=false] - 返回结果中是否包含经过弧段 ID 集合。
 * @param {boolean} [options.returnNodeFeatures=false] - 是否在分析结果中包含结点要素集合。
 * @param {boolean} [options.returnNodeGeometry=false] - 返回的结点要素集合中是否包含几何对象信息。
 * @param {boolean} [options.returnNodeIDs=false] - 返回结果中是否包含经过结点 ID 集合。
 * @param {boolean} [options.returnPathGuides=false] - 返回分析结果中是否包含行驶导引集合。
 * @param {boolean} [options.returnRoutes=false] - 返回分析结果中是否包含路由对象的集合。
 */

var TransportationAnalystResultSetting_TransportationAnalystResultSetting =
/*#__PURE__*/
function () {
  function TransportationAnalystResultSetting(options) {
    TransportationAnalystResultSetting_classCallCheck(this, TransportationAnalystResultSetting);

    if (!options) {
      return;
    }
    /**
     * @member {boolean} SuperMap.TransportationAnalystResultSetting.prototype.returnEdgeFeatures
     * @description 是否在分析结果中包含弧段要素集合。弧段要素包括弧段的空间信息和属性信息。
     */


    this.returnEdgeFeatures = false;
    /**
     * @member {boolean} [SuperMap.TransportationAnalystResultSetting.prototype.returnEdgeGeometry=false]
     * @description 返回的弧段要素集合中是否包含几何对象信息。
     */

    this.returnEdgeGeometry = false;
    /**
     * @member {boolean} [SuperMap.TransportationAnalystResultSetting.prototype.returnEdgeIDs=false]
     * @description 返回结果中是否包含经过弧段 ID 集合。
     */

    this.returnEdgeIDs = false;
    /**
     * @member {boolean} [SuperMap.TransportationAnalystResultSetting.prototype.returnNodeFeatures=false]
     * @description 是否在分析结果中包含结点要素集合。
     * 结点要素包括结点的空间信息和属性信息。其中返回的结点要素是否包含空间信息可通过 returnNodeGeometry 字段设置。
     */

    this.returnNodeFeatures = false;
    /**
     * @member {boolean} [SuperMap.TransportationAnalystResultSetting.prototype.returnNodeGeometry=false]
     * @description 返回的结点要素集合中是否包含几何对象信息。
     */

    this.returnNodeGeometry = false;
    /**
     * @member {boolean} [SuperMap.TransportationAnalystResultSetting.prototype.returnNodeIDs=false]
     * @description 返回结果中是否包含经过结点 ID 集合。
     */

    this.returnNodeIDs = false;
    /**
     * @member {boolean} SuperMap.TransportationAnalystResultSetting.prototype.returnPathGuides
     * @description 返回分析结果中是否包含行驶导引集合。
     */

    this.returnPathGuides = false;
    /**
     * @member {boolean} SuperMap.TransportationAnalystResultSetting.prototype.returnRoutes
     * @description 返回分析结果中是否包含路由对象的集合。
     */

    this.returnRoutes = false;
    Util.extend(this, options);
    this.CLASS_NAME = "SuperMap.TransportationAnalystResultSetting";
  }
  /**
   * @function SuperMap.TransportationAnalystResultSetting.prototype.destroy
   * @description 释放资源，将引用资源的属性置空。
   */


  TransportationAnalystResultSetting_createClass(TransportationAnalystResultSetting, [{
    key: "destroy",
    value: function destroy() {
      var me = this;
      me.returnEdgeFeatures = null;
      me.returnEdgeGeometry = null;
      me.returnEdgeIDs = null;
      me.returnNodeFeatures = null;
      me.returnNodeGeometry = null;
      me.returnNodeIDs = null;
      me.returnPathGuides = null;
      me.returnRoutes = null;
    }
  }]);

  return TransportationAnalystResultSetting;
}();
SuperMap.TransportationAnalystResultSetting = TransportationAnalystResultSetting_TransportationAnalystResultSetting;
// CONCATENATED MODULE: ./src/common/iServer/TransportationAnalystParameter.js
function TransportationAnalystParameter_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function TransportationAnalystParameter_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function TransportationAnalystParameter_createClass(Constructor, protoProps, staticProps) { if (protoProps) TransportationAnalystParameter_defineProperties(Constructor.prototype, protoProps); if (staticProps) TransportationAnalystParameter_defineProperties(Constructor, staticProps); return Constructor; }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/



/**
 * @class SuperMap.TransportationAnalystParameter
 * @category  iServer NetworkAnalyst
 * @classdesc 交通网络分析通用参数类。
 * @description 该类主要用来提供交通网络分析所需的通用参数。
 * 通过本类可以设置障碍边、障碍点、权值字段信息的名称标识、转向权值字段等信息，还可以对分析结果包含的内容进行一些设置。
 * @param {Object} options - 参数。
 * @param {Array.<number>} options.barrierEdgeIDs - 网络分析中障碍弧段的 ID 数组。
 * @param {Array.<number>} options.barrierNodeIDs - 网络分析中障碍点的 ID 数组。
 * @param {string} options.turnWeightField - 转向权重字段的名称。
 * @param {SuperMap.TransportationAnalystResultSetting} options.resultSetting - 分析结果返回内容。
 * @param {Array.<(SuperMap.Geometry.Point|L.Point|L.LatLng|ol.geom.Point)>} [options.barrierPoints] - 网络分析中 Point2D 类型的障碍点数组。
 * @param {string} [options.weightFieldName] - 阻力字段的名称。
 */

var TransportationAnalystParameter_TransportationAnalystParameter =
/*#__PURE__*/
function () {
  function TransportationAnalystParameter(options) {
    TransportationAnalystParameter_classCallCheck(this, TransportationAnalystParameter);

    if (!options) {
      return;
    }
    /**
     * @member {Array.<number>} SuperMap.TransportationAnalystParameter.prototype.barrierEdgeIDs
     * @description 网络分析中障碍弧段的 ID 数组。弧段设置为障碍边之后，表示双向都不通。
     */


    this.barrierEdgeIDs = null;
    /**
     * @member {Array.<number>} SuperMap.TransportationAnalystParameter.prototype.barrierNodeIDs
     * @description 网络分析中障碍点的 ID 数组。结点设置为障碍点之后，表示任何方向都不能通过此结点。
     */

    this.barrierNodeIDs = null;
    /**
     * @member {Array.<(SuperMap.Geometry.Point|L.Point|L.LatLng|ol.geom.Point)>}  SuperMap.TransportationAnalystParameter.prototype.barrierPoints
     * @description 网络分析中 Point2D 类型的障碍点数组。障碍点表示任何方向都不能通过此点。</br>
     * 当各网络分析参数类中的 isAnalyzeById 属性设置为 false 时，该属性才生效。
     */

    this.barrierPoints = null;
    /**
     * @member {string} [SuperMap.TransportationAnalystParameter.prototype.weightFieldName]
     * @description 阻力字段的名称，标识了进行网络分析时所使用的阻力字段，例如表示时间、长度等的字段都可以用作阻力字段。
     * 该字段默值为服务器发布的所有耗费字段的第一个字段。
     */

    this.weightFieldName = null;
    /**
     * @member {string} SuperMap.TransportationAnalystParameter.prototype.turnWeightField
     * @description 转向权重字段的名称。
     */

    this.turnWeightField = null;
    /**
     *  @member {SuperMap.TransportationAnalystResultSetting} SuperMap.TransportationAnalystParameter.prototype.resultSetting
     *  @description 分析结果返回内容。
     */

    this.resultSetting = new TransportationAnalystResultSetting_TransportationAnalystResultSetting();
    Util.extend(this, options);
    this.CLASS_NAME = "SuperMap.TransportationAnalystParameter";
  }
  /**
   * @function SuperMap.TransportationAnalystParameter.prototype.destroy
   * @description 释放资源，将引用资源的属性置空。
   */


  TransportationAnalystParameter_createClass(TransportationAnalystParameter, [{
    key: "destroy",
    value: function destroy() {
      var me = this;
      me.barrierEdgeIDs = null;
      me.barrierNodeIDs = null;
      me.weightFieldName = null;
      me.turnWeightField = null;

      if (me.resultSetting) {
        me.resultSetting.destroy();
        me.resultSetting = null;
      }

      if (me.barrierPoints && me.barrierPoints.length) {
        for (var i in me.barrierPoints) {
          me.barrierPoints[i].destroy();
        }
      }

      me.barrierPoints = null;
    }
  }]);

  return TransportationAnalystParameter;
}();
SuperMap.TransportationAnalystParameter = TransportationAnalystParameter_TransportationAnalystParameter;
// CONCATENATED MODULE: ./src/common/iServer/ComputeWeightMatrixParameters.js
function ComputeWeightMatrixParameters_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function ComputeWeightMatrixParameters_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function ComputeWeightMatrixParameters_createClass(Constructor, protoProps, staticProps) { if (protoProps) ComputeWeightMatrixParameters_defineProperties(Constructor.prototype, protoProps); if (staticProps) ComputeWeightMatrixParameters_defineProperties(Constructor, staticProps); return Constructor; }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/



/**
 * @class SuperMap.ComputeWeightMatrixParameters
 * @category iServer NetworkAnalyst WeightMatrix
 * @classdesc 耗费矩阵分析参数类。根据交通网络分析参数中的耗费字段返回一个耗费矩阵。该矩阵是一个二维数组，用来存储任意两点间的资源消耗。
 * @param {Object} options - 参数。 
 * @param {boolean} [options.isAnalyzeById=false] - 是否通过节点 ID 指定路径分析的结点。 
 * @param {Array.<SuperMap.Geometry.Point|L.LatLng|L.Point|ol.geom.Point|number>} options.nodes - 要计算耗费矩阵的点数组。 
 * @param {SuperMap.TransportationAnalystParameter} [options.parameter] - 交通网络分析通用参数。
 */

var ComputeWeightMatrixParameters_ComputeWeightMatrixParameters =
/*#__PURE__*/
function () {
  function ComputeWeightMatrixParameters(options) {
    ComputeWeightMatrixParameters_classCallCheck(this, ComputeWeightMatrixParameters);

    /**
     * @member {boolean} [SuperMap.ComputeWeightMatrixParameters.prototype.isAnalyzeById=false]
     * @description 是否通过节点 ID 指定路径分析的结点，即通过坐标点指定。
     */
    this.isAnalyzeById = false;
    /**
     * @member {Array.<SuperMap.Geometry.Point|L.LatLng|L.Point|ol.geom.Point|number>} SuperMap.ComputeWeightMatrixParameters.prototype.nodes
     * @description 要计算耗费矩阵的点数组。
     *              当 {@link SuperMap.ComputeWeightMatrixParameters.isAnalyzeById} = false 时，nodes 应为点的坐标数组；
     *              当 {@link SuperMap.ComputeWeightMatrixParameters.isAnalyzeById} = true 时，nodes 应为点的 ID 数组。
     */

    this.nodes = null;
    /**
     * @member {SuperMap.TransportationAnalystParameter} SuperMap.ComputeWeightMatrixParameters.prototype.parameter
     * @description 交通网络分析通用参数。
     */

    this.parameter = new TransportationAnalystParameter_TransportationAnalystParameter();
    Util.extend(this, options);
    this.CLASS_NAME = "SuperMap.ComputeWeightMatrixParameters";
  }
  /**
   * @function SuperMap.ComputeWeightMatrixParameters.prototype.destroy
   * @description 释放资源，将引用资源的属性置空。
   */


  ComputeWeightMatrixParameters_createClass(ComputeWeightMatrixParameters, [{
    key: "destroy",
    value: function destroy() {
      var me = this;
      me.isAnalyzeById = null;
      me.nodes = null;

      if (me.parameter) {
        me.parameter.destroy();
        me.parameter = null;
      }
    }
  }]);

  return ComputeWeightMatrixParameters;
}();
SuperMap.ComputeWeightMatrixParameters = ComputeWeightMatrixParameters_ComputeWeightMatrixParameters;
// CONCATENATED MODULE: ./src/common/iServer/ComputeWeightMatrixService.js
function ComputeWeightMatrixService_typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { ComputeWeightMatrixService_typeof = function _typeof(obj) { return typeof obj; }; } else { ComputeWeightMatrixService_typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return ComputeWeightMatrixService_typeof(obj); }

function ComputeWeightMatrixService_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function ComputeWeightMatrixService_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function ComputeWeightMatrixService_createClass(Constructor, protoProps, staticProps) { if (protoProps) ComputeWeightMatrixService_defineProperties(Constructor.prototype, protoProps); if (staticProps) ComputeWeightMatrixService_defineProperties(Constructor, staticProps); return Constructor; }

function ComputeWeightMatrixService_possibleConstructorReturn(self, call) { if (call && (ComputeWeightMatrixService_typeof(call) === "object" || typeof call === "function")) { return call; } return ComputeWeightMatrixService_assertThisInitialized(self); }

function ComputeWeightMatrixService_assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function ComputeWeightMatrixService_get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { ComputeWeightMatrixService_get = Reflect.get; } else { ComputeWeightMatrixService_get = function _get(target, property, receiver) { var base = ComputeWeightMatrixService_superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return ComputeWeightMatrixService_get(target, property, receiver || target); }

function ComputeWeightMatrixService_superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = ComputeWeightMatrixService_getPrototypeOf(object); if (object === null) break; } return object; }

function ComputeWeightMatrixService_getPrototypeOf(o) { ComputeWeightMatrixService_getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return ComputeWeightMatrixService_getPrototypeOf(o); }

function ComputeWeightMatrixService_inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) ComputeWeightMatrixService_setPrototypeOf(subClass, superClass); }

function ComputeWeightMatrixService_setPrototypeOf(o, p) { ComputeWeightMatrixService_setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return ComputeWeightMatrixService_setPrototypeOf(o, p); }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/




/**
 * @class SuperMap.ComputeWeightMatrixService
 * @category  iServer NetworkAnalyst WeightMatrix
 * @classdesc 耗费矩阵分析服务类。
 *            耗费矩阵是根据交通网络分析参数中的耗费字段来计算一个二维数组，
 *            用来存储指定的任意两点间的资源消耗。
 *            耗费矩阵分析结果通过该类支持的事件的监听函数参数获取
 * @extends {SuperMap.NetworkAnalystServiceBase}
 * @example
 * var mycomputeWeightMatrixService = new SuperMap.ComputeWeightMatrixService(url,{
 *     eventListeners: {
 *	       "processCompleted": computeWeightMatrixCompleted,
 *		   "processFailed": computeWeightMatrixnError
 *	   }
 * });
 * @param {string} url - 耗费矩阵分析服务地址。请求服务的URL应为：
 *                       http://{服务器地址}:{服务端口号}/iserver/services/{网络分析服务名}/rest/networkanalyst/{网络数据集@数据源}；
 *                       例如："http://localhost:8090/iserver/services/components-rest/rest/networkanalyst/RoadNet@Changchun"。
 * @param {Object} options - 参数。
 * @param {Object} options.eventListeners - 需要被注册的监听器对象。
 * @param {boolean} [options.crossOrigin] - 是否允许跨域请求。
 * @param {Object} [options.headers] - 请求头。
 */

var ComputeWeightMatrixService_ComputeWeightMatrixService =
/*#__PURE__*/
function (_NetworkAnalystServic) {
  ComputeWeightMatrixService_inherits(ComputeWeightMatrixService, _NetworkAnalystServic);

  function ComputeWeightMatrixService(url, options) {
    var _this;

    ComputeWeightMatrixService_classCallCheck(this, ComputeWeightMatrixService);

    _this = ComputeWeightMatrixService_possibleConstructorReturn(this, ComputeWeightMatrixService_getPrototypeOf(ComputeWeightMatrixService).call(this, url, options));
    _this.CLASS_NAME = "SuperMap.ComputeWeightMatrixService";
    return _this;
  }
  /**
   * @function SuperMap.ComputeWeightMatrixService.prototype.destroy
   * @override
   */


  ComputeWeightMatrixService_createClass(ComputeWeightMatrixService, [{
    key: "destroy",
    value: function destroy() {
      ComputeWeightMatrixService_get(ComputeWeightMatrixService_getPrototypeOf(ComputeWeightMatrixService.prototype), "destroy", this).call(this);
    }
    /**
     * @function SuperMap.ComputeWeightMatrixService.prototype.processAsync
     * @description 负责将客户端的查询参数传递到服务端。
     * @param {SuperMap.ComputeWeightMatrixParameters} params - 耗费矩阵分析参数类
     */

  }, {
    key: "processAsync",
    value: function processAsync(params) {
      if (!(params instanceof ComputeWeightMatrixParameters_ComputeWeightMatrixParameters)) {
        return;
      }

      var me = this,
          jsonObject,
          end = me.url.substr(me.url.length - 1, 1);
      me.url = me.url + (end === "/" ? "weightmatrix" : "/weightmatrix") + ".json?";
      jsonObject = {
        parameter: Util.toJSON(params.parameter),
        nodes: me.getJson(params.isAnalyzeById, params.nodes)
      };
      me.request({
        method: "GET",
        params: jsonObject,
        scope: me,
        success: me.serviceProcessCompleted,
        failure: me.serviceProcessFailed
      });
    }
    /**
     * @function SuperMap.ComputeWeightMatrixService.prototype.getJson
     * @description 将对象转化为JSON字符串。
     * @param {boolean} isAnalyzeById - 是否通过id分析
     * @param {Array.<SuperMap.ComputeWeightMatrixParameters>} params - 分析参数数组
     * @returns {string} 转化后的JSON字符串。
     */

  }, {
    key: "getJson",
    value: function getJson(isAnalyzeById, params) {
      var jsonString = "[",
          len = params ? params.length : 0;

      if (isAnalyzeById === false) {
        for (var i = 0; i < len; i++) {
          if (i > 0) {
            jsonString += ",";
          }

          jsonString += '{"x":' + params[i].x + ',"y":' + params[i].y + '}';
        }
      } else if (isAnalyzeById === true) {
        for (var _i = 0; _i < len; _i++) {
          if (_i > 0) {
            jsonString += ",";
          }

          jsonString += params[_i];
        }
      }

      jsonString += ']';
      return jsonString;
    }
  }]);

  return ComputeWeightMatrixService;
}(NetworkAnalystServiceBase_NetworkAnalystServiceBase);
SuperMap.ComputeWeightMatrixService = ComputeWeightMatrixService_ComputeWeightMatrixService;
// CONCATENATED MODULE: ./src/common/iServer/DataFlowService.js
function DataFlowService_typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { DataFlowService_typeof = function _typeof(obj) { return typeof obj; }; } else { DataFlowService_typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return DataFlowService_typeof(obj); }

function DataFlowService_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function DataFlowService_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function DataFlowService_createClass(Constructor, protoProps, staticProps) { if (protoProps) DataFlowService_defineProperties(Constructor.prototype, protoProps); if (staticProps) DataFlowService_defineProperties(Constructor, staticProps); return Constructor; }

function DataFlowService_possibleConstructorReturn(self, call) { if (call && (DataFlowService_typeof(call) === "object" || typeof call === "function")) { return call; } return DataFlowService_assertThisInitialized(self); }

function DataFlowService_getPrototypeOf(o) { DataFlowService_getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return DataFlowService_getPrototypeOf(o); }

function DataFlowService_assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function DataFlowService_inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) DataFlowService_setPrototypeOf(subClass, superClass); }

function DataFlowService_setPrototypeOf(o, p) { DataFlowService_setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return DataFlowService_setPrototypeOf(o, p); }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/




/**
 * @class SuperMap.DataFlowService
 * @category iServer DataFlow
 * @classdesc 数据流服务类
 * @extends {SuperMap.CommonServiceBase}
 * @param {string} url - 数据流服务地址
 * @param {Object} options - 参数。
 * @param {function} options.style - 设置数据加载样式。
 * @param {function} [options.onEachFeature] - 设置每个数据加载popup等。
 * @param {GeoJSONObject} [options.geometry] - 指定几何范围，该范围内的要素才能被订阅。
 * @param {Object} [options.excludeField] - -排除字段。
 * @param {boolean} [options.crossOrigin] - 是否允许跨域请求。
 * @param {Object} [options.headers] - 请求头。
 */

var DataFlowService_DataFlowService =
/*#__PURE__*/
function (_CommonServiceBase) {
  DataFlowService_inherits(DataFlowService, _CommonServiceBase);

  function DataFlowService(url, options) {
    var _this;

    DataFlowService_classCallCheck(this, DataFlowService);

    options = options || {};
    /*
     * @constant EVENT_TYPES
     * {Array.<string>}
     * 此类支持的事件类型
     */

    options.EVENT_TYPES = ["broadcastSocketConnected", "broadcastSocketError", "broadcastFailed", "broadcastSucceeded", "subscribeSocketConnected", "subscribeSocketError", "messageSucceeded", "setFilterParamSucceeded"];
    _this = DataFlowService_possibleConstructorReturn(this, DataFlowService_getPrototypeOf(DataFlowService).call(this, url, options));
    /**
     * @member {GeoJSONObject} SuperMap.DataFlowService.prototype.geometry
     * @description 指定几何范围，该范围内的要素才能被订阅。
     */

    _this.geometry = null;
    /**
     * @member {Object} SuperMap.DataFlowService.prototype.prjCoordSys
     * @description 动态投影参数
     */

    _this.prjCoordSys = null;
    /**
     * @member {Object} SuperMap.DataFlowService.prototype.excludeField
     * @description 排除字段
     */

    _this.excludeField = null;

    var me = DataFlowService_assertThisInitialized(_this);

    var end = me.url.substr(me.url.length - 1, 1);

    if (end !== '/') {
      me.url += "/";
    }

    Util.extend(me, options);
    _this.CLASS_NAME = "SuperMap.DataFlowService";
    return _this;
  }
  /**
   * @function SuperMap.DataFlowService.prototype.initBroadcast
   * @description 初始化广播
   * @returns {SuperMap.DataFlowService}
   */


  DataFlowService_createClass(DataFlowService, [{
    key: "initBroadcast",
    value: function initBroadcast() {
      var me = this;
      this.broadcastWebSocket = this._connect(me.url + 'broadcast');

      this.broadcastWebSocket.onopen = function (e) {
        me.broadcastWebSocket.isOpen = true;
        e.eventType = 'broadcastSocketConnected';
        me.events.triggerEvent('broadcastSocketConnected', e);
      };

      this.broadcastWebSocket.onclose = function (e) {
        me.broadcastWebSocket.isOpen = false;
        e.eventType = 'broadcastSocketConnected';
        me.events.triggerEvent('broadcastSocketConnected', e);
      };

      this.broadcastWebSocket.onerror = function (e) {
        e.eventType = 'broadcastSocketError';
        me.events.triggerEvent('broadcastSocketError', e);
      };

      return this;
    }
    /**
     * @function SuperMap.DataFlowService.prototype.broadcast
     * @description 加载广播数据。
     * @param {GeoJSONObject} geoJSONFeature - JSON 格式的要素数据。
     */

  }, {
    key: "broadcast",
    value: function broadcast(geoJSONFeature) {
      if (!this.broadcastWebSocket || !this.broadcastWebSocket.isOpen) {
        this.events.triggerEvent('broadcastFailed');
        return;
      }

      this.broadcastWebSocket.send(JSON.stringify(geoJSONFeature));
      this.events.triggerEvent('broadcastSucceeded');
    }
    /**
     * @function SuperMap.DataFlowService.prototype.initSubscribe
     * @description 初始化订阅数据
     * @returns {this} this
     */

  }, {
    key: "initSubscribe",
    value: function initSubscribe() {
      var me = this;
      this.subscribeWebSocket = this._connect(this.url + 'subscribe');

      this.subscribeWebSocket.onopen = function (e) {
        me.subscribeWebSocket.send(me._getFilterParams());
        e.eventType = 'subscribeSocketConnected';
        me.events.triggerEvent('subscribeSocketConnected', e);
      };

      this.subscribeWebSocket.onerror = function (e) {
        e.eventType = 'subscribeSocketError';
        me.events.triggerEvent('subscribeSocketError', e);
      };

      this.subscribeWebSocket.onmessage = function (e) {
        me._onMessage(e);
      };

      return this;
    }
    /**
     * @function SuperMap.DataFlowService.prototype.setExcludeField
     * @description 设置排除字段
     * @param {Object} excludeField - 排除字段
     * @returns {this} this
     */

  }, {
    key: "setExcludeField",
    value: function setExcludeField(excludeField) {
      this.excludeField = excludeField;
      this.subscribeWebSocket.send(this._getFilterParams());
      return this;
    }
    /**
     * @function SuperMap.DataFlowService.prototype.setGeometry
     * @description 设置添加的几何要素数据
     * @param {GeoJSONObject} geometry - 指定几何范围，该范围内的要素才能被订阅。
     * @returns {this} this
     */

  }, {
    key: "setGeometry",
    value: function setGeometry(geometry) {
      this.geometry = geometry;
      this.subscribeWebSocket.send(this._getFilterParams());
      return this;
    }
    /**
     * @function SuperMap.DataFlowService.prototype.unSubscribe
     * @description 结束订阅数据
     */

  }, {
    key: "unSubscribe",
    value: function unSubscribe() {
      if (!this.subscribeWebSocket) {
        return;
      }

      this.subscribeWebSocket.close();
      this.subscribeWebSocket = null;
    }
    /**
     * @function SuperMap.DataFlowService.prototype.unBroadcast
     * @description 结束加载广播
     */

  }, {
    key: "unBroadcast",
    value: function unBroadcast() {
      if (!this.broadcastWebSocket) {
        return;
      }

      this.broadcastWebSocket.close();
      this.broadcastWebSocket = null;
    }
    /**
     * @function SuperMap.DataFlowService.prototype.destroy
     * @override
     */

  }, {
    key: "destroy",
    value: function destroy() {
      CommonServiceBase_CommonServiceBase.prototype.destroy.apply(this, arguments);
      var me = this;
      me.geometry = null;
      me.prjCoordSys = null;
      me.excludeField = null;
      this.unBroadcast();
      this.unSubscribe();
    }
  }, {
    key: "_getFilterParams",
    value: function _getFilterParams() {
      var filter = {
        filterParam: {
          prjCoordSys: this.prjCoordSys,
          excludeField: this.excludeField,
          geometry: this.geometry
        }
      };
      return Util.toJSON(filter);
    }
  }, {
    key: "_onMessage",
    value: function _onMessage(e) {
      if (e.data && e.data.indexOf("filterParam") >= 0) {
        var filterParam = JSON.parse(e.data);
        e.filterParam = filterParam;
        e.eventType = 'setFilterParamSucceeded';
        this.events.triggerEvent('setFilterParamSucceeded', e);
        return;
      }

      var feature = JSON.parse(e.data);
      e.featureResult = feature;
      e.eventType = 'messageSucceeded';
      this.events.triggerEvent('messageSucceeded', e);
    }
  }, {
    key: "_connect",
    value: function _connect(url) {
      url = this._appendCredentials(url);

      if ("WebSocket" in window) {
        return new WebSocket(url);
      } else if ("MozWebSocket" in window) {
        var mozWebSocket = window.MozWebSocket;
        return new mozWebSocket(url);
      } else {
        console.log("no WebSocket");
        return null;
      }
    }
  }, {
    key: "_appendCredentials",
    value: function _appendCredentials(url) {
      var token = SecurityManager_SecurityManager.getToken(url);

      if (token) {
        url += "?token=" + token;
      }

      return url;
    }
  }]);

  return DataFlowService;
}(CommonServiceBase_CommonServiceBase);
SuperMap.DataFlowService = DataFlowService_DataFlowService;
// CONCATENATED MODULE: ./src/common/iServer/DatasetInfo.js
function DatasetInfo_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function DatasetInfo_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function DatasetInfo_createClass(Constructor, protoProps, staticProps) { if (protoProps) DatasetInfo_defineProperties(Constructor.prototype, protoProps); if (staticProps) DatasetInfo_defineProperties(Constructor, staticProps); return Constructor; }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/



/**
 * @class SuperMap.DatasetInfo
 * @category  iServer Data
 * @classdesc 数据集信息类。
 * @description 数据集一般为存储在一起的相关数据的集合；根据数据类型的不同，分为矢量数据集、栅格数据集（griddataset）和
 * 影像数据集（image dataset），以及为了处理特定问题而设计的数据集，如拓扑数据集，网络数据集等。
 * 数据集是 GIS 数据组织的最小单位。其中矢量数据集是由同种类型空间要素组成的集合，
 * 所以也可以称为要素集。根据要素的空间特征的不同，矢量数据集又分为点数据集，
 * 线数据集，面数据集等，各矢量数据集是空间特征和性质相同的数据组织起来的集合。
 * 目前版本支持的数据集主要有点数据集，线数据集，面数据集，文本数据集，复合数据集（CAD 数据集）、
 * 网络数据集，栅格数据集（grid dataset）和影像数据集（image dataset）。
 * @param {Object} options - 参数。 
 * @param {SuperMap.Bounds} [options.bounds] - 数据集范围，该字段只读。 
 * @param {string} [options.dataSourceName] - 数据源名称，该字段只读。 
 * @param {string} [options.description] - 数据集的描述信息。 
 * @param {string} [options.encodeType] - 数据集存储时的压缩编码方式，该字段只读。 
 * @param {boolean} [options.isReadOnly] - 数据集是否为只读。 
 * @param {string} options.name - 数据集名称，该字段必须且只读。 
 * @param {SuperMap.Projection} [options.prjCoordSys] - 数据集的投影信息。 
 * @param {string} [options.tableName] - 表名，该字段只读。 
 * @param {string} options.type - 数据集类型。主要有点数据集，线数据集，面数据集，文本数据集，复合数据集（CAD 数据集）、网络数据集，栅格数据集（grid dataset）和影像数据集（image dataset）。
 */

var DatasetInfo_DatasetInfo =
/*#__PURE__*/
function () {
  function DatasetInfo(options) {
    DatasetInfo_classCallCheck(this, DatasetInfo);

    options = options || {};
    /**
     * @member {SuperMap.Bounds} [SuperMap.DatasetInfo.prototype.bounds]
     * @description 数据集范围，该字段只读。
     */

    this.bounds = null;
    /**
     * @member {string} [SuperMap.DatasetInfo.prototype.dataSourceName]
     * @description 数据源名称，该字段只读。
     */

    this.dataSourceName = null;
    /**
     * @member {string} [SuperMap.DatasetInfo.prototype.description]
     * @description 数据集的描述信息。
     */

    this.description = null;
    /**
     * @member {string} [SuperMap.DatasetInfo.prototype.encodeType]
     * @description 数据集存储时的压缩编码方式，该字段只读。
     */

    this.encodeType = null;
    /**
     * @member {boolean} [SuperMap.DatasetInfo.prototype.isReadOnly]
     * @description 数据集是否为只读。
     */

    this.isReadOnly = null;
    /**
     * @member {string} SuperMap.DatasetInfo.prototype.name
     * @description 数据集名称，该字段必须且只读。
     */

    this.name = null;
    /**
     * @member {SuperMap.Projection} [SuperMap.DatasetInfo.prototype.prjCoordSys]
     * @description 数据集的投影信息。
     */

    this.prjCoordSys = null;
    /**
     * @member {string} [SuperMap.DatasetInfo.prototype.tableName]
     * @description 表名，该字段只读。
     */

    this.tableName = null;
    /**
     * @member {string} SuperMap.DatasetInfo.prototype.type
     * @description 数据集类型，该字段必设。主要有点数据集，线数据集，面数据集，文本数据集，复合数据集（CAD 数据集）、网络数据集，栅格数据集（grid dataset）和影像数据集（image dataset）。
     */

    this.type = null;
    Util.extend(this, options);
    var b = this.bounds;

    if (b) {
      this.bounds = new Bounds_Bounds(b.leftBottom.x, b.leftBottom.y, b.rightTop.x, b.rightTop.y);
    }

    this.CLASS_NAME = "SuperMap.DatasetInfo";
  }
  /**
   * @function SuperMap.DatasetInfo.prototype.destroy
   * @description 释放资源，将引用资源的属性置空。
   */


  DatasetInfo_createClass(DatasetInfo, [{
    key: "destroy",
    value: function destroy() {
      Util.reset(this);
    }
    /**
     * @function SuperMap.DatasetInfo.prototype.toServerJSONObject
     * @description 转换成对应的 JSON 格式对象。
     * @returns {Object} JSON 对象。
     */

  }, {
    key: "toServerJSONObject",
    value: function toServerJSONObject() {
      var dataObj = {};
      dataObj = Util.copyAttributes(dataObj, this);

      if (dataObj.bounds) {
        if (dataObj.bounds.toServerJSONObject) {
          dataObj.bounds = dataObj.bounds.toServerJSONObject();
        }
      }

      return dataObj;
    }
  }]);

  return DatasetInfo;
}();
SuperMap.DatasetInfo = DatasetInfo_DatasetInfo;
// CONCATENATED MODULE: ./src/common/iServer/OverlayAnalystParameters.js
function OverlayAnalystParameters_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function OverlayAnalystParameters_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function OverlayAnalystParameters_createClass(Constructor, protoProps, staticProps) { if (protoProps) OverlayAnalystParameters_defineProperties(Constructor.prototype, protoProps); if (staticProps) OverlayAnalystParameters_defineProperties(Constructor, staticProps); return Constructor; }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/



/**
 * @class SuperMap.OverlayAnalystParameters
 * @category  iServer SpatialAnalyst OverlayAnalyst
 * @classdesc 叠加分析参数基类。数据集叠加分析参数和几何对象叠加分析参数均继承此基类。
 * @param {Object} options - 参数。
 */

var OverlayAnalystParameters_OverlayAnalystParameters =
/*#__PURE__*/
function () {
  function OverlayAnalystParameters(options) {
    OverlayAnalystParameters_classCallCheck(this, OverlayAnalystParameters);

    /**
     * @member {SuperMap.OverlayOperationType} [SuperMap.OverlayAnalystParameters.prototype.operation=SuperMap.OverlayOperationType.UNION]
     * @description 指定叠加分析操作类型。
     */
    this.operation = OverlayOperationType.UNION;

    if (options) {
      Util.extend(this, options);
    }

    this.CLASS_NAME = "SuperMap.OverlayAnalystParameters";
  }
  /**
   * @function SuperMap.OverlayAnalystParameters.prototype.destroy
   * @description 释放资源，将引用资源的属性置空。
   */


  OverlayAnalystParameters_createClass(OverlayAnalystParameters, [{
    key: "destroy",
    value: function destroy() {
      var me = this;
      me.operation = null;
    }
  }]);

  return OverlayAnalystParameters;
}();
SuperMap.OverlayAnalystParameters = OverlayAnalystParameters_OverlayAnalystParameters;
// CONCATENATED MODULE: ./src/common/iServer/DatasetOverlayAnalystParameters.js
function DatasetOverlayAnalystParameters_typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { DatasetOverlayAnalystParameters_typeof = function _typeof(obj) { return typeof obj; }; } else { DatasetOverlayAnalystParameters_typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return DatasetOverlayAnalystParameters_typeof(obj); }

function DatasetOverlayAnalystParameters_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function DatasetOverlayAnalystParameters_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function DatasetOverlayAnalystParameters_createClass(Constructor, protoProps, staticProps) { if (protoProps) DatasetOverlayAnalystParameters_defineProperties(Constructor.prototype, protoProps); if (staticProps) DatasetOverlayAnalystParameters_defineProperties(Constructor, staticProps); return Constructor; }

function DatasetOverlayAnalystParameters_possibleConstructorReturn(self, call) { if (call && (DatasetOverlayAnalystParameters_typeof(call) === "object" || typeof call === "function")) { return call; } return DatasetOverlayAnalystParameters_assertThisInitialized(self); }

function DatasetOverlayAnalystParameters_assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function DatasetOverlayAnalystParameters_get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { DatasetOverlayAnalystParameters_get = Reflect.get; } else { DatasetOverlayAnalystParameters_get = function _get(target, property, receiver) { var base = DatasetOverlayAnalystParameters_superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return DatasetOverlayAnalystParameters_get(target, property, receiver || target); }

function DatasetOverlayAnalystParameters_superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = DatasetOverlayAnalystParameters_getPrototypeOf(object); if (object === null) break; } return object; }

function DatasetOverlayAnalystParameters_getPrototypeOf(o) { DatasetOverlayAnalystParameters_getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return DatasetOverlayAnalystParameters_getPrototypeOf(o); }

function DatasetOverlayAnalystParameters_inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) DatasetOverlayAnalystParameters_setPrototypeOf(subClass, superClass); }

function DatasetOverlayAnalystParameters_setPrototypeOf(o, p) { DatasetOverlayAnalystParameters_setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return DatasetOverlayAnalystParameters_setPrototypeOf(o, p); }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/






/**
 * @class SuperMap.DatasetOverlayAnalystParameters
 * @category  iServer SpatialAnalyst OverlayAnalyst
 * @classdesc 数据集叠加分析参数类。
 * @param {Object} options - 参数。 
 * @param {string} options.operateDataset - 叠加分析中操作数据集的名称。 
* @param {string} options.sourceDataset - 叠加分析中源数据集的名称。 
 * @param {Array.<string>} [options.operateDatasetFields] - 叠加分析中操作数据集保留在结果数据集中的字段名列表。 
 * @param {SuperMap.FilterParameter} [options.operateDatasetFilter] - 设置操作数据集中空间对象过滤条件。 
 * @param {Array.<SuperMap.Geometry.Polygon|L.Polygon|ol.geom.Polygon>} [options.operateRegions] - 操作面对象集合，表示与这些面对象进行叠加分析。与 operateDataset 参数互斥，冲突时以 operateDataset 为准。 
 * @param {Array.<string>} [options.sourceDatasetFields] - 叠加分析中源数据集保留在结果数据集中的字段名列表。 
 * @param {SuperMap.FilterParameter} [options.sourceDatasetFilter] - 设置源数据集中空间对象过滤条件。 
 * @param {number} [options.tolerance=0] - 容限。 
 * @param {SuperMap.OverlayOperationType} options.operation - 叠加操作枚举值。 
 * @param {SuperMap.DataReturnOption} [options.resultSetting] - 结果返回设置类。 
 * @extends {SuperMap.GetFeaturesParametersBase}
 */

var DatasetOverlayAnalystParameters_DatasetOverlayAnalystParameters =
/*#__PURE__*/
function (_OverlayAnalystParame) {
  DatasetOverlayAnalystParameters_inherits(DatasetOverlayAnalystParameters, _OverlayAnalystParame);

  function DatasetOverlayAnalystParameters(options) {
    var _this;

    DatasetOverlayAnalystParameters_classCallCheck(this, DatasetOverlayAnalystParameters);

    _this = DatasetOverlayAnalystParameters_possibleConstructorReturn(this, DatasetOverlayAnalystParameters_getPrototypeOf(DatasetOverlayAnalystParameters).call(this, options));
    /**
     * @member {string} SuperMap.DatasetOverlayAnalystParameters.prototype.operateDataset
     * @description 叠加分析中操作数据集的名称。
     */

    _this.operateDataset = null;
    /**
     * @member {Array.<string>} [SuperMap.DatasetOverlayAnalystParameters.prototype.operateDatasetFields]
     * @description 叠加分析中操作数据集保留在结果数据集中的字段名列表。
     */

    _this.operateDatasetFields = [];
    /**
     * @member {SuperMap.FilterParameter} SuperMap.DatasetOverlayAnalystParameters.prototype.operateDatasetFilter
     * @description 设置操作数据集中空间对象过滤条件。
     */

    _this.operateDatasetFilter = new FilterParameter_FilterParameter();
    /**
     * @member {Array.<SuperMap.Geometry.Polygon|L.Polygon|ol.geom.Polygon>} [SuperMap.DatasetOverlayAnalystParameters.prototype.operateRegions]
     * @description 操作面对象集合，表示与这些面对象进行叠加分析。与 operateDataset 参数互斥，冲突时以 operateDataset 为准。
     */

    _this.operateRegions = [];
    /**
     * @member {string} SuperMap.DatasetOverlayAnalystParameters.prototype.sourceDataset
     * @description 叠加分析中源数据集的名称。
     */

    _this.sourceDataset = null;
    /**
     * @member {Array.<string>} [SuperMap.DatasetOverlayAnalystParameters.prototype.sourceDatasetFields]
     * @description 叠加分析中源数据集保留在结果数据集中的字段名列表。
     */

    _this.sourceDatasetFields = [];
    /**
     * @member {SuperMap.FilterParameter} [SuperMap.DatasetOverlayAnalystParameters.prototype.filterQueryParameter]
     * @description 设置源数据集中空间对象过滤条件。
     */

    _this.sourceDatasetFilter = new FilterParameter_FilterParameter();
    /**
     * @member {number} [SuperMap.DatasetOverlayAnalystParameters.prototype.tolerance=0]
     * @description 容限。
     */

    _this.tolerance = 0;
    /**
     * @member {SuperMap.DataReturnOption} [SuperMap.DatasetOverlayAnalystParameters.prototype.resultSetting]
     * @description 结果返回设置类。
     */

    _this.resultSetting = new DataReturnOption_DataReturnOption();
    Util.extend(DatasetOverlayAnalystParameters_assertThisInitialized(_this), options);
    _this.CLASS_NAME = "SuperMap.DatasetOverlayAnalystParameters";
    return _this;
  }
  /**
   * @function SuperMap.DatasetOverlayAnalystParameters.prototype.destroy
   * @override
   */


  DatasetOverlayAnalystParameters_createClass(DatasetOverlayAnalystParameters, [{
    key: "destroy",
    value: function destroy() {
      DatasetOverlayAnalystParameters_get(DatasetOverlayAnalystParameters_getPrototypeOf(DatasetOverlayAnalystParameters.prototype), "destroy", this).call(this);

      var me = this;
      me.operateDataset = null;
      me.operateDatasetFields = null;

      if (me.operateDatasetFilter) {
        me.operateDatasetFilter.destroy();
        me.operateDatasetFilter = null;
      }

      if (me.operateRegions) {
        for (var i = 0, opRegions = me.operateRegions, len = opRegions.length; i < len; i++) {
          opRegions[i].destroy();
        }

        me.operateRegions = null;
      }

      me.sourceDataset = null;
      me.sourceDatasetFields = null;

      if (me.sourceDatasetFilter) {
        me.sourceDatasetFilter.destroy();
        me.sourceDatasetFilter = null;
      }

      me.tolerance = null;

      if (me.resultSetting) {
        me.resultSetting.destroy();
        me.resultSetting = null;
      }
    }
    /**
     * @function SuperMap.DatasetOverlayAnalystParameters.toObject
     * @param {SuperMap.DatasetOverlayAnalystParameters} datasetOverlayAnalystParameters - 数据集叠加分析参数类。
     * @param {SuperMap.DatasetOverlayAnalystParameters} tempObj - 数据集叠加分析参数对象。
     * @description 将数据集叠加分析参数类转换为 JSON 对象。
     * @returns {Object} JSON 对象。
     */

  }], [{
    key: "toObject",
    value: function toObject(datasetOverlayAnalystParameters, tempObj) {
      for (var name in datasetOverlayAnalystParameters) {
        if (name === "sourceDataset") {
          continue;
        } else if (name === "operateRegions") {
          tempObj.operateRegions = [];
          var ors = datasetOverlayAnalystParameters.operateRegions;

          for (var index in ors) {
            if (ors.hasOwnProperty(index)) {
              //icl542
              tempObj.operateRegions[index] = ServerGeometry_ServerGeometry.fromGeometry(ors[index]);
            }
          }
        } else if (name === "resultSetting") {
          tempObj.dataReturnOption = datasetOverlayAnalystParameters.resultSetting;
        } else {
          tempObj[name] = datasetOverlayAnalystParameters[name];
        }
      }
    }
  }]);

  return DatasetOverlayAnalystParameters;
}(OverlayAnalystParameters_OverlayAnalystParameters);
SuperMap.DatasetOverlayAnalystParameters = DatasetOverlayAnalystParameters_DatasetOverlayAnalystParameters;
// CONCATENATED MODULE: ./src/common/iServer/SurfaceAnalystParametersSetting.js
function SurfaceAnalystParametersSetting_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function SurfaceAnalystParametersSetting_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function SurfaceAnalystParametersSetting_createClass(Constructor, protoProps, staticProps) { if (protoProps) SurfaceAnalystParametersSetting_defineProperties(Constructor.prototype, protoProps); if (staticProps) SurfaceAnalystParametersSetting_defineProperties(Constructor, staticProps); return Constructor; }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/





/**
 * @class SuperMap.SurfaceAnalystParametersSetting
 * @category  iServer SpatialAnalyst SurfaceAnalyst
 * @classdesc 表面分析参数设置类。
 * 通过该类可以设置表面分析提取等值线、提取等值面的一些参数，包括基准值、等值距、光滑度、光滑方法等。
 * @param {Object} options - 参数。
 * @param {(SuperMap.Geometry.Polygon|L.Polygon|ol.geom.Polygon)} [options.clipRegion] - 获取或设置裁剪面对象，如果不需要对操作结果进行裁剪，可以使用 null 值取代该参数。
 * @param {number} [options.datumValue=0] - 获取或设置表面分析中提取等值线、提取等值面的基准值。
 * @param {Array.<number>} options.expectedZValues - 获取或设置期望分析结果的 Z 值集合。
 * @param {number} [options.interval=0] - 获取或设置等值距。等值距是两条等值线之间的间隔值。
 * @param {number} [options.resampleTolerance=0] - 获取或设置重采样容限。
 * @param {SuperMap.SmoothMethod} [options.smoothMethod=SuperMap.SmoothMethod.BSPLINE] - 获取或设置光滑处理所使用的方法。
 * @param {number} [options.smoothness=0] - 获取或设置表面分析中等值线或等值面的边界线的光滑度。
 */

var SurfaceAnalystParametersSetting_SurfaceAnalystParametersSetting =
/*#__PURE__*/
function () {
  function SurfaceAnalystParametersSetting(options) {
    SurfaceAnalystParametersSetting_classCallCheck(this, SurfaceAnalystParametersSetting);

    /**
     * @member {(SuperMap.Geometry.Polygon|L.Polygon|ol.geom.Polygon)} [SuperMap.SurfaceAnalystParametersSetting.prototype.clipRegion]
     * @description 获取或设置裁剪面对象，如果不需要对操作结果进行裁剪，可以使用 null 值取代该参数。
     */
    this.clipRegion = null;
    /**
     * @member {number} [SuperMap.SurfaceAnalystParametersSetting.prototype.datumValue=0]
     * @description 获取或设置表面分析中提取等值线、提取等值面的基准值。
     * 基准值是作为一个生成等值线的初始起算值，并不一定是最小等值线的值。 例如，高程范围为 220 -1550 的 DEM 栅格数据，
     * 如果设基准值为 0， 等值距为 50，则提取等值线时，以基准值 0 为起点，等值距 50 为间隔提取等值线，
     * 因为给定高程的最小值是 220，所以，在给定范围内提取等值线的最小高程是 250。
     * 提取等值线的结果是：最小等值线值为 250，最大等值线值为 1550。
     */

    this.datumValue = 0;
    /**
     * @member {Array.<number>} SuperMap.SurfaceAnalystParametersSetting.prototype.expectedZValues
     * @description 获取或设置期望分析结果的 Z 值集合。
     *              Z 值集合存储一系列数值，该数值为待提取等值线的值。即仅高程值在 Z 值集合中的等值线会被提取。
     */

    this.expectedZValues = null;
    /**
     *  @member {number} [SuperMap.SurfaceAnalystParametersSetting.prototype.interval=0]
     *  @description 获取或设置等值距。等值距是两条等值线之间的间隔值。
     */

    this.interval = 0;
    /**
     * @member {number} [SuperMap.SurfaceAnalystParametersSetting.prototype.resampleTolerance=0]
     * @description 获取或设置重采样容限。
     *              容限值越大，采样结果数据越简化。当分析结果出现交叉时，可通过调整重采样容限为较小的值来处理。
     */

    this.resampleTolerance = 0;
    /**
     * @member {SuperMap.SmoothMethod} [SuperMap.SurfaceAnalystParametersSetting.prototype.smoothMethod=SuperMap.SmoothMethod.BSPLINE]
     * @description 获取或设置光滑处理所使用的方法。
     */

    this.smoothMethod = SmoothMethod.BSPLINE;
    /**
     * @member {number} [SuperMap.SurfaceAnalystParametersSetting.prototype.smoothness=0]
     * @description 获取或设置表面分析中等值线或等值面的边界线的光滑度。
     * 以为 0-5 为例，光滑度为 0 表示不进行光滑操作，值越大表示光滑度越高。
     * 随着光滑度的增加，提取的等值线越光滑.当然光滑度越大，
     * 计算所需的时间和占用的内存也就越大。而且，当等值距较小时，
     * 光滑度太高会出现等值线相交的问题。
     */

    this.smoothness = 0;

    if (options) {
      Util.extend(this, options);
    }

    this.CLASS_NAME = "SuperMap.SurfaceAnalystParametersSetting";
  }
  /**
   * @function SuperMap.SurfaceAnalystParametersSetting.prototype.destroy
   * @description 释放资源，将引用资源的属性置空。
   */


  SurfaceAnalystParametersSetting_createClass(SurfaceAnalystParametersSetting, [{
    key: "destroy",
    value: function destroy() {
      var me = this;

      if (me.clipRegion) {
        me.clipRegion.destroy();
        me.clipRegion = null;
      }

      me.datumValue = null;
      me.expectedZValues = null;
      me.interval = null;
      me.resampleTolerance = null;
      me.smoothMethod = null;
      me.smoothness = null;
    }
    /**
     * @function SuperMap.SurfaceAnalystParametersSetting.prototype.toJSON
     * @description 将对象转化为 JSON 字符串。
     * @returns {string} 对象 JSON 字符串。
     */

  }, {
    key: "toJSON",
    value: function toJSON() {
      var json = "'datumValue':" + Util.toJSON(this.datumValue);
      json += ",'interval':" + Util.toJSON(this.interval);
      json += ",'resampleTolerance':" + Util.toJSON(this.resampleTolerance);
      json += ",'smoothMethod':" + Util.toJSON(this.smoothMethod);
      json += ",'smoothness':" + Util.toJSON(this.smoothness);

      if (this.expectedZValues != null) {
        json += "," + "'expectedZValues':" + Util.toJSON(this.expectedZValues);
      }

      if (this.clipRegion != null) {
        var serverGeometry = this.clipRegion;

        if (this.clipRegion instanceof Geometry_Geometry && this.clipRegion.components) {
          serverGeometry = ServerGeometry_ServerGeometry.fromGeometry(this.clipRegion);
        }

        json += ",'clipRegion':" + Util.toJSON(serverGeometry);
      }

      return "{" + json + "}";
    }
  }]);

  return SurfaceAnalystParametersSetting;
}();
SuperMap.SurfaceAnalystParametersSetting = SurfaceAnalystParametersSetting_SurfaceAnalystParametersSetting;
// CONCATENATED MODULE: ./src/common/iServer/SurfaceAnalystParameters.js
function SurfaceAnalystParameters_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function SurfaceAnalystParameters_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function SurfaceAnalystParameters_createClass(Constructor, protoProps, staticProps) { if (protoProps) SurfaceAnalystParameters_defineProperties(Constructor.prototype, protoProps); if (staticProps) SurfaceAnalystParameters_defineProperties(Constructor, staticProps); return Constructor; }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/





/**
 * @class SuperMap.SurfaceAnalystParameters
 * @category  iServer SpatialAnalyst SurfaceAnalyst
 * @classdesc 表面分析提取操作参数类。
 * @description 通过该类可以为进行表面分析提供参数信息，包括表面分析的方法提取等值线、提取等值面和中间结果的分辨率，
 * {@link SuperMap.DatasetSurfaceAnalystParameters} 和 {@link SuperMap.GeometrySurfaceAnalystParameters} 继承自该类。
 * @param {Object} options - 参数。
 * @param {SuperMap.SurfaceAnalystParametersSetting} options.extractParameter - 获取或设置表面分析参数。
 * @param {number} options.resolution - 指定中间结果（栅格数据集）的分辨率。
 * @param {SuperMap.DataReturnOption} options.resultSetting - 结果返回设置类。
 * @param {SuperMap.SurfaceAnalystMethod} [options.surfaceAnalystMethod=SuperMap.SurfaceAnalystMethod.ISOLINE] - 获取或设置表面分析的提取方法，提取等值线和提取等值面。
 */

var SurfaceAnalystParameters_SurfaceAnalystParameters =
/*#__PURE__*/
function () {
  function SurfaceAnalystParameters(options) {
    SurfaceAnalystParameters_classCallCheck(this, SurfaceAnalystParameters);

    /**
     * @member {number} SuperMap.SurfaceAnalystParameters.prototype.resolution
     * @description 获取或设置指定中间结果（栅格数据集）的分辨率。
     */
    this.resolution = 0;
    /**
     * @member {SuperMap.SurfaceAnalystParametersSetting} SuperMap.SurfaceAnalystParameters.prototype.extractParameter
     * @description 获取或设置表面分析参数。
     * 在进行点数据集进行提取等值面分析时，暂时不支持 SurfaceAnalystParametersSetting 类中的 expectedZValues 字段。
     */

    this.extractParameter = new SurfaceAnalystParametersSetting_SurfaceAnalystParametersSetting();
    /**
     * @member {SuperMap.DataReturnOption} SuperMap.SurfaceAnalystParameters.prototype.resultSetting
     * @description 结果返回设置类。
     */

    this.resultSetting = new DataReturnOption_DataReturnOption();
    /**
     * @member {SuperMap.SurfaceAnalystMethod} [SuperMap.SurfaceAnalystParameters.prototype.surfaceAnalystMethod=SuperMap.SurfaceAnalystMethod.ISOLINE]
     * @description 获取或设置表面分析的提取方法，提取等值线和提取等值面。
     */

    this.surfaceAnalystMethod = SurfaceAnalystMethod.ISOLINE;

    if (options) {
      Util.extend(this, options);
    }

    this.CLASS_NAME = "SuperMap.SurfaceAnalystParameters";
  }
  /**
   * @function SuperMap.SurfaceAnalystParameters.prototype.destroy
   * @description 释放资源，将引用资源的属性置空。
   */


  SurfaceAnalystParameters_createClass(SurfaceAnalystParameters, [{
    key: "destroy",
    value: function destroy() {
      var me = this;
      me.resolution = null;

      if (me.extractParameter) {
        me.extractParameter.destroy();
        me.extractParameter = null;
      }

      if (me.resultSetting) {
        me.resultSetting.destroy();
        me.resultSetting = null;
      }

      me.surfaceAnalystMethod = null;
    }
  }]);

  return SurfaceAnalystParameters;
}();
SuperMap.SurfaceAnalystParameters = SurfaceAnalystParameters_SurfaceAnalystParameters;
// CONCATENATED MODULE: ./src/common/iServer/DatasetSurfaceAnalystParameters.js
function DatasetSurfaceAnalystParameters_typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { DatasetSurfaceAnalystParameters_typeof = function _typeof(obj) { return typeof obj; }; } else { DatasetSurfaceAnalystParameters_typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return DatasetSurfaceAnalystParameters_typeof(obj); }

function DatasetSurfaceAnalystParameters_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function DatasetSurfaceAnalystParameters_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function DatasetSurfaceAnalystParameters_createClass(Constructor, protoProps, staticProps) { if (protoProps) DatasetSurfaceAnalystParameters_defineProperties(Constructor.prototype, protoProps); if (staticProps) DatasetSurfaceAnalystParameters_defineProperties(Constructor, staticProps); return Constructor; }

function DatasetSurfaceAnalystParameters_possibleConstructorReturn(self, call) { if (call && (DatasetSurfaceAnalystParameters_typeof(call) === "object" || typeof call === "function")) { return call; } return DatasetSurfaceAnalystParameters_assertThisInitialized(self); }

function DatasetSurfaceAnalystParameters_assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function DatasetSurfaceAnalystParameters_get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { DatasetSurfaceAnalystParameters_get = Reflect.get; } else { DatasetSurfaceAnalystParameters_get = function _get(target, property, receiver) { var base = DatasetSurfaceAnalystParameters_superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return DatasetSurfaceAnalystParameters_get(target, property, receiver || target); }

function DatasetSurfaceAnalystParameters_superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = DatasetSurfaceAnalystParameters_getPrototypeOf(object); if (object === null) break; } return object; }

function DatasetSurfaceAnalystParameters_getPrototypeOf(o) { DatasetSurfaceAnalystParameters_getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return DatasetSurfaceAnalystParameters_getPrototypeOf(o); }

function DatasetSurfaceAnalystParameters_inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) DatasetSurfaceAnalystParameters_setPrototypeOf(subClass, superClass); }

function DatasetSurfaceAnalystParameters_setPrototypeOf(o, p) { DatasetSurfaceAnalystParameters_setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return DatasetSurfaceAnalystParameters_setPrototypeOf(o, p); }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/






/**
 * @class SuperMap.DatasetSurfaceAnalystParameters
 * @category iServer SpatialAnalyst SurfaceAnalyst
 * @classdesc 数据集表面分析参数类。该类对数据集表面分析所用到的参数进行设置。
 * @param {Object} options - 参数。 
 * @param {string} options.dataset - 要用来做数据集表面分析的数据源中数据集的名称。 
 * @param {string} options.zValueFieldName - 获取或设置用于提取操作的字段名称。 
 * @param {integer} options.resolution - 获取或设置指定中间结果（栅格数据集）的分辨率。 
 * @param {SuperMap.SurfaceAnalystParametersSetting} options.extractParameter - 表面分析参数设置类。获取或设置表面分析参数。 
 * @param {SuperMap.FilterParameter} [options.filterQueryParameter] - 获取或设置查询过滤条件参数。 
 * @param {SuperMap.DataReturnOption} [options.resultSetting] - 结果返回设置类。 
 * @param {SuperMap.SurfaceAnalystMethod} [options.surfaceAnalystMethod=SuperMap.SurfaceAnalystMethod.ISOLINE] - 获取或设置表面分析的提取方法，提取等值线和提取等值面。 
 * @extends {SuperMap.SurfaceAnalystParameters}
 */

var DatasetSurfaceAnalystParameters_DatasetSurfaceAnalystParameters =
/*#__PURE__*/
function (_SurfaceAnalystParame) {
  DatasetSurfaceAnalystParameters_inherits(DatasetSurfaceAnalystParameters, _SurfaceAnalystParame);

  function DatasetSurfaceAnalystParameters(options) {
    var _this;

    DatasetSurfaceAnalystParameters_classCallCheck(this, DatasetSurfaceAnalystParameters);

    _this = DatasetSurfaceAnalystParameters_possibleConstructorReturn(this, DatasetSurfaceAnalystParameters_getPrototypeOf(DatasetSurfaceAnalystParameters).call(this, options));
    /**
     * @member {string} SuperMap.DatasetSurfaceAnalystParameters.prototype.dataset
     * @description 要用来做数据集表面分析的数据源中数据集的名称。该名称用形如 "数据集名称@数据源别名" 形式来表示，例如：Country@World。
     */

    _this.dataset = null;
    /**
     *  @member {SuperMap.FilterParameter} SuperMap.DatasetSurfaceAnalystParameters.prototype.filterQueryParameter
     *  @description 获取或设置查询过滤条件参数。
     */

    _this.filterQueryParameter = new FilterParameter_FilterParameter();
    /**
     * @member {string} SuperMap.DatasetSurfaceAnalystParameters.prototype.zValueFieldName
     * @description 获取或设置用于提取操作的字段名称。提取等值线时，将使用该字段中的值，对点记录集中的点数据进行插值分析，得到栅格数据集（中间结果），接着从栅格数据集提取等值线。
     */

    _this.zValueFieldName = null;

    if (options) {
      Util.extend(DatasetSurfaceAnalystParameters_assertThisInitialized(_this), options);
    }

    _this.CLASS_NAME = "SuperMap.DatasetSurfaceAnalystParameters";
    return _this;
  }
  /**
   * @function SuperMap.DatasetSurfaceAnalystParameters.prototype.destroy
   * @override
   */


  DatasetSurfaceAnalystParameters_createClass(DatasetSurfaceAnalystParameters, [{
    key: "destroy",
    value: function destroy() {
      DatasetSurfaceAnalystParameters_get(DatasetSurfaceAnalystParameters_getPrototypeOf(DatasetSurfaceAnalystParameters.prototype), "destroy", this).call(this);

      var me = this;
      me.dataset = null;

      if (me.filterQueryParameter) {
        me.filterQueryParameter.destroy();
        me.filterQueryParameter = null;
      }

      me.zValueFieldName = null;
    }
    /**
     * @function SuperMap.DatasetSurfaceAnalystParameters.toObject
     * @param {SuperMap.DatasetSurfaceAnalystParameters} datasetSurfaceAnalystParameters - 数据集表面分析参数类。
     * @param {SuperMap.DatasetSurfaceAnalystParameters} tempObj - 数据集表面分析参数对象。
     * @description 将数据集表面分析参数对象转换为 JSON 对象。
     * @returns JSON 对象。
     */

  }], [{
    key: "toObject",
    value: function toObject(datasetSurfaceAnalystParameters, tempObj) {
      for (var name in datasetSurfaceAnalystParameters) {
        if (name === "filterQueryParameter") {
          tempObj.filterQueryParameter = datasetSurfaceAnalystParameters.filterQueryParameter;
        }

        if (name === "extractParameter") {
          if (datasetSurfaceAnalystParameters.extractParameter.clipRegion instanceof Geometry_Geometry && datasetSurfaceAnalystParameters.extractParameter.clipRegion.components) {
            datasetSurfaceAnalystParameters.extractParameter.clipRegion = ServerGeometry_ServerGeometry.fromGeometry(datasetSurfaceAnalystParameters.extractParameter.clipRegion);
          }

          tempObj.extractParameter = datasetSurfaceAnalystParameters.extractParameter;
        } else if (name === "dataset") {
          continue;
        } else if (name === "surfaceAnalystMethod") {
          continue;
        } else {
          tempObj[name] = datasetSurfaceAnalystParameters[name];
        }
      }
    }
  }]);

  return DatasetSurfaceAnalystParameters;
}(SurfaceAnalystParameters_SurfaceAnalystParameters);
SuperMap.DatasetSurfaceAnalystParameters = DatasetSurfaceAnalystParameters_DatasetSurfaceAnalystParameters;
// CONCATENATED MODULE: ./src/common/iServer/ThiessenAnalystParameters.js
function ThiessenAnalystParameters_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function ThiessenAnalystParameters_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function ThiessenAnalystParameters_createClass(Constructor, protoProps, staticProps) { if (protoProps) ThiessenAnalystParameters_defineProperties(Constructor.prototype, protoProps); if (staticProps) ThiessenAnalystParameters_defineProperties(Constructor, staticProps); return Constructor; }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


/**
 * @class SuperMap.ThiessenAnalystParameters
 * @category  iServer SpatialAnalyst ThiessenPolygonAnalyst
 * @classdesc 泰森多边形分析参数基类。
 * @param {Object} options - 参数。
 * @param {(SuperMap.Geometry.Polygon|L.Polygon|ol.geom.Polygon)} [options.clipRegion] - 结果数据裁剪区域，可以为 null，表示不对结果进行裁剪。
 * @param {boolean} [options.createResultDataset=false] - 是否返回结果数据集。
 * @param {string} [options.resultDatasetName] - 指定结果数据集名称。
 * @param {string} [options.resultDatasourceName] - 指定结果数据集所在数据源，默认为当前数据源。
 * @param {boolean} [options.returnResultRegion=true] - 是否返回分析得到的多边形面数组。
 */

var ThiessenAnalystParameters_ThiessenAnalystParameters =
/*#__PURE__*/
function () {
  function ThiessenAnalystParameters(options) {
    ThiessenAnalystParameters_classCallCheck(this, ThiessenAnalystParameters);

    if (!options) {
      return;
    }
    /**
     * @member {(SuperMap.Geometry.Polygon|L.Polygon|ol.geom.Polygon)} [SuperMap.ThiessenAnalystParameters.prototype.clipRegion]
     * @description 结果数据裁剪区域，可以为 null，表示不对结果进行裁剪。
     */


    this.clipRegion = null;
    /**
     *  @member {boolean} [SuperMap.ThiessenAnalystParameters.prototype.createResultDataset=false]
     *  @description 是否返回结果数据集。如果为 true，则必须设置属性 resultDatasetName 和 resultDatasourceName。
     */

    this.createResultDataset = false;
    /**
     * @member {string} SuperMap.ThiessenAnalystParameters.prototype.resultDatasetName
     * @description 指定结果数据集名称。
     */

    this.resultDatasetName = null;
    /**
     * @member {string} SuperMap.ThiessenAnalystParameters.prototype.resultDatasourceName
     * @description 指定结果数据集所在数据源。
     */

    this.resultDatasourceName = null;
    /**
     * @member {boolean} SuperMap.ThiessenAnalystParameters.prototype.returnResultRegion
     * @description 是否返回分析得到的多边形面数组。
     */

    this.returnResultRegion = true;
    Util.extend(this, options);
    this.CLASS_NAME = "SuperMap.ThiessenAnalystParameters";
  }
  /**
   * @function SuperMap.ThiessenAnalystParameters.prototype.destroy
   * @description 释放资源，将引用资源的属性置空。
   */


  ThiessenAnalystParameters_createClass(ThiessenAnalystParameters, [{
    key: "destroy",
    value: function destroy() {
      var me = this;

      if (me.clipRegion) {
        me.clipRegion.destroy();
        me.clipRegion = null;
      }

      me.createResultDataset = null;
      me.resultDatasetName = null;
      me.resultDatasourceName = null;
      me.returnResultRegion = null;
    }
  }]);

  return ThiessenAnalystParameters;
}();
SuperMap.ThiessenAnalystParameters = ThiessenAnalystParameters_ThiessenAnalystParameters;
// CONCATENATED MODULE: ./src/common/iServer/DatasetThiessenAnalystParameters.js
function DatasetThiessenAnalystParameters_typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { DatasetThiessenAnalystParameters_typeof = function _typeof(obj) { return typeof obj; }; } else { DatasetThiessenAnalystParameters_typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return DatasetThiessenAnalystParameters_typeof(obj); }

function DatasetThiessenAnalystParameters_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function DatasetThiessenAnalystParameters_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function DatasetThiessenAnalystParameters_createClass(Constructor, protoProps, staticProps) { if (protoProps) DatasetThiessenAnalystParameters_defineProperties(Constructor.prototype, protoProps); if (staticProps) DatasetThiessenAnalystParameters_defineProperties(Constructor, staticProps); return Constructor; }

function DatasetThiessenAnalystParameters_possibleConstructorReturn(self, call) { if (call && (DatasetThiessenAnalystParameters_typeof(call) === "object" || typeof call === "function")) { return call; } return DatasetThiessenAnalystParameters_assertThisInitialized(self); }

function DatasetThiessenAnalystParameters_assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function DatasetThiessenAnalystParameters_get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { DatasetThiessenAnalystParameters_get = Reflect.get; } else { DatasetThiessenAnalystParameters_get = function _get(target, property, receiver) { var base = DatasetThiessenAnalystParameters_superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return DatasetThiessenAnalystParameters_get(target, property, receiver || target); }

function DatasetThiessenAnalystParameters_superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = DatasetThiessenAnalystParameters_getPrototypeOf(object); if (object === null) break; } return object; }

function DatasetThiessenAnalystParameters_getPrototypeOf(o) { DatasetThiessenAnalystParameters_getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return DatasetThiessenAnalystParameters_getPrototypeOf(o); }

function DatasetThiessenAnalystParameters_inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) DatasetThiessenAnalystParameters_setPrototypeOf(subClass, superClass); }

function DatasetThiessenAnalystParameters_setPrototypeOf(o, p) { DatasetThiessenAnalystParameters_setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return DatasetThiessenAnalystParameters_setPrototypeOf(o, p); }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/




/**
 * @class SuperMap.DatasetThiessenAnalystParameters
 * @category iServer SpatialAnalyst ThiessenAnalyst
 * @classdesc 数据集泰森多边形分析参数类。
 * @param {Object} options - 参数。 
 * @param {SuperMap.FilterParameter} [options.filterQueryParameter] - 对待分析数据集中的点进行过滤，即对数据集中的所有点进行分析。
 * @extends {SuperMap.ThiessenAnalystParameters}
 */

var DatasetThiessenAnalystParameters_DatasetThiessenAnalystParameters =
/*#__PURE__*/
function (_ThiessenAnalystParam) {
  DatasetThiessenAnalystParameters_inherits(DatasetThiessenAnalystParameters, _ThiessenAnalystParam);

  function DatasetThiessenAnalystParameters(options) {
    var _this;

    DatasetThiessenAnalystParameters_classCallCheck(this, DatasetThiessenAnalystParameters);

    _this = DatasetThiessenAnalystParameters_possibleConstructorReturn(this, DatasetThiessenAnalystParameters_getPrototypeOf(DatasetThiessenAnalystParameters).call(this, options));
    /**
     * @member {SuperMap.FilterParameter} [SuperMap.DatasetThiessenAnalystParameters.prototype.filterQueryParameter]
     * @description 过滤条件，对待分析数据集中的点进行过滤，即对数据集中的所有点进行分析。
     * @example
     *  var filterQueryParameter = new SuperMap.FilterParameter({
     *   name: "Countries@World",
     *   attributeFilter: "SmID>100"
     *  });
     */

    _this.filterQueryParameter = null;
    /**
     * @member {string} SuperMap.DatasetThiessenAnalystParameters.prototype.dataset
     * @description 数据集名称待分析的数据集名称，请使用 "datasetName@datasourceName" 格式来表示。
     */

    _this.dataset = null;

    if (options) {
      Util.extend(DatasetThiessenAnalystParameters_assertThisInitialized(_this), options);
    }

    _this.CLASS_NAME = "SuperMap.DatasetThiessenAnalystParameters";
    return _this;
  }
  /**
   * @function SuperMap.DatasetThiessenAnalystParameters.prototype.destroy
   * @override
   */


  DatasetThiessenAnalystParameters_createClass(DatasetThiessenAnalystParameters, [{
    key: "destroy",
    value: function destroy() {
      DatasetThiessenAnalystParameters_get(DatasetThiessenAnalystParameters_getPrototypeOf(DatasetThiessenAnalystParameters.prototype), "destroy", this).call(this);

      var me = this;

      if (me.filterQueryParameter) {
        me.filterQueryParameter.destroy();
        me.filterQueryParameter = null;
      }
    }
    /**
     * @function SuperMap.DatasetThiessenAnalystParameters.toObject
     * @param {SuperMap.DatasetThiessenAnalystParameters} datasetThiessenAnalystParameters - 泰森多边形分析服务参数类。
     * @param {SuperMap.DatasetThiessenAnalystParameters} tempObj - 泰森多边形分析服务参数对象。
     * @description 将泰森多边形分析服务参数对象转换为 JSON 对象。
     * @returns JSON 对象。
     */

  }], [{
    key: "toObject",
    value: function toObject(datasetThiessenAnalystParameters, tempObj) {
      for (var name in datasetThiessenAnalystParameters) {
        if (name === "clipRegion") {
          tempObj.clipRegion = ServerGeometry_ServerGeometry.fromGeometry(datasetThiessenAnalystParameters.clipRegion);
        } else {
          tempObj[name] = datasetThiessenAnalystParameters[name];
        }
      }
    }
  }]);

  return DatasetThiessenAnalystParameters;
}(ThiessenAnalystParameters_ThiessenAnalystParameters);
SuperMap.DatasetThiessenAnalystParameters = DatasetThiessenAnalystParameters_DatasetThiessenAnalystParameters;
// CONCATENATED MODULE: ./src/common/iServer/DensityKernelAnalystParameters.js
function DensityKernelAnalystParameters_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function DensityKernelAnalystParameters_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function DensityKernelAnalystParameters_createClass(Constructor, protoProps, staticProps) { if (protoProps) DensityKernelAnalystParameters_defineProperties(Constructor.prototype, protoProps); if (staticProps) DensityKernelAnalystParameters_defineProperties(Constructor, staticProps); return Constructor; }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


/**
 * @class SuperMap.DensityKernelAnalystParameters
 * @category  iServer SpatialAnalyst DensityAnalyst
 * @classdesc 核密度分析参数类。
 * @param {Object} options - 参数。
 * @param {string} options.dataset - 要用来做核密度分析数据源中数据集的名称。该名称用形如 "数据集名称@数据源别名" 形式来表示，例如：BaseMap_P@Jingjin。 
 * @param {string} options.fieldName - 用于进行核密度分析的测量值的字段名称，核密度分析不支持文本类型的字段。 
 * @param {string} options.resultGridName - 指定结果数据集名称。 
 * @param {(SuperMap.Bounds|L.Bounds|ol.extent)} [options.bounds] - 核密度分析的范围，用于确定结果栅格数据集的范围。如果缺省，则默认为原数据集的范围。 
 * @param {number} [options.searchRadius] - 栅格邻域内用于计算密度的查找半径，单位与当前数据集相同。默认值为当前数据集的长宽中的最大值除30。 
 * @param {number} [options.resultGridDatasetResolution] - 密度分析结果栅格数据的分辨率，单位与当前数据集相同。默认值为当前数据集的长宽中的最小值除500。 
 * @param {string} [options.targetDatasource] - 指定的存储结果数据集的数据源，默认为当前分析的数据集所在的数据源。 
 * @param {boolean} [options.deleteExistResultDataset=false] - 如果用户命名的结果数据集名称与已有的数据集重名，是否删除已有的数据集。 
 */

var DensityKernelAnalystParameters_DensityKernelAnalystParameters =
/*#__PURE__*/
function () {
  function DensityKernelAnalystParameters(options) {
    DensityKernelAnalystParameters_classCallCheck(this, DensityKernelAnalystParameters);

    /**
     * @member {string} SuperMap.DensityKernelAnalystParameters.prototype.dataset
     * @description 要用来做核密度分析数据源中数据集的名称。
     * 该名称用形如 "数据集名称@数据源别名" 形式来表示，例如：Railway@Changchun。
     * 注：核密度分析支持点数据集和线数据集。
     */
    this.dataset = null;
    /**
     * @member {(SuperMap.Bounds|L.Bounds|ol.extent)} [SuperMap.DensityKernelAnalystParameters.prototype.bounds]
     * @description 核密度分析的范围，用于确定结果栅格数据集的范围。
     * 如果缺省，则默认为原数据集的范围。
     */

    this.bounds = null;
    /**
     * @member {string} SuperMap.DensityKernelAnalystParameters.prototype.fieldName
     * @description 用于进行核密度分析的测量值的字段名称，核密度分析不支持文本类型的字段。
     */

    this.fieldName = null;
    /**
     * @member {number} [SuperMap.DensityKernelAnalystParameters.prototype.resultGridDatasetResolution]
     * @description 密度分析结果栅格数据的分辨率，单位与当前数据集相同。默认值为当前数据集的长宽中的最小值除500。
     */

    this.resultGridDatasetResolution = null;
    /**
     * @member {number} [SuperMap.DensityKernelAnalystParameters.prototype.searchRadius]
     * @description 栅格邻域内用于计算密度的查找半径，单位与当前数据集相同。默认值为当前数据集的长宽中的最大值除30。
     */

    this.searchRadius = null;
    /**
     * @member {string} [SuperMap.DensityKernelAnalystParameters.prototype.targetDatasource]
     * @description 指定的存储结果数据集的数据源，默认为当前分析的数据集所在的数据源。
     */

    this.targetDatasource = null;
    /**
     * @member {string} SuperMap.DensityKernelAnalystParameters.prototype.resultGridName
     * @description 指定结果数据集名称。
     */

    this.resultGridName = null;
    /**
     * @member {boolean} [SuperMap.DensityKernelAnalystParameters.prototype.deleteExistResultDataset=false]
     * @description 如果用户命名的结果数据集名称与已有的数据集重名，是否删除已有的数据集。
     */

    this.deleteExistResultDataset = false;
    Util.extend(this, options);
    this.CLASS_NAME = "SuperMap.DensityKernelAnalystParameters";
  }
  /**
   * @function SuperMap.DensityKernelAnalystParameters.prototype.destroy
   * @description 释放资源，将引用资源的属性置空。
   */


  DensityKernelAnalystParameters_createClass(DensityKernelAnalystParameters, [{
    key: "destroy",
    value: function destroy() {
      var me = this;
      me.dataset = null;
      me.bounds = null;
      me.fieldName = null;
      me.resultGridDatasetResolution = null;
      me.searchRadius = null;
      me.targetDatasource = null;
      me.resultGridName = null;
      me.deleteExistResultDataset = null;
    }
    /**
     * @function SuperMap.DensityKernelAnalystParameters.toObject
     * @param {SuperMap.DensityKernelAnalystParameters} densityKernelAnalystParameters -核密度分析参数类。
     * @param {SuperMap.DensityKernelAnalystParameters} tempObj - 核密度分析参数对象。
     * @description 将核密度分析参数对象转换成 JSON 对象。
     * @returns JSON 对象。
     */

  }], [{
    key: "toObject",
    value: function toObject(densityKernelAnalystParameters, tempObj) {
      for (var name in densityKernelAnalystParameters) {
        if (name !== "dataset") {
          tempObj[name] = densityKernelAnalystParameters[name];
        }
      }
    }
  }]);

  return DensityKernelAnalystParameters;
}();
SuperMap.DensityKernelAnalystParameters = DensityKernelAnalystParameters_DensityKernelAnalystParameters;
// CONCATENATED MODULE: ./src/common/iServer/DensityAnalystService.js
function DensityAnalystService_typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { DensityAnalystService_typeof = function _typeof(obj) { return typeof obj; }; } else { DensityAnalystService_typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return DensityAnalystService_typeof(obj); }

function DensityAnalystService_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function DensityAnalystService_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function DensityAnalystService_createClass(Constructor, protoProps, staticProps) { if (protoProps) DensityAnalystService_defineProperties(Constructor.prototype, protoProps); if (staticProps) DensityAnalystService_defineProperties(Constructor, staticProps); return Constructor; }

function DensityAnalystService_possibleConstructorReturn(self, call) { if (call && (DensityAnalystService_typeof(call) === "object" || typeof call === "function")) { return call; } return DensityAnalystService_assertThisInitialized(self); }

function DensityAnalystService_assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function DensityAnalystService_get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { DensityAnalystService_get = Reflect.get; } else { DensityAnalystService_get = function _get(target, property, receiver) { var base = DensityAnalystService_superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return DensityAnalystService_get(target, property, receiver || target); }

function DensityAnalystService_superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = DensityAnalystService_getPrototypeOf(object); if (object === null) break; } return object; }

function DensityAnalystService_getPrototypeOf(o) { DensityAnalystService_getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return DensityAnalystService_getPrototypeOf(o); }

function DensityAnalystService_inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) DensityAnalystService_setPrototypeOf(subClass, superClass); }

function DensityAnalystService_setPrototypeOf(o, p) { DensityAnalystService_setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return DensityAnalystService_setPrototypeOf(o, p); }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/




/**
 * @class SuperMap.DensityAnalystService
 * @category iServer SpatialAnalyst DensityAnalyst
 * @classdesc
 * 密度分析服务类，密度分析可计算每个输出栅格像元周围圆形邻域内输入的点或线对象的密度。
 * 密度分析，在某种意义上来说，相当于在表面上将输入的点线对象的测量值散开来，将每个点或线对象的测量量分布在整个研究区域，并计算输出栅格中每个像元的密度值。目前提供1种密度分析：核密度分析（Kernel）。
 * @param {string} url - 服务的访问地址。如 http://localhost:8090/iserver/services/spatialanalyst-changchun/restjsr/spatialanalyst 。
 * @param {Object} options - 参数。</br>
 * @param {Object} options.eventListeners - 需要被注册的监听器对象。
 * @param {boolean} [options.crossOrigin] - 是否允许跨域请求。
 * @param {Object} [options.headers] - 请求头。
 * @extends {SuperMap.SpatialAnalystBase}
 * @example  例如：
 *  var myDensityAnalystService = new SuperMap.DensityAnalystService(url);
 *  myDensityAnalystService.on({
 *     "processCompleted": processCompleted,
 *     "processFailed": processFailed
 *     }
 *  );
 */

var DensityAnalystService_DensityAnalystService =
/*#__PURE__*/
function (_SpatialAnalystBase) {
  DensityAnalystService_inherits(DensityAnalystService, _SpatialAnalystBase);

  function DensityAnalystService(url, options) {
    var _this;

    DensityAnalystService_classCallCheck(this, DensityAnalystService);

    _this = DensityAnalystService_possibleConstructorReturn(this, DensityAnalystService_getPrototypeOf(DensityAnalystService).call(this, url, options));
    /**
     * @member {string} SuperMap.DensityAnalystService.prototype.mode
     * @description 密度分析类型。
     */

    _this.mode = null;

    if (options) {
      Util.extend(DensityAnalystService_assertThisInitialized(_this), options);
    }

    _this.CLASS_NAME = "SuperMap.DensityAnalystService";
    return _this;
  }
  /**
   * @function SuperMap.DensityAnalystService.prototype.destroy
   * @description 释放资源,将引用资源的属性置空。
   */


  DensityAnalystService_createClass(DensityAnalystService, [{
    key: "destroy",
    value: function destroy() {
      DensityAnalystService_get(DensityAnalystService_getPrototypeOf(DensityAnalystService.prototype), "destroy", this).call(this);

      this.mode = null;
    }
    /**
     * @function SuperMap.DensityAnalystService.prototype.processAsync
     * @description 负责将客户端的查询参数传递到服务端。
     * @param {SuperMap.DensityKernelAnalystParameters} parameter - 核密度分析参数。
     */

  }, {
    key: "processAsync",
    value: function processAsync(parameter) {
      var me = this;
      var end = me.url.substr(me.url.length - 1, 1);

      if (end !== '/') {
        me.url += "/";
      }

      var parameterObject = new Object();

      if (parameter instanceof DensityKernelAnalystParameters_DensityKernelAnalystParameters) {
        me.url += 'datasets/' + parameter.dataset + '/densityanalyst/kernel';
        me.mode = "kernel";
      }

      DensityKernelAnalystParameters_DensityKernelAnalystParameters.toObject(parameter, parameterObject);
      var jsonParameters = Util.toJSON(parameterObject);
      me.url += '.json?returnContent=true';
      me.request({
        method: "POST",
        data: jsonParameters,
        scope: me,
        success: me.serviceProcessCompleted,
        failure: me.serviceProcessFailed
      });
    }
  }]);

  return DensityAnalystService;
}(SpatialAnalystBase_SpatialAnalystBase);
SuperMap.DensityAnalystService = DensityAnalystService_DensityAnalystService;
// CONCATENATED MODULE: ./src/common/iServer/EditFeaturesParameters.js
function EditFeaturesParameters_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function EditFeaturesParameters_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function EditFeaturesParameters_createClass(Constructor, protoProps, staticProps) { if (protoProps) EditFeaturesParameters_defineProperties(Constructor.prototype, protoProps); if (staticProps) EditFeaturesParameters_defineProperties(Constructor, staticProps); return Constructor; }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/




/**
 * @class SuperMap.EditFeaturesParameters
 * @category iServer Data Feature
 * @classdesc 数据服务中数据集添加、修改、删除参数类。
 * @category iServer Data
 * @param {Object} options - 参数。 
 * @param {Array.<SuperMap.Feature.Vector|GeoJSONObject|ol.feature>} options.features - 当前需要创建或者是修改的要素集。 
 * @param {boolean} [options.returnContent=false] - 是返回创建要素的 ID 数组还是返回 featureResult 资源的 URI。 
 * @param {SuperMap.EditType} [options.editType=SuperMap.EditType.ADD] - POST 动作类型 (ADD、UPDATE、DELETE)。 
 * @param {Array.<string|integer>} [options.IDs] - 删除要素时的要素的 ID 数组。 
 */

var EditFeaturesParameters_EditFeaturesParameters =
/*#__PURE__*/
function () {
  function EditFeaturesParameters(options) {
    EditFeaturesParameters_classCallCheck(this, EditFeaturesParameters);

    /**
     * @member {string} SuperMap.EditFeaturesParameters.prototype.dataSourceName
     * @description 当前需要创建或者是修改的要素的数据源。
     */
    this.dataSourceName = null;
    /**
     * @member {string} SuperMap.EditFeaturesParameters.prototype.dataSetName
     * @description 当前需要创建或者是修改的要素的数据集。
     */

    this.dataSetName = null;
    /**
     * @member {Array.<SuperMap.Feature.Vector|GeoJSONObject|ol.feature>} SuperMap.EditFeaturesParameters.prototype.features
     * @description 当前需要创建或者是修改的要素集。 
     */

    this.features = null;
    /**
     * @member {SuperMap.EditType} [SuperMap.EditFeaturesParameters.prototype.editType=SuperMap.EditType.ADD]
     * @description 要素集更新类型 (add、update、delete)。
     */

    this.editType = EditType.ADD;
    /**
     * @member {Array.<string|number>} [SuperMap.EditFeaturesParameters.prototype.IDs]
     * @description 执行删除时要素集 ID 集合。
     */

    this.IDs = null;
    /**
     * @member {boolean} [SuperMap.EditFeaturesParameters.prototype.returnContent=false]
     * @description 要素添加时，isUseBatch 不传或传为 false 的情况下有效。
     *              true 表示直接返回新创建的要素的 ID 数组；false 表示返回创建的 featureResult 资源的 URI。
     */

    this.returnContent = false;
    /**
     * @member {boolean} [SuperMap.EditFeaturesParameters.prototype.isUseBatch=false]
     * @description 是否使用批量添加要素功能，要素添加时有效。批量添加能够提高要素编辑效率。true 表示批量添加；false 表示不使用批量添加。
     */

    this.isUseBatch = false;
    Util.extend(this, options);
    this.CLASS_NAME = "SuperMap.EditFeaturesParameters";
  }
  /**
   * @function SuperMap.EditFeaturesParameters.prototype.destroy
   * @description 释放资源，将引用资源的属性置空。
   */


  EditFeaturesParameters_createClass(EditFeaturesParameters, [{
    key: "destroy",
    value: function destroy() {
      var me = this;
      me.dataSourceName = null;
      me.dataSetName = null;
      me.features = null;
      me.editType = null;
      me.IDs = null;
      me.returnContent = null;
    }
    /**
     * @function SuperMap.EditFeaturesParameters.prototype.toJsonParameters
     * @description 将 EditFeaturesParameters 对象参数转换为 JSON 字符串。
     * @param {SuperMap.EditFeaturesParameters} params - 地物编辑参数。
     * @returns {string} JSON 字符串。
     */

  }], [{
    key: "toJsonParameters",
    value: function toJsonParameters(params) {
      var feature,
          len,
          features,
          editType = params.editType;

      if (editType === EditType.DELETE) {
        if (params.IDs === null) {
          return;
        }

        features = {
          ids: params.IDs
        };
      } else {
        features = [];

        if (params.features) {
          len = params.features.length;

          for (var i = 0; i < len; i++) {
            feature = params.features[i];
            feature.geometry = ServerGeometry_ServerGeometry.fromGeometry(feature.geometry);
            features.push(feature);
          }
        }
      }

      return Util.toJSON(features);
    }
  }]);

  return EditFeaturesParameters;
}();
SuperMap.EditFeaturesParameters = EditFeaturesParameters_EditFeaturesParameters;
// CONCATENATED MODULE: ./src/common/iServer/EditFeaturesService.js
function EditFeaturesService_typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { EditFeaturesService_typeof = function _typeof(obj) { return typeof obj; }; } else { EditFeaturesService_typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return EditFeaturesService_typeof(obj); }

function EditFeaturesService_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function EditFeaturesService_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function EditFeaturesService_createClass(Constructor, protoProps, staticProps) { if (protoProps) EditFeaturesService_defineProperties(Constructor.prototype, protoProps); if (staticProps) EditFeaturesService_defineProperties(Constructor, staticProps); return Constructor; }

function EditFeaturesService_possibleConstructorReturn(self, call) { if (call && (EditFeaturesService_typeof(call) === "object" || typeof call === "function")) { return call; } return EditFeaturesService_assertThisInitialized(self); }

function EditFeaturesService_assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function EditFeaturesService_get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { EditFeaturesService_get = Reflect.get; } else { EditFeaturesService_get = function _get(target, property, receiver) { var base = EditFeaturesService_superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return EditFeaturesService_get(target, property, receiver || target); }

function EditFeaturesService_superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = EditFeaturesService_getPrototypeOf(object); if (object === null) break; } return object; }

function EditFeaturesService_getPrototypeOf(o) { EditFeaturesService_getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return EditFeaturesService_getPrototypeOf(o); }

function EditFeaturesService_inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) EditFeaturesService_setPrototypeOf(subClass, superClass); }

function EditFeaturesService_setPrototypeOf(o, p) { EditFeaturesService_setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return EditFeaturesService_setPrototypeOf(o, p); }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/





/**
 * @class SuperMap.EditFeaturesService
 * @category  iServer Data Feature
 * @classdesc 数据服务中数据集添加、更新、删除服务类。
 * @extends {SuperMap.CommonServiceBase}
 * @param {string} url - 服务端的数据服务资源地址。请求数据服务中数据集编辑服务，URL 应为：</br>
 * http://{服务器地址}:{服务端口号}/iserver/services/{数据服务名}/rest/data/datasources/name/{数据源名}/datasets/name/{数据集名} 。</br>
 * 例如：http://localhost:8090/iserver/services/data-jingjin/rest/data/datasources/name/Jingjin/datasets/name/Landuse_R
 * @param {Object} options - 参数。</br>
 * @param {Object} options.eventListeners - 事件监听器对象。有processCompleted属性可传入处理完成后的回调函数。processFailed属性传入处理失败后的回调函数。
 * @param {SuperMap.ServerType} [options.serverType=SuperMap.ServerType.ISERVER] - 服务器类型，iServer|iPortal|Online。
 * @param {SuperMap.DataFormat} [format] -查询结果返回格式，目前支持iServerJSON 和GeoJSON两种格式。参数格式为"ISERVER","GEOJSON"。
 * @param {boolean} [options.crossOrigin] - 是否允许跨域请求。
 * @param {Object} [options.headers] - 请求头。
 * @example
 * var myService = new SuperMap.EditFeaturesService(url, {eventListeners: {
 *     "processCompleted": editFeatureCompleted,
 *     "processFailed": editFeatureError
 *       }
 * };
 *
 */

var EditFeaturesService_EditFeaturesService =
/*#__PURE__*/
function (_CommonServiceBase) {
  EditFeaturesService_inherits(EditFeaturesService, _CommonServiceBase);

  function EditFeaturesService(url, options) {
    var _this;

    EditFeaturesService_classCallCheck(this, EditFeaturesService);

    _this = EditFeaturesService_possibleConstructorReturn(this, EditFeaturesService_getPrototypeOf(EditFeaturesService).call(this, url, options));
    /**
     * @member {boolean} [SuperMap.EditFeaturesService.prototype.returnContent=false]
     * @description要素添加时，isUseBatch 不传或传为 false 的情况下有效。true 表示直接返回新创建的要素的 ID 数组;false 表示返回创建的 featureResult 资源的 URI。
     */

    _this.returnContent = false;
    /**
     * @member {boolean} [SuperMap.EditFeaturesService.prototype.isUseBatch=false]
     * @description 是否使用批量添加要素功能，要素添加时有效。
     *              批量添加能够提高要素编辑效率。
     *              true 表示批量添加；false 表示不使用批量添加。
     */

    _this.isUseBatch = false;

    if (options) {
      Util.extend(EditFeaturesService_assertThisInitialized(_this), options);
    }

    var me = EditFeaturesService_assertThisInitialized(_this),
        end;

    end = me.url.substr(me.url.length - 1, 1);
    me.url += end == "/" ? "features.json?" : "/features.json?";
    _this.CLASS_NAME = "SuperMap.EditFeaturesService";
    return _this;
  }
  /**
   * @function SuperMap.EditFeaturesService.prototype.destroy
   * @override
   */


  EditFeaturesService_createClass(EditFeaturesService, [{
    key: "destroy",
    value: function destroy() {
      EditFeaturesService_get(EditFeaturesService_getPrototypeOf(EditFeaturesService.prototype), "destroy", this).call(this);

      var me = this;
      me.returnContent = null;
      me.isUseBatch = null;
      me.fromIndex = null;
      me.toIndex = null;
    }
    /**
     * @function SuperMap.EditFeaturesService.prototype.processAsync
     * @description 负责将客户端的更新参数传递到服务端。
     * @param {SuperMap.EditFeaturesParameters} params - 编辑要素参数。
     */

  }, {
    key: "processAsync",
    value: function processAsync(params) {
      if (!(params instanceof EditFeaturesParameters_EditFeaturesParameters)) {
        return;
      }

      var me = this,
          method = "POST",
          ids = "",
          editType = params.editType,
          jsonParameters = null;
      me.returnContent = params.returnContent;
      me.isUseBatch = params.isUseBatch;
      jsonParameters = EditFeaturesParameters_EditFeaturesParameters.toJsonParameters(params);

      if (editType === EditType.DELETE) {
        ids = Util.toJSON(params.IDs);
        me.url += "ids=" + ids;
        method = "DELETE";
        jsonParameters = ids;
      } else if (editType === EditType.UPDATE) {
        method = "PUT";
      } else {
        if (me.isUseBatch) {
          me.url += "isUseBatch=" + me.isUseBatch;
          me.returnContent = false;
        }

        if (me.returnContent) {
          me.url += "returnContent=" + me.returnContent;
          method = "POST";
        }
      }

      me.request({
        method: method,
        data: jsonParameters,
        scope: me,
        success: me.serviceProcessCompleted,
        failure: me.serviceProcessFailed
      });
    }
  }]);

  return EditFeaturesService;
}(CommonServiceBase_CommonServiceBase);
SuperMap.EditFeaturesService = EditFeaturesService_EditFeaturesService;
// CONCATENATED MODULE: ./src/common/iServer/FacilityAnalyst3DParameters.js
function FacilityAnalyst3DParameters_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function FacilityAnalyst3DParameters_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function FacilityAnalyst3DParameters_createClass(Constructor, protoProps, staticProps) { if (protoProps) FacilityAnalyst3DParameters_defineProperties(Constructor.prototype, protoProps); if (staticProps) FacilityAnalyst3DParameters_defineProperties(Constructor, staticProps); return Constructor; }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


/**
 * @class SuperMap.FacilityAnalyst3DParameters
 * @category  iServer FacilityAnalyst3D
 * @classdesc 最近设施分析参数基类。最近设施分析是指在网络上给定一个事件点和一组设施点，查找从事件点到设施点（或从设施点到事件点）以最小耗费能到达的最佳路径。
 * 设施点一般为学校、超市、加油站等服务设施；事件点为需要服务设施的事件位置。例如事件发生点是一起交通事故，要求查找在 10 分钟内能到达的最近医院，
 * 超过 10 分钟能到达的都不予考虑。此例中，事故发生地即是一个事件点，周边的医院则是设施点。最近设施查找实际上也是一种路径分析，因此对路径分析起
 * 作用的障碍边、障碍点、转向表、耗费等属性在最近设施分析时同样可设置。
 * @param {Object} options - 参数。 
 * @param {string} options.weightName - 指定的权值字段信息对象的名称。 
 * @param {number} [options.edgeID] - 指定的弧段 ID，edgeID 与 nodeID 必须指定一个。 
 * @param {number} [options.nodeID] - 指定的结点 ID，edgeID 与 nodeID 必须指定一个。  
 * @param {boolean} [options.isUncertainDirectionValid=false] - 指定不确定流向是否有效。指定为 true，表示不确定流向有效，遇到不确定流向时分析继续进行；
 *                                                      指定为 false，表示不确定流向无效，遇到不确定流向将停止在该方向上继续查找。
 */

var FacilityAnalyst3DParameters_FacilityAnalyst3DParameters =
/*#__PURE__*/
function () {
  function FacilityAnalyst3DParameters(options) {
    FacilityAnalyst3DParameters_classCallCheck(this, FacilityAnalyst3DParameters);

    /**
     * @member {number} [SuperMap.FacilityAnalyst3DParameters.prototype.edgeID]
     * @description 指定的弧段 ID，edgeID 与 nodeID 必须指定一个。 
     */
    this.edgeID = null;
    /**
     * @member {number} [SuperMap.FacilityAnalyst3DParameters.prototype.nodeID]
     * @description 指定的结点 ID，edgeID 与 nodeID 必须指定一个。 
     */

    this.nodeID = null;
    /**
     * @member {string} SuperMap.FacilityAnalyst3DParameters.prototype.weightName
     * @description 指定的权值字段信息对象的名称。
     */

    this.weightName = null;
    /**
     * @member {boolean} [SuperMap.FacilityAnalyst3DParameters.prototype.isUncertainDirectionValid=false]
     * @description 指定不确定流向是否有效。指定为 true，表示不确定流向有效，遇到不确定流向时分析继续进行；
     *              指定为 false，表示不确定流向无效，遇到不确定流向将停止在该方向上继续查找
     */

    this.isUncertainDirectionValid = false;
    Util.extend(this, options);
    this.CLASS_NAME = "SuperMap.FacilityAnalyst3DParameters";
  }
  /**
   * @function SuperMap.FacilityAnalyst3DParameters.prototype.destroy
   * @override
   */


  FacilityAnalyst3DParameters_createClass(FacilityAnalyst3DParameters, [{
    key: "destroy",
    value: function destroy() {
      var me = this;
      me.edgeID = null;
      me.nodeID = null;
      me.weightName = null;
      me.isUncertainDirectionValid = null;
    }
  }]);

  return FacilityAnalyst3DParameters;
}();
SuperMap.FacilityAnalyst3DParameters = FacilityAnalyst3DParameters_FacilityAnalyst3DParameters;
// CONCATENATED MODULE: ./src/common/iServer/FacilityAnalystSinks3DParameters.js
function FacilityAnalystSinks3DParameters_typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { FacilityAnalystSinks3DParameters_typeof = function _typeof(obj) { return typeof obj; }; } else { FacilityAnalystSinks3DParameters_typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return FacilityAnalystSinks3DParameters_typeof(obj); }

function FacilityAnalystSinks3DParameters_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function FacilityAnalystSinks3DParameters_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function FacilityAnalystSinks3DParameters_createClass(Constructor, protoProps, staticProps) { if (protoProps) FacilityAnalystSinks3DParameters_defineProperties(Constructor.prototype, protoProps); if (staticProps) FacilityAnalystSinks3DParameters_defineProperties(Constructor, staticProps); return Constructor; }

function FacilityAnalystSinks3DParameters_possibleConstructorReturn(self, call) { if (call && (FacilityAnalystSinks3DParameters_typeof(call) === "object" || typeof call === "function")) { return call; } return FacilityAnalystSinks3DParameters_assertThisInitialized(self); }

function FacilityAnalystSinks3DParameters_assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function FacilityAnalystSinks3DParameters_get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { FacilityAnalystSinks3DParameters_get = Reflect.get; } else { FacilityAnalystSinks3DParameters_get = function _get(target, property, receiver) { var base = FacilityAnalystSinks3DParameters_superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return FacilityAnalystSinks3DParameters_get(target, property, receiver || target); }

function FacilityAnalystSinks3DParameters_superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = FacilityAnalystSinks3DParameters_getPrototypeOf(object); if (object === null) break; } return object; }

function FacilityAnalystSinks3DParameters_getPrototypeOf(o) { FacilityAnalystSinks3DParameters_getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return FacilityAnalystSinks3DParameters_getPrototypeOf(o); }

function FacilityAnalystSinks3DParameters_inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) FacilityAnalystSinks3DParameters_setPrototypeOf(subClass, superClass); }

function FacilityAnalystSinks3DParameters_setPrototypeOf(o, p) { FacilityAnalystSinks3DParameters_setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return FacilityAnalystSinks3DParameters_setPrototypeOf(o, p); }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


/**
 * @class SuperMap.FacilityAnalystSinks3DParameters
 * @category  iServer FacilityAnalyst3D Sinks
 * @classdesc 最近设施分析参数类(汇查找资源)。最近设施分析是指在网络上给定一个事件点和一组设施点，查找从事件点到设施点(或从设施点到事件点)以最小耗费能到达的最佳路径。
 *            设施点一般为学校、超市、加油站等服务设施；事件点为需要服务设施的事件位置。例如事件发生点是一起交通事故，要求查找在10分钟内能到达的最近医院，超过10分钟
 *            能到达的都不予考虑。此例中，事故发生地即是一个事件点，周边的医院则是设施点。最近设施查找实际上也是一种路径分析，因此对路径分析起作用的障碍边、障碍点、
 *            转向表、耗费等属性在最近设施分析时同样可设置。
 * @extends {SuperMap.FacilityAnalyst3DParameters}
 * @param {Object} options - 参数。 
 * @param {string} options.weightName - 指定的权值字段信息对象的名称。 
 * @param {number} [options.edgeID] - 指定的弧段 ID，edgeID 与 nodeID 必须指定一个。  
 * @param {number} [options.nodeID] - 指定的结点 ID，edgeID 与 nodeID 必须指定一个。  
 * @param {boolean} [options.isUncertainDirectionValid=false] - 指定不确定流向是否有效。指定为 true，表示不确定流向有效，遇到不确定流向时分析继续进行；
 * 指定为 false，表示不确定流向无效，遇到不确定流向将停止在该方向上继续查找。
 */

var FacilityAnalystSinks3DParameters =
/*#__PURE__*/
function (_FacilityAnalyst3DPar) {
  FacilityAnalystSinks3DParameters_inherits(FacilityAnalystSinks3DParameters, _FacilityAnalyst3DPar);

  function FacilityAnalystSinks3DParameters(options) {
    var _this;

    FacilityAnalystSinks3DParameters_classCallCheck(this, FacilityAnalystSinks3DParameters);

    _this = FacilityAnalystSinks3DParameters_possibleConstructorReturn(this, FacilityAnalystSinks3DParameters_getPrototypeOf(FacilityAnalystSinks3DParameters).call(this, options));
    _this.CLASS_NAME = "SuperMap.FacilityAnalystSinks3DParameters";
    return _this;
  }
  /**
   * @function SuperMap.FacilityAnalystSinks3DParameters.prototype.destroy
   * @override
   */


  FacilityAnalystSinks3DParameters_createClass(FacilityAnalystSinks3DParameters, [{
    key: "destroy",
    value: function destroy() {
      FacilityAnalystSinks3DParameters_get(FacilityAnalystSinks3DParameters_getPrototypeOf(FacilityAnalystSinks3DParameters.prototype), "destroy", this).call(this);
    }
  }]);

  return FacilityAnalystSinks3DParameters;
}(FacilityAnalyst3DParameters_FacilityAnalyst3DParameters);
SuperMap.FacilityAnalystSinks3DParameters = FacilityAnalystSinks3DParameters;
// CONCATENATED MODULE: ./src/common/iServer/FacilityAnalystSinks3DService.js
function FacilityAnalystSinks3DService_typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { FacilityAnalystSinks3DService_typeof = function _typeof(obj) { return typeof obj; }; } else { FacilityAnalystSinks3DService_typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return FacilityAnalystSinks3DService_typeof(obj); }

function FacilityAnalystSinks3DService_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function FacilityAnalystSinks3DService_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function FacilityAnalystSinks3DService_createClass(Constructor, protoProps, staticProps) { if (protoProps) FacilityAnalystSinks3DService_defineProperties(Constructor.prototype, protoProps); if (staticProps) FacilityAnalystSinks3DService_defineProperties(Constructor, staticProps); return Constructor; }

function FacilityAnalystSinks3DService_possibleConstructorReturn(self, call) { if (call && (FacilityAnalystSinks3DService_typeof(call) === "object" || typeof call === "function")) { return call; } return FacilityAnalystSinks3DService_assertThisInitialized(self); }

function FacilityAnalystSinks3DService_assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function FacilityAnalystSinks3DService_getPrototypeOf(o) { FacilityAnalystSinks3DService_getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return FacilityAnalystSinks3DService_getPrototypeOf(o); }

function FacilityAnalystSinks3DService_inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) FacilityAnalystSinks3DService_setPrototypeOf(subClass, superClass); }

function FacilityAnalystSinks3DService_setPrototypeOf(o, p) { FacilityAnalystSinks3DService_setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return FacilityAnalystSinks3DService_setPrototypeOf(o, p); }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/



/**
 * @class SuperMap.FacilityAnalystSinks3DService
 * @category iServer FacilityAnalyst3D Sinks
 * @classdesc  最近设施分析服务类(汇查找资源)<br>
 *             最近设施分析是指在网络上给定一个事件点和一组设施点，
 *             查找从事件点到设施点(或从设施点到事件点)以最小耗费能到达的最佳路径。
 *             该类负责将客户端指定的最近设施分析参数传递给服务端，并接收服务端返回的结果数据。
 *             最近设施分析结果通过该类支持的事件的监听函数参数获取
 * @extends {SuperMap.CommonServiceBase}
 * @example
 * var myFacilityAnalystSinks3DService = new SuperMap.FacilityAnalystSinks3DService(url, {
 *     eventListeners: {
 *	       "processCompleted": facilityAnalystSinks3DCompleted,
 *		   "processFailed": facilityAnalystSinks3DError
 *		   }
 * });
 * @param {string} url - 网络分析服务地址。请求网络分析服务，URL应为：<br>
 *                       http://{服务器地址}:{服务端口号}/iserver/services/{网络分析服务名}/rest/networkanalyst/{网络数据集@数据源}；<br>
 *                       例如:"http://localhost:8090/iserver/services/components-rest/rest/networkanalyst/RoadNet@Changchun"。<br>
 * @param {Object} options - 参数。<br>
 * @param {Object} options.eventListeners - 需要被注册的监听器对象。
 * @param {boolean} [options.crossOrigin] - 是否允许跨域请求。
 * @param {Object} [options.headers] - 请求头。
 */

var FacilityAnalystSinks3DService_FacilityAnalystSinks3DService =
/*#__PURE__*/
function (_CommonServiceBase) {
  FacilityAnalystSinks3DService_inherits(FacilityAnalystSinks3DService, _CommonServiceBase);

  function FacilityAnalystSinks3DService(url, options) {
    var _this;

    FacilityAnalystSinks3DService_classCallCheck(this, FacilityAnalystSinks3DService);

    _this = FacilityAnalystSinks3DService_possibleConstructorReturn(this, FacilityAnalystSinks3DService_getPrototypeOf(FacilityAnalystSinks3DService).call(this, url, options));
    _this.CLASS_NAME = "SuperMap.FacilityAnalystSinks3DService";
    return _this;
  }
  /**
   * @function SuperMap.FacilityAnalystSinks3DService.prototype.destroy
   * @override
   */


  FacilityAnalystSinks3DService_createClass(FacilityAnalystSinks3DService, [{
    key: "destroy",
    value: function destroy() {
      CommonServiceBase_CommonServiceBase.prototype.destroy.apply(this, arguments);
    }
    /**
     * @function SuperMap.FacilityAnalystSinks3DService.prototype.processAsync
     * @description 负责将客户端的查询参数传递到服务端。
     * @param {SuperMap.FacilityAnalystSinks3DParameters} params - 最近设施分析参数类(汇查找资源)
     */

  }, {
    key: "processAsync",
    value: function processAsync(params) {
      if (!(params instanceof FacilityAnalystSinks3DParameters)) {
        return;
      }

      var me = this,
          jsonObject,
          end = me.url.substr(me.url.length - 1, 1);
      me.url = me.url + (end === "/" ? "sinks" : "/sinks") + ".json?";
      jsonObject = {
        edgeID: params.edgeID,
        nodeID: params.nodeID,
        weightName: params.weightName,
        isUncertainDirectionValid: params.isUncertainDirectionValid
      };
      me.request({
        method: "GET",
        params: jsonObject,
        scope: me,
        success: me.serviceProcessCompleted,
        failure: me.serviceProcessFailed
      });
    }
  }]);

  return FacilityAnalystSinks3DService;
}(CommonServiceBase_CommonServiceBase);
SuperMap.FacilityAnalystSinks3DService = FacilityAnalystSinks3DService_FacilityAnalystSinks3DService;
// CONCATENATED MODULE: ./src/common/iServer/FacilityAnalystSources3DParameters.js
function FacilityAnalystSources3DParameters_typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { FacilityAnalystSources3DParameters_typeof = function _typeof(obj) { return typeof obj; }; } else { FacilityAnalystSources3DParameters_typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return FacilityAnalystSources3DParameters_typeof(obj); }

function FacilityAnalystSources3DParameters_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function FacilityAnalystSources3DParameters_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function FacilityAnalystSources3DParameters_createClass(Constructor, protoProps, staticProps) { if (protoProps) FacilityAnalystSources3DParameters_defineProperties(Constructor.prototype, protoProps); if (staticProps) FacilityAnalystSources3DParameters_defineProperties(Constructor, staticProps); return Constructor; }

function FacilityAnalystSources3DParameters_possibleConstructorReturn(self, call) { if (call && (FacilityAnalystSources3DParameters_typeof(call) === "object" || typeof call === "function")) { return call; } return FacilityAnalystSources3DParameters_assertThisInitialized(self); }

function FacilityAnalystSources3DParameters_assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function FacilityAnalystSources3DParameters_get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { FacilityAnalystSources3DParameters_get = Reflect.get; } else { FacilityAnalystSources3DParameters_get = function _get(target, property, receiver) { var base = FacilityAnalystSources3DParameters_superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return FacilityAnalystSources3DParameters_get(target, property, receiver || target); }

function FacilityAnalystSources3DParameters_superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = FacilityAnalystSources3DParameters_getPrototypeOf(object); if (object === null) break; } return object; }

function FacilityAnalystSources3DParameters_getPrototypeOf(o) { FacilityAnalystSources3DParameters_getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return FacilityAnalystSources3DParameters_getPrototypeOf(o); }

function FacilityAnalystSources3DParameters_inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) FacilityAnalystSources3DParameters_setPrototypeOf(subClass, superClass); }

function FacilityAnalystSources3DParameters_setPrototypeOf(o, p) { FacilityAnalystSources3DParameters_setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return FacilityAnalystSources3DParameters_setPrototypeOf(o, p); }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


/**
 * @class SuperMap.FacilityAnalystSources3DParameters
 * @category  iServer FacilityAnalyst3D Sources 
 * @classdesc 最近设施分析参数类(源查找资源)。最近设施分析是指在网络上给定一个事件点和一组设施点，查找从事件点到设施点(或从设施点到事件点)以最小耗费能到达的最佳路径。
 *            设施点一般为学校、超市、加油站等服务设施；事件点为需要服务设施的事件位置。例如事件发生点是一起交通事故，要求查找在10分钟内能到达的最近医院，超过10分
 *            钟能到达的都不予考虑。此例中，事故发生地即是一个事件点，周边的医院则是设施点。最近设施查找实际上也是一种路径分析，因此对路径分析起作用的障碍边、障碍
 *            点、转向表、耗费等属性在最近设施分析时同样可设置。
 * @extends {SuperMap.FacilityAnalyst3DParameters}
 * @param {Object} options - 参数。 
 * @param {string} options.weightName - 指定的权值字段信息对象的名称。 
 * @param {number} [options.edgeID] - 指定的弧段 ID，edgeID 与 nodeID 必须指定一个。 
 * @param {number} [options.nodeID] - 指定的结点 ID，edgeID 与 nodeID 必须指定一个。  
 * @param {boolean} [options.isUncertainDirectionValid=false] - 指定不确定流向是否有效。指定为 true，表示不确定流向有效，遇到不确定流向时分析继续进行；
 * 指定为 false，表示不确定流向无效，遇到不确定流向将停止在该方向上继续查找。
 */

var FacilityAnalystSources3DParameters =
/*#__PURE__*/
function (_FacilityAnalyst3DPar) {
  FacilityAnalystSources3DParameters_inherits(FacilityAnalystSources3DParameters, _FacilityAnalyst3DPar);

  function FacilityAnalystSources3DParameters(options) {
    var _this;

    FacilityAnalystSources3DParameters_classCallCheck(this, FacilityAnalystSources3DParameters);

    _this = FacilityAnalystSources3DParameters_possibleConstructorReturn(this, FacilityAnalystSources3DParameters_getPrototypeOf(FacilityAnalystSources3DParameters).call(this, options));
    _this.CLASS_NAME = "SuperMap.FacilityAnalystSources3DParameters";
    return _this;
  }
  /**
   * @function SuperMap.FacilityAnalystSources3DParameters.prototype.destroy
   * @override
   */


  FacilityAnalystSources3DParameters_createClass(FacilityAnalystSources3DParameters, [{
    key: "destroy",
    value: function destroy() {
      FacilityAnalystSources3DParameters_get(FacilityAnalystSources3DParameters_getPrototypeOf(FacilityAnalystSources3DParameters.prototype), "destroy", this).call(this);
    }
  }]);

  return FacilityAnalystSources3DParameters;
}(FacilityAnalyst3DParameters_FacilityAnalyst3DParameters);
SuperMap.FacilityAnalystSources3DParameters = FacilityAnalystSources3DParameters;
// CONCATENATED MODULE: ./src/common/iServer/FacilityAnalystSources3DService.js
function FacilityAnalystSources3DService_typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { FacilityAnalystSources3DService_typeof = function _typeof(obj) { return typeof obj; }; } else { FacilityAnalystSources3DService_typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return FacilityAnalystSources3DService_typeof(obj); }

function FacilityAnalystSources3DService_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function FacilityAnalystSources3DService_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function FacilityAnalystSources3DService_createClass(Constructor, protoProps, staticProps) { if (protoProps) FacilityAnalystSources3DService_defineProperties(Constructor.prototype, protoProps); if (staticProps) FacilityAnalystSources3DService_defineProperties(Constructor, staticProps); return Constructor; }

function FacilityAnalystSources3DService_possibleConstructorReturn(self, call) { if (call && (FacilityAnalystSources3DService_typeof(call) === "object" || typeof call === "function")) { return call; } return FacilityAnalystSources3DService_assertThisInitialized(self); }

function FacilityAnalystSources3DService_assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function FacilityAnalystSources3DService_get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { FacilityAnalystSources3DService_get = Reflect.get; } else { FacilityAnalystSources3DService_get = function _get(target, property, receiver) { var base = FacilityAnalystSources3DService_superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return FacilityAnalystSources3DService_get(target, property, receiver || target); }

function FacilityAnalystSources3DService_superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = FacilityAnalystSources3DService_getPrototypeOf(object); if (object === null) break; } return object; }

function FacilityAnalystSources3DService_getPrototypeOf(o) { FacilityAnalystSources3DService_getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return FacilityAnalystSources3DService_getPrototypeOf(o); }

function FacilityAnalystSources3DService_inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) FacilityAnalystSources3DService_setPrototypeOf(subClass, superClass); }

function FacilityAnalystSources3DService_setPrototypeOf(o, p) { FacilityAnalystSources3DService_setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return FacilityAnalystSources3DService_setPrototypeOf(o, p); }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/



/**
 * @class SuperMap.FacilityAnalystSources3DService
 * @category  iServer FacilityAnalyst3D Sources
 * @classdesc 最近设施分析服务类(源查找资源)
 *            最近设施分析是指在网络上给定一个事件点和一组设施点，
 *            查找从事件点到设施点(或从设施点到事件点)以最小耗费能到达的最佳路径。
 *            该类负责将客户端指定的最近设施分析参数传递给服务端，并接收服务端返回的结果数据。
 *            最近设施分析结果通过该类支持的事件的监听函数参数获取。
 * @extends {SuperMap.CommonServiceBase}
 * @param {string} url - 网络分析服务地址。请求网络分析服务，URL应为：
 *                       http://{服务器地址}:{服务端口号}/iserver/services/{网络分析服务名}/rest/networkanalyst/{网络数据集@数据源}；
 *                       例如:"http://localhost:8090/iserver/services/components-rest/rest/networkanalyst/RoadNet@Changchun"。
 * @param {Object} options - 参数。
 * @param {Object} options.eventListeners - 需要被注册的监听器对象。
 * @param {boolean} [options.crossOrigin] - 是否允许跨域请求。
 * @param {Object} [options.headers] - 请求头。
 */

var FacilityAnalystSources3DService_FacilityAnalystSources3DService =
/*#__PURE__*/
function (_CommonServiceBase) {
  FacilityAnalystSources3DService_inherits(FacilityAnalystSources3DService, _CommonServiceBase);

  function FacilityAnalystSources3DService(url, options) {
    var _this;

    FacilityAnalystSources3DService_classCallCheck(this, FacilityAnalystSources3DService);

    _this = FacilityAnalystSources3DService_possibleConstructorReturn(this, FacilityAnalystSources3DService_getPrototypeOf(FacilityAnalystSources3DService).call(this, url, options));
    _this.CLASS_NAME = "SuperMap.FacilityAnalystSources3DService";
    return _this;
  }
  /**
   * @function SuperMap.FacilityAnalystSources3DService.prototype.destroy
   * @override
   */


  FacilityAnalystSources3DService_createClass(FacilityAnalystSources3DService, [{
    key: "destroy",
    value: function destroy() {
      FacilityAnalystSources3DService_get(FacilityAnalystSources3DService_getPrototypeOf(FacilityAnalystSources3DService.prototype), "destroy", this).call(this);
    }
    /**
     * @function SuperMap.FacilityAnalystSources3DService.prototype.processAsync
     * @description 负责将客户端的查询参数传递到服务端。
     * @param {SuperMap.FacilityAnalystSources3DParameters} params - 最近设施分析参数类（源查找资源）
     */

  }, {
    key: "processAsync",
    value: function processAsync(params) {
      if (!(params instanceof FacilityAnalystSources3DParameters)) {
        return;
      }

      var me = this,
          jsonObject,
          end = me.url.substr(me.url.length - 1, 1);
      me.url = me.url + (end === "/" ? "sources" : "/sources") + ".json?";
      jsonObject = {
        edgeID: params.edgeID,
        nodeID: params.nodeID,
        weightName: params.weightName,
        isUncertainDirectionValid: params.isUncertainDirectionValid
      };
      me.request({
        method: "GET",
        params: jsonObject,
        scope: me,
        success: me.serviceProcessCompleted,
        failure: me.serviceProcessFailed
      });
    }
  }]);

  return FacilityAnalystSources3DService;
}(CommonServiceBase_CommonServiceBase);
SuperMap.FacilityAnalystSources3DService = FacilityAnalystSources3DService_FacilityAnalystSources3DService;
// CONCATENATED MODULE: ./src/common/iServer/FacilityAnalystStreamParameters.js
function FacilityAnalystStreamParameters_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function FacilityAnalystStreamParameters_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function FacilityAnalystStreamParameters_createClass(Constructor, protoProps, staticProps) { if (protoProps) FacilityAnalystStreamParameters_defineProperties(Constructor.prototype, protoProps); if (staticProps) FacilityAnalystStreamParameters_defineProperties(Constructor, staticProps); return Constructor; }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


/**
 * @class SuperMap.FacilityAnalystStreamParameters
 * @category iServer NetworkAnalyst UpstreamCriticalFacilities
 * @classdesc 上游/下游关键设施查找资源参数类。
 * @param {Object} options - 参数。 
 * @param {Array.<number>} options.sourceNodeIDs - 指定的设施点 ID 数组。 
 * @param {number} options.queryType - 分析类型，只能是 0 (上游关键设施查询) 或者是 1（下游关键设施查询）。
 * @param {number} [options.edgeID] - 指定的弧段 ID，edgeID 与 nodeID 必须指定一个。  
 * @param {number} [options.nodeID] - 指定的结点 ID，edgeID 与 nodeID 必须指定一个。  
 * @param {boolean} [options.isUncertainDirectionValid=false] - 指定不确定流向是否有效。
 */

var FacilityAnalystStreamParameters_FacilityAnalystStreamParameters =
/*#__PURE__*/
function () {
  function FacilityAnalystStreamParameters(options) {
    FacilityAnalystStreamParameters_classCallCheck(this, FacilityAnalystStreamParameters);

    /**
     * @member {Array.<number>} [SuperMap.FacilityAnalystStreamParameters.prototype.sourceNodeIDs]
     * @description 指定的设施点 ID 数组。
     */
    this.sourceNodeIDs = null;
    /**
     * @member {number} [SuperMap.FacilityAnalystStreamParameters.prototype.edgeID]
     * @description 指定的弧段 ID，edgeID 与 nodeID 必须指定一个。 
     */

    this.edgeID = null;
    /**
     * @member {number} [SuperMap.FacilityAnalystStreamParameters.prototype.nodeID]
     * @description 指定的结点 ID，edgeID 与 nodeID 必须指定一个。 
     */

    this.nodeID = null;
    /**
     * @member {boolean} [SuperMap.FacilityAnalystStreamParameters.prototype.isUncertainDirectionValid=false]
     * @description 指定不确定流向是否有效。指定为 true，表示不确定流向有效，遇到不确定流向时分析继续进行；
     *              指定为 false，表示不确定流向无效，遇到不确定流向将停止在该方向上继续查找。
     */

    this.isUncertainDirectionValid = false;
    /**
     * @member {number} SuperMap.FacilityAnalystStreamParameters.prototype.queryType
     * @description 分析类型，只能是 0 (上游关键设施查询) 或者是 1（下游关键设施查询）。
     */

    this.queryType = null;
    Util.extend(this, options);
    this.CLASS_NAME = "SuperMap.FacilityAnalystStreamParameters";
  }
  /**
   * @function SuperMap.FacilityAnalystStreamParameters.prototype.destroy
   * @description 释放资源，将引用资源的属性置空。
   */


  FacilityAnalystStreamParameters_createClass(FacilityAnalystStreamParameters, [{
    key: "destroy",
    value: function destroy() {
      var me = this;
      me.edgeID = null;
      me.nodeID = null;
      me.weightName = null;
      me.isUncertainDirectionValid = null;
      me.type = null;
    }
  }]);

  return FacilityAnalystStreamParameters;
}();
SuperMap.FacilityAnalystStreamParameters = FacilityAnalystStreamParameters_FacilityAnalystStreamParameters;
// CONCATENATED MODULE: ./src/common/iServer/FacilityAnalystStreamService.js
function FacilityAnalystStreamService_typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { FacilityAnalystStreamService_typeof = function _typeof(obj) { return typeof obj; }; } else { FacilityAnalystStreamService_typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return FacilityAnalystStreamService_typeof(obj); }

function FacilityAnalystStreamService_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function FacilityAnalystStreamService_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function FacilityAnalystStreamService_createClass(Constructor, protoProps, staticProps) { if (protoProps) FacilityAnalystStreamService_defineProperties(Constructor.prototype, protoProps); if (staticProps) FacilityAnalystStreamService_defineProperties(Constructor, staticProps); return Constructor; }

function FacilityAnalystStreamService_possibleConstructorReturn(self, call) { if (call && (FacilityAnalystStreamService_typeof(call) === "object" || typeof call === "function")) { return call; } return FacilityAnalystStreamService_assertThisInitialized(self); }

function FacilityAnalystStreamService_assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function FacilityAnalystStreamService_get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { FacilityAnalystStreamService_get = Reflect.get; } else { FacilityAnalystStreamService_get = function _get(target, property, receiver) { var base = FacilityAnalystStreamService_superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return FacilityAnalystStreamService_get(target, property, receiver || target); }

function FacilityAnalystStreamService_superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = FacilityAnalystStreamService_getPrototypeOf(object); if (object === null) break; } return object; }

function FacilityAnalystStreamService_getPrototypeOf(o) { FacilityAnalystStreamService_getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return FacilityAnalystStreamService_getPrototypeOf(o); }

function FacilityAnalystStreamService_inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) FacilityAnalystStreamService_setPrototypeOf(subClass, superClass); }

function FacilityAnalystStreamService_setPrototypeOf(o, p) { FacilityAnalystStreamService_setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return FacilityAnalystStreamService_setPrototypeOf(o, p); }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/



/**
 * @class SuperMap.FacilityAnalystStreamService
 * @category iServer NetworkAnalyst UpstreamCriticalFacilities
 * @classdesc 上游/下游 关键设施查找资源服务类；即查找给定弧段或节点的上游/下游中的关键设施结点，返回关键结点 ID 数组及其下游弧段 ID 数组。
 * @extends SuperMap.NetworkAnalystServiceBase
 * @param {string} url - 网络分析服务地址。请求网络分析服务，URL应为：
 *                       http://{服务器地址}:{服务端口号}/iserver/services/{网络分析服务名}/rest/networkanalyst/{网络数据集@数据源}；
 *                       例如: "http://localhost:8090/iserver/services/test/rest/networkanalyst/WaterNet@FacilityNet";
 * @param {Object} options - 参数。
 * @param {Object} options.eventListeners - 需要被注册的监听器对象。
 * @param {boolean} [options.crossOrigin] - 是否允许跨域请求。
 * @param {Object} [options.headers] - 请求头。
 */

var FacilityAnalystStreamService_FacilityAnalystStreamService =
/*#__PURE__*/
function (_NetworkAnalystServic) {
  FacilityAnalystStreamService_inherits(FacilityAnalystStreamService, _NetworkAnalystServic);

  function FacilityAnalystStreamService(url, options) {
    var _this;

    FacilityAnalystStreamService_classCallCheck(this, FacilityAnalystStreamService);

    _this = FacilityAnalystStreamService_possibleConstructorReturn(this, FacilityAnalystStreamService_getPrototypeOf(FacilityAnalystStreamService).call(this, url, options));
    _this.CLASS_NAME = "SuperMap.FacilityAnalystStreamService";
    return _this;
  }
  /**
   * @function SuperMap.FacilityAnalystStreamService.prototype.destroy
   * @override
   */


  FacilityAnalystStreamService_createClass(FacilityAnalystStreamService, [{
    key: "destroy",
    value: function destroy() {
      FacilityAnalystStreamService_get(FacilityAnalystStreamService_getPrototypeOf(FacilityAnalystStreamService.prototype), "destroy", this).call(this);
    }
    /**
     * @function SuperMap.FacilityAnalystStreamService.prototype.processAsync
     * @description 负责将客户端的查询参数传递到服务端。
     * @param {SuperMap.FacilityAnalystStreamParameters} params - 上游/下游关键设施查找资源参数类。
     */

  }, {
    key: "processAsync",
    value: function processAsync(params) {
      if (!(params instanceof FacilityAnalystStreamParameters_FacilityAnalystStreamParameters)) {
        return;
      }

      var me = this,
          jsonObject;
      var end = me.url.substr(me.url.length - 1, 1); //URL 通过参数类型来判断是 上游 还是下游 查询

      if (params.queryType === 0) {
        me.url = me.url + (end === "/" ? "upstreamcirticalfaclilities" : "/upstreamcirticalfaclilities") + ".json?";
      } else if (params.queryType === 1) {
        me.url = me.url + (end === "/" ? "downstreamcirticalfaclilities" : "/downstreamcirticalfaclilities") + ".json?";
      } else {
        return;
      }

      jsonObject = {
        sourceNodeIDs: params.sourceNodeIDs,
        isUncertainDirectionValid: params.isUncertainDirectionValid
      };

      if (params.edgeID !== null && params.nodeID !== null) {
        return;
      }

      if (params.edgeID === null && params.nodeID === null) {
        return;
      }

      if (params.edgeID !== null) {
        jsonObject.edgeID = params.edgeID;
      } else {
        jsonObject.nodeID = params.nodeID;
      }

      me.request({
        method: "GET",
        params: jsonObject,
        scope: me,
        success: me.serviceProcessCompleted,
        failure: me.serviceProcessFailed
      });
    }
  }]);

  return FacilityAnalystStreamService;
}(NetworkAnalystServiceBase_NetworkAnalystServiceBase);
SuperMap.FacilityAnalystStreamService = FacilityAnalystStreamService_FacilityAnalystStreamService;
// CONCATENATED MODULE: ./src/common/iServer/FacilityAnalystTracedown3DParameters.js
function FacilityAnalystTracedown3DParameters_typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { FacilityAnalystTracedown3DParameters_typeof = function _typeof(obj) { return typeof obj; }; } else { FacilityAnalystTracedown3DParameters_typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return FacilityAnalystTracedown3DParameters_typeof(obj); }

function FacilityAnalystTracedown3DParameters_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function FacilityAnalystTracedown3DParameters_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function FacilityAnalystTracedown3DParameters_createClass(Constructor, protoProps, staticProps) { if (protoProps) FacilityAnalystTracedown3DParameters_defineProperties(Constructor.prototype, protoProps); if (staticProps) FacilityAnalystTracedown3DParameters_defineProperties(Constructor, staticProps); return Constructor; }

function FacilityAnalystTracedown3DParameters_possibleConstructorReturn(self, call) { if (call && (FacilityAnalystTracedown3DParameters_typeof(call) === "object" || typeof call === "function")) { return call; } return FacilityAnalystTracedown3DParameters_assertThisInitialized(self); }

function FacilityAnalystTracedown3DParameters_assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function FacilityAnalystTracedown3DParameters_get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { FacilityAnalystTracedown3DParameters_get = Reflect.get; } else { FacilityAnalystTracedown3DParameters_get = function _get(target, property, receiver) { var base = FacilityAnalystTracedown3DParameters_superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return FacilityAnalystTracedown3DParameters_get(target, property, receiver || target); }

function FacilityAnalystTracedown3DParameters_superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = FacilityAnalystTracedown3DParameters_getPrototypeOf(object); if (object === null) break; } return object; }

function FacilityAnalystTracedown3DParameters_getPrototypeOf(o) { FacilityAnalystTracedown3DParameters_getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return FacilityAnalystTracedown3DParameters_getPrototypeOf(o); }

function FacilityAnalystTracedown3DParameters_inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) FacilityAnalystTracedown3DParameters_setPrototypeOf(subClass, superClass); }

function FacilityAnalystTracedown3DParameters_setPrototypeOf(o, p) { FacilityAnalystTracedown3DParameters_setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return FacilityAnalystTracedown3DParameters_setPrototypeOf(o, p); }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


/**
 * @class SuperMap.FacilityAnalystTracedown3DParameters
 * @category iServer FacilityAnalyst3D TraceDownResult
 * @classdesc 下游追踪资源参数类。
 * @extends {SuperMap.FacilityAnalyst3DParameters}
 * @param {Object} options - 参数。 
 * @param {string} options.weightName - 指定的权值字段信息对象的名称。 
 * @param {number} [options.edgeID] - 指定的弧段 ID，edgeID 与 nodeID 必须指定一个。  
 * @param {number} [options.nodeID] - 指定的结点 ID，edgeID 与 nodeID 必须指定一个。  
 * @param {boolean} [options.isUncertainDirectionValid=false] - 指定不确定流向是否有效。指定为 true，表示不确定流向有效，遇到不确定流向时分析继续进行；
 * 指定为 false，表示不确定流向无效，遇到不确定流向将停止在该方向上继续查找。

 */

var FacilityAnalystTracedown3DParameters =
/*#__PURE__*/
function (_FacilityAnalyst3DPar) {
  FacilityAnalystTracedown3DParameters_inherits(FacilityAnalystTracedown3DParameters, _FacilityAnalyst3DPar);

  function FacilityAnalystTracedown3DParameters(options) {
    var _this;

    FacilityAnalystTracedown3DParameters_classCallCheck(this, FacilityAnalystTracedown3DParameters);

    _this = FacilityAnalystTracedown3DParameters_possibleConstructorReturn(this, FacilityAnalystTracedown3DParameters_getPrototypeOf(FacilityAnalystTracedown3DParameters).call(this, options));
    _this.CLASS_NAME = "SuperMap.FacilityAnalystTracedown3DParameters";
    return _this;
  }
  /**
   * @function SuperMap.FacilityAnalystTracedown3DParameters.prototype.destroy
   * @override
   */


  FacilityAnalystTracedown3DParameters_createClass(FacilityAnalystTracedown3DParameters, [{
    key: "destroy",
    value: function destroy() {
      FacilityAnalystTracedown3DParameters_get(FacilityAnalystTracedown3DParameters_getPrototypeOf(FacilityAnalystTracedown3DParameters.prototype), "destroy", this).call(this);
    }
  }]);

  return FacilityAnalystTracedown3DParameters;
}(FacilityAnalyst3DParameters_FacilityAnalyst3DParameters);
SuperMap.FacilityAnalystTracedown3DParameters = FacilityAnalystTracedown3DParameters;
// CONCATENATED MODULE: ./src/common/iServer/FacilityAnalystTracedown3DService.js
function FacilityAnalystTracedown3DService_typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { FacilityAnalystTracedown3DService_typeof = function _typeof(obj) { return typeof obj; }; } else { FacilityAnalystTracedown3DService_typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return FacilityAnalystTracedown3DService_typeof(obj); }

function FacilityAnalystTracedown3DService_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function FacilityAnalystTracedown3DService_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function FacilityAnalystTracedown3DService_createClass(Constructor, protoProps, staticProps) { if (protoProps) FacilityAnalystTracedown3DService_defineProperties(Constructor.prototype, protoProps); if (staticProps) FacilityAnalystTracedown3DService_defineProperties(Constructor, staticProps); return Constructor; }

function FacilityAnalystTracedown3DService_possibleConstructorReturn(self, call) { if (call && (FacilityAnalystTracedown3DService_typeof(call) === "object" || typeof call === "function")) { return call; } return FacilityAnalystTracedown3DService_assertThisInitialized(self); }

function FacilityAnalystTracedown3DService_assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function FacilityAnalystTracedown3DService_get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { FacilityAnalystTracedown3DService_get = Reflect.get; } else { FacilityAnalystTracedown3DService_get = function _get(target, property, receiver) { var base = FacilityAnalystTracedown3DService_superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return FacilityAnalystTracedown3DService_get(target, property, receiver || target); }

function FacilityAnalystTracedown3DService_superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = FacilityAnalystTracedown3DService_getPrototypeOf(object); if (object === null) break; } return object; }

function FacilityAnalystTracedown3DService_getPrototypeOf(o) { FacilityAnalystTracedown3DService_getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return FacilityAnalystTracedown3DService_getPrototypeOf(o); }

function FacilityAnalystTracedown3DService_inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) FacilityAnalystTracedown3DService_setPrototypeOf(subClass, superClass); }

function FacilityAnalystTracedown3DService_setPrototypeOf(o, p) { FacilityAnalystTracedown3DService_setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return FacilityAnalystTracedown3DService_setPrototypeOf(o, p); }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/



/**
 * @class SuperMap.FacilityAnalystTracedown3DService
 * @category iServer FacilityAnalyst3D TraceDownResult
 * @classdesc 下游追踪资源服务类
 * @extends {SuperMap.CommonServiceBase}
 * @param {string} url - 网络分析服务地址。请求网络分析服务，URL应为：
 *                       http://{服务器地址}:{服务端口号}/iserver/services/{网络分析服务名}/rest/networkanalyst/{网络数据集@数据源}；
 *                       例如:"http://localhost:8090/iserver/services/components-rest/rest/networkanalyst/RoadNet@Changchun"。
 * @param {Object} options - 参数。
 * @param {Object} options.eventListeners - 需要被注册的监听器对象。
 * @param {boolean} [options.crossOrigin] - 是否允许跨域请求。
 * @param {Object} [options.headers] - 请求头。
 */

var FacilityAnalystTracedown3DService_FacilityAnalystTracedown3DService =
/*#__PURE__*/
function (_CommonServiceBase) {
  FacilityAnalystTracedown3DService_inherits(FacilityAnalystTracedown3DService, _CommonServiceBase);

  function FacilityAnalystTracedown3DService(url, options) {
    var _this;

    FacilityAnalystTracedown3DService_classCallCheck(this, FacilityAnalystTracedown3DService);

    _this = FacilityAnalystTracedown3DService_possibleConstructorReturn(this, FacilityAnalystTracedown3DService_getPrototypeOf(FacilityAnalystTracedown3DService).call(this, url, options));
    _this.CLASS_NAME = "SuperMap.FacilityAnalystTracedown3DService";
    return _this;
  }
  /**
   * @function SuperMap.FacilityAnalystTracedown3DService.prototype.destroy
   * @override
   */


  FacilityAnalystTracedown3DService_createClass(FacilityAnalystTracedown3DService, [{
    key: "destroy",
    value: function destroy() {
      FacilityAnalystTracedown3DService_get(FacilityAnalystTracedown3DService_getPrototypeOf(FacilityAnalystTracedown3DService.prototype), "destroy", this).call(this);
    }
    /**
     * @function SuperMap.FacilityAnalystTracedown3DService.prototype.processAsync
     * @description 负责将客户端的查询参数传递到服务端。
     * @param {SuperMap.FacilityAnalystTracedown3DParameters} params - 下游追踪资源参数类。
     */

  }, {
    key: "processAsync",
    value: function processAsync(params) {
      if (!(params instanceof FacilityAnalystTracedown3DParameters)) {
        return;
      }

      var me = this,
          jsonObject,
          end = me.url.substr(me.url.length - 1, 1);
      me.url = me.url + (end === "/" ? "tracedownresult" : "/tracedownresult") + ".json?";
      jsonObject = {
        edgeID: params.edgeID,
        nodeID: params.nodeID,
        weightName: params.weightName,
        isUncertainDirectionValid: params.isUncertainDirectionValid
      };
      me.request({
        method: "GET",
        params: jsonObject,
        scope: me,
        success: me.serviceProcessCompleted,
        failure: me.serviceProcessFailed
      });
    }
  }]);

  return FacilityAnalystTracedown3DService;
}(CommonServiceBase_CommonServiceBase);
SuperMap.FacilityAnalystTracedown3DService = FacilityAnalystTracedown3DService_FacilityAnalystTracedown3DService;
// CONCATENATED MODULE: ./src/common/iServer/FacilityAnalystTraceup3DParameters.js
function FacilityAnalystTraceup3DParameters_typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { FacilityAnalystTraceup3DParameters_typeof = function _typeof(obj) { return typeof obj; }; } else { FacilityAnalystTraceup3DParameters_typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return FacilityAnalystTraceup3DParameters_typeof(obj); }

function FacilityAnalystTraceup3DParameters_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function FacilityAnalystTraceup3DParameters_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function FacilityAnalystTraceup3DParameters_createClass(Constructor, protoProps, staticProps) { if (protoProps) FacilityAnalystTraceup3DParameters_defineProperties(Constructor.prototype, protoProps); if (staticProps) FacilityAnalystTraceup3DParameters_defineProperties(Constructor, staticProps); return Constructor; }

function FacilityAnalystTraceup3DParameters_possibleConstructorReturn(self, call) { if (call && (FacilityAnalystTraceup3DParameters_typeof(call) === "object" || typeof call === "function")) { return call; } return FacilityAnalystTraceup3DParameters_assertThisInitialized(self); }

function FacilityAnalystTraceup3DParameters_assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function FacilityAnalystTraceup3DParameters_get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { FacilityAnalystTraceup3DParameters_get = Reflect.get; } else { FacilityAnalystTraceup3DParameters_get = function _get(target, property, receiver) { var base = FacilityAnalystTraceup3DParameters_superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return FacilityAnalystTraceup3DParameters_get(target, property, receiver || target); }

function FacilityAnalystTraceup3DParameters_superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = FacilityAnalystTraceup3DParameters_getPrototypeOf(object); if (object === null) break; } return object; }

function FacilityAnalystTraceup3DParameters_getPrototypeOf(o) { FacilityAnalystTraceup3DParameters_getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return FacilityAnalystTraceup3DParameters_getPrototypeOf(o); }

function FacilityAnalystTraceup3DParameters_inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) FacilityAnalystTraceup3DParameters_setPrototypeOf(subClass, superClass); }

function FacilityAnalystTraceup3DParameters_setPrototypeOf(o, p) { FacilityAnalystTraceup3DParameters_setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return FacilityAnalystTraceup3DParameters_setPrototypeOf(o, p); }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


/**
 * @class SuperMap.FacilityAnalystTraceup3DParameters
 * @category iServer FacilityAnalyst3D TraceUpResult
 * @classdesc 上游追踪资源参数类。
 * @extends {SuperMap.FacilityAnalyst3DParameters}
 * @param {Object} options - 参数。 
 * @param {string} options.weightName - 指定的权值字段信息对象的名称。 
 * @param {number} [options.edgeID] - 指定的弧段ID，edgeID 与 nodeID 必须指定一个。 
 * @param {number} [options.nodeID] - 指定的结点ID，edgeID 与 nodeID 必须指定一个。 
 * @param {boolean} [options.isUncertainDirectionValid=false] - 指定不确定流向是否有效。指定为 true，表示不确定流向有效，遇到不确定流向时分析继续进行；
 * 指定为 false，表示不确定流向无效，遇到不确定流向将停止在该方向上继续查找。
 */

var FacilityAnalystTraceup3DParameters =
/*#__PURE__*/
function (_FacilityAnalyst3DPar) {
  FacilityAnalystTraceup3DParameters_inherits(FacilityAnalystTraceup3DParameters, _FacilityAnalyst3DPar);

  function FacilityAnalystTraceup3DParameters(options) {
    var _this;

    FacilityAnalystTraceup3DParameters_classCallCheck(this, FacilityAnalystTraceup3DParameters);

    _this = FacilityAnalystTraceup3DParameters_possibleConstructorReturn(this, FacilityAnalystTraceup3DParameters_getPrototypeOf(FacilityAnalystTraceup3DParameters).call(this, options));
    _this.CLASS_NAME = "SuperMap.FacilityAnalystTraceup3DParameters";
    return _this;
  }
  /**
   * @function SuperMap.FacilityAnalystTraceup3DParameters.prototype.destroy
   * @override
   */


  FacilityAnalystTraceup3DParameters_createClass(FacilityAnalystTraceup3DParameters, [{
    key: "destroy",
    value: function destroy() {
      FacilityAnalystTraceup3DParameters_get(FacilityAnalystTraceup3DParameters_getPrototypeOf(FacilityAnalystTraceup3DParameters.prototype), "destroy", this).call(this);
    }
  }]);

  return FacilityAnalystTraceup3DParameters;
}(FacilityAnalyst3DParameters_FacilityAnalyst3DParameters);
SuperMap.FacilityAnalystTraceup3DParameters = FacilityAnalystTraceup3DParameters;
// CONCATENATED MODULE: ./src/common/iServer/FacilityAnalystTraceup3DService.js
function FacilityAnalystTraceup3DService_typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { FacilityAnalystTraceup3DService_typeof = function _typeof(obj) { return typeof obj; }; } else { FacilityAnalystTraceup3DService_typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return FacilityAnalystTraceup3DService_typeof(obj); }

function FacilityAnalystTraceup3DService_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function FacilityAnalystTraceup3DService_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function FacilityAnalystTraceup3DService_createClass(Constructor, protoProps, staticProps) { if (protoProps) FacilityAnalystTraceup3DService_defineProperties(Constructor.prototype, protoProps); if (staticProps) FacilityAnalystTraceup3DService_defineProperties(Constructor, staticProps); return Constructor; }

function FacilityAnalystTraceup3DService_possibleConstructorReturn(self, call) { if (call && (FacilityAnalystTraceup3DService_typeof(call) === "object" || typeof call === "function")) { return call; } return FacilityAnalystTraceup3DService_assertThisInitialized(self); }

function FacilityAnalystTraceup3DService_assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function FacilityAnalystTraceup3DService_get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { FacilityAnalystTraceup3DService_get = Reflect.get; } else { FacilityAnalystTraceup3DService_get = function _get(target, property, receiver) { var base = FacilityAnalystTraceup3DService_superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return FacilityAnalystTraceup3DService_get(target, property, receiver || target); }

function FacilityAnalystTraceup3DService_superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = FacilityAnalystTraceup3DService_getPrototypeOf(object); if (object === null) break; } return object; }

function FacilityAnalystTraceup3DService_getPrototypeOf(o) { FacilityAnalystTraceup3DService_getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return FacilityAnalystTraceup3DService_getPrototypeOf(o); }

function FacilityAnalystTraceup3DService_inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) FacilityAnalystTraceup3DService_setPrototypeOf(subClass, superClass); }

function FacilityAnalystTraceup3DService_setPrototypeOf(o, p) { FacilityAnalystTraceup3DService_setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return FacilityAnalystTraceup3DService_setPrototypeOf(o, p); }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/



/**
 * @class SuperMap.FacilityAnalystTraceup3DService
 * @category iServer FacilityAnalyst3D TraceUpResult
 * @classdesc 上游追踪资源服务类
 * @extends {SuperMap.CommonServiceBase}
 * @param {string} url - 网络分析服务地址。请求网络分析服务，URL应为：
 *                       http://{服务器地址}:{服务端口号}/iserver/services/{网络分析服务名}/rest/networkanalyst/{网络数据集@数据源}；
 *                       例如:"http://localhost:8090/iserver/services/components-rest/rest/networkanalyst/RoadNet@Changchun"。
 * @param {Object} options - 参数。
 * @param {Object} options.eventListeners - 需要被注册的监听器对象。
 * @param {boolean} [options.crossOrigin] - 是否允许跨域请求。
 * @param {Object} [options.headers] - 请求头。
 */

var FacilityAnalystTraceup3DService_FacilityAnalystTraceup3DService =
/*#__PURE__*/
function (_CommonServiceBase) {
  FacilityAnalystTraceup3DService_inherits(FacilityAnalystTraceup3DService, _CommonServiceBase);

  /**
   * @function SuperMap.FacilityAnalystTraceup3DService.constructor
   * @description 上游追踪资源服务类构造函数。
   * @param {string} url - 网络分析服务地址。请求网络分析服务，URL应为：
   *                       http://{服务器地址}:{服务端口号}/iserver/services/{网络分析服务名}/rest/networkanalyst/{网络数据集@数据源}；
   *                       例如:"http://localhost:8090/iserver/services/components-rest/rest/networkanalyst/RoadNet@Changchun"。
   * @param {Object} options - 参数。
   * @param {Object} options.eventListeners - 需要被注册的监听器对象。
   */
  function FacilityAnalystTraceup3DService(url, options) {
    var _this;

    FacilityAnalystTraceup3DService_classCallCheck(this, FacilityAnalystTraceup3DService);

    _this = FacilityAnalystTraceup3DService_possibleConstructorReturn(this, FacilityAnalystTraceup3DService_getPrototypeOf(FacilityAnalystTraceup3DService).call(this, url, options));
    _this.CLASS_NAME = "SuperMap.FacilityAnalystTraceup3DService";
    return _this;
  }
  /**
   * @function SuperMap.FacilityAnalystTraceup3DService.prototype.destroy
   * @override
   */


  FacilityAnalystTraceup3DService_createClass(FacilityAnalystTraceup3DService, [{
    key: "destroy",
    value: function destroy() {
      FacilityAnalystTraceup3DService_get(FacilityAnalystTraceup3DService_getPrototypeOf(FacilityAnalystTraceup3DService.prototype), "destroy", this).call(this);
    }
    /**
     * @function SuperMap.FacilityAnalystTraceup3DService.prototype.processAsync
     * @description 负责将客户端的查询参数传递到服务端。
     * @param {SuperMap.FacilityAnalystTraceup3DParameters} params - 上游追踪资源参数类
     */

  }, {
    key: "processAsync",
    value: function processAsync(params) {
      if (!(params instanceof FacilityAnalystTraceup3DParameters)) {
        return;
      }

      var me = this,
          jsonObject,
          end = me.url.substr(me.url.length - 1, 1);
      me.url = me.url + (end === "/" ? "traceupresult" : "/traceupresult") + ".json?";
      jsonObject = {
        edgeID: params.edgeID,
        nodeID: params.nodeID,
        weightName: params.weightName,
        isUncertainDirectionValid: params.isUncertainDirectionValid
      };
      me.request({
        method: "GET",
        params: jsonObject,
        scope: me,
        success: me.serviceProcessCompleted,
        failure: me.serviceProcessFailed
      });
    }
  }]);

  return FacilityAnalystTraceup3DService;
}(CommonServiceBase_CommonServiceBase);
SuperMap.FacilityAnalystTraceup3DService = FacilityAnalystTraceup3DService_FacilityAnalystTraceup3DService;
// CONCATENATED MODULE: ./src/common/iServer/FacilityAnalystUpstream3DParameters.js
function FacilityAnalystUpstream3DParameters_typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { FacilityAnalystUpstream3DParameters_typeof = function _typeof(obj) { return typeof obj; }; } else { FacilityAnalystUpstream3DParameters_typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return FacilityAnalystUpstream3DParameters_typeof(obj); }

function FacilityAnalystUpstream3DParameters_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function FacilityAnalystUpstream3DParameters_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function FacilityAnalystUpstream3DParameters_createClass(Constructor, protoProps, staticProps) { if (protoProps) FacilityAnalystUpstream3DParameters_defineProperties(Constructor.prototype, protoProps); if (staticProps) FacilityAnalystUpstream3DParameters_defineProperties(Constructor, staticProps); return Constructor; }

function FacilityAnalystUpstream3DParameters_possibleConstructorReturn(self, call) { if (call && (FacilityAnalystUpstream3DParameters_typeof(call) === "object" || typeof call === "function")) { return call; } return FacilityAnalystUpstream3DParameters_assertThisInitialized(self); }

function FacilityAnalystUpstream3DParameters_assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function FacilityAnalystUpstream3DParameters_get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { FacilityAnalystUpstream3DParameters_get = Reflect.get; } else { FacilityAnalystUpstream3DParameters_get = function _get(target, property, receiver) { var base = FacilityAnalystUpstream3DParameters_superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return FacilityAnalystUpstream3DParameters_get(target, property, receiver || target); }

function FacilityAnalystUpstream3DParameters_superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = FacilityAnalystUpstream3DParameters_getPrototypeOf(object); if (object === null) break; } return object; }

function FacilityAnalystUpstream3DParameters_getPrototypeOf(o) { FacilityAnalystUpstream3DParameters_getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return FacilityAnalystUpstream3DParameters_getPrototypeOf(o); }

function FacilityAnalystUpstream3DParameters_inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) FacilityAnalystUpstream3DParameters_setPrototypeOf(subClass, superClass); }

function FacilityAnalystUpstream3DParameters_setPrototypeOf(o, p) { FacilityAnalystUpstream3DParameters_setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return FacilityAnalystUpstream3DParameters_setPrototypeOf(o, p); }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/



/**
 * @class SuperMap.FacilityAnalystUpstream3DParameters
 * @category iServer FacilityAnalyst3D UpstreamCriticalFacilities
 * @classdesc 上游关键设施查找资源参数类。
 * @extends {SuperMap.FacilityAnalyst3DParameters}
 * @param {Object} options - 参数。 
 * @param {Array.<number>} options.sourceNodeIDs - 指定的设施点 ID 数组。 
 * @param {number} [options.edgeID] - 指定的弧段ID。edgeID 与 nodeID 必须指定一个。  
 * @param {number} [options.nodeID] - 指定的结点ID。edgeID 与 edgeID 必须指定一个。
 * @param {boolean} [options.isUncertainDirectionValid=false] - 指定不确定流向是否有效。指定为 true，表示不确定流向有效，遇到不确定流向时分析继续进行；
 * 指定为 false，表示不确定流向无效，遇到不确定流向将停止在该方向上继续查找。 
 */

var FacilityAnalystUpstream3DParameters_FacilityAnalystUpstream3DParameters =
/*#__PURE__*/
function (_FacilityAnalyst3DPar) {
  FacilityAnalystUpstream3DParameters_inherits(FacilityAnalystUpstream3DParameters, _FacilityAnalyst3DPar);

  function FacilityAnalystUpstream3DParameters(options) {
    var _this;

    FacilityAnalystUpstream3DParameters_classCallCheck(this, FacilityAnalystUpstream3DParameters);

    _this = FacilityAnalystUpstream3DParameters_possibleConstructorReturn(this, FacilityAnalystUpstream3DParameters_getPrototypeOf(FacilityAnalystUpstream3DParameters).call(this, options));
    options = options || {};
    _this.sourceNodeIDs = null;
    Util.extend(FacilityAnalystUpstream3DParameters_assertThisInitialized(_this), options);
    _this.CLASS_NAME = "SuperMap.FacilityAnalystUpstream3DParameters";
    return _this;
  }
  /**
   * @function SuperMap.FacilityAnalystUpstream3DParameters.prototype.destroy
   * @override
   */


  FacilityAnalystUpstream3DParameters_createClass(FacilityAnalystUpstream3DParameters, [{
    key: "destroy",
    value: function destroy() {
      FacilityAnalystUpstream3DParameters_get(FacilityAnalystUpstream3DParameters_getPrototypeOf(FacilityAnalystUpstream3DParameters.prototype), "destroy", this).call(this);

      this.sourceNodeIDs = null;
    }
  }]);

  return FacilityAnalystUpstream3DParameters;
}(FacilityAnalyst3DParameters_FacilityAnalyst3DParameters);
SuperMap.FacilityAnalystUpstream3DParameters = FacilityAnalystUpstream3DParameters_FacilityAnalystUpstream3DParameters;
// CONCATENATED MODULE: ./src/common/iServer/FacilityAnalystUpstream3DService.js
function FacilityAnalystUpstream3DService_typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { FacilityAnalystUpstream3DService_typeof = function _typeof(obj) { return typeof obj; }; } else { FacilityAnalystUpstream3DService_typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return FacilityAnalystUpstream3DService_typeof(obj); }

function FacilityAnalystUpstream3DService_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function FacilityAnalystUpstream3DService_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function FacilityAnalystUpstream3DService_createClass(Constructor, protoProps, staticProps) { if (protoProps) FacilityAnalystUpstream3DService_defineProperties(Constructor.prototype, protoProps); if (staticProps) FacilityAnalystUpstream3DService_defineProperties(Constructor, staticProps); return Constructor; }

function FacilityAnalystUpstream3DService_possibleConstructorReturn(self, call) { if (call && (FacilityAnalystUpstream3DService_typeof(call) === "object" || typeof call === "function")) { return call; } return FacilityAnalystUpstream3DService_assertThisInitialized(self); }

function FacilityAnalystUpstream3DService_assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function FacilityAnalystUpstream3DService_get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { FacilityAnalystUpstream3DService_get = Reflect.get; } else { FacilityAnalystUpstream3DService_get = function _get(target, property, receiver) { var base = FacilityAnalystUpstream3DService_superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return FacilityAnalystUpstream3DService_get(target, property, receiver || target); }

function FacilityAnalystUpstream3DService_superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = FacilityAnalystUpstream3DService_getPrototypeOf(object); if (object === null) break; } return object; }

function FacilityAnalystUpstream3DService_getPrototypeOf(o) { FacilityAnalystUpstream3DService_getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return FacilityAnalystUpstream3DService_getPrototypeOf(o); }

function FacilityAnalystUpstream3DService_inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) FacilityAnalystUpstream3DService_setPrototypeOf(subClass, superClass); }

function FacilityAnalystUpstream3DService_setPrototypeOf(o, p) { FacilityAnalystUpstream3DService_setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return FacilityAnalystUpstream3DService_setPrototypeOf(o, p); }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/



/**
 * @class SuperMap.FacilityAnalystUpstream3DService
 * @category  iServer FacilityAnalyst3D UpstreamCriticalFacilities
 * @classdesc 上游关键设施查找资源服务类
 * @extends {SuperMap.CommonServiceBase}
 * @param {string} url - 网络分析服务地址。请求网络分析服务，URL应为：
 *                       http://{服务器地址}:{服务端口号}/iserver/services/{网络分析服务名}/rest/networkanalyst/{网络数据集@数据源}；
 *                       例如:"http://localhost:8090/iserver/services/components-rest/rest/networkanalyst/RoadNet@Changchun"。
 * @param {Object} options - 参数。
 * @param {Object} options.eventListeners - 需要被注册的监听器对象。
 * @param {boolean} [options.crossOrigin] - 是否允许跨域请求。
 * @param {Object} [options.headers] - 请求头。
 */

var FacilityAnalystUpstream3DService_FacilityAnalystUpstream3DService =
/*#__PURE__*/
function (_CommonServiceBase) {
  FacilityAnalystUpstream3DService_inherits(FacilityAnalystUpstream3DService, _CommonServiceBase);

  function FacilityAnalystUpstream3DService(url, options) {
    var _this;

    FacilityAnalystUpstream3DService_classCallCheck(this, FacilityAnalystUpstream3DService);

    _this = FacilityAnalystUpstream3DService_possibleConstructorReturn(this, FacilityAnalystUpstream3DService_getPrototypeOf(FacilityAnalystUpstream3DService).call(this, url, options));
    _this.CLASS_NAME = "SuperMap.FacilityAnalystUpstream3DService";
    return _this;
  }
  /**
   * @function SuperMap.FacilityAnalystUpstream3DService.prototype.destroy
   * @override
   */


  FacilityAnalystUpstream3DService_createClass(FacilityAnalystUpstream3DService, [{
    key: "destroy",
    value: function destroy() {
      FacilityAnalystUpstream3DService_get(FacilityAnalystUpstream3DService_getPrototypeOf(FacilityAnalystUpstream3DService.prototype), "destroy", this).call(this);
    }
    /**
     * @function SuperMap.FacilityAnalystUpstream3DService.prototype.processAsync
     * @description 负责将客户端的查询参数传递到服务端。
     * @param {SuperMap.FacilityAnalystUpstream3DParameters} params - 上游关键设施查找资源参数类
     */

  }, {
    key: "processAsync",
    value: function processAsync(params) {
      if (!(params instanceof FacilityAnalystUpstream3DParameters_FacilityAnalystUpstream3DParameters)) {
        return;
      }

      var me = this,
          jsonObject,
          end = me.url.substr(me.url.length - 1, 1);
      me.url = me.url + (end === "/" ? "upstreamcirticalfaclilities" : "/upstreamcirticalfaclilities") + ".json?";
      jsonObject = {
        sourceNodeIDs: params.sourceNodeIDs,
        edgeID: params.edgeID,
        nodeID: params.nodeID,
        isUncertainDirectionValid: params.isUncertainDirectionValid
      };
      me.request({
        method: "GET",
        params: jsonObject,
        scope: me,
        success: me.serviceProcessCompleted,
        failure: me.serviceProcessFailed
      });
    }
  }]);

  return FacilityAnalystUpstream3DService;
}(CommonServiceBase_CommonServiceBase);
SuperMap.FacilityAnalystUpstream3DService = FacilityAnalystUpstream3DService_FacilityAnalystUpstream3DService;
// CONCATENATED MODULE: ./src/common/iServer/FilterAggParameter.js
function FilterAggParameter_typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { FilterAggParameter_typeof = function _typeof(obj) { return typeof obj; }; } else { FilterAggParameter_typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return FilterAggParameter_typeof(obj); }

function FilterAggParameter_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function FilterAggParameter_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function FilterAggParameter_createClass(Constructor, protoProps, staticProps) { if (protoProps) FilterAggParameter_defineProperties(Constructor.prototype, protoProps); if (staticProps) FilterAggParameter_defineProperties(Constructor, staticProps); return Constructor; }

function FilterAggParameter_possibleConstructorReturn(self, call) { if (call && (FilterAggParameter_typeof(call) === "object" || typeof call === "function")) { return call; } return FilterAggParameter_assertThisInitialized(self); }

function FilterAggParameter_assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function FilterAggParameter_get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { FilterAggParameter_get = Reflect.get; } else { FilterAggParameter_get = function _get(target, property, receiver) { var base = FilterAggParameter_superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return FilterAggParameter_get(target, property, receiver || target); }

function FilterAggParameter_superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = FilterAggParameter_getPrototypeOf(object); if (object === null) break; } return object; }

function FilterAggParameter_getPrototypeOf(o) { FilterAggParameter_getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return FilterAggParameter_getPrototypeOf(o); }

function FilterAggParameter_inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) FilterAggParameter_setPrototypeOf(subClass, superClass); }

function FilterAggParameter_setPrototypeOf(o, p) { FilterAggParameter_setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return FilterAggParameter_setPrototypeOf(o, p); }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/





/**
 * @class SuperMap.FilterAggParameter
 * @classdesc 过滤条件参数设置，该参数仅支持数据来源 Elasticsearch 服务的数据服务。
 * @category iServer Data FeatureResults
 * @param {Object} options - 初始化参数。
 * @param {SuperMap.AggQueryBuilderParameter} options.filterParam - 过滤条件参数设置类。
 * @param {SuperMap.AggregationType} [options.aggType=AggregationType.FILTER] - 聚合类型。
 */

var FilterAggParameter_FilterAggParameter =
/*#__PURE__*/
function (_AggregationParameter) {
  FilterAggParameter_inherits(FilterAggParameter, _AggregationParameter);

  function FilterAggParameter(options) {
    var _this;

    FilterAggParameter_classCallCheck(this, FilterAggParameter);

    _this = FilterAggParameter_possibleConstructorReturn(this, FilterAggParameter_getPrototypeOf(FilterAggParameter).call(this, options));
    /**
     * @member {SuperMap.AggQueryBuilderParameter} SuperMap.FilterAggParameter.prototype.filterParam
     * @description 过滤条件参数设置类。
     */

    _this.filterParam = null;
    /**
     * @member {SuperMap.AggregationType} [SuperMap.FilterAggParameter.prototype.aggType=AggregationType.FILTER]
     * @description 聚合类型。
     */

    _this.aggType = AggregationType.FILTER;
    _this.CLASS_NAME = "SuperMap.FilterAggParameter";
    Util.extend(FilterAggParameter_assertThisInitialized(_this), options);
    return _this;
  }

  FilterAggParameter_createClass(FilterAggParameter, [{
    key: "destroy",
    value: function destroy() {
      FilterAggParameter_get(FilterAggParameter_getPrototypeOf(FilterAggParameter.prototype), "destroy", this).call(this);

      var me = this;

      if (me.filterParam) {
        me.filterParam = null;
      }
    }
  }]);

  return FilterAggParameter;
}(AggregationParameter_AggregationParameter);
SuperMap.FilterAggParameter = FilterAggParameter_FilterAggParameter;
// CONCATENATED MODULE: ./src/common/iServer/FieldParameters.js
function FieldParameters_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function FieldParameters_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function FieldParameters_createClass(Constructor, protoProps, staticProps) { if (protoProps) FieldParameters_defineProperties(Constructor.prototype, protoProps); if (staticProps) FieldParameters_defineProperties(Constructor, staticProps); return Constructor; }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


/**
 * @class SuperMap.FieldParameters
 * @category iServer Data Field
 * @classdesc 字段信息查询参数类。
 * @param {Object} options - 参数。 
 * @param {string} options.datasource - 数据源名称。
 * @param {string} options.dataset - 数据集名称。
 */

var FieldParameters_FieldParameters =
/*#__PURE__*/
function () {
  function FieldParameters(options) {
    FieldParameters_classCallCheck(this, FieldParameters);

    /**
     * @member {string} SuperMap.FieldParameters.prototype.datasource
     * @description 要查询的数据集所在的数据源名称。
     */
    this.datasource = null;
    /**
     *  @member {string} SuperMap.FieldParameters.prototype.dataset
     *  @description 要查询的数据集名称。
     */

    this.dataset = null;

    if (options) {
      Util.extend(this, options);
    }

    this.CLASS_NAME = "SuperMap.FieldParameters";
  }
  /**
   * @function SuperMap.FieldParameters.prototype.destroy
   * @description 释放资源，将引用资源的属性置空。
   */


  FieldParameters_createClass(FieldParameters, [{
    key: "destroy",
    value: function destroy() {
      var me = this;
      me.datasource = null;
      me.dataset = null;
    }
  }]);

  return FieldParameters;
}();
SuperMap.FieldParameters = FieldParameters_FieldParameters;
// CONCATENATED MODULE: ./src/common/iServer/FieldStatisticsParameters.js
function FieldStatisticsParameters_typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { FieldStatisticsParameters_typeof = function _typeof(obj) { return typeof obj; }; } else { FieldStatisticsParameters_typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return FieldStatisticsParameters_typeof(obj); }

function FieldStatisticsParameters_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function FieldStatisticsParameters_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function FieldStatisticsParameters_createClass(Constructor, protoProps, staticProps) { if (protoProps) FieldStatisticsParameters_defineProperties(Constructor.prototype, protoProps); if (staticProps) FieldStatisticsParameters_defineProperties(Constructor, staticProps); return Constructor; }

function FieldStatisticsParameters_possibleConstructorReturn(self, call) { if (call && (FieldStatisticsParameters_typeof(call) === "object" || typeof call === "function")) { return call; } return FieldStatisticsParameters_assertThisInitialized(self); }

function FieldStatisticsParameters_getPrototypeOf(o) { FieldStatisticsParameters_getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return FieldStatisticsParameters_getPrototypeOf(o); }

function FieldStatisticsParameters_assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function FieldStatisticsParameters_inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) FieldStatisticsParameters_setPrototypeOf(subClass, superClass); }

function FieldStatisticsParameters_setPrototypeOf(o, p) { FieldStatisticsParameters_setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return FieldStatisticsParameters_setPrototypeOf(o, p); }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/



/**
 * @class SuperMap.FieldStatisticsParameters
 * @category iServer Data Field
 * @classdesc 字段统计信息查询参数类。
 * @param {Object} options - 参数。 
 * @param {string} options.datasource - 数据源名称。 
 * @param {string} options.dataset - 数据集名称。 
 * @param {string} options.fieldName - 字段名。 
 * @param {(string.<SuperMap.StatisticMode>|Array.<string.<SuperMap.StatisticMode>>)} statisticMode - 字段统计方法类型。
 * @extends {SuperMap.FieldParameters}
 */

var FieldStatisticsParameters_FieldStatisticsParameters =
/*#__PURE__*/
function (_FieldParameters) {
  FieldStatisticsParameters_inherits(FieldStatisticsParameters, _FieldParameters);

  function FieldStatisticsParameters(options) {
    var _this;

    FieldStatisticsParameters_classCallCheck(this, FieldStatisticsParameters);

    _this = FieldStatisticsParameters_possibleConstructorReturn(this, FieldStatisticsParameters_getPrototypeOf(FieldStatisticsParameters).call(this, options));
    /**
     * @member {string} SuperMap.FieldStatisticsParameters.prototype.fieldName
     * @description 字段名
     */

    _this.fieldName = null;
    /**
     * @member {(string.<SuperMap.StatisticMode>|Array.<string.<SuperMap.StatisticMode>>)} SuperMap.FieldStatisticsParameters.prototype.statisticMode
     * @description 字段统计方法类型
     */

    _this.statisticMode = null;

    if (options) {
      Util.extend(FieldStatisticsParameters_assertThisInitialized(_this), options);
    }

    _this.CLASS_NAME = "SuperMap.FieldStatisticsParameters";
    return _this;
  }
  /**
   * @function SuperMap.FieldStatisticsParameters.prototype.destroy
   * @description 释放资源，将引用资源的属性置空。
   */


  FieldStatisticsParameters_createClass(FieldStatisticsParameters, [{
    key: "destroy",
    value: function destroy() {
      var me = this;
      me.fieldName = null;
      me.statisticMode = null;
    }
  }]);

  return FieldStatisticsParameters;
}(FieldParameters_FieldParameters);
SuperMap.FieldStatisticsParameters = FieldStatisticsParameters_FieldStatisticsParameters;
// CONCATENATED MODULE: ./src/common/iServer/FieldStatisticService.js
function FieldStatisticService_typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { FieldStatisticService_typeof = function _typeof(obj) { return typeof obj; }; } else { FieldStatisticService_typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return FieldStatisticService_typeof(obj); }

function FieldStatisticService_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function FieldStatisticService_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function FieldStatisticService_createClass(Constructor, protoProps, staticProps) { if (protoProps) FieldStatisticService_defineProperties(Constructor.prototype, protoProps); if (staticProps) FieldStatisticService_defineProperties(Constructor, staticProps); return Constructor; }

function FieldStatisticService_possibleConstructorReturn(self, call) { if (call && (FieldStatisticService_typeof(call) === "object" || typeof call === "function")) { return call; } return FieldStatisticService_assertThisInitialized(self); }

function FieldStatisticService_assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function FieldStatisticService_get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { FieldStatisticService_get = Reflect.get; } else { FieldStatisticService_get = function _get(target, property, receiver) { var base = FieldStatisticService_superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return FieldStatisticService_get(target, property, receiver || target); }

function FieldStatisticService_superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = FieldStatisticService_getPrototypeOf(object); if (object === null) break; } return object; }

function FieldStatisticService_getPrototypeOf(o) { FieldStatisticService_getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return FieldStatisticService_getPrototypeOf(o); }

function FieldStatisticService_inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) FieldStatisticService_setPrototypeOf(subClass, superClass); }

function FieldStatisticService_setPrototypeOf(o, p) { FieldStatisticService_setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return FieldStatisticService_setPrototypeOf(o, p); }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/




/**
 * @class SuperMap.FieldStatisticService
 * @category iServer Data Field
 * @classdesc 字段查询统计服务类。用来完成对指定数据集指定字段的查询统计分析，即求平均值，最大值等。
 * @extends {SuperMap.CommonServiceBase}
 * @param {string} url - 服务的访问地址。如访问 World Map 服务，只需将 url 设为：http://localhost:8090/iserver/services/data-world/rest/data 即可。
 * @param {Object} options - 参数。
 * @param {Object} options.eventListeners - 事件监听器对象。有 processCompleted 属性可传入处理完成后的回调函数。processFailed 属性传入处理失败后的回调函数。
 * @param {SuperMap.ServerType} [options.serverType=SuperMap.ServerType.ISERVER] - 服务器类型，iServer|iPortal|Online。
 * @param {SuperMap.DataFormat} [options.format] - 查询结果返回格式，目前支持 iServerJSON 和GeoJSON 两种格式。参数格式为 "ISERVER","GEOJSON"。
 * @param {string} options.datasource - 数据集所在的数据源名称。
 * @param {string} options.dataset - 数据集名称。
 * @param {string} options.field - 查询统计的目标字段名称。
 * @param {SuperMap.StatisticMode} options.statisticMode - 字段查询统计的方法类型。
 * @param {boolean} [options.crossOrigin] - 是否允许跨域请求。
 * @param {Object} [options.headers] - 请求头。
 * @example
 * var myService = new SuperMap.FieldStatisticService(url, {eventListeners: {
 *     "processCompleted": fieldStatisticCompleted,
 *     "processFailed": fieldStatisticError
 *     }，
 *     datasource: "World",
 *     dataset: "Countries",
 *     field: "SmID",
 *     statisticMode: StatisticMode.AVERAGE
 * };
 */

var FieldStatisticService_FieldStatisticService =
/*#__PURE__*/
function (_CommonServiceBase) {
  FieldStatisticService_inherits(FieldStatisticService, _CommonServiceBase);

  function FieldStatisticService(url, options) {
    var _this;

    FieldStatisticService_classCallCheck(this, FieldStatisticService);

    _this = FieldStatisticService_possibleConstructorReturn(this, FieldStatisticService_getPrototypeOf(FieldStatisticService).call(this, url, options));
    /**
     * @member {string} SuperMap.FieldStatisticService.prototype.datasource
     * @description 数据集所在的数据源名称。
     */

    _this.datasource = null;
    /**
     * @member {string} SuperMap.FieldStatisticService.prototype.dataset
     * @description 数据集名称。
     */

    _this.dataset = null;
    /**
     * @member {string} SuperMap.FieldStatisticService.prototype.field
     * @description 查询统计的目标字段名称。
     */

    _this.field = null;
    /**
     * @member {SuperMap.StatisticMode} SuperMap.FieldStatisticService.prototype.statisticMode
     * @description 字段查询统计的方法类型。
     */

    _this.statisticMode = null;

    if (options) {
      Util.extend(FieldStatisticService_assertThisInitialized(_this), options);
    }

    _this.CLASS_NAME = "SuperMap.FieldStatisticService";
    return _this;
  }
  /**
   * @function SuperMap.FieldStatisticService.prototype.destroy
   * @override
   */


  FieldStatisticService_createClass(FieldStatisticService, [{
    key: "destroy",
    value: function destroy() {
      FieldStatisticService_get(FieldStatisticService_getPrototypeOf(FieldStatisticService.prototype), "destroy", this).call(this);

      var me = this;
      me.datasource = null;
      me.dataset = null;
      me.field = null;
      me.statisticMode = null;
    }
    /**
     * @function SuperMap.FieldStatisticService.prototype.processAsync
     * @description 执行服务，进行指定字段的查询统计。
     */

  }, {
    key: "processAsync",
    value: function processAsync() {
      var me = this,
          end = me.url.substr(me.url.length - 1, 1),
          fieldStatisticURL = "datasources/" + me.datasource + "/datasets/" + me.dataset + "/fields/" + me.field + "/" + me.statisticMode;
      me.url += end == "/" ? fieldStatisticURL + ".json?" : "/" + fieldStatisticURL + ".json?";
      me.request({
        method: "GET",
        data: null,
        scope: me,
        success: me.serviceProcessCompleted,
        failure: me.serviceProcessFailed
      });
    }
  }]);

  return FieldStatisticService;
}(CommonServiceBase_CommonServiceBase);
SuperMap.FieldStatisticService = FieldStatisticService_FieldStatisticService;
// CONCATENATED MODULE: ./src/common/iServer/FindClosestFacilitiesParameters.js
function FindClosestFacilitiesParameters_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function FindClosestFacilitiesParameters_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function FindClosestFacilitiesParameters_createClass(Constructor, protoProps, staticProps) { if (protoProps) FindClosestFacilitiesParameters_defineProperties(Constructor.prototype, protoProps); if (staticProps) FindClosestFacilitiesParameters_defineProperties(Constructor, staticProps); return Constructor; }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/



/**
 * @class SuperMap.FindClosestFacilitiesParameters
 * @category iServer NetworkAnalyst ClosestFacility
 * @classdesc 最近设施分析参数类。
 * @param {Object} options - 参数。 
 * @param {(SuperMap.Geometry.Point|L.LatLng|L.Point|ol.geom.Point|number)} options.event - 事件点，一般为需要获得服务设施服务的事件位置。 
 * @param {Array.<SuperMap.Geometry.Point|L.LatLng|L.Point|ol.geom.Point|number>}  options.facilities - 设施点集合，一般为提供服务的服务设施位置。 
 * @param {number} [options.expectFacilityCount=1] - 要查找的设施点数量。 
 * @param {boolean} [options.fromEvent=false] - 是否从事件点到设施点进行查找。 
 * @param {boolean} [options.isAnalyzeById=false] - 事件点和设施点是否通过节点 ID 号来指定。 
 * @param {number} [options.maxWeight=0] - 查找半径。单位与该类中 parameter 字段（交通网络分析通用参数）中设置的耗费字段一致。 
 * @param {SuperMap.TransportationAnalystParameter} [options.parameter] - 交通网络分析通用参数。
 */

var FindClosestFacilitiesParameters_FindClosestFacilitiesParameters =
/*#__PURE__*/
function () {
  function FindClosestFacilitiesParameters(options) {
    FindClosestFacilitiesParameters_classCallCheck(this, FindClosestFacilitiesParameters);

    /**
     * @member {(SuperMap.Geometry.Point|L.LatLng|L.Point|ol.geom.Point|number)} SuperMap.FindClosestFacilitiesParameters.prototype.event
     * @description 事件点，一般为需要获得服务设施服务的事件位置。
     *              可以通过两种方式赋予事件点：当该类中字段 isAnalyzeById = true 时，应输入事件点 ID 号；当 isAnalyzeById = false 时，应输入事件点坐标。
     */
    this.event = null;
    /**
     * @member {number} [SuperMap.FindClosestFacilitiesParameters.prototype.expectFacilityCount=1]
     * @description 要查找的设施点数量。
     */

    this.expectFacilityCount = 1;
    /**
     * @member {Array.<SuperMap.Geometry.Point|L.LatLng|L.Point|ol.geom.Point|number>} [SuperMap.FindClosestFacilitiesParameters.prototype.facilities=false]
     * @description 设施点集合，一般为提供服务的服务设施位置。
     *              可以通过两种方式赋予设施点：当该类中字段 isAnalyzeById = true 时，应输入设施点 ID 号；当 isAnalyzeById = false 时，应输入设施点坐标。
     */

    this.facilities = null;
    /**
     * @member {boolean} [SuperMap.FindClosestFacilitiesParameters.prototype.fromEvent=false]
     * @description 是否从事件点到设施点进行查找。最近设施分析主要是通过设施点和事件点之间最优的路线来分析在一定范围内哪个或哪些设施与事件点有最优路线的关系。
     *              这个行走线路是通过网络图层进行网络分析算法计算出来的两点间的最优路线。由于存在从 A 点到 B 点与从 B 点到 A 点的耗费不一样的情况，因此起止点
     *              不同可能会得到不同的最优路线。因此在进行最近设施分析之前，需要设置获取的最优路线的方向，即是以事件点作为起点到最近设施点的方向分析，还是以最
     *              近设施点为起点到事件点的方向分析。如果需要以事件点作为起点到设施点方向进行查找，设置该字段值为 true；设置为 false，表示从设施点到事件点进行查找。
     */

    this.fromEvent = false;
    /**
     * @member {boolean} [SuperMap.FindClosestFacilitiesParameters.prototype.isAnalyzeById=false]
     * @description 事件点和设施点是否通过节点 ID 号来指定，设置为 false，表示通过坐标点指定事件点和设施点。
     */

    this.isAnalyzeById = false;
    /**
     * @member {number} [SuperMap.FindClosestFacilitiesParameters.prototype.maxWeight=0]
     * @description 查找半径。单位与该类中 parameter 字段（交通网络分析通用参数）中设置的耗费字段一致。
     *              例如事件发生点是一起交通事故，要求查找在 10 分钟内能到达的最近医院，超过 10 分钟能到达的都不予考虑。
     *              那么需要将网络分析参数中 parameter.weightFieldName 设置为表示时间的字段，然后设置查找范围的半径值为10。
     */

    this.maxWeight = 0;
    /**
     * @member {SuperMap.TransportationAnalystParameter} [SuperMap.FindClosestFacilitiesParameters.prototype.parameter]
     * @description 交通网络分析通用参数。通过本类可以设置障碍边、障碍点、权值字段信息的名称标识、转向权值字段等信息。
     *              它为 SuperMap.TransportationAnalystParameter 类型，虽然为可选参数，但是如果不设置其中的 resultSetting 字段，
     *              则返回结果空间信息等都为空。
     */

    this.parameter = new TransportationAnalystParameter_TransportationAnalystParameter();
    Util.extend(this, options);
    this.CLASS_NAME = "SuperMap.FindClosestFacilitiesParameters";
  }
  /**
   * @function SuperMap.FindClosestFacilitiesParameters.prototype.destroy
   * @description 释放资源，将引用资源的属性置空。
   */


  FindClosestFacilitiesParameters_createClass(FindClosestFacilitiesParameters, [{
    key: "destroy",
    value: function destroy() {
      var me = this;
      me.event = null;
      me.expectFacilityCount = null;
      me.facilities = null;
      me.fromEvent = null;
      me.isAnalyzeById = null;
      me.maxWeight = null;

      if (me.parameter) {
        me.parameter.destroy();
        me.parameter = null;
      }
    }
  }]);

  return FindClosestFacilitiesParameters;
}();
SuperMap.FindClosestFacilitiesParameters = FindClosestFacilitiesParameters_FindClosestFacilitiesParameters;
// CONCATENATED MODULE: ./src/common/iServer/FindClosestFacilitiesService.js
function FindClosestFacilitiesService_typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { FindClosestFacilitiesService_typeof = function _typeof(obj) { return typeof obj; }; } else { FindClosestFacilitiesService_typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return FindClosestFacilitiesService_typeof(obj); }

function FindClosestFacilitiesService_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function FindClosestFacilitiesService_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function FindClosestFacilitiesService_createClass(Constructor, protoProps, staticProps) { if (protoProps) FindClosestFacilitiesService_defineProperties(Constructor.prototype, protoProps); if (staticProps) FindClosestFacilitiesService_defineProperties(Constructor, staticProps); return Constructor; }

function FindClosestFacilitiesService_possibleConstructorReturn(self, call) { if (call && (FindClosestFacilitiesService_typeof(call) === "object" || typeof call === "function")) { return call; } return FindClosestFacilitiesService_assertThisInitialized(self); }

function FindClosestFacilitiesService_assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function FindClosestFacilitiesService_get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { FindClosestFacilitiesService_get = Reflect.get; } else { FindClosestFacilitiesService_get = function _get(target, property, receiver) { var base = FindClosestFacilitiesService_superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return FindClosestFacilitiesService_get(target, property, receiver || target); }

function FindClosestFacilitiesService_superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = FindClosestFacilitiesService_getPrototypeOf(object); if (object === null) break; } return object; }

function FindClosestFacilitiesService_getPrototypeOf(o) { FindClosestFacilitiesService_getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return FindClosestFacilitiesService_getPrototypeOf(o); }

function FindClosestFacilitiesService_inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) FindClosestFacilitiesService_setPrototypeOf(subClass, superClass); }

function FindClosestFacilitiesService_setPrototypeOf(o, p) { FindClosestFacilitiesService_setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return FindClosestFacilitiesService_setPrototypeOf(o, p); }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/





/**
 * @class SuperMap.FindClosestFacilitiesService
 * @category  iServer NetworkAnalyst ClosestFacility
 * @classdesc 最近设施分析服务类。
 *            最近设施分析是指在网络上给定一个事件点和一组设施点，
 *            查找从事件点到设施点(或从设施点到事件点)以最小耗费能到达的最佳路径。
 *            该类负责将客户端指定的最近设施分析参数传递给服务端，并接收服务端返回的结果数据。
 *            最近设施分析结果通过该类支持的事件的监听函数参数获取
 * @extends {SuperMap.NetworkAnalystServiceBase}
 * @example
 * var myfindClosestFacilitiesService = new SuperMap.FindClosestFacilitiesService(url, {
 *     eventListeners: {
 *	       "processCompleted": findClosestFacilitiesCompleted,
 *		   "processFailed": findClosestFacilitiesError
 *		   }
 * });
 * @param {string} url - 网络分析服务地址。请求网络分析服务，URL应为：
 *                       http://{服务器地址}:{服务端口号}/iserver/services/{网络分析服务名}/rest/networkanalyst/{网络数据集@数据源}；
 *                       例如:"http://localhost:8090/iserver/services/components-rest/rest/networkanalyst/RoadNet@Changchun"。
 * @param {Object} options - 参数。
 * @param {Object} options.eventListeners - 需要被注册的监听器对象。
 * @param {boolean} [options.crossOrigin] - 是否允许跨域请求。
 * @param {Object} [options.headers] - 请求头。
 */

var FindClosestFacilitiesService_FindClosestFacilitiesService =
/*#__PURE__*/
function (_NetworkAnalystServic) {
  FindClosestFacilitiesService_inherits(FindClosestFacilitiesService, _NetworkAnalystServic);

  /*
   * @function SuperMap.FindClosestFacilitiesService.prototype.constructor
   * @description 最近设施分析服务类构造函数。
   * @param {string} url - 网络分析服务地址。请求网络分析服务，URL应为：
   *                       http://{服务器地址}:{服务端口号}/iserver/services/{网络分析服务名}/rest/networkanalyst/{网络数据集@数据源}；
   *                       例如:"http://localhost:8090/iserver/services/components-rest/rest/networkanalyst/RoadNet@Changchun"。
   * @param {Object} options - 选参数。<br>
   * @param {Object} options.eventListeners - 需要被注册的监听器对象。
   */
  function FindClosestFacilitiesService(url, options) {
    var _this;

    FindClosestFacilitiesService_classCallCheck(this, FindClosestFacilitiesService);

    _this = FindClosestFacilitiesService_possibleConstructorReturn(this, FindClosestFacilitiesService_getPrototypeOf(FindClosestFacilitiesService).call(this, url, options));
    _this.CLASS_NAME = "SuperMap.FindClosestFacilitiesService";
    return _this;
  }
  /**
   * @function SuperMap.FindClosestFacilitiesService.prototype.destroy
   * @override
   */


  FindClosestFacilitiesService_createClass(FindClosestFacilitiesService, [{
    key: "destroy",
    value: function destroy() {
      FindClosestFacilitiesService_get(FindClosestFacilitiesService_getPrototypeOf(FindClosestFacilitiesService.prototype), "destroy", this).call(this);
    }
    /**
     * @function SuperMap.FindClosestFacilitiesService.prototype.processAsync
     * @description 负责将客户端的查询参数传递到服务端。
     * @param {SuperMap.FindClosestFacilitiesParameters} params - 最近设施分析服务参数类
     */

  }, {
    key: "processAsync",
    value: function processAsync(params) {
      if (!(params instanceof FindClosestFacilitiesParameters_FindClosestFacilitiesParameters)) {
        return;
      }

      var me = this,
          jsonObject,
          end = me.url.substr(me.url.length - 1, 1);
      me.url = me.url + (end === "/" ? "closestfacility" : "/closestfacility") + ".json?";
      jsonObject = {
        expectFacilityCount: params.expectFacilityCount,
        fromEvent: params.fromEvent,
        maxWeight: params.maxWeight,
        parameter: Util.toJSON(params.parameter),
        event: Util.toJSON(params.event),
        facilities: me.getJson(params.isAnalyzeById, params.facilities)
      };
      me.request({
        method: "GET",
        params: jsonObject,
        scope: me,
        success: me.serviceProcessCompleted,
        failure: me.serviceProcessFailed
      });
    }
    /**
     * @function SuperMap.FindClosestFacilitiesService.prototype.getJson
     * @description 将对象转化为JSON字符串。
     * @param {boolean} isAnalyzeById - 是否通过ID来分析
     * @param {Array} params - 分析参数数组
     * @returns {Object} 转化后的JSON字符串。
     */

  }, {
    key: "getJson",
    value: function getJson(isAnalyzeById, params) {
      var jsonString = "[",
          len = params ? params.length : 0;

      if (isAnalyzeById === false) {
        for (var i = 0; i < len; i++) {
          if (i > 0) {
            jsonString += ",";
          }

          jsonString += '{"x":' + params[i].x + ',"y":' + params[i].y + '}';
        }
      } else if (isAnalyzeById === true) {
        for (var _i = 0; _i < len; _i++) {
          if (_i > 0) {
            jsonString += ",";
          }

          jsonString += params[_i];
        }
      }

      jsonString += ']';
      return jsonString;
    }
    /**
     * @function SuperMap.FindClosestFacilitiesService.prototype.toGeoJSONResult
     * @description 将含有 geometry 的数据转换为 GeoJSON 格式。
     * @param {Object} result - 服务器返回的结果对象。
     */

  }, {
    key: "toGeoJSONResult",
    value: function toGeoJSONResult(result) {
      if (!result || !result.facilityPathList) {
        return result;
      }

      var geoJSONFormat = new GeoJSON_GeoJSON();
      result.facilityPathList.map(function (path) {
        if (path.route) {
          path.route = geoJSONFormat.toGeoJSON(path.route);
        }

        if (path.pathGuideItems) {
          path.pathGuideItems = geoJSONFormat.toGeoJSON(path.pathGuideItems);
        }

        if (path.edgeFeatures) {
          path.edgeFeatures = geoJSONFormat.toGeoJSON(path.edgeFeatures);
        }

        if (path.nodeFeatures) {
          path.nodeFeatures = geoJSONFormat.toGeoJSON(path.nodeFeatures);
        }

        return path;
      });
      return result;
    }
  }]);

  return FindClosestFacilitiesService;
}(NetworkAnalystServiceBase_NetworkAnalystServiceBase);
SuperMap.FindClosestFacilitiesService = FindClosestFacilitiesService_FindClosestFacilitiesService;
// CONCATENATED MODULE: ./src/common/iServer/FindLocationParameters.js
function FindLocationParameters_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function FindLocationParameters_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function FindLocationParameters_createClass(Constructor, protoProps, staticProps) { if (protoProps) FindLocationParameters_defineProperties(Constructor.prototype, protoProps); if (staticProps) FindLocationParameters_defineProperties(Constructor, staticProps); return Constructor; }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/


/**
 * @class SuperMap.FindLocationParameters
 * @category iServer NetworkAnalyst Location
 * @classdesc 选址分区分析参数类。
 * @param {Object} options - 参数。 
 * @param {string} options.turnWeightField - 转向权值字段的名称。 
 * @param {string} options.weightName - 阻力字段的名称，标识了进行网络分析时所使用的阻力字段。
 * @param {Array.<SuperMap.SupplyCenter>} options.supplyCenters - 资源供给中心集合。 
 * @param {number} [options.expectedSupplyCenterCount=1] - 期望用于最终设施选址的资源供给中心数量。 
 * @param {boolean} [options.isFromCenter=false] - 是否从中心点开始分配资源。 
 */

var FindLocationParameters_FindLocationParameters =
/*#__PURE__*/
function () {
  function FindLocationParameters(options) {
    FindLocationParameters_classCallCheck(this, FindLocationParameters);

    /**
     * @member {number} [SuperMap.FindLocationParameters.prototype.expectedSupplyCenterCount=1]
     * @description 期望用于最终设施选址的资源供给中心数量。 
     *              当输入值为 0 时，最终设施选址的资源供给中心数量默认为覆盖分析区域内的所需最少的供给中心数。
     */
    this.expectedSupplyCenterCount = null;
    /**
     * @member {boolean} [SuperMap.FindLocationParameters.prototype.isFromCenter=false]
     * @description 是否从中心点开始分配资源。
     *              由于网路数据中的弧段具有正反阻力，即弧段的正向阻力值与其反向阻力值可能不同，
     *              因此，在进行分析时，从资源供给中心开始分配资源到需求点与从需求点向资源供给中心分配这两种分配形式下，所得的分析结果会不同。
     */

    this.isFromCenter = false;
    /**
     * @member {Array.<SuperMap.SupplyCenter>} SuperMap.FindLocationParameters.prototype.supplyCenters
     * @description 资源供给中心集合。
     *              资源供给中心是提供资源和服务的设施，对应于网络结点，
     *              资源供给中心的相关信息包括资源量、最大阻力值、资源供给中心类型，资源供给中心在网络中所处结点的 ID 等，以便在进行选址分区分析时使用。
     */

    this.supplyCenters = null;
    /**
     * @member {string} SuperMap.FindLocationParameters.prototype.turnWeightField
     * @description 转向权值字段的名称。
     */

    this.turnWeightField = null;
    /**
     * @member {string} SuperMap.FindLocationParameters.prototype.weightName
     * @description 阻力字段的名称，标识了进行网络分析时所使用的阻力字段。
     */

    this.weightName = null;
    Util.extend(this, options);
    this.CLASS_NAME = "SuperMap.FindLocationParameters";
  }
  /**
   * @function SuperMap.FindLocationParameters.prototype.destroy
   * @description 释放资源，将引用资源的属性置空。
   */


  FindLocationParameters_createClass(FindLocationParameters, [{
    key: "destroy",
    value: function destroy() {
      var me = this;
      me.expectedSupplyCenterCount = null;
      me.isFromCenter = null;
      me.turnWeightField = null;
      me.weightName = null;

      if (me.supplyCenters) {
        for (var i = 0, supplyCenters = me.supplyCenters, len = supplyCenters.length; i < len; i++) {
          supplyCenters[i].destroy();
        }

        me.supplyCenters = null;
      }
    }
  }]);

  return FindLocationParameters;
}();
SuperMap.FindLocationParameters = FindLocationParameters_FindLocationParameters;
// CONCATENATED MODULE: ./src/common/iServer/FindLocationService.js
function FindLocationService_typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { FindLocationService_typeof = function _typeof(obj) { return typeof obj; }; } else { FindLocationService_typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return FindLocationService_typeof(obj); }

function FindLocationService_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function FindLocationService_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function FindLocationService_createClass(Constructor, protoProps, staticProps) { if (protoProps) FindLocationService_defineProperties(Constructor.prototype, protoProps); if (staticProps) FindLocationService_defineProperties(Constructor, staticProps); return Constructor; }

function FindLocationService_possibleConstructorReturn(self, call) { if (call && (FindLocationService_typeof(call) === "object" || typeof call === "function")) { return call; } return FindLocationService_assertThisInitialized(self); }

function FindLocationService_assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function FindLocationService_get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { FindLocationService_get = Reflect.get; } else { FindLocationService_get = function _get(target, property, receiver) { var base = FindLocationService_superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return FindLocationService_get(target, property, receiver || target); }

function FindLocationService_superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = FindLocationService_getPrototypeOf(object); if (object === null) break; } return object; }

function FindLocationService_getPrototypeOf(o) { FindLocationService_getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return FindLocationService_getPrototypeOf(o); }

function FindLocationService_inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) FindLocationService_setPrototypeOf(subClass, superClass); }

function FindLocationService_setPrototypeOf(o, p) { FindLocationService_setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return FindLocationService_setPrototypeOf(o, p); }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/





/**
 * @class SuperMap.FindLocationService
 * @category iServer NetworkAnalyst Location
 * @classdesc 选址分区分析服务类。
 *            选址分区分析是为了确定一个或多个待建设施的最佳或最优位置，使得设施可以用一种最经济有效的方式为需求方提供服务或者商品。
 *            选址分区不仅仅是一个选址过程，还要将需求点的需求分配到相应的新建设施的服务区中，因此称之为选址与分区。
 *            选址分区分析结果通过该类支持的事件的监听函数参数获取
 * @extends {SuperMap.NetworkAnalystServiceBase}
 * @example
 * (start code)
 * var findLocationService = new SuperMap.FindLocationService(url, {
 *     eventListeners: {
 *         "processCompleted": findLocationCompleted,
 *		   "processFailed": findLocationError
 *		   }
 * });
 * (end)
 * @param {string} url - 服务的访问地址。
 *                       如 http://localhost:8090/iserver/services/transportationanalyst-sample/rest/networkanalyst/RoadNet@Changchun 。
 * @param {Object} options - 参数。
 * @param {Object} options.eventListeners - 需要被注册的监听器对象。
 * @param {boolean} [options.crossOrigin] - 是否允许跨域请求。
 * @param {Object} [options.headers] - 请求头。
 */

var FindLocationService_FindLocationService =
/*#__PURE__*/
function (_NetworkAnalystServic) {
  FindLocationService_inherits(FindLocationService, _NetworkAnalystServic);

  function FindLocationService(url, options) {
    var _this;

    FindLocationService_classCallCheck(this, FindLocationService);

    _this = FindLocationService_possibleConstructorReturn(this, FindLocationService_getPrototypeOf(FindLocationService).call(this, url, options));
    _this.CLASS_NAME = "SuperMap.FindLocationService";
    return _this;
  }
  /**
   * @function SuperMap.FindLocationService.prototype.destroy
   * @override
   */


  FindLocationService_createClass(FindLocationService, [{
    key: "destroy",
    value: function destroy() {
      FindLocationService_get(FindLocationService_getPrototypeOf(FindLocationService.prototype), "destroy", this).call(this);
    }
    /**
     * @function SuperMap.FindLocationService.prototype.processAsync
     * @description 负责将客户端的查询参数传递到服务端。
     * @param {SuperMap.FindLocationParameters} params - 选址分区分析服务参数类
     */

  }, {
    key: "processAsync",
    value: function processAsync(params) {
      if (!(params instanceof FindLocationParameters_FindLocationParameters)) {
        return;
      }

      var me = this,
          jsonObject,
          end = me.url.substr(me.url.length - 1, 1);
      me.url = me.url + (end === "/" ? "location" : "/location") + ".json?";
      jsonObject = {
        isFromCenter: params.isFromCenter,
        expectedSupplyCenterCount: params.expectedSupplyCenterCount,
        weightName: params.weightName,
        turnWeightField: params.turnWeightField,
        returnEdgeFeature: true,
        returnEdgeGeometry: true,
        returnNodeFeature: true,
        mapParameter: Util.toJSON(params.mapParameter),
        supplyCenters: me.getCentersJson(params.supplyCenters)
      };
      me.request({
        method: "GET",
        params: jsonObject,
        scope: me,
        success: me.serviceProcessCompleted,
        failure: me.serviceProcessFailed
      });
    }
    /**
     * @function SuperMap.FindLocationService.prototype.getCentersJson
     * @description 将数组对象转化为JSON字符串。
     * @param {Array} params - 需要转换的参数
     * @returns {string} 转化后的JSON字符串。
     */

  }, {
    key: "getCentersJson",
    value: function getCentersJson(params) {
      var json = "[",
          len = params ? params.length : 0;

      for (var i = 0; i < len; i++) {
        if (i > 0) {
          json += ",";
        }

        json += Util.toJSON(params[i]);
      }

      json += "]";
      return json;
    }
    /**
     * @function SuperMap.FindLocationService.prototype.toGeoJSONResult
     * @description 将含有 geometry 的数据转换为 GeoJSON 格式。
     * @param {Object} result - 服务器返回的结果对象。
     */

  }, {
    key: "toGeoJSONResult",
    value: function toGeoJSONResult(result) {
      if (!result) {
        return null;
      }

      var geoJSONFormat = new GeoJSON_GeoJSON();

      if (result.demandResults) {
        result.demandResults = geoJSONFormat.toGeoJSON(result.demandResults);
      }

      if (result.supplyResults) {
        result.supplyResults = geoJSONFormat.toGeoJSON(result.supplyResults);
      }

      return result;
    }
  }]);

  return FindLocationService;
}(NetworkAnalystServiceBase_NetworkAnalystServiceBase);
SuperMap.FindLocationService = FindLocationService_FindLocationService;
// CONCATENATED MODULE: ./src/common/iServer/FindMTSPPathsParameters.js
function FindMTSPPathsParameters_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function FindMTSPPathsParameters_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function FindMTSPPathsParameters_createClass(Constructor, protoProps, staticProps) { if (protoProps) FindMTSPPathsParameters_defineProperties(Constructor.prototype, protoProps); if (staticProps) FindMTSPPathsParameters_defineProperties(Constructor, staticProps); return Constructor; }

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/



/**
 * @class SuperMap.FindMTSPPathsParameters
 * @category iServer NetworkAnalyst MTSPPath
 * @classdesc 多旅行商分析参数类
 * @param {Object} options - 参数。 
 * @param {Array.<SuperMap.Geometry.Point|L.LatLng|L.Point|ol.geom.Point|number>} options.centers - 配送中心集合。 
 * @param {Array.<SuperMap.Geometry.Point|L.LatLng|L.Point|ol.geom.Point|number>} options.nodes - 配送目标集合。 
 * @param {boolean} [options.hasLeastTotalCost=false] - 配送模式是否为总花费最小方案。 
 * @param {boolean} [options.isAnalyzeById=false] - 是否通过节点 ID 号来指定配送中心点和配送目的点，即通过坐标点指定。 
 * @param {SuperMap.TransportationAnalystParameter} [options.parameter] - 交通网络分析通用参数。
 */

var FindMTSPPathsParameters_FindMTSPPathsParameters =
/*#__PURE__*/
function () {
  function FindMTSPPathsParameters(options) {
    FindMTSPPathsParameters_classCallCheck(this, FindMTSPPathsParameters);

    /**
     * @member SuperMap.FindMTSPPathsParameters.prototype.centers - {Array.<SuperMap.Geometry.Point|L.LatLng|L.Point|ol.geom.Point|number>}
     * @description 配送中心集合。
     *              当 SuperMap.FindMTSPPathsParameters.isAnalyzeById = false 时，centers 应为点的坐标数组；
     *              当 SuperMap.FindMTSPPathsParameters.isAnalyzeById = true 时，centers 应为点的 ID 数组。
     */
    this.centers = null;
    /**
     * @member {boolean} [SuperMap.FindMTSPPathsParameters.prototype.hasLeastTotalCost=false]
     * @description 配送模式是否为总花费最小方案。
     *              若为 true，则按照总花费最小的模式进行配送，此时可能会出现某几个配送中心点配送的花费较多而其他配送中心点的花费很少的情况。
     *              若为 false，则为局部最优，此方案会控制每个配送中心点的花费，使各个中心点花费相对平均，此时总花费不一定最小。
     */

    this.hasLeastTotalCost = false;
    /**
     * @member {boolean} [SuperMap.FindMTSPPathsParameters.prototype.isAnalyzeById=false] 
     * @description 是否通过节点 ID 号来指定配送中心点和配送目的点，即通过坐标点指定。
     */

    this.isAnalyzeById = false;
    /**
     * @member {Array.<SuperMap.Geometry.Point|L.LatLng|L.Point|ol.geom.Point|number>} SuperMap.FindMTSPPathsParameters.prototype.nodes  
     * @description 配送目标集合。
     *              当 SuperMap.FindMTSPPathsParameters.isAnalyzeById = false 时，nodes 应为点的坐标数组；
     *              当 SuperMap.FindMTSPPathsParameters.isAnalyzeById = true 时，nodes 应为点的 ID 数组。
     */

    this.nodes = null;
    /**
     * @member {SuperMap.TransportationAnalystParameter} [SuperMap.FindMTSPPathsParameters.prototype.parameter]
     * @description 交通网络分析通用参数。
     *              通过本类可以设置障碍边、障碍点、权值字段信息的名称标识、转向权值字段等信息。
     *              SuperMap.TransportationAnalystParameter 类型，它虽然为可选参数，但是如果不设置其中的 resultSetting 字段，则返回结果空间信息等都为空。
     */

    this.parameter = new TransportationAnalystParameter_TransportationAnalystParameter();
    Util.extend(this, options);
    this.CLASS_NAME = "SuperMap.FindMTSPPathsParameters";
  }
  /**
   * @function SuperMap.FindMTSPPathsParameters.prototype.destroy
   * @description 释放资源，将引用资源的属性置空。
   */


  FindMTSPPathsParameters_createClass(FindMTSPPathsParameters, [{
    key: "destroy",
    value: function destroy() {
      var me = this;
      me.centers = null;
      me.hasLeastTotalCost = null;
      me.isAnalyzeById = null;
      me.nodes = null;
      me.maxWeight = null;

      if (me.parameter) {
        me.parameter.destroy();
        me.parameter = null;
      }
    }
  }]);

  return FindMTSPPathsParameters;
}();
SuperMap.FindMTSPPathsParameters = FindMTSPPathsParameters_FindMTSPPathsParameters;
// CONCATENATED MODULE: ./src/common/iServer/FindMTSPPathsService.js
function FindMTSPPathsService_typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { FindMTSPPathsService_typeof = function _typeof(obj) { return typeof obj; }; } else { FindMTSPPathsService_typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return FindMTSPPathsService_typeof(obj); }

function FindMTSPPathsService_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function FindMTSPPathsService_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function FindMTSPPathsService_createClass(Constructor, protoProps, staticProps) { if (protoProps) FindMTSPPathsService_defineProperties(Constructor.prototype, protoProps); if (staticProps) FindMTSPPathsService_defineProperties(Constructor, staticProps); return Constructor; }

function FindMTSPPathsService_possibleConstructorReturn(self, call) { if (call && (FindMTSPPathsService_typeof(call) === "object" || typeof call === "function")) { return call; } return FindMTSPPathsService_assertThisInitialized(self); }

function FindMTSPPathsService_assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function FindMTSPPathsService_get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { FindMTSPPathsService_get = Reflect.get; } else { FindMTSPPathsService_get = function _get(target, property, receiver) { var base = FindMTSPPathsService_superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return FindMTSPPathsService_get(target, property, receiver || target); }

function FindMTSPPathsService_superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = FindMTSPPathsService_getPrototypeOf(object); if (object === null) break; } return object; }

function FindMTSPPathsService_getPrototypeOf(o) { FindMTSPPathsService_getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return FindMTSPPathsService_getPrototypeOf(o); }

function FindMTSPPathsService_inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expres