/*!
 * 
 *     @supermap/vue-iclient.(http://iclient.supermap.io)
 *     Copyright© 2000 - 2020 SuperMap Software Co.Ltd
 *     license: Apache-2.0
 *     version: v10.0.1
 *    
 */
(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory(require("./static/libs/iclient-leaflet/iclient-leaflet.min.js"), require("video.js"), require("echarts"), require("ant-design-vue"), require("vue-echarts"), require("echarts-liquidfill"), require("leaflet"), require("vue"));
	else if(typeof define === 'function' && define.amd)
		define(["./static/libs/iclient-leaflet/iclient-leaflet.min.js", "video.js", "echarts", "ant-design-vue", "vue-echarts", "echarts-liquidfill", "leaflet", "vue"], factory);
	else if(typeof exports === 'object')
		exports["Components"] = factory(require("./static/libs/iclient-leaflet/iclient-leaflet.min.js"), require("video.js"), require("echarts"), require("ant-design-vue"), require("vue-echarts"), require("echarts-liquidfill"), require("leaflet"), require("vue"));
	else
		root["SuperMap"] = root["SuperMap"] || {}, root["SuperMap"]["Components"] = factory(root["SuperMap"], root["_videojs"], root["echarts"], root["antd"], root["VueECharts"], root["echarts-liquidfill"], root["L"], root["Vue"]);
})(window, function(__WEBPACK_EXTERNAL_MODULE__17FK__, __WEBPACK_EXTERNAL_MODULE_AzSJ__, __WEBPACK_EXTERNAL_MODULE_Fk5u__, __WEBPACK_EXTERNAL_MODULE_TnLG__, __WEBPACK_EXTERNAL_MODULE_Zni2__, __WEBPACK_EXTERNAL_MODULE_hQXD__, __WEBPACK_EXTERNAL_MODULE_hgx0__, __WEBPACK_EXTERNAL_MODULE_i7_w__) {
return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "/";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 0);
/******/ })
/************************************************************************/
/******/ ({

/***/ "+Db8":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__("TqRt");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports._getValueOfEpsgCode = _getValueOfEpsgCode;
exports.vertifyEpsgCode = vertifyEpsgCode;
exports.transformFeatures = transformFeatures;
exports.getServerEpsgCode = getServerEpsgCode;
exports.checkAndRectifyFeatures = checkAndRectifyFeatures;
exports.default = void 0;

var _classCallCheck2 = _interopRequireDefault(__webpack_require__("lwsE"));

var _createClass2 = _interopRequireDefault(__webpack_require__("W8MJ"));

var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__("a1gu"));

var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__("Nsbk"));

var _inherits2 = _interopRequireDefault(__webpack_require__("7W2i"));

var _regenerator = _interopRequireDefault(__webpack_require__("o0o1"));

var _Events2 = __webpack_require__("peoL");

var _epsg = _interopRequireDefault(__webpack_require__("hzAs"));

var _proj = _interopRequireDefault(__webpack_require__("p5/s"));

var _util = __webpack_require__("e7LN");

var _statistics = __webpack_require__("EtYe");

var _lodash = _interopRequireDefault(__webpack_require__("zT9C"));

function _getValueOfEpsgCode(epsgCode) {
  var defName = "EPSG:".concat(epsgCode);
  var defValue = _epsg.default[defName];

  if (!defValue) {
    console.error("".concat(defName, " not define"));
  } else {
    _proj.default.defs(defName, defValue);
  }

  return {
    name: defName,
    value: defValue
  };
}

function _transformCoordinates(coordinates, projName) {
  if (coordinates[0] instanceof Array) {
    coordinates.forEach(function (item, index) {
      if (item instanceof Array) {
        coordinates[index] = _transformCoordinates(item, projName);
      }
    });
  } else if (coordinates.length > 0) {
    return projName !== 'EPSG:4326' ? (0, _proj.default)(projName, 'EPSG:4326', coordinates) : coordinates;
  }

  return coordinates;
}

function vertifyEpsgCode(firstFeature) {
  var epsgCode = 4326;
  var firstCoord = (firstFeature.geometry || {}).coordinates || [];

  if (firstCoord[0] instanceof Array) {
    if (firstCoord[0][0] instanceof Array) {
      // type: Polygon
      firstCoord = firstCoord[0][0];

      if (firstCoord[0] instanceof Array) {
        // type: MultiPolygon
        firstCoord = firstCoord[0];
      }
    } else {
      // type: LineString
      firstCoord = firstCoord[0];
    }
  } // 以防经纬度交换，判断错误的问题，都改成180


  var acceptRange = firstCoord[0] > -180 && firstCoord[0] < 180 && firstCoord[1] > -180 && firstCoord[1] < 180;

  if (!acceptRange) {
    epsgCode = 3857;
  }

  return epsgCode;
}

function transformFeatures(epsgCode, features) {
  var projName = _getValueOfEpsgCode(epsgCode).name;

  var transformedFeatures = features.map(function (feature) {
    var coordinates = feature.geometry.coordinates;
    feature.geometry.coordinates = _transformCoordinates(coordinates, projName);
    return feature;
  });
  return transformedFeatures;
} // 获取iServer restdata restmap 的 epsgcode


function getServerEpsgCode(projectionUrl, options) {
  if (!projectionUrl) {
    return;
  }

  return SuperMap.FetchRequest.get(projectionUrl, null, options).then(function (response) {
    return response.json();
  }).then(function (results) {
    var epsgCode = results.epsgCode;

    if (results.datasetInfo) {
      var prjCoordSys = results.datasetInfo.prjCoordSys;
      epsgCode = prjCoordSys ? prjCoordSys.epsgCode : null;
    }

    return epsgCode;
  }).catch(function (error) {
    console.log(error);
  });
} // 关系型存储发布成服务后坐标一定是4326，但真实数据可能不是4326，判断一下暂时按照3857处理


function checkAndRectifyFeatures(_ref) {
  var features, epsgCode, projectionUrl, options, currentEpsgCode, copyFeatures, epsgValue, vertifyCode;
  return _regenerator.default.async(function checkAndRectifyFeatures$(_context) {
    while (1) {
      switch (_context.prev = _context.next) {
        case 0:
          features = _ref.features, epsgCode = _ref.epsgCode, projectionUrl = _ref.projectionUrl, options = _ref.options;
          currentEpsgCode = epsgCode;
          copyFeatures = features;

          if (epsgCode) {
            _context.next = 7;
            break;
          }

          _context.next = 6;
          return _regenerator.default.awrap(getServerEpsgCode(projectionUrl, options));

        case 6:
          currentEpsgCode = _context.sent;

        case 7:
          epsgValue = _epsg.default["EPSG: ".concat(currentEpsgCode)];

          if (epsgValue === void 0) {
            currentEpsgCode = 4326;
          }

          if (currentEpsgCode && features && !!features.length) {
            if (currentEpsgCode === 4326) {
              vertifyCode = vertifyEpsgCode(features[0]);
              currentEpsgCode = vertifyCode;
            }

            copyFeatures = transformFeatures(currentEpsgCode, (0, _lodash.default)(features));
          }

          return _context.abrupt("return", copyFeatures);

        case 11:
        case "end":
          return _context.stop();
      }
    }
  });
}
/**
 * @class iServerRestService
 * @classdesc iServer 数据请求类。
 * @category  BaseTypes Util
 * @param {string} url - iServer 数据服务或地图服务地址。
 * @fires iServerRestService#getdatasucceeded
 * @fires iServerRestService#getdatafailed
 * @fires iServerRestService#featureisempty
 */


var iServerRestService =
/*#__PURE__*/
function (_Events) {
  (0, _inherits2.default)(iServerRestService, _Events);

  function iServerRestService(url, options) {
    var _this;

    (0, _classCallCheck2.default)(this, iServerRestService);
    _this = (0, _possibleConstructorReturn2.default)(this, (0, _getPrototypeOf2.default)(iServerRestService).call(this));
    _this.url = url;
    _this.options = options || {};
    _this.eventTypes = ['getdatasucceeded', 'getdatafailed', 'featureisempty'];
    return _this;
  }

  (0, _createClass2.default)(iServerRestService, [{
    key: "getData",
    value: function getData(datasetInfo, queryInfo) {
      if (!this._checkUrl(this.url)) {
        return null;
      }

      this._getDatasetInfoSucceed(datasetInfo, queryInfo);
    }
    /**
     * @function iServerRestService.prototype.getData
     * @description 请求数据。
     * @param {Object} queryInfo - 可选参数。
     * @param {Object} [queryInfo.maxFeatures] - 最多可返回的要素数量。
     * @param {Object} [queryInfo.attributeFilter] - 属性过滤条件。
     * @param {Object} [queryInfo.keyWord] - 筛选关键字。
     */

  }, {
    key: "_getDatasetInfoSucceed",
    value: function _getDatasetInfoSucceed(datasetInfo, queryInfo) {
      datasetInfo.dataUrl = this.url; // 判断服务为地图服务 或者 数据服务

      this.url.indexOf('/rest/maps') > -1 && this.getMapFeatures(datasetInfo, queryInfo);
      this.url.indexOf('/rest/data') > -1 && this.getDataFeatures(datasetInfo, queryInfo);
    }
    /**
     * @function iServerRestService.prototype.getMapFeatures
     * @description 请求地图服务数据。
     * @param {Object} datasetInfo - 数据集参数。
     * @param {Object} datasetInfo.dataUrl - 地图服务地址。
     * @param {Object} datasetInfo.mapName - 图层名。
     * @param {Object} queryInfo - 可选参数。
     * @param {Object} [queryInfo.maxFeatures] - 最多可返回的要素数量。
     * @param {Object} [queryInfo.attributeFilter] - 属性过滤条件。
     * @param {Object} [queryInfo.keyWord] - 筛选关键字。
     */

  }, {
    key: "getMapFeatures",
    value: function getMapFeatures(datasetInfo, queryInfo) {
      var _this2 = this;

      var dataUrl = datasetInfo.dataUrl,
          mapName = datasetInfo.mapName;
      queryInfo.name = mapName;
      this.projectionUrl = "".concat(dataUrl, "/prjCoordSys");

      if (queryInfo.keyWord) {
        this._getRestMapFields(dataUrl, mapName, function (fields) {
          queryInfo.attributeFilter = _this2._getAttributeFilterByKeywords(fields, queryInfo.keyWord);

          _this2._getMapFeatureBySql(dataUrl, queryInfo);
        });
      } else {
        this._getMapFeatureBySql(dataUrl, queryInfo);
      }
    }
    /**
     * @function iServerRestService.prototype.getDataFeatures
     * @description 请求数据服务数据。
     * @param {Object} datasetInfo - 数据集参数。
     * @param {Object} datasetInfo.datasetName - 数据集名。
     * @param {Object} datasetInfo.dataSourceName - 数据源名。
     * @param {Object} datasetInfo.dataUrl - 数据服务地址。
     * @param {Object} queryInfo - 可选参数。
     * @param {Object} [queryInfo.maxFeatures] - 最多可返回的要素数量。
     * @param {Object} [queryInfo.attributeFilter] - 属性过滤条件。
     * @param {Object} [queryInfo.keyWord] - 筛选关键字。
     */

  }, {
    key: "getDataFeatures",
    value: function getDataFeatures(datasetInfo, queryInfo) {
      var _this3 = this;

      var datasetName = datasetInfo.datasetName,
          dataSourceName = datasetInfo.dataSourceName,
          dataUrl = datasetInfo.dataUrl;
      queryInfo.name = datasetName + '@' + dataSourceName;
      queryInfo.datasetNames = [dataSourceName + ':' + datasetName];
      this.projectionUrl = "".concat(dataUrl, "/datasources/").concat(dataSourceName, "/datasets/").concat(datasetName);

      if (queryInfo.keyWord) {
        var fieldsUrl = dataUrl + "/datasources/".concat(dataSourceName, "/datasets/").concat(datasetName, "/fields.rjson?returnAll=true");

        this._getRestDataFields(fieldsUrl, function (fields) {
          queryInfo.attributeFilter = _this3._getAttributeFilterByKeywords(fields, queryInfo.keyWord);

          _this3._getDataFeaturesBySql(dataUrl, queryInfo);
        });
      } else {
        this._getDataFeaturesBySql(dataUrl, queryInfo);
      }
    }
  }, {
    key: "_getMapFeatureBySql",
    value: function _getMapFeatureBySql(url, queryInfo) {
      var _this4 = this;

      var queryBySQLParams, queryBySQLService;
      queryBySQLParams = new SuperMap.QueryBySQLParameters({
        queryParams: [{
          name: queryInfo.name,
          attributeFilter: queryInfo.attributeFilter
        }],
        expectCount: queryInfo.maxFeatures
      });
      queryBySQLService = new SuperMap.QueryBySQLService(url, {
        proxy: this.options.proxy,
        eventListeners: {
          processCompleted: this._getFeaturesSucceed.bind(this),
          processFailed: function processFailed(serviceResult) {
            console.error(serviceResult.error);

            _this4.fetchFailed(serviceResult.error);
          }
        }
      });
      queryBySQLService.processAsync(queryBySQLParams);
    }
  }, {
    key: "_getDataFeaturesBySql",
    value: function _getDataFeaturesBySql(url, queryInfo) {
      var getFeatureBySQLParams, getFeatureBySQLService;
      getFeatureBySQLParams = new SuperMap.GetFeaturesBySQLParameters({
        queryParameter: {
          name: queryInfo.name,
          attributeFilter: queryInfo.attributeFilter
        },
        datasetNames: queryInfo.datasetNames,
        fromIndex: 0,
        toIndex: queryInfo.maxFeatures >= 1000 ? -1 : queryInfo.maxFeatures - 1,
        maxFeatures: -1
      });
      getFeatureBySQLService = new SuperMap.GetFeaturesBySQLService(url, {
        proxy: this.options.proxy,
        eventListeners: {
          processCompleted: this._getFeaturesSucceed.bind(this),
          processFailed: function processFailed() {}
        }
      });
      getFeatureBySQLService.processAsync(getFeatureBySQLParams);
    }
  }, {
    key: "_getFeaturesSucceed",
    value: function _getFeaturesSucceed(results) {
      var features, data, recordsets;
      return _regenerator.default.async(function _getFeaturesSucceed$(_context2) {
        while (1) {
          switch (_context2.prev = _context2.next) {
            case 0:
              if (!(results.result && results.result.recordsets)) {
                _context2.next = 12;
                break;
              }

              // 数据来自restmap
              recordsets = results.result.recordsets[0];
              this.features = recordsets.features;
              features = this.features.features;

              if (!(features && features.length > 0)) {
                _context2.next = 8;
                break;
              }

              data = (0, _statistics.statisticsFeatures)(features, recordsets.fields, recordsets.fieldCaptions, recordsets.fieldTypes);
              _context2.next = 10;
              break;

            case 8:
              /**
               * @event iServerRestService#featureisempty
               * @description 请求数据为空后触发。
               * @property {Object} e  - 事件对象。
               */
              this.triggerEvent('featureisempty', {
                results: results
              });
              return _context2.abrupt("return");

            case 10:
              _context2.next = 25;
              break;

            case 12:
              if (!results.result) {
                _context2.next = 23;
                break;
              }

              // 数据来自restdata---results.result.features
              this.features = results.result.features;
              features = this.features.features;

              if (!(features && features.length > 0)) {
                _context2.next = 19;
                break;
              }

              data = (0, _statistics.statisticsFeatures)(features);
              _context2.next = 21;
              break;

            case 19:
              this.triggerEvent('featureisempty', {
                results: results
              });
              return _context2.abrupt("return");

            case 21:
              _context2.next = 25;
              break;

            case 23:
              this.triggerEvent('getdatafailed', {
                results: results
              });
              return _context2.abrupt("return");

            case 25:
              _context2.next = 27;
              return _regenerator.default.awrap(checkAndRectifyFeatures({
                features: data.features,
                projectionUrl: this.projectionUrl,
                options: this.options
              }));

            case 27:
              data.features = _context2.sent;

              /**
               * @event iServerRestService#getdatasucceeded
               * @description 请求数据成功后触发。
               * @property {Object} e  - 事件对象。
               */
              this.triggerEvent('getdatasucceeded', data);

            case 29:
            case "end":
              return _context2.stop();
          }
        }
      }, null, this);
    }
  }, {
    key: "_getRestDataFields",
    value: function _getRestDataFields(fieldsUrl, callBack) {
      var _this5 = this;

      SuperMap.FetchRequest.get(fieldsUrl, null, {
        proxy: this.options.proxy
      }).then(function (response) {
        return response.json();
      }).then(function (results) {
        var fields = _this5._getFiledsByType(['CHAR', 'TEXT', 'WTEXT'], results);

        callBack(fields, results);
      }).catch(function (error) {
        console.log(error);

        _this5.fetchFailed(error);
      });
    }
  }, {
    key: "_getRestMapFields",
    value: function _getRestMapFields(url, layerName, callBack) {
      var _this6 = this;

      var param = new SuperMap.QueryBySQLParameters({
        queryParams: [new SuperMap.FilterParameter({
          name: layerName,
          attributeFilter: 'SMID=0'
        })]
      });
      var queryBySQLSerice = new SuperMap.QueryBySQLService(url, {
        proxy: this.options.proxy,
        eventListeners: {
          processCompleted: function processCompleted(serviceResult) {
            var fields;

            if (serviceResult.result) {
              var result = serviceResult.result.recordsets[0];
              fields = _this6._getFiledsByType(['CHAR', 'TEXT', 'WTEXT'], result.fieldCaptions, result.fieldTypes);
            }

            fields && callBack(fields, serviceResult.result.recordsets[0]);
          },
          processFailed: function processFailed(serviceResult) {
            console.error(serviceResult.error);

            _this6.fetchFailed(serviceResult.error);
          }
        }
      });
      queryBySQLSerice.processAsync(param);
    }
  }, {
    key: "_getAttributeFilterByKeywords",
    value: function _getAttributeFilterByKeywords(fields, keyWord) {
      var attributeFilter = '';
      fields && fields.forEach(function (field, index) {
        attributeFilter += index !== fields.length - 1 ? "".concat(field, " LIKE '%").concat(keyWord, "%' ") + 'OR ' : "".concat(field, " LIKE '%").concat(keyWord, "%'");
      }, this);
      return attributeFilter;
    }
    /**
     * @function iServerRestService.prototype._checkUrl
     * @description 检查url是否符合要求
     * @private
     * @param {string} url
     */

  }, {
    key: "_checkUrl",
    value: function _checkUrl(url) {
      var match;

      if (url === '' || !(0, _util.isMatchUrl)(url)) {
        match = false;
      } else {
        match = true;
      } // else if (/^http[s]?:\/\/localhost/.test(url) || /^http[s]?:\/\/127.0.0.1/.test(url)) {
      //     //不是实际域名
      //     match = false;
      // }


      return match;
    } // types => []string

  }, {
    key: "_getFiledsByType",
    value: function _getFiledsByType(types, fields, fieldTypes) {
      var resultFileds = [];
      fields.forEach(function (field, index) {
        types.includes(fieldTypes && fieldTypes[index] || field.type) && resultFileds.push(fieldTypes ? field : field.name);
      });
      return resultFileds;
    }
  }, {
    key: "fetchFailed",
    value: function fetchFailed(error) {
      this.triggerEvent('getdatafailed', {
        error: error
      });
    }
  }]);
  return iServerRestService;
}(_Events2.Events);

exports.default = iServerRestService;

/***/ }),

/***/ "+qE3":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.



var R = typeof Reflect === 'object' ? Reflect : null
var ReflectApply = R && typeof R.apply === 'function'
  ? R.apply
  : function ReflectApply(target, receiver, args) {
    return Function.prototype.apply.call(target, receiver, args);
  }

var ReflectOwnKeys
if (R && typeof R.ownKeys === 'function') {
  ReflectOwnKeys = R.ownKeys
} else if (Object.getOwnPropertySymbols) {
  ReflectOwnKeys = function ReflectOwnKeys(target) {
    return Object.getOwnPropertyNames(target)
      .concat(Object.getOwnPropertySymbols(target));
  };
} else {
  ReflectOwnKeys = function ReflectOwnKeys(target) {
    return Object.getOwnPropertyNames(target);
  };
}

function ProcessEmitWarning(warning) {
  if (console && console.warn) console.warn(warning);
}

var NumberIsNaN = Number.isNaN || function NumberIsNaN(value) {
  return value !== value;
}

function EventEmitter() {
  EventEmitter.init.call(this);
}
module.exports = EventEmitter;

// Backwards-compat with node 0.10.x
EventEmitter.EventEmitter = EventEmitter;

EventEmitter.prototype._events = undefined;
EventEmitter.prototype._eventsCount = 0;
EventEmitter.prototype._maxListeners = undefined;

// By default EventEmitters will print a warning if more than 10 listeners are
// added to it. This is a useful default which helps finding memory leaks.
var defaultMaxListeners = 10;

Object.defineProperty(EventEmitter, 'defaultMaxListeners', {
  enumerable: true,
  get: function() {
    return defaultMaxListeners;
  },
  set: function(arg) {
    if (typeof arg !== 'number' || arg < 0 || NumberIsNaN(arg)) {
      throw new RangeError('The value of "defaultMaxListeners" is out of range. It must be a non-negative number. Received ' + arg + '.');
    }
    defaultMaxListeners = arg;
  }
});

EventEmitter.init = function() {

  if (this._events === undefined ||
      this._events === Object.getPrototypeOf(this)._events) {
    this._events = Object.create(null);
    this._eventsCount = 0;
  }

  this._maxListeners = this._maxListeners || undefined;
};

// Obviously not all Emitters should be limited to 10. This function allows
// that to be increased. Set to zero for unlimited.
EventEmitter.prototype.setMaxListeners = function setMaxListeners(n) {
  if (typeof n !== 'number' || n < 0 || NumberIsNaN(n)) {
    throw new RangeError('The value of "n" is out of range. It must be a non-negative number. Received ' + n + '.');
  }
  this._maxListeners = n;
  return this;
};

function $getMaxListeners(that) {
  if (that._maxListeners === undefined)
    return EventEmitter.defaultMaxListeners;
  return that._maxListeners;
}

EventEmitter.prototype.getMaxListeners = function getMaxListeners() {
  return $getMaxListeners(this);
};

EventEmitter.prototype.emit = function emit(type) {
  var args = [];
  for (var i = 1; i < arguments.length; i++) args.push(arguments[i]);
  var doError = (type === 'error');

  var events = this._events;
  if (events !== undefined)
    doError = (doError && events.error === undefined);
  else if (!doError)
    return false;

  // If there is no 'error' event listener then throw.
  if (doError) {
    var er;
    if (args.length > 0)
      er = args[0];
    if (er instanceof Error) {
      // Note: The comments on the `throw` lines are intentional, they show
      // up in Node's output if this results in an unhandled exception.
      throw er; // Unhandled 'error' event
    }
    // At least give some kind of context to the user
    var err = new Error('Unhandled error.' + (er ? ' (' + er.message + ')' : ''));
    err.context = er;
    throw err; // Unhandled 'error' event
  }

  var handler = events[type];

  if (handler === undefined)
    return false;

  if (typeof handler === 'function') {
    ReflectApply(handler, this, args);
  } else {
    var len = handler.length;
    var listeners = arrayClone(handler, len);
    for (var i = 0; i < len; ++i)
      ReflectApply(listeners[i], this, args);
  }

  return true;
};

function _addListener(target, type, listener, prepend) {
  var m;
  var events;
  var existing;

  if (typeof listener !== 'function') {
    throw new TypeError('The "listener" argument must be of type Function. Received type ' + typeof listener);
  }

  events = target._events;
  if (events === undefined) {
    events = target._events = Object.create(null);
    target._eventsCount = 0;
  } else {
    // To avoid recursion in the case that type === "newListener"! Before
    // adding it to the listeners, first emit "newListener".
    if (events.newListener !== undefined) {
      target.emit('newListener', type,
                  listener.listener ? listener.listener : listener);

      // Re-assign `events` because a newListener handler could have caused the
      // this._events to be assigned to a new object
      events = target._events;
    }
    existing = events[type];
  }

  if (existing === undefined) {
    // Optimize the case of one listener. Don't need the extra array object.
    existing = events[type] = listener;
    ++target._eventsCount;
  } else {
    if (typeof existing === 'function') {
      // Adding the second element, need to change to array.
      existing = events[type] =
        prepend ? [listener, existing] : [existing, listener];
      // If we've already got an array, just append.
    } else if (prepend) {
      existing.unshift(listener);
    } else {
      existing.push(listener);
    }

    // Check for listener leak
    m = $getMaxListeners(target);
    if (m > 0 && existing.length > m && !existing.warned) {
      existing.warned = true;
      // No error code for this since it is a Warning
      // eslint-disable-next-line no-restricted-syntax
      var w = new Error('Possible EventEmitter memory leak detected. ' +
                          existing.length + ' ' + String(type) + ' listeners ' +
                          'added. Use emitter.setMaxListeners() to ' +
                          'increase limit');
      w.name = 'MaxListenersExceededWarning';
      w.emitter = target;
      w.type = type;
      w.count = existing.length;
      ProcessEmitWarning(w);
    }
  }

  return target;
}

EventEmitter.prototype.addListener = function addListener(type, listener) {
  return _addListener(this, type, listener, false);
};

EventEmitter.prototype.on = EventEmitter.prototype.addListener;

EventEmitter.prototype.prependListener =
    function prependListener(type, listener) {
      return _addListener(this, type, listener, true);
    };

function onceWrapper() {
  var args = [];
  for (var i = 0; i < arguments.length; i++) args.push(arguments[i]);
  if (!this.fired) {
    this.target.removeListener(this.type, this.wrapFn);
    this.fired = true;
    ReflectApply(this.listener, this.target, args);
  }
}

function _onceWrap(target, type, listener) {
  var state = { fired: false, wrapFn: undefined, target: target, type: type, listener: listener };
  var wrapped = onceWrapper.bind(state);
  wrapped.listener = listener;
  state.wrapFn = wrapped;
  return wrapped;
}

EventEmitter.prototype.once = function once(type, listener) {
  if (typeof listener !== 'function') {
    throw new TypeError('The "listener" argument must be of type Function. Received type ' + typeof listener);
  }
  this.on(type, _onceWrap(this, type, listener));
  return this;
};

EventEmitter.prototype.prependOnceListener =
    function prependOnceListener(type, listener) {
      if (typeof listener !== 'function') {
        throw new TypeError('The "listener" argument must be of type Function. Received type ' + typeof listener);
      }
      this.prependListener(type, _onceWrap(this, type, listener));
      return this;
    };

// Emits a 'removeListener' event if and only if the listener was removed.
EventEmitter.prototype.removeListener =
    function removeListener(type, listener) {
      var list, events, position, i, originalListener;

      if (typeof listener !== 'function') {
        throw new TypeError('The "listener" argument must be of type Function. Received type ' + typeof listener);
      }

      events = this._events;
      if (events === undefined)
        return this;

      list = events[type];
      if (list === undefined)
        return this;

      if (list === listener || list.listener === listener) {
        if (--this._eventsCount === 0)
          this._events = Object.create(null);
        else {
          delete events[type];
          if (events.removeListener)
            this.emit('removeListener', type, list.listener || listener);
        }
      } else if (typeof list !== 'function') {
        position = -1;

        for (i = list.length - 1; i >= 0; i--) {
          if (list[i] === listener || list[i].listener === listener) {
            originalListener = list[i].listener;
            position = i;
            break;
          }
        }

        if (position < 0)
          return this;

        if (position === 0)
          list.shift();
        else {
          spliceOne(list, position);
        }

        if (list.length === 1)
          events[type] = list[0];

        if (events.removeListener !== undefined)
          this.emit('removeListener', type, originalListener || listener);
      }

      return this;
    };

EventEmitter.prototype.off = EventEmitter.prototype.removeListener;

EventEmitter.prototype.removeAllListeners =
    function removeAllListeners(type) {
      var listeners, events, i;

      events = this._events;
      if (events === undefined)
        return this;

      // not listening for removeListener, no need to emit
      if (events.removeListener === undefined) {
        if (arguments.length === 0) {
          this._events = Object.create(null);
          this._eventsCount = 0;
        } else if (events[type] !== undefined) {
          if (--this._eventsCount === 0)
            this._events = Object.create(null);
          else
            delete events[type];
        }
        return this;
      }

      // emit removeListener for all listeners on all events
      if (arguments.length === 0) {
        var keys = Object.keys(events);
        var key;
        for (i = 0; i < keys.length; ++i) {
          key = keys[i];
          if (key === 'removeListener') continue;
          this.removeAllListeners(key);
        }
        this.removeAllListeners('removeListener');
        this._events = Object.create(null);
        this._eventsCount = 0;
        return this;
      }

      listeners = events[type];

      if (typeof listeners === 'function') {
        this.removeListener(type, listeners);
      } else if (listeners !== undefined) {
        // LIFO order
        for (i = listeners.length - 1; i >= 0; i--) {
          this.removeListener(type, listeners[i]);
        }
      }

      return this;
    };

function _listeners(target, type, unwrap) {
  var events = target._events;

  if (events === undefined)
    return [];

  var evlistener = events[type];
  if (evlistener === undefined)
    return [];

  if (typeof evlistener === 'function')
    return unwrap ? [evlistener.listener || evlistener] : [evlistener];

  return unwrap ?
    unwrapListeners(evlistener) : arrayClone(evlistener, evlistener.length);
}

EventEmitter.prototype.listeners = function listeners(type) {
  return _listeners(this, type, true);
};

EventEmitter.prototype.rawListeners = function rawListeners(type) {
  return _listeners(this, type, false);
};

EventEmitter.listenerCount = function(emitter, type) {
  if (typeof emitter.listenerCount === 'function') {
    return emitter.listenerCount(type);
  } else {
    return listenerCount.call(emitter, type);
  }
};

EventEmitter.prototype.listenerCount = listenerCount;
function listenerCount(type) {
  var events = this._events;

  if (events !== undefined) {
    var evlistener = events[type];

    if (typeof evlistener === 'function') {
      return 1;
    } else if (evlistener !== undefined) {
      return evlistener.length;
    }
  }

  return 0;
}

EventEmitter.prototype.eventNames = function eventNames() {
  return this._eventsCount > 0 ? ReflectOwnKeys(this._events) : [];
};

function arrayClone(arr, n) {
  var copy = new Array(n);
  for (var i = 0; i < n; ++i)
    copy[i] = arr[i];
  return copy;
}

function spliceOne(list, index) {
  for (; index + 1 < list.length; index++)
    list[index] = list[index + 1];
  list.pop();
}

function unwrapListeners(arr) {
  var ret = new Array(arr.length);
  for (var i = 0; i < ret.length; ++i) {
    ret[i] = arr[i].listener || arr[i];
  }
  return ret;
}


/***/ }),

/***/ "/9aa":
/***/ (function(module, exports, __webpack_require__) {

var baseGetTag = __webpack_require__("NykK"),
    isObjectLike = __webpack_require__("ExA7");

/** `Object#toString` result references. */
var symbolTag = '[object Symbol]';

/**
 * Checks if `value` is classified as a `Symbol` primitive or object.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a symbol, else `false`.
 * @example
 *
 * _.isSymbol(Symbol.iterator);
 * // => true
 *
 * _.isSymbol('abc');
 * // => false
 */
function isSymbol(value) {
  return typeof value == 'symbol' ||
    (isObjectLike(value) && baseGetTag(value) == symbolTag);
}

module.exports = isSymbol;


/***/ }),

/***/ "/aIJ":
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ "/rf6":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
/**
 * @module helpers
 */
/**
 * Earth Radius used with the Harvesine formula and approximates using a spherical (non-ellipsoid) Earth.
 *
 * @memberof helpers
 * @type {number}
 */
exports.earthRadius = 6371008.8;
/**
 * Unit of measurement factors using a spherical (non-ellipsoid) earth radius.
 *
 * @memberof helpers
 * @type {Object}
 */
exports.factors = {
    centimeters: exports.earthRadius * 100,
    centimetres: exports.earthRadius * 100,
    degrees: exports.earthRadius / 111325,
    feet: exports.earthRadius * 3.28084,
    inches: exports.earthRadius * 39.370,
    kilometers: exports.earthRadius / 1000,
    kilometres: exports.earthRadius / 1000,
    meters: exports.earthRadius,
    metres: exports.earthRadius,
    miles: exports.earthRadius / 1609.344,
    millimeters: exports.earthRadius * 1000,
    millimetres: exports.earthRadius * 1000,
    nauticalmiles: exports.earthRadius / 1852,
    radians: 1,
    yards: exports.earthRadius / 1.0936,
};
/**
 * Units of measurement factors based on 1 meter.
 *
 * @memberof helpers
 * @type {Object}
 */
exports.unitsFactors = {
    centimeters: 100,
    centimetres: 100,
    degrees: 1 / 111325,
    feet: 3.28084,
    inches: 39.370,
    kilometers: 1 / 1000,
    kilometres: 1 / 1000,
    meters: 1,
    metres: 1,
    miles: 1 / 1609.344,
    millimeters: 1000,
    millimetres: 1000,
    nauticalmiles: 1 / 1852,
    radians: 1 / exports.earthRadius,
    yards: 1 / 1.0936,
};
/**
 * Area of measurement factors based on 1 square meter.
 *
 * @memberof helpers
 * @type {Object}
 */
exports.areaFactors = {
    acres: 0.000247105,
    centimeters: 10000,
    centimetres: 10000,
    feet: 10.763910417,
    inches: 1550.003100006,
    kilometers: 0.000001,
    kilometres: 0.000001,
    meters: 1,
    metres: 1,
    miles: 3.86e-7,
    millimeters: 1000000,
    millimetres: 1000000,
    yards: 1.195990046,
};
/**
 * Wraps a GeoJSON {@link Geometry} in a GeoJSON {@link Feature}.
 *
 * @name feature
 * @param {Geometry} geometry input geometry
 * @param {Object} [properties={}] an Object of key-value pairs to add as properties
 * @param {Object} [options={}] Optional Parameters
 * @param {Array<number>} [options.bbox] Bounding Box Array [west, south, east, north] associated with the Feature
 * @param {string|number} [options.id] Identifier associated with the Feature
 * @returns {Feature} a GeoJSON Feature
 * @example
 * var geometry = {
 *   "type": "Point",
 *   "coordinates": [110, 50]
 * };
 *
 * var feature = turf.feature(geometry);
 *
 * //=feature
 */
function feature(geom, properties, options) {
    if (options === void 0) { options = {}; }
    var feat = { type: "Feature" };
    if (options.id === 0 || options.id) {
        feat.id = options.id;
    }
    if (options.bbox) {
        feat.bbox = options.bbox;
    }
    feat.properties = properties || {};
    feat.geometry = geom;
    return feat;
}
exports.feature = feature;
/**
 * Creates a GeoJSON {@link Geometry} from a Geometry string type & coordinates.
 * For GeometryCollection type use `helpers.geometryCollection`
 *
 * @name geometry
 * @param {string} type Geometry Type
 * @param {Array<any>} coordinates Coordinates
 * @param {Object} [options={}] Optional Parameters
 * @returns {Geometry} a GeoJSON Geometry
 * @example
 * var type = "Point";
 * var coordinates = [110, 50];
 * var geometry = turf.geometry(type, coordinates);
 * // => geometry
 */
function geometry(type, coordinates, options) {
    if (options === void 0) { options = {}; }
    switch (type) {
        case "Point": return point(coordinates).geometry;
        case "LineString": return lineString(coordinates).geometry;
        case "Polygon": return polygon(coordinates).geometry;
        case "MultiPoint": return multiPoint(coordinates).geometry;
        case "MultiLineString": return multiLineString(coordinates).geometry;
        case "MultiPolygon": return multiPolygon(coordinates).geometry;
        default: throw new Error(type + " is invalid");
    }
}
exports.geometry = geometry;
/**
 * Creates a {@link Point} {@link Feature} from a Position.
 *
 * @name point
 * @param {Array<number>} coordinates longitude, latitude position (each in decimal degrees)
 * @param {Object} [properties={}] an Object of key-value pairs to add as properties
 * @param {Object} [options={}] Optional Parameters
 * @param {Array<number>} [options.bbox] Bounding Box Array [west, south, east, north] associated with the Feature
 * @param {string|number} [options.id] Identifier associated with the Feature
 * @returns {Feature<Point>} a Point feature
 * @example
 * var point = turf.point([-75.343, 39.984]);
 *
 * //=point
 */
function point(coordinates, properties, options) {
    if (options === void 0) { options = {}; }
    var geom = {
        type: "Point",
        coordinates: coordinates,
    };
    return feature(geom, properties, options);
}
exports.point = point;
/**
 * Creates a {@link Point} {@link FeatureCollection} from an Array of Point coordinates.
 *
 * @name points
 * @param {Array<Array<number>>} coordinates an array of Points
 * @param {Object} [properties={}] Translate these properties to each Feature
 * @param {Object} [options={}] Optional Parameters
 * @param {Array<number>} [options.bbox] Bounding Box Array [west, south, east, north]
 * associated with the FeatureCollection
 * @param {string|number} [options.id] Identifier associated with the FeatureCollection
 * @returns {FeatureCollection<Point>} Point Feature
 * @example
 * var points = turf.points([
 *   [-75, 39],
 *   [-80, 45],
 *   [-78, 50]
 * ]);
 *
 * //=points
 */
function points(coordinates, properties, options) {
    if (options === void 0) { options = {}; }
    return featureCollection(coordinates.map(function (coords) {
        return point(coords, properties);
    }), options);
}
exports.points = points;
/**
 * Creates a {@link Polygon} {@link Feature} from an Array of LinearRings.
 *
 * @name polygon
 * @param {Array<Array<Array<number>>>} coordinates an array of LinearRings
 * @param {Object} [properties={}] an Object of key-value pairs to add as properties
 * @param {Object} [options={}] Optional Parameters
 * @param {Array<number>} [options.bbox] Bounding Box Array [west, south, east, north] associated with the Feature
 * @param {string|number} [options.id] Identifier associated with the Feature
 * @returns {Feature<Polygon>} Polygon Feature
 * @example
 * var polygon = turf.polygon([[[-5, 52], [-4, 56], [-2, 51], [-7, 54], [-5, 52]]], { name: 'poly1' });
 *
 * //=polygon
 */
function polygon(coordinates, properties, options) {
    if (options === void 0) { options = {}; }
    for (var _i = 0, coordinates_1 = coordinates; _i < coordinates_1.length; _i++) {
        var ring = coordinates_1[_i];
        if (ring.length < 4) {
            throw new Error("Each LinearRing of a Polygon must have 4 or more Positions.");
        }
        for (var j = 0; j < ring[ring.length - 1].length; j++) {
            // Check if first point of Polygon contains two numbers
            if (ring[ring.length - 1][j] !== ring[0][j]) {
                throw new Error("First and last Position are not equivalent.");
            }
        }
    }
    var geom = {
        type: "Polygon",
        coordinates: coordinates,
    };
    return feature(geom, properties, options);
}
exports.polygon = polygon;
/**
 * Creates a {@link Polygon} {@link FeatureCollection} from an Array of Polygon coordinates.
 *
 * @name polygons
 * @param {Array<Array<Array<Array<number>>>>} coordinates an array of Polygon coordinates
 * @param {Object} [properties={}] an Object of key-value pairs to add as properties
 * @param {Object} [options={}] Optional Parameters
 * @param {Array<number>} [options.bbox] Bounding Box Array [west, south, east, north] associated with the Feature
 * @param {string|number} [options.id] Identifier associated with the FeatureCollection
 * @returns {FeatureCollection<Polygon>} Polygon FeatureCollection
 * @example
 * var polygons = turf.polygons([
 *   [[[-5, 52], [-4, 56], [-2, 51], [-7, 54], [-5, 52]]],
 *   [[[-15, 42], [-14, 46], [-12, 41], [-17, 44], [-15, 42]]],
 * ]);
 *
 * //=polygons
 */
function polygons(coordinates, properties, options) {
    if (options === void 0) { options = {}; }
    return featureCollection(coordinates.map(function (coords) {
        return polygon(coords, properties);
    }), options);
}
exports.polygons = polygons;
/**
 * Creates a {@link LineString} {@link Feature} from an Array of Positions.
 *
 * @name lineString
 * @param {Array<Array<number>>} coordinates an array of Positions
 * @param {Object} [properties={}] an Object of key-value pairs to add as properties
 * @param {Object} [options={}] Optional Parameters
 * @param {Array<number>} [options.bbox] Bounding Box Array [west, south, east, north] associated with the Feature
 * @param {string|number} [options.id] Identifier associated with the Feature
 * @returns {Feature<LineString>} LineString Feature
 * @example
 * var linestring1 = turf.lineString([[-24, 63], [-23, 60], [-25, 65], [-20, 69]], {name: 'line 1'});
 * var linestring2 = turf.lineString([[-14, 43], [-13, 40], [-15, 45], [-10, 49]], {name: 'line 2'});
 *
 * //=linestring1
 * //=linestring2
 */
function lineString(coordinates, properties, options) {
    if (options === void 0) { options = {}; }
    if (coordinates.length < 2) {
        throw new Error("coordinates must be an array of two or more positions");
    }
    var geom = {
        type: "LineString",
        coordinates: coordinates,
    };
    return feature(geom, properties, options);
}
exports.lineString = lineString;
/**
 * Creates a {@link LineString} {@link FeatureCollection} from an Array of LineString coordinates.
 *
 * @name lineStrings
 * @param {Array<Array<Array<number>>>} coordinates an array of LinearRings
 * @param {Object} [properties={}] an Object of key-value pairs to add as properties
 * @param {Object} [options={}] Optional Parameters
 * @param {Array<number>} [options.bbox] Bounding Box Array [west, south, east, north]
 * associated with the FeatureCollection
 * @param {string|number} [options.id] Identifier associated with the FeatureCollection
 * @returns {FeatureCollection<LineString>} LineString FeatureCollection
 * @example
 * var linestrings = turf.lineStrings([
 *   [[-24, 63], [-23, 60], [-25, 65], [-20, 69]],
 *   [[-14, 43], [-13, 40], [-15, 45], [-10, 49]]
 * ]);
 *
 * //=linestrings
 */
function lineStrings(coordinates, properties, options) {
    if (options === void 0) { options = {}; }
    return featureCollection(coordinates.map(function (coords) {
        return lineString(coords, properties);
    }), options);
}
exports.lineStrings = lineStrings;
/**
 * Takes one or more {@link Feature|Features} and creates a {@link FeatureCollection}.
 *
 * @name featureCollection
 * @param {Feature[]} features input features
 * @param {Object} [options={}] Optional Parameters
 * @param {Array<number>} [options.bbox] Bounding Box Array [west, south, east, north] associated with the Feature
 * @param {string|number} [options.id] Identifier associated with the Feature
 * @returns {FeatureCollection} FeatureCollection of Features
 * @example
 * var locationA = turf.point([-75.343, 39.984], {name: 'Location A'});
 * var locationB = turf.point([-75.833, 39.284], {name: 'Location B'});
 * var locationC = turf.point([-75.534, 39.123], {name: 'Location C'});
 *
 * var collection = turf.featureCollection([
 *   locationA,
 *   locationB,
 *   locationC
 * ]);
 *
 * //=collection
 */
function featureCollection(features, options) {
    if (options === void 0) { options = {}; }
    var fc = { type: "FeatureCollection" };
    if (options.id) {
        fc.id = options.id;
    }
    if (options.bbox) {
        fc.bbox = options.bbox;
    }
    fc.features = features;
    return fc;
}
exports.featureCollection = featureCollection;
/**
 * Creates a {@link Feature<MultiLineString>} based on a
 * coordinate array. Properties can be added optionally.
 *
 * @name multiLineString
 * @param {Array<Array<Array<number>>>} coordinates an array of LineStrings
 * @param {Object} [properties={}] an Object of key-value pairs to add as properties
 * @param {Object} [options={}] Optional Parameters
 * @param {Array<number>} [options.bbox] Bounding Box Array [west, south, east, north] associated with the Feature
 * @param {string|number} [options.id] Identifier associated with the Feature
 * @returns {Feature<MultiLineString>} a MultiLineString feature
 * @throws {Error} if no coordinates are passed
 * @example
 * var multiLine = turf.multiLineString([[[0,0],[10,10]]]);
 *
 * //=multiLine
 */
function multiLineString(coordinates, properties, options) {
    if (options === void 0) { options = {}; }
    var geom = {
        type: "MultiLineString",
        coordinates: coordinates,
    };
    return feature(geom, properties, options);
}
exports.multiLineString = multiLineString;
/**
 * Creates a {@link Feature<MultiPoint>} based on a
 * coordinate array. Properties can be added optionally.
 *
 * @name multiPoint
 * @param {Array<Array<number>>} coordinates an array of Positions
 * @param {Object} [properties={}] an Object of key-value pairs to add as properties
 * @param {Object} [options={}] Optional Parameters
 * @param {Array<number>} [options.bbox] Bounding Box Array [west, south, east, north] associated with the Feature
 * @param {string|number} [options.id] Identifier associated with the Feature
 * @returns {Feature<MultiPoint>} a MultiPoint feature
 * @throws {Error} if no coordinates are passed
 * @example
 * var multiPt = turf.multiPoint([[0,0],[10,10]]);
 *
 * //=multiPt
 */
function multiPoint(coordinates, properties, options) {
    if (options === void 0) { options = {}; }
    var geom = {
        type: "MultiPoint",
        coordinates: coordinates,
    };
    return feature(geom, properties, options);
}
exports.multiPoint = multiPoint;
/**
 * Creates a {@link Feature<MultiPolygon>} based on a
 * coordinate array. Properties can be added optionally.
 *
 * @name multiPolygon
 * @param {Array<Array<Array<Array<number>>>>} coordinates an array of Polygons
 * @param {Object} [properties={}] an Object of key-value pairs to add as properties
 * @param {Object} [options={}] Optional Parameters
 * @param {Array<number>} [options.bbox] Bounding Box Array [west, south, east, north] associated with the Feature
 * @param {string|number} [options.id] Identifier associated with the Feature
 * @returns {Feature<MultiPolygon>} a multipolygon feature
 * @throws {Error} if no coordinates are passed
 * @example
 * var multiPoly = turf.multiPolygon([[[[0,0],[0,10],[10,10],[10,0],[0,0]]]]);
 *
 * //=multiPoly
 *
 */
function multiPolygon(coordinates, properties, options) {
    if (options === void 0) { options = {}; }
    var geom = {
        type: "MultiPolygon",
        coordinates: coordinates,
    };
    return feature(geom, properties, options);
}
exports.multiPolygon = multiPolygon;
/**
 * Creates a {@link Feature<GeometryCollection>} based on a
 * coordinate array. Properties can be added optionally.
 *
 * @name geometryCollection
 * @param {Array<Geometry>} geometries an array of GeoJSON Geometries
 * @param {Object} [properties={}] an Object of key-value pairs to add as properties
 * @param {Object} [options={}] Optional Parameters
 * @param {Array<number>} [options.bbox] Bounding Box Array [west, south, east, north] associated with the Feature
 * @param {string|number} [options.id] Identifier associated with the Feature
 * @returns {Feature<GeometryCollection>} a GeoJSON GeometryCollection Feature
 * @example
 * var pt = turf.geometry("Point", [100, 0]);
 * var line = turf.geometry("LineString", [[101, 0], [102, 1]]);
 * var collection = turf.geometryCollection([pt, line]);
 *
 * // => collection
 */
function geometryCollection(geometries, properties, options) {
    if (options === void 0) { options = {}; }
    var geom = {
        type: "GeometryCollection",
        geometries: geometries,
    };
    return feature(geom, properties, options);
}
exports.geometryCollection = geometryCollection;
/**
 * Round number to precision
 *
 * @param {number} num Number
 * @param {number} [precision=0] Precision
 * @returns {number} rounded number
 * @example
 * turf.round(120.4321)
 * //=120
 *
 * turf.round(120.4321, 2)
 * //=120.43
 */
function round(num, precision) {
    if (precision === void 0) { precision = 0; }
    if (precision && !(precision >= 0)) {
        throw new Error("precision must be a positive number");
    }
    var multiplier = Math.pow(10, precision || 0);
    return Math.round(num * multiplier) / multiplier;
}
exports.round = round;
/**
 * Convert a distance measurement (assuming a spherical Earth) from radians to a more friendly unit.
 * Valid units: miles, nauticalmiles, inches, yards, meters, metres, kilometers, centimeters, feet
 *
 * @name radiansToLength
 * @param {number} radians in radians across the sphere
 * @param {string} [units="kilometers"] can be degrees, radians, miles, or kilometers inches, yards, metres,
 * meters, kilometres, kilometers.
 * @returns {number} distance
 */
function radiansToLength(radians, units) {
    if (units === void 0) { units = "kilometers"; }
    var factor = exports.factors[units];
    if (!factor) {
        throw new Error(units + " units is invalid");
    }
    return radians * factor;
}
exports.radiansToLength = radiansToLength;
/**
 * Convert a distance measurement (assuming a spherical Earth) from a real-world unit into radians
 * Valid units: miles, nauticalmiles, inches, yards, meters, metres, kilometers, centimeters, feet
 *
 * @name lengthToRadians
 * @param {number} distance in real units
 * @param {string} [units="kilometers"] can be degrees, radians, miles, or kilometers inches, yards, metres,
 * meters, kilometres, kilometers.
 * @returns {number} radians
 */
function lengthToRadians(distance, units) {
    if (units === void 0) { units = "kilometers"; }
    var factor = exports.factors[units];
    if (!factor) {
        throw new Error(units + " units is invalid");
    }
    return distance / factor;
}
exports.lengthToRadians = lengthToRadians;
/**
 * Convert a distance measurement (assuming a spherical Earth) from a real-world unit into degrees
 * Valid units: miles, nauticalmiles, inches, yards, meters, metres, centimeters, kilometres, feet
 *
 * @name lengthToDegrees
 * @param {number} distance in real units
 * @param {string} [units="kilometers"] can be degrees, radians, miles, or kilometers inches, yards, metres,
 * meters, kilometres, kilometers.
 * @returns {number} degrees
 */
function lengthToDegrees(distance, units) {
    return radiansToDegrees(lengthToRadians(distance, units));
}
exports.lengthToDegrees = lengthToDegrees;
/**
 * Converts any bearing angle from the north line direction (positive clockwise)
 * and returns an angle between 0-360 degrees (positive clockwise), 0 being the north line
 *
 * @name bearingToAzimuth
 * @param {number} bearing angle, between -180 and +180 degrees
 * @returns {number} angle between 0 and 360 degrees
 */
function bearingToAzimuth(bearing) {
    var angle = bearing % 360;
    if (angle < 0) {
        angle += 360;
    }
    return angle;
}
exports.bearingToAzimuth = bearingToAzimuth;
/**
 * Converts an angle in radians to degrees
 *
 * @name radiansToDegrees
 * @param {number} radians angle in radians
 * @returns {number} degrees between 0 and 360 degrees
 */
function radiansToDegrees(radians) {
    var degrees = radians % (2 * Math.PI);
    return degrees * 180 / Math.PI;
}
exports.radiansToDegrees = radiansToDegrees;
/**
 * Converts an angle in degrees to radians
 *
 * @name degreesToRadians
 * @param {number} degrees angle between 0 and 360 degrees
 * @returns {number} angle in radians
 */
function degreesToRadians(degrees) {
    var radians = degrees % 360;
    return radians * Math.PI / 180;
}
exports.degreesToRadians = degreesToRadians;
/**
 * Converts a length to the requested unit.
 * Valid units: miles, nauticalmiles, inches, yards, meters, metres, kilometers, centimeters, feet
 *
 * @param {number} length to be converted
 * @param {Units} [originalUnit="kilometers"] of the length
 * @param {Units} [finalUnit="kilometers"] returned unit
 * @returns {number} the converted length
 */
function convertLength(length, originalUnit, finalUnit) {
    if (originalUnit === void 0) { originalUnit = "kilometers"; }
    if (finalUnit === void 0) { finalUnit = "kilometers"; }
    if (!(length >= 0)) {
        throw new Error("length must be a positive number");
    }
    return radiansToLength(lengthToRadians(length, originalUnit), finalUnit);
}
exports.convertLength = convertLength;
/**
 * Converts a area to the requested unit.
 * Valid units: kilometers, kilometres, meters, metres, centimetres, millimeters, acres, miles, yards, feet, inches
 * @param {number} area to be converted
 * @param {Units} [originalUnit="meters"] of the distance
 * @param {Units} [finalUnit="kilometers"] returned unit
 * @returns {number} the converted distance
 */
function convertArea(area, originalUnit, finalUnit) {
    if (originalUnit === void 0) { originalUnit = "meters"; }
    if (finalUnit === void 0) { finalUnit = "kilometers"; }
    if (!(area >= 0)) {
        throw new Error("area must be a positive number");
    }
    var startFactor = exports.areaFactors[originalUnit];
    if (!startFactor) {
        throw new Error("invalid original units");
    }
    var finalFactor = exports.areaFactors[finalUnit];
    if (!finalFactor) {
        throw new Error("invalid final units");
    }
    return (area / startFactor) * finalFactor;
}
exports.convertArea = convertArea;
/**
 * isNumber
 *
 * @param {*} num Number to validate
 * @returns {boolean} true/false
 * @example
 * turf.isNumber(123)
 * //=true
 * turf.isNumber('foo')
 * //=false
 */
function isNumber(num) {
    return !isNaN(num) && num !== null && !Array.isArray(num) && !/^\s*$/.test(num);
}
exports.isNumber = isNumber;
/**
 * isObject
 *
 * @param {*} input variable to validate
 * @returns {boolean} true/false
 * @example
 * turf.isObject({elevation: 10})
 * //=true
 * turf.isObject('foo')
 * //=false
 */
function isObject(input) {
    return (!!input) && (input.constructor === Object);
}
exports.isObject = isObject;
/**
 * Validate BBox
 *
 * @private
 * @param {Array<number>} bbox BBox to validate
 * @returns {void}
 * @throws Error if BBox is not valid
 * @example
 * validateBBox([-180, -40, 110, 50])
 * //=OK
 * validateBBox([-180, -40])
 * //=Error
 * validateBBox('Foo')
 * //=Error
 * validateBBox(5)
 * //=Error
 * validateBBox(null)
 * //=Error
 * validateBBox(undefined)
 * //=Error
 */
function validateBBox(bbox) {
    if (!bbox) {
        throw new Error("bbox is required");
    }
    if (!Array.isArray(bbox)) {
        throw new Error("bbox must be an Array");
    }
    if (bbox.length !== 4 && bbox.length !== 6) {
        throw new Error("bbox must be an Array of 4 or 6 numbers");
    }
    bbox.forEach(function (num) {
        if (!isNumber(num)) {
            throw new Error("bbox must only contain numbers");
        }
    });
}
exports.validateBBox = validateBBox;
/**
 * Validate Id
 *
 * @private
 * @param {string|number} id Id to validate
 * @returns {void}
 * @throws Error if Id is not valid
 * @example
 * validateId([-180, -40, 110, 50])
 * //=Error
 * validateId([-180, -40])
 * //=Error
 * validateId('Foo')
 * //=OK
 * validateId(5)
 * //=OK
 * validateId(null)
 * //=Error
 * validateId(undefined)
 * //=Error
 */
function validateId(id) {
    if (!id) {
        throw new Error("id is required");
    }
    if (["string", "number"].indexOf(typeof id) === -1) {
        throw new Error("id must be a number or a string");
    }
}
exports.validateId = validateId;
// Deprecated methods
function radians2degrees() {
    throw new Error("method has been renamed to `radiansToDegrees`");
}
exports.radians2degrees = radians2degrees;
function degrees2radians() {
    throw new Error("method has been renamed to `degreesToRadians`");
}
exports.degrees2radians = degrees2radians;
function distanceToDegrees() {
    throw new Error("method has been renamed to `lengthToDegrees`");
}
exports.distanceToDegrees = distanceToDegrees;
function distanceToRadians() {
    throw new Error("method has been renamed to `lengthToRadians`");
}
exports.distanceToRadians = distanceToRadians;
function radiansToDistance() {
    throw new Error("method has been renamed to `radiansToLength`");
}
exports.radiansToDistance = radiansToDistance;
function bearingToAngle() {
    throw new Error("method has been renamed to `bearingToAzimuth`");
}
exports.bearingToAngle = bearingToAngle;
function convertDistance() {
    throw new Error("method has been renamed to `convertLength`");
}
exports.convertDistance = convertDistance;


/***/ }),

/***/ 0:
/***/ (function(module, exports, __webpack_require__) {

module.exports = __webpack_require__("bD5U");


/***/ }),

/***/ "07ub":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_Indicator_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("8Q8H");
/* harmony import */ var _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_Indicator_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_Indicator_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__);
/* harmony reexport (unknown) */ for(var __WEBPACK_IMPORT_KEY__ in _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_Indicator_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__) if(__WEBPACK_IMPORT_KEY__ !== 'default') (function(key) { __webpack_require__.d(__webpack_exports__, key, function() { return _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_Indicator_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__[key]; }) }(__WEBPACK_IMPORT_KEY__));
 /* harmony default export */ __webpack_exports__["default"] = (_node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_Indicator_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0___default.a); 

/***/ }),

/***/ "0F1z":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__("TqRt");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _regenerator = _interopRequireDefault(__webpack_require__("o0o1"));

var _classCallCheck2 = _interopRequireDefault(__webpack_require__("lwsE"));

var _createClass2 = _interopRequireDefault(__webpack_require__("W8MJ"));

var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__("a1gu"));

var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__("Nsbk"));

var _inherits2 = _interopRequireDefault(__webpack_require__("7W2i"));

var _leafletWrapper = _interopRequireDefault(__webpack_require__("uTlj"));

__webpack_require__("17FK");

__webpack_require__("e/Qi");

var _center = _interopRequireDefault(__webpack_require__("SPBs"));

var _WebMapBase2 = _interopRequireDefault(__webpack_require__("qPby"));

var __awaiter = void 0 && (void 0).__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};

var WebMapViewModel =
/*#__PURE__*/
function (_WebMapBase) {
  (0, _inherits2.default)(WebMapViewModel, _WebMapBase);

  function WebMapViewModel(id) {
    var _this;

    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    var mapOptions = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
    (0, _classCallCheck2.default)(this, WebMapViewModel);
    _this = (0, _possibleConstructorReturn2.default)(this, (0, _getPrototypeOf2.default)(WebMapViewModel).call(this, id, options, mapOptions));
    _this.layers = {};
    _this._dataflowPathIdCache = {};
    _this._dataflowLabelIdCache = {};
    _this._dataflowLineFeatureCache = {};
    _this.center = mapOptions.center;
    _this.zoom = mapOptions.zoom;

    _this._initWebMap();

    return _this;
  }

  (0, _createClass2.default)(WebMapViewModel, [{
    key: "resize",
    value: function resize() {
      this.map && this.map.invalidateSize();
      this.echartsLayerResize();
    }
  }, {
    key: "setCenter",
    value: function setCenter(center) {
      if (this.map) {
        this.mapOptions.center = center;
        center && center.length > 0 && this.map.setView(center, this.zoom);
      }
    }
  }, {
    key: "_initWebMap",
    value: function _initWebMap() {
      this.initWebMap();
    }
  }, {
    key: "_getMapInfo",
    value: function _getMapInfo(mapInfo, _taskID) {
      var layers = mapInfo.layers;

      this._createMap(mapInfo);

      this._initBaseLayer(mapInfo, false);

      if (!layers || layers.length === 0) {
        this._sendMapToUser(0, 0);
      } else {
        this._initOverlayLayers(layers, _taskID);
      }
    }
  }, {
    key: "_createMap",
    value: function _createMap(mapInfo) {
      var _this2 = this;

      if (!mapInfo) {
        this.map = _leafletWrapper.default.map(this.target, {
          center: this.center && this.center.length ? _leafletWrapper.default.latLng(this.center[0], this.center[1]) : [0, 0],
          zoom: this.zoom || 0,
          crs: this.mapOptions.crs || _leafletWrapper.default.CRS.EPSG3857,
          maxZoom: this.mapOptions.maxZoom || 30,
          minZoom: this.mapOptions.minZoom || 0,
          preferCanvas: this.mapOptions.preferCanvas || true
        });
        setTimeout(function () {
          _this2.triggerEvent('addlayerssucceeded', {
            map: _this2.map,
            mapparams: {},
            layers: []
          });
        }, 0);
        return;
      }

      var level = mapInfo.level,
          maxZoom = mapInfo.maxZoom,
          minZoom = mapInfo.minZoom;
      var zoom = level ? level : 0;
      zoom = zoom === 0 ? 0 : zoom;

      var crs = this._handleMapCrs(mapInfo);

      var center = this._getMapCenter(mapInfo);

      this.map = _leafletWrapper.default.map(this.target, {
        center: this.center || center,
        zoom: this.zoom || zoom,
        crs: crs,
        maxZoom: maxZoom || 30,
        minZoom: minZoom || 0,
        preferCanvas: true
      });
      this.triggerEvent('mapinitialized', {
        map: this.map
      });
    }
  }, {
    key: "_initBaseLayer",
    value: function _initBaseLayer(mapInfo) {
      var sendToMap = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
      var layerInfo = mapInfo.baseLayer || mapInfo;
      var layerType = this.getBaseLayerType(layerInfo);
      var mapUrls = this.getMapurls({
        CLOUD: 'http://t2.supermapcloud.com/FileService/image',
        CLOUD_BLACK: 'http://t3.supermapcloud.com/MapService/getGdp',
        OSM: 'https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png'
      });
      var url;
      var layer;

      switch (layerType) {
        case 'TIANDITU':
          layer = this._createTiandituLayer(layerInfo);
          break;

        case 'BING':
          layer = this._createBingLayer();
          break;

        case 'WMS':
          layer = this._createWMSLayer(layerInfo);
          break;

        case 'WMTS':
          layer = this._createWMTSLayer(layerInfo);
          break;

        case 'TILE':
          layer = this._createDynamicTiledLayer(layerInfo);
          break;

        case 'CLOUD':
          url = mapUrls[layerInfo.layerType];
          layer = this._createCLOUDLayer(layerType, url);
          break;

        case 'XYZ':
          url = mapUrls[layerInfo.layerType];
          layer = this._createXYZLayer(url);
          break;

        case 'BAIDU':
          layer = this._createBaiduTileLayer();
          break;

        case 'MAPBOXSTYLE':
          this.triggerEvent('notsupportmvt', {});
          break;

        default:
          break;
      }

      layer && this._addLayerToMap({
        layer: layer,
        type: 'baseLayers',
        layerInfo: layerInfo,
        sendToMap: sendToMap
      });
    }
  }, {
    key: "_initOverlayLayers",
    value: function _initOverlayLayers(layers, _taskID) {
      var _this3 = this;

      this._layers = layers;
      this.layerAdded = 0;
      this.expectLayerLen = layers.length;

      if (this.expectLayerLen > 0) {
        layers.forEach(function (layer, index) {
          var type = _this3.webMapService.getDatasourceType(layer);

          if (type === 'SAMPLE_DATA') {
            _this3._addLayerSucceeded();

            _this3.triggerEvent('getlayerdatasourcefailed', {
              error: 'SAMPLE DATA is not supported',
              layer: layer,
              map: _this3.map
            });

            return;
          }

          layer.layerID = layer.name + '-' + index;
          layer.index = index;

          if (type === 'tile') {
            _this3._initBaseLayer(layer);
          } else {
            _this3.getLayerFeatures(layer, _taskID, type);
          }
        }, this);
      }
    }
  }, {
    key: "_createMvtLayer",
    value: function _createMvtLayer(info, layer, featureType) {
      this._addLayerSucceeded();

      return;
    }
  }, {
    key: "_createRestMapLayer",
    value: function _createRestMapLayer(restMaps, layer) {
      var _this4 = this;

      restMaps.forEach(function (restMapInfo, index) {
        layer = _this4.getRestMapLayerInfo(restMapInfo, layer);

        _this4._initBaseLayer(layer, index === restMaps.length - 1);
      });
    }
  }, {
    key: "_initOverlayLayer",
    value: function _initOverlayLayer(layerInfo, features) {
      return __awaiter(this, void 0, void 0,
      /*#__PURE__*/
      _regenerator.default.mark(function _callee() {
        var layerType, style, filterCondition, featureType, labelStyle, projection, epsgCode, layer, labelLayerInfo, labelLayer;
        return _regenerator.default.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                _context.prev = 0;
                layerType = layerInfo.layerType, style = layerInfo.style, filterCondition = layerInfo.filterCondition, featureType = layerInfo.featureType, labelStyle = layerInfo.labelStyle, projection = layerInfo.projection;

                if (!(layerType === 'restMap')) {
                  _context.next = 5;
                  break;
                }

                this._createRestMapLayer(features, layerInfo);

                return _context.abrupt("return");

              case 5:
                if (!(layerType === 'mvt')) {
                  _context.next = 8;
                  break;
                }

                this._createMvtLayer(features.info, layerInfo, features.featureType);

                return _context.abrupt("return");

              case 8:
                if (!(features && projection && projection !== 'EPSG:4326')) {
                  _context.next = 14;
                  break;
                }

                epsgCode = projection.split(':')[1];

                if (epsgCode) {
                  _context.next = 12;
                  break;
                }

                return _context.abrupt("return");

              case 12:
                this._unprojectCrs = this.getTransformCoodinatesCRS(projection.split(":")[1]);
                features = this.transformFeatures(features);

              case 14:
                this.handleLayerFeatures(features, layerInfo);
                _context.t0 = layerType;
                _context.next = _context.t0 === 'VECTOR' ? 18 : _context.t0 === 'UNIQUE' ? 34 : _context.t0 === 'RANGE' ? 38 : _context.t0 === 'HEAT' ? 42 : _context.t0 === 'MARKER' ? 46 : _context.t0 === 'RANK_SYMBOL' ? 50 : _context.t0 === 'MIGRATION' ? 54 : _context.t0 === 'DATAFLOW_POINT_TRACK' ? 58 : _context.t0 === 'DATAFLOW_HEAT' ? 58 : 62;
                break;

              case 18:
                if (!(featureType === 'POINT')) {
                  _context.next = 30;
                  break;
                }

                if (!(style.type === 'SYMBOL_POINT')) {
                  _context.next = 25;
                  break;
                }

                _context.next = 22;
                return this._createSymbolLayer(layerInfo, features);

              case 22:
                layer = _context.sent;
                _context.next = 28;
                break;

              case 25:
                _context.next = 27;
                return this._createGraphicLayer(layerInfo, features);

              case 27:
                layer = _context.sent;

              case 28:
                _context.next = 33;
                break;

              case 30:
                _context.next = 32;
                return this._createVectorLayer(layerInfo, features);

              case 32:
                layer = _context.sent;

              case 33:
                return _context.abrupt("break", 62);

              case 34:
                _context.next = 36;
                return this._createUniqueLayer(layerInfo, features);

              case 36:
                layer = _context.sent;
                return _context.abrupt("break", 62);

              case 38:
                _context.next = 40;
                return this._createRangeLayer(layerInfo, features);

              case 40:
                layer = _context.sent;
                return _context.abrupt("break", 62);

              case 42:
                _context.next = 44;
                return this._createHeatLayer(layerInfo, features);

              case 44:
                layer = _context.sent;
                return _context.abrupt("break", 62);

              case 46:
                _context.next = 48;
                return this._createMarkerLayer(features);

              case 48:
                layer = _context.sent;
                return _context.abrupt("break", 62);

              case 50:
                _context.next = 52;
                return this._createRankSymbolLayer(layerInfo, features);

              case 52:
                layer = _context.sent;
                return _context.abrupt("break", 62);

              case 54:
                _context.next = 56;
                return this._createMigrationLayer(layerInfo, features);

              case 56:
                layer = _context.sent;
                return _context.abrupt("break", 62);

              case 58:
                _context.next = 60;
                return this._createDataflowLayer(layerInfo);

              case 60:
                layer = _context.sent;
                return _context.abrupt("break", 62);

              case 62:
                if (labelStyle && labelStyle.labelField && layerType !== 'DATAFLOW_POINT_TRACK') {
                  features = this.getFiterFeatures(filterCondition, features);
                  labelLayerInfo = JSON.parse(JSON.stringify(layerInfo));
                  labelLayer = this._addLabelLayer(labelLayerInfo, features);

                  this._addLayerToMap({
                    layer: _leafletWrapper.default.layerGroup([layer, labelLayer]),
                    layerInfo: layerInfo
                  });
                } else {
                  layer && this._addLayerToMap({
                    layer: layer,
                    layerInfo: layerInfo
                  });
                }

                _context.next = 70;
                break;

              case 65:
                _context.prev = 65;
                _context.t1 = _context["catch"](0);
                console.error(_context.t1);

                this._addLayerSucceeded();

                this.triggerEvent('getlayerdatasourcefailed', {
                  error: _context.t1,
                  layer: layerInfo,
                  map: this.map
                });

              case 70:
              case "end":
                return _context.stop();
            }
          }
        }, _callee, this, [[0, 65]]);
      }));
    }
  }, {
    key: "_createBingLayer",
    value: function _createBingLayer() {
      var url = 'https://dynamic.t0.tiles.ditu.live.com/comp/ch/{quadKey}?it=G,TW,L,LA&mkt=zh-cn&og=109&cstl=w4c&ur=CN&n=z';
      _leafletWrapper.default.TileLayer.BingLayer = _leafletWrapper.default.TileLayer.extend({
        getTileUrl: function getTileUrl(coordinates) {
          var z = coordinates.z,
              x = coordinates.x,
              y = coordinates.y;
          var index = '';

          for (var i = z; i > 0; i--) {
            var b = 0;
            var mask = 1 << i - 1;

            if ((x & mask) !== 0) {
              b++;
            }

            if ((y & mask) !== 0) {
              b += 2;
            }

            index += b.toString();
          }

          return url.replace('{quadKey}', index);
        }
      });

      _leafletWrapper.default.tileLayer.bingLayer = function (url, options) {
        return new _leafletWrapper.default.TileLayer.BingLayer(url, options);
      };

      return _leafletWrapper.default.tileLayer.bingLayer(url, {
        noWrap: true
      });
    }
  }, {
    key: "_createDynamicTiledLayer",
    value: function _createDynamicTiledLayer(layerInfo) {
      var url = layerInfo.url;

      var layer = _leafletWrapper.default.supermap.tiledMapLayer(url, {
        noWrap: true,
        prjCoordSys: {
          epsgCode: this.baseProjection.split(':')[1]
        }
      });

      return layer;
    }
  }, {
    key: "_createWMSLayer",
    value: function _createWMSLayer(layerInfo) {
      var url = layerInfo.url,
          layers = layerInfo.layers;

      if (!layers || layers === 'undefined' || layers === 'null') {
        layers = '0';
      } else if (layers.length > 0) {
        layers = layers[0];
      }

      return _leafletWrapper.default.tileLayer.wms(url, {
        layers: layers,
        format: 'image/png',
        transparent: true,
        noWrap: true
      });
    }
  }, {
    key: "_createWMTSLayer",
    value: function _createWMTSLayer(layerInfo) {
      var url = layerInfo.url,
          tileMatrixSet = layerInfo.tileMatrixSet,
          name = layerInfo.name;
      return _leafletWrapper.default.supermap.wmtsLayer(url, {
        layer: name,
        style: 'default',
        tilematrixSet: tileMatrixSet,
        format: 'image/png',
        noWrap: true
      });
    }
  }, {
    key: "_createTiandituLayer",
    value: function _createTiandituLayer(layerInfo) {
      this.map.getZoom() < 1 && this.map.setZoom(1);
      this.map.setMinZoom(1);
      var layerType = layerInfo.layerType.split('_')[1].toLowerCase();
      var isLabel = Boolean(layerInfo.labelLayerVisible);

      var tiandituLayer = _leafletWrapper.default.supermap.tiandituTileLayer({
        layerType: layerType,
        key: this.tiandituKey
      });

      var tiandituLabelLayer = _leafletWrapper.default.supermap.tiandituTileLayer({
        layerType: layerType,
        isLabel: true,
        key: this.tiandituKey
      });

      var layers = [tiandituLayer];
      isLabel && layers.push(tiandituLabelLayer);
      return _leafletWrapper.default.layerGroup(layers);
    }
  }, {
    key: "_createCLOUDLayer",
    value: function _createCLOUDLayer(layerType, url) {
      if (layerType === 'CLOUD') {
        this.map.getZoom() < 3 && this.map.setZoom(3);
        this.map.setMinZoom(3);
      }

      return _leafletWrapper.default.supermap.cloudTileLayer(url, {
        noWrap: true
      });
    }
  }, {
    key: "_createXYZLayer",
    value: function _createXYZLayer(url) {
      return _leafletWrapper.default.tileLayer(url, {
        noWrap: true
      });
    }
  }, {
    key: "_createBaiduTileLayer",
    value: function _createBaiduTileLayer() {
      this.map.getZoom() < 3 && this.map.setZoom(3);
      this.map.setMinZoom(3);
      return _leafletWrapper.default.supermap.baiduTileLayer('', {
        noWrap: true
      });
    }
  }, {
    key: "_createUniqueLayer",
    value: function _createUniqueLayer(layerInfo, features) {
      return this._createThemeLayer('unique', layerInfo, features);
    }
  }, {
    key: "_createRangeLayer",
    value: function _createRangeLayer(layerInfo, features) {
      return this._createThemeLayer('range', layerInfo, features);
    }
  }, {
    key: "_createMarkerLayer",
    value: function _createMarkerLayer(features) {
      var _this5 = this;

      return new Promise(function (resolve, reject) {
        var layerGroupPromises = features && features.map(function (feature) {
          return new Promise(function (resolve, reject) {
            var geomType = feature.geometry.type.toUpperCase();
            var defaultStyle = feature.dv_v5_markerStyle;

            if (geomType === 'POINT' && defaultStyle.text) {
              geomType = 'TEXT';
            }

            var featureInfo = _this5.setFeatureInfo(feature);

            feature.properties['useStyle'] = defaultStyle;
            feature.properties['featureInfo'] = featureInfo;

            if (geomType === 'POINT' && defaultStyle.src && defaultStyle.src.indexOf('http://') === -1 && defaultStyle.src.indexOf('https://') === -1) {
              defaultStyle.src = _this5.serverUrl + defaultStyle.src;
            }

            var imgWidth = (defaultStyle.imgWidth || 48) * defaultStyle.scale;
            var imgHeight = (defaultStyle.imgHeight || 43) * defaultStyle.scale;

            if (geomType === 'POINT' && defaultStyle.src && defaultStyle.src.indexOf('svg') <= -1) {
              resolve(_leafletWrapper.default.marker([feature.geometry.coordinates[1], feature.geometry.coordinates[0]], {
                icon: _leafletWrapper.default.icon({
                  iconUrl: defaultStyle.src,
                  iconSize: [imgWidth, imgHeight],
                  iconAnchor: [imgWidth * defaultStyle.anchor[0], imgHeight * defaultStyle.anchor[1]]
                })
              }));
            }

            if (geomType === 'POINT' && defaultStyle.src && defaultStyle.src.indexOf('svg') > -1) {
              if (!_this5._svgDiv) {
                _this5._svgDiv = document.createElement('div');
                document.body.appendChild(_this5._svgDiv);
              }

              _this5.getCanvasFromSVG(defaultStyle.src, _this5._svgDiv, function (canvas) {
                resolve(_this5._getSvgLayer(canvas, defaultStyle, [feature]));
              });
            }

            if (!defaultStyle.src) {
              if (geomType === 'LINESTRING' && defaultStyle.lineCap || geomType === 'POLYGON') {
                resolve(_this5._createGeojsonLayer([feature], _this5._getVectorLayerStyle(defaultStyle)));
              } else if (geomType === 'TEXT') {
                var text = new _leafletWrapper.default.supermap.labelThemeLayer(defaultStyle.text + '-text');
                text.style = {
                  fontSize: defaultStyle.font.split(' ')[0],
                  labelRect: true,
                  fontColor: defaultStyle.fillColor,
                  fill: true,
                  fillColor: defaultStyle.backgroundFill,
                  stroke: false
                };
                text.themeField = 'text';
                feature.properties.text = defaultStyle.text;
                var geoTextFeature = new _leafletWrapper.default.supermap.themeFeature([feature.geometry.coordinates[1], feature.geometry.coordinates[0], defaultStyle.text], feature.properties);
                text.addFeatures([geoTextFeature]);
                resolve(text);
              } else {
                resolve(_leafletWrapper.default.circleMarker([feature.geometry.coordinates[1], feature.geometry.coordinates[0]], Object.assign({}, _this5._getVectorLayerStyle(defaultStyle))));
              }
            }
          });
        });
        layerGroupPromises && Promise.all(layerGroupPromises).then(function (layerGroup) {
          layerGroup && resolve(_leafletWrapper.default.layerGroup(layerGroup));
        }).catch(function (error) {
          console.error(error);
        });
      });
    }
  }, {
    key: "_createRankSymbolLayer",
    value: function _createRankSymbolLayer(layerInfo, features) {
      var _this6 = this;

      var fieldName = layerInfo.themeSetting.themeField;
      var style = layerInfo.style;
      var styleSource = this.createRankStyleSource(layerInfo, features);
      var styleGroups = styleSource.styleGroups;
      features = this.getFiterFeatures(layerInfo.filterCondition, features);
      var radiusList = [];
      features.forEach(function (row) {
        var target = parseFloat(row.properties[fieldName]);

        if (styleGroups) {
          for (var i = 0; i < styleGroups.length; i++) {
            if (styleGroups[i].start <= target && target < styleGroups[i].end) {
              var radius = style.type === 'SYMBOL_POINT' || style.type === 'IMAGE_POINT' ? style.type === 'SYMBOL_POINT' ? styleGroups[i].radius * 2 : styleGroups[i].radius : styleGroups[i].radius;
              radiusList.push(radius);
            }
          }
        }
      }, this);

      if (style.type === 'SYMBOL_POINT') {
        return this._createSymbolLayer(layerInfo, features, radiusList);
      } else if (style.type === 'IMAGE_POINT' || style.type === 'SVG_POINT') {
        return this._createGraphicLayer(layerInfo, features, radiusList);
      } else {
        var layerGroup = [];
        features.forEach(function (feature, index) {
          var newStyle = Object.assign({}, style, {
            radius: radiusList[index]
          });
          layerGroup.push(_leafletWrapper.default.circleMarker([feature.geometry.coordinates[1], feature.geometry.coordinates[0]], _this6._getVectorLayerStyle(newStyle)));
        });
        return _leafletWrapper.default.layerGroup(layerGroup);
      }
    }
  }, {
    key: "_addLabelLayer",
    value: function _addLabelLayer(layerInfo, features) {
      var labelStyle = layerInfo.labelStyle,
          layerID = layerInfo.layerID,
          featureType = layerInfo.featureType;
      var label = new _leafletWrapper.default.supermap.labelThemeLayer(layerID + '-label');
      labelStyle.fontSize = 14;
      labelStyle.labelRect = true;
      labelStyle.fontColor = labelStyle.fill;
      labelStyle.fill = true;
      labelStyle.fillColor = '#FFFFFF';
      labelStyle.stroke = false;
      labelStyle.strokeColor = '#8B7B8B';
      label.style = labelStyle;
      label.themeField = labelStyle.labelField;

      var labelFeatures = this._convertLabelFeatures(label, features, layerInfo, featureType);

      label.addFeatures(labelFeatures);
      return label;
    }
  }, {
    key: "_createHeatLayer",
    value: function _createHeatLayer(layerInfo, features) {
      var themeSetting = layerInfo.themeSetting,
          layerID = layerInfo.layerID;
      var colors = themeSetting.colors,
          radius = themeSetting.radius,
          customSettings = themeSetting.customSettings,
          weight = themeSetting.weight;
      var heatColors = colors.slice();

      for (var i in customSettings) {
        heatColors[i] = customSettings[i];
      }

      var heatMapLayer = _leafletWrapper.default.supermap.heatMapLayer(layerID, {
        colors: heatColors,
        map: this.map,
        radius: radius * 2,
        featureWeight: weight,
        blur: radius * 1.5
      });

      heatMapLayer.addFeatures({
        type: 'FeatureCollection',
        features: features
      });
      return heatMapLayer;
    }
  }, {
    key: "_createSymbolLayer",
    value: function _createSymbolLayer(layerInfo, features, textSize) {
      var style = layerInfo.style;
      var unicode = style.unicode;
      var pointToLayer;

      if (unicode) {
        pointToLayer = this._getSymbolPointLayer(style, textSize);
      }

      return pointToLayer && this._createGeojsonLayer(features, null, pointToLayer);
    }
  }, {
    key: "_createGraphicLayer",
    value: function _createGraphicLayer(layerInfo, features, textSize) {
      var _this7 = this;

      return new Promise(function (resolve, reject) {
        var style = layerInfo.style;
        var type = style.type,
            imageInfo = style.imageInfo,
            radius = style.radius,
            url = style.url;
        var pointToLayer;

        if (type === 'IMAGE_POINT' && imageInfo.url) {
          var resolution = imageInfo.size.w / imageInfo.size.h;

          pointToLayer = function pointToLayer(geojson, latlng) {
            var iconSize = textSize && textSize[geojson.id - 1 || geojson.properties.index] * 2;
            return _leafletWrapper.default.marker(latlng, {
              icon: _leafletWrapper.default.icon({
                iconUrl: imageInfo.url,
                iconSize: textSize ? [iconSize, iconSize / resolution] : [radius * 2, radius * 2 / resolution]
              })
            });
          };
        } else if (type === 'SVG_POINT') {
          if (!_this7._svgDiv) {
            _this7._svgDiv = document.createElement('div');
            document.body.appendChild(_this7._svgDiv);
          }

          _this7.getCanvasFromSVG(url, _this7._svgDiv, function (canvas) {
            resolve(_this7._getSvgLayer(canvas, style, features, textSize));
          });
        } else {
          pointToLayer = function pointToLayer(geojson, latlng) {
            return _leafletWrapper.default.circleMarker(latlng, _this7._getVectorLayerStyle(style));
          };
        }

        pointToLayer && resolve(_this7._createGeojsonLayer(features, null, pointToLayer));
      });
    }
  }, {
    key: "_createVectorLayer",
    value: function _createVectorLayer(layerInfo, features) {
      var style = layerInfo.style;
      return this._createGeojsonLayer(features, this._getVectorLayerStyle(style));
    }
  }, {
    key: "_createMigrationLayer",
    value: function _createMigrationLayer(layerInfo, features) {
      var options = this.getEchartsLayerOptions(layerInfo, features, 'leaflet');

      var layer = _leafletWrapper.default.supermap.echartsLayer(options);

      this.echartslayer.push(layer);
      return layer;
    }
  }, {
    key: "_createDataflowLayer",
    value: function _createDataflowLayer(layerInfo) {
      var _this8 = this;

      this._dataflowFeatureCache = {};
      return new Promise(function (resolve, reject) {
        _this8._getDataflowPointLayer(layerInfo).then(function (pointToLayer) {
          var dataFlowLayer = _leafletWrapper.default.supermap.dataFlowLayer(layerInfo.wsUrl, {
            pointToLayer: pointToLayer
          });

          _this8._updateDataFlowFeaturesCallback = _this8._updateDataFlowFeature.bind(_this8, layerInfo);
          dataFlowLayer.on('dataupdated', _this8._updateDataFlowFeaturesCallback);
          _this8._dataFlowLayer = dataFlowLayer;
          resolve(dataFlowLayer);
        });
      });
    }
  }, {
    key: "_createGeojsonLayer",
    value: function _createGeojsonLayer(features, style, pointToLayer) {
      return _leafletWrapper.default.geoJSON({
        type: 'FeatureCollection',
        features: features
      }, {
        pointToLayer: pointToLayer,
        style: style
      });
    }
  }, {
    key: "_getVectorLayerStyle",
    value: function _getVectorLayerStyle(style) {
      var fillColor = style.fillColor,
          fillOpacity = style.fillOpacity,
          strokeColor = style.strokeColor,
          strokeOpacity = style.strokeOpacity,
          strokeWidth = style.strokeWidth,
          radius = style.radius,
          lineDash = style.lineDash;
      var commonStyle = {
        color: strokeColor,
        weight: strokeWidth,
        opacity: strokeOpacity,
        fillColor: fillColor,
        fillOpacity: fillOpacity
      };
      var dashArray;

      if (lineDash) {
        dashArray = this.getDashStyle(lineDash, strokeWidth, 'string');
      }

      radius && (commonStyle['radius'] = radius);
      lineDash && (commonStyle['dashArray'] = dashArray);
      return commonStyle;
    }
  }, {
    key: "_getMapCenter",
    value: function _getMapCenter(mapInfo) {
      var center;
      center = mapInfo.center && [mapInfo.center.x, mapInfo.center.y];

      if (!center) {
        center = [0, 0];
      }

      center = this.baseProjection === 'EPSG:3857' ? this.crs.unproject(_leafletWrapper.default.point(center[0], center[1])) : _leafletWrapper.default.latLng(center[1], center[0]);
      return center;
    }
  }, {
    key: "_sendMapToUser",
    value: function _sendMapToUser(count, layersLen) {
      if (count === layersLen) {
        this.triggerEvent('addlayerssucceeded', {
          map: this.map,
          mapparams: this.mapParams,
          layers: this._layers
        });
      }
    }
  }, {
    key: "_addLayerToMap",
    value: function _addLayerToMap(_ref) {
      var layer = _ref.layer,
          _ref$type = _ref.type,
          type = _ref$type === void 0 ? 'overlays' : _ref$type,
          layerInfo = _ref.layerInfo,
          _ref$sendToMap = _ref.sendToMap,
          sendToMap = _ref$sendToMap === void 0 ? true : _ref$sendToMap;
      var visible = layerInfo.visible,
          layerID = layerInfo.layerID,
          name = layerInfo.name,
          index = layerInfo.index;
      sendToMap && (type = 'overlays');
      type === 'overlays' && layer.setZIndex && layer.setZIndex(index + 1);

      if (visible === undefined || visible) {
        this.map.addLayer(layer, layerInfo.name);
      }

      !this.layers[type] && (this.layers[type] = {});
      this.layers[type][layerID || name] = layer;

      this._addLayerSucceeded(sendToMap);
    }
  }, {
    key: "_convertLabelFeatures",
    value: function _convertLabelFeatures(layer, features, layerInfo, featureType) {
      var _this9 = this;

      if (!features) {
        return [];
      }

      var themeField = layer.themeField,
          style = layer.style;
      var labelFeatures = [];
      var layerStyle = layerInfo.style || {};
      features.forEach(function (feature) {
        var coordinate = _this9._getLabelLngLat(featureType, feature);

        _this9._setLabelOffset(featureType, layerStyle, style);

        var properties = feature.properties;
        var geoTextFeature = new _leafletWrapper.default.supermap.themeFeature([coordinate[1], coordinate[0], properties[themeField]], properties);
        labelFeatures.push(geoTextFeature);
      });
      return labelFeatures;
    }
  }, {
    key: "_getLabelLngLat",
    value: function _getLabelLngLat(featureType, feature) {
      var coordinate;
      var coordinates = feature.geometry.coordinates;

      if (featureType === 'POINT') {
        coordinate = coordinates;
      } else if (featureType === 'LINE') {
        var length = coordinates.length;
        coordinate = coordinates[Math.round(length / 2)];
      } else {
        coordinate = (0, _center.default)(feature).geometry.coordinates;
      }

      return coordinate;
    }
  }, {
    key: "_setLabelOffset",
    value: function _setLabelOffset(featureType, layerStyle, style) {
      if (featureType === 'POINT') {
        var pointRadius = layerStyle.pointRadius || 0;
        var strokeWidth = layerStyle.strokeWidth || 0;
        var fontSize = parseInt(layerStyle.fontSize) || 0;
        style.labelXOffset = 0;
        style.labelYOffset = layerStyle.unicode ? 20 + fontSize : 25 + (pointRadius + strokeWidth);
      } else {
        return;
      }
    }
  }, {
    key: "_addLayerSucceeded",
    value: function _addLayerSucceeded() {
      var sendMap = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;

      if (sendMap) {
        this.layerAdded++;

        this._sendMapToUser(this.layerAdded, this.expectLayerLen);
      }
    }
  }, {
    key: "_unproject",
    value: function _unproject(coordinate) {
      var crs = this._unprojectCrs || _leafletWrapper.default.CRS.EPSG3857;
      return this._latlngToCoordinate(crs.unproject(_leafletWrapper.default.point(coordinate[0], coordinate[1])));
    }
  }, {
    key: "_latlngToCoordinate",
    value: function _latlngToCoordinate(latlng) {
      if (!latlng) {
        return null;
      }

      return [latlng.lng, latlng.lat];
    }
  }, {
    key: "_getSvgLayer",
    value: function _getSvgLayer(canvas, style, features, textSize) {
      var svgPointToLayer = this._getSvgPointLayer(canvas, style, textSize);

      return this._createGeojsonLayer(features, null, svgPointToLayer);
    }
  }, {
    key: "_createThemeLayer",
    value: function _createThemeLayer(type, layerInfo, features) {
      var filterCondition = layerInfo.filterCondition,
          style = layerInfo.style,
          themeSetting = layerInfo.themeSetting,
          featureType = layerInfo.featureType,
          layerID = layerInfo.layerID;
      var layerStyle = JSON.parse(JSON.stringify(style));
      featureType === 'POINT' && (layerStyle.pointRadius = style.radius);
      delete layerStyle.radius;

      if (featureType === 'LINE') {
        layerStyle.fill = false;
        layerStyle.strokeDashstyle = style.lineDash;
        delete layerStyle.lineDash;
      }

      var styleGroup;

      if (type === 'unique') {
        styleGroup = this.getUniqueStyleGroup(layerInfo, features);
      } else if (type === 'range') {
        styleGroup = this.getRangeStyleGroup(layerInfo, features);
      }

      filterCondition && (features = this.getFiterFeatures(filterCondition, features));
      var themeField = themeSetting.themeField;
      Object.keys(features[0].properties).forEach(function (key) {
        key.toLocaleUpperCase() === themeField.toLocaleUpperCase() && (themeField = key);
      });

      var layer = _leafletWrapper.default.supermap["".concat(type, "ThemeLayer")](layerID);

      layerStyle.stroke = true;
      layer.style = layerStyle;
      layer.themeField = themeField;
      layer.styleGroups = styleGroup;
      layer.addFeatures({
        type: 'FeatureCollection',
        features: features
      });
      return layer;
    }
  }, {
    key: "_handleMapCrs",
    value: function _handleMapCrs(mapInfo) {
      var projection = mapInfo.projection,
          baseLayer = mapInfo.baseLayer,
          extent = mapInfo.extent;
      this.baseProjection = projection;

      if (projection === 'EPSG:910111' || projection === 'EPSG:910112') {
        this.baseProjection = 'EPSG:3857';
      } else if (projection === 'EPSG:910101' || projection === 'EPSG:910102') {
        this.baseProjection = 'EPSG:4326';
      }

      if (baseLayer.layerType === 'BAIDU') {
        this.crs = _leafletWrapper.default.CRS.Baidu;
        return this.crs;
      }

      if (baseLayer.layerType.indexOf('TIANDITU') > -1) {
        this.crs = this.baseProjection === 'EPSG:3857' ? _leafletWrapper.default.CRS.TianDiTu_Mercator : _leafletWrapper.default.CRS.TianDiTu_WGS84;
        return this.crs;
      }

      var epsgCode = this.baseProjection.split(':')[1];

      var bounds = _leafletWrapper.default.bounds([extent.leftBottom.x, extent.leftBottom.y], [extent.rightTop.x, extent.rightTop.y]);

      if (['4326', '3857', '3395'].includes(epsgCode)) {
        this.crs = _leafletWrapper.default.Proj.CRS("EPSG:".concat(epsgCode), {
          bounds: bounds
        });
      } else if (parseFloat(epsgCode) < 0) {
        this.crs = new _leafletWrapper.default.CRS.NonEarthCRS({
          bounds: bounds
        });
      } else if (!epsgCode) {
        this.baseProjection = this.getEpsgInfoFromWKT(this.baseProjection);

        if (this.baseProjection) {
          this.crs = _leafletWrapper.default.Proj.CRS(this.baseProjection, {
            bounds: bounds,
            def: mapInfo.projection
          });
        }
      }

      return this.crs;
    }
  }, {
    key: "_updateDataFlowFeature",
    value: function _updateDataFlowFeature(layerInfo, e) {
      if (layerInfo.visible) {
        var feature = e.data;
        var lineStyle = layerInfo.lineStyle,
            labelStyle = layerInfo.labelStyle;
        lineStyle && this._updateDataflowPathLayer(feature, layerInfo);
        labelStyle && labelStyle.labelField !== '未设置' && this._updateDataflowLabelLayer(feature, layerInfo);
      }
    }
  }, {
    key: "_getSymbolPointLayer",
    value: function _getSymbolPointLayer(style, textSize) {
      var symbolStyle = JSON.parse(JSON.stringify(style));
      symbolStyle.fontColor = style.fillColor;
      symbolStyle.label = style.unicode;
      symbolStyle.fontFamily = 'supermapol-icons';

      var pointToLayer = function pointToLayer(geojson, latlng) {
        textSize && (symbolStyle.fontSize = textSize[geojson.id - 1 || geojson.properties.index] + 'px');
        return new _leafletWrapper.default.supermap.unicodeMarker(latlng, symbolStyle);
      };

      return pointToLayer;
    }
  }, {
    key: "_getSvgPointLayer",
    value: function _getSvgPointLayer(canvas, style, textSize) {
      var radius = style.radius;
      this.handleSvgColor(style, canvas);
      var imgUrl = canvas.toDataURL('img/png');
      var resolution = canvas.width / canvas.height;

      var svgPointToLayer = function svgPointToLayer(geojson, latlng) {
        var iconSize = textSize && textSize[geojson.id - 1 || geojson.properties.index];
        return _leafletWrapper.default.marker(latlng, {
          icon: _leafletWrapper.default.icon({
            iconUrl: imgUrl,
            iconSize: textSize ? [iconSize, iconSize / resolution] : [radius, radius / resolution]
          })
        });
      };

      return svgPointToLayer;
    }
  }, {
    key: "_getDataflowPointLayer",
    value: function _getDataflowPointLayer(layerInfo) {
      var _this10 = this;

      var layerType = layerInfo.layerType,
          pointStyle = layerInfo.pointStyle,
          layerID = layerInfo.layerID,
          themeSetting = layerInfo.themeSetting;
      return new Promise(function (resolve, reject) {
        if (layerType === 'DATAFLOW_HEAT') {
          var colors = themeSetting.colors,
              radius = themeSetting.radius,
              customSettings = themeSetting.customSettings,
              weight = themeSetting.weight;
          var heatLayerInfo = {
            layerID: layerID,
            themeSetting: {
              colors: colors,
              radius: radius,
              customSettings: customSettings,
              weight: weight
            }
          };

          var pointToLayer = function pointToLayer(geojson, latlng) {
            return _this10._createHeatLayer(heatLayerInfo, [geojson]);
          };

          resolve(pointToLayer);
        } else if ('SYMBOL_POINT' === pointStyle.type) {
          resolve(_this10._getSymbolPointLayer(pointStyle, null));
        } else if ('SVG_POINT' === pointStyle.type) {
          if (!_this10._svgDiv) {
            _this10._svgDiv = document.createElement('div');
            document.body.appendChild(_this10._svgDiv);
          }

          _this10.getCanvasFromSVG(pointStyle.url, _this10._svgDiv, function (canvas) {
            resolve(_this10._getSvgPointLayer(canvas, pointStyle, null));
          });
        } else {
          var _pointToLayer = function _pointToLayer(geojson, latlng) {
            return _leafletWrapper.default.circleMarker(latlng, _this10._getVectorLayerStyle(pointStyle));
          };

          resolve(_pointToLayer);
        }
      });
    }
  }, {
    key: "_handleDataflowFeature",
    value: function _handleDataflowFeature(feature, layerInfo) {
      var identifyField = layerInfo.identifyField,
          maxPointCount = layerInfo.maxPointCount,
          lineStyle = layerInfo.lineStyle;
      var geoID = feature.properties[identifyField];

      if (lineStyle) {
        if (this._dataflowLineFeatureCache[geoID]) {
          var coordinates = this._dataflowLineFeatureCache[geoID].geometry.coordinates;
          coordinates.push(feature.geometry.coordinates);

          if (maxPointCount && coordinates.length > maxPointCount) {
            coordinates.splice(0, coordinates.length - maxPointCount);
          }

          this._dataflowLineFeatureCache[geoID].geometry.coordinates = coordinates;
        } else {
          this._dataflowLineFeatureCache[geoID] = {
            type: 'Feature',
            properties: feature.properties,
            geometry: {
              type: 'LineString',
              coordinates: [feature.geometry.coordinates]
            }
          };
        }
      }

      this._dataflowFeatureCache[geoID] = feature;
    }
  }, {
    key: "_updateDataflowLabelLayer",
    value: function _updateDataflowLabelLayer(feature, layerInfo) {
      this._handleDataflowFeature(feature, layerInfo);

      var geoID = feature.properties[layerInfo.identifyField];
      var layer;

      if (this._dataflowLabelIdCache[geoID]) {
        layer = this._dataFlowLayer.getLayer(this._dataflowLabelIdCache[geoID]);
        var _feature = this._dataflowFeatureCache[geoID];
        var geoTextFeature = new _leafletWrapper.default.supermap.themeFeature([_feature.geometry.coordinates[1], _feature.geometry.coordinates[0], geoID], _feature.properties);
        layer.removeAllFeatures();
        layer.addFeatures([geoTextFeature]);
      } else {
        var _feature2 = this._dataflowFeatureCache[geoID];
        layer = this._addLabelLayer(layerInfo, [_feature2]);

        this._dataFlowLayer.addLayer(layer);

        this._dataflowLabelIdCache[geoID] = this._dataFlowLayer.getLayerId(layer);
      }
    }
  }, {
    key: "_updateDataflowPathLayer",
    value: function _updateDataflowPathLayer(feature, layerInfo) {
      this._handleDataflowFeature(feature, layerInfo);

      var geoID = feature.properties[layerInfo.identifyField];
      var layer;
      var coordinates = this._dataflowLineFeatureCache[geoID].geometry.coordinates;

      var latlngs = _leafletWrapper.default.GeoJSON.coordsToLatLngs(coordinates, 0);

      if (this._dataflowPathIdCache[geoID]) {
        layer = this._dataFlowLayer.getLayer(this._dataflowPathIdCache[geoID]);
        layer.setLatLngs(latlngs);
      } else {
        layer = _leafletWrapper.default.polyline(latlngs, Object.assign({}, this._getVectorLayerStyle(layerInfo.lineStyle)));

        this._dataFlowLayer.addLayer(layer);

        this._dataflowPathIdCache[geoID] = this._dataFlowLayer.getLayerId(layer);
      }
    }
  }, {
    key: "getTransformCoodinatesCRS",
    value: function getTransformCoodinatesCRS(epsgCode) {
      var defName = "EPSG:".concat(epsgCode);
      var defValue = this.webMapService.getEpsgcodeWkt(defName);
      return _leafletWrapper.default.Proj.CRS(this.getEpsgInfoFromWKT(defValue), {
        def: defValue
      });
    }
  }, {
    key: "cleanWebMap",
    value: function cleanWebMap() {
      if (this.map) {
        this.map.remove();
        this.center = null;
        this.zoom = null;

        this._dataFlowLayer.off('dataupdated', this._updateDataFlowFeaturesCallback);

        this._unprojectCrs = null;
      }
    }
  }]);
  return WebMapViewModel;
}(_WebMapBase2.default);

exports.default = WebMapViewModel;

/***/ }),

/***/ "0Tzf":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_Progress_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("5L7t");
/* harmony import */ var _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_Progress_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_Progress_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__);
/* harmony reexport (unknown) */ for(var __WEBPACK_IMPORT_KEY__ in _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_Progress_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__) if(__WEBPACK_IMPORT_KEY__ !== 'default') (function(key) { __webpack_require__.d(__webpack_exports__, key, function() { return _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_Progress_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__[key]; }) }(__WEBPACK_IMPORT_KEY__));
 /* harmony default export */ __webpack_exports__["default"] = (_node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_Progress_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0___default.a); 

/***/ }),

/***/ "0XuU":
/***/ (function(module, exports, __webpack_require__) {

module.exports = __webpack_require__("43KI").Transform


/***/ }),

/***/ "0Z9T":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";

// CONCATENATED MODULE: ./node_modules/vue-loader/lib/loaders/templateLoader.js??vue-loader-options!./node_modules/vue-loader/lib??vue-loader-options!./src/common/image/Image.vue?vue&type=template&id=452a2bc2&
var render = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{staticClass:"sm-component-image",style:([_vm.getBackgroundStyle, _vm.getTextColorStyle])},[_c('a',{class:['sm-component-image__link', _vm.realHref ? '': 'sm-component-image__noLink'],attrs:{"href":_vm.realHref,"target":_vm.target}},[(_vm.src)?_c('div',{staticClass:"sm-component-image__content",style:([_vm.repeatStyle,_vm.imgUrl])}):_c('i',{staticClass:"sm-components-icons-x-bmp sm-component-image__defaultImg"})])])}
var staticRenderFns = []


// CONCATENATED MODULE: ./src/common/image/Image.vue?vue&type=template&id=452a2bc2&
/* concated harmony reexport render */__webpack_require__.d(__webpack_exports__, "a", function() { return render; });
/* concated harmony reexport staticRenderFns */__webpack_require__.d(__webpack_exports__, "b", function() { return staticRenderFns; });


/***/ }),

/***/ "0ow9":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";

// CONCATENATED MODULE: ./node_modules/vue-loader/lib/loaders/templateLoader.js??vue-loader-options!./node_modules/vue-loader/lib??vue-loader-options!./src/leaflet/web-map/WebMap.vue?vue&type=template&id=33038e71&
var render = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{staticClass:"sm-component-web-map",attrs:{"id":_vm.target}},[(_vm.ready)?_vm._t("default"):_vm._e(),_vm._v(" "),(_vm.spinning)?_c('a-spin',{attrs:{"size":"large","tip":_vm.$t('webmap.loadingTip'),"spinning":_vm.spinning}}):_vm._e()],2)}
var staticRenderFns = []


// CONCATENATED MODULE: ./src/leaflet/web-map/WebMap.vue?vue&type=template&id=33038e71&
/* concated harmony reexport render */__webpack_require__.d(__webpack_exports__, "a", function() { return render; });
/* concated harmony reexport staticRenderFns */__webpack_require__.d(__webpack_exports__, "b", function() { return staticRenderFns; });


/***/ }),

/***/ "0zgg":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__("TqRt");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _classCallCheck2 = _interopRequireDefault(__webpack_require__("lwsE"));

var _createClass2 = _interopRequireDefault(__webpack_require__("W8MJ"));

var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__("a1gu"));

var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__("Nsbk"));

var _inherits2 = _interopRequireDefault(__webpack_require__("7W2i"));

var _typeof2 = _interopRequireDefault(__webpack_require__("cDf5"));

var _vue = _interopRequireDefault(__webpack_require__("i7/w"));

var _vuePropertyDecorator = __webpack_require__("YKMj");

var __decorate = void 0 && (void 0).__decorate || function (decorators, target, key, desc) {
  var c = arguments.length,
      r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
      d;
  if ((typeof Reflect === "undefined" ? "undefined" : (0, _typeof2.default)(Reflect)) === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);else for (var i = decorators.length - 1; i >= 0; i--) {
    if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
  }
  return c > 3 && r && Object.defineProperty(target, key, r), r;
};

var MAP_EVENT_NAMES = ['zoomlevelschange', 'resize', 'unload', 'viewreset', 'load', 'zoomstart', 'movestart', 'zoom', 'move', 'zoomend', 'moveend', 'popupopen', 'popupclose', 'autopanstart', 'tooltipopen', 'tooltipclose', 'locationerror', 'locationfound', 'click', 'dblclick', 'mousedown', 'mouseup', 'mouseover', 'mouseout', 'mousemove', 'contextmenu', 'keypress', 'keydown', 'keyup', 'preclick', 'zoomanim'];

var MapEvents =
/*#__PURE__*/
function (_Vue) {
  (0, _inherits2.default)(MapEvents, _Vue);

  function MapEvents() {
    (0, _classCallCheck2.default)(this, MapEvents);
    return (0, _possibleConstructorReturn2.default)(this, (0, _getPrototypeOf2.default)(MapEvents).apply(this, arguments));
  }

  (0, _createClass2.default)(MapEvents, [{
    key: "mapEventCallback",
    value: function mapEventCallback(event) {
      var data = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      this.emitMapEvent(event.type, Object.assign({
        mapboxEvent: event
      }, data));
    }
  }, {
    key: "bindMapEvents",
    value: function bindMapEvents() {
      var _this = this;

      Object.keys(this.$listeners).forEach(function (eventName) {
        if (MAP_EVENT_NAMES.includes(eventName)) {
          _this.bindMapEvent(eventName, _this.mapEventCallback.bind(_this));
        }
      });
    }
  }, {
    key: "emitMapEvent",
    value: function emitMapEvent(name) {
      var data = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      this.$emit(name, Object.assign({
        map: this.map,
        component: this
      }, data));
    }
  }, {
    key: "bindMapEvent",
    value: function bindMapEvent(eventName, eventCallback) {
      this.map.on(eventName, eventCallback);
    }
  }]);
  return MapEvents;
}(_vue.default);

MapEvents = __decorate([_vuePropertyDecorator.Component], MapEvents);
var _default = MapEvents;
exports.default = _default;

/***/ }),

/***/ 1:
/***/ (function(module, exports) {

/* (ignored) */

/***/ }),

/***/ "17FK":
/***/ (function(module, exports) {

module.exports = __WEBPACK_EXTERNAL_MODULE__17FK__;

/***/ }),

/***/ "1IWx":
/***/ (function(module, exports, __webpack_require__) {

// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.

module.exports = Stream;

var EE = __webpack_require__("+qE3").EventEmitter;
var inherits = __webpack_require__("P7XM");

inherits(Stream, EE);
Stream.Readable = __webpack_require__("43KI");
Stream.Writable = __webpack_require__("LGOv");
Stream.Duplex = __webpack_require__("CWBI");
Stream.Transform = __webpack_require__("0XuU");
Stream.PassThrough = __webpack_require__("wq4j");

// Backwards-compat with node 0.4.x
Stream.Stream = Stream;



// old-style streams.  Note that the pipe method (the only relevant
// part of this class) is overridden in the Readable class.

function Stream() {
  EE.call(this);
}

Stream.prototype.pipe = function(dest, options) {
  var source = this;

  function ondata(chunk) {
    if (dest.writable) {
      if (false === dest.write(chunk) && source.pause) {
        source.pause();
      }
    }
  }

  source.on('data', ondata);

  function ondrain() {
    if (source.readable && source.resume) {
      source.resume();
    }
  }

  dest.on('drain', ondrain);

  // If the 'end' option is not supplied, dest.end() will be called when
  // source gets the 'end' or 'close' events.  Only dest.end() once.
  if (!dest._isStdio && (!options || options.end !== false)) {
    source.on('end', onend);
    source.on('close', onclose);
  }

  var didOnEnd = false;
  function onend() {
    if (didOnEnd) return;
    didOnEnd = true;

    dest.end();
  }


  function onclose() {
    if (didOnEnd) return;
    didOnEnd = true;

    if (typeof dest.destroy === 'function') dest.destroy();
  }

  // don't leave dangling pipes when there are errors.
  function onerror(er) {
    cleanup();
    if (EE.listenerCount(this, 'error') === 0) {
      throw er; // Unhandled stream error in pipe.
    }
  }

  source.on('error', onerror);
  dest.on('error', onerror);

  // remove all the event listeners that were added.
  function cleanup() {
    source.removeListener('data', ondata);
    dest.removeListener('drain', ondrain);

    source.removeListener('end', onend);
    source.removeListener('close', onclose);

    source.removeListener('error', onerror);
    dest.removeListener('error', onerror);

    source.removeListener('end', cleanup);
    source.removeListener('close', cleanup);

    dest.removeListener('close', cleanup);
  }

  source.on('end', cleanup);
  source.on('close', cleanup);

  dest.on('close', cleanup);

  dest.emit('pipe', source);

  // Allow for unix-like usage: A.pipe(B).pipe(C)
  return dest;
};


/***/ }),

/***/ "1Mc+":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_CountTo_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("QmiY");
/* harmony import */ var _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_CountTo_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_CountTo_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__);
/* harmony reexport (unknown) */ for(var __WEBPACK_IMPORT_KEY__ in _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_CountTo_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__) if(__WEBPACK_IMPORT_KEY__ !== 'default') (function(key) { __webpack_require__.d(__webpack_exports__, key, function() { return _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_CountTo_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__[key]; }) }(__WEBPACK_IMPORT_KEY__));
 /* harmony default export */ __webpack_exports__["default"] = (_node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_CountTo_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0___default.a); 

/***/ }),

/***/ "1P0Z":
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ "1ThP":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Popup_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("TPtX");
/* harmony reexport (unknown) */ for(var __WEBPACK_IMPORT_KEY__ in _Popup_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__) if(__WEBPACK_IMPORT_KEY__ !== 'default') (function(key) { __webpack_require__.d(__webpack_exports__, key, function() { return _Popup_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__[key]; }) }(__WEBPACK_IMPORT_KEY__));
/* harmony import */ var _node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("KHd+");
var render, staticRenderFns




/* normalize component */

var component = Object(_node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_1__[/* default */ "a"])(
  _Popup_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__["default"],
  render,
  staticRenderFns,
  false,
  null,
  null,
  null
  
)

/* harmony default export */ __webpack_exports__["default"] = (component.exports);

/***/ }),

/***/ "1tPa":
/***/ (function(module, exports, __webpack_require__) {

!function(e,t){ true?module.exports=t(__webpack_require__("AzSJ")):undefined}(this,function(e){return function(e){function t(i){if(n[i])return n[i].exports;var r=n[i]={i:i,l:!1,exports:{}};return e[i].call(r.exports,r,r.exports,t),r.l=!0,r.exports}var n={};return t.m=e,t.c=n,t.i=function(e){return e},t.d=function(e,n,i){t.o(e,n)||Object.defineProperty(e,n,{configurable:!1,enumerable:!0,get:i})},t.n=function(e){var n=e&&e.__esModule?function(){return e.default}:function(){return e};return t.d(n,"a",n),n},t.o=function(e,t){return Object.prototype.hasOwnProperty.call(e,t)},t.p="/",t(t.s=3)}([function(t,n){t.exports=e},function(e,t,n){"use strict";function i(e,t,n){return t in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(t,"__esModule",{value:!0});var r=n(0),o=function(e){return e&&e.__esModule?e:{default:e}}(r),s=window.videojs||o.default;"function"!=typeof Object.assign&&Object.defineProperty(Object,"assign",{value:function(e,t){if(null==e)throw new TypeError("Cannot convert undefined or null to object");for(var n=Object(e),i=1;i<arguments.length;i++){var r=arguments[i];if(null!=r)for(var o in r)Object.prototype.hasOwnProperty.call(r,o)&&(n[o]=r[o])}return n},writable:!0,configurable:!0});var a=["loadeddata","canplay","canplaythrough","play","pause","waiting","playing","ended","error"];t.default={name:"video-player",props:{start:{type:Number,default:0},crossOrigin:{type:String,default:""},playsinline:{type:Boolean,default:!1},customEventName:{type:String,default:"statechanged"},options:{type:Object,required:!0},events:{type:Array,default:function(){return[]}},globalOptions:{type:Object,default:function(){return{controls:!0,controlBar:{remainingTimeDisplay:!1,playToggle:{},progressControl:{},fullscreenToggle:{},volumeMenuButton:{inline:!1,vertical:!0}},techOrder:["html5"],plugins:{}}}},globalEvents:{type:Array,default:function(){return[]}}},data:function(){return{player:null,reseted:!0}},mounted:function(){this.player||this.initialize()},beforeDestroy:function(){this.player&&this.dispose()},methods:{initialize:function(){var e=this,t=Object.assign({},this.globalOptions,this.options);this.playsinline&&(this.$refs.video.setAttribute("playsinline",this.playsinline),this.$refs.video.setAttribute("webkit-playsinline",this.playsinline),this.$refs.video.setAttribute("x5-playsinline",this.playsinline),this.$refs.video.setAttribute("x5-video-player-type","h5"),this.$refs.video.setAttribute("x5-video-player-fullscreen",!1)),""!==this.crossOrigin&&(this.$refs.video.crossOrigin=this.crossOrigin,this.$refs.video.setAttribute("crossOrigin",this.crossOrigin));var n=function(t,n){t&&e.$emit(t,e.player),n&&e.$emit(e.customEventName,i({},t,n))};t.plugins&&delete t.plugins.__ob__;var r=this;this.player=s(this.$refs.video,t,function(){for(var e=this,t=a.concat(r.events).concat(r.globalEvents),i={},o=0;o<t.length;o++)"string"==typeof t[o]&&void 0===i[t[o]]&&function(t){i[t]=null,e.on(t,function(){n(t,!0)})}(t[o]);this.on("timeupdate",function(){n("timeupdate",this.currentTime())}),r.$emit("ready",this)})},dispose:function(e){var t=this;this.player&&this.player.dispose&&("Flash"!==this.player.techName_&&this.player.pause&&this.player.pause(),this.player.dispose(),this.player=null,this.$nextTick(function(){t.reseted=!1,t.$nextTick(function(){t.reseted=!0,t.$nextTick(function(){e&&e()})})}))}},watch:{options:{deep:!0,handler:function(e,t){var n=this;this.dispose(function(){e&&e.sources&&e.sources.length&&n.initialize()})}}}}},function(e,t,n){"use strict";Object.defineProperty(t,"__esModule",{value:!0});var i=n(1),r=n.n(i);for(var o in i)["default","default"].indexOf(o)<0&&function(e){n.d(t,e,function(){return i[e]})}(o);var s=n(5),a=n(4),l=a(r.a,s.a,!1,null,null,null);t.default=l.exports},function(e,t,n){"use strict";function i(e){return e&&e.__esModule?e:{default:e}}Object.defineProperty(t,"__esModule",{value:!0}),t.install=t.videoPlayer=t.videojs=void 0;var r=n(0),o=i(r),s=n(2),a=i(s),l=window.videojs||o.default,u=function(e,t){t&&(t.options&&(a.default.props.globalOptions.default=function(){return t.options}),t.events&&(a.default.props.globalEvents.default=function(){return t.events})),e.component(a.default.name,a.default)},d={videojs:l,videoPlayer:a.default,install:u};t.default=d,t.videojs=l,t.videoPlayer=a.default,t.install=u},function(e,t){e.exports=function(e,t,n,i,r,o){var s,a=e=e||{},l=typeof e.default;"object"!==l&&"function"!==l||(s=e,a=e.default);var u="function"==typeof a?a.options:a;t&&(u.render=t.render,u.staticRenderFns=t.staticRenderFns,u._compiled=!0),n&&(u.functional=!0),r&&(u._scopeId=r);var d;if(o?(d=function(e){e=e||this.$vnode&&this.$vnode.ssrContext||this.parent&&this.parent.$vnode&&this.parent.$vnode.ssrContext,e||"undefined"==typeof __VUE_SSR_CONTEXT__||(e=__VUE_SSR_CONTEXT__),i&&i.call(this,e),e&&e._registeredComponents&&e._registeredComponents.add(o)},u._ssrRegister=d):i&&(d=i),d){var c=u.functional,f=c?u.render:u.beforeCreate;c?(u._injectStyles=d,u.render=function(e,t){return d.call(t),f(e,t)}):u.beforeCreate=f?[].concat(f,d):[d]}return{esModule:s,exports:a,options:u}}},function(e,t,n){"use strict";var i=function(){var e=this,t=e.$createElement,n=e._self._c||t;return e.reseted?n("div",{staticClass:"video-player"},[n("video",{ref:"video",staticClass:"video-js"})]):e._e()},r=[],o={render:i,staticRenderFns:r};t.a=o}])});

/***/ }),

/***/ 2:
/***/ (function(module, exports) {

/* (ignored) */

/***/ }),

/***/ "284h":
/***/ (function(module, exports, __webpack_require__) {

var _typeof = __webpack_require__("cDf5");

function _getRequireWildcardCache() {
  if (typeof WeakMap !== "function") return null;
  var cache = new WeakMap();

  _getRequireWildcardCache = function _getRequireWildcardCache() {
    return cache;
  };

  return cache;
}

function _interopRequireWildcard(obj) {
  if (obj && obj.__esModule) {
    return obj;
  }

  if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
    return {
      "default": obj
    };
  }

  var cache = _getRequireWildcardCache();

  if (cache && cache.has(obj)) {
    return cache.get(obj);
  }

  var newObj = {};
  var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;

  for (var key in obj) {
    if (Object.prototype.hasOwnProperty.call(obj, key)) {
      var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;

      if (desc && (desc.get || desc.set)) {
        Object.defineProperty(newObj, key, desc);
      } else {
        newObj[key] = obj[key];
      }
    }
  }

  newObj["default"] = obj;

  if (cache) {
    cache.set(obj, newObj);
  }

  return newObj;
}

module.exports = _interopRequireWildcard;

/***/ }),

/***/ "2EDF":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_Iframe_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("kokw");
/* harmony import */ var _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_Iframe_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_Iframe_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__);
/* harmony reexport (unknown) */ for(var __WEBPACK_IMPORT_KEY__ in _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_Iframe_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__) if(__WEBPACK_IMPORT_KEY__ !== 'default') (function(key) { __webpack_require__.d(__webpack_exports__, key, function() { return _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_Iframe_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__[key]; }) }(__WEBPACK_IMPORT_KEY__));
 /* harmony default export */ __webpack_exports__["default"] = (_node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_Iframe_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0___default.a); 

/***/ }),

/***/ "2Vb1":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _interopRequireWildcard = __webpack_require__("284h");

var _interopRequireDefault = __webpack_require__("TqRt");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _classCallCheck2 = _interopRequireDefault(__webpack_require__("lwsE"));

var _createClass2 = _interopRequireDefault(__webpack_require__("W8MJ"));

var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__("a1gu"));

var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__("Nsbk"));

var _inherits2 = _interopRequireDefault(__webpack_require__("7W2i"));

var _Events2 = __webpack_require__("peoL");

var _util = __webpack_require__("e7LN");

var _epsg = _interopRequireDefault(__webpack_require__("hzAs"));

var convert = _interopRequireWildcard(__webpack_require__("xRo1"));

var DEFAULT_WELLKNOWNSCALESET = ['GoogleCRS84Quad', 'GoogleMapsCompatible'];
var MB_SCALEDENOMINATOR_3857 = ['559082264.0287178', '279541132.0143589', '139770566.0071794', '69885283.00358972', '34942641.50179486', '17471320.75089743', '8735660.375448715', '4367830.1877224357', '2183915.093862179', '1091957.546931089', '545978.7734655447', '272989.7734655447', '272989.3867327723', '136494.6933663862', '68247.34668319309', '34123.67334159654', '17061.83667079827', '8530.918335399136', '4265.459167699568', '2132.729583849784'];
var MB_SCALEDENOMINATOR_4326 = ['5.590822640287176E8', '2.795411320143588E8', '1.397705660071794E8', '6.98852830035897E7', '3.494264150179485E7', '1.7471320750897426E7', '8735660.375448713', '4367830.187724357', '2183915.0938621783', '1091957.5469310891', '545978.7734655446', '272989.3867327723', '136494.69336638614', '68247.34668319307', '34123.673341596535', '17061.836670798268', '8530.918335399134'];

var WebMapService =
/*#__PURE__*/
function (_Events) {
  (0, _inherits2.default)(WebMapService, _Events);

  function WebMapService(mapId) {
    var _this;

    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    (0, _classCallCheck2.default)(this, WebMapService);
    _this = (0, _possibleConstructorReturn2.default)(this, (0, _getPrototypeOf2.default)(WebMapService).call(this));
    _this.mapId = mapId;
    _this.serverUrl = options.serverUrl || 'https://www.supermapol.com';
    _this.accessToken = options.accessToken;
    _this.accessKey = options.accessKey;
    _this.tiandituKey = options.tiandituKey || '';
    _this.withCredentials = options.withCredentials || false;
    _this.excludePortalProxyUrl = options.excludePortalProxyUrl;
    return _this;
  }

  (0, _createClass2.default)(WebMapService, [{
    key: "setMapId",
    value: function setMapId(mapId) {
      this.mapId = mapId;
    }
  }, {
    key: "setServerUrl",
    value: function setServerUrl(serverUrl) {
      this.serverUrl = serverUrl;
    }
  }, {
    key: "setWithCredentials",
    value: function setWithCredentials(withCredentials) {
      this.withCredentials = withCredentials;
    }
  }, {
    key: "handleServerUrl",
    value: function handleServerUrl(serverUrl) {
      var urlArr = serverUrl.split('');

      if (urlArr[urlArr.length - 1] !== '/') {
        serverUrl += '/';
      }

      this.serverUrl = serverUrl;
      return serverUrl;
    }
  }, {
    key: "getMapInfo",
    value: function getMapInfo() {
      var _this2 = this;

      var mapUrl = this._handleMapUrl();

      return new Promise(function (resolve, reject) {
        SuperMap.FetchRequest.get(mapUrl, null, {
          withCredentials: _this2.withCredentials
        }).then(function (response) {
          return response.json();
        }).then(function (mapInfo) {
          if (mapInfo && mapInfo.succeed === false) {
            var error = {
              message: mapInfo && mapInfo.error && mapInfo.error.errorMsg
            };
            reject(error);
            return;
          }

          mapInfo.mapParams = {
            title: mapInfo.title,
            description: mapInfo.description
          };
          resolve(mapInfo);
        }).catch(function (error) {
          reject(error);
        });
      });
    }
  }, {
    key: "getLayerFeatures",
    value: function getLayerFeatures(type, layer, baseProjection) {
      var pro;

      switch (type) {
        case 'hosted':
          pro = this._getFeaturesFromHosted(layer, baseProjection);
          break;

        case 'rest_data':
          pro = this._getFeaturesFromRestData(layer);
          break;

        case 'rest_map':
          pro = this._getFeaturesFromRestMap(layer);
          break;

        case 'dataflow':
          pro = this._getFeaturesFromDataflow(layer);
          break;
      }

      return pro;
    }
  }, {
    key: "getWmtsInfo",
    value: function getWmtsInfo(mapInfo) {
      var _this3 = this;

      return new Promise(function (resolve, reject) {
        var isMatched = false;
        var matchMaxZoom = 22;
        SuperMap.FetchRequest.get(mapInfo.url, null, {
          withCredentials: false,
          withoutFormatSuffix: true
        }).then(function (response) {
          return response.text();
        }).then(function (capabilitiesText) {
          var converts = convert || window.convert;
          var tileMatrixSet = JSON.parse(converts.xml2json(capabilitiesText, {
            compact: true,
            spaces: 4
          })).Capabilities.Contents.TileMatrixSet;

          for (var i = 0; i < tileMatrixSet.length; i++) {
            if (tileMatrixSet[i]['ows:Identifier'] && tileMatrixSet[i]['ows:Identifier']['_text'] === mapInfo.tileMatrixSet) {
              if (DEFAULT_WELLKNOWNSCALESET.includes(tileMatrixSet[i]['WellKnownScaleSet']['_text'])) {
                isMatched = true;
              } else if (tileMatrixSet[i]['WellKnownScaleSet'] && tileMatrixSet[i]['WellKnownScaleSet']['_text'] === 'Custom') {
                var matchedScaleDenominator = [];
                var defaultCRSScaleDenominators = _this3.map.crs === 'EPSG:3857' ? MB_SCALEDENOMINATOR_3857 : MB_SCALEDENOMINATOR_4326;

                for (var j = 0, len = defaultCRSScaleDenominators.length; j < len; j++) {
                  if (!tileMatrixSet[i].TileMatrix[j]) {
                    break;
                  }

                  if (defaultCRSScaleDenominators[j] !== tileMatrixSet[i].TileMatrix[j]['ScaleDenominator']['_text']) {
                    break;
                  }

                  matchedScaleDenominator.push(defaultCRSScaleDenominators[j]);
                }

                matchMaxZoom = matchedScaleDenominator.length - 1;

                if (matchedScaleDenominator.length !== 0) {
                  isMatched = true;
                } else {
                  throw Error('TileMatrixSetNotSuppport');
                }
              } else {
                throw Error('TileMatrixSetNotSuppport');
              }
            }
          }

          resolve({
            isMatched: isMatched,
            matchMaxZoom: matchMaxZoom
          });
        }).catch(function (error) {
          reject(error);
        });
      });
    }
  }, {
    key: "_getFeaturesFromHosted",
    value: function _getFeaturesFromHosted(layer, baseProjection) {
      var dataSource = layer.dataSource,
          layerType = layer.layerType;
      var serverId = dataSource ? dataSource.serverId : layer.serverId;

      if (!serverId) {
        return new Promise(function (resolve, reject) {
          resolve({
            type: 'noServerId'
          });
        });
      }

      var getDataFromIportal = layerType === 'MARKER' || dataSource && (!dataSource.accessType || dataSource.accessType === 'DIRECT');

      if (getDataFromIportal) {
        return this._getDataFromIportal(serverId);
      } else {
        return this._getDataFromHosted({
          layer: layer,
          serverId: serverId,
          baseProjection: baseProjection
        });
      }
    }
  }, {
    key: "_getFeaturesFromRestData",
    value: function _getFeaturesFromRestData(layer) {
      var _this4 = this;

      var features;
      var dataSource = layer.dataSource;
      return new Promise(function (resolve, reject) {
        _this4._getFeatureBySQL(dataSource.url, [dataSource.dataSourseName || layer.name], function (result) {
          features = _this4.parseGeoJsonData2Feature({
            allDatas: {
              features: result.result.features.features
            }
          });
          resolve({
            type: 'feature',
            features: features
          });
        }, function (err) {
          reject(err);
        });
      });
    }
  }, {
    key: "_getFeaturesFromRestMap",
    value: function _getFeaturesFromRestMap(layer) {
      var _this5 = this;

      return new Promise(function (resolve, reject) {
        _this5._queryFeatureBySQL(layer.dataSource.url, layer.dataSource.layerName, function (result) {
          var recordsets = result && result.result.recordsets;
          var recordset = recordsets && recordsets[0];
          var attributes = recordset.fields;

          if (recordset && attributes) {
            var fileterAttrs = [];

            for (var i in attributes) {
              var value = attributes[i];

              if (value.indexOf('Sm') !== 0 || value === 'SmID') {
                fileterAttrs.push(value);
              }
            }

            _this5._getFeatures(fileterAttrs, layer, function (features) {
              resolve({
                type: 'feature',
                features: features
              });
            }, function (err) {
              reject(err);
            });
          }
        }, function (err) {
          reject(err);
        }, 'smid=1');
      });
    }
  }, {
    key: "_queryFeatureBySQL",
    value: function _queryFeatureBySQL(url, layerName, _processCompleted, processFaild, attributeFilter, fields, epsgCode, startRecord, recordLength, onlyAttribute) {
      var queryBySQLParams = this._getQueryFeaturesParam(layerName, attributeFilter, fields, epsgCode, startRecord, recordLength, onlyAttribute);

      var queryBySQLService = new SuperMap.QueryBySQLService(url, {
        eventListeners: {
          processCompleted: function processCompleted(data) {
            _processCompleted && _processCompleted(data);
          },
          processFailed: function processFailed(data) {
            processFaild && processFaild(data);
          }
        }
      });
      queryBySQLService.processAsync(queryBySQLParams);
    }
  }, {
    key: "_getFeatures",
    value: function _getFeatures(fields, layerInfo, resolve, reject) {
      var _this6 = this;

      var source = layerInfo.dataSource;

      this._queryFeatureBySQL(source.url, source.layerName, function (result) {
        var recordsets = result.result.recordsets[0];
        var features = recordsets.features.features;

        var featuresObj = _this6.parseGeoJsonData2Feature({
          allDatas: {
            features: features
          }
        });

        resolve(featuresObj);
      }, function (err) {
        reject(err);
      }, null, fields);
    }
  }, {
    key: "_getQueryFeaturesParam",
    value: function _getQueryFeaturesParam(layerName, attributeFilter, fields, epsgCode, startRecord, recordLength, onlyAttribute) {
      var queryParam = new SuperMap.FilterParameter({
        name: layerName,
        attributeFilter: attributeFilter
      });

      if (fields) {
        queryParam.fields = fields;
      }

      var params = {
        queryParams: [queryParam]
      };

      if (onlyAttribute) {
        params.queryOption = SuperMap.QueryOption.ATTRIBUTE;
      }

      startRecord && (params.startRecord = startRecord);
      recordLength && (params.expectCount = recordLength);

      if (epsgCode) {
        params.prjCoordSys = {
          epsgCode: epsgCode
        };
      }

      var queryBySQLParams = new SuperMap.QueryBySQLParameters(params);
      return queryBySQLParams;
    }
  }, {
    key: "_getFeaturesFromDataflow",
    value: function _getFeaturesFromDataflow(layer) {
      var _this7 = this;

      return new Promise(function (resolve, reject) {
        _this7._getDataflowInfo(layer, function () {
          resolve({
            type: 'dataflow'
          });
        }, function (e) {
          reject(e);
        });
      });
    }
  }, {
    key: "_getDataflowInfo",
    value: function _getDataflowInfo(layerInfo, success, faild) {
      var url = layerInfo.url,
          token;
      var requestUrl = "".concat(url, ".json");

      if (layerInfo.credential && layerInfo.credential.token) {
        token = layerInfo.credential.token;
        requestUrl += "?token=".concat(token);
      }

      SuperMap.FetchRequest.get(requestUrl).then(function (response) {
        return response.json();
      }).then(function (result) {
        if (result && result.featureMetaData) {
          layerInfo.featureType = result.featureMetaData.featureType.toUpperCase();
          layerInfo.dataSource = {
            dataTypes: {}
          };

          if (result.featureMetaData.fieldInfos && result.featureMetaData.fieldInfos.length > 0) {
            result.featureMetaData.fieldInfos.forEach(function (data) {
              var name = data.name.trim();

              if (data.type === 'TEXT') {
                layerInfo.dataSource.dataTypes[name] = 'STRING';
              } else if (['DOUBLE', 'INT', 'FLOAT', 'LONG', 'SHORT'].includes(data.type)) {
                layerInfo.dataSource.dataTypes[name] = 'NUMBER';
              } else {
                layerInfo.dataSource.dataTypes[name] = 'UNKNOWN';
              }
            });
          }

          layerInfo.wsUrl = result.urls[0].url;
          layerInfo.name = result.urls[0].url.split('iserver/services/')[1].split('/dataflow')[0];
          success();
        } else {
          faild();
        }
      }).catch(function () {
        faild();
      });
    }
  }, {
    key: "getDatasourceType",
    value: function getDatasourceType(layer) {
      var dataSource = layer.dataSource,
          layerType = layer.layerType;

      if (dataSource && dataSource.type === 'SAMPLE_DATA') {
        return dataSource.type;
      }

      var type;
      var isHosted = dataSource && dataSource.serverId || layerType === 'MARKER' || layerType === 'HOSTED_TILE';
      var isTile = layerType === 'SUPERMAP_REST' || layerType === 'TILE' || layerType === 'WMS' || layerType === 'WMTS';

      if (isHosted) {
        type = 'hosted';
      } else if (isTile) {
        type = 'tile';
      } else if (dataSource && dataSource.type === 'REST_DATA') {
        type = 'rest_data';
      } else if (dataSource && dataSource.type === 'REST_MAP' && dataSource.url) {
        type = 'rest_map';
      } else if (layerType === 'DATAFLOW_POINT_TRACK' || layerType === 'DATAFLOW_HEAT') {
        type = 'dataflow';
      }

      return type;
    }
  }, {
    key: "getFeatureProperties",
    value: function getFeatureProperties(features) {
      var properties = [];

      if (features && features.length) {
        features.forEach(function (feature) {
          var property = feature.properties;
          property && properties.push(property);
        });
      }

      return properties;
    }
  }, {
    key: "parseGeoJsonData2Feature",
    value: function parseGeoJsonData2Feature(metaData) {
      var allFeatures = metaData.allDatas.features;
      var features = [];

      for (var i = 0, len = allFeatures.length; i < len; i++) {
        var feature = allFeatures[i];
        var coordinate = feature.geometry.coordinates;

        if (allFeatures[i].geometry.type === 'Point') {
          if (allFeatures[i].properties) {
            allFeatures[i].properties.lon = coordinate[0];
            allFeatures[i].properties.lat = coordinate[1];
          }
        }

        feature.properties['index'] = i + '';
        features.push(feature);
      }

      return features;
    }
  }, {
    key: "getEpsgcodeWkt",
    value: function getEpsgcodeWkt(epsgCode) {
      return _epsg.default[epsgCode];
    }
  }, {
    key: "_getDataFromIportal",
    value: function _getDataFromIportal(serverId) {
      var _this8 = this;

      var features;
      var url = "".concat(this.serverUrl, "web/datas/").concat(serverId, "/content.json?pageSize=9999999&currentPage=1");

      if (this.accessToken) {
        url = "".concat(url, "&").concat(this.accessKey, "=").concat(this.accessToken);
      }

      return new Promise(function (resolve, reject) {
        SuperMap.FetchRequest.get(url, null, {
          withCredentials: _this8.withCredentials
        }).then(function (response) {
          return response.json();
        }).then(function (data) {
          if (data.succeed === false) {
            reject(data.error);
          }

          if (data && data.type) {
            if (data.type === 'JSON' || data.type === 'GEOJSON') {
              data.content = JSON.parse(data.content.trim());
              features = _this8._formatGeoJSON(data.content);
            } else if (data.type === 'EXCEL' || data.type === 'CSV') {
              features = _this8._excelData2Feature(data.content);
            }

            resolve({
              type: 'feature',
              features: features
            });
          }
        }).catch(function (error) {
          reject(error);
        });
      });
    }
  }, {
    key: "_getDataFromHosted",
    value: function _getDataFromHosted(_ref) {
      var _this9 = this;

      var layer = _ref.layer,
          serverId = _ref.serverId,
          baseProjection = _ref.baseProjection;
      var isMapService = layer.layerType === 'HOSTED_TILE';
      return new Promise(function (resolve, reject) {
        _this9._checkUploadToRelationship(serverId).then(function (result) {
          if (result && result.length > 0) {
            var datasetName = result[0].name,
                featureType = result[0].type.toUpperCase();

            _this9._getDataService(serverId, datasetName).then(function (data) {
              var dataItemServices = data.dataItemServices;

              if (dataItemServices.length === 0) {
                reject('noDataServices');
              }

              var param = {
                layer: layer,
                dataItemServices: dataItemServices,
                datasetName: datasetName,
                featureType: featureType,
                resolve: resolve,
                reject: reject,
                baseProjection: baseProjection
              };

              if (isMapService) {
                var dataService = dataItemServices.filter(function (info) {
                  return info && info.serviceType === 'RESTDATA';
                })[0];

                _this9._isMvt(dataService.address, datasetName, baseProjection).then(function (info) {
                  _this9._getServiceInfoFromLayer(param, info);
                }).catch(function () {
                  _this9._getServiceInfoFromLayer(param);
                });
              } else {
                _this9._getServiceInfoFromLayer(param);
              }
            });
          } else {
            reject('resultIsEmpty');
          }
        }).catch(function (error) {
          reject(error);
        });
      });
    }
  }, {
    key: "_isMvt",
    value: function _isMvt(serviceUrl, datasetName, baseProjection) {
      return this._getDatasetsInfo(serviceUrl, datasetName).then(function (info) {
        if (info.epsgCode == baseProjection.split('EPSG:')[1]) {
          return SuperMap.FetchRequest.get("".concat(info.url, "/tilefeature.mvt")).then(function (response) {
            return response.json();
          }).then(function (result) {
            info.isMvt = result.error && result.error.code === 400;
            return info;
          }).catch(function () {
            return info;
          });
        }

        return info;
      });
    }
  }, {
    key: "_getServiceInfoFromLayer",
    value: function _getServiceInfoFromLayer(_ref2, info) {
      var _this10 = this;

      var layer = _ref2.layer,
          dataItemServices = _ref2.dataItemServices,
          datasetName = _ref2.datasetName,
          featureType = _ref2.featureType,
          resolve = _ref2.resolve,
          reject = _ref2.reject,
          baseProjection = _ref2.baseProjection;
      var isMapService = info ? !info.isMvt : layer.layerType === 'HOSTED_TILE',
          isAdded = false;
      dataItemServices.forEach(function (service, index) {
        if (isAdded) {
          return;
        }

        if (service && isMapService && service.serviceType === 'RESTMAP') {
          isAdded = true;

          _this10._getTileLayerInfo(service.address, baseProjection).then(function (restMaps) {
            resolve({
              type: 'restMap',
              restMaps: restMaps
            });
          });
        } else if (service && !isMapService && service.serviceType === 'RESTDATA') {
          if (info && info.isMvt) {
            resolve({
              type: 'mvt',
              info: info,
              featureType: featureType
            });
          } else {
            isAdded = true;

            _this10._getDatasources(service.address).then(function (datasourceName) {
              layer.dataSource.dataSourceName = datasourceName + ':' + datasetName;
              layer.dataSource.url = "".concat(service.address, "/data");

              _this10._getFeatureBySQL(layer.dataSource.url, [layer.dataSource.dataSourceName || layer.name], function (result) {
                var features = _this10.parseGeoJsonData2Feature({
                  allDatas: {
                    features: result.result.features.features
                  }
                });

                resolve({
                  type: 'feature',
                  features: features
                });
              }, function (err) {
                reject(err);
              });
            }, function (err) {
              reject(err);
            });
          }
        }
      }, this);

      if (!isAdded) {
        reject('noService');
      }
    }
  }, {
    key: "_getDatasetsInfo",
    value: function _getDatasetsInfo(serviceUrl, datasetName) {
      return this._getDatasources(serviceUrl).then(function (datasourceName) {
        var url = "".concat(serviceUrl, "/data/datasources/").concat(datasourceName, "/datasets/").concat(datasetName);
        return SuperMap.FetchRequest.get(url).then(function (response) {
          return response.json();
        }).then(function (datasetsInfo) {
          return {
            epsgCode: datasetsInfo.datasetInfo.prjCoordSys.epsgCode,
            bounds: datasetsInfo.datasetInfo.bounds,
            datasourceName: datasourceName,
            datasetName: datasetName,
            url: url
          };
        });
      });
    }
  }, {
    key: "_getDatasources",
    value: function _getDatasources(url) {
      return SuperMap.FetchRequest.get("".concat(url, "/data/datasources.json")).then(function (response) {
        return response.json();
      }).then(function (datasource) {
        if (datasource.code === 401) {
          throw Error(datasource.errorMsg);
        }

        var datasourceNames = datasource.datasourceNames;
        return datasourceNames[0];
      });
    }
  }, {
    key: "_getDataService",
    value: function _getDataService(fileId, datasetName) {
      return SuperMap.FetchRequest.get("".concat(this.serverUrl, "web/datas/").concat(fileId, ".json"), null, {
        withCredentials: this.withCredentials
      }).then(function (response) {
        return response.json();
      }).then(function (result) {
        result.fileId = fileId;
        result.datasetName = datasetName;
        return result;
      });
    }
  }, {
    key: "_checkUploadToRelationship",
    value: function _checkUploadToRelationship(fileId) {
      return SuperMap.FetchRequest.get("".concat(this.serverUrl, "web/datas/").concat(fileId, "/datasets.json"), null, {
        withCredentials: this.withCredentials
      }).then(function (response) {
        return response.json();
      }).then(function (result) {
        return result;
      });
    }
  }, {
    key: "_handleMapUrl",
    value: function _handleMapUrl() {
      var mapUrl = this.serverUrl + 'web/maps/' + this.mapId + '/map';

      if (this.accessToken || this.accessKey) {
        mapUrl +=  true ? 'token=' + this.accessToken : undefined;
      }

      var filter = 'getUrlResource.json?url=';

      if (this.excludePortalProxyUrl && this.serverUrl.indexOf(filter) > -1) {
        var urlArray = this.serverUrl.split(filter);

        if (urlArray.length > 1) {
          mapUrl = urlArray[0] + filter + this.serverUrl + 'web/maps/' + this.mapId + '/map.json';
        }
      }

      mapUrl = mapUrl.indexOf('.json') === -1 ? "".concat(mapUrl, ".json") : mapUrl;
      return mapUrl;
    }
  }, {
    key: "_formatGeoJSON",
    value: function _formatGeoJSON(data) {
      var features = data.features;
      features.forEach(function (row, index) {
        row.properties['index'] = index;
      });
      return features;
    }
  }, {
    key: "_excelData2Feature",
    value: function _excelData2Feature(dataContent) {
      var fieldCaptions = dataContent.colTitles;
      var xfieldIndex = -1;
      var yfieldIndex = -1;

      for (var i = 0, len = fieldCaptions.length; i < len; i++) {
        if ((0, _util.isXField)(fieldCaptions[i])) {
          xfieldIndex = i;
        }

        if ((0, _util.isYField)(fieldCaptions[i])) {
          yfieldIndex = i;
        }
      }

      var features = [];

      for (var _i = 0, _len = dataContent.rows.length; _i < _len; _i++) {
        var row = dataContent.rows[_i];
        var x = Number(row[xfieldIndex]);
        var y = Number(row[yfieldIndex]);
        var attributes = {};

        for (var index in dataContent.colTitles) {
          var key = dataContent.colTitles[index];
          attributes[key] = dataContent.rows[_i][index];
        }

        attributes['index'] = _i + '';
        var feature = {
          type: 'Feature',
          geometry: {
            type: 'Point',
            coordinates: [x, y]
          },
          properties: attributes
        };
        features.push(feature);
      }

      return features;
    }
  }, {
    key: "_getTileLayerInfo",
    value: function _getTileLayerInfo(url, baseProjection) {
      var _this11 = this;

      var proxyUrl = this.serverUrl + 'apps/viewer/getUrlResource.json?url=';
      var requestUrl = proxyUrl + encodeURIComponent(url);
      var epsgCode = baseProjection.split('EPSG:')[1];
      return SuperMap.FetchRequest.get("".concat(requestUrl, "/maps.json"), null, {
        withCredentials: this.withCredentials
      }).then(function (response) {
        return response.json();
      }).then(function (mapInfo) {
        var promises = [];

        if (mapInfo) {
          mapInfo.forEach(function (info) {
            var promise = SuperMap.FetchRequest.get("".concat(proxyUrl).concat(info.path, ".json?prjCoordSys=").concat(JSON.stringify({
              epsgCode: epsgCode
            })), null, {
              withCredentials: _this11.withCredentials
            }).then(function (response) {
              return response.json();
            }).then(function (restMapInfo) {
              restMapInfo.url = info.path;
              return restMapInfo;
            });
            promises.push(promise);
          });
        }

        return Promise.all(promises).then(function (allRestMaps) {
          return allRestMaps;
        });
      });
    }
  }, {
    key: "_getFeatureBySQL",
    value: function _getFeatureBySQL(url, datasetNames, _processCompleted2, processFaild) {
      var getFeatureParam, getFeatureBySQLService, getFeatureBySQLParams;
      getFeatureParam = new SuperMap.FilterParameter({
        name: datasetNames.join().replace(':', '@'),
        attributeFilter: 'SMID > 0'
      });
      getFeatureBySQLParams = new SuperMap.GetFeaturesBySQLParameters({
        queryParameter: getFeatureParam,
        datasetNames: datasetNames,
        fromIndex: 0,
        toIndex: -1,
        maxFeatures: -1,
        returnContent: true
      });
      var options = {
        eventListeners: {
          processCompleted: function processCompleted(getFeaturesEventArgs) {
            _processCompleted2 && _processCompleted2(getFeaturesEventArgs);
          },
          processFailed: function processFailed(e) {
            processFaild && processFaild(e);
          }
        }
      };
      getFeatureBySQLService = new SuperMap.GetFeaturesBySQLService(url, options);
      getFeatureBySQLService.processAsync(getFeatureBySQLParams);
    }
  }]);
  return WebMapService;
}(_Events2.Events);

exports.default = WebMapService;

/***/ }),

/***/ "2Zn6":
/***/ (function(module) {

module.exports = JSON.parse("[{\"title\":\"经典深色\",\"label\":\"dark\",\"textColor\":\"#fff\",\"background\":\"rgba(0,0,0,0.6)\",\"colorGroup\":[\"#dd6b66\",\"#759aa0\",\"#e69d87\",\"#8dc1a9\",\"#ea7e53\"]},{\"title\":\"经典浅色\",\"label\":\"light\",\"textColor\":\"#333\",\"background\":\"rgba(255, 255, 255,0.6)\",\"colorGroup\":[\"#3fb1e3\",\"#6be6c1\",\"#626c91\",\"#a0a7e6\",\"#c4ebad\"]},{\"title\":\"绿色渐变\",\"label\":\"green-g\",\"textColor\":\"#fff\",\"background\":\"rgba(0,0,0,0.6)\",\"colorGroup\":[\"#064049\",\"#165A65\",\"#1F717F\",\"#3097AB\",\"#9AEAF4\"]},{\"title\":\"蓝色渐变\",\"label\":\"blue-g\",\"textColor\":\"#fff\",\"background\":\"rgba(0,0,0,0.6)\",\"colorGroup\":[\"#243BCC\",\"#1C55FF\",\"#0C75FF\",\"#338FFF\",\"#00CDF1\"]},{\"title\":\"橙红渐变\",\"label\":\"red-g\",\"textColor\":\"#fff\",\"background\":\"rgba(0,0,0,0.6)\",\"colorGroup\":[\"#770000\",\"#882241\",\"#BE3144\",\"#F05940\",\"#FF8417\"]},{\"title\":\"紫色渐变\",\"label\":\"purple-g\",\"textColor\":\"#fff\",\"background\":\"rgba(0,0,0,0.6)\",\"colorGroup\":[\"#2F2AA4\",\"#5432D3\",\"#8B3B86\",\"#9740B1\",\"#7B6CF5\"]},{\"title\":\"深蓝黑色\",\"label\":\"bluedark-dark\",\"textColor\":\"#fff\",\"background\":\"rgba(0,0,0,0.6)\",\"colorGroup\":[\"#15D1F2\",\"#499BFF\",\"#2C61FF\",\"#243BCC\",\"#67A9FF\"]},{\"title\":\"墨绿黑色\",\"label\":\"green-dark\",\"textColor\":\"#fff\",\"background\":\"rgba(0,0,0,0.6)\",\"colorGroup\":[\"#2D808D\",\"#53A8B6\",\"#7AC2D0\",\"#BCE4E9\",\"#F1FDFF\"]},{\"title\":\"浅蓝黑色\",\"label\":\"blue-dark\",\"textColor\":\"#fff\",\"background\":\"rgba(0,0,0,0.6)\",\"colorGroup\":[\"#00E9FF\",\"#BBE7FF\",\"#6AE5C1\",\"#46ABFF\",\"#363EFF\"]},{\"title\":\"浅灰黑色\",\"label\":\"grey-dark\",\"textColor\":\"#fff\",\"background\":\"rgba(0,0,0,0.6)\",\"colorGroup\":[\"#52606D\",\"#8894A0\",\"#BACBDB\",\"#D3DDE8\",\"#F2F5F8\"]},{\"title\":\"深紫黑色\",\"label\":\"purple-dark\",\"textColor\":\"#fff\",\"background\":\"rgba(0,0,0,0.6)\",\"colorGroup\":[\"#7B6CF6\",\"#5432D3\",\"#241F92\",\"#8B3B86\",\"#E6A5FF\"]},{\"title\":\"深蓝白色\",\"label\":\"blue-light\",\"textColor\":\"#000\",\"background\":\"rgba(255,255,255,0.6)\",\"colorGroup\":[\"#243BCC\",\"#2C61FF\",\"#499BFF\",\"#15D1F2\",\"#67A9FF\"]},{\"title\":\"深红白色\",\"label\":\"red-light\",\"textColor\":\"#000\",\"background\":\"rgba(255,255,255,0.6)\",\"colorGroup\":[\"#F05940\",\"#BE3144\",\"#882241\",\"#770000\",\"#FF8418\"]}]");

/***/ }),

/***/ "2a28":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Text_vue_vue_type_template_id_d0243d1c___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("72Xp");
/* harmony import */ var _Text_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("ekee");
/* harmony reexport (unknown) */ for(var __WEBPACK_IMPORT_KEY__ in _Text_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_1__) if(__WEBPACK_IMPORT_KEY__ !== 'default') (function(key) { __webpack_require__.d(__webpack_exports__, key, function() { return _Text_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_1__[key]; }) }(__WEBPACK_IMPORT_KEY__));
/* harmony import */ var _node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("KHd+");





/* normalize component */

var component = Object(_node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_2__[/* default */ "a"])(
  _Text_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_1__["default"],
  _Text_vue_vue_type_template_id_d0243d1c___WEBPACK_IMPORTED_MODULE_0__[/* render */ "a"],
  _Text_vue_vue_type_template_id_d0243d1c___WEBPACK_IMPORTED_MODULE_0__[/* staticRenderFns */ "b"],
  false,
  null,
  null,
  null
  
)

/* harmony default export */ __webpack_exports__["default"] = (component.exports);

/***/ }),

/***/ "2oH+":
/***/ (function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(global, module) {/**
 * Lodash (Custom Build) <https://lodash.com/>
 * Build: `lodash modularize exports="npm" -o ./`
 * Copyright OpenJS Foundation and other contributors <https://openjsf.org/>
 * Released under MIT license <https://lodash.com/license>
 * Based on Underscore.js 1.8.3 <http://underscorejs.org/LICENSE>
 * Copyright Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
 */

/** Used as the size to enable large array optimizations. */
var LARGE_ARRAY_SIZE = 200;

/** Used to stand-in for `undefined` hash values. */
var HASH_UNDEFINED = '__lodash_hash_undefined__';

/** Used to detect hot functions by number of calls within a span of milliseconds. */
var HOT_COUNT = 800,
    HOT_SPAN = 16;

/** Used as references for various `Number` constants. */
var MAX_SAFE_INTEGER = 9007199254740991;

/** `Object#toString` result references. */
var argsTag = '[object Arguments]',
    arrayTag = '[object Array]',
    asyncTag = '[object AsyncFunction]',
    boolTag = '[object Boolean]',
    dateTag = '[object Date]',
    errorTag = '[object Error]',
    funcTag = '[object Function]',
    genTag = '[object GeneratorFunction]',
    mapTag = '[object Map]',
    numberTag = '[object Number]',
    nullTag = '[object Null]',
    objectTag = '[object Object]',
    proxyTag = '[object Proxy]',
    regexpTag = '[object RegExp]',
    setTag = '[object Set]',
    stringTag = '[object String]',
    undefinedTag = '[object Undefined]',
    weakMapTag = '[object WeakMap]';

var arrayBufferTag = '[object ArrayBuffer]',
    dataViewTag = '[object DataView]',
    float32Tag = '[object Float32Array]',
    float64Tag = '[object Float64Array]',
    int8Tag = '[object Int8Array]',
    int16Tag = '[object Int16Array]',
    int32Tag = '[object Int32Array]',
    uint8Tag = '[object Uint8Array]',
    uint8ClampedTag = '[object Uint8ClampedArray]',
    uint16Tag = '[object Uint16Array]',
    uint32Tag = '[object Uint32Array]';

/**
 * Used to match `RegExp`
 * [syntax characters](http://ecma-international.org/ecma-262/7.0/#sec-patterns).
 */
var reRegExpChar = /[\\^$.*+?()[\]{}|]/g;

/** Used to detect host constructors (Safari). */
var reIsHostCtor = /^\[object .+?Constructor\]$/;

/** Used to detect unsigned integer values. */
var reIsUint = /^(?:0|[1-9]\d*)$/;

/** Used to identify `toStringTag` values of typed arrays. */
var typedArrayTags = {};
typedArrayTags[float32Tag] = typedArrayTags[float64Tag] =
typedArrayTags[int8Tag] = typedArrayTags[int16Tag] =
typedArrayTags[int32Tag] = typedArrayTags[uint8Tag] =
typedArrayTags[uint8ClampedTag] = typedArrayTags[uint16Tag] =
typedArrayTags[uint32Tag] = true;
typedArrayTags[argsTag] = typedArrayTags[arrayTag] =
typedArrayTags[arrayBufferTag] = typedArrayTags[boolTag] =
typedArrayTags[dataViewTag] = typedArrayTags[dateTag] =
typedArrayTags[errorTag] = typedArrayTags[funcTag] =
typedArrayTags[mapTag] = typedArrayTags[numberTag] =
typedArrayTags[objectTag] = typedArrayTags[regexpTag] =
typedArrayTags[setTag] = typedArrayTags[stringTag] =
typedArrayTags[weakMapTag] = false;

/** Detect free variable `global` from Node.js. */
var freeGlobal = typeof global == 'object' && global && global.Object === Object && global;

/** Detect free variable `self`. */
var freeSelf = typeof self == 'object' && self && self.Object === Object && self;

/** Used as a reference to the global object. */
var root = freeGlobal || freeSelf || Function('return this')();

/** Detect free variable `exports`. */
var freeExports =  true && exports && !exports.nodeType && exports;

/** Detect free variable `module`. */
var freeModule = freeExports && typeof module == 'object' && module && !module.nodeType && module;

/** Detect the popular CommonJS extension `module.exports`. */
var moduleExports = freeModule && freeModule.exports === freeExports;

/** Detect free variable `process` from Node.js. */
var freeProcess = moduleExports && freeGlobal.process;

/** Used to access faster Node.js helpers. */
var nodeUtil = (function() {
  try {
    // Use `util.types` for Node.js 10+.
    var types = freeModule && freeModule.require && freeModule.require('util').types;

    if (types) {
      return types;
    }

    // Legacy `process.binding('util')` for Node.js < 10.
    return freeProcess && freeProcess.binding && freeProcess.binding('util');
  } catch (e) {}
}());

/* Node.js helper references. */
var nodeIsTypedArray = nodeUtil && nodeUtil.isTypedArray;

/**
 * A faster alternative to `Function#apply`, this function invokes `func`
 * with the `this` binding of `thisArg` and the arguments of `args`.
 *
 * @private
 * @param {Function} func The function to invoke.
 * @param {*} thisArg The `this` binding of `func`.
 * @param {Array} args The arguments to invoke `func` with.
 * @returns {*} Returns the result of `func`.
 */
function apply(func, thisArg, args) {
  switch (args.length) {
    case 0: return func.call(thisArg);
    case 1: return func.call(thisArg, args[0]);
    case 2: return func.call(thisArg, args[0], args[1]);
    case 3: return func.call(thisArg, args[0], args[1], args[2]);
  }
  return func.apply(thisArg, args);
}

/**
 * The base implementation of `_.times` without support for iteratee shorthands
 * or max array length checks.
 *
 * @private
 * @param {number} n The number of times to invoke `iteratee`.
 * @param {Function} iteratee The function invoked per iteration.
 * @returns {Array} Returns the array of results.
 */
function baseTimes(n, iteratee) {
  var index = -1,
      result = Array(n);

  while (++index < n) {
    result[index] = iteratee(index);
  }
  return result;
}

/**
 * The base implementation of `_.unary` without support for storing metadata.
 *
 * @private
 * @param {Function} func The function to cap arguments for.
 * @returns {Function} Returns the new capped function.
 */
function baseUnary(func) {
  return function(value) {
    return func(value);
  };
}

/**
 * Gets the value at `key` of `object`.
 *
 * @private
 * @param {Object} [object] The object to query.
 * @param {string} key The key of the property to get.
 * @returns {*} Returns the property value.
 */
function getValue(object, key) {
  return object == null ? undefined : object[key];
}

/**
 * Creates a unary function that invokes `func` with its argument transformed.
 *
 * @private
 * @param {Function} func The function to wrap.
 * @param {Function} transform The argument transform.
 * @returns {Function} Returns the new function.
 */
function overArg(func, transform) {
  return function(arg) {
    return func(transform(arg));
  };
}

/** Used for built-in method references. */
var arrayProto = Array.prototype,
    funcProto = Function.prototype,
    objectProto = Object.prototype;

/** Used to detect overreaching core-js shims. */
var coreJsData = root['__core-js_shared__'];

/** Used to resolve the decompiled source of functions. */
var funcToString = funcProto.toString;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/** Used to detect methods masquerading as native. */
var maskSrcKey = (function() {
  var uid = /[^.]+$/.exec(coreJsData && coreJsData.keys && coreJsData.keys.IE_PROTO || '');
  return uid ? ('Symbol(src)_1.' + uid) : '';
}());

/**
 * Used to resolve the
 * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
 * of values.
 */
var nativeObjectToString = objectProto.toString;

/** Used to infer the `Object` constructor. */
var objectCtorString = funcToString.call(Object);

/** Used to detect if a method is native. */
var reIsNative = RegExp('^' +
  funcToString.call(hasOwnProperty).replace(reRegExpChar, '\\$&')
  .replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, '$1.*?') + '$'
);

/** Built-in value references. */
var Buffer = moduleExports ? root.Buffer : undefined,
    Symbol = root.Symbol,
    Uint8Array = root.Uint8Array,
    allocUnsafe = Buffer ? Buffer.allocUnsafe : undefined,
    getPrototype = overArg(Object.getPrototypeOf, Object),
    objectCreate = Object.create,
    propertyIsEnumerable = objectProto.propertyIsEnumerable,
    splice = arrayProto.splice,
    symToStringTag = Symbol ? Symbol.toStringTag : undefined;

var defineProperty = (function() {
  try {
    var func = getNative(Object, 'defineProperty');
    func({}, '', {});
    return func;
  } catch (e) {}
}());

/* Built-in method references for those with the same name as other `lodash` methods. */
var nativeIsBuffer = Buffer ? Buffer.isBuffer : undefined,
    nativeMax = Math.max,
    nativeNow = Date.now;

/* Built-in method references that are verified to be native. */
var Map = getNative(root, 'Map'),
    nativeCreate = getNative(Object, 'create');

/**
 * The base implementation of `_.create` without support for assigning
 * properties to the created object.
 *
 * @private
 * @param {Object} proto The object to inherit from.
 * @returns {Object} Returns the new object.
 */
var baseCreate = (function() {
  function object() {}
  return function(proto) {
    if (!isObject(proto)) {
      return {};
    }
    if (objectCreate) {
      return objectCreate(proto);
    }
    object.prototype = proto;
    var result = new object;
    object.prototype = undefined;
    return result;
  };
}());

/**
 * Creates a hash object.
 *
 * @private
 * @constructor
 * @param {Array} [entries] The key-value pairs to cache.
 */
function Hash(entries) {
  var index = -1,
      length = entries == null ? 0 : entries.length;

  this.clear();
  while (++index < length) {
    var entry = entries[index];
    this.set(entry[0], entry[1]);
  }
}

/**
 * Removes all key-value entries from the hash.
 *
 * @private
 * @name clear
 * @memberOf Hash
 */
function hashClear() {
  this.__data__ = nativeCreate ? nativeCreate(null) : {};
  this.size = 0;
}

/**
 * Removes `key` and its value from the hash.
 *
 * @private
 * @name delete
 * @memberOf Hash
 * @param {Object} hash The hash to modify.
 * @param {string} key The key of the value to remove.
 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
 */
function hashDelete(key) {
  var result = this.has(key) && delete this.__data__[key];
  this.size -= result ? 1 : 0;
  return result;
}

/**
 * Gets the hash value for `key`.
 *
 * @private
 * @name get
 * @memberOf Hash
 * @param {string} key The key of the value to get.
 * @returns {*} Returns the entry value.
 */
function hashGet(key) {
  var data = this.__data__;
  if (nativeCreate) {
    var result = data[key];
    return result === HASH_UNDEFINED ? undefined : result;
  }
  return hasOwnProperty.call(data, key) ? data[key] : undefined;
}

/**
 * Checks if a hash value for `key` exists.
 *
 * @private
 * @name has
 * @memberOf Hash
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function hashHas(key) {
  var data = this.__data__;
  return nativeCreate ? (data[key] !== undefined) : hasOwnProperty.call(data, key);
}

/**
 * Sets the hash `key` to `value`.
 *
 * @private
 * @name set
 * @memberOf Hash
 * @param {string} key The key of the value to set.
 * @param {*} value The value to set.
 * @returns {Object} Returns the hash instance.
 */
function hashSet(key, value) {
  var data = this.__data__;
  this.size += this.has(key) ? 0 : 1;
  data[key] = (nativeCreate && value === undefined) ? HASH_UNDEFINED : value;
  return this;
}

// Add methods to `Hash`.
Hash.prototype.clear = hashClear;
Hash.prototype['delete'] = hashDelete;
Hash.prototype.get = hashGet;
Hash.prototype.has = hashHas;
Hash.prototype.set = hashSet;

/**
 * Creates an list cache object.
 *
 * @private
 * @constructor
 * @param {Array} [entries] The key-value pairs to cache.
 */
function ListCache(entries) {
  var index = -1,
      length = entries == null ? 0 : entries.length;

  this.clear();
  while (++index < length) {
    var entry = entries[index];
    this.set(entry[0], entry[1]);
  }
}

/**
 * Removes all key-value entries from the list cache.
 *
 * @private
 * @name clear
 * @memberOf ListCache
 */
function listCacheClear() {
  this.__data__ = [];
  this.size = 0;
}

/**
 * Removes `key` and its value from the list cache.
 *
 * @private
 * @name delete
 * @memberOf ListCache
 * @param {string} key The key of the value to remove.
 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
 */
function listCacheDelete(key) {
  var data = this.__data__,
      index = assocIndexOf(data, key);

  if (index < 0) {
    return false;
  }
  var lastIndex = data.length - 1;
  if (index == lastIndex) {
    data.pop();
  } else {
    splice.call(data, index, 1);
  }
  --this.size;
  return true;
}

/**
 * Gets the list cache value for `key`.
 *
 * @private
 * @name get
 * @memberOf ListCache
 * @param {string} key The key of the value to get.
 * @returns {*} Returns the entry value.
 */
function listCacheGet(key) {
  var data = this.__data__,
      index = assocIndexOf(data, key);

  return index < 0 ? undefined : data[index][1];
}

/**
 * Checks if a list cache value for `key` exists.
 *
 * @private
 * @name has
 * @memberOf ListCache
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function listCacheHas(key) {
  return assocIndexOf(this.__data__, key) > -1;
}

/**
 * Sets the list cache `key` to `value`.
 *
 * @private
 * @name set
 * @memberOf ListCache
 * @param {string} key The key of the value to set.
 * @param {*} value The value to set.
 * @returns {Object} Returns the list cache instance.
 */
function listCacheSet(key, value) {
  var data = this.__data__,
      index = assocIndexOf(data, key);

  if (index < 0) {
    ++this.size;
    data.push([key, value]);
  } else {
    data[index][1] = value;
  }
  return this;
}

// Add methods to `ListCache`.
ListCache.prototype.clear = listCacheClear;
ListCache.prototype['delete'] = listCacheDelete;
ListCache.prototype.get = listCacheGet;
ListCache.prototype.has = listCacheHas;
ListCache.prototype.set = listCacheSet;

/**
 * Creates a map cache object to store key-value pairs.
 *
 * @private
 * @constructor
 * @param {Array} [entries] The key-value pairs to cache.
 */
function MapCache(entries) {
  var index = -1,
      length = entries == null ? 0 : entries.length;

  this.clear();
  while (++index < length) {
    var entry = entries[index];
    this.set(entry[0], entry[1]);
  }
}

/**
 * Removes all key-value entries from the map.
 *
 * @private
 * @name clear
 * @memberOf MapCache
 */
function mapCacheClear() {
  this.size = 0;
  this.__data__ = {
    'hash': new Hash,
    'map': new (Map || ListCache),
    'string': new Hash
  };
}

/**
 * Removes `key` and its value from the map.
 *
 * @private
 * @name delete
 * @memberOf MapCache
 * @param {string} key The key of the value to remove.
 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
 */
function mapCacheDelete(key) {
  var result = getMapData(this, key)['delete'](key);
  this.size -= result ? 1 : 0;
  return result;
}

/**
 * Gets the map value for `key`.
 *
 * @private
 * @name get
 * @memberOf MapCache
 * @param {string} key The key of the value to get.
 * @returns {*} Returns the entry value.
 */
function mapCacheGet(key) {
  return getMapData(this, key).get(key);
}

/**
 * Checks if a map value for `key` exists.
 *
 * @private
 * @name has
 * @memberOf MapCache
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function mapCacheHas(key) {
  return getMapData(this, key).has(key);
}

/**
 * Sets the map `key` to `value`.
 *
 * @private
 * @name set
 * @memberOf MapCache
 * @param {string} key The key of the value to set.
 * @param {*} value The value to set.
 * @returns {Object} Returns the map cache instance.
 */
function mapCacheSet(key, value) {
  var data = getMapData(this, key),
      size = data.size;

  data.set(key, value);
  this.size += data.size == size ? 0 : 1;
  return this;
}

// Add methods to `MapCache`.
MapCache.prototype.clear = mapCacheClear;
MapCache.prototype['delete'] = mapCacheDelete;
MapCache.prototype.get = mapCacheGet;
MapCache.prototype.has = mapCacheHas;
MapCache.prototype.set = mapCacheSet;

/**
 * Creates a stack cache object to store key-value pairs.
 *
 * @private
 * @constructor
 * @param {Array} [entries] The key-value pairs to cache.
 */
function Stack(entries) {
  var data = this.__data__ = new ListCache(entries);
  this.size = data.size;
}

/**
 * Removes all key-value entries from the stack.
 *
 * @private
 * @name clear
 * @memberOf Stack
 */
function stackClear() {
  this.__data__ = new ListCache;
  this.size = 0;
}

/**
 * Removes `key` and its value from the stack.
 *
 * @private
 * @name delete
 * @memberOf Stack
 * @param {string} key The key of the value to remove.
 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
 */
function stackDelete(key) {
  var data = this.__data__,
      result = data['delete'](key);

  this.size = data.size;
  return result;
}

/**
 * Gets the stack value for `key`.
 *
 * @private
 * @name get
 * @memberOf Stack
 * @param {string} key The key of the value to get.
 * @returns {*} Returns the entry value.
 */
function stackGet(key) {
  return this.__data__.get(key);
}

/**
 * Checks if a stack value for `key` exists.
 *
 * @private
 * @name has
 * @memberOf Stack
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function stackHas(key) {
  return this.__data__.has(key);
}

/**
 * Sets the stack `key` to `value`.
 *
 * @private
 * @name set
 * @memberOf Stack
 * @param {string} key The key of the value to set.
 * @param {*} value The value to set.
 * @returns {Object} Returns the stack cache instance.
 */
function stackSet(key, value) {
  var data = this.__data__;
  if (data instanceof ListCache) {
    var pairs = data.__data__;
    if (!Map || (pairs.length < LARGE_ARRAY_SIZE - 1)) {
      pairs.push([key, value]);
      this.size = ++data.size;
      return this;
    }
    data = this.__data__ = new MapCache(pairs);
  }
  data.set(key, value);
  this.size = data.size;
  return this;
}

// Add methods to `Stack`.
Stack.prototype.clear = stackClear;
Stack.prototype['delete'] = stackDelete;
Stack.prototype.get = stackGet;
Stack.prototype.has = stackHas;
Stack.prototype.set = stackSet;

/**
 * Creates an array of the enumerable property names of the array-like `value`.
 *
 * @private
 * @param {*} value The value to query.
 * @param {boolean} inherited Specify returning inherited property names.
 * @returns {Array} Returns the array of property names.
 */
function arrayLikeKeys(value, inherited) {
  var isArr = isArray(value),
      isArg = !isArr && isArguments(value),
      isBuff = !isArr && !isArg && isBuffer(value),
      isType = !isArr && !isArg && !isBuff && isTypedArray(value),
      skipIndexes = isArr || isArg || isBuff || isType,
      result = skipIndexes ? baseTimes(value.length, String) : [],
      length = result.length;

  for (var key in value) {
    if ((inherited || hasOwnProperty.call(value, key)) &&
        !(skipIndexes && (
           // Safari 9 has enumerable `arguments.length` in strict mode.
           key == 'length' ||
           // Node.js 0.10 has enumerable non-index properties on buffers.
           (isBuff && (key == 'offset' || key == 'parent')) ||
           // PhantomJS 2 has enumerable non-index properties on typed arrays.
           (isType && (key == 'buffer' || key == 'byteLength' || key == 'byteOffset')) ||
           // Skip index properties.
           isIndex(key, length)
        ))) {
      result.push(key);
    }
  }
  return result;
}

/**
 * This function is like `assignValue` except that it doesn't assign
 * `undefined` values.
 *
 * @private
 * @param {Object} object The object to modify.
 * @param {string} key The key of the property to assign.
 * @param {*} value The value to assign.
 */
function assignMergeValue(object, key, value) {
  if ((value !== undefined && !eq(object[key], value)) ||
      (value === undefined && !(key in object))) {
    baseAssignValue(object, key, value);
  }
}

/**
 * Assigns `value` to `key` of `object` if the existing value is not equivalent
 * using [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
 * for equality comparisons.
 *
 * @private
 * @param {Object} object The object to modify.
 * @param {string} key The key of the property to assign.
 * @param {*} value The value to assign.
 */
function assignValue(object, key, value) {
  var objValue = object[key];
  if (!(hasOwnProperty.call(object, key) && eq(objValue, value)) ||
      (value === undefined && !(key in object))) {
    baseAssignValue(object, key, value);
  }
}

/**
 * Gets the index at which the `key` is found in `array` of key-value pairs.
 *
 * @private
 * @param {Array} array The array to inspect.
 * @param {*} key The key to search for.
 * @returns {number} Returns the index of the matched value, else `-1`.
 */
function assocIndexOf(array, key) {
  var length = array.length;
  while (length--) {
    if (eq(array[length][0], key)) {
      return length;
    }
  }
  return -1;
}

/**
 * The base implementation of `assignValue` and `assignMergeValue` without
 * value checks.
 *
 * @private
 * @param {Object} object The object to modify.
 * @param {string} key The key of the property to assign.
 * @param {*} value The value to assign.
 */
function baseAssignValue(object, key, value) {
  if (key == '__proto__' && defineProperty) {
    defineProperty(object, key, {
      'configurable': true,
      'enumerable': true,
      'value': value,
      'writable': true
    });
  } else {
    object[key] = value;
  }
}

/**
 * The base implementation of `baseForOwn` which iterates over `object`
 * properties returned by `keysFunc` and invokes `iteratee` for each property.
 * Iteratee functions may exit iteration early by explicitly returning `false`.
 *
 * @private
 * @param {Object} object The object to iterate over.
 * @param {Function} iteratee The function invoked per iteration.
 * @param {Function} keysFunc The function to get the keys of `object`.
 * @returns {Object} Returns `object`.
 */
var baseFor = createBaseFor();

/**
 * The base implementation of `getTag` without fallbacks for buggy environments.
 *
 * @private
 * @param {*} value The value to query.
 * @returns {string} Returns the `toStringTag`.
 */
function baseGetTag(value) {
  if (value == null) {
    return value === undefined ? undefinedTag : nullTag;
  }
  return (symToStringTag && symToStringTag in Object(value))
    ? getRawTag(value)
    : objectToString(value);
}

/**
 * The base implementation of `_.isArguments`.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an `arguments` object,
 */
function baseIsArguments(value) {
  return isObjectLike(value) && baseGetTag(value) == argsTag;
}

/**
 * The base implementation of `_.isNative` without bad shim checks.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a native function,
 *  else `false`.
 */
function baseIsNative(value) {
  if (!isObject(value) || isMasked(value)) {
    return false;
  }
  var pattern = isFunction(value) ? reIsNative : reIsHostCtor;
  return pattern.test(toSource(value));
}

/**
 * The base implementation of `_.isTypedArray` without Node.js optimizations.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a typed array, else `false`.
 */
function baseIsTypedArray(value) {
  return isObjectLike(value) &&
    isLength(value.length) && !!typedArrayTags[baseGetTag(value)];
}

/**
 * The base implementation of `_.keysIn` which doesn't treat sparse arrays as dense.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property names.
 */
function baseKeysIn(object) {
  if (!isObject(object)) {
    return nativeKeysIn(object);
  }
  var isProto = isPrototype(object),
      result = [];

  for (var key in object) {
    if (!(key == 'constructor' && (isProto || !hasOwnProperty.call(object, key)))) {
      result.push(key);
    }
  }
  return result;
}

/**
 * The base implementation of `_.merge` without support for multiple sources.
 *
 * @private
 * @param {Object} object The destination object.
 * @param {Object} source The source object.
 * @param {number} srcIndex The index of `source`.
 * @param {Function} [customizer] The function to customize merged values.
 * @param {Object} [stack] Tracks traversed source values and their merged
 *  counterparts.
 */
function baseMerge(object, source, srcIndex, customizer, stack) {
  if (object === source) {
    return;
  }
  baseFor(source, function(srcValue, key) {
    stack || (stack = new Stack);
    if (isObject(srcValue)) {
      baseMergeDeep(object, source, key, srcIndex, baseMerge, customizer, stack);
    }
    else {
      var newValue = customizer
        ? customizer(safeGet(object, key), srcValue, (key + ''), object, source, stack)
        : undefined;

      if (newValue === undefined) {
        newValue = srcValue;
      }
      assignMergeValue(object, key, newValue);
    }
  }, keysIn);
}

/**
 * A specialized version of `baseMerge` for arrays and objects which performs
 * deep merges and tracks traversed objects enabling objects with circular
 * references to be merged.
 *
 * @private
 * @param {Object} object The destination object.
 * @param {Object} source The source object.
 * @param {string} key The key of the value to merge.
 * @param {number} srcIndex The index of `source`.
 * @param {Function} mergeFunc The function to merge values.
 * @param {Function} [customizer] The function to customize assigned values.
 * @param {Object} [stack] Tracks traversed source values and their merged
 *  counterparts.
 */
function baseMergeDeep(object, source, key, srcIndex, mergeFunc, customizer, stack) {
  var objValue = safeGet(object, key),
      srcValue = safeGet(source, key),
      stacked = stack.get(srcValue);

  if (stacked) {
    assignMergeValue(object, key, stacked);
    return;
  }
  var newValue = customizer
    ? customizer(objValue, srcValue, (key + ''), object, source, stack)
    : undefined;

  var isCommon = newValue === undefined;

  if (isCommon) {
    var isArr = isArray(srcValue),
        isBuff = !isArr && isBuffer(srcValue),
        isTyped = !isArr && !isBuff && isTypedArray(srcValue);

    newValue = srcValue;
    if (isArr || isBuff || isTyped) {
      if (isArray(objValue)) {
        newValue = objValue;
      }
      else if (isArrayLikeObject(objValue)) {
        newValue = copyArray(objValue);
      }
      else if (isBuff) {
        isCommon = false;
        newValue = cloneBuffer(srcValue, true);
      }
      else if (isTyped) {
        isCommon = false;
        newValue = cloneTypedArray(srcValue, true);
      }
      else {
        newValue = [];
      }
    }
    else if (isPlainObject(srcValue) || isArguments(srcValue)) {
      newValue = objValue;
      if (isArguments(objValue)) {
        newValue = toPlainObject(objValue);
      }
      else if (!isObject(objValue) || isFunction(objValue)) {
        newValue = initCloneObject(srcValue);
      }
    }
    else {
      isCommon = false;
    }
  }
  if (isCommon) {
    // Recursively merge objects and arrays (susceptible to call stack limits).
    stack.set(srcValue, newValue);
    mergeFunc(newValue, srcValue, srcIndex, customizer, stack);
    stack['delete'](srcValue);
  }
  assignMergeValue(object, key, newValue);
}

/**
 * The base implementation of `_.rest` which doesn't validate or coerce arguments.
 *
 * @private
 * @param {Function} func The function to apply a rest parameter to.
 * @param {number} [start=func.length-1] The start position of the rest parameter.
 * @returns {Function} Returns the new function.
 */
function baseRest(func, start) {
  return setToString(overRest(func, start, identity), func + '');
}

/**
 * The base implementation of `setToString` without support for hot loop shorting.
 *
 * @private
 * @param {Function} func The function to modify.
 * @param {Function} string The `toString` result.
 * @returns {Function} Returns `func`.
 */
var baseSetToString = !defineProperty ? identity : function(func, string) {
  return defineProperty(func, 'toString', {
    'configurable': true,
    'enumerable': false,
    'value': constant(string),
    'writable': true
  });
};

/**
 * Creates a clone of  `buffer`.
 *
 * @private
 * @param {Buffer} buffer The buffer to clone.
 * @param {boolean} [isDeep] Specify a deep clone.
 * @returns {Buffer} Returns the cloned buffer.
 */
function cloneBuffer(buffer, isDeep) {
  if (isDeep) {
    return buffer.slice();
  }
  var length = buffer.length,
      result = allocUnsafe ? allocUnsafe(length) : new buffer.constructor(length);

  buffer.copy(result);
  return result;
}

/**
 * Creates a clone of `arrayBuffer`.
 *
 * @private
 * @param {ArrayBuffer} arrayBuffer The array buffer to clone.
 * @returns {ArrayBuffer} Returns the cloned array buffer.
 */
function cloneArrayBuffer(arrayBuffer) {
  var result = new arrayBuffer.constructor(arrayBuffer.byteLength);
  new Uint8Array(result).set(new Uint8Array(arrayBuffer));
  return result;
}

/**
 * Creates a clone of `typedArray`.
 *
 * @private
 * @param {Object} typedArray The typed array to clone.
 * @param {boolean} [isDeep] Specify a deep clone.
 * @returns {Object} Returns the cloned typed array.
 */
function cloneTypedArray(typedArray, isDeep) {
  var buffer = isDeep ? cloneArrayBuffer(typedArray.buffer) : typedArray.buffer;
  return new typedArray.constructor(buffer, typedArray.byteOffset, typedArray.length);
}

/**
 * Copies the values of `source` to `array`.
 *
 * @private
 * @param {Array} source The array to copy values from.
 * @param {Array} [array=[]] The array to copy values to.
 * @returns {Array} Returns `array`.
 */
function copyArray(source, array) {
  var index = -1,
      length = source.length;

  array || (array = Array(length));
  while (++index < length) {
    array[index] = source[index];
  }
  return array;
}

/**
 * Copies properties of `source` to `object`.
 *
 * @private
 * @param {Object} source The object to copy properties from.
 * @param {Array} props The property identifiers to copy.
 * @param {Object} [object={}] The object to copy properties to.
 * @param {Function} [customizer] The function to customize copied values.
 * @returns {Object} Returns `object`.
 */
function copyObject(source, props, object, customizer) {
  var isNew = !object;
  object || (object = {});

  var index = -1,
      length = props.length;

  while (++index < length) {
    var key = props[index];

    var newValue = customizer
      ? customizer(object[key], source[key], key, object, source)
      : undefined;

    if (newValue === undefined) {
      newValue = source[key];
    }
    if (isNew) {
      baseAssignValue(object, key, newValue);
    } else {
      assignValue(object, key, newValue);
    }
  }
  return object;
}

/**
 * Creates a function like `_.assign`.
 *
 * @private
 * @param {Function} assigner The function to assign values.
 * @returns {Function} Returns the new assigner function.
 */
function createAssigner(assigner) {
  return baseRest(function(object, sources) {
    var index = -1,
        length = sources.length,
        customizer = length > 1 ? sources[length - 1] : undefined,
        guard = length > 2 ? sources[2] : undefined;

    customizer = (assigner.length > 3 && typeof customizer == 'function')
      ? (length--, customizer)
      : undefined;

    if (guard && isIterateeCall(sources[0], sources[1], guard)) {
      customizer = length < 3 ? undefined : customizer;
      length = 1;
    }
    object = Object(object);
    while (++index < length) {
      var source = sources[index];
      if (source) {
        assigner(object, source, index, customizer);
      }
    }
    return object;
  });
}

/**
 * Creates a base function for methods like `_.forIn` and `_.forOwn`.
 *
 * @private
 * @param {boolean} [fromRight] Specify iterating from right to left.
 * @returns {Function} Returns the new base function.
 */
function createBaseFor(fromRight) {
  return function(object, iteratee, keysFunc) {
    var index = -1,
        iterable = Object(object),
        props = keysFunc(object),
        length = props.length;

    while (length--) {
      var key = props[fromRight ? length : ++index];
      if (iteratee(iterable[key], key, iterable) === false) {
        break;
      }
    }
    return object;
  };
}

/**
 * Gets the data for `map`.
 *
 * @private
 * @param {Object} map The map to query.
 * @param {string} key The reference key.
 * @returns {*} Returns the map data.
 */
function getMapData(map, key) {
  var data = map.__data__;
  return isKeyable(key)
    ? data[typeof key == 'string' ? 'string' : 'hash']
    : data.map;
}

/**
 * Gets the native function at `key` of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @param {string} key The key of the method to get.
 * @returns {*} Returns the function if it's native, else `undefined`.
 */
function getNative(object, key) {
  var value = getValue(object, key);
  return baseIsNative(value) ? value : undefined;
}

/**
 * A specialized version of `baseGetTag` which ignores `Symbol.toStringTag` values.
 *
 * @private
 * @param {*} value The value to query.
 * @returns {string} Returns the raw `toStringTag`.
 */
function getRawTag(value) {
  var isOwn = hasOwnProperty.call(value, symToStringTag),
      tag = value[symToStringTag];

  try {
    value[symToStringTag] = undefined;
    var unmasked = true;
  } catch (e) {}

  var result = nativeObjectToString.call(value);
  if (unmasked) {
    if (isOwn) {
      value[symToStringTag] = tag;
    } else {
      delete value[symToStringTag];
    }
  }
  return result;
}

/**
 * Initializes an object clone.
 *
 * @private
 * @param {Object} object The object to clone.
 * @returns {Object} Returns the initialized clone.
 */
function initCloneObject(object) {
  return (typeof object.constructor == 'function' && !isPrototype(object))
    ? baseCreate(getPrototype(object))
    : {};
}

/**
 * Checks if `value` is a valid array-like index.
 *
 * @private
 * @param {*} value The value to check.
 * @param {number} [length=MAX_SAFE_INTEGER] The upper bounds of a valid index.
 * @returns {boolean} Returns `true` if `value` is a valid index, else `false`.
 */
function isIndex(value, length) {
  var type = typeof value;
  length = length == null ? MAX_SAFE_INTEGER : length;

  return !!length &&
    (type == 'number' ||
      (type != 'symbol' && reIsUint.test(value))) &&
        (value > -1 && value % 1 == 0 && value < length);
}

/**
 * Checks if the given arguments are from an iteratee call.
 *
 * @private
 * @param {*} value The potential iteratee value argument.
 * @param {*} index The potential iteratee index or key argument.
 * @param {*} object The potential iteratee object argument.
 * @returns {boolean} Returns `true` if the arguments are from an iteratee call,
 *  else `false`.
 */
function isIterateeCall(value, index, object) {
  if (!isObject(object)) {
    return false;
  }
  var type = typeof index;
  if (type == 'number'
        ? (isArrayLike(object) && isIndex(index, object.length))
        : (type == 'string' && index in object)
      ) {
    return eq(object[index], value);
  }
  return false;
}

/**
 * Checks if `value` is suitable for use as unique object key.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is suitable, else `false`.
 */
function isKeyable(value) {
  var type = typeof value;
  return (type == 'string' || type == 'number' || type == 'symbol' || type == 'boolean')
    ? (value !== '__proto__')
    : (value === null);
}

/**
 * Checks if `func` has its source masked.
 *
 * @private
 * @param {Function} func The function to check.
 * @returns {boolean} Returns `true` if `func` is masked, else `false`.
 */
function isMasked(func) {
  return !!maskSrcKey && (maskSrcKey in func);
}

/**
 * Checks if `value` is likely a prototype object.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a prototype, else `false`.
 */
function isPrototype(value) {
  var Ctor = value && value.constructor,
      proto = (typeof Ctor == 'function' && Ctor.prototype) || objectProto;

  return value === proto;
}

/**
 * This function is like
 * [`Object.keys`](http://ecma-international.org/ecma-262/7.0/#sec-object.keys)
 * except that it includes inherited enumerable properties.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property names.
 */
function nativeKeysIn(object) {
  var result = [];
  if (object != null) {
    for (var key in Object(object)) {
      result.push(key);
    }
  }
  return result;
}

/**
 * Converts `value` to a string using `Object.prototype.toString`.
 *
 * @private
 * @param {*} value The value to convert.
 * @returns {string} Returns the converted string.
 */
function objectToString(value) {
  return nativeObjectToString.call(value);
}

/**
 * A specialized version of `baseRest` which transforms the rest array.
 *
 * @private
 * @param {Function} func The function to apply a rest parameter to.
 * @param {number} [start=func.length-1] The start position of the rest parameter.
 * @param {Function} transform The rest array transform.
 * @returns {Function} Returns the new function.
 */
function overRest(func, start, transform) {
  start = nativeMax(start === undefined ? (func.length - 1) : start, 0);
  return function() {
    var args = arguments,
        index = -1,
        length = nativeMax(args.length - start, 0),
        array = Array(length);

    while (++index < length) {
      array[index] = args[start + index];
    }
    index = -1;
    var otherArgs = Array(start + 1);
    while (++index < start) {
      otherArgs[index] = args[index];
    }
    otherArgs[start] = transform(array);
    return apply(func, this, otherArgs);
  };
}

/**
 * Gets the value at `key`, unless `key` is "__proto__" or "constructor".
 *
 * @private
 * @param {Object} object The object to query.
 * @param {string} key The key of the property to get.
 * @returns {*} Returns the property value.
 */
function safeGet(object, key) {
  if (key === 'constructor' && typeof object[key] === 'function') {
    return;
  }

  if (key == '__proto__') {
    return;
  }

  return object[key];
}

/**
 * Sets the `toString` method of `func` to return `string`.
 *
 * @private
 * @param {Function} func The function to modify.
 * @param {Function} string The `toString` result.
 * @returns {Function} Returns `func`.
 */
var setToString = shortOut(baseSetToString);

/**
 * Creates a function that'll short out and invoke `identity` instead
 * of `func` when it's called `HOT_COUNT` or more times in `HOT_SPAN`
 * milliseconds.
 *
 * @private
 * @param {Function} func The function to restrict.
 * @returns {Function} Returns the new shortable function.
 */
function shortOut(func) {
  var count = 0,
      lastCalled = 0;

  return function() {
    var stamp = nativeNow(),
        remaining = HOT_SPAN - (stamp - lastCalled);

    lastCalled = stamp;
    if (remaining > 0) {
      if (++count >= HOT_COUNT) {
        return arguments[0];
      }
    } else {
      count = 0;
    }
    return func.apply(undefined, arguments);
  };
}

/**
 * Converts `func` to its source code.
 *
 * @private
 * @param {Function} func The function to convert.
 * @returns {string} Returns the source code.
 */
function toSource(func) {
  if (func != null) {
    try {
      return funcToString.call(func);
    } catch (e) {}
    try {
      return (func + '');
    } catch (e) {}
  }
  return '';
}

/**
 * Performs a
 * [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
 * comparison between two values to determine if they are equivalent.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to compare.
 * @param {*} other The other value to compare.
 * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
 * @example
 *
 * var object = { 'a': 1 };
 * var other = { 'a': 1 };
 *
 * _.eq(object, object);
 * // => true
 *
 * _.eq(object, other);
 * // => false
 *
 * _.eq('a', 'a');
 * // => true
 *
 * _.eq('a', Object('a'));
 * // => false
 *
 * _.eq(NaN, NaN);
 * // => true
 */
function eq(value, other) {
  return value === other || (value !== value && other !== other);
}

/**
 * Checks if `value` is likely an `arguments` object.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an `arguments` object,
 *  else `false`.
 * @example
 *
 * _.isArguments(function() { return arguments; }());
 * // => true
 *
 * _.isArguments([1, 2, 3]);
 * // => false
 */
var isArguments = baseIsArguments(function() { return arguments; }()) ? baseIsArguments : function(value) {
  return isObjectLike(value) && hasOwnProperty.call(value, 'callee') &&
    !propertyIsEnumerable.call(value, 'callee');
};

/**
 * Checks if `value` is classified as an `Array` object.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an array, else `false`.
 * @example
 *
 * _.isArray([1, 2, 3]);
 * // => true
 *
 * _.isArray(document.body.children);
 * // => false
 *
 * _.isArray('abc');
 * // => false
 *
 * _.isArray(_.noop);
 * // => false
 */
var isArray = Array.isArray;

/**
 * Checks if `value` is array-like. A value is considered array-like if it's
 * not a function and has a `value.length` that's an integer greater than or
 * equal to `0` and less than or equal to `Number.MAX_SAFE_INTEGER`.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is array-like, else `false`.
 * @example
 *
 * _.isArrayLike([1, 2, 3]);
 * // => true
 *
 * _.isArrayLike(document.body.children);
 * // => true
 *
 * _.isArrayLike('abc');
 * // => true
 *
 * _.isArrayLike(_.noop);
 * // => false
 */
function isArrayLike(value) {
  return value != null && isLength(value.length) && !isFunction(value);
}

/**
 * This method is like `_.isArrayLike` except that it also checks if `value`
 * is an object.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an array-like object,
 *  else `false`.
 * @example
 *
 * _.isArrayLikeObject([1, 2, 3]);
 * // => true
 *
 * _.isArrayLikeObject(document.body.children);
 * // => true
 *
 * _.isArrayLikeObject('abc');
 * // => false
 *
 * _.isArrayLikeObject(_.noop);
 * // => false
 */
function isArrayLikeObject(value) {
  return isObjectLike(value) && isArrayLike(value);
}

/**
 * Checks if `value` is a buffer.
 *
 * @static
 * @memberOf _
 * @since 4.3.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a buffer, else `false`.
 * @example
 *
 * _.isBuffer(new Buffer(2));
 * // => true
 *
 * _.isBuffer(new Uint8Array(2));
 * // => false
 */
var isBuffer = nativeIsBuffer || stubFalse;

/**
 * Checks if `value` is classified as a `Function` object.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a function, else `false`.
 * @example
 *
 * _.isFunction(_);
 * // => true
 *
 * _.isFunction(/abc/);
 * // => false
 */
function isFunction(value) {
  if (!isObject(value)) {
    return false;
  }
  // The use of `Object#toString` avoids issues with the `typeof` operator
  // in Safari 9 which returns 'object' for typed arrays and other constructors.
  var tag = baseGetTag(value);
  return tag == funcTag || tag == genTag || tag == asyncTag || tag == proxyTag;
}

/**
 * Checks if `value` is a valid array-like length.
 *
 * **Note:** This method is loosely based on
 * [`ToLength`](http://ecma-international.org/ecma-262/7.0/#sec-tolength).
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a valid length, else `false`.
 * @example
 *
 * _.isLength(3);
 * // => true
 *
 * _.isLength(Number.MIN_VALUE);
 * // => false
 *
 * _.isLength(Infinity);
 * // => false
 *
 * _.isLength('3');
 * // => false
 */
function isLength(value) {
  return typeof value == 'number' &&
    value > -1 && value % 1 == 0 && value <= MAX_SAFE_INTEGER;
}

/**
 * Checks if `value` is the
 * [language type](http://www.ecma-international.org/ecma-262/7.0/#sec-ecmascript-language-types)
 * of `Object`. (e.g. arrays, functions, objects, regexes, `new Number(0)`, and `new String('')`)
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an object, else `false`.
 * @example
 *
 * _.isObject({});
 * // => true
 *
 * _.isObject([1, 2, 3]);
 * // => true
 *
 * _.isObject(_.noop);
 * // => true
 *
 * _.isObject(null);
 * // => false
 */
function isObject(value) {
  var type = typeof value;
  return value != null && (type == 'object' || type == 'function');
}

/**
 * Checks if `value` is object-like. A value is object-like if it's not `null`
 * and has a `typeof` result of "object".
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is object-like, else `false`.
 * @example
 *
 * _.isObjectLike({});
 * // => true
 *
 * _.isObjectLike([1, 2, 3]);
 * // => true
 *
 * _.isObjectLike(_.noop);
 * // => false
 *
 * _.isObjectLike(null);
 * // => false
 */
function isObjectLike(value) {
  return value != null && typeof value == 'object';
}

/**
 * Checks if `value` is a plain object, that is, an object created by the
 * `Object` constructor or one with a `[[Prototype]]` of `null`.
 *
 * @static
 * @memberOf _
 * @since 0.8.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a plain object, else `false`.
 * @example
 *
 * function Foo() {
 *   this.a = 1;
 * }
 *
 * _.isPlainObject(new Foo);
 * // => false
 *
 * _.isPlainObject([1, 2, 3]);
 * // => false
 *
 * _.isPlainObject({ 'x': 0, 'y': 0 });
 * // => true
 *
 * _.isPlainObject(Object.create(null));
 * // => true
 */
function isPlainObject(value) {
  if (!isObjectLike(value) || baseGetTag(value) != objectTag) {
    return false;
  }
  var proto = getPrototype(value);
  if (proto === null) {
    return true;
  }
  var Ctor = hasOwnProperty.call(proto, 'constructor') && proto.constructor;
  return typeof Ctor == 'function' && Ctor instanceof Ctor &&
    funcToString.call(Ctor) == objectCtorString;
}

/**
 * Checks if `value` is classified as a typed array.
 *
 * @static
 * @memberOf _
 * @since 3.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a typed array, else `false`.
 * @example
 *
 * _.isTypedArray(new Uint8Array);
 * // => true
 *
 * _.isTypedArray([]);
 * // => false
 */
var isTypedArray = nodeIsTypedArray ? baseUnary(nodeIsTypedArray) : baseIsTypedArray;

/**
 * Converts `value` to a plain object flattening inherited enumerable string
 * keyed properties of `value` to own properties of the plain object.
 *
 * @static
 * @memberOf _
 * @since 3.0.0
 * @category Lang
 * @param {*} value The value to convert.
 * @returns {Object} Returns the converted plain object.
 * @example
 *
 * function Foo() {
 *   this.b = 2;
 * }
 *
 * Foo.prototype.c = 3;
 *
 * _.assign({ 'a': 1 }, new Foo);
 * // => { 'a': 1, 'b': 2 }
 *
 * _.assign({ 'a': 1 }, _.toPlainObject(new Foo));
 * // => { 'a': 1, 'b': 2, 'c': 3 }
 */
function toPlainObject(value) {
  return copyObject(value, keysIn(value));
}

/**
 * Creates an array of the own and inherited enumerable property names of `object`.
 *
 * **Note:** Non-object values are coerced to objects.
 *
 * @static
 * @memberOf _
 * @since 3.0.0
 * @category Object
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property names.
 * @example
 *
 * function Foo() {
 *   this.a = 1;
 *   this.b = 2;
 * }
 *
 * Foo.prototype.c = 3;
 *
 * _.keysIn(new Foo);
 * // => ['a', 'b', 'c'] (iteration order is not guaranteed)
 */
function keysIn(object) {
  return isArrayLike(object) ? arrayLikeKeys(object, true) : baseKeysIn(object);
}

/**
 * This method is like `_.assign` except that it recursively merges own and
 * inherited enumerable string keyed properties of source objects into the
 * destination object. Source properties that resolve to `undefined` are
 * skipped if a destination value exists. Array and plain object properties
 * are merged recursively. Other objects and value types are overridden by
 * assignment. Source objects are applied from left to right. Subsequent
 * sources overwrite property assignments of previous sources.
 *
 * **Note:** This method mutates `object`.
 *
 * @static
 * @memberOf _
 * @since 0.5.0
 * @category Object
 * @param {Object} object The destination object.
 * @param {...Object} [sources] The source objects.
 * @returns {Object} Returns `object`.
 * @example
 *
 * var object = {
 *   'a': [{ 'b': 2 }, { 'd': 4 }]
 * };
 *
 * var other = {
 *   'a': [{ 'c': 3 }, { 'e': 5 }]
 * };
 *
 * _.merge(object, other);
 * // => { 'a': [{ 'b': 2, 'c': 3 }, { 'd': 4, 'e': 5 }] }
 */
var merge = createAssigner(function(object, source, srcIndex) {
  baseMerge(object, source, srcIndex);
});

/**
 * Creates a function that returns `value`.
 *
 * @static
 * @memberOf _
 * @since 2.4.0
 * @category Util
 * @param {*} value The value to return from the new function.
 * @returns {Function} Returns the new constant function.
 * @example
 *
 * var objects = _.times(2, _.constant({ 'a': 1 }));
 *
 * console.log(objects);
 * // => [{ 'a': 1 }, { 'a': 1 }]
 *
 * console.log(objects[0] === objects[1]);
 * // => true
 */
function constant(value) {
  return function() {
    return value;
  };
}

/**
 * This method returns the first argument it receives.
 *
 * @static
 * @since 0.1.0
 * @memberOf _
 * @category Util
 * @param {*} value Any value.
 * @returns {*} Returns `value`.
 * @example
 *
 * var object = { 'a': 1 };
 *
 * console.log(_.identity(object) === object);
 * // => true
 */
function identity(value) {
  return value;
}

/**
 * This method returns `false`.
 *
 * @static
 * @memberOf _
 * @since 4.13.0
 * @category Util
 * @returns {boolean} Returns `false`.
 * @example
 *
 * _.times(2, _.stubFalse);
 * // => [false, false]
 */
function stubFalse() {
  return false;
}

module.exports = merge;

/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__("yLpj"), __webpack_require__("YuTi")(module)))

/***/ }),

/***/ "2uka":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";

// CONCATENATED MODULE: ./node_modules/vue-loader/lib/loaders/templateLoader.js??vue-loader-options!./node_modules/vue-loader/lib??vue-loader-options!./src/common/iframe/Iframe.vue?vue&type=template&id=37ec6382&
var render = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('iframe',{staticClass:"sm-component-iframe",attrs:{"src":_vm.src,"scrolling":"auto"}})}
var staticRenderFns = []


// CONCATENATED MODULE: ./src/common/iframe/Iframe.vue?vue&type=template&id=37ec6382&
/* concated harmony reexport render */__webpack_require__.d(__webpack_exports__, "a", function() { return render; });
/* concated harmony reexport staticRenderFns */__webpack_require__.d(__webpack_exports__, "b", function() { return staticRenderFns; });


/***/ }),

/***/ "3BRs":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(process, global) {// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.

// A bit simpler than readable streams.
// Implement an async ._write(chunk, encoding, cb), and it'll handle all
// the drain event emission and buffering.



/*<replacement>*/

var pna = __webpack_require__("lm0R");
/*</replacement>*/

module.exports = Writable;

/* <replacement> */
function WriteReq(chunk, encoding, cb) {
  this.chunk = chunk;
  this.encoding = encoding;
  this.callback = cb;
  this.next = null;
}

// It seems a linked list but it is not
// there will be only 2 of these for each stream
function CorkedRequest(state) {
  var _this = this;

  this.next = null;
  this.entry = null;
  this.finish = function () {
    onCorkedFinish(_this, state);
  };
}
/* </replacement> */

/*<replacement>*/
var asyncWrite = !process.browser && ['v0.10', 'v0.9.'].indexOf(process.version.slice(0, 5)) > -1 ? setImmediate : pna.nextTick;
/*</replacement>*/

/*<replacement>*/
var Duplex;
/*</replacement>*/

Writable.WritableState = WritableState;

/*<replacement>*/
var util = __webpack_require__("Onz0");
util.inherits = __webpack_require__("P7XM");
/*</replacement>*/

/*<replacement>*/
var internalUtil = {
  deprecate: __webpack_require__("t9FE")
};
/*</replacement>*/

/*<replacement>*/
var Stream = __webpack_require__("QpuX");
/*</replacement>*/

/*<replacement>*/

var Buffer = __webpack_require__("hwdV").Buffer;
var OurUint8Array = global.Uint8Array || function () {};
function _uint8ArrayToBuffer(chunk) {
  return Buffer.from(chunk);
}
function _isUint8Array(obj) {
  return Buffer.isBuffer(obj) || obj instanceof OurUint8Array;
}

/*</replacement>*/

var destroyImpl = __webpack_require__("RoFp");

util.inherits(Writable, Stream);

function nop() {}

function WritableState(options, stream) {
  Duplex = Duplex || __webpack_require__("sZro");

  options = options || {};

  // Duplex streams are both readable and writable, but share
  // the same options object.
  // However, some cases require setting options to different
  // values for the readable and the writable sides of the duplex stream.
  // These options can be provided separately as readableXXX and writableXXX.
  var isDuplex = stream instanceof Duplex;

  // object stream flag to indicate whether or not this stream
  // contains buffers or objects.
  this.objectMode = !!options.objectMode;

  if (isDuplex) this.objectMode = this.objectMode || !!options.writableObjectMode;

  // the point at which write() starts returning false
  // Note: 0 is a valid value, means that we always return false if
  // the entire buffer is not flushed immediately on write()
  var hwm = options.highWaterMark;
  var writableHwm = options.writableHighWaterMark;
  var defaultHwm = this.objectMode ? 16 : 16 * 1024;

  if (hwm || hwm === 0) this.highWaterMark = hwm;else if (isDuplex && (writableHwm || writableHwm === 0)) this.highWaterMark = writableHwm;else this.highWaterMark = defaultHwm;

  // cast to ints.
  this.highWaterMark = Math.floor(this.highWaterMark);

  // if _final has been called
  this.finalCalled = false;

  // drain event flag.
  this.needDrain = false;
  // at the start of calling end()
  this.ending = false;
  // when end() has been called, and returned
  this.ended = false;
  // when 'finish' is emitted
  this.finished = false;

  // has it been destroyed
  this.destroyed = false;

  // should we decode strings into buffers before passing to _write?
  // this is here so that some node-core streams can optimize string
  // handling at a lower level.
  var noDecode = options.decodeStrings === false;
  this.decodeStrings = !noDecode;

  // Crypto is kind of old and crusty.  Historically, its default string
  // encoding is 'binary' so we have to make this configurable.
  // Everything else in the universe uses 'utf8', though.
  this.defaultEncoding = options.defaultEncoding || 'utf8';

  // not an actual buffer we keep track of, but a measurement
  // of how much we're waiting to get pushed to some underlying
  // socket or file.
  this.length = 0;

  // a flag to see when we're in the middle of a write.
  this.writing = false;

  // when true all writes will be buffered until .uncork() call
  this.corked = 0;

  // a flag to be able to tell if the onwrite cb is called immediately,
  // or on a later tick.  We set this to true at first, because any
  // actions that shouldn't happen until "later" should generally also
  // not happen before the first write call.
  this.sync = true;

  // a flag to know if we're processing previously buffered items, which
  // may call the _write() callback in the same tick, so that we don't
  // end up in an overlapped onwrite situation.
  this.bufferProcessing = false;

  // the callback that's passed to _write(chunk,cb)
  this.onwrite = function (er) {
    onwrite(stream, er);
  };

  // the callback that the user supplies to write(chunk,encoding,cb)
  this.writecb = null;

  // the amount that is being written when _write is called.
  this.writelen = 0;

  this.bufferedRequest = null;
  this.lastBufferedRequest = null;

  // number of pending user-supplied write callbacks
  // this must be 0 before 'finish' can be emitted
  this.pendingcb = 0;

  // emit prefinish if the only thing we're waiting for is _write cbs
  // This is relevant for synchronous Transform streams
  this.prefinished = false;

  // True if the error was already emitted and should not be thrown again
  this.errorEmitted = false;

  // count buffered requests
  this.bufferedRequestCount = 0;

  // allocate the first CorkedRequest, there is always
  // one allocated and free to use, and we maintain at most two
  this.corkedRequestsFree = new CorkedRequest(this);
}

WritableState.prototype.getBuffer = function getBuffer() {
  var current = this.bufferedRequest;
  var out = [];
  while (current) {
    out.push(current);
    current = current.next;
  }
  return out;
};

(function () {
  try {
    Object.defineProperty(WritableState.prototype, 'buffer', {
      get: internalUtil.deprecate(function () {
        return this.getBuffer();
      }, '_writableState.buffer is deprecated. Use _writableState.getBuffer ' + 'instead.', 'DEP0003')
    });
  } catch (_) {}
})();

// Test _writableState for inheritance to account for Duplex streams,
// whose prototype chain only points to Readable.
var realHasInstance;
if (typeof Symbol === 'function' && Symbol.hasInstance && typeof Function.prototype[Symbol.hasInstance] === 'function') {
  realHasInstance = Function.prototype[Symbol.hasInstance];
  Object.defineProperty(Writable, Symbol.hasInstance, {
    value: function (object) {
      if (realHasInstance.call(this, object)) return true;
      if (this !== Writable) return false;

      return object && object._writableState instanceof WritableState;
    }
  });
} else {
  realHasInstance = function (object) {
    return object instanceof this;
  };
}

function Writable(options) {
  Duplex = Duplex || __webpack_require__("sZro");

  // Writable ctor is applied to Duplexes, too.
  // `realHasInstance` is necessary because using plain `instanceof`
  // would return false, as no `_writableState` property is attached.

  // Trying to use the custom `instanceof` for Writable here will also break the
  // Node.js LazyTransform implementation, which has a non-trivial getter for
  // `_writableState` that would lead to infinite recursion.
  if (!realHasInstance.call(Writable, this) && !(this instanceof Duplex)) {
    return new Writable(options);
  }

  this._writableState = new WritableState(options, this);

  // legacy.
  this.writable = true;

  if (options) {
    if (typeof options.write === 'function') this._write = options.write;

    if (typeof options.writev === 'function') this._writev = options.writev;

    if (typeof options.destroy === 'function') this._destroy = options.destroy;

    if (typeof options.final === 'function') this._final = options.final;
  }

  Stream.call(this);
}

// Otherwise people can pipe Writable streams, which is just wrong.
Writable.prototype.pipe = function () {
  this.emit('error', new Error('Cannot pipe, not readable'));
};

function writeAfterEnd(stream, cb) {
  var er = new Error('write after end');
  // TODO: defer error events consistently everywhere, not just the cb
  stream.emit('error', er);
  pna.nextTick(cb, er);
}

// Checks that a user-supplied chunk is valid, especially for the particular
// mode the stream is in. Currently this means that `null` is never accepted
// and undefined/non-string values are only allowed in object mode.
function validChunk(stream, state, chunk, cb) {
  var valid = true;
  var er = false;

  if (chunk === null) {
    er = new TypeError('May not write null values to stream');
  } else if (typeof chunk !== 'string' && chunk !== undefined && !state.objectMode) {
    er = new TypeError('Invalid non-string/buffer chunk');
  }
  if (er) {
    stream.emit('error', er);
    pna.nextTick(cb, er);
    valid = false;
  }
  return valid;
}

Writable.prototype.write = function (chunk, encoding, cb) {
  var state = this._writableState;
  var ret = false;
  var isBuf = !state.objectMode && _isUint8Array(chunk);

  if (isBuf && !Buffer.isBuffer(chunk)) {
    chunk = _uint8ArrayToBuffer(chunk);
  }

  if (typeof encoding === 'function') {
    cb = encoding;
    encoding = null;
  }

  if (isBuf) encoding = 'buffer';else if (!encoding) encoding = state.defaultEncoding;

  if (typeof cb !== 'function') cb = nop;

  if (state.ended) writeAfterEnd(this, cb);else if (isBuf || validChunk(this, state, chunk, cb)) {
    state.pendingcb++;
    ret = writeOrBuffer(this, state, isBuf, chunk, encoding, cb);
  }

  return ret;
};

Writable.prototype.cork = function () {
  var state = this._writableState;

  state.corked++;
};

Writable.prototype.uncork = function () {
  var state = this._writableState;

  if (state.corked) {
    state.corked--;

    if (!state.writing && !state.corked && !state.finished && !state.bufferProcessing && state.bufferedRequest) clearBuffer(this, state);
  }
};

Writable.prototype.setDefaultEncoding = function setDefaultEncoding(encoding) {
  // node::ParseEncoding() requires lower case.
  if (typeof encoding === 'string') encoding = encoding.toLowerCase();
  if (!(['hex', 'utf8', 'utf-8', 'ascii', 'binary', 'base64', 'ucs2', 'ucs-2', 'utf16le', 'utf-16le', 'raw'].indexOf((encoding + '').toLowerCase()) > -1)) throw new TypeError('Unknown encoding: ' + encoding);
  this._writableState.defaultEncoding = encoding;
  return this;
};

function decodeChunk(state, chunk, encoding) {
  if (!state.objectMode && state.decodeStrings !== false && typeof chunk === 'string') {
    chunk = Buffer.from(chunk, encoding);
  }
  return chunk;
}

Object.defineProperty(Writable.prototype, 'writableHighWaterMark', {
  // making it explicit this property is not enumerable
  // because otherwise some prototype manipulation in
  // userland will fail
  enumerable: false,
  get: function () {
    return this._writableState.highWaterMark;
  }
});

// if we're already writing something, then just put this
// in the queue, and wait our turn.  Otherwise, call _write
// If we return false, then we need a drain event, so set that flag.
function writeOrBuffer(stream, state, isBuf, chunk, encoding, cb) {
  if (!isBuf) {
    var newChunk = decodeChunk(state, chunk, encoding);
    if (chunk !== newChunk) {
      isBuf = true;
      encoding = 'buffer';
      chunk = newChunk;
    }
  }
  var len = state.objectMode ? 1 : chunk.length;

  state.length += len;

  var ret = state.length < state.highWaterMark;
  // we must ensure that previous needDrain will not be reset to false.
  if (!ret) state.needDrain = true;

  if (state.writing || state.corked) {
    var last = state.lastBufferedRequest;
    state.lastBufferedRequest = {
      chunk: chunk,
      encoding: encoding,
      isBuf: isBuf,
      callback: cb,
      next: null
    };
    if (last) {
      last.next = state.lastBufferedRequest;
    } else {
      state.bufferedRequest = state.lastBufferedRequest;
    }
    state.bufferedRequestCount += 1;
  } else {
    doWrite(stream, state, false, len, chunk, encoding, cb);
  }

  return ret;
}

function doWrite(stream, state, writev, len, chunk, encoding, cb) {
  state.writelen = len;
  state.writecb = cb;
  state.writing = true;
  state.sync = true;
  if (writev) stream._writev(chunk, state.onwrite);else stream._write(chunk, encoding, state.onwrite);
  state.sync = false;
}

function onwriteError(stream, state, sync, er, cb) {
  --state.pendingcb;

  if (sync) {
    // defer the callback if we are being called synchronously
    // to avoid piling up things on the stack
    pna.nextTick(cb, er);
    // this can emit finish, and it will always happen
    // after error
    pna.nextTick(finishMaybe, stream, state);
    stream._writableState.errorEmitted = true;
    stream.emit('error', er);
  } else {
    // the caller expect this to happen before if
    // it is async
    cb(er);
    stream._writableState.errorEmitted = true;
    stream.emit('error', er);
    // this can emit finish, but finish must
    // always follow error
    finishMaybe(stream, state);
  }
}

function onwriteStateUpdate(state) {
  state.writing = false;
  state.writecb = null;
  state.length -= state.writelen;
  state.writelen = 0;
}

function onwrite(stream, er) {
  var state = stream._writableState;
  var sync = state.sync;
  var cb = state.writecb;

  onwriteStateUpdate(state);

  if (er) onwriteError(stream, state, sync, er, cb);else {
    // Check if we're actually ready to finish, but don't emit yet
    var finished = needFinish(state);

    if (!finished && !state.corked && !state.bufferProcessing && state.bufferedRequest) {
      clearBuffer(stream, state);
    }

    if (sync) {
      /*<replacement>*/
      asyncWrite(afterWrite, stream, state, finished, cb);
      /*</replacement>*/
    } else {
      afterWrite(stream, state, finished, cb);
    }
  }
}

function afterWrite(stream, state, finished, cb) {
  if (!finished) onwriteDrain(stream, state);
  state.pendingcb--;
  cb();
  finishMaybe(stream, state);
}

// Must force callback to be called on nextTick, so that we don't
// emit 'drain' before the write() consumer gets the 'false' return
// value, and has a chance to attach a 'drain' listener.
function onwriteDrain(stream, state) {
  if (state.length === 0 && state.needDrain) {
    state.needDrain = false;
    stream.emit('drain');
  }
}

// if there's something in the buffer waiting, then process it
function clearBuffer(stream, state) {
  state.bufferProcessing = true;
  var entry = state.bufferedRequest;

  if (stream._writev && entry && entry.next) {
    // Fast case, write everything using _writev()
    var l = state.bufferedRequestCount;
    var buffer = new Array(l);
    var holder = state.corkedRequestsFree;
    holder.entry = entry;

    var count = 0;
    var allBuffers = true;
    while (entry) {
      buffer[count] = entry;
      if (!entry.isBuf) allBuffers = false;
      entry = entry.next;
      count += 1;
    }
    buffer.allBuffers = allBuffers;

    doWrite(stream, state, true, state.length, buffer, '', holder.finish);

    // doWrite is almost always async, defer these to save a bit of time
    // as the hot path ends with doWrite
    state.pendingcb++;
    state.lastBufferedRequest = null;
    if (holder.next) {
      state.corkedRequestsFree = holder.next;
      holder.next = null;
    } else {
      state.corkedRequestsFree = new CorkedRequest(state);
    }
    state.bufferedRequestCount = 0;
  } else {
    // Slow case, write chunks one-by-one
    while (entry) {
      var chunk = entry.chunk;
      var encoding = entry.encoding;
      var cb = entry.callback;
      var len = state.objectMode ? 1 : chunk.length;

      doWrite(stream, state, false, len, chunk, encoding, cb);
      entry = entry.next;
      state.bufferedRequestCount--;
      // if we didn't call the onwrite immediately, then
      // it means that we need to wait until it does.
      // also, that means that the chunk and cb are currently
      // being processed, so move the buffer counter past them.
      if (state.writing) {
        break;
      }
    }

    if (entry === null) state.lastBufferedRequest = null;
  }

  state.bufferedRequest = entry;
  state.bufferProcessing = false;
}

Writable.prototype._write = function (chunk, encoding, cb) {
  cb(new Error('_write() is not implemented'));
};

Writable.prototype._writev = null;

Writable.prototype.end = function (chunk, encoding, cb) {
  var state = this._writableState;

  if (typeof chunk === 'function') {
    cb = chunk;
    chunk = null;
    encoding = null;
  } else if (typeof encoding === 'function') {
    cb = encoding;
    encoding = null;
  }

  if (chunk !== null && chunk !== undefined) this.write(chunk, encoding);

  // .end() fully uncorks
  if (state.corked) {
    state.corked = 1;
    this.uncork();
  }

  // ignore unnecessary end() calls.
  if (!state.ending && !state.finished) endWritable(this, state, cb);
};

function needFinish(state) {
  return state.ending && state.length === 0 && state.bufferedRequest === null && !state.finished && !state.writing;
}
function callFinal(stream, state) {
  stream._final(function (err) {
    state.pendingcb--;
    if (err) {
      stream.emit('error', err);
    }
    state.prefinished = true;
    stream.emit('prefinish');
    finishMaybe(stream, state);
  });
}
function prefinish(stream, state) {
  if (!state.prefinished && !state.finalCalled) {
    if (typeof stream._final === 'function') {
      state.pendingcb++;
      state.finalCalled = true;
      pna.nextTick(callFinal, stream, state);
    } else {
      state.prefinished = true;
      stream.emit('prefinish');
    }
  }
}

function finishMaybe(stream, state) {
  var need = needFinish(state);
  if (need) {
    prefinish(stream, state);
    if (state.pendingcb === 0) {
      state.finished = true;
      stream.emit('finish');
    }
  }
  return need;
}

function endWritable(stream, state, cb) {
  state.ending = true;
  finishMaybe(stream, state);
  if (cb) {
    if (state.finished) pna.nextTick(cb);else stream.once('finish', cb);
  }
  state.ended = true;
  stream.writable = false;
}

function onCorkedFinish(corkReq, state, err) {
  var entry = corkReq.entry;
  corkReq.entry = null;
  while (entry) {
    var cb = entry.callback;
    state.pendingcb--;
    cb(err);
    entry = entry.next;
  }
  if (state.corkedRequestsFree) {
    state.corkedRequestsFree.next = corkReq;
  } else {
    state.corkedRequestsFree = corkReq;
  }
}

Object.defineProperty(Writable.prototype, 'destroyed', {
  get: function () {
    if (this._writableState === undefined) {
      return false;
    }
    return this._writableState.destroyed;
  },
  set: function (value) {
    // we ignore the value if the stream
    // has not been initialized yet
    if (!this._writableState) {
      return;
    }

    // backward compatibility, the user is explicitly
    // managing destroyed
    this._writableState.destroyed = value;
  }
});

Writable.prototype.destroy = destroyImpl.destroy;
Writable.prototype._undestroy = destroyImpl.undestroy;
Writable.prototype._destroy = function (err, cb) {
  this.end();
  cb(err);
};
/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__("KCCg"), __webpack_require__("yLpj")))

/***/ }),

/***/ "3DSN":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";

// CONCATENATED MODULE: ./node_modules/vue-loader/lib/loaders/templateLoader.js??vue-loader-options!./node_modules/vue-loader/lib??vue-loader-options!./src/common/indicator/CountTo.vue?vue&type=template&id=53dff5c7&
var render = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('span',_vm._l((_vm.numDataList),function(numVale,index){return _c('div',{key:index,staticClass:"sm-component-count-to__numItem",style:([_vm.calNumBackground(numVale),_vm.numInterval,_vm.numStyle])},[_c('span',[_vm._v(_vm._s(numVale))])])}),0)}
var staticRenderFns = []


// CONCATENATED MODULE: ./src/common/indicator/CountTo.vue?vue&type=template&id=53dff5c7&
/* concated harmony reexport render */__webpack_require__.d(__webpack_exports__, "a", function() { return render; });
/* concated harmony reexport staticRenderFns */__webpack_require__.d(__webpack_exports__, "b", function() { return staticRenderFns; });


/***/ }),

/***/ "3N2c":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAhYAAAD+CAYAAABmz0wVAAAABGdBTUEAALGPC/xhBQAADb5JREFUeAHt3bGK3QkdhuFzJhtRsNRyr8DOQiHaiJ3LFILiDdhpZ7Gla2lhpxchLliE2AoSU1gIFlvY2FiK2AgK2Z1xpghvsUyW5Jt1T2aeNPvtzvzO/M9zin0hgRwPd/DX9y8vH/z2ybOfX15e/uQOvr2Tf0vH4/EX333n0bu/OR4/OvmH9YAECBAgcKsCx1t9tRN4sS/+7s9f/u/Ff359FRXfOoHHubePcBUXv//82Rd+8O/vfPUf9xbBGydAgMA9FLhTYfHw8bOvXRwu3r/6HN++h5/lKb7lv58dzr73/PzRn07x4TwTAQJ3R+DB46eXd+fdfPydfHT+zTfm/9dnH3/8N/O/PHzy9IcXx4s/XD29qDidj/Dt68/k+rM5nUfyJAQIECDwaQoc73rlfZp4XpsAAQIECBAgQIAAAQIECBAgQIAAAQIECBA4dYE35g+DnBrkm/5bSG/SHwQ6tc/e8xAgQIAAAQIECBAgQIAAAQIECBAgQIAAAQIECBAgQIAAAQIECBAgQIAAAQIECBAgQIAAAQIECBAgQIAAgbslcLz6y7q+dLfekndDgAABAgQIfFYCd+bvCvmsAP1cAgQIECBAIAFhkYVFgAABAgQIjALCYgR0ToAAAQIECCQgLLKwCBAgQIAAgVFAWIyAzgkQIECAAIEEhEUWFgECBAgQIDAKCIsR0DkBAgQIECCQgLDIwiJAgAABAgRGAWExAjonQIAAAQIEEhAWWVgECBAgQIDAKCAsRkDnBAgQIECAQALCIguLAAECBAgQGAWExQjonAABAgQIEEhAWGRhESBAgAABAqOAsBgBnRMgQIAAAQIJCIssLAIECBAgQGAUEBYjoHMCBAgQIEAgAWGRhUWAAAECBAiMAsJiBHROgAABAgQIJCAssrAIECBAgACBUUBYjIDOCRAgQIAAgQSERRYWAQIECBAgMAoIixHQOQECBAgQIJCAsMjCIkCAAAECBEYBYTECOidAgAABAgQSEBZZWAQIECBAgMAoICxGQOcECBAgQIBAAsIiC4sAAQIECBAYBYTFCOicAAECBAgQSEBYZGERIECAAAECo4CwGAGdEyBAgAABAgkIiywsAgQIECBAYBQQFiOgcwIECBAgQCABYZGFRYAAAQIECIwCwmIEdE6AAAECBAgkICyysAgQIECAAIFRQFiMgM4JECBAgACBBIRFFhYBAgQIECAwCgiLEdA5AQIECBAgkICwyMIiQIAAAQIERgFhMQI6J0CAAAECBBIQFllYBAgQIECAwCggLEZA5wQIECBAgEACwiILiwABAgQIEBgFhMUI6JwAAQIECBBIQFhkYREgQIAAAQKjgLAYAZ0TIECAAAECCQiLLCwCBAgQIEBgFBAWI6BzAgQIECBAIAFhkYVFgAABAgQIjALCYgR0ToAAAQIECCQgLLKwCBAgQIAAgVFAWIyAzgkQIECAAIEEhEUWFgECBAgQIDAKCIsR0DkBAgQIECCQgLDIwiJAgAABAgRGAWExAjonQIAAAQIEEhAWWVgECBAgQIDAKCAsRkDnBAgQIECAQALCIguLAAECBAgQGAWExQjonAABAgQIEEhAWGRhESBAgAABAqOAsBgBnRMgQIAAAQIJCIssLAIECBAgQGAUEBYjoHMCBAgQIEAgAWGRhUWAAAECBAiMAsJiBHROgAABAgQIJCAssrAIECBAgACBUUBYjIDOCRAgQIAAgQSERRYWAQIECBAgMAoIixHQOQECBAgQIJCAsMjCIkCAAAECBEYBYTECOidAgAABAgQSEBZZWAQIECBAgMAoICxGQOcECBAgQIBAAsIiC4sAAQIECBAYBYTFCOicAAECBAgQSEBYZGERIECAAAECo4CwGAGdEyBAgAABAgkIiywsAgQIECBAYBQQFiOgcwIECBAgQCABYZGFRYAAAQIECIwCwmIEdE6AAAECBAgkICyysAgQIECAAIFRQFiMgM4JECBAgACBBIRFFhYBAgQIECAwCgiLEdA5AQIECBAgkICwyMIiQIAAAQIERgFhMQI6J0CAAAECBBIQFllYBAgQIECAwCggLEZA5wQIECBAgEACwiILiwABAgQIEBgFhMUI6JwAAQIECBBIQFhkYREgQIAAAQKjgLAYAZ0TIECAAAECCQiLLCwCBAgQIEBgFBAWI6BzAgQIECBAIAFhkYVFgAABAgQIjALCYgR0ToAAAQIECCQgLLKwCBAgQIAAgVFAWIyAzgkQIECAAIEEhEUWFgECBAgQIDAKCIsR0DkBAgQIECCQgLDIwiJAgAABAgRGAWExAjonQIAAAQIEEhAWWVgECBAgQIDAKCAsRkDnBAgQIECAQALCIguLAAECBAgQGAWExQjonAABAgQIEEhAWGRhESBAgAABAqOAsBgBnRMgQIAAAQIJCIssLAIECBAgQGAUEBYjoHMCBAgQIEAgAWGRhUWAAAECBAiMAsJiBHROgAABAgQIJCAssrAIECBAgACBUUBYjIDOCRAgQIAAgQSERRYWAQIECBAgMAoIixHQOQECBAgQIJCAsMjCIkCAAAECBEYBYTECOidAgAABAgQSEBZZWAQIECBAgMAoICxGQOcECBAgQIBAAsIiC4sAAQIECBAYBYTFCOicAAECBAgQSEBYZGERIECAAAECo4CwGAGdEyBAgAABAgkIiywsAgQIECBAYBQQFiOgcwIECBAgQCABYZGFRYAAAQIECIwCwmIEdE6AAAECBAgkICyysAgQIECAAIFRQFiMgM4JECBAgACBBIRFFhYBAgQIECAwCgiLEdA5AQIECBAgkICwyMIiQIAAAQIERgFhMQI6J0CAAAECBBIQFllYBAgQIECAwCggLEZA5wQIECBAgEACwiILiwABAgQIEBgFhMUI6JwAAQIECBBIQFhkYREgQIAAAQKjgLAYAZ0TIECAAAECCQiLLCwCBAgQIEBgFBAWI6BzAgQIECBAIAFhkYVFgAABAgQIjALCYgR0ToAAAQIECCQgLLKwCBAgQIAAgVFAWIyAzgkQIECAAIEEhEUWFgECBAgQIDAKCIsR0DkBAgQIECCQgLDIwiJAgAABAgRGAWExAjonQIAAAQIEEhAWWVgECBAgQIDAKCAsRkDnBAgQIECAQALCIguLAAECBAgQGAWExQjonAABAgQIEEhAWGRhESBAgAABAqOAsBgBnRMgQIAAAQIJCIssLAIECBAgQGAUEBYjoHMCBAgQIEAgAWGRhUWAAAECBAiMAsJiBHROgAABAgQIJCAssrAIECBAgACBUUBYjIDOCRAgQIAAgQSERRYWAQIECBAgMAoIixHQOQECBAgQIJCAsMjCIkCAAAECBEYBYTECOidAgAABAgQSEBZZWAQIECBAgMAoICxGQOcECBAgQIBAAsIiC4sAAQIECBAYBYTFCOicAAECBAgQSEBYZGERIECAAAECo4CwGAGdEyBAgAABAgkIiywsAgQIECBAYBQQFiOgcwIECBAgQCABYZGFRYAAAQIECIwCwmIEdE6AAAECBAgkICyysAgQIECAAIFRQFiMgM4JECBAgACBBIRFFhYBAgQIECAwCgiLEdA5AQIECBAgkICwyMIiQIAAAQIERgFhMQI6J0CAAAECBBIQFllYBAgQIECAwCggLEZA5wQIECBAgEACwiILiwABAgQIEBgFhMUI6JwAAQIECBBIQFhkYREgQIAAAQKjgLAYAZ0TIECAAAECCQiLLCwCBAgQIEBgFBAWI6BzAgQIECBAIAFhkYVFgAABAgQIjALCYgR0ToAAAQIECCQgLLKwCBAgQIAAgVFAWIyAzgkQIECAAIEEhEUWFgECBAgQIDAKCIsR0DkBAgQIECCQgLDIwiJAgAABAgRGAWExAjonQIAAAQIEEhAWWVgECBAgQIDAKCAsRkDnBAgQIECAQALCIguLAAECBAgQGAWExQjonAABAgQIEEhAWGRhESBAgAABAqOAsBgBnRMgQIAAAQIJCIssLAIECBAgQGAUEBYjoHMCBAgQIEAgAWGRhUWAAAECBAiMAsJiBHROgAABAgQIJCAssrAIECBAgACBUUBYjIDOCRAgQIAAgQSERRYWAQIECBAgMAoIixHQOQECBAgQIJCAsMjCIkCAAAECBEYBYTECOidAgAABAgQSEBZZWAQIECBAgMAoICxGQOcECBAgQIBAAsIiC4sAAQIECBAYBYTFCOicAAECBAgQSEBYZGERIECAAAECo4CwGAGdEyBAgAABAgkIiywsAgQIECBAYBQQFiOgcwIECBAgQCABYZGFRYAAAQIECIwCwmIEdE6AAAECBAgkICyysAgQIECAAAECBAgQIECAAAECBAgQIECAAAECBAgQIECAAAECBAgQIECAAAECBAgQIECAAAECBAgQIECAAAEC91DgeA/fs7dMgAABAv8HgYdPnv3o4uLil9c/6uzs7MfP33n0qxc/9ra/9pUPPvjcX//2r/cvD4fzw+H4z7PDW99+fv71v7z4eW89/uN7l4fLn774d/+8WeB4OP7sw/NvvHfzd7z8K8Li5T6+SoAAAQKvIXDb4XD9CDe9pqh4jQ/oE06WuBAWn4DrywQIECDwagI3BcD1q9z210TFq302r/LdrxsXwuJVlH0vAQIECLxU4LbD4fqH3fSaouKlH8WtfPF14uL44PHTq9+S8osAAQIECBAgsAv8D3+y/1UxtS72AAAAAElFTkSuQmCC"

/***/ }),

/***/ "43KI":
/***/ (function(module, exports, __webpack_require__) {

exports = module.exports = __webpack_require__("rXFu");
exports.Stream = exports;
exports.Readable = exports;
exports.Writable = __webpack_require__("3BRs");
exports.Duplex = __webpack_require__("sZro");
exports.Transform = __webpack_require__("J78i");
exports.PassThrough = __webpack_require__("eA/Y");


/***/ }),

/***/ "49sm":
/***/ (function(module, exports) {

var toString = {}.toString;

module.exports = Array.isArray || function (arr) {
  return toString.call(arr) == '[object Array]';
};


/***/ }),

/***/ "4EGE":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,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"

/***/ }),

/***/ "4rkx":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACkAAAApCAQAAAACach9AAACMUlEQVR4Ae3ShY7jQBAE0Aoz/f9/HTMzhg1zrdKUrJbdx+Kd2nD8VNudfsL/Th///dyQN2TH6f3y/BGpC379rV+S+qqetBOxImNQXL8JCAr2V4iMQXHGNJxeCfZXhSRBcQMfvkOWUdtfzlLgAENmZDcmo2TVmt8OSM2eXxBp3DjHSMFutqS7SbmemzBiR+xpKCNUIRkdkkYxhAkyGoBvyQFEJEefwSmmvBfJuJ6aKqKWnAkvGZOaZXTUgFqYULWNSHUckZuR1HIIimUExutRxwzOLROIG4vKmCKQt364mIlhSyzAf1m9lHZHJZrlAOMMztRRiKimp/rpdJDc9Awry5xTZCte7FHtuS8wJgeYGrex28xNTd086Dik7vUMscQOa8y4DoGtCCSkAKlNwpgNtphjrC6MIHUkR6YWxxs6Sc5xqn222mmCRFzIt8lEdKx+ikCtg91qS2WpwVfBelJCiQJwvzixfI9cxZQWgiSJelKnwBElKYtDOb2MFbhmUigbReQBV0Cg4+qMXSxXSyGUn4UbF8l+7qdSGnTC0XLCmahIgUHLhLOhpVCtw4CzYXvLQWQbJNmxoCsOKAxSgBJno75avolkRw8iIAFcsdc02e9iyCd8tHwmeSSoKTowIgvscSGZUOA7PuCN5b2BX9mQM7S0wYhMNU74zgsPBj3HU7wguAfnxxjFQGBE6pwN+GjME9zHY7zGp8wVxMShYX9NXvEWD3HbwJf4giO4CFIQxXScH1/TM+04kkBiAAAAAElFTkSuQmCC"

/***/ }),

/***/ "50+k":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _LiquidFill_vue_vue_type_template_id_a5712d74___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("n2oB");
/* harmony import */ var _LiquidFill_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("O2Ir");
/* harmony reexport (unknown) */ for(var __WEBPACK_IMPORT_KEY__ in _LiquidFill_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_1__) if(__WEBPACK_IMPORT_KEY__ !== 'default') (function(key) { __webpack_require__.d(__webpack_exports__, key, function() { return _LiquidFill_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_1__[key]; }) }(__WEBPACK_IMPORT_KEY__));
/* harmony import */ var _node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("KHd+");





/* normalize component */

var component = Object(_node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_2__[/* default */ "a"])(
  _LiquidFill_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_1__["default"],
  _LiquidFill_vue_vue_type_template_id_a5712d74___WEBPACK_IMPORTED_MODULE_0__[/* render */ "a"],
  _LiquidFill_vue_vue_type_template_id_a5712d74___WEBPACK_IMPORTED_MODULE_0__[/* staticRenderFns */ "b"],
  false,
  null,
  null,
  null
  
)

/* harmony default export */ __webpack_exports__["default"] = (component.exports);

/***/ }),

/***/ "5L7t":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__("TqRt");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _theme = _interopRequireDefault(__webpack_require__("bCOg"));

var _cssElementQueries = __webpack_require__("h9Sk");

var _timer = _interopRequireDefault(__webpack_require__("N63c"));

var _RestService = _interopRequireDefault(__webpack_require__("w4Wy"));

//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
var _default = {
  name: 'SmProgress',
  mixins: [_theme.default, _timer.default],
  props: {
    percent: {
      type: [Number, String],
      required: true
    },
    type: {
      type: String,
      default: 'line'
    },
    strokeWidth: {
      type: [Number, String],
      default: 6
    },
    status: {
      type: String
    },
    strokeColor: {
      type: String
    },
    size: {
      type: [Number] // fix 其父元素宽高都很大的时候，需要传一个合适的size, 这时候不会自适应, 如需自适应则不传size

    },
    showInfo: {
      type: Boolean,
      default: true
    },
    gapDegree: {
      type: Number,
      default: 0
    },
    gapPosition: {
      type: String,
      default: 'top',
      validator: function validator(gapPosition) {
        var positionList = ['top', 'bottom', 'left', 'right'];
        return positionList.includes(gapPosition);
      }
    },
    strokeLinecap: {
      type: String,
      default: 'round',
      validator: function validator(strokeLinecap) {
        var strokeLinecapList = ['round', 'square'];
        return strokeLinecapList.includes(strokeLinecap);
      }
    },
    url: {
      type: String
    },
    field: {
      type: String
    },
    proxy: {
      type: String
    }
  },
  data: function data() {
    return {
      colorData: '',
      circleWidth: 0,
      finalPercent: this.percent
    };
  },
  computed: {
    calWidth: function calWidth() {
      if (this.size) {
        return this.size;
      }

      return this.circleWidth;
    }
  },
  watch: {
    strokeColor: function strokeColor(val) {
      this.colorData = val;
    },
    textColorsData: {
      handler: function handler() {
        if (this.progressTextNode) {
          this.progressTextNode.style.color = this.getTextColor;
        }
      }
    },
    percent: function percent(val) {
      this.finalPercent = val;
    },
    url: {
      handler: function handler(val) {
        if (val) {
          this.getData();
        } else {
          this.finalPercent = this.percent;
          this.features = null;
        }
      },
      immediate: true
    },
    field: function field() {
      this.setPercent(this.features);
    },
    proxy: function proxy() {
      this.restService && this.restService.setProxy(this.proxy);

      if (this.url) {
        this.getData();
      }
    }
  },
  created: function created() {
    this.colorData = this.strokeColor || this.getColor(0);
  },
  mounted: function mounted() {
    var _this = this;

    this.$on('theme-style-changed', function () {
      _this.colorData = _this.getColor(0);
    });
    this.progressTextNode = this.$el.querySelector('.ant-progress-text');
    this.progressTextNode.style.color = this.getTextColor;
    this.resizeObsever = new _cssElementQueries.ResizeSensor(this.$el, function () {
      _this.resize();
    });
  },
  beforeDestroy: function beforeDestroy() {
    this.restService && this.restService.remove('getdatasucceeded');
  },
  methods: {
    resize: function resize() {
      this.circleWidth = Math.min(this.$el.offsetWidth, this.$el.offsetHeight);
    },
    timing: function timing() {
      this.getData();
    },
    fetchData: function fetchData(_ref) {
      var features = _ref.features;
      this.features = features;
      this.setPercent(features);
    },
    getData: function getData() {
      if (!this.restService) {
        this.restService = new _RestService.default({
          proxy: this.proxy
        });
        this.restService.on({
          getdatasucceeded: this.fetchData
        });
      }

      this.restService.getData(this.url);
    },
    setPercent: function setPercent(features) {
      if (features && !!features.length) {
        var field = this.field;
        this.finalPercent = features[0].properties[field];
      }
    }
  }
};
exports.default = _default;

/***/ }),

/***/ "6TV0":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__("TqRt");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = getFeatures;

var _iServerRestService = _interopRequireDefault(__webpack_require__("+Db8"));

var _iPortalDataService = _interopRequireDefault(__webpack_require__("nDi8"));

var _RestService = _interopRequireDefault(__webpack_require__("w4Wy"));

function getFeatures(dataset) {
  var promise = new Promise(function (resolve, reject) {
    var url = dataset.url,
        type = dataset.type,
        maxFeatures = dataset.maxFeatures,
        attributeFilter = dataset.attributeFilter,
        dataName = dataset.dataName,
        layerName = dataset.layerName,
        withCredentials = dataset.withCredentials,
        preferContent = dataset.preferContent;

    if (dataset && url && type) {
      var superMapService;
      var queryInfo = {
        maxFeatures: maxFeatures,
        attributeFilter: attributeFilter
      };

      if (type === 'iServer') {
        var datasetInfo;
        var options = {};

        if (dataset.proxy) {
          options.proxy = dataset.proxy;
        }

        superMapService = new _iServerRestService.default(dataset.url, options);

        if (dataName) {
          var arr = dataName[0].split(':');
          datasetInfo = {
            datasetName: arr[1],
            dataSourceName: arr[0],
            dataUrl: url
          };
        } else {
          datasetInfo = {
            mapName: layerName,
            dataUrl: url
          };
        }

        superMapService.getData(datasetInfo, queryInfo);
      } else if (type === 'iPortal') {
        queryInfo.withCredentials = withCredentials;
        superMapService = new _iPortalDataService.default(url, withCredentials);
        superMapService.getData(queryInfo, !!preferContent);
      } else if (type === 'rest') {
        superMapService = new _RestService.default({
          proxy: dataset.proxy
        });
        superMapService.getData(url, queryInfo);
      }

      if (superMapService) {
        superMapService.on({
          getdatasucceeded: function getdatasucceeded(data) {
            resolve(data);
          },
          getdatafailed: function getdatafailed(e) {
            reject(e);
          }
        });
      }
    }
  });
  return promise;
}

/***/ }),

/***/ "6hQo":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_Card_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("ntgd");
/* harmony import */ var _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_Card_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_Card_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__);
/* harmony reexport (unknown) */ for(var __WEBPACK_IMPORT_KEY__ in _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_Card_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__) if(__WEBPACK_IMPORT_KEY__ !== 'default') (function(key) { __webpack_require__.d(__webpack_exports__, key, function() { return _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_Card_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__[key]; }) }(__WEBPACK_IMPORT_KEY__));
 /* harmony default export */ __webpack_exports__["default"] = (_node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_Card_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0___default.a); 

/***/ }),

/***/ "6sEm":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_ChartMixin_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("mu6A");
/* harmony import */ var _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_ChartMixin_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_ChartMixin_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__);
/* harmony reexport (unknown) */ for(var __WEBPACK_IMPORT_KEY__ in _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_ChartMixin_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__) if(__WEBPACK_IMPORT_KEY__ !== 'default') (function(key) { __webpack_require__.d(__webpack_exports__, key, function() { return _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_ChartMixin_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__[key]; }) }(__WEBPACK_IMPORT_KEY__));
 /* harmony default export */ __webpack_exports__["default"] = (_node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_ChartMixin_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0___default.a); 

/***/ }),

/***/ "72Xp":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";

// CONCATENATED MODULE: ./node_modules/vue-loader/lib/loaders/templateLoader.js??vue-loader-options!./node_modules/vue-loader/lib??vue-loader-options!./src/common/text/Text.vue?vue&type=template&id=d0243d1c&
var render = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{staticClass:"sm-component-text",style:([_vm.customStyle, _vm.getBackgroundStyle, _vm.getTextColorStyle])},[(_vm.href)?_c('span',[_c('a',{staticClass:"sm-component-text__href",style:([_vm.getTextColorStyle]),attrs:{"target":_vm.target,"href":_vm.href}},[_vm._v(_vm._s(_vm.finalTitle))])]):_c('span',[_vm._v(_vm._s(_vm.finalTitle))])])}
var staticRenderFns = []


// CONCATENATED MODULE: ./src/common/text/Text.vue?vue&type=template&id=d0243d1c&
/* concated harmony reexport render */__webpack_require__.d(__webpack_exports__, "a", function() { return render; });
/* concated harmony reexport staticRenderFns */__webpack_require__.d(__webpack_exports__, "b", function() { return staticRenderFns; });


/***/ }),

/***/ "7BsA":
/***/ (function(module, exports, __webpack_require__) {

!function(t,e){ true?module.exports=e():undefined}(this,function(){return function(t){function e(n){if(i[n])return i[n].exports;var a=i[n]={i:n,l:!1,exports:{}};return t[n].call(a.exports,a,a.exports,e),a.l=!0,a.exports}var i={};return e.m=t,e.c=i,e.i=function(t){return t},e.d=function(t,i,n){e.o(t,i)||Object.defineProperty(t,i,{configurable:!1,enumerable:!0,get:n})},e.n=function(t){var i=t&&t.__esModule?function(){return t.default}:function(){return t};return e.d(i,"a",i),i},e.o=function(t,e){return Object.prototype.hasOwnProperty.call(t,e)},e.p="/dist/",e(e.s=2)}([function(t,e,i){var n=i(4)(i(1),i(5),null,null);t.exports=n.exports},function(t,e,i){"use strict";Object.defineProperty(e,"__esModule",{value:!0});var n=i(3);e.default={props:{startVal:{type:Number,required:!1,default:0},endVal:{type:Number,required:!1,default:2017},duration:{type:Number,required:!1,default:3e3},autoplay:{type:Boolean,required:!1,default:!0},decimals:{type:Number,required:!1,default:0,validator:function(t){return t>=0}},decimal:{type:String,required:!1,default:"."},separator:{type:String,required:!1,default:","},prefix:{type:String,required:!1,default:""},suffix:{type:String,required:!1,default:""},useEasing:{type:Boolean,required:!1,default:!0},easingFn:{type:Function,default:function(t,e,i,n){return i*(1-Math.pow(2,-10*t/n))*1024/1023+e}}},data:function(){return{localStartVal:this.startVal,displayValue:this.formatNumber(this.startVal),printVal:null,paused:!1,localDuration:this.duration,startTime:null,timestamp:null,remaining:null,rAF:null}},computed:{countDown:function(){return this.startVal>this.endVal}},watch:{startVal:function(){this.autoplay&&this.start()},endVal:function(){this.autoplay&&this.start()}},mounted:function(){this.autoplay&&this.start(),this.$emit("mountedCallback")},methods:{start:function(){this.localStartVal=this.startVal,this.startTime=null,this.localDuration=this.duration,this.paused=!1,this.rAF=(0,n.requestAnimationFrame)(this.count)},pauseResume:function(){this.paused?(this.resume(),this.paused=!1):(this.pause(),this.paused=!0)},pause:function(){(0,n.cancelAnimationFrame)(this.rAF)},resume:function(){this.startTime=null,this.localDuration=+this.remaining,this.localStartVal=+this.printVal,(0,n.requestAnimationFrame)(this.count)},reset:function(){this.startTime=null,(0,n.cancelAnimationFrame)(this.rAF),this.displayValue=this.formatNumber(this.startVal)},count:function(t){this.startTime||(this.startTime=t),this.timestamp=t;var e=t-this.startTime;this.remaining=this.localDuration-e,this.useEasing?this.countDown?this.printVal=this.localStartVal-this.easingFn(e,0,this.localStartVal-this.endVal,this.localDuration):this.printVal=this.easingFn(e,this.localStartVal,this.endVal-this.localStartVal,this.localDuration):this.countDown?this.printVal=this.localStartVal-(this.localStartVal-this.endVal)*(e/this.localDuration):this.printVal=this.localStartVal+(this.localStartVal-this.startVal)*(e/this.localDuration),this.countDown?this.printVal=this.printVal<this.endVal?this.endVal:this.printVal:this.printVal=this.printVal>this.endVal?this.endVal:this.printVal,this.displayValue=this.formatNumber(this.printVal),e<this.localDuration?this.rAF=(0,n.requestAnimationFrame)(this.count):this.$emit("callback")},isNumber:function(t){return!isNaN(parseFloat(t))},formatNumber:function(t){t=t.toFixed(this.decimals),t+="";var e=t.split("."),i=e[0],n=e.length>1?this.decimal+e[1]:"",a=/(\d+)(\d{3})/;if(this.separator&&!this.isNumber(this.separator))for(;a.test(i);)i=i.replace(a,"$1"+this.separator+"$2");return this.prefix+i+n+this.suffix}},destroyed:function(){(0,n.cancelAnimationFrame)(this.rAF)}}},function(t,e,i){"use strict";Object.defineProperty(e,"__esModule",{value:!0});var n=i(0),a=function(t){return t&&t.__esModule?t:{default:t}}(n);e.default=a.default,"undefined"!=typeof window&&window.Vue&&window.Vue.component("count-to",a.default)},function(t,e,i){"use strict";Object.defineProperty(e,"__esModule",{value:!0});var n=0,a="webkit moz ms o".split(" "),r=void 0,o=void 0;if("undefined"==typeof window)e.requestAnimationFrame=r=function(){},e.cancelAnimationFrame=o=function(){};else{e.requestAnimationFrame=r=window.requestAnimationFrame,e.cancelAnimationFrame=o=window.cancelAnimationFrame;for(var s=void 0,u=0;u<a.length&&(!r||!o);u++)s=a[u],e.requestAnimationFrame=r=r||window[s+"RequestAnimationFrame"],e.cancelAnimationFrame=o=o||window[s+"CancelAnimationFrame"]||window[s+"CancelRequestAnimationFrame"];r&&o||(e.requestAnimationFrame=r=function(t){var e=(new Date).getTime(),i=Math.max(0,16-(e-n)),a=window.setTimeout(function(){t(e+i)},i);return n=e+i,a},e.cancelAnimationFrame=o=function(t){window.clearTimeout(t)})}e.requestAnimationFrame=r,e.cancelAnimationFrame=o},function(t,e){t.exports=function(t,e,i,n){var a,r=t=t||{},o=typeof t.default;"object"!==o&&"function"!==o||(a=t,r=t.default);var s="function"==typeof r?r.options:r;if(e&&(s.render=e.render,s.staticRenderFns=e.staticRenderFns),i&&(s._scopeId=i),n){var u=Object.create(s.computed||null);Object.keys(n).forEach(function(t){var e=n[t];u[t]=function(){return e}}),s.computed=u}return{esModule:a,exports:r,options:s}}},function(t,e){t.exports={render:function(){var t=this,e=t.$createElement;return(t._self._c||e)("span",[t._v("\n  "+t._s(t.displayValue)+"\n")])},staticRenderFns:[]}}])});
//# sourceMappingURL=vue-count-to.min.js.map

/***/ }),

/***/ "7W2i":
/***/ (function(module, exports, __webpack_require__) {

var setPrototypeOf = __webpack_require__("SksO");

function _inherits(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function");
  }

  subClass.prototype = Object.create(superClass && superClass.prototype, {
    constructor: {
      value: subClass,
      writable: true,
      configurable: true
    }
  });
  if (superClass) setPrototypeOf(subClass, superClass);
}

module.exports = _inherits;

/***/ }),

/***/ "81VL":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Iframe_vue_vue_type_template_id_37ec6382___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("2uka");
/* harmony import */ var _Iframe_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("2EDF");
/* harmony reexport (unknown) */ for(var __WEBPACK_IMPORT_KEY__ in _Iframe_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_1__) if(__WEBPACK_IMPORT_KEY__ !== 'default') (function(key) { __webpack_require__.d(__webpack_exports__, key, function() { return _Iframe_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_1__[key]; }) }(__WEBPACK_IMPORT_KEY__));
/* harmony import */ var _node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("KHd+");





/* normalize component */

var component = Object(_node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_2__[/* default */ "a"])(
  _Iframe_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_1__["default"],
  _Iframe_vue_vue_type_template_id_37ec6382___WEBPACK_IMPORTED_MODULE_0__[/* render */ "a"],
  _Iframe_vue_vue_type_template_id_37ec6382___WEBPACK_IMPORTED_MODULE_0__[/* staticRenderFns */ "b"],
  false,
  null,
  null,
  null
  
)

/* harmony default export */ __webpack_exports__["default"] = (component.exports);

/***/ }),

/***/ "8HGC":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Icon_vue_vue_type_template_id_3522372a___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("m5z/");
/* harmony import */ var _Icon_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("i7K5");
/* harmony reexport (unknown) */ for(var __WEBPACK_IMPORT_KEY__ in _Icon_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_1__) if(__WEBPACK_IMPORT_KEY__ !== 'default') (function(key) { __webpack_require__.d(__webpack_exports__, key, function() { return _Icon_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_1__[key]; }) }(__WEBPACK_IMPORT_KEY__));
/* harmony import */ var _node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("KHd+");





/* normalize component */

var component = Object(_node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_2__[/* default */ "a"])(
  _Icon_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_1__["default"],
  _Icon_vue_vue_type_template_id_3522372a___WEBPACK_IMPORTED_MODULE_0__[/* render */ "a"],
  _Icon_vue_vue_type_template_id_3522372a___WEBPACK_IMPORTED_MODULE_0__[/* staticRenderFns */ "b"],
  false,
  null,
  null,
  null
  
)

/* harmony default export */ __webpack_exports__["default"] = (component.exports);

/***/ }),

/***/ "8Q8H":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__("TqRt");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _theme = _interopRequireDefault(__webpack_require__("bCOg"));

var _timer = _interopRequireDefault(__webpack_require__("N63c"));

var _RestService = _interopRequireDefault(__webpack_require__("w4Wy"));

var _CountTo = _interopRequireDefault(__webpack_require__("C07L"));

//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
var _default2 = {
  name: 'SmIndicator',
  components: {
    countTo: _CountTo.default
  },
  mixins: [_theme.default, _timer.default],
  props: {
    title: {
      type: String,
      default: function _default() {
        return this.$t('indicator.title');
      }
    },
    unit: {
      type: String,
      default: function _default() {
        return this.$t('indicator.unit');
      }
    },
    indicatorColor: {
      type: String
    },
    fontSize: {
      type: [String, Number]
    },
    fontWeight: {
      type: [String, Number],
      default: 'border'
    },
    num: {
      type: [Number, String],
      default: 0
    },
    url: {
      type: String
    },
    proxy: {
      type: String
    },
    animated: {
      type: Boolean,
      default: false
    },
    duration: {
      type: [Number, String],
      default: 1000
    },
    decimals: {
      type: Number,
      default: -1
    },
    mode: {
      type: String,
      default: 'vertical',
      validator: function validator(val) {
        return ['vertical', 'horizontal'];
      }
    },
    separator: {
      type: String,
      default: ','
    },
    numSpacing: {
      type: Number,
      default: 0
    },
    numBackground: {
      type: Object,
      default: function _default() {
        return {
          color: 'rgba(0, 0, 0, 0)',
          image: ''
        };
      }
    },
    separatorBackground: {
      type: Boolean,
      default: false
    },
    showTitleUnit: {
      type: Boolean,
      default: true
    },
    titleField: String,
    numField: String,
    unitField: String
  },
  data: function data() {
    return {
      indicatorColorData: '',
      titleData: this.title,
      unitData: this.unit,
      numData: 0,
      startData: 0,
      indicatorNum: 0
    };
  },
  computed: {
    unit_titleStyle: function unit_titleStyle() {
      return {
        fontSize: parseFloat(this.fontSize) * 0.66 + this.fontUnit,
        fontWeight: this.fontWeight
      };
    },
    fontUnit: function fontUnit() {
      var reg = /\d+(\.\d+)?([a-z]+)/gi;
      var fontUnit = this.fontSize ? this.fontSize.replace(reg, '$2') : '';
      return fontUnit;
    },
    indicatorStyle: function indicatorStyle() {
      var style = {
        color: this.indicatorColorData
      };
      typeof this.indicatorNum === 'string' && (style.fontSize = parseFloat(this.fontSize) + this.fontUnit);
      return style;
    },
    direction: function direction() {
      return {
        vertical: 'column',
        horizontal: 'row'
      }[this.mode];
    },
    calDecimals: function calDecimals() {
      if (this.decimals > 0) {
        return this.decimals;
      }

      if (this.numData.toString().split('.')[1]) {
        return this.numData.toString().split('.')[1].length;
      }

      return 0;
    }
  },
  watch: {
    url: {
      handler: function handler(val) {
        if (val) {
          this.getData();
        } else {
          this.unitData = this.unit;
          this.changeNumData(this.num);
          this.titleData = this.title;
          this.fetchProperties = null;
        }
      },
      immediate: true
    },
    indicatorColor: function indicatorColor(val) {
      this.indicatorColorData = val;
    },
    proxy: function proxy() {
      this.restService && this.restService.setProxy(this.proxy);

      if (this.url) {
        this.getData();
      }
    }
  },
  mounted: function mounted() {
    var _this = this;

    this.$on('theme-style-changed', function () {
      _this.indicatorColorData = _this.getColor(0);
    });
    this.indicatorColorData = this.indicatorColor || this.getColor(0);
    this.partsOfPropsWatcher();
  },
  beforeDestroy: function beforeDestroy() {
    this.restService && this.restService.remove('getdatasucceeded');
  },
  methods: {
    partsOfPropsWatcher: function partsOfPropsWatcher() {
      var _this2 = this;

      var propsFields = ['title', 'unit', 'num', 'titleField', 'unitField', 'numField'];
      propsFields.forEach(function (props) {
        _this2.$watch(props, function (next) {
          switch (props) {
            case 'title':
              this.titleData = next;
              break;

            case 'titleField':
              if (this.fetchProperties && this.fetchProperties.hasOwnProperty(next)) {
                this.titleData = this.fetchProperties[this.titleField];
              } else {
                this.titleData = this.title;
              }

              break;

            case 'unit':
              this.unitData = next;
              break;

            case 'unitField':
              if (this.fetchProperties && this.fetchProperties.hasOwnProperty(next)) {
                this.unitData = this.fetchProperties[this.unitField];
              } else {
                this.unitData = this.unit;
              }

              break;

            case 'num':
              this.changeNumData(next);
              break;

            case 'numField':
              if (this.fetchProperties && this.fetchProperties.hasOwnProperty(next)) {
                this.changeNumData(this.fetchProperties[this.numField]);
              } else {
                this.changeNumData(this.num);
              }

              break;
          }
        });
      });
    },
    isNumber: function isNumber(str) {
      return /^\d+$/.test(str);
    },
    timing: function timing() {
      this.getData();
    },
    fetchData: function fetchData(_ref) {
      var features = _ref.features;

      if (features && !!features.length) {
        var properties = features[0].properties;
        this.fetchProperties = properties;
        this.unitData = properties.hasOwnProperty(this.unitField) ? properties[this.unitField] : this.unit;
        properties.hasOwnProperty(this.numField) ? this.changeNumData(properties[this.numField]) : this.changeNumData(this.num);
        this.titleData = properties.hasOwnProperty(this.titleField) ? properties[this.titleField] : this.title;
      }
    },
    getData: function getData() {
      this.getRestService().getData(this.url);
    },
    changeNumData: function changeNumData(newData) {
      this.startData = this.animated ? +this.numData : +newData;
      this.numData = +newData;
      this.indicatorNum = newData;
    },
    getRestService: function getRestService() {
      if (!this.restService) {
        this.restService = new _RestService.default({
          proxy: this.proxy
        });
        this.restService.on({
          getdatasucceeded: this.fetchData
        });
      }

      return this.restService;
    }
  }
};
exports.default = _default2;

/***/ }),

/***/ "8Wwx":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _WebMap_vue_vue_type_template_id_33038e71___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("0ow9");
/* harmony import */ var _WebMap_vue_vue_type_script_lang_ts___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("dZA3");
/* harmony reexport (unknown) */ for(var __WEBPACK_IMPORT_KEY__ in _WebMap_vue_vue_type_script_lang_ts___WEBPACK_IMPORTED_MODULE_1__) if(__WEBPACK_IMPORT_KEY__ !== 'default') (function(key) { __webpack_require__.d(__webpack_exports__, key, function() { return _WebMap_vue_vue_type_script_lang_ts___WEBPACK_IMPORTED_MODULE_1__[key]; }) }(__WEBPACK_IMPORT_KEY__));
/* harmony import */ var _node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("KHd+");





/* normalize component */

var component = Object(_node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_2__[/* default */ "a"])(
  _WebMap_vue_vue_type_script_lang_ts___WEBPACK_IMPORTED_MODULE_1__["default"],
  _WebMap_vue_vue_type_template_id_33038e71___WEBPACK_IMPORTED_MODULE_0__[/* render */ "a"],
  _WebMap_vue_vue_type_template_id_33038e71___WEBPACK_IMPORTED_MODULE_0__[/* staticRenderFns */ "b"],
  false,
  null,
  null,
  null
  
)

/* harmony default export */ __webpack_exports__["default"] = (component.exports);

/***/ }),

/***/ "8XH1":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__("TqRt");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _classCallCheck2 = _interopRequireDefault(__webpack_require__("lwsE"));

var _lang = __webpack_require__("DSM6");

var AddressMatchParameter = function AddressMatchParameter(options) {
  (0, _classCallCheck2.default)(this, AddressMatchParameter);
  this.url = options.url;
  this.name = options.name || (0, _lang.geti18n)().t('commontypes.addressMatch');
  this.proxy = options.proxy;
};

exports.default = AddressMatchParameter;

/***/ }),

/***/ "9csQ":
/***/ (function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(global) {/**
 * lodash (Custom Build) <https://lodash.com/>
 * Build: `lodash modularize exports="npm" -o ./`
 * Copyright jQuery Foundation and other contributors <https://jquery.org/>
 * Released under MIT license <https://lodash.com/license>
 * Based on Underscore.js 1.8.3 <http://underscorejs.org/LICENSE>
 * Copyright Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
 */

/** Used as references for various `Number` constants. */
var INFINITY = 1 / 0;

/** `Object#toString` result references. */
var symbolTag = '[object Symbol]';

/** Detect free variable `global` from Node.js. */
var freeGlobal = typeof global == 'object' && global && global.Object === Object && global;

/** Detect free variable `self`. */
var freeSelf = typeof self == 'object' && self && self.Object === Object && self;

/** Used as a reference to the global object. */
var root = freeGlobal || freeSelf || Function('return this')();

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Used to generate unique IDs. */
var idCounter = 0;

/**
 * Used to resolve the
 * [`toStringTag`](http://ecma-international.org/ecma-262/6.0/#sec-object.prototype.tostring)
 * of values.
 */
var objectToString = objectProto.toString;

/** Built-in value references. */
var Symbol = root.Symbol;

/** Used to convert symbols to primitives and strings. */
var symbolProto = Symbol ? Symbol.prototype : undefined,
    symbolToString = symbolProto ? symbolProto.toString : undefined;

/**
 * The base implementation of `_.toString` which doesn't convert nullish
 * values to empty strings.
 *
 * @private
 * @param {*} value The value to process.
 * @returns {string} Returns the string.
 */
function baseToString(value) {
  // Exit early for strings to avoid a performance hit in some environments.
  if (typeof value == 'string') {
    return value;
  }
  if (isSymbol(value)) {
    return symbolToString ? symbolToString.call(value) : '';
  }
  var result = (value + '');
  return (result == '0' && (1 / value) == -INFINITY) ? '-0' : result;
}

/**
 * Checks if `value` is object-like. A value is object-like if it's not `null`
 * and has a `typeof` result of "object".
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is object-like, else `false`.
 * @example
 *
 * _.isObjectLike({});
 * // => true
 *
 * _.isObjectLike([1, 2, 3]);
 * // => true
 *
 * _.isObjectLike(_.noop);
 * // => false
 *
 * _.isObjectLike(null);
 * // => false
 */
function isObjectLike(value) {
  return !!value && typeof value == 'object';
}

/**
 * Checks if `value` is classified as a `Symbol` primitive or object.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a symbol, else `false`.
 * @example
 *
 * _.isSymbol(Symbol.iterator);
 * // => true
 *
 * _.isSymbol('abc');
 * // => false
 */
function isSymbol(value) {
  return typeof value == 'symbol' ||
    (isObjectLike(value) && objectToString.call(value) == symbolTag);
}

/**
 * Converts `value` to a string. An empty string is returned for `null`
 * and `undefined` values. The sign of `-0` is preserved.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to process.
 * @returns {string} Returns the string.
 * @example
 *
 * _.toString(null);
 * // => ''
 *
 * _.toString(-0);
 * // => '-0'
 *
 * _.toString([1, 2, 3]);
 * // => '1,2,3'
 */
function toString(value) {
  return value == null ? '' : baseToString(value);
}

/**
 * Generates a unique ID. If `prefix` is given, the ID is appended to it.
 *
 * @static
 * @since 0.1.0
 * @memberOf _
 * @category Util
 * @param {string} [prefix=''] The value to prefix the ID with.
 * @returns {string} Returns the unique ID.
 * @example
 *
 * _.uniqueId('contact_');
 * // => 'contact_104'
 *
 * _.uniqueId();
 * // => '105'
 */
function uniqueId(prefix) {
  var id = ++idCounter;
  return toString(prefix) + id;
}

module.exports = uniqueId;

/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__("yLpj")))

/***/ }),

/***/ "9pJD":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,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"

/***/ }),

/***/ "9rNx":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,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"

/***/ }),

/***/ "AP2z":
/***/ (function(module, exports, __webpack_require__) {

var Symbol = __webpack_require__("nmnc");

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/**
 * Used to resolve the
 * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
 * of values.
 */
var nativeObjectToString = objectProto.toString;

/** Built-in value references. */
var symToStringTag = Symbol ? Symbol.toStringTag : undefined;

/**
 * A specialized version of `baseGetTag` which ignores `Symbol.toStringTag` values.
 *
 * @private
 * @param {*} value The value to query.
 * @returns {string} Returns the raw `toStringTag`.
 */
function getRawTag(value) {
  var isOwn = hasOwnProperty.call(value, symToStringTag),
      tag = value[symToStringTag];

  try {
    value[symToStringTag] = undefined;
    var unmasked = true;
  } catch (e) {}

  var result = nativeObjectToString.call(value);
  if (unmasked) {
    if (isOwn) {
      value[symToStringTag] = tag;
    } else {
      delete value[symToStringTag];
    }
  }
  return result;
}

module.exports = getRawTag;


/***/ }),

/***/ "ATId":
/***/ (function(module, exports, __webpack_require__) {

!function(t,e){ true?module.exports=e(__webpack_require__("WOGj"),__webpack_require__("Qu5F")):undefined}(this,function(m,d){"use strict";var t;return m=m&&m.hasOwnProperty("default")?m.default:m,d=d&&d.hasOwnProperty("default")?d.default:d,function(t){var u;t.exports;(u=window).DOMParser=window.DOMParser;function p(){return document.createElement("canvas")}var f,c=function(t,e,i){if(null!=t||null!=e||null!=i){var n=function(s){var A={opts:s,FRAMERATE:30,MAX_VIRTUAL_PIXELS:3e4,rootEmSize:12,emSize:12,log:function(t){}};1==A.opts.log&&"undefined"!=typeof console&&(A.log=function(t){console.log(t)});A.init=function(t){var e=0;A.UniqueId=function(){return"canvg"+ ++e},A.Definitions={},A.Styles={},A.StylesSpecificity={},A.Animations=[],A.Images=[],A.ctx=t,A.ViewPort=new function(){this.viewPorts=[],this.Clear=function(){this.viewPorts=[]},this.SetCurrent=function(t,e){this.viewPorts.push({width:t,height:e})},this.RemoveCurrent=function(){this.viewPorts.pop()},this.Current=function(){return this.viewPorts[this.viewPorts.length-1]},this.width=function(){return this.Current().width},this.height=function(){return this.Current().height},this.ComputeSize=function(t){return null!=t&&"number"==typeof t?t:"x"==t?this.width():"y"==t?this.height():Math.sqrt(Math.pow(this.width(),2)+Math.pow(this.height(),2))/Math.sqrt(2)}}},A.init(),A.ImagesLoaded=function(){for(var t=0;t<A.Images.length;t++)if(!A.Images[t].loaded)return!1;return!0},A.trim=function(t){return t.replace(/^\s+|\s+$/g,"")},A.compressSpaces=function(t){return t.replace(/(?!\u3000)\s+/gm," ")},A.ajax=function(t){var e;return(e=u.XMLHttpRequest?new u.XMLHttpRequest:new ActiveXObject("Microsoft.XMLHTTP"))?(e.open("GET",t,!1),e.send(null),e.responseText):null},A.parseXml=function(e){if("undefined"!=typeof Windows&&void 0!==Windows.Data&&void 0!==Windows.Data.Xml){var t=new Windows.Data.Xml.Dom.XmlDocument,i=new Windows.Data.Xml.Dom.XmlLoadSettings;return i.prohibitDtd=!1,t.loadXml(e,i),t}if(!u.DOMParser){e=e.replace(/<!DOCTYPE svg[^>]*>/,"");var t=new ActiveXObject("Microsoft.XMLDOM");return t.async="false",t.loadXML(e),t}try{var n=s.xmldom?new u.DOMParser(s.xmldom):new u.DOMParser;return n.parseFromString(e,"image/svg+xml")}catch(t){return(n=s.xmldom?new u.DOMParser(s.xmldom):new u.DOMParser).parseFromString(e,"text/xml")}},A.Property=function(t,e){this.name=t,this.value=e},A.Property.prototype.getValue=function(){return this.value},A.Property.prototype.hasValue=function(){return null!=this.value&&""!==this.value},A.Property.prototype.numValue=function(){if(!this.hasValue())return 0;var t=parseFloat(this.value);return(this.value+"").match(/%$/)&&(t/=100),t},A.Property.prototype.valueOrDefault=function(t){return this.hasValue()?this.value:t},A.Property.prototype.numValueOrDefault=function(t){return this.hasValue()?this.numValue():t},A.Property.prototype.addOpacity=function(t){var e=this.value;if(null!=t.value&&""!=t.value&&"string"==typeof this.value){var i=new m(this.value);i.ok&&(e="rgba("+i.r+", "+i.g+", "+i.b+", "+t.numValue()+")")}return new A.Property(this.name,e)},A.Property.prototype.getDefinition=function(){var t=this.value.match(/#([^\)'"]+)/);return t&&(t=t[1]),t||(t=this.value),A.Definitions[t]},A.Property.prototype.isUrlDefinition=function(){return 0==this.value.indexOf("url(")},A.Property.prototype.getFillStyleDefinition=function(t,e){var i=this.getDefinition();if(null!=i&&i.createGradient)return i.createGradient(A.ctx,t,e);if(null!=i&&i.createPattern){if(i.getHrefAttribute().hasValue()){var n=i.attribute("patternTransform");i=i.getHrefAttribute().getDefinition(),n.hasValue()&&(i.attribute("patternTransform",!0).value=n.value)}return i.createPattern(A.ctx,t)}return null},A.Property.prototype.getDPI=function(t){return 96},A.Property.prototype.getREM=function(t){return A.rootEmSize},A.Property.prototype.getEM=function(t){return A.emSize},A.Property.prototype.getUnits=function(){var t=this.value+"";return t.replace(/[0-9\.\-]/g,"")},A.Property.prototype.isPixels=function(){if(!this.hasValue())return!1;var t=this.value+"";return!!t.match(/px$/)||!!t.match(/^[0-9]+$/)},A.Property.prototype.toPixels=function(t,e){if(!this.hasValue())return 0;var i=this.value+"";if(i.match(/rem$/))return this.numValue()*this.getREM(t);if(i.match(/em$/))return this.numValue()*this.getEM(t);if(i.match(/ex$/))return this.numValue()*this.getEM(t)/2;if(i.match(/px$/))return this.numValue();if(i.match(/pt$/))return this.numValue()*this.getDPI(t)*(1/72);if(i.match(/pc$/))return 15*this.numValue();if(i.match(/cm$/))return this.numValue()*this.getDPI(t)/2.54;if(i.match(/mm$/))return this.numValue()*this.getDPI(t)/25.4;if(i.match(/in$/))return this.numValue()*this.getDPI(t);if(i.match(/%$/))return this.numValue()*A.ViewPort.ComputeSize(t);var n=this.numValue();return e&&n<1?n*A.ViewPort.ComputeSize(t):n},A.Property.prototype.toMilliseconds=function(){if(!this.hasValue())return 0;var t=this.value+"";return t.match(/s$/)?1e3*this.numValue():(t.match(/ms$/),this.numValue())},A.Property.prototype.toRadians=function(){if(!this.hasValue())return 0;var t=this.value+"";return t.match(/deg$/)?this.numValue()*(Math.PI/180):t.match(/grad$/)?this.numValue()*(Math.PI/200):t.match(/rad$/)?this.numValue():this.numValue()*(Math.PI/180)};var t={baseline:"alphabetic","before-edge":"top","text-before-edge":"top",middle:"middle",central:"middle","after-edge":"bottom","text-after-edge":"bottom",ideographic:"ideographic",alphabetic:"alphabetic",hanging:"hanging",mathematical:"alphabetic"};return A.Property.prototype.toTextBaseline=function(){return this.hasValue()?t[this.value]:null},A.Font=new function(){this.Styles="normal|italic|oblique|inherit",this.Variants="normal|small-caps|inherit",this.Weights="normal|bold|bolder|lighter|100|200|300|400|500|600|700|800|900|inherit",this.CreateFont=function(t,e,i,n,s,a){var r=null!=a?this.Parse(a):this.CreateFont("","","","","",A.ctx.font);return{fontFamily:s=s||r.fontFamily,fontSize:n||r.fontSize,fontStyle:t||r.fontStyle,fontWeight:i||r.fontWeight,fontVariant:e||r.fontVariant,toString:function(){return[this.fontStyle,this.fontVariant,this.fontWeight,this.fontSize,this.fontFamily].join(" ")}}};var r=this;this.Parse=function(t){for(var e={},i=A.trim(A.compressSpaces(t||"")).split(" "),n={fontSize:!1,fontStyle:!1,fontWeight:!1,fontVariant:!1},s="",a=0;a<i.length;a++)n.fontStyle||-1==r.Styles.indexOf(i[a])?n.fontVariant||-1==r.Variants.indexOf(i[a])?n.fontWeight||-1==r.Weights.indexOf(i[a])?n.fontSize?"inherit"!=i[a]&&(s+=i[a]):("inherit"!=i[a]&&(e.fontSize=i[a].split("/")[0]),n.fontStyle=n.fontVariant=n.fontWeight=n.fontSize=!0):("inherit"!=i[a]&&(e.fontWeight=i[a]),n.fontStyle=n.fontVariant=n.fontWeight=!0):("inherit"!=i[a]&&(e.fontVariant=i[a]),n.fontStyle=n.fontVariant=!0):("inherit"!=i[a]&&(e.fontStyle=i[a]),n.fontStyle=!0);return""!=s&&(e.fontFamily=s),e}},A.ToNumberArray=function(t){for(var e=A.trim(A.compressSpaces((t||"").replace(/,/g," "))).split(" "),i=0;i<e.length;i++)e[i]=parseFloat(e[i]);return e},A.Point=function(t,e){this.x=t,this.y=e},A.Point.prototype.angleTo=function(t){return Math.atan2(t.y-this.y,t.x-this.x)},A.Point.prototype.applyTransform=function(t){var e=this.x*t[0]+this.y*t[2]+t[4],i=this.x*t[1]+this.y*t[3]+t[5];this.x=e,this.y=i},A.CreatePoint=function(t){var e=A.ToNumberArray(t);return new A.Point(e[0],e[1])},A.CreatePath=function(t){for(var e=A.ToNumberArray(t),i=[],n=0;n<e.length;n+=2)i.push(new A.Point(e[n],e[n+1]));return i},A.BoundingBox=function(t,e,i,n){this.x1=Number.NaN,this.y1=Number.NaN,this.x2=Number.NaN,this.y2=Number.NaN,this.x=function(){return this.x1},this.y=function(){return this.y1},this.width=function(){return this.x2-this.x1},this.height=function(){return this.y2-this.y1},this.addPoint=function(t,e){null!=t&&((isNaN(this.x1)||isNaN(this.x2))&&(this.x1=t,this.x2=t),t<this.x1&&(this.x1=t),t>this.x2&&(this.x2=t)),null!=e&&((isNaN(this.y1)||isNaN(this.y2))&&(this.y1=e,this.y2=e),e<this.y1&&(this.y1=e),e>this.y2&&(this.y2=e))},this.addX=function(t){this.addPoint(t,null)},this.addY=function(t){this.addPoint(null,t)},this.addBoundingBox=function(t){this.addPoint(t.x1,t.y1),this.addPoint(t.x2,t.y2)},this.addQuadraticCurve=function(t,e,i,n,s,a){var r=t+2/3*(i-t),o=e+2/3*(n-e),l=r+1/3*(s-t),h=o+1/3*(a-e);this.addBezierCurve(t,e,r,l,o,h,s,a)},this.addBezierCurve=function(t,e,i,n,s,a,r,o){var l=[t,e],h=[i,n],u=[s,a],c=[r,o];this.addPoint(l[0],l[1]),this.addPoint(c[0],c[1]);for(var f=0;f<=1;f++){var m=function(t){return Math.pow(1-t,3)*l[f]+3*Math.pow(1-t,2)*t*h[f]+3*(1-t)*Math.pow(t,2)*u[f]+Math.pow(t,3)*c[f]},p=6*l[f]-12*h[f]+6*u[f],d=-3*l[f]+9*h[f]-9*u[f]+3*c[f],y=3*h[f]-3*l[f];if(0!=d){var v=Math.pow(p,2)-4*y*d;if(!(v<0)){var g=(-p+Math.sqrt(v))/(2*d);0<g&&g<1&&(0==f&&this.addX(m(g)),1==f&&this.addY(m(g)));var x=(-p-Math.sqrt(v))/(2*d);0<x&&x<1&&(0==f&&this.addX(m(x)),1==f&&this.addY(m(x)))}}else{if(0==p)continue;var b=-y/p;0<b&&b<1&&(0==f&&this.addX(m(b)),1==f&&this.addY(m(b)))}}},this.isPointInBox=function(t,e){return this.x1<=t&&t<=this.x2&&this.y1<=e&&e<=this.y2},this.addPoint(t,e),this.addPoint(i,n)},A.Transform=function(t){var e=this;this.Type={},this.Type.translate=function(t){this.p=A.CreatePoint(t),this.apply=function(t){t.translate(this.p.x||0,this.p.y||0)},this.unapply=function(t){t.translate(-1*this.p.x||0,-1*this.p.y||0)},this.applyToPoint=function(t){t.applyTransform([1,0,0,1,this.p.x||0,this.p.y||0])}},this.Type.rotate=function(t){var e=A.ToNumberArray(t);this.angle=new A.Property("angle",e[0]),this.cx=e[1]||0,this.cy=e[2]||0,this.apply=function(t){t.translate(this.cx,this.cy),t.rotate(this.angle.toRadians()),t.translate(-this.cx,-this.cy)},this.unapply=function(t){t.translate(this.cx,this.cy),t.rotate(-1*this.angle.toRadians()),t.translate(-this.cx,-this.cy)},this.applyToPoint=function(t){var e=this.angle.toRadians();t.applyTransform([1,0,0,1,this.p.x||0,this.p.y||0]),t.applyTransform([Math.cos(e),Math.sin(e),-Math.sin(e),Math.cos(e),0,0]),t.applyTransform([1,0,0,1,-this.p.x||0,-this.p.y||0])}},this.Type.scale=function(t){this.p=A.CreatePoint(t),this.apply=function(t){t.scale(this.p.x||1,this.p.y||this.p.x||1)},this.unapply=function(t){t.scale(1/this.p.x||1,1/this.p.y||this.p.x||1)},this.applyToPoint=function(t){t.applyTransform([this.p.x||0,0,0,this.p.y||0,0,0])}},this.Type.matrix=function(t){this.m=A.ToNumberArray(t),this.apply=function(t){t.transform(this.m[0],this.m[1],this.m[2],this.m[3],this.m[4],this.m[5])},this.unapply=function(t){var e=this.m[0],i=this.m[2],n=this.m[4],s=this.m[1],a=this.m[3],r=this.m[5],o=1/(e*(1*a-0*r)-i*(1*s-0*r)+n*(0*s-0*a));t.transform(o*(1*a-0*r),o*(0*r-1*s),o*(0*n-1*i),o*(1*e-0*n),o*(i*r-n*a),o*(n*s-e*r))},this.applyToPoint=function(t){t.applyTransform(this.m)}},this.Type.SkewBase=function(t){this.base=e.Type.matrix,this.base(t),this.angle=new A.Property("angle",t)},this.Type.SkewBase.prototype=new this.Type.matrix,this.Type.skewX=function(t){this.base=e.Type.SkewBase,this.base(t),this.m=[1,0,Math.tan(this.angle.toRadians()),1,0,0]},this.Type.skewX.prototype=new this.Type.SkewBase,this.Type.skewY=function(t){this.base=e.Type.SkewBase,this.base(t),this.m=[1,Math.tan(this.angle.toRadians()),0,1,0,0]},this.Type.skewY.prototype=new this.Type.SkewBase,this.transforms=[],this.apply=function(t){for(var e=0;e<this.transforms.length;e++)this.transforms[e].apply(t)},this.unapply=function(t){for(var e=this.transforms.length-1;0<=e;e--)this.transforms[e].unapply(t)},this.applyToPoint=function(t){for(var e=0;e<this.transforms.length;e++)this.transforms[e].applyToPoint(t)};for(var i=A.trim(A.compressSpaces(t)).replace(/\)([a-zA-Z])/g,") $1").replace(/\)(\s?,\s?)/g,") ").split(/\s(?=[a-z])/),n=0;n<i.length;n++)if("none"!==i[n]){var s=A.trim(i[n].split("(")[0]),a=i[n].split("(")[1].replace(")",""),r=this.Type[s];if(void 0!==r){var o=new r(a);o.type=s,this.transforms.push(o)}}},A.AspectRatio=function(t,e,i,n,s,a,r,o,l,h){var u=(e=(e=A.compressSpaces(e)).replace(/^defer\s/,"")).split(" ")[0]||"xMidYMid",c=e.split(" ")[1]||"meet",f=i/n,m=s/a,p=Math.min(f,m),d=Math.max(f,m);"meet"==c&&(n*=p,a*=p),"slice"==c&&(n*=d,a*=d),l=new A.Property("refX",l),h=new A.Property("refY",h),l.hasValue()&&h.hasValue()?t.translate(-p*l.toPixels("x"),-p*h.toPixels("y")):(u.match(/^xMid/)&&("meet"==c&&p==m||"slice"==c&&d==m)&&t.translate(i/2-n/2,0),u.match(/YMid$/)&&("meet"==c&&p==f||"slice"==c&&d==f)&&t.translate(0,s/2-a/2),u.match(/^xMax/)&&("meet"==c&&p==m||"slice"==c&&d==m)&&t.translate(i-n,0),u.match(/YMax$/)&&("meet"==c&&p==f||"slice"==c&&d==f)&&t.translate(0,s-a)),"none"==u?t.scale(f,m):"meet"==c?t.scale(p,p):"slice"==c&&t.scale(d,d),t.translate(null==r?0:-r,null==o?0:-o)},A.Element={},A.EmptyProperty=new A.Property("EMPTY",""),A.Element.ElementBase=function(a){this.attributes={},this.styles={},this.stylesSpecificity={},this.children=[],this.attribute=function(t,e){var i=this.attributes[t];return null!=i?i:(1==e&&(i=new A.Property(t,""),this.attributes[t]=i),i||A.EmptyProperty)},this.getHrefAttribute=function(){for(var t in this.attributes)if("href"==t||t.match(/:href$/))return this.attributes[t];return A.EmptyProperty},this.style=function(t,e,i){var n=this.styles[t];if(null!=n)return n;var s=this.attribute(t);if(null!=s&&s.hasValue())return this.styles[t]=s;if(1!=i){var a=this.parent;if(null!=a){var r=a.style(t);if(null!=r&&r.hasValue())return r}}return 1==e&&(n=new A.Property(t,""),this.styles[t]=n),n||A.EmptyProperty},this.render=function(t){if("none"!=this.style("display").value&&"hidden"!=this.style("visibility").value){if(t.save(),this.style("mask").hasValue()){var e=this.style("mask").getDefinition();null!=e&&e.apply(t,this)}else if(this.style("filter").hasValue()){var i=this.style("filter").getDefinition();null!=i&&i.apply(t,this)}else this.setContext(t),this.renderChildren(t),this.clearContext(t);t.restore()}},this.setContext=function(t){},this.clearContext=function(t){},this.renderChildren=function(t){for(var e=0;e<this.children.length;e++)this.children[e].render(t)},this.addChild=function(t,e){var i=t;e&&(i=A.CreateElement(t)),i.parent=this,"title"!=i.type&&this.children.push(i)},this.addStylesFromStyleDefinition=function(){for(var t in A.Styles)if("@"!=t[0]&&f(a,t)){var e=A.Styles[t],i=A.StylesSpecificity[t];if(null!=e)for(var n in e){var s=this.stylesSpecificity[n];void 0===s&&(s="000"),s<i&&(this.styles[n]=e[n],this.stylesSpecificity[n]=i)}}};var t,e=new RegExp("^[A-Z-]+$");if(null!=a&&1==a.nodeType){for(var i=0;i<a.attributes.length;i++){var n=a.attributes[i],s=(t=n.nodeName,e.test(t)?t.toLowerCase():t);this.attributes[s]=new A.Property(s,n.value)}if(this.addStylesFromStyleDefinition(),this.attribute("style").hasValue()){var r=this.attribute("style").value.split(";");for(i=0;i<r.length;i++)if(""!=A.trim(r[i])){var o=r[i].split(":"),l=A.trim(o[0]),h=A.trim(o[1]);this.styles[l]=new A.Property(l,h)}}for(this.attribute("id").hasValue()&&null==A.Definitions[this.attribute("id").value]&&(A.Definitions[this.attribute("id").value]=this),i=0;i<a.childNodes.length;i++){var u=a.childNodes[i];if(1==u.nodeType&&this.addChild(u,!0),this.captureTextNodes&&(3==u.nodeType||4==u.nodeType)){var c=u.value||u.text||u.textContent||"";""!=A.compressSpaces(c)&&this.addChild(new A.Element.tspan(u),!1)}}}},A.Element.RenderedElementBase=function(t){this.base=A.Element.ElementBase,this.base(t),this.calculateOpacity=function(){for(var t=1,e=this;null!=e;){var i=e.style("opacity",!1,!0);i.hasValue()&&(t*=i.numValue()),e=e.parent}return t},this.setContext=function(t,e){if(!e){var i;if(this.style("fill").isUrlDefinition())null!=(i=this.style("fill").getFillStyleDefinition(this,this.style("fill-opacity")))&&(t.fillStyle=i);else if(this.style("fill").hasValue()){var n;"currentColor"==(n=this.style("fill")).value&&(n.value=this.style("color").value),"inherit"!=n.value&&(t.fillStyle="none"==n.value?"rgba(0,0,0,0)":n.value)}if(this.style("fill-opacity").hasValue()&&(n=(n=new A.Property("fill",t.fillStyle)).addOpacity(this.style("fill-opacity")),t.fillStyle=n.value),this.style("stroke").isUrlDefinition())null!=(i=this.style("stroke").getFillStyleDefinition(this,this.style("stroke-opacity")))&&(t.strokeStyle=i);else if(this.style("stroke").hasValue()){var s;"currentColor"==(s=this.style("stroke")).value&&(s.value=this.style("color").value),"inherit"!=s.value&&(t.strokeStyle="none"==s.value?"rgba(0,0,0,0)":s.value)}if(this.style("stroke-opacity").hasValue()&&(s=(s=new A.Property("stroke",t.strokeStyle)).addOpacity(this.style("stroke-opacity")),t.strokeStyle=s.value),this.style("stroke-width").hasValue()){var a=this.style("stroke-width").toPixels();t.lineWidth=0==a?.001:a}if(this.style("stroke-linecap").hasValue()&&(t.lineCap=this.style("stroke-linecap").value),this.style("stroke-linejoin").hasValue()&&(t.lineJoin=this.style("stroke-linejoin").value),this.style("stroke-miterlimit").hasValue()&&(t.miterLimit=this.style("stroke-miterlimit").value),this.style("paint-order").hasValue()&&(t.paintOrder=this.style("paint-order").value),this.style("stroke-dasharray").hasValue()&&"none"!=this.style("stroke-dasharray").value){var r=A.ToNumberArray(this.style("stroke-dasharray").value);void 0!==t.setLineDash?t.setLineDash(r):void 0!==t.webkitLineDash?t.webkitLineDash=r:void 0===t.mozDash||1==r.length&&0==r[0]||(t.mozDash=r);var o=this.style("stroke-dashoffset").toPixels();void 0!==t.lineDashOffset?t.lineDashOffset=o:void 0!==t.webkitLineDashOffset?t.webkitLineDashOffset=o:void 0!==t.mozDashOffset&&(t.mozDashOffset=o)}}if(void 0!==t.font){t.font=A.Font.CreateFont(this.style("font-style").value,this.style("font-variant").value,this.style("font-weight").value,this.style("font-size").hasValue()?this.style("font-size").toPixels()+"px":"",this.style("font-family").value).toString();var l=this.style("font-size",!1,!1);l.isPixels()&&(A.emSize=l.toPixels())}if(this.style("transform",!1,!0).hasValue()&&new A.Transform(this.style("transform",!1,!0).value).apply(t),this.style("clip-path",!1,!0).hasValue()){var h=this.style("clip-path",!1,!0).getDefinition();null!=h&&h.apply(t)}t.globalAlpha=this.calculateOpacity()}},A.Element.RenderedElementBase.prototype=new A.Element.ElementBase,A.Element.PathElementBase=function(t){this.base=A.Element.RenderedElementBase,this.base(t),this.path=function(t){return null!=t&&t.beginPath(),new A.BoundingBox},this.renderChildren=function(t){this.path(t),A.Mouse.checkPath(this,t),""!=t.fillStyle&&("inherit"!=this.style("fill-rule").valueOrDefault("inherit")?t.fill(this.style("fill-rule").value):t.fill()),""!=t.strokeStyle&&t.stroke();var e=this.getMarkers();if(null!=e){if(this.style("marker-start").isUrlDefinition()&&(i=this.style("marker-start").getDefinition()).render(t,e[0][0],e[0][1]),this.style("marker-mid").isUrlDefinition())for(var i=this.style("marker-mid").getDefinition(),n=1;n<e.length-1;n++)i.render(t,e[n][0],e[n][1]);this.style("marker-end").isUrlDefinition()&&(i=this.style("marker-end").getDefinition()).render(t,e[e.length-1][0],e[e.length-1][1])}},this.getBoundingBox=function(){return this.path()},this.getMarkers=function(){return null}},A.Element.PathElementBase.prototype=new A.Element.RenderedElementBase,A.Element.svg=function(t){this.base=A.Element.RenderedElementBase,this.base(t),this.baseClearContext=this.clearContext,this.clearContext=function(t){this.baseClearContext(t),A.ViewPort.RemoveCurrent()},this.baseSetContext=this.setContext,this.setContext=function(t){if(t.strokeStyle="rgba(0,0,0,0)",t.lineCap="butt",t.lineJoin="miter",t.miterLimit=4,t.canvas.style&&void 0!==t.font&&void 0!==u.getComputedStyle){t.font=u.getComputedStyle(t.canvas).getPropertyValue("font");var e=new A.Property("fontSize",A.Font.Parse(t.font).fontSize);e.hasValue()&&(A.rootEmSize=A.emSize=e.toPixels("y"))}this.baseSetContext(t),this.attribute("x").hasValue()||(this.attribute("x",!0).value=0),this.attribute("y").hasValue()||(this.attribute("y",!0).value=0),t.translate(this.attribute("x").toPixels("x"),this.attribute("y").toPixels("y"));var i=A.ViewPort.width(),n=A.ViewPort.height();if(this.attribute("width").hasValue()||(this.attribute("width",!0).value="100%"),this.attribute("height").hasValue()||(this.attribute("height",!0).value="100%"),void 0===this.root){i=this.attribute("width").toPixels("x"),n=this.attribute("height").toPixels("y");var s=0,a=0;this.attribute("refX").hasValue()&&this.attribute("refY").hasValue()&&(s=-this.attribute("refX").toPixels("x"),a=-this.attribute("refY").toPixels("y")),"visible"!=this.attribute("overflow").valueOrDefault("hidden")&&(t.beginPath(),t.moveTo(s,a),t.lineTo(i,a),t.lineTo(i,n),t.lineTo(s,n),t.closePath(),t.clip())}if(A.ViewPort.SetCurrent(i,n),this.attribute("viewBox").hasValue()){var r=A.ToNumberArray(this.attribute("viewBox").value),o=r[0],l=r[1];i=r[2],n=r[3],A.AspectRatio(t,this.attribute("preserveAspectRatio").value,A.ViewPort.width(),i,A.ViewPort.height(),n,o,l,this.attribute("refX").value,this.attribute("refY").value),A.ViewPort.RemoveCurrent(),A.ViewPort.SetCurrent(r[2],r[3])}}},A.Element.svg.prototype=new A.Element.RenderedElementBase,A.Element.rect=function(t){this.base=A.Element.PathElementBase,this.base(t),this.path=function(t){var e=this.attribute("x").toPixels("x"),i=this.attribute("y").toPixels("y"),n=this.attribute("width").toPixels("x"),s=this.attribute("height").toPixels("y"),a=this.attribute("rx").toPixels("x"),r=this.attribute("ry").toPixels("y");if(this.attribute("rx").hasValue()&&!this.attribute("ry").hasValue()&&(r=a),this.attribute("ry").hasValue()&&!this.attribute("rx").hasValue()&&(a=r),a=Math.min(a,n/2),r=Math.min(r,s/2),null!=t){var o=(Math.sqrt(2)-1)/3*4;t.beginPath(),t.moveTo(e+a,i),t.lineTo(e+n-a,i),t.bezierCurveTo(e+n-a+o*a,i,e+n,i+r-o*r,e+n,i+r),t.lineTo(e+n,i+s-r),t.bezierCurveTo(e+n,i+s-r+o*r,e+n-a+o*a,i+s,e+n-a,i+s),t.lineTo(e+a,i+s),t.bezierCurveTo(e+a-o*a,i+s,e,i+s-r+o*r,e,i+s-r),t.lineTo(e,i+r),t.bezierCurveTo(e,i+r-o*r,e+a-o*a,i,e+a,i),t.closePath()}return new A.BoundingBox(e,i,e+n,i+s)}},A.Element.rect.prototype=new A.Element.PathElementBase,A.Element.circle=function(t){this.base=A.Element.PathElementBase,this.base(t),this.path=function(t){var e=this.attribute("cx").toPixels("x"),i=this.attribute("cy").toPixels("y"),n=this.attribute("r").toPixels();return null!=t&&(t.beginPath(),t.arc(e,i,n,0,2*Math.PI,!1),t.closePath()),new A.BoundingBox(e-n,i-n,e+n,i+n)}},A.Element.circle.prototype=new A.Element.PathElementBase,A.Element.ellipse=function(t){this.base=A.Element.PathElementBase,this.base(t),this.path=function(t){var e=(Math.sqrt(2)-1)/3*4,i=this.attribute("rx").toPixels("x"),n=this.attribute("ry").toPixels("y"),s=this.attribute("cx").toPixels("x"),a=this.attribute("cy").toPixels("y");return null!=t&&(t.beginPath(),t.moveTo(s+i,a),t.bezierCurveTo(s+i,a+e*n,s+e*i,a+n,s,a+n),t.bezierCurveTo(s-e*i,a+n,s-i,a+e*n,s-i,a),t.bezierCurveTo(s-i,a-e*n,s-e*i,a-n,s,a-n),t.bezierCurveTo(s+e*i,a-n,s+i,a-e*n,s+i,a),t.closePath()),new A.BoundingBox(s-i,a-n,s+i,a+n)}},A.Element.ellipse.prototype=new A.Element.PathElementBase,A.Element.line=function(t){this.base=A.Element.PathElementBase,this.base(t),this.getPoints=function(){return[new A.Point(this.attribute("x1").toPixels("x"),this.attribute("y1").toPixels("y")),new A.Point(this.attribute("x2").toPixels("x"),this.attribute("y2").toPixels("y"))]},this.path=function(t){var e=this.getPoints();return null!=t&&(t.beginPath(),t.moveTo(e[0].x,e[0].y),t.lineTo(e[1].x,e[1].y)),new A.BoundingBox(e[0].x,e[0].y,e[1].x,e[1].y)},this.getMarkers=function(){var t=this.getPoints(),e=t[0].angleTo(t[1]);return[[t[0],e],[t[1],e]]}},A.Element.line.prototype=new A.Element.PathElementBase,A.Element.polyline=function(t){this.base=A.Element.PathElementBase,this.base(t),this.points=A.CreatePath(this.attribute("points").value),this.path=function(t){var e=new A.BoundingBox(this.points[0].x,this.points[0].y);null!=t&&(t.beginPath(),t.moveTo(this.points[0].x,this.points[0].y));for(var i=1;i<this.points.length;i++)e.addPoint(this.points[i].x,this.points[i].y),null!=t&&t.lineTo(this.points[i].x,this.points[i].y);return e},this.getMarkers=function(){for(var t=[],e=0;e<this.points.length-1;e++)t.push([this.points[e],this.points[e].angleTo(this.points[e+1])]);return 0<t.length&&t.push([this.points[this.points.length-1],t[t.length-1][1]]),t}},A.Element.polyline.prototype=new A.Element.PathElementBase,A.Element.polygon=function(t){this.base=A.Element.polyline,this.base(t),this.basePath=this.path,this.path=function(t){var e=this.basePath(t);return null!=t&&(t.lineTo(this.points[0].x,this.points[0].y),t.closePath()),e}},A.Element.polygon.prototype=new A.Element.polyline,A.Element.path=function(t){this.base=A.Element.PathElementBase,this.base(t);var e=this.attribute("d").value;e=e.replace(/,/gm," ");for(var i=0;i<2;i++)e=e.replace(/([MmZzLlHhVvCcSsQqTtAa])([^\s])/gm,"$1 $2");for(e=(e=e.replace(/([^\s])([MmZzLlHhVvCcSsQqTtAa])/gm,"$1 $2")).replace(/([0-9])([+\-])/gm,"$1 $2"),i=0;i<2;i++)e=e.replace(/(\.[0-9]*)(\.)/gm,"$1 $2");e=e.replace(/([Aa](\s+[0-9]+){3})\s+([01])\s*([01])/gm,"$1 $3 $4 "),e=A.compressSpaces(e),e=A.trim(e),this.PathParser=new function(t){this.tokens=t.split(" "),this.reset=function(){this.i=-1,this.command="",this.previousCommand="",this.start=new A.Point(0,0),this.control=new A.Point(0,0),this.current=new A.Point(0,0),this.points=[],this.angles=[]},this.isEnd=function(){return this.i>=this.tokens.length-1},this.isCommandOrEnd=function(){return!!this.isEnd()||null!=this.tokens[this.i+1].match(/^[A-Za-z]$/)},this.isRelativeCommand=function(){switch(this.command){case"m":case"l":case"h":case"v":case"c":case"s":case"q":case"t":case"a":case"z":return!0}return!1},this.getToken=function(){return this.i++,this.tokens[this.i]},this.getScalar=function(){return parseFloat(this.getToken())},this.nextCommand=function(){this.previousCommand=this.command,this.command=this.getToken()},this.getPoint=function(){var t=new A.Point(this.getScalar(),this.getScalar());return this.makeAbsolute(t)},this.getAsControlPoint=function(){var t=this.getPoint();return this.control=t},this.getAsCurrentPoint=function(){var t=this.getPoint();return this.current=t},this.getReflectedControlPoint=function(){return"c"!=this.previousCommand.toLowerCase()&&"s"!=this.previousCommand.toLowerCase()&&"q"!=this.previousCommand.toLowerCase()&&"t"!=this.previousCommand.toLowerCase()?this.current:new A.Point(2*this.current.x-this.control.x,2*this.current.y-this.control.y)},this.makeAbsolute=function(t){return this.isRelativeCommand()&&(t.x+=this.current.x,t.y+=this.current.y),t},this.addMarker=function(t,e,i){null!=i&&0<this.angles.length&&null==this.angles[this.angles.length-1]&&(this.angles[this.angles.length-1]=this.points[this.points.length-1].angleTo(i)),this.addMarkerAngle(t,null==e?null:e.angleTo(t))},this.addMarkerAngle=function(t,e){this.points.push(t),this.angles.push(e)},this.getMarkerPoints=function(){return this.points},this.getMarkerAngles=function(){for(var t=0;t<this.angles.length;t++)if(null==this.angles[t])for(var e=t+1;e<this.angles.length;e++)if(null!=this.angles[e]){this.angles[t]=this.angles[e];break}return this.angles}}(e),this.path=function(t){var e=this.PathParser;e.reset();var i=new A.BoundingBox;for(null!=t&&t.beginPath();!e.isEnd();)switch(e.nextCommand(),e.command){case"M":case"m":var n=e.getAsCurrentPoint();for(e.addMarker(n),i.addPoint(n.x,n.y),null!=t&&t.moveTo(n.x,n.y),e.start=e.current;!e.isCommandOrEnd();)n=e.getAsCurrentPoint(),e.addMarker(n,e.start),i.addPoint(n.x,n.y),null!=t&&t.lineTo(n.x,n.y);break;case"L":case"l":for(;!e.isCommandOrEnd();){var s=e.current;n=e.getAsCurrentPoint(),e.addMarker(n,s),i.addPoint(n.x,n.y),null!=t&&t.lineTo(n.x,n.y)}break;case"H":case"h":for(;!e.isCommandOrEnd();){var a=new A.Point((e.isRelativeCommand()?e.current.x:0)+e.getScalar(),e.current.y);e.addMarker(a,e.current),e.current=a,i.addPoint(e.current.x,e.current.y),null!=t&&t.lineTo(e.current.x,e.current.y)}break;case"V":case"v":for(;!e.isCommandOrEnd();)a=new A.Point(e.current.x,(e.isRelativeCommand()?e.current.y:0)+e.getScalar()),e.addMarker(a,e.current),e.current=a,i.addPoint(e.current.x,e.current.y),null!=t&&t.lineTo(e.current.x,e.current.y);break;case"C":case"c":for(;!e.isCommandOrEnd();){var r=e.current,o=e.getPoint(),l=e.getAsControlPoint(),h=e.getAsCurrentPoint();e.addMarker(h,l,o),i.addBezierCurve(r.x,r.y,o.x,o.y,l.x,l.y,h.x,h.y),null!=t&&t.bezierCurveTo(o.x,o.y,l.x,l.y,h.x,h.y)}break;case"S":case"s":for(;!e.isCommandOrEnd();)r=e.current,o=e.getReflectedControlPoint(),l=e.getAsControlPoint(),h=e.getAsCurrentPoint(),e.addMarker(h,l,o),i.addBezierCurve(r.x,r.y,o.x,o.y,l.x,l.y,h.x,h.y),null!=t&&t.bezierCurveTo(o.x,o.y,l.x,l.y,h.x,h.y);break;case"Q":case"q":for(;!e.isCommandOrEnd();)r=e.current,l=e.getAsControlPoint(),h=e.getAsCurrentPoint(),e.addMarker(h,l,l),i.addQuadraticCurve(r.x,r.y,l.x,l.y,h.x,h.y),null!=t&&t.quadraticCurveTo(l.x,l.y,h.x,h.y);break;case"T":case"t":for(;!e.isCommandOrEnd();)r=e.current,l=e.getReflectedControlPoint(),e.control=l,h=e.getAsCurrentPoint(),e.addMarker(h,l,l),i.addQuadraticCurve(r.x,r.y,l.x,l.y,h.x,h.y),null!=t&&t.quadraticCurveTo(l.x,l.y,h.x,h.y);break;case"A":case"a":for(;!e.isCommandOrEnd();){r=e.current;var u=e.getScalar(),c=e.getScalar(),f=e.getScalar()*(Math.PI/180),m=e.getScalar(),p=e.getScalar(),d=(h=e.getAsCurrentPoint(),new A.Point(Math.cos(f)*(r.x-h.x)/2+Math.sin(f)*(r.y-h.y)/2,-Math.sin(f)*(r.x-h.x)/2+Math.cos(f)*(r.y-h.y)/2)),y=Math.pow(d.x,2)/Math.pow(u,2)+Math.pow(d.y,2)/Math.pow(c,2);1<y&&(u*=Math.sqrt(y),c*=Math.sqrt(y));var v=(m==p?-1:1)*Math.sqrt((Math.pow(u,2)*Math.pow(c,2)-Math.pow(u,2)*Math.pow(d.y,2)-Math.pow(c,2)*Math.pow(d.x,2))/(Math.pow(u,2)*Math.pow(d.y,2)+Math.pow(c,2)*Math.pow(d.x,2)));isNaN(v)&&(v=0);var g=new A.Point(v*u*d.y/c,v*-c*d.x/u),x=new A.Point((r.x+h.x)/2+Math.cos(f)*g.x-Math.sin(f)*g.y,(r.y+h.y)/2+Math.sin(f)*g.x+Math.cos(f)*g.y),b=function(t){return Math.sqrt(Math.pow(t[0],2)+Math.pow(t[1],2))},P=function(t,e){return(t[0]*e[0]+t[1]*e[1])/(b(t)*b(e))},E=function(t,e){return(t[0]*e[1]<t[1]*e[0]?-1:1)*Math.acos(P(t,e))},w=E([1,0],[(d.x-g.x)/u,(d.y-g.y)/c]),B=[(d.x-g.x)/u,(d.y-g.y)/c],C=[(-d.x-g.x)/u,(-d.y-g.y)/c],T=E(B,C);P(B,C)<=-1&&(T=Math.PI),1<=P(B,C)&&(T=0);var V=1-p?1:-1,M=w+V*(T/2),S=new A.Point(x.x+u*Math.cos(M),x.y+c*Math.sin(M));if(e.addMarkerAngle(S,M-V*Math.PI/2),e.addMarkerAngle(h,M-V*Math.PI),i.addPoint(h.x,h.y),null!=t){P=c<u?u:c;var k=c<u?1:u/c,D=c<u?c/u:1;t.translate(x.x,x.y),t.rotate(f),t.scale(k,D),t.arc(0,0,P,w,w+T,1-p),t.scale(1/k,1/D),t.rotate(-f),t.translate(-x.x,-x.y)}}break;case"Z":case"z":null!=t&&i.x1!==i.x2&&i.y1!==i.y2&&t.closePath(),e.current=e.start}return i},this.getMarkers=function(){for(var t=this.PathParser.getMarkerPoints(),e=this.PathParser.getMarkerAngles(),i=[],n=0;n<t.length;n++)i.push([t[n],e[n]]);return i}},A.Element.path.prototype=new A.Element.PathElementBase,A.Element.pattern=function(t){this.base=A.Element.ElementBase,this.base(t),this.createPattern=function(t,e){var i=this.attribute("width").toPixels("x",!0),n=this.attribute("height").toPixels("y",!0),s=new A.Element.svg;s.attributes.viewBox=new A.Property("viewBox",this.attribute("viewBox").value),s.attributes.width=new A.Property("width",i+"px"),s.attributes.height=new A.Property("height",n+"px"),s.attributes.transform=new A.Property("transform",this.attribute("patternTransform").value),s.children=this.children;var a=p();a.width=i,a.height=n;var r=a.getContext("2d");this.attribute("x").hasValue()&&this.attribute("y").hasValue()&&r.translate(this.attribute("x").toPixels("x",!0),this.attribute("y").toPixels("y",!0));for(var o=-1;o<=1;o++)for(var l=-1;l<=1;l++)r.save(),s.attributes.x=new A.Property("x",o*a.width),s.attributes.y=new A.Property("y",l*a.height),s.render(r),r.restore();return t.createPattern(a,"repeat")}},A.Element.pattern.prototype=new A.Element.ElementBase,A.Element.marker=function(t){this.base=A.Element.ElementBase,this.base(t),this.baseRender=this.render,this.render=function(t,e,i){if(e){t.translate(e.x,e.y),"auto"==this.attribute("orient").valueOrDefault("auto")&&t.rotate(i),"strokeWidth"==this.attribute("markerUnits").valueOrDefault("strokeWidth")&&t.scale(t.lineWidth,t.lineWidth),t.save();var n=new A.Element.svg;n.attributes.viewBox=new A.Property("viewBox",this.attribute("viewBox").value),n.attributes.refX=new A.Property("refX",this.attribute("refX").value),n.attributes.refY=new A.Property("refY",this.attribute("refY").value),n.attributes.width=new A.Property("width",this.attribute("markerWidth").value),n.attributes.height=new A.Property("height",this.attribute("markerHeight").value),n.attributes.fill=new A.Property("fill",this.attribute("fill").valueOrDefault("black")),n.attributes.stroke=new A.Property("stroke",this.attribute("stroke").valueOrDefault("none")),n.children=this.children,n.render(t),t.restore(),"strokeWidth"==this.attribute("markerUnits").valueOrDefault("strokeWidth")&&t.scale(1/t.lineWidth,1/t.lineWidth),"auto"==this.attribute("orient").valueOrDefault("auto")&&t.rotate(-i),t.translate(-e.x,-e.y)}}},A.Element.marker.prototype=new A.Element.ElementBase,A.Element.defs=function(t){this.base=A.Element.ElementBase,this.base(t),this.render=function(t){}},A.Element.defs.prototype=new A.Element.ElementBase,A.Element.GradientBase=function(t){this.base=A.Element.ElementBase,this.base(t),this.stops=[];for(var e=0;e<this.children.length;e++){var i=this.children[e];"stop"==i.type&&this.stops.push(i)}this.getGradient=function(){},this.gradientUnits=function(){return this.attribute("gradientUnits").valueOrDefault("objectBoundingBox")},this.attributesToInherit=["gradientUnits"],this.inheritStopContainer=function(t){for(var e=0;e<this.attributesToInherit.length;e++){var i=this.attributesToInherit[e];!this.attribute(i).hasValue()&&t.attribute(i).hasValue()&&(this.attribute(i,!0).value=t.attribute(i).value)}},this.createGradient=function(t,e,i){var n=this;this.getHrefAttribute().hasValue()&&(n=this.getHrefAttribute().getDefinition(),this.inheritStopContainer(n));var s=function(t){return i.hasValue()?new A.Property("color",t).addOpacity(i).value:t},a=this.getGradient(t,e);if(null==a)return s(n.stops[n.stops.length-1].color);for(var r=0;r<n.stops.length;r++)a.addColorStop(n.stops[r].offset,s(n.stops[r].color));if(this.attribute("gradientTransform").hasValue()){var o=A.ViewPort.viewPorts[0],l=new A.Element.rect;l.attributes.x=new A.Property("x",-A.MAX_VIRTUAL_PIXELS/3),l.attributes.y=new A.Property("y",-A.MAX_VIRTUAL_PIXELS/3),l.attributes.width=new A.Property("width",A.MAX_VIRTUAL_PIXELS),l.attributes.height=new A.Property("height",A.MAX_VIRTUAL_PIXELS);var h=new A.Element.g;h.attributes.transform=new A.Property("transform",this.attribute("gradientTransform").value),h.children=[l];var u=new A.Element.svg;u.attributes.x=new A.Property("x",0),u.attributes.y=new A.Property("y",0),u.attributes.width=new A.Property("width",o.width),u.attributes.height=new A.Property("height",o.height),u.children=[h];var c=p();c.width=o.width,c.height=o.height;var f=c.getContext("2d");return f.fillStyle=a,u.render(f),f.createPattern(c,"no-repeat")}return a}},A.Element.GradientBase.prototype=new A.Element.ElementBase,A.Element.linearGradient=function(t){this.base=A.Element.GradientBase,this.base(t),this.attributesToInherit.push("x1"),this.attributesToInherit.push("y1"),this.attributesToInherit.push("x2"),this.attributesToInherit.push("y2"),this.getGradient=function(t,e){var i="objectBoundingBox"==this.gradientUnits()?e.getBoundingBox(t):null;this.attribute("x1").hasValue()||this.attribute("y1").hasValue()||this.attribute("x2").hasValue()||this.attribute("y2").hasValue()||(this.attribute("x1",!0).value=0,this.attribute("y1",!0).value=0,this.attribute("x2",!0).value=1,this.attribute("y2",!0).value=0);var n="objectBoundingBox"==this.gradientUnits()?i.x()+i.width()*this.attribute("x1").numValue():this.attribute("x1").toPixels("x"),s="objectBoundingBox"==this.gradientUnits()?i.y()+i.height()*this.attribute("y1").numValue():this.attribute("y1").toPixels("y"),a="objectBoundingBox"==this.gradientUnits()?i.x()+i.width()*this.attribute("x2").numValue():this.attribute("x2").toPixels("x"),r="objectBoundingBox"==this.gradientUnits()?i.y()+i.height()*this.attribute("y2").numValue():this.attribute("y2").toPixels("y");return n==a&&s==r?null:t.createLinearGradient(n,s,a,r)}},A.Element.linearGradient.prototype=new A.Element.GradientBase,A.Element.radialGradient=function(t){this.base=A.Element.GradientBase,this.base(t),this.attributesToInherit.push("cx"),this.attributesToInherit.push("cy"),this.attributesToInherit.push("r"),this.attributesToInherit.push("fx"),this.attributesToInherit.push("fy"),this.getGradient=function(t,e){var i=e.getBoundingBox(t);this.attribute("cx").hasValue()||(this.attribute("cx",!0).value="50%"),this.attribute("cy").hasValue()||(this.attribute("cy",!0).value="50%"),this.attribute("r").hasValue()||(this.attribute("r",!0).value="50%");var n="objectBoundingBox"==this.gradientUnits()?i.x()+i.width()*this.attribute("cx").numValue():this.attribute("cx").toPixels("x"),s="objectBoundingBox"==this.gradientUnits()?i.y()+i.height()*this.attribute("cy").numValue():this.attribute("cy").toPixels("y"),a=n,r=s;this.attribute("fx").hasValue()&&(a="objectBoundingBox"==this.gradientUnits()?i.x()+i.width()*this.attribute("fx").numValue():this.attribute("fx").toPixels("x")),this.attribute("fy").hasValue()&&(r="objectBoundingBox"==this.gradientUnits()?i.y()+i.height()*this.attribute("fy").numValue():this.attribute("fy").toPixels("y"));var o="objectBoundingBox"==this.gradientUnits()?(i.width()+i.height())/2*this.attribute("r").numValue():this.attribute("r").toPixels();return t.createRadialGradient(a,r,0,n,s,o)}},A.Element.radialGradient.prototype=new A.Element.GradientBase,A.Element.stop=function(t){this.base=A.Element.ElementBase,this.base(t),this.offset=this.attribute("offset").numValue(),this.offset<0&&(this.offset=0),1<this.offset&&(this.offset=1);var e=this.style("stop-color",!0);""===e.value&&(e.value="#000"),this.style("stop-opacity").hasValue()&&(e=e.addOpacity(this.style("stop-opacity"))),this.color=e.value},A.Element.stop.prototype=new A.Element.ElementBase,A.Element.AnimateBase=function(t){this.base=A.Element.ElementBase,this.base(t),A.Animations.push(this),this.duration=0,this.begin=this.attribute("begin").toMilliseconds(),this.maxDuration=this.begin+this.attribute("dur").toMilliseconds(),this.getProperty=function(){var t=this.attribute("attributeType").value,e=this.attribute("attributeName").value;return"CSS"==t?this.parent.style(e,!0):this.parent.attribute(e,!0)},this.initialValue=null,this.initialUnits="",this.removed=!1,this.calcValue=function(){return""},this.update=function(t){if(null==this.initialValue&&(this.initialValue=this.getProperty().value,this.initialUnits=this.getProperty().getUnits()),this.duration>this.maxDuration){if("indefinite"==this.attribute("repeatCount").value||"indefinite"==this.attribute("repeatDur").value)this.duration=0;else if("freeze"!=this.attribute("fill").valueOrDefault("remove")||this.frozen){if("remove"==this.attribute("fill").valueOrDefault("remove")&&!this.removed)return this.removed=!0,this.getProperty().value=this.parent.animationFrozen?this.parent.animationFrozenValue:this.initialValue,!0}else this.frozen=!0,this.parent.animationFrozen=!0,this.parent.animationFrozenValue=this.getProperty().value;return!1}this.duration=this.duration+t;var e=!1;if(this.begin<this.duration){var i=this.calcValue();this.attribute("type").hasValue()&&(i=this.attribute("type").value+"("+i+")"),this.getProperty().value=i,e=!0}return e},this.from=this.attribute("from"),this.to=this.attribute("to"),this.values=this.attribute("values"),this.values.hasValue()&&(this.values.value=this.values.value.split(";")),this.progress=function(){var t={progress:(this.duration-this.begin)/(this.maxDuration-this.begin)};if(this.values.hasValue()){var e=t.progress*(this.values.value.length-1),i=Math.floor(e),n=Math.ceil(e);t.from=new A.Property("from",parseFloat(this.values.value[i])),t.to=new A.Property("to",parseFloat(this.values.value[n])),t.progress=(e-i)/(n-i)}else t.from=this.from,t.to=this.to;return t}},A.Element.AnimateBase.prototype=new A.Element.ElementBase,A.Element.animate=function(t){this.base=A.Element.AnimateBase,this.base(t),this.calcValue=function(){var t=this.progress();return t.from.numValue()+(t.to.numValue()-t.from.numValue())*t.progress+this.initialUnits}},A.Element.animate.prototype=new A.Element.AnimateBase,A.Element.animateColor=function(t){this.base=A.Element.AnimateBase,this.base(t),this.calcValue=function(){var t=this.progress(),e=new m(t.from.value),i=new m(t.to.value);if(e.ok&&i.ok){var n=e.r+(i.r-e.r)*t.progress,s=e.g+(i.g-e.g)*t.progress,a=e.b+(i.b-e.b)*t.progress;return"rgb("+parseInt(n,10)+","+parseInt(s,10)+","+parseInt(a,10)+")"}return this.attribute("from").value}},A.Element.animateColor.prototype=new A.Element.AnimateBase,A.Element.animateTransform=function(t){this.base=A.Element.AnimateBase,this.base(t),this.calcValue=function(){for(var t=this.progress(),e=A.ToNumberArray(t.from.value),i=A.ToNumberArray(t.to.value),n="",s=0;s<e.length;s++)n+=e[s]+(i[s]-e[s])*t.progress+" ";return n}},A.Element.animateTransform.prototype=new A.Element.animate,A.Element.font=function(t){this.base=A.Element.ElementBase,this.base(t),this.horizAdvX=this.attribute("horiz-adv-x").numValue(),this.isRTL=!1,this.isArabic=!1,this.fontFace=null,this.missingGlyph=null,this.glyphs=[];for(var e=0;e<this.children.length;e++){var i=this.children[e];"font-face"==i.type?(this.fontFace=i).style("font-family").hasValue()&&(A.Definitions[i.style("font-family").value]=this):"missing-glyph"==i.type?this.missingGlyph=i:"glyph"==i.type&&(""!=i.arabicForm?(this.isRTL=!0,this.isArabic=!0,void 0===this.glyphs[i.unicode]&&(this.glyphs[i.unicode]=[]),this.glyphs[i.unicode][i.arabicForm]=i):this.glyphs[i.unicode]=i)}},A.Element.font.prototype=new A.Element.ElementBase,A.Element.fontface=function(t){this.base=A.Element.ElementBase,this.base(t),this.ascent=this.attribute("ascent").value,this.descent=this.attribute("descent").value,this.unitsPerEm=this.attribute("units-per-em").numValue()},A.Element.fontface.prototype=new A.Element.ElementBase,A.Element.missingglyph=function(t){this.base=A.Element.path,this.base(t),this.horizAdvX=0},A.Element.missingglyph.prototype=new A.Element.path,A.Element.glyph=function(t){this.base=A.Element.path,this.base(t),this.horizAdvX=this.attribute("horiz-adv-x").numValue(),this.unicode=this.attribute("unicode").value,this.arabicForm=this.attribute("arabic-form").value},A.Element.glyph.prototype=new A.Element.path,A.Element.text=function(t){this.captureTextNodes=!0,this.base=A.Element.RenderedElementBase,this.base(t),this.baseSetContext=this.setContext,this.setContext=function(t){this.baseSetContext(t);var e=this.style("dominant-baseline").toTextBaseline();null==e&&(e=this.style("alignment-baseline").toTextBaseline()),null!=e&&(t.textBaseline=e)},this.initializeCoordinates=function(t){this.x=this.attribute("x").toPixels("x"),this.y=this.attribute("y").toPixels("y"),this.attribute("dx").hasValue()&&(this.x+=this.attribute("dx").toPixels("x")),this.attribute("dy").hasValue()&&(this.y+=this.attribute("dy").toPixels("y")),this.x+=this.getAnchorDelta(t,this,0)},this.getBoundingBox=function(t){this.initializeCoordinates(t);for(var e=null,i=0;i<this.children.length;i++){var n=this.getChildBoundingBox(t,this,this,i);null==e?e=n:e.addBoundingBox(n)}return e},this.renderChildren=function(t){this.initializeCoordinates(t);for(var e=0;e<this.children.length;e++)this.renderChild(t,this,this,e)},this.getAnchorDelta=function(t,e,i){var n=this.style("text-anchor").valueOrDefault("start");if("start"!=n){for(var s=0,a=i;a<e.children.length;a++){var r=e.children[a];if(i<a&&r.attribute("x").hasValue())break;s+=r.measureTextRecursive(t)}return-1*("end"==n?s:s/2)}return 0},this.adjustChildCoordinates=function(t,e,i,n){var s=i.children[n];return s.attribute("x").hasValue()?(s.x=s.attribute("x").toPixels("x")+e.getAnchorDelta(t,i,n),s.attribute("dx").hasValue()&&(s.x+=s.attribute("dx").toPixels("x"))):(s.attribute("dx").hasValue()&&(e.x+=s.attribute("dx").toPixels("x")),s.x=e.x),e.x=s.x+s.measureText(t),s.attribute("y").hasValue()?(s.y=s.attribute("y").toPixels("y"),s.attribute("dy").hasValue()&&(s.y+=s.attribute("dy").toPixels("y"))):(s.attribute("dy").hasValue()&&(e.y+=s.attribute("dy").toPixels("y")),s.y=e.y),e.y=s.y,s},this.getChildBoundingBox=function(t,e,i,n){var s=this.adjustChildCoordinates(t,e,i,n),a=s.getBoundingBox(t);for(n=0;n<s.children.length;n++){var r=e.getChildBoundingBox(t,e,s,n);a.addBoundingBox(r)}return a},this.renderChild=function(t,e,i,n){var s=this.adjustChildCoordinates(t,e,i,n);for(s.render(t),n=0;n<s.children.length;n++)e.renderChild(t,e,s,n)}},A.Element.text.prototype=new A.Element.RenderedElementBase,A.Element.TextElementBase=function(t){this.base=A.Element.RenderedElementBase,this.base(t),this.getGlyph=function(t,e,i){var n=e[i],s=null;if(t.isArabic){var a="isolated";(0==i||" "==e[i-1])&&i<e.length-2&&" "!=e[i+1]&&(a="terminal"),0<i&&" "!=e[i-1]&&i<e.length-2&&" "!=e[i+1]&&(a="medial"),0<i&&" "!=e[i-1]&&(i==e.length-1||" "==e[i+1])&&(a="initial"),void 0!==t.glyphs[n]&&null==(s=t.glyphs[n][a])&&"glyph"==t.glyphs[n].type&&(s=t.glyphs[n])}else s=t.glyphs[n];return null==s&&(s=t.missingGlyph),s},this.renderChildren=function(t){var e=this.parent.style("font-family").getDefinition();if(null==e)"stroke"==t.paintOrder?(""!=t.strokeStyle&&t.strokeText(A.compressSpaces(this.getText()),this.x,this.y),""!=t.fillStyle&&t.fillText(A.compressSpaces(this.getText()),this.x,this.y)):(""!=t.fillStyle&&t.fillText(A.compressSpaces(this.getText()),this.x,this.y),""!=t.strokeStyle&&t.strokeText(A.compressSpaces(this.getText()),this.x,this.y));else{var i=this.parent.style("font-size").numValueOrDefault(A.Font.Parse(A.ctx.font).fontSize),n=this.parent.style("font-style").valueOrDefault(A.Font.Parse(A.ctx.font).fontStyle),s=this.getText();e.isRTL&&(s=s.split("").reverse().join(""));for(var a=A.ToNumberArray(this.parent.attribute("dx").value),r=0;r<s.length;r++){var o=this.getGlyph(e,s,r),l=i/e.fontFace.unitsPerEm;t.translate(this.x,this.y),t.scale(l,-l);var h=t.lineWidth;t.lineWidth=t.lineWidth*e.fontFace.unitsPerEm/i,"italic"==n&&t.transform(1,0,.4,1,0,0),o.render(t),"italic"==n&&t.transform(1,0,-.4,1,0,0),t.lineWidth=h,t.scale(1/l,-1/l),t.translate(-this.x,-this.y),this.x+=i*(o.horizAdvX||e.horizAdvX)/e.fontFace.unitsPerEm,void 0===a[r]||isNaN(a[r])||(this.x+=a[r])}}},this.getText=function(){},this.measureTextRecursive=function(t){for(var e=this.measureText(t),i=0;i<this.children.length;i++)e+=this.children[i].measureTextRecursive(t);return e},this.measureText=function(t){var e=this.parent.style("font-family").getDefinition();if(null!=e){var i=this.parent.style("font-size").numValueOrDefault(A.Font.Parse(A.ctx.font).fontSize),n=0,s=this.getText();e.isRTL&&(s=s.split("").reverse().join(""));for(var a=A.ToNumberArray(this.parent.attribute("dx").value),r=0;r<s.length;r++)n+=(this.getGlyph(e,s,r).horizAdvX||e.horizAdvX)*i/e.fontFace.unitsPerEm,void 0===a[r]||isNaN(a[r])||(n+=a[r]);return n}var o=A.compressSpaces(this.getText());if(!t.measureText)return 10*o.length;t.save(),this.setContext(t,!0);var l=t.measureText(o).width;return t.restore(),l},this.getBoundingBox=function(t){var e=this.parent.style("font-size").numValueOrDefault(A.Font.Parse(A.ctx.font).fontSize);return new A.BoundingBox(this.x,this.y-e,this.x+this.measureText(t),this.y)}},A.Element.TextElementBase.prototype=new A.Element.RenderedElementBase,A.Element.tspan=function(t){this.captureTextNodes=!0,this.base=A.Element.TextElementBase,this.base(t),this.text=A.compressSpaces(t.value||t.text||t.textContent||""),this.getText=function(){return 0<this.children.length?"":this.text}},A.Element.tspan.prototype=new A.Element.TextElementBase,A.Element.tref=function(t){this.base=A.Element.TextElementBase,this.base(t),this.getText=function(){var t=this.getHrefAttribute().getDefinition();if(null!=t)return t.children[0].getText()}},A.Element.tref.prototype=new A.Element.TextElementBase,A.Element.a=function(t){this.base=A.Element.TextElementBase,this.base(t),this.hasText=0<t.childNodes.length;for(var e=0;e<t.childNodes.length;e++)3!=t.childNodes[e].nodeType&&(this.hasText=!1);this.text=this.hasText?t.childNodes[0].value||t.childNodes[0].data:"",this.getText=function(){return this.text},this.baseRenderChildren=this.renderChildren,this.renderChildren=function(t){if(this.hasText){this.baseRenderChildren(t);var e=new A.Property("fontSize",A.Font.Parse(A.ctx.font).fontSize);A.Mouse.checkBoundingBox(this,new A.BoundingBox(this.x,this.y-e.toPixels("y"),this.x+this.measureText(t),this.y))}else if(0<this.children.length){var i=new A.Element.g;i.children=this.children,i.parent=this,i.render(t)}},this.onclick=function(){u.open(this.getHrefAttribute().value)},this.onmousemove=function(){A.ctx.canvas.style.cursor="pointer"}},A.Element.a.prototype=new A.Element.TextElementBase,A.Element.image=function(t){this.base=A.Element.RenderedElementBase,this.base(t);var e=this.getHrefAttribute().value;if(""!=e){var a=e.match(/\.svg$/);if(A.Images.push(this),this.loaded=!1,a)this.img=A.ajax(e),this.loaded=!0;else{this.img=document.createElement("img"),1==A.opts.useCORS&&(this.img.crossOrigin="Anonymous");var r=this;this.img.onload=function(){r.loaded=!0},this.img.onerror=function(){A.log('ERROR: image "'+e+'" not found'),r.loaded=!0},this.img.src=e}this.renderChildren=function(t){var e=this.attribute("x").toPixels("x"),i=this.attribute("y").toPixels("y"),n=this.attribute("width").toPixels("x"),s=this.attribute("height").toPixels("y");0!=n&&0!=s&&(t.save(),a?t.drawSvg(this.img,e,i,n,s):(t.translate(e,i),A.AspectRatio(t,this.attribute("preserveAspectRatio").value,n,this.img.width,s,this.img.height,0,0),r.loaded&&(void 0===this.img.complete||this.img.complete)&&t.drawImage(this.img,0,0)),t.restore())},this.getBoundingBox=function(){var t=this.attribute("x").toPixels("x"),e=this.attribute("y").toPixels("y"),i=this.attribute("width").toPixels("x"),n=this.attribute("height").toPixels("y");return new A.BoundingBox(t,e,t+i,e+n)}}},A.Element.image.prototype=new A.Element.RenderedElementBase,A.Element.g=function(t){this.base=A.Element.RenderedElementBase,this.base(t),this.getBoundingBox=function(t){for(var e=new A.BoundingBox,i=0;i<this.children.length;i++)e.addBoundingBox(this.children[i].getBoundingBox(t));return e}},A.Element.g.prototype=new A.Element.RenderedElementBase,A.Element.symbol=function(t){this.base=A.Element.RenderedElementBase,this.base(t),this.render=function(t){}},A.Element.symbol.prototype=new A.Element.RenderedElementBase,A.Element.style=function(t){this.base=A.Element.ElementBase,this.base(t);for(var e="",i=0;i<t.childNodes.length;i++)e+=t.childNodes[i].data;e=e.replace(/(\/\*([^*]|[\r\n]|(\*+([^*\/]|[\r\n])))*\*+\/)|(^[\s]*\/\/.*)/gm,"");var n=(e=A.compressSpaces(e)).split("}");for(i=0;i<n.length;i++)if(""!=A.trim(n[i]))for(var s=n[i].split("{"),a=s[0].split(","),r=s[1].split(";"),o=0;o<a.length;o++){var l=A.trim(a[o]);if(""!=l){for(var h=A.Styles[l]||{},u=0;u<r.length;u++){var c=r[u].indexOf(":"),f=r[u].substr(0,c),m=r[u].substr(c+1,r[u].length-c);null!=f&&null!=m&&(h[A.trim(f)]=new A.Property(A.trim(f),A.trim(m)))}if(A.Styles[l]=h,A.StylesSpecificity[l]=w(l),"@font-face"==l)for(var p=h["font-family"].value.replace(/"/g,""),d=h.src.value.split(","),y=0;y<d.length;y++)if(0<d[y].indexOf('format("svg")'))for(var v=d[y].indexOf("url"),g=d[y].indexOf(")",v),x=d[y].substr(v+5,g-v-6),b=A.parseXml(A.ajax(x)).getElementsByTagName("font"),P=0;P<b.length;P++){var E=A.CreateElement(b[P]);A.Definitions[p]=E}}}},A.Element.style.prototype=new A.Element.ElementBase,A.Element.use=function(t){this.base=A.Element.RenderedElementBase,this.base(t),this.baseSetContext=this.setContext,this.setContext=function(t){this.baseSetContext(t),this.attribute("x").hasValue()&&t.translate(this.attribute("x").toPixels("x"),0),this.attribute("y").hasValue()&&t.translate(0,this.attribute("y").toPixels("y"))};var n=this.getHrefAttribute().getDefinition();this.path=function(t){null!=n&&n.path(t)},this.elementTransform=function(){if(null!=n&&n.style("transform",!1,!0).hasValue())return new A.Transform(n.style("transform",!1,!0).value)},this.getBoundingBox=function(t){if(null!=n)return n.getBoundingBox(t)},this.renderChildren=function(t){if(null!=n){var e=n;"symbol"==n.type&&((e=new A.Element.svg).type="svg",e.attributes.viewBox=new A.Property("viewBox",n.attribute("viewBox").value),e.attributes.preserveAspectRatio=new A.Property("preserveAspectRatio",n.attribute("preserveAspectRatio").value),e.attributes.overflow=new A.Property("overflow",n.attribute("overflow").value),e.children=n.children),"svg"==e.type&&(this.attribute("width").hasValue()&&(e.attributes.width=new A.Property("width",this.attribute("width").value)),this.attribute("height").hasValue()&&(e.attributes.height=new A.Property("height",this.attribute("height").value)));var i=e.parent;e.parent=null,e.render(t),e.parent=i}}},A.Element.use.prototype=new A.Element.RenderedElementBase,A.Element.mask=function(t){this.base=A.Element.ElementBase,this.base(t),this.apply=function(t,e){var i=this.attribute("x").toPixels("x"),n=this.attribute("y").toPixels("y"),s=this.attribute("width").toPixels("x"),a=this.attribute("height").toPixels("y");if(0==s&&0==a){for(var r=new A.BoundingBox,o=0;o<this.children.length;o++)r.addBoundingBox(this.children[o].getBoundingBox(t));i=Math.floor(r.x1),n=Math.floor(r.y1),s=Math.floor(r.width()),a=Math.floor(r.height())}var l=e.attribute("mask").value;e.attribute("mask").value="";var h=p();h.width=i+s,h.height=n+a;var u=h.getContext("2d");this.renderChildren(u);var c=p();c.width=i+s,c.height=n+a;var f=c.getContext("2d");e.render(f),f.globalCompositeOperation="destination-in",f.fillStyle=u.createPattern(h,"no-repeat"),f.fillRect(0,0,i+s,n+a),t.fillStyle=f.createPattern(c,"no-repeat"),t.fillRect(0,0,i+s,n+a),e.attribute("mask").value=l},this.render=function(t){}},A.Element.mask.prototype=new A.Element.ElementBase,A.Element.clipPath=function(t){this.base=A.Element.ElementBase,this.base(t),this.apply=function(t){var e="undefined"!=typeof CanvasRenderingContext2D,i=t.beginPath,n=t.closePath;e&&(CanvasRenderingContext2D.prototype.beginPath=function(){},CanvasRenderingContext2D.prototype.closePath=function(){}),i.call(t);for(var s=0;s<this.children.length;s++){var a=this.children[s];if(void 0!==a.path){var r=void 0!==a.elementTransform&&a.elementTransform();!r&&a.style("transform",!1,!0).hasValue()&&(r=new A.Transform(a.style("transform",!1,!0).value)),r&&r.apply(t),a.path(t),e&&(CanvasRenderingContext2D.prototype.closePath=n),r&&r.unapply(t)}}n.call(t),t.clip(),e&&(CanvasRenderingContext2D.prototype.beginPath=i,CanvasRenderingContext2D.prototype.closePath=n)},this.render=function(t){}},A.Element.clipPath.prototype=new A.Element.ElementBase,A.Element.filter=function(t){this.base=A.Element.ElementBase,this.base(t),this.apply=function(t,e){var i=e.getBoundingBox(t),n=Math.floor(i.x1),s=Math.floor(i.y1),a=Math.floor(i.width()),r=Math.floor(i.height()),o=e.style("filter").value;e.style("filter").value="";for(var l=0,h=0,u=0;u<this.children.length;u++){var c=this.children[u].extraFilterDistance||0;l=Math.max(l,c),h=Math.max(h,c)}var f=p();f.width=a+2*l,f.height=r+2*h;var m=f.getContext("2d");for(m.translate(-n+l,-s+h),e.render(m),u=0;u<this.children.length;u++)"function"==typeof this.children[u].apply&&this.children[u].apply(m,0,0,a+2*l,r+2*h);t.drawImage(f,0,0,a+2*l,r+2*h,n-l,s-h,a+2*l,r+2*h),e.style("filter",!0).value=o},this.render=function(t){}},A.Element.filter.prototype=new A.Element.ElementBase,A.Element.feMorphology=function(t){this.base=A.Element.ElementBase,this.base(t),this.apply=function(t,e,i,n,s){}},A.Element.feMorphology.prototype=new A.Element.ElementBase,A.Element.feComposite=function(t){this.base=A.Element.ElementBase,this.base(t),this.apply=function(t,e,i,n,s){}},A.Element.feComposite.prototype=new A.Element.ElementBase,A.Element.feColorMatrix=function(t){this.base=A.Element.ElementBase,this.base(t);var n=A.ToNumberArray(this.attribute("values").value);switch(this.attribute("type").valueOrDefault("matrix")){case"saturate":var e=n[0];n=[.213+.787*e,.715-.715*e,.072-.072*e,0,0,.213-.213*e,.715+.285*e,.072-.072*e,0,0,.213-.213*e,.715-.715*e,.072+.928*e,0,0,0,0,0,1,0,0,0,0,0,1];break;case"hueRotate":var s=n[0]*Math.PI/180,i=function(t,e,i){return t+Math.cos(s)*e+Math.sin(s)*i};n=[i(.213,.787,-.213),i(.715,-.715,-.715),i(.072,-.072,.928),0,0,i(.213,-.213,.143),i(.715,.285,.14),i(.072,-.072,-.283),0,0,i(.213,-.213,-.787),i(.715,-.715,.715),i(.072,.928,.072),0,0,0,0,0,1,0,0,0,0,0,1];break;case"luminanceToAlpha":n=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,.2125,.7154,.0721,0,0,0,0,0,0,1]}function u(t,e,i,n,s,a){return t[i*n*4+4*e+a]}function c(t,e,i,n,s,a,r){t[i*n*4+4*e+a]=r}function f(t,e){var i=n[t];return i*(i<0?e-255:e)}this.apply=function(t,e,i,n,s){var a=t.getImageData(0,0,n,s);for(i=0;i<s;i++)for(e=0;e<n;e++){var r=u(a.data,e,i,n,0,0),o=u(a.data,e,i,n,0,1),l=u(a.data,e,i,n,0,2),h=u(a.data,e,i,n,0,3);c(a.data,e,i,n,0,0,f(0,r)+f(1,o)+f(2,l)+f(3,h)+f(4,1)),c(a.data,e,i,n,0,1,f(5,r)+f(6,o)+f(7,l)+f(8,h)+f(9,1)),c(a.data,e,i,n,0,2,f(10,r)+f(11,o)+f(12,l)+f(13,h)+f(14,1)),c(a.data,e,i,n,0,3,f(15,r)+f(16,o)+f(17,l)+f(18,h)+f(19,1))}t.clearRect(0,0,n,s),t.putImageData(a,0,0)}},A.Element.feColorMatrix.prototype=new A.Element.ElementBase,A.Element.feGaussianBlur=function(t){this.base=A.Element.ElementBase,this.base(t),this.blurRadius=Math.floor(this.attribute("stdDeviation").numValue()),this.extraFilterDistance=this.blurRadius,this.apply=function(t,e,i,n,s){d&&void 0!==d.canvasRGBA?(t.canvas.id=A.UniqueId(),t.canvas.style.display="none",document.body.appendChild(t.canvas),d.canvasRGBA(t.canvas,e,i,n,s,this.blurRadius),document.body.removeChild(t.canvas)):A.log("ERROR: StackBlur.js must be included for blur to work")}},A.Element.feGaussianBlur.prototype=new A.Element.ElementBase,A.Element.title=function(t){},A.Element.title.prototype=new A.Element.ElementBase,A.Element.desc=function(t){},A.Element.desc.prototype=new A.Element.ElementBase,A.Element.MISSING=function(t){A.log("ERROR: Element '"+t.nodeName+"' not yet implemented.")},A.Element.MISSING.prototype=new A.Element.ElementBase,A.CreateElement=function(t){var e=t.nodeName.replace(/^[^:]+:/,"");e=e.replace(/\-/g,"");var i=null;return(i=void 0!==A.Element[e]?new A.Element[e](t):new A.Element.MISSING(t)).type=t.nodeName,i},A.load=function(t,e){A.loadXml(t,A.ajax(e))},A.loadXml=function(t,e){A.loadXmlDoc(t,A.parseXml(e))},A.loadXmlDoc=function(a,r){A.init(a);var i=function(t){for(var e=a.canvas;e;)t.x-=e.offsetLeft,t.y-=e.offsetTop,e=e.offsetParent;return u.scrollX&&(t.x+=u.scrollX),u.scrollY&&(t.y+=u.scrollY),t};1!=A.opts.ignoreMouse&&(a.canvas.onclick=function(t){var e=i(new A.Point(null!=t?t.clientX:event.clientX,null!=t?t.clientY:event.clientY));A.Mouse.onclick(e.x,e.y)},a.canvas.onmousemove=function(t){var e=i(new A.Point(null!=t?t.clientX:event.clientX,null!=t?t.clientY:event.clientY));A.Mouse.onmousemove(e.x,e.y)});var o=A.CreateElement(r.documentElement);o.root=!0,o.addStylesFromStyleDefinition();var l=!0,n=function(){A.ViewPort.Clear(),a.canvas.parentNode?A.ViewPort.SetCurrent(a.canvas.parentNode.clientWidth,a.canvas.parentNode.clientHeight):A.ViewPort.SetCurrent(800,600),1!=A.opts.ignoreDimensions&&(o.style("width").hasValue()&&(a.canvas.width=o.style("width").toPixels("x"),a.canvas.style&&(a.canvas.style.width=a.canvas.width+"px")),o.style("height").hasValue()&&(a.canvas.height=o.style("height").toPixels("y"),a.canvas.style&&(a.canvas.style.height=a.canvas.height+"px")));var t=a.canvas.clientWidth||a.canvas.width,e=a.canvas.clientHeight||a.canvas.height;if(1==A.opts.ignoreDimensions&&o.style("width").hasValue()&&o.style("height").hasValue()&&(t=o.style("width").toPixels("x"),e=o.style("height").toPixels("y")),A.ViewPort.SetCurrent(t,e),null!=A.opts.offsetX&&(o.attribute("x",!0).value=A.opts.offsetX),null!=A.opts.offsetY&&(o.attribute("y",!0).value=A.opts.offsetY),null!=A.opts.scaleWidth||null!=A.opts.scaleHeight){var i=null,n=null,s=A.ToNumberArray(o.attribute("viewBox").value);null!=A.opts.scaleWidth&&(o.attribute("width").hasValue()?i=o.attribute("width").toPixels("x")/A.opts.scaleWidth:isNaN(s[2])||(i=s[2]/A.opts.scaleWidth)),null!=A.opts.scaleHeight&&(o.attribute("height").hasValue()?n=o.attribute("height").toPixels("y")/A.opts.scaleHeight:isNaN(s[3])||(n=s[3]/A.opts.scaleHeight)),null==i&&(i=n),null==n&&(n=i),o.attribute("width",!0).value=A.opts.scaleWidth,o.attribute("height",!0).value=A.opts.scaleHeight,o.style("transform",!0,!0).value+=" scale("+1/i+","+1/n+")"}1!=A.opts.ignoreClear&&a.clearRect(0,0,t,e),o.render(a),l&&(l=!1,"function"==typeof A.opts.renderCallback&&A.opts.renderCallback(r))},s=!0;A.ImagesLoaded()&&(s=!1,n()),A.intervalID=setInterval(function(){var t=!1;if(s&&A.ImagesLoaded()&&(t=!(s=!1)),1!=A.opts.ignoreMouse&&(t|=A.Mouse.hasEvents()),1!=A.opts.ignoreAnimation)for(var e=0;e<A.Animations.length;e++)t|=A.Animations[e].update(1e3/A.FRAMERATE);"function"==typeof A.opts.forceRedraw&&1==A.opts.forceRedraw()&&(t=!0),t&&(n(),A.Mouse.runEvents())},1e3/A.FRAMERATE)},A.stop=function(){A.intervalID&&clearInterval(A.intervalID)},A.Mouse=new function(){this.events=[],this.hasEvents=function(){return 0!=this.events.length},this.onclick=function(t,e){this.events.push({type:"onclick",x:t,y:e,run:function(t){t.onclick&&t.onclick()}})},this.onmousemove=function(t,e){this.events.push({type:"onmousemove",x:t,y:e,run:function(t){t.onmousemove&&t.onmousemove()}})},this.eventElements=[],this.checkPath=function(t,e){for(var i=0;i<this.events.length;i++){var n=this.events[i];e.isPointInPath&&e.isPointInPath(n.x,n.y)&&(this.eventElements[i]=t)}},this.checkBoundingBox=function(t,e){for(var i=0;i<this.events.length;i++){var n=this.events[i];e.isPointInBox(n.x,n.y)&&(this.eventElements[i]=t)}},this.runEvents=function(){A.ctx.canvas.style.cursor="";for(var t=0;t<this.events.length;t++)for(var e=this.events[t],i=this.eventElements[t];i;)e.run(i),i=i.parent;this.events=[],this.eventElements=[]}},A}(i||{});"string"==typeof t&&(t=document.getElementById(t)),null!=t.svg&&t.svg.stop(),t.childNodes&&1==t.childNodes.length&&"OBJECT"==t.childNodes[0].nodeName||(t.svg=n);var s=t.getContext("2d");void 0!==e.documentElement?n.loadXmlDoc(s,e):"<"==e.substr(0,1)?n.loadXml(s,e):n.load(s,e)}else for(var a=document.querySelectorAll("svg"),r=0;r<a.length;r++){var o=a[r],l=document.createElement("canvas");l.width=o.clientWidth,l.height=o.clientHeight,o.parentNode.insertBefore(l,o),o.parentNode.removeChild(o);var h=document.createElement("div");h.appendChild(o),c(l,h.innerHTML)}};"undefined"==typeof Element||(void 0!==Element.prototype.matches?f=function(t,e){return t.matches(e)}:void 0!==Element.prototype.webkitMatchesSelector?f=function(t,e){return t.webkitMatchesSelector(e)}:void 0!==Element.prototype.mozMatchesSelector?f=function(t,e){return t.mozMatchesSelector(e)}:void 0!==Element.prototype.msMatchesSelector?f=function(t,e){return t.msMatchesSelector(e)}:void 0!==Element.prototype.oMatchesSelector?f=function(t,e){return t.oMatchesSelector(e)}:("function"!=typeof jQuery&&"function"!=typeof Zepto||(f=function(t,e){return $(t).is(e)}),void 0===f&&"undefined"!=typeof Sizzle&&(f=Sizzle.matchesSelector)));var e=/(\[[^\]]+\])/g,i=/(#[^\s\+>~\.\[:]+)/g,a=/(\.[^\s\+>~\.\[:]+)/g,r=/(::[^\s\+>~\.\[:]+|:first-line|:first-letter|:before|:after)/gi,o=/(:[\w-]+\([^\)]*\))/gi,l=/(:[^\s\+>~\.\[:]+)/g,h=/([^\s\+>~\.\[:]+)/g;function w(n){var s=[0,0,0],t=function(t,e){var i=n.match(t);null!=i&&(s[e]+=i.length,n=n.replace(t," "))};return n=(n=n.replace(/:not\(([^\)]*)\)/g,"     $1 ")).replace(/{[\s\S]*/gm," "),t(e,1),t(i,0),t(a,1),t(r,2),t(o,1),t(l,1),n=(n=n.replace(/[\*\s\+>~]/g," ")).replace(/[#\.]/g," "),t(h,2),s.join("")}"undefined"!=typeof CanvasRenderingContext2D&&(CanvasRenderingContext2D.prototype.drawSvg=function(t,e,i,n,s,a){var r={ignoreMouse:!0,ignoreAnimation:!0,ignoreDimensions:!0,ignoreClear:!0,offsetX:e,offsetY:i,scaleWidth:n,scaleHeight:s};for(var o in a)a.hasOwnProperty(o)&&(r[o]=a[o]);c(this.canvas,t,r)}),t.exports=c}(t={exports:{}},t.exports),t.exports});

/***/ }),

/***/ "AqgP":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__("TqRt");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.tranformSingleToMulti = tranformSingleToMulti;
exports.default = void 0;

var _toConsumableArray2 = _interopRequireDefault(__webpack_require__("RIqP"));

var _defineProperty2 = _interopRequireDefault(__webpack_require__("lSNA"));

var _classCallCheck2 = _interopRequireDefault(__webpack_require__("lwsE"));

var _createClass2 = _interopRequireDefault(__webpack_require__("W8MJ"));

var _slicedToArray2 = _interopRequireDefault(__webpack_require__("J4zp"));

var _getFeatures = _interopRequireDefault(__webpack_require__("6TV0"));

var _lodash = _interopRequireDefault(__webpack_require__("CeSn"));

var _lodash2 = _interopRequireDefault(__webpack_require__("XaGS"));

var _lodash3 = _interopRequireDefault(__webpack_require__("w1NJ"));

var _lodash4 = _interopRequireDefault(__webpack_require__("SPmy"));

var _util = __webpack_require__("e7LN");

var _statistics = __webpack_require__("EtYe");

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

// 三方服务请求的结果为单对象的时候，是否要转成多个features
function tranformSingleToMulti(data) {
  var dataInfo = (data.features[0] || {}).properties;

  if (dataInfo) {
    data.features = Object.entries(dataInfo).map(function (_ref) {
      var _ref2 = (0, _slicedToArray2.default)(_ref, 2),
          key = _ref2[0],
          value = _ref2[1];

      return {
        properties: {
          label: key,
          value: value
        }
      };
    });
    return Object.assign(data, (0, _statistics.statisticsFeatures)(data.features));
  }

  return data;
}
/**
 * @class EchartsDataService
 * @classdesc 图表组件功能类
 * @param {Chart-dataset} dataset - 请求的参数
 * @param {Array.<Chart-datasetOption>} datasetOptions - 数据解析的配置。
 */

/**
 * @typedef {Object} Chart-dataset  - 数据来源
 * @property {string} [type = 'iServer'] - 服务类型 iServer, iPortal。
 * @property {string} url - 服务url地址。
 * @property {boolean} [withCredentials = false] - 设置请求是否带cookie
 * @property {SuperMap.FilterParameter} queryInfo - 查询条件
 */

/**
 * @typedef {Object} Chart-datasetOption  - 解析数据的配置
 * @property {string} seriesType - 图表类型line, bar, scatter, pie, radar, gauge。
 * @property {boolean} [isStastic = false] - 是否统计数据。
 * @property {boolean} [isStack = false] - 图表（line, bar, scatter）是否堆叠
 * @property {string} xField - 数据的字段，坐标值
 * @property {string} yField - 数据的字段，数据值
 */


var EchartsDataService =
/*#__PURE__*/
function () {
  function EchartsDataService(dataset, datasetOptions) {
    (0, _classCallCheck2.default)(this, EchartsDataService);
    // 设置默认值
    dataset.withCredentials = dataset.withCredentials || false; // 请求认证

    this.dataset = dataset;
    this.datasetOptions = datasetOptions;
    this.dataCache = null; // 缓存的是请求后的数据

    this.axisDatas = []; // 坐标data

    this.serieDatas = []; // series data

    this.gridAxis = {
      xAxis: [],
      yAxis: {}
    }; // 直角坐标系

    this.radarAxis = {}; // 雷达图坐标系

    this.radarMax = 0; // 雷达图坐标最大值
  }
  /**
   * @function EchartsDataService.prototype.getDataOption
   * @description 获取符合echart data数据格式的数据, 入口函数。
   * @returns {Object}  带有请求的数据的promise对象
   */


  (0, _createClass2.default)(EchartsDataService, [{
    key: "getDataOption",
    value: function getDataOption(dataset) {
      var _this = this;

      var xBar = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      // 设置datasets的默认配置type，withCredentials
      var promise = new Promise(function (resolve, reject) {
        // 请求数据，请求成功后，解析数据
        (0, _getFeatures.default)(dataset).then(function (data) {
          // 兼容三方服务接口返回的一个普通的对象
          if (data.transformed && !!data.features.length) {
            data = tranformSingleToMulti(data);
          } // 设置this.data


          _this._setData(data); // 解析数据，生成dataOption


          var options;

          if (_this.dataset.type === 'iPortal' || _this.dataset.type === 'iServer' || _this.dataset.type === 'rest') {
            options = _this.formatChartData(_this.datasetOptions, xBar, data);
          }

          resolve(options);
        }).catch(function (e) {
          reject(e);
        });
      });
      return promise;
    }
    /**
     * @function EchartsDataService.prototype.formatChartData
     * @description _requestData方法中返回的数据: 设置数据，转换数据格式。
     * @param {Object} data - 从superMap的iserver,iportal中请求返回的数据
     * @param {Object} datasetOptions - 数据解析的配置参数
     * @returns {Object}  符合echart格式的数据
     */

  }, {
    key: "formatChartData",
    value: function formatChartData(datasetOptions) {
      var _this2 = this;

      var xBar = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      var data = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : this.dataCache;

      // 清除数据缓存
      this._clearChartCache(); // 设置datasetOptions


      this.setDatasetOptions(datasetOptions); // 生成seriedata

      datasetOptions.forEach(function (item) {
        // 生成YData, XData
        var fieldData = _this2._fieldsData(data, item, xBar); // 解析YData, XData，生成EchartsOption的data


        var serieData = _this2._createDataOption(fieldData, item); // 设置坐标


        _this2._createAxisData(fieldData, item);

        _this2.serieDatas.push(serieData);
      });
      var gridAxis = (this.gridAxis.xAxis.length > 0 || JSON.stringify(this.gridAxis.yAxis) !== '{}') && this.gridAxis;
      var radarAxis = this.radarAxis;
      var series = this.serieDatas;
      return _objectSpread({}, gridAxis, {}, radarAxis, {
        series: series
      });
    }
    /**
     * @function EchartsDataService.prototype.setDatasetOptions
     * @private
     * @description 设置datasetOptions
     * @param {Array.<Chart-datasetOption>} datasetOptions - 数据解析的配置
     */

  }, {
    key: "setDatasetOptions",
    value: function setDatasetOptions(datasetOptions) {
      this.datasetOptions = datasetOptions;
    }
    /**
     * @function EchartsDataService.prototype._setData
     * @private
     * @description 给实例绑定data。
     * @param {Object} data - 从superMap的iserver,iportal中请求返回的数据
     */

  }, {
    key: "_setData",
    value: function _setData(data) {
      if (data) {
        this.dataCache = data;
      }
    }
    /**
     * @function EchartsDataService.prototype._clearChartCache
     * @private
     * @description 清除已经生成的chart数据的缓存。
     */

  }, {
    key: "_clearChartCache",
    value: function _clearChartCache() {
      this.axisDatas = []; // 坐标data

      this.serieDatas = []; // series data

      this.gridAxis = {
        xAxis: [],
        yAxis: {}
      }; // 直角坐标系
    }
    /**
     * @function EchartsDataService.prototype._createSeriesData
     * @private
     * @description 生成chart的serie。
     * @param {Object} fieldData - 解析后的数据{xData,yData}
     * @param {Chart-datasetOption} datasetOption - 数据解析的配置
     * @returns {Object}  配置好的serieData
     */

  }, {
    key: "_createDataOption",
    value: function _createDataOption(fieldData, datasetOption) {
      var chartType = datasetOption.seriesType;
      var XData = fieldData.xData;
      var YData = fieldData.yData;
      var serieData = {
        type: chartType,
        name: datasetOption.yField,
        data: []
      };

      if (chartType === 'pie') {
        YData.forEach(function (value, index) {
          serieData.data.push({
            value: value,
            name: XData[index]
          });
        });
      } else if (chartType === 'radar') {
        var yData = (0, _toConsumableArray2.default)(YData);
        serieData.data.push({
          value: (0, _toConsumableArray2.default)(YData),
          name: datasetOption.yField
        }); // 获取雷达图的max最大值

        var maxValue = (0, _lodash3.default)(yData);
        this.radarMax = Math.max(maxValue, this.radarMax);
      } else {
        // line bar scatter gauge
        serieData.data = (0, _toConsumableArray2.default)(YData); // 是否堆叠数据（line,bar,scatter）

        if (datasetOption.isStack) {
          serieData.stack = 1;
        } else {
          serieData.stack = 0;
        }
      }

      return serieData;
    }
    /**
     * @function EchartsDataService.prototype._createSeriesData
     * @private
     * @description 生成chart的serie。
     * @param {Object} fieldData - 解析后的数据{xData,yData}
     * @param {Chart-datasetOption} datasetOption - 数据解析的配置
     * @returns {Object}  配置好的坐标data
     */

  }, {
    key: "_createAxisData",
    value: function _createAxisData(fieldData, datasetOption) {
      var chartType = datasetOption.seriesType;
      var XData = fieldData.xData;
      var radarData = [];
      var axisData;

      if (chartType === 'radar') {
        var radarMax = this.radarMax;
        XData.forEach(function (text) {
          radarData.push({
            text: text,
            max: radarMax
          });
        });
        this.radarAxis = {
          radar: {
            indicator: radarData
          }
        };
        axisData = this.radarAxis;
      } else if (chartType === 'bar' || chartType === 'line' || chartType === 'scatter') {
        var data = XData && (0, _toConsumableArray2.default)(XData);

        if (!this.gridAxis.xAxis) {
          this.gridAxis.xAxis = [];
          this.gridAxis.yAxis = {};
        }

        if (this.gridAxis.xAxis.length === 0 || !(0, _lodash2.default)(data, this.gridAxis.xAxis[0].data)) {
          this.gridAxis.xAxis.push({
            data: data
          });
        }

        axisData = this.gridAxis;
      } else {
        axisData = {};
      }

      return axisData;
    }
    /**
     * @function EchartsDataService.prototype._fieldsData
     * @private
     * @description 将请求回来的数据，转换成适用于chart配置的数据。
     * @param {Object} data - 从superMap的iserver,iportal中请求返回的数据
     * @param {Chart-datasetOption} datasetOption - 数据解析的配置
     * @returns {Object}  解析好的Ydata，xdata
     */

  }, {
    key: "_fieldsData",
    value: function _fieldsData(data, datasetOption) {
      var xBar = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
      var fieldCaptions, fieldValues, xFieldIndex, yFieldIndex, fieldValueIndex, xData, yData, result;
      var sort = datasetOption.sort,
          yField = datasetOption.yField,
          xField = datasetOption.xField,
          isStastic = datasetOption.isStastic;
      fieldCaptions = data.fieldCaptions; // 所有x字段

      xFieldIndex = fieldCaptions.indexOf(xField); // x字段的下标

      yFieldIndex = fieldCaptions.indexOf(yField); // y字段的下标

      fieldValues = yFieldIndex < 0 ? [] : data.fieldValues[yFieldIndex]; // y字段的所有feature值
      // 该数据是否需要统计,统计的是数组下标

      if (isStastic) {
        fieldValueIndex = this._getUniqFieldDatas(data, xFieldIndex, sort); // 生成统计后的数据

        xData = this._stasticXData(fieldValueIndex, sort);
        yData = this._stasticYData(fieldValues, fieldValueIndex, sort);
      } else {
        // 如果不是统计图表
        xData = this._getFieldDatas(data, xFieldIndex);
        yData = (0, _toConsumableArray2.default)(fieldValues);
      }

      result = sort && sort !== 'unsort' ? this._resortData(xData, yData, sort, xBar) : {
        xData: xData,
        yData: yData
      };
      return result;
    }
  }, {
    key: "_resortData",
    value: function _resortData(xData, yData, sort) {
      var xBar = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;
      var obj = [];
      yData.forEach(function (item, index) {
        obj.push({
          y: item,
          x: xData[index]
        });
      });
      obj = (0, _lodash4.default)(obj, function (o) {
        return o.y;
      }, sort === 'ascending' ? [xBar ? 'desc' : 'asc'] : [xBar ? 'asc' : 'desc']);
      var x = [];
      var y = [];
      obj.forEach(function (item) {
        x.push(item.x);
        y.push(item.y);
      });
      return {
        xData: x,
        yData: y
      };
    }
    /**
     * @function EchartsDataService.prototype._stasticXData
     * @private
     * @description 统计X字段数据，生成xData。
     * @param {Object} fieldValueIndex - x字段的统计索引
     * @returns {Array}  统计后的Xdata、
     */

  }, {
    key: "_stasticXData",
    value: function _stasticXData(fieldValueIndex) {
      var xData = Object.keys(fieldValueIndex);
      return xData;
    }
    /**
     * @function EchartsDataService.prototype._stasticYData
     * @private
     * @description 统计数据，生成yData。
     * @param {Object} fieldValues - y字段的所有feature值
     * @param {Object} fieldValueIndex - x字段的统计索引
     * @returns {Array}  统计后的Ydata、
     */

  }, {
    key: "_stasticYData",
    value: function _stasticYData(fieldValues, fieldValueIndex) {
      var yData = []; // 统计Y字段

      for (var key in fieldValueIndex) {
        var total = 0;
        fieldValueIndex[key].forEach(function (index) {
          // 清除字符串型的数字的逗号
          var num = fieldValues[index] && (0, _util.clearNumberComma)(fieldValues[index]);
          total += (0, _lodash.default)(num);
        });
        yData.push(total);
      }

      return yData;
    }
    /**
     * @function EchartsDataService.prototype._getUniqFieldDatas
     * @private
     * @description 获取x轴字段要统计的属性值
     * @param {Object} data - 从superMap的iserver,iportal中请求返回的数据的fieldValue
     * @param {String} fieldIndexs - x字段索引值数组
     * @returns {Object}  返回x轴字段要统计的属性值，返回值为eg:[fieldIndex：1, statiscIndex:{浇水地：[5,2,5,4], 林地：[5,2,5,4]...}]。
     */

  }, {
    key: "_getUniqFieldDatas",
    value: function _getUniqFieldDatas(data, fieldIndex) {
      var fieldValues = this._getFieldDatas(data, fieldIndex);

      var uniqFieldValues = {};

      if (fieldValues) {
        fieldValues.forEach(function (value, index) {
          if (!uniqFieldValues[value]) {
            uniqFieldValues[value] = [index];
          } else {
            uniqFieldValues[value].push(index);
          }
        });
      }

      return uniqFieldValues;
    }
    /**
     * @function EchartsDataService.prototype._getFieldDatas
     * @private
     * @description 。
     * @param {Object} data - 从superMap的iserver,iportal中请求返回的数据的fieldValue
     * @param {String} fieldIndex - x字段索引值
     * @returns {Array}  返回的是一个数组[林地， 旱地， 林地，沼泽，旱地...]
     */

  }, {
    key: "_getFieldDatas",
    value: function _getFieldDatas(data, fieldIndex) {
      // 获取x字段所有值，
      return data.fieldValues[fieldIndex];
    }
  }]);
  return EchartsDataService;
}();

exports.default = EchartsDataService;

/***/ }),

/***/ "AzSJ":
/***/ (function(module, exports) {

module.exports = __WEBPACK_EXTERNAL_MODULE_AzSJ__;

/***/ }),

/***/ "B4q0":
/***/ (function(module, exports, __webpack_require__) {

var helper = __webpack_require__("lsHq");
var xml2js = __webpack_require__("hE+I");

function validateOptions (userOptions) {
  var options = helper.copyOptions(userOptions);
  helper.ensureSpacesExists(options);
  return options;
}

module.exports = function(xml, userOptions) {
  var options, js, json, parentKey;
  options = validateOptions(userOptions);
  js = xml2js(xml, options);
  parentKey = 'compact' in options && options.compact ? '_parent' : 'parent';
  // parentKey = ptions.compact ? '_parent' : 'parent'; // consider this
  if ('addParent' in options && options.addParent) {
    json = JSON.stringify(js, function (k, v) { return k === parentKey? '_' : v; }, options.spaces);
  } else {
    json = JSON.stringify(js, null, options.spaces);
  }
  return json.replace(/\u2028/g, '\\u2028').replace(/\u2029/g, '\\u2029');
};


/***/ }),

/***/ "B8n6":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__("TqRt");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _theme = _interopRequireDefault(__webpack_require__("bCOg"));

//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
var _default = {
  name: 'SmIcon',
  mixins: [_theme.default],
  props: {
    type: {
      type: String,
      default: 'info'
    },
    iconStyle: {
      type: Object
    },
    theme: {
      type: String,
      default: 'outlined'
    },
    twoToneColor: {
      type: String
    },
    iconClass: {
      type: String
    },
    component: {
      type: Object
    },
    autoPrefix: {
      type: Boolean,
      default: true
    }
  },
  computed: {
    colorStyle: function colorStyle() {
      return !this.iconStyle || !this.iconStyle.color ? this.getColorStyle(0) : {
        color: this.iconStyle.color
      };
    },
    customIconClass: function customIconClass() {
      return this.autoPrefix ? 'sm-components-icons-' + this.iconClass : this.iconClass;
    }
  }
};
exports.default = _default;

/***/ }),

/***/ "BFO0":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__("TqRt");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _classCallCheck2 = _interopRequireDefault(__webpack_require__("lwsE"));

var _createClass2 = _interopRequireDefault(__webpack_require__("W8MJ"));

var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__("a1gu"));

var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__("Nsbk"));

var _inherits2 = _interopRequireDefault(__webpack_require__("7W2i"));

var _leaflet = _interopRequireDefault(__webpack_require__("hgx0"));

__webpack_require__("17FK");

var _propsBinder = __webpack_require__("hS5c");

var RasterTileLayerViewModel =
/*#__PURE__*/
function (_L$Evented) {
  (0, _inherits2.default)(RasterTileLayerViewModel, _L$Evented);

  function RasterTileLayerViewModel(options) {
    var _this;

    (0, _classCallCheck2.default)(this, RasterTileLayerViewModel);
    _this = (0, _possibleConstructorReturn2.default)(this, (0, _getPrototypeOf2.default)(RasterTileLayerViewModel).call(this));
    _this.defaultOptions = {
      minZoom: 0,
      maxZoom: 22,
      opacity: 1,
      tileSize: 256
    };

    var _loop = function _loop(key) {
      var setMethodName = 'set' + (0, _propsBinder.capitalizeFirstLetter)(key);

      _this[setMethodName] = function (newVal) {
        if (this.layer) {
          this.layer._paramsChanged = true;

          if (key === 'url') {
            this.layer.setUrl(newVal);
          } else if (key === 'bounds') {
            this.layer.options[key] = this._setBounds(newVal);
          } else {
            this.layer.options[key] = newVal;
            this.layer.redraw();
          }
        }
      };
    };

    for (var key in options) {
      _loop(key);
    }

    Object.assign(_this.defaultOptions, options);
    _this.defaultOptions.bounds && (_this.defaultOptions.bounds = _this._setBounds(_this.defaultOptions.bounds));

    _this._init();

    return _this;
  }

  (0, _createClass2.default)(RasterTileLayerViewModel, [{
    key: "_setBounds",
    value: function _setBounds(bounds) {
      return _leaflet.default.latLngBounds(_leaflet.default.latLng(bounds[1], bounds[0]), _leaflet.default.latLng(bounds[3], bounds[2]));
    }
  }, {
    key: "_init",
    value: function _init() {
      this._addLayer();
    }
  }, {
    key: "_addLayer",
    value: function _addLayer() {
      this.layer = _leaflet.default.supermap.tiledMapLayer(this.defaultOptions.url, this.defaultOptions);
    }
  }, {
    key: "getLayer",
    value: function getLayer() {
      return this.layer;
    }
  }, {
    key: "addTo",
    value: function addTo(map) {
      this.map = map;
      this.map.addLayer(this.layer);
    }
  }, {
    key: "clear",
    value: function clear() {
      var map = this.map,
          layer = this.layer;

      if (map && layer && map.hasLayer(this.layer)) {
        map.removeLayer(layer);
      }
    }
  }]);
  return RasterTileLayerViewModel;
}(_leaflet.default.Evented);

exports.default = RasterTileLayerViewModel;

/***/ }),

/***/ "Bnag":
/***/ (function(module, exports) {

function _nonIterableSpread() {
  throw new TypeError("Invalid attempt to spread non-iterable instance");
}

module.exports = _nonIterableSpread;

/***/ }),

/***/ "BtDp":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_Border_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("ydGV");
/* harmony import */ var _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_Border_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_Border_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__);
/* harmony reexport (unknown) */ for(var __WEBPACK_IMPORT_KEY__ in _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_Border_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__) if(__WEBPACK_IMPORT_KEY__ !== 'default') (function(key) { __webpack_require__.d(__webpack_exports__, key, function() { return _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_Border_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__[key]; }) }(__WEBPACK_IMPORT_KEY__));
 /* harmony default export */ __webpack_exports__["default"] = (_node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_Border_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0___default.a); 

/***/ }),

/***/ "C/aJ":
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ "C07L":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _CountTo_vue_vue_type_template_id_53dff5c7___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("3DSN");
/* harmony import */ var _CountTo_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("1Mc+");
/* harmony reexport (unknown) */ for(var __WEBPACK_IMPORT_KEY__ in _CountTo_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_1__) if(__WEBPACK_IMPORT_KEY__ !== 'default') (function(key) { __webpack_require__.d(__webpack_exports__, key, function() { return _CountTo_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_1__[key]; }) }(__WEBPACK_IMPORT_KEY__));
/* harmony import */ var _node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("KHd+");





/* normalize component */

var component = Object(_node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_2__[/* default */ "a"])(
  _CountTo_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_1__["default"],
  _CountTo_vue_vue_type_template_id_53dff5c7___WEBPACK_IMPORTED_MODULE_0__[/* render */ "a"],
  _CountTo_vue_vue_type_template_id_53dff5c7___WEBPACK_IMPORTED_MODULE_0__[/* staticRenderFns */ "b"],
  false,
  null,
  null,
  null
  
)

/* harmony default export */ __webpack_exports__["default"] = (component.exports);

/***/ }),

/***/ "C55n":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";

// CONCATENATED MODULE: ./node_modules/vue-loader/lib/loaders/templateLoader.js??vue-loader-options!./node_modules/vue-loader/lib??vue-loader-options!./src/common/border/Border.vue?vue&type=template&id=52e77cab&
var render = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{ref:_vm.borderId,staticClass:"sm-component-border",style:(_vm.borderStyle)},[_c('div',{staticClass:"sm-component-border__content",style:(_vm.contentStyle)},[_vm._t("default")],2)])}
var staticRenderFns = []


// CONCATENATED MODULE: ./src/common/border/Border.vue?vue&type=template&id=52e77cab&
/* concated harmony reexport render */__webpack_require__.d(__webpack_exports__, "a", function() { return render; });
/* concated harmony reexport staticRenderFns */__webpack_require__.d(__webpack_exports__, "b", function() { return staticRenderFns; });


/***/ }),

/***/ "C6WP":
/***/ (function(module) {

module.exports = JSON.parse("[{\"name\":\"黑龙江省\",\"coord\":[127.64559817675396,48.48668098449708]},{\"name\":\"内蒙古自治区\",\"coord\":[118.34519572208615,45.370218276977525]},{\"name\":\"新疆维吾尔自治区\",\"coord\":[87.13479065593184,41.75497055053711]},{\"name\":\"吉林省\",\"coord\":[126.12985278813787,43.57983207702637]},{\"name\":\"辽宁省\",\"coord\":[124.02494773936439,41.105743408203125]},{\"name\":\"甘肃省\",\"coord\":[102.87785725633012,37.69582366943361]},{\"name\":\"河北省\",\"coord\":[115.66327227481898,39.33383178710938]},{\"name\":\"北京市\",\"coord\":[116.62199343603638,40.25053787231445]},{\"name\":\"山西省\",\"coord\":[112.45180235808988,37.666561126708984]},{\"name\":\"天津市\",\"coord\":[117.35711842642581,39.406789779663086]},{\"name\":\"陕西省\",\"coord\":[109.56294003056632,35.64754199981689]},{\"name\":\"宁夏回族自治区\",\"coord\":[105.96110877640074,37.3081169128418]},{\"name\":\"青海省\",\"coord\":[96.07301048277901,35.44417190551758]},{\"name\":\"山东省\",\"coord\":[118.03833752951093,36.29800605773925]},{\"name\":\"西藏自治区\",\"coord\":[87.47361520439412,31.6703872680664]},{\"name\":\"河南省\",\"coord\":[113.07832397097275,33.87751102447509]},{\"name\":\"江苏省\",\"coord\":[119.93926538201052,32.945452690124505]},{\"name\":\"安徽省\",\"coord\":[117.15146765881019,32.024482727050774]},{\"name\":\"四川省\",\"coord\":[102.28998890142759,30.182161331176758]},{\"name\":\"湖北省\",\"coord\":[112.87798261431585,31.157071113586426]},{\"name\":\"重庆市\",\"coord\":[107.870126637831,30.188085556030266]},{\"name\":\"上海市\",\"coord\":[121.42561166015514,31.276043891906745]},{\"name\":\"浙江省\",\"coord\":[119.75337092707514,29.175934791564945]},{\"name\":\"湖南省\",\"coord\":[111.52770282777405,27.38110256195069]},{\"name\":\"江西省\",\"coord\":[115.51091280655628,27.283511161804206]},{\"name\":\"云南省\",\"coord\":[101.27053825991308,25.19783210754396]},{\"name\":\"贵州省\",\"coord\":[106.49672346773299,26.92267990112305]},{\"name\":\"福建省\",\"coord\":[117.9976766946587,25.939599990844727]},{\"name\":\"广西壮族自治区\",\"coord\":[108.98706831086302,23.891559600830078]},{\"name\":\"台湾省\",\"coord\":[120.82468432537434,23.602651596069336]},{\"name\":\"香港特别行政区\",\"coord\":[114.21036850371561,22.374858856201172]},{\"name\":\"海南省\",\"coord\":[109.62792940960824,19.163116455078125]},{\"name\":\"广东省\",\"coord\":[113.32127888266032,22.873867034912106]},{\"name\":\"澳门特别行政区\",\"coord\":[113.56819996291901,22.160347992976]}]");

/***/ }),

/***/ "CWBI":
/***/ (function(module, exports, __webpack_require__) {

module.exports = __webpack_require__("sZro");


/***/ }),

/***/ "Cb6A":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,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"

/***/ }),

/***/ "CeSn":
/***/ (function(module, exports) {

/**
 * lodash (Custom Build) <https://lodash.com/>
 * Build: `lodash modularize exports="npm" -o ./`
 * Copyright jQuery Foundation and other contributors <https://jquery.org/>
 * Released under MIT license <https://lodash.com/license>
 * Based on Underscore.js 1.8.3 <http://underscorejs.org/LICENSE>
 * Copyright Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
 */

/** Used as references for various `Number` constants. */
var NAN = 0 / 0;

/** `Object#toString` result references. */
var symbolTag = '[object Symbol]';

/** Used to match leading and trailing whitespace. */
var reTrim = /^\s+|\s+$/g;

/** Used to detect bad signed hexadecimal string values. */
var reIsBadHex = /^[-+]0x[0-9a-f]+$/i;

/** Used to detect binary string values. */
var reIsBinary = /^0b[01]+$/i;

/** Used to detect octal string values. */
var reIsOctal = /^0o[0-7]+$/i;

/** Built-in method references without a dependency on `root`. */
var freeParseInt = parseInt;

/** Used for built-in method references. */
var objectProto = Object.prototype;

/**
 * Used to resolve the
 * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
 * of values.
 */
var objectToString = objectProto.toString;

/**
 * Checks if `value` is the
 * [language type](http://www.ecma-international.org/ecma-262/7.0/#sec-ecmascript-language-types)
 * of `Object`. (e.g. arrays, functions, objects, regexes, `new Number(0)`, and `new String('')`)
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an object, else `false`.
 * @example
 *
 * _.isObject({});
 * // => true
 *
 * _.isObject([1, 2, 3]);
 * // => true
 *
 * _.isObject(_.noop);
 * // => true
 *
 * _.isObject(null);
 * // => false
 */
function isObject(value) {
  var type = typeof value;
  return !!value && (type == 'object' || type == 'function');
}

/**
 * Checks if `value` is object-like. A value is object-like if it's not `null`
 * and has a `typeof` result of "object".
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is object-like, else `false`.
 * @example
 *
 * _.isObjectLike({});
 * // => true
 *
 * _.isObjectLike([1, 2, 3]);
 * // => true
 *
 * _.isObjectLike(_.noop);
 * // => false
 *
 * _.isObjectLike(null);
 * // => false
 */
function isObjectLike(value) {
  return !!value && typeof value == 'object';
}

/**
 * Checks if `value` is classified as a `Symbol` primitive or object.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a symbol, else `false`.
 * @example
 *
 * _.isSymbol(Symbol.iterator);
 * // => true
 *
 * _.isSymbol('abc');
 * // => false
 */
function isSymbol(value) {
  return typeof value == 'symbol' ||
    (isObjectLike(value) && objectToString.call(value) == symbolTag);
}

/**
 * Converts `value` to a number.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to process.
 * @returns {number} Returns the number.
 * @example
 *
 * _.toNumber(3.2);
 * // => 3.2
 *
 * _.toNumber(Number.MIN_VALUE);
 * // => 5e-324
 *
 * _.toNumber(Infinity);
 * // => Infinity
 *
 * _.toNumber('3.2');
 * // => 3.2
 */
function toNumber(value) {
  if (typeof value == 'number') {
    return value;
  }
  if (isSymbol(value)) {
    return NAN;
  }
  if (isObject(value)) {
    var other = typeof value.valueOf == 'function' ? value.valueOf() : value;
    value = isObject(other) ? (other + '') : other;
  }
  if (typeof value != 'string') {
    return value === 0 ? value : +value;
  }
  value = value.replace(reTrim, '');
  var isBinary = reIsBinary.test(value);
  return (isBinary || reIsOctal.test(value))
    ? freeParseInt(value.slice(2), isBinary ? 2 : 8)
    : (reIsBadHex.test(value) ? NAN : +value);
}

module.exports = toNumber;


/***/ }),

/***/ "DMW1":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,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"

/***/ }),

/***/ "DSM6":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__("TqRt");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLanguage = getLanguage;
exports.geti18n = geti18n;
exports.setLocale = setLocale;
exports.initi18n = initi18n;
exports.default = exports.lang = void 0;

var _defineProperty2 = _interopRequireDefault(__webpack_require__("lSNA"));

var _jsCookie = _interopRequireDefault(__webpack_require__("p46w"));

var _en = _interopRequireDefault(__webpack_require__("W1yv"));

var _zh = _interopRequireDefault(__webpack_require__("ORi+"));

var _lodash = _interopRequireDefault(__webpack_require__("zT9C"));

var _vueI18n = _interopRequireDefault(__webpack_require__("qSUR"));

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var dateTimeFormats = {
  en: _en.default.dateTimeFormat,
  zh: _zh.default.dateTimeFormat
};
var i18n = {};
var rooti18n;
var messages = {
  en: _objectSpread({}, _en.default),
  zh: _objectSpread({}, _zh.default)
};

function getLanguage() {
  var lang = _jsCookie.default.get('language');

  if (!lang) {
    if (navigator.appName === 'Netscape') {
      lang = navigator.language;
    } else {
      lang = navigator.browserLanguage;
    }
  }

  if (lang) {
    if (lang.indexOf('zh') === 0) {
      return 'zh';
    }

    if (lang.indexOf('en') === 0) {
      return 'en';
    }
  }

  return 'zh';
}

function geti18n(n) {
  return rooti18n || i18n;
}

function setLocale(locales) {
  i18n.mergeLocaleMessage && i18n.mergeLocaleMessage(i18n.locale, locales);
}

var lang = {
  en: (0, _lodash.default)(_en.default),
  zh: (0, _lodash.default)(_zh.default)
};
exports.lang = lang;

function initi18n(Vue, config) {
  config = config || {};

  if (config.i18n) {
    i18n = config.i18n;

    if (!i18n.getDateTimeFormat().hasOwnProperty()) {
      i18n.setDateTimeFormat('en', _en.default.dateTimeFormat);
      i18n.setDateTimeFormat('zh', _zh.default.dateTimeFormat);
    }

    i18n.mergeLocaleMessage && i18n.mergeLocaleMessage('en', _en.default);
    i18n.mergeLocaleMessage && i18n.mergeLocaleMessage('zh', _zh.default);
  } else if (!Vue.prototype.hasOwnProperty('$i18n')) {
    Object.defineProperty(Vue.prototype, '$i18n', {
      get: function get() {
        if (!rooti18n && this.$root && this.$root.$options.i18n) {
          rooti18n = this.$root.$options.i18n;
        }

        return rooti18n || i18n;
      }
    });
    Vue.use(_vueI18n.default);
    i18n = new _vueI18n.default({
      dateTimeFormats: dateTimeFormats,
      locale: getLanguage(),
      fallbackLocale: 'zh',
      messages: messages
    });
  }

  if (config.locale) {
    setLocale(config.locale);
  }
}

var _default = i18n;
/*
Example
假设国际化资源配置为：
layerList: {
    title: "图层",
    hello: '{msg} world',
    hello1: '{0} world',
    theWorld: 'the world',
    dio: 'DIO:',
    linked: '@:(message.dio) @:(message.theWorld) !!!!'，
    apple: 'no apples | one apple | {count} apples'
},
vue中调用：
this.$tc('layerList.apple',10,{ count: 20 })

文本模板调用：
$t方法：
<span>{{$t("layerList.title")}}</span>
==>
<span>图层</span>

<span>{{$t("layerList.hello",{msg:"hello"})}}</span>
==>
<span>hello world</span>

<span>{{$t("layerList.hello1",["bye"])}}</span>
==>
<span>bye world</span>

<span>{{$t("layerList.linked")}}</span>
==>
<span>DIO: the world !!!!</span>

$tc方法：
<p>{{ $tc('layerList.apple', 0) }}</p>
==>
<p>no apples</p>

<p>{{ $tc('layerList.apple', 1) }}</p>
==>
<p>one apple</p>

<p>{{ $tc('layerList.apple', 10}}</p>
==>
<p>10 apples</p>

<p>{{ $tc('layerList.apple', 10, { count: 20 }) }}</p>
==>
<p>20 apples</p>

日期格式处理（$d）：https://kazupon.github.io/vue-i18n/guide/datetime.html
数字格式处理（$n）：https://kazupon.github.io/vue-i18n/guide/number.html
*/

exports.default = _default;

/***/ }),

/***/ "EbDI":
/***/ (function(module, exports) {

function _iterableToArray(iter) {
  if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
}

module.exports = _iterableToArray;

/***/ }),

/***/ "EtYe":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.statisticsFeatures = statisticsFeatures;

function statisticsFeatures(features, fields, fieldCaptions, fieldTypes) {
  var data = {
    features: features,
    fields: fields || [],
    fieldCaptions: fieldCaptions || [],
    fieldValues: [],
    fieldTypes: fieldTypes
  };

  if (features && !!features.length && !fieldCaptions && !fields) {
    var feature = features[0]; // 获取每个字段的名字和类型

    for (var attr in feature.properties) {
      data.fieldCaptions.push(attr);
      data.fields.push(attr);
    }
  }

  for (var m in data.fields) {
    var fieldValue = [];

    for (var j in features) {
      var _feature = features[j];
      var field = data.fields[m];
      var value = _feature.properties[field];
      fieldValue.push(value);
    } // fieldValues   [[每个字段的所有要素值],[],[]]


    data.fieldValues.push(fieldValue);
  }

  return data;
}

/***/ }),

/***/ "ExA7":
/***/ (function(module, exports) {

/**
 * Checks if `value` is object-like. A value is object-like if it's not `null`
 * and has a `typeof` result of "object".
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is object-like, else `false`.
 * @example
 *
 * _.isObjectLike({});
 * // => true
 *
 * _.isObjectLike([1, 2, 3]);
 * // => true
 *
 * _.isObjectLike(_.noop);
 * // => false
 *
 * _.isObjectLike(null);
 * // => false
 */
function isObjectLike(value) {
  return value != null && typeof value == 'object';
}

module.exports = isObjectLike;


/***/ }),

/***/ "FHWo":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_TimeText_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("TTB2");
/* harmony import */ var _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_TimeText_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_TimeText_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__);
/* harmony reexport (unknown) */ for(var __WEBPACK_IMPORT_KEY__ in _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_TimeText_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__) if(__WEBPACK_IMPORT_KEY__ !== 'default') (function(key) { __webpack_require__.d(__webpack_exports__, key, function() { return _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_TimeText_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__[key]; }) }(__WEBPACK_IMPORT_KEY__));
 /* harmony default export */ __webpack_exports__["default"] = (_node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_TimeText_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0___default.a); 

/***/ }),

/***/ "FXEt":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_TablePopup_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("dXCY");
/* harmony import */ var _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_TablePopup_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_TablePopup_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__);
/* harmony reexport (unknown) */ for(var __WEBPACK_IMPORT_KEY__ in _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_TablePopup_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__) if(__WEBPACK_IMPORT_KEY__ !== 'default') (function(key) { __webpack_require__.d(__webpack_exports__, key, function() { return _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_TablePopup_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__[key]; }) }(__WEBPACK_IMPORT_KEY__));
 /* harmony default export */ __webpack_exports__["default"] = (_node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_TablePopup_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0___default.a); 

/***/ }),

/***/ "Fk5u":
/***/ (function(module, exports) {

module.exports = __WEBPACK_EXTERNAL_MODULE_Fk5u__;

/***/ }),

/***/ "G9Sk":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _SmTileLayer_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("UJ84");
/* harmony reexport (unknown) */ for(var __WEBPACK_IMPORT_KEY__ in _SmTileLayer_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__) if(__WEBPACK_IMPORT_KEY__ !== 'default') (function(key) { __webpack_require__.d(__webpack_exports__, key, function() { return _SmTileLayer_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__[key]; }) }(__WEBPACK_IMPORT_KEY__));
/* harmony import */ var _node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("KHd+");
var render, staticRenderFns




/* normalize component */

var component = Object(_node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_1__[/* default */ "a"])(
  _SmTileLayer_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__["default"],
  render,
  staticRenderFns,
  false,
  null,
  null,
  null
  
)

/* harmony default export */ __webpack_exports__["default"] = (component.exports);

/***/ }),

/***/ "GD9B":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Card_vue_vue_type_template_id_0b7b8e8a___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("UTm/");
/* harmony import */ var _Card_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("6hQo");
/* harmony reexport (unknown) */ for(var __WEBPACK_IMPORT_KEY__ in _Card_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_1__) if(__WEBPACK_IMPORT_KEY__ !== 'default') (function(key) { __webpack_require__.d(__webpack_exports__, key, function() { return _Card_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_1__[key]; }) }(__WEBPACK_IMPORT_KEY__));
/* harmony import */ var _node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("KHd+");





/* normalize component */

var component = Object(_node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_2__[/* default */ "a"])(
  _Card_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_1__["default"],
  _Card_vue_vue_type_template_id_0b7b8e8a___WEBPACK_IMPORTED_MODULE_0__[/* render */ "a"],
  _Card_vue_vue_type_template_id_0b7b8e8a___WEBPACK_IMPORTED_MODULE_0__[/* staticRenderFns */ "b"],
  false,
  null,
  null,
  null
  
)

/* harmony default export */ __webpack_exports__["default"] = (component.exports);

/***/ }),

/***/ "GlvM":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_Identify_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("LU8/");
/* harmony import */ var _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_Identify_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_Identify_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__);
/* harmony reexport (unknown) */ for(var __WEBPACK_IMPORT_KEY__ in _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_Identify_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__) if(__WEBPACK_IMPORT_KEY__ !== 'default') (function(key) { __webpack_require__.d(__webpack_exports__, key, function() { return _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_Identify_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__[key]; }) }(__WEBPACK_IMPORT_KEY__));
 /* harmony default export */ __webpack_exports__["default"] = (_node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_Identify_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0___default.a); 

/***/ }),

/***/ "GoyQ":
/***/ (function(module, exports) {

/**
 * Checks if `value` is the
 * [language type](http://www.ecma-international.org/ecma-262/7.0/#sec-ecmascript-language-types)
 * of `Object`. (e.g. arrays, functions, objects, regexes, `new Number(0)`, and `new String('')`)
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an object, else `false`.
 * @example
 *
 * _.isObject({});
 * // => true
 *
 * _.isObject([1, 2, 3]);
 * // => true
 *
 * _.isObject(_.noop);
 * // => true
 *
 * _.isObject(null);
 * // => false
 */
function isObject(value) {
  var type = typeof value;
  return value != null && (type == 'object' || type == 'function');
}

module.exports = isObject;


/***/ }),

/***/ "H7XF":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


exports.byteLength = byteLength
exports.toByteArray = toByteArray
exports.fromByteArray = fromByteArray

var lookup = []
var revLookup = []
var Arr = typeof Uint8Array !== 'undefined' ? Uint8Array : Array

var code = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/'
for (var i = 0, len = code.length; i < len; ++i) {
  lookup[i] = code[i]
  revLookup[code.charCodeAt(i)] = i
}

// Support decoding URL-safe base64 strings, as Node.js does.
// See: https://en.wikipedia.org/wiki/Base64#URL_applications
revLookup['-'.charCodeAt(0)] = 62
revLookup['_'.charCodeAt(0)] = 63

function getLens (b64) {
  var len = b64.length

  if (len % 4 > 0) {
    throw new Error('Invalid string. Length must be a multiple of 4')
  }

  // Trim off extra bytes after placeholder bytes are found
  // See: https://github.com/beatgammit/base64-js/issues/42
  var validLen = b64.indexOf('=')
  if (validLen === -1) validLen = len

  var placeHoldersLen = validLen === len
    ? 0
    : 4 - (validLen % 4)

  return [validLen, placeHoldersLen]
}

// base64 is 4/3 + up to two characters of the original data
function byteLength (b64) {
  var lens = getLens(b64)
  var validLen = lens[0]
  var placeHoldersLen = lens[1]
  return ((validLen + placeHoldersLen) * 3 / 4) - placeHoldersLen
}

function _byteLength (b64, validLen, placeHoldersLen) {
  return ((validLen + placeHoldersLen) * 3 / 4) - placeHoldersLen
}

function toByteArray (b64) {
  var tmp
  var lens = getLens(b64)
  var validLen = lens[0]
  var placeHoldersLen = lens[1]

  var arr = new Arr(_byteLength(b64, validLen, placeHoldersLen))

  var curByte = 0

  // if there are placeholders, only get up to the last complete 4 chars
  var len = placeHoldersLen > 0
    ? validLen - 4
    : validLen

  var i
  for (i = 0; i < len; i += 4) {
    tmp =
      (revLookup[b64.charCodeAt(i)] << 18) |
      (revLookup[b64.charCodeAt(i + 1)] << 12) |
      (revLookup[b64.charCodeAt(i + 2)] << 6) |
      revLookup[b64.charCodeAt(i + 3)]
    arr[curByte++] = (tmp >> 16) & 0xFF
    arr[curByte++] = (tmp >> 8) & 0xFF
    arr[curByte++] = tmp & 0xFF
  }

  if (placeHoldersLen === 2) {
    tmp =
      (revLookup[b64.charCodeAt(i)] << 2) |
      (revLookup[b64.charCodeAt(i + 1)] >> 4)
    arr[curByte++] = tmp & 0xFF
  }

  if (placeHoldersLen === 1) {
    tmp =
      (revLookup[b64.charCodeAt(i)] << 10) |
      (revLookup[b64.charCodeAt(i + 1)] << 4) |
      (revLookup[b64.charCodeAt(i + 2)] >> 2)
    arr[curByte++] = (tmp >> 8) & 0xFF
    arr[curByte++] = tmp & 0xFF
  }

  return arr
}

function tripletToBase64 (num) {
  return lookup[num >> 18 & 0x3F] +
    lookup[num >> 12 & 0x3F] +
    lookup[num >> 6 & 0x3F] +
    lookup[num & 0x3F]
}

function encodeChunk (uint8, start, end) {
  var tmp
  var output = []
  for (var i = start; i < end; i += 3) {
    tmp =
      ((uint8[i] << 16) & 0xFF0000) +
      ((uint8[i + 1] << 8) & 0xFF00) +
      (uint8[i + 2] & 0xFF)
    output.push(tripletToBase64(tmp))
  }
  return output.join('')
}

function fromByteArray (uint8) {
  var tmp
  var len = uint8.length
  var extraBytes = len % 3 // if we have 1 byte left, pad 2 bytes
  var parts = []
  var maxChunkLength = 16383 // must be multiple of 3

  // go through the array every three bytes, we'll deal with trailing stuff later
  for (var i = 0, len2 = len - extraBytes; i < len2; i += maxChunkLength) {
    parts.push(encodeChunk(
      uint8, i, (i + maxChunkLength) > len2 ? len2 : (i + maxChunkLength)
    ))
  }

  // pad the end with zeros, but make sure to not forget the extra bytes
  if (extraBytes === 1) {
    tmp = uint8[len - 1]
    parts.push(
      lookup[tmp >> 2] +
      lookup[(tmp << 4) & 0x3F] +
      '=='
    )
  } else if (extraBytes === 2) {
    tmp = (uint8[len - 2] << 8) + uint8[len - 1]
    parts.push(
      lookup[tmp >> 10] +
      lookup[(tmp >> 4) & 0x3F] +
      lookup[(tmp << 2) & 0x3F] +
      '='
    )
  }

  return parts.join('')
}


/***/ }),

/***/ "HVJS":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__("TqRt");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _mapGetter = _interopRequireDefault(__webpack_require__("KP9C"));

var _SmTileLayerViewModel = _interopRequireDefault(__webpack_require__("BFO0"));

var _propsBinder = __webpack_require__("hS5c");

var _TileLayer = _interopRequireDefault(__webpack_require__("T3Jp"));

var _default = {
  name: 'SmTileLayer',
  mixins: [_mapGetter.default, _TileLayer.default],
  props: {
    layersID: {
      type: String
    },
    redirect: {
      type: Boolean,
      default: false
    },
    cacheEnabled: {
      type: Boolean,
      default: true
    },
    clipRegionEnabled: {
      type: Boolean,
      default: false
    },
    prjCoordSys: {
      type: Object
    },
    overlapDisplayed: {
      type: Boolean,
      default: false
    },
    overlapDisplayedOptions: {
      type: String
    },
    tileversion: {
      type: String
    },
    serverType: {
      type: String,
      default: 'iServer'
    },
    tileProxy: {
      type: String
    },
    format: {
      type: String,
      default: 'png',
      validator: function validator(val) {
        return ['png', 'jpg', 'bmp', 'gif'].indexOf(val) !== -1;
      }
    },
    tileSize: {
      type: Number,
      default: 256
    },
    url: {
      type: String
    },
    transparent: {
      type: Boolean,
      default: true
    },
    clipRegion: {
      type: Object
    },
    crs: {
      type: Object
    }
  },
  created: function created() {
    var _this = this;

    var _loop = function _loop(key) {
      var setMethodName = 'set' + (0, _propsBinder.capitalizeFirstLetter)(key);

      if (!_this[setMethodName]) {
        _this[setMethodName] = function (newValue) {
          this.viewModel && this.viewModel[setMethodName](newValue);
        };
      }
    };

    for (var key in this.$props) {
      _loop(key);
    }

    this.viewModel = new _SmTileLayerViewModel.default(this.$props);
    this.layer = this.viewModel.getLayer();
  },
  loaded: function loaded() {
    this.viewModel.addTo(this.map);
  },
  render: function render() {}
};
exports.default = _default;

/***/ }),

/***/ "IHp/":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";

// CONCATENATED MODULE: ./node_modules/vue-loader/lib/loaders/templateLoader.js??vue-loader-options!./node_modules/vue-loader/lib??vue-loader-options!./src/common/progress/Progress.vue?vue&type=template&id=01b494c1&
var render = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{staticClass:"sm-component-progress",style:([_vm.background && _vm.getBackgroundStyle])},[_c('a-progress',{attrs:{"percent":parseFloat(_vm.finalPercent),"type":_vm.type,"stroke-width":parseFloat(_vm.strokeWidth),"show-info":_vm.showInfo,"width":_vm.calWidth,"stroke-color":_vm.colorData,"status":_vm.status,"gap-degree":_vm.type === 'circle' ? _vm.gapDegree : null,"gap-position":_vm.gapPosition,"stroke-linecap":_vm.strokeLinecap}})],1)}
var staticRenderFns = []


// CONCATENATED MODULE: ./src/common/progress/Progress.vue?vue&type=template&id=01b494c1&
/* concated harmony reexport render */__webpack_require__.d(__webpack_exports__, "a", function() { return render; });
/* concated harmony reexport staticRenderFns */__webpack_require__.d(__webpack_exports__, "b", function() { return staticRenderFns; });


/***/ }),

/***/ "II3L":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__("TqRt");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _theme = _interopRequireDefault(__webpack_require__("bCOg"));

var _timer = _interopRequireDefault(__webpack_require__("N63c"));

var _RestService = _interopRequireDefault(__webpack_require__("w4Wy"));

//
//
//
//
//
//
//
//
//
var _default = {
  name: 'SmText',
  mixins: [_theme.default, _timer.default],
  props: {
    fontStyle: {
      type: Object
    },
    title: {
      type: String
    },
    url: {
      type: String
    },
    href: {
      type: String,
      default: ''
    },
    target: {
      type: String,
      default: '_self'
    },
    field: {
      type: String
    },
    proxy: {
      type: String
    }
  },
  data: function data() {
    return {
      finalTitle: this.title
    };
  },
  computed: {
    customStyle: function customStyle() {
      var style = Object.assign({}, this.fontStyle);

      if (style.textAlign && !style.justifyContent) {
        var textAlign = style.textAlign;
        style.justifyContent = textAlign === 'left' ? 'flex-start' : textAlign === 'right' ? 'flex-end' : 'center';
        delete style.textAlign;
      }

      return style;
    }
  },
  watch: {
    title: function title(val) {
      this.finalTitle = val;
    },
    url: {
      handler: function handler(val) {
        if (val) {
          this.getData();
        } else {
          this.finalTitle = this.title;
          this.features = null;
        }
      },
      immediate: true
    },
    field: function field() {
      this.setTitle(this.features);
    },
    proxy: function proxy() {
      this.restService && this.restService.setProxy(this.proxy);

      if (this.url) {
        this.getData();
      }
    }
  },
  beforeDestroy: function beforeDestroy() {
    this.restService && this.restService.remove('getdatasucceeded');
  },
  methods: {
    timing: function timing() {
      this.getData();
    },
    fetchData: function fetchData(_ref) {
      var features = _ref.features;
      this.features = features;
      this.setTitle(features);
    },
    getData: function getData() {
      if (!this.restService) {
        this.restService = new _RestService.default({
          proxy: this.proxy
        });
        this.restService.on({
          getdatasucceeded: this.fetchData
        });
      }

      this.restService.getData(this.url);
    },
    setTitle: function setTitle(features) {
      if (features && !!features.length) {
        var field = this.field;
        this.finalTitle = features[0].properties[field];
      }
    }
  }
};
exports.default = _default;

/***/ }),

/***/ "Ijbi":
/***/ (function(module, exports) {

function _arrayWithoutHoles(arr) {
  if (Array.isArray(arr)) {
    for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
      arr2[i] = arr[i];
    }

    return arr2;
  }
}

module.exports = _arrayWithoutHoles;

/***/ }),

/***/ "ImIo":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,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"

/***/ }),

/***/ "J4zp":
/***/ (function(module, exports, __webpack_require__) {

var arrayWithHoles = __webpack_require__("wTVA");

var iterableToArrayLimit = __webpack_require__("m0LI");

var nonIterableRest = __webpack_require__("wkBT");

function _slicedToArray(arr, i) {
  return arrayWithHoles(arr) || iterableToArrayLimit(arr, i) || nonIterableRest();
}

module.exports = _slicedToArray;

/***/ }),

/***/ "J78i":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.

// a transform stream is a readable/writable stream where you do
// something with the data.  Sometimes it's called a "filter",
// but that's not a great name for it, since that implies a thing where
// some bits pass through, and others are simply ignored.  (That would
// be a valid example of a transform, of course.)
//
// While the output is causally related to the input, it's not a
// necessarily symmetric or synchronous transformation.  For example,
// a zlib stream might take multiple plain-text writes(), and then
// emit a single compressed chunk some time in the future.
//
// Here's how this works:
//
// The Transform stream has all the aspects of the readable and writable
// stream classes.  When you write(chunk), that calls _write(chunk,cb)
// internally, and returns false if there's a lot of pending writes
// buffered up.  When you call read(), that calls _read(n) until
// there's enough pending readable data buffered up.
//
// In a transform stream, the written data is placed in a buffer.  When
// _read(n) is called, it transforms the queued up data, calling the
// buffered _write cb's as it consumes chunks.  If consuming a single
// written chunk would result in multiple output chunks, then the first
// outputted bit calls the readcb, and subsequent chunks just go into
// the read buffer, and will cause it to emit 'readable' if necessary.
//
// This way, back-pressure is actually determined by the reading side,
// since _read has to be called to start processing a new chunk.  However,
// a pathological inflate type of transform can cause excessive buffering
// here.  For example, imagine a stream where every byte of input is
// interpreted as an integer from 0-255, and then results in that many
// bytes of output.  Writing the 4 bytes {ff,ff,ff,ff} would result in
// 1kb of data being output.  In this case, you could write a very small
// amount of input, and end up with a very large amount of output.  In
// such a pathological inflating mechanism, there'd be no way to tell
// the system to stop doing the transform.  A single 4MB write could
// cause the system to run out of memory.
//
// However, even in such a pathological case, only a single written chunk
// would be consumed, and then the rest would wait (un-transformed) until
// the results of the previous transformed chunk were consumed.



module.exports = Transform;

var Duplex = __webpack_require__("sZro");

/*<replacement>*/
var util = __webpack_require__("Onz0");
util.inherits = __webpack_require__("P7XM");
/*</replacement>*/

util.inherits(Transform, Duplex);

function afterTransform(er, data) {
  var ts = this._transformState;
  ts.transforming = false;

  var cb = ts.writecb;

  if (!cb) {
    return this.emit('error', new Error('write callback called multiple times'));
  }

  ts.writechunk = null;
  ts.writecb = null;

  if (data != null) // single equals check for both `null` and `undefined`
    this.push(data);

  cb(er);

  var rs = this._readableState;
  rs.reading = false;
  if (rs.needReadable || rs.length < rs.highWaterMark) {
    this._read(rs.highWaterMark);
  }
}

function Transform(options) {
  if (!(this instanceof Transform)) return new Transform(options);

  Duplex.call(this, options);

  this._transformState = {
    afterTransform: afterTransform.bind(this),
    needTransform: false,
    transforming: false,
    writecb: null,
    writechunk: null,
    writeencoding: null
  };

  // start out asking for a readable event once data is transformed.
  this._readableState.needReadable = true;

  // we have implemented the _read method, and done the other things
  // that Readable wants before the first _read call, so unset the
  // sync guard flag.
  this._readableState.sync = false;

  if (options) {
    if (typeof options.transform === 'function') this._transform = options.transform;

    if (typeof options.flush === 'function') this._flush = options.flush;
  }

  // When the writable side finishes, then flush out anything remaining.
  this.on('prefinish', prefinish);
}

function prefinish() {
  var _this = this;

  if (typeof this._flush === 'function') {
    this._flush(function (er, data) {
      done(_this, er, data);
    });
  } else {
    done(this, null, null);
  }
}

Transform.prototype.push = function (chunk, encoding) {
  this._transformState.needTransform = false;
  return Duplex.prototype.push.call(this, chunk, encoding);
};

// This is the part where you do stuff!
// override this function in implementation classes.
// 'chunk' is an input chunk.
//
// Call `push(newChunk)` to pass along transformed output
// to the readable side.  You may call 'push' zero or more times.
//
// Call `cb(err)` when you are done with this chunk.  If you pass
// an error, then that'll put the hurt on the whole operation.  If you
// never call cb(), then you'll never get another chunk.
Transform.prototype._transform = function (chunk, encoding, cb) {
  throw new Error('_transform() is not implemented');
};

Transform.prototype._write = function (chunk, encoding, cb) {
  var ts = this._transformState;
  ts.writecb = cb;
  ts.writechunk = chunk;
  ts.writeencoding = encoding;
  if (!ts.transforming) {
    var rs = this._readableState;
    if (ts.needTransform || rs.needReadable || rs.length < rs.highWaterMark) this._read(rs.highWaterMark);
  }
};

// Doesn't matter what the args are here.
// _transform does all the work.
// That we got here means that the readable side wants more data.
Transform.prototype._read = function (n) {
  var ts = this._transformState;

  if (ts.writechunk !== null && ts.writecb && !ts.transforming) {
    ts.transforming = true;
    this._transform(ts.writechunk, ts.writeencoding, ts.afterTransform);
  } else {
    // mark that we need a transform, so that any data that comes in
    // will get processed, now that we've asked for it.
    ts.needTransform = true;
  }
};

Transform.prototype._destroy = function (err, cb) {
  var _this2 = this;

  Duplex.prototype._destroy.call(this, err, function (err2) {
    cb(err2);
    _this2.emit('close');
  });
};

function done(stream, er, data) {
  if (er) return stream.emit('error', er);

  if (data != null) // single equals check for both `null` and `undefined`
    stream.push(data);

  // if there's nothing in the write buffer, then that means
  // that nothing more will ever be provided
  if (stream._writableState.length) throw new Error('Calling transform done when ws.length != 0');

  if (stream._transformState.transforming) throw new Error('Calling transform done when still transforming');

  return stream.push(null);
}

/***/ }),

/***/ "JBR1":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAhYAAAD+CAYAAABmz0wVAAAABGdBTUEAALGPC/xhBQAAFxJJREFUeAHt3U9u68qVB2CS8n2byH6ykgA9DLrTQAcBMsqk0YN+AXqUSe8g+8ooC7i2yJxTpGzpXYkiLRJ4cn3EtfivWDI/CfAPp0q6bfP3fw7NnaX92893WjhNgAABAgQIfGWB4d/+/e7tZV54udsqGnw7/uN/mqGPABL/+i4fyr/y0LZ3g8mS59CGAAECBAgQ+JUIDEPbNF35N6779nvT/NeS3649VSy+/f9ffm6G45A/7TFCRJ/bQ9mPHBH7ESZyv4SKDBO5n08R60a4WIKtDQECBAgQ+PULTKEiosUYKk77bdt0JWy0TXuIn9w/tMOha19/95c/ZOvLikWGimOEiqxMHI8RJWK/z2ARP/1b5IfTdgaJ3M4usoqRq/LogQABAgQIEHh2gcgO49JFeIit4xQoMkgM+fMyNO0xQkVuR7yY6hqnqz6GQs5DxfEtKxRjteKYwWKqXmSQyMpFhoxME+1hDBaSxcnTmgABAgQIPLfAcUoWw+s0HJIBIo9l0IjtLioYUbBo+kPTRMZojpch4D1YfFQqIlQMQ9/kcMhYvRhDRoaLMp8iAkWZbxHr4zGeKAOGoZDnfhf57QkQIECAwCTwMb8iUkOEiCHmVuaf+yGrFJkocmhkGgrJoHF4e69xZA/vwWKsSkR4eItAUUJFbB9f+/F4BIches3jbVYwpspF+R1yv2x4IECAAAECBJ5doMSECAwZJnJOxRCVihwCKduRB44RMIY+AkXM7oyZEiV4nN3zR7AocykiJJwmbGaoeMsqRQaH1+l4CR1RpIjjuWTAGNdl5YEAAQIECBB4coEMEBEXIki0ZSplF9WDLqoWWcnoY9ZFnn8rqWOIcJEFjDELTLd9FiwiJJRwkZWK+ClDHxEq3nJoJPezSnFa5/DHqVKhXDFZWhEgQIAAgecXKNMcslIRf/PHSsUYMrpIERkyMk10ER/6yAcxKPLL6RBt+9s/D+V7KvKTIMeoTLy+xTo/FRKzNPvvU8iYQkWGjHEoJKdWREKJJyi54jKtPL+qOyBAgAABArUKRGWiFC3ioZsqFBkwXl7GORZZyTh8y4mcXdPF+nDomm8vXR57/ek3fxwrFpFJ3j/tcapa5JyKsn0WKnK/fMdFpolSsRjDRa327psAAQIECHw9gcgEGSpiLkWWJPJPfhn+iAkVp3GOLodC4pOhfawPMUySnxZtY95FLFOTKURkcMgBlfyUx+lTITn8UYZDMkhkyMh1HMslP3oaCWNa57aFAAECBAgQeGaBMsciQ0IGhvjJj5dmusjj+b1WuWTwiO/GynGQ8knRzA8lQ5yCRfma7tcxKJSwEB3kkEeMiJQwMW5PoSKGQ8Y2sc4sk2FjfB6PBAgQIECAwLML5FyHCA5jqWIMGKUOEX/sS7go2SCHQiJFxBdZ9BFC2jiWEzljmSoW2SiTR1YjMnVkWMifMlkzDpdOok2eL9s5NXTczl5Onw7JbQsBAgQIECDwxAL5lZrxNz7CRflerPwkSO6Xw3FbGSgyD3QlE2TAiE+H5Hb8xDIGi8gK0SoHNaZlChK5V6oVeSYvyIb9lVBROpiutSJAgAABAgSeVqAULPKjptPf9sgX8bc/9vNrNmMpqxwqKd++ncdiOCRPjO0/KhbjwXiME6ecUKoW2TiWfKJSrcjtqUGpVJy1Lw09ECBAgAABAk8rkB8pncJFjHBkVSFLFHE7WbWIb9zMzbaMWkxDIHE6z03LGCxOX9WdB8v//xHzLT4qFNG+dJhnx2pFbl2Eio8O85SFAAECBAgQeFKBPqoV7+GiDHxEuChzLiJURIjIzdOEitwc/9+wqWpxGgrJEzHmUVJIPmTQeM8S07lcfVQsziobfRmCydMWAgQIECBA4LkF4kusIgNM4SJTROaBfCifFsn5mKcKxvsUiTh0muw55Y68xEKAAAECBAgQeFSgFDQe7cT1BAgQIECAQK0Cl1Hicq9WE/dNgAABAgQIbCIgWGzCqBMCBAgQIEAgBQQL7wMCBAgQIEBgMwHBYjNKHREgQIAAAQKChfcAAQIECBAgMC+wIi2saDr/nM4SIECAAAECBAQL7wECBAgQIEBgMwHBYjNKHREgQIAAAQKChfcAAQIECBAgsJmAYLEZpY4IECBAgAABwcJ7gAABAgQIENhMQLDYjFJHBAgQIECAgGDhPUCAAAECBAhsJiBYbEapIwIECBAgQECw8B4gQIAAAQIENhMQLDaj1BEBAgQIEPiCAjeTQtte/l+mY8Obzb8gjVsiQIAAAQIEdhYQLHYG1j0BAgQIEPh6Arfjw+0zX0/BHREgQIAAAQI7CwgWOwPrngABAgQI1CQgWNT0artXAgQIECCwWOBzEeFzVy3+pTQkQIAAAQIEahIQLGp6td0rAQIECBDYWUCw2BlY9wQIECBAoCYBwaKmV9u9EiBAgACBnQUEi52BdU+AAAECBGoSECxqerXdKwECBAgQ2FlAsNgZWPcECBAgQKAmAcGiplfbvRIgQIAAgYcEhviPx+YXwWLex1kCBAgQIEBghYBgsQJLUwIECBAgQGBeQLCY93GWAAECBAgQWCEgWKzA0pQAAQIECBCYFxAs5n2cJUCAAAECBFYICBYrsDQlQIAAAQIE5gUEi3kfZwkQIECAAIElAtMHUQWLJVjaECBAgAABAosEBItFTBoRIECAAAECSwQEiyVK2hAgQIAAAQKLBASLRUwaESBAgAABAksEBIslStoQIECAAAEC1wWG48X/HyJYXGdylAABAgQIEPiEgGDxCTSXECBAgAABAtcFBIvrLo4SIECAAAECnxAQLD6B5hICBAgQIEDguoBgcd3FUQIECBAgQOATAoLFJ9BcQoAAAQIE6hJYHheWt6xL0N0SIECAAAECnxAQLD6B5hICBAgQIEDguoBgcd3FUQIECBAgUJ1Av8EdCxYbIOqCAAECBAjUIzAfHebP1qPkTgkQIECAAIENBASLDRB1QYAAAQIE6hbo3v+/EMGi7neCuydAgAABApsKCBabcuqMAAECBAjULSBY1P36u3sCBAgQILCpgGCxKafOCBAgQIBA3QKCRd2vv7snQIAAAQKbCggWm3LqjAABAgQI1C0gWNT9+rt7AgQIECCwqYBgsSmnzggQIECAwBcWWJAaFjT5wkBujQABAgQIENhUQLDYlFNnBAgQIECgbgHBou7X390TIECAAIFNBQSLTTl1RoAAAQIE6hYQLOp+/d09AQIECBDYVECw2JRTZwQIECBAoG4BwaLu19/dEyBAgACBTQUEi005dUaAAAECBOoWECzqfv3dPQECBAgQ2FRAsNiUU2cECBAgQKBuAcGi7tff3RMgQIAAgU0FBItNOXVGgAABAgTqFhAs6n793T0BAgQIENhUQLDYlFNnBAgQIECgVoExUggWtb7+7psAAQIECOwgIFjsgKpLAgQIECBQq4BgUesr774JECBAgMAOAoLFDqi6JECAAAECtQoIFrW+8u6bAAECBAjsICBY7ICqSwIECBAgUIXAlRRx5VAVFG6SAAECBAgQ2EFAsNgBVZcECBAgQKAegcsocblXj4I7JUCAAAECBHYQECx2QNUlAQIECBCoVUCwqPWVd98ECBAgQGAHAcFiB1RdEiBAgACBWgUEi1pfefdNgAABAgR2EBAsdkDVJQECBAgQqFVAsKj1lXffBAgQIEBgBwHBYgdUXRIgQIAAgVoFBItaX3n3TYAAAQIEVgvcjw33W6x+UhcQIECAAAECVQm0H3crWHxY2CJAgAABAgQeFBAsHgR0OQECBAgQqE+gO6tRXN69YHHpYY8AAQIECBB4QECweADPpQQIECBAgMClgGBx6WGPAAECBAgQeEBAsHgAz6UECBAgQIDApYBgcelhjwABAgQIEHhAQLB4AM+lBAgQIECAwKWAYHHpYY8AAQIECBB4QECweADPpQQIECBAoG6BH2PEj0fqFnL3BAgQIECAwAMCgsUDeC4lQIAAAQIELgUEi0sPewQIECBAgMADAoLFA3guJUCAAAECX1LggXTwwKVfktJNESBAgAABAlcFpshwJzncOX21ZwcJECBAgAABAlcFBIurLA4SIECAAAECswLd9Qhx/ehsT04SIECAAAECBK4LCBbXXRwlQIAAAQIEPiEgWHwCzSUECBAgQIDAdQHB4rqLowQIECBAgMAnBASLT6C5hAABAgQIELguIFhcd3GUAAECBAgQCIGhado1EILFGi1tCRAgQIAAgVkBwWKWx0kCBAgQIEBgjYBgsUZLWwIECBAgQGBWQLCY5XGSAAECBAgQWCMgWKzR0pYAAQIECBBompn0MHOKHAECBAgQIEBgnYBgsc5LawIECBAgQGBGQLCYwXGKAAECBAgQWCcgWKzz0poAAQIECBCYERAsZnCcIkCAAAECBNYJCBbrvLQmQIAAAQIEZgQEixkcpwgQIECAAIF1AoLFOi+tCRAgQIAAgRkBwWIGxykCBAgQIEBgnYBgsc5LawIECBAgUKPA4v86XbCo8e3hngkQIECAwE4CgsVOsLolQIAAAQL1CLRt0w2lqiFY1POqu1MCBAgQILC7gGCxO7EnIECAAAEC9QgIFvW81u6UAAECBAjsLiBY7E7sCQgQIECAQD0CgkU9r7U7JUCAAAECuwsIFrsTewICBAgQIFCPgGBRz2vtTgkQIECAwO4CgsXuxJ6AAAECBAjUIyBY1PNau1MCBAgQILC7gGCxO7EnIECAAAEC9QgIFvW81u6UAAECBAjsLiBY7E7sCQgQIECAwBcW+EWS+MXuF75xt0aAAAECBAh8XqBrFv3X6YLF54ldSYAAAQIEahf4IWwIFrW/Jdw/AQIECBDYUECw2BBTVwQIECBAoHYBwaL2d4D7J0CAAAECGwoIFhti6ooAAQIECNQuIFjU/g5w/wQIECBAYBOBMVIIFptg6oQAAQIECBBIAcHC+4AAAQIECBDYTECw2IxSRwQIECBAgIBg4T1AgAABAgQIbCYgWGxGqSMCBAgQIEBAsPAeIECAAAECBDYTECw2o9QRAQIECBAgIFh4DxAgQIAAAQKbCQgWm1HqiAABAgQIEBAsvAcIECBAgACBzQQEi80odUSAAAECBAgIFt4DBAgQIECAwHKBoW3nGgsWczrOESBAgACB6gXWRYV1ravHBUCAAAECBAjMCQgWczrOESBAgAABAncELodGBIs7XE4TIECAAAECywUEi+VWWhIgQIAAAQJ3BASLO0BOEyBAgACBugS62U993LMQLO4JOU+AAAECBAgsFhAsFlNpSIAAAQIECNwTECzuCTlPgAABAgQILBYQLBZTaUiAAAECBAjcExAs7gk5T4AAAQIECCwWECwWU2lIgAABAgQI3BMQLO4JOU+AAAECBAgsFhAsFlNpSIAAAQIECNwTECzuCTlPgAABAgQILBYQLBZTaUiAAAECBAicCVz9hk7B4kzIJgECBAgQIPCYgGDxmJ+rCRAgQIAAgTMBweIMwyYBAgQIECDwmIBg8ZifqwkQIECAAIEzAcHiDMMmAQIECBAg8JiAYPGYn6sJECBAgACBMwHB4gzDJgECBAgQIPCYgGDxmJ+rCRAgQIAAgTMBweIMwyYBAgQIECDwmIBg8ZifqwkQIECAAIEzAcHiDMMmAQIECBAgsEKg+zFG/HhkRX+aEiBAgAABAgTOBQSLcw3bBAgQIECAwHqBs8qFYLGezxUECBAgQIDADQHB4gaMwwQIECBAgMB6AcFivZkrCBAgQIAAgRsCgsUNGIcJECBAgACBWwK348PtM7f6cpwAAQIECBAgcENAsLgB4zABAgQIECCwXkCwWG/mCgIECBAgQOCGgGBxA8ZhAgQIECBAYL2AYLHezBUECBAgQIDADQHB4gaMwwQIECBAgMCcwPUIcf3oXD/OESBAgAABAgRuCAgWN2AcJkCAAAECBNYLCBbrzVxBgAABAgQI3BAQLG7AOEyAAAECBAisFxAs1pu5ggABAgQIELghIFjcgHGYAAECBAgQWC8gWKw3cwUBAgQIECBwQ0CwuAHjMAECBAgQILBeQLBYb+YKAgQIECBA4IaAYHEDxmECBAgQIEBgvYBgsd7MFQQIECBAgMANAcHiBozDBAgQIECAwCTQLY8Ly1vSJUCAAAECBAjcERAs7gA5TYAAAQIECCwXePloOrRNxoxjPAzTdtnPFrEfD00phfSx2bVNn/ux3Xdt3/RDtrIQIECAAAECzywQf99LySEeutzO9el+yvZ4Po+dH88m03DJGCwySDTdGA6G47TdTus4nBeX7NC3kSaaSBUZMi7CRfZpIUCAAAECBJ5YoISFeMi/8bFEAsgsMN5Ql1nhENu5HxlhKDlhOl0KEKXdVLGIRqWL7CgCRneMykVeG/vDcYjqRF44npt2mj4OnoeL0p0HAgQIECBA4HkFPkJF/I3Pv/Pj3/oSNHI772wMHeUex2JEZIg4UYJG04zBIhvmEEgJF+WisbM+0kU2zPN9nsyqRhdVi9JHBI6zcJGXWQgQIECAAIHnFZgqFRkoosqQBYUpGZQsMFYpStEigkEZ+sjsUNrF/njbHxWLLHEc88L4GaJR/nRxdRfDHsM0HFLmWpQhkxIuspcyLPL+xM9r6TcnQIAAAQLVC0Q4KIGihITMAbHRvWQ2iHVsZ2WiHCvn2hgRiROZHcqUisI3VSyiHHHMIZC4YIifHAYplYpyrG3eSmUiDuaYSF7yVioXuR8XTcdjZSFAgAABAgSeVyBzQCSFkgdyawwVuT9VKzJQHMbt8vc/2pdrcl2GNqahkJyM0caBkjzy4pjAWUJGJJCsWpQs8TZdnOEiOh3LGBEw4rrxF8lfwUKAAAECBAg8tUCGhJwcUUYx8m//mA9KyIi//2U/s0JkhMPpXAaSuKQ8/v2fOWWi+en//vO/m+Pr0LxGeeJ4jFJETKDovw+xnXMp4ifWb1GpaGNcJOdWZLEiKxiZM+JgPloIECBAgACBZxbIgkL+/lO4KEWGDBgxHPJSQkXUFg5d0/0UYSMaHb7lT/v9P/76p7yq/dvPp4pF9hEXDi9Dc4hOM4X0WbWIUkUGh/Iksc7KRYaKaNpE0/gOizg3Jos4YyFAgAABAgSeWiCrDiVUjFMick5FViVy+KNUKnIdIaPNAPJtOp6h4GPJqDAuOauzNIyhjwwXOcTxFpMtXk7hIjrPINHH8axeZM2jzS+3iPYZNiwECBAgQIDAcwucpjZkiMhlDBSxPg15RKjIOZiHCBjlZ9o+u+uzYBEns2oRuaFp84JSp4jhkAgX3U8RHt4iSMSQx0tM6BwDxviEOddCrjgjtUmAAAECBJ5UIOoH47BErDJkZKDIIJHFhxzFyAJECRQxBJJZoRyP82fLR7AoszyjCpFDHDmJM+ZqjuEig0RUJtpDhIpsHskjKxWHSBMlUMTDizkWZ6Y2CRAgQIDAcwqM38QdgSJ//SlY5DqPlxARASODRYaKnHOReSG3z5b3YDHEBW1WKY4RF9q3mIwRgWLIL7CI0NDG0EcX+/lV3hkmsnKRsz9fImyUJcscFgIECBAgQOC5BUqiiCBR/nuPsdBQhkdOQyERIg5TBSNDxWlI5Oym34NFnhxi1KOEi6xF5Nd6l8mZmSfi4j5CRgaN+C/HYg5GbGcvOcciV9MvUnY8ECBAgAABAk8p8P7nPCdo5h3E3/8MFhkicrpEGQ6Ztsu0icgO7WlixnjHbTN93HQOoHwUNSdolgpGrPP/IsvSxRgu8onHgDHXiXMECBAgQIDAr1wgP7yRQSJ/zVifvlEzgsX33//vH+/98pcfN51rXT6zmuEhnrD/lvMrYp0XxEMZFhl/hbkunCNAgAABAgSeQOCHeRblUx2Lf/G2/e2fVRsWc2lIgAABAgQIzAn8C5DdL0rYAs4xAAAAAElFTkSuQmCC"

/***/ }),

/***/ "Jibq":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Identify_vue_vue_type_template_id_a1e2c0ac___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("dKZ/");
/* harmony import */ var _Identify_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("GlvM");
/* harmony reexport (unknown) */ for(var __WEBPACK_IMPORT_KEY__ in _Identify_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_1__) if(__WEBPACK_IMPORT_KEY__ !== 'default') (function(key) { __webpack_require__.d(__webpack_exports__, key, function() { return _Identify_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_1__[key]; }) }(__WEBPACK_IMPORT_KEY__));
/* harmony import */ var _node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("KHd+");





/* normalize component */

var component = Object(_node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_2__[/* default */ "a"])(
  _Identify_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_1__["default"],
  _Identify_vue_vue_type_template_id_a1e2c0ac___WEBPACK_IMPORTED_MODULE_0__[/* render */ "a"],
  _Identify_vue_vue_type_template_id_a1e2c0ac___WEBPACK_IMPORTED_MODULE_0__[/* staticRenderFns */ "b"],
  false,
  null,
  null,
  null
  
)

/* harmony default export */ __webpack_exports__["default"] = (component.exports);

/***/ }),

/***/ "KCCg":
/***/ (function(module, exports) {

// shim for using process in browser
var process = module.exports = {};

// cached from whatever global is present so that test runners that stub it
// don't break things.  But we need to wrap it in a try catch in case it is
// wrapped in strict mode code which doesn't define any globals.  It's inside a
// function because try/catches deoptimize in certain engines.

var cachedSetTimeout;
var cachedClearTimeout;

function defaultSetTimout() {
    throw new Error('setTimeout has not been defined');
}
function defaultClearTimeout () {
    throw new Error('clearTimeout has not been defined');
}
(function () {
    try {
        if (typeof setTimeout === 'function') {
            cachedSetTimeout = setTimeout;
        } else {
            cachedSetTimeout = defaultSetTimout;
        }
    } catch (e) {
        cachedSetTimeout = defaultSetTimout;
    }
    try {
        if (typeof clearTimeout === 'function') {
            cachedClearTimeout = clearTimeout;
        } else {
            cachedClearTimeout = defaultClearTimeout;
        }
    } catch (e) {
        cachedClearTimeout = defaultClearTimeout;
    }
} ())
function runTimeout(fun) {
    if (cachedSetTimeout === setTimeout) {
        //normal enviroments in sane situations
        return setTimeout(fun, 0);
    }
    // if setTimeout wasn't available but was latter defined
    if ((cachedSetTimeout === defaultSetTimout || !cachedSetTimeout) && setTimeout) {
        cachedSetTimeout = setTimeout;
        return setTimeout(fun, 0);
    }
    try {
        // when when somebody has screwed with setTimeout but no I.E. maddness
        return cachedSetTimeout(fun, 0);
    } catch(e){
        try {
            // When we are in I.E. but the script has been evaled so I.E. doesn't trust the global object when called normally
            return cachedSetTimeout.call(null, fun, 0);
        } catch(e){
            // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error
            return cachedSetTimeout.call(this, fun, 0);
        }
    }


}
function runClearTimeout(marker) {
    if (cachedClearTimeout === clearTimeout) {
        //normal enviroments in sane situations
        return clearTimeout(marker);
    }
    // if clearTimeout wasn't available but was latter defined
    if ((cachedClearTimeout === defaultClearTimeout || !cachedClearTimeout) && clearTimeout) {
        cachedClearTimeout = clearTimeout;
        return clearTimeout(marker);
    }
    try {
        // when when somebody has screwed with setTimeout but no I.E. maddness
        return cachedClearTimeout(marker);
    } catch (e){
        try {
            // When we are in I.E. but the script has been evaled so I.E. doesn't  trust the global object when called normally
            return cachedClearTimeout.call(null, marker);
        } catch (e){
            // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error.
            // Some versions of I.E. have different rules for clearTimeout vs setTimeout
            return cachedClearTimeout.call(this, marker);
        }
    }



}
var queue = [];
var draining = false;
var currentQueue;
var queueIndex = -1;

function cleanUpNextTick() {
    if (!draining || !currentQueue) {
        return;
    }
    draining = false;
    if (currentQueue.length) {
        queue = currentQueue.concat(queue);
    } else {
        queueIndex = -1;
    }
    if (queue.length) {
        drainQueue();
    }
}

function drainQueue() {
    if (draining) {
        return;
    }
    var timeout = runTimeout(cleanUpNextTick);
    draining = true;

    var len = queue.length;
    while(len) {
        currentQueue = queue;
        queue = [];
        while (++queueIndex < len) {
            if (currentQueue) {
                currentQueue[queueIndex].run();
            }
        }
        queueIndex = -1;
        len = queue.length;
    }
    currentQueue = null;
    draining = false;
    runClearTimeout(timeout);
}

process.nextTick = function (fun) {
    var args = new Array(arguments.length - 1);
    if (arguments.length > 1) {
        for (var i = 1; i < arguments.length; i++) {
            args[i - 1] = arguments[i];
        }
    }
    queue.push(new Item(fun, args));
    if (queue.length === 1 && !draining) {
        runTimeout(drainQueue);
    }
};

// v8 likes predictible objects
function Item(fun, array) {
    this.fun = fun;
    this.array = array;
}
Item.prototype.run = function () {
    this.fun.apply(null, this.array);
};
process.title = 'browser';
process.browser = true;
process.env = {};
process.argv = [];
process.version = ''; // empty string to avoid regexp issues
process.versions = {};

function noop() {}

process.on = noop;
process.addListener = noop;
process.once = noop;
process.off = noop;
process.removeListener = noop;
process.removeAllListeners = noop;
process.emit = noop;
process.prependListener = noop;
process.prependOnceListener = noop;

process.listeners = function (name) { return [] }

process.binding = function (name) {
    throw new Error('process.binding is not supported');
};

process.cwd = function () { return '/' };
process.chdir = function (dir) {
    throw new Error('process.chdir is not supported');
};
process.umask = function() { return 0; };


/***/ }),

/***/ "KHd+":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return normalizeComponent; });
/* globals __VUE_SSR_CONTEXT__ */

// IMPORTANT: Do NOT use ES2015 features in this file (except for modules).
// This module is a runtime utility for cleaner component module output and will
// be included in the final webpack user bundle.

function normalizeComponent (
  scriptExports,
  render,
  staticRenderFns,
  functionalTemplate,
  injectStyles,
  scopeId,
  moduleIdentifier, /* server only */
  shadowMode /* vue-cli only */
) {
  // Vue.extend constructor export interop
  var options = typeof scriptExports === 'function'
    ? scriptExports.options
    : scriptExports

  // render functions
  if (render) {
    options.render = render
    options.staticRenderFns = staticRenderFns
    options._compiled = true
  }

  // functional template
  if (functionalTemplate) {
    options.functional = true
  }

  // scopedId
  if (scopeId) {
    options._scopeId = 'data-v-' + scopeId
  }

  var hook
  if (moduleIdentifier) { // server build
    hook = function (context) {
      // 2.3 injection
      context =
        context || // cached call
        (this.$vnode && this.$vnode.ssrContext) || // stateful
        (this.parent && this.parent.$vnode && this.parent.$vnode.ssrContext) // functional
      // 2.2 with runInNewContext: true
      if (!context && typeof __VUE_SSR_CONTEXT__ !== 'undefined') {
        context = __VUE_SSR_CONTEXT__
      }
      // inject component styles
      if (injectStyles) {
        injectStyles.call(this, context)
      }
      // register component module identifier for async chunk inferrence
      if (context && context._registeredComponents) {
        context._registeredComponents.add(moduleIdentifier)
      }
    }
    // used by ssr in case component is cached and beforeCreate
    // never gets called
    options._ssrRegister = hook
  } else if (injectStyles) {
    hook = shadowMode
      ? function () { injectStyles.call(this, this.$root.$options.shadowRoot) }
      : injectStyles
  }

  if (hook) {
    if (options.functional) {
      // for template-only hot-reload because in that case the render fn doesn't
      // go through the normalizer
      options._injectStyles = hook
      // register for functioal component in vue file
      var originalRender = options.render
      options.render = function renderWithStyleInjection (h, context) {
        hook.call(context)
        return originalRender(h, context)
      }
    } else {
      // inject component registration as beforeCreate hook
      var existing = options.beforeCreate
      options.beforeCreate = existing
        ? [].concat(existing, hook)
        : [hook]
    }
  }

  return {
    exports: scriptExports,
    options: options
  }
}


/***/ }),

/***/ "KP9C":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__("TqRt");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _classCallCheck2 = _interopRequireDefault(__webpack_require__("lwsE"));

var _createClass2 = _interopRequireDefault(__webpack_require__("W8MJ"));

var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__("a1gu"));

var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__("Nsbk"));

var _inherits2 = _interopRequireDefault(__webpack_require__("7W2i"));

var _typeof2 = _interopRequireDefault(__webpack_require__("cDf5"));

var _mapEvent = _interopRequireDefault(__webpack_require__("Whz7"));

var _globalEvent = _interopRequireDefault(__webpack_require__("qF08"));

var _vue = _interopRequireDefault(__webpack_require__("i7/w"));

var _vuePropertyDecorator = __webpack_require__("YKMj");

var __decorate = void 0 && (void 0).__decorate || function (decorators, target, key, desc) {
  var c = arguments.length,
      r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
      d;
  if ((typeof Reflect === "undefined" ? "undefined" : (0, _typeof2.default)(Reflect)) === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);else for (var i = decorators.length - 1; i >= 0; i--) {
    if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
  }
  return c > 3 && r && Object.defineProperty(target, key, r), r;
};

function callHook(vm, hook) {
  var options = vm.constructor.options;
  options.mixins && options.mixins.forEach(function (mixin) {
    mixin[hook] && mixin[hook].call(vm, vm.$options.name);
  });
  options[hook] && options[hook].call(vm, vm);
}

var MapGetter =
/*#__PURE__*/
function (_Vue) {
  (0, _inherits2.default)(MapGetter, _Vue);

  function MapGetter() {
    (0, _classCallCheck2.default)(this, MapGetter);
    return (0, _possibleConstructorReturn2.default)(this, (0, _getPrototypeOf2.default)(MapGetter).apply(this, arguments));
  }

  (0, _createClass2.default)(MapGetter, [{
    key: "mapTargetChanged",
    value: function mapTargetChanged(newVal, oldVal) {
      if (newVal && oldVal && newVal !== oldVal) {
        callHook(this, 'removed');

        if (_mapEvent.default.$options.getMap(newVal)) {
          this.loadMap(newVal);
        }
      }
    }
  }, {
    key: "mounted",
    value: function mounted() {
      var targetName = this.getTargetName();

      if (_mapEvent.default.$options.getMap(targetName)) {
        this.loadMap(targetName);
      }

      _mapEvent.default.$on('load-map', this.loadMapSucceed);

      _globalEvent.default.$on('delete-map', this.deleteMapSucceed);
    }
  }, {
    key: "beforeDestroy",
    value: function beforeDestroy() {
      _mapEvent.default.$off('load-map', this.loadMapSucceed);

      _globalEvent.default.$off('delete-map', this.deleteMapSucceed);
    }
  }, {
    key: "loadMapSucceed",
    value: function loadMapSucceed(map, target) {
      var targetName = this.getTargetName();

      if (target === targetName) {
        this.loadMap(target);
      }
    }
  }, {
    key: "getTargetName",
    value: function getTargetName() {
      var selfParent = this.$parent;
      var parentTarget = selfParent && selfParent.$options.name && selfParent.$options.name.toLowerCase() === 'smwebmap' && selfParent.target;
      return this.mapTarget || parentTarget || Object.keys(_mapEvent.default.$options.getAllMaps())[0];
    }
  }, {
    key: "loadMap",
    value: function loadMap(targetName) {
      var _this = this;

      this.map = _mapEvent.default.$options.getMap(targetName);
      this.webmap = _mapEvent.default.$options.getWebMap(targetName);
      callHook(this, 'loaded');
      this.$nextTick(function () {
        _this.$emit('loaded');
      });
    }
  }, {
    key: "deleteMapSucceed",
    value: function deleteMapSucceed(target) {
      var targetName = this.getTargetName();

      if (target === targetName) {
        callHook(this, 'removed');
        this.map = null;
        this.webmap = null;
        this.viewModel && (this.viewModel = null);
      }
    }
  }, {
    key: "mapNotLoadedTip",
    value: function mapNotLoadedTip() {
      if (!this.map) {
        this.$message.destroy();
        this.$message.warning(this.$t('warning.unassociatedMap'));
        return true;
      }

      return false;
    }
  }]);
  return MapGetter;
}(_vue.default);

__decorate([(0, _vuePropertyDecorator.Prop)()], MapGetter.prototype, "mapTarget", void 0);

__decorate([(0, _vuePropertyDecorator.Watch)('mapTarget')], MapGetter.prototype, "mapTargetChanged", null);

MapGetter = __decorate([_vuePropertyDecorator.Component], MapGetter);
var _default = MapGetter;
exports.default = _default;

/***/ }),

/***/ "KS6f":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _propsBinder = __webpack_require__("hS5c");

var _default = {
  props: {
    pane: {
      type: String,
      default: 'overlayPane'
    },
    name: {
      type: String,
      default: undefined
    },
    attribution: {
      type: String,
      default: null
    }
  },
  mounted: function mounted() {
    var _this = this;

    if (this.layer) {
      this.layer.on('add', function (e) {
        _this.$emit('load', e);
      });
    }

    (0, _propsBinder.propsBinder)(this, this.$props);
  }
};
exports.default = _default;

/***/ }),

/***/ "KUEp":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__("TqRt");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _classCallCheck2 = _interopRequireDefault(__webpack_require__("lwsE"));

var _lang = __webpack_require__("DSM6");

var RestParameter = function RestParameter(options) {
  (0, _classCallCheck2.default)(this, RestParameter);
  this.url = options.url;
  this.type = 'rest';
  this.attributeFilter = options.attributeFilter || null;
  this.maxFeatures = options.maxFeatures || 20;
  this.name = options.name || (0, _lang.geti18n)().t('commontypes.restData');
  this.proxy = options.proxy;
};

exports.default = RestParameter;

/***/ }),

/***/ "KfNM":
/***/ (function(module, exports) {

/** Used for built-in method references. */
var objectProto = Object.prototype;

/**
 * Used to resolve the
 * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
 * of values.
 */
var nativeObjectToString = objectProto.toString;

/**
 * Converts `value` to a string using `Object.prototype.toString`.
 *
 * @private
 * @param {*} value The value to convert.
 * @returns {string} Returns the converted string.
 */
function objectToString(value) {
  return nativeObjectToString.call(value);
}

module.exports = objectToString;


/***/ }),

/***/ "KtZj":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_RESULT__;

/**
 * Copyright Marc J. Schmidt. See the LICENSE file at the top-level
 * directory of this distribution and at
 * https://github.com/marcj/css-element-queries/blob/master/LICENSE.
 */
(function (root, factory) {
    if (true) {
        !(__WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
				__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
				(__WEBPACK_AMD_DEFINE_FACTORY__.call(exports, __webpack_require__, exports, module)) :
				__WEBPACK_AMD_DEFINE_FACTORY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
    } else {}
}(typeof window !== 'undefined' ? window : this, function () {

    // Make sure it does not throw in a SSR (Server Side Rendering) situation
    if (typeof window === "undefined") {
        return null;
    }
    // https://github.com/Semantic-Org/Semantic-UI/issues/3855
    // https://github.com/marcj/css-element-queries/issues/257
    var globalWindow = typeof window != 'undefined' && window.Math == Math
        ? window
        : typeof self != 'undefined' && self.Math == Math
            ? self
            : Function('return this')();
    // Only used for the dirty checking, so the event callback count is limited to max 1 call per fps per sensor.
    // In combination with the event based resize sensor this saves cpu time, because the sensor is too fast and
    // would generate too many unnecessary events.
    var requestAnimationFrame = globalWindow.requestAnimationFrame ||
        globalWindow.mozRequestAnimationFrame ||
        globalWindow.webkitRequestAnimationFrame ||
        function (fn) {
            return globalWindow.setTimeout(fn, 20);
        };

    /**
     * Iterate over each of the provided element(s).
     *
     * @param {HTMLElement|HTMLElement[]} elements
     * @param {Function}                  callback
     */
    function forEachElement(elements, callback){
        var elementsType = Object.prototype.toString.call(elements);
        var isCollectionTyped = ('[object Array]' === elementsType
            || ('[object NodeList]' === elementsType)
            || ('[object HTMLCollection]' === elementsType)
            || ('[object Object]' === elementsType)
            || ('undefined' !== typeof jQuery && elements instanceof jQuery) //jquery
            || ('undefined' !== typeof Elements && elements instanceof Elements) //mootools
        );
        var i = 0, j = elements.length;
        if (isCollectionTyped) {
            for (; i < j; i++) {
                callback(elements[i]);
            }
        } else {
            callback(elements);
        }
    }

    /**
    * Get element size
    * @param {HTMLElement} element
    * @returns {Object} {width, height}
    */
    function getElementSize(element) {
        if (!element.getBoundingClientRect) {
            return {
                width: element.offsetWidth,
                height: element.offsetHeight
            }
        }

        var rect = element.getBoundingClientRect();
        return {
            width: Math.round(rect.width),
            height: Math.round(rect.height)
        }
    }

    /**
     * Apply CSS styles to element.
     *
     * @param {HTMLElement} element
     * @param {Object} style
     */
    function setStyle(element, style) {
        Object.keys(style).forEach(function(key) {
            element.style[key] = style[key];
        });
    }

    /**
     * Class for dimension change detection.
     *
     * @param {Element|Element[]|Elements|jQuery} element
     * @param {Function} callback
     *
     * @constructor
     */
    var ResizeSensor = function(element, callback) {
        var lastAnimationFrame = 0;
        
        /**
         *
         * @constructor
         */
        function EventQueue() {
            var q = [];
            this.add = function(ev) {
                q.push(ev);
            };

            var i, j;
            this.call = function(sizeInfo) {
                for (i = 0, j = q.length; i < j; i++) {
                    q[i].call(this, sizeInfo);
                }
            };

            this.remove = function(ev) {
                var newQueue = [];
                for(i = 0, j = q.length; i < j; i++) {
                    if(q[i] !== ev) newQueue.push(q[i]);
                }
                q = newQueue;
            };

            this.length = function() {
                return q.length;
            }
        }

        /**
         *
         * @param {HTMLElement} element
         * @param {Function}    resized
         */
        function attachResizeEvent(element, resized) {
            if (!element) return;
            if (element.resizedAttached) {
                element.resizedAttached.add(resized);
                return;
            }

            element.resizedAttached = new EventQueue();
            element.resizedAttached.add(resized);

            element.resizeSensor = document.createElement('div');
            element.resizeSensor.dir = 'ltr';
            element.resizeSensor.className = 'resize-sensor';

            var style = {
                pointerEvents: 'none',
                position: 'absolute',
                left: '0px',
                top: '0px',
                right: '0px',
                bottom: '0px',
                overflow: 'hidden',
                zIndex: '-1',
                visibility: 'hidden',
                maxWidth: '100%'
            };
            var styleChild = {
                position: 'absolute',
                left: '0px',
                top: '0px',
                transition: '0s',
            };

            setStyle(element.resizeSensor, style);

            var expand = document.createElement('div');
            expand.className = 'resize-sensor-expand';
            setStyle(expand, style);

            var expandChild = document.createElement('div');
            setStyle(expandChild, styleChild);
            expand.appendChild(expandChild);

            var shrink = document.createElement('div');
            shrink.className = 'resize-sensor-shrink';
            setStyle(shrink, style);

            var shrinkChild = document.createElement('div');
            setStyle(shrinkChild, styleChild);
            setStyle(shrinkChild, { width: '200%', height: '200%' });
            shrink.appendChild(shrinkChild);

            element.resizeSensor.appendChild(expand);
            element.resizeSensor.appendChild(shrink);
            element.appendChild(element.resizeSensor);

            var computedStyle = window.getComputedStyle(element);
            var position = computedStyle ? computedStyle.getPropertyValue('position') : null;
            if ('absolute' !== position && 'relative' !== position && 'fixed' !== position && 'sticky' !== position) {
                element.style.position = 'relative';
            }

            var dirty, rafId;
            var size = getElementSize(element);
            var lastWidth = 0;
            var lastHeight = 0;
            var initialHiddenCheck = true;
            lastAnimationFrame = 0;

            var resetExpandShrink = function () {
                var width = element.offsetWidth;
                var height = element.offsetHeight;

                expandChild.style.width = (width + 10) + 'px';
                expandChild.style.height = (height + 10) + 'px';

                expand.scrollLeft = width + 10;
                expand.scrollTop = height + 10;

                shrink.scrollLeft = width + 10;
                shrink.scrollTop = height + 10;
            };

            var reset = function() {
                // Check if element is hidden
                if (initialHiddenCheck) {
                    var invisible = element.offsetWidth === 0 && element.offsetHeight === 0;
                    if (invisible) {
                        // Check in next frame
                        if (!lastAnimationFrame){
                            lastAnimationFrame = requestAnimationFrame(function(){
                                lastAnimationFrame = 0;

                                reset();
                            });
                        }

                        return;
                    } else {
                        // Stop checking
                        initialHiddenCheck = false;
                    }
                }

                resetExpandShrink();
            };
            element.resizeSensor.resetSensor = reset;

            var onResized = function() {
                rafId = 0;

                if (!dirty) return;

                lastWidth = size.width;
                lastHeight = size.height;

                if (element.resizedAttached) {
                    element.resizedAttached.call(size);
                }
            };

            var onScroll = function() {
                size = getElementSize(element);
                dirty = size.width !== lastWidth || size.height !== lastHeight;

                if (dirty && !rafId) {
                    rafId = requestAnimationFrame(onResized);
                }

                reset();
            };

            var addEvent = function(el, name, cb) {
                if (el.attachEvent) {
                    el.attachEvent('on' + name, cb);
                } else {
                    el.addEventListener(name, cb);
                }
            };

            addEvent(expand, 'scroll', onScroll);
            addEvent(shrink, 'scroll', onScroll);

            // Fix for custom Elements
            lastAnimationFrame = requestAnimationFrame(reset);
        }

        forEachElement(element, function(elem){
            attachResizeEvent(elem, callback);
        });

        this.detach = function(ev) {
            // clean up the unfinished animation frame to prevent a potential endless requestAnimationFrame of reset
            if (!lastAnimationFrame) {
                window.cancelAnimationFrame(lastAnimationFrame);
                lastAnimationFrame = 0;
            }
            ResizeSensor.detach(element, ev);
        };

        this.reset = function() {
            element.resizeSensor.resetSensor();
        };
    };

    ResizeSensor.reset = function(element) {
        forEachElement(element, function(elem){
            elem.resizeSensor.resetSensor();
        });
    };

    ResizeSensor.detach = function(element, ev) {
        forEachElement(element, function(elem){
            if (!elem) return;
            if(elem.resizedAttached && typeof ev === "function"){
                elem.resizedAttached.remove(ev);
                if(elem.resizedAttached.length()) return;
            }
            if (elem.resizeSensor) {
                if (elem.contains(elem.resizeSensor)) {
                    elem.removeChild(elem.resizeSensor);
                }
                delete elem.resizeSensor;
                delete elem.resizedAttached;
            }
        });
    };

    if (typeof MutationObserver !== "undefined") {
        var observer = new MutationObserver(function (mutations) {
            for (var i in mutations) {
                if (mutations.hasOwnProperty(i)) {
                    var items = mutations[i].addedNodes;
                    for (var j = 0; j < items.length; j++) {
                        if (items[j].resizeSensor) {
                            ResizeSensor.reset(items[j]);
                        }
                    }
                }
            }
        });

        document.addEventListener("DOMContentLoaded", function (event) {
            observer.observe(document.body, {
                childList: true,
                subtree: true,
            });
        });
    }

    return ResizeSensor;

}));


/***/ }),

/***/ "Kz5y":
/***/ (function(module, exports, __webpack_require__) {

var freeGlobal = __webpack_require__("WFqU");

/** Detect free variable `self`. */
var freeSelf = typeof self == 'object' && self && self.Object === Object && self;

/** Used as a reference to the global object. */
var root = freeGlobal || freeSelf || Function('return this')();

module.exports = root;


/***/ }),

/***/ "LGOv":
/***/ (function(module, exports, __webpack_require__) {

module.exports = __webpack_require__("3BRs");


/***/ }),

/***/ "LU8/":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__("TqRt");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _mapGetter = _interopRequireDefault(__webpack_require__("KP9C"));

var _theme = _interopRequireDefault(__webpack_require__("bCOg"));

var _IdentifyViewModel = _interopRequireDefault(__webpack_require__("PZvK"));

var _lodash = _interopRequireDefault(__webpack_require__("XaGS"));

//
//
//
//
//
//
//
//
//
//
//
//
//
var _default2 = {
  name: 'SmIdentify',
  mixins: [_mapGetter.default, _theme.default],
  props: {
    layerNames: {
      type: Array,
      default: function _default() {
        return [];
      }
    },
    fields: {
      type: Array,
      default: function _default() {
        return [];
      }
    },
    layerStyle: {
      type: Object,
      default: function _default() {
        return {};
      }
    }
  },
  data: function data() {
    return {
      popupProps: {},
      layers: [],
      layerType: false,
      popupLayers: [],
      mapClickPosition: null
    };
  },
  watch: {
    layerNames: function layerNames(val, oldVal) {
      if (val && !(0, _lodash.default)(val, oldVal)) {
        this.$options.removed.call(this, oldVal);
        this.setLayers();
      }
    },
    backgroundData: function backgroundData() {
      this.changeStyle();
    }
  },
  loaded: function loaded() {
    var _this = this;

    this.setViewModel();
    this.setLayers();

    if (this.layers && this.layers.length > 0) {
      this.layers.forEach(function (layer) {
        var layerType = _this.viewModel.getLayerType(layer);

        _this.bindLayerClick(layer, layerType);
      });
    } // 客户端专题图图层无准确坐标，通过地图坐标来实现


    this.map.on('click', function (e) {
      _this.mapClickPosition = _this.map.layerPointToLatLng(e.layerPoint);
    });
  },
  removed: function removed() {
    var layers = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this.layers;
    // 清除点击事件和popup
    this.popupLayers && this.popupLayers.forEach(function (layer) {
      layer.closePopup();
      layer.off('click');
      layer.off('popupclose');
    });
    layers && layers.forEach(function (layer) {
      layer.off('click');
    }); // 清除高亮的图层

    this.viewModel && this.viewModel.removed(); // 重置

    this.popupLayers = [];
    this.layers = [];
  },
  beforeDestroy: function beforeDestroy() {
    this.map && this.map.off('click');
    this.$options.removed.call(this);
  },
  methods: {
    setViewModel: function setViewModel() {
      this.viewModel = new _IdentifyViewModel.default(this.map, {
        mapTarget: this.getTargetName(),
        layerNames: this.layerNames,
        layerStyle: this.layerStyle
      });
    },
    // 通过layerName设置layers
    setLayers: function setLayers() {
      var _this2 = this;

      // 重置layers
      this.layers = [];
      this.layerNames.forEach(function (layerName) {
        var layer = _this2.getLayerByName(layerName);

        layer && _this2.layers.push(layer);
      });
    },
    // 通过layerName获取layer
    getLayerByName: function getLayerByName(layerName) {
      var layer = this.viewModel.getLayerByName(layerName);

      if (!layer) {
        this.$message.error(this.$t('identify.layerNotExit', {
          layer: layerName
        }));
      }

      return layer;
    },
    // 给选中图层绑定click
    bindLayerClick: function bindLayerClick(layer, layerType) {
      if (layerType) {
        // 如果是geojson
        this.bindGeojsonLayer(layer);
      } else if (layer.TFEvents) {
        // 如果是客户端专题图
        this.bindThemeLayer(layer);
      } else {
        // 如果是其他的图层(marker,polygon,polyline,隐藏的客户端专题图)
        this.bindOtherLayer(layer);
      }
    },
    // geojsonlayer绑定click事件
    bindGeojsonLayer: function bindGeojsonLayer(geojsonLayer) {
      var _this3 = this;

      geojsonLayer.on('click', function (e) {
        // e.layer是被选中的某个要素
        _this3.bindPopupLayer(e.layer.feature, e.layer, e.latlng);
      });
    },
    // 给客户端专题图绑定click事件
    bindThemeLayer: function bindThemeLayer(themeLayer) {
      var _this4 = this;

      themeLayer.on('click', function (e) {
        if (e.target && e.target.refDataID) {
          var themeFeature = themeLayer.getFeatureById(e.target.refDataID); // 将矢量要素转换成geojson

          var feature = _this4.viewModel.formatGeoJSON(themeFeature); // 因为线坐标等要素不准确，所以用地图的点击的坐标点


          _this4.bindPopupLayer(feature, themeLayer, '');
        }
      });
    },
    // 其他layer(layergroup等)绑定click事件
    bindOtherLayer: function bindOtherLayer(otherLayer) {
      var _this5 = this;

      if (otherLayer._layers) {
        for (var key in otherLayer._layers) {
          var layer = otherLayer._layers[key];

          if (layer.TFEvents) {
            // 说明是客户端专题图
            this.bindThemeLayer(otherLayer._layers[key]);
          } else if (this.viewModel.getLayerType(layer)) {
            this.bindGeojsonLayer(layer);
          } else {
            (function () {
              // 普通图层
              var popupLayer = void 0;
              var feature = void 0;
              layer.on('click', function (e) {
                // geojson点线面图层marker,image-marker、 RANK_SYMBOL:等级符号专题图(返回的是layergroup);
                var coordinates = e.sourceTarget && e.sourceTarget._point && _this5.map.layerPointToLatLng(e.sourceTarget._point) || e.target && e.target._latlng || e.latlng;
                feature = {
                  type: 'Feature',
                  properties: coordinates,
                  geometry: {
                    type: 'Point',
                    coordinates: [coordinates.lng, coordinates.lat]
                  }
                };
                e.sourceTarget.feature = feature;
                popupLayer = e.sourceTarget;

                _this5.bindPopupLayer(feature, popupLayer, e.latlng);
              });
            })();
          }
        }
      }
    },
    // 绑定popup
    bindPopupLayer: function bindPopupLayer(feature, popupLayer, latlng) {
      var _this6 = this;

      if (!feature) {
        return;
      }

      this.filterFeature(feature);
      this.$nextTick(function () {
        // 这个定时器是避免和专题图的点击事件（要清空popup）冲突
        setTimeout(function () {
          var popupDom = _this6.$refs.Popup;
          popupDom.style.display = 'block';
          popupLayer.bindPopup(popupDom); // 定时为了获取最近的一次地图点击事件的坐标mapClickPosition

          popupLayer.openPopup(latlng || _this6.mapClickPosition); // popupclose(点击地图的时候，清除最后一次的高亮)

          popupLayer.on('popupclose', function () {
            return _this6.viewModel.removed();
          });

          if (!popupLayer.feature) {
            popupLayer.feature = feature;
          }

          _this6.viewModel.addOverlayToMap(popupLayer, feature, _this6.layerStyle);

          _this6.popupLayers.push(popupLayer);
        }, 0);
      });
    },
    // 过滤用户传入的字段
    filterFeature: function filterFeature(feature) {
      var _this7 = this;

      // 重置popupProps
      this.popupProps = {};

      if (feature.properties) {
        // 过滤字段
        if (this.fields.length > 0) {
          this.fields.forEach(function (field) {
            if (feature.properties.hasOwnProperty(field)) {
              _this7.popupProps[field] = feature.properties[field];
            }
          });
        } else {
          // 默认是读取layer的全部字段
          this.popupProps = feature.properties;
        }
      }
    },
    // 根据主题改变样式
    changeStyle: function changeStyle() {
      var wrapper = document.querySelector('.leaflet-popup-content-wrapper');
      var tip = document.querySelector('.leaflet-popup-tip');
      wrapper && (wrapper.style.background = this.backgroundData);
      tip && (tip.style.background = this.backgroundData);
    }
  }
};
exports.default = _default2;

/***/ }),

/***/ "MXF5":
/***/ (function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(Buffer) {;(function (sax) { // wrapper for non-node envs
  sax.parser = function (strict, opt) { return new SAXParser(strict, opt) }
  sax.SAXParser = SAXParser
  sax.SAXStream = SAXStream
  sax.createStream = createStream

  // When we pass the MAX_BUFFER_LENGTH position, start checking for buffer overruns.
  // When we check, schedule the next check for MAX_BUFFER_LENGTH - (max(buffer lengths)),
  // since that's the earliest that a buffer overrun could occur.  This way, checks are
  // as rare as required, but as often as necessary to ensure never crossing this bound.
  // Furthermore, buffers are only tested at most once per write(), so passing a very
  // large string into write() might have undesirable effects, but this is manageable by
  // the caller, so it is assumed to be safe.  Thus, a call to write() may, in the extreme
  // edge case, result in creating at most one complete copy of the string passed in.
  // Set to Infinity to have unlimited buffers.
  sax.MAX_BUFFER_LENGTH = 64 * 1024

  var buffers = [
    'comment', 'sgmlDecl', 'textNode', 'tagName', 'doctype',
    'procInstName', 'procInstBody', 'entity', 'attribName',
    'attribValue', 'cdata', 'script'
  ]

  sax.EVENTS = [
    'text',
    'processinginstruction',
    'sgmldeclaration',
    'doctype',
    'comment',
    'opentagstart',
    'attribute',
    'opentag',
    'closetag',
    'opencdata',
    'cdata',
    'closecdata',
    'error',
    'end',
    'ready',
    'script',
    'opennamespace',
    'closenamespace'
  ]

  function SAXParser (strict, opt) {
    if (!(this instanceof SAXParser)) {
      return new SAXParser(strict, opt)
    }

    var parser = this
    clearBuffers(parser)
    parser.q = parser.c = ''
    parser.bufferCheckPosition = sax.MAX_BUFFER_LENGTH
    parser.opt = opt || {}
    parser.opt.lowercase = parser.opt.lowercase || parser.opt.lowercasetags
    parser.looseCase = parser.opt.lowercase ? 'toLowerCase' : 'toUpperCase'
    parser.tags = []
    parser.closed = parser.closedRoot = parser.sawRoot = false
    parser.tag = parser.error = null
    parser.strict = !!strict
    parser.noscript = !!(strict || parser.opt.noscript)
    parser.state = S.BEGIN
    parser.strictEntities = parser.opt.strictEntities
    parser.ENTITIES = parser.strictEntities ? Object.create(sax.XML_ENTITIES) : Object.create(sax.ENTITIES)
    parser.attribList = []

    // namespaces form a prototype chain.
    // it always points at the current tag,
    // which protos to its parent tag.
    if (parser.opt.xmlns) {
      parser.ns = Object.create(rootNS)
    }

    // mostly just for error reporting
    parser.trackPosition = parser.opt.position !== false
    if (parser.trackPosition) {
      parser.position = parser.line = parser.column = 0
    }
    emit(parser, 'onready')
  }

  if (!Object.create) {
    Object.create = function (o) {
      function F () {}
      F.prototype = o
      var newf = new F()
      return newf
    }
  }

  if (!Object.keys) {
    Object.keys = function (o) {
      var a = []
      for (var i in o) if (o.hasOwnProperty(i)) a.push(i)
      return a
    }
  }

  function checkBufferLength (parser) {
    var maxAllowed = Math.max(sax.MAX_BUFFER_LENGTH, 10)
    var maxActual = 0
    for (var i = 0, l = buffers.length; i < l; i++) {
      var len = parser[buffers[i]].length
      if (len > maxAllowed) {
        // Text/cdata nodes can get big, and since they're buffered,
        // we can get here under normal conditions.
        // Avoid issues by emitting the text node now,
        // so at least it won't get any bigger.
        switch (buffers[i]) {
          case 'textNode':
            closeText(parser)
            break

          case 'cdata':
            emitNode(parser, 'oncdata', parser.cdata)
            parser.cdata = ''
            break

          case 'script':
            emitNode(parser, 'onscript', parser.script)
            parser.script = ''
            break

          default:
            error(parser, 'Max buffer length exceeded: ' + buffers[i])
        }
      }
      maxActual = Math.max(maxActual, len)
    }
    // schedule the next check for the earliest possible buffer overrun.
    var m = sax.MAX_BUFFER_LENGTH - maxActual
    parser.bufferCheckPosition = m + parser.position
  }

  function clearBuffers (parser) {
    for (var i = 0, l = buffers.length; i < l; i++) {
      parser[buffers[i]] = ''
    }
  }

  function flushBuffers (parser) {
    closeText(parser)
    if (parser.cdata !== '') {
      emitNode(parser, 'oncdata', parser.cdata)
      parser.cdata = ''
    }
    if (parser.script !== '') {
      emitNode(parser, 'onscript', parser.script)
      parser.script = ''
    }
  }

  SAXParser.prototype = {
    end: function () { end(this) },
    write: write,
    resume: function () { this.error = null; return this },
    close: function () { return this.write(null) },
    flush: function () { flushBuffers(this) }
  }

  var Stream
  try {
    Stream = __webpack_require__("1IWx").Stream
  } catch (ex) {
    Stream = function () {}
  }

  var streamWraps = sax.EVENTS.filter(function (ev) {
    return ev !== 'error' && ev !== 'end'
  })

  function createStream (strict, opt) {
    return new SAXStream(strict, opt)
  }

  function SAXStream (strict, opt) {
    if (!(this instanceof SAXStream)) {
      return new SAXStream(strict, opt)
    }

    Stream.apply(this)

    this._parser = new SAXParser(strict, opt)
    this.writable = true
    this.readable = true

    var me = this

    this._parser.onend = function () {
      me.emit('end')
    }

    this._parser.onerror = function (er) {
      me.emit('error', er)

      // if didn't throw, then means error was handled.
      // go ahead and clear error, so we can write again.
      me._parser.error = null
    }

    this._decoder = null

    streamWraps.forEach(function (ev) {
      Object.defineProperty(me, 'on' + ev, {
        get: function () {
          return me._parser['on' + ev]
        },
        set: function (h) {
          if (!h) {
            me.removeAllListeners(ev)
            me._parser['on' + ev] = h
            return h
          }
          me.on(ev, h)
        },
        enumerable: true,
        configurable: false
      })
    })
  }

  SAXStream.prototype = Object.create(Stream.prototype, {
    constructor: {
      value: SAXStream
    }
  })

  SAXStream.prototype.write = function (data) {
    if (typeof Buffer === 'function' &&
      typeof Buffer.isBuffer === 'function' &&
      Buffer.isBuffer(data)) {
      if (!this._decoder) {
        var SD = __webpack_require__("fXKp").StringDecoder
        this._decoder = new SD('utf8')
      }
      data = this._decoder.write(data)
    }

    this._parser.write(data.toString())
    this.emit('data', data)
    return true
  }

  SAXStream.prototype.end = function (chunk) {
    if (chunk && chunk.length) {
      this.write(chunk)
    }
    this._parser.end()
    return true
  }

  SAXStream.prototype.on = function (ev, handler) {
    var me = this
    if (!me._parser['on' + ev] && streamWraps.indexOf(ev) !== -1) {
      me._parser['on' + ev] = function () {
        var args = arguments.length === 1 ? [arguments[0]] : Array.apply(null, arguments)
        args.splice(0, 0, ev)
        me.emit.apply(me, args)
      }
    }

    return Stream.prototype.on.call(me, ev, handler)
  }

  // this really needs to be replaced with character classes.
  // XML allows all manner of ridiculous numbers and digits.
  var CDATA = '[CDATA['
  var DOCTYPE = 'DOCTYPE'
  var XML_NAMESPACE = 'http://www.w3.org/XML/1998/namespace'
  var XMLNS_NAMESPACE = 'http://www.w3.org/2000/xmlns/'
  var rootNS = { xml: XML_NAMESPACE, xmlns: XMLNS_NAMESPACE }

  // http://www.w3.org/TR/REC-xml/#NT-NameStartChar
  // This implementation works on strings, a single character at a time
  // as such, it cannot ever support astral-plane characters (10000-EFFFF)
  // without a significant breaking change to either this  parser, or the
  // JavaScript language.  Implementation of an emoji-capable xml parser
  // is left as an exercise for the reader.
  var nameStart = /[:_A-Za-z\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u02FF\u0370-\u037D\u037F-\u1FFF\u200C-\u200D\u2070-\u218F\u2C00-\u2FEF\u3001-\uD7FF\uF900-\uFDCF\uFDF0-\uFFFD]/

  var nameBody = /[:_A-Za-z\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u02FF\u0370-\u037D\u037F-\u1FFF\u200C-\u200D\u2070-\u218F\u2C00-\u2FEF\u3001-\uD7FF\uF900-\uFDCF\uFDF0-\uFFFD\u00B7\u0300-\u036F\u203F-\u2040.\d-]/

  var entityStart = /[#:_A-Za-z\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u02FF\u0370-\u037D\u037F-\u1FFF\u200C-\u200D\u2070-\u218F\u2C00-\u2FEF\u3001-\uD7FF\uF900-\uFDCF\uFDF0-\uFFFD]/
  var entityBody = /[#:_A-Za-z\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u02FF\u0370-\u037D\u037F-\u1FFF\u200C-\u200D\u2070-\u218F\u2C00-\u2FEF\u3001-\uD7FF\uF900-\uFDCF\uFDF0-\uFFFD\u00B7\u0300-\u036F\u203F-\u2040.\d-]/

  function isWhitespace (c) {
    return c === ' ' || c === '\n' || c === '\r' || c === '\t'
  }

  function isQuote (c) {
    return c === '"' || c === '\''
  }

  function isAttribEnd (c) {
    return c === '>' || isWhitespace(c)
  }

  function isMatch (regex, c) {
    return regex.test(c)
  }

  function notMatch (regex, c) {
    return !isMatch(regex, c)
  }

  var S = 0
  sax.STATE = {
    BEGIN: S++, // leading byte order mark or whitespace
    BEGIN_WHITESPACE: S++, // leading whitespace
    TEXT: S++, // general stuff
    TEXT_ENTITY: S++, // &amp and such.
    OPEN_WAKA: S++, // <
    SGML_DECL: S++, // <!BLARG
    SGML_DECL_QUOTED: S++, // <!BLARG foo "bar
    DOCTYPE: S++, // <!DOCTYPE
    DOCTYPE_QUOTED: S++, // <!DOCTYPE "//blah
    DOCTYPE_DTD: S++, // <!DOCTYPE "//blah" [ ...
    DOCTYPE_DTD_QUOTED: S++, // <!DOCTYPE "//blah" [ "foo
    COMMENT_STARTING: S++, // <!-
    COMMENT: S++, // <!--
    COMMENT_ENDING: S++, // <!-- blah -
    COMMENT_ENDED: S++, // <!-- blah --
    CDATA: S++, // <![CDATA[ something
    CDATA_ENDING: S++, // ]
    CDATA_ENDING_2: S++, // ]]
    PROC_INST: S++, // <?hi
    PROC_INST_BODY: S++, // <?hi there
    PROC_INST_ENDING: S++, // <?hi "there" ?
    OPEN_TAG: S++, // <strong
    OPEN_TAG_SLASH: S++, // <strong /
    ATTRIB: S++, // <a
    ATTRIB_NAME: S++, // <a foo
    ATTRIB_NAME_SAW_WHITE: S++, // <a foo _
    ATTRIB_VALUE: S++, // <a foo=
    ATTRIB_VALUE_QUOTED: S++, // <a foo="bar
    ATTRIB_VALUE_CLOSED: S++, // <a foo="bar"
    ATTRIB_VALUE_UNQUOTED: S++, // <a foo=bar
    ATTRIB_VALUE_ENTITY_Q: S++, // <foo bar="&quot;"
    ATTRIB_VALUE_ENTITY_U: S++, // <foo bar=&quot
    CLOSE_TAG: S++, // </a
    CLOSE_TAG_SAW_WHITE: S++, // </a   >
    SCRIPT: S++, // <script> ...
    SCRIPT_ENDING: S++ // <script> ... <
  }

  sax.XML_ENTITIES = {
    'amp': '&',
    'gt': '>',
    'lt': '<',
    'quot': '"',
    'apos': "'"
  }

  sax.ENTITIES = {
    'amp': '&',
    'gt': '>',
    'lt': '<',
    'quot': '"',
    'apos': "'",
    'AElig': 198,
    'Aacute': 193,
    'Acirc': 194,
    'Agrave': 192,
    'Aring': 197,
    'Atilde': 195,
    'Auml': 196,
    'Ccedil': 199,
    'ETH': 208,
    'Eacute': 201,
    'Ecirc': 202,
    'Egrave': 200,
    'Euml': 203,
    'Iacute': 205,
    'Icirc': 206,
    'Igrave': 204,
    'Iuml': 207,
    'Ntilde': 209,
    'Oacute': 211,
    'Ocirc': 212,
    'Ograve': 210,
    'Oslash': 216,
    'Otilde': 213,
    'Ouml': 214,
    'THORN': 222,
    'Uacute': 218,
    'Ucirc': 219,
    'Ugrave': 217,
    'Uuml': 220,
    'Yacute': 221,
    'aacute': 225,
    'acirc': 226,
    'aelig': 230,
    'agrave': 224,
    'aring': 229,
    'atilde': 227,
    'auml': 228,
    'ccedil': 231,
    'eacute': 233,
    'ecirc': 234,
    'egrave': 232,
    'eth': 240,
    'euml': 235,
    'iacute': 237,
    'icirc': 238,
    'igrave': 236,
    'iuml': 239,
    'ntilde': 241,
    'oacute': 243,
    'ocirc': 244,
    'ograve': 242,
    'oslash': 248,
    'otilde': 245,
    'ouml': 246,
    'szlig': 223,
    'thorn': 254,
    'uacute': 250,
    'ucirc': 251,
    'ugrave': 249,
    'uuml': 252,
    'yacute': 253,
    'yuml': 255,
    'copy': 169,
    'reg': 174,
    'nbsp': 160,
    'iexcl': 161,
    'cent': 162,
    'pound': 163,
    'curren': 164,
    'yen': 165,
    'brvbar': 166,
    'sect': 167,
    'uml': 168,
    'ordf': 170,
    'laquo': 171,
    'not': 172,
    'shy': 173,
    'macr': 175,
    'deg': 176,
    'plusmn': 177,
    'sup1': 185,
    'sup2': 178,
    'sup3': 179,
    'acute': 180,
    'micro': 181,
    'para': 182,
    'middot': 183,
    'cedil': 184,
    'ordm': 186,
    'raquo': 187,
    'frac14': 188,
    'frac12': 189,
    'frac34': 190,
    'iquest': 191,
    'times': 215,
    'divide': 247,
    'OElig': 338,
    'oelig': 339,
    'Scaron': 352,
    'scaron': 353,
    'Yuml': 376,
    'fnof': 402,
    'circ': 710,
    'tilde': 732,
    'Alpha': 913,
    'Beta': 914,
    'Gamma': 915,
    'Delta': 916,
    'Epsilon': 917,
    'Zeta': 918,
    'Eta': 919,
    'Theta': 920,
    'Iota': 921,
    'Kappa': 922,
    'Lambda': 923,
    'Mu': 924,
    'Nu': 925,
    'Xi': 926,
    'Omicron': 927,
    'Pi': 928,
    'Rho': 929,
    'Sigma': 931,
    'Tau': 932,
    'Upsilon': 933,
    'Phi': 934,
    'Chi': 935,
    'Psi': 936,
    'Omega': 937,
    'alpha': 945,
    'beta': 946,
    'gamma': 947,
    'delta': 948,
    'epsilon': 949,
    'zeta': 950,
    'eta': 951,
    'theta': 952,
    'iota': 953,
    'kappa': 954,
    'lambda': 955,
    'mu': 956,
    'nu': 957,
    'xi': 958,
    'omicron': 959,
    'pi': 960,
    'rho': 961,
    'sigmaf': 962,
    'sigma': 963,
    'tau': 964,
    'upsilon': 965,
    'phi': 966,
    'chi': 967,
    'psi': 968,
    'omega': 969,
    'thetasym': 977,
    'upsih': 978,
    'piv': 982,
    'ensp': 8194,
    'emsp': 8195,
    'thinsp': 8201,
    'zwnj': 8204,
    'zwj': 8205,
    'lrm': 8206,
    'rlm': 8207,
    'ndash': 8211,
    'mdash': 8212,
    'lsquo': 8216,
    'rsquo': 8217,
    'sbquo': 8218,
    'ldquo': 8220,
    'rdquo': 8221,
    'bdquo': 8222,
    'dagger': 8224,
    'Dagger': 8225,
    'bull': 8226,
    'hellip': 8230,
    'permil': 8240,
    'prime': 8242,
    'Prime': 8243,
    'lsaquo': 8249,
    'rsaquo': 8250,
    'oline': 8254,
    'frasl': 8260,
    'euro': 8364,
    'image': 8465,
    'weierp': 8472,
    'real': 8476,
    'trade': 8482,
    'alefsym': 8501,
    'larr': 8592,
    'uarr': 8593,
    'rarr': 8594,
    'darr': 8595,
    'harr': 8596,
    'crarr': 8629,
    'lArr': 8656,
    'uArr': 8657,
    'rArr': 8658,
    'dArr': 8659,
    'hArr': 8660,
    'forall': 8704,
    'part': 8706,
    'exist': 8707,
    'empty': 8709,
    'nabla': 8711,
    'isin': 8712,
    'notin': 8713,
    'ni': 8715,
    'prod': 8719,
    'sum': 8721,
    'minus': 8722,
    'lowast': 8727,
    'radic': 8730,
    'prop': 8733,
    'infin': 8734,
    'ang': 8736,
    'and': 8743,
    'or': 8744,
    'cap': 8745,
    'cup': 8746,
    'int': 8747,
    'there4': 8756,
    'sim': 8764,
    'cong': 8773,
    'asymp': 8776,
    'ne': 8800,
    'equiv': 8801,
    'le': 8804,
    'ge': 8805,
    'sub': 8834,
    'sup': 8835,
    'nsub': 8836,
    'sube': 8838,
    'supe': 8839,
    'oplus': 8853,
    'otimes': 8855,
    'perp': 8869,
    'sdot': 8901,
    'lceil': 8968,
    'rceil': 8969,
    'lfloor': 8970,
    'rfloor': 8971,
    'lang': 9001,
    'rang': 9002,
    'loz': 9674,
    'spades': 9824,
    'clubs': 9827,
    'hearts': 9829,
    'diams': 9830
  }

  Object.keys(sax.ENTITIES).forEach(function (key) {
    var e = sax.ENTITIES[key]
    var s = typeof e === 'number' ? String.fromCharCode(e) : e
    sax.ENTITIES[key] = s
  })

  for (var s in sax.STATE) {
    sax.STATE[sax.STATE[s]] = s
  }

  // shorthand
  S = sax.STATE

  function emit (parser, event, data) {
    parser[event] && parser[event](data)
  }

  function emitNode (parser, nodeType, data) {
    if (parser.textNode) closeText(parser)
    emit(parser, nodeType, data)
  }

  function closeText (parser) {
    parser.textNode = textopts(parser.opt, parser.textNode)
    if (parser.textNode) emit(parser, 'ontext', parser.textNode)
    parser.textNode = ''
  }

  function textopts (opt, text) {
    if (opt.trim) text = text.trim()
    if (opt.normalize) text = text.replace(/\s+/g, ' ')
    return text
  }

  function error (parser, er) {
    closeText(parser)
    if (parser.trackPosition) {
      er += '\nLine: ' + parser.line +
        '\nColumn: ' + parser.column +
        '\nChar: ' + parser.c
    }
    er = new Error(er)
    parser.error = er
    emit(parser, 'onerror', er)
    return parser
  }

  function end (parser) {
    if (parser.sawRoot && !parser.closedRoot) strictFail(parser, 'Unclosed root tag')
    if ((parser.state !== S.BEGIN) &&
      (parser.state !== S.BEGIN_WHITESPACE) &&
      (parser.state !== S.TEXT)) {
      error(parser, 'Unexpected end')
    }
    closeText(parser)
    parser.c = ''
    parser.closed = true
    emit(parser, 'onend')
    SAXParser.call(parser, parser.strict, parser.opt)
    return parser
  }

  function strictFail (parser, message) {
    if (typeof parser !== 'object' || !(parser instanceof SAXParser)) {
      throw new Error('bad call to strictFail')
    }
    if (parser.strict) {
      error(parser, message)
    }
  }

  function newTag (parser) {
    if (!parser.strict) parser.tagName = parser.tagName[parser.looseCase]()
    var parent = parser.tags[parser.tags.length - 1] || parser
    var tag = parser.tag = { name: parser.tagName, attributes: {} }

    // will be overridden if tag contails an xmlns="foo" or xmlns:foo="bar"
    if (parser.opt.xmlns) {
      tag.ns = parent.ns
    }
    parser.attribList.length = 0
    emitNode(parser, 'onopentagstart', tag)
  }

  function qname (name, attribute) {
    var i = name.indexOf(':')
    var qualName = i < 0 ? [ '', name ] : name.split(':')
    var prefix = qualName[0]
    var local = qualName[1]

    // <x "xmlns"="http://foo">
    if (attribute && name === 'xmlns') {
      prefix = 'xmlns'
      local = ''
    }

    return { prefix: prefix, local: local }
  }

  function attrib (parser) {
    if (!parser.strict) {
      parser.attribName = parser.attribName[parser.looseCase]()
    }

    if (parser.attribList.indexOf(parser.attribName) !== -1 ||
      parser.tag.attributes.hasOwnProperty(parser.attribName)) {
      parser.attribName = parser.attribValue = ''
      return
    }

    if (parser.opt.xmlns) {
      var qn = qname(parser.attribName, true)
      var prefix = qn.prefix
      var local = qn.local

      if (prefix === 'xmlns') {
        // namespace binding attribute. push the binding into scope
        if (local === 'xml' && parser.attribValue !== XML_NAMESPACE) {
          strictFail(parser,
            'xml: prefix must be bound to ' + XML_NAMESPACE + '\n' +
            'Actual: ' + parser.attribValue)
        } else if (local === 'xmlns' && parser.attribValue !== XMLNS_NAMESPACE) {
          strictFail(parser,
            'xmlns: prefix must be bound to ' + XMLNS_NAMESPACE + '\n' +
            'Actual: ' + parser.attribValue)
        } else {
          var tag = parser.tag
          var parent = parser.tags[parser.tags.length - 1] || parser
          if (tag.ns === parent.ns) {
            tag.ns = Object.create(parent.ns)
          }
          tag.ns[local] = parser.attribValue
        }
      }

      // defer onattribute events until all attributes have been seen
      // so any new bindings can take effect. preserve attribute order
      // so deferred events can be emitted in document order
      parser.attribList.push([parser.attribName, parser.attribValue])
    } else {
      // in non-xmlns mode, we can emit the event right away
      parser.tag.attributes[parser.attribName] = parser.attribValue
      emitNode(parser, 'onattribute', {
        name: parser.attribName,
        value: parser.attribValue
      })
    }

    parser.attribName = parser.attribValue = ''
  }

  function openTag (parser, selfClosing) {
    if (parser.opt.xmlns) {
      // emit namespace binding events
      var tag = parser.tag

      // add namespace info to tag
      var qn = qname(parser.tagName)
      tag.prefix = qn.prefix
      tag.local = qn.local
      tag.uri = tag.ns[qn.prefix] || ''

      if (tag.prefix && !tag.uri) {
        strictFail(parser, 'Unbound namespace prefix: ' +
          JSON.stringify(parser.tagName))
        tag.uri = qn.prefix
      }

      var parent = parser.tags[parser.tags.length - 1] || parser
      if (tag.ns && parent.ns !== tag.ns) {
        Object.keys(tag.ns).forEach(function (p) {
          emitNode(parser, 'onopennamespace', {
            prefix: p,
            uri: tag.ns[p]
          })
        })
      }

      // handle deferred onattribute events
      // Note: do not apply default ns to attributes:
      //   http://www.w3.org/TR/REC-xml-names/#defaulting
      for (var i = 0, l = parser.attribList.length; i < l; i++) {
        var nv = parser.attribList[i]
        var name = nv[0]
        var value = nv[1]
        var qualName = qname(name, true)
        var prefix = qualName.prefix
        var local = qualName.local
        var uri = prefix === '' ? '' : (tag.ns[prefix] || '')
        var a = {
          name: name,
          value: value,
          prefix: prefix,
          local: local,
          uri: uri
        }

        // if there's any attributes with an undefined namespace,
        // then fail on them now.
        if (prefix && prefix !== 'xmlns' && !uri) {
          strictFail(parser, 'Unbound namespace prefix: ' +
            JSON.stringify(prefix))
          a.uri = prefix
        }
        parser.tag.attributes[name] = a
        emitNode(parser, 'onattribute', a)
      }
      parser.attribList.length = 0
    }

    parser.tag.isSelfClosing = !!selfClosing

    // process the tag
    parser.sawRoot = true
    parser.tags.push(parser.tag)
    emitNode(parser, 'onopentag', parser.tag)
    if (!selfClosing) {
      // special case for <script> in non-strict mode.
      if (!parser.noscript && parser.tagName.toLowerCase() === 'script') {
        parser.state = S.SCRIPT
      } else {
        parser.state = S.TEXT
      }
      parser.tag = null
      parser.tagName = ''
    }
    parser.attribName = parser.attribValue = ''
    parser.attribList.length = 0
  }

  function closeTag (parser) {
    if (!parser.tagName) {
      strictFail(parser, 'Weird empty close tag.')
      parser.textNode += '</>'
      parser.state = S.TEXT
      return
    }

    if (parser.script) {
      if (parser.tagName !== 'script') {
        parser.script += '</' + parser.tagName + '>'
        parser.tagName = ''
        parser.state = S.SCRIPT
        return
      }
      emitNode(parser, 'onscript', parser.script)
      parser.script = ''
    }

    // first make sure that the closing tag actually exists.
    // <a><b></c></b></a> will close everything, otherwise.
    var t = parser.tags.length
    var tagName = parser.tagName
    if (!parser.strict) {
      tagName = tagName[parser.looseCase]()
    }
    var closeTo = tagName
    while (t--) {
      var close = parser.tags[t]
      if (close.name !== closeTo) {
        // fail the first time in strict mode
        strictFail(parser, 'Unexpected close tag')
      } else {
        break
      }
    }

    // didn't find it.  we already failed for strict, so just abort.
    if (t < 0) {
      strictFail(parser, 'Unmatched closing tag: ' + parser.tagName)
      parser.textNode += '</' + parser.tagName + '>'
      parser.state = S.TEXT
      return
    }
    parser.tagName = tagName
    var s = parser.tags.length
    while (s-- > t) {
      var tag = parser.tag = parser.tags.pop()
      parser.tagName = parser.tag.name
      emitNode(parser, 'onclosetag', parser.tagName)

      var x = {}
      for (var i in tag.ns) {
        x[i] = tag.ns[i]
      }

      var parent = parser.tags[parser.tags.length - 1] || parser
      if (parser.opt.xmlns && tag.ns !== parent.ns) {
        // remove namespace bindings introduced by tag
        Object.keys(tag.ns).forEach(function (p) {
          var n = tag.ns[p]
          emitNode(parser, 'onclosenamespace', { prefix: p, uri: n })
        })
      }
    }
    if (t === 0) parser.closedRoot = true
    parser.tagName = parser.attribValue = parser.attribName = ''
    parser.attribList.length = 0
    parser.state = S.TEXT
  }

  function parseEntity (parser) {
    var entity = parser.entity
    var entityLC = entity.toLowerCase()
    var num
    var numStr = ''

    if (parser.ENTITIES[entity]) {
      return parser.ENTITIES[entity]
    }
    if (parser.ENTITIES[entityLC]) {
      return parser.ENTITIES[entityLC]
    }
    entity = entityLC
    if (entity.charAt(0) === '#') {
      if (entity.charAt(1) === 'x') {
        entity = entity.slice(2)
        num = parseInt(entity, 16)
        numStr = num.toString(16)
      } else {
        entity = entity.slice(1)
        num = parseInt(entity, 10)
        numStr = num.toString(10)
      }
    }
    entity = entity.replace(/^0+/, '')
    if (isNaN(num) || numStr.toLowerCase() !== entity) {
      strictFail(parser, 'Invalid character entity')
      return '&' + parser.entity + ';'
    }

    return String.fromCodePoint(num)
  }

  function beginWhiteSpace (parser, c) {
    if (c === '<') {
      parser.state = S.OPEN_WAKA
      parser.startTagPosition = parser.position
    } else if (!isWhitespace(c)) {
      // have to process this as a text node.
      // weird, but happens.
      strictFail(parser, 'Non-whitespace before first tag.')
      parser.textNode = c
      parser.state = S.TEXT
    }
  }

  function charAt (chunk, i) {
    var result = ''
    if (i < chunk.length) {
      result = chunk.charAt(i)
    }
    return result
  }

  function write (chunk) {
    var parser = this
    if (this.error) {
      throw this.error
    }
    if (parser.closed) {
      return error(parser,
        'Cannot write after close. Assign an onready handler.')
    }
    if (chunk === null) {
      return end(parser)
    }
    if (typeof chunk === 'object') {
      chunk = chunk.toString()
    }
    var i = 0
    var c = ''
    while (true) {
      c = charAt(chunk, i++)
      parser.c = c

      if (!c) {
        break
      }

      if (parser.trackPosition) {
        parser.position++
        if (c === '\n') {
          parser.line++
          parser.column = 0
        } else {
          parser.column++
        }
      }

      switch (parser.state) {
        case S.BEGIN:
          parser.state = S.BEGIN_WHITESPACE
          if (c === '\uFEFF') {
            continue
          }
          beginWhiteSpace(parser, c)
          continue

        case S.BEGIN_WHITESPACE:
          beginWhiteSpace(parser, c)
          continue

        case S.TEXT:
          if (parser.sawRoot && !parser.closedRoot) {
            var starti = i - 1
            while (c && c !== '<' && c !== '&') {
              c = charAt(chunk, i++)
              if (c && parser.trackPosition) {
                parser.position++
                if (c === '\n') {
                  parser.line++
                  parser.column = 0
                } else {
                  parser.column++
                }
              }
            }
            parser.textNode += chunk.substring(starti, i - 1)
          }
          if (c === '<' && !(parser.sawRoot && parser.closedRoot && !parser.strict)) {
            parser.state = S.OPEN_WAKA
            parser.startTagPosition = parser.position
          } else {
            if (!isWhitespace(c) && (!parser.sawRoot || parser.closedRoot)) {
              strictFail(parser, 'Text data outside of root node.')
            }
            if (c === '&') {
              parser.state = S.TEXT_ENTITY
            } else {
              parser.textNode += c
            }
          }
          continue

        case S.SCRIPT:
          // only non-strict
          if (c === '<') {
            parser.state = S.SCRIPT_ENDING
          } else {
            parser.script += c
          }
          continue

        case S.SCRIPT_ENDING:
          if (c === '/') {
            parser.state = S.CLOSE_TAG
          } else {
            parser.script += '<' + c
            parser.state = S.SCRIPT
          }
          continue

        case S.OPEN_WAKA:
          // either a /, ?, !, or text is coming next.
          if (c === '!') {
            parser.state = S.SGML_DECL
            parser.sgmlDecl = ''
          } else if (isWhitespace(c)) {
            // wait for it...
          } else if (isMatch(nameStart, c)) {
            parser.state = S.OPEN_TAG
            parser.tagName = c
          } else if (c === '/') {
            parser.state = S.CLOSE_TAG
            parser.tagName = ''
          } else if (c === '?') {
            parser.state = S.PROC_INST
            parser.procInstName = parser.procInstBody = ''
          } else {
            strictFail(parser, 'Unencoded <')
            // if there was some whitespace, then add that in.
            if (parser.startTagPosition + 1 < parser.position) {
              var pad = parser.position - parser.startTagPosition
              c = new Array(pad).join(' ') + c
            }
            parser.textNode += '<' + c
            parser.state = S.TEXT
          }
          continue

        case S.SGML_DECL:
          if ((parser.sgmlDecl + c).toUpperCase() === CDATA) {
            emitNode(parser, 'onopencdata')
            parser.state = S.CDATA
            parser.sgmlDecl = ''
            parser.cdata = ''
          } else if (parser.sgmlDecl + c === '--') {
            parser.state = S.COMMENT
            parser.comment = ''
            parser.sgmlDecl = ''
          } else if ((parser.sgmlDecl + c).toUpperCase() === DOCTYPE) {
            parser.state = S.DOCTYPE
            if (parser.doctype || parser.sawRoot) {
              strictFail(parser,
                'Inappropriately located doctype declaration')
            }
            parser.doctype = ''
            parser.sgmlDecl = ''
          } else if (c === '>') {
            emitNode(parser, 'onsgmldeclaration', parser.sgmlDecl)
            parser.sgmlDecl = ''
            parser.state = S.TEXT
          } else if (isQuote(c)) {
            parser.state = S.SGML_DECL_QUOTED
            parser.sgmlDecl += c
          } else {
            parser.sgmlDecl += c
          }
          continue

        case S.SGML_DECL_QUOTED:
          if (c === parser.q) {
            parser.state = S.SGML_DECL
            parser.q = ''
          }
          parser.sgmlDecl += c
          continue

        case S.DOCTYPE:
          if (c === '>') {
            parser.state = S.TEXT
            emitNode(parser, 'ondoctype', parser.doctype)
            parser.doctype = true // just remember that we saw it.
          } else {
            parser.doctype += c
            if (c === '[') {
              parser.state = S.DOCTYPE_DTD
            } else if (isQuote(c)) {
              parser.state = S.DOCTYPE_QUOTED
              parser.q = c
            }
          }
          continue

        case S.DOCTYPE_QUOTED:
          parser.doctype += c
          if (c === parser.q) {
            parser.q = ''
            parser.state = S.DOCTYPE
          }
          continue

        case S.DOCTYPE_DTD:
          parser.doctype += c
          if (c === ']') {
            parser.state = S.DOCTYPE
          } else if (isQuote(c)) {
            parser.state = S.DOCTYPE_DTD_QUOTED
            parser.q = c
          }
          continue

        case S.DOCTYPE_DTD_QUOTED:
          parser.doctype += c
          if (c === parser.q) {
            parser.state = S.DOCTYPE_DTD
            parser.q = ''
          }
          continue

        case S.COMMENT:
          if (c === '-') {
            parser.state = S.COMMENT_ENDING
          } else {
            parser.comment += c
          }
          continue

        case S.COMMENT_ENDING:
          if (c === '-') {
            parser.state = S.COMMENT_ENDED
            parser.comment = textopts(parser.opt, parser.comment)
            if (parser.comment) {
              emitNode(parser, 'oncomment', parser.comment)
            }
            parser.comment = ''
          } else {
            parser.comment += '-' + c
            parser.state = S.COMMENT
          }
          continue

        case S.COMMENT_ENDED:
          if (c !== '>') {
            strictFail(parser, 'Malformed comment')
            // allow <!-- blah -- bloo --> in non-strict mode,
            // which is a comment of " blah -- bloo "
            parser.comment += '--' + c
            parser.state = S.COMMENT
          } else {
            parser.state = S.TEXT
          }
          continue

        case S.CDATA:
          if (c === ']') {
            parser.state = S.CDATA_ENDING
          } else {
            parser.cdata += c
          }
          continue

        case S.CDATA_ENDING:
          if (c === ']') {
            parser.state = S.CDATA_ENDING_2
          } else {
            parser.cdata += ']' + c
            parser.state = S.CDATA
          }
          continue

        case S.CDATA_ENDING_2:
          if (c === '>') {
            if (parser.cdata) {
              emitNode(parser, 'oncdata', parser.cdata)
            }
            emitNode(parser, 'onclosecdata')
            parser.cdata = ''
            parser.state = S.TEXT
          } else if (c === ']') {
            parser.cdata += ']'
          } else {
            parser.cdata += ']]' + c
            parser.state = S.CDATA
          }
          continue

        case S.PROC_INST:
          if (c === '?') {
            parser.state = S.PROC_INST_ENDING
          } else if (isWhitespace(c)) {
            parser.state = S.PROC_INST_BODY
          } else {
            parser.procInstName += c
          }
          continue

        case S.PROC_INST_BODY:
          if (!parser.procInstBody && isWhitespace(c)) {
            continue
          } else if (c === '?') {
            parser.state = S.PROC_INST_ENDING
          } else {
            parser.procInstBody += c
          }
          continue

        case S.PROC_INST_ENDING:
          if (c === '>') {
            emitNode(parser, 'onprocessinginstruction', {
              name: parser.procInstName,
              body: parser.procInstBody
            })
            parser.procInstName = parser.procInstBody = ''
            parser.state = S.TEXT
          } else {
            parser.procInstBody += '?' + c
            parser.state = S.PROC_INST_BODY
          }
          continue

        case S.OPEN_TAG:
          if (isMatch(nameBody, c)) {
            parser.tagName += c
          } else {
            newTag(parser)
            if (c === '>') {
              openTag(parser)
            } else if (c === '/') {
              parser.state = S.OPEN_TAG_SLASH
            } else {
              if (!isWhitespace(c)) {
                strictFail(parser, 'Invalid character in tag name')
              }
              parser.state = S.ATTRIB
            }
          }
          continue

        case S.OPEN_TAG_SLASH:
          if (c === '>') {
            openTag(parser, true)
            closeTag(parser)
          } else {
            strictFail(parser, 'Forward-slash in opening tag not followed by >')
            parser.state = S.ATTRIB
          }
          continue

        case S.ATTRIB:
          // haven't read the attribute name yet.
          if (isWhitespace(c)) {
            continue
          } else if (c === '>') {
            openTag(parser)
          } else if (c === '/') {
            parser.state = S.OPEN_TAG_SLASH
          } else if (isMatch(nameStart, c)) {
            parser.attribName = c
            parser.attribValue = ''
            parser.state = S.ATTRIB_NAME
          } else {
            strictFail(parser, 'Invalid attribute name')
          }
          continue

        case S.ATTRIB_NAME:
          if (c === '=') {
            parser.state = S.ATTRIB_VALUE
          } else if (c === '>') {
            strictFail(parser, 'Attribute without value')
            parser.attribValue = parser.attribName
            attrib(parser)
            openTag(parser)
          } else if (isWhitespace(c)) {
            parser.state = S.ATTRIB_NAME_SAW_WHITE
          } else if (isMatch(nameBody, c)) {
            parser.attribName += c
          } else {
            strictFail(parser, 'Invalid attribute name')
          }
          continue

        case S.ATTRIB_NAME_SAW_WHITE:
          if (c === '=') {
            parser.state = S.ATTRIB_VALUE
          } else if (isWhitespace(c)) {
            continue
          } else {
            strictFail(parser, 'Attribute without value')
            parser.tag.attributes[parser.attribName] = ''
            parser.attribValue = ''
            emitNode(parser, 'onattribute', {
              name: parser.attribName,
              value: ''
            })
            parser.attribName = ''
            if (c === '>') {
              openTag(parser)
            } else if (isMatch(nameStart, c)) {
              parser.attribName = c
              parser.state = S.ATTRIB_NAME
            } else {
              strictFail(parser, 'Invalid attribute name')
              parser.state = S.ATTRIB
            }
          }
          continue

        case S.ATTRIB_VALUE:
          if (isWhitespace(c)) {
            continue
          } else if (isQuote(c)) {
            parser.q = c
            parser.state = S.ATTRIB_VALUE_QUOTED
          } else {
            strictFail(parser, 'Unquoted attribute value')
            parser.state = S.ATTRIB_VALUE_UNQUOTED
            parser.attribValue = c
          }
          continue

        case S.ATTRIB_VALUE_QUOTED:
          if (c !== parser.q) {
            if (c === '&') {
              parser.state = S.ATTRIB_VALUE_ENTITY_Q
            } else {
              parser.attribValue += c
            }
            continue
          }
          attrib(parser)
          parser.q = ''
          parser.state = S.ATTRIB_VALUE_CLOSED
          continue

        case S.ATTRIB_VALUE_CLOSED:
          if (isWhitespace(c)) {
            parser.state = S.ATTRIB
          } else if (c === '>') {
            openTag(parser)
          } else if (c === '/') {
            parser.state = S.OPEN_TAG_SLASH
          } else if (isMatch(nameStart, c)) {
            strictFail(parser, 'No whitespace between attributes')
            parser.attribName = c
            parser.attribValue = ''
            parser.state = S.ATTRIB_NAME
          } else {
            strictFail(parser, 'Invalid attribute name')
          }
          continue

        case S.ATTRIB_VALUE_UNQUOTED:
          if (!isAttribEnd(c)) {
            if (c === '&') {
              parser.state = S.ATTRIB_VALUE_ENTITY_U
            } else {
              parser.attribValue += c
            }
            continue
          }
          attrib(parser)
          if (c === '>') {
            openTag(parser)
          } else {
            parser.state = S.ATTRIB
          }
          continue

        case S.CLOSE_TAG:
          if (!parser.tagName) {
            if (isWhitespace(c)) {
              continue
            } else if (notMatch(nameStart, c)) {
              if (parser.script) {
                parser.script += '</' + c
                parser.state = S.SCRIPT
              } else {
                strictFail(parser, 'Invalid tagname in closing tag.')
              }
            } else {
              parser.tagName = c
            }
          } else if (c === '>') {
            closeTag(parser)
          } else if (isMatch(nameBody, c)) {
            parser.tagName += c
          } else if (parser.script) {
            parser.script += '</' + parser.tagName
            parser.tagName = ''
            parser.state = S.SCRIPT
          } else {
            if (!isWhitespace(c)) {
              strictFail(parser, 'Invalid tagname in closing tag')
            }
            parser.state = S.CLOSE_TAG_SAW_WHITE
          }
          continue

        case S.CLOSE_TAG_SAW_WHITE:
          if (isWhitespace(c)) {
            continue
          }
          if (c === '>') {
            closeTag(parser)
          } else {
            strictFail(parser, 'Invalid characters in closing tag')
          }
          continue

        case S.TEXT_ENTITY:
        case S.ATTRIB_VALUE_ENTITY_Q:
        case S.ATTRIB_VALUE_ENTITY_U:
          var returnState
          var buffer
          switch (parser.state) {
            case S.TEXT_ENTITY:
              returnState = S.TEXT
              buffer = 'textNode'
              break

            case S.ATTRIB_VALUE_ENTITY_Q:
              returnState = S.ATTRIB_VALUE_QUOTED
              buffer = 'attribValue'
              break

            case S.ATTRIB_VALUE_ENTITY_U:
              returnState = S.ATTRIB_VALUE_UNQUOTED
              buffer = 'attribValue'
              break
          }

          if (c === ';') {
            parser[buffer] += parseEntity(parser)
            parser.entity = ''
            parser.state = returnState
          } else if (isMatch(parser.entity.length ? entityBody : entityStart, c)) {
            parser.entity += c
          } else {
            strictFail(parser, 'Invalid character in entity name')
            parser[buffer] += '&' + parser.entity + c
            parser.entity = ''
            parser.state = returnState
          }

          continue

        default:
          throw new Error(parser, 'Unknown state: ' + parser.state)
      }
    } // while

    if (parser.position >= parser.bufferCheckPosition) {
      checkBufferLength(parser)
    }
    return parser
  }

  /*! http://mths.be/fromcodepoint v0.1.0 by @mathias */
  /* istanbul ignore next */
  if (!String.fromCodePoint) {
    (function () {
      var stringFromCharCode = String.fromCharCode
      var floor = Math.floor
      var fromCodePoint = function () {
        var MAX_SIZE = 0x4000
        var codeUnits = []
        var highSurrogate
        var lowSurrogate
        var index = -1
        var length = arguments.length
        if (!length) {
          return ''
        }
        var result = ''
        while (++index < length) {
          var codePoint = Number(arguments[index])
          if (
            !isFinite(codePoint) || // `NaN`, `+Infinity`, or `-Infinity`
            codePoint < 0 || // not a valid Unicode code point
            codePoint > 0x10FFFF || // not a valid Unicode code point
            floor(codePoint) !== codePoint // not an integer
          ) {
            throw RangeError('Invalid code point: ' + codePoint)
          }
          if (codePoint <= 0xFFFF) { // BMP code point
            codeUnits.push(codePoint)
          } else { // Astral code point; split in surrogate halves
            // http://mathiasbynens.be/notes/javascript-encoding#surrogate-formulae
            codePoint -= 0x10000
            highSurrogate = (codePoint >> 10) + 0xD800
            lowSurrogate = (codePoint % 0x400) + 0xDC00
            codeUnits.push(highSurrogate, lowSurrogate)
          }
          if (index + 1 === length || codeUnits.length > MAX_SIZE) {
            result += stringFromCharCode.apply(null, codeUnits)
            codeUnits.length = 0
          }
        }
        return result
      }
      /* istanbul ignore next */
      if (Object.defineProperty) {
        Object.defineProperty(String, 'fromCodePoint', {
          value: fromCodePoint,
          configurable: true,
          writable: true
        })
      } else {
        String.fromCodePoint = fromCodePoint
      }
    }())
  }
})( false ? undefined : exports)

/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__("tjlA").Buffer))

/***/ }),

/***/ "N63c":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__("TqRt");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _classCallCheck2 = _interopRequireDefault(__webpack_require__("lwsE"));

var _createClass2 = _interopRequireDefault(__webpack_require__("W8MJ"));

var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__("a1gu"));

var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__("Nsbk"));

var _inherits2 = _interopRequireDefault(__webpack_require__("7W2i"));

var _typeof2 = _interopRequireDefault(__webpack_require__("cDf5"));

var _vue = _interopRequireDefault(__webpack_require__("i7/w"));

var _vuePropertyDecorator = __webpack_require__("YKMj");

var __decorate = void 0 && (void 0).__decorate || function (decorators, target, key, desc) {
  var c = arguments.length,
      r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
      d;
  if ((typeof Reflect === "undefined" ? "undefined" : (0, _typeof2.default)(Reflect)) === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);else for (var i = decorators.length - 1; i >= 0; i--) {
    if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
  }
  return c > 3 && r && Object.defineProperty(target, key, r), r;
};

var Theme =
/*#__PURE__*/
function (_Vue) {
  (0, _inherits2.default)(Theme, _Vue);

  function Theme() {
    var _this;

    (0, _classCallCheck2.default)(this, Theme);
    _this = (0, _possibleConstructorReturn2.default)(this, (0, _getPrototypeOf2.default)(Theme).apply(this, arguments));
    _this.timer = null;
    return _this;
  }

  (0, _createClass2.default)(Theme, [{
    key: "onStartTimingChange",
    value: function onStartTimingChange(newValue) {
      if (newValue) {
        this._start();
      } else {
        this._close();
      }
    }
  }, {
    key: "onFrequencyChange",
    value: function onFrequencyChange() {
      if (this.startTiming) {
        this.resetTimer();
      }
    }
  }, {
    key: "_start",
    value: function _start() {
      var _this2 = this;

      var time = 1000 * this.frequency || 3000;
      this.startTimer();
      this.timer = setInterval(function () {
        _this2.timing();
      }, time);
    }
  }, {
    key: "_close",
    value: function _close() {
      if (this.timer) {
        clearInterval(this.timer);
        this.timer = null;
      }

      this.closeTimer();
    }
  }, {
    key: "startTimer",
    value: function startTimer() {}
  }, {
    key: "timing",
    value: function timing() {}
  }, {
    key: "closeTimer",
    value: function closeTimer() {}
  }, {
    key: "resetTimer",
    value: function resetTimer() {
      this._close();

      this._start();
    }
  }, {
    key: "beforeDestroy",
    value: function beforeDestroy() {
      this.startTiming && this._close();
    }
  }]);
  return Theme;
}(_vue.default);

__decorate([(0, _vuePropertyDecorator.Prop)({
  default: false
})], Theme.prototype, "startTiming", void 0);

__decorate([(0, _vuePropertyDecorator.Prop)({
  default: 3
})], Theme.prototype, "frequency", void 0);

__decorate([(0, _vuePropertyDecorator.Watch)('startTiming', {
  immediate: true
})], Theme.prototype, "onStartTimingChange", null);

__decorate([(0, _vuePropertyDecorator.Watch)('frequency')], Theme.prototype, "onFrequencyChange", null);

Theme = __decorate([_vuePropertyDecorator.Component], Theme);
var _default = Theme;
exports.default = _default;

/***/ }),

/***/ "NGA9":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__("TqRt");

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "AddressMatchParameter", {
  enumerable: true,
  get: function get() {
    return _AddressMatchParameter.default;
  }
});
Object.defineProperty(exports, "iPortalDataParameter", {
  enumerable: true,
  get: function get() {
    return _iPortalDataParameter.default;
  }
});
Object.defineProperty(exports, "RestDataParameter", {
  enumerable: true,
  get: function get() {
    return _RestDataParameter.default;
  }
});
Object.defineProperty(exports, "RestMapParameter", {
  enumerable: true,
  get: function get() {
    return _RestMapParameter.default;
  }
});
Object.defineProperty(exports, "RestParameter", {
  enumerable: true,
  get: function get() {
    return _RestParameter.default;
  }
});

var _AddressMatchParameter = _interopRequireDefault(__webpack_require__("8XH1"));

var _iPortalDataParameter = _interopRequireDefault(__webpack_require__("m68f"));

var _RestDataParameter = _interopRequireDefault(__webpack_require__("gQum"));

var _RestMapParameter = _interopRequireDefault(__webpack_require__("Qp06"));

var _RestParameter = _interopRequireDefault(__webpack_require__("KUEp"));

/***/ }),

/***/ "NjLH":
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ "Nsbk":
/***/ (function(module, exports) {

function _getPrototypeOf(o) {
  module.exports = _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
    return o.__proto__ || Object.getPrototypeOf(o);
  };
  return _getPrototypeOf(o);
}

module.exports = _getPrototypeOf;

/***/ }),

/***/ "NykK":
/***/ (function(module, exports, __webpack_require__) {

var Symbol = __webpack_require__("nmnc"),
    getRawTag = __webpack_require__("AP2z"),
    objectToString = __webpack_require__("KfNM");

/** `Object#toString` result references. */
var nullTag = '[object Null]',
    undefinedTag = '[object Undefined]';

/** Built-in value references. */
var symToStringTag = Symbol ? Symbol.toStringTag : undefined;

/**
 * The base implementation of `getTag` without fallbacks for buggy environments.
 *
 * @private
 * @param {*} value The value to query.
 * @returns {string} Returns the `toStringTag`.
 */
function baseGetTag(value) {
  if (value == null) {
    return value === undefined ? undefinedTag : nullTag;
  }
  return (symToStringTag && symToStringTag in Object(value))
    ? getRawTag(value)
    : objectToString(value);
}

module.exports = baseGetTag;


/***/ }),

/***/ "O2Ir":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_LiquidFill_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("jcU1");
/* harmony import */ var _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_LiquidFill_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_LiquidFill_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__);
/* harmony reexport (unknown) */ for(var __WEBPACK_IMPORT_KEY__ in _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_LiquidFill_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__) if(__WEBPACK_IMPORT_KEY__ !== 'default') (function(key) { __webpack_require__.d(__webpack_exports__, key, function() { return _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_LiquidFill_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__[key]; }) }(__WEBPACK_IMPORT_KEY__));
 /* harmony default export */ __webpack_exports__["default"] = (_node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_LiquidFill_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0___default.a); 

/***/ }),

/***/ "ORi+":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _default = {
  dateTimeFormat: {
    date: {
      year: 'numeric',
      month: 'short',
      day: 'numeric'
    },
    date_second: {
      year: 'numeric',
      month: 'short',
      day: 'numeric',
      hour: 'numeric',
      minute: 'numeric',
      second: 'numeric'
    },
    date_second_week: {
      year: 'numeric',
      month: 'short',
      day: 'numeric',
      weekday: 'long',
      hour: 'numeric',
      minute: 'numeric',
      second: 'numeric'
    }
  },
  // messageTemplate
  warning: {
    unsupportedVideoAddress: '视频地址不合法',
    unavailableVideo: '此视频暂无法播放，请稍后再试',
    mapNotLoaded: '关联的地图尚未加载完整，请稍后',
    unassociatedMap: '您需要配置关联地图！'
  },
  success: {},
  info: {
    loading: '加载中',
    pressEscToExit: '按下 ESC 键或点击关闭按钮退出'
  },
  unit: {
    kilometers: '千米',
    miles: '英里',
    meters: '米',
    yards: '码',
    feet: '英尺',
    squarekilometers: '平方千米',
    squaremiles: '平方英里',
    squaremeters: '平方米',
    squareyards: '平方码',
    squarefeet: '平方英尺'
  },
  error: {},
  commontypes: {
    restData: 'SuperMap Rest 数据服务',
    restMap: 'SuperMap Rest 地图服务',
    addressMatch: 'SuperMap 地址匹配服务',
    iportalData: 'SuperMap iPortal 数据',
    onlineLocalSearch: 'SuperMap Online 本地搜索'
  },
  // 组件
  timeText: {
    Year: '年',
    Month: '月',
    Day: '日',
    hour: '时',
    minute: '分',
    second: '秒'
  },
  zoom: {},
  chart: {
    unSupportedData: '当前数据不支持与地图联动'
  },
  layerList: {
    title: '图层'
  },
  miniMap: {},
  pan: {},
  scale: {},
  webmap: {
    loadingTip: '地图加载中...',
    crsNotSupport: '不支持当前地图的坐标系！',
    TileMatrixSetNotSuppport: '不支持传入的 TileMatrixSet！',
    getLayerInfoFailed: '获取图层信息失败！',
    crsnotsupport: '不支持的坐标系！',
    baiduMapNotSupport: '暂不支持加载百度地图！',
    sampleDataNotSupport: '暂不支持加载示例数据！',
    mvtNotSupport: '暂不支持加载矢量瓦片图层！'
  },
  legend: {
    themeField: '专题字段',
    title: '图例',
    top: '最高',
    bottom: '最低',
    noMatchLayer: '没有匹配的图层'
  },
  measure: {
    mapMeasure: '量算',
    measureResult: '测量结果',
    distance: '距离',
    area: '面积',
    delete: '清空',
    selectPlaceholder: '请选择',
    startingPoint: '起点'
  },
  search: {
    noResult: '查询结果为空！',
    noKey: '搜索关键字不能为空，请输入搜索条件。',
    inputPlaceHolder: '查找地址或地点',
    attribute: '属性',
    attributeValue: '属性值',
    setSearchSource: '请设置搜索源！',
    address: '地址',
    null: '空',
    illegalFeature: '要素必须包含合法的坐标！'
  },
  query: {
    query: '查询',
    queryJob: '任务',
    queryResult: '结果',
    attributeCondition: '属性条件',
    spatialFilter: '空间过滤器',
    mapBounds: '返回地图全图范围的要素',
    currentMapBounds: '返回当前地图范围内的要素',
    applicate: '应用',
    noResult: '无结果',
    resultAlreadyExists: '当前查询结果已经存在!',
    querying: '查询中',
    attribute: '属性',
    attributeValue: '属性值',
    noResults: '查询结果为空！',
    queryFailed: '查询失败!',
    seviceNotSupport: '此服务不支持查询！'
  },
  identify: {
    layerNotExit: "地图上不存在该图层: '{layer}'"
  },
  openFile: {
    fileSizeExceeded: '文件大小超限！文件大小不得超过 10M！',
    fileTypeUnsupported: '不支持该文件格式！',
    openFileFail: '打开文件失败！',
    openFileSuccess: '打开文件成功!',
    selectFile: '选择文件',
    openEmptyFile: '打开文件为空！',
    openFile: '打开文件'
  },
  draw: {
    draw: '绘制'
  },
  indicator: {
    title: '指标标题',
    unit: '单位'
  },
  layerManager: {
    title: '图层管理'
  },
  tdtResults: {
    on: '在',
    station: '站',
    total: '共',
    about: '约',
    // pagination
    homePage: '首页',
    prevPage: '上一页',
    nextPage: '下一页',
    // nothingResult
    searchNoResult: '没有查询到相关结果',
    youCanTry: '您可以尝试',
    enterCorrect: '检查输入是否正确',
    enterOtherKeyWords: '输入其他关键字进行搜索',
    onTdtMap: '在天地图上',
    addThisAddress: '添加该地点',
    uWantTo: '您是否要找',
    // pointResults
    totalFind: '共找到',
    piecesResults: '条结果',
    phone: '电话',
    address: '地址',
    setStartPonint: '设为起点',
    setEndPonint: '设为终点',
    // routePlan
    totalMiles: '总里程',
    distance: '约{distance}公里',
    showDetails: '显示全部详情',
    switchTimes: '换乘{switchTimes}次',
    noSwitch: '无换乘',
    walk: '步行至',
    getOff: '下车',
    getOn: '上车',
    take: '乘坐',
    noSearchResults: '没有查询到线路信息',
    fastRoute: '最快线路',
    shortRoute: '最短线路',
    walkRoute: '少走高速',
    fast: '较快捷',
    noSubway: '不坐地铁',
    lessSwitch: '少换乘',
    lessWalk: '少步行',
    // staticResult
    cityHadResults: '以下城市有结果，请您选择',
    moreCity: '更多城市',
    // LineResult
    allFound: '共为您找到',
    piecesBusRoute: '条公交线路',
    showDetail: '展开详情',
    busEndTime: '首末车时间',
    relateAdress: '点击此处查看 "{keyWord}" 的相关地点',
    // areaResult
    switchTo: '已切换到'
  },
  tdtRoute: {
    title: '路线',
    clearRoute: '清除路线',
    pleaseEnterStartPoint: '请输入起点',
    pleaseEnterEndPoint: '请输入终点',
    search: '搜索',
    startPoint: '起点',
    endPoint: '终点',
    mapLoadedFiled: '地图加载失败',
    busEndTime: '首末车时间',
    about: '约',
    station: '站',
    total: '共',
    hour: '小时',
    minutes: '分钟'
  },
  tdtSearch: {
    phone: '电话',
    address: '地址',
    noData: '暂无',
    transport: '交通'
  },
  tdtMapSwitcher: {
    title: '地图切换',
    image: '影像',
    vector: '矢量',
    terrain: '地形',
    placeName: '地名',
    TiandituVec: '天地图矢量底图',
    TiandituTer: '天地图地形底图',
    TiandituImg: '天地图影像底图',
    TiandituCva: '天地图矢量注记',
    TiandituCta: '天地图地形注记',
    TiandituCia: '天地图影像注记'
  },
  // layer
  dataFlow: {
    dataSubscriptionFailed: '数据订阅失败！'
  },
  animateMarkerlayer: {
    unsupportedData: '当前图层不支持该数据，请重新传入数据！'
  }
};
exports.default = _default;

/***/ }),

/***/ "Onz0":
/***/ (function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(Buffer) {// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.

// NOTE: These type checking functions intentionally don't use `instanceof`
// because it is fragile and can be easily faked with `Object.create()`.

function isArray(arg) {
  if (Array.isArray) {
    return Array.isArray(arg);
  }
  return objectToString(arg) === '[object Array]';
}
exports.isArray = isArray;

function isBoolean(arg) {
  return typeof arg === 'boolean';
}
exports.isBoolean = isBoolean;

function isNull(arg) {
  return arg === null;
}
exports.isNull = isNull;

function isNullOrUndefined(arg) {
  return arg == null;
}
exports.isNullOrUndefined = isNullOrUndefined;

function isNumber(arg) {
  return typeof arg === 'number';
}
exports.isNumber = isNumber;

function isString(arg) {
  return typeof arg === 'string';
}
exports.isString = isString;

function isSymbol(arg) {
  return typeof arg === 'symbol';
}
exports.isSymbol = isSymbol;

function isUndefined(arg) {
  return arg === void 0;
}
exports.isUndefined = isUndefined;

function isRegExp(re) {
  return objectToString(re) === '[object RegExp]';
}
exports.isRegExp = isRegExp;

function isObject(arg) {
  return typeof arg === 'object' && arg !== null;
}
exports.isObject = isObject;

function isDate(d) {
  return objectToString(d) === '[object Date]';
}
exports.isDate = isDate;

function isError(e) {
  return (objectToString(e) === '[object Error]' || e instanceof Error);
}
exports.isError = isError;

function isFunction(arg) {
  return typeof arg === 'function';
}
exports.isFunction = isFunction;

function isPrimitive(arg) {
  return arg === null ||
         typeof arg === 'boolean' ||
         typeof arg === 'number' ||
         typeof arg === 'string' ||
         typeof arg === 'symbol' ||  // ES6 symbol
         typeof arg === 'undefined';
}
exports.isPrimitive = isPrimitive;

exports.isBuffer = Buffer.isBuffer;

function objectToString(o) {
  return Object.prototype.toString.call(o);
}

/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__("tjlA").Buffer))

/***/ }),

/***/ "P7XM":
/***/ (function(module, exports) {

if (typeof Object.create === 'function') {
  // implementation from standard node.js 'util' module
  module.exports = function inherits(ctor, superCtor) {
    if (superCtor) {
      ctor.super_ = superCtor
      ctor.prototype = Object.create(superCtor.prototype, {
        constructor: {
          value: ctor,
          enumerable: false,
          writable: true,
          configurable: true
        }
      })
    }
  };
} else {
  // old school shim for old browsers
  module.exports = function inherits(ctor, superCtor) {
    if (superCtor) {
      ctor.super_ = superCtor
      var TempCtor = function () {}
      TempCtor.prototype = superCtor.prototype
      ctor.prototype = new TempCtor()
      ctor.prototype.constructor = ctor
    }
  }
}


/***/ }),

/***/ "PJYZ":
/***/ (function(module, exports) {

function _assertThisInitialized(self) {
  if (self === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }

  return self;
}

module.exports = _assertThisInitialized;

/***/ }),

/***/ "PZvK":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__("TqRt");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _classCallCheck2 = _interopRequireDefault(__webpack_require__("lwsE"));

var _createClass2 = _interopRequireDefault(__webpack_require__("W8MJ"));

var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__("a1gu"));

var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__("Nsbk"));

var _inherits2 = _interopRequireDefault(__webpack_require__("7W2i"));

var _leafletWrapper = _interopRequireDefault(__webpack_require__("uTlj"));

__webpack_require__("17FK");

var _lodash = _interopRequireDefault(__webpack_require__("zT9C"));

/**
 * @class IdentifyViewModel
 * @description 点选 viewModel.
 * @param {Object} map - map 对象。
 * @param {String} [options.layerName] - 图层名。
 * @param {Object} [options.layerStyle] - 查询结果图层样式配置。
 * @extends mapboxgl.Evented
 */
var IdentifyViewModel =
/*#__PURE__*/
function (_L$Evented) {
  (0, _inherits2.default)(IdentifyViewModel, _L$Evented);

  function IdentifyViewModel(map, options) {
    var _this;

    (0, _classCallCheck2.default)(this, IdentifyViewModel);
    _this = (0, _possibleConstructorReturn2.default)(this, (0, _getPrototypeOf2.default)(IdentifyViewModel).call(this));
    _this.map = map;
    _this.layerNames = options.layerNames;
    _this.layerStyle = options.layerStyle || {};
    _this.popup = null;
    _this.lastLayerName = '';
    return _this;
  }
  /**
   * @function IdentifyViewModel.prototype.getLayerByName
   * @desc 获取。
   * @param {Array} name - 图层名。
   */


  (0, _createClass2.default)(IdentifyViewModel, [{
    key: "getLayerByName",
    value: function getLayerByName(name) {
      return this.map.getLayerByName(name);
    }
    /**
     * @function IdentifyViewModel.prototype.getLayerById
     * @desc 获取。
     * @param {Array} id - 图层名。
     */

  }, {
    key: "getLayerById",
    value: function getLayerById(id) {
      return this.map.getLayerById(id);
    }
    /**
     * @function IdentifyViewModel.prototype.getLayerType
     * @desc 判断是否是geojson
     * @param {Array} layer - 图层名。
     */

  }, {
    key: "getLayerType",
    value: function getLayerType(layer) {
      return layer instanceof _leafletWrapper.default.GeoJSON;
    }
    /**
     * @function IdentifyViewModel.prototype.addOverlayToMap
     * @desc 添加高亮图层。
     * @param {Object} layer - layer。
     * @param {Object} feature - geojson
     * @param {Object} customStyle - 用户自定义样式
     */

  }, {
    key: "addOverlayToMap",
    value: function addOverlayToMap(layer, feature) {
      var customStyle = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : this.layerStyle;
      // 高亮前，清除之前的高亮
      this.lastLayerName && this.removed(this.lastLayerName); // 默认样式

      var defaultStyle = {
        color: '#409eff',
        fillColor: '#409eff',
        fillOpacity: 1,
        opacity: 0.6,
        renderer: _leafletWrapper.default.svg()
      }; // new layer

      var styleOptions = Object.assign((0, _lodash.default)(layer.options), defaultStyle, customStyle);
      var overlayer;
      var type = feature.geometry.type;

      if (type === 'Point' || type === 'MultiPoint') {
        var geoCoordinates = (0, _lodash.default)(feature.geometry.coordinates);
        overlayer = _leafletWrapper.default.circleMarker(geoCoordinates.reverse(), styleOptions);
      } else {
        overlayer = _leafletWrapper.default.geoJSON(feature, {
          style: function style() {
            return styleOptions;
          }
        });
      } // 上图，记录图层名


      this.map.addLayer(overlayer, layer.name + '-SM-highlighted');
      this.lastLayerName = layer.name;
    }
    /**
     * @function IdentifyViewModel.prototype.removed
     * @desc 将客户端专题图的矢量要素转换成geojson。
     * @param {Object} themeFeature - themeFeature。
     */

  }, {
    key: "formatGeoJSON",
    value: function formatGeoJSON(themeFeature) {
      var formatObj = new SuperMap.Format.GeoJSON();
      var serverGeometry = SuperMap.ServerGeometry.fromGeometry(themeFeature.geometry);
      var geojson = formatObj.toGeoJSON(serverGeometry);
      geojson.properties = themeFeature.attributes;
      return geojson;
    }
    /**
     * @function IdentifyViewModel.prototype.removed
     * @desc 清除高亮图层。
     * @param {String} lastLayerName - 图层名。
     */

  }, {
    key: "removed",
    value: function removed() {
      var lastLayerName = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this.lastLayerName;

      // 移除高亮图层
      if (lastLayerName && this.getLayerByName(lastLayerName + '-SM-highlighted')) {
        this.map.removeLayer(this.getLayerByName(lastLayerName + '-SM-highlighted'));
        this.lastLayerName = '';
      }
    }
  }]);
  return IdentifyViewModel;
}(_leafletWrapper.default.Evented);

exports.default = IdentifyViewModel;

/***/ }),

/***/ "QG5D":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addListener = addListener;
exports.removeListener = removeListener;
var raf = null;

function requestAnimationFrame(callback) {
  if (!raf) {
    raf = (window.requestAnimationFrame || window.webkitRequestAnimationFrame || window.mozRequestAnimationFrame || function (callback) {
      return setTimeout(callback, 16);
    }).bind(window);
  }

  return raf(callback);
}

var caf = null;

function cancelAnimationFrame(id) {
  if (!caf) {
    caf = (window.cancelAnimationFrame || window.webkitCancelAnimationFrame || window.mozCancelAnimationFrame || function (id) {
      clearTimeout(id);
    }).bind(window);
  }

  caf(id);
}

function createStyles(styleText) {
  var style = document.createElement('style');
  style.type = 'text/css';

  if (style.styleSheet) {
    style.styleSheet.cssText = styleText;
  } else {
    style.appendChild(document.createTextNode(styleText));
  }

  (document.querySelector('head') || document.body).appendChild(style);
  return style;
}

function createElement(tagName) {
  var props = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var elem = document.createElement(tagName);
  Object.keys(props).forEach(function (key) {
    elem[key] = props[key];
  });
  return elem;
}

function getComputedStyle(elem, prop, pseudo) {
  // for older versions of Firefox, `getComputedStyle` required
  // the second argument and may return `null` for some elements
  // when `display: none`
  var computedStyle = window.getComputedStyle(elem, pseudo || null) || {
    display: 'none'
  };
  return computedStyle[prop];
}

function getRenderInfo(elem) {
  if (!document.documentElement.contains(elem)) {
    return {
      detached: true,
      rendered: false
    };
  }

  var current = elem;

  while (current !== document) {
    if (getComputedStyle(current, 'display') === 'none') {
      return {
        detached: false,
        rendered: false
      };
    }

    current = current.parentNode;
  }

  return {
    detached: false,
    rendered: true
  };
}

var css = ".resize-triggers{visibility:hidden;opacity:0}.resize-contract-trigger,.resize-contract-trigger:before,.resize-expand-trigger,.resize-triggers{content:\"\";position:absolute;top:0;left:0;height:100%;width:100%;overflow:hidden}.resize-contract-trigger,.resize-expand-trigger{background:#eee;overflow:auto}.resize-contract-trigger:before{width:200%;height:200%}";
var total = 0;
var style = null;

function addListener(elem, callback) {
  if (!elem.__resize_mutation_handler__) {
    elem.__resize_mutation_handler__ = handleMutation.bind(elem);
  }

  var listeners = elem.__resize_listeners__;

  if (!listeners) {
    elem.__resize_listeners__ = [];

    if (window.ResizeObserver) {
      var offsetWidth = elem.offsetWidth,
          offsetHeight = elem.offsetHeight;
      var ro = new ResizeObserver(function () {
        if (!elem.__resize_observer_triggered__) {
          elem.__resize_observer_triggered__ = true;

          if (elem.offsetWidth === offsetWidth && elem.offsetHeight === offsetHeight) {
            return;
          }
        }

        runCallbacks(elem);
      }); // initially display none won't trigger ResizeObserver callback

      var _getRenderInfo = getRenderInfo(elem),
          detached = _getRenderInfo.detached,
          rendered = _getRenderInfo.rendered;

      elem.__resize_observer_triggered__ = detached === false && rendered === false;
      elem.__resize_observer__ = ro;
      ro.observe(elem);
    } else if (elem.attachEvent && elem.addEventListener) {
      // targeting IE9/10
      elem.__resize_legacy_resize_handler__ = function handleLegacyResize() {
        runCallbacks(elem);
      };

      elem.attachEvent('onresize', elem.__resize_legacy_resize_handler__);
      document.addEventListener('DOMSubtreeModified', elem.__resize_mutation_handler__);
    } else {
      if (!total) {
        style = createStyles(css);
      }

      initTriggers(elem);
      elem.__resize_rendered__ = getRenderInfo(elem).rendered;

      if (window.MutationObserver) {
        var mo = new MutationObserver(elem.__resize_mutation_handler__);
        mo.observe(document, {
          attributes: true,
          childList: true,
          characterData: true,
          subtree: true
        });
        elem.__resize_mutation_observer__ = mo;
      }
    }
  }

  elem.__resize_listeners__.push(callback);

  total++;
}

function removeListener(elem, callback) {
  var listeners = elem.__resize_listeners__;

  if (!listeners) {
    return;
  }

  if (callback) {
    listeners.splice(listeners.indexOf(callback), 1);
  } // no listeners exist, or removing all listeners


  if (!listeners.length || !callback) {
    // targeting IE9/10
    if (elem.detachEvent && elem.removeEventListener) {
      elem.detachEvent('onresize', elem.__resize_legacy_resize_handler__);
      document.removeEventListener('DOMSubtreeModified', elem.__resize_mutation_handler__);
      return;
    }

    if (elem.__resize_observer__) {
      elem.__resize_observer__.unobserve(elem);

      elem.__resize_observer__.disconnect();

      elem.__resize_observer__ = null;
    } else {
      if (elem.__resize_mutation_observer__) {
        elem.__resize_mutation_observer__.disconnect();

        elem.__resize_mutation_observer__ = null;
      }

      elem.removeEventListener('scroll', handleScroll);
      elem.removeChild(elem.__resize_triggers__.triggers);
      elem.__resize_triggers__ = null;
    }

    elem.__resize_listeners__ = null;
  }

  if (! --total && style) {
    style.parentNode.removeChild(style);
  }
}

function getUpdatedSize(elem) {
  var _elem$__resize_last__ = elem.__resize_last__,
      width = _elem$__resize_last__.width,
      height = _elem$__resize_last__.height;
  var offsetWidth = elem.offsetWidth,
      offsetHeight = elem.offsetHeight;

  if (offsetWidth !== width || offsetHeight !== height) {
    return {
      width: offsetWidth,
      height: offsetHeight
    };
  }

  return null;
}

function handleMutation() {
  // `this` denotes the scrolling element
  var _getRenderInfo2 = getRenderInfo(this),
      rendered = _getRenderInfo2.rendered,
      detached = _getRenderInfo2.detached;

  if (rendered !== this.__resize_rendered__) {
    if (!detached && this.__resize_triggers__) {
      resetTriggers(this);
      this.addEventListener('scroll', handleScroll, true);
    }

    this.__resize_rendered__ = rendered;
    runCallbacks(this);
  }
}

function handleScroll() {
  var _this = this;

  // `this` denotes the scrolling element
  resetTriggers(this);

  if (this.__resize_raf__) {
    cancelAnimationFrame(this.__resize_raf__);
  }

  this.__resize_raf__ = requestAnimationFrame(function () {
    var updated = getUpdatedSize(_this);

    if (updated) {
      _this.__resize_last__ = updated;
      runCallbacks(_this);
    }
  });
}

function runCallbacks(elem) {
  if (!elem || !elem.__resize_listeners__) {
    return;
  }

  elem.__resize_listeners__.forEach(function (callback) {
    callback.call(elem);
  });
}

function initTriggers(elem) {
  var position = getComputedStyle(elem, 'position');

  if (!position || position === 'static') {
    elem.style.position = 'relative';
  }

  elem.__resize_old_position__ = position;
  elem.__resize_last__ = {};
  var triggers = createElement('div', {
    className: 'resize-triggers'
  });
  var expand = createElement('div', {
    className: 'resize-expand-trigger'
  });
  var expandChild = createElement('div');
  var contract = createElement('div', {
    className: 'resize-contract-trigger'
  });
  expand.appendChild(expandChild);
  triggers.appendChild(expand);
  triggers.appendChild(contract);
  elem.appendChild(triggers);
  elem.__resize_triggers__ = {
    triggers: triggers,
    expand: expand,
    expandChild: expandChild,
    contract: contract
  };
  resetTriggers(elem);
  elem.addEventListener('scroll', handleScroll, true);
  elem.__resize_last__ = {
    width: elem.offsetWidth,
    height: elem.offsetHeight
  };
}

function resetTriggers(elem) {
  var _elem$__resize_trigge = elem.__resize_triggers__,
      expand = _elem$__resize_trigge.expand,
      expandChild = _elem$__resize_trigge.expandChild,
      contract = _elem$__resize_trigge.contract; // batch read

  var csw = contract.scrollWidth,
      csh = contract.scrollHeight;
  var eow = expand.offsetWidth,
      eoh = expand.offsetHeight,
      esw = expand.scrollWidth,
      esh = expand.scrollHeight; // batch write

  contract.scrollLeft = csw;
  contract.scrollTop = csh;
  expandChild.style.width = eow + 1 + 'px';
  expandChild.style.height = eoh + 1 + 'px';
  expand.scrollLeft = esw;
  expand.scrollTop = esh;
}

/***/ }),

/***/ "QIyF":
/***/ (function(module, exports, __webpack_require__) {

var root = __webpack_require__("Kz5y");

/**
 * Gets the timestamp of the number of milliseconds that have elapsed since
 * the Unix epoch (1 January 1970 00:00:00 UTC).
 *
 * @static
 * @memberOf _
 * @since 2.4.0
 * @category Date
 * @returns {number} Returns the timestamp.
 * @example
 *
 * _.defer(function(stamp) {
 *   console.log(_.now() - stamp);
 * }, _.now());
 * // => Logs the number of milliseconds it took for the deferred invocation.
 */
var now = function() {
  return root.Date.now();
};

module.exports = now;


/***/ }),

/***/ "QJ+7":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var meta_1 = __webpack_require__("cWyK");
/**
 * Takes a set of features, calculates the bbox of all input features, and returns a bounding box.
 *
 * @name bbox
 * @param {GeoJSON} geojson any GeoJSON object
 * @returns {BBox} bbox extent in [minX, minY, maxX, maxY] order
 * @example
 * var line = turf.lineString([[-74, 40], [-78, 42], [-82, 35]]);
 * var bbox = turf.bbox(line);
 * var bboxPolygon = turf.bboxPolygon(bbox);
 *
 * //addToMap
 * var addToMap = [line, bboxPolygon]
 */
function bbox(geojson) {
    var result = [Infinity, Infinity, -Infinity, -Infinity];
    meta_1.coordEach(geojson, function (coord) {
        if (result[0] > coord[0]) {
            result[0] = coord[0];
        }
        if (result[1] > coord[1]) {
            result[1] = coord[1];
        }
        if (result[2] < coord[0]) {
            result[2] = coord[0];
        }
        if (result[3] < coord[1]) {
            result[3] = coord[1];
        }
    });
    return result;
}
exports.default = bbox;


/***/ }),

/***/ "QYU9":
/***/ (function(module) {

module.exports = JSON.parse("[{\"name\":\"克拉玛依市\",\"coord\":[85.01486759299489,45.406422237230046]},{\"name\":\"昌吉回族自治州\",\"coord\":[88.7154624754753,44.26991024636568]},{\"name\":\"石河子市\",\"coord\":[86.0208600035924,44.239045558096805]},{\"name\":\"霍林郭勒市\",\"coord\":[114.73479243733115,44.16058374713977]},{\"name\":\"本溪市\",\"coord\":[124.64357865201586,41.177197783134275]},{\"name\":\"嘉峪关市\",\"coord\":[98.16891560537093,39.76279786284264]},{\"name\":\"莱芜市\",\"coord\":[117.65723565456207,36.27916499211527]},{\"name\":\"神农架林区\",\"coord\":[110.48296222218153,31.581260143666697]},{\"name\":\"天门市\",\"coord\":[113.00615321481195,30.64105781887143]},{\"name\":\"鄂州市\",\"coord\":[114.94764081970385,30.325634953844585]},{\"name\":\"潜江市\",\"coord\":[112.70703817700621,30.349210666019893]},{\"name\":\"仙桃市\",\"coord\":[113.34688900729822,30.315951161935402]},{\"name\":\"萍乡市\",\"coord\":[113.88072263074415,27.47193090553213]},{\"name\":\"台湾省\",\"coord\":[120.14338943402045,23.596002465926095]},{\"name\":\"东莞市\",\"coord\":[113.89443658529342,22.897826158636448]},{\"name\":\"中山市\",\"coord\":[113.37118387764659,22.501478858616522]},{\"name\":\"珠海市\",\"coord\":[113.21799258934986,22.23782602992192]},{\"name\":\"北海市\",\"coord\":[109.18248083043899,21.695773689750148]},{\"name\":\"香港\",\"coord\":[114.20689279508653,22.36016760139811]},{\"name\":\"舟山市\",\"coord\":[122.22514712841459,30.338633120695956]},{\"name\":\"克孜勒苏柯尔克孜\",\"coord\":[74.62910472637343,39.59886016069875]},{\"name\":\"喀什地区\",\"coord\":[77.19899922143753,37.85462871211595]},{\"name\":\"阿克苏地区\",\"coord\":[81.43930290016381,41.067304799230456]},{\"name\":\"和田地区\",\"coord\":[80.69780509160952,36.95287032287055]},{\"name\":\"阿里地区\",\"coord\":[82.536487505389,32.69566569631762]},{\"name\":\"日喀则地区\",\"coord\":[86.5996831353606,29.54861754814263]},{\"name\":\"那曲地区\",\"coord\":[88.32523292667608,33.20600450932715]},{\"name\":\"玉树藏族自治州\",\"coord\":[95.2107128446203,33.90320387919257]},{\"name\":\"迪庆藏族自治州\",\"coord\":[99.42465312188943,28.052797714348895]},{\"name\":\"怒江傈傈族自治州\",\"coord\":[98.85737910439825,26.98345757528851]},{\"name\":\"大理白族自治州\",\"coord\":[99.93934374816013,25.684737357453045]},{\"name\":\"德宏傣族景颇族自\",\"coord\":[98.13830877778075,24.593421919561205]},{\"name\":\"保山市\",\"coord\":[99.19031013453166,24.979380341662]},{\"name\":\"临沧市\",\"coord\":[99.62483778975081,24.058807858948214]},{\"name\":\"普洱市\",\"coord\":[100.94440267992684,23.44121660743221]},{\"name\":\"西双版纳傣族自治\",\"coord\":[100.86105801845994,21.882475641324206]},{\"name\":\"拉萨市\",\"coord\":[91.3684790613129,30.14176592960237]},{\"name\":\"山南地区\",\"coord\":[92.11665242621062,28.33000201578789]},{\"name\":\"林芝地区\",\"coord\":[94.9307847458166,29.125110156601963]},{\"name\":\"昌都地区\",\"coord\":[97.33912235873476,30.48520825551814]},{\"name\":\"丽江市\",\"coord\":[100.65713436205135,26.96190318191959]},{\"name\":\"攀枝花市\",\"coord\":[101.73355913301131,26.714486678752795]},{\"name\":\"凉山彝族自治州\",\"coord\":[102.08678551422615,27.683020519860396]},{\"name\":\"楚雄彝族自治州\",\"coord\":[101.68264761198458,25.369603845264024]},{\"name\":\"红河哈尼族彝族自\",\"coord\":[102.95101719613119,23.624860095239875]},{\"name\":\"文山壮族苗族自治\",\"coord\":[104.8708359910614,23.579587266862504]},{\"name\":\"百色市\",\"coord\":[106.69546907589859,23.98220841166522]},{\"name\":\"崇左市\",\"coord\":[107.3277087317123,22.49769755349952]},{\"name\":\"防城港市\",\"coord\":[107.88939931155171,21.94550204069006]},{\"name\":\"南宁市\",\"coord\":[108.67078983716917,23.12207641861882]},{\"name\":\"钦州市\",\"coord\":[108.8532307305186,22.157690108421384]},{\"name\":\"玉林市\",\"coord\":[110.26918466489103,22.391823643610415]},{\"name\":\"湛江市\",\"coord\":[109.93033457863683,21.086751055633457]},{\"name\":\"茂名市\",\"coord\":[110.80336192333934,22.069184739040775]},{\"name\":\"阳江市\",\"coord\":[111.70471342186183,22.108751366417575]},{\"name\":\"江门市\",\"coord\":[112.53715618649149,22.297368082806777]},{\"name\":\"广州市\",\"coord\":[113.4949302208309,23.28359314707863]},{\"name\":\"清远市\",\"coord\":[113.10957368131268,24.334444053233856]},{\"name\":\"肇庆市\",\"coord\":[112.11117530204233,23.60241158796112]},{\"name\":\"梧州市\",\"coord\":[111.01709510772797,23.518132876753846]},{\"name\":\"贺州市\",\"coord\":[111.50423061842756,24.4095096817199]},{\"name\":\"桂林市\",\"coord\":[110.44046163393094,25.353966673735407]},{\"name\":\"柳州市\",\"coord\":[109.34854449214147,24.972408051485047]},{\"name\":\"河池市\",\"coord\":[107.81191841865586,24.649291651298164]},{\"name\":\"黔东南苗族侗族自\",\"coord\":[108.39952601614591,26.429286420465576]},{\"name\":\"贵阳市\",\"coord\":[106.59784062851153,26.797907456479816]},{\"name\":\"安顺市\",\"coord\":[105.76161265300635,25.988644902171018]},{\"name\":\"黔西南布依族苗族\",\"coord\":[105.5954078788574,25.404850939549405]},{\"name\":\"曲靖市\",\"coord\":[103.9164335632742,25.697243690315265]},{\"name\":\"六盘水市\",\"coord\":[104.77723228072432,26.15402255629164]},{\"name\":\"毕节地区\",\"coord\":[105.03867422931839,27.077913968069666]},{\"name\":\"昭通市\",\"coord\":[104.29730513046874,27.62418247971078]},{\"name\":\"宜宾市\",\"coord\":[104.76748901448207,28.553501804266475]},{\"name\":\"乐山市\",\"coord\":[103.56027669102787,29.160754519210577]},{\"name\":\"自贡市\",\"coord\":[104.63272827056402,29.273152614922402]},{\"name\":\"内江市\",\"coord\":[104.82644562304716,29.61272653799929]},{\"name\":\"遵义市\",\"coord\":[106.82413636302059,28.191847588570702]},{\"name\":\"达州市\",\"coord\":[107.59704170009518,31.32138258839703]},{\"name\":\"遂宁市\",\"coord\":[105.48979445433736,30.677687821242678]},{\"name\":\"广安市\",\"coord\":[106.56708164098042,30.43500706741521]},{\"name\":\"泸州市\",\"coord\":[105.42591761727707,28.50277238478137]},{\"name\":\"资阳市\",\"coord\":[104.97995126874034,30.154251886139654]},{\"name\":\"雅安市\",\"coord\":[102.69931299964517,29.892630706195035]},{\"name\":\"眉山市\",\"coord\":[104.07052881858888,29.894202166560405]},{\"name\":\"甘孜藏族自治州\",\"coord\":[100.50721042614238,30.975216556269658]},{\"name\":\"果洛藏族自治州\",\"coord\":[99.30775565051923,34.03539865224808]},{\"name\":\"海南藏族自治州\",\"coord\":[100.39969108016373,35.90048272566899]},{\"name\":\"黄南藏族自治州\",\"coord\":[101.5360706381689,35.10286360841902]},{\"name\":\"赣南藏族自治州\",\"coord\":[102.97083885806067,34.326752803339026]},{\"name\":\"陇南市\",\"coord\":[105.24780098912132,33.57031117443431]},{\"name\":\"天水市\",\"coord\":[105.53503634660417,34.62320421368087]},{\"name\":\"定西市\",\"coord\":[104.58787768541339,35.08900966621695]},{\"name\":\"临夏回族自治州\",\"coord\":[103.2612870434902,35.591577124455235]},{\"name\":\"西宁市\",\"coord\":[101.57680657999033,36.84800271717157]},{\"name\":\"海东地区\",\"coord\":[102.30909850729282,36.287400615025646]},{\"name\":\"海北藏族自治州\",\"coord\":[100.27122484450717,37.892557516083826]},{\"name\":\"金昌市\",\"coord\":[102.02244049169511,38.497330414886164]},{\"name\":\"酒泉市\",\"coord\":[95.94486678270127,40.56891536586272]},{\"name\":\"海西蒙古族藏族自\",\"coord\":[94.67143298050689,36.022725148503724]},{\"name\":\"巴音郭楞蒙古自治\",\"coord\":[88.18116214759745,39.556478810319916]},{\"name\":\"哈密地区\",\"coord\":[93.84302392518026,42.95015211178875]},{\"name\":\"叶鲁番地区\",\"coord\":[89.82035217277885,42.399368632283505]},{\"name\":\"乌鲁木齐市\",\"coord\":[88.00048109561487,43.549986370786]},{\"name\":\"阿勒泰地区\",\"coord\":[88.11213933257655,47.05593413019629]},{\"name\":\"博尔塔拉蒙古自治\",\"coord\":[82.26402238163408,44.671135542630864]},{\"name\":\"伊犁哈萨克自治州\",\"coord\":[82.80778717477179,43.53783381365267]},{\"name\":\"阿拉善盟\",\"coord\":[103.29923966842289,40.10955801781495]},{\"name\":\"武威市\",\"coord\":[102.73362058791429,37.94211141321436]},{\"name\":\"兰州市\",\"coord\":[103.73793563506032,36.27379827886003]},{\"name\":\"中卫市\",\"coord\":[105.6943786030716,37.20654236148948]},{\"name\":\"银川市\",\"coord\":[106.20022174140034,38.52103167597483]},{\"name\":\"石嘴山市\",\"coord\":[106.41544011793628,38.84054137571417]},{\"name\":\"乌海市\",\"coord\":[106.8984175998405,39.54616572239788]},{\"name\":\"鄂尔多斯市\",\"coord\":[108.43285571424619,39.24036799350715]},{\"name\":\"巴彦淖尔市\",\"coord\":[107.45840392808307,41.30159860424196]},{\"name\":\"包头市\",\"coord\":[110.46472193224272,41.48017783644221]},{\"name\":\"呼和浩特市\",\"coord\":[111.48365173603975,40.498363056149884]},{\"name\":\"乌兰察布市\",\"coord\":[112.61568977597707,41.75789561273154]},{\"name\":\"大同市\",\"coord\":[113.7107192749083,39.898956799744184]},{\"name\":\"朔州市\",\"coord\":[112.65428748167508,39.681772914701924]},{\"name\":\"忻州市\",\"coord\":[112.36127575589583,38.88990233614568]},{\"name\":\"榆林市\",\"coord\":[109.68473112169593,38.19921027134876]},{\"name\":\"延安市\",\"coord\":[109.52425222161318,36.406522726136814]},{\"name\":\"庆阳市\",\"coord\":[107.73052193155061,36.183821532624464]},{\"name\":\"固原市\",\"coord\":[106.20191575442442,36.11634909496382]},{\"name\":\"白银市\",\"coord\":[104.68634478137065,36.51582865625868]},{\"name\":\"宝鸡市\",\"coord\":[107.33534779230747,34.3387216485855]},{\"name\":\"汉中市\",\"coord\":[107.03534754266246,33.00142998064871]},{\"name\":\"广元市\",\"coord\":[105.92928137563939,32.21872447205537]},{\"name\":\"巴中市\",\"coord\":[107.03422410306194,31.99874720836291]},{\"name\":\"南充市\",\"coord\":[106.32964805032347,31.156657700184095]},{\"name\":\"绵阳市\",\"coord\":[104.58949560201106,31.88628780630976]},{\"name\":\"德阳市\",\"coord\":[104.41542984932845,31.110558133718676]},{\"name\":\"成都市\",\"coord\":[103.8852290010473,30.777258040348634]},{\"name\":\"阿坝藏族羌族自治\",\"coord\":[102.26209319552814,32.45725845387284]},{\"name\":\"安康市\",\"coord\":[109.14236501848015,32.77467694678074]},{\"name\":\"十堰市\",\"coord\":[110.39934083416314,32.376209039347906]},{\"name\":\"襄阳市\",\"coord\":[111.97539147094662,31.93399822417465]},{\"name\":\"宜昌市\",\"coord\":[111.22204852395754,30.772457669035354]},{\"name\":\"恩施市\",\"coord\":[109.42158366502872,30.260366574390105]},{\"name\":\"张家界市\",\"coord\":[110.59760006538717,29.330107409240718]},{\"name\":\"吉首市\",\"coord\":[109.72176899848378,28.681903937242495]},{\"name\":\"铜仁地区\",\"coord\":[108.54247523485463,28.11736237519646]},{\"name\":\"重庆市\",\"coord\":[107.86007108564992,30.186253395053196]},{\"name\":\"怀化市\",\"coord\":[109.94325166787243,27.43919084801186]},{\"name\":\"益阳市\",\"coord\":[112.43060358108062,28.75127294553697]},{\"name\":\"娄底市\",\"coord\":[111.41891416951897,27.696312460064604]},{\"name\":\"常德市\",\"coord\":[111.72571610131646,29.27189463838195]},{\"name\":\"荆州市\",\"coord\":[112.65896596965268,30.05161542755362]},{\"name\":\"荆门市\",\"coord\":[112.6586855902184,31.01267124474617]},{\"name\":\"岳阳市\",\"coord\":[113.2595036144316,29.106247116930163]},{\"name\":\"长沙市\",\"coord\":[113.15415586456598,28.222934680488425]},{\"name\":\"湘潭市\",\"coord\":[112.51092596317824,27.69881544105668]},{\"name\":\"株州市\",\"coord\":[113.49665538546823,27.03993794610501]},{\"name\":\"衡阳市\",\"coord\":[112.48849636578527,26.783613569970782]},{\"name\":\"邵阳市\",\"coord\":[110.6723832117475,26.81652287086792]},{\"name\":\"永州市\",\"coord\":[111.8565364154186,25.768488267811968]},{\"name\":\"韶关市\",\"coord\":[113.53420325850979,24.69848878771937]},{\"name\":\"惠州市\",\"coord\":[114.32029589634925,23.25504544231892]},{\"name\":\"佛山市\",\"coord\":[112.95925897403649,23.10116677189257]},{\"name\":\"云浮市\",\"coord\":[111.78042514904234,22.840400494105687]},{\"name\":\"深圳市\",\"coord\":[114.13138648919008,22.649563063468342]},{\"name\":\"汕尾市\",\"coord\":[115.57412892884373,23.06989642104901]},{\"name\":\"河源市\",\"coord\":[114.89746229844398,23.97971937124767]},{\"name\":\"揭阳市\",\"coord\":[116.04290004239446,23.304802704715357]},{\"name\":\"汕头市\",\"coord\":[116.7008461897183,23.35898625947344]},{\"name\":\"潮州市\",\"coord\":[116.75405548481658,23.854381508863064]},{\"name\":\"梅州市\",\"coord\":[116.13719397345734,24.15633544812716]},{\"name\":\"漳州市\",\"coord\":[117.38279760543345,24.41111215459575]},{\"name\":\"厦门市\",\"coord\":[118.04275971554665,24.675908246507944]},{\"name\":\"龙岩市\",\"coord\":[116.69341144552507,25.20284542644492]},{\"name\":\"泉州市\",\"coord\":[118.12035864630246,25.22984144365049]},{\"name\":\"莆田市\",\"coord\":[118.82439690138142,25.439653480972687]},{\"name\":\"福州市\",\"coord\":[119.1608285845262,25.99117532466728]},{\"name\":\"三明市\",\"coord\":[117.51188176216434,26.318292906961602]},{\"name\":\"南平市\",\"coord\":[118.16153136678187,27.306303151805437]},{\"name\":\"抚州市\",\"coord\":[116.3455359885574,27.487043655935366]},{\"name\":\"鹰潭市\",\"coord\":[117.01082360702333,28.241253742969946]},{\"name\":\"吉安市\",\"coord\":[114.91377151807418,26.957486660664525]},{\"name\":\"赣州市\",\"coord\":[115.046455717572,25.81565075681663]},{\"name\":\"郴州市\",\"coord\":[113.1544526703492,25.871927095452524]},{\"name\":\"新余市\",\"coord\":[114.94161795877827,27.79044654578371]},{\"name\":\"宜春市\",\"coord\":[115.04574494880995,28.306428044943356]},{\"name\":\"南昌市\",\"coord\":[115.9963824234495,28.664803351584705]},{\"name\":\"九江市\",\"coord\":[115.53225905704193,29.362905920276297]},{\"name\":\"上饶市\",\"coord\":[117.8595355766598,28.765755150094634]},{\"name\":\"景德镇市\",\"coord\":[117.25387030721845,29.33426823662448]},{\"name\":\"黄山市\",\"coord\":[117.85476357809696,29.969632034273722]},{\"name\":\"池州市\",\"coord\":[117.34517113140791,30.208089337922335]},{\"name\":\"铜陵市\",\"coord\":[117.93160431300694,30.926442655001676]},{\"name\":\"安庆市\",\"coord\":[116.54307680610799,30.524265461641296]},{\"name\":\"黄石市\",\"coord\":[115.02354597728443,29.924060229331015]},{\"name\":\"咸宁市\",\"coord\":[114.26967602231792,29.652174021136048]},{\"name\":\"黄冈市\",\"coord\":[115.2859016705373,30.65856897065683]},{\"name\":\"武汉市\",\"coord\":[114.34552076948799,30.68836237966767]},{\"name\":\"随州市\",\"coord\":[113.3850627838818,31.87891659924412]},{\"name\":\"信阳市\",\"coord\":[114.81374730587638,32.0309685135914]},{\"name\":\"驻马店市\",\"coord\":[114.07756451509235,32.896720987266114]},{\"name\":\"商洛市\",\"coord\":[109.82044421310393,33.77403373563189]},{\"name\":\"西安市\",\"coord\":[109.11839808451401,34.225257215515896]},{\"name\":\"渭南市\",\"coord\":[109.75732444226935,35.025913644359306]},{\"name\":\"铜川市\",\"coord\":[108.98695328111377,35.19235092947735]},{\"name\":\"咸阳市\",\"coord\":[108.36398776446165,34.84311348287181]},{\"name\":\"三门峡市\",\"coord\":[110.80049688104964,34.31818709571671]},{\"name\":\"运城市\",\"coord\":[111.1736679525165,35.19010372283576]},{\"name\":\"洛阳市\",\"coord\":[111.87577573098216,34.33379926109848]},{\"name\":\"平顶山市\",\"coord\":[112.80931281928427,33.759895800153096]},{\"name\":\"漯河市\",\"coord\":[113.83505724178012,33.70034266174508]},{\"name\":\"许昌市\",\"coord\":[113.78762484088509,34.051835688452435]},{\"name\":\"郑州市\",\"coord\":[113.49619951867594,34.61181797865449]},{\"name\":\"焦作市\",\"coord\":[113.13404280173008,35.134167097471625]},{\"name\":\"晋城市\",\"coord\":[112.7495732073233,35.63186423091449]},{\"name\":\"长治市\",\"coord\":[112.85900842873183,36.45872910742828]},{\"name\":\"临汾市\",\"coord\":[111.49379787924448,36.22810800777857]},{\"name\":\"太原市\",\"coord\":[112.15628804033796,37.91704444063036]},{\"name\":\"吕梁市\",\"coord\":[111.31901105774872,37.712740463356496]},{\"name\":\"晋中市\",\"coord\":[113.08199599739676,37.36532613794343]},{\"name\":\"邯郸市\",\"coord\":[114.41824047234618,36.530119932543315]},{\"name\":\"安阳市\",\"coord\":[113.88883283163116,35.7797611183252]},{\"name\":\"鹤壁市\",\"coord\":[114.3654094911545,35.75770487428472]},{\"name\":\"新乡市\",\"coord\":[113.9184107718167,35.348471214026716]},{\"name\":\"开封市\",\"coord\":[114.52801677500626,34.61371216679872]},{\"name\":\"周口市\",\"coord\":[114.88509782391864,33.69999759722657]},{\"name\":\"阜阳市\",\"coord\":[115.44595951398213,32.98060371610532]},{\"name\":\"淮南市\",\"coord\":[116.68941991880993,32.79972275772595]},{\"name\":\"蚌埠市\",\"coord\":[117.38594715783302,33.106729536033896]},{\"name\":\"淮北市\",\"coord\":[116.69651711889378,33.69527529383458]},{\"name\":\"宿州市\",\"coord\":[117.30175405886838,33.943330421260015]},{\"name\":\"亳州市\",\"coord\":[116.12410804185097,33.46769392946132]},{\"name\":\"商丘市\",\"coord\":[115.59575176872548,34.28339840831147]},{\"name\":\"菏泽市\",\"coord\":[115.53631974831816,35.197319393220624]},{\"name\":\"濮阳市\",\"coord\":[115.3070485514902,35.775883510964334]},{\"name\":\"聊城市\",\"coord\":[115.8870069012884,36.40529594548765]},{\"name\":\"邢台市\",\"coord\":[114.74259008644859,37.251396750084155]},{\"name\":\"石家庄市\",\"coord\":[114.56923838363613,38.13141710980106]},{\"name\":\"阳泉市\",\"coord\":[113.39216149668508,38.09075470547468]},{\"name\":\"保定市\",\"coord\":[115.261524468934,39.09118520781398]},{\"name\":\"衡水市\",\"coord\":[115.8182936677897,37.715661598187154]},{\"name\":\"德州市\",\"coord\":[116.4582273790399,37.19372347888644]},{\"name\":\"沧州市\",\"coord\":[116.76192710911863,38.20240042039232]},{\"name\":\"廊坊市\",\"coord\":[116.50410772133856,39.27896741763884]},{\"name\":\"天津市\",\"coord\":[117.31988934444873,39.37154482470619]},{\"name\":\"北京市\",\"coord\":[116.59734730757869,40.237112944270976]},{\"name\":\"张家口市\",\"coord\":[115.1823606483226,40.83732566607167]},{\"name\":\"唐山市\",\"coord\":[117.8693184261954,39.71862889477249]},{\"name\":\"秦皇岛市\",\"coord\":[119.30467355367742,39.990574652162564]},{\"name\":\"承德市\",\"coord\":[117.16275671911026,41.36623845548547]},{\"name\":\"葫芦岛市\",\"coord\":[119.9342336210531,40.5628822626519]},{\"name\":\"朝阳市\",\"coord\":[120.11853493535794,41.471852354885755]},{\"name\":\"赤峰市\",\"coord\":[118.50943546234379,43.25452976059767]},{\"name\":\"锦州市\",\"coord\":[121.5167549323861,41.45933087433065]},{\"name\":\"营口市\",\"coord\":[122.58571915054674,40.42093503997384]},{\"name\":\"丹东市\",\"coord\":[124.33549382902183,40.46369290272115]},{\"name\":\"辽阳市\",\"coord\":[123.34064798039414,41.152331397771356]},{\"name\":\"盘锦市\",\"coord\":[122.06718005354679,41.05573599862555]},{\"name\":\"阜新市\",\"coord\":[121.93889757908204,42.27641773244204]},{\"name\":\"鞍山市\",\"coord\":[122.78904432242356,40.77781183142038]},{\"name\":\"沈阳市\",\"coord\":[122.99508899709724,42.1162195010079]},{\"name\":\"铁岭市\",\"coord\":[124.23100515588399,42.72666083611828]},{\"name\":\"扶顺市\",\"coord\":[124.46027188217573,41.82955407638859]},{\"name\":\"通辽市\",\"coord\":[122.0729370657937,43.90889130864869]},{\"name\":\"兴安盟\",\"coord\":[120.79456431092532,45.92003249442161]},{\"name\":\"白城市\",\"coord\":[123.10619907715235,45.25475749267784]},{\"name\":\"齐齐哈尔市\",\"coord\":[124.5462214659102,47.55395009317394]},{\"name\":\"大兴安岭地区\",\"coord\":[124.50992855161529,52.18438447846694]},{\"name\":\"黑河市\",\"coord\":[127.14721400335922,49.25080134026901]},{\"name\":\"大庆市\",\"coord\":[124.40329830095243,46.401048760966745]},{\"name\":\"绥化市\",\"coord\":[126.5214484055605,46.76992452194825]},{\"name\":\"松原市\",\"coord\":[124.21244334807682,44.75779381338502]},{\"name\":\"四平市\",\"coord\":[124.27839350328821,43.52139065090318]},{\"name\":\"通化市\",\"coord\":[125.67392830706305,41.91771808663852]},{\"name\":\"辽源市\",\"coord\":[125.33529527643432,42.758340204944986]},{\"name\":\"吉林市\",\"coord\":[126.83350281902375,43.60730120049175]},{\"name\":\"长春市\",\"coord\":[125.53597875970374,44.24624314701737]},{\"name\":\"白山市\",\"coord\":[127.16780160322108,42.093893880305075]},{\"name\":\"哈尔滨市\",\"coord\":[127.39125008786029,45.36200668820575]},{\"name\":\"鹤岗市\",\"coord\":[130.4703811258197,47.66520688940109]},{\"name\":\"伊春市\",\"coord\":[128.91240831703635,47.93833794565277]},{\"name\":\"七台河市\",\"coord\":[131.2677920224311,45.945099776108584]},{\"name\":\"鸡西市\",\"coord\":[132.38059153660274,45.722934218318535]},{\"name\":\"双鸭山市\",\"coord\":[132.3184817002743,46.65813679030265]},{\"name\":\"佳木斯市\",\"coord\":[132.26174446608726,47.17569713691394]},{\"name\":\"呼伦贝尔市\",\"coord\":[122.3210739998419,50.18176996070858]},{\"name\":\"孝感市\",\"coord\":[113.83749892135485,31.11757234692128]},{\"name\":\"贵港市\",\"coord\":[110.07354588052804,23.380735604767374]},{\"name\":\"黔南布依族苗族自\",\"coord\":[107.30931767543106,26.2976919432269]},{\"name\":\"宁德市\",\"coord\":[119.52482556634342,27.013151692716413]},{\"name\":\"温州市\",\"coord\":[120.30037042732202,27.8699145504001]},{\"name\":\"台州市\",\"coord\":[120.88886782713843,28.670799172772313]},{\"name\":\"丽水市\",\"coord\":[119.56796851966463,28.170268394477755]},{\"name\":\"衢州市\",\"coord\":[118.79479802644406,28.865874397158763]},{\"name\":\"金华市\",\"coord\":[119.99381920686633,29.093455548185744]},{\"name\":\"绍兴市\",\"coord\":[120.46546691682343,29.69382513836818]},{\"name\":\"宁波市\",\"coord\":[121.42142987830871,29.70001162878972]},{\"name\":\"杭州市\",\"coord\":[119.4405685790891,29.87218307296989]},{\"name\":\"宣城市\",\"coord\":[118.68748382914703,30.628143499626418]},{\"name\":\"湖州市\",\"coord\":[119.98261306633574,30.7945175862809]},{\"name\":\"嘉兴市\",\"coord\":[120.83889215988998,30.67538495499343]},{\"name\":\"上海市\",\"coord\":[121.37534147322967,31.25628247908459]},{\"name\":\"苏州市\",\"coord\":[120.6906182622391,31.381280695137775]},{\"name\":\"无锡市\",\"coord\":[120.32182300914366,31.54113306724517]},{\"name\":\"常州市\",\"coord\":[119.61953292830165,31.611878565375576]},{\"name\":\"南京市\",\"coord\":[118.71890548838064,31.910863187910323]},{\"name\":\"镇江市\",\"coord\":[119.42349332902813,31.97942313430778]},{\"name\":\"合肥市\",\"coord\":[117.30651975617157,31.79407863049138]},{\"name\":\"六安市\",\"coord\":[116.24668220575353,31.820846193819513]},{\"name\":\"滁州市\",\"coord\":[117.88422385307969,32.51792621904418]},{\"name\":\"泰州市\",\"coord\":[120.03124303305091,32.56503102346783]},{\"name\":\"南通市\",\"coord\":[120.85599446760912,32.18496706099728]},{\"name\":\"盐城市\",\"coord\":[120.01812490612667,33.54219948734023]},{\"name\":\"淮安市\",\"coord\":[119.0749424205415,33.39203631772854]},{\"name\":\"宿迁市\",\"coord\":[118.45404943216346,33.666258719120265]},{\"name\":\"徐州市\",\"coord\":[117.77482249295966,34.30847766157078]},{\"name\":\"济宁市\",\"coord\":[116.74147276546373,35.27488504351119]},{\"name\":\"枣庄市\",\"coord\":[117.43359942491492,34.884162021736]},{\"name\":\"连云港市\",\"coord\":[119.01553213785074,34.54316517587849]},{\"name\":\"临沂市\",\"coord\":[118.31478835349617,35.28173079028279]},{\"name\":\"日照市\",\"coord\":[119.14265350444272,35.54479073199592]},{\"name\":\"青岛市\",\"coord\":[120.27779044405756,36.3464117375903]},{\"name\":\"威海市\",\"coord\":[122.12963327195605,37.13879077904251]},{\"name\":\"烟台市\",\"coord\":[120.7689567423966,37.19772002195597]},{\"name\":\"潍坊市\",\"coord\":[119.02178548592039,36.49292234053931]},{\"name\":\"淄博市\",\"coord\":[117.92936024367185,36.60871347163638]},{\"name\":\"泰安市\",\"coord\":[116.93810893944303,36.0423330118612]},{\"name\":\"济南市\",\"coord\":[117.34560282551296,36.769574973846304]},{\"name\":\"东营市\",\"coord\":[118.4915054457184,37.52194690335787]},{\"name\":\"滨州市\",\"coord\":[117.67610299757533,37.4439597758601]},{\"name\":\"昆明市\",\"coord\":[102.93100245594789,25.481300763922075]},{\"name\":\"玉溪市\",\"coord\":[102.23080854291823,24.156168324611663]},{\"name\":\"塔城地区\",\"coord\":[83.60908162840168,45.3721852373893]},{\"name\":\"张掖市\",\"coord\":[100.47710030600572,38.704239320458385]},{\"name\":\"南阳市\",\"coord\":[112.1400670951149,33.03033276715801]},{\"name\":\"扬州市\",\"coord\":[119.48949608990988,32.80956776339646]},{\"name\":\"延边朝鲜族自治州\",\"coord\":[129.3577692895626,43.24968794080283]},{\"name\":\"牡丹江市\",\"coord\":[129.87240796405672,44.7073040108322]},{\"name\":\"澳门\",\"coord\":[113.56289691515346,22.14602596262204]},{\"name\":\"吴忠市\",\"coord\":[106.76894508116403,37.72566765880316]},{\"name\":\"来宾市\",\"coord\":[109.25592217010114,23.86346274681084]},{\"name\":\"平凉市\",\"coord\":[107.0708132782897,35.30329631658711]},{\"name\":\"马鞍山市\",\"coord\":[118.27245878467022,31.657727937739004]},{\"name\":\"芜湖市\",\"coord\":[118.32992684415504,31.081688223101658]},{\"name\":\"澄迈县\",\"coord\":[110.04198076060266,19.694955078668105]},{\"name\":\"保亭黎族苗族自治\",\"coord\":[109.6055304964257,18.6101488675304]},{\"name\":\"乐东黎族自治县\",\"coord\":[109.04051999525574,18.643137437909203]},{\"name\":\"儋州市\",\"coord\":[109.3431358337404,19.550974957403195]},{\"name\":\"定安县\",\"coord\":[110.38744429685676,19.47557074114284]},{\"name\":\"屯昌县\",\"coord\":[110.00574767630334,19.367175093044388]},{\"name\":\"白沙黎族自治县\",\"coord\":[109.36860737761768,19.214416393082217]},{\"name\":\"琼中黎族苗族自治\",\"coord\":[109.86691465937548,19.073671135862682]},{\"name\":\"东方市\",\"coord\":[108.86903802405428,19.017352815445214]},{\"name\":\"昌江黎族自治县\",\"coord\":[108.9686431884767,19.182594167127824]},{\"name\":\"海口市\",\"coord\":[110.420654296875,19.806565564640795]},{\"name\":\"济源市\",\"coord\":[112.38051465474433,35.07958362422394]},{\"name\":\"五指山市\",\"coord\":[109.53595187364496,18.832908264613966]},{\"name\":\"大连市\",\"coord\":[121.96662235866603,39.444150542439914]},{\"name\":\"文昌市三沙市\",\"coord\":[110.81828537536748,19.756501444162936]},{\"name\":\"三亚市\",\"coord\":[109.38424600793707,18.39186315877128]},{\"name\":\"万宁市\",\"coord\":[110.28485046979574,18.860240588635115]},{\"name\":\"陵水黎族自治县\",\"coord\":[109.95577603229562,18.594712684620465]},{\"name\":\"临高县\",\"coord\":[109.71915395436967,19.79420403032508]},{\"name\":\"琼海市\",\"coord\":[110.41650700703043,19.22315873149372]}]");

/***/ }),

/***/ "QmiY":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__("TqRt");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _vueCountTo = _interopRequireDefault(__webpack_require__("7BsA"));

var _util = __webpack_require__("e7LN");

//
//
//
//
//
//
//
//
//
//
//
//
//
var _default2 = {
  name: 'SmCountTo',
  extends: _vueCountTo.default,
  props: {
    fontSize: {
      type: [String, Number]
    },
    numBackground: {
      type: Object,
      default: function _default() {
        return {
          color: 'rgba(0, 0, 0, 0)',
          image: ''
        };
      }
    },
    numSpacing: {
      type: Number,
      default: 0
    },
    separatorBackground: {
      type: Boolean,
      default: false
    }
  },
  computed: {
    calNumBackground: function calNumBackground() {
      var _this = this;

      return function (value) {
        if (!_this.numBackground) {
          return {};
        }

        if (value && !_this.separatorBackground && (value === _this.separator || value === _this.decimal)) {
          return {};
        }

        var reg = /\d+(\.\d+)?([a-z]+)/gi;
        var fontUnit = _this.fontSize ? _this.fontSize.replace(reg, '$2') : '';
        var styleObj = {
          backgroundColor: _this.numBackground.color
        };

        if (_this.numBackground.image) {
          styleObj = Object.assign(styleObj, {
            backgroundImage: "url(".concat(_this.numBackground.image, ")"),
            backgroundSize: '100% 100%'
          });
        }

        if (_this.numBackground.image || !(0, _util.isTransparent)(_this.numBackground.color)) {
          styleObj = Object.assign(styleObj, {
            textIndent: "".concat(parseFloat(_this.fontSize) * 0.16).concat(fontUnit),
            letterSpacing: "".concat(parseFloat(_this.fontSize) * 0.16).concat(fontUnit)
          });
        } else {
          styleObj = Object.assign(styleObj, {
            textIndent: "".concat(parseFloat(_this.fontSize) * 0.06).concat(fontUnit),
            letterSpacing: "".concat(parseFloat(_this.fontSize) * 0.06).concat(fontUnit)
          });
        }

        return styleObj;
      };
    },
    numInterval: function numInterval() {
      return {
        marginRight: "".concat(this.numSpacing, "px")
      };
    },
    numStyle: function numStyle() {
      return {
        fontSize: this.fontSize
      };
    },
    numDataList: function numDataList() {
      return this.displayValue.split('').map(function (num) {
        return num;
      });
    }
  },
  watch: {
    separator: function separator() {
      this.start();
    },
    decimals: function decimals() {
      this.start();
    }
  }
};
exports.default = _default2;

/***/ }),

/***/ "Qp06":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__("TqRt");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _classCallCheck2 = _interopRequireDefault(__webpack_require__("lwsE"));

var _lang = __webpack_require__("DSM6");

var RestMapParameter = function RestMapParameter(options) {
  (0, _classCallCheck2.default)(this, RestMapParameter);
  this.type = 'iServer';
  this.url = options.url;
  this.layerName = options.layerName;
  this.attributeFilter = options.attributeFilter || null;
  this.maxFeatures = options.maxFeatures || 20;
  this.name = options.name || (0, _lang.geti18n)().t('commontypes.restMap');
  this.proxy = options.proxy;
};

exports.default = RestMapParameter;

/***/ }),

/***/ "QpuX":
/***/ (function(module, exports, __webpack_require__) {

module.exports = __webpack_require__("+qE3").EventEmitter;


/***/ }),

/***/ "Qu5F":
/***/ (function(module, exports) {

/*
    StackBlur - a fast almost Gaussian Blur For Canvas

    Version:     0.5
    Author:        Mario Klingemann
    Contact:     mario@quasimondo.com
    Website:    http://www.quasimondo.com/StackBlurForCanvas
    Twitter:    @quasimondo

    In case you find this class useful - especially in commercial projects -
    I am not totally unhappy for a small donation to my PayPal account
    mario@quasimondo.de

    Or support me on flattr:
    https://flattr.com/thing/72791/StackBlur-a-fast-almost-Gaussian-Blur-Effect-for-CanvasJavascript

    Copyright (c) 2010 Mario Klingemann

    Permission is hereby granted, free of charge, to any person
    obtaining a copy of this software and associated documentation
    files (the "Software"), to deal in the Software without
    restriction, including without limitation the rights to use,
    copy, modify, merge, publish, distribute, sublicense, and/or sell
    copies of the Software, and to permit persons to whom the
    Software is furnished to do so, subject to the following
    conditions:

    The above copyright notice and this permission notice shall be
    included in all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
    EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
    OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
    NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
    HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
    WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
    FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
    OTHER DEALINGS IN THE SOFTWARE.
    */


var mul_table = [
    512,512,456,512,328,456,335,512,405,328,271,456,388,335,292,512,
    454,405,364,328,298,271,496,456,420,388,360,335,312,292,273,512,
    482,454,428,405,383,364,345,328,312,298,284,271,259,496,475,456,
    437,420,404,388,374,360,347,335,323,312,302,292,282,273,265,512,
    497,482,468,454,441,428,417,405,394,383,373,364,354,345,337,328,
    320,312,305,298,291,284,278,271,265,259,507,496,485,475,465,456,
    446,437,428,420,412,404,396,388,381,374,367,360,354,347,341,335,
    329,323,318,312,307,302,297,292,287,282,278,273,269,265,261,512,
    505,497,489,482,475,468,461,454,447,441,435,428,422,417,411,405,
    399,394,389,383,378,373,368,364,359,354,350,345,341,337,332,328,
    324,320,316,312,309,305,301,298,294,291,287,284,281,278,274,271,
    268,265,262,259,257,507,501,496,491,485,480,475,470,465,460,456,
    451,446,442,437,433,428,424,420,416,412,408,404,400,396,392,388,
    385,381,377,374,370,367,363,360,357,354,350,347,344,341,338,335,
    332,329,326,323,320,318,315,312,310,307,304,302,299,297,294,292,
    289,287,285,282,280,278,275,273,271,269,267,265,263,261,259];


var shg_table = [
    9, 11, 12, 13, 13, 14, 14, 15, 15, 15, 15, 16, 16, 16, 16, 17,
    17, 17, 17, 17, 17, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18, 19,
    19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 20, 20, 20,
    20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 21,
    21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
    21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 23,
    23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23,
    23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23,
    23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23,
    23, 23, 23, 23, 23, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24,
    24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24,
    24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24,
    24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24,
    24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24 ];


function processImage(img, canvas, radius, blurAlphaChannel)
{
    if (typeof(img) == 'string') {
        var img = document.getElementById(img);
    }
    else if (typeof HTMLImageElement !== 'undefined' && !img instanceof HTMLImageElement) {
        return;
    }
    var w = img.naturalWidth;
    var h = img.naturalHeight;

    if (typeof(canvas) == 'string') {
        var canvas = document.getElementById(canvas);
    }
    else if (typeof HTMLCanvasElement !== 'undefined' && !canvas instanceof HTMLCanvasElement) {
        return;
    }

    canvas.style.width  = w + 'px';
    canvas.style.height = h + 'px';
    canvas.width = w;
    canvas.height = h;

    var context = canvas.getContext('2d');
    context.clearRect(0, 0, w, h);
    context.drawImage(img, 0, 0);

    if (isNaN(radius) || radius < 1) return;

    if (blurAlphaChannel)
        processCanvasRGBA(canvas, 0, 0, w, h, radius);
    else
        processCanvasRGB(canvas, 0, 0, w, h, radius);
}

function getImageDataFromCanvas(canvas, top_x, top_y, width, height)
{
    if (typeof(canvas) == 'string')
        var canvas  = document.getElementById(canvas);
    else if (typeof HTMLCanvasElement !== 'undefined' && !canvas instanceof HTMLCanvasElement)
        return;

    var context = canvas.getContext('2d');
    var imageData;

    try {
        try {
            imageData = context.getImageData(top_x, top_y, width, height);
        } catch(e) {
            throw new Error("unable to access local image data: " + e);
            return;
        }
    } catch(e) {
        throw new Error("unable to access image data: " + e);
    }

    return imageData;
}

function processCanvasRGBA(canvas, top_x, top_y, width, height, radius)
{
    if (isNaN(radius) || radius < 1) return;
    radius |= 0;

    var imageData = getImageDataFromCanvas(canvas, top_x, top_y, width, height);

    imageData = processImageDataRGBA(imageData, top_x, top_y, width, height, radius);

    canvas.getContext('2d').putImageData(imageData, top_x, top_y);
}

function processImageDataRGBA(imageData, top_x, top_y, width, height, radius)
{
    var pixels = imageData.data;

    var x, y, i, p, yp, yi, yw, r_sum, g_sum, b_sum, a_sum,
        r_out_sum, g_out_sum, b_out_sum, a_out_sum,
        r_in_sum, g_in_sum, b_in_sum, a_in_sum,
        pr, pg, pb, pa, rbs;

    var div = radius + radius + 1;
    var w4 = width << 2;
    var widthMinus1  = width - 1;
    var heightMinus1 = height - 1;
    var radiusPlus1  = radius + 1;
    var sumFactor = radiusPlus1 * (radiusPlus1 + 1) / 2;

    var stackStart = new BlurStack();
    var stack = stackStart;
    for (i = 1; i < div; i++)
    {
        stack = stack.next = new BlurStack();
        if (i == radiusPlus1) var stackEnd = stack;
    }
    stack.next = stackStart;
    var stackIn = null;
    var stackOut = null;

    yw = yi = 0;

    var mul_sum = mul_table[radius];
    var shg_sum = shg_table[radius];

    for (y = 0; y < height; y++)
    {
        r_in_sum = g_in_sum = b_in_sum = a_in_sum = r_sum = g_sum = b_sum = a_sum = 0;

        r_out_sum = radiusPlus1 * (pr = pixels[yi]);
        g_out_sum = radiusPlus1 * (pg = pixels[yi+1]);
        b_out_sum = radiusPlus1 * (pb = pixels[yi+2]);
        a_out_sum = radiusPlus1 * (pa = pixels[yi+3]);

        r_sum += sumFactor * pr;
        g_sum += sumFactor * pg;
        b_sum += sumFactor * pb;
        a_sum += sumFactor * pa;

        stack = stackStart;

        for (i = 0; i < radiusPlus1; i++)
        {
            stack.r = pr;
            stack.g = pg;
            stack.b = pb;
            stack.a = pa;
            stack = stack.next;
        }

        for (i = 1; i < radiusPlus1; i++)
        {
            p = yi + ((widthMinus1 < i ? widthMinus1 : i) << 2);
            r_sum += (stack.r = (pr = pixels[p])) * (rbs = radiusPlus1 - i);
            g_sum += (stack.g = (pg = pixels[p+1])) * rbs;
            b_sum += (stack.b = (pb = pixels[p+2])) * rbs;
            a_sum += (stack.a = (pa = pixels[p+3])) * rbs;

            r_in_sum += pr;
            g_in_sum += pg;
            b_in_sum += pb;
            a_in_sum += pa;

            stack = stack.next;
        }


        stackIn = stackStart;
        stackOut = stackEnd;
        for (x = 0; x < width; x++)
        {
            pixels[yi+3] = pa = (a_sum * mul_sum) >> shg_sum;
            if (pa != 0)
            {
                pa = 255 / pa;
                pixels[yi]   = ((r_sum * mul_sum) >> shg_sum) * pa;
                pixels[yi+1] = ((g_sum * mul_sum) >> shg_sum) * pa;
                pixels[yi+2] = ((b_sum * mul_sum) >> shg_sum) * pa;
            } else {
                pixels[yi] = pixels[yi+1] = pixels[yi+2] = 0;
            }

            r_sum -= r_out_sum;
            g_sum -= g_out_sum;
            b_sum -= b_out_sum;
            a_sum -= a_out_sum;

            r_out_sum -= stackIn.r;
            g_out_sum -= stackIn.g;
            b_out_sum -= stackIn.b;
            a_out_sum -= stackIn.a;

            p =  (yw + ((p = x + radius + 1) < widthMinus1 ? p : widthMinus1)) << 2;

            r_in_sum += (stackIn.r = pixels[p]);
            g_in_sum += (stackIn.g = pixels[p+1]);
            b_in_sum += (stackIn.b = pixels[p+2]);
            a_in_sum += (stackIn.a = pixels[p+3]);

            r_sum += r_in_sum;
            g_sum += g_in_sum;
            b_sum += b_in_sum;
            a_sum += a_in_sum;

            stackIn = stackIn.next;

            r_out_sum += (pr = stackOut.r);
            g_out_sum += (pg = stackOut.g);
            b_out_sum += (pb = stackOut.b);
            a_out_sum += (pa = stackOut.a);

            r_in_sum -= pr;
            g_in_sum -= pg;
            b_in_sum -= pb;
            a_in_sum -= pa;

            stackOut = stackOut.next;

            yi += 4;
        }
        yw += width;
    }


    for (x = 0; x < width; x++)
    {
        g_in_sum = b_in_sum = a_in_sum = r_in_sum = g_sum = b_sum = a_sum = r_sum = 0;

        yi = x << 2;
        r_out_sum = radiusPlus1 * (pr = pixels[yi]);
        g_out_sum = radiusPlus1 * (pg = pixels[yi+1]);
        b_out_sum = radiusPlus1 * (pb = pixels[yi+2]);
        a_out_sum = radiusPlus1 * (pa = pixels[yi+3]);

        r_sum += sumFactor * pr;
        g_sum += sumFactor * pg;
        b_sum += sumFactor * pb;
        a_sum += sumFactor * pa;

        stack = stackStart;

        for (i = 0; i < radiusPlus1; i++)
        {
            stack.r = pr;
            stack.g = pg;
            stack.b = pb;
            stack.a = pa;
            stack = stack.next;
        }

        yp = width;

        for (i = 1; i <= radius; i++)
        {
            yi = (yp + x) << 2;

            r_sum += (stack.r = (pr = pixels[yi])) * (rbs = radiusPlus1 - i);
            g_sum += (stack.g = (pg = pixels[yi+1])) * rbs;
            b_sum += (stack.b = (pb = pixels[yi+2])) * rbs;
            a_sum += (stack.a = (pa = pixels[yi+3])) * rbs;

            r_in_sum += pr;
            g_in_sum += pg;
            b_in_sum += pb;
            a_in_sum += pa;

            stack = stack.next;

            if(i < heightMinus1)
            {
                yp += width;
            }
        }

        yi = x;
        stackIn = stackStart;
        stackOut = stackEnd;
        for (y = 0; y < height; y++)
        {
            p = yi << 2;
            pixels[p+3] = pa = (a_sum * mul_sum) >> shg_sum;
            if (pa > 0)
            {
                pa = 255 / pa;
                pixels[p]   = ((r_sum * mul_sum) >> shg_sum) * pa;
                pixels[p+1] = ((g_sum * mul_sum) >> shg_sum) * pa;
                pixels[p+2] = ((b_sum * mul_sum) >> shg_sum) * pa;
            } else {
                pixels[p] = pixels[p+1] = pixels[p+2] = 0;
            }

            r_sum -= r_out_sum;
            g_sum -= g_out_sum;
            b_sum -= b_out_sum;
            a_sum -= a_out_sum;

            r_out_sum -= stackIn.r;
            g_out_sum -= stackIn.g;
            b_out_sum -= stackIn.b;
            a_out_sum -= stackIn.a;

            p = (x + (((p = y + radiusPlus1) < heightMinus1 ? p : heightMinus1) * width)) << 2;

            r_sum += (r_in_sum += (stackIn.r = pixels[p]));
            g_sum += (g_in_sum += (stackIn.g = pixels[p+1]));
            b_sum += (b_in_sum += (stackIn.b = pixels[p+2]));
            a_sum += (a_in_sum += (stackIn.a = pixels[p+3]));

            stackIn = stackIn.next;

            r_out_sum += (pr = stackOut.r);
            g_out_sum += (pg = stackOut.g);
            b_out_sum += (pb = stackOut.b);
            a_out_sum += (pa = stackOut.a);

            r_in_sum -= pr;
            g_in_sum -= pg;
            b_in_sum -= pb;
            a_in_sum -= pa;

            stackOut = stackOut.next;

            yi += width;
        }
    }
    return imageData;
}

function processCanvasRGB(canvas, top_x, top_y, width, height, radius)
{
    if (isNaN(radius) || radius < 1) return;
    radius |= 0;

    var imageData = getImageDataFromCanvas(canvas, top_x, top_y, width, height);
    imageData = processImageDataRGB(imageData, top_x, top_y, width, height, radius);

    canvas.getContext('2d').putImageData(imageData, top_x, top_y);
}

function processImageDataRGB(imageData, top_x, top_y, width, height, radius)
{
    var pixels = imageData.data;

    var x, y, i, p, yp, yi, yw, r_sum, g_sum, b_sum,
        r_out_sum, g_out_sum, b_out_sum,
        r_in_sum, g_in_sum, b_in_sum,
        pr, pg, pb, rbs;

    var div = radius + radius + 1;
    var w4 = width << 2;
    var widthMinus1  = width - 1;
    var heightMinus1 = height - 1;
    var radiusPlus1  = radius + 1;
    var sumFactor = radiusPlus1 * (radiusPlus1 + 1) / 2;

    var stackStart = new BlurStack();
    var stack = stackStart;
    for (i = 1; i < div; i++)
    {
        stack = stack.next = new BlurStack();
        if (i == radiusPlus1) var stackEnd = stack;
    }
    stack.next = stackStart;
    var stackIn = null;
    var stackOut = null;

    yw = yi = 0;

    var mul_sum = mul_table[radius];
    var shg_sum = shg_table[radius];

    for (y = 0; y < height; y++)
    {
        r_in_sum = g_in_sum = b_in_sum = r_sum = g_sum = b_sum = 0;

        r_out_sum = radiusPlus1 * (pr = pixels[yi]);
        g_out_sum = radiusPlus1 * (pg = pixels[yi+1]);
        b_out_sum = radiusPlus1 * (pb = pixels[yi+2]);

        r_sum += sumFactor * pr;
        g_sum += sumFactor * pg;
        b_sum += sumFactor * pb;

        stack = stackStart;

        for (i = 0; i < radiusPlus1; i++)
        {
            stack.r = pr;
            stack.g = pg;
            stack.b = pb;
            stack = stack.next;
        }

        for (i = 1; i < radiusPlus1; i++)
        {
            p = yi + ((widthMinus1 < i ? widthMinus1 : i) << 2);
            r_sum += (stack.r = (pr = pixels[p])) * (rbs = radiusPlus1 - i);
            g_sum += (stack.g = (pg = pixels[p+1])) * rbs;
            b_sum += (stack.b = (pb = pixels[p+2])) * rbs;

            r_in_sum += pr;
            g_in_sum += pg;
            b_in_sum += pb;

            stack = stack.next;
        }


        stackIn = stackStart;
        stackOut = stackEnd;
        for (x = 0; x < width; x++)
        {
            pixels[yi]   = (r_sum * mul_sum) >> shg_sum;
            pixels[yi+1] = (g_sum * mul_sum) >> shg_sum;
            pixels[yi+2] = (b_sum * mul_sum) >> shg_sum;

            r_sum -= r_out_sum;
            g_sum -= g_out_sum;
            b_sum -= b_out_sum;

            r_out_sum -= stackIn.r;
            g_out_sum -= stackIn.g;
            b_out_sum -= stackIn.b;

            p =  (yw + ((p = x + radius + 1) < widthMinus1 ? p : widthMinus1)) << 2;

            r_in_sum += (stackIn.r = pixels[p]);
            g_in_sum += (stackIn.g = pixels[p+1]);
            b_in_sum += (stackIn.b = pixels[p+2]);

            r_sum += r_in_sum;
            g_sum += g_in_sum;
            b_sum += b_in_sum;

            stackIn = stackIn.next;

            r_out_sum += (pr = stackOut.r);
            g_out_sum += (pg = stackOut.g);
            b_out_sum += (pb = stackOut.b);

            r_in_sum -= pr;
            g_in_sum -= pg;
            b_in_sum -= pb;

            stackOut = stackOut.next;

            yi += 4;
        }
        yw += width;
    }


    for (x = 0; x < width; x++)
    {
        g_in_sum = b_in_sum = r_in_sum = g_sum = b_sum = r_sum = 0;

        yi = x << 2;
        r_out_sum = radiusPlus1 * (pr = pixels[yi]);
        g_out_sum = radiusPlus1 * (pg = pixels[yi+1]);
        b_out_sum = radiusPlus1 * (pb = pixels[yi+2]);

        r_sum += sumFactor * pr;
        g_sum += sumFactor * pg;
        b_sum += sumFactor * pb;

        stack = stackStart;

        for (i = 0; i < radiusPlus1; i++)
        {
            stack.r = pr;
            stack.g = pg;
            stack.b = pb;
            stack = stack.next;
        }

        yp = width;

        for (i = 1; i <= radius; i++)
        {
            yi = (yp + x) << 2;

            r_sum += (stack.r = (pr = pixels[yi])) * (rbs = radiusPlus1 - i);
            g_sum += (stack.g = (pg = pixels[yi+1])) * rbs;
            b_sum += (stack.b = (pb = pixels[yi+2])) * rbs;

            r_in_sum += pr;
            g_in_sum += pg;
            b_in_sum += pb;

            stack = stack.next;

            if(i < heightMinus1)
            {
                yp += width;
            }
        }

        yi = x;
        stackIn = stackStart;
        stackOut = stackEnd;
        for (y = 0; y < height; y++)
        {
            p = yi << 2;
            pixels[p]   = (r_sum * mul_sum) >> shg_sum;
            pixels[p+1] = (g_sum * mul_sum) >> shg_sum;
            pixels[p+2] = (b_sum * mul_sum) >> shg_sum;

            r_sum -= r_out_sum;
            g_sum -= g_out_sum;
            b_sum -= b_out_sum;

            r_out_sum -= stackIn.r;
            g_out_sum -= stackIn.g;
            b_out_sum -= stackIn.b;

            p = (x + (((p = y + radiusPlus1) < heightMinus1 ? p : heightMinus1) * width)) << 2;

            r_sum += (r_in_sum += (stackIn.r = pixels[p]));
            g_sum += (g_in_sum += (stackIn.g = pixels[p+1]));
            b_sum += (b_in_sum += (stackIn.b = pixels[p+2]));

            stackIn = stackIn.next;

            r_out_sum += (pr = stackOut.r);
            g_out_sum += (pg = stackOut.g);
            b_out_sum += (pb = stackOut.b);

            r_in_sum -= pr;
            g_in_sum -= pg;
            b_in_sum -= pb;

            stackOut = stackOut.next;

            yi += width;
        }
    }

    return imageData;
}

function BlurStack()
{
    this.r = 0;
    this.g = 0;
    this.b = 0;
    this.a = 0;
    this.next = null;
}

module.exports = {
    image: processImage,
    canvasRGBA: processCanvasRGBA,
    canvasRGB: processCanvasRGB,
    imageDataRGBA: processImageDataRGBA,
    imageDataRGB: processImageDataRGB
};


/***/ }),

/***/ "R7NE":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _ChartMixin_vue_vue_type_template_id_0d0e6a6e___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("ZgnL");
/* harmony import */ var _ChartMixin_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("6sEm");
/* harmony reexport (unknown) */ for(var __WEBPACK_IMPORT_KEY__ in _ChartMixin_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_1__) if(__WEBPACK_IMPORT_KEY__ !== 'default') (function(key) { __webpack_require__.d(__webpack_exports__, key, function() { return _ChartMixin_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_1__[key]; }) }(__WEBPACK_IMPORT_KEY__));
/* harmony import */ var _node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("KHd+");





/* normalize component */

var component = Object(_node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_2__[/* default */ "a"])(
  _ChartMixin_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_1__["default"],
  _ChartMixin_vue_vue_type_template_id_0d0e6a6e___WEBPACK_IMPORTED_MODULE_0__[/* render */ "a"],
  _ChartMixin_vue_vue_type_template_id_0d0e6a6e___WEBPACK_IMPORTED_MODULE_0__[/* staticRenderFns */ "b"],
  false,
  null,
  null,
  null
  
)

/* harmony default export */ __webpack_exports__["default"] = (component.exports);

/***/ }),

/***/ "RIqP":
/***/ (function(module, exports, __webpack_require__) {

var arrayWithoutHoles = __webpack_require__("Ijbi");

var iterableToArray = __webpack_require__("EbDI");

var nonIterableSpread = __webpack_require__("Bnag");

function _toConsumableArray(arr) {
  return arrayWithoutHoles(arr) || iterableToArray(arr) || nonIterableSpread();
}

module.exports = _toConsumableArray;

/***/ }),

/***/ "RoFp":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


/*<replacement>*/

var pna = __webpack_require__("lm0R");
/*</replacement>*/

// undocumented cb() API, needed for core, not for public API
function destroy(err, cb) {
  var _this = this;

  var readableDestroyed = this._readableState && this._readableState.destroyed;
  var writableDestroyed = this._writableState && this._writableState.destroyed;

  if (readableDestroyed || writableDestroyed) {
    if (cb) {
      cb(err);
    } else if (err && (!this._writableState || !this._writableState.errorEmitted)) {
      pna.nextTick(emitErrorNT, this, err);
    }
    return this;
  }

  // we set destroyed to true before firing error callbacks in order
  // to make it re-entrance safe in case destroy() is called within callbacks

  if (this._readableState) {
    this._readableState.destroyed = true;
  }

  // if this is a duplex stream mark the writable part as destroyed as well
  if (this._writableState) {
    this._writableState.destroyed = true;
  }

  this._destroy(err || null, function (err) {
    if (!cb && err) {
      pna.nextTick(emitErrorNT, _this, err);
      if (_this._writableState) {
        _this._writableState.errorEmitted = true;
      }
    } else if (cb) {
      cb(err);
    }
  });

  return this;
}

function undestroy() {
  if (this._readableState) {
    this._readableState.destroyed = false;
    this._readableState.reading = false;
    this._readableState.ended = false;
    this._readableState.endEmitted = false;
  }

  if (this._writableState) {
    this._writableState.destroyed = false;
    this._writableState.ended = false;
    this._writableState.ending = false;
    this._writableState.finished = false;
    this._writableState.errorEmitted = false;
  }
}

function emitErrorNT(self, err) {
  self.emit('error', err);
}

module.exports = {
  destroy: destroy,
  undestroy: undestroy
};

/***/ }),

/***/ "SPBs":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var bbox_1 = __webpack_require__("QJ+7");
var helpers_1 = __webpack_require__("/rf6");
/**
 * Takes a {@link Feature} or {@link FeatureCollection} and returns the absolute center point of all features.
 *
 * @name center
 * @param {GeoJSON} geojson GeoJSON to be centered
 * @param {Object} [options={}] Optional parameters
 * @param {Object} [options.properties={}] Translate GeoJSON Properties to Point
 * @param {Object} [options.bbox={}] Translate GeoJSON BBox to Point
 * @param {Object} [options.id={}] Translate GeoJSON Id to Point
 * @returns {Feature<Point>} a Point feature at the absolute center point of all input features
 * @example
 * var features = turf.points([
 *   [-97.522259, 35.4691],
 *   [-97.502754, 35.463455],
 *   [-97.508269, 35.463245]
 * ]);
 *
 * var center = turf.center(features);
 *
 * //addToMap
 * var addToMap = [features, center]
 * center.properties['marker-size'] = 'large';
 * center.properties['marker-color'] = '#000';
 */
function center(geojson, options) {
    if (options === void 0) { options = {}; }
    var ext = bbox_1.default(geojson);
    var x = (ext[0] + ext[2]) / 2;
    var y = (ext[1] + ext[3]) / 2;
    return helpers_1.point([x, y], options.properties, options);
}
exports.default = center;


/***/ }),

/***/ "SPmy":
/***/ (function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(global, module) {/**
 * lodash (Custom Build) <https://lodash.com/>
 * Build: `lodash modularize exports="npm" -o ./`
 * Copyright jQuery Foundation and other contributors <https://jquery.org/>
 * Released under MIT license <https://lodash.com/license>
 * Based on Underscore.js 1.8.3 <http://underscorejs.org/LICENSE>
 * Copyright Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
 */

/** Used as the size to enable large array optimizations. */
var LARGE_ARRAY_SIZE = 200;

/** Used as the `TypeError` message for "Functions" methods. */
var FUNC_ERROR_TEXT = 'Expected a function';

/** Used to stand-in for `undefined` hash values. */
var HASH_UNDEFINED = '__lodash_hash_undefined__';

/** Used to compose bitmasks for comparison styles. */
var UNORDERED_COMPARE_FLAG = 1,
    PARTIAL_COMPARE_FLAG = 2;

/** Used as references for various `Number` constants. */
var INFINITY = 1 / 0,
    MAX_SAFE_INTEGER = 9007199254740991;

/** `Object#toString` result references. */
var argsTag = '[object Arguments]',
    arrayTag = '[object Array]',
    boolTag = '[object Boolean]',
    dateTag = '[object Date]',
    errorTag = '[object Error]',
    funcTag = '[object Function]',
    genTag = '[object GeneratorFunction]',
    mapTag = '[object Map]',
    numberTag = '[object Number]',
    objectTag = '[object Object]',
    promiseTag = '[object Promise]',
    regexpTag = '[object RegExp]',
    setTag = '[object Set]',
    stringTag = '[object String]',
    symbolTag = '[object Symbol]',
    weakMapTag = '[object WeakMap]';

var arrayBufferTag = '[object ArrayBuffer]',
    dataViewTag = '[object DataView]',
    float32Tag = '[object Float32Array]',
    float64Tag = '[object Float64Array]',
    int8Tag = '[object Int8Array]',
    int16Tag = '[object Int16Array]',
    int32Tag = '[object Int32Array]',
    uint8Tag = '[object Uint8Array]',
    uint8ClampedTag = '[object Uint8ClampedArray]',
    uint16Tag = '[object Uint16Array]',
    uint32Tag = '[object Uint32Array]';

/** Used to match property names within property paths. */
var reIsDeepProp = /\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/,
    reIsPlainProp = /^\w*$/,
    reLeadingDot = /^\./,
    rePropName = /[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|$))/g;

/**
 * Used to match `RegExp`
 * [syntax characters](http://ecma-international.org/ecma-262/7.0/#sec-patterns).
 */
var reRegExpChar = /[\\^$.*+?()[\]{}|]/g;

/** Used to match backslashes in property paths. */
var reEscapeChar = /\\(\\)?/g;

/** Used to detect host constructors (Safari). */
var reIsHostCtor = /^\[object .+?Constructor\]$/;

/** Used to detect unsigned integer values. */
var reIsUint = /^(?:0|[1-9]\d*)$/;

/** Used to identify `toStringTag` values of typed arrays. */
var typedArrayTags = {};
typedArrayTags[float32Tag] = typedArrayTags[float64Tag] =
typedArrayTags[int8Tag] = typedArrayTags[int16Tag] =
typedArrayTags[int32Tag] = typedArrayTags[uint8Tag] =
typedArrayTags[uint8ClampedTag] = typedArrayTags[uint16Tag] =
typedArrayTags[uint32Tag] = true;
typedArrayTags[argsTag] = typedArrayTags[arrayTag] =
typedArrayTags[arrayBufferTag] = typedArrayTags[boolTag] =
typedArrayTags[dataViewTag] = typedArrayTags[dateTag] =
typedArrayTags[errorTag] = typedArrayTags[funcTag] =
typedArrayTags[mapTag] = typedArrayTags[numberTag] =
typedArrayTags[objectTag] = typedArrayTags[regexpTag] =
typedArrayTags[setTag] = typedArrayTags[stringTag] =
typedArrayTags[weakMapTag] = false;

/** Detect free variable `global` from Node.js. */
var freeGlobal = typeof global == 'object' && global && global.Object === Object && global;

/** Detect free variable `self`. */
var freeSelf = typeof self == 'object' && self && self.Object === Object && self;

/** Used as a reference to the global object. */
var root = freeGlobal || freeSelf || Function('return this')();

/** Detect free variable `exports`. */
var freeExports =  true && exports && !exports.nodeType && exports;

/** Detect free variable `module`. */
var freeModule = freeExports && typeof module == 'object' && module && !module.nodeType && module;

/** Detect the popular CommonJS extension `module.exports`. */
var moduleExports = freeModule && freeModule.exports === freeExports;

/** Detect free variable `process` from Node.js. */
var freeProcess = moduleExports && freeGlobal.process;

/** Used to access faster Node.js helpers. */
var nodeUtil = (function() {
  try {
    return freeProcess && freeProcess.binding('util');
  } catch (e) {}
}());

/* Node.js helper references. */
var nodeIsTypedArray = nodeUtil && nodeUtil.isTypedArray;

/**
 * A specialized version of `_.map` for arrays without support for iteratee
 * shorthands.
 *
 * @private
 * @param {Array} [array] The array to iterate over.
 * @param {Function} iteratee The function invoked per iteration.
 * @returns {Array} Returns the new mapped array.
 */
function arrayMap(array, iteratee) {
  var index = -1,
      length = array ? array.length : 0,
      result = Array(length);

  while (++index < length) {
    result[index] = iteratee(array[index], index, array);
  }
  return result;
}

/**
 * A specialized version of `_.some` for arrays without support for iteratee
 * shorthands.
 *
 * @private
 * @param {Array} [array] The array to iterate over.
 * @param {Function} predicate The function invoked per iteration.
 * @returns {boolean} Returns `true` if any element passes the predicate check,
 *  else `false`.
 */
function arraySome(array, predicate) {
  var index = -1,
      length = array ? array.length : 0;

  while (++index < length) {
    if (predicate(array[index], index, array)) {
      return true;
    }
  }
  return false;
}

/**
 * The base implementation of `_.property` without support for deep paths.
 *
 * @private
 * @param {string} key The key of the property to get.
 * @returns {Function} Returns the new accessor function.
 */
function baseProperty(key) {
  return function(object) {
    return object == null ? undefined : object[key];
  };
}

/**
 * The base implementation of `_.sortBy` which uses `comparer` to define the
 * sort order of `array` and replaces criteria objects with their corresponding
 * values.
 *
 * @private
 * @param {Array} array The array to sort.
 * @param {Function} comparer The function to define sort order.
 * @returns {Array} Returns `array`.
 */
function baseSortBy(array, comparer) {
  var length = array.length;

  array.sort(comparer);
  while (length--) {
    array[length] = array[length].value;
  }
  return array;
}

/**
 * The base implementation of `_.times` without support for iteratee shorthands
 * or max array length checks.
 *
 * @private
 * @param {number} n The number of times to invoke `iteratee`.
 * @param {Function} iteratee The function invoked per iteration.
 * @returns {Array} Returns the array of results.
 */
function baseTimes(n, iteratee) {
  var index = -1,
      result = Array(n);

  while (++index < n) {
    result[index] = iteratee(index);
  }
  return result;
}

/**
 * The base implementation of `_.unary` without support for storing metadata.
 *
 * @private
 * @param {Function} func The function to cap arguments for.
 * @returns {Function} Returns the new capped function.
 */
function baseUnary(func) {
  return function(value) {
    return func(value);
  };
}

/**
 * Gets the value at `key` of `object`.
 *
 * @private
 * @param {Object} [object] The object to query.
 * @param {string} key The key of the property to get.
 * @returns {*} Returns the property value.
 */
function getValue(object, key) {
  return object == null ? undefined : object[key];
}

/**
 * Checks if `value` is a host object in IE < 9.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a host object, else `false`.
 */
function isHostObject(value) {
  // Many host objects are `Object` objects that can coerce to strings
  // despite having improperly defined `toString` methods.
  var result = false;
  if (value != null && typeof value.toString != 'function') {
    try {
      result = !!(value + '');
    } catch (e) {}
  }
  return result;
}

/**
 * Converts `map` to its key-value pairs.
 *
 * @private
 * @param {Object} map The map to convert.
 * @returns {Array} Returns the key-value pairs.
 */
function mapToArray(map) {
  var index = -1,
      result = Array(map.size);

  map.forEach(function(value, key) {
    result[++index] = [key, value];
  });
  return result;
}

/**
 * Creates a unary function that invokes `func` with its argument transformed.
 *
 * @private
 * @param {Function} func The function to wrap.
 * @param {Function} transform The argument transform.
 * @returns {Function} Returns the new function.
 */
function overArg(func, transform) {
  return function(arg) {
    return func(transform(arg));
  };
}

/**
 * Converts `set` to an array of its values.
 *
 * @private
 * @param {Object} set The set to convert.
 * @returns {Array} Returns the values.
 */
function setToArray(set) {
  var index = -1,
      result = Array(set.size);

  set.forEach(function(value) {
    result[++index] = value;
  });
  return result;
}

/** Used for built-in method references. */
var arrayProto = Array.prototype,
    funcProto = Function.prototype,
    objectProto = Object.prototype;

/** Used to detect overreaching core-js shims. */
var coreJsData = root['__core-js_shared__'];

/** Used to detect methods masquerading as native. */
var maskSrcKey = (function() {
  var uid = /[^.]+$/.exec(coreJsData && coreJsData.keys && coreJsData.keys.IE_PROTO || '');
  return uid ? ('Symbol(src)_1.' + uid) : '';
}());

/** Used to resolve the decompiled source of functions. */
var funcToString = funcProto.toString;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/**
 * Used to resolve the
 * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
 * of values.
 */
var objectToString = objectProto.toString;

/** Used to detect if a method is native. */
var reIsNative = RegExp('^' +
  funcToString.call(hasOwnProperty).replace(reRegExpChar, '\\$&')
  .replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, '$1.*?') + '$'
);

/** Built-in value references. */
var Symbol = root.Symbol,
    Uint8Array = root.Uint8Array,
    propertyIsEnumerable = objectProto.propertyIsEnumerable,
    splice = arrayProto.splice;

/* Built-in method references for those with the same name as other `lodash` methods. */
var nativeKeys = overArg(Object.keys, Object);

/* Built-in method references that are verified to be native. */
var DataView = getNative(root, 'DataView'),
    Map = getNative(root, 'Map'),
    Promise = getNative(root, 'Promise'),
    Set = getNative(root, 'Set'),
    WeakMap = getNative(root, 'WeakMap'),
    nativeCreate = getNative(Object, 'create');

/** Used to detect maps, sets, and weakmaps. */
var dataViewCtorString = toSource(DataView),
    mapCtorString = toSource(Map),
    promiseCtorString = toSource(Promise),
    setCtorString = toSource(Set),
    weakMapCtorString = toSource(WeakMap);

/** Used to convert symbols to primitives and strings. */
var symbolProto = Symbol ? Symbol.prototype : undefined,
    symbolValueOf = symbolProto ? symbolProto.valueOf : undefined,
    symbolToString = symbolProto ? symbolProto.toString : undefined;

/**
 * Creates a hash object.
 *
 * @private
 * @constructor
 * @param {Array} [entries] The key-value pairs to cache.
 */
function Hash(entries) {
  var index = -1,
      length = entries ? entries.length : 0;

  this.clear();
  while (++index < length) {
    var entry = entries[index];
    this.set(entry[0], entry[1]);
  }
}

/**
 * Removes all key-value entries from the hash.
 *
 * @private
 * @name clear
 * @memberOf Hash
 */
function hashClear() {
  this.__data__ = nativeCreate ? nativeCreate(null) : {};
}

/**
 * Removes `key` and its value from the hash.
 *
 * @private
 * @name delete
 * @memberOf Hash
 * @param {Object} hash The hash to modify.
 * @param {string} key The key of the value to remove.
 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
 */
function hashDelete(key) {
  return this.has(key) && delete this.__data__[key];
}

/**
 * Gets the hash value for `key`.
 *
 * @private
 * @name get
 * @memberOf Hash
 * @param {string} key The key of the value to get.
 * @returns {*} Returns the entry value.
 */
function hashGet(key) {
  var data = this.__data__;
  if (nativeCreate) {
    var result = data[key];
    return result === HASH_UNDEFINED ? undefined : result;
  }
  return hasOwnProperty.call(data, key) ? data[key] : undefined;
}

/**
 * Checks if a hash value for `key` exists.
 *
 * @private
 * @name has
 * @memberOf Hash
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function hashHas(key) {
  var data = this.__data__;
  return nativeCreate ? data[key] !== undefined : hasOwnProperty.call(data, key);
}

/**
 * Sets the hash `key` to `value`.
 *
 * @private
 * @name set
 * @memberOf Hash
 * @param {string} key The key of the value to set.
 * @param {*} value The value to set.
 * @returns {Object} Returns the hash instance.
 */
function hashSet(key, value) {
  var data = this.__data__;
  data[key] = (nativeCreate && value === undefined) ? HASH_UNDEFINED : value;
  return this;
}

// Add methods to `Hash`.
Hash.prototype.clear = hashClear;
Hash.prototype['delete'] = hashDelete;
Hash.prototype.get = hashGet;
Hash.prototype.has = hashHas;
Hash.prototype.set = hashSet;

/**
 * Creates an list cache object.
 *
 * @private
 * @constructor
 * @param {Array} [entries] The key-value pairs to cache.
 */
function ListCache(entries) {
  var index = -1,
      length = entries ? entries.length : 0;

  this.clear();
  while (++index < length) {
    var entry = entries[index];
    this.set(entry[0], entry[1]);
  }
}

/**
 * Removes all key-value entries from the list cache.
 *
 * @private
 * @name clear
 * @memberOf ListCache
 */
function listCacheClear() {
  this.__data__ = [];
}

/**
 * Removes `key` and its value from the list cache.
 *
 * @private
 * @name delete
 * @memberOf ListCache
 * @param {string} key The key of the value to remove.
 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
 */
function listCacheDelete(key) {
  var data = this.__data__,
      index = assocIndexOf(data, key);

  if (index < 0) {
    return false;
  }
  var lastIndex = data.length - 1;
  if (index == lastIndex) {
    data.pop();
  } else {
    splice.call(data, index, 1);
  }
  return true;
}

/**
 * Gets the list cache value for `key`.
 *
 * @private
 * @name get
 * @memberOf ListCache
 * @param {string} key The key of the value to get.
 * @returns {*} Returns the entry value.
 */
function listCacheGet(key) {
  var data = this.__data__,
      index = assocIndexOf(data, key);

  return index < 0 ? undefined : data[index][1];
}

/**
 * Checks if a list cache value for `key` exists.
 *
 * @private
 * @name has
 * @memberOf ListCache
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function listCacheHas(key) {
  return assocIndexOf(this.__data__, key) > -1;
}

/**
 * Sets the list cache `key` to `value`.
 *
 * @private
 * @name set
 * @memberOf ListCache
 * @param {string} key The key of the value to set.
 * @param {*} value The value to set.
 * @returns {Object} Returns the list cache instance.
 */
function listCacheSet(key, value) {
  var data = this.__data__,
      index = assocIndexOf(data, key);

  if (index < 0) {
    data.push([key, value]);
  } else {
    data[index][1] = value;
  }
  return this;
}

// Add methods to `ListCache`.
ListCache.prototype.clear = listCacheClear;
ListCache.prototype['delete'] = listCacheDelete;
ListCache.prototype.get = listCacheGet;
ListCache.prototype.has = listCacheHas;
ListCache.prototype.set = listCacheSet;

/**
 * Creates a map cache object to store key-value pairs.
 *
 * @private
 * @constructor
 * @param {Array} [entries] The key-value pairs to cache.
 */
function MapCache(entries) {
  var index = -1,
      length = entries ? entries.length : 0;

  this.clear();
  while (++index < length) {
    var entry = entries[index];
    this.set(entry[0], entry[1]);
  }
}

/**
 * Removes all key-value entries from the map.
 *
 * @private
 * @name clear
 * @memberOf MapCache
 */
function mapCacheClear() {
  this.__data__ = {
    'hash': new Hash,
    'map': new (Map || ListCache),
    'string': new Hash
  };
}

/**
 * Removes `key` and its value from the map.
 *
 * @private
 * @name delete
 * @memberOf MapCache
 * @param {string} key The key of the value to remove.
 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
 */
function mapCacheDelete(key) {
  return getMapData(this, key)['delete'](key);
}

/**
 * Gets the map value for `key`.
 *
 * @private
 * @name get
 * @memberOf MapCache
 * @param {string} key The key of the value to get.
 * @returns {*} Returns the entry value.
 */
function mapCacheGet(key) {
  return getMapData(this, key).get(key);
}

/**
 * Checks if a map value for `key` exists.
 *
 * @private
 * @name has
 * @memberOf MapCache
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function mapCacheHas(key) {
  return getMapData(this, key).has(key);
}

/**
 * Sets the map `key` to `value`.
 *
 * @private
 * @name set
 * @memberOf MapCache
 * @param {string} key The key of the value to set.
 * @param {*} value The value to set.
 * @returns {Object} Returns the map cache instance.
 */
function mapCacheSet(key, value) {
  getMapData(this, key).set(key, value);
  return this;
}

// Add methods to `MapCache`.
MapCache.prototype.clear = mapCacheClear;
MapCache.prototype['delete'] = mapCacheDelete;
MapCache.prototype.get = mapCacheGet;
MapCache.prototype.has = mapCacheHas;
MapCache.prototype.set = mapCacheSet;

/**
 *
 * Creates an array cache object to store unique values.
 *
 * @private
 * @constructor
 * @param {Array} [values] The values to cache.
 */
function SetCache(values) {
  var index = -1,
      length = values ? values.length : 0;

  this.__data__ = new MapCache;
  while (++index < length) {
    this.add(values[index]);
  }
}

/**
 * Adds `value` to the array cache.
 *
 * @private
 * @name add
 * @memberOf SetCache
 * @alias push
 * @param {*} value The value to cache.
 * @returns {Object} Returns the cache instance.
 */
function setCacheAdd(value) {
  this.__data__.set(value, HASH_UNDEFINED);
  return this;
}

/**
 * Checks if `value` is in the array cache.
 *
 * @private
 * @name has
 * @memberOf SetCache
 * @param {*} value The value to search for.
 * @returns {number} Returns `true` if `value` is found, else `false`.
 */
function setCacheHas(value) {
  return this.__data__.has(value);
}

// Add methods to `SetCache`.
SetCache.prototype.add = SetCache.prototype.push = setCacheAdd;
SetCache.prototype.has = setCacheHas;

/**
 * Creates a stack cache object to store key-value pairs.
 *
 * @private
 * @constructor
 * @param {Array} [entries] The key-value pairs to cache.
 */
function Stack(entries) {
  this.__data__ = new ListCache(entries);
}

/**
 * Removes all key-value entries from the stack.
 *
 * @private
 * @name clear
 * @memberOf Stack
 */
function stackClear() {
  this.__data__ = new ListCache;
}

/**
 * Removes `key` and its value from the stack.
 *
 * @private
 * @name delete
 * @memberOf Stack
 * @param {string} key The key of the value to remove.
 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
 */
function stackDelete(key) {
  return this.__data__['delete'](key);
}

/**
 * Gets the stack value for `key`.
 *
 * @private
 * @name get
 * @memberOf Stack
 * @param {string} key The key of the value to get.
 * @returns {*} Returns the entry value.
 */
function stackGet(key) {
  return this.__data__.get(key);
}

/**
 * Checks if a stack value for `key` exists.
 *
 * @private
 * @name has
 * @memberOf Stack
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function stackHas(key) {
  return this.__data__.has(key);
}

/**
 * Sets the stack `key` to `value`.
 *
 * @private
 * @name set
 * @memberOf Stack
 * @param {string} key The key of the value to set.
 * @param {*} value The value to set.
 * @returns {Object} Returns the stack cache instance.
 */
function stackSet(key, value) {
  var cache = this.__data__;
  if (cache instanceof ListCache) {
    var pairs = cache.__data__;
    if (!Map || (pairs.length < LARGE_ARRAY_SIZE - 1)) {
      pairs.push([key, value]);
      return this;
    }
    cache = this.__data__ = new MapCache(pairs);
  }
  cache.set(key, value);
  return this;
}

// Add methods to `Stack`.
Stack.prototype.clear = stackClear;
Stack.prototype['delete'] = stackDelete;
Stack.prototype.get = stackGet;
Stack.prototype.has = stackHas;
Stack.prototype.set = stackSet;

/**
 * Creates an array of the enumerable property names of the array-like `value`.
 *
 * @private
 * @param {*} value The value to query.
 * @param {boolean} inherited Specify returning inherited property names.
 * @returns {Array} Returns the array of property names.
 */
function arrayLikeKeys(value, inherited) {
  // Safari 8.1 makes `arguments.callee` enumerable in strict mode.
  // Safari 9 makes `arguments.length` enumerable in strict mode.
  var result = (isArray(value) || isArguments(value))
    ? baseTimes(value.length, String)
    : [];

  var length = result.length,
      skipIndexes = !!length;

  for (var key in value) {
    if ((inherited || hasOwnProperty.call(value, key)) &&
        !(skipIndexes && (key == 'length' || isIndex(key, length)))) {
      result.push(key);
    }
  }
  return result;
}

/**
 * Gets the index at which the `key` is found in `array` of key-value pairs.
 *
 * @private
 * @param {Array} array The array to inspect.
 * @param {*} key The key to search for.
 * @returns {number} Returns the index of the matched value, else `-1`.
 */
function assocIndexOf(array, key) {
  var length = array.length;
  while (length--) {
    if (eq(array[length][0], key)) {
      return length;
    }
  }
  return -1;
}

/**
 * The base implementation of `_.forEach` without support for iteratee shorthands.
 *
 * @private
 * @param {Array|Object} collection The collection to iterate over.
 * @param {Function} iteratee The function invoked per iteration.
 * @returns {Array|Object} Returns `collection`.
 */
var baseEach = createBaseEach(baseForOwn);

/**
 * The base implementation of `baseForOwn` which iterates over `object`
 * properties returned by `keysFunc` and invokes `iteratee` for each property.
 * Iteratee functions may exit iteration early by explicitly returning `false`.
 *
 * @private
 * @param {Object} object The object to iterate over.
 * @param {Function} iteratee The function invoked per iteration.
 * @param {Function} keysFunc The function to get the keys of `object`.
 * @returns {Object} Returns `object`.
 */
var baseFor = createBaseFor();

/**
 * The base implementation of `_.forOwn` without support for iteratee shorthands.
 *
 * @private
 * @param {Object} object The object to iterate over.
 * @param {Function} iteratee The function invoked per iteration.
 * @returns {Object} Returns `object`.
 */
function baseForOwn(object, iteratee) {
  return object && baseFor(object, iteratee, keys);
}

/**
 * The base implementation of `_.get` without support for default values.
 *
 * @private
 * @param {Object} object The object to query.
 * @param {Array|string} path The path of the property to get.
 * @returns {*} Returns the resolved value.
 */
function baseGet(object, path) {
  path = isKey(path, object) ? [path] : castPath(path);

  var index = 0,
      length = path.length;

  while (object != null && index < length) {
    object = object[toKey(path[index++])];
  }
  return (index && index == length) ? object : undefined;
}

/**
 * The base implementation of `getTag`.
 *
 * @private
 * @param {*} value The value to query.
 * @returns {string} Returns the `toStringTag`.
 */
function baseGetTag(value) {
  return objectToString.call(value);
}

/**
 * The base implementation of `_.hasIn` without support for deep paths.
 *
 * @private
 * @param {Object} [object] The object to query.
 * @param {Array|string} key The key to check.
 * @returns {boolean} Returns `true` if `key` exists, else `false`.
 */
function baseHasIn(object, key) {
  return object != null && key in Object(object);
}

/**
 * The base implementation of `_.isEqual` which supports partial comparisons
 * and tracks traversed objects.
 *
 * @private
 * @param {*} value The value to compare.
 * @param {*} other The other value to compare.
 * @param {Function} [customizer] The function to customize comparisons.
 * @param {boolean} [bitmask] The bitmask of comparison flags.
 *  The bitmask may be composed of the following flags:
 *     1 - Unordered comparison
 *     2 - Partial comparison
 * @param {Object} [stack] Tracks traversed `value` and `other` objects.
 * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
 */
function baseIsEqual(value, other, customizer, bitmask, stack) {
  if (value === other) {
    return true;
  }
  if (value == null || other == null || (!isObject(value) && !isObjectLike(other))) {
    return value !== value && other !== other;
  }
  return baseIsEqualDeep(value, other, baseIsEqual, customizer, bitmask, stack);
}

/**
 * A specialized version of `baseIsEqual` for arrays and objects which performs
 * deep comparisons and tracks traversed objects enabling objects with circular
 * references to be compared.
 *
 * @private
 * @param {Object} object The object to compare.
 * @param {Object} other The other object to compare.
 * @param {Function} equalFunc The function to determine equivalents of values.
 * @param {Function} [customizer] The function to customize comparisons.
 * @param {number} [bitmask] The bitmask of comparison flags. See `baseIsEqual`
 *  for more details.
 * @param {Object} [stack] Tracks traversed `object` and `other` objects.
 * @returns {boolean} Returns `true` if the objects are equivalent, else `false`.
 */
function baseIsEqualDeep(object, other, equalFunc, customizer, bitmask, stack) {
  var objIsArr = isArray(object),
      othIsArr = isArray(other),
      objTag = arrayTag,
      othTag = arrayTag;

  if (!objIsArr) {
    objTag = getTag(object);
    objTag = objTag == argsTag ? objectTag : objTag;
  }
  if (!othIsArr) {
    othTag = getTag(other);
    othTag = othTag == argsTag ? objectTag : othTag;
  }
  var objIsObj = objTag == objectTag && !isHostObject(object),
      othIsObj = othTag == objectTag && !isHostObject(other),
      isSameTag = objTag == othTag;

  if (isSameTag && !objIsObj) {
    stack || (stack = new Stack);
    return (objIsArr || isTypedArray(object))
      ? equalArrays(object, other, equalFunc, customizer, bitmask, stack)
      : equalByTag(object, other, objTag, equalFunc, customizer, bitmask, stack);
  }
  if (!(bitmask & PARTIAL_COMPARE_FLAG)) {
    var objIsWrapped = objIsObj && hasOwnProperty.call(object, '__wrapped__'),
        othIsWrapped = othIsObj && hasOwnProperty.call(other, '__wrapped__');

    if (objIsWrapped || othIsWrapped) {
      var objUnwrapped = objIsWrapped ? object.value() : object,
          othUnwrapped = othIsWrapped ? other.value() : other;

      stack || (stack = new Stack);
      return equalFunc(objUnwrapped, othUnwrapped, customizer, bitmask, stack);
    }
  }
  if (!isSameTag) {
    return false;
  }
  stack || (stack = new Stack);
  return equalObjects(object, other, equalFunc, customizer, bitmask, stack);
}

/**
 * The base implementation of `_.isMatch` without support for iteratee shorthands.
 *
 * @private
 * @param {Object} object The object to inspect.
 * @param {Object} source The object of property values to match.
 * @param {Array} matchData The property names, values, and compare flags to match.
 * @param {Function} [customizer] The function to customize comparisons.
 * @returns {boolean} Returns `true` if `object` is a match, else `false`.
 */
function baseIsMatch(object, source, matchData, customizer) {
  var index = matchData.length,
      length = index,
      noCustomizer = !customizer;

  if (object == null) {
    return !length;
  }
  object = Object(object);
  while (index--) {
    var data = matchData[index];
    if ((noCustomizer && data[2])
          ? data[1] !== object[data[0]]
          : !(data[0] in object)
        ) {
      return false;
    }
  }
  while (++index < length) {
    data = matchData[index];
    var key = data[0],
        objValue = object[key],
        srcValue = data[1];

    if (noCustomizer && data[2]) {
      if (objValue === undefined && !(key in object)) {
        return false;
      }
    } else {
      var stack = new Stack;
      if (customizer) {
        var result = customizer(objValue, srcValue, key, object, source, stack);
      }
      if (!(result === undefined
            ? baseIsEqual(srcValue, objValue, customizer, UNORDERED_COMPARE_FLAG | PARTIAL_COMPARE_FLAG, stack)
            : result
          )) {
        return false;
      }
    }
  }
  return true;
}

/**
 * The base implementation of `_.isNative` without bad shim checks.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a native function,
 *  else `false`.
 */
function baseIsNative(value) {
  if (!isObject(value) || isMasked(value)) {
    return false;
  }
  var pattern = (isFunction(value) || isHostObject(value)) ? reIsNative : reIsHostCtor;
  return pattern.test(toSource(value));
}

/**
 * The base implementation of `_.isTypedArray` without Node.js optimizations.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a typed array, else `false`.
 */
function baseIsTypedArray(value) {
  return isObjectLike(value) &&
    isLength(value.length) && !!typedArrayTags[objectToString.call(value)];
}

/**
 * The base implementation of `_.iteratee`.
 *
 * @private
 * @param {*} [value=_.identity] The value to convert to an iteratee.
 * @returns {Function} Returns the iteratee.
 */
function baseIteratee(value) {
  // Don't store the `typeof` result in a variable to avoid a JIT bug in Safari 9.
  // See https://bugs.webkit.org/show_bug.cgi?id=156034 for more details.
  if (typeof value == 'function') {
    return value;
  }
  if (value == null) {
    return identity;
  }
  if (typeof value == 'object') {
    return isArray(value)
      ? baseMatchesProperty(value[0], value[1])
      : baseMatches(value);
  }
  return property(value);
}

/**
 * The base implementation of `_.keys` which doesn't treat sparse arrays as dense.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property names.
 */
function baseKeys(object) {
  if (!isPrototype(object)) {
    return nativeKeys(object);
  }
  var result = [];
  for (var key in Object(object)) {
    if (hasOwnProperty.call(object, key) && key != 'constructor') {
      result.push(key);
    }
  }
  return result;
}

/**
 * The base implementation of `_.map` without support for iteratee shorthands.
 *
 * @private
 * @param {Array|Object} collection The collection to iterate over.
 * @param {Function} iteratee The function invoked per iteration.
 * @returns {Array} Returns the new mapped array.
 */
function baseMap(collection, iteratee) {
  var index = -1,
      result = isArrayLike(collection) ? Array(collection.length) : [];

  baseEach(collection, function(value, key, collection) {
    result[++index] = iteratee(value, key, collection);
  });
  return result;
}

/**
 * The base implementation of `_.matches` which doesn't clone `source`.
 *
 * @private
 * @param {Object} source The object of property values to match.
 * @returns {Function} Returns the new spec function.
 */
function baseMatches(source) {
  var matchData = getMatchData(source);
  if (matchData.length == 1 && matchData[0][2]) {
    return matchesStrictComparable(matchData[0][0], matchData[0][1]);
  }
  return function(object) {
    return object === source || baseIsMatch(object, source, matchData);
  };
}

/**
 * The base implementation of `_.matchesProperty` which doesn't clone `srcValue`.
 *
 * @private
 * @param {string} path The path of the property to get.
 * @param {*} srcValue The value to match.
 * @returns {Function} Returns the new spec function.
 */
function baseMatchesProperty(path, srcValue) {
  if (isKey(path) && isStrictComparable(srcValue)) {
    return matchesStrictComparable(toKey(path), srcValue);
  }
  return function(object) {
    var objValue = get(object, path);
    return (objValue === undefined && objValue === srcValue)
      ? hasIn(object, path)
      : baseIsEqual(srcValue, objValue, undefined, UNORDERED_COMPARE_FLAG | PARTIAL_COMPARE_FLAG);
  };
}

/**
 * The base implementation of `_.orderBy` without param guards.
 *
 * @private
 * @param {Array|Object} collection The collection to iterate over.
 * @param {Function[]|Object[]|string[]} iteratees The iteratees to sort by.
 * @param {string[]} orders The sort orders of `iteratees`.
 * @returns {Array} Returns the new sorted array.
 */
function baseOrderBy(collection, iteratees, orders) {
  var index = -1;
  iteratees = arrayMap(iteratees.length ? iteratees : [identity], baseUnary(baseIteratee));

  var result = baseMap(collection, function(value, key, collection) {
    var criteria = arrayMap(iteratees, function(iteratee) {
      return iteratee(value);
    });
    return { 'criteria': criteria, 'index': ++index, 'value': value };
  });

  return baseSortBy(result, function(object, other) {
    return compareMultiple(object, other, orders);
  });
}

/**
 * A specialized version of `baseProperty` which supports deep paths.
 *
 * @private
 * @param {Array|string} path The path of the property to get.
 * @returns {Function} Returns the new accessor function.
 */
function basePropertyDeep(path) {
  return function(object) {
    return baseGet(object, path);
  };
}

/**
 * The base implementation of `_.toString` which doesn't convert nullish
 * values to empty strings.
 *
 * @private
 * @param {*} value The value to process.
 * @returns {string} Returns the string.
 */
function baseToString(value) {
  // Exit early for strings to avoid a performance hit in some environments.
  if (typeof value == 'string') {
    return value;
  }
  if (isSymbol(value)) {
    return symbolToString ? symbolToString.call(value) : '';
  }
  var result = (value + '');
  return (result == '0' && (1 / value) == -INFINITY) ? '-0' : result;
}

/**
 * Casts `value` to a path array if it's not one.
 *
 * @private
 * @param {*} value The value to inspect.
 * @returns {Array} Returns the cast property path array.
 */
function castPath(value) {
  return isArray(value) ? value : stringToPath(value);
}

/**
 * Compares values to sort them in ascending order.
 *
 * @private
 * @param {*} value The value to compare.
 * @param {*} other The other value to compare.
 * @returns {number} Returns the sort order indicator for `value`.
 */
function compareAscending(value, other) {
  if (value !== other) {
    var valIsDefined = value !== undefined,
        valIsNull = value === null,
        valIsReflexive = value === value,
        valIsSymbol = isSymbol(value);

    var othIsDefined = other !== undefined,
        othIsNull = other === null,
        othIsReflexive = other === other,
        othIsSymbol = isSymbol(other);

    if ((!othIsNull && !othIsSymbol && !valIsSymbol && value > other) ||
        (valIsSymbol && othIsDefined && othIsReflexive && !othIsNull && !othIsSymbol) ||
        (valIsNull && othIsDefined && othIsReflexive) ||
        (!valIsDefined && othIsReflexive) ||
        !valIsReflexive) {
      return 1;
    }
    if ((!valIsNull && !valIsSymbol && !othIsSymbol && value < other) ||
        (othIsSymbol && valIsDefined && valIsReflexive && !valIsNull && !valIsSymbol) ||
        (othIsNull && valIsDefined && valIsReflexive) ||
        (!othIsDefined && valIsReflexive) ||
        !othIsReflexive) {
      return -1;
    }
  }
  return 0;
}

/**
 * Used by `_.orderBy` to compare multiple properties of a value to another
 * and stable sort them.
 *
 * If `orders` is unspecified, all values are sorted in ascending order. Otherwise,
 * specify an order of "desc" for descending or "asc" for ascending sort order
 * of corresponding values.
 *
 * @private
 * @param {Object} object The object to compare.
 * @param {Object} other The other object to compare.
 * @param {boolean[]|string[]} orders The order to sort by for each property.
 * @returns {number} Returns the sort order indicator for `object`.
 */
function compareMultiple(object, other, orders) {
  var index = -1,
      objCriteria = object.criteria,
      othCriteria = other.criteria,
      length = objCriteria.length,
      ordersLength = orders.length;

  while (++index < length) {
    var result = compareAscending(objCriteria[index], othCriteria[index]);
    if (result) {
      if (index >= ordersLength) {
        return result;
      }
      var order = orders[index];
      return result * (order == 'desc' ? -1 : 1);
    }
  }
  // Fixes an `Array#sort` bug in the JS engine embedded in Adobe applications
  // that causes it, under certain circumstances, to provide the same value for
  // `object` and `other`. See https://github.com/jashkenas/underscore/pull/1247
  // for more details.
  //
  // This also ensures a stable sort in V8 and other engines.
  // See https://bugs.chromium.org/p/v8/issues/detail?id=90 for more details.
  return object.index - other.index;
}

/**
 * Creates a `baseEach` or `baseEachRight` function.
 *
 * @private
 * @param {Function} eachFunc The function to iterate over a collection.
 * @param {boolean} [fromRight] Specify iterating from right to left.
 * @returns {Function} Returns the new base function.
 */
function createBaseEach(eachFunc, fromRight) {
  return function(collection, iteratee) {
    if (collection == null) {
      return collection;
    }
    if (!isArrayLike(collection)) {
      return eachFunc(collection, iteratee);
    }
    var length = collection.length,
        index = fromRight ? length : -1,
        iterable = Object(collection);

    while ((fromRight ? index-- : ++index < length)) {
      if (iteratee(iterable[index], index, iterable) === false) {
        break;
      }
    }
    return collection;
  };
}

/**
 * Creates a base function for methods like `_.forIn` and `_.forOwn`.
 *
 * @private
 * @param {boolean} [fromRight] Specify iterating from right to left.
 * @returns {Function} Returns the new base function.
 */
function createBaseFor(fromRight) {
  return function(object, iteratee, keysFunc) {
    var index = -1,
        iterable = Object(object),
        props = keysFunc(object),
        length = props.length;

    while (length--) {
      var key = props[fromRight ? length : ++index];
      if (iteratee(iterable[key], key, iterable) === false) {
        break;
      }
    }
    return object;
  };
}

/**
 * A specialized version of `baseIsEqualDeep` for arrays with support for
 * partial deep comparisons.
 *
 * @private
 * @param {Array} array The array to compare.
 * @param {Array} other The other array to compare.
 * @param {Function} equalFunc The function to determine equivalents of values.
 * @param {Function} customizer The function to customize comparisons.
 * @param {number} bitmask The bitmask of comparison flags. See `baseIsEqual`
 *  for more details.
 * @param {Object} stack Tracks traversed `array` and `other` objects.
 * @returns {boolean} Returns `true` if the arrays are equivalent, else `false`.
 */
function equalArrays(array, other, equalFunc, customizer, bitmask, stack) {
  var isPartial = bitmask & PARTIAL_COMPARE_FLAG,
      arrLength = array.length,
      othLength = other.length;

  if (arrLength != othLength && !(isPartial && othLength > arrLength)) {
    return false;
  }
  // Assume cyclic values are equal.
  var stacked = stack.get(array);
  if (stacked && stack.get(other)) {
    return stacked == other;
  }
  var index = -1,
      result = true,
      seen = (bitmask & UNORDERED_COMPARE_FLAG) ? new SetCache : undefined;

  stack.set(array, other);
  stack.set(other, array);

  // Ignore non-index properties.
  while (++index < arrLength) {
    var arrValue = array[index],
        othValue = other[index];

    if (customizer) {
      var compared = isPartial
        ? customizer(othValue, arrValue, index, other, array, stack)
        : customizer(arrValue, othValue, index, array, other, stack);
    }
    if (compared !== undefined) {
      if (compared) {
        continue;
      }
      result = false;
      break;
    }
    // Recursively compare arrays (susceptible to call stack limits).
    if (seen) {
      if (!arraySome(other, function(othValue, othIndex) {
            if (!seen.has(othIndex) &&
                (arrValue === othValue || equalFunc(arrValue, othValue, customizer, bitmask, stack))) {
              return seen.add(othIndex);
            }
          })) {
        result = false;
        break;
      }
    } else if (!(
          arrValue === othValue ||
            equalFunc(arrValue, othValue, customizer, bitmask, stack)
        )) {
      result = false;
      break;
    }
  }
  stack['delete'](array);
  stack['delete'](other);
  return result;
}

/**
 * A specialized version of `baseIsEqualDeep` for comparing objects of
 * the same `toStringTag`.
 *
 * **Note:** This function only supports comparing values with tags of
 * `Boolean`, `Date`, `Error`, `Number`, `RegExp`, or `String`.
 *
 * @private
 * @param {Object} object The object to compare.
 * @param {Object} other The other object to compare.
 * @param {string} tag The `toStringTag` of the objects to compare.
 * @param {Function} equalFunc The function to determine equivalents of values.
 * @param {Function} customizer The function to customize comparisons.
 * @param {number} bitmask The bitmask of comparison flags. See `baseIsEqual`
 *  for more details.
 * @param {Object} stack Tracks traversed `object` and `other` objects.
 * @returns {boolean} Returns `true` if the objects are equivalent, else `false`.
 */
function equalByTag(object, other, tag, equalFunc, customizer, bitmask, stack) {
  switch (tag) {
    case dataViewTag:
      if ((object.byteLength != other.byteLength) ||
          (object.byteOffset != other.byteOffset)) {
        return false;
      }
      object = object.buffer;
      other = other.buffer;

    case arrayBufferTag:
      if ((object.byteLength != other.byteLength) ||
          !equalFunc(new Uint8Array(object), new Uint8Array(other))) {
        return false;
      }
      return true;

    case boolTag:
    case dateTag:
    case numberTag:
      // Coerce booleans to `1` or `0` and dates to milliseconds.
      // Invalid dates are coerced to `NaN`.
      return eq(+object, +other);

    case errorTag:
      return object.name == other.name && object.message == other.message;

    case regexpTag:
    case stringTag:
      // Coerce regexes to strings and treat strings, primitives and objects,
      // as equal. See http://www.ecma-international.org/ecma-262/7.0/#sec-regexp.prototype.tostring
      // for more details.
      return object == (other + '');

    case mapTag:
      var convert = mapToArray;

    case setTag:
      var isPartial = bitmask & PARTIAL_COMPARE_FLAG;
      convert || (convert = setToArray);

      if (object.size != other.size && !isPartial) {
        return false;
      }
      // Assume cyclic values are equal.
      var stacked = stack.get(object);
      if (stacked) {
        return stacked == other;
      }
      bitmask |= UNORDERED_COMPARE_FLAG;

      // Recursively compare objects (susceptible to call stack limits).
      stack.set(object, other);
      var result = equalArrays(convert(object), convert(other), equalFunc, customizer, bitmask, stack);
      stack['delete'](object);
      return result;

    case symbolTag:
      if (symbolValueOf) {
        return symbolValueOf.call(object) == symbolValueOf.call(other);
      }
  }
  return false;
}

/**
 * A specialized version of `baseIsEqualDeep` for objects with support for
 * partial deep comparisons.
 *
 * @private
 * @param {Object} object The object to compare.
 * @param {Object} other The other object to compare.
 * @param {Function} equalFunc The function to determine equivalents of values.
 * @param {Function} customizer The function to customize comparisons.
 * @param {number} bitmask The bitmask of comparison flags. See `baseIsEqual`
 *  for more details.
 * @param {Object} stack Tracks traversed `object` and `other` objects.
 * @returns {boolean} Returns `true` if the objects are equivalent, else `false`.
 */
function equalObjects(object, other, equalFunc, customizer, bitmask, stack) {
  var isPartial = bitmask & PARTIAL_COMPARE_FLAG,
      objProps = keys(object),
      objLength = objProps.length,
      othProps = keys(other),
      othLength = othProps.length;

  if (objLength != othLength && !isPartial) {
    return false;
  }
  var index = objLength;
  while (index--) {
    var key = objProps[index];
    if (!(isPartial ? key in other : hasOwnProperty.call(other, key))) {
      return false;
    }
  }
  // Assume cyclic values are equal.
  var stacked = stack.get(object);
  if (stacked && stack.get(other)) {
    return stacked == other;
  }
  var result = true;
  stack.set(object, other);
  stack.set(other, object);

  var skipCtor = isPartial;
  while (++index < objLength) {
    key = objProps[index];
    var objValue = object[key],
        othValue = other[key];

    if (customizer) {
      var compared = isPartial
        ? customizer(othValue, objValue, key, other, object, stack)
        : customizer(objValue, othValue, key, object, other, stack);
    }
    // Recursively compare objects (susceptible to call stack limits).
    if (!(compared === undefined
          ? (objValue === othValue || equalFunc(objValue, othValue, customizer, bitmask, stack))
          : compared
        )) {
      result = false;
      break;
    }
    skipCtor || (skipCtor = key == 'constructor');
  }
  if (result && !skipCtor) {
    var objCtor = object.constructor,
        othCtor = other.constructor;

    // Non `Object` object instances with different constructors are not equal.
    if (objCtor != othCtor &&
        ('constructor' in object && 'constructor' in other) &&
        !(typeof objCtor == 'function' && objCtor instanceof objCtor &&
          typeof othCtor == 'function' && othCtor instanceof othCtor)) {
      result = false;
    }
  }
  stack['delete'](object);
  stack['delete'](other);
  return result;
}

/**
 * Gets the data for `map`.
 *
 * @private
 * @param {Object} map The map to query.
 * @param {string} key The reference key.
 * @returns {*} Returns the map data.
 */
function getMapData(map, key) {
  var data = map.__data__;
  return isKeyable(key)
    ? data[typeof key == 'string' ? 'string' : 'hash']
    : data.map;
}

/**
 * Gets the property names, values, and compare flags of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Array} Returns the match data of `object`.
 */
function getMatchData(object) {
  var result = keys(object),
      length = result.length;

  while (length--) {
    var key = result[length],
        value = object[key];

    result[length] = [key, value, isStrictComparable(value)];
  }
  return result;
}

/**
 * Gets the native function at `key` of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @param {string} key The key of the method to get.
 * @returns {*} Returns the function if it's native, else `undefined`.
 */
function getNative(object, key) {
  var value = getValue(object, key);
  return baseIsNative(value) ? value : undefined;
}

/**
 * Gets the `toStringTag` of `value`.
 *
 * @private
 * @param {*} value The value to query.
 * @returns {string} Returns the `toStringTag`.
 */
var getTag = baseGetTag;

// Fallback for data views, maps, sets, and weak maps in IE 11,
// for data views in Edge < 14, and promises in Node.js.
if ((DataView && getTag(new DataView(new ArrayBuffer(1))) != dataViewTag) ||
    (Map && getTag(new Map) != mapTag) ||
    (Promise && getTag(Promise.resolve()) != promiseTag) ||
    (Set && getTag(new Set) != setTag) ||
    (WeakMap && getTag(new WeakMap) != weakMapTag)) {
  getTag = function(value) {
    var result = objectToString.call(value),
        Ctor = result == objectTag ? value.constructor : undefined,
        ctorString = Ctor ? toSource(Ctor) : undefined;

    if (ctorString) {
      switch (ctorString) {
        case dataViewCtorString: return dataViewTag;
        case mapCtorString: return mapTag;
        case promiseCtorString: return promiseTag;
        case setCtorString: return setTag;
        case weakMapCtorString: return weakMapTag;
      }
    }
    return result;
  };
}

/**
 * Checks if `path` exists on `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @param {Array|string} path The path to check.
 * @param {Function} hasFunc The function to check properties.
 * @returns {boolean} Returns `true` if `path` exists, else `false`.
 */
function hasPath(object, path, hasFunc) {
  path = isKey(path, object) ? [path] : castPath(path);

  var result,
      index = -1,
      length = path.length;

  while (++index < length) {
    var key = toKey(path[index]);
    if (!(result = object != null && hasFunc(object, key))) {
      break;
    }
    object = object[key];
  }
  if (result) {
    return result;
  }
  var length = object ? object.length : 0;
  return !!length && isLength(length) && isIndex(key, length) &&
    (isArray(object) || isArguments(object));
}

/**
 * Checks if `value` is a valid array-like index.
 *
 * @private
 * @param {*} value The value to check.
 * @param {number} [length=MAX_SAFE_INTEGER] The upper bounds of a valid index.
 * @returns {boolean} Returns `true` if `value` is a valid index, else `false`.
 */
function isIndex(value, length) {
  length = length == null ? MAX_SAFE_INTEGER : length;
  return !!length &&
    (typeof value == 'number' || reIsUint.test(value)) &&
    (value > -1 && value % 1 == 0 && value < length);
}

/**
 * Checks if `value` is a property name and not a property path.
 *
 * @private
 * @param {*} value The value to check.
 * @param {Object} [object] The object to query keys on.
 * @returns {boolean} Returns `true` if `value` is a property name, else `false`.
 */
function isKey(value, object) {
  if (isArray(value)) {
    return false;
  }
  var type = typeof value;
  if (type == 'number' || type == 'symbol' || type == 'boolean' ||
      value == null || isSymbol(value)) {
    return true;
  }
  return reIsPlainProp.test(value) || !reIsDeepProp.test(value) ||
    (object != null && value in Object(object));
}

/**
 * Checks if `value` is suitable for use as unique object key.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is suitable, else `false`.
 */
function isKeyable(value) {
  var type = typeof value;
  return (type == 'string' || type == 'number' || type == 'symbol' || type == 'boolean')
    ? (value !== '__proto__')
    : (value === null);
}

/**
 * Checks if `func` has its source masked.
 *
 * @private
 * @param {Function} func The function to check.
 * @returns {boolean} Returns `true` if `func` is masked, else `false`.
 */
function isMasked(func) {
  return !!maskSrcKey && (maskSrcKey in func);
}

/**
 * Checks if `value` is likely a prototype object.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a prototype, else `false`.
 */
function isPrototype(value) {
  var Ctor = value && value.constructor,
      proto = (typeof Ctor == 'function' && Ctor.prototype) || objectProto;

  return value === proto;
}

/**
 * Checks if `value` is suitable for strict equality comparisons, i.e. `===`.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` if suitable for strict
 *  equality comparisons, else `false`.
 */
function isStrictComparable(value) {
  return value === value && !isObject(value);
}

/**
 * A specialized version of `matchesProperty` for source values suitable
 * for strict equality comparisons, i.e. `===`.
 *
 * @private
 * @param {string} key The key of the property to get.
 * @param {*} srcValue The value to match.
 * @returns {Function} Returns the new spec function.
 */
function matchesStrictComparable(key, srcValue) {
  return function(object) {
    if (object == null) {
      return false;
    }
    return object[key] === srcValue &&
      (srcValue !== undefined || (key in Object(object)));
  };
}

/**
 * Converts `string` to a property path array.
 *
 * @private
 * @param {string} string The string to convert.
 * @returns {Array} Returns the property path array.
 */
var stringToPath = memoize(function(string) {
  string = toString(string);

  var result = [];
  if (reLeadingDot.test(string)) {
    result.push('');
  }
  string.replace(rePropName, function(match, number, quote, string) {
    result.push(quote ? string.replace(reEscapeChar, '$1') : (number || match));
  });
  return result;
});

/**
 * Converts `value` to a string key if it's not a string or symbol.
 *
 * @private
 * @param {*} value The value to inspect.
 * @returns {string|symbol} Returns the key.
 */
function toKey(value) {
  if (typeof value == 'string' || isSymbol(value)) {
    return value;
  }
  var result = (value + '');
  return (result == '0' && (1 / value) == -INFINITY) ? '-0' : result;
}

/**
 * Converts `func` to its source code.
 *
 * @private
 * @param {Function} func The function to process.
 * @returns {string} Returns the source code.
 */
function toSource(func) {
  if (func != null) {
    try {
      return funcToString.call(func);
    } catch (e) {}
    try {
      return (func + '');
    } catch (e) {}
  }
  return '';
}

/**
 * This method is like `_.sortBy` except that it allows specifying the sort
 * orders of the iteratees to sort by. If `orders` is unspecified, all values
 * are sorted in ascending order. Otherwise, specify an order of "desc" for
 * descending or "asc" for ascending sort order of corresponding values.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Collection
 * @param {Array|Object} collection The collection to iterate over.
 * @param {Array[]|Function[]|Object[]|string[]} [iteratees=[_.identity]]
 *  The iteratees to sort by.
 * @param {string[]} [orders] The sort orders of `iteratees`.
 * @param- {Object} [guard] Enables use as an iteratee for methods like `_.reduce`.
 * @returns {Array} Returns the new sorted array.
 * @example
 *
 * var users = [
 *   { 'user': 'fred',   'age': 48 },
 *   { 'user': 'barney', 'age': 34 },
 *   { 'user': 'fred',   'age': 40 },
 *   { 'user': 'barney', 'age': 36 }
 * ];
 *
 * // Sort by `user` in ascending order and by `age` in descending order.
 * _.orderBy(users, ['user', 'age'], ['asc', 'desc']);
 * // => objects for [['barney', 36], ['barney', 34], ['fred', 48], ['fred', 40]]
 */
function orderBy(collection, iteratees, orders, guard) {
  if (collection == null) {
    return [];
  }
  if (!isArray(iteratees)) {
    iteratees = iteratees == null ? [] : [iteratees];
  }
  orders = guard ? undefined : orders;
  if (!isArray(orders)) {
    orders = orders == null ? [] : [orders];
  }
  return baseOrderBy(collection, iteratees, orders);
}

/**
 * Creates a function that memoizes the result of `func`. If `resolver` is
 * provided, it determines the cache key for storing the result based on the
 * arguments provided to the memoized function. By default, the first argument
 * provided to the memoized function is used as the map cache key. The `func`
 * is invoked with the `this` binding of the memoized function.
 *
 * **Note:** The cache is exposed as the `cache` property on the memoized
 * function. Its creation may be customized by replacing the `_.memoize.Cache`
 * constructor with one whose instances implement the
 * [`Map`](http://ecma-international.org/ecma-262/7.0/#sec-properties-of-the-map-prototype-object)
 * method interface of `delete`, `get`, `has`, and `set`.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Function
 * @param {Function} func The function to have its output memoized.
 * @param {Function} [resolver] The function to resolve the cache key.
 * @returns {Function} Returns the new memoized function.
 * @example
 *
 * var object = { 'a': 1, 'b': 2 };
 * var other = { 'c': 3, 'd': 4 };
 *
 * var values = _.memoize(_.values);
 * values(object);
 * // => [1, 2]
 *
 * values(other);
 * // => [3, 4]
 *
 * object.a = 2;
 * values(object);
 * // => [1, 2]
 *
 * // Modify the result cache.
 * values.cache.set(object, ['a', 'b']);
 * values(object);
 * // => ['a', 'b']
 *
 * // Replace `_.memoize.Cache`.
 * _.memoize.Cache = WeakMap;
 */
function memoize(func, resolver) {
  if (typeof func != 'function' || (resolver && typeof resolver != 'function')) {
    throw new TypeError(FUNC_ERROR_TEXT);
  }
  var memoized = function() {
    var args = arguments,
        key = resolver ? resolver.apply(this, args) : args[0],
        cache = memoized.cache;

    if (cache.has(key)) {
      return cache.get(key);
    }
    var result = func.apply(this, args);
    memoized.cache = cache.set(key, result);
    return result;
  };
  memoized.cache = new (memoize.Cache || MapCache);
  return memoized;
}

// Assign cache to `_.memoize`.
memoize.Cache = MapCache;

/**
 * Performs a
 * [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
 * comparison between two values to determine if they are equivalent.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to compare.
 * @param {*} other The other value to compare.
 * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
 * @example
 *
 * var object = { 'a': 1 };
 * var other = { 'a': 1 };
 *
 * _.eq(object, object);
 * // => true
 *
 * _.eq(object, other);
 * // => false
 *
 * _.eq('a', 'a');
 * // => true
 *
 * _.eq('a', Object('a'));
 * // => false
 *
 * _.eq(NaN, NaN);
 * // => true
 */
function eq(value, other) {
  return value === other || (value !== value && other !== other);
}

/**
 * Checks if `value` is likely an `arguments` object.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an `arguments` object,
 *  else `false`.
 * @example
 *
 * _.isArguments(function() { return arguments; }());
 * // => true
 *
 * _.isArguments([1, 2, 3]);
 * // => false
 */
function isArguments(value) {
  // Safari 8.1 makes `arguments.callee` enumerable in strict mode.
  return isArrayLikeObject(value) && hasOwnProperty.call(value, 'callee') &&
    (!propertyIsEnumerable.call(value, 'callee') || objectToString.call(value) == argsTag);
}

/**
 * Checks if `value` is classified as an `Array` object.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an array, else `false`.
 * @example
 *
 * _.isArray([1, 2, 3]);
 * // => true
 *
 * _.isArray(document.body.children);
 * // => false
 *
 * _.isArray('abc');
 * // => false
 *
 * _.isArray(_.noop);
 * // => false
 */
var isArray = Array.isArray;

/**
 * Checks if `value` is array-like. A value is considered array-like if it's
 * not a function and has a `value.length` that's an integer greater than or
 * equal to `0` and less than or equal to `Number.MAX_SAFE_INTEGER`.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is array-like, else `false`.
 * @example
 *
 * _.isArrayLike([1, 2, 3]);
 * // => true
 *
 * _.isArrayLike(document.body.children);
 * // => true
 *
 * _.isArrayLike('abc');
 * // => true
 *
 * _.isArrayLike(_.noop);
 * // => false
 */
function isArrayLike(value) {
  return value != null && isLength(value.length) && !isFunction(value);
}

/**
 * This method is like `_.isArrayLike` except that it also checks if `value`
 * is an object.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an array-like object,
 *  else `false`.
 * @example
 *
 * _.isArrayLikeObject([1, 2, 3]);
 * // => true
 *
 * _.isArrayLikeObject(document.body.children);
 * // => true
 *
 * _.isArrayLikeObject('abc');
 * // => false
 *
 * _.isArrayLikeObject(_.noop);
 * // => false
 */
function isArrayLikeObject(value) {
  return isObjectLike(value) && isArrayLike(value);
}

/**
 * Checks if `value` is classified as a `Function` object.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a function, else `false`.
 * @example
 *
 * _.isFunction(_);
 * // => true
 *
 * _.isFunction(/abc/);
 * // => false
 */
function isFunction(value) {
  // The use of `Object#toString` avoids issues with the `typeof` operator
  // in Safari 8-9 which returns 'object' for typed array and other constructors.
  var tag = isObject(value) ? objectToString.call(value) : '';
  return tag == funcTag || tag == genTag;
}

/**
 * Checks if `value` is a valid array-like length.
 *
 * **Note:** This method is loosely based on
 * [`ToLength`](http://ecma-international.org/ecma-262/7.0/#sec-tolength).
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a valid length, else `false`.
 * @example
 *
 * _.isLength(3);
 * // => true
 *
 * _.isLength(Number.MIN_VALUE);
 * // => false
 *
 * _.isLength(Infinity);
 * // => false
 *
 * _.isLength('3');
 * // => false
 */
function isLength(value) {
  return typeof value == 'number' &&
    value > -1 && value % 1 == 0 && value <= MAX_SAFE_INTEGER;
}

/**
 * Checks if `value` is the
 * [language type](http://www.ecma-international.org/ecma-262/7.0/#sec-ecmascript-language-types)
 * of `Object`. (e.g. arrays, functions, objects, regexes, `new Number(0)`, and `new String('')`)
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an object, else `false`.
 * @example
 *
 * _.isObject({});
 * // => true
 *
 * _.isObject([1, 2, 3]);
 * // => true
 *
 * _.isObject(_.noop);
 * // => true
 *
 * _.isObject(null);
 * // => false
 */
function isObject(value) {
  var type = typeof value;
  return !!value && (type == 'object' || type == 'function');
}

/**
 * Checks if `value` is object-like. A value is object-like if it's not `null`
 * and has a `typeof` result of "object".
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is object-like, else `false`.
 * @example
 *
 * _.isObjectLike({});
 * // => true
 *
 * _.isObjectLike([1, 2, 3]);
 * // => true
 *
 * _.isObjectLike(_.noop);
 * // => false
 *
 * _.isObjectLike(null);
 * // => false
 */
function isObjectLike(value) {
  return !!value && typeof value == 'object';
}

/**
 * Checks if `value` is classified as a `Symbol` primitive or object.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a symbol, else `false`.
 * @example
 *
 * _.isSymbol(Symbol.iterator);
 * // => true
 *
 * _.isSymbol('abc');
 * // => false
 */
function isSymbol(value) {
  return typeof value == 'symbol' ||
    (isObjectLike(value) && objectToString.call(value) == symbolTag);
}

/**
 * Checks if `value` is classified as a typed array.
 *
 * @static
 * @memberOf _
 * @since 3.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a typed array, else `false`.
 * @example
 *
 * _.isTypedArray(new Uint8Array);
 * // => true
 *
 * _.isTypedArray([]);
 * // => false
 */
var isTypedArray = nodeIsTypedArray ? baseUnary(nodeIsTypedArray) : baseIsTypedArray;

/**
 * Converts `value` to a string. An empty string is returned for `null`
 * and `undefined` values. The sign of `-0` is preserved.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to process.
 * @returns {string} Returns the string.
 * @example
 *
 * _.toString(null);
 * // => ''
 *
 * _.toString(-0);
 * // => '-0'
 *
 * _.toString([1, 2, 3]);
 * // => '1,2,3'
 */
function toString(value) {
  return value == null ? '' : baseToString(value);
}

/**
 * Gets the value at `path` of `object`. If the resolved value is
 * `undefined`, the `defaultValue` is returned in its place.
 *
 * @static
 * @memberOf _
 * @since 3.7.0
 * @category Object
 * @param {Object} object The object to query.
 * @param {Array|string} path The path of the property to get.
 * @param {*} [defaultValue] The value returned for `undefined` resolved values.
 * @returns {*} Returns the resolved value.
 * @example
 *
 * var object = { 'a': [{ 'b': { 'c': 3 } }] };
 *
 * _.get(object, 'a[0].b.c');
 * // => 3
 *
 * _.get(object, ['a', '0', 'b', 'c']);
 * // => 3
 *
 * _.get(object, 'a.b.c', 'default');
 * // => 'default'
 */
function get(object, path, defaultValue) {
  var result = object == null ? undefined : baseGet(object, path);
  return result === undefined ? defaultValue : result;
}

/**
 * Checks if `path` is a direct or inherited property of `object`.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Object
 * @param {Object} object The object to query.
 * @param {Array|string} path The path to check.
 * @returns {boolean} Returns `true` if `path` exists, else `false`.
 * @example
 *
 * var object = _.create({ 'a': _.create({ 'b': 2 }) });
 *
 * _.hasIn(object, 'a');
 * // => true
 *
 * _.hasIn(object, 'a.b');
 * // => true
 *
 * _.hasIn(object, ['a', 'b']);
 * // => true
 *
 * _.hasIn(object, 'b');
 * // => false
 */
function hasIn(object, path) {
  return object != null && hasPath(object, path, baseHasIn);
}

/**
 * Creates an array of the own enumerable property names of `object`.
 *
 * **Note:** Non-object values are coerced to objects. See the
 * [ES spec](http://ecma-international.org/ecma-262/7.0/#sec-object.keys)
 * for more details.
 *
 * @static
 * @since 0.1.0
 * @memberOf _
 * @category Object
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property names.
 * @example
 *
 * function Foo() {
 *   this.a = 1;
 *   this.b = 2;
 * }
 *
 * Foo.prototype.c = 3;
 *
 * _.keys(new Foo);
 * // => ['a', 'b'] (iteration order is not guaranteed)
 *
 * _.keys('hi');
 * // => ['0', '1']
 */
function keys(object) {
  return isArrayLike(object) ? arrayLikeKeys(object) : baseKeys(object);
}

/**
 * This method returns the first argument it receives.
 *
 * @static
 * @since 0.1.0
 * @memberOf _
 * @category Util
 * @param {*} value Any value.
 * @returns {*} Returns `value`.
 * @example
 *
 * var object = { 'a': 1 };
 *
 * console.log(_.identity(object) === object);
 * // => true
 */
function identity(value) {
  return value;
}

/**
 * Creates a function that returns the value at `path` of a given object.
 *
 * @static
 * @memberOf _
 * @since 2.4.0
 * @category Util
 * @param {Array|string} path The path of the property to get.
 * @returns {Function} Returns the new accessor function.
 * @example
 *
 * var objects = [
 *   { 'a': { 'b': 2 } },
 *   { 'a': { 'b': 1 } }
 * ];
 *
 * _.map(objects, _.property('a.b'));
 * // => [2, 1]
 *
 * _.map(_.sortBy(objects, _.property(['a', 'b'])), 'a.b');
 * // => [1, 2]
 */
function property(path) {
  return isKey(path) ? baseProperty(toKey(path)) : basePropertyDeep(path);
}

module.exports = orderBy;

/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__("yLpj"), __webpack_require__("YuTi")(module)))

/***/ }),

/***/ "STtz":
/***/ (function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(Buffer) {var js2xml = __webpack_require__("zvmt");

module.exports = function (json, options) {
  if (json instanceof Buffer) {
    json = json.toString();
  }
  var js = null;
  if (typeof (json) === 'string') {
    try {
      js = JSON.parse(json);
    } catch (e) {
      throw new Error('The JSON structure is invalid');
    }
  } else {
    js = json;
  }
  return js2xml(js, options);
};

/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__("tjlA").Buffer))

/***/ }),

/***/ "Sacq":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_babel_loader_lib_index_js_node_modules_ts_loader_index_js_ref_1_1_node_modules_vue_loader_lib_index_js_vue_loader_options_VideoPlayer_vue_vue_type_script_lang_ts___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("p1EF");
/* harmony import */ var _node_modules_babel_loader_lib_index_js_node_modules_ts_loader_index_js_ref_1_1_node_modules_vue_loader_lib_index_js_vue_loader_options_VideoPlayer_vue_vue_type_script_lang_ts___WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_babel_loader_lib_index_js_node_modules_ts_loader_index_js_ref_1_1_node_modules_vue_loader_lib_index_js_vue_loader_options_VideoPlayer_vue_vue_type_script_lang_ts___WEBPACK_IMPORTED_MODULE_0__);
/* harmony reexport (unknown) */ for(var __WEBPACK_IMPORT_KEY__ in _node_modules_babel_loader_lib_index_js_node_modules_ts_loader_index_js_ref_1_1_node_modules_vue_loader_lib_index_js_vue_loader_options_VideoPlayer_vue_vue_type_script_lang_ts___WEBPACK_IMPORTED_MODULE_0__) if(__WEBPACK_IMPORT_KEY__ !== 'default') (function(key) { __webpack_require__.d(__webpack_exports__, key, function() { return _node_modules_babel_loader_lib_index_js_node_modules_ts_loader_index_js_ref_1_1_node_modules_vue_loader_lib_index_js_vue_loader_options_VideoPlayer_vue_vue_type_script_lang_ts___WEBPACK_IMPORTED_MODULE_0__[key]; }) }(__WEBPACK_IMPORT_KEY__));
 /* harmony default export */ __webpack_exports__["default"] = (_node_modules_babel_loader_lib_index_js_node_modules_ts_loader_index_js_ref_1_1_node_modules_vue_loader_lib_index_js_vue_loader_options_VideoPlayer_vue_vue_type_script_lang_ts___WEBPACK_IMPORTED_MODULE_0___default.a); 

/***/ }),

/***/ "SksO":
/***/ (function(module, exports) {

function _setPrototypeOf(o, p) {
  module.exports = _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
    o.__proto__ = p;
    return o;
  };

  return _setPrototypeOf(o, p);
}

module.exports = _setPrototypeOf;

/***/ }),

/***/ "T016":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


module.exports = {
	"aliceblue": [240, 248, 255],
	"antiquewhite": [250, 235, 215],
	"aqua": [0, 255, 255],
	"aquamarine": [127, 255, 212],
	"azure": [240, 255, 255],
	"beige": [245, 245, 220],
	"bisque": [255, 228, 196],
	"black": [0, 0, 0],
	"blanchedalmond": [255, 235, 205],
	"blue": [0, 0, 255],
	"blueviolet": [138, 43, 226],
	"brown": [165, 42, 42],
	"burlywood": [222, 184, 135],
	"cadetblue": [95, 158, 160],
	"chartreuse": [127, 255, 0],
	"chocolate": [210, 105, 30],
	"coral": [255, 127, 80],
	"cornflowerblue": [100, 149, 237],
	"cornsilk": [255, 248, 220],
	"crimson": [220, 20, 60],
	"cyan": [0, 255, 255],
	"darkblue": [0, 0, 139],
	"darkcyan": [0, 139, 139],
	"darkgoldenrod": [184, 134, 11],
	"darkgray": [169, 169, 169],
	"darkgreen": [0, 100, 0],
	"darkgrey": [169, 169, 169],
	"darkkhaki": [189, 183, 107],
	"darkmagenta": [139, 0, 139],
	"darkolivegreen": [85, 107, 47],
	"darkorange": [255, 140, 0],
	"darkorchid": [153, 50, 204],
	"darkred": [139, 0, 0],
	"darksalmon": [233, 150, 122],
	"darkseagreen": [143, 188, 143],
	"darkslateblue": [72, 61, 139],
	"darkslategray": [47, 79, 79],
	"darkslategrey": [47, 79, 79],
	"darkturquoise": [0, 206, 209],
	"darkviolet": [148, 0, 211],
	"deeppink": [255, 20, 147],
	"deepskyblue": [0, 191, 255],
	"dimgray": [105, 105, 105],
	"dimgrey": [105, 105, 105],
	"dodgerblue": [30, 144, 255],
	"firebrick": [178, 34, 34],
	"floralwhite": [255, 250, 240],
	"forestgreen": [34, 139, 34],
	"fuchsia": [255, 0, 255],
	"gainsboro": [220, 220, 220],
	"ghostwhite": [248, 248, 255],
	"gold": [255, 215, 0],
	"goldenrod": [218, 165, 32],
	"gray": [128, 128, 128],
	"green": [0, 128, 0],
	"greenyellow": [173, 255, 47],
	"grey": [128, 128, 128],
	"honeydew": [240, 255, 240],
	"hotpink": [255, 105, 180],
	"indianred": [205, 92, 92],
	"indigo": [75, 0, 130],
	"ivory": [255, 255, 240],
	"khaki": [240, 230, 140],
	"lavender": [230, 230, 250],
	"lavenderblush": [255, 240, 245],
	"lawngreen": [124, 252, 0],
	"lemonchiffon": [255, 250, 205],
	"lightblue": [173, 216, 230],
	"lightcoral": [240, 128, 128],
	"lightcyan": [224, 255, 255],
	"lightgoldenrodyellow": [250, 250, 210],
	"lightgray": [211, 211, 211],
	"lightgreen": [144, 238, 144],
	"lightgrey": [211, 211, 211],
	"lightpink": [255, 182, 193],
	"lightsalmon": [255, 160, 122],
	"lightseagreen": [32, 178, 170],
	"lightskyblue": [135, 206, 250],
	"lightslategray": [119, 136, 153],
	"lightslategrey": [119, 136, 153],
	"lightsteelblue": [176, 196, 222],
	"lightyellow": [255, 255, 224],
	"lime": [0, 255, 0],
	"limegreen": [50, 205, 50],
	"linen": [250, 240, 230],
	"magenta": [255, 0, 255],
	"maroon": [128, 0, 0],
	"mediumaquamarine": [102, 205, 170],
	"mediumblue": [0, 0, 205],
	"mediumorchid": [186, 85, 211],
	"mediumpurple": [147, 112, 219],
	"mediumseagreen": [60, 179, 113],
	"mediumslateblue": [123, 104, 238],
	"mediumspringgreen": [0, 250, 154],
	"mediumturquoise": [72, 209, 204],
	"mediumvioletred": [199, 21, 133],
	"midnightblue": [25, 25, 112],
	"mintcream": [245, 255, 250],
	"mistyrose": [255, 228, 225],
	"moccasin": [255, 228, 181],
	"navajowhite": [255, 222, 173],
	"navy": [0, 0, 128],
	"oldlace": [253, 245, 230],
	"olive": [128, 128, 0],
	"olivedrab": [107, 142, 35],
	"orange": [255, 165, 0],
	"orangered": [255, 69, 0],
	"orchid": [218, 112, 214],
	"palegoldenrod": [238, 232, 170],
	"palegreen": [152, 251, 152],
	"paleturquoise": [175, 238, 238],
	"palevioletred": [219, 112, 147],
	"papayawhip": [255, 239, 213],
	"peachpuff": [255, 218, 185],
	"peru": [205, 133, 63],
	"pink": [255, 192, 203],
	"plum": [221, 160, 221],
	"powderblue": [176, 224, 230],
	"purple": [128, 0, 128],
	"rebeccapurple": [102, 51, 153],
	"red": [255, 0, 0],
	"rosybrown": [188, 143, 143],
	"royalblue": [65, 105, 225],
	"saddlebrown": [139, 69, 19],
	"salmon": [250, 128, 114],
	"sandybrown": [244, 164, 96],
	"seagreen": [46, 139, 87],
	"seashell": [255, 245, 238],
	"sienna": [160, 82, 45],
	"silver": [192, 192, 192],
	"skyblue": [135, 206, 235],
	"slateblue": [106, 90, 205],
	"slategray": [112, 128, 144],
	"slategrey": [112, 128, 144],
	"snow": [255, 250, 250],
	"springgreen": [0, 255, 127],
	"steelblue": [70, 130, 180],
	"tan": [210, 180, 140],
	"teal": [0, 128, 128],
	"thistle": [216, 191, 216],
	"tomato": [255, 99, 71],
	"turquoise": [64, 224, 208],
	"violet": [238, 130, 238],
	"wheat": [245, 222, 179],
	"white": [255, 255, 255],
	"whitesmoke": [245, 245, 245],
	"yellow": [255, 255, 0],
	"yellowgreen": [154, 205, 50]
};


/***/ }),

/***/ "T3Jp":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__("TqRt");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _GridLayer = _interopRequireDefault(__webpack_require__("mkpX"));

var _default = {
  mixins: [_GridLayer.default],
  props: {
    tms: {
      type: Boolean,
      default: false
    },
    detectRetina: {
      type: Boolean,
      default: false
    }
  },
  render: function render() {
    return null;
  }
};
exports.default = _default;

/***/ }),

/***/ "TPtX":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_Popup_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("V8Rk");
/* harmony import */ var _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_Popup_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_Popup_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__);
/* harmony reexport (unknown) */ for(var __WEBPACK_IMPORT_KEY__ in _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_Popup_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__) if(__WEBPACK_IMPORT_KEY__ !== 'default') (function(key) { __webpack_require__.d(__webpack_exports__, key, function() { return _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_Popup_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__[key]; }) }(__WEBPACK_IMPORT_KEY__));
 /* harmony default export */ __webpack_exports__["default"] = (_node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_Popup_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0___default.a); 

/***/ }),

/***/ "TTB2":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__("TqRt");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _util = __webpack_require__("e7LN");

var _theme = _interopRequireDefault(__webpack_require__("bCOg"));

//
//
//
//
//
//
var _default = {
  name: 'SmTimeText',
  mixins: [_theme.default],
  props: {
    timeType: {
      type: String,
      default: 'date' // "date+second" "date+second+week"

    },
    fontStyle: {
      type: Object
    }
  },
  data: function data() {
    return {
      time: '',
      timeInterval: null
    };
  },
  watch: {
    timeType: function timeType() {
      this.initTime(this.timeType);
    }
  },
  mounted: function mounted() {
    this.initTime(this.timeType);
  },
  destroyed: function destroyed() {
    clearInterval(this.timeInterval);
  },
  methods: {
    // 初始化
    initTime: function initTime(timeType) {
      var _this = this;

      clearInterval(this.timeInterval);
      this.time = (0, _util.getDateTime)(timeType);
      this.timeInterval = setInterval(function () {
        _this.time = (0, _util.getDateTime)(timeType);
      }, 1000);
    }
  }
};
exports.default = _default;

/***/ }),

/***/ "TVTA":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__("TqRt");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _theme = _interopRequireDefault(__webpack_require__("bCOg"));

var _util = __webpack_require__("e7LN");

//
//
//
//
//
//
//
//
//
//
//
//
//
var _default = {
  name: 'SmImage',
  mixins: [_theme.default],
  props: {
    src: {
      type: String
    },
    repeat: {
      type: String,
      default: 'center'
    },
    href: {
      type: String,
      default: ''
    },
    target: {
      type: String,
      default: '_self'
    }
  },
  data: function data() {
    return {
      repeatOption: {
        center: {
          backgroundRepeat: 'no-repeat',
          backgroundPosition: 'center'
        },
        noRepeat: {
          backgroundSize: '100% 100%',
          backgroundRepeat: 'no-repeat'
        },
        repeatX: {
          backgroundRepeat: 'repeat-x',
          backgroundSize: 'auto 100%'
        },
        repeatY: {
          backgroundRepeat: 'repeat-Y',
          backgroundSize: '100% auto'
        },
        repeatXY: {
          backgroundRepeat: 'repeat',
          backgroundSize: 'auto'
        }
      }
    };
  },
  computed: {
    repeatStyle: function repeatStyle() {
      return this.repeatOption[this.repeat];
    },
    imgUrl: function imgUrl() {
      return {
        backgroundImage: "url(".concat(this.src, ")")
      };
    },
    realHref: function realHref() {
      var href = this.href.replace(/ /g, '');

      if (href && !(0, _util.parseUrl)(href)) {
        return "http://".concat(href);
      }

      return href;
    }
  }
};
exports.default = _default;

/***/ }),

/***/ "TnLG":
/***/ (function(module, exports) {

module.exports = __WEBPACK_EXTERNAL_MODULE_TnLG__;

/***/ }),

/***/ "TqRt":
/***/ (function(module, exports) {

function _interopRequireDefault(obj) {
  return obj && obj.__esModule ? obj : {
    "default": obj
  };
}

module.exports = _interopRequireDefault;

/***/ }),

/***/ "U4oE":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Border_vue_vue_type_template_id_52e77cab___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("C55n");
/* harmony import */ var _Border_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("BtDp");
/* harmony reexport (unknown) */ for(var __WEBPACK_IMPORT_KEY__ in _Border_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_1__) if(__WEBPACK_IMPORT_KEY__ !== 'default') (function(key) { __webpack_require__.d(__webpack_exports__, key, function() { return _Border_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_1__[key]; }) }(__WEBPACK_IMPORT_KEY__));
/* harmony import */ var _node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("KHd+");





/* normalize component */

var component = Object(_node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_2__[/* default */ "a"])(
  _Border_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_1__["default"],
  _Border_vue_vue_type_template_id_52e77cab___WEBPACK_IMPORTED_MODULE_0__[/* render */ "a"],
  _Border_vue_vue_type_template_id_52e77cab___WEBPACK_IMPORTED_MODULE_0__[/* staticRenderFns */ "b"],
  false,
  null,
  null,
  null
  
)

/* harmony default export */ __webpack_exports__["default"] = (component.exports);

/***/ }),

/***/ "UJ84":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_SmTileLayer_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("HVJS");
/* harmony import */ var _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_SmTileLayer_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_SmTileLayer_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__);
/* harmony reexport (unknown) */ for(var __WEBPACK_IMPORT_KEY__ in _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_SmTileLayer_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__) if(__WEBPACK_IMPORT_KEY__ !== 'default') (function(key) { __webpack_require__.d(__webpack_exports__, key, function() { return _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_SmTileLayer_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__[key]; }) }(__WEBPACK_IMPORT_KEY__));
 /* harmony default export */ __webpack_exports__["default"] = (_node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_SmTileLayer_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0___default.a); 

/***/ }),

/***/ "UTm/":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";

// CONCATENATED MODULE: ./node_modules/vue-loader/lib/loaders/templateLoader.js??vue-loader-options!./node_modules/vue-loader/lib??vue-loader-options!./src/common/card/Card.vue?vue&type=template&id=0b7b8e8a&
var render = function () {
var _obj, _obj$1, _obj$2;
var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{staticClass:"sm-component-card"},[(_vm.iconClass)?_c('div',{class:( _obj = {}, _obj['sm-component-card__icon'] = true, _obj['is-' + _vm.position] = true, _obj[("is-click-" + (_vm.isShow ? 'out' : 'in'))] = true, _obj['is-not-header'] = !_vm.headerName, _obj ),style:([_vm.getBackgroundStyle, _vm.getTextColorStyle, _vm.iconStyleObject]),on:{"click":_vm.iconClicked}},[_c('div',{class:( _obj$1 = {}, _obj$1[_vm.iconClass] = true, _obj$1['is-auto-rotate'] = _vm.autoRotate, _obj$1['sm-component-card__component-icon'] = true, _obj$1 ),style:([_vm.iconStyle])})]):_vm._e(),_vm._v(" "),_c('transition',{attrs:{"name":"sm-component-zoom-in"},on:{"after-leave":function($event){return _vm.toggleTransition('leave')},"enter":function($event){return _vm.toggleTransition('enter')}}},[_c('div',{directives:[{name:"show",rawName:"v-show",value:(_vm.isShow),expression:"isShow"}],class:( _obj$2 = {}, _obj$2['sm-component-card__content'] = true, _obj$2['is-not-header'] = !_vm.headerName, _obj$2['is-' + _vm.position] = true, _obj$2['is-icon'] = _vm.iconClass, _obj$2 ),style:([_vm.getCardStyle])},[(_vm.headerName)?_c('div',{staticClass:"sm-component-card__header",style:([_vm.getBackgroundStyle, _vm.getTextColorStyle])},[_c('span',{staticClass:"sm-component-card__header-name"},[_vm._v(_vm._s(_vm.headerName))])]):_vm._e(),_vm._v(" "),_vm._t("default")],2)])],1)}
var staticRenderFns = []


// CONCATENATED MODULE: ./src/common/card/Card.vue?vue&type=template&id=0b7b8e8a&
/* concated harmony reexport render */__webpack_require__.d(__webpack_exports__, "a", function() { return render; });
/* concated harmony reexport staticRenderFns */__webpack_require__.d(__webpack_exports__, "b", function() { return staticRenderFns; });


/***/ }),

/***/ "UZyX":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";

// CONCATENATED MODULE: ./node_modules/vue-loader/lib/loaders/templateLoader.js??vue-loader-options!./node_modules/vue-loader/lib??vue-loader-options!./src/common/table-popup/TablePopup.vue?vue&type=template&id=38bfab64&
var render = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{staticClass:"sm-component-table-popup",style:([_vm.backgroundStyle, _vm.getTextColorStyle, _vm.styleObject])},[_c('a-table',{staticClass:"sm-component-table-popup__table",style:(_vm.backgroundStyle),attrs:{"data-source":_vm.data,"columns":_vm.columns,"rowKey":function (record, index) { return index; },"pagination":false}})],1)}
var staticRenderFns = []


// CONCATENATED MODULE: ./src/common/table-popup/TablePopup.vue?vue&type=template&id=38bfab64&
/* concated harmony reexport render */__webpack_require__.d(__webpack_exports__, "a", function() { return render; });
/* concated harmony reexport staticRenderFns */__webpack_require__.d(__webpack_exports__, "b", function() { return staticRenderFns; });


/***/ }),

/***/ "V8Rk":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__("TqRt");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _Popper = _interopRequireDefault(__webpack_require__("jDn+"));

var _Options = _interopRequireDefault(__webpack_require__("VeHG"));

var _vmUpdater = _interopRequireDefault(__webpack_require__("w286"));

var _theme = _interopRequireDefault(__webpack_require__("bCOg"));

var _mapGetter = _interopRequireDefault(__webpack_require__("KP9C"));

var _PopupViewModel = _interopRequireDefault(__webpack_require__("njMg"));

var _default2 = {
  name: 'SmPopup',
  mixins: [_Popper.default, _Options.default, _vmUpdater.default, _mapGetter.default, _theme.default],
  viewModelProps: ['latLng', 'content'],
  props: {
    latLng: {
      type: [Object, Array],
      default: function _default() {
        return [];
      }
    }
  },
  watch: {
    backgroundData: function backgroundData() {
      this.changePopupStyle();
    },
    options: function options() {
      this.loaded();
    }
  },
  loaded: function loaded() {
    var _this = this;

    this.setViewModel();
    this.mapObject = this.viewModel.getPopup();
    this.parentContainer = this.$parent; // 如果有父组件有mapObject,则可以绑定在上面(默认绑定在map上面)

    var parentContainerObject = this.parentContainer && this.parentContainer.mapObject || this.map;

    if (parentContainerObject) {
      // 如果有bindpopup方法的就绑定
      if (parentContainerObject.bindPopup) {
        parentContainerObject.bindPopup(this.mapObject);
        this.$nextTick(function () {
          _this.$emit('ready', _this.mapObject);
        });
        return;
      } // 如果是地图，则openOn(this.map)


      this.isMap = this.viewModel.isMap(parentContainerObject);

      if (this.isMap) {
        parentContainerObject.on('click', function (e) {
          var latLng = _this.map.layerPointToLatLng(e.layerPoint);

          _this.viewModel.setLatLng(latLng); // 通过slot进来的content


          if (_this.$el && _this.$el.style) {
            _this.$el.style.display = 'block';
          }

          _this.$nextTick(function () {
            _this.$emit('ready', _this.mapObject);
          });

          _this.$on('ready', _this.viewModel.openOnMap);
        });
      }
    }
  },
  beforeDestroy: function beforeDestroy() {
    if (this.parentContainer) {
      if (this.parentContainer.unbindPopup) {
        this.parentContainer.unbindPopup();
      } else if (this.parentContainer.mapObject && this.parentContainer.mapObject.unbindPopup) {
        this.parentContainer.mapObject.unbindPopup();
      }
    }
  },
  methods: {
    setViewModel: function setViewModel() {
      this.viewModel = new _PopupViewModel.default(this.map, {
        latLng: this.latLng,
        content: this.content || this.$el,
        options: this.options
      });
    },
    changePopupStyle: function changePopupStyle() {
      var popupContent = document.querySelector('.leaflet-popup-content-wrapper');
      var popupTip = document.querySelector('.leaflet-popup-tip');
      var popupCloseBtn = document.querySelector('.leaflet-container a.leaflet-popup-close-button:hover');

      if (popupContent) {
        popupContent.style.background = this.backgroundData;
      }

      if (popupTip) {
        popupTip.style.background = this.backgroundData;
      }

      if (popupCloseBtn) {
        popupTip.style.color = this.textColorsData;
      }
    }
  }
};
exports.default = _default2;

/***/ }),

/***/ "VEr5":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _VideoPlayer_vue_vue_type_template_id_6a6899a8___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("iPb/");
/* harmony import */ var _VideoPlayer_vue_vue_type_script_lang_ts___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("Sacq");
/* harmony reexport (unknown) */ for(var __WEBPACK_IMPORT_KEY__ in _VideoPlayer_vue_vue_type_script_lang_ts___WEBPACK_IMPORTED_MODULE_1__) if(__WEBPACK_IMPORT_KEY__ !== 'default') (function(key) { __webpack_require__.d(__webpack_exports__, key, function() { return _VideoPlayer_vue_vue_type_script_lang_ts___WEBPACK_IMPORTED_MODULE_1__[key]; }) }(__WEBPACK_IMPORT_KEY__));
/* harmony import */ var _node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("KHd+");





/* normalize component */

var component = Object(_node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_2__[/* default */ "a"])(
  _VideoPlayer_vue_vue_type_script_lang_ts___WEBPACK_IMPORTED_MODULE_1__["default"],
  _VideoPlayer_vue_vue_type_template_id_6a6899a8___WEBPACK_IMPORTED_MODULE_0__[/* render */ "a"],
  _VideoPlayer_vue_vue_type_template_id_6a6899a8___WEBPACK_IMPORTED_MODULE_0__[/* staticRenderFns */ "b"],
  false,
  null,
  null,
  null
  
)

/* harmony default export */ __webpack_exports__["default"] = (component.exports);

/***/ }),

/***/ "VeHG":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _default2 = {
  props: {
    options: {
      type: Object,
      default: function _default() {
        return null;
      }
    }
  }
};
exports.default = _default2;

/***/ }),

/***/ "VgK+":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _TimeText_vue_vue_type_template_id_6da009bc___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("WYr/");
/* harmony import */ var _TimeText_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("FHWo");
/* harmony reexport (unknown) */ for(var __WEBPACK_IMPORT_KEY__ in _TimeText_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_1__) if(__WEBPACK_IMPORT_KEY__ !== 'default') (function(key) { __webpack_require__.d(__webpack_exports__, key, function() { return _TimeText_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_1__[key]; }) }(__WEBPACK_IMPORT_KEY__));
/* harmony import */ var _node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("KHd+");





/* normalize component */

var component = Object(_node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_2__[/* default */ "a"])(
  _TimeText_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_1__["default"],
  _TimeText_vue_vue_type_template_id_6da009bc___WEBPACK_IMPORTED_MODULE_0__[/* render */ "a"],
  _TimeText_vue_vue_type_template_id_6da009bc___WEBPACK_IMPORTED_MODULE_0__[/* staticRenderFns */ "b"],
  false,
  null,
  null,
  null
  
)

/* harmony default export */ __webpack_exports__["default"] = (component.exports);

/***/ }),

/***/ "W1yv":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _default = {
  dateTimeFormat: {
    date: {
      year: 'numeric',
      month: 'short',
      day: 'numeric'
    },
    date_second: {
      year: 'numeric',
      month: 'short',
      day: 'numeric',
      hour: 'numeric',
      minute: 'numeric',
      second: 'numeric'
    },
    date_second_week: {
      year: 'numeric',
      month: 'short',
      day: 'numeric',
      weekday: 'long',
      hour: 'numeric',
      minute: 'numeric',
      second: 'numeric'
    }
  },
  // messageTemplate
  warning: {
    unsupportedVideoAddress: 'The video address is illegal',
    unavailableVideo: 'This video is temporarily unavailable, please try again later',
    mapNotLoaded: 'The associated map has not been loaded yet, please wait for a second',
    unassociatedMap: 'You need to configure the associated map!'
  },
  success: {},
  info: {
    loading: 'Loading...',
    pressEscToExit: 'Press the ESC key or click the close button to exit'
  },
  unit: {
    kilometers: 'km',
    miles: 'mi',
    meters: 'm',
    yards: 'yd',
    feet: 'ft',
    squarekilometers: 'sq km',
    squaremiles: 'sq mi',
    squaremeters: 'sq m',
    squareyards: 'sq yd',
    squarefeet: 'sq ft'
  },
  error: {},
  commontypes: {
    restData: 'SuperMap Rest Data Service',
    restMap: 'SuperMap Rest Map Service',
    addressMatch: 'SuperMap Address Matching Service',
    iportalData: 'SuperMap iPortal Data',
    onlineLocalSearch: 'SuperMap Online Local Search'
  },
  // 微件
  timeText: {
    Year: 'year',
    Month: 'month',
    Day: 'd',
    hour: 'h',
    minute: 'min',
    second: 's'
  },
  zoom: {},
  chart: {
    unSupportedData: 'The current data does not support linkage with the map'
  },
  layerList: {
    title: 'Layer'
  },
  miniMap: {},
  pan: {},
  scale: {},
  webmap: {
    loadingTip: 'Map is loading...',
    crsNotSupport: 'The coordinate system of the current map is not supported!',
    TileMatrixSetNotSuppport: 'Incoming TileMatrixSet is not supported!',
    getLayerInfoFailed: 'Failed to get layer information!',
    crsnotsupport: 'Unsupported coordinate system!',
    baiduMapNotSupport: 'Baidu maps is not supported yet!',
    sampleDataNotSupport: 'Sample datas is not supported yet!',
    mvtNotSupport: 'Vector tile layers is not supported yet!'
  },
  legend: {
    themeField: 'Thematic Field',
    title: 'Legend',
    top: 'Highest',
    bottom: 'Lowest',
    noMatchLayer: 'No matching layer'
  },
  measure: {
    mapMeasure: 'Measure',
    measureResult: 'Measurement Result',
    distance: 'Distance',
    area: 'Area',
    delete: 'Empty',
    selectPlaceholder: 'Please Select',
    startingPoint: 'Starting Point'
  },
  search: {
    noResult: 'The query result is empty!',
    noKey: 'The search keyword cannot be empty. Please enter the search condition.',
    inputPlaceHolder: 'Find an address or location',
    attribute: 'Attribute',
    attributeValue: 'Attribute Value',
    setSearchSource: 'Please set the search source!',
    address: 'Address',
    null: 'Null',
    illegalFeature: 'Features must contain legal coordinates!'
  },
  query: {
    query: 'Query',
    queryJob: 'Task',
    queryResult: 'Result',
    attributeCondition: 'Attribute Condition',
    spatialFilter: 'Spatial Filter',
    mapBounds: 'Query within the whole map extent',
    currentMapBounds: 'Query within current viewbound',
    applicate: 'Apply',
    noResult: 'No Result',
    resultAlreadyExists: 'The current query result already exists!',
    querying: 'Querying...',
    attribute: 'Attribute',
    attributeValue: 'Attribute Value',
    noResults: 'The query result is empty!',
    queryFailed: 'Query failed!',
    seviceNotSupport: 'This service does not support queries!'
  },
  identify: {
    layerNotExit: "The layer '{layer}' does not exist in the map's style"
  },
  openFile: {
    fileSizeExceeded: "The file size is too big! The file size can't exceed 10M!",
    fileTypeUnsupported: 'This file format is not supported!',
    openFileFail: 'File open failed!',
    openFileSuccess: 'File open succeeded!',
    selectFile: 'Select File',
    openEmptyFile: 'The opened file is empty!',
    openFile: 'Open File'
  },
  draw: {
    draw: 'Draw'
  },
  indicator: {
    title: 'Indicator Title',
    unit: 'Unit'
  },
  tdtResults: {
    on: 'on ',
    station: ' station',
    total: 'total',
    about: 'about ',
    // pagination
    homePage: 'Home',
    prevPage: 'Previous',
    nextPage: 'Next',
    // nothingResult
    searchNoResult: 'No related results were found',
    youCanTry: 'You can try',
    enterCorrect: 'Check if the input is correct',
    enterOtherKeyWords: 'Enter another keyword to search',
    onTdtMap: 'On the map of the sky',
    addThisAddress: 'Add this address',
    uWantTo: 'Are you looking for',
    // pointResults
    totalFind: 'found',
    piecesResults: 'result',
    phone: 'Tell',
    address: 'Address',
    setStartPonint: 'Set as starting point',
    setEndPonint: 'Set as end point',
    // routePlan
    totalMiles: 'total mileage',
    distance: 'About {distance} km',
    showDetails: 'Show full details',
    switchTimes: 'Transfer {switchTimes} times',
    noSwitch: 'No transfer',
    walk: 'Walk to',
    getOff: 'get off',
    getOn: 'boarding',
    take: 'take ',
    noSearchResults: 'No line information was found',
    fastRoute: 'Fastest line',
    shortRoute: 'Shortest line',
    walkRoute: 'Less high speed',
    fast: 'Faster',
    noSubway: 'No subway',
    lessSwitch: 'Less transfer',
    lessWalk: 'Less walking',
    // staticResult
    cityHadResults: 'The following cities have results, please choose',
    moreCity: 'More cities',
    // LineResult
    allFound: 'Found for you',
    piecesBusRoute: 'bus route',
    showDetail: 'Expand details',
    busEndTime: 'First and last bus time',
    relateAdress: 'Click here to see the location of "{keyWord}"',
    // areaResult
    switchTo: 'Switched to'
  },
  tdtRoute: {
    title: 'Route',
    clearRoute: 'Clear route',
    pleaseEnterStartPoint: 'Please enter the starting address',
    pleaseEnterEndPoint: 'Please enter the destination address',
    search: 'Search',
    startPoint: 'Starting address',
    endPoint: 'Destination address',
    mapLoadedFiled: 'Map failed to load',
    busEndTime: 'First and last bus time',
    about: 'about ',
    station: ' station',
    total: 'total',
    hour: ' hour',
    minutes: ' minutes'
  },
  tdtSearch: {
    phone: 'Tell',
    address: 'Address',
    noData: 'No data',
    transport: 'traffic'
  },
  tdtMapSwitcher: {
    title: 'Map Switcher',
    image: 'image',
    vector: 'vector',
    terrain: 'terrain',
    placeName: 'placeName',
    TiandituVec: 'TiandituVecLayer',
    TiandituTer: 'TiandituTerLayer',
    TiandituImg: 'TiandituImgLayer',
    TiandituCva: 'TiandituCvaLabel',
    TiandituCta: 'TiandituCtaLabel',
    TiandituCia: 'TiandituCiaLabel'
  },
  // layer
  dataFlow: {
    dataSubscriptionFailed: 'Data subscription failed!'
  },
  animateMarkerlayer: {
    unsupportedData: 'The data is not supported, please reset the data!'
  }
};
exports.default = _default;

/***/ }),

/***/ "W6Z/":
/***/ (function(module) {

module.exports = JSON.parse("{\"border1\":{\"type\":\"1\",\"borderWidth\":[12,12,12,12],\"borderEdge\":{\"top\":12,\"left\":12,\"right\":12,\"bottom\":12}},\"border2\":{\"type\":\"2\",\"borderWidth\":[12,12,12,12],\"borderEdge\":{\"top\":12,\"left\":12,\"right\":12,\"bottom\":12}},\"border3\":{\"type\":\"3\",\"borderWidth\":[19,19,19,19],\"borderEdge\":{\"top\":19,\"left\":19,\"right\":19,\"bottom\":19}},\"border4\":{\"type\":\"4\",\"borderWidth\":[20,40,20,40],\"borderEdge\":{\"top\":20,\"left\":20,\"right\":20,\"bottom\":20}},\"border5\":{\"type\":\"5\",\"borderWidth\":[12,135,12,160],\"borderEdge\":{\"top\":12,\"left\":12,\"right\":12,\"bottom\":12}},\"border6\":{\"type\":\"6\",\"borderWidth\":[12,12,12,12],\"borderEdge\":{\"top\":12,\"left\":12,\"right\":12,\"bottom\":12}},\"border7\":{\"type\":\"7\",\"borderWidth\":[88,138,134,130],\"borderEdge\":{\"top\":30,\"left\":30,\"right\":32,\"bottom\":32}},\"border8\":{\"type\":\"8\",\"borderWidth\":[24,100,24,100],\"borderEdge\":{\"top\":17,\"left\":17,\"right\":17,\"bottom\":17}},\"border9\":{\"type\":\"9\",\"borderWidth\":[100,90,70,75],\"borderEdge\":{\"top\":32,\"left\":32,\"right\":32,\"bottom\":32}},\"border10\":{\"type\":\"10\",\"borderWidth\":[27,104,100,52],\"borderEdge\":{\"top\":27,\"left\":23,\"right\":60,\"bottom\":44}},\"border11\":{\"type\":\"11\",\"borderWidth\":[26,52,26,52],\"borderEdge\":{\"top\":12,\"left\":12,\"right\":12,\"bottom\":12}},\"border12\":{\"type\":\"12\",\"borderWidth\":[109,271,100,180],\"borderEdge\":{\"top\":30,\"left\":12,\"right\":12,\"bottom\":25}},\"border13\":{\"type\":\"13\",\"borderWidth\":[20,24,20,24],\"borderEdge\":{\"top\":20,\"left\":22,\"right\":24,\"bottom\":20}}}");

/***/ }),

/***/ "W8MJ":
/***/ (function(module, exports) {

function _defineProperties(target, props) {
  for (var i = 0; i < props.length; i++) {
    var descriptor = props[i];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor) descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}

function _createClass(Constructor, protoProps, staticProps) {
  if (protoProps) _defineProperties(Constructor.prototype, protoProps);
  if (staticProps) _defineProperties(Constructor, staticProps);
  return Constructor;
}

module.exports = _createClass;

/***/ }),

/***/ "WE1v":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAABSCAMAAAAhFXfZAAAC91BMVEVMaXEzeak2f7I4g7g3g7cua5gzeKg8hJo3grY4g7c3grU0gLI2frE0daAubJc2gbQwd6QzeKk2gLMtd5sxdKIua5g1frA2f7IydaM0e6w2fq41fK01eqo3grgubJgta5cxdKI1f7AydaQydaMxc6EubJgvbJkwcZ4ubZkwcJwubZgubJcydqUydKIxapgubJctbJcubZcubJcvbJYubJcvbZkubJctbJctbZcubJg2f7AubJcrbZcubJcubJcua5g3grY0fq8ubJcubJdEkdEwhsw6i88vhswuhcsuhMtBjMgthMsrg8srgss6is8qgcs8i9A9iMYtg8spgcoogMo7hcMngMonf8olfso4gr8kfck5iM8jfMk4iM8he8k1fro7itAgesk2hs8eecgzfLcofssdeMg0hc4cd8g2hcsxeLQbdsgZdcgxeLImfcszhM0vda4xgckzhM4xg84wf8Yxgs4udKsvfcQucqhUndROmdM1fK0wcZ8vb5w0eqpQm9MzeKhXoNVcpdYydKNWn9VZotVKltJFjsIwcJ1Rms9OlslLmtH///8+kc9epdYzd6dbo9VHkMM2f7FHmNBClM8ydqVcpNY9hro3gLM9hLczealQmcw3fa46f7A8gLMxc6I3eagyc6FIldJMl9JSnNRSntNNl9JPnNJFi75UnM9ZodVKksg8kM45jc09e6ZHltFBk883gbRBh7pDk9EwcaBzn784g7dKkcY2i81Om9M7j85Llc81is09g7Q4grY/j9A0eqxKmdFFltBEjcXf6fFImdBCiLxJl9FGlNFBi78yiMxVndEvbpo6js74+vx+psPP3+o/ks5HkcpGmNCjwdZCkNDM3ehYoNJEls+lxNkxh8xHks0+jdC1zd5Lg6r+/v/H2ufz9/o3jM3t8/edvdM/k89Th61OiLBSjbZklbaTt9BfptdjmL1AicBHj8hGk9FAgK1dkLNTjLRekrdClc/k7fM0icy0y9tgp9c4jc2NtM9Dlc8zicxeXZn3AAAAQ3RSTlMAHDdTb4yPA+LtnEQmC4L2EmHqB7XA0d0sr478x4/Yd5i1zOfyPkf1sLVq4Nh3FvjxopQ2/STNuFzUwFIwxKaejILpIBEV9wAABhVJREFUeF6s1NdyFEcYBeBeoQIhRAkLlRDGrhIgY3BJL8CVeKzuyXFzzjkn5ZxzzuScg3PO8cKzu70JkO0LfxdTU//pM9vTu7Xgf6KqOVTb9X7toRrVEfBf1HTVjZccrT/2by1VV928Yty9ZbVuucdz90frG8DBjl9pVApbOstvmMuvVgaNXSfAAd6pGxpy6yxf5ph43pS/4f3uoaGm2rdu72S9xzOvMymkZFq/ptDrk90mhW7e4zl7HLzhxGWPR20xmSxJ/VqldG5m9XhaVOA1DadsNh3Pu5L2N6QtPO/32JpqQBVVk20oy/Pi2s23WEvyfHbe1thadVQttvm7Llf65gGmXK67XtupyoM7HQhmXdLS8oGWJNeOJ3C5fG5XCEJnkez3/oFdsvgJ4l2ANZwhrJKk/7OSXa+3Vw2WJMlKnGkobouYk6T0TyX30klOUnTD9HJ5qpckL3EW/w4XF3Xd0FGywXUrstrclVsqz5Pd/sXFYyDnPdrLcQODmGOK47IZb4CmibmMn+MYRzFZ5jg33ZL/EJrWcszHmANy3ARBK/IXtciJy8VsitPSdE3uuHxzougojcUdr8/32atnz/ev3f/K5wtpxUTpcaI45zusVDpYtZi+jg0oU9b3x74h7+n9ABvYEZeKaVq0sh0AtLKsFtqNBdeT0MrSzwwlq9+x6xAO4tgOtSzbCjrNQQiNvQUbUEubvzBUeGw26yDCsRHCoLkTHDa7IdOLIThs/gHvChszh2CimE8peRs47cxANI0lYNB5y1DljpOF0IhzBDPOZnDOqYYbeGKECbPzWnXludPphw5c2YBq5zlwXphIbO4VDCZ0gnPfUO1TwZoYwAs2ExPCedAu9DAjfQUjzITQb3jNj0KG2Sgt6BHaQUdYzWz+XmBktOHwanXjaSTcwwziBcuMOtwBmqPrTOxFQR/DRKKPqyur0aiW6cULYsx6tBm0jXpR/AUWR6HRq9WVW6MRhIq5jLyjbaCTDCijyYJNpCajdyobP/eTw0iexBAKkJ3gA5KcQb2zBXsIBckn+xVv8jkZSaEFHE+jFEleAEfayRU0MouNoBmB/L50Ai/HSLIHxcrpCvnhSQAuakKp2C/YbCylJjXRVy/z3+Kv/RrNcCo+WUzlVEhzKffnTQnxeN9fWF88fiNCUdSTsaufaChKWInHeysygfpIqagoakW+vV20J8uyl6TyNKEZWV4oRSPyCkWpgOLSbkCObT8o2r6tlG58HQquf6O0v50tB7JM7F4EORd2dx/K0w/KHsVkLPaoYrwgP/y7krr3SSMA4zj+OBgmjYkxcdIJQyQRKgg2viX9Hddi9UBb29LrKR7CVVEEEXWojUkXNyfTNDE14W9gbHJNuhjDettN3ZvbOvdOqCD3Jp/9l+/wJE+9PkYGjx/fqkys3S2rMozM/o2106rfMUINo6hVqz+eu/hd1c4xTg0TAfy5kV+4UG6+IthHTU9woWmxuKNbTfuCSfovBCxq7EtHqvYL4Sm6F8GVxsSXHMQ07TOi1DKtZxjWaaIyi4CXWjxPccUw8WVbMYY5wxC1mzEyXMJWkllpRloi+Kkoq69sxBTlElF6aAxYUbjXNlhlDZilDnM4U5SlN5biRsRHnbx3mbeWjEh4mEyiuJDl5XcWVmX5GvNkFgLWZM5qwsop4/AWfLhU1cR7k1VVvcYCWRkOI6Xy5gmnphCYIkvzuNYzHzosq2oNk2RtSs8khfUOfHIDgR6ysYBaMpl4uEgk2U/oJTs9AaTSwma7dT69geAE2ZpEjUsn2ieJNHeKfrI3EcAGJ2ZaNgVuC8EBctCLc57P5u5led6IOBkIYkuQMrmmjChs4VkfOerHqSBkPzZlhe06RslZ3zMjk2sscqKwY0RcjKK+LWbzd7KiHhkncs/siFJ+V5eXxD34B8nVuJEpGJNmxN2gH3vSvp7J70tF+D1Ej8qUJD1TkErAND2GZwTFg/LubvmgiBG3SOvdlsqFQrkEzJCL1rstlnVFROixZoDDSuXQFHESwVGlcuQcMb/b42NgjLowh5MTDFE3vNB5qStRIErdCQEh6pLPR92anSUb/wAIhldAaDMpGgAAAABJRU5ErkJggg=="

/***/ }),

/***/ "WFqU":
/***/ (function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(global) {/** Detect free variable `global` from Node.js. */
var freeGlobal = typeof global == 'object' && global && global.Object === Object && global;

module.exports = freeGlobal;

/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__("yLpj")))

/***/ }),

/***/ "WOGj":
/***/ (function(module, exports) {

/*
	Based on rgbcolor.js by Stoyan Stefanov <sstoo@gmail.com>
	http://www.phpied.com/rgb-color-parser-in-javascript/
*/

module.exports = function(color_string) {
    this.ok = false;
    this.alpha = 1.0;

    // strip any leading #
    if (color_string.charAt(0) == '#') { // remove # if any
        color_string = color_string.substr(1,6);
    }

    color_string = color_string.replace(/ /g,'');
    color_string = color_string.toLowerCase();

    // before getting into regexps, try simple matches
    // and overwrite the input
    var simple_colors = {
        aliceblue: 'f0f8ff',
        antiquewhite: 'faebd7',
        aqua: '00ffff',
        aquamarine: '7fffd4',
        azure: 'f0ffff',
        beige: 'f5f5dc',
        bisque: 'ffe4c4',
        black: '000000',
        blanchedalmond: 'ffebcd',
        blue: '0000ff',
        blueviolet: '8a2be2',
        brown: 'a52a2a',
        burlywood: 'deb887',
        cadetblue: '5f9ea0',
        chartreuse: '7fff00',
        chocolate: 'd2691e',
        coral: 'ff7f50',
        cornflowerblue: '6495ed',
        cornsilk: 'fff8dc',
        crimson: 'dc143c',
        cyan: '00ffff',
        darkblue: '00008b',
        darkcyan: '008b8b',
        darkgoldenrod: 'b8860b',
        darkgray: 'a9a9a9',
        darkgreen: '006400',
        darkkhaki: 'bdb76b',
        darkmagenta: '8b008b',
        darkolivegreen: '556b2f',
        darkorange: 'ff8c00',
        darkorchid: '9932cc',
        darkred: '8b0000',
        darksalmon: 'e9967a',
        darkseagreen: '8fbc8f',
        darkslateblue: '483d8b',
        darkslategray: '2f4f4f',
        darkturquoise: '00ced1',
        darkviolet: '9400d3',
        deeppink: 'ff1493',
        deepskyblue: '00bfff',
        dimgray: '696969',
        dodgerblue: '1e90ff',
        feldspar: 'd19275',
        firebrick: 'b22222',
        floralwhite: 'fffaf0',
        forestgreen: '228b22',
        fuchsia: 'ff00ff',
        gainsboro: 'dcdcdc',
        ghostwhite: 'f8f8ff',
        gold: 'ffd700',
        goldenrod: 'daa520',
        gray: '808080',
        green: '008000',
        greenyellow: 'adff2f',
        honeydew: 'f0fff0',
        hotpink: 'ff69b4',
        indianred : 'cd5c5c',
        indigo : '4b0082',
        ivory: 'fffff0',
        khaki: 'f0e68c',
        lavender: 'e6e6fa',
        lavenderblush: 'fff0f5',
        lawngreen: '7cfc00',
        lemonchiffon: 'fffacd',
        lightblue: 'add8e6',
        lightcoral: 'f08080',
        lightcyan: 'e0ffff',
        lightgoldenrodyellow: 'fafad2',
        lightgrey: 'd3d3d3',
        lightgreen: '90ee90',
        lightpink: 'ffb6c1',
        lightsalmon: 'ffa07a',
        lightseagreen: '20b2aa',
        lightskyblue: '87cefa',
        lightslateblue: '8470ff',
        lightslategray: '778899',
        lightsteelblue: 'b0c4de',
        lightyellow: 'ffffe0',
        lime: '00ff00',
        limegreen: '32cd32',
        linen: 'faf0e6',
        magenta: 'ff00ff',
        maroon: '800000',
        mediumaquamarine: '66cdaa',
        mediumblue: '0000cd',
        mediumorchid: 'ba55d3',
        mediumpurple: '9370d8',
        mediumseagreen: '3cb371',
        mediumslateblue: '7b68ee',
        mediumspringgreen: '00fa9a',
        mediumturquoise: '48d1cc',
        mediumvioletred: 'c71585',
        midnightblue: '191970',
        mintcream: 'f5fffa',
        mistyrose: 'ffe4e1',
        moccasin: 'ffe4b5',
        navajowhite: 'ffdead',
        navy: '000080',
        oldlace: 'fdf5e6',
        olive: '808000',
        olivedrab: '6b8e23',
        orange: 'ffa500',
        orangered: 'ff4500',
        orchid: 'da70d6',
        palegoldenrod: 'eee8aa',
        palegreen: '98fb98',
        paleturquoise: 'afeeee',
        palevioletred: 'd87093',
        papayawhip: 'ffefd5',
        peachpuff: 'ffdab9',
        peru: 'cd853f',
        pink: 'ffc0cb',
        plum: 'dda0dd',
        powderblue: 'b0e0e6',
        purple: '800080',
        rebeccapurple: '663399',
        red: 'ff0000',
        rosybrown: 'bc8f8f',
        royalblue: '4169e1',
        saddlebrown: '8b4513',
        salmon: 'fa8072',
        sandybrown: 'f4a460',
        seagreen: '2e8b57',
        seashell: 'fff5ee',
        sienna: 'a0522d',
        silver: 'c0c0c0',
        skyblue: '87ceeb',
        slateblue: '6a5acd',
        slategray: '708090',
        snow: 'fffafa',
        springgreen: '00ff7f',
        steelblue: '4682b4',
        tan: 'd2b48c',
        teal: '008080',
        thistle: 'd8bfd8',
        tomato: 'ff6347',
        turquoise: '40e0d0',
        violet: 'ee82ee',
        violetred: 'd02090',
        wheat: 'f5deb3',
        white: 'ffffff',
        whitesmoke: 'f5f5f5',
        yellow: 'ffff00',
        yellowgreen: '9acd32'
    };
    color_string = simple_colors[color_string] || color_string;
    // emd of simple type-in colors

    // array of color definition objects
    var color_defs = [
        {
            re: /^rgba\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3}),\s*((?:\d?\.)?\d)\)$/,
            example: ['rgba(123, 234, 45, 0.8)', 'rgba(255,234,245,1.0)'],
            process: function (bits){
                return [
                    parseInt(bits[1]),
                    parseInt(bits[2]),
                    parseInt(bits[3]),
                    parseFloat(bits[4])
                ];
            }
        },
        {
            re: /^rgb\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3})\)$/,
            example: ['rgb(123, 234, 45)', 'rgb(255,234,245)'],
            process: function (bits){
                return [
                    parseInt(bits[1]),
                    parseInt(bits[2]),
                    parseInt(bits[3])
                ];
            }
        },
        {
            re: /^([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})$/,
            example: ['#00ff00', '336699'],
            process: function (bits){
                return [
                    parseInt(bits[1], 16),
                    parseInt(bits[2], 16),
                    parseInt(bits[3], 16)
                ];
            }
        },
        {
            re: /^([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})$/,
            example: ['#fb0', 'f0f'],
            process: function (bits){
                return [
                    parseInt(bits[1] + bits[1], 16),
                    parseInt(bits[2] + bits[2], 16),
                    parseInt(bits[3] + bits[3], 16)
                ];
            }
        }
    ];

    // search through the definitions to find a match
    for (var i = 0; i < color_defs.length; i++) {
        var re = color_defs[i].re;
        var processor = color_defs[i].process;
        var bits = re.exec(color_string);
        if (bits) {
            var channels = processor(bits);
            this.r = channels[0];
            this.g = channels[1];
            this.b = channels[2];
            if (channels.length > 3) {
                this.alpha = channels[3];
            }
            this.ok = true;
        }

    }

    // validate/cleanup values
    this.r = (this.r < 0 || isNaN(this.r)) ? 0 : ((this.r > 255) ? 255 : this.r);
    this.g = (this.g < 0 || isNaN(this.g)) ? 0 : ((this.g > 255) ? 255 : this.g);
    this.b = (this.b < 0 || isNaN(this.b)) ? 0 : ((this.b > 255) ? 255 : this.b);
    this.alpha = (this.alpha < 0) ? 0 : ((this.alpha > 1.0 || isNaN(this.alpha)) ? 1.0 : this.alpha);

    // some getters
    this.toRGB = function () {
        return 'rgb(' + this.r + ', ' + this.g + ', ' + this.b + ')';
    }
    this.toRGBA = function () {
        return 'rgba(' + this.r + ', ' + this.g + ', ' + this.b + ', ' + this.alpha + ')';
    }
    this.toHex = function () {
        var r = this.r.toString(16);
        var g = this.g.toString(16);
        var b = this.b.toString(16);
        if (r.length == 1) r = '0' + r;
        if (g.length == 1) g = '0' + g;
        if (b.length == 1) b = '0' + b;
        return '#' + r + g + b;
    }

    // help
    this.getHelpXML = function () {

        var examples = new Array();
        // add regexps
        for (var i = 0; i < color_defs.length; i++) {
            var example = color_defs[i].example;
            for (var j = 0; j < example.length; j++) {
                examples[examples.length] = example[j];
            }
        }
        // add type-in colors
        for (var sc in simple_colors) {
            examples[examples.length] = sc;
        }

        var xml = document.createElement('ul');
        xml.setAttribute('id', 'rgbcolor-examples');
        for (var i = 0; i < examples.length; i++) {
            try {
                var list_item = document.createElement('li');
                var list_color = new RGBColor(examples[i]);
                var example_div = document.createElement('div');
                example_div.style.cssText =
                        'margin: 3px; '
                        + 'border: 1px solid black; '
                        + 'background:' + list_color.toHex() + '; '
                        + 'color:' + list_color.toHex()
                ;
                example_div.appendChild(document.createTextNode('test'));
                var list_item_value = document.createTextNode(
                    ' ' + examples[i] + ' -> ' + list_color.toRGB() + ' -> ' + list_color.toHex()
                );
                list_item.appendChild(example_div);
                list_item.appendChild(list_item_value);
                xml.appendChild(list_item);

            } catch(e){}
        }
        return xml;

    }

}


/***/ }),

/***/ "WYr/":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";

// CONCATENATED MODULE: ./node_modules/vue-loader/lib/loaders/templateLoader.js??vue-loader-options!./node_modules/vue-loader/lib??vue-loader-options!./src/common/time-text/TimeText.vue?vue&type=template&id=6da009bc&
var render = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{staticClass:"sm-component-time-text",style:([_vm.fontStyle, _vm.getBackgroundStyle, _vm.getTextColorStyle])},[_c('span',[_vm._v(_vm._s(_vm.time))])])}
var staticRenderFns = []


// CONCATENATED MODULE: ./src/common/time-text/TimeText.vue?vue&type=template&id=6da009bc&
/* concated harmony reexport render */__webpack_require__.d(__webpack_exports__, "a", function() { return render; });
/* concated harmony reexport staticRenderFns */__webpack_require__.d(__webpack_exports__, "b", function() { return staticRenderFns; });


/***/ }),

/***/ "Whz7":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__("TqRt");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _vue = _interopRequireDefault(__webpack_require__("i7/w"));

var _globalEvent = _interopRequireDefault(__webpack_require__("qF08"));

var _default = new _vue.default({
  mapCache: {},
  webMapCache: {},
  getMap: function getMap(mapTarget) {
    return this.mapCache[mapTarget];
  },
  getAllMaps: function getAllMaps() {
    return this.mapCache;
  },
  setMap: function setMap(mapTarget, map) {
    this.mapCache[mapTarget] = map;
  },
  deleteMap: function deleteMap(mapTarget) {
    _globalEvent.default.$emit('delete-map', mapTarget);

    delete this.mapCache[mapTarget];
  },
  getWebMap: function getWebMap(webmapTarget) {
    return this.webMapCache[webmapTarget];
  },
  getAllWebMap: function getAllWebMap() {
    return this.webMapCache;
  },
  setWebMap: function setWebMap(webmapTarget, webmap) {
    this.webMapCache[webmapTarget] = webmap;
  },
  deleteWebMap: function deleteWebMap(webmapTarget) {
    delete this.webMapCache[webmapTarget];
  }
});

exports.default = _default;

/***/ }),

/***/ "Wt6/":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__("TqRt");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _Card = _interopRequireDefault(__webpack_require__("GD9B"));

var _default = {
  components: {
    'sm-card': _Card.default
  },
  data: function data() {
    return {
      isShow: true
    };
  },
  props: {
    position: {
      type: String,
      default: 'top-left',
      validator: function validator(value) {
        return ['top-left', 'top-right', 'bottom-left', 'bottom-right'].includes(value);
      }
    },
    iconClass: {
      type: String
    },
    autoRotate: {
      type: Boolean,
      default: false
    },
    headerName: {
      type: String
    },
    collapsed: {
      type: Boolean,
      // 是否折叠
      default: false
    }
  }
};
exports.default = _default;

/***/ }),

/***/ "X7Q1":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,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"

/***/ }),

/***/ "XaGS":
/***/ (function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(global, module) {/**
 * Lodash (Custom Build) <https://lodash.com/>
 * Build: `lodash modularize exports="npm" -o ./`
 * Copyright JS Foundation and other contributors <https://js.foundation/>
 * Released under MIT license <https://lodash.com/license>
 * Based on Underscore.js 1.8.3 <http://underscorejs.org/LICENSE>
 * Copyright Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
 */

/** Used as the size to enable large array optimizations. */
var LARGE_ARRAY_SIZE = 200;

/** Used to stand-in for `undefined` hash values. */
var HASH_UNDEFINED = '__lodash_hash_undefined__';

/** Used to compose bitmasks for value comparisons. */
var COMPARE_PARTIAL_FLAG = 1,
    COMPARE_UNORDERED_FLAG = 2;

/** Used as references for various `Number` constants. */
var MAX_SAFE_INTEGER = 9007199254740991;

/** `Object#toString` result references. */
var argsTag = '[object Arguments]',
    arrayTag = '[object Array]',
    asyncTag = '[object AsyncFunction]',
    boolTag = '[object Boolean]',
    dateTag = '[object Date]',
    errorTag = '[object Error]',
    funcTag = '[object Function]',
    genTag = '[object GeneratorFunction]',
    mapTag = '[object Map]',
    numberTag = '[object Number]',
    nullTag = '[object Null]',
    objectTag = '[object Object]',
    promiseTag = '[object Promise]',
    proxyTag = '[object Proxy]',
    regexpTag = '[object RegExp]',
    setTag = '[object Set]',
    stringTag = '[object String]',
    symbolTag = '[object Symbol]',
    undefinedTag = '[object Undefined]',
    weakMapTag = '[object WeakMap]';

var arrayBufferTag = '[object ArrayBuffer]',
    dataViewTag = '[object DataView]',
    float32Tag = '[object Float32Array]',
    float64Tag = '[object Float64Array]',
    int8Tag = '[object Int8Array]',
    int16Tag = '[object Int16Array]',
    int32Tag = '[object Int32Array]',
    uint8Tag = '[object Uint8Array]',
    uint8ClampedTag = '[object Uint8ClampedArray]',
    uint16Tag = '[object Uint16Array]',
    uint32Tag = '[object Uint32Array]';

/**
 * Used to match `RegExp`
 * [syntax characters](http://ecma-international.org/ecma-262/7.0/#sec-patterns).
 */
var reRegExpChar = /[\\^$.*+?()[\]{}|]/g;

/** Used to detect host constructors (Safari). */
var reIsHostCtor = /^\[object .+?Constructor\]$/;

/** Used to detect unsigned integer values. */
var reIsUint = /^(?:0|[1-9]\d*)$/;

/** Used to identify `toStringTag` values of typed arrays. */
var typedArrayTags = {};
typedArrayTags[float32Tag] = typedArrayTags[float64Tag] =
typedArrayTags[int8Tag] = typedArrayTags[int16Tag] =
typedArrayTags[int32Tag] = typedArrayTags[uint8Tag] =
typedArrayTags[uint8ClampedTag] = typedArrayTags[uint16Tag] =
typedArrayTags[uint32Tag] = true;
typedArrayTags[argsTag] = typedArrayTags[arrayTag] =
typedArrayTags[arrayBufferTag] = typedArrayTags[boolTag] =
typedArrayTags[dataViewTag] = typedArrayTags[dateTag] =
typedArrayTags[errorTag] = typedArrayTags[funcTag] =
typedArrayTags[mapTag] = typedArrayTags[numberTag] =
typedArrayTags[objectTag] = typedArrayTags[regexpTag] =
typedArrayTags[setTag] = typedArrayTags[stringTag] =
typedArrayTags[weakMapTag] = false;

/** Detect free variable `global` from Node.js. */
var freeGlobal = typeof global == 'object' && global && global.Object === Object && global;

/** Detect free variable `self`. */
var freeSelf = typeof self == 'object' && self && self.Object === Object && self;

/** Used as a reference to the global object. */
var root = freeGlobal || freeSelf || Function('return this')();

/** Detect free variable `exports`. */
var freeExports =  true && exports && !exports.nodeType && exports;

/** Detect free variable `module`. */
var freeModule = freeExports && typeof module == 'object' && module && !module.nodeType && module;

/** Detect the popular CommonJS extension `module.exports`. */
var moduleExports = freeModule && freeModule.exports === freeExports;

/** Detect free variable `process` from Node.js. */
var freeProcess = moduleExports && freeGlobal.process;

/** Used to access faster Node.js helpers. */
var nodeUtil = (function() {
  try {
    return freeProcess && freeProcess.binding && freeProcess.binding('util');
  } catch (e) {}
}());

/* Node.js helper references. */
var nodeIsTypedArray = nodeUtil && nodeUtil.isTypedArray;

/**
 * A specialized version of `_.filter` for arrays without support for
 * iteratee shorthands.
 *
 * @private
 * @param {Array} [array] The array to iterate over.
 * @param {Function} predicate The function invoked per iteration.
 * @returns {Array} Returns the new filtered array.
 */
function arrayFilter(array, predicate) {
  var index = -1,
      length = array == null ? 0 : array.length,
      resIndex = 0,
      result = [];

  while (++index < length) {
    var value = array[index];
    if (predicate(value, index, array)) {
      result[resIndex++] = value;
    }
  }
  return result;
}

/**
 * Appends the elements of `values` to `array`.
 *
 * @private
 * @param {Array} array The array to modify.
 * @param {Array} values The values to append.
 * @returns {Array} Returns `array`.
 */
function arrayPush(array, values) {
  var index = -1,
      length = values.length,
      offset = array.length;

  while (++index < length) {
    array[offset + index] = values[index];
  }
  return array;
}

/**
 * A specialized version of `_.some` for arrays without support for iteratee
 * shorthands.
 *
 * @private
 * @param {Array} [array] The array to iterate over.
 * @param {Function} predicate The function invoked per iteration.
 * @returns {boolean} Returns `true` if any element passes the predicate check,
 *  else `false`.
 */
function arraySome(array, predicate) {
  var index = -1,
      length = array == null ? 0 : array.length;

  while (++index < length) {
    if (predicate(array[index], index, array)) {
      return true;
    }
  }
  return false;
}

/**
 * The base implementation of `_.times` without support for iteratee shorthands
 * or max array length checks.
 *
 * @private
 * @param {number} n The number of times to invoke `iteratee`.
 * @param {Function} iteratee The function invoked per iteration.
 * @returns {Array} Returns the array of results.
 */
function baseTimes(n, iteratee) {
  var index = -1,
      result = Array(n);

  while (++index < n) {
    result[index] = iteratee(index);
  }
  return result;
}

/**
 * The base implementation of `_.unary` without support for storing metadata.
 *
 * @private
 * @param {Function} func The function to cap arguments for.
 * @returns {Function} Returns the new capped function.
 */
function baseUnary(func) {
  return function(value) {
    return func(value);
  };
}

/**
 * Checks if a `cache` value for `key` exists.
 *
 * @private
 * @param {Object} cache The cache to query.
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function cacheHas(cache, key) {
  return cache.has(key);
}

/**
 * Gets the value at `key` of `object`.
 *
 * @private
 * @param {Object} [object] The object to query.
 * @param {string} key The key of the property to get.
 * @returns {*} Returns the property value.
 */
function getValue(object, key) {
  return object == null ? undefined : object[key];
}

/**
 * Converts `map` to its key-value pairs.
 *
 * @private
 * @param {Object} map The map to convert.
 * @returns {Array} Returns the key-value pairs.
 */
function mapToArray(map) {
  var index = -1,
      result = Array(map.size);

  map.forEach(function(value, key) {
    result[++index] = [key, value];
  });
  return result;
}

/**
 * Creates a unary function that invokes `func` with its argument transformed.
 *
 * @private
 * @param {Function} func The function to wrap.
 * @param {Function} transform The argument transform.
 * @returns {Function} Returns the new function.
 */
function overArg(func, transform) {
  return function(arg) {
    return func(transform(arg));
  };
}

/**
 * Converts `set` to an array of its values.
 *
 * @private
 * @param {Object} set The set to convert.
 * @returns {Array} Returns the values.
 */
function setToArray(set) {
  var index = -1,
      result = Array(set.size);

  set.forEach(function(value) {
    result[++index] = value;
  });
  return result;
}

/** Used for built-in method references. */
var arrayProto = Array.prototype,
    funcProto = Function.prototype,
    objectProto = Object.prototype;

/** Used to detect overreaching core-js shims. */
var coreJsData = root['__core-js_shared__'];

/** Used to resolve the decompiled source of functions. */
var funcToString = funcProto.toString;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/** Used to detect methods masquerading as native. */
var maskSrcKey = (function() {
  var uid = /[^.]+$/.exec(coreJsData && coreJsData.keys && coreJsData.keys.IE_PROTO || '');
  return uid ? ('Symbol(src)_1.' + uid) : '';
}());

/**
 * Used to resolve the
 * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
 * of values.
 */
var nativeObjectToString = objectProto.toString;

/** Used to detect if a method is native. */
var reIsNative = RegExp('^' +
  funcToString.call(hasOwnProperty).replace(reRegExpChar, '\\$&')
  .replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, '$1.*?') + '$'
);

/** Built-in value references. */
var Buffer = moduleExports ? root.Buffer : undefined,
    Symbol = root.Symbol,
    Uint8Array = root.Uint8Array,
    propertyIsEnumerable = objectProto.propertyIsEnumerable,
    splice = arrayProto.splice,
    symToStringTag = Symbol ? Symbol.toStringTag : undefined;

/* Built-in method references for those with the same name as other `lodash` methods. */
var nativeGetSymbols = Object.getOwnPropertySymbols,
    nativeIsBuffer = Buffer ? Buffer.isBuffer : undefined,
    nativeKeys = overArg(Object.keys, Object);

/* Built-in method references that are verified to be native. */
var DataView = getNative(root, 'DataView'),
    Map = getNative(root, 'Map'),
    Promise = getNative(root, 'Promise'),
    Set = getNative(root, 'Set'),
    WeakMap = getNative(root, 'WeakMap'),
    nativeCreate = getNative(Object, 'create');

/** Used to detect maps, sets, and weakmaps. */
var dataViewCtorString = toSource(DataView),
    mapCtorString = toSource(Map),
    promiseCtorString = toSource(Promise),
    setCtorString = toSource(Set),
    weakMapCtorString = toSource(WeakMap);

/** Used to convert symbols to primitives and strings. */
var symbolProto = Symbol ? Symbol.prototype : undefined,
    symbolValueOf = symbolProto ? symbolProto.valueOf : undefined;

/**
 * Creates a hash object.
 *
 * @private
 * @constructor
 * @param {Array} [entries] The key-value pairs to cache.
 */
function Hash(entries) {
  var index = -1,
      length = entries == null ? 0 : entries.length;

  this.clear();
  while (++index < length) {
    var entry = entries[index];
    this.set(entry[0], entry[1]);
  }
}

/**
 * Removes all key-value entries from the hash.
 *
 * @private
 * @name clear
 * @memberOf Hash
 */
function hashClear() {
  this.__data__ = nativeCreate ? nativeCreate(null) : {};
  this.size = 0;
}

/**
 * Removes `key` and its value from the hash.
 *
 * @private
 * @name delete
 * @memberOf Hash
 * @param {Object} hash The hash to modify.
 * @param {string} key The key of the value to remove.
 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
 */
function hashDelete(key) {
  var result = this.has(key) && delete this.__data__[key];
  this.size -= result ? 1 : 0;
  return result;
}

/**
 * Gets the hash value for `key`.
 *
 * @private
 * @name get
 * @memberOf Hash
 * @param {string} key The key of the value to get.
 * @returns {*} Returns the entry value.
 */
function hashGet(key) {
  var data = this.__data__;
  if (nativeCreate) {
    var result = data[key];
    return result === HASH_UNDEFINED ? undefined : result;
  }
  return hasOwnProperty.call(data, key) ? data[key] : undefined;
}

/**
 * Checks if a hash value for `key` exists.
 *
 * @private
 * @name has
 * @memberOf Hash
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function hashHas(key) {
  var data = this.__data__;
  return nativeCreate ? (data[key] !== undefined) : hasOwnProperty.call(data, key);
}

/**
 * Sets the hash `key` to `value`.
 *
 * @private
 * @name set
 * @memberOf Hash
 * @param {string} key The key of the value to set.
 * @param {*} value The value to set.
 * @returns {Object} Returns the hash instance.
 */
function hashSet(key, value) {
  var data = this.__data__;
  this.size += this.has(key) ? 0 : 1;
  data[key] = (nativeCreate && value === undefined) ? HASH_UNDEFINED : value;
  return this;
}

// Add methods to `Hash`.
Hash.prototype.clear = hashClear;
Hash.prototype['delete'] = hashDelete;
Hash.prototype.get = hashGet;
Hash.prototype.has = hashHas;
Hash.prototype.set = hashSet;

/**
 * Creates an list cache object.
 *
 * @private
 * @constructor
 * @param {Array} [entries] The key-value pairs to cache.
 */
function ListCache(entries) {
  var index = -1,
      length = entries == null ? 0 : entries.length;

  this.clear();
  while (++index < length) {
    var entry = entries[index];
    this.set(entry[0], entry[1]);
  }
}

/**
 * Removes all key-value entries from the list cache.
 *
 * @private
 * @name clear
 * @memberOf ListCache
 */
function listCacheClear() {
  this.__data__ = [];
  this.size = 0;
}

/**
 * Removes `key` and its value from the list cache.
 *
 * @private
 * @name delete
 * @memberOf ListCache
 * @param {string} key The key of the value to remove.
 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
 */
function listCacheDelete(key) {
  var data = this.__data__,
      index = assocIndexOf(data, key);

  if (index < 0) {
    return false;
  }
  var lastIndex = data.length - 1;
  if (index == lastIndex) {
    data.pop();
  } else {
    splice.call(data, index, 1);
  }
  --this.size;
  return true;
}

/**
 * Gets the list cache value for `key`.
 *
 * @private
 * @name get
 * @memberOf ListCache
 * @param {string} key The key of the value to get.
 * @returns {*} Returns the entry value.
 */
function listCacheGet(key) {
  var data = this.__data__,
      index = assocIndexOf(data, key);

  return index < 0 ? undefined : data[index][1];
}

/**
 * Checks if a list cache value for `key` exists.
 *
 * @private
 * @name has
 * @memberOf ListCache
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function listCacheHas(key) {
  return assocIndexOf(this.__data__, key) > -1;
}

/**
 * Sets the list cache `key` to `value`.
 *
 * @private
 * @name set
 * @memberOf ListCache
 * @param {string} key The key of the value to set.
 * @param {*} value The value to set.
 * @returns {Object} Returns the list cache instance.
 */
function listCacheSet(key, value) {
  var data = this.__data__,
      index = assocIndexOf(data, key);

  if (index < 0) {
    ++this.size;
    data.push([key, value]);
  } else {
    data[index][1] = value;
  }
  return this;
}

// Add methods to `ListCache`.
ListCache.prototype.clear = listCacheClear;
ListCache.prototype['delete'] = listCacheDelete;
ListCache.prototype.get = listCacheGet;
ListCache.prototype.has = listCacheHas;
ListCache.prototype.set = listCacheSet;

/**
 * Creates a map cache object to store key-value pairs.
 *
 * @private
 * @constructor
 * @param {Array} [entries] The key-value pairs to cache.
 */
function MapCache(entries) {
  var index = -1,
      length = entries == null ? 0 : entries.length;

  this.clear();
  while (++index < length) {
    var entry = entries[index];
    this.set(entry[0], entry[1]);
  }
}

/**
 * Removes all key-value entries from the map.
 *
 * @private
 * @name clear
 * @memberOf MapCache
 */
function mapCacheClear() {
  this.size = 0;
  this.__data__ = {
    'hash': new Hash,
    'map': new (Map || ListCache),
    'string': new Hash
  };
}

/**
 * Removes `key` and its value from the map.
 *
 * @private
 * @name delete
 * @memberOf MapCache
 * @param {string} key The key of the value to remove.
 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
 */
function mapCacheDelete(key) {
  var result = getMapData(this, key)['delete'](key);
  this.size -= result ? 1 : 0;
  return result;
}

/**
 * Gets the map value for `key`.
 *
 * @private
 * @name get
 * @memberOf MapCache
 * @param {string} key The key of the value to get.
 * @returns {*} Returns the entry value.
 */
function mapCacheGet(key) {
  return getMapData(this, key).get(key);
}

/**
 * Checks if a map value for `key` exists.
 *
 * @private
 * @name has
 * @memberOf MapCache
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function mapCacheHas(key) {
  return getMapData(this, key).has(key);
}

/**
 * Sets the map `key` to `value`.
 *
 * @private
 * @name set
 * @memberOf MapCache
 * @param {string} key The key of the value to set.
 * @param {*} value The value to set.
 * @returns {Object} Returns the map cache instance.
 */
function mapCacheSet(key, value) {
  var data = getMapData(this, key),
      size = data.size;

  data.set(key, value);
  this.size += data.size == size ? 0 : 1;
  return this;
}

// Add methods to `MapCache`.
MapCache.prototype.clear = mapCacheClear;
MapCache.prototype['delete'] = mapCacheDelete;
MapCache.prototype.get = mapCacheGet;
MapCache.prototype.has = mapCacheHas;
MapCache.prototype.set = mapCacheSet;

/**
 *
 * Creates an array cache object to store unique values.
 *
 * @private
 * @constructor
 * @param {Array} [values] The values to cache.
 */
function SetCache(values) {
  var index = -1,
      length = values == null ? 0 : values.length;

  this.__data__ = new MapCache;
  while (++index < length) {
    this.add(values[index]);
  }
}

/**
 * Adds `value` to the array cache.
 *
 * @private
 * @name add
 * @memberOf SetCache
 * @alias push
 * @param {*} value The value to cache.
 * @returns {Object} Returns the cache instance.
 */
function setCacheAdd(value) {
  this.__data__.set(value, HASH_UNDEFINED);
  return this;
}

/**
 * Checks if `value` is in the array cache.
 *
 * @private
 * @name has
 * @memberOf SetCache
 * @param {*} value The value to search for.
 * @returns {number} Returns `true` if `value` is found, else `false`.
 */
function setCacheHas(value) {
  return this.__data__.has(value);
}

// Add methods to `SetCache`.
SetCache.prototype.add = SetCache.prototype.push = setCacheAdd;
SetCache.prototype.has = setCacheHas;

/**
 * Creates a stack cache object to store key-value pairs.
 *
 * @private
 * @constructor
 * @param {Array} [entries] The key-value pairs to cache.
 */
function Stack(entries) {
  var data = this.__data__ = new ListCache(entries);
  this.size = data.size;
}

/**
 * Removes all key-value entries from the stack.
 *
 * @private
 * @name clear
 * @memberOf Stack
 */
function stackClear() {
  this.__data__ = new ListCache;
  this.size = 0;
}

/**
 * Removes `key` and its value from the stack.
 *
 * @private
 * @name delete
 * @memberOf Stack
 * @param {string} key The key of the value to remove.
 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
 */
function stackDelete(key) {
  var data = this.__data__,
      result = data['delete'](key);

  this.size = data.size;
  return result;
}

/**
 * Gets the stack value for `key`.
 *
 * @private
 * @name get
 * @memberOf Stack
 * @param {string} key The key of the value to get.
 * @returns {*} Returns the entry value.
 */
function stackGet(key) {
  return this.__data__.get(key);
}

/**
 * Checks if a stack value for `key` exists.
 *
 * @private
 * @name has
 * @memberOf Stack
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function stackHas(key) {
  return this.__data__.has(key);
}

/**
 * Sets the stack `key` to `value`.
 *
 * @private
 * @name set
 * @memberOf Stack
 * @param {string} key The key of the value to set.
 * @param {*} value The value to set.
 * @returns {Object} Returns the stack cache instance.
 */
function stackSet(key, value) {
  var data = this.__data__;
  if (data instanceof ListCache) {
    var pairs = data.__data__;
    if (!Map || (pairs.length < LARGE_ARRAY_SIZE - 1)) {
      pairs.push([key, value]);
      this.size = ++data.size;
      return this;
    }
    data = this.__data__ = new MapCache(pairs);
  }
  data.set(key, value);
  this.size = data.size;
  return this;
}

// Add methods to `Stack`.
Stack.prototype.clear = stackClear;
Stack.prototype['delete'] = stackDelete;
Stack.prototype.get = stackGet;
Stack.prototype.has = stackHas;
Stack.prototype.set = stackSet;

/**
 * Creates an array of the enumerable property names of the array-like `value`.
 *
 * @private
 * @param {*} value The value to query.
 * @param {boolean} inherited Specify returning inherited property names.
 * @returns {Array} Returns the array of property names.
 */
function arrayLikeKeys(value, inherited) {
  var isArr = isArray(value),
      isArg = !isArr && isArguments(value),
      isBuff = !isArr && !isArg && isBuffer(value),
      isType = !isArr && !isArg && !isBuff && isTypedArray(value),
      skipIndexes = isArr || isArg || isBuff || isType,
      result = skipIndexes ? baseTimes(value.length, String) : [],
      length = result.length;

  for (var key in value) {
    if ((inherited || hasOwnProperty.call(value, key)) &&
        !(skipIndexes && (
           // Safari 9 has enumerable `arguments.length` in strict mode.
           key == 'length' ||
           // Node.js 0.10 has enumerable non-index properties on buffers.
           (isBuff && (key == 'offset' || key == 'parent')) ||
           // PhantomJS 2 has enumerable non-index properties on typed arrays.
           (isType && (key == 'buffer' || key == 'byteLength' || key == 'byteOffset')) ||
           // Skip index properties.
           isIndex(key, length)
        ))) {
      result.push(key);
    }
  }
  return result;
}

/**
 * Gets the index at which the `key` is found in `array` of key-value pairs.
 *
 * @private
 * @param {Array} array The array to inspect.
 * @param {*} key The key to search for.
 * @returns {number} Returns the index of the matched value, else `-1`.
 */
function assocIndexOf(array, key) {
  var length = array.length;
  while (length--) {
    if (eq(array[length][0], key)) {
      return length;
    }
  }
  return -1;
}

/**
 * The base implementation of `getAllKeys` and `getAllKeysIn` which uses
 * `keysFunc` and `symbolsFunc` to get the enumerable property names and
 * symbols of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @param {Function} keysFunc The function to get the keys of `object`.
 * @param {Function} symbolsFunc The function to get the symbols of `object`.
 * @returns {Array} Returns the array of property names and symbols.
 */
function baseGetAllKeys(object, keysFunc, symbolsFunc) {
  var result = keysFunc(object);
  return isArray(object) ? result : arrayPush(result, symbolsFunc(object));
}

/**
 * The base implementation of `getTag` without fallbacks for buggy environments.
 *
 * @private
 * @param {*} value The value to query.
 * @returns {string} Returns the `toStringTag`.
 */
function baseGetTag(value) {
  if (value == null) {
    return value === undefined ? undefinedTag : nullTag;
  }
  return (symToStringTag && symToStringTag in Object(value))
    ? getRawTag(value)
    : objectToString(value);
}

/**
 * The base implementation of `_.isArguments`.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an `arguments` object,
 */
function baseIsArguments(value) {
  return isObjectLike(value) && baseGetTag(value) == argsTag;
}

/**
 * The base implementation of `_.isEqual` which supports partial comparisons
 * and tracks traversed objects.
 *
 * @private
 * @param {*} value The value to compare.
 * @param {*} other The other value to compare.
 * @param {boolean} bitmask The bitmask flags.
 *  1 - Unordered comparison
 *  2 - Partial comparison
 * @param {Function} [customizer] The function to customize comparisons.
 * @param {Object} [stack] Tracks traversed `value` and `other` objects.
 * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
 */
function baseIsEqual(value, other, bitmask, customizer, stack) {
  if (value === other) {
    return true;
  }
  if (value == null || other == null || (!isObjectLike(value) && !isObjectLike(other))) {
    return value !== value && other !== other;
  }
  return baseIsEqualDeep(value, other, bitmask, customizer, baseIsEqual, stack);
}

/**
 * A specialized version of `baseIsEqual` for arrays and objects which performs
 * deep comparisons and tracks traversed objects enabling objects with circular
 * references to be compared.
 *
 * @private
 * @param {Object} object The object to compare.
 * @param {Object} other The other object to compare.
 * @param {number} bitmask The bitmask flags. See `baseIsEqual` for more details.
 * @param {Function} customizer The function to customize comparisons.
 * @param {Function} equalFunc The function to determine equivalents of values.
 * @param {Object} [stack] Tracks traversed `object` and `other` objects.
 * @returns {boolean} Returns `true` if the objects are equivalent, else `false`.
 */
function baseIsEqualDeep(object, other, bitmask, customizer, equalFunc, stack) {
  var objIsArr = isArray(object),
      othIsArr = isArray(other),
      objTag = objIsArr ? arrayTag : getTag(object),
      othTag = othIsArr ? arrayTag : getTag(other);

  objTag = objTag == argsTag ? objectTag : objTag;
  othTag = othTag == argsTag ? objectTag : othTag;

  var objIsObj = objTag == objectTag,
      othIsObj = othTag == objectTag,
      isSameTag = objTag == othTag;

  if (isSameTag && isBuffer(object)) {
    if (!isBuffer(other)) {
      return false;
    }
    objIsArr = true;
    objIsObj = false;
  }
  if (isSameTag && !objIsObj) {
    stack || (stack = new Stack);
    return (objIsArr || isTypedArray(object))
      ? equalArrays(object, other, bitmask, customizer, equalFunc, stack)
      : equalByTag(object, other, objTag, bitmask, customizer, equalFunc, stack);
  }
  if (!(bitmask & COMPARE_PARTIAL_FLAG)) {
    var objIsWrapped = objIsObj && hasOwnProperty.call(object, '__wrapped__'),
        othIsWrapped = othIsObj && hasOwnProperty.call(other, '__wrapped__');

    if (objIsWrapped || othIsWrapped) {
      var objUnwrapped = objIsWrapped ? object.value() : object,
          othUnwrapped = othIsWrapped ? other.value() : other;

      stack || (stack = new Stack);
      return equalFunc(objUnwrapped, othUnwrapped, bitmask, customizer, stack);
    }
  }
  if (!isSameTag) {
    return false;
  }
  stack || (stack = new Stack);
  return equalObjects(object, other, bitmask, customizer, equalFunc, stack);
}

/**
 * The base implementation of `_.isNative` without bad shim checks.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a native function,
 *  else `false`.
 */
function baseIsNative(value) {
  if (!isObject(value) || isMasked(value)) {
    return false;
  }
  var pattern = isFunction(value) ? reIsNative : reIsHostCtor;
  return pattern.test(toSource(value));
}

/**
 * The base implementation of `_.isTypedArray` without Node.js optimizations.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a typed array, else `false`.
 */
function baseIsTypedArray(value) {
  return isObjectLike(value) &&
    isLength(value.length) && !!typedArrayTags[baseGetTag(value)];
}

/**
 * The base implementation of `_.keys` which doesn't treat sparse arrays as dense.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property names.
 */
function baseKeys(object) {
  if (!isPrototype(object)) {
    return nativeKeys(object);
  }
  var result = [];
  for (var key in Object(object)) {
    if (hasOwnProperty.call(object, key) && key != 'constructor') {
      result.push(key);
    }
  }
  return result;
}

/**
 * A specialized version of `baseIsEqualDeep` for arrays with support for
 * partial deep comparisons.
 *
 * @private
 * @param {Array} array The array to compare.
 * @param {Array} other The other array to compare.
 * @param {number} bitmask The bitmask flags. See `baseIsEqual` for more details.
 * @param {Function} customizer The function to customize comparisons.
 * @param {Function} equalFunc The function to determine equivalents of values.
 * @param {Object} stack Tracks traversed `array` and `other` objects.
 * @returns {boolean} Returns `true` if the arrays are equivalent, else `false`.
 */
function equalArrays(array, other, bitmask, customizer, equalFunc, stack) {
  var isPartial = bitmask & COMPARE_PARTIAL_FLAG,
      arrLength = array.length,
      othLength = other.length;

  if (arrLength != othLength && !(isPartial && othLength > arrLength)) {
    return false;
  }
  // Assume cyclic values are equal.
  var stacked = stack.get(array);
  if (stacked && stack.get(other)) {
    return stacked == other;
  }
  var index = -1,
      result = true,
      seen = (bitmask & COMPARE_UNORDERED_FLAG) ? new SetCache : undefined;

  stack.set(array, other);
  stack.set(other, array);

  // Ignore non-index properties.
  while (++index < arrLength) {
    var arrValue = array[index],
        othValue = other[index];

    if (customizer) {
      var compared = isPartial
        ? customizer(othValue, arrValue, index, other, array, stack)
        : customizer(arrValue, othValue, index, array, other, stack);
    }
    if (compared !== undefined) {
      if (compared) {
        continue;
      }
      result = false;
      break;
    }
    // Recursively compare arrays (susceptible to call stack limits).
    if (seen) {
      if (!arraySome(other, function(othValue, othIndex) {
            if (!cacheHas(seen, othIndex) &&
                (arrValue === othValue || equalFunc(arrValue, othValue, bitmask, customizer, stack))) {
              return seen.push(othIndex);
            }
          })) {
        result = false;
        break;
      }
    } else if (!(
          arrValue === othValue ||
            equalFunc(arrValue, othValue, bitmask, customizer, stack)
        )) {
      result = false;
      break;
    }
  }
  stack['delete'](array);
  stack['delete'](other);
  return result;
}

/**
 * A specialized version of `baseIsEqualDeep` for comparing objects of
 * the same `toStringTag`.
 *
 * **Note:** This function only supports comparing values with tags of
 * `Boolean`, `Date`, `Error`, `Number`, `RegExp`, or `String`.
 *
 * @private
 * @param {Object} object The object to compare.
 * @param {Object} other The other object to compare.
 * @param {string} tag The `toStringTag` of the objects to compare.
 * @param {number} bitmask The bitmask flags. See `baseIsEqual` for more details.
 * @param {Function} customizer The function to customize comparisons.
 * @param {Function} equalFunc The function to determine equivalents of values.
 * @param {Object} stack Tracks traversed `object` and `other` objects.
 * @returns {boolean} Returns `true` if the objects are equivalent, else `false`.
 */
function equalByTag(object, other, tag, bitmask, customizer, equalFunc, stack) {
  switch (tag) {
    case dataViewTag:
      if ((object.byteLength != other.byteLength) ||
          (object.byteOffset != other.byteOffset)) {
        return false;
      }
      object = object.buffer;
      other = other.buffer;

    case arrayBufferTag:
      if ((object.byteLength != other.byteLength) ||
          !equalFunc(new Uint8Array(object), new Uint8Array(other))) {
        return false;
      }
      return true;

    case boolTag:
    case dateTag:
    case numberTag:
      // Coerce booleans to `1` or `0` and dates to milliseconds.
      // Invalid dates are coerced to `NaN`.
      return eq(+object, +other);

    case errorTag:
      return object.name == other.name && object.message == other.message;

    case regexpTag:
    case stringTag:
      // Coerce regexes to strings and treat strings, primitives and objects,
      // as equal. See http://www.ecma-international.org/ecma-262/7.0/#sec-regexp.prototype.tostring
      // for more details.
      return object == (other + '');

    case mapTag:
      var convert = mapToArray;

    case setTag:
      var isPartial = bitmask & COMPARE_PARTIAL_FLAG;
      convert || (convert = setToArray);

      if (object.size != other.size && !isPartial) {
        return false;
      }
      // Assume cyclic values are equal.
      var stacked = stack.get(object);
      if (stacked) {
        return stacked == other;
      }
      bitmask |= COMPARE_UNORDERED_FLAG;

      // Recursively compare objects (susceptible to call stack limits).
      stack.set(object, other);
      var result = equalArrays(convert(object), convert(other), bitmask, customizer, equalFunc, stack);
      stack['delete'](object);
      return result;

    case symbolTag:
      if (symbolValueOf) {
        return symbolValueOf.call(object) == symbolValueOf.call(other);
      }
  }
  return false;
}

/**
 * A specialized version of `baseIsEqualDeep` for objects with support for
 * partial deep comparisons.
 *
 * @private
 * @param {Object} object The object to compare.
 * @param {Object} other The other object to compare.
 * @param {number} bitmask The bitmask flags. See `baseIsEqual` for more details.
 * @param {Function} customizer The function to customize comparisons.
 * @param {Function} equalFunc The function to determine equivalents of values.
 * @param {Object} stack Tracks traversed `object` and `other` objects.
 * @returns {boolean} Returns `true` if the objects are equivalent, else `false`.
 */
function equalObjects(object, other, bitmask, customizer, equalFunc, stack) {
  var isPartial = bitmask & COMPARE_PARTIAL_FLAG,
      objProps = getAllKeys(object),
      objLength = objProps.length,
      othProps = getAllKeys(other),
      othLength = othProps.length;

  if (objLength != othLength && !isPartial) {
    return false;
  }
  var index = objLength;
  while (index--) {
    var key = objProps[index];
    if (!(isPartial ? key in other : hasOwnProperty.call(other, key))) {
      return false;
    }
  }
  // Assume cyclic values are equal.
  var stacked = stack.get(object);
  if (stacked && stack.get(other)) {
    return stacked == other;
  }
  var result = true;
  stack.set(object, other);
  stack.set(other, object);

  var skipCtor = isPartial;
  while (++index < objLength) {
    key = objProps[index];
    var objValue = object[key],
        othValue = other[key];

    if (customizer) {
      var compared = isPartial
        ? customizer(othValue, objValue, key, other, object, stack)
        : customizer(objValue, othValue, key, object, other, stack);
    }
    // Recursively compare objects (susceptible to call stack limits).
    if (!(compared === undefined
          ? (objValue === othValue || equalFunc(objValue, othValue, bitmask, customizer, stack))
          : compared
        )) {
      result = false;
      break;
    }
    skipCtor || (skipCtor = key == 'constructor');
  }
  if (result && !skipCtor) {
    var objCtor = object.constructor,
        othCtor = other.constructor;

    // Non `Object` object instances with different constructors are not equal.
    if (objCtor != othCtor &&
        ('constructor' in object && 'constructor' in other) &&
        !(typeof objCtor == 'function' && objCtor instanceof objCtor &&
          typeof othCtor == 'function' && othCtor instanceof othCtor)) {
      result = false;
    }
  }
  stack['delete'](object);
  stack['delete'](other);
  return result;
}

/**
 * Creates an array of own enumerable property names and symbols of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property names and symbols.
 */
function getAllKeys(object) {
  return baseGetAllKeys(object, keys, getSymbols);
}

/**
 * Gets the data for `map`.
 *
 * @private
 * @param {Object} map The map to query.
 * @param {string} key The reference key.
 * @returns {*} Returns the map data.
 */
function getMapData(map, key) {
  var data = map.__data__;
  return isKeyable(key)
    ? data[typeof key == 'string' ? 'string' : 'hash']
    : data.map;
}

/**
 * Gets the native function at `key` of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @param {string} key The key of the method to get.
 * @returns {*} Returns the function if it's native, else `undefined`.
 */
function getNative(object, key) {
  var value = getValue(object, key);
  return baseIsNative(value) ? value : undefined;
}

/**
 * A specialized version of `baseGetTag` which ignores `Symbol.toStringTag` values.
 *
 * @private
 * @param {*} value The value to query.
 * @returns {string} Returns the raw `toStringTag`.
 */
function getRawTag(value) {
  var isOwn = hasOwnProperty.call(value, symToStringTag),
      tag = value[symToStringTag];

  try {
    value[symToStringTag] = undefined;
    var unmasked = true;
  } catch (e) {}

  var result = nativeObjectToString.call(value);
  if (unmasked) {
    if (isOwn) {
      value[symToStringTag] = tag;
    } else {
      delete value[symToStringTag];
    }
  }
  return result;
}

/**
 * Creates an array of the own enumerable symbols of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of symbols.
 */
var getSymbols = !nativeGetSymbols ? stubArray : function(object) {
  if (object == null) {
    return [];
  }
  object = Object(object);
  return arrayFilter(nativeGetSymbols(object), function(symbol) {
    return propertyIsEnumerable.call(object, symbol);
  });
};

/**
 * Gets the `toStringTag` of `value`.
 *
 * @private
 * @param {*} value The value to query.
 * @returns {string} Returns the `toStringTag`.
 */
var getTag = baseGetTag;

// Fallback for data views, maps, sets, and weak maps in IE 11 and promises in Node.js < 6.
if ((DataView && getTag(new DataView(new ArrayBuffer(1))) != dataViewTag) ||
    (Map && getTag(new Map) != mapTag) ||
    (Promise && getTag(Promise.resolve()) != promiseTag) ||
    (Set && getTag(new Set) != setTag) ||
    (WeakMap && getTag(new WeakMap) != weakMapTag)) {
  getTag = function(value) {
    var result = baseGetTag(value),
        Ctor = result == objectTag ? value.constructor : undefined,
        ctorString = Ctor ? toSource(Ctor) : '';

    if (ctorString) {
      switch (ctorString) {
        case dataViewCtorString: return dataViewTag;
        case mapCtorString: return mapTag;
        case promiseCtorString: return promiseTag;
        case setCtorString: return setTag;
        case weakMapCtorString: return weakMapTag;
      }
    }
    return result;
  };
}

/**
 * Checks if `value` is a valid array-like index.
 *
 * @private
 * @param {*} value The value to check.
 * @param {number} [length=MAX_SAFE_INTEGER] The upper bounds of a valid index.
 * @returns {boolean} Returns `true` if `value` is a valid index, else `false`.
 */
function isIndex(value, length) {
  length = length == null ? MAX_SAFE_INTEGER : length;
  return !!length &&
    (typeof value == 'number' || reIsUint.test(value)) &&
    (value > -1 && value % 1 == 0 && value < length);
}

/**
 * Checks if `value` is suitable for use as unique object key.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is suitable, else `false`.
 */
function isKeyable(value) {
  var type = typeof value;
  return (type == 'string' || type == 'number' || type == 'symbol' || type == 'boolean')
    ? (value !== '__proto__')
    : (value === null);
}

/**
 * Checks if `func` has its source masked.
 *
 * @private
 * @param {Function} func The function to check.
 * @returns {boolean} Returns `true` if `func` is masked, else `false`.
 */
function isMasked(func) {
  return !!maskSrcKey && (maskSrcKey in func);
}

/**
 * Checks if `value` is likely a prototype object.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a prototype, else `false`.
 */
function isPrototype(value) {
  var Ctor = value && value.constructor,
      proto = (typeof Ctor == 'function' && Ctor.prototype) || objectProto;

  return value === proto;
}

/**
 * Converts `value` to a string using `Object.prototype.toString`.
 *
 * @private
 * @param {*} value The value to convert.
 * @returns {string} Returns the converted string.
 */
function objectToString(value) {
  return nativeObjectToString.call(value);
}

/**
 * Converts `func` to its source code.
 *
 * @private
 * @param {Function} func The function to convert.
 * @returns {string} Returns the source code.
 */
function toSource(func) {
  if (func != null) {
    try {
      return funcToString.call(func);
    } catch (e) {}
    try {
      return (func + '');
    } catch (e) {}
  }
  return '';
}

/**
 * Performs a
 * [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
 * comparison between two values to determine if they are equivalent.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to compare.
 * @param {*} other The other value to compare.
 * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
 * @example
 *
 * var object = { 'a': 1 };
 * var other = { 'a': 1 };
 *
 * _.eq(object, object);
 * // => true
 *
 * _.eq(object, other);
 * // => false
 *
 * _.eq('a', 'a');
 * // => true
 *
 * _.eq('a', Object('a'));
 * // => false
 *
 * _.eq(NaN, NaN);
 * // => true
 */
function eq(value, other) {
  return value === other || (value !== value && other !== other);
}

/**
 * Checks if `value` is likely an `arguments` object.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an `arguments` object,
 *  else `false`.
 * @example
 *
 * _.isArguments(function() { return arguments; }());
 * // => true
 *
 * _.isArguments([1, 2, 3]);
 * // => false
 */
var isArguments = baseIsArguments(function() { return arguments; }()) ? baseIsArguments : function(value) {
  return isObjectLike(value) && hasOwnProperty.call(value, 'callee') &&
    !propertyIsEnumerable.call(value, 'callee');
};

/**
 * Checks if `value` is classified as an `Array` object.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an array, else `false`.
 * @example
 *
 * _.isArray([1, 2, 3]);
 * // => true
 *
 * _.isArray(document.body.children);
 * // => false
 *
 * _.isArray('abc');
 * // => false
 *
 * _.isArray(_.noop);
 * // => false
 */
var isArray = Array.isArray;

/**
 * Checks if `value` is array-like. A value is considered array-like if it's
 * not a function and has a `value.length` that's an integer greater than or
 * equal to `0` and less than or equal to `Number.MAX_SAFE_INTEGER`.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is array-like, else `false`.
 * @example
 *
 * _.isArrayLike([1, 2, 3]);
 * // => true
 *
 * _.isArrayLike(document.body.children);
 * // => true
 *
 * _.isArrayLike('abc');
 * // => true
 *
 * _.isArrayLike(_.noop);
 * // => false
 */
function isArrayLike(value) {
  return value != null && isLength(value.length) && !isFunction(value);
}

/**
 * Checks if `value` is a buffer.
 *
 * @static
 * @memberOf _
 * @since 4.3.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a buffer, else `false`.
 * @example
 *
 * _.isBuffer(new Buffer(2));
 * // => true
 *
 * _.isBuffer(new Uint8Array(2));
 * // => false
 */
var isBuffer = nativeIsBuffer || stubFalse;

/**
 * Performs a deep comparison between two values to determine if they are
 * equivalent.
 *
 * **Note:** This method supports comparing arrays, array buffers, booleans,
 * date objects, error objects, maps, numbers, `Object` objects, regexes,
 * sets, strings, symbols, and typed arrays. `Object` objects are compared
 * by their own, not inherited, enumerable properties. Functions and DOM
 * nodes are compared by strict equality, i.e. `===`.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to compare.
 * @param {*} other The other value to compare.
 * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
 * @example
 *
 * var object = { 'a': 1 };
 * var other = { 'a': 1 };
 *
 * _.isEqual(object, other);
 * // => true
 *
 * object === other;
 * // => false
 */
function isEqual(value, other) {
  return baseIsEqual(value, other);
}

/**
 * Checks if `value` is classified as a `Function` object.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a function, else `false`.
 * @example
 *
 * _.isFunction(_);
 * // => true
 *
 * _.isFunction(/abc/);
 * // => false
 */
function isFunction(value) {
  if (!isObject(value)) {
    return false;
  }
  // The use of `Object#toString` avoids issues with the `typeof` operator
  // in Safari 9 which returns 'object' for typed arrays and other constructors.
  var tag = baseGetTag(value);
  return tag == funcTag || tag == genTag || tag == asyncTag || tag == proxyTag;
}

/**
 * Checks if `value` is a valid array-like length.
 *
 * **Note:** This method is loosely based on
 * [`ToLength`](http://ecma-international.org/ecma-262/7.0/#sec-tolength).
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a valid length, else `false`.
 * @example
 *
 * _.isLength(3);
 * // => true
 *
 * _.isLength(Number.MIN_VALUE);
 * // => false
 *
 * _.isLength(Infinity);
 * // => false
 *
 * _.isLength('3');
 * // => false
 */
function isLength(value) {
  return typeof value == 'number' &&
    value > -1 && value % 1 == 0 && value <= MAX_SAFE_INTEGER;
}

/**
 * Checks if `value` is the
 * [language type](http://www.ecma-international.org/ecma-262/7.0/#sec-ecmascript-language-types)
 * of `Object`. (e.g. arrays, functions, objects, regexes, `new Number(0)`, and `new String('')`)
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an object, else `false`.
 * @example
 *
 * _.isObject({});
 * // => true
 *
 * _.isObject([1, 2, 3]);
 * // => true
 *
 * _.isObject(_.noop);
 * // => true
 *
 * _.isObject(null);
 * // => false
 */
function isObject(value) {
  var type = typeof value;
  return value != null && (type == 'object' || type == 'function');
}

/**
 * Checks if `value` is object-like. A value is object-like if it's not `null`
 * and has a `typeof` result of "object".
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is object-like, else `false`.
 * @example
 *
 * _.isObjectLike({});
 * // => true
 *
 * _.isObjectLike([1, 2, 3]);
 * // => true
 *
 * _.isObjectLike(_.noop);
 * // => false
 *
 * _.isObjectLike(null);
 * // => false
 */
function isObjectLike(value) {
  return value != null && typeof value == 'object';
}

/**
 * Checks if `value` is classified as a typed array.
 *
 * @static
 * @memberOf _
 * @since 3.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a typed array, else `false`.
 * @example
 *
 * _.isTypedArray(new Uint8Array);
 * // => true
 *
 * _.isTypedArray([]);
 * // => false
 */
var isTypedArray = nodeIsTypedArray ? baseUnary(nodeIsTypedArray) : baseIsTypedArray;

/**
 * Creates an array of the own enumerable property names of `object`.
 *
 * **Note:** Non-object values are coerced to objects. See the
 * [ES spec](http://ecma-international.org/ecma-262/7.0/#sec-object.keys)
 * for more details.
 *
 * @static
 * @since 0.1.0
 * @memberOf _
 * @category Object
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property names.
 * @example
 *
 * function Foo() {
 *   this.a = 1;
 *   this.b = 2;
 * }
 *
 * Foo.prototype.c = 3;
 *
 * _.keys(new Foo);
 * // => ['a', 'b'] (iteration order is not guaranteed)
 *
 * _.keys('hi');
 * // => ['0', '1']
 */
function keys(object) {
  return isArrayLike(object) ? arrayLikeKeys(object) : baseKeys(object);
}

/**
 * This method returns a new empty array.
 *
 * @static
 * @memberOf _
 * @since 4.13.0
 * @category Util
 * @returns {Array} Returns the new empty array.
 * @example
 *
 * var arrays = _.times(2, _.stubArray);
 *
 * console.log(arrays);
 * // => [[], []]
 *
 * console.log(arrays[0] === arrays[1]);
 * // => false
 */
function stubArray() {
  return [];
}

/**
 * This method returns `false`.
 *
 * @static
 * @memberOf _
 * @since 4.13.0
 * @category Util
 * @returns {boolean} Returns `false`.
 * @example
 *
 * _.times(2, _.stubFalse);
 * // => [false, false]
 */
function stubFalse() {
  return false;
}

module.exports = isEqual;

/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__("yLpj"), __webpack_require__("YuTi")(module)))

/***/ }),

/***/ "Xhqo":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var Buffer = __webpack_require__("hwdV").Buffer;
var util = __webpack_require__(2);

function copyBuffer(src, target, offset) {
  src.copy(target, offset);
}

module.exports = function () {
  function BufferList() {
    _classCallCheck(this, BufferList);

    this.head = null;
    this.tail = null;
    this.length = 0;
  }

  BufferList.prototype.push = function push(v) {
    var entry = { data: v, next: null };
    if (this.length > 0) this.tail.next = entry;else this.head = entry;
    this.tail = entry;
    ++this.length;
  };

  BufferList.prototype.unshift = function unshift(v) {
    var entry = { data: v, next: this.head };
    if (this.length === 0) this.tail = entry;
    this.head = entry;
    ++this.length;
  };

  BufferList.prototype.shift = function shift() {
    if (this.length === 0) return;
    var ret = this.head.data;
    if (this.length === 1) this.head = this.tail = null;else this.head = this.head.next;
    --this.length;
    return ret;
  };

  BufferList.prototype.clear = function clear() {
    this.head = this.tail = null;
    this.length = 0;
  };

  BufferList.prototype.join = function join(s) {
    if (this.length === 0) return '';
    var p = this.head;
    var ret = '' + p.data;
    while (p = p.next) {
      ret += s + p.data;
    }return ret;
  };

  BufferList.prototype.concat = function concat(n) {
    if (this.length === 0) return Buffer.alloc(0);
    if (this.length === 1) return this.head.data;
    var ret = Buffer.allocUnsafe(n >>> 0);
    var p = this.head;
    var i = 0;
    while (p) {
      copyBuffer(p.data, ret, i);
      i += p.data.length;
      p = p.next;
    }
    return ret;
  };

  return BufferList;
}();

if (util && util.inspect && util.inspect.custom) {
  module.exports.prototype[util.inspect.custom] = function () {
    var obj = util.inspect({ length: this.length });
    return this.constructor.name + ' ' + obj;
  };
}

/***/ }),

/***/ "Y5fm":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABkAAAApCAYAAADAk4LOAAAFgUlEQVR4Aa1XA5BjWRTN2oW17d3YaZtr2962HUzbDNpjszW24mRt28p47v7zq/bXZtrp/lWnXr337j3nPCe85NcypgSFdugCpW5YoDAMRaIMqRi6aKq5E3YqDQO3qAwjVWrD8Ncq/RBpykd8oZUb/kaJutow8r1aP9II0WmLKLIsJyv1w/kqw9Ch2MYdB++12Onxee/QMwvf4/Dk/Lfp/i4nxTXtOoQ4pW5Aj7wpici1A9erdAN2OH64x8OSP9j3Ft3b7aWkTg/Fm91siTra0f9on5sQr9INejH6CUUUpavjFNq1B+Oadhxmnfa8RfEmN8VNAsQhPqF55xHkMzz3jSmChWU6f7/XZKNH+9+hBLOHYozuKQPxyMPUKkrX/K0uWnfFaJGS1QPRtZsOPtr3NsW0uyh6NNCOkU3Yz+bXbT3I8G3xE5EXLXtCXbbqwCO9zPQYPRTZ5vIDXD7U+w7rFDEoUUf7ibHIR4y6bLVPXrz8JVZEql13trxwue/uDivd3fkWRbS6/IA2bID4uk0UpF1N8qLlbBlXs4Ee7HLTfV1j54APvODnSfOWBqtKVvjgLKzF5YdEk5ewRkGlK0i33Eofffc7HT56jD7/6U+qH3Cx7SBLNntH5YIPvODnyfIXZYRVDPqgHtLs5ABHD3YzLuespb7t79FY34DjMwrVrcTuwlT55YMPvOBnRrJ4VXTdNnYug5ucHLBjEpt30701A3Ts+HEa73u6dT3FNWwflY86eMHPk+Yu+i6pzUpRrW7SNDg5JHR4KapmM5Wv2E8Tfcb1HoqqHMHU+uWDD7zg54mz5/2BSnizi9T1Dg4QQXLToGNCkb6tb1NU+QAlGr1++eADrzhn/u8Q2YZhQVlZ5+CAOtqfbhmaUCS1ezNFVm2imDbPmPng5wmz+gwh+oHDce0eUtQ6OGDIyR0uUhUsoO3vfDmmgOezH0mZN59x7MBi++WDL1g/eEiU3avlidO671bkLfwbw5XV2P8Pzo0ydy4t2/0eu33xYSOMOD8hTf4CrBtGMSoXfPLchX+J0ruSePw3LZeK0juPJbYzrhkH0io7B3k164hiGvawhOKMLkrQLyVpZg8rHFW7E2uHOL888IBPlNZ1FPzstSJM694fWr6RwpvcJK60+0HCILTBzZLFNdtAzJaohze60T8qBzyh5ZuOg5e7uwQppofEmf2++DYvmySqGBuKaicF1blQjhuHdvCIMvp8whTTfZzI7RldpwtSzL+F1+wkdZ2TBOW2gIF88PBTzD/gpeREAMEbxnJcaJHNHrpzji0gQCS6hdkEeYt9DF/2qPcEC8RM28Hwmr3sdNyht00byAut2k3gufWNtgtOEOFGUwcXWNDbdNbpgBGxEvKkOQsxivJx33iow0Vw5S6SVTrpVq11ysA2Rp7gTfPfktc6zhtXBBC+adRLshf6sG2RfHPZ5EAc4sVZ83yCN00Fk/4kggu40ZTvIEm5g24qtU4KjBrx/BTTH8ifVASAG7gKrnWxJDcU7x8X6Ecczhm3o6YicvsLXWfh3Ch1W0k8x0nXF+0fFxgt4phz8QvypiwCCFKMqXCnqXExjq10beH+UUA7+nG6mdG/Pu0f3LgFcGrl2s0kNNjpmoJ9o4B29CMO8dMT4Q5ox8uitF6fqsrJOr8qnwNbRzv6hSnG5wP+64C7h9lp30hKNtKdWjtdkbuPA19nJ7Tz3zR/ibgARbhb4AlhavcBebmTHcFl2fvYEnW0ox9xMxKBS8btJ+KiEbq9zA4RthQXDhPa0T9TEe69gWupwc6uBUphquXgf+/FrIjweHQS4/pduMe5ERUMHUd9xv8ZR98CxkS4F2n3EUrUZ10EYNw7BWm9x1GiPssi3GgiGRDKWRYZfXlON+dfNbM+GgIwYdwAAAAASUVORK5CYII="

/***/ }),

/***/ "YKMj":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);

// EXTERNAL MODULE: external {"root":"Vue","commonjs":"vue","commonjs2":"vue","amd":"vue"}
var external_root_Vue_commonjs_vue_commonjs2_vue_amd_vue_ = __webpack_require__("i7/w");
var external_root_Vue_commonjs_vue_commonjs2_vue_amd_vue_default = /*#__PURE__*/__webpack_require__.n(external_root_Vue_commonjs_vue_commonjs2_vue_amd_vue_);

// CONCATENATED MODULE: ./node_modules/vue-class-component/dist/vue-class-component.esm.js
/**
  * vue-class-component v7.1.0
  * (c) 2015-present Evan You
  * @license MIT
  */


// The rational behind the verbose Reflect-feature check below is the fact that there are polyfills
// which add an implementation for Reflect.defineMetadata but not for Reflect.getOwnMetadataKeys.
// Without this check consumers will encounter hard to track down runtime errors.
var reflectionIsSupported = typeof Reflect !== 'undefined' && Reflect.defineMetadata && Reflect.getOwnMetadataKeys;
function copyReflectionMetadata(to, from) {
    forwardMetadata(to, from);
    Object.getOwnPropertyNames(from.prototype).forEach(function (key) {
        forwardMetadata(to.prototype, from.prototype, key);
    });
    Object.getOwnPropertyNames(from).forEach(function (key) {
        forwardMetadata(to, from, key);
    });
}
function forwardMetadata(to, from, propertyKey) {
    var metaKeys = propertyKey
        ? Reflect.getOwnMetadataKeys(from, propertyKey)
        : Reflect.getOwnMetadataKeys(from);
    metaKeys.forEach(function (metaKey) {
        var metadata = propertyKey
            ? Reflect.getOwnMetadata(metaKey, from, propertyKey)
            : Reflect.getOwnMetadata(metaKey, from);
        if (propertyKey) {
            Reflect.defineMetadata(metaKey, metadata, to, propertyKey);
        }
        else {
            Reflect.defineMetadata(metaKey, metadata, to);
        }
    });
}

var fakeArray = { __proto__: [] };
var hasProto = fakeArray instanceof Array;
function createDecorator(factory) {
    return function (target, key, index) {
        var Ctor = typeof target === 'function'
            ? target
            : target.constructor;
        if (!Ctor.__decorators__) {
            Ctor.__decorators__ = [];
        }
        if (typeof index !== 'number') {
            index = undefined;
        }
        Ctor.__decorators__.push(function (options) { return factory(options, key, index); });
    };
}
function mixins() {
    var Ctors = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        Ctors[_i] = arguments[_i];
    }
    return external_root_Vue_commonjs_vue_commonjs2_vue_amd_vue_default.a.extend({ mixins: Ctors });
}
function isPrimitive(value) {
    var type = typeof value;
    return value == null || (type !== 'object' && type !== 'function');
}
function warn(message) {
    if (typeof console !== 'undefined') {
        console.warn('[vue-class-component] ' + message);
    }
}

function collectDataFromConstructor(vm, Component) {
    // override _init to prevent to init as Vue instance
    var originalInit = Component.prototype._init;
    Component.prototype._init = function () {
        var _this = this;
        // proxy to actual vm
        var keys = Object.getOwnPropertyNames(vm);
        // 2.2.0 compat (props are no longer exposed as self properties)
        if (vm.$options.props) {
            for (var key in vm.$options.props) {
                if (!vm.hasOwnProperty(key)) {
                    keys.push(key);
                }
            }
        }
        keys.forEach(function (key) {
            if (key.charAt(0) !== '_') {
                Object.defineProperty(_this, key, {
                    get: function () { return vm[key]; },
                    set: function (value) { vm[key] = value; },
                    configurable: true
                });
            }
        });
    };
    // should be acquired class property values
    var data = new Component();
    // restore original _init to avoid memory leak (#209)
    Component.prototype._init = originalInit;
    // create plain data object
    var plainData = {};
    Object.keys(data).forEach(function (key) {
        if (data[key] !== undefined) {
            plainData[key] = data[key];
        }
    });
    if (false) {}
    return plainData;
}

var $internalHooks = [
    'data',
    'beforeCreate',
    'created',
    'beforeMount',
    'mounted',
    'beforeDestroy',
    'destroyed',
    'beforeUpdate',
    'updated',
    'activated',
    'deactivated',
    'render',
    'errorCaptured',
    'serverPrefetch' // 2.6
];
function componentFactory(Component, options) {
    if (options === void 0) { options = {}; }
    options.name = options.name || Component._componentTag || Component.name;
    // prototype props.
    var proto = Component.prototype;
    Object.getOwnPropertyNames(proto).forEach(function (key) {
        if (key === 'constructor') {
            return;
        }
        // hooks
        if ($internalHooks.indexOf(key) > -1) {
            options[key] = proto[key];
            return;
        }
        var descriptor = Object.getOwnPropertyDescriptor(proto, key);
        if (descriptor.value !== void 0) {
            // methods
            if (typeof descriptor.value === 'function') {
                (options.methods || (options.methods = {}))[key] = descriptor.value;
            }
            else {
                // typescript decorated data
                (options.mixins || (options.mixins = [])).push({
                    data: function () {
                        var _a;
                        return _a = {}, _a[key] = descriptor.value, _a;
                    }
                });
            }
        }
        else if (descriptor.get || descriptor.set) {
            // computed properties
            (options.computed || (options.computed = {}))[key] = {
                get: descriptor.get,
                set: descriptor.set
            };
        }
    });
    (options.mixins || (options.mixins = [])).push({
        data: function () {
            return collectDataFromConstructor(this, Component);
        }
    });
    // decorate options
    var decorators = Component.__decorators__;
    if (decorators) {
        decorators.forEach(function (fn) { return fn(options); });
        delete Component.__decorators__;
    }
    // find super
    var superProto = Object.getPrototypeOf(Component.prototype);
    var Super = superProto instanceof external_root_Vue_commonjs_vue_commonjs2_vue_amd_vue_default.a
        ? superProto.constructor
        : external_root_Vue_commonjs_vue_commonjs2_vue_amd_vue_default.a;
    var Extended = Super.extend(options);
    forwardStaticMembers(Extended, Component, Super);
    if (reflectionIsSupported) {
        copyReflectionMetadata(Extended, Component);
    }
    return Extended;
}
var reservedPropertyNames = [
    // Unique id
    'cid',
    // Super Vue constructor
    'super',
    // Component options that will be used by the component
    'options',
    'superOptions',
    'extendOptions',
    'sealedOptions',
    // Private assets
    'component',
    'directive',
    'filter'
];
var shouldIgnore = {
    prototype: true,
    arguments: true,
    callee: true,
    caller: true
};
function forwardStaticMembers(Extended, Original, Super) {
    // We have to use getOwnPropertyNames since Babel registers methods as non-enumerable
    Object.getOwnPropertyNames(Original).forEach(function (key) {
        // Skip the properties that should not be overwritten
        if (shouldIgnore[key]) {
            return;
        }
        // Some browsers does not allow reconfigure built-in properties
        var extendedDescriptor = Object.getOwnPropertyDescriptor(Extended, key);
        if (extendedDescriptor && !extendedDescriptor.configurable) {
            return;
        }
        var descriptor = Object.getOwnPropertyDescriptor(Original, key);
        // If the user agent does not support `__proto__` or its family (IE <= 10),
        // the sub class properties may be inherited properties from the super class in TypeScript.
        // We need to exclude such properties to prevent to overwrite
        // the component options object which stored on the extended constructor (See #192).
        // If the value is a referenced value (object or function),
        // we can check equality of them and exclude it if they have the same reference.
        // If it is a primitive value, it will be forwarded for safety.
        if (!hasProto) {
            // Only `cid` is explicitly exluded from property forwarding
            // because we cannot detect whether it is a inherited property or not
            // on the no `__proto__` environment even though the property is reserved.
            if (key === 'cid') {
                return;
            }
            var superDescriptor = Object.getOwnPropertyDescriptor(Super, key);
            if (!isPrimitive(descriptor.value) &&
                superDescriptor &&
                superDescriptor.value === descriptor.value) {
                return;
            }
        }
        // Warn if the users manually declare reserved properties
        if (false) {}
        Object.defineProperty(Extended, key, descriptor);
    });
}

function vue_class_component_esm_Component(options) {
    if (typeof options === 'function') {
        return componentFactory(options);
    }
    return function (Component) {
        return componentFactory(Component, options);
    };
}
vue_class_component_esm_Component.registerHooks = function registerHooks(keys) {
    $internalHooks.push.apply($internalHooks, keys);
};

/* harmony default export */ var vue_class_component_esm = (vue_class_component_esm_Component);


// CONCATENATED MODULE: ./node_modules/vue-property-decorator/lib/vue-property-decorator.js
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Inject", function() { return Inject; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "InjectReactive", function() { return InjectReactive; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Provide", function() { return Provide; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ProvideReactive", function() { return ProvideReactive; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Model", function() { return Model; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Prop", function() { return Prop; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PropSync", function() { return PropSync; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Watch", function() { return Watch; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Emit", function() { return Emit; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Ref", function() { return Ref; });
/* concated harmony reexport Component */__webpack_require__.d(__webpack_exports__, "Component", function() { return vue_class_component_esm; });
/* concated harmony reexport Vue */__webpack_require__.d(__webpack_exports__, "Vue", function() { return external_root_Vue_commonjs_vue_commonjs2_vue_amd_vue_default.a; });
/* concated harmony reexport Mixins */__webpack_require__.d(__webpack_exports__, "Mixins", function() { return mixins; });
/** vue-property-decorator verson 8.2.2 MIT LICENSE copyright 2019 kaorun343 */
/// <reference types='reflect-metadata'/>




/** Used for keying reactive provide/inject properties */
var reactiveInjectKey = '__reactiveInject__';
/**
 * decorator of an inject
 * @param from key
 * @return PropertyDecorator
 */
function Inject(options) {
    return createDecorator(function (componentOptions, key) {
        if (typeof componentOptions.inject === 'undefined') {
            componentOptions.inject = {};
        }
        if (!Array.isArray(componentOptions.inject)) {
            componentOptions.inject[key] = options || key;
        }
    });
}
/**
 * decorator of a reactive inject
 * @param from key
 * @return PropertyDecorator
 */
function InjectReactive(options) {
    return createDecorator(function (componentOptions, key) {
        if (typeof componentOptions.inject === 'undefined') {
            componentOptions.inject = {};
        }
        if (!Array.isArray(componentOptions.inject)) {
            var fromKey_1 = !!options ? options.from || options : key;
            var defaultVal_1 = (!!options && options.default) || undefined;
            if (!componentOptions.computed)
                componentOptions.computed = {};
            componentOptions.computed[key] = function () {
                var obj = this[reactiveInjectKey];
                return obj ? obj[fromKey_1] : defaultVal_1;
            };
            componentOptions.inject[reactiveInjectKey] = reactiveInjectKey;
        }
    });
}
/**
 * decorator of a provide
 * @param key key
 * @return PropertyDecorator | void
 */
function Provide(key) {
    return createDecorator(function (componentOptions, k) {
        var provide = componentOptions.provide;
        if (typeof provide !== 'function' || !provide.managed) {
            var original_1 = componentOptions.provide;
            provide = componentOptions.provide = function () {
                var rv = Object.create((typeof original_1 === 'function' ? original_1.call(this) : original_1) ||
                    null);
                for (var i in provide.managed)
                    rv[provide.managed[i]] = this[i];
                return rv;
            };
            provide.managed = {};
        }
        provide.managed[k] = key || k;
    });
}
/**
 * decorator of a reactive provide
 * @param key key
 * @return PropertyDecorator | void
 */
function ProvideReactive(key) {
    return createDecorator(function (componentOptions, k) {
        var provide = componentOptions.provide;
        // inject parent reactive services (if any)
        if (!Array.isArray(componentOptions.inject)) {
            componentOptions.inject = componentOptions.inject || {};
            componentOptions.inject[reactiveInjectKey] = { from: reactiveInjectKey, default: {} };
        }
        if (typeof provide !== 'function' || !provide.managedReactive) {
            var original_2 = componentOptions.provide;
            provide = componentOptions.provide = function () {
                var _this = this;
                var rv = typeof original_2 === 'function'
                    ? original_2.call(this)
                    : original_2;
                rv = Object.create(rv || null);
                // set reactive services (propagates previous services if necessary)
                rv[reactiveInjectKey] = this[reactiveInjectKey] || {};
                var _loop_1 = function (i) {
                    rv[provide.managedReactive[i]] = this_1[i]; // Duplicates the behavior of `@Provide`
                    Object.defineProperty(rv[reactiveInjectKey], provide.managedReactive[i], {
                        enumerable: true,
                        get: function () { return _this[i]; },
                    });
                };
                var this_1 = this;
                for (var i in provide.managedReactive) {
                    _loop_1(i);
                }
                return rv;
            };
            provide.managedReactive = {};
        }
        provide.managedReactive[k] = key || k;
    });
}
/** @see {@link https://github.com/vuejs/vue-class-component/blob/master/src/reflect.ts} */
var reflectMetadataIsSupported = typeof Reflect !== 'undefined' && typeof Reflect.getMetadata !== 'undefined';
function applyMetadata(options, target, key) {
    if (reflectMetadataIsSupported) {
        if (!Array.isArray(options) &&
            typeof options !== 'function' &&
            typeof options.type === 'undefined') {
            options.type = Reflect.getMetadata('design:type', target, key);
        }
    }
}
/**
 * decorator of model
 * @param  event event name
 * @param options options
 * @return PropertyDecorator
 */
function Model(event, options) {
    if (options === void 0) { options = {}; }
    return function (target, key) {
        applyMetadata(options, target, key);
        createDecorator(function (componentOptions, k) {
            ;
            (componentOptions.props || (componentOptions.props = {}))[k] = options;
            componentOptions.model = { prop: k, event: event || k };
        })(target, key);
    };
}
/**
 * decorator of a prop
 * @param  options the options for the prop
 * @return PropertyDecorator | void
 */
function Prop(options) {
    if (options === void 0) { options = {}; }
    return function (target, key) {
        applyMetadata(options, target, key);
        createDecorator(function (componentOptions, k) {
            ;
            (componentOptions.props || (componentOptions.props = {}))[k] = options;
        })(target, key);
    };
}
/**
 * decorator of a synced prop
 * @param propName the name to interface with from outside, must be different from decorated property
 * @param options the options for the synced prop
 * @return PropertyDecorator | void
 */
function PropSync(propName, options) {
    if (options === void 0) { options = {}; }
    // @ts-ignore
    return function (target, key) {
        applyMetadata(options, target, key);
        createDecorator(function (componentOptions, k) {
            ;
            (componentOptions.props || (componentOptions.props = {}))[propName] = options;
            (componentOptions.computed || (componentOptions.computed = {}))[k] = {
                get: function () {
                    return this[propName];
                },
                set: function (value) {
                    // @ts-ignore
                    this.$emit("update:" + propName, value);
                },
            };
        })(target, key);
    };
}
/**
 * decorator of a watch function
 * @param  path the path or the expression to observe
 * @param  WatchOption
 * @return MethodDecorator
 */
function Watch(path, options) {
    if (options === void 0) { options = {}; }
    var _a = options.deep, deep = _a === void 0 ? false : _a, _b = options.immediate, immediate = _b === void 0 ? false : _b;
    return createDecorator(function (componentOptions, handler) {
        if (typeof componentOptions.watch !== 'object') {
            componentOptions.watch = Object.create(null);
        }
        var watch = componentOptions.watch;
        if (typeof watch[path] === 'object' && !Array.isArray(watch[path])) {
            watch[path] = [watch[path]];
        }
        else if (typeof watch[path] === 'undefined') {
            watch[path] = [];
        }
        watch[path].push({ handler: handler, deep: deep, immediate: immediate });
    });
}
// Code copied from Vue/src/shared/util.js
var hyphenateRE = /\B([A-Z])/g;
var hyphenate = function (str) { return str.replace(hyphenateRE, '-$1').toLowerCase(); };
/**
 * decorator of an event-emitter function
 * @param  event The name of the event
 * @return MethodDecorator
 */
function Emit(event) {
    return function (_target, key, descriptor) {
        key = hyphenate(key);
        var original = descriptor.value;
        descriptor.value = function emitter() {
            var _this = this;
            var args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                args[_i] = arguments[_i];
            }
            var emit = function (returnValue) {
                if (returnValue !== undefined)
                    args.unshift(returnValue);
                _this.$emit.apply(_this, [event || key].concat(args));
            };
            var returnValue = original.apply(this, args);
            if (isPromise(returnValue)) {
                returnValue.then(function (returnValue) {
                    emit(returnValue);
                });
            }
            else {
                emit(returnValue);
            }
            return returnValue;
        };
    };
}
/**
 * decorator of a ref prop
 * @param refKey the ref key defined in template
 */
function Ref(refKey) {
    return createDecorator(function (options, key) {
        options.computed = options.computed || {};
        options.computed[key] = {
            cache: false,
            get: function () {
                return this.$refs[refKey || key];
            },
        };
    });
}
function isPromise(obj) {
    return obj instanceof Promise || (obj && typeof obj.then === 'function');
}


/***/ }),

/***/ "YuTi":
/***/ (function(module, exports) {

module.exports = function(module) {
	if (!module.webpackPolyfill) {
		module.deprecate = function() {};
		module.paths = [];
		// module.parent = undefined by default
		if (!module.children) module.children = [];
		Object.defineProperty(module, "loaded", {
			enumerable: true,
			get: function() {
				return module.l;
			}
		});
		Object.defineProperty(module, "id", {
			enumerable: true,
			get: function() {
				return module.i;
			}
		});
		module.webpackPolyfill = 1;
	}
	return module;
};


/***/ }),

/***/ "Z94/":
/***/ (function(module, exports) {

/**
 * lodash 3.0.3 (Custom Build) <https://lodash.com/>
 * Build: `lodash modularize exports="npm" -o ./`
 * Copyright 2012-2016 The Dojo Foundation <http://dojofoundation.org/>
 * Based on Underscore.js 1.8.3 <http://underscorejs.org/LICENSE>
 * Copyright 2009-2016 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
 * Available under MIT license <https://lodash.com/license>
 */

/** `Object#toString` result references. */
var numberTag = '[object Number]';

/** Used for built-in method references. */
var objectProto = Object.prototype;

/**
 * Used to resolve the [`toStringTag`](http://ecma-international.org/ecma-262/6.0/#sec-object.prototype.tostring)
 * of values.
 */
var objectToString = objectProto.toString;

/**
 * Checks if `value` is object-like. A value is object-like if it's not `null`
 * and has a `typeof` result of "object".
 *
 * @static
 * @memberOf _
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is object-like, else `false`.
 * @example
 *
 * _.isObjectLike({});
 * // => true
 *
 * _.isObjectLike([1, 2, 3]);
 * // => true
 *
 * _.isObjectLike(_.noop);
 * // => false
 *
 * _.isObjectLike(null);
 * // => false
 */
function isObjectLike(value) {
  return !!value && typeof value == 'object';
}

/**
 * Checks if `value` is classified as a `Number` primitive or object.
 *
 * **Note:** To exclude `Infinity`, `-Infinity`, and `NaN`, which are classified
 * as numbers, use the `_.isFinite` method.
 *
 * @static
 * @memberOf _
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is correctly classified, else `false`.
 * @example
 *
 * _.isNumber(3);
 * // => true
 *
 * _.isNumber(Number.MIN_VALUE);
 * // => true
 *
 * _.isNumber(Infinity);
 * // => true
 *
 * _.isNumber('3');
 * // => false
 */
function isNumber(value) {
  return typeof value == 'number' ||
    (isObjectLike(value) && objectToString.call(value) == numberTag);
}

module.exports = isNumber;


/***/ }),

/***/ "ZgnL":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";

// CONCATENATED MODULE: ./node_modules/vue-loader/lib/loaders/templateLoader.js??vue-loader-options!./node_modules/vue-loader/lib??vue-loader-options!./src/common/chart/ChartMixin.vue?vue&type=template&id=0d0e6a6e&
var render = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('sm-card',{directives:[{name:"show",rawName:"v-show",value:(_vm.isShow),expression:"isShow"}],staticClass:"sm-component-chart",attrs:{"icon-class":_vm.iconClass,"icon-position":_vm.position,"header-name":_vm.headerName,"auto-rotate":_vm.autoRotate,"collapsed":_vm.collapsed}},[_c('v-chart',{ref:_vm.chartId,style:(_vm._chartStyle),attrs:{"id":_vm.chartId,"options":_vm._chartOptions,"autoresize":_vm.autoresize,"initOptions":_vm.initOptions,"group":_vm.group,"manual-update":_vm.manualUpdate,"theme":_vm.theme || _vm.chartTheme}}),_vm._v(" "),_c('TablePopup',_vm._b({directives:[{name:"show",rawName:"v-show",value:(false),expression:"false"}],ref:"chartTablePopup",attrs:{"text-color":_vm.textColor,"background":_vm.background}},'TablePopup',_vm.tablePopupProps,false))],1)}
var staticRenderFns = []


// CONCATENATED MODULE: ./src/common/chart/ChartMixin.vue?vue&type=template&id=0d0e6a6e&
/* concated harmony reexport render */__webpack_require__.d(__webpack_exports__, "a", function() { return render; });
/* concated harmony reexport staticRenderFns */__webpack_require__.d(__webpack_exports__, "b", function() { return staticRenderFns; });


/***/ }),

/***/ "Zni2":
/***/ (function(module, exports) {

module.exports = __WEBPACK_EXTERNAL_MODULE_Zni2__;

/***/ }),

/***/ "a1gu":
/***/ (function(module, exports, __webpack_require__) {

var _typeof = __webpack_require__("cDf5");

var assertThisInitialized = __webpack_require__("PJYZ");

function _possibleConstructorReturn(self, call) {
  if (call && (_typeof(call) === "object" || typeof call === "function")) {
    return call;
  }

  return assertThisInitialized(self);
}

module.exports = _possibleConstructorReturn;

/***/ }),

/***/ "axHA":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";

// CONCATENATED MODULE: ./node_modules/vue-loader/lib/loaders/templateLoader.js??vue-loader-options!./node_modules/vue-loader/lib??vue-loader-options!./src/common/indicator/Indicator.vue?vue&type=template&id=72e86396&
var render = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{staticClass:"sm-component-indicator",style:([_vm.getBackgroundStyle, { 'flex-direction': _vm.direction }])},[_c('div',{staticClass:"sm-component-indicator__head"},[_c('span',{directives:[{name:"show",rawName:"v-show",value:(_vm.showTitleUnit),expression:"showTitleUnit"}],staticClass:"sm-component-indicator__title",style:([_vm.unit_titleStyle, _vm.getTextColorStyle])},[_vm._v("\n      "+_vm._s(_vm.titleData)+"\n    ")])]),_vm._v(" "),_c('div',{staticClass:"sm-component-indicator__content"},[_c('span',{staticClass:"sm-component-indicator__num",style:([_vm.indicatorStyle])},[(_vm.isNumber(_vm.indicatorNum))?_c('countTo',{attrs:{"decimals":_vm.calDecimals,"startVal":_vm.startData,"endVal":_vm.numData,"duration":Number(_vm.duration) || 1000,"separator":_vm.separator,"numBackground":_vm.numBackground,"numSpacing":_vm.numSpacing,"separatorBackground":_vm.separatorBackground,"fontSize":_vm.fontSize}}):_vm._e(),_vm._v("\n      "+_vm._s(_vm.isNumber(_vm.indicatorNum) ? '' : _vm.indicatorNum)+"\n    ")],1),_vm._v(" "),_c('span',{directives:[{name:"show",rawName:"v-show",value:(_vm.showTitleUnit),expression:"showTitleUnit"}],staticClass:"sm-component-indicator__unit",style:([_vm.unit_titleStyle, _vm.getTextColorStyle])},[_vm._v(_vm._s(_vm.unitData))])])])}
var staticRenderFns = []


// CONCATENATED MODULE: ./src/common/indicator/Indicator.vue?vue&type=template&id=72e86396&
/* concated harmony reexport render */__webpack_require__.d(__webpack_exports__, "a", function() { return render; });
/* concated harmony reexport staticRenderFns */__webpack_require__.d(__webpack_exports__, "b", function() { return staticRenderFns; });


/***/ }),

/***/ "bCOg":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__("TqRt");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _classCallCheck2 = _interopRequireDefault(__webpack_require__("lwsE"));

var _createClass2 = _interopRequireDefault(__webpack_require__("W8MJ"));

var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__("a1gu"));

var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__("Nsbk"));

var _inherits2 = _interopRequireDefault(__webpack_require__("7W2i"));

var _typeof2 = _interopRequireDefault(__webpack_require__("cDf5"));

var _vue = _interopRequireDefault(__webpack_require__("i7/w"));

var _vuePropertyDecorator = __webpack_require__("YKMj");

var _globalEvent = _interopRequireDefault(__webpack_require__("qF08"));

var __decorate = void 0 && (void 0).__decorate || function (decorators, target, key, desc) {
  var c = arguments.length,
      r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
      d;
  if ((typeof Reflect === "undefined" ? "undefined" : (0, _typeof2.default)(Reflect)) === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);else for (var i = decorators.length - 1; i >= 0; i--) {
    if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
  }
  return c > 3 && r && Object.defineProperty(target, key, r), r;
};

var Theme =
/*#__PURE__*/
function (_Vue) {
  (0, _inherits2.default)(Theme, _Vue);

  function Theme() {
    var _this;

    (0, _classCallCheck2.default)(this, Theme);
    _this = (0, _possibleConstructorReturn2.default)(this, (0, _getPrototypeOf2.default)(Theme).apply(this, arguments));
    _this.backgroundData = '';
    _this.textColorsData = '';
    _this.colorGroupsData = [];
    return _this;
  }

  (0, _createClass2.default)(Theme, [{
    key: "backgroundChanged",
    value: function backgroundChanged(newValue) {
      this.backgroundData = newValue;
    }
  }, {
    key: "textColorChanged",
    value: function textColorChanged(newValue) {
      this.textColorsData = newValue;
    }
  }, {
    key: "colorGroupChanged",
    value: function colorGroupChanged(newValue) {
      this.colorGroupsData = newValue;
    }
  }, {
    key: "created",
    value: function created() {
      var theme = _globalEvent.default.$options.theme;
      this.backgroundData = this.background || theme && theme.background;
      this.textColorsData = this.textColor || theme && theme.textColor;
      this.colorGroupsData = this.colorGroup || theme && theme.colorGroup;
    }
  }, {
    key: "themeStyleChanged",
    value: function themeStyleChanged(value) {
      return value;
    }
  }, {
    key: "mounted",
    value: function mounted() {
      var _this2 = this;

      _globalEvent.default.$on('change-theme', function (themeStyle) {
        _this2.backgroundData = themeStyle.background;
        _this2.textColorsData = themeStyle.textColor;
        _this2.colorGroupsData = themeStyle.colorGroup;

        _this2.themeStyleChanged();
      });
    }
  }, {
    key: "getBackgroundStyle",
    get: function get() {
      return {
        background: this.backgroundData
      };
    }
  }, {
    key: "getTextColorStyle",
    get: function get() {
      return {
        color: this.textColorsData
      };
    }
  }, {
    key: "getBackground",
    get: function get() {
      return this.backgroundData;
    }
  }, {
    key: "getTextColor",
    get: function get() {
      return this.textColorsData;
    }
  }, {
    key: "getColorStyle",
    get: function get() {
      return function (index) {
        return {
          color: this.colorGroupsData[index]
        };
      };
    }
  }, {
    key: "getColor",
    get: function get() {
      return function (index) {
        return this.colorGroupsData[index];
      };
    }
  }]);
  return Theme;
}(_vue.default);

__decorate([(0, _vuePropertyDecorator.Prop)()], Theme.prototype, "background", void 0);

__decorate([(0, _vuePropertyDecorator.Prop)()], Theme.prototype, "textColor", void 0);

__decorate([(0, _vuePropertyDecorator.Prop)()], Theme.prototype, "colorGroup", void 0);

__decorate([(0, _vuePropertyDecorator.Watch)('background')], Theme.prototype, "backgroundChanged", null);

__decorate([(0, _vuePropertyDecorator.Watch)('textColor')], Theme.prototype, "textColorChanged", null);

__decorate([(0, _vuePropertyDecorator.Watch)('colorGroup')], Theme.prototype, "colorGroupChanged", null);

__decorate([(0, _vuePropertyDecorator.Emit)()], Theme.prototype, "themeStyleChanged", null);

Theme = __decorate([_vuePropertyDecorator.Component], Theme);
var _default = Theme;
exports.default = _default;

/***/ }),

/***/ "bD5U":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _interopRequireWildcard = __webpack_require__("284h");

var _interopRequireDefault = __webpack_require__("TqRt");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _globalEvent = _interopRequireDefault(__webpack_require__("qF08"));

var _antDesignVue = __webpack_require__("TnLG");

var _lang = __webpack_require__("DSM6");

var _theme = _interopRequireDefault(__webpack_require__("2Zn6"));

var components = _interopRequireWildcard(__webpack_require__("jUok"));

__webpack_require__("1P0Z");

var commontypes = _interopRequireWildcard(__webpack_require__("NGA9"));

var setTheme = function setTheme() {
  var themeStyle = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

  if (typeof themeStyle === 'string') {
    themeStyle = _theme.default.filter(function (item) {
      return item.label === themeStyle;
    })[0] || {};
  }

  _globalEvent.default.$options.theme = themeStyle;

  _globalEvent.default.$emit('change-theme', themeStyle);
};

var install = function install(Vue) {
  var opts = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var theme = opts.theme || 'light';

  __webpack_require__("utZJ")("./".concat(theme, ".scss"));

  __webpack_require__("jsF9");

  setTheme(theme);
  Vue.use(_antDesignVue.Button);
  Vue.use(_antDesignVue.Checkbox);
  Vue.use(_antDesignVue.Card);
  Vue.use(_antDesignVue.Slider);
  Vue.use(_antDesignVue.Select);
  Vue.use(_antDesignVue.Collapse);
  Vue.use(_antDesignVue.Input);
  Vue.use(_antDesignVue.Table);
  Vue.use(_antDesignVue.Progress);
  Vue.use(_antDesignVue.Icon);
  Vue.use(_antDesignVue.Spin);
  Vue.use(_antDesignVue.Modal);
  Vue.use(_antDesignVue.Tree);
  Vue.use(_antDesignVue.Tabs);
  Vue.prototype.$message = _antDesignVue.message;
  (0, _lang.initi18n)(Vue, opts);

  for (var component in components) {
    var com = components[component];
    Vue.component(com.options ? com.options.name : com.name, com);
  }
};

if (typeof window !== 'undefined' && window['Vue']) {
  install(window['Vue'], {
    theme: 'light'
  });
}

var _default = {
  setTheme: setTheme,
  commontypes: commontypes,
  lang: _lang.lang,
  locale: _lang.setLocale,
  install: install
};
exports.default = _default;

/***/ }),

/***/ "cDf5":
/***/ (function(module, exports) {

function _typeof(obj) {
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    module.exports = _typeof = function _typeof(obj) {
      return typeof obj;
    };
  } else {
    module.exports = _typeof = function _typeof(obj) {
      return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
    };
  }

  return _typeof(obj);
}

module.exports = _typeof;

/***/ }),

/***/ "cV8Z":
/***/ (function(module, exports, __webpack_require__) {

var map = {
	"./border1.png": "JBR1",
	"./border10.png": "Cb6A",
	"./border11.png": "9pJD",
	"./border12.png": "X7Q1",
	"./border13.png": "DMW1",
	"./border2.png": "ifxw",
	"./border3.png": "usAy",
	"./border4.png": "9rNx",
	"./border5.png": "3N2c",
	"./border6.png": "4EGE",
	"./border7.png": "riVy",
	"./border8.png": "vsHO",
	"./border9.png": "ImIo"
};


function webpackContext(req) {
	var id = webpackContextResolve(req);
	return __webpack_require__(id);
}
function webpackContextResolve(req) {
	if(!__webpack_require__.o(map, req)) {
		var e = new Error("Cannot find module '" + req + "'");
		e.code = 'MODULE_NOT_FOUND';
		throw e;
	}
	return map[req];
}
webpackContext.keys = function webpackContextKeys() {
	return Object.keys(map);
};
webpackContext.resolve = webpackContextResolve;
module.exports = webpackContext;
webpackContext.id = "cV8Z";

/***/ }),

/***/ "cWyK":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, '__esModule', { value: true });

var helpers = __webpack_require__("/rf6");

/**
 * Callback for coordEach
 *
 * @callback coordEachCallback
 * @param {Array<number>} currentCoord The current coordinate being processed.
 * @param {number} coordIndex The current index of the coordinate being processed.
 * @param {number} featureIndex The current index of the Feature being processed.
 * @param {number} multiFeatureIndex The current index of the Multi-Feature being processed.
 * @param {number} geometryIndex The current index of the Geometry being processed.
 */

/**
 * Iterate over coordinates in any GeoJSON object, similar to Array.forEach()
 *
 * @name coordEach
 * @param {FeatureCollection|Feature|Geometry} geojson any GeoJSON object
 * @param {Function} callback a method that takes (currentCoord, coordIndex, featureIndex, multiFeatureIndex)
 * @param {boolean} [excludeWrapCoord=false] whether or not to include the final coordinate of LinearRings that wraps the ring in its iteration.
 * @returns {void}
 * @example
 * var features = turf.featureCollection([
 *   turf.point([26, 37], {"foo": "bar"}),
 *   turf.point([36, 53], {"hello": "world"})
 * ]);
 *
 * turf.coordEach(features, function (currentCoord, coordIndex, featureIndex, multiFeatureIndex, geometryIndex) {
 *   //=currentCoord
 *   //=coordIndex
 *   //=featureIndex
 *   //=multiFeatureIndex
 *   //=geometryIndex
 * });
 */
function coordEach(geojson, callback, excludeWrapCoord) {
    // Handles null Geometry -- Skips this GeoJSON
    if (geojson === null) return;
    var j, k, l, geometry, stopG, coords,
        geometryMaybeCollection,
        wrapShrink = 0,
        coordIndex = 0,
        isGeometryCollection,
        type = geojson.type,
        isFeatureCollection = type === 'FeatureCollection',
        isFeature = type === 'Feature',
        stop = isFeatureCollection ? geojson.features.length : 1;

    // This logic may look a little weird. The reason why it is that way
    // is because it's trying to be fast. GeoJSON supports multiple kinds
    // of objects at its root: FeatureCollection, Features, Geometries.
    // This function has the responsibility of handling all of them, and that
    // means that some of the `for` loops you see below actually just don't apply
    // to certain inputs. For instance, if you give this just a
    // Point geometry, then both loops are short-circuited and all we do
    // is gradually rename the input until it's called 'geometry'.
    //
    // This also aims to allocate as few resources as possible: just a
    // few numbers and booleans, rather than any temporary arrays as would
    // be required with the normalization approach.
    for (var featureIndex = 0; featureIndex < stop; featureIndex++) {
        geometryMaybeCollection = (isFeatureCollection ? geojson.features[featureIndex].geometry :
            (isFeature ? geojson.geometry : geojson));
        isGeometryCollection = (geometryMaybeCollection) ? geometryMaybeCollection.type === 'GeometryCollection' : false;
        stopG = isGeometryCollection ? geometryMaybeCollection.geometries.length : 1;

        for (var geomIndex = 0; geomIndex < stopG; geomIndex++) {
            var multiFeatureIndex = 0;
            var geometryIndex = 0;
            geometry = isGeometryCollection ?
                geometryMaybeCollection.geometries[geomIndex] : geometryMaybeCollection;

            // Handles null Geometry -- Skips this geometry
            if (geometry === null) continue;
            coords = geometry.coordinates;
            var geomType = geometry.type;

            wrapShrink = (excludeWrapCoord && (geomType === 'Polygon' || geomType === 'MultiPolygon')) ? 1 : 0;

            switch (geomType) {
            case null:
                break;
            case 'Point':
                if (callback(coords, coordIndex, featureIndex, multiFeatureIndex, geometryIndex) === false) return false;
                coordIndex++;
                multiFeatureIndex++;
                break;
            case 'LineString':
            case 'MultiPoint':
                for (j = 0; j < coords.length; j++) {
                    if (callback(coords[j], coordIndex, featureIndex, multiFeatureIndex, geometryIndex) === false) return false;
                    coordIndex++;
                    if (geomType === 'MultiPoint') multiFeatureIndex++;
                }
                if (geomType === 'LineString') multiFeatureIndex++;
                break;
            case 'Polygon':
            case 'MultiLineString':
                for (j = 0; j < coords.length; j++) {
                    for (k = 0; k < coords[j].length - wrapShrink; k++) {
                        if (callback(coords[j][k], coordIndex, featureIndex, multiFeatureIndex, geometryIndex) === false) return false;
                        coordIndex++;
                    }
                    if (geomType === 'MultiLineString') multiFeatureIndex++;
                    if (geomType === 'Polygon') geometryIndex++;
                }
                if (geomType === 'Polygon') multiFeatureIndex++;
                break;
            case 'MultiPolygon':
                for (j = 0; j < coords.length; j++) {
                    geometryIndex = 0;
                    for (k = 0; k < coords[j].length; k++) {
                        for (l = 0; l < coords[j][k].length - wrapShrink; l++) {
                            if (callback(coords[j][k][l], coordIndex, featureIndex, multiFeatureIndex, geometryIndex) === false) return false;
                            coordIndex++;
                        }
                        geometryIndex++;
                    }
                    multiFeatureIndex++;
                }
                break;
            case 'GeometryCollection':
                for (j = 0; j < geometry.geometries.length; j++)
                    if (coordEach(geometry.geometries[j], callback, excludeWrapCoord) === false) return false;
                break;
            default:
                throw new Error('Unknown Geometry Type');
            }
        }
    }
}

/**
 * Callback for coordReduce
 *
 * The first time the callback function is called, the values provided as arguments depend
 * on whether the reduce method has an initialValue argument.
 *
 * If an initialValue is provided to the reduce method:
 *  - The previousValue argument is initialValue.
 *  - The currentValue argument is the value of the first element present in the array.
 *
 * If an initialValue is not provided:
 *  - The previousValue argument is the value of the first element present in the array.
 *  - The currentValue argument is the value of the second element present in the array.
 *
 * @callback coordReduceCallback
 * @param {*} previousValue The accumulated value previously returned in the last invocation
 * of the callback, or initialValue, if supplied.
 * @param {Array<number>} currentCoord The current coordinate being processed.
 * @param {number} coordIndex The current index of the coordinate being processed.
 * Starts at index 0, if an initialValue is provided, and at index 1 otherwise.
 * @param {number} featureIndex The current index of the Feature being processed.
 * @param {number} multiFeatureIndex The current index of the Multi-Feature being processed.
 * @param {number} geometryIndex The current index of the Geometry being processed.
 */

/**
 * Reduce coordinates in any GeoJSON object, similar to Array.reduce()
 *
 * @name coordReduce
 * @param {FeatureCollection|Geometry|Feature} geojson any GeoJSON object
 * @param {Function} callback a method that takes (previousValue, currentCoord, coordIndex)
 * @param {*} [initialValue] Value to use as the first argument to the first call of the callback.
 * @param {boolean} [excludeWrapCoord=false] whether or not to include the final coordinate of LinearRings that wraps the ring in its iteration.
 * @returns {*} The value that results from the reduction.
 * @example
 * var features = turf.featureCollection([
 *   turf.point([26, 37], {"foo": "bar"}),
 *   turf.point([36, 53], {"hello": "world"})
 * ]);
 *
 * turf.coordReduce(features, function (previousValue, currentCoord, coordIndex, featureIndex, multiFeatureIndex, geometryIndex) {
 *   //=previousValue
 *   //=currentCoord
 *   //=coordIndex
 *   //=featureIndex
 *   //=multiFeatureIndex
 *   //=geometryIndex
 *   return currentCoord;
 * });
 */
function coordReduce(geojson, callback, initialValue, excludeWrapCoord) {
    var previousValue = initialValue;
    coordEach(geojson, function (currentCoord, coordIndex, featureIndex, multiFeatureIndex, geometryIndex) {
        if (coordIndex === 0 && initialValue === undefined) previousValue = currentCoord;
        else previousValue = callback(previousValue, currentCoord, coordIndex, featureIndex, multiFeatureIndex, geometryIndex);
    }, excludeWrapCoord);
    return previousValue;
}

/**
 * Callback for propEach
 *
 * @callback propEachCallback
 * @param {Object} currentProperties The current Properties being processed.
 * @param {number} featureIndex The current index of the Feature being processed.
 */

/**
 * Iterate over properties in any GeoJSON object, similar to Array.forEach()
 *
 * @name propEach
 * @param {FeatureCollection|Feature} geojson any GeoJSON object
 * @param {Function} callback a method that takes (currentProperties, featureIndex)
 * @returns {void}
 * @example
 * var features = turf.featureCollection([
 *     turf.point([26, 37], {foo: 'bar'}),
 *     turf.point([36, 53], {hello: 'world'})
 * ]);
 *
 * turf.propEach(features, function (currentProperties, featureIndex) {
 *   //=currentProperties
 *   //=featureIndex
 * });
 */
function propEach(geojson, callback) {
    var i;
    switch (geojson.type) {
    case 'FeatureCollection':
        for (i = 0; i < geojson.features.length; i++) {
            if (callback(geojson.features[i].properties, i) === false) break;
        }
        break;
    case 'Feature':
        callback(geojson.properties, 0);
        break;
    }
}


/**
 * Callback for propReduce
 *
 * The first time the callback function is called, the values provided as arguments depend
 * on whether the reduce method has an initialValue argument.
 *
 * If an initialValue is provided to the reduce method:
 *  - The previousValue argument is initialValue.
 *  - The currentValue argument is the value of the first element present in the array.
 *
 * If an initialValue is not provided:
 *  - The previousValue argument is the value of the first element present in the array.
 *  - The currentValue argument is the value of the second element present in the array.
 *
 * @callback propReduceCallback
 * @param {*} previousValue The accumulated value previously returned in the last invocation
 * of the callback, or initialValue, if supplied.
 * @param {*} currentProperties The current Properties being processed.
 * @param {number} featureIndex The current index of the Feature being processed.
 */

/**
 * Reduce properties in any GeoJSON object into a single value,
 * similar to how Array.reduce works. However, in this case we lazily run
 * the reduction, so an array of all properties is unnecessary.
 *
 * @name propReduce
 * @param {FeatureCollection|Feature} geojson any GeoJSON object
 * @param {Function} callback a method that takes (previousValue, currentProperties, featureIndex)
 * @param {*} [initialValue] Value to use as the first argument to the first call of the callback.
 * @returns {*} The value that results from the reduction.
 * @example
 * var features = turf.featureCollection([
 *     turf.point([26, 37], {foo: 'bar'}),
 *     turf.point([36, 53], {hello: 'world'})
 * ]);
 *
 * turf.propReduce(features, function (previousValue, currentProperties, featureIndex) {
 *   //=previousValue
 *   //=currentProperties
 *   //=featureIndex
 *   return currentProperties
 * });
 */
function propReduce(geojson, callback, initialValue) {
    var previousValue = initialValue;
    propEach(geojson, function (currentProperties, featureIndex) {
        if (featureIndex === 0 && initialValue === undefined) previousValue = currentProperties;
        else previousValue = callback(previousValue, currentProperties, featureIndex);
    });
    return previousValue;
}

/**
 * Callback for featureEach
 *
 * @callback featureEachCallback
 * @param {Feature<any>} currentFeature The current Feature being processed.
 * @param {number} featureIndex The current index of the Feature being processed.
 */

/**
 * Iterate over features in any GeoJSON object, similar to
 * Array.forEach.
 *
 * @name featureEach
 * @param {FeatureCollection|Feature|Geometry} geojson any GeoJSON object
 * @param {Function} callback a method that takes (currentFeature, featureIndex)
 * @returns {void}
 * @example
 * var features = turf.featureCollection([
 *   turf.point([26, 37], {foo: 'bar'}),
 *   turf.point([36, 53], {hello: 'world'})
 * ]);
 *
 * turf.featureEach(features, function (currentFeature, featureIndex) {
 *   //=currentFeature
 *   //=featureIndex
 * });
 */
function featureEach(geojson, callback) {
    if (geojson.type === 'Feature') {
        callback(geojson, 0);
    } else if (geojson.type === 'FeatureCollection') {
        for (var i = 0; i < geojson.features.length; i++) {
            if (callback(geojson.features[i], i) === false) break;
        }
    }
}

/**
 * Callback for featureReduce
 *
 * The first time the callback function is called, the values provided as arguments depend
 * on whether the reduce method has an initialValue argument.
 *
 * If an initialValue is provided to the reduce method:
 *  - The previousValue argument is initialValue.
 *  - The currentValue argument is the value of the first element present in the array.
 *
 * If an initialValue is not provided:
 *  - The previousValue argument is the value of the first element present in the array.
 *  - The currentValue argument is the value of the second element present in the array.
 *
 * @callback featureReduceCallback
 * @param {*} previousValue The accumulated value previously returned in the last invocation
 * of the callback, or initialValue, if supplied.
 * @param {Feature} currentFeature The current Feature being processed.
 * @param {number} featureIndex The current index of the Feature being processed.
 */

/**
 * Reduce features in any GeoJSON object, similar to Array.reduce().
 *
 * @name featureReduce
 * @param {FeatureCollection|Feature|Geometry} geojson any GeoJSON object
 * @param {Function} callback a method that takes (previousValue, currentFeature, featureIndex)
 * @param {*} [initialValue] Value to use as the first argument to the first call of the callback.
 * @returns {*} The value that results from the reduction.
 * @example
 * var features = turf.featureCollection([
 *   turf.point([26, 37], {"foo": "bar"}),
 *   turf.point([36, 53], {"hello": "world"})
 * ]);
 *
 * turf.featureReduce(features, function (previousValue, currentFeature, featureIndex) {
 *   //=previousValue
 *   //=currentFeature
 *   //=featureIndex
 *   return currentFeature
 * });
 */
function featureReduce(geojson, callback, initialValue) {
    var previousValue = initialValue;
    featureEach(geojson, function (currentFeature, featureIndex) {
        if (featureIndex === 0 && initialValue === undefined) previousValue = currentFeature;
        else previousValue = callback(previousValue, currentFeature, featureIndex);
    });
    return previousValue;
}

/**
 * Get all coordinates from any GeoJSON object.
 *
 * @name coordAll
 * @param {FeatureCollection|Feature|Geometry} geojson any GeoJSON object
 * @returns {Array<Array<number>>} coordinate position array
 * @example
 * var features = turf.featureCollection([
 *   turf.point([26, 37], {foo: 'bar'}),
 *   turf.point([36, 53], {hello: 'world'})
 * ]);
 *
 * var coords = turf.coordAll(features);
 * //= [[26, 37], [36, 53]]
 */
function coordAll(geojson) {
    var coords = [];
    coordEach(geojson, function (coord) {
        coords.push(coord);
    });
    return coords;
}

/**
 * Callback for geomEach
 *
 * @callback geomEachCallback
 * @param {Geometry} currentGeometry The current Geometry being processed.
 * @param {number} featureIndex The current index of the Feature being processed.
 * @param {Object} featureProperties The current Feature Properties being processed.
 * @param {Array<number>} featureBBox The current Feature BBox being processed.
 * @param {number|string} featureId The current Feature Id being processed.
 */

/**
 * Iterate over each geometry in any GeoJSON object, similar to Array.forEach()
 *
 * @name geomEach
 * @param {FeatureCollection|Feature|Geometry} geojson any GeoJSON object
 * @param {Function} callback a method that takes (currentGeometry, featureIndex, featureProperties, featureBBox, featureId)
 * @returns {void}
 * @example
 * var features = turf.featureCollection([
 *     turf.point([26, 37], {foo: 'bar'}),
 *     turf.point([36, 53], {hello: 'world'})
 * ]);
 *
 * turf.geomEach(features, function (currentGeometry, featureIndex, featureProperties, featureBBox, featureId) {
 *   //=currentGeometry
 *   //=featureIndex
 *   //=featureProperties
 *   //=featureBBox
 *   //=featureId
 * });
 */
function geomEach(geojson, callback) {
    var i, j, g, geometry, stopG,
        geometryMaybeCollection,
        isGeometryCollection,
        featureProperties,
        featureBBox,
        featureId,
        featureIndex = 0,
        isFeatureCollection = geojson.type === 'FeatureCollection',
        isFeature = geojson.type === 'Feature',
        stop = isFeatureCollection ? geojson.features.length : 1;

    // This logic may look a little weird. The reason why it is that way
    // is because it's trying to be fast. GeoJSON supports multiple kinds
    // of objects at its root: FeatureCollection, Features, Geometries.
    // This function has the responsibility of handling all of them, and that
    // means that some of the `for` loops you see below actually just don't apply
    // to certain inputs. For instance, if you give this just a
    // Point geometry, then both loops are short-circuited and all we do
    // is gradually rename the input until it's called 'geometry'.
    //
    // This also aims to allocate as few resources as possible: just a
    // few numbers and booleans, rather than any temporary arrays as would
    // be required with the normalization approach.
    for (i = 0; i < stop; i++) {

        geometryMaybeCollection = (isFeatureCollection ? geojson.features[i].geometry :
            (isFeature ? geojson.geometry : geojson));
        featureProperties = (isFeatureCollection ? geojson.features[i].properties :
            (isFeature ? geojson.properties : {}));
        featureBBox = (isFeatureCollection ? geojson.features[i].bbox :
            (isFeature ? geojson.bbox : undefined));
        featureId = (isFeatureCollection ? geojson.features[i].id :
            (isFeature ? geojson.id : undefined));
        isGeometryCollection = (geometryMaybeCollection) ? geometryMaybeCollection.type === 'GeometryCollection' : false;
        stopG = isGeometryCollection ? geometryMaybeCollection.geometries.length : 1;

        for (g = 0; g < stopG; g++) {
            geometry = isGeometryCollection ?
                geometryMaybeCollection.geometries[g] : geometryMaybeCollection;

            // Handle null Geometry
            if (geometry === null) {
                if (callback(null, featureIndex, featureProperties, featureBBox, featureId) === false) return false;
                continue;
            }
            switch (geometry.type) {
            case 'Point':
            case 'LineString':
            case 'MultiPoint':
            case 'Polygon':
            case 'MultiLineString':
            case 'MultiPolygon': {
                if (callback(geometry, featureIndex, featureProperties, featureBBox, featureId) === false) return false;
                break;
            }
            case 'GeometryCollection': {
                for (j = 0; j < geometry.geometries.length; j++) {
                    if (callback(geometry.geometries[j], featureIndex, featureProperties, featureBBox, featureId) === false) return false;
                }
                break;
            }
            default:
                throw new Error('Unknown Geometry Type');
            }
        }
        // Only increase `featureIndex` per each feature
        featureIndex++;
    }
}

/**
 * Callback for geomReduce
 *
 * The first time the callback function is called, the values provided as arguments depend
 * on whether the reduce method has an initialValue argument.
 *
 * If an initialValue is provided to the reduce method:
 *  - The previousValue argument is initialValue.
 *  - The currentValue argument is the value of the first element present in the array.
 *
 * If an initialValue is not provided:
 *  - The previousValue argument is the value of the first element present in the array.
 *  - The currentValue argument is the value of the second element present in the array.
 *
 * @callback geomReduceCallback
 * @param {*} previousValue The accumulated value previously returned in the last invocation
 * of the callback, or initialValue, if supplied.
 * @param {Geometry} currentGeometry The current Geometry being processed.
 * @param {number} featureIndex The current index of the Feature being processed.
 * @param {Object} featureProperties The current Feature Properties being processed.
 * @param {Array<number>} featureBBox The current Feature BBox being processed.
 * @param {number|string} featureId The current Feature Id being processed.
 */

/**
 * Reduce geometry in any GeoJSON object, similar to Array.reduce().
 *
 * @name geomReduce
 * @param {FeatureCollection|Feature|Geometry} geojson any GeoJSON object
 * @param {Function} callback a method that takes (previousValue, currentGeometry, featureIndex, featureProperties, featureBBox, featureId)
 * @param {*} [initialValue] Value to use as the first argument to the first call of the callback.
 * @returns {*} The value that results from the reduction.
 * @example
 * var features = turf.featureCollection([
 *     turf.point([26, 37], {foo: 'bar'}),
 *     turf.point([36, 53], {hello: 'world'})
 * ]);
 *
 * turf.geomReduce(features, function (previousValue, currentGeometry, featureIndex, featureProperties, featureBBox, featureId) {
 *   //=previousValue
 *   //=currentGeometry
 *   //=featureIndex
 *   //=featureProperties
 *   //=featureBBox
 *   //=featureId
 *   return currentGeometry
 * });
 */
function geomReduce(geojson, callback, initialValue) {
    var previousValue = initialValue;
    geomEach(geojson, function (currentGeometry, featureIndex, featureProperties, featureBBox, featureId) {
        if (featureIndex === 0 && initialValue === undefined) previousValue = currentGeometry;
        else previousValue = callback(previousValue, currentGeometry, featureIndex, featureProperties, featureBBox, featureId);
    });
    return previousValue;
}

/**
 * Callback for flattenEach
 *
 * @callback flattenEachCallback
 * @param {Feature} currentFeature The current flattened feature being processed.
 * @param {number} featureIndex The current index of the Feature being processed.
 * @param {number} multiFeatureIndex The current index of the Multi-Feature being processed.
 */

/**
 * Iterate over flattened features in any GeoJSON object, similar to
 * Array.forEach.
 *
 * @name flattenEach
 * @param {FeatureCollection|Feature|Geometry} geojson any GeoJSON object
 * @param {Function} callback a method that takes (currentFeature, featureIndex, multiFeatureIndex)
 * @example
 * var features = turf.featureCollection([
 *     turf.point([26, 37], {foo: 'bar'}),
 *     turf.multiPoint([[40, 30], [36, 53]], {hello: 'world'})
 * ]);
 *
 * turf.flattenEach(features, function (currentFeature, featureIndex, multiFeatureIndex) {
 *   //=currentFeature
 *   //=featureIndex
 *   //=multiFeatureIndex
 * });
 */
function flattenEach(geojson, callback) {
    geomEach(geojson, function (geometry, featureIndex, properties, bbox, id) {
        // Callback for single geometry
        var type = (geometry === null) ? null : geometry.type;
        switch (type) {
        case null:
        case 'Point':
        case 'LineString':
        case 'Polygon':
            if (callback(helpers.feature(geometry, properties, {bbox: bbox, id: id}), featureIndex, 0) === false) return false;
            return;
        }

        var geomType;

        // Callback for multi-geometry
        switch (type) {
        case 'MultiPoint':
            geomType = 'Point';
            break;
        case 'MultiLineString':
            geomType = 'LineString';
            break;
        case 'MultiPolygon':
            geomType = 'Polygon';
            break;
        }

        for (var multiFeatureIndex = 0; multiFeatureIndex < geometry.coordinates.length; multiFeatureIndex++) {
            var coordinate = geometry.coordinates[multiFeatureIndex];
            var geom = {
                type: geomType,
                coordinates: coordinate
            };
            if (callback(helpers.feature(geom, properties), featureIndex, multiFeatureIndex) === false) return false;
        }
    });
}

/**
 * Callback for flattenReduce
 *
 * The first time the callback function is called, the values provided as arguments depend
 * on whether the reduce method has an initialValue argument.
 *
 * If an initialValue is provided to the reduce method:
 *  - The previousValue argument is initialValue.
 *  - The currentValue argument is the value of the first element present in the array.
 *
 * If an initialValue is not provided:
 *  - The previousValue argument is the value of the first element present in the array.
 *  - The currentValue argument is the value of the second element present in the array.
 *
 * @callback flattenReduceCallback
 * @param {*} previousValue The accumulated value previously returned in the last invocation
 * of the callback, or initialValue, if supplied.
 * @param {Feature} currentFeature The current Feature being processed.
 * @param {number} featureIndex The current index of the Feature being processed.
 * @param {number} multiFeatureIndex The current index of the Multi-Feature being processed.
 */

/**
 * Reduce flattened features in any GeoJSON object, similar to Array.reduce().
 *
 * @name flattenReduce
 * @param {FeatureCollection|Feature|Geometry} geojson any GeoJSON object
 * @param {Function} callback a method that takes (previousValue, currentFeature, featureIndex, multiFeatureIndex)
 * @param {*} [initialValue] Value to use as the first argument to the first call of the callback.
 * @returns {*} The value that results from the reduction.
 * @example
 * var features = turf.featureCollection([
 *     turf.point([26, 37], {foo: 'bar'}),
 *     turf.multiPoint([[40, 30], [36, 53]], {hello: 'world'})
 * ]);
 *
 * turf.flattenReduce(features, function (previousValue, currentFeature, featureIndex, multiFeatureIndex) {
 *   //=previousValue
 *   //=currentFeature
 *   //=featureIndex
 *   //=multiFeatureIndex
 *   return currentFeature
 * });
 */
function flattenReduce(geojson, callback, initialValue) {
    var previousValue = initialValue;
    flattenEach(geojson, function (currentFeature, featureIndex, multiFeatureIndex) {
        if (featureIndex === 0 && multiFeatureIndex === 0 && initialValue === undefined) previousValue = currentFeature;
        else previousValue = callback(previousValue, currentFeature, featureIndex, multiFeatureIndex);
    });
    return previousValue;
}

/**
 * Callback for segmentEach
 *
 * @callback segmentEachCallback
 * @param {Feature<LineString>} currentSegment The current Segment being processed.
 * @param {number} featureIndex The current index of the Feature being processed.
 * @param {number} multiFeatureIndex The current index of the Multi-Feature being processed.
 * @param {number} geometryIndex The current index of the Geometry being processed.
 * @param {number} segmentIndex The current index of the Segment being processed.
 * @returns {void}
 */

/**
 * Iterate over 2-vertex line segment in any GeoJSON object, similar to Array.forEach()
 * (Multi)Point geometries do not contain segments therefore they are ignored during this operation.
 *
 * @param {FeatureCollection|Feature|Geometry} geojson any GeoJSON
 * @param {Function} callback a method that takes (currentSegment, featureIndex, multiFeatureIndex, geometryIndex, segmentIndex)
 * @returns {void}
 * @example
 * var polygon = turf.polygon([[[-50, 5], [-40, -10], [-50, -10], [-40, 5], [-50, 5]]]);
 *
 * // Iterate over GeoJSON by 2-vertex segments
 * turf.segmentEach(polygon, function (currentSegment, featureIndex, multiFeatureIndex, geometryIndex, segmentIndex) {
 *   //=currentSegment
 *   //=featureIndex
 *   //=multiFeatureIndex
 *   //=geometryIndex
 *   //=segmentIndex
 * });
 *
 * // Calculate the total number of segments
 * var total = 0;
 * turf.segmentEach(polygon, function () {
 *     total++;
 * });
 */
function segmentEach(geojson, callback) {
    flattenEach(geojson, function (feature, featureIndex, multiFeatureIndex) {
        var segmentIndex = 0;

        // Exclude null Geometries
        if (!feature.geometry) return;
        // (Multi)Point geometries do not contain segments therefore they are ignored during this operation.
        var type = feature.geometry.type;
        if (type === 'Point' || type === 'MultiPoint') return;

        // Generate 2-vertex line segments
        var previousCoords;
        var previousFeatureIndex = 0;
        var previousMultiIndex = 0;
        var prevGeomIndex = 0;
        if (coordEach(feature, function (currentCoord, coordIndex, featureIndexCoord, multiPartIndexCoord, geometryIndex) {
            // Simulating a meta.coordReduce() since `reduce` operations cannot be stopped by returning `false`
            if (previousCoords === undefined || featureIndex > previousFeatureIndex || multiPartIndexCoord > previousMultiIndex || geometryIndex > prevGeomIndex) {
                previousCoords = currentCoord;
                previousFeatureIndex = featureIndex;
                previousMultiIndex = multiPartIndexCoord;
                prevGeomIndex = geometryIndex;
                segmentIndex = 0;
                return;
            }
            var currentSegment = helpers.lineString([previousCoords, currentCoord], feature.properties);
            if (callback(currentSegment, featureIndex, multiFeatureIndex, geometryIndex, segmentIndex) === false) return false;
            segmentIndex++;
            previousCoords = currentCoord;
        }) === false) return false;
    });
}

/**
 * Callback for segmentReduce
 *
 * The first time the callback function is called, the values provided as arguments depend
 * on whether the reduce method has an initialValue argument.
 *
 * If an initialValue is provided to the reduce method:
 *  - The previousValue argument is initialValue.
 *  - The currentValue argument is the value of the first element present in the array.
 *
 * If an initialValue is not provided:
 *  - The previousValue argument is the value of the first element present in the array.
 *  - The currentValue argument is the value of the second element present in the array.
 *
 * @callback segmentReduceCallback
 * @param {*} previousValue The accumulated value previously returned in the last invocation
 * of the callback, or initialValue, if supplied.
 * @param {Feature<LineString>} currentSegment The current Segment being processed.
 * @param {number} featureIndex The current index of the Feature being processed.
 * @param {number} multiFeatureIndex The current index of the Multi-Feature being processed.
 * @param {number} geometryIndex The current index of the Geometry being processed.
 * @param {number} segmentIndex The current index of the Segment being processed.
 */

/**
 * Reduce 2-vertex line segment in any GeoJSON object, similar to Array.reduce()
 * (Multi)Point geometries do not contain segments therefore they are ignored during this operation.
 *
 * @param {FeatureCollection|Feature|Geometry} geojson any GeoJSON
 * @param {Function} callback a method that takes (previousValue, currentSegment, currentIndex)
 * @param {*} [initialValue] Value to use as the first argument to the first call of the callback.
 * @returns {void}
 * @example
 * var polygon = turf.polygon([[[-50, 5], [-40, -10], [-50, -10], [-40, 5], [-50, 5]]]);
 *
 * // Iterate over GeoJSON by 2-vertex segments
 * turf.segmentReduce(polygon, function (previousSegment, currentSegment, featureIndex, multiFeatureIndex, geometryIndex, segmentIndex) {
 *   //= previousSegment
 *   //= currentSegment
 *   //= featureIndex
 *   //= multiFeatureIndex
 *   //= geometryIndex
 *   //= segmentInex
 *   return currentSegment
 * });
 *
 * // Calculate the total number of segments
 * var initialValue = 0
 * var total = turf.segmentReduce(polygon, function (previousValue) {
 *     previousValue++;
 *     return previousValue;
 * }, initialValue);
 */
function segmentReduce(geojson, callback, initialValue) {
    var previousValue = initialValue;
    var started = false;
    segmentEach(geojson, function (currentSegment, featureIndex, multiFeatureIndex, geometryIndex, segmentIndex) {
        if (started === false && initialValue === undefined) previousValue = currentSegment;
        else previousValue = callback(previousValue, currentSegment, featureIndex, multiFeatureIndex, geometryIndex, segmentIndex);
        started = true;
    });
    return previousValue;
}

/**
 * Callback for lineEach
 *
 * @callback lineEachCallback
 * @param {Feature<LineString>} currentLine The current LineString|LinearRing being processed
 * @param {number} featureIndex The current index of the Feature being processed
 * @param {number} multiFeatureIndex The current index of the Multi-Feature being processed
 * @param {number} geometryIndex The current index of the Geometry being processed
 */

/**
 * Iterate over line or ring coordinates in LineString, Polygon, MultiLineString, MultiPolygon Features or Geometries,
 * similar to Array.forEach.
 *
 * @name lineEach
 * @param {Geometry|Feature<LineString|Polygon|MultiLineString|MultiPolygon>} geojson object
 * @param {Function} callback a method that takes (currentLine, featureIndex, multiFeatureIndex, geometryIndex)
 * @example
 * var multiLine = turf.multiLineString([
 *   [[26, 37], [35, 45]],
 *   [[36, 53], [38, 50], [41, 55]]
 * ]);
 *
 * turf.lineEach(multiLine, function (currentLine, featureIndex, multiFeatureIndex, geometryIndex) {
 *   //=currentLine
 *   //=featureIndex
 *   //=multiFeatureIndex
 *   //=geometryIndex
 * });
 */
function lineEach(geojson, callback) {
    // validation
    if (!geojson) throw new Error('geojson is required');

    flattenEach(geojson, function (feature, featureIndex, multiFeatureIndex) {
        if (feature.geometry === null) return;
        var type = feature.geometry.type;
        var coords = feature.geometry.coordinates;
        switch (type) {
        case 'LineString':
            if (callback(feature, featureIndex, multiFeatureIndex, 0, 0) === false) return false;
            break;
        case 'Polygon':
            for (var geometryIndex = 0; geometryIndex < coords.length; geometryIndex++) {
                if (callback(helpers.lineString(coords[geometryIndex], feature.properties), featureIndex, multiFeatureIndex, geometryIndex) === false) return false;
            }
            break;
        }
    });
}

/**
 * Callback for lineReduce
 *
 * The first time the callback function is called, the values provided as arguments depend
 * on whether the reduce method has an initialValue argument.
 *
 * If an initialValue is provided to the reduce method:
 *  - The previousValue argument is initialValue.
 *  - The currentValue argument is the value of the first element present in the array.
 *
 * If an initialValue is not provided:
 *  - The previousValue argument is the value of the first element present in the array.
 *  - The currentValue argument is the value of the second element present in the array.
 *
 * @callback lineReduceCallback
 * @param {*} previousValue The accumulated value previously returned in the last invocation
 * of the callback, or initialValue, if supplied.
 * @param {Feature<LineString>} currentLine The current LineString|LinearRing being processed.
 * @param {number} featureIndex The current index of the Feature being processed
 * @param {number} multiFeatureIndex The current index of the Multi-Feature being processed
 * @param {number} geometryIndex The current index of the Geometry being processed
 */

/**
 * Reduce features in any GeoJSON object, similar to Array.reduce().
 *
 * @name lineReduce
 * @param {Geometry|Feature<LineString|Polygon|MultiLineString|MultiPolygon>} geojson object
 * @param {Function} callback a method that takes (previousValue, currentLine, featureIndex, multiFeatureIndex, geometryIndex)
 * @param {*} [initialValue] Value to use as the first argument to the first call of the callback.
 * @returns {*} The value that results from the reduction.
 * @example
 * var multiPoly = turf.multiPolygon([
 *   turf.polygon([[[12,48],[2,41],[24,38],[12,48]], [[9,44],[13,41],[13,45],[9,44]]]),
 *   turf.polygon([[[5, 5], [0, 0], [2, 2], [4, 4], [5, 5]]])
 * ]);
 *
 * turf.lineReduce(multiPoly, function (previousValue, currentLine, featureIndex, multiFeatureIndex, geometryIndex) {
 *   //=previousValue
 *   //=currentLine
 *   //=featureIndex
 *   //=multiFeatureIndex
 *   //=geometryIndex
 *   return currentLine
 * });
 */
function lineReduce(geojson, callback, initialValue) {
    var previousValue = initialValue;
    lineEach(geojson, function (currentLine, featureIndex, multiFeatureIndex, geometryIndex) {
        if (featureIndex === 0 && initialValue === undefined) previousValue = currentLine;
        else previousValue = callback(previousValue, currentLine, featureIndex, multiFeatureIndex, geometryIndex);
    });
    return previousValue;
}

/**
 * Finds a particular 2-vertex LineString Segment from a GeoJSON using `@turf/meta` indexes.
 *
 * Negative indexes are permitted.
 * Point & MultiPoint will always return null.
 *
 * @param {FeatureCollection|Feature|Geometry} geojson Any GeoJSON Feature or Geometry
 * @param {Object} [options={}] Optional parameters
 * @param {number} [options.featureIndex=0] Feature Index
 * @param {number} [options.multiFeatureIndex=0] Multi-Feature Index
 * @param {number} [options.geometryIndex=0] Geometry Index
 * @param {number} [options.segmentIndex=0] Segment Index
 * @param {Object} [options.properties={}] Translate Properties to output LineString
 * @param {BBox} [options.bbox={}] Translate BBox to output LineString
 * @param {number|string} [options.id={}] Translate Id to output LineString
 * @returns {Feature<LineString>} 2-vertex GeoJSON Feature LineString
 * @example
 * var multiLine = turf.multiLineString([
 *     [[10, 10], [50, 30], [30, 40]],
 *     [[-10, -10], [-50, -30], [-30, -40]]
 * ]);
 *
 * // First Segment (defaults are 0)
 * turf.findSegment(multiLine);
 * // => Feature<LineString<[[10, 10], [50, 30]]>>
 *
 * // First Segment of 2nd Multi Feature
 * turf.findSegment(multiLine, {multiFeatureIndex: 1});
 * // => Feature<LineString<[[-10, -10], [-50, -30]]>>
 *
 * // Last Segment of Last Multi Feature
 * turf.findSegment(multiLine, {multiFeatureIndex: -1, segmentIndex: -1});
 * // => Feature<LineString<[[-50, -30], [-30, -40]]>>
 */
function findSegment(geojson, options) {
    // Optional Parameters
    options = options || {};
    if (!helpers.isObject(options)) throw new Error('options is invalid');
    var featureIndex = options.featureIndex || 0;
    var multiFeatureIndex = options.multiFeatureIndex || 0;
    var geometryIndex = options.geometryIndex || 0;
    var segmentIndex = options.segmentIndex || 0;

    // Find FeatureIndex
    var properties = options.properties;
    var geometry;

    switch (geojson.type) {
    case 'FeatureCollection':
        if (featureIndex < 0) featureIndex = geojson.features.length + featureIndex;
        properties = properties || geojson.features[featureIndex].properties;
        geometry = geojson.features[featureIndex].geometry;
        break;
    case 'Feature':
        properties = properties || geojson.properties;
        geometry = geojson.geometry;
        break;
    case 'Point':
    case 'MultiPoint':
        return null;
    case 'LineString':
    case 'Polygon':
    case 'MultiLineString':
    case 'MultiPolygon':
        geometry = geojson;
        break;
    default:
        throw new Error('geojson is invalid');
    }

    // Find SegmentIndex
    if (geometry === null) return null;
    var coords = geometry.coordinates;
    switch (geometry.type) {
    case 'Point':
    case 'MultiPoint':
        return null;
    case 'LineString':
        if (segmentIndex < 0) segmentIndex = coords.length + segmentIndex - 1;
        return helpers.lineString([coords[segmentIndex], coords[segmentIndex + 1]], properties, options);
    case 'Polygon':
        if (geometryIndex < 0) geometryIndex = coords.length + geometryIndex;
        if (segmentIndex < 0) segmentIndex = coords[geometryIndex].length + segmentIndex - 1;
        return helpers.lineString([coords[geometryIndex][segmentIndex], coords[geometryIndex][segmentIndex + 1]], properties, options);
    case 'MultiLineString':
        if (multiFeatureIndex < 0) multiFeatureIndex = coords.length + multiFeatureIndex;
        if (segmentIndex < 0) segmentIndex = coords[multiFeatureIndex].length + segmentIndex - 1;
        return helpers.lineString([coords[multiFeatureIndex][segmentIndex], coords[multiFeatureIndex][segmentIndex + 1]], properties, options);
    case 'MultiPolygon':
        if (multiFeatureIndex < 0) multiFeatureIndex = coords.length + multiFeatureIndex;
        if (geometryIndex < 0) geometryIndex = coords[multiFeatureIndex].length + geometryIndex;
        if (segmentIndex < 0) segmentIndex = coords[multiFeatureIndex][geometryIndex].length - segmentIndex - 1;
        return helpers.lineString([coords[multiFeatureIndex][geometryIndex][segmentIndex], coords[multiFeatureIndex][geometryIndex][segmentIndex + 1]], properties, options);
    }
    throw new Error('geojson is invalid');
}

/**
 * Finds a particular Point from a GeoJSON using `@turf/meta` indexes.
 *
 * Negative indexes are permitted.
 *
 * @param {FeatureCollection|Feature|Geometry} geojson Any GeoJSON Feature or Geometry
 * @param {Object} [options={}] Optional parameters
 * @param {number} [options.featureIndex=0] Feature Index
 * @param {number} [options.multiFeatureIndex=0] Multi-Feature Index
 * @param {number} [options.geometryIndex=0] Geometry Index
 * @param {number} [options.coordIndex=0] Coord Index
 * @param {Object} [options.properties={}] Translate Properties to output Point
 * @param {BBox} [options.bbox={}] Translate BBox to output Point
 * @param {number|string} [options.id={}] Translate Id to output Point
 * @returns {Feature<Point>} 2-vertex GeoJSON Feature Point
 * @example
 * var multiLine = turf.multiLineString([
 *     [[10, 10], [50, 30], [30, 40]],
 *     [[-10, -10], [-50, -30], [-30, -40]]
 * ]);
 *
 * // First Segment (defaults are 0)
 * turf.findPoint(multiLine);
 * // => Feature<Point<[10, 10]>>
 *
 * // First Segment of the 2nd Multi-Feature
 * turf.findPoint(multiLine, {multiFeatureIndex: 1});
 * // => Feature<Point<[-10, -10]>>
 *
 * // Last Segment of last Multi-Feature
 * turf.findPoint(multiLine, {multiFeatureIndex: -1, coordIndex: -1});
 * // => Feature<Point<[-30, -40]>>
 */
function findPoint(geojson, options) {
    // Optional Parameters
    options = options || {};
    if (!helpers.isObject(options)) throw new Error('options is invalid');
    var featureIndex = options.featureIndex || 0;
    var multiFeatureIndex = options.multiFeatureIndex || 0;
    var geometryIndex = options.geometryIndex || 0;
    var coordIndex = options.coordIndex || 0;

    // Find FeatureIndex
    var properties = options.properties;
    var geometry;

    switch (geojson.type) {
    case 'FeatureCollection':
        if (featureIndex < 0) featureIndex = geojson.features.length + featureIndex;
        properties = properties || geojson.features[featureIndex].properties;
        geometry = geojson.features[featureIndex].geometry;
        break;
    case 'Feature':
        properties = properties || geojson.properties;
        geometry = geojson.geometry;
        break;
    case 'Point':
    case 'MultiPoint':
        return null;
    case 'LineString':
    case 'Polygon':
    case 'MultiLineString':
    case 'MultiPolygon':
        geometry = geojson;
        break;
    default:
        throw new Error('geojson is invalid');
    }

    // Find Coord Index
    if (geometry === null) return null;
    var coords = geometry.coordinates;
    switch (geometry.type) {
    case 'Point':
        return helpers.point(coords, properties, options);
    case 'MultiPoint':
        if (multiFeatureIndex < 0) multiFeatureIndex = coords.length + multiFeatureIndex;
        return helpers.point(coords[multiFeatureIndex], properties, options);
    case 'LineString':
        if (coordIndex < 0) coordIndex = coords.length + coordIndex;
        return helpers.point(coords[coordIndex], properties, options);
    case 'Polygon':
        if (geometryIndex < 0) geometryIndex = coords.length + geometryIndex;
        if (coordIndex < 0) coordIndex = coords[geometryIndex].length + coordIndex;
        return helpers.point(coords[geometryIndex][coordIndex], properties, options);
    case 'MultiLineString':
        if (multiFeatureIndex < 0) multiFeatureIndex = coords.length + multiFeatureIndex;
        if (coordIndex < 0) coordIndex = coords[multiFeatureIndex].length + coordIndex;
        return helpers.point(coords[multiFeatureIndex][coordIndex], properties, options);
    case 'MultiPolygon':
        if (multiFeatureIndex < 0) multiFeatureIndex = coords.length + multiFeatureIndex;
        if (geometryIndex < 0) geometryIndex = coords[multiFeatureIndex].length + geometryIndex;
        if (coordIndex < 0) coordIndex = coords[multiFeatureIndex][geometryIndex].length - coordIndex;
        return helpers.point(coords[multiFeatureIndex][geometryIndex][coordIndex], properties, options);
    }
    throw new Error('geojson is invalid');
}

exports.coordEach = coordEach;
exports.coordReduce = coordReduce;
exports.propEach = propEach;
exports.propReduce = propReduce;
exports.featureEach = featureEach;
exports.featureReduce = featureReduce;
exports.coordAll = coordAll;
exports.geomEach = geomEach;
exports.geomReduce = geomReduce;
exports.flattenEach = flattenEach;
exports.flattenReduce = flattenReduce;
exports.segmentEach = segmentEach;
exports.segmentReduce = segmentReduce;
exports.lineEach = lineEach;
exports.lineReduce = lineReduce;
exports.findSegment = findSegment;
exports.findPoint = findPoint;


/***/ }),

/***/ "dKZ/":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";

// CONCATENATED MODULE: ./node_modules/vue-loader/lib/loaders/templateLoader.js??vue-loader-options!./node_modules/vue-loader/lib??vue-loader-options!./src/leaflet/identify/Identify.vue?vue&type=template&id=a1e2c0ac&
var render = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('ul',{directives:[{name:"show",rawName:"v-show",value:(false),expression:"false"}],ref:"Popup",class:['sm-component-identify'],style:([_vm.getTextColorStyle])},_vm._l((_vm.popupProps),function(value,key,index){return _c('li',{key:index,staticClass:"sm-component-identify__body"},[_c('div',{staticClass:"sm-component-identify__left",attrs:{"title":key}},[_vm._v(_vm._s(key))]),_vm._v(" "),_c('div',{staticClass:"sm-component-identify__right",attrs:{"title":value}},[_vm._v(_vm._s(value))])])}),0)}
var staticRenderFns = []


// CONCATENATED MODULE: ./src/leaflet/identify/Identify.vue?vue&type=template&id=a1e2c0ac&
/* concated harmony reexport render */__webpack_require__.d(__webpack_exports__, "a", function() { return render; });
/* concated harmony reexport staticRenderFns */__webpack_require__.d(__webpack_exports__, "b", function() { return staticRenderFns; });


/***/ }),

/***/ "dXCY":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__("TqRt");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _theme = _interopRequireDefault(__webpack_require__("bCOg"));

var _util = __webpack_require__("e7LN");

//
//
//
//
//
//
//
//
//
//
//
//
var _default2 = {
  name: 'SmTablePopup',
  mixins: [_theme.default],
  props: {
    data: {
      type: Array,
      default: function _default() {
        return [];
      }
    },
    columns: {
      type: Array,
      default: function _default() {
        return [];
      }
    }
  },
  computed: {
    styleObject: function styleObject() {
      return {
        '--table-popup-active-color--text': this.colorGroupsData[0]
      };
    },
    backgroundStyle: function backgroundStyle() {
      return {
        background: this.backgroundData ? (0, _util.getColorWithOpacity)(this.backgroundData, 0.5) : this.backgroundData
      };
    }
  }
};
exports.default = _default2;

/***/ }),

/***/ "dZA3":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_babel_loader_lib_index_js_node_modules_ts_loader_index_js_ref_1_1_node_modules_vue_loader_lib_index_js_vue_loader_options_WebMap_vue_vue_type_script_lang_ts___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("hB31");
/* harmony import */ var _node_modules_babel_loader_lib_index_js_node_modules_ts_loader_index_js_ref_1_1_node_modules_vue_loader_lib_index_js_vue_loader_options_WebMap_vue_vue_type_script_lang_ts___WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_babel_loader_lib_index_js_node_modules_ts_loader_index_js_ref_1_1_node_modules_vue_loader_lib_index_js_vue_loader_options_WebMap_vue_vue_type_script_lang_ts___WEBPACK_IMPORTED_MODULE_0__);
/* harmony reexport (unknown) */ for(var __WEBPACK_IMPORT_KEY__ in _node_modules_babel_loader_lib_index_js_node_modules_ts_loader_index_js_ref_1_1_node_modules_vue_loader_lib_index_js_vue_loader_options_WebMap_vue_vue_type_script_lang_ts___WEBPACK_IMPORTED_MODULE_0__) if(__WEBPACK_IMPORT_KEY__ !== 'default') (function(key) { __webpack_require__.d(__webpack_exports__, key, function() { return _node_modules_babel_loader_lib_index_js_node_modules_ts_loader_index_js_ref_1_1_node_modules_vue_loader_lib_index_js_vue_loader_options_WebMap_vue_vue_type_script_lang_ts___WEBPACK_IMPORTED_MODULE_0__[key]; }) }(__WEBPACK_IMPORT_KEY__));
 /* harmony default export */ __webpack_exports__["default"] = (_node_modules_babel_loader_lib_index_js_node_modules_ts_loader_index_js_ref_1_1_node_modules_vue_loader_lib_index_js_vue_loader_options_WebMap_vue_vue_type_script_lang_ts___WEBPACK_IMPORTED_MODULE_0___default.a); 

/***/ }),

/***/ "drpF":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__("TqRt");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _classCallCheck2 = _interopRequireDefault(__webpack_require__("lwsE"));

var _createClass2 = _interopRequireDefault(__webpack_require__("W8MJ"));

var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__("a1gu"));

var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__("Nsbk"));

var _inherits2 = _interopRequireDefault(__webpack_require__("7W2i"));

var _leafletWrapper = _interopRequireDefault(__webpack_require__("uTlj"));

var ChartViewModel =
/*#__PURE__*/
function (_L$Evented) {
  (0, _inherits2.default)(ChartViewModel, _L$Evented);

  function ChartViewModel(map, options) {
    var _this;

    (0, _classCallCheck2.default)(this, ChartViewModel);
    _this = (0, _possibleConstructorReturn2.default)(this, (0, _getPrototypeOf2.default)(ChartViewModel).call(this, null));
    _this.map = map;
    _this.options = options;
    return _this;
  }

  (0, _createClass2.default)(ChartViewModel, [{
    key: "setPopupContent",
    value: function setPopupContent(coordinates, popupContainer, callback) {
      this.clear();

      var fromatCoordinates = _leafletWrapper.default.GeoJSON.coordsToLatLng(coordinates);

      popupContainer.style.display = 'block';
      this.popup = new _leafletWrapper.default.Popup({
        className: 'sm-leaflet-tabel-popup sm-component-chart-result-popup',
        closeOnClick: true,
        maxWidth: 800
      });
      this.marker = new _leafletWrapper.default.Marker();
      this.popup.setLatLng(fromatCoordinates).setContent(popupContainer);
      this.map.on('popupopen', function () {
        callback && callback();
      });
      this.marker.setLatLng(fromatCoordinates).bindPopup(this.popup).addTo(this.map);
      this.map.flyTo(fromatCoordinates);
    }
  }, {
    key: "clear",
    value: function clear() {
      if (this.popup) {
        this.popup.remove();
        this.popup = null;
      }

      if (this.marker) {
        this.marker.remove();
        this.marker = null;
      }

      if (this.map) {
        this.map.off('popupopen', function () {});
      }
    }
  }]);
  return ChartViewModel;
}(_leafletWrapper.default.Evented);

exports.default = ChartViewModel;

/***/ }),

/***/ "e/Qi":
/***/ (function(module, exports, __webpack_require__) {

/**
* geostats() is a tiny and standalone javascript library for classification 
* Project page - https://github.com/simogeo/geostats
* Copyright (c) 2011 Simon Georget, http://www.empreinte-urbaine.eu
* Licensed under the MIT license
*/


(function (definition) {
    // This file will function properly as a <script> tag, or a module
    // using CommonJS and NodeJS or RequireJS module formats.

    // CommonJS
    if (true) {
        module.exports = definition();

    // RequireJS
    } else {}

})(function () {

var isInt = function(n) {
   return typeof n === 'number' && parseFloat(n) == parseInt(n, 10) && !isNaN(n);
} // 6 characters

var _t = function(str) {
	return str;
};

//taking from http://stackoverflow.com/questions/18082/validate-decimal-numbers-in-javascript-isnumeric
var isNumber = function(n) {
	  return !isNaN(parseFloat(n)) && isFinite(n);
}



//indexOf polyfill
// from https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/indexOf
if (!Array.prototype.indexOf) {
    Array.prototype.indexOf = function (searchElement, fromIndex) {
      if ( this === undefined || this === null ) {
        throw new TypeError( '"this" is null or not defined' );
      }

      var length = this.length >>> 0; // Hack to convert object.length to a UInt32

      fromIndex = +fromIndex || 0;

      if (Math.abs(fromIndex) === Infinity) {
        fromIndex = 0;
      }

      if (fromIndex < 0) {
        fromIndex += length;
        if (fromIndex < 0) {
          fromIndex = 0;
        }
      }

      for (;fromIndex < length; fromIndex++) {
        if (this[fromIndex] === searchElement) {
          return fromIndex;
        }
      }

      return -1;
    };
  }

var geostats = function(a) {

	this.objectID = '';
	this.separator = ' - ';
	this.legendSeparator = this.separator;
	this.method  = '';
	this.precision = 0;
	this.precisionflag = 'auto';
	this.roundlength 	= 2; // Number of decimals, round values
	this.is_uniqueValues = false;
	this.debug =  false;
	this.silent = false;
	
	this.bounds  = Array();
	this.ranges  = Array();
	this.inner_ranges  = null;
	this.colors  = Array();
	this.counter = Array();
	
	// statistics information
	this.stat_sorted	= null;
	this.stat_mean 		= null;
	this.stat_median 	= null;
	this.stat_sum 		= null;
	this.stat_max 		= null;
	this.stat_min 		= null;
	this.stat_pop 		= null;
	this.stat_variance	= null;
	this.stat_stddev	= null;
	this.stat_cov		= null;

	
	/**
	 * logging method
	 */
	this.log = function(msg, force) {
	
		if(this.debug == true || force != null)
			console.log(this.objectID + "(object id) :: " + msg);
		
	};
	
	/**
	 * Set bounds
	 */
	this.setBounds = function(a) {
		
		this.log('Setting bounds (' + a.length + ') : ' + a.join());
	
		this.bounds = Array() // init empty array to prevent bug when calling classification after another with less items (sample getQuantile(6) and getQuantile(4))
		
		this.bounds = a;
		//this.bounds = this.decimalFormat(a);
		
	};
	
	/**
	 * Set a new serie
	 */
	this.setSerie = function(a) {
		
		this.log('Setting serie (' + a.length + ') : ' + a.join());
	
		this.serie = Array() // init empty array to prevent bug when calling classification after another with less items (sample getQuantile(6) and getQuantile(4))
		this.serie = a;
		
		//reset statistics after changing serie
	    this.resetStatistics();
	    
		this.setPrecision();
		
	};
	
	/**
	 * Set colors
	 */
	this.setColors = function(colors) {
		
		this.log('Setting color ramp (' + colors.length + ') : '  + colors.join());
		
		this.colors = colors;
		
	};
	
	/**
	 * Get feature count
	 * With bounds array(0, 0.75, 1.5, 2.25, 3); 
	 * should populate this.counter with 5 keys
	 * and increment counters for each key
	 */
	this.doCount = function() {

		if (this._nodata())
			return;
		

		var tmp = this.sorted();
		
		this.counter = new Array();
		
		// we init counter with 0 value
		for(i = 0; i < this.bounds.length -1; i++) {
			this.counter[i]= 0;
		}
		
		for(j=0; j < tmp.length; j++) {
			
			// get current class for value to increment the counter
			var cclass = this.getClass(tmp[j]);
			this.counter[cclass]++;

		}

	};
	
	/**
	 * Set decimal precision according to user input
	 * or automatcally determined according
	 * to the given serie.
	 */
	this.setPrecision = function(decimals) {
		
		// only when called from user
		if(typeof decimals !== "undefined") {
			this.precisionflag = 'manual';
			this.precision = decimals;
		}
		
		// we calculate the maximal decimal length on given serie
		if(this.precisionflag == 'auto') {
			
			for (var i = 0; i < this.serie.length; i++) {
				
				// check if the given value is a number and a float
				if (!isNaN((this.serie[i]+"")) && (this.serie[i]+"").toString().indexOf('.') != -1) {
					var precision = (this.serie[i] + "").split(".")[1].length;
				} else {
					var precision = 0;
				}
				
				if(precision > this.precision) {
					this.precision = precision;
				}
				
			}
			
		}
		if(this.precision > 20) {
			// prevent "Uncaught RangeError: toFixed() digits argument must be between 0 and 20" bug. See https://github.com/simogeo/geostats/issues/34
			this.log('this.precision value (' + this.precision + ') is greater than max value. Automatic set-up to 20 to prevent "Uncaught RangeError: toFixed()" when calling decimalFormat() method.');
			this.precision = 20;
		}

		this.log('Calling setPrecision(). Mode : ' + this.precisionflag + ' - Decimals : '+ this.precision);
		
		this.serie = this.decimalFormat(this.serie);
		
	};
	
	/**
	 * Format array numbers regarding to precision
	 */
	this.decimalFormat = function(a) {
		
		var b = new Array();
		
		for (var i = 0; i < a.length; i++) {
			// check if the given value is a number
			if (isNumber(a[i])) {
				b[i] = parseFloat(parseFloat(a[i]).toFixed(this.precision));
			} else {
				b[i] = a[i];
			}
		}
		
		return b;
	}
	
	/**
	 * Transform a bounds array to a range array the following array : array(0,
	 * 0.75, 1.5, 2.25, 3); becomes : array('0-0.75', '0.75-1.5', '1.5-2.25',
	 * '2.25-3');
	 */
	this.setRanges = function() {
	
		this.ranges = Array(); // init empty array to prevent bug when calling classification after another with less items (sample getQuantile(6) and getQuantile(4))
		
		for (i = 0; i < (this.bounds.length - 1); i++) {
			this.ranges[i] = this.bounds[i] + this.separator + this.bounds[i + 1];
		}
	};

	/** return min value */
	this.min = function() {
		
		if (this._nodata())
			return;
		
		this.stat_min = this.serie[0];
		
		for (i = 0; i < this.pop(); i++) {
			if (this.serie[i] < this.stat_min) {
				this.stat_min = this.serie[i];
			}
		}

		return this.stat_min;
	};

	/** return max value */
	this.max = function() {
		
		if (this._nodata())
			return;
		
		this.stat_max = this.serie[0];
		for (i = 0; i < this.pop(); i++) {
			if (this.serie[i] > this.stat_max) {
				this.stat_max = this.serie[i];
			}
		}
		
		return this.stat_max;
	};

	/** return sum value */
	this.sum = function() {
		
		if (this._nodata())
			return;
		
		if (this.stat_sum  == null) {
			
			this.stat_sum = 0;
			for (i = 0; i < this.pop(); i++) {
				this.stat_sum += parseFloat(this.serie[i]);
			}
			
		}
		
		return this.stat_sum;
	};

	/** return population number */
	this.pop = function() {
		
		if (this._nodata())
			return;
		
		if (this.stat_pop  == null) {
			
			this.stat_pop = this.serie.length;
			
		}
		
		return this.stat_pop;
	};

	/** return mean value */
	this.mean = function() {
		
		if (this._nodata())
			return;

		if (this.stat_mean  == null) {
			
			this.stat_mean = parseFloat(this.sum() / this.pop());
			
		}
		
		return this.stat_mean;
	};

	/** return median value */
	this.median = function() {
		
		if (this._nodata())
			return;
		
		if (this.stat_median  == null) {
			
			this.stat_median = 0;
			var tmp = this.sorted();
			
			// serie pop is odd
			if (tmp.length % 2) {
				this.stat_median = parseFloat(tmp[(Math.ceil(tmp.length / 2) - 1)]);
				
			// serie pop is even
			} else {
				this.stat_median = ( parseFloat(tmp[((tmp.length / 2) - 1)]) + parseFloat(tmp[(tmp.length / 2)]) ) / 2;
			}
			
		}
		
		return this.stat_median;
	};

	/** return variance value */
	this.variance = function() {
		
		round = (typeof round === "undefined") ? true : false;
		
		if (this._nodata())
			return;
		
		if (this.stat_variance  == null) {

			var tmp = 0, serie_mean = this.mean();
			for (var i = 0; i < this.pop(); i++) {
				tmp += Math.pow( (this.serie[i] - serie_mean), 2 );
			}

			this.stat_variance =  tmp / this.pop();
			
			if(round == true) {
				this.stat_variance = Math.round(this.stat_variance * Math.pow(10,this.roundlength) )/ Math.pow(10,this.roundlength);
			}
			
		}
		
		return this.stat_variance;
	};
	
	/** return standard deviation value */
	this.stddev = function(round) {
		
		round = (typeof round === "undefined") ? true : false;
		
		if (this._nodata())
			return;
		
		if (this.stat_stddev  == null) {
			
			this.stat_stddev = Math.sqrt(this.variance());
			
			if(round == true) {
				this.stat_stddev = Math.round(this.stat_stddev * Math.pow(10,this.roundlength) )/ Math.pow(10,this.roundlength);
			}
			
		}
		
		return this.stat_stddev;
	};
	
	/** coefficient of variation - measure of dispersion */
	this.cov = function(round) {
		
		round = (typeof round === "undefined") ? true : false;
		
		if (this._nodata())
			return;
		
		if (this.stat_cov  == null) {
			
			this.stat_cov = this.stddev() / this.mean();
			
			if(round == true) {
				this.stat_cov = Math.round(this.stat_cov * Math.pow(10,this.roundlength) )/ Math.pow(10,this.roundlength);
			}
			
		}
		
		return this.stat_cov;
	};
	
	/** reset all attributes after setting a new serie */
	this.resetStatistics = function() {
	    this.stat_sorted    = null;
	    this.stat_mean  = null;
	    this.stat_median    = null;
	    this.stat_sum       = null;
	    this.stat_max       = null;
	    this.stat_min       = null;
	    this.stat_pop       = null;
	    this.stat_variance  = null;
	    this.stat_stddev    = null;
	    this.stat_cov       = null;
	}
	
	/** data test */
	this._nodata = function() {
		if (this.serie.length == 0) {
			
			if(this.silent) this.log("[silent mode] Error. You should first enter a serie!", true);
			else throw new TypeError("Error. You should first enter a serie!");
			return 1;
		} else
			return 0;
		
	};
	
	/** check if the serie contains negative value */
	this._hasNegativeValue = function() {
		
		for (i = 0; i < this.serie.length; i++) {
	    	if(this.serie[i] < 0)
	    		return true;
	    }

		return false;
	};
	
	/** check if the serie contains zero value */
	this._hasZeroValue = function() {
		
		for (i = 0; i < this.serie.length; i++) {
	    	if(parseFloat(this.serie[i]) === 0)
	    		return true;
	    }

		return false;
	};

	/** return sorted values (as array) */
	this.sorted = function() {
		
		if (this.stat_sorted  == null) {
			
			if(this.is_uniqueValues == false) {
				this.stat_sorted = this.serie.sort(function(a, b) {
					return a - b;
				});
			} else {
				this.stat_sorted = this.serie.sort(function(a,b){
					var nameA=a.toString().toLowerCase(), nameB=b.toString().toLowerCase();
				    if(nameA < nameB) return -1;
				    if(nameA > nameB) return 1;
				    return 0;
				})
			}
		}
		
		return this.stat_sorted;
		
	};

	/** return all info */
	this.info = function() {
		
		if (this._nodata())
			return;
		
		var content = '';
		content += _t('Population') + ' : ' + this.pop() + ' - [' + _t('Min')
				+ ' : ' + this.min() + ' | ' + _t('Max') + ' : ' + this.max()
				+ ']' + "\n";
		content += _t('Mean') + ' : ' + this.mean() + ' - ' + _t('Median')	+ ' : ' + this.median() + "\n";
		content += _t('Variance') + ' : ' + this.variance() + ' - ' + _t('Standard deviation')	+ ' : ' + this.stddev()  
				+ ' - ' + _t('Coefficient of variation')	+ ' : ' + this.cov() + "\n";

		return content;
	};
	
	/**
	 * Set Manual classification Return an array with bounds : ie array(0,
	 * 0.75, 1.5, 2.25, 3);
	 * Set ranges and prepare data for displaying legend
	 * 
	 */
	this.setClassManually = function(array) {

		if (this._nodata())
	        return;

	    if(array[0] !== this.min() || array[array.length-1] !== this.max()) {
	    	if(this.silent) this.log("[silent mode] " + t('Given bounds may not be correct! please check your input.\nMin value : ' + this.min() + ' / Max value : ' + this.max()), true);
			else throw new TypeError(_t('Given bounds may not be correct! please check your input.\nMin value : ' + this.min() + ' / Max value : ' + this.max()));
	    	return; 
	    }

	    this.setBounds(array);
	    this.setRanges();
	    
	    // we specify the classification method
	    this.method = _t('manual classification') + ' (' + (array.length -1) + ' ' + _t('classes') + ')';

	    return this.bounds;
	};

	/**
	 * Equal intervals classification Return an array with bounds : ie array(0,
	 * 0.75, 1.5, 2.25, 3);
	 */
	this.getClassEqInterval = function(nbClass, forceMin, forceMax) {

		if (this._nodata())
	        return;

		var tmpMin = (typeof forceMin === "undefined") ? this.min() : forceMin;
		var tmpMax = (typeof forceMax === "undefined") ? this.max() : forceMax;
		
	    var a = Array();
	    var val = tmpMin;
	    var interval = (tmpMax - tmpMin) / nbClass;

	    for (i = 0; i <= nbClass; i++) {
	        a[i] = val;
	        val += interval;
	    }

	    //-> Fix last bound to Max of values
	    a[nbClass] = tmpMax;

	    this.setBounds(a);
	    this.setRanges();
	    
	    // we specify the classification method
	    this.method = _t('eq. intervals') + ' (' + nbClass + ' ' + _t('classes') + ')';

	    return this.bounds;
	};
	

	this.getQuantiles = function(nbClass) {
		var tmp = this.sorted();
		var quantiles = [];

		var step = this.pop() / nbClass;
		for (var i = 1; i < nbClass; i++) {
			var qidx = Math.round(i*step+0.49);
			quantiles.push(tmp[qidx-1]); // zero-based
		}

		return quantiles;
	};

	/**
	 * Quantile classification Return an array with bounds : ie array(0, 0.75,
	 * 1.5, 2.25, 3);
	 */
	this.getClassQuantile = function(nbClass) {

		if (this._nodata())
			return;

		var tmp = this.sorted();
		var bounds = this.getQuantiles(nbClass);
		bounds.unshift(tmp[0]);

		if (bounds[tmp.length - 1] !== tmp[tmp.length - 1])
			bounds.push(tmp[tmp.length - 1]);

		this.setBounds(bounds);
		this.setRanges();

		// we specify the classification method
		this.method = _t('quantile') + ' (' + nbClass + ' ' + _t('classes') + ')';

		return this.bounds;

	};
	
	/**
	 * Standard Deviation classification
	 * Return an array with bounds : ie array(0,
	 * 0.75, 1.5, 2.25, 3);
	 */
	this.getClassStdDeviation = function(nbClass, matchBounds) {

		if (this._nodata())
	        return;

	    var tmpMax = this.max();
	    var tmpMin = this.min();
	    
	    var a = Array();
	    
	    // number of classes is odd
	    if(nbClass % 2 == 1) {

	    	// Euclidean division to get the inferior bound
	    	var infBound = Math.floor(nbClass / 2);
	    	
	    	var supBound = infBound + 1;
	    	
	    	// we set the central bounds
	    	a[infBound] = this.mean() - ( this.stddev() / 2);
	    	a[supBound] = this.mean() + ( this.stddev() / 2);
	    	
	    	// Values < to infBound, except first one
	    	for (i = infBound - 1; i > 0; i--) {
	    		var val = a[i+1] - this.stddev();
		        a[i] = val;
		    }
	    	
	    	// Values > to supBound, except last one
	    	for (i = supBound + 1; i < nbClass; i++) {
	    		var val = a[i-1] + this.stddev();
		        a[i] = val;
		    }
	    	
	    	// number of classes is even
	    } else {
	    	
	    	var meanBound = nbClass / 2;
	    	
	    	// we get the mean value
	    	a[meanBound] = this.mean();
	    	
	    	// Values < to the mean, except first one
	    	for (i = meanBound - 1; i > 0; i--) {
	    		var val = a[i+1] - this.stddev();
		        a[i] = val;
		    }
	    	
	    	// Values > to the mean, except last one
	    	for (i = meanBound + 1; i < nbClass; i++) {
	    		var val = a[i-1] + this.stddev();
		        a[i] = val;
		    }
	    }
	    
	    
	    // we finally set the first value
	    // do we excatly match min value or not ? 
	    a[0] = (typeof matchBounds === "undefined") ? a[1]-this.stddev() : this.min();
    	
    	// we finally set the last value
	    // do we excatly match max value or not ? 
    	a[nbClass] = (typeof matchBounds === "undefined") ? a[nbClass-1]+this.stddev() : this.max();

	    this.setBounds(a);
	    this.setRanges();
	    
	    // we specify the classification method
	    this.method = _t('std deviation') + ' (' + nbClass + ' ' + _t('classes')+ ')'; 
	    
	    return this.bounds;
	};
	
	
	/**
	 * Geometric Progression classification 
	 * http://en.wikipedia.org/wiki/Geometric_progression
	 * Return an array with bounds : ie array(0,
	 * 0.75, 1.5, 2.25, 3);
	 */
	this.getClassGeometricProgression = function(nbClass) {

		if (this._nodata())
	        return;

	    if(this._hasNegativeValue() || this._hasZeroValue()) {
	    	if(this.silent) this.log("[silent mode] " + _t('geometric progression can\'t be applied with a serie containing negative or zero values.'), true);
			else throw new TypeError(_t('geometric progression can\'t be applied with a serie containing negative or zero values.'));
	    	return;
	    }
	    
	    var a = Array();
	    var tmpMin = this.min();
	    var tmpMax = this.max();
	    
	    var logMax = Math.log(tmpMax) / Math.LN10; // max decimal logarithm (or base 10)
	    var logMin = Math.log(tmpMin) / Math.LN10;; // min decimal logarithm (or base 10)
	    
	    var interval = (logMax - logMin) / nbClass;
	    
	    // we compute log bounds
	    for (i = 0; i < nbClass; i++) {
	    	if(i == 0) {
	    		a[i] = logMin;
	    	} else {
	    		a[i] = a[i-1] + interval;
	    	}
	    }
	    
	    // we compute antilog
	    a = a.map(function(x) { return Math.pow(10, x); });
	    
	    // and we finally add max value
	    a.push(this.max());
	    
	    this.setBounds(a);
	    this.setRanges();
	    
	    // we specify the classification method
	    this.method = _t('geometric progression') + ' (' + nbClass + ' ' + _t('classes') + ')';

	    return this.bounds;
	};
	
	/**
	 * Arithmetic Progression classification 
	 * http://en.wikipedia.org/wiki/Arithmetic_progression
	 * Return an array with bounds : ie array(0,
	 * 0.75, 1.5, 2.25, 3);
	 */
	this.getClassArithmeticProgression = function(nbClass) {

		if (this._nodata())
	        return;
	    
	    var denominator = 0;
	    
	    // we compute the (french) "Raison"
	    for (i = 1; i <= nbClass; i++) {
	        denominator += i;
	    }

	    var a = Array();
	    var tmpMin = this.min();
	    var tmpMax = this.max();
	    
	    var interval = (tmpMax - tmpMin) / denominator;

	    for (i = 0; i <= nbClass; i++) {
	    	if(i == 0) {
	    		a[i] = tmpMin;
	    	} else {
	    		a[i] = a[i-1] + (i * interval);
	    	}
	    }

	    this.setBounds(a);
	    this.setRanges();
	    
	    // we specify the classification method
	    this.method = _t('arithmetic progression') + ' (' + nbClass + ' ' + _t('classes') + ')';

	    return this.bounds;
	};
	
	/**
	 * Credits : Doug Curl (javascript) and Daniel J Lewis (python implementation)
	 * http://www.arcgis.com/home/item.html?id=0b633ff2f40d412995b8be377211c47b
	 * http://danieljlewis.org/2010/06/07/jenks-natural-breaks-algorithm-in-python/
	 */
	this.getClassJenks = function(nbClass) {
	
		if (this._nodata())
			return;
		
		dataList = this.sorted();

		// now iterate through the datalist:
		// determine mat1 and mat2
		// really not sure how these 2 different arrays are set - the code for
		// each seems the same!
		// but the effect are 2 different arrays: mat1 and mat2
		var mat1 = []
		for ( var x = 0, xl = dataList.length + 1; x < xl; x++) {
			var temp = []
			for ( var j = 0, jl = nbClass + 1; j < jl; j++) {
				temp.push(0)
			}
			mat1.push(temp)
		}

		var mat2 = []
		for ( var i = 0, il = dataList.length + 1; i < il; i++) {
			var temp2 = []
			for ( var c = 0, cl = nbClass + 1; c < cl; c++) {
				temp2.push(0)
			}
			mat2.push(temp2)
		}

		// absolutely no idea what this does - best I can tell, it sets the 1st
		// group in the
		// mat1 and mat2 arrays to 1 and 0 respectively
		for ( var y = 1, yl = nbClass + 1; y < yl; y++) {
			mat1[0][y] = 1
			mat2[0][y] = 0
			for ( var t = 1, tl = dataList.length + 1; t < tl; t++) {
				mat2[t][y] = Infinity
			}
			var v = 0.0
		}

		// and this part - I'm a little clueless on - but it works
		// pretty sure it iterates across the entire dataset and compares each
		// value to
		// one another to and adjust the indices until you meet the rules:
		// minimum deviation
		// within a class and maximum separation between classes
		for ( var l = 2, ll = dataList.length + 1; l < ll; l++) {
			var s1 = 0.0
			var s2 = 0.0
			var w = 0.0
			for ( var m = 1, ml = l + 1; m < ml; m++) {
				var i3 = l - m + 1
				var val = parseFloat(dataList[i3 - 1])
				s2 += val * val
				s1 += val
				w += 1
				v = s2 - (s1 * s1) / w
				var i4 = i3 - 1
				if (i4 != 0) {
					for ( var p = 2, pl = nbClass + 1; p < pl; p++) {
						if (mat2[l][p] >= (v + mat2[i4][p - 1])) {
							mat1[l][p] = i3
							mat2[l][p] = v + mat2[i4][p - 1]
						}
					}
				}
			}
			mat1[l][1] = 1
			mat2[l][1] = v
		}

		var k = dataList.length
		var kclass = []

		// fill the kclass (classification) array with zeros:
		for (i = 0; i <= nbClass; i++) {
			kclass.push(0);
		}

		// this is the last number in the array:
		kclass[nbClass] = parseFloat(dataList[dataList.length - 1])
		// this is the first number - can set to zero, but want to set to lowest
		// to use for legend:
		kclass[0] = parseFloat(dataList[0])
		var countNum = nbClass
		while (countNum >= 2) {
			var id = parseInt((mat1[k][countNum]) - 2)
			kclass[countNum - 1] = dataList[id]
			k = parseInt((mat1[k][countNum] - 1))
			// spits out the rank and value of the break values:
			// console.log("id="+id,"rank = " + String(mat1[k][countNum]),"val =
			// " + String(dataList[id]))
			// count down:
			countNum -= 1
		}
		// check to see if the 0 and 1 in the array are the same - if so, set 0
		// to 0:
		if (kclass[0] == kclass[1]) {
			kclass[0] = 0
		}

		this.setBounds(kclass);
		this.setRanges();

		
		this.method = _t('Jenks') + ' (' + nbClass + ' ' + _t('classes') + ')';
		
		return this.bounds; //array of breaks
	}
	
	
	/**
	 * Quantile classification Return an array with bounds : ie array(0, 0.75,
	 * 1.5, 2.25, 3);
	 */
	this.getClassUniqueValues = function() {

		if (this._nodata())
			return;
		
		this.is_uniqueValues = true;
		
		var tmp = this.sorted(); // display in alphabetical order

		var a = Array();

		for (i = 0; i < this.pop(); i++) {
			if(a.indexOf(tmp[i]) === -1)
				a.push(tmp[i]);
		}
		
		this.bounds = a;
		
		// we specify the classification method
		this.method = _t('unique values');
		
		return a;

	};
	
	
	/**
	 * Return the class of a given value.
	 * For example value : 6
	 * and bounds array = (0, 4, 8, 12);
	 * Return 2
	 */
	this.getClass = function(value) {

		for(i = 0; i < this.bounds.length; i++) {
			
			
			if(this.is_uniqueValues == true) {
				if(value == this.bounds[i])
					return i;
			} else {
				// parseFloat() is necessary
				if(parseFloat(value) <= this.bounds[i + 1]) {
					return i;
				}
			}
		}
		
		return _t("Unable to get value's class.");
		
	};

	/**
	 * Return the ranges array : array('0-0.75', '0.75-1.5', '1.5-2.25',
	 * '2.25-3');
	 */
	this.getRanges = function() {
		
		return this.ranges;
		
	};

	/**
	 * Returns the number/index of this.ranges that value falls into
	 */
	this.getRangeNum = function(value) {
		
		var bounds, i;

		for (i = 0; i < this.ranges.length; i++) {
			bounds = this.ranges[i].split(/ - /);
			if (value <= parseFloat(bounds[1])) {
				return i;
			}
		}
	}
	
	/*
	 * Compute inner ranges based on serie. 
	 * Produce discontinous ranges used for legend - return an array similar to : 
	 * array('0.00-0.74', '0.98-1.52', '1.78-2.25', '2.99-3.14');
	 * If inner ranges already computed, return array values.
	 */
	this.getInnerRanges = function() {
		
		// if already computed, we return the result
		if(this.inner_ranges != null)
			return this.inner_ranges;

		
		var a = new Array();
		var tmp = this.sorted();
		
		var cnt = 1; // bounds array counter
		
		for (i = 0; i < tmp.length; i++) {
			
			if(i == 0) var range_firstvalue = tmp[i]; // we init first range value
			
			if(parseFloat(tmp[i]) > parseFloat(this.bounds[cnt])) {
				
				a[cnt - 1] = '' + range_firstvalue + this.separator + tmp[i-1];
				
				var range_firstvalue =  tmp[i];
				
				cnt++;

			}
			
			// we reach the last range, we finally complete manually
			// and return the array
			if(cnt == (this.bounds.length - 1)) {
				// we set the last value
				a[cnt - 1] = '' + range_firstvalue + this.separator + tmp[tmp.length-1];
				
				this.inner_ranges = a;
				return this.inner_ranges;
			}
			

		}
		
	};
	
	this.getSortedlist = function() {
		
		return this.sorted().join(', ');
		
	};
	
	/**
	 * Return an html legend
	 * colors : specify an array of color (hexadecimal values)
	 * legend :  specify a text input for the legend. By default, just displays 'legend'
	 * counter : if not null, display counter value
	 * callback : if not null, callback function applied on legend boundaries
	 * mode : 	null, 'default', 'distinct', 'discontinuous' : 
	 * 			- if mode is null, will display legend as 'default mode'
	 * 			- 'default' : displays ranges like in ranges array (continuous values), sample :  29.26 - 378.80 / 378.80 - 2762.25 /  2762.25 - 6884.84
	 * 			- 'distinct' : Add + 1 according to decimal precision to distinguish classes (discrete values), sample :  29.26 - 378.80 / 378.81 - 2762.25 /  2762.26 - 6884.84 
	 * 			- 'discontinuous' : indicates the range of data actually falling in each class , sample :  29.26 - 225.43 / 852.12 - 2762.20 /  3001.25 - 6884.84 / not implemented yet
	 * order : 	null, 'ASC', 'DESC'
	 */
	this.getHtmlLegend = function(colors, legend, counter, callback, mode, order) {
		
		var cnt= '';
		var elements = new Array();
		
		this.doCount(); // we do count, even if not displayed
		
		if(colors != null) {
			ccolors = colors;
		}
		else {
			ccolors = this.colors;
		}
		
		if(legend != null) {
			lg = legend;
		}
		else {
			lg =  'Legend';
		}
		
		if(counter != null) {
			getcounter = true;
		}
		else {
			getcounter = false;
		}
		
		if(callback != null) {
			fn = callback;
		}
		else {
			fn = function(o) {return o;};
		}
		if(mode == null) {
			mode = 'default';
		}
		if(mode == 'discontinuous') {
			this.getInnerRanges();
			// check if some classes are not populated / equivalent of in_array function
			if(this.counter.indexOf(0) !== -1) {
		    	if(this.silent) this.log("[silent mode] " + _t("Geostats cannot apply 'discontinuous' mode to the getHtmlLegend() method because some classes are not populated.\nPlease switch to 'default' or 'distinct' modes. Exit!"), true);
				else throw new TypeError(_t("Geostats cannot apply 'discontinuous' mode to the getHtmlLegend() method because some classes are not populated.\nPlease switch to 'default' or 'distinct' modes. Exit!"));
				return;
			}

		}
		if(order !== 'DESC') order = 'ASC';
		
		if(ccolors.length < this.ranges.length) {
			if(this.silent) this.log("[silent mode] " + _t('The number of colors should fit the number of ranges. Exit!'), true);
			else throw new TypeError(_t('The number of colors should fit the number of ranges. Exit!'));
			return;
		}
		
		if(this.is_uniqueValues == false) {
			
			for (i = 0; i < (this.ranges.length); i++) {
				if(getcounter===true) {
					cnt = ' <span class="geostats-legend-counter">(' + this.counter[i] + ')</span>';
				}
				//console.log("Ranges : " + this.ranges[i]);
				
				// default mode 
				var tmp = this.ranges[i].split(this.separator);
					
				var start_value = parseFloat(tmp[0]).toFixed(this.precision);
				var end_value = parseFloat(tmp[1]).toFixed(this.precision);
					
				
				// if mode == 'distinct' and we are not working on the first value
				if(mode == 'distinct' && i != 0) {

					if(isInt(start_value)) {
						start_value = parseInt(start_value) + 1;
						// format to float if necessary
						if(this.precisionflag == 'manual' && this.precision != 0) start_value = parseFloat(start_value).toFixed(this.precision);
					} else {

						start_value = parseFloat(start_value) + (1 / Math.pow(10,this.precision));
						// strangely the formula above return sometimes long decimal values, 
						// the following instruction fix it
						start_value = parseFloat(start_value).toFixed(this.precision);
					}
				}
				
				// if mode == 'discontinuous'
				if(mode == 'discontinuous') {
										
					var tmp = this.inner_ranges[i].split(this.separator);
					// console.log("Ranges : " + this.inner_ranges[i]);
					
					var start_value = parseFloat(tmp[0]).toFixed(this.precision);
					var end_value = parseFloat(tmp[1]).toFixed(this.precision);
					
				}
				
				// we apply callback function
				var el = fn(start_value) + this.legendSeparator + fn(end_value);
					
				var block = '<div><div class="geostats-legend-block" style="background-color:' + ccolors[i] + '"></div> ' + el + cnt + '</div>';
				elements.push(block);
			}
			
		} else {
			
			// only if classification is done on unique values
			for (i = 0; i < (this.bounds.length); i++) {
				if(getcounter===true) {
					cnt = ' <span class="geostats-legend-counter">(' + this.counter[i] + ')</span>';
				}
				var el = fn(this.bounds[i]);
				var block = '<div><div class="geostats-legend-block" style="background-color:' + ccolors[i] + '"></div> ' + el + cnt + '</div>';

				elements.push(block);
			}
			
		}
		
		// do we reverse the return legend ?
		if(order === 'DESC') elements.reverse(); 
		
		// finally we create HTML and return it
		var content  = '<div class="geostats-legend"><div class="geostats-legend-title">' + _t(lg) + '</div>';
		for (i = 0; i < (elements.length); i++) {
			content += elements[i];
		}
		content += '</div>';
    
		return content;
	};

	
	
	// object constructor
	// At the end of script. If not setPrecision() method is not known
	
	// we create an object identifier for debugging
	this.objectID = new Date().getUTCMilliseconds();
	this.log('Creating new geostats object');
	
	if(typeof a !== 'undefined' && a.length > 0) {
		this.serie = a;
		this.setPrecision();
		this.log('Setting serie (' + a.length + ') : ' + a.join());
	} else {
		this.serie = Array();

	};
	
	// creating aliases on classification function for backward compatibility
	this.getJenks = this.getClassJenks;
	this.getGeometricProgression = this.getClassGeometricProgression;
	this.getEqInterval = this.getClassEqInterval;
	this.getQuantile = this.getClassQuantile;
	this.getStdDeviation = this.getClassStdDeviation;
	this.getUniqueValues = this.getClassUniqueValues;
	this.getArithmeticProgression = this.getClassArithmeticProgression;

};

window.geostats = geostats;
return geostats;
});

/***/ }),

/***/ "e6PS":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__("TqRt");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Pixel = void 0;

var _classCallCheck2 = _interopRequireDefault(__webpack_require__("lwsE"));

var _createClass2 = _interopRequireDefault(__webpack_require__("W8MJ"));

/* Copyright© 2000 - 2020 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html. */

/**
 * @class Pixel
 * @category BaseTypes Geometry
 * @classdesc 此类用 x,y 坐标描绘屏幕坐标（像素点）。
 * @param {number} [x=0.0] - x 坐标。
 * @param {number} [y=0.0] - y 坐标。
 * @param {Pixel.Mode} [mode=Pixel.Mode.LeftTop] - 坐标模式。
 *
 * @example
 * //单独创建一个对象
 * var pixcel = new Pixel(100,50);
 *
 * //依据 size 创建
 *  var size = new Size(21,25);
 *  var offset = new Pixel(-(size.w/2), -size.h);
 */
var Pixel =
/*#__PURE__*/
function () {
  function Pixel(x, y, mode) {
    (0, _classCallCheck2.default)(this, Pixel);

    /**
     * @member {number} [Pixel.prototype.x=0.0]
     * @description x 坐标。
     */
    this.x = x ? parseFloat(x) : 0.0;
    /**
     * @member {number} [Pixel.prototype.y=0.0]
     * @description y 坐标。
     */

    this.y = y ? parseFloat(y) : 0.0;
    /**
     * @member {Pixel.Mode} [Pixel.prototype.mode=Pixel.Mode.LeftTop]
     * @description 坐标模式，有左上、右上、右下、左下这几种模式，分别表示相对于左上角、右上角、右下角、左下角的坐标。
     */

    this.mode = mode;
    this.CLASS_NAME = 'Pixel';
    /**
     * @enum Pixel.Mode
     * @readonly
     * @description 模式。
     * @type {string}
     */

    Pixel.Mode = {
      /** 左上模式。 */
      LeftTop: 'lefttop',

      /** 右上模式。 */
      RightTop: 'righttop',

      /** 右下模式。 */
      RightBottom: 'rightbottom',

      /** 左下模式。 */
      LeftBottom: 'leftbottom'
    };
  }
  /**
   * @function Pixel.prototype.toString
   * @description 返回此对象的字符串形式。
   * @example
   *
   * var pixcel = new Pixel(100,50);
   * var str = pixcel.toString();
   *
   * @returns {string} 例如: "x=200.4,y=242.2"
   */


  (0, _createClass2.default)(Pixel, [{
    key: "toString",
    value: function toString() {
      return 'x=' + this.x + ',y=' + this.y;
    }
    /**
     * @function Pixel.prototype.clone
     * @description 克隆当前的 pixel 对象。
     * @example
     * var pixcel = new Pixel(100,50);
     * var pixcel2 = pixcel.clone();
     * @returns {Pixel} 返回一个新的与当前 pixel 对象有相同 x、y 坐标的 pixel 对象。
     */

  }, {
    key: "clone",
    value: function clone() {
      return new Pixel(this.x, this.y, this.mode);
    }
    /**
     * @function Pixel.prototype.equals
     * @description 比较两 pixel 是否相等。
     * @example
     * var pixcel = new Pixel(100,50);
     * var pixcel2 = new Pixel(100,50);
     * var isEquals = pixcel.equals(pixcel2);
     *
     * @param {Pixel} px - 用于比较相等的 pixel 对象。
     * @returns {boolean} 如果传入的像素点和当前像素点相同返回 true，如果不同或传入参数为 NULL 则返回 false。
     */

  }, {
    key: "equals",
    value: function equals(px) {
      var equals = false;

      if (px != null) {
        equals = this.x === px.x && this.y === px.y || isNaN(this.x) && isNaN(this.y) && isNaN(px.x) && isNaN(px.y);
      }

      return equals;
    }
    /**
     * @function Pixel.prototype.distanceTo
     * @description 返回两个 pixel 的距离。
     * @example
     * var pixcel = new Pixel(100,50);
     * var pixcel2 = new Pixel(110,30);
     * var distance = pixcel.distanceTo(pixcel2);
     *
     * @param {Pixel} px - 用于计算的一个 pixel。
     * @returns {float} 作为参数传入的像素与当前像素点的距离。
     */

  }, {
    key: "distanceTo",
    value: function distanceTo(px) {
      return Math.sqrt(Math.pow(this.x - px.x, 2) + Math.pow(this.y - px.y, 2));
    }
    /**
     * @function Pixel.prototype.add
     * @description 在原来像素坐标基础上，x 值加上传入的 x 参数，y 值加上传入的 y 参数。
     * @example
     * var pixcel = new Pixel(100,50);
     * //pixcel2是新的对象
     * var pixcel2 = pixcel.add(20,30);
     *
     * @param {number} x - 传入的 x 值。
     * @param {number} y - 传入的 y 值。
     * @returns {Pixel} 返回一个新的 pixel 对象，该 pixel 是由当前的 pixel 与传入的 x，y 相加得到。
     */

  }, {
    key: "add",
    value: function add(x, y) {
      if (x == null || y == null) {
        throw new TypeError('Pixel.add cannot receive null values');
      }

      return new Pixel(this.x + x, this.y + y);
    }
    /**
     * @function Pixel.prototype.offset
     * @description 通过传入的 {@link Pixel} 参数对原屏幕坐标进行偏移。
     * @example
     * var pixcel = new Pixel(100,50);
     * var pixcel2 = new Pixel(130,20);
     * //pixcel3 是新的对象
     * var pixcel3 = pixcel.offset(pixcel2);
     *
     * @param {Pixel} px - 传入的 <Pixel> 对象。
     * @returns {Pixel} 返回一个新的 pixel，该 pixel 是由当前的 pixel 对象的 x，y 值与传入的 Pixel 对象的 x，y 值相加得到。
     */

  }, {
    key: "offset",
    value: function offset(px) {
      var newPx = this.clone();

      if (px) {
        newPx = this.add(px.x, px.y);
      }

      return newPx;
    }
    /**
     *
     * @function Pixel.prototype.destroy
     * @description 销毁此对象。销毁后此对象的所有属性为 null，而不是初始值。
     * @example
     * var pixcel = new Pixel(100,50);
     * pixcel.destroy();
     */

  }, {
    key: "destroy",
    value: function destroy() {
      this.x = null;
      this.y = null;
      this.mode = null;
    }
  }]);
  return Pixel;
}();

exports.Pixel = Pixel;

/***/ }),

/***/ "e7LN":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__("TqRt");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDateTime = getDateTime;
exports.hexToRgba = hexToRgba;
exports.isTransparent = isTransparent;
exports.reservedDecimal = reservedDecimal;
exports.clearNumberComma = clearNumberComma;
exports.isXField = isXField;
exports.isYField = isYField;
exports.getColorWithOpacity = getColorWithOpacity;
exports.parseUrl = parseUrl;
exports.getDataType = getDataType;
exports.isMatchUrl = isMatchUrl;
exports.isDate = isDate;
exports.isNumber = isNumber;
exports.getFeatureCenter = getFeatureCenter;
exports.getValueCaseInsensitive = getValueCaseInsensitive;

var _lang = __webpack_require__("DSM6");

var _colorcolor = _interopRequireDefault(__webpack_require__("rn/G"));

var _center = _interopRequireDefault(__webpack_require__("SPBs"));

// 获取当前时间返回置顶格式
function getDateTime(timeType) {
  return (0, _lang.geti18n)().d(new Date(), timeType.replace(/\+/g, '_'), (0, _lang.getLanguage)());
} // hex -> rgba


function hexToRgba(hex, opacity) {
  return 'rgba(' + parseInt('0x' + hex.slice(1, 3)) + ',' + parseInt('0x' + hex.slice(3, 5)) + ',' + parseInt('0x' + hex.slice(5, 7)) + ',' + opacity + ')';
}

function isTransparent(color) {
  var rgba = (0, _colorcolor.default)(color, 'rgba');
  return +rgba.match(/(\d(\.\d+)?)+/g)[3] === 0;
} // 保留指定位数的小数


function reservedDecimal(val, precise) {
  return Number(val).toFixed(precise);
} // 清除数字（字符串型的）的逗号


function clearNumberComma(num) {
  if (num.replace) {
    num = num.replace(/,/g, '');
  }

  return num;
}
/**
 * 判断是否地理X坐标
 * @param data
 */


function isXField(data) {
  var lowerdata = data.toLowerCase();
  return lowerdata === 'x' || lowerdata === 'smx' || lowerdata === 'jd' || lowerdata === '经度' || lowerdata === '东经' || lowerdata === 'longitude' || lowerdata === 'lot' || lowerdata === 'lon' || lowerdata === 'lng' || lowerdata === 'x坐标';
}
/**
 * 判断是否地理Y坐标
 * @param data
 */


function isYField(data) {
  var lowerdata = data.toLowerCase();
  return lowerdata === 'y' || lowerdata === 'smy' || lowerdata === 'wd' || lowerdata === '纬度' || lowerdata === '北纬' || lowerdata === 'latitude' || lowerdata === 'lat' || lowerdata === 'y坐标';
}

function getColorWithOpacity(color, opacity) {
  if (color.indexOf('rgba') > -1) {
    return color.substring(0, color.lastIndexOf(',') + 1) + opacity + ')';
  }

  var newColor = (0, _colorcolor.default)(color, 'rgb');
  return 'rgba' + newColor.substring(3, newColor.length - 1) + ",".concat(opacity, ")");
}

function parseUrl(url) {
  var urlRe = /^(\w+):\/\/([^/?]*)(\/[^?]+)?\??(.+)?/;
  return url.match(urlRe);
}

function getDataType(data) {
  return Object.prototype.toString.call(data);
} // 判断输入的地址是否符合地址格式


function isMatchUrl(str) {
  var reg = new RegExp('(https?|http|file|ftp)://[-A-Za-z0-9+&@#/%?=~_|!:,.;]+[-A-Za-z0-9+&@#/%=~_|]');
  return reg.test(str);
} // 判断是否为日期


function isDate(data) {
  var reg = /((^((1[8-9]\d{2})|([2-9]\d{3}))([-\/\._])(10|12|0?[13578])([-\/\._])(3[01]|[12][0-9]|0?[1-9])$)|(^((1[8-9]\d{2})|([2-9]\d{3}))([-\/\._])(11|0?[469])([-\/\._])(30|[12][0-9]|0?[1-9])$)|(^((1[8-9]\d{2})|([2-9]\d{3}))([-\/\._])(0?2)([-\/\._])(2[0-8]|1[0-9]|0?[1-9])$)|(^([2468][048]00)([-\/\._])(0?2)([-\/\._])(29)$)|(^([3579][26]00)([-\/\._])(0?2)([-\/\._])(29)$)|(^([1][89][0][48])([-\/\._])(0?2)([-\/\._])(29)$)|(^([2-9][0-9][0][48])([-\/\._])(0?2)([-\/\._])(29)$)|(^([1][89][2468][048])([-\/\._])(0?2)([-\/\._])(29)$)|(^([2-9][0-9][2468][048])([-\/\._])(0?2)([-\/\._])(29)$)|(^([1][89][13579][26])([-\/\._])(0?2)([-\/\._])(29)$)|(^([2-9][0-9][13579][26])([-\/\._])(0?2)([-\/\._])(29)$))/gi;
  return reg.test(data);
} // 判断是否为数值


function isNumber(data) {
  var mdata = Number(data);

  if (mdata === 0) {
    return true;
  }

  return !isNaN(mdata);
}

function getFeatureCenter(feature) {
  var coordinates = ((feature || {}).geometry || {}).coordinates;
  var hasCoordinates = coordinates && !!coordinates.length;

  if (!hasCoordinates) {
    return;
  }

  var featureType = feature.geometry.type;
  var center;

  if (featureType === 'LineString') {
    center = coordinates[parseInt(coordinates.length / 2)];
  } else if (featureType === 'MultiLineString') {
    var coord = coordinates[parseInt(coordinates.length / 2)];
    center = coord[parseInt(coord.length / 2)];
  } else {
    center = (0, _center.default)(feature).geometry.coordinates;
  }

  return center;
}

function getValueCaseInsensitive(properties, searchKey) {
  var isObj = getDataType(properties) === '[object Object]';

  if (!searchKey || !isObj) {
    return '';
  }

  var lowerSearchKey = searchKey.toLocaleLowerCase();

  for (var key in properties) {
    if (key.toLocaleLowerCase() === lowerSearchKey) {
      return properties[key];
    }
  }

  return '';
}

/***/ }),

/***/ "eA/Y":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.

// a passthrough stream.
// basically just the most minimal sort of Transform stream.
// Every written chunk gets output as-is.



module.exports = PassThrough;

var Transform = __webpack_require__("J78i");

/*<replacement>*/
var util = __webpack_require__("Onz0");
util.inherits = __webpack_require__("P7XM");
/*</replacement>*/

util.inherits(PassThrough, Transform);

function PassThrough(options) {
  if (!(this instanceof PassThrough)) return new PassThrough(options);

  Transform.call(this, options);
}

PassThrough.prototype._transform = function (chunk, encoding, cb) {
  cb(null, chunk);
};

/***/ }),

/***/ "ekee":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_Text_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("II3L");
/* harmony import */ var _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_Text_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_Text_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__);
/* harmony reexport (unknown) */ for(var __WEBPACK_IMPORT_KEY__ in _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_Text_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__) if(__WEBPACK_IMPORT_KEY__ !== 'default') (function(key) { __webpack_require__.d(__webpack_exports__, key, function() { return _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_Text_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__[key]; }) }(__WEBPACK_IMPORT_KEY__));
 /* harmony default export */ __webpack_exports__["default"] = (_node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_Text_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0___default.a); 

/***/ }),

/***/ "fFTV":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_Chart_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("zyim");
/* harmony import */ var _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_Chart_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_Chart_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__);
/* harmony reexport (unknown) */ for(var __WEBPACK_IMPORT_KEY__ in _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_Chart_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__) if(__WEBPACK_IMPORT_KEY__ !== 'default') (function(key) { __webpack_require__.d(__webpack_exports__, key, function() { return _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_Chart_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__[key]; }) }(__WEBPACK_IMPORT_KEY__));
 /* harmony default export */ __webpack_exports__["default"] = (_node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_Chart_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0___default.a); 

/***/ }),

/***/ "fXKp":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.



/*<replacement>*/

var Buffer = __webpack_require__("hwdV").Buffer;
/*</replacement>*/

var isEncoding = Buffer.isEncoding || function (encoding) {
  encoding = '' + encoding;
  switch (encoding && encoding.toLowerCase()) {
    case 'hex':case 'utf8':case 'utf-8':case 'ascii':case 'binary':case 'base64':case 'ucs2':case 'ucs-2':case 'utf16le':case 'utf-16le':case 'raw':
      return true;
    default:
      return false;
  }
};

function _normalizeEncoding(enc) {
  if (!enc) return 'utf8';
  var retried;
  while (true) {
    switch (enc) {
      case 'utf8':
      case 'utf-8':
        return 'utf8';
      case 'ucs2':
      case 'ucs-2':
      case 'utf16le':
      case 'utf-16le':
        return 'utf16le';
      case 'latin1':
      case 'binary':
        return 'latin1';
      case 'base64':
      case 'ascii':
      case 'hex':
        return enc;
      default:
        if (retried) return; // undefined
        enc = ('' + enc).toLowerCase();
        retried = true;
    }
  }
};

// Do not cache `Buffer.isEncoding` when checking encoding names as some
// modules monkey-patch it to support additional encodings
function normalizeEncoding(enc) {
  var nenc = _normalizeEncoding(enc);
  if (typeof nenc !== 'string' && (Buffer.isEncoding === isEncoding || !isEncoding(enc))) throw new Error('Unknown encoding: ' + enc);
  return nenc || enc;
}

// StringDecoder provides an interface for efficiently splitting a series of
// buffers into a series of JS strings without breaking apart multi-byte
// characters.
exports.StringDecoder = StringDecoder;
function StringDecoder(encoding) {
  this.encoding = normalizeEncoding(encoding);
  var nb;
  switch (this.encoding) {
    case 'utf16le':
      this.text = utf16Text;
      this.end = utf16End;
      nb = 4;
      break;
    case 'utf8':
      this.fillLast = utf8FillLast;
      nb = 4;
      break;
    case 'base64':
      this.text = base64Text;
      this.end = base64End;
      nb = 3;
      break;
    default:
      this.write = simpleWrite;
      this.end = simpleEnd;
      return;
  }
  this.lastNeed = 0;
  this.lastTotal = 0;
  this.lastChar = Buffer.allocUnsafe(nb);
}

StringDecoder.prototype.write = function (buf) {
  if (buf.length === 0) return '';
  var r;
  var i;
  if (this.lastNeed) {
    r = this.fillLast(buf);
    if (r === undefined) return '';
    i = this.lastNeed;
    this.lastNeed = 0;
  } else {
    i = 0;
  }
  if (i < buf.length) return r ? r + this.text(buf, i) : this.text(buf, i);
  return r || '';
};

StringDecoder.prototype.end = utf8End;

// Returns only complete characters in a Buffer
StringDecoder.prototype.text = utf8Text;

// Attempts to complete a partial non-UTF-8 character using bytes from a Buffer
StringDecoder.prototype.fillLast = function (buf) {
  if (this.lastNeed <= buf.length) {
    buf.copy(this.lastChar, this.lastTotal - this.lastNeed, 0, this.lastNeed);
    return this.lastChar.toString(this.encoding, 0, this.lastTotal);
  }
  buf.copy(this.lastChar, this.lastTotal - this.lastNeed, 0, buf.length);
  this.lastNeed -= buf.length;
};

// Checks the type of a UTF-8 byte, whether it's ASCII, a leading byte, or a
// continuation byte. If an invalid byte is detected, -2 is returned.
function utf8CheckByte(byte) {
  if (byte <= 0x7F) return 0;else if (byte >> 5 === 0x06) return 2;else if (byte >> 4 === 0x0E) return 3;else if (byte >> 3 === 0x1E) return 4;
  return byte >> 6 === 0x02 ? -1 : -2;
}

// Checks at most 3 bytes at the end of a Buffer in order to detect an
// incomplete multi-byte UTF-8 character. The total number of bytes (2, 3, or 4)
// needed to complete the UTF-8 character (if applicable) are returned.
function utf8CheckIncomplete(self, buf, i) {
  var j = buf.length - 1;
  if (j < i) return 0;
  var nb = utf8CheckByte(buf[j]);
  if (nb >= 0) {
    if (nb > 0) self.lastNeed = nb - 1;
    return nb;
  }
  if (--j < i || nb === -2) return 0;
  nb = utf8CheckByte(buf[j]);
  if (nb >= 0) {
    if (nb > 0) self.lastNeed = nb - 2;
    return nb;
  }
  if (--j < i || nb === -2) return 0;
  nb = utf8CheckByte(buf[j]);
  if (nb >= 0) {
    if (nb > 0) {
      if (nb === 2) nb = 0;else self.lastNeed = nb - 3;
    }
    return nb;
  }
  return 0;
}

// Validates as many continuation bytes for a multi-byte UTF-8 character as
// needed or are available. If we see a non-continuation byte where we expect
// one, we "replace" the validated continuation bytes we've seen so far with
// a single UTF-8 replacement character ('\ufffd'), to match v8's UTF-8 decoding
// behavior. The continuation byte check is included three times in the case
// where all of the continuation bytes for a character exist in the same buffer.
// It is also done this way as a slight performance increase instead of using a
// loop.
function utf8CheckExtraBytes(self, buf, p) {
  if ((buf[0] & 0xC0) !== 0x80) {
    self.lastNeed = 0;
    return '\ufffd';
  }
  if (self.lastNeed > 1 && buf.length > 1) {
    if ((buf[1] & 0xC0) !== 0x80) {
      self.lastNeed = 1;
      return '\ufffd';
    }
    if (self.lastNeed > 2 && buf.length > 2) {
      if ((buf[2] & 0xC0) !== 0x80) {
        self.lastNeed = 2;
        return '\ufffd';
      }
    }
  }
}

// Attempts to complete a multi-byte UTF-8 character using bytes from a Buffer.
function utf8FillLast(buf) {
  var p = this.lastTotal - this.lastNeed;
  var r = utf8CheckExtraBytes(this, buf, p);
  if (r !== undefined) return r;
  if (this.lastNeed <= buf.length) {
    buf.copy(this.lastChar, p, 0, this.lastNeed);
    return this.lastChar.toString(this.encoding, 0, this.lastTotal);
  }
  buf.copy(this.lastChar, p, 0, buf.length);
  this.lastNeed -= buf.length;
}

// Returns all complete UTF-8 characters in a Buffer. If the Buffer ended on a
// partial character, the character's bytes are buffered until the required
// number of bytes are available.
function utf8Text(buf, i) {
  var total = utf8CheckIncomplete(this, buf, i);
  if (!this.lastNeed) return buf.toString('utf8', i);
  this.lastTotal = total;
  var end = buf.length - (total - this.lastNeed);
  buf.copy(this.lastChar, 0, end);
  return buf.toString('utf8', i, end);
}

// For UTF-8, a replacement character is added when ending on a partial
// character.
function utf8End(buf) {
  var r = buf && buf.length ? this.write(buf) : '';
  if (this.lastNeed) return r + '\ufffd';
  return r;
}

// UTF-16LE typically needs two bytes per character, but even if we have an even
// number of bytes available, we need to check if we end on a leading/high
// surrogate. In that case, we need to wait for the next two bytes in order to
// decode the last character properly.
function utf16Text(buf, i) {
  if ((buf.length - i) % 2 === 0) {
    var r = buf.toString('utf16le', i);
    if (r) {
      var c = r.charCodeAt(r.length - 1);
      if (c >= 0xD800 && c <= 0xDBFF) {
        this.lastNeed = 2;
        this.lastTotal = 4;
        this.lastChar[0] = buf[buf.length - 2];
        this.lastChar[1] = buf[buf.length - 1];
        return r.slice(0, -1);
      }
    }
    return r;
  }
  this.lastNeed = 1;
  this.lastTotal = 2;
  this.lastChar[0] = buf[buf.length - 1];
  return buf.toString('utf16le', i, buf.length - 1);
}

// For UTF-16LE we do not explicitly append special replacement characters if we
// end on a partial character, we simply let v8 handle that.
function utf16End(buf) {
  var r = buf && buf.length ? this.write(buf) : '';
  if (this.lastNeed) {
    var end = this.lastTotal - this.lastNeed;
    return r + this.lastChar.toString('utf16le', 0, end);
  }
  return r;
}

function base64Text(buf, i) {
  var n = (buf.length - i) % 3;
  if (n === 0) return buf.toString('base64', i);
  this.lastNeed = 3 - n;
  this.lastTotal = 3;
  if (n === 1) {
    this.lastChar[0] = buf[buf.length - 1];
  } else {
    this.lastChar[0] = buf[buf.length - 2];
    this.lastChar[1] = buf[buf.length - 1];
  }
  return buf.toString('base64', i, buf.length - n);
}

function base64End(buf) {
  var r = buf && buf.length ? this.write(buf) : '';
  if (this.lastNeed) return r + this.lastChar.toString('base64', 0, 3 - this.lastNeed);
  return r;
}

// Pass bytes on through for single-byte encodings (e.g. ascii, latin1, hex)
function simpleWrite(buf) {
  return buf.toString(this.encoding);
}

function simpleEnd(buf) {
  return buf && buf.length ? this.write(buf) : '';
}

/***/ }),

/***/ "gQum":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__("TqRt");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _classCallCheck2 = _interopRequireDefault(__webpack_require__("lwsE"));

var _lang = __webpack_require__("DSM6");

var RestDataParameter = function RestDataParameter(options) {
  (0, _classCallCheck2.default)(this, RestDataParameter);
  this.type = 'iServer';
  this.url = options.url;
  this.dataName = options.dataName;
  this.attributeFilter = options.attributeFilter || null;
  this.maxFeatures = options.maxFeatures || 20;
  this.name = options.name || (0, _lang.geti18n)().t('commontypes.restData');
  this.proxy = options.proxy;
};

exports.default = RestDataParameter;

/***/ }),

/***/ "gzXh":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.chartThemeUtil = void 0;

var _util = __webpack_require__("e7LN");

var chartThemeUtil = function chartThemeUtil() {
  var background = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'rgba(255, 255, 255, 0.6)';
  var textColor = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '#333';
  var colorGroup = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : ['#3fb1e3', '#6be6c1', '#626c91', '#a0a7e6', '#c4ebad', '#96dee8'];
  var chartTheme = {
    color: colorGroup,
    backgroundColor: background,
    textStyle: {},
    title: {
      textStyle: {
        color: textColor
      },
      subtextStyle: {
        color: '#999999'
      }
    },
    line: {
      itemStyle: {
        normal: {
          borderWidth: '2'
        }
      },
      lineStyle: {
        normal: {
          width: '3'
        }
      },
      symbolSize: '8',
      symbol: 'emptyCircle',
      smooth: false
    },
    radar: {
      name: {
        textStyle: {
          color: textColor
        }
      },
      lineStyle: {
        normal: {
          width: '3',
          color: textColor
        }
      },
      splitLine: {
        lineStyle: {
          color: [(0, _util.getColorWithOpacity)(textColor, 1), (0, _util.getColorWithOpacity)(textColor, 0.8), (0, _util.getColorWithOpacity)(textColor, 0.6), (0, _util.getColorWithOpacity)(textColor, 0.4), (0, _util.getColorWithOpacity)(textColor, 0.2), (0, _util.getColorWithOpacity)(textColor, 0.1)]
        }
      },
      axisLine: {
        lineStyle: {
          color: (0, _util.getColorWithOpacity)(textColor, 0.3)
        }
      },
      symbolSize: '8',
      symbol: 'emptyCircle',
      smooth: false // 'radius': '63%'

    },
    bar: {
      itemStyle: {
        normal: {
          barBorderWidth: 0,
          barBorderColor: '#cccccc'
        },
        emphasis: {
          barBorderWidth: 0,
          barBorderColor: '#cccccc'
        }
      }
    },
    pie: {
      itemStyle: {
        normal: {
          borderWidth: 0,
          borderColor: '#cccccc'
        },
        emphasis: {
          borderWidth: 0,
          borderColor: '#cccccc'
        }
      },
      radius: '63%'
    },
    scatter: {
      itemStyle: {
        normal: {
          borderWidth: 0,
          borderColor: '#cccccc'
        },
        emphasis: {
          borderWidth: 0,
          borderColor: '#cccccc'
        }
      }
    },
    boxplot: {
      itemStyle: {
        normal: {
          borderWidth: 0,
          borderColor: '#cccccc'
        },
        emphasis: {
          borderWidth: 0,
          borderColor: '#cccccc'
        }
      }
    },
    parallel: {
      itemStyle: {
        normal: {
          borderWidth: 0,
          borderColor: '#cccccc'
        },
        emphasis: {
          borderWidth: 0,
          borderColor: '#cccccc'
        }
      }
    },
    sankey: {
      itemStyle: {
        normal: {
          borderWidth: 0,
          borderColor: '#cccccc'
        },
        emphasis: {
          borderWidth: 0,
          borderColor: '#cccccc'
        }
      }
    },
    funnel: {
      itemStyle: {
        normal: {
          borderWidth: 0,
          borderColor: '#cccccc'
        },
        emphasis: {
          borderWidth: 0,
          borderColor: '#cccccc'
        }
      }
    },
    gauge: {
      axisLine: {
        // 坐标轴线
        lineStyle: {
          // 属性lineStyle控制线条样式
          color: [[0.2, colorGroup[0]], [0.8, colorGroup[1]], [1, colorGroup[2]]]
        }
      },
      itemStyle: {
        normal: {
          borderWidth: 0,
          borderColor: '#cccccc'
        },
        emphasis: {
          borderWidth: 0,
          borderColor: '#cccccc'
        }
      }
    },
    candlestick: {
      itemStyle: {
        normal: {
          color: '#e6a0d2',
          color0: 'transparent',
          borderColor: '#e6a0d2',
          borderColor0: '#3fb1e3',
          borderWidth: '2'
        }
      }
    },
    graph: {
      itemStyle: {
        normal: {
          borderWidth: 0,
          borderColor: '#cccccc'
        }
      },
      lineStyle: {
        normal: {
          width: '1',
          color: '#cccccc'
        }
      },
      symbolSize: '8',
      symbol: 'emptyCircle',
      smooth: false,
      color: colorGroup,
      label: {
        normal: {
          textStyle: {
            color: '#ffffff'
          }
        }
      }
    },
    map: {
      itemStyle: {
        normal: {
          areaColor: '#eeeeee',
          borderColor: '#aaaaaa',
          borderWidth: 0.5
        },
        emphasis: {
          areaColor: 'rgba(63,177,227,0.25)',
          borderColor: '#3fb1e3',
          borderWidth: 1
        }
      },
      label: {
        normal: {
          textStyle: {
            color: '#ffffff'
          }
        },
        emphasis: {
          textStyle: {
            color: 'rgb(63,177,227)'
          }
        }
      }
    },
    geo: {
      itemStyle: {
        normal: {
          areaColor: '#eeeeee',
          borderColor: '#aaaaaa',
          borderWidth: 0.5
        },
        emphasis: {
          areaColor: 'rgba(63,177,227,0.25)',
          borderColor: '#3fb1e3',
          borderWidth: 1
        }
      },
      label: {
        normal: {
          textStyle: {
            color: '#ffffff'
          }
        },
        emphasis: {
          textStyle: {
            color: 'rgb(63,177,227)'
          }
        }
      }
    },
    categoryAxis: {
      axisLine: {
        show: true,
        lineStyle: {
          color: textColor
        }
      },
      axisTick: {
        show: true,
        lineStyle: {
          color: textColor
        }
      },
      axisLabel: {
        show: true,
        rotate: -45,
        interval: 'auto',
        textStyle: {
          color: textColor
        }
      },
      splitLine: {
        show: false,
        lineStyle: {
          color: ['#eeeeee']
        }
      },
      splitArea: {
        show: false,
        areaStyle: {
          color: ['rgba(250,250,250,0.05)', 'rgba(200,200,200,0.02)']
        }
      },
      nameTextStyle: {
        fontSize: 14
      }
    },
    valueAxis: {
      axisLine: {
        show: true,
        lineStyle: {
          color: textColor
        }
      },
      axisTick: {
        show: true,
        lineStyle: {
          color: textColor
        }
      },
      axisLabel: {
        show: true,
        rotate: 45,
        interval: 'auto',
        textStyle: {
          color: textColor
        }
      },
      splitLine: {
        show: false,
        lineStyle: {
          color: ['#eeeeee']
        }
      },
      splitArea: {
        show: true // 'areaStyle': {
        //   'color': [
        //     'rgba(237,237,236,1)',
        //     'rgba(252,252,251,1)'
        //   ]
        // }

      },
      nameTextStyle: {
        fontSize: 14
      }
    },
    logAxis: {
      axisLine: {
        show: true,
        lineStyle: {
          color: textColor
        }
      },
      axisTick: {
        show: false,
        lineStyle: {
          color: textColor
        }
      },
      axisLabel: {
        show: true,
        textStyle: {
          color: textColor
        }
      },
      splitLine: {
        show: true,
        lineStyle: {
          color: [textColor]
        }
      },
      splitArea: {
        show: false,
        areaStyle: {
          color: ['rgba(250,250,250,0.05)', 'rgba(200,200,200,0.02)']
        }
      }
    },
    timeAxis: {
      axisLine: {
        show: true,
        lineStyle: {
          color: textColor
        }
      },
      axisTick: {
        show: false,
        lineStyle: {
          color: textColor
        }
      },
      axisLabel: {
        show: true,
        textStyle: {
          color: textColor
        }
      },
      splitLine: {
        show: true,
        lineStyle: {
          color: [textColor]
        }
      },
      splitArea: {
        show: false,
        areaStyle: {
          color: ['rgba(250,250,250,0.05)', 'rgba(200,200,200,0.02)']
        }
      }
    },
    toolbox: {
      iconStyle: {
        normal: {
          borderColor: '#999999'
        },
        emphasis: {
          borderColor: '#666666'
        }
      }
    },
    legend: {
      textStyle: {
        color: textColor
      },
      pageTextStyle: {
        color: textColor
      }
    },
    tooltip: {
      axisPointer: {
        lineStyle: {
          color: '#cccccc',
          width: 1
        },
        crossStyle: {
          color: '#cccccc',
          width: 1
        }
      }
    },
    timeline: {
      lineStyle: {
        color: '#626c91',
        width: 1
      },
      itemStyle: {
        normal: {
          color: '#626c91',
          borderWidth: 1
        },
        emphasis: {
          color: '#626c91'
        }
      },
      controlStyle: {
        normal: {
          color: '#626c91',
          borderColor: '#626c91',
          borderWidth: 0.5
        },
        emphasis: {
          color: '#626c91',
          borderColor: '#626c91',
          borderWidth: 0.5
        }
      },
      checkpointStyle: {
        color: '#3fb1e3',
        borderColor: 'rgba(63,177,227,0.15)'
      },
      label: {
        normal: {
          textStyle: {
            color: '#626c91'
          }
        },
        emphasis: {
          textStyle: {
            color: '#626c91'
          }
        }
      }
    },
    visualMap: {
      color: colorGroup
    },
    dataZoom: {
      backgroundColor: 'rgba(255,255,255,0)',
      dataBackgroundColor: 'rgba(222,222,222,1)',
      fillerColor: 'rgba(114,230,212,0.25)',
      handleColor: '#cccccc',
      handleSize: '100%',
      textStyle: {
        color: textColor
      }
    },
    markPoint: {
      label: {
        normal: {
          textStyle: {
            color: textColor
          }
        },
        emphasis: {
          textStyle: {
            color: textColor
          }
        }
      }
    }
  };
  return chartTheme;
};

exports.chartThemeUtil = chartThemeUtil;

/***/ }),

/***/ "h9Sk":
/***/ (function(module, exports, __webpack_require__) {

module.exports = {
    ResizeSensor: __webpack_require__("KtZj"),
    ElementQueries: __webpack_require__("rnKy")
};


/***/ }),

/***/ "hB31":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__("TqRt");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _classCallCheck2 = _interopRequireDefault(__webpack_require__("lwsE"));

var _createClass2 = _interopRequireDefault(__webpack_require__("W8MJ"));

var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__("a1gu"));

var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__("Nsbk"));

var _inherits2 = _interopRequireDefault(__webpack_require__("7W2i"));

var _typeof2 = _interopRequireDefault(__webpack_require__("cDf5"));

var _WebMapViewModel = _interopRequireDefault(__webpack_require__("0F1z"));

var _vmUpdater = _interopRequireDefault(__webpack_require__("w286"));

var _mapEvent = _interopRequireDefault(__webpack_require__("Whz7"));

var _vuePropertyDecorator = __webpack_require__("YKMj");

var _resizeDetector = __webpack_require__("QG5D");

var _debounce = _interopRequireDefault(__webpack_require__("sEfC"));

var _mapEvents = _interopRequireDefault(__webpack_require__("0zgg"));

var __decorate = void 0 && (void 0).__decorate || function (decorators, target, key, desc) {
  var c = arguments.length,
      r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
      d;
  if ((typeof Reflect === "undefined" ? "undefined" : (0, _typeof2.default)(Reflect)) === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);else for (var i = decorators.length - 1; i >= 0; i--) {
    if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
  }
  return c > 3 && r && Object.defineProperty(target, key, r), r;
};

var SmWebMap =
/*#__PURE__*/
function (_Mixins) {
  (0, _inherits2.default)(SmWebMap, _Mixins);

  function SmWebMap() {
    var _this;

    (0, _classCallCheck2.default)(this, SmWebMap);
    _this = (0, _possibleConstructorReturn2.default)(this, (0, _getPrototypeOf2.default)(SmWebMap).apply(this, arguments));
    _this.spinning = true;
    _this.ready = false;
    return _this;
  }

  (0, _createClass2.default)(SmWebMap, [{
    key: "mapIdChanged",
    value: function mapIdChanged() {
      this.spinning = true;
    }
  }, {
    key: "mounted",
    value: function mounted() {
      this.initializeWebMap();
      this.registerEvents();
    }
  }, {
    key: "beforeDestroy",
    value: function beforeDestroy() {
      this.destory();

      _mapEvent.default.$options.deleteMap(this.target);

      _mapEvent.default.$options.deleteWebMap(this.target);
    }
  }, {
    key: "load",
    value: function load(value) {
      return value;
    }
  }, {
    key: "getMapFailed",
    value: function getMapFailed(value) {
      return value;
    }
  }, {
    key: "getLayerDatasourceFailed",
    value: function getLayerDatasourceFailed(value) {
      return value;
    }
  }, {
    key: "initializeWebMap",
    value: function initializeWebMap() {
      var _this2 = this;

      var _this$$props = this.$props,
          target = _this$$props.target,
          serverUrl = _this$$props.serverUrl,
          accessToken = _this$$props.accessToken,
          accessKey = _this$$props.accessKey,
          tiandituKey = _this$$props.tiandituKey,
          withCredentials = _this$$props.withCredentials,
          excludePortalProxyUrl = _this$$props.excludePortalProxyUrl,
          isSuperMapOnline = _this$$props.isSuperMapOnline,
          mapOptions = _this$$props.mapOptions;
      this.viewModel = new _WebMapViewModel.default(this.mapId, {
        target: target,
        serverUrl: serverUrl,
        accessToken: accessToken,
        accessKey: accessKey,
        tiandituKey: tiandituKey,
        withCredentials: withCredentials,
        excludePortalProxyUrl: excludePortalProxyUrl,
        isSuperMapOnline: isSuperMapOnline
      }, mapOptions);

      if (this.autoresize) {
        this.__resizeHandler = (0, _debounce.default)(function () {
          _this2.resize();
        }, 100, {
          leading: true
        });
        (0, _resizeDetector.addListener)(this.$el, this.__resizeHandler);
      }
    }
  }, {
    key: "resize",
    value: function resize() {
      var _this3 = this;

      if (this.viewModel && this.viewModel.resize) {
        this.$nextTick(function () {
          _this3.viewModel.resize();
        });
      }
    }
  }, {
    key: "registerEvents",
    value: function registerEvents() {
      var _this4 = this;

      this.viewModel.on({
        addlayerssucceeded: function addlayerssucceeded(e) {
          _this4.spinning = false;

          _mapEvent.default.$options.setMap(_this4.target, e.map);

          _this4.viewModel && _mapEvent.default.$options.setWebMap(_this4.target, _this4.viewModel);

          _mapEvent.default.$emit('load-map', e.map, _this4.target);

          _this4.map = e.map;
          _this4.mapObject = e.map;
          _this4.ready = true;

          _this4.$nextTick(function () {
            _this4.viewModel.resize();
          });

          _this4.bindMapEvents();

          _this4.load({
            map: e.map
          });
        },
        getmapinfofailed: function getmapinfofailed(e) {
          _this4.getMapFailed({
            error: e.error
          });

          _this4.$message.error(e.error.message);

          _this4.spinning = false;
        },
        getlayerdatasourcefailed: function getlayerdatasourcefailed(e) {
          _this4.getLayerDatasourceFailed({
            error: e.error,
            layer: e.layer,
            map: e.map
          });

          if (e.error === 'SAMPLE DATA is not supported') {
            _this4.$message.error(_this4.$t('webmap.sampleDataNotSupport'));
          } else {
            _this4.$message.error(_this4.$t('webmap.getLayerInfoFailed'));
          }
        },
        notsupportmvt: function notsupportmvt() {
          _this4.$message.error('暂不支持加载矢量瓦片图层！');

          _this4.spinning = false;
        }
      });
    }
  }, {
    key: "destory",
    value: function destory() {
      if (this.autoresize) {
        (0, _resizeDetector.removeListener)(this.$el, this.__resizeHandler);
      }
    }
  }, {
    key: "getMapTarget",
    get: function get() {
      return this.target;
    }
  }]);
  return SmWebMap;
}((0, _vuePropertyDecorator.Mixins)(_vmUpdater.default, _mapEvents.default));

__decorate([(0, _vuePropertyDecorator.Provide)()], SmWebMap.prototype, "__resizeHandler", void 0);

__decorate([(0, _vuePropertyDecorator.Provide)()], SmWebMap.prototype, "ready", void 0);

__decorate([(0, _vuePropertyDecorator.Prop)()], SmWebMap.prototype, "mapId", void 0);

__decorate([(0, _vuePropertyDecorator.Prop)({
  default: 'map'
})], SmWebMap.prototype, "target", void 0);

__decorate([(0, _vuePropertyDecorator.Prop)({
  default: 'https://www.supermapol.com'
})], SmWebMap.prototype, "serverUrl", void 0);

__decorate([(0, _vuePropertyDecorator.Prop)()], SmWebMap.prototype, "accessToken", void 0);

__decorate([(0, _vuePropertyDecorator.Prop)()], SmWebMap.prototype, "accessKey", void 0);

__decorate([(0, _vuePropertyDecorator.Prop)()], SmWebMap.prototype, "tiandituKey", void 0);

__decorate([(0, _vuePropertyDecorator.Prop)({
  default: false
})], SmWebMap.prototype, "withCredentials", void 0);

__decorate([(0, _vuePropertyDecorator.Prop)()], SmWebMap.prototype, "excludePortalProxyUrl", void 0);

__decorate([(0, _vuePropertyDecorator.Prop)()], SmWebMap.prototype, "isSuperMapOnline", void 0);

__decorate([(0, _vuePropertyDecorator.Prop)()], SmWebMap.prototype, "mapOptions", void 0);

__decorate([(0, _vuePropertyDecorator.Prop)({
  default: true
})], SmWebMap.prototype, "autoresize", void 0);

__decorate([(0, _vuePropertyDecorator.Watch)('mapId')], SmWebMap.prototype, "mapIdChanged", null);

__decorate([(0, _vuePropertyDecorator.Emit)()], SmWebMap.prototype, "load", null);

__decorate([(0, _vuePropertyDecorator.Emit)()], SmWebMap.prototype, "getMapFailed", null);

__decorate([(0, _vuePropertyDecorator.Emit)()], SmWebMap.prototype, "getLayerDatasourceFailed", null);

SmWebMap = __decorate([(0, _vuePropertyDecorator.Component)({
  name: 'SmWebMap',
  viewModelProps: ['mapId', 'serverUrl', 'mapOptions.center', 'mapOptions.zoom', 'mapOptions.minZoom', 'mapOptions.maxZoom', 'mapOptions.maxBounds', 'withCredentials']
})], SmWebMap);
var _default = SmWebMap;
exports.default = _default;

/***/ }),

/***/ "hE+I":
/***/ (function(module, exports, __webpack_require__) {

var sax = __webpack_require__("MXF5");
var expat /*= require('node-expat');*/ = { on: function () { }, parse: function () { } };
var helper = __webpack_require__("lsHq");
var isArray = __webpack_require__("mxIc").isArray;

var options;
var pureJsParser = true;
var currentElement;

function validateOptions(userOptions) {
  options = helper.copyOptions(userOptions);
  helper.ensureFlagExists('ignoreDeclaration', options);
  helper.ensureFlagExists('ignoreInstruction', options);
  helper.ensureFlagExists('ignoreAttributes', options);
  helper.ensureFlagExists('ignoreText', options);
  helper.ensureFlagExists('ignoreComment', options);
  helper.ensureFlagExists('ignoreCdata', options);
  helper.ensureFlagExists('ignoreDoctype', options);
  helper.ensureFlagExists('compact', options);
  helper.ensureFlagExists('alwaysChildren', options);
  helper.ensureFlagExists('addParent', options);
  helper.ensureFlagExists('trim', options);
  helper.ensureFlagExists('nativeType', options);
  helper.ensureFlagExists('nativeTypeAttributes', options);
  helper.ensureFlagExists('sanitize', options);
  helper.ensureFlagExists('instructionHasAttributes', options);
  helper.ensureFlagExists('captureSpacesBetweenElements', options);
  helper.ensureAlwaysArrayExists(options);
  helper.ensureKeyExists('declaration', options);
  helper.ensureKeyExists('instruction', options);
  helper.ensureKeyExists('attributes', options);
  helper.ensureKeyExists('text', options);
  helper.ensureKeyExists('comment', options);
  helper.ensureKeyExists('cdata', options);
  helper.ensureKeyExists('doctype', options);
  helper.ensureKeyExists('type', options);
  helper.ensureKeyExists('name', options);
  helper.ensureKeyExists('elements', options);
  helper.ensureKeyExists('parent', options);
  helper.checkFnExists('doctype', options);
  helper.checkFnExists('instruction', options);
  helper.checkFnExists('cdata', options);
  helper.checkFnExists('comment', options);
  helper.checkFnExists('text', options);
  helper.checkFnExists('instructionName', options);
  helper.checkFnExists('elementName', options);
  helper.checkFnExists('attributeName', options);
  helper.checkFnExists('attributeValue', options);
  helper.checkFnExists('attributes', options);
  return options;
}

function nativeType(value) {
  var nValue = Number(value);
  if (!isNaN(nValue)) {
    return nValue;
  }
  var bValue = value.toLowerCase();
  if (bValue === 'true') {
    return true;
  } else if (bValue === 'false') {
    return false;
  }
  return value;
}

function addField(type, value) {
  var key;
  if (options.compact) {
    if (
      !currentElement[options[type + 'Key']] &&
      (isArray(options.alwaysArray) ? options.alwaysArray.indexOf(options[type + 'Key']) !== -1 : options.alwaysArray)
    ) {
      currentElement[options[type + 'Key']] = [];
    }
    if (currentElement[options[type + 'Key']] && !isArray(currentElement[options[type + 'Key']])) {
      currentElement[options[type + 'Key']] = [currentElement[options[type + 'Key']]];
    }
    if (type + 'Fn' in options && typeof value === 'string') {
      value = options[type + 'Fn'](value, currentElement);
    }
    if (type === 'instruction' && ('instructionFn' in options || 'instructionNameFn' in options)) {
      for (key in value) {
        if (value.hasOwnProperty(key)) {
          if ('instructionFn' in options) {
            value[key] = options.instructionFn(value[key], key, currentElement);
          } else {
            var temp = value[key];
            delete value[key];
            value[options.instructionNameFn(key, temp, currentElement)] = temp;
          }
        }
      }
    }
    if (isArray(currentElement[options[type + 'Key']])) {
      currentElement[options[type + 'Key']].push(value);
    } else {
      currentElement[options[type + 'Key']] = value;
    }
  } else {
    if (!currentElement[options.elementsKey]) {
      currentElement[options.elementsKey] = [];
    }
    var element = {};
    element[options.typeKey] = type;
    if (type === 'instruction') {
      for (key in value) {
        if (value.hasOwnProperty(key)) {
          break;
        }
      }
      element[options.nameKey] = 'instructionNameFn' in options ? options.instructionNameFn(key, value, currentElement) : key;
      if (options.instructionHasAttributes) {
        element[options.attributesKey] = value[key][options.attributesKey];
        if ('instructionFn' in options) {
          element[options.attributesKey] = options.instructionFn(element[options.attributesKey], key, currentElement);
        }
      } else {
        if ('instructionFn' in options) {
          value[key] = options.instructionFn(value[key], key, currentElement);
        }
        element[options.instructionKey] = value[key];
      }
    } else {
      if (type + 'Fn' in options) {
        value = options[type + 'Fn'](value, currentElement);
      }
      element[options[type + 'Key']] = value;
    }
    if (options.addParent) {
      element[options.parentKey] = currentElement;
    }
    currentElement[options.elementsKey].push(element);
  }
}

function manipulateAttributes(attributes) {
  if ('attributesFn' in options && attributes) {
    attributes = options.attributesFn(attributes, currentElement);
  }
  if ((options.trim || 'attributeValueFn' in options || 'attributeNameFn' in options || options.nativeTypeAttributes) && attributes) {
    var key;
    for (key in attributes) {
      if (attributes.hasOwnProperty(key)) {
        if (options.trim) attributes[key] = attributes[key].trim();
        if (options.nativeTypeAttributes) {
          attributes[key] = nativeType(attributes[key]);
        }
        if ('attributeValueFn' in options) attributes[key] = options.attributeValueFn(attributes[key], key, currentElement);
        if ('attributeNameFn' in options) {
          var temp = attributes[key];
          delete attributes[key];
          attributes[options.attributeNameFn(key, attributes[key], currentElement)] = temp;
        }
      }
    }
  }
  return attributes;
}

function onInstruction(instruction) {
  var attributes = {};
  if (instruction.body && (instruction.name.toLowerCase() === 'xml' || options.instructionHasAttributes)) {
    var attrsRegExp = /([\w:-]+)\s*=\s*(?:"([^"]*)"|'([^']*)'|(\w+))\s*/g;
    var match;
    while ((match = attrsRegExp.exec(instruction.body)) !== null) {
      attributes[match[1]] = match[2] || match[3] || match[4];
    }
    attributes = manipulateAttributes(attributes);
  }
  if (instruction.name.toLowerCase() === 'xml') {
    if (options.ignoreDeclaration) {
      return;
    }
    currentElement[options.declarationKey] = {};
    if (Object.keys(attributes).length) {
      currentElement[options.declarationKey][options.attributesKey] = attributes;
    }
    if (options.addParent) {
      currentElement[options.declarationKey][options.parentKey] = currentElement;
    }
  } else {
    if (options.ignoreInstruction) {
      return;
    }
    if (options.trim) {
      instruction.body = instruction.body.trim();
    }
    var value = {};
    if (options.instructionHasAttributes && Object.keys(attributes).length) {
      value[instruction.name] = {};
      value[instruction.name][options.attributesKey] = attributes;
    } else {
      value[instruction.name] = instruction.body;
    }
    addField('instruction', value);
  }
}

function onStartElement(name, attributes) {
  var element;
  if (typeof name === 'object') {
    attributes = name.attributes;
    name = name.name;
  }
  attributes = manipulateAttributes(attributes);
  if ('elementNameFn' in options) {
    name = options.elementNameFn(name, currentElement);
  }
  if (options.compact) {
    element = {};
    if (!options.ignoreAttributes && attributes && Object.keys(attributes).length) {
      element[options.attributesKey] = {};
      var key;
      for (key in attributes) {
        if (attributes.hasOwnProperty(key)) {
          element[options.attributesKey][key] = attributes[key];
        }
      }
    }
    if (
      !(name in currentElement) &&
      (isArray(options.alwaysArray) ? options.alwaysArray.indexOf(name) !== -1 : options.alwaysArray)
    ) {
      currentElement[name] = [];
    }
    if (currentElement[name] && !isArray(currentElement[name])) {
      currentElement[name] = [currentElement[name]];
    }
    if (isArray(currentElement[name])) {
      currentElement[name].push(element);
    } else {
      currentElement[name] = element;
    }
  } else {
    if (!currentElement[options.elementsKey]) {
      currentElement[options.elementsKey] = [];
    }
    element = {};
    element[options.typeKey] = 'element';
    element[options.nameKey] = name;
    if (!options.ignoreAttributes && attributes && Object.keys(attributes).length) {
      element[options.attributesKey] = attributes;
    }
    if (options.alwaysChildren) {
      element[options.elementsKey] = [];
    }
    currentElement[options.elementsKey].push(element);
  }
  element[options.parentKey] = currentElement; // will be deleted in onEndElement() if !options.addParent
  currentElement = element;
}

function onText(text) {
  if (options.ignoreText) {
    return;
  }
  if (!text.trim() && !options.captureSpacesBetweenElements) {
    return;
  }
  if (options.trim) {
    text = text.trim();
  }
  if (options.nativeType) {
    text = nativeType(text);
  }
  if (options.sanitize) {
    text = text.replace(/&/g, '&amp;').replace(/</g, '&lt;').replace(/>/g, '&gt;');
  }
  addField('text', text);
}

function onComment(comment) {
  if (options.ignoreComment) {
    return;
  }
  if (options.trim) {
    comment = comment.trim();
  }
  addField('comment', comment);
}

function onEndElement(name) {
  var parentElement = currentElement[options.parentKey];
  if (!options.addParent) {
    delete currentElement[options.parentKey];
  }
  currentElement = parentElement;
}

function onCdata(cdata) {
  if (options.ignoreCdata) {
    return;
  }
  if (options.trim) {
    cdata = cdata.trim();
  }
  addField('cdata', cdata);
}

function onDoctype(doctype) {
  if (options.ignoreDoctype) {
    return;
  }
  doctype = doctype.replace(/^ /, '');
  if (options.trim) {
    doctype = doctype.trim();
  }
  addField('doctype', doctype);
}

function onError(error) {
  error.note = error; //console.error(error);
}

module.exports = function (xml, userOptions) {

  var parser = pureJsParser ? sax.parser(true, {}) : parser = new expat.Parser('UTF-8');
  var result = {};
  currentElement = result;

  options = validateOptions(userOptions);

  if (pureJsParser) {
    parser.opt = {strictEntities: true};
    parser.onopentag = onStartElement;
    parser.ontext = onText;
    parser.oncomment = onComment;
    parser.onclosetag = onEndElement;
    parser.onerror = onError;
    parser.oncdata = onCdata;
    parser.ondoctype = onDoctype;
    parser.onprocessinginstruction = onInstruction;
  } else {
    parser.on('startElement', onStartElement);
    parser.on('text', onText);
    parser.on('comment', onComment);
    parser.on('endElement', onEndElement);
    parser.on('error', onError);
    //parser.on('startCdata', onStartCdata);
    //parser.on('endCdata', onEndCdata);
    //parser.on('entityDecl', onEntityDecl);
  }

  if (pureJsParser) {
    parser.write(xml).close();
  } else {
    if (!parser.parse(xml)) {
      throw new Error('XML parsing error: ' + parser.getError());
    }
  }

  if (result[options.elementsKey]) {
    var temp = result[options.elementsKey];
    delete result[options.elementsKey];
    result[options.elementsKey] = temp;
    delete result.text;
  }

  return result;

};


/***/ }),

/***/ "hQXD":
/***/ (function(module, exports) {

module.exports = __WEBPACK_EXTERNAL_MODULE_hQXD__;

/***/ }),

/***/ "hS5c":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.propsBinder = exports.capitalizeFirstLetter = void 0;

var capitalizeFirstLetter = function capitalizeFirstLetter(string) {
  if (!string || typeof string.charAt !== 'function') {
    return string;
  }

  return string.charAt(0).toUpperCase() + string.slice(1);
};

exports.capitalizeFirstLetter = capitalizeFirstLetter;

var propsBinder = function propsBinder(vueElement, props) {
  var _loop = function _loop(key) {
    var setMethodName = 'set' + capitalizeFirstLetter(key);

    if (vueElement[setMethodName]) {
      vueElement.$watch(key, function (newVal) {
        vueElement[setMethodName](newVal);
      }, {
        deep: true
      });
    }
  };

  for (var key in props) {
    _loop(key);
  }
};

exports.propsBinder = propsBinder;

/***/ }),

/***/ "hgx0":
/***/ (function(module, exports) {

module.exports = __WEBPACK_EXTERNAL_MODULE_hgx0__;

/***/ }),

/***/ "hwdV":
/***/ (function(module, exports, __webpack_require__) {

/* eslint-disable node/no-deprecated-api */
var buffer = __webpack_require__("tjlA")
var Buffer = buffer.Buffer

// alternative to using Object.keys for old browsers
function copyProps (src, dst) {
  for (var key in src) {
    dst[key] = src[key]
  }
}
if (Buffer.from && Buffer.alloc && Buffer.allocUnsafe && Buffer.allocUnsafeSlow) {
  module.exports = buffer
} else {
  // Copy properties from require('buffer')
  copyProps(buffer, exports)
  exports.Buffer = SafeBuffer
}

function SafeBuffer (arg, encodingOrOffset, length) {
  return Buffer(arg, encodingOrOffset, length)
}

// Copy static methods from Buffer
copyProps(Buffer, SafeBuffer)

SafeBuffer.from = function (arg, encodingOrOffset, length) {
  if (typeof arg === 'number') {
    throw new TypeError('Argument must not be a number')
  }
  return Buffer(arg, encodingOrOffset, length)
}

SafeBuffer.alloc = function (size, fill, encoding) {
  if (typeof size !== 'number') {
    throw new TypeError('Argument must be a number')
  }
  var buf = Buffer(size)
  if (fill !== undefined) {
    if (typeof encoding === 'string') {
      buf.fill(fill, encoding)
    } else {
      buf.fill(fill)
    }
  } else {
    buf.fill(0)
  }
  return buf
}

SafeBuffer.allocUnsafe = function (size) {
  if (typeof size !== 'number') {
    throw new TypeError('Argument must be a number')
  }
  return Buffer(size)
}

SafeBuffer.allocUnsafeSlow = function (size) {
  if (typeof size !== 'number') {
    throw new TypeError('Argument must be a number')
  }
  return buffer.SlowBuffer(size)
}


/***/ }),

/***/ "hzAs":
/***/ (function(module) {

module.exports = JSON.parse("{\"EPSG:2000\":\"PROJCS[\\\"Anguilla 1957 / British West Indies Grid\\\",GEOGCS[\\\"Anguilla 1957\\\",DATUM[\\\"Anguilla_1957\\\",SPHEROID[\\\"Clarke 1880 (RGS)\\\",6378249.145,293.465,AUTHORITY[\\\"EPSG\\\",\\\"7012\\\"]],AUTHORITY[\\\"EPSG\\\",\\\"6600\\\"]],PRIMEM[\\\"Greenwich\\\",0,AUTHORITY[\\\"EPSG\\\",\\\"8901\\\"]],UNIT[\\\"degree\\\",0.0174532925199433,AUTHORITY[\\\"EPSG\\\",\\\"9122\\\"]],AUTHORITY[\\\"EPSG\\\",\\\"4600\\\"]],PROJECTION[\\\"Transverse_Mercator\\\"],PARAMETER[\\\"latitude_of_origin\\\",0],PARAMETER[\\\"central_meridian\\\",-62],PARAMETER[\\\"scale_factor\\\",0.9995],PARAMETER[\\\"false_easting\\\",400000],PARAMETER[\\\"false_northing\\\",0],UNIT[\\\"metre\\\",1,AUTHORITY[\\\"EPSG\\\",\\\"9001\\\"]],AXIS[\\\"Easting\\\",EAST],AXIS[\\\"Northing\\\",NORTH],AUTHORITY[\\\"EPSG\\\",\\\"2000\\\"]]\",\"EPSG:2001\":\"PROJCS[\\\"Antigua 1943 / British West Indies Grid\\\",GEOGCS[\\\"Antigua 1943\\\",DATUM[\\\"Antigua_1943\\\",SPHEROID[\\\"Clarke 1880 (RGS)\\\",6378249.145,293.465,AUTHORITY[\\\"EPSG\\\",\\\"7012\\\"]],TOWGS84[-255,-15,71,0,0,0,0],AUTHORITY[\\\"EPSG\\\",\\\"6601\\\"]],PRIMEM[\\\"Greenwich\\\",0,AUTHORITY[\\\"EPSG\\\",\\\"8901\\\"]],UNIT[\\\"degree\\\",0.0174532925199433,AUTHORITY[\\\"EPSG\\\",\\\"9122\\\"]],AUTHORITY[\\\"EPSG\\\",\\\"4601\\\"]],PROJECTION[\\\"Transverse_Mercator\\\"],PARAMETER[\\\"latitude_of_origin\\\",0],PARAMETER[\\\"central_meridian\\\",-62],PARAMETER[\\\"scale_factor\\\",0.9995],PARAMETER[\\\"false_easting\\\",400000],PARAMETER[\\\"false_northing\\\",0],UNIT[\\\"metre\\\",1,AUTHORITY[\\\"EPSG\\\",\\\"9001\\\"]],AXIS[\\\"Easting\\\",EAST],AXIS[\\\"Northing\\\",NORTH],AUTHORITY[\\\"EPSG\\\",\\\"2001\\\"]]\",\"EPSG:2002\":\"PROJCS[\\\"Dominica 1945 / British West Indies Grid\\\",GEOGCS[\\\"Dominica 1945\\\",DATUM[\\\"Dominica_1945\\\",SPHEROID[\\\"Clarke 1880 (RGS)\\\",6378249.145,293.465,AUTHORITY[\\\"EPSG\\\",\\\"7012\\\"]],TOWGS84[725,685,536,0,0,0,0],AUTHORITY[\\\"EPSG\\\",\\\"6602\\\"]],PRIMEM[\\\"Greenwich\\\",0,AUTHORITY[\\\"EPSG\\\",\\\"8901\\\"]],UNIT[\\\"degree\\\",0.0174532925199433,AUTHORITY[\\\"EPSG\\\",\\\"9122\\\"]],AUTHORITY[\\\"EPSG\\\",\\\"4602\\\"]],PROJECTION[\\\"Transverse_Mercator\\\"],PARAMETER[\\\"latitude_of_origin\\\",0],PARAMETER[\\\"central_meridian\\\",-62],PARAMETER[\\\"scale_factor\\\",0.9995],PARAMETER[\\\"false_easting\\\",400000],PARAMETER[\\\"false_northing\\\",0],UNIT[\\\"metre\\\",1,AUTHORITY[\\\"EPSG\\\",\\\"9001\\\"]],AXIS[\\\"Easting\\\",EAST],AXIS[\\\"Northing\\\",NORTH],AUTHORITY[\\\"EPSG\\\",\\\"2002\\\"]]\",\"EPSG:2003\":\"PROJCS[\\\"Grenada 1953 / British West Indies Grid\\\",GEOGCS[\\\"Grenada 1953\\\",DATUM[\\\"Grenada_1953\\\",SPHEROID[\\\"Clarke 1880 (RGS)\\\",6378249.145,293.465,AUTHORITY[\\\"EPSG\\\",\\\"7012\\\"]],TOWGS84[72,213.7,93,0,0,0,0],AUTHORITY[\\\"EPSG\\\",\\\"6603\\\"]],PRIMEM[\\\"Greenwich\\\",0,AUTHORITY[\\\"EPSG\\\",\\\"8901\\\"]],UNIT[\\\"degree\\\",0.0174532925199433,AUTHORITY[\\\"EPSG\\\",\\\"9122\\\"]],AUTHORITY[\\\"EPSG\\\",\\\"4603\\\"]],PROJECTION[\\\"Transverse_Mercator\\\"],PARAMETER[\\\"latitude_of_origin\\\",0],PARAMETER[\\\"central_meridian\\\",-62],PARAMETER[\\\"scale_factor\\\",0.9995],PARAMETER[\\\"false_easting\\\",400000],PARAMETER[\\\"false_northing\\\",0],UNIT[\\\"metre\\\",1,AUTHORITY[\\\"EPSG\\\",\\\"9001\\\"]],AXIS[\\\"Easting\\\",EAST],AXIS[\\\"Northing\\\",NORTH],AUTHORITY[\\\"EPSG\\\",\\\"2003\\\"]]\",\"EPSG:2004\":\"PROJCS[\\\"Montserrat 1958 / British West Indies Grid\\\",GEOGCS[\\\"Montserrat 1958\\\",DATUM[\\\"Montserrat_1958\\\",SPHEROID[\\\"Clarke 1880 (RGS)\\\",6378249.145,293.465,AUTHORITY[\\\"EPSG\\\",\\\"7012\\\"]],TOWGS84[174,359,365,0,0,0,0],AUTHORITY[\\\"EPSG\\\",\\\"6604\\\"]],PRIMEM[\\\"Greenwich\\\",0,AUTHORITY[\\\"EPSG\\\",\\\"8901\\\"]],UNIT[\\\"degree\\\",0.0174532925199433,AUTHORITY[\\\"EPSG\\\",\\\"9122\\\"]],AUTHORITY[\\\"EPSG\\\",\\\"4604\\\"]],PROJECTION[\\\"Transverse_Mercator\\\"],PARAMETER[\\\"latitude_of_origin\\\",0],PARAMETER[\\\"central_meridian\\\",-62],PARAMETER[\\\"scale_factor\\\",0.9995],PARAMETER[\\\"false_easting\\\",400000],PARAMETER[\\\"false_northing\\\",0],UNIT[\\\"metre\\\",1,AUTHORITY[\\\"EPSG\\\",\\\"9001\\\"]],AXIS[\\\"Easting\\\",EAST],AXIS[\\\"Northing\\\",NORTH],AUTHORITY[\\\"EPSG\\\",\\\"2004\\\"]]\",\"EPSG:2005\":\"PROJCS[\\\"St. Kitts 1955 / British West Indies Grid\\\",GEOGCS[\\\"St. Kitts 1955\\\",DATUM[\\\"St_Kitts_1955\\\",SPHEROID[\\\"Clarke 1880 (RGS)\\\",6378249.145,293.465,AUTHORITY[\\\"EPSG\\\",\\\"7012\\\"]],TOWGS84[9,183,236,0,0,0,0],AUTHORITY[\\\"EPSG\\\",\\\"6605\\\"]],PRIMEM[\\\"Greenwich\\\",0,AUTHORITY[\\\"EPSG\\\",\\\"8901\\\"]],UNIT[\\\"degree\\\",0.0174532925199433,AUTHORITY[\\\"EPSG\\\",\\\"9122\\\"]],AUTHORITY[\\\"EPSG\\\",\\\"4605\\\"]],PROJECTION[\\\"Transverse_Mercator\\\"],PARAMETER[\\\"latitude_of_origin\\\",0],PARAMETER[\\\"central_meridian\\\",-62],PARAMETER[\\\"scale_factor\\\",0.9995],PARAMETER[\\\"false_easting\\\",400000],PARAMETER[\\\"false_northing\\\",0],UNIT[\\\"metre\\\",1,AUTHORITY[\\\"EPSG\\\",\\\"9001\\\"]],AXIS[\\\"Easting\\\",EAST],AXIS[\\\"Northing\\\",NORTH],AUTHORITY[\\\"EPSG\\\",\\\"2005\\\"]]\",\"EPSG:2006\":\"PROJCS[\\\"St. Lucia 1955 / British West Indies Grid\\\",GEOGCS[\\\"St. Lucia 1955\\\",DATUM[\\\"St_Lucia_1955\\\",SPHEROID[\\\"Clarke 1880 (RGS)\\\",6378249.145,293.465,AUTHORITY[\\\"EPSG\\\",\\\"7012\\\"]],TOWGS84[-149,128,296,0,0,0,0],AUTHORITY[\\\"EPSG\\\",\\\"6606\\\"]],PRIMEM[\\\"Greenwich\\\",0,AUTHORITY[\\\"EPSG\\\",\\\"8901\\\"]],UNIT[\\\"degree\\\",0.0174532925199433,AUTHORITY[\\\"EPSG\\\",\\\"9122\\\"]],AUTHORITY[\\\"EPSG\\\",\\\"4606\\\"]],PROJECTION[\\\"Transverse_Mercator\\\"],PARAMETER[\\\"latitude_of_origin\\\",0],PARAMETER[\\\"central_meridian\\\",-62],PARAMETER[\\\"scale_factor\\\",0.9995],PARAMETER[\\\"false_easting\\\",400000],PARAMETER[\\\"false_northing\\\",0],UNIT[\\\"metre\\\",1,AUTHORITY[\\\"EPSG\\\",\\\"9001\\\"]],AXIS[\\\"Easting\\\",EAST],AXIS[\\\"Northing\\\",NORTH],AUTHORITY[\\\"EPSG\\\",\\\"2006\\\"]]\",\"EPSG:2007\":\"PROJCS[\\\"St. Vincent 45 / British West Indies Grid\\\",GEOGCS[\\\"St. Vincent 1945\\\",DATUM[\\\"St_Vincent_1945\\\",SPHEROID[\\\"Clarke 1880 (RGS)\\\",6378249.145,293.465,AUTHORITY[\\\"EPSG\\\",\\\"7012\\\"]],TOWGS84[195.671,332.517,274.607,0,0,0,0],AUTHORITY[\\\"EPSG\\\",\\\"6607\\\"]],PRIMEM[\\\"Greenwich\\\",0,AUTHORITY[\\\"EPSG\\\",\\\"8901\\\"]],UNIT[\\\"degree\\\",0.0174532925199433,AUTHORITY[\\\"EPSG\\\",\\\"9122\\\"]],AUTHORITY[\\\"EPSG\\\",\\\"4607\\\"]],PROJECTION[\\\"Transverse_Mercator\\\"],PARAMETER[\\\"latitude_of_origin\\\",0],PARAMETER[\\\"central_meridian\\\",-62],PARAMETER[\\\"scale_factor\\\",0.9995],PARAMETER[\\\"false_easting\\\",400000],PARAMETER[\\\"false_northing\\\",0],UNIT[\\\"metre\\\",1,AUTHORITY[\\\"EPSG\\\",\\\"9001\\\"]],AXIS[\\\"Easting\\\",EAST],AXIS[\\\"Northing\\\",NORTH],AUTHORITY[\\\"EPSG\\\",\\\"2007\\\"]]\",\"EPSG:2009\":\"PROJCS[\\\"NAD27(CGQ77) / SCoPQ zone 3\\\",GEOGCS[\\\"NAD27(CGQ77)\\\",DATUM[\\\"North_American_Datum_1927_CGQ77\\\",SPHEROID[\\\"Clarke 1866\\\",6378206.4,294.9786982139006,AUTHORITY[\\\"EPSG\\\",\\\"7008\\\"]],AUTHORITY[\\\"EPSG\\\",\\\"6609\\\"]],PRIMEM[\\\"Greenwich\\\",0,AUTHORITY[\\\"EPSG\\\",\\\"8901\\\"]],UNIT[\\\"degree\\\",0.0174532925199433,AUTHORITY[\\\"EPSG\\\",\\\"9122\\\"]],AUTHORITY[\\\"EPSG\\\",\\\"4609\\\"]],PROJECTION[\\\"Transverse_Mercator\\\"],PARAMETER[\\\"latitude_of_origin\\\",0],PARAMETER[\\\"central_meridian\\\",-58.5],PARAMETER[\\\"scale_factor\\\",0.9999],PARAMETER[\\\"false_easting\\\",304800],PARAMETER[\\\"false_northing\\\",0],UNIT[\\\"metre\\\",1,AUTHORITY[\\\"EPSG\\\",\\\"9001\\\"]],AXIS[\\\"X\\\",EAST],AXIS[\\\"Y\\\",NORTH],AUTHORITY[\\\"EPSG\\\",\\\"2009\\\"]]\",\"EPSG:2010\":\"PROJCS[\\\"NAD27(CGQ77) / SCoPQ zone 4\\\",GEOGCS[\\\"NAD27(CGQ77)\\\",DATUM[\\\"North_American_Datum_1927_CGQ77\\\",SPHEROID[\\\"Clarke 1866\\\",6378206.4,294.9786982139006,AUTHORITY[\\\"EPSG\\\",\\\"7008\\\"]],AUTHORITY[\\\"EPSG\\\",\\\"6609\\\"]],PRIMEM[\\\"Greenwich\\\",0,AUTHORITY[\\\"EPSG\\\",\\\"8901\\\"]],UNIT[\\\"degree\\\",0.0174532925199433,AUTHORITY[\\\"EPSG\\\",\\\"9122\\\"]],AUTHORITY[\\\"EPSG\\\",\\\"4609\\\"]],PROJECTION[\\\"Transverse_Mercator\\\"],PARAMETER[\\\"latitude_of_origin\\\",0],PARAMETER[\\\"central_meridian\\\",-61.5],PARAMETER[\\\"scale_factor\\\",0.9999],PARAMETER[\\\"false_easting\\\",304800],PARAMETER[\\\"false_northing\\\",0],UNIT[\\\"metre\\\",1,AUTHORITY[\\\"EPSG\\\",\\\"9001\\\"]],AXIS[\\\"X\\\",EAST],AXIS[\\\"Y\\\",NORTH],AUTHORITY[\\\"EPSG\\\",\\\"2010\\\"]]\",\"EPSG:2011\":\"PROJCS[\\\"NAD27(CGQ77) / SCoPQ zone 5\\\",GEOGCS[\\\"NAD27(CGQ77)\\\",DATUM[\\\"North_American_Datum_1927_CGQ77\\\",SPHEROID[\\\"Clarke 1866\\\",6378206.4,294.9786982139006,AUTHORITY[\\\"EPSG\\\",\\\"7008\\\"]],AUTHORITY[\\\"EPSG\\\",\\\"6609\\\"]],PRIMEM[\\\"Greenwich\\\",0,AUTHORITY[\\\"EPSG\\\",\\\"8901\\\"]],UNIT[\\\"degree\\\",0.0174532925199433,AUTHORITY[\\\"EPSG\\\",\\\"9122\\\"]],AUTHORITY[\\\"EPSG\\\",\\\"4609\\\"]],PROJECTION[\\\"Transverse_Mercator\\\"],PARAMETER[\\\"latitude_of_origin\\\",0],PARAMETER[\\\"central_meridian\\\",-64.5],PARAMETER[\\\"scale_factor\\\",0.9999],PARAMETER[\\\"false_easting\\\",304800],PARAMETER[\\\"false_northing\\\",0],UNIT[\\\"metre\\\",1,AUTHORITY[\\\"EPSG\\\",\\\"9001\\\"]],AXIS[\\\"X\\\",EAST],AXIS[\\\"Y\\\",NORTH],AUTHORITY[\\\"EPSG\\\",\\\"2011\\\"]]\",\"EPSG:2012\":\"PROJCS[\\\"NAD27(CGQ77) / SCoPQ zone 6\\\",GEOGCS[\\\"NAD27(CGQ77)\\\",DATUM[\\\"North_American_Datum_1927_CGQ77\\\",SPHEROID[\\\"Clarke 1866\\\",6378206.4,294.9786982139006,AUTHORITY[\\\"EPSG\\\",\\\"7008\\\"]],AUTHORITY[\\\"EPSG\\\",\\\"6609\\\"]],PRIMEM[\\\"Greenwich\\\",0,AUTHORITY[\\\"EPSG\\\",\\\"8901\\\"]],UNIT[\\\"degree\\\",0.0174532925199433,AUTHORITY[\\\"EPSG\\\",\\\"9122\\\"]],AUTHORITY[\\\"EPSG\\\",\\\"4609\\\"]],PROJECTION[\\\"Transverse_Mercator\\\"],PARAMETER[\\\"latitude_of_origin\\\",0],PARAMETER[\\\"central_meridian\\\",-67.5],PARAMETER[\\\"scale_factor\\\",0.9999],PARAMETER[\\\"false_easting\\\",304800],PARAMETER[\\\"false_northing\\\",0],UNIT[\\\"metre\\\",1,AUTHORITY[\\\"EPSG\\\",\\\"9001\\\"]],AXIS[\\\"X\\\",EAST],AXIS[\\\"Y\\\",NORTH],AUTHORITY[\\\"EPSG\\\",\\\"2012\\\"]]\",\"EPSG:2013\":\"PROJCS[\\\"NAD27(CGQ77) / SCoPQ zone 7\\\",GEOGCS[\\\"NAD27(CGQ77)\\\",DATUM[\\\"North_American_Datum_1927_CGQ77\\\",SPHEROID[\\\"Clarke 1866\\\",6378206.4,294.9786982139006,AUTHORITY[\\\"EPSG\\\",\\\"7008\\\"]],AUTHORITY[\\\"EPSG\\\",\\\"6609\\\"]],PRIMEM[\\\"Greenwich\\\",0,AUTHORITY[\\\"EPSG\\\",\\\"8901\\\"]],UNIT[\\\"degree\\\",0.0174532925199433,AUTHORITY[\\\"EPSG\\\",\\\"9122\\\"]],AUTHORITY[\\\"EPSG\\\",\\\"4609\\\"]],PROJECTION[\\\"Transverse_Mercator\\\"],PARAMETER[\\\"latitude_of_origin\\\",0],PARAMETER[\\\"central_meridian\\\",-70.5],PARAMETER[\\\"scale_factor\\\",0.9999],PARAMETER[\\\"false_easting\\\",304800],PARAMETER[\\\"false_northing\\\",0],UNIT[\\\"metre\\\",1,AUTHORITY[\\\"EPSG\\\",\\\"9001\\\"]],AXIS[\\\"X\\\",EAST],AXIS[\\\"Y\\\",NORTH],AUTHORITY[\\\"EPSG\\\",\\\"2013\\\"]]\",\"EPSG:2014\":\"PROJCS[\\\"NAD27(CGQ77) / SCoPQ zone 8\\\",GEOGCS[\\\"NAD27(CGQ77)\\\",DATUM[\\\"North_American_Datum_1927_CGQ77\\\",SPHEROID[\\\"Clarke 1866\\\",6378206.4,294.9786982139006,AUTHORITY[\\\"EPSG\\\",\\\"7008\\\"]],AUTHORITY[\\\"EPSG\\\",\\\"6609\\\"]],PRIMEM[\\\"Greenwich\\\",0,AUTH