/**
 *  地图管理及地图初始化
 * @author by <a href="mailto:chaomashi@gmail.com">Du</a>
 * @version v1.0 2019/4/9/15:01  Copyright gtmap Corp
 */

define([
        'leaflet',
        "easyMap/core/EventBus",
        'esri-leaflet',
        'easyMap/core/CrsFactory',
        "easyMap/core/GeometrySymbol",
        'easyMap/tp/supermap-leaflet/iclient-leaflet',
        'easyMap/main',
        'easyMap/core/StDynamicMapLayer',
    ], function (
    L,
    EventBus,
    LEsri,
    CrsFactory,
    GeometrySymbol,
    Supermap,
    MainMap,
    StDynamicMapLayer
    ) {
        'use strict';

        /**
         * @alias MapManager
         * @constructor
         */
        function MapManager(option, configMapPart, xzqdm, regionIndex, regionUrlPre) {
            if (!configMapPart || !option) {
                alert("map config is null");
                return;
            }
            var $that = this;
            var $map;
            //当前底图
            this.baseLayer = null;

            var initBounds = null;

            var initZoom = 13;

            this.CrsFactory = CrsFactory;

            /**
             * 初始化地图
             * @private
             */
            this.initMap = function () {
                // 获取参数和地图配置
                var mapDiv = option.MAP_CONTAINER;
                if (configMapPart) {
                    // 地图参数
                    var configMapOptions = configMapPart.options;
                    // 初始化范围
                    initBounds = configMapOptions.initBounds;
                    initZoom = configMapOptions.zoom;
                    // 模板空间参考
                    var proj = configMapOptions.crs;
                    // 基础底图
                    var baseLayerConfigs = configMapPart.baseLayers;

                    // 地图控制器
                    var controls = configMapPart.controls;

                    this.CrsFactory.setWkid(proj.wkid);
                    CrsFactory.setCrsParams(proj);
                    var crs = CrsFactory.getCrs(proj.wkid) || CrsFactory.getCrs("4490");

                    // 整合地图参数
                    var mapOptions = $.extend(option, {crs: crs});//,
                    $map = L.map(mapDiv, mapOptions);

                    //地图-》多个底图->多个图层
                    var baseLayerDic = {};
                    if (baseLayerConfigs.length > 0) {
                        $.each(baseLayerConfigs, function (index, value) {
                            if (value.layers.length !== 0) {
                                baseLayerDic[value.title] = L.layerGroup(value.layers.map(function (lyr) {
                                    lyr.isBaseLayer = true;
                                    return $that.createLayer(lyr);
                                }));
                            }
                        });
                        // allBaseLayers.push(baseLayerDic);
                        if (Object.keys(baseLayerDic).length > 0) {
                            var firstKey = option.baseLayer || Object.keys(baseLayerDic)[0];
                            //加载
                            $map.addLayer(baseLayerDic[firstKey]);
                            this.baseLayer = baseLayerDic[firstKey];
                            // 传输地图和底图
                            // MapUtils.setMap(map);
                            // MapUtils.setBaseLayer(baseLayerDic[firstKey]);
                        }

                    }
                    var bounds = L.bounds(initBounds);
                    var centerPnt = bounds.getCenter();

                    $map.fitBounds(initBounds);
                    $map.setMinZoom(initZoom);
                    if (xzqdm.indexOf('0000') === -1) {
                        if (xzqdm.indexOf('00') !== -1) {
                            xzqdm = xzqdm.split('00')[0];
                        }
                        var regionUrl = "";
                        //判断行政市和区对应的图层
                        if (xzqdm.length > 6) {
                            regionUrl = regionUrlPre + "?regionCode=" + xzqdm + "&index="
                                + regionIndex.split(',')[0] + ',' + regionIndex.split(',')[1] + ',' + regionIndex.split(',')[2];
                        } else if (xzqdm.length > 5) {
                            //index根据tpl模板中的regionIndex进行获取
                            regionUrl = regionUrlPre + "?regionCode=" + xzqdm + "&index="
                                + regionIndex.split(',')[0] + ',' + regionIndex.split(',')[1];
                        } else {
                            //检索市数据时需要将index拆分获取regionIndex的xzq_c_2016_2k索引
                            regionUrl = regionUrlPre + "?regionCode=" + xzqdm + "&index="
                                + regionIndex.split(',')[0];
                        }
                        //获取geojson数据
                        //渲染图层
                        $.support.cors = true;
                        //根据拼接的url拿到需要的市区数据
                        $.getJSON(regionUrl).done(function (data) {
                            var sr = parseInt($that.getWkid());
                            var feature = data.content[0];
                            //渲染图层
                            var regionLayer = L.geoJson(feature);
                            //设定bounds中心及视图缩放比例
                            var geoBounds = regionLayer.getBounds();
                            var center = geoBounds.getCenter();

                            if(sr === 4528){
                                center = $that._latlngToMeter(center);
                                var maxBound = $that._latlngToMeter(geoBounds._northEast);
                                var minBound = $that._latlngToMeter(geoBounds._southWest);
                                geoBounds._northEast = maxBound;
                                geoBounds._southWest = minBound;
                            }
                            var zoom = $map.getBoundsZoom(geoBounds);
                            $map.setView(center, zoom);

                            // _addControl(controls, map);
                        })
                    }
                    if (crs.code === 'EPSG:2364' || crs.code === 'EPSG:4549' || crs.code === 'EPSG:4528') {
                        var latlg = crs.unproject(centerPnt);
                        $map.setView(latlg, initZoom || 0);
                        $map.setMaxZoom(crs._scales.length - 1);
                    } else {
                        $map.fitBounds(initBounds);
                        $map.setMinZoom(initZoom);
                    }
                }
                // }
                EventBus.trigger(EventBus.MAIN_MAP_INITIALIZED);
            }

            this.moveToDefaultBounds = function () {
                $map.fitBounds(initBounds);
                $map.setMinZoom(initZoom);
            }

            this._latlngToMeter = function (latlng) {
                var crs = this.getCrs();
                var point = crs.project(latlng);
                latlng.lng = point.x;
                latlng.lat = point.y;
                return latlng;
            }
            this.getWkid = function () {
                return this.CrsFactory._wkid;
            }

            this.getCrs = function (wkid) {
                return this.CrsFactory.getCrs(wkid);
            }

            this.getSymbol = function (name) {
                if (GeometrySymbol[name]) {
                    return GeometrySymbol[name];
                }
            };

            /**
             * 创建图层
             * @param config
             */
            this.createLayer = function (config) {
                if (!config) {
                    console.log("config is null");
                    return;
                }

                var _layer, type = config.type.toLocaleLowerCase();
                switch (type) {
                    case "ags_tile":
                        _layer = new L.TileLayer(this.getTileUrl(config), config);
                        break;
                    case "ags_rest":
                        // _layer = new LEsri.DynamicMapLayer(config);
                        _layer = new StDynamicMapLayer(config, null, xzqdm);
                        break;
                    case "ags_vector_tile":
                        _layer = new L.vectorGrid.protobuf(config.url, $that.setPbfStyle(config));
                        break;
                    case "spm_tile":
                    case "spm_rest":
                        _layer = new L.supermap.tiledMapLayer(config.url, config);
                        break;
                    default:
                        // todo other service
                        console.log("config is null");
                }
                return _layer;
            }

            this.addLayer = function (layer) {
                $map.addLayer(layer);
            },
                this.getTileUrl = function (val) {
                    var url = val.url + '/tile/{z}/{y}/{x}';
                    if (xzqdm) {
                        val.regionCode = xzqdm
                    }
                    url = url + '?regionCode=' + xzqdm;
                    return url
                },
                this.removeLayer = function (layer) {
                    $map.removeLayer(layer);
                },

                /**
                 * 返回地图
                 * @returns {*}
                 */
                this.get$Map = function () {
                    return $map;
                },
                this.removeAllLayers=function (layers){
                if (layers.length > 0) {
                    layers.forEach(function (Lyr) {
                        $map.removeLayer(Lyr);
                    });
                    layers = [];
                    return layers;
                } else {
                    return [];
                }
            }

            /**
             * 返回所有图层
             */
            this.getAllLayers = function () {
                var allLayers = [];
                $map.eachLayer(function (layer) {
                    allLayers.push(layer);
                });
                //
                // if(layersAll.length === 0 ){
                //     if (allLayers !== undefined && allLayers.length > 0) {
                //         allLayers.forEach(function (item) {
                //             if (item.hasOwnProperty('options')) {
                //                 if (item.options.hasOwnProperty('subdomains') || item.options.hasOwnProperty('pans')) {
                //                     layersAll.push(item);
                //                 }
                //             }
                //         });
                //     }
                //     //上层的服务显示在上面
                //     layersAll = layersAll.reverse();
                // } else {
                //     //按保留结果渲染
                //     if (allLayers != undefined && allLayers.length > 0) {
                //         allLayers.forEach(function (item) {
                //             if (item.hasOwnProperty('options')) {
                //                 if (item.options.hasOwnProperty('subdomains') || item.options.hasOwnProperty('pans')) {
                //                     if(layersAll.indexOf(item) == -1) {
                //                         //添加勾选图层
                //                         layersAll.splice(0, 0, item);
                //                     }
                //                 }
                //             }
                //         });
                //     }
                //     //删去图层
                //     layersAll = layersAll.filter(function (item) {
                //         if(allLayers.indexOf(item) != -1) {
                //             return item
                //         }
                //     });
                // }

                return allLayers;
            }

            this.zoom = function (_zoom) {
                if (_zoom) {

                } else {
                    return
                }
            }

            this.coordsMeterToSys = function (geoJSON, sr) {
                var sr = parseInt(sr);
                var crs = this.getCrs(sr);
                //判断坐标系，如果是4490就跳出方法
                if (sr !== 4490) {
                    if (geoJSON.features !== undefined) {
                        geoJSON.features.forEach(function (feature) {
                            if (feature.geometry.type === "MultiPolygon") {
                                feature.geometry.coordinates.forEach(function (coordinates) {
                                    coordinates.forEach(function (polygons) {
                                        polygons.forEach(function (coord) {
                                            _transPoint(coord, crs);
                                        })
                                    })
                                })
                            } else if (feature.geometry.type === "Polygon") {
                                feature.geometry.coordinates.forEach(function (coords) {
                                    coords.forEach(function (coord) {
                                        _transPoint(coord, crs);
                                    });
                                })
                            } else if (feature.geometry.type === "Point") {
                                if (typeof (feature.geometry.coordinates) === "string") {
                                    var tranP = JSON.parse(feature.geometry.coordinates);
                                    _transPoint(tranP, crs);
                                    feature.geometry.coordinates = tranP;
                                } else {
                                    _transPoint(feature.geometry.coordinates, crs);
                                }
                            } else if (feature.geometry.type === "LineString") {
                                feature.geometry.coordinates.forEach(function (coord) {
                                    _transPoint(coord, crs);
                                })
                            }
                        });
                    } else if (geoJSON.geometry !== "") {
                        if (geoJSON.geometry.type === "MultiPolygon") {
                            geoJSON.geometry.coordinates.forEach(function (coordinates) {
                                coordinates.forEach(function (polygons) {
                                    polygons.forEach(function (coord) {
                                        _transPoint(coord, crs);
                                    })
                                })
                            })
                        } else if (geoJSON.geometry.type === "Polygon") {
                            geoJSON.geometry.coordinates.forEach(function (coords) {
                                coords.forEach(function (coord) {
                                    _transPoint(coord, crs);
                                })
                            })
                        } else if (geoJSON.geometry.type === "Point") {
                            _transPoint(geoJSON.geometry.coordinates, crs);
                        } else if (geoJSON.geometry.type === "LineString") {
                            geoJSON.geometry.coordinates.forEach(function (coord) {
                                _transPoint(coord, crs);
                            })
                        }
                    }

                }
                return geoJSON;
            }

            function _transPoint(coord, crs) {
                var temPoint = L.point(coord[0], coord[1]);
                var pointTrans = crs.unproject(temPoint);
                coord[0] = pointTrans.lng;
                coord[1] = pointTrans.lat;
            }
        }

        /**
         * add map controls
         * @param controls
         * @param map
         * @private
         */
        // function _addControl(controls, map) {
        //     $.each(controls, function (index, value) {
        //         if (value.display) {
        //             require(["../map/controls/index"], function (control) {
        //                 try {
        //                     var func,
        //                         con = $.extend(L.control, control),
        //                         uri = value.uri.toLowerCase();
        //
        //                     if (con.hasOwnProperty(uri)) {
        //                         func = con[uri];
        //                         var mc = func.call(this).setPosition(value.position);
        //                         if (uri === 'zoom') {
        //                             //zoom的悬浮提示改为中文
        //                             mc.options.zoomInTitle = '放大';
        //                             mc.options.zoomOutTitle = '缩小';
        //                         }
        //                         map.addControl(mc);
        //                     }
        //                 } catch (e) {
        //                     Utils.error('init control error' + e)
        //                 }
        //             });
        //         }
        //     });
        // }


        return MapManager;
    }
);
