define(["easyMap/core/EventBus",
    "easyMap/manager/MapManager",
    "easyMap/manager/WidgetsManager",
    "text!easyMap/template/mainMap.html",
    "text!easyMap/template/compare-layout.html",
    "knockout",
    'easyMap/controls/Legend',
    'easyMap/controls/TimeLine',
    'easyMap/controls/ServiceLayer',
    'easyMap/core/DrawGeometry',
    'jquery',
    'easyMap/core/EchartsUtils',
    'leaflet',
    'leaflet-pip',
    'easyMap/tp/jquery/jquery.upload2',
    "css!easyMap/css/iconfont.css",
    "css!easyMap/css/easyMap.css"], function (
    EventBus,
    MapManager,
    WidgetsManager,
    MapHtml,
    CompareHtml,
    knockout,
    Legend,
    TimeLine,
    ServiceLayer,
    Draw,
    $,
    EchartsUtils,
    L,
    LeafletPip,
    UPload
) {
    /**
     * mainMap类
     * @constructor
     */
    function MainMap() {
        var $map, activeWidget = null, activeConfig;
        var timeLayerArr = [];
        this.even = EventBus;
        this.timeLine = new TimeLine();
        this.widgets = null;
        this.map = null;
        this.controls = {};
        this.option = null;
        this.appConfig = null;
        this.mapType = "main";//主地图 main ，second,third
        this.widgetLoaded = false;//防止重复加载
        this.xzqdm = null;
        var drawMarker;
        var layerConfig = null;
        var that = this;
        var hideTools = false;
        //初始化地图
        this.initMap = function (option, tpl, regionCode) {
            if (typeof tpl == "string") {
                tpl = JSON.parse(tpl);
            }
            that.appConfig = tpl;
            that.appConfig.regionCode = regionCode;
            layerConfig = that.appConfig.map.layers;
            that.xzqdm = regionCode;
            if (!option || !option.mapId) {
                alert("初始化地图失败，请输入mapid");
                return;
            }
            //处理一个页面多个地图情况
            this.mapType = option.mapType || this.mapType;
            if (!option.isCompareMap) {
                //主屏幕执行分屏
                //追加地图容器

                $("<div></div>").attr("id", option.mapId + "_second").appendTo($("#" + option.mapId));
                $("<div></div>").addClass("main-map").attr("id", option.mapId + "_main").appendTo($("#" + option.mapId));
                that.compareMapId = option.mapId + "_second";
                option.mapId = option.mapId + "_main";
            }
            //初始化地图html
            option.MAP_CONTAINER = option.mapId + "_map";

            $("#" + option.mapId).html(MapHtml);
            that.option = option;
            that.widgets = new WidgetsManager(tpl.content, option.mapId);
            EventBus.listener(EventBus.MAIN_MAP_INITIALIZED, function (e) {
                if (that.widgetLoaded) {
                    return;
                }
                that.widgets.loadWidgets();
                that.widgetLoaded = true;
            });
            var content = tpl.content;
            bindHtml(option, content);
            that.map = new MapManager(option, tpl.map, regionCode, that.appConfig.regionIndex, that.appConfig.interface.queryUrlPre);
            //初始化地图及控件
            that.map.initMap();
            $map = that.map.get$Map();
            Legend.showLegend(true);
            bindEvent();
        };

        function bindEvent() {

            EventBus.listener("timeLine-change", function (data) {
                if (data.mapType != that.mapType) {
                    return;
                }
                $(timeLayerArr).map(function (i, layer) {
                    that.map.removeLayer(layer);
                });
                timeLayerArr = [];
                $(data.layers).map(function (i, layer) {
                    if (Legend.showLegend()) {
                        Legend.init(layer);
                    }
                    that.showLayerTitle(layer);
                    var tmpLayer = that.map.createLayer(layer);
                    that.map.addLayer(tmpLayer);
                    timeLayerArr.push(tmpLayer);
                    if ($("#compare_li").hasClass("tool-active")) {
                        return;
                    }
                    setExtentByLayer(layer)
                })

            }, that.mapType);

            EventBus.listener("timeLine-close", function (mapType) {
                if (mapType && mapType != that.mapType) {
                    return;
                }
                $(timeLayerArr).map(function (i, tmpLayer) {
                    that.map.removeLayer(tmpLayer);
                })
                timeLayerArr = [];
            });
        }

        /**
         * 销毁不删除事件
         * @param notRemoveEvent
         */
        function destroyTimeLine(notRemoveEvent) {

            $("#" + that.option.mapId + " .timeLine").hide();
            if (!notRemoveEvent) {
                that.controls.TimeLine.removeEventAll(that.mapType);
                //重新绑定
                var roll, leftLayer, rightLayer;
                EventBus.listener("timeLine-change", function (data) {
                    if (data.mapType != that.mapType) {
                        return;
                    }
                    if (!data.loaded) {
                        $(timeLayerArr).map(function (i, layer) {
                            that.map.removeLayer(layer);
                        })
                        timeLayerArr = [];
                        $(data.layers).map(function (i, layer) {
                            if (Legend.showLegend()) {
                                Legend.init(layer);
                            }
                            that.showLayerTitle(layer);
                            var tmpLayer = that.map.createLayer(layer);
                            that.map.addLayer(tmpLayer);
                            timeLayerArr.push(tmpLayer);
                            if ($("#compare_li").hasClass("tool-active")) {
                                return;
                            }
                            setExtentByLayer(layer);
                        });
                        return;
                    }
                    if (roll !== undefined) {
                        clearInterval(roll);
                    }
                    if (rightLayer !== undefined) {
                        that.map.removeLayer(rightLayer);
                    }
                    // $(".leaflet-easyMap-divider").remove();
                    if (leftLayer) {
                        if (leftLayer._currentImage !== undefined) {
                            leftLayer._currentImage._image.style.clip = ''
                        } else if (leftLayer._container) {
                            leftLayer.getContainer().style.clip = '';
                        }
                    }
                    $(timeLayerArr).map(function (i, layer) {
                        rightLayer = layer;
                    });
                    timeLayerArr = [];
                    $(data.layers).map(function (i, layer) {
                        if (Legend.showLegend()) {
                            Legend.init(layer);
                        }
                        that.showLayerTitle(layer);
                        var tmpLayer = that.map.createLayer(layer);
                        that.map.addLayer(tmpLayer);
                        timeLayerArr.push(tmpLayer);
                        leftLayer = tmpLayer;
                        if ($("#compare_li").hasClass("tool-active")) {
                            return;
                        }
                        // setExtentByLayer(layer);
                    });

                    // L.DomUtil.create('div', 'leaflet-easyMap-divider',that.map.get$Map()._controlContainer);
                    var length = 0;
                    var maxLen = $(".main-map").width();
                    roll = setInterval(function () {
                        if (maxLen > length) {
                            that.roller(leftLayer, rightLayer, length);
                            length = length + maxLen / 200;
                        } else {
                            clearInterval(roll);
                            that.map.removeLayer(rightLayer);
                            // $(".leaflet-easyMap-divider").remove();
                            if (leftLayer) {
                                if (leftLayer._currentImage !== undefined) {
                                    leftLayer._currentImage._image.style.clip = ''
                                } else {
                                    leftLayer.getContainer().style.clip = '';
                                }
                            }
                        }
                    }, 20);
                }, that.mapType);
            }
            $("#" + that.option.mapId + " .slider-container").remove();
            $("#" + that.option.mapId + " .time_select_left").removeData();
            EventBus.trigger("timeLine-close", that.mapType);
        }

        //自动卷帘效果
        this.roller = function (leftLayer, rightLayer, length) {
            $(".leaflet-easyMap-divider").css("left", length + "px");
            var nw = that.map.get$Map().containerPointToLayerPoint([0, 0]);
            var se = that.map.get$Map().containerPointToLayerPoint(that.map.get$Map().getSize());
            var clipX = nw.x + length;
            var clipLeft = 'rect(' + [nw.y, clipX, se.y, nw.x].join('px,') + 'px)';
            var clipRight = 'rect(' + [nw.y, se.x, se.y, clipX].join('px,') + 'px)';
            var clip_restL = 'rect(' + [0, length, 100000, 0].join('px,') + 'px)';
            var clip_restR = 'rect(' + [0, 10000, 10000, length].join('px,') + 'px)';
            if (leftLayer) {
                try {
                    if (leftLayer._currentImage !== undefined) {
                        leftLayer._currentImage._image.style.clip = clip_restL
                    } else {
                        leftLayer.getContainer().style.clip = clipLeft
                    }
                } catch (e) {

                }
            }
            if (rightLayer) {
                try {
                    if (rightLayer._currentImage !== undefined) {
                        rightLayer._currentImage._image.style.clip = clip_restR;
                        rightLayer._currentImage._image.style.opacity = 0.6
                    } else {
                        rightLayer.getContainer().style.clip = clipRight;
                        rightLayer.getContainer().style.opacity = 0.6
                    }
                } catch (e) {
                    that.map.removeLayer(rightLayer);
                }
            }
            // leftLayer.getContainer().style.clip = clipLeft;
            // rightLayer.getContainer().style.clip = clipRight;
        };
        var layerControlLayer = [];

        this.controls.Legend = Legend;
        this.controls.TimeLine = this.timeLine;
        this.controls.ServiceLayer = ServiceLayer;
        this.showLayerTitle = function (layer) {
            var title = layer.title || layer.alias || layer.label;
            if (hideTools == false) {
                $("#region_li").css("display", "none");
            }

            $("#" + that.option.mapId + " .map-title").show();
            $("#" + that.option.mapId + " .map-title").text(title);
        };

        var currentLayer = null;
        var loadedLayer = [];
        this.getOption = function () {
            return {
                currentLayer: currentLayer
            };
        }
        this.readFile = function (id, obj, formId, complete, send) {
            try {
                if (obj.val() !== '') {
                    //获取文件类型
                    var fileType = obj.val().substr(obj.val().lastIndexOf('.') + 1).toLowerCase();
                    if (fileType === 'zip' || fileType === 'xls' ||
                        fileType === 'xlsx' || fileType === 'txt' || fileType === 'dwg') {
                        this.upLoad(id, obj, formId, complete, send);
                    } else {
                        alert("上传错误");
                    }
                    obj.val("");
                }
            } catch (e) {
                obj.val("");
            }
        };
        this.upLoad = function (id, object, formId, complete, send) {
            var that = this
            $(object).upload({
                url: 'http://192.168.1.46:9016/gis/misc/parseGeoFile',
                params: _$(formId).serialize(),
                dataType: 'text',
                onSend: function (obj, filePath) {
                    if (send !== null && send !== undefined) {
                        send();
                    }
                    filePath.substr(filePath.lastIndexOf('\\') + 1);
                    return true;//须加,否则上传后不会进入complete
                },
                onComplate: function (data) {
                    if (complete !== null && complete !== undefined) {
                        complete(data, id);
                    }
                    if (typeof data == "string") {
                        data = JSON.parse(data);
                    }
                    data = data.value;
                    that.addGeojson(data);
                },
                onProgress: function (e) {
                    var per = Math.round(e.loaded * 100 / e.total);
                    if (per != 100) {
                    } else {
                    }
                },
                error: function () {
                }
            });
            $(object).upload("ajaxSubmit");
        }
        this.addGeojson = function (geometry) {
            //删除上一个
            if (drawMarker !== undefined) {
                $map.removeLayer(drawMarker)
            }
            if (typeof geometry == "string") {
                geometry = JSON.parse(geometry);
            }
            if (drawMarker) {
                $map.removeLayer(drawMarker);
            }
            drawMarker = L.geoJSON(geometry, {
                style: {
                    color: 'red',
                    fillColor: '#add2ff',
                    fillOpacity: 0.5
                }
            }).addTo($map);
            var geoBounds = drawMarker.getBounds();
            var zoom = $map.getBoundsZoom(geoBounds);
            $map.setView(geoBounds.getCenter(), zoom);
        }
        this.clearGeo = function () {
            Draw.doClear();
            if (drawMarker !== undefined) {
                $map.removeLayer(drawMarker)
            }
        }
        this.drawGeo = function (callback) {
            var tmp = null;
            var that = this;
            Draw.draw({
                type: 'polygon',
                measureUnit: "公顷",
                fun: function (data) {
                    tmp = data.toGeoJSON();
                    tmp.properties.NAME = "地块-1";
                    tmp.crs = {"type": "name", "properties": {"name": "EPSG:4490"}};
                    tmp.id = "feature" + Math.random() * 256;
                    //进行图形展示
                    that.addGeojson(tmp);
                    callback(tmp);
                    Draw.doClear();
                }
            }, $map);
            Draw.doClear();
        };

        function _$(D) {
            return $(document.getElementById(D));
        }

        this.setOption = function (opt) {

            //组件初始化完成之后操作
            //todo loaded失败导致
            if (!that.widgets.isLoaded) {
                setTimeout(function () {
                    that.setOption(opt);
                }, 300);
                return;
            }

            // 控制行政区定位
            if (opt.region) {
                addBackButton();
                loadRegionData();
                openClickEvent($map);
            } else {
                closeClickEvent($map);
            }

            if (opt.reset) {
                destroyTimeLine();
                // var measure = that.widgets.getWidget("measure");
                // if(measure){
                //     measure.clearResult();
                // }
                // var compare =that.widgets.getWidget("compare");
                // if(compare&&$("#compare_li").hasClass("tool-active")){
                //     // compare.onClose();
                //     // $("#compare_li").removeClass("tool-active")
                //     $("#compare_li").click();
                // }
                $(".tool-active").click();
                that.setOption({
                    echarts: {
                        destroy: true
                    }
                    , region: true
                })
                if (queryLayer) {
                    $map.removeLayer(queryLayer);
                }
            }

            if (opt.tools) {
                hideTools = opt.tools.hideTools;
                if (opt.tools.hideTools == true) {
                    $(".top-widgets").hide();
                } else {
                    $(".top-widgets").show();
                }
            }

            /**
             * 图例
             */
            if (opt.Legend) {
                if (!opt.Legend.hideLegend) {
                    Legend.showLegend(true);
                    $("#" + that.option.mapId + " .map-legend").show();
                } else {
                    // Legend.showLegend(false);
                    $("#" + that.option.mapId + " .map-legend").hide();
                }
                if (opt.Legend.layer) {
                    Legend.init(opt.layer);
                }
            }

            if (opt.loadLayer) {
                if (loadedLayer && loadedLayer.length > 0) {
                    $(loadedLayer).map(function (i, layer) {
                        $map.removeLayer(layer);
                    });
                    loadedLayer = [];
                }
                //加载地图
                //普通地图，年度图层
                //年度图层
                var loadLayer = opt.loadLayer;
                if (loadLayer.years) {
                    that.setOption({
                        TimeLine: {
                            layers: loadLayer.years
                        }
                        , region: true
                    })
                    return;
                }
                destroyTimeLine();
                var lyr = that.map.createLayer(loadLayer);
                that.map.addLayer(lyr);
                loadedLayer.push(lyr);
                that.showLayerTitle(loadLayer);
                that.controls.Legend.init(loadLayer);
            }

            /**
             * 显示时间轴
             */
            if (opt.TimeLine) {
                if (opt.TimeLine.refresh) {
                    //刷新但是不清空事件
                    destroyTimeLine(true);
                    if (!currentLayer || !currentLayer.years || currentLayer.years.length == 0) {
                        return;
                    }
                    ;
                    $("#" + that.option.mapId + " .timeLine").show();
                    this.controls.TimeLine.init("#" + that.option.mapId + " .time_select_left", currentLayer.years, that);
                    return;
                }

                if (!opt.TimeLine.hideTimeLine) {
                    $("#" + that.option.mapId + " .timeLine").show();
                } else {
                    $("#" + that.option.mapId + " .timeLine").hide();
                    return;
                }
                if (opt.TimeLine.destroy) {
                    destroyTimeLine();
                    //删除图层
                }
                if (opt.TimeLine.layers) {
                    destroyTimeLine();
                    $("#" + that.option.mapId + " .timeLine").show();
                    this.controls.TimeLine.init("#" + that.option.mapId + " .time_select_left", opt.TimeLine.layers, that);
                }
            }

            if (opt.LayerControl) {
                if (opt.LayerControl.hideLayerControl) {
                    $("#" + that.option.mapId + " .layer-Control").hide();
                }
            }

            /**
             * echarts
             */
            if (opt.echarts) {
                if (opt.echarts.data) {
                    EchartsUtils.addChartsToMap(opt.echarts.data, that.map.get$Map());
                }
                if (opt.echarts.destroy) {
                    EchartsUtils.destroy();
                }
            }

            if (opt.layers) {
                if (!layerConfig || !layerConfig[opt.layers]) {
                    ServiceLayer.showService(false);
                    console.log("layerConfig is null");
                    return;
                }
                var layers = layerConfig[opt.layers].layers;
                //无图层或图层个数等于1
                if (!layers || layers.length <= 1) {
                    ServiceLayer.showService(false);
                } else {
                    ServiceLayer.showService(true);
                }

                //删除已经显示的图层
                if (layerControlLayer.length > 0) {
                    $.each(layerControlLayer, function (i, e) {
                        $map.removeLayer(e);
                    });
                    layerControlLayer = [];
                }

                ServiceLayer.layers(layers);
                //默认触发第一个节点
                if (layers.length > 0) {
                    ServiceLayer.changeLyr(layers[0]);
                }
                // var years =layerConfig[opt.layers].years;
                // if(years&&years.length>0){
                //     that.setOption({
                //         TimeLine:{
                //             layers:years
                //         }
                //     })
                // }else {
                //     if(layers.length>0){
                //         ServiceLayer.changeLyr(layers[0]);
                //     }
                //     //隐藏时间轴
                //     that.setOption({
                //         TimeLine:{
                //             hideTimeLine:true
                //         }
                //     })
                // }
            }

            // var compare = that.widgets.getWidget("measure");
            // if(compare){
            //     compare.onClose();
            // }
        };
        this.getNewInstance = function () {
            return new MainMap();
        }
        /**
         * 初始化地图所需的模板
         * @param config
         */
        var bindHtml = function (option, config) {
            config = config || {};

            /**
             * 用于绑定地图事件的参数
             * @constructor
             */
            function MapModel() {
                this.MAP_CONTAINER = option.MAP_CONTAINER;
                var self = this;

                this.tools = knockout.observableArray(config.tools || []);
                this.widgets = knockout.observableArray(config.widgets || []);
                //绑定事件
                this.onToolClick = function (toolConfig) {
                    var tool = that.widgets.getWidget(toolConfig.id);
                    if (!toolConfig.active) {
                        toolConfig.active = knockout.observable(false);
                    }
                    if (toolConfig.active()) {
                        $(".tool-pane").hide();
                        if (tool.onClose) {
                            tool.onClose();
                        }
                        toolConfig.active = knockout.observable(false);
                        $(".tool-active").removeClass("tool-active");
                    } else {
                        //close已经包含的
                        if (activeWidget && activeWidget.onClose) {
                            activeWidget.onClose();
                        }
                        if (activeConfig) {
                            activeConfig.active = knockout.observable(false);
                        }
                        toolConfig.active = knockout.observable(true);
                        $(".tool-pane").hide();
                        if (!tool.noHtml) {
                            $("#" + tool.id + "_pane").show();
                        }
                        if (tool.beforeOpen) {
                            tool.beforeOpen();
                        }
                        if (tool.inited) {
                            //已经初始化
                            if (tool.onOpen) {
                                tool.onOpen();
                            }
                        } else {
                            if (tool.init) {
                                tool.init();
                                tool.inited = true;
                            }
                        }
                        $(".tool-active").removeClass("tool-active");
                        $("#" + toolConfig.id + "_li").addClass("tool-active");
                        activeWidget = tool;
                        activeConfig = toolConfig;
                    }
                }
            }

            var mapModel = new MapModel();
            var layer = [];

            /**
             * 改变图层显示函数(用于监听事件)
             * @param btn
             */
            function changeLayerControl(btn) {
                currentLayer = btn;
                try {
                    $(":radio[name='rdoLayerName'][value='" + btn.alias + "']").prop("checked", "checked");
                    // 判断动态服务多图层
                    if (btn.isNode) {
                        // 刷新图层
                        layerControlLayer[layerControlLayer.length - 1].options.layers = [btn.id];
                        layerControlLayer[layerControlLayer.length - 1].redraw();
                    } else {
                        if (layerControlLayer.length > 0) {
                            $.each(layerControlLayer, function (i, e) {
                                $map.removeLayer(e);
                            });
                            layerControlLayer = [];
                        }
                        //年度图层
                        if (btn.years) {
                            that.setOption({
                                TimeLine: {
                                    layers: btn.years
                                }
                                , region: true
                            })
                            return;
                        }
                        destroyTimeLine();
                        var lyr = that.map.createLayer(btn);
                        layerControlLayer.push(lyr);
                        that.map.addLayer(lyr);
                        that.showLayerTitle(btn);
                        that.controls.Legend.init(btn);
                    }
                    // 请求服务参数并定位
                    // $.support.cors = true;
                    // $.ajax({
                    //     url: btn.url,
                    //     type: 'get',
                    //     dataType: 'jsonp',
                    //     data: {f: 'pjson'},
                    //     success: function (res) {
                    //         var extent = res.fullExtent;
                    //         if(!extent){
                    //             return;
                    //         }
                    //         $map.fitBounds([
                    //             [extent.ymin, extent.xmin],
                    //             [extent.ymax, extent.xmax]
                    //         ]);
                    //     }
                    // });
                    setExtentByLayer(btn);
                } catch (e) {
                    console.log(e)
                }
            };
            knockout.applyBindings(mapModel, $("#" + option.mapId + " .easy-map_container").get(0));
            knockout.applyBindings(Legend, $("#" + option.mapId + " .map-legend").get(0));

            //如果不是主地图  不监听图层控件事件
            if (that.mapType != "main") {
                $("#" + option.mapId + " .layer-Control").hide();
            } else {
                ServiceLayer.addEventListener(changeLayerControl);
                knockout.applyBindings(ServiceLayer, $("#" + option.mapId + " .layer-Control").get(0));


            }
        };


        var setExtentByLayer = function (layer) {
            if (layer.url && (layer.url.indexOf("iserver") != -1)) {
                return SMCenterToLayer(layer);
            }
            $.ajax({
                url: layer.url,
                type: 'get',
                dataType: 'jsonp',
                data: {f: 'pjson'},
                success: function (res) {
                    // fit bounds
                    var extent = res.fullExtent;
                    if (!extent) {
                        return;
                    }
                    $map.fitBounds([
                        [extent.ymin, extent.xmin],
                        [extent.ymax, extent.xmax]
                    ]);

                }, complete: function () {
                }
            });
        }

        /**
         *超图定位
         */
        function SMCenterToLayer(layer) {
            $.support.cors = true;
            $.ajax({
                url: layer.url + ".json",
                type: 'get',
                success: function (res) {
                    var extent = res.bounds;
                    if (!extent) {
                        return;
                    }
                    $map.fitBounds([
                        [extent.leftBottom.y, extent.leftBottom.x],
                        [extent.rightTop.y, extent.rightTop.x]
                    ]);
                }
            })

        }

        //***********业务代码******************
        /**
         * 查询接口
         * @param layerName
         * @param where
         * @param geometry
         */
        this.query = function (layerName, where, geometry, callBack) {
            geometry = geometry || "";
            if (where == '') {
                where = '1=1';
            }
            var queryConfig = that.appConfig.queryConfig;
            //遍历tpl,找到对应图层的查询参数信息
            for (var key in queryConfig) {
                var vals = queryConfig[key];
                for (var i in vals) {
                    var val = vals[i];
                    if (val && val["layerName"] === layerName) {
                        var option = [];
                        option.url = val["url"] + "/query?";
                        //暂默认geometryType:esriGeometryEnvelope
                        option.data = {
                            geometry: geometry,
                            where: where,
                            outFields: "*",
                            geometryType: "esriGeometryEnvelope",
                            spatialRel: 'esriSpatialRelIntersects',
                            returnGeometry: 'true',
                            returnIdsOnly: 'false',
                            returnCountOnly: 'false',
                            returnZ: 'false',
                            returnM: 'false',
                            f: 'json',
                            inSR: '4490'
                        };
                        exeQuery(option, callBack, val);
                    }
                }
            }
        };

        function exeQuery(option, callBack, config) {
            jQuery.support.cors = true;
            if (!option || !option.url) {
                alert("请输入正确查询参数!");
                return;
            }
            $.ajax({
                url: option.url,
                type: "post",
                data: option.data,
                success: function (data) {
                    if (callBack) {
                        callBack(data, config);
                    }
                },
                error: function (data) {
                    console.log(data);
                    alert("查询失败！");
                }
            })
        }

        var queryLayer = null;

        var tmpQueryConfig = null;

        this.query2 = function (layerName, where, geometry) {
            if (queryLayer) {
                $map.removeLayer(queryLayer);
                queryLayer = null;
            }
            that.query(layerName, where, geometry, function (data, config) {
                if (typeof (data) == "string") {
                    data = JSON.parse(data)
                }
                if (!data || !data.features || data.features.length == 0) {
                    layer.msg("查询无结果！");
                    return;
                }
                var tmpFeature = jsonToGeo(data, config);
                queryLayer = L.geoJson(tmpFeature, {
                    style: that.map.getSymbol("polygon"),
                    onEachFeature: onEachFeature
                }).addTo($map).openPopup();
                var geoBounds = queryLayer.getBounds();
                var zoom = $map.getBoundsZoom(geoBounds);
                $map.fitBounds(geoBounds, true);
            })
        }


        this.setExtentByLayer = setExtentByLayer;

        /**
         * 组织属性查询详情的html
         * @param data
         */
        function onEachFeature(feature, layer) {
            layer.on('click', function (e) {
                $map.closePopup();
                if ($('#pane_identify').css('display') === 'none') {
                    var crosshair = L.DomUtil.hasClass($map._container, 'draw-cursor-enabled');
                    $that.$map.fire('click', e);
                    if (crosshair) {
                        this.unbindPopup();
                    } else {
                        if (this.getPopup() === null) {
                            this.bindPopup(this.popupContent).openPopup();
                            $('.leaflet-popup-tip-container').show();
                        }
                    }
                }
            });
            //获取图层配置信息
            var config = feature.properties.config;
            if (config && typeof config == "string") {
                config = JSON.parse(config);
            }
            var configFields = config.field;
            var popupContent = '<div class="win_title">';
            // 获取属性信息
            popupContent += '<span class="icon-f-dotcircle"> 属性详情</span>';
            popupContent += '<span class="map-popup-close icon-f-delete-circle"></span></div>' +
                '<div class="tb-content">' +
                '<table class="content-table">';

            for (var field in feature.properties) {
                //是否已经配置
                var isExist = false;
                var alias = "";
                $(configFields).map(function (i, v) {
                    if (v.name == field) {
                        isExist = true;
                        alias = v.alias;
                    }
                })
                if (!isExist) {
                    continue;
                }
                var fValue = feature.properties[field];

                popupContent += '<tr><td class="td-key"><span>' +
                    alias + '</span></td><td class="td-property" title="' + fValue + '"><span>' +
                    fValue +
                    '</span></td></tr>';
            }
            popupContent += '</table>';
            layer.bindPopup(popupContent, {minWidth: 350, maxWidth: 350, closeButton: false});
            setTimeout(function () {
                layer.openPopup();
            }, 1000);
// 图层绑定弹出框
            layer.popupContent = layer.getPopup();
            $('.leaflet-popup-tip-container').show();
        }

        /**
         * 增加视图按钮回退
         */
        function addBackButton() {
            var base = root + '/webjars/lp-webjars/image/ghfl/fullMap.png';
            var html = "<div id='fullMap' " +
                "style='position: absolute;bottom:30px;right: 10px;z-index:999;" +
                "width:30px;height:30px;border-radius:3px;background: #fff;" +
                "border: 1px solid #c3b4b4;text-align: center;line-height:30px;cursor: pointer'>" +
                "<img src=" + base + ">" +
                "</div>";
            $("#" + that.option.mapId).append(html);
            var el = document.getElementById("fullMap");

            L.DomEvent.addListener(el, 'click', function (e) {
                $(document).trigger("region-change", {regionCode: that.appConfig.cityRegionCode});
                L.DomEvent.stopPropagation(e);
                L.DomEvent.preventDefault(e);
                removeRegionLayer();
                $map.setZoom(8)
            });
            L.DomEvent.addListener(el, 'mousedown dblclick drag', function (e) {
                L.DomEvent.stopPropagation(e);
                L.DomEvent.preventDefault(e);
            });
        }

        function jsonToGeo(data, config) {
            var geoFeatures = [];
            $(data.features).each(function (i, item) {
                if (config) {
                    item.attributes.config = JSON.stringify(config);
                }
                var geoFeature = {
                    type: 'Feature',
                    properties: item.attributes,
                    id: item.attributes.OBJECTID,
                    geometry: {
                        type: '',
                        coordinates: []
                    }
                };
                switch (data.geometryType) {
                    case 'esriGeometryPolygon' :
                        geoFeature.geometry.type = 'Polygon';
                        geoFeature.geometry.coordinates = item.geometry.rings;
                        geoFeatures.push(geoFeature);
                        break;
                    case 'esriGeometryPolyline' :
                        geoFeature.geometry.type = 'LineString';
                        geoFeature.geometry.coordinates = item.geometry.paths[0];
                        geoFeatures.push(geoFeature);
                        break;
                    case 'esriGeometryPoint' :
                        geoFeature.geometry.type = 'Point';
                        geoFeature.geometry.coordinates = [item.geometry.x, item.geometry.y];
                        geoFeatures.push(geoFeature);
                        break;
                    case 'esriGeometryMultipoint':
                        geoFeature.geometry.type = 'MultiPoint';
                        geoFeature.geometry.coordinates = item.geometry.points;
                        geoFeatures.push(geoFeature);
                        break;
                }
            })

            // 返回GeoJson
            return {
                features: geoFeatures,
                type: 'FeatureCollection'
            };
        }

        // 加载行政区数据
        //存储范围结果数据
        var regionJson = [], judgeGeoJson = [], fullMap = [];

        function loadRegionData() {
            var getAllRegionsUrl = that.appConfig.interface.getAllRegionsUrl;
            var queryPre = that.appConfig.interface.queryUrlPre;
            var regionCode = that.appConfig.cityRegionCode;
            var provincialCode = that.appConfig.provinceRegionCode;
            var regionIndex = that.appConfig.regionIndex;
            var queryUrl = queryPre + "?index=" + regionIndex.split(',')[1];
            var cityUrl = queryPre + "?index=" + regionIndex.split(',')[0];
            // 若缓存数组为空
            if (regionJson.length === 0) {

                //图形中行政区按钮加载
                $.ajax({
                    url: getAllRegionsUrl + regionCode,
                    type: 'get',
                    success: function (data) {
                        $(".regionName").text(data[0].name);
                    }
                });

                $.ajax({
                    url: getAllRegionsUrl + provincialCode,
                    type: 'get',
                    success: function (data) {
                        $.each(data, function (i, e) {
                            if (e.value === regionCode) {

                                //默认图上行政区的值（图形中行政区按钮加载）
                                $(".mapRegion").css("display", "block");

                                // 市级面数据
                                $.ajax({
                                    url: cityUrl + "&XZQDM=" + e.value,
                                    type: "get",
                                    success: function (data) {
                                        // todo 传递数据
                                        // 定位
                                        fullMap = data.content;
                                    }
                                });
                                // 区级面数据
                                $.each(e.children, function (index, value) {
                                    $.ajax({
                                        url: queryUrl + "&XZQDM=" + value.value,
                                        type: "get",
                                        success: function (data) {
                                            // todo 传递数据
                                            // 定位
                                            judgeGeoJson.push(data.content[0]);
                                        }
                                    })
                                });
                            }
                        });
                    }
                })
            }
        }

        function openClickEvent(map) {
            map.on('click', clickEvent);
        }

        function closeClickEvent(map) {
            map.off('click');
        }

        //清楚行政区图层
        function removeRegionLayer() {
            if (regionLyr.length > 0) {
                $.each(regionLyr, function (i, e) {
                    $map.removeLayer(e);
                });
                regionLyr = [];
            }
        }


        var regionLyr = [];

        function clickEvent(e) {
            if (judgeGeoJson.length === 0) {
                alert('行政区范围尚未请求完成');
            } else {
                // 判断点所在的位置
                var point = [e.latlng.lng, e.latlng.lat];
                // 清除上次点击图层
                removeRegionLayer();

                $.each(judgeGeoJson, function (i, item) {
                    var gjLayer = L.geoJson(item);
                    var pipResult = LeafletPip.pointInLayer(point, gjLayer, false);
                    if (pipResult.length !== 0) {

                        // 定位
                        var bounds = pipResult[0].getBounds();
                        var zoom = $map.getBoundsZoom(bounds);
                        pipResult[0].addTo($map);
                        regionLyr.push(pipResult[0]);

                        //将区级行政区赋值按钮
                        var xzqmc = pipResult[0].feature.properties.XZQMC;
                        $(".regionName").text(xzqmc);

                        //地图放大
                        //$map.flyTo(bounds.getCenter(), zoom);

                        //地图点击事件
                        $(document).trigger("region-change", {regionCode: pipResult[0].feature.properties.REGION_CODE});

                        // 绑定图层事件，todo后期优化，不需要再次点击
                        pipResult[0].on('mouseover', function (e) {
                            var toolTip = this.bindTooltip(e.target.feature.properties.TITLE, {opacity: '1.0'});
                            toolTip.openTooltip();
                            setTimeout(function () {
                                toolTip.closeTooltip();
                            }, 2000);
                        }).on('click', function (e) {
                            $(document).trigger("region-change", {regionCode: e.target.feature.properties.REGION_CODE});
                        });
                    }
                });
            }
        }

        /**
         * 根据行政区定位展示echarts
         * @param data
         */
        this.echartsByRegion = function (xzqdm, callBack, option, showMarker) {
            EchartsUtils.echartsByRegion(that, xzqdm, callBack, option, showMarker);
        }
    }

    //点击事件点击“行政区定位”
    $(document).on('click', '.mapRegion', function () {
        $("#region_li").click();
    });

    var instance = new MainMap();
    return instance;

});
