/**
 *  预定义坐标系
 * @support 4326 3857 4490 4610 2364 4549 4528
 * @author by <a href="mailto:chaomashi@gmail.com">Du</a>
 * @version v1.0 2019/5/20/14:41  Copyright gtmap Corp
 */

define(['proj4-leaflet', 'leaflet'], function (Lproj4, L) {

    var resAndOrigin = {
            4490: {
                resolutions: [1.4062500262315776, 0.7031250131157888, 0.3515625065578944, 0.1757812532789477, 0.08789062663947395,
                    0.04394531331973697, 0.021972656659868466, 0.010986328329934222, 0.005493164164967122, 0.0027465820824835495, 0.0013732910412417793,
                    6.866455206208897E-4, 3.433227603104437E-4, 1.716613801552223E-4, 8.583069007761127E-5, 4.291534503880564E-5, 2.1457672519402795E-5,
                    1.0728836259701398E-5, 5.364418129850711E-6, 2.6822090649253553E-6, 1.3411045324626777E-6],
                origin: [-180, 90]
            },
            4610: {
                resolutions: [0.007138383017490841, 0.002749665686873995, 6.874164098211937E-4, 1.7185409650664595E-4, 4.296352412666149E-5,
                    2.148177396063577E-5, 1.0740886980317885E-5],
                origin: [116.354, 35.232]
            },
            2364: {
                resolutions: [264.5838625010584, 132.2919312505292, 66.1459656252646, 26.458386250105836, 13.229193125052918, 6.614596562526459,
                    2.6458386250105836, 1.3229193125052918, 0.5291677250021167, 0.26458386250105836, 0.13229193125052918],
                origin: [34876800, 10002100]
            },
            4549: {
                resolutions: [264.58386250105838, 132.29193125052919, 66.145965625264594, 26.458386250105836, 13.229193125052918, 2.6458386250105836, 1.3229193125052918, 0.66145965625264591, 0.26458386250105836],
                origin: [-5123200, 1.00021E7]
            },
            4528: {
                resolutions: [305.40584370960335, 152.7029218548022, 76.3514609274011, 38.17573046370042, 19.087865231850262, 9.543932615925145, 4.771966307962573, 2.3859831539812832, 1.1929915769906416, 0.5964957884953221, 0.29824789424766107],
                origin: [34876800, 10002100],
                lods: [
                    {
                        "level": 0,
                        "resolution": 305.40584370960335,
                        "scale": 1154287.49441732
                    },
                    {
                        "level": 1,
                        "resolution": 152.7029218548022,
                        "scale": 577143.747208662
                    },
                    {
                        "level": 2,
                        "resolution": 76.3514609274011,
                        "scale": 288571.873604331
                    },
                    {
                        "level": 3,
                        "resolution": 38.17573046370042,
                        "scale": 144285.936802165
                    },
                    {
                        "level": 4,
                        "resolution": 19.087865231850262,
                        "scale": 72142.9684010827
                    },
                    {
                        "level": 5,
                        "resolution": 9.543932615925145,
                        "scale": 36071.4842005414
                    },
                    {
                        "level": 6,
                        "resolution": 4.771966307962573,
                        "scale": 18035.7421002707
                    },
                    {
                        "level": 7,
                        "resolution": 2.3859831539812832,
                        "scale": 9017.87105013534
                    },
                    {
                        "level": 8,
                        "resolution": 1.1929915769906416,
                        "scale": 4508.93552506767
                    },
                    {
                        "level": 9,
                        "resolution": 0.5964957884953221,
                        "scale": 2254.46776253384
                    },
                    {
                        "level": 10,
                        "resolution": 0.29824789424766107,
                        "scale": 1127.23388126692
                    }
                ]
            }
        },

        proj4 = {
            4326: L.CRS.EPSG4326,
            3857: L.CRS.EPSG3857,
            4490: '+proj=longlat +ellps=GRS80 +no_defs',
            4610: '+proj=longlat +a=6378140 +b=6356755.288157528 +no_defs',
            2364: '+proj=tmerc +lat_0=0 +lon_0=120 +k=1 +x_0=40500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs',
            4549: '+proj=tmerc +lat_0=0 +lon_0=120 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +units=m +no_defs',
            4528: '+proj=tmerc +lat_0=0 +lon_0=120 +k=1 +x_0=40500000 +y_0=0 +ellps=GRS80 +units=m +no_defs'

        };

    function crs(crs, resAndOriginTpl) {
        if(resAndOriginTpl){
            resAndOrigin[crs] = resAndOriginTpl;
        }
        return new Lproj4.CRS('EPSG:' + crs, proj4[crs], resAndOrigin[crs])
    }

    return crs
});