/**
 *  Crs Factory
 * @author by <a href="mailto:chaomashi@gmail.com">Du</a>
 * @version v1.0 2019/5/20/14:14  Copyright gtmap Corp
 */

define([base+'/webjars/map-2d/tp/es5-shim/es5-shim.js',
    base+'/webjars/map-2d/tp/es5-shim/es5-sham.js',
        'easyMap/core/PredefinedCrs',
        'easyMap/core/PredefinedLods'
    ], function (
    Shim,
    Sham,
    PredefinedCrs,
    PredefinedLods
    ) {

        'use strict';

        /**
         * @export CrsFactory
         * @param wkid
         * @constructor
         */
        function CrsFactory() {
            this._wkid = undefined;
        }

        // CrsFactory.prototype.wkid = this._wkid|| Utils.config.DEFINE_WKID;
        // Utils.defineProperties(CrsFactory.prototype, {
        //
        //     wkid: {
        //         get: function () {
        //             return Utils.defaultValue();
        //         }
        //     }
        //
        // });



        /**
         *  this is a project not a number
         * @param wkid
         * @return {*}
         */
        CrsFactory.prototype.getCrs = function (wkid) {
            if (!wkid) {
                console.error('wkid cannot be undefined!');
            }
            if(this._resAndOriginTpl){
                return PredefinedCrs(parseInt(wkid), this._resAndOriginTpl);
            }else{
                return PredefinedCrs(parseInt(wkid));
            }

        };

        /**
         * get map lods from PredefinedLods
         * @param level
         * @returns {*}
         */
        CrsFactory.prototype.getLods = function (level) {
            if (!level) {
                console.log('level cannot be undefined!');
            }

            return PredefinedLods[this._wkid][level].scale;

        };

        /**
         * get all lods
         * @returns {*}
         */
        CrsFactory.prototype.getAllLods = function () {
            return PredefinedLods[this._wkid];
        };

        /**
         * get zoom by scale
         * @param scale
         * @returns {*}
         */
        CrsFactory.prototype.getZoomByScale = function(scale) {
            var key;
            var lods = this.getAllLods();
            for (var i = 0; i < lods.length; i++) {
                if (parseInt(lods[i].scale) === parseInt(scale)) {
                    key = lods[i].level;
                }

            }
            return key;
        };

        /**
         * set wkid
         * @param wkid
         */
        CrsFactory.prototype.setWkid = function (wkid) {
            if (!wkid) {
                console.log('wkid cannot be undefined!');
            }

            this._wkid = wkid;

        };

        /**
         * set crsParams
         * @param crsParams
         */
        CrsFactory.prototype.setCrsParams = function (crsParams) {
            if (!crsParams) {
                console.log('crsParams cannot be undefined!');
            }else{
                // 设置crs相关参数
                if(crsParams.resolutions&&crsParams.origin) {
                    this._resAndOriginTpl = {resolutions: crsParams.resolutions, origin: crsParams.origin};
                }
                if(crsParams.lods){
                    PredefinedLods[parseInt(this._wkid)] = crsParams.lods;
                }
            }
        };

        CrsFactory.prototype.getWkid = function () {
            return this._wkid;
        }


        return new CrsFactory;
    }
)
;