/**
 * 时间轴
 * @author by <a href="mailto:xxx@gmail.com">cyj</a>
 * @version v1.0 2019  Copyright gtmap Corp
 */
define([
    "easyMap/core/EventBus",
    'jquery',
    'css!easyMap/tp/jRange/jquery.range.css',
    'easyMap/tp/jRange/jquery.range'
], function (EventBus,$) {
    'use strict';
    var LISTEN = [];
    function TimeLine() {
    }

    TimeLine.prototype = {
        mapType:"main",
        //所属地图
        underMap:null,
        /**
         * 渲染时间轴
         * @param DOM
         * @param LIST
         * @param OPTION
         */
        init: function (DOM,LIST,Map) {
            var that = this;
            that.underMap =Map;
            this. mapType = Map.mapType||this. mapType;
            this._list = LIST;this._dom = DOM;this._load=false;
            var mainWidth = $(".main-map").width();
            if(!$(".main-map").hasClass("compare-map")){
                mainWidth= mainWidth*0.6;
            }
            var width =mainWidth*0.6||document.body.clientWidth * 0.25;
            // 默认加载第一个年份
            // this.addYearLayer(list[0]);
            // 定义范围与刻度
            var min = 0,max = LIST.length - 1,scale = [];
            $.each(LIST,function (i,e) {
                scale.push(e.year);
            });
            this._option =
                {
                    from: min,
                    to: max,
                    step: 1,
                    scale: scale,
                    format: '%s',
                    width: width,
                    showLabels: false,
                    showScale: true,
                    snap: true,
                    // 只要用户更改了值，就会调用此函数。同样的值也会自动为提供的隐藏输入设置。
                    onstatechange: function (event) {
                        var message = that._list[event];
                        message.id = that._list.id;
                        message.mapType =that. mapType;
                        //判断是否为播放事件
                        message.loaded=that._load;
                        // 触发更改图层事件
                        EventBus.trigger("timeLine-change",message);
                    }
                };
            // 继承方便调用修改参数
            $.extend(this._option,Map);
            $(DOM).jRange(that._option);
            // 绑定播放事件
            bindEvent(that);
            //重置
            $(DOM).jRange('setValue', '0');
            $(DOM).jRange('setValue', (LIST.length - 1).toString());

        },

        /**
         *
         * @param Event
         */
        addEventListen: function (Event) {
            LISTEN.push(Event);
        },

        removeEventListen: function (Event) {
            LISTEN.splice($.inArray(Event,LISTEN),1);
        },
        removeEventAll:function (mapType) {
            //main
            //second
            LISTEN=[];
            var that =this;
            EventBus.remove("timeLine-change",function (obj) {
                //分配防止副地图清空不带id的事件
                if(!obj.id&&mapType=="main"){
                    return true;
                }
                if(!obj||obj.id==mapType){
                    return true;
                }
            });
        }

    };

    /****************************************【逻辑处理层】********/

    var intervalId;
    function bindEvent(self) {
        var underMap = self.underMap;
        $("#"+underMap.option.mapId + " .timeLine-icon").unbind("click").on("click",function () {
            if($(this).hasClass("layui-icon-play")){
                // 播放
                $(this).removeClass("layui-icon-play").addClass("layui-icon-pause");
                play(self);
            }else {
                // 暂停
                $(this).removeClass("layui-icon-pause").addClass("layui-icon-play");
                pause(self);
            }
        });
        $("#"+underMap.option.mapId + " .timeLine-node").on("click",function () {
            var x=$(this).attr('data-id')
            $(self._dom).jRange('setValue', (x).toString());
        })
    }

    /*播放*/
    function play(self) {
        self._load=true;
        var index = 1;// 定时器和刻度
        var all = self._list.length;
        $(self._dom).jRange('setValue', "0");
        // 初始化播放
        intervalId = setInterval(
            function () {
                if(index === all){
                    index = 1;
                    clearInterval(intervalId);
                    self._load=false;
                    /* Pop.msg({type:'info',message:"播放结束"});*/
                    $("#"+self.underMap.option.mapId + " .timeLine-icon").removeClass("layui-icon-pause").addClass("layui-icon-play");
                }else {
                    $(self._dom).jRange('setValue', (index++).toString());
                }
            }, 5000);
    }

    /*暂停*/
    function pause(self) {
        clearInterval(intervalId);
        self._load=false;
        $("#"+self.underMap.option.mapId + ".timeLine-icon").removeClass("layui-icon-pause").addClass("layui-icon-play");
    }



    return TimeLine;
});