/**
 * @author 杨红杰
 * @date 2018-11-21
 */
layui.config({
    base: base + '/webjars/lp-webjars/js/' //设定扩展的Layui模块的所在目录，一般用于外部模块扩展
});

document.onkeydown = function (event) {
    var e = event || window.event || arguments.callee.caller.arguments[0];
    if (e.keyCode == 32) {
        return false;
    }
};

/*
 重写toFixed方法
 */
Number.prototype.toFixed = function(s) {
    var tmp = 0.5;
    if (this < 0) {
        tmp = -0.5;
    }
    var changenum = (parseInt(this * Math.pow(10, s) + tmp) / Math.pow(10, s)).toString();
    var index = changenum.indexOf(".");
    if (index < 0 && s > 0) {
        changenum += ".";
        for (i = 0; i < s; i++) {
            changenum += "0";
        }
    } else {
        index = changenum.length - index;
        for (i = 0; i < (s - index) + 1; i++) {
            changenum += "0";
        }
    }
    return changenum;
};

/**
 * 字典转换
 * @param key 要转换的值
 * @param name 下拉框控件name
 * @returns {*}
 */
function convert(key, name) {
    var temp = document.getElementsByName(name);
    if (temp.length > 0) {
        var len = temp[0].options.length;
        for (var i = 0; i < len; i++) {
            if (temp[0].options[i].value == key) {
                return temp[0].options[i].text;
            }
        }
    }
    return key;
}

//****************以下是js关于数值精准计算的加减乘除算法*********************
/**
 * 精准计算js两个数值的相加，避免精度问题
 */
function accAdd(arg1,arg2){
    if(!arg1 || arg1 == ""){
        arg1 = 0;
    }
    if(!arg2 || arg2 == ""){
        arg2 = 0;
    }
    var r1,r2,m;
    try{r1=arg1.toString().split(".")[1].length;}catch(e){r1=0;}
    try{r2=arg2.toString().split(".")[1].length;}catch(e){r2=0;}
    m=Math.pow(10,Math.max(r1,r2)) ;
    return (arg1*m+arg2*m)/m ;
}
//给Number类型增加一个add方法，调用起来更加方便。
Number.prototype.add = function (arg){
    return accAdd(arg,this);
};
//调用：accDiv(arg1,arg2)
//返回值：arg1除以arg2的精确结果
function accDiv(arg1,arg2){
    if(!arg1 || arg1 == ""){
        arg1 = 0;
    }
    if(!arg2 || arg2 == ""){
        return null;
    }
    var t1=0,t2=0,r1,r2;
    try{t1=arg1.toString().split(".")[1].length}catch(e){}
    try{t2=arg2.toString().split(".")[1].length}catch(e){}
    with(Math){
        r1=Number(arg1.toString().replace(".",""));
        r2=Number(arg2.toString().replace(".",""));
        return (r1/r2)*pow(10,t2-t1);
    }
}
//给Number类型增加一个div方法，调用起来更加方便。
Number.prototype.div = function (arg){
    return accDiv(this, arg);
};
//乘法函数，用来得到精确的乘法结果
//说明：javascript的乘法结果会有误差，在两个浮点数相乘的时候会比较明显。这个函数返回较为精确的乘法结果。
//调用：accMul(arg1,arg2)
//返回值：arg1乘以arg2的精确结果
function accMul(arg1,arg2){
    if(!arg1 || arg1 == ""){
        arg1 = 0;
    }
    if(!arg2 || arg2 == ""){
        arg2 = 0;
    }
    var m=0,s1=arg1.toString(),s2=arg2.toString();
    try{m+=s1.split(".")[1].length}catch(e){}
    try{m+=s2.split(".")[1].length}catch(e){}
    return Number(s1.replace(".",""))*Number(s2.replace(".",""))/Math.pow(10,m)
}
//给Number类型增加一个mul方法，调用起来更加方便。
Number.prototype.mul = function (arg){
    return accMul(arg, this);
};
/**
 * 精准计算两数值相减
 */
function accSubtr(arg1,arg2){
    if(!arg1 || arg1 == ""){
        arg1 = 0;
    }
    if(!arg2 || arg2 == ""){
        arg2 = 0;
    }
    var r1,r2,m,n;
    try{r1=arg1.toString().split(".")[1].length}catch(e){r1=0}
    try{r2=arg2.toString().split(".")[1].length}catch(e){r2=0}
    m=Math.pow(10,Math.max(r1,r2));
    //last modify by deeka
    //动态控制精度长度
    n=(r1>=r2)?r1:r2;
    return ((arg1*m-arg2*m)/m).toFixed(n);
}
//给Number类型增加一个subtr方法，调用起来更加方便。
Number.prototype.subtr = function (arg){
    return accSubtr(this, arg);
};