/**
 * @author 杨红杰
 * @date 2018-12-27
 */
;layui.define('jquery', function (exports) {
    var $ = layui.$;
    // 给jquery定义方法
    (function ($) {
        window.autocomplete = function (input, hints, height, callback) {
            if (!input) {
                return;
            }
            if (!hints) {
                hints = [];
            }

            var inputId = input.attr("id");
            if (inputId.length > 0) {
                $("#" + inputId + "_ul").remove();
            }

            var proposalList = $('<ul></ul>').addClass('proposal-list');
            proposalList.css("min-width", input.outerWidth());
            var inputOffset = input.offset();
            proposalList.css("left", inputOffset.left);
            proposalList.css("top", inputOffset.top + input.outerHeight());
            if (inputId.length > 0) {
                proposalList.attr("id", inputId + "_ul");
            }
            $("body").append(proposalList);

            input.bind("focus paste keyup", function (e) {
                if (e.which != 13 && e.which != 27 && e.which != 38 && e.which != 40) {
                    proposalList.empty();
                    proposalList.css("height", "auto");
                    //if(input.val() != ''){
                    var count = 1;
                    for (var i = 0; i < hints.length; i++) {
                        if (("" + hints[i]).indexOf(input.val()) != -1) {
                            var element = $('<li index="' + (count - 1) + '" class="text-overflow"></li>')
                                .html(hints[i])
                                .addClass('proposal')
                                .click(function () {
                                    input.val($(this).html());
                                    proposalList.empty();
                                    proposalList.css("height", "auto");
                                    if (typeof callback == "function") {
                                        callback(inputId, $(this).attr("index"), $(this).html());
                                    }
                                })
                                .mouseenter(function () {
                                    $(this).addClass('selected');
                                })
                                .mouseleave(function () {
                                    $(this).removeClass('selected');
                                });

                            proposalList.append(element);
                            count++;
                        }
                    }
                    if (height && height < proposalList.height()) {
                        proposalList.height(height)
                    }
                    //}
                }
            });

            // 绑定鼠标mousedown事件，控制导入/定制查询窗口隐藏
            $("body").bind("mousedown", function (event) {
                if (!($(event.target).hasClass("proposal-list") || $(event.target).parents().hasClass("proposal-list") || event.target.id == input.attr("id") || $(event.target).parents("#" + input.attr("id")).length > 0)) {
                    proposalList.empty();
                    proposalList.css("height", "auto");
                }
            });

            $(window).resize(function () {
                proposalList.css("min-width", input.outerWidth());
            });
        };
    })($);
    exports('autocomplete', null);
}).link(base + "/static/css/autocomplete.css");