/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtcc.gis.resource.ui.web.rest;

import cn.gtmap.gtc.clients.RegionManagerClient;
import cn.gtmap.gtcc.tddc.domain.gis.tpl.Tpl;
import cn.gtmap.gtcc.tddc.service.clients.gis.tpl.TplClient;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
@RequestMapping(value={"/rest/tpls"})
public class TplsRestController {
    private final TplClient tplClient;
    private final RegionManagerClient regionManagerClient;

    @Autowired
    public TplsRestController(TplClient tplClient, RegionManagerClient regionManagerClient) {
        this.tplClient = tplClient;
        this.regionManagerClient = regionManagerClient;
    }

    @GetMapping(value={"/all"})
    public List<Tpl> fetchAll() {
        return this.tplClient.fetchAll();
    }

    @PostMapping(value={"/save"})
    public Tpl saveTplConfig(@RequestBody Tpl tpl) {
        return this.tplClient.saveTplConfig(tpl);
    }

    @GetMapping(value={"/find/{id}"})
    public Tpl getOne(@PathVariable String id) {
        return this.tplClient.getOne(id);
    }

    @RequestMapping(value={"/queryTplListByRegionCode"})
    public List<Tpl> queryTplListByRegionCode(@RequestParam(name="regionCode", required=false) String regionCode) {
        return this.tplClient.queryTplListByRegionCode(regionCode);
    }

    @GetMapping(value={"/query/queryAllTpls"})
    public List<Map> queryAllTpls() {
        return this.getAllTpls(this.tplClient.fetchAll());
    }

    @GetMapping(value={"/query/queryAllTplsExceptContent"})
    public List<Map> queryAllTplsExceptContent() {
        return this.getAllTpls(this.tplClient.fetchAllExceptContent());
    }

    @RequestMapping(value={"/queryTplRoleRefsByTplId/{tplId}"})
    public List<String> queryMenuRoleRefsByMenuId(@PathVariable(name="tplId") String tplId) {
        return this.tplClient.queryTplRoleRefsByTplId(tplId);
    }

    @RequestMapping(value={"/associate/associateTplAndRoles"})
    public Object associateTplAndRoles(@RequestParam(name="tplId") String tplId, @RequestParam(name="roleIds[]", required=false) String[] roles) {
        try {
            return this.tplClient.associateTplAndRoles(tplId, roles);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private List<Map> getAllTpls(List<Tpl> tplList) {
        tplList.stream().sorted(Comparator.comparing(Tpl::getRegionCode));
        ArrayList<Map> mapList = new ArrayList<Map>();
        String regionName = "";
        for (Tpl tpl : tplList) {
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            map.put("id", tpl.getId());
            map.put("title", tpl.getTitle());
            try {
                regionName = this.regionManagerClient.findRegionByCode(tpl.getRegionCode()).getName();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            map.put("regionCode", regionName);
            map.put("createAt", tpl.getCreateAt());
            map.put("sr", tpl.getSr());
            mapList.add(map);
        }
        return mapList;
    }

    @RequestMapping(value={"/queryTplbyRoleIdAndSr"})
    String queryTplbyRoleIdAndSr(@RequestParam(name="roleId") String roleId, @RequestParam(name="sr") String sr) {
        return this.tplClient.queryTplbyRoleIdAndSr(roleId, sr);
    }
}

