/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtcc.gis.resource.ui.web.rest;

import cn.gtmap.gtc.storage.clients.v1.StorageClient;
import cn.gtmap.gtc.storage.domain.dto.MultipartDto;
import cn.gtmap.gtc.storage.domain.dto.StorageDto;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/resource/storage"})
public class StorageController {
    @Autowired
    private StorageClient storageClient;

    @GetMapping(value={"/upload"})
    public String uploadForm() {
        return "upload";
    }

    @RequestMapping(value={"/uploadFile"})
    @ResponseBody
    @CrossOrigin
    public StorageDto[] upload(@RequestParam(value="file") MultipartFile[] files) {
        StorageDto[] storages = new StorageDto[files.length];
        int i = 0;
        for (MultipartFile file : files) {
            MultipartDto multipartDto = new MultipartDto();
            multipartDto.setName(file.getName());
            multipartDto.setOriginalFilename(file.getOriginalFilename());
            multipartDto.setContentType(file.getContentType());
            multipartDto.setSize(file.getSize());
            multipartDto.setNodeId(this.test().getId());
            multipartDto.setClientId("contentsId");
            multipartDto.setSpaceCode("contents");
            multipartDto.setOwner("contents");
            try {
                multipartDto.setData(file.getBytes());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            storages[i] = this.storageClient.multipartUpload(multipartDto);
            ++i;
        }
        return storages;
    }

    public StorageDto test() {
        StorageDto root = this.storageClient.createRootFolder("contentsId", "contents", "contentsFile", "contents");
        StorageDto parent = this.storageClient.createFolder("contentsId", "contents", root.getId(), "2019", "contents");
        StorageDto child1 = this.storageClient.createFolder("contentsId", "contents", parent.getId(), "12", "contents");
        StorageDto child2 = this.storageClient.createFolder("contentsId", "contents", child1.getId(), "28", "contents");
        return child2;
    }
}

