/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtcc.gis.resource.ui.web.rest;

import cn.gtmap.gtc.clients.AuthorityManagerClient;
import cn.gtmap.gtc.clients.OrganizationManagerClient;
import cn.gtmap.gtc.clients.RoleManagerClient;
import cn.gtmap.gtc.clients.UserManagerClient;
import cn.gtmap.gtc.common.properties.AppBrand;
import cn.gtmap.gtc.sso.domain.dto.OrganizationDto;
import cn.gtmap.gtc.sso.domain.dto.RoleDto;
import cn.gtmap.gtc.sso.domain.dto.UserDto;
import cn.gtmap.gtc.storage.clients.v1.StorageClient;
import cn.gtmap.gtc.storage.domain.dto.MultipartDto;
import cn.gtmap.gtc.storage.domain.dto.StorageDto;
import cn.gtmap.gtcc.gis.core.geojson.Shp2Geojson;
import cn.gtmap.gtcc.gis.resource.ui.config.AdoptConfig;
import cn.gtmap.gtcc.gis.resource.ui.config.GeoJsonLengthConfig;
import cn.gtmap.gtcc.gis.resource.ui.config.SystemUrlsConfig;
import cn.gtmap.gtcc.tddc.domain.gis.data.search.ResultBean;
import cn.gtmap.gtcc.tddc.domain.gis.esm.Feature;
import cn.gtmap.gtcc.tddc.domain.gis.esm.FeatureCollection;
import cn.gtmap.gtcc.tddc.domain.gis.sde.TaskStatusCode;
import cn.gtmap.gtcc.tddc.domain.gis.tpl.map.ResourceLayer;
import cn.gtmap.gtcc.tddc.domain.resource.dto.resource.CapableView;
import cn.gtmap.gtcc.tddc.domain.resource.dto.resource.DataBaseView;
import cn.gtmap.gtcc.tddc.domain.resource.dto.resource.Layer;
import cn.gtmap.gtcc.tddc.domain.resource.dto.resource.MenuView;
import cn.gtmap.gtcc.tddc.domain.resource.dto.resource.ResourceRefView;
import cn.gtmap.gtcc.tddc.domain.resource.dto.resource.ResourceView;
import cn.gtmap.gtcc.tddc.domain.resource.metadata.Announcement;
import cn.gtmap.gtcc.tddc.domain.resource.metadata.Catalog;
import cn.gtmap.gtcc.tddc.domain.resource.metadata.Dict;
import cn.gtmap.gtcc.tddc.domain.resource.metadata.Keyword;
import cn.gtmap.gtcc.tddc.domain.resource.metadata.ResourceApply;
import cn.gtmap.gtcc.tddc.domain.resource.metadata.SpatialCoverage;
import cn.gtmap.gtcc.tddc.domain.resource.metadata.SpatialCoverageRef;
import cn.gtmap.gtcc.tddc.domain.resource.metadata.source.DataBase;
import cn.gtmap.gtcc.tddc.domain.resource.metadata.source.TableInfo;
import cn.gtmap.gtcc.tddc.domain.sec.UserInfo;
import cn.gtmap.gtcc.tddc.domain.sec.UserView;
import cn.gtmap.gtcc.tddc.service.clients.gis.data.search.EsAttributeQueryClient;
import cn.gtmap.gtcc.tddc.service.clients.gis.sde.SdeClient;
import cn.gtmap.gtcc.tddc.service.clients.gis.tpl.TplClient;
import cn.gtmap.gtcc.tddc.service.clients.resource.AnnouncementClient;
import cn.gtmap.gtcc.tddc.service.clients.resource.CatalogClient;
import cn.gtmap.gtcc.tddc.service.clients.resource.DBHClient;
import cn.gtmap.gtcc.tddc.service.clients.resource.DictClient;
import cn.gtmap.gtcc.tddc.service.clients.resource.KeywordClient;
import cn.gtmap.gtcc.tddc.service.clients.resource.MenuClient;
import cn.gtmap.gtcc.tddc.service.clients.resource.ResourceClient;
import cn.gtmap.gtcc.tddc.utils.BeanUtil;
import cn.gtmap.gtcc.tddc.utils.FileUtil;
import cn.gtmap.gtcc.tddc.utils.Utils;
import cn.gtmap.gtcc.tddc.utils.ZipUtil;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.multipart.MultipartFile;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@CrossOrigin
@RequestMapping(value={"/rest/resource"})
public class ResourceRestController {
    private ResourceClient resourceClient;
    private DBHClient dbhClient;
    private StorageClient storageClient;
    private DiscoveryClient discoveryClient;
    private KeywordClient keywordClient;
    @Autowired
    DictClient dictClient;
    @Autowired
    UserManagerClient userManagerClient;
    @Autowired
    RoleManagerClient roleManagerClient;
    @Autowired
    OrganizationManagerClient organizationManagerClient;
    @Autowired
    AuthorityManagerClient authorityManagerClient;
    @Autowired
    CatalogClient catalogClient;
    @Autowired
    AnnouncementClient announcementClient;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private SdeClient sdeClient;
    @Autowired
    private EsAttributeQueryClient esAttributeQueryClient;
    @Autowired
    private GeoJsonLengthConfig geoJsonLengthConfig;
    @Autowired
    private SystemUrlsConfig systemUrlsConfig;
    @Autowired
    private AdoptConfig adoptConfig;
    @Autowired
    AppBrand appBrand;
    @Autowired
    private MenuClient menuClient;
    @Autowired
    private TplClient tplClient;
    @Value(value="${security.oauth2.client.client-id}")
    private String resourceUiClientId;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String LAYERNAME_GDDK_DM = "gddk_320000";
    public static final String LAYERNAME_BPDK_DM = "bpdk_320000";
    public static final String LAYERNAME_TZZZ_DM = "tdzz_320000";
    public static final String GET_SHAPEFILE_STATUS_FAIL = "fail";
    public static final String GET_SHAPEFILE_STATUS_SUCCESS = "success";
    public static final String URL_19 = "172.18.2.19";
    public static final String URL_91 = "172.18.2.91";
    public static final String URL_92 = "172.18.2.92";
    public static final String URL_21 = "172.23.22.21";
    public static final String URL_22 = "172.23.22.22";
    public static final String URL_23 = "172.23.22.23";
    public static final String ALL_NDTYPE = "1";
    public static final String CUSTOM_NDTYPE = "2";

    @Autowired
    public ResourceRestController(ResourceClient resourceClient, DBHClient dbhClient, StorageClient storageClient, DiscoveryClient discoveryClient, KeywordClient keywordClient) {
        this.resourceClient = resourceClient;
        this.dbhClient = dbhClient;
        this.storageClient = storageClient;
        this.discoveryClient = discoveryClient;
        this.keywordClient = keywordClient;
    }

    @RequestMapping(value={"/register"})
    public String registerResource() {
        return this.resourceClient.register();
    }

    @PostMapping(value={"/save"})
    public String saveResource(@RequestBody ResourceView resourceView) {
        try {
            return this.resourceClient.saveResource(resourceView);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @RequestMapping(value={"/query/queryResourceById"})
    public ResourceView queryResourceById(String id) {
        ArrayList<String> listResc = new ArrayList<String>();
        ResourceView resourceView = this.resourceClient.queryResourceById(id);
        UserDto creator = this.userManagerClient.getUserDetailByUsername(resourceView.getCreator());
        UserDto publisher = this.userManagerClient.getUserDetailByUsername(resourceView.getPublisher());
        resourceView.setCreator(creator.getAlias());
        resourceView.setPublisher(publisher.getAlias());
        List catalogIds = resourceView.getCatalogIds();
        for (String catologId : catalogIds) {
            Catalog catalog = this.catalogClient.findCatalogById(catologId);
            if (!"RESC".equals(catalog.getType())) continue;
            listResc.add(catologId);
            resourceView.setRescIds(listResc);
        }
        Map sourceMap = (Map)resourceView.getSource();
        if (sourceMap != null) {
            SpatialCoverageRef spatialCoverageRef;
            int wkid;
            if (sourceMap.containsKey("projection")) {
                String projection = sourceMap.get("projection").toString();
                resourceView.setProjection(projection);
            } else if (resourceView.getSpatialCoverage() != null && (wkid = resourceView.getSpatialCoverage().getWkid()) != 0 && (spatialCoverageRef = this.resourceClient.getSpatialCoverageRefByWkid(wkid)).getCsType() != null) {
                resourceView.setProjection(spatialCoverageRef.getCsType());
            }
        }
        if (resourceView.getRescIds() != null && resourceView.getRescIds().size() > 0) {
            List list1 = this.catalogClient.findParentByChild((String)resourceView.getRescIds().get(0));
            resourceView.setRescIds(list1);
        } else {
            resourceView.setRescIds(new ArrayList());
        }
        return resourceView;
    }

    @RequestMapping(value={"/query/queryResourceId"})
    public ResourceView queryResourceId(String id) {
        List list1;
        ResourceView resourceView = this.resourceClient.queryResourceById(id);
        List list = resourceView.getCatalogIds();
        ArrayList<String> listResc = new ArrayList<String>();
        ArrayList<String> listXzjg = new ArrayList<String>();
        for (String catologId : list) {
            Catalog catalog = this.catalogClient.findCatalogById(catologId);
            if ("RESC".equals(catalog.getType())) {
                listResc.add(catologId);
                resourceView.setRescIds(listResc);
            }
            if (!"XZJG".equals(catalog.getType())) continue;
            listXzjg.add(catologId);
            resourceView.setXzjgIds(listXzjg);
        }
        if (resourceView.getRescIds() != null && resourceView.getRescIds().size() > 0) {
            list1 = this.catalogClient.findParentByChild((String)resourceView.getRescIds().get(0));
            resourceView.setRescIds(list1);
        } else {
            resourceView.setRescIds(new ArrayList());
        }
        if (resourceView.getXzjgIds() != null && resourceView.getXzjgIds().size() > 0) {
            list1 = this.catalogClient.findParentByChild((String)resourceView.getXzjgIds().get(0));
            resourceView.setXzjgIds(list1);
        } else {
            resourceView.setXzjgIds(new ArrayList());
        }
        Map sourceMap = (Map)resourceView.getSource();
        if (sourceMap != null) {
            SpatialCoverageRef spatialCoverageRef;
            int wkid;
            if (sourceMap.containsKey("projection")) {
                String projection = sourceMap.get("projection").toString();
                resourceView.setProjection(projection);
            } else if (resourceView.getSpatialCoverage() != null && (wkid = resourceView.getSpatialCoverage().getWkid()) != 0 && (spatialCoverageRef = this.resourceClient.getSpatialCoverageRefByWkid(wkid)).getCsType() != null) {
                resourceView.setProjection(spatialCoverageRef.getCsType());
            }
        }
        return resourceView;
    }

    @PostMapping(value={"/update"})
    public String updateResource(@RequestBody ResourceView resourceView) {
        return this.resourceClient.updateResource(resourceView);
    }

    @RequestMapping(value={"/deleteResource"})
    public Boolean deleteResource(String id) {
        return this.resourceClient.deleteResource(id);
    }

    @RequestMapping(value={"/query/condition"})
    public Page<ResourceView> queryResourceByCondition(@RequestParam(name="keyword", required=false) String keyword, @RequestParam(name="title", required=false) String title, @RequestParam(name="start", required=false) Date start, @RequestParam(name="end", required=false) Date end, Pageable pageable) {
        return this.resourceClient.queryResourceByCondition(keyword, title, start, end, pageable);
    }

    @RequestMapping(value={"/query/queryResourceByTitle"})
    public List<ResourceView> queryResourceByTitle(@RequestParam(name="title", required=false) String title) {
        return this.resourceClient.queryResourceByTitle(title);
    }

    @RequestMapping(value={"/query/all"})
    public Page<ResourceView> findResources(Pageable pageable) {
        return this.resourceClient.findResources(pageable);
    }

    @RequestMapping(value={"/query/getRightsByResource"})
    public Boolean getRightsByResource(String id) {
        return this.resourceClient.getRightsByResource(id);
    }

    @RequestMapping(value={"/query/getRateById"})
    public int getRateById(String id) {
        return this.resourceClient.getRateById(id);
    }

    @RequestMapping(value={"/query/getResourceRef"})
    public List<ResourceRefView> getResourceRef(String id) {
        return this.resourceClient.getResourceRef(id);
    }

    @RequestMapping(value={"/checkUrl"})
    public Object checkUrl(@RequestParam(name="type", required=false) String type, @RequestParam(name="url") String url) {
        if (this.adoptConfig.isAdoptSt()) {
            url = this.mapUrlForSt(url);
        }
        HashMap<String, Object> resMap = new HashMap<String, Object>(16);
        boolean flag = false;
        if (StringUtils.isBlank((String)url) && url.length() == 0) {
            resMap.put("resInfo", "");
            resMap.put("flag", flag);
            return resMap;
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        if ("AGS_REST".equals(type) || "AGS_TILE".equals(type) || "AGS_FEATURE".equals(type) || "AGS_VECTOR_TILE".equals(type)) {
            block13: {
                url = url.contains("?") ? url + "&f=pjson" : url + "?f=pjson";
                try {
                    ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)entity, String.class, new Object[0]);
                    if (responseEntity.getStatusCode() == HttpStatus.OK) {
                        String res = (String)responseEntity.getBody();
                        ObjectMapper objectMapper = new ObjectMapper();
                        try {
                            Map map = (Map)objectMapper.readValue(res, Map.class);
                            LinkedHashMap mapFullExtent = (LinkedHashMap)map.get("fullExtent");
                            resMap.put("left", mapFullExtent.get("xmin"));
                            resMap.put("bottom", mapFullExtent.get("ymin"));
                            resMap.put("right", mapFullExtent.get("xmax"));
                            resMap.put("top", mapFullExtent.get("ymax"));
                            LinkedHashMap mapSpatialReference = (LinkedHashMap)map.get("spatialReference");
                            if (mapSpatialReference.containsKey("wkid")) {
                                resMap.put("wkid", mapSpatialReference.get("wkid"));
                            }
                        }
                        catch (IOException e) {
                            resMap.put("flag", flag);
                            e.printStackTrace();
                        }
                        flag = true;
                        resMap.put("flag", flag);
                        resMap.put("resInfo", res);
                        break block13;
                    }
                    resMap.put("resInfo", "");
                    resMap.put("flag", flag);
                }
                catch (Exception e) {
                    resMap.put("resInfo", "");
                    resMap.put("flag", flag);
                    e.printStackTrace();
                }
            }
            return resMap;
        }
        try {
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)entity, String.class, new Object[0]);
            if (responseEntity.getStatusCode() == HttpStatus.OK) {
                String res = (String)responseEntity.getBody();
                flag = true;
                resMap.put("resInfo", res);
                resMap.put("flag", flag);
            } else {
                resMap.put("resInfo", "");
                resMap.put("flag", flag);
            }
        }
        catch (Exception e) {
            resMap.put("resInfo", "");
            resMap.put("flag", flag);
            e.printStackTrace();
        }
        return resMap;
    }

    @RequestMapping(value={"/getInitExtent"})
    public Object getInitExtent(@RequestParam(name="type") String type, @RequestParam(name="url") String url) {
        HashMap<String, Boolean> resMap;
        block13: {
            resMap = new HashMap<String, Boolean>(16);
            boolean flag = false;
            if (StringUtils.isBlank((String)url) && url.length() == 0) {
                resMap.put("flag", flag);
            } else {
                HttpHeaders headers = new HttpHeaders();
                headers.setContentType(MediaType.APPLICATION_JSON);
                HttpEntity entity = new HttpEntity((MultiValueMap)headers);
                if ("AGS_REST".equals(type) || "AGS_TILE".equals(type) || "AGS_FEATURE".equals(type) || "AGS_VECTOR_TILE".equals(type)) {
                    url = url + "?f=pjson";
                    try {
                        ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)entity, String.class, new Object[0]);
                        if (responseEntity.getStatusCode() == HttpStatus.OK) {
                            String res = (String)responseEntity.getBody();
                            ObjectMapper objectMapper = new ObjectMapper();
                            try {
                                Map map = (Map)objectMapper.readValue(res, Map.class);
                                LinkedHashMap mapFullExtent = (LinkedHashMap)map.get("initialExtent");
                                resMap.put("xmin", (Boolean)mapFullExtent.get("xmin"));
                                resMap.put("ymin", (Boolean)mapFullExtent.get("ymin"));
                                resMap.put("xmax", (Boolean)mapFullExtent.get("xmax"));
                                resMap.put("ymax", (Boolean)mapFullExtent.get("ymax"));
                            }
                            catch (IOException e) {
                                resMap.put("flag", flag);
                                e.printStackTrace();
                            }
                            flag = true;
                            break block13;
                        }
                        resMap.put("flag", flag);
                    }
                    catch (Exception e) {
                        resMap.put("flag", flag);
                        e.printStackTrace();
                    }
                } else {
                    try {
                        ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)entity, String.class, new Object[0]);
                        if (responseEntity.getStatusCode() == HttpStatus.OK) {
                            flag = true;
                            resMap.put("flag", flag);
                        } else {
                            resMap.put("flag", flag);
                        }
                    }
                    catch (Exception e) {
                        resMap.put("flag", flag);
                        e.printStackTrace();
                    }
                }
            }
        }
        return resMap;
    }

    @RequestMapping(value={"/query/myResource"})
    public Page<ResourceView> findMyResources(@RequestParam(name="keyword", required=false) String keyword, Pageable pageable) {
        return this.resourceClient.queryResourceByPublisher(keyword, pageable);
    }

    @RequestMapping(value={"/query/findCatalogResources"})
    public Page<ResourceView> findCatalogResources(String id, Pageable pageable) {
        return this.resourceClient.findCatalogResources(id, pageable);
    }

    @RequestMapping(value={"/query/findCapablesByResource"})
    public List<CapableView> findCapablesByResource(String id) {
        return this.resourceClient.queryResourceCapables(id);
    }

    @RequestMapping(value={"/query/getDataBaseMessage"})
    public DataBaseView getDataBaseMessage(String id) {
        ResourceView resourceView = this.resourceClient.queryResourceById(id);
        DataBaseView dataBaseView = new DataBaseView();
        try {
            if ("\u5c5e\u6027\u670d\u52a1".equals(resourceView.getType())) {
                Map info = (Map)resourceView.getSource();
                Map dataBaseResource = (Map)info.get("dataBaseResource");
                dataBaseView.setDataBaseType(dataBaseResource.get("dataBaseType").toString());
                dataBaseView.setDataType(dataBaseResource.get("dataType").toString());
                dataBaseView.setDbName(dataBaseResource.get("dbName").toString());
                dataBaseView.setIp(dataBaseResource.get("ip").toString());
                dataBaseView.setPort(Integer.valueOf(dataBaseResource.get("port").toString()).intValue());
                dataBaseView.setUsername(dataBaseResource.get("username").toString());
                dataBaseView.setPassword(dataBaseResource.get("password").toString());
                dataBaseView.setTableName(dataBaseResource.get("tableName").toString());
                dataBaseView.setFields(dataBaseResource.get("fields").toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dataBaseView;
    }

    @RequestMapping(value={"/query/getLayerByCapable"})
    public Layer getLayerByCapable(String id) {
        Layer layer = new Layer();
        ResourceView resourceView = this.resourceClient.getResourceByCapable(id);
        CapableView capableView = this.resourceClient.getCapableById(id);
        SpatialCoverage spatialCoverage = new SpatialCoverage();
        layer.setId(capableView.getId());
        layer.setUrl(capableView.getProxyUrl());
        spatialCoverage = resourceView.getSpatialCoverage();
        if (StringUtils.isNotEmpty((String)capableView.getUrl())) {
            if (capableView.getUrl().contains("TDLY") || capableView.getUrl().contains("JBNT") || capableView.getUrl().contains("TDGH")) {
                Map map = (Map)this.getInitExtent(capableView.getTitle(), capableView.getUrl());
                if (map != null) {
                    if (map.containsKey("xmin")) {
                        spatialCoverage.setLeft(((Double)map.get("xmin")).doubleValue());
                    }
                    if (map.containsKey("ymin")) {
                        spatialCoverage.setBottom(((Double)map.get("ymin")).doubleValue());
                    }
                    if (map.containsKey("xmax")) {
                        spatialCoverage.setRight(((Double)map.get("xmax")).doubleValue());
                    }
                    if (map.containsKey("ymax")) {
                        spatialCoverage.setTop(((Double)map.get("ymax")).doubleValue());
                    }
                }
                layer.setZoomOffset(-4);
            } else {
                layer.setZoomOffset(0);
            }
        }
        layer.setSpatialCoverage(spatialCoverage);
        if (StringUtils.isNotEmpty((String)capableView.getUrl()) && capableView.getUrl().contains("172.24.19.51")) {
            layer.setUrl(capableView.getUrl());
        }
        layer.setType(capableView.getType().name());
        layer.setCrs(Integer.valueOf(resourceView.getSpatialCoverage().getWkid()));
        layer.setName(resourceView.getTitle());
        layer.setMaxZoom(10);
        return layer;
    }

    @RequestMapping(value={"/query/findCapableById"})
    public CapableView findCapableById(String id) {
        CapableView capableView = this.resourceClient.getCapableById(id);
        return capableView;
    }

    @PostMapping(value={"/zysq"})
    public Boolean zysq(@RequestBody ResourceApply resourceApply, Principal principal) {
        UserDto user = this.userManagerClient.getUserDetailByUsername(principal.getName());
        List departments = user.getOrgRecordList();
        if (departments.size() > 1) {
            departments.stream().sorted(Comparator.comparing(OrganizationDto::getRegionCode));
        }
        if (departments.size() > 0) {
            resourceApply.setDepartment(((OrganizationDto)departments.get(0)).getName());
        }
        return this.resourceClient.applyResource(resourceApply);
    }

    @PostMapping(value={"/check/apply"})
    public Boolean checkApply(@RequestBody ResourceApply resourceApply) {
        return this.resourceClient.checkApply(resourceApply);
    }

    @PostMapping(value={"/check/backApply"})
    public Boolean backApply(@RequestBody ResourceApply resourceApply) {
        return this.resourceClient.backApply(resourceApply);
    }

    @RequestMapping(value={"/query/findResourceViewByCatalogAndRegionCode"})
    public List<ResourceView> findResourceViewByCatalogAndRegionCode(@RequestParam(name="catalog", required=false) String catalog, @RequestParam(name="type", required=false) String type, @RequestParam(name="region", required=false) String region) {
        return this.resourceClient.condition2(catalog, type, region);
    }

    @PostMapping(value={"/findDataBaseMessage"})
    public List<TableInfo> findDataBaseMessage(@RequestBody DataBase dataBase) {
        return this.dbhClient.getTablesByDB(dataBase);
    }

    @PostMapping(value={"/findDataBaseByUserSelectedMessage"})
    public List<Map> findDataBaseByUserSelectedMessage(@RequestParam(name="id") String id, @RequestParam(name="paramString") String paramString) {
        return this.dbhClient.getMapList(id, paramString);
    }

    @PostMapping(value={"/publishDataBaseMessage"})
    public Object publishDataBaseMessage(@RequestBody DataBase dataBase) {
        return this.dbhClient.tableCon(dataBase);
    }

    @GetMapping(value={"/query/queryApplyById"})
    public ResourceApply queryApplyById(String id) {
        ResourceApply resourceApply = this.resourceClient.queryApplyById(id);
        return resourceApply;
    }

    @RequestMapping(value={"/query/getUploadFile"})
    public Object getUploadFile(String id) {
        try {
            return this.storageClient.listAllSubsetStorages(id, null, Integer.valueOf(1), null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @RequestMapping(value={"/history/process/unchecked"})
    public Page<ResourceApply> applyIsendAndUnCheck(@RequestParam(name="keyword", required=false) String keyword, Pageable pageable) {
        return this.resourceClient.applyIsendAndUnCheck(keyword, pageable);
    }

    @RequestMapping(value={"/history/process/checked"})
    public Page<ResourceApply> applyIsendAndChecked(@RequestParam(name="keyword", required=false) String keyword, Pageable pageable) {
        return this.resourceClient.applyIsendAndChecked(keyword, pageable);
    }

    @RequestMapping(value={"/history/process/turnBack"})
    public Page<ResourceApply> applyTurnBack(@RequestParam(name="keyword", required=false) String keyword, Pageable pageable) {
        return this.resourceClient.applyTurnBack(keyword, pageable);
    }

    @RequestMapping(value={"/query/active/tasks/undo"})
    public Page<ResourceApply> applyINeedCheck(@RequestParam(name="keyword", required=false) String keyword, Pageable pageable) {
        return this.resourceClient.applyINeedCheck(keyword, pageable);
    }

    @RequestMapping(value={"/query/active/tasks"})
    public Page<ResourceApply> applyIChecked(@RequestParam(name="keyword", required=false) String keyword, Pageable pageable) {
        return this.resourceClient.applyIChecked(keyword, pageable);
    }

    @RequestMapping(value={"/query/condition2/pageable"})
    public Page<ResourceView> queryPageResourceByCondition2(@RequestParam(name="catalog[]", required=false) String[] catalogId, @RequestParam(name="type", required=false) String type, @RequestParam(name="region", required=false) String regionCode, @RequestParam(name="keyword", required=false) String keyword, @RequestParam(name="wkid", required=false) Integer wkid, @RequestParam(name="fwlx", required=false) String fwlx, Pageable pageable) {
        return this.resourceClient.queryPageResourceByCondition2(catalogId, type, regionCode, keyword, wkid, fwlx, pageable);
    }

    @RequestMapping(value={"/query/condition3/pageable"})
    public Page<ResourceView> queryPageResourceByCondition3(@RequestParam(name="catalog[]", required=false) String[] catalogId, @RequestParam(name="type", required=false) String type, @RequestParam(name="region", required=false) String regionCode, @RequestParam(name="keyword", required=false) String keyword, @RequestParam(name="wkid", required=false) Integer wkid, @RequestParam(name="fwlx", required=false) String fwlx, Pageable pageable) {
        return this.resourceClient.queryPageResourceByCondition3(catalogId, type, regionCode, keyword, wkid, fwlx, pageable);
    }

    @RequestMapping(value={"/query/getStorageUrl"})
    public Object getStorageUrl() {
        String storageUrl = ((ServiceInstance)this.discoveryClient.getInstances("storage-app").get(0)).getUri().toString();
        List dictList = new ArrayList();
        try {
            dictList = this.dictClient.findDefaultDicts(this.dictClient.findValueByKey("serverMapping").getId());
        }
        catch (Exception e) {
            this.logger.error("\u8bf7\u786e\u8ba4serverMapping\u5b57\u5178\u9879\u662f\u5426\u914d\u7f6e\u6b63\u786e");
        }
        return ResourceRestController.mappingUrl((String)storageUrl, dictList);
    }

    @RequestMapping(value={"/query/findKeywordByStr"})
    public List<Keyword> findKeywordByStr(@RequestParam(name="strContent", required=false) String strContent) {
        return this.keywordClient.findKeywordByStr(strContent);
    }

    @RequestMapping(value={"/query/findUserByStr"})
    public List<UserDto> findUserByStr(@RequestParam(name="strContent", required=false) String strContent) {
        PageRequest pageable = new PageRequest(0, 1000);
        Page userDtoPage = this.userManagerClient.listUsers(strContent, null, Integer.valueOf(1), (Pageable)pageable);
        List userDtoList = null;
        if (userDtoPage != null) {
            userDtoList = userDtoPage.getContent();
        }
        return userDtoList;
    }

    @RequestMapping(value={"/query/getRoleList"})
    public List<RoleDto> getRoleList(Pageable pageable) {
        return this.roleManagerClient.getEnabledRoleList();
    }

    @RequestMapping(value={"/getUser"})
    public String getUser(Principal principal) {
        UserDto user = this.userManagerClient.getUserDetailByUsername(principal.getName());
        return user.getAlias();
    }

    @RequestMapping(value={"/getUserPermissions"})
    public Map getCurrentUserPermissions(Principal principal, @RequestParam(name="type", required=false) String type) {
        String mapUrl = "";
        String accountUiUrl = "";
        String censusUrl = "";
        String contentsUrl = "";
        String shareUrl = "";
        String resourceUiUrl = "";
        List dictList = new ArrayList();
        try {
            dictList = this.dictClient.findDefaultDicts(this.dictClient.findValueByKey("serverMapping").getId());
        }
        catch (Exception e) {
            this.logger.error("\u8bf7\u786e\u8ba4serverMapping\u5b57\u5178\u9879\u662f\u5426\u914d\u7f6e\u6b63\u786e", (Throwable)e);
        }
        List map = this.discoveryClient.getInstances("data-map");
        List accountUi = this.discoveryClient.getInstances("account-ui");
        List census = this.discoveryClient.getInstances("census-app");
        List contents = this.discoveryClient.getInstances("contents-app");
        List share = this.discoveryClient.getInstances("share-app");
        List resourceUI = this.discoveryClient.getInstances("resource-ui");
        if (!CollectionUtils.isEmpty((Collection)map)) {
            mapUrl = ((ServiceInstance)map.get(0)).getUri().toString();
        }
        if (!CollectionUtils.isEmpty((Collection)accountUi)) {
            accountUiUrl = ((ServiceInstance)accountUi.get(0)).getUri().toString();
        }
        if (!CollectionUtils.isEmpty((Collection)census)) {
            censusUrl = ((ServiceInstance)census.get(0)).getUri().toString();
        }
        if (!CollectionUtils.isEmpty((Collection)contents)) {
            contentsUrl = ((ServiceInstance)contents.get(0)).getUri().toString();
        }
        if (!CollectionUtils.isEmpty((Collection)share)) {
            shareUrl = ((ServiceInstance)share.get(0)).getUri().toString();
        }
        if (!CollectionUtils.isEmpty((Collection)resourceUI)) {
            resourceUiUrl = ((ServiceInstance)resourceUI.get(0)).getUri().toString();
        }
        mapUrl = ResourceRestController.mappingUrl((String)mapUrl, dictList);
        accountUiUrl = ResourceRestController.mappingUrl((String)accountUiUrl, dictList);
        censusUrl = ResourceRestController.mappingUrl((String)censusUrl, dictList);
        contentsUrl = ResourceRestController.mappingUrl((String)contentsUrl, dictList);
        shareUrl = ResourceRestController.mappingUrl((String)shareUrl, dictList);
        resourceUiUrl = ResourceRestController.mappingUrl((String)resourceUiUrl, dictList);
        String commonUser = "user";
        HashMap<String, Object> resMap = new HashMap<String, Object>(16);
        UserDto user = this.userManagerClient.getUserDetailByUsername(principal.getName());
        List departments = this.userManagerClient.findOrgs(user.getId());
        List<RoleDto> roleList = this.userManagerClient.findAllRoles(user.getId());
        roleList = roleList.stream().filter(role -> !commonUser.equals(role.getName())).collect(Collectors.toList());
        ArrayList menuRoleRefs = new ArrayList();
        roleList.forEach(role -> menuRoleRefs.addAll(this.menuClient.queryMenuRoleRefsByRoleId(role.getId())));
        List menuList = this.menuClient.findListMenuByIdAndAndTypeAndParentIsNullOrderByWeightAsc(menuRoleRefs, type);
        List resMenuList = menuList.stream().filter(menu -> menu != null).sorted(Comparator.comparing(MenuView::getWeight)).collect(Collectors.toList());
        ArrayList tplIds = new ArrayList();
        roleList.forEach(r -> tplIds.addAll(this.tplClient.queryTplRoleRefsByRoleId(r.getId())));
        List tplList = this.tplClient.queryTplsByIdExceptContent(tplIds);
        resMap.put("orginMenuPermissionIds", menuRoleRefs);
        resMap.put("menuPermissions", resMenuList);
        resMap.put("tplList", tplList);
        if (departments.size() > 1) {
            departments.stream().sorted(Comparator.comparing(OrganizationDto::getRegionCode));
        }
        resMap.put("department", departments.get(0));
        resMap.put("departmentLists", departments);
        resMap.put("user", user.getAlias());
        resMap.put("loginName", user.getUsername());
        resMap.put("mapUrl", mapUrl);
        resMap.put("accountUiUrl", accountUiUrl);
        resMap.put("censusUrl", censusUrl);
        resMap.put("contentsUrl", contentsUrl);
        resMap.put("shareUrl", shareUrl);
        resMap.put("resourceUiUrl", resourceUiUrl);
        return resMap;
    }

    @RequestMapping(value={"/user/getUser"})
    public Map<String, Object> getUserRelInfo(Principal principal) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        if (principal != null) {
            map.put("name", principal.getName());
            UserDto user = this.userManagerClient.getUserByUsername(principal.getName());
            map.put("alias", user.getAlias());
            List roleList = this.userManagerClient.findAllRoles(user.getId());
            if (!CollectionUtils.isEmpty((Collection)roleList)) {
                ArrayList role = new ArrayList();
                roleList.forEach(r -> role.add(MapUtils.getString((Map)map, (Object)"name")));
                map.put("role", role);
            }
        }
        return map;
    }

    @RequestMapping(value={"/user/info"})
    public UserView getUserInfo(Principal principal) {
        UserView userView = new UserView();
        UserDto userDto = this.userManagerClient.getUserDetailByUsername(principal.getName());
        if (userDto != null) {
            userView.setUsername(userDto.getUsername());
            userView.setAlias(userDto.getAlias());
            userView.setPassword(userDto.getPassword());
            userView.setId(userDto.getId());
            UserInfo userInfo = new UserInfo(userDto.getBirthday(), null, userDto.getEmail(), userDto.getMobile(), userDto.getTel(), userDto.getAddress(), null, userDto.getResume());
            userInfo.setId(userDto.getId());
            userView.setUserInfo(userInfo);
        }
        return userView;
    }

    @PostMapping(value={"/user/saveUserInfo"})
    public Boolean saveUserInfo(@RequestBody UserView userView, Principal principal) {
        UserDto user = this.userManagerClient.getUserDetailByUsername(principal.getName());
        String userId = user.getId();
        BeanUtil.copyBean((Object)userView, (Object)user, (String[])new String[0]);
        user.setId(userId);
        if (user != null && StringUtils.isNotBlank((String)user.getId())) {
            this.userManagerClient.updateUserInfo(user.getId(), user);
        }
        return true;
    }

    @RequestMapping(value={"/user/saveUserPassword"})
    public Boolean saveUserPassword(String password, Principal principal) {
        UserDto user = this.userManagerClient.getUserDetailByUsername(principal.getName());
        if (user != null && StringUtils.isNotBlank((String)user.getId())) {
            user.setPassword(password);
            this.userManagerClient.updateUserInfo(user.getId(), user);
        }
        return true;
    }

    @RequestMapping(value={"/user/checkUserPassword"})
    public Boolean checkUserPassword(String password, Principal principal) {
        UserDto user = this.userManagerClient.getUserDetailByUsername(principal.getName());
        return this.userManagerClient.checkUserPassword(password, user.getId());
    }

    @RequestMapping(value={"/grantAthority"})
    public Boolean grantAthority(@RequestParam(name="user", required=false) String user, @RequestParam(name="role", required=false) String role, @RequestParam(name="departments[]", required=false) String[] departments, @RequestParam(name="resourceId", required=false) String resourceId, @RequestParam(name="capable", required=false) String capable, Principal principal) {
        if (!user.equals(principal.getName())) {
            return this.resourceClient.grantAthority(user, role, departments, resourceId, capable);
        }
        return false;
    }

    @RequestMapping(value={"/backAuthority"})
    public Boolean backAuthority(@RequestParam(name="id", required=false) String id) {
        return this.resourceClient.backAthority(id);
    }

    @RequestMapping(value={"/query/getSpatial"})
    public Object getSpatial(@RequestParam(name="xzqdms[]", required=false) String[] xzqdms, @RequestParam(value="isChecked_2000") String isChecked_2000) {
        String raw_xzq_c_2k = "raw_xzq_c_2016_2k";
        String raw_xzq_c = "raw_xzq_c";
        String raw_xzq_d_2k = "raw_xzq_d_2016_2k";
        String raw_xzq_d = "raw_xzq_d";
        raw_xzq_c_2k = this.dictClient.findValueByKey("raw_xzq_c_2k").getValue();
        raw_xzq_c = this.dictClient.findValueByKey("raw_xzq_c_80").getValue();
        raw_xzq_d_2k = this.dictClient.findValueByKey("raw_xzq_d_2k").getValue();
        raw_xzq_d = this.dictClient.findValueByKey("raw_xzq_d_80").getValue();
        String searchConditionName = "";
        ArrayList<String> geometryList = new ArrayList<String>();
        HashMap<String, String> map = new HashMap<String, String>(16);
        for (String regionCode : xzqdms) {
            searchConditionName = regionCode.length() == 4 ? ("2000".equals(isChecked_2000) ? raw_xzq_c_2k : raw_xzq_c) : ("2000".equals(isChecked_2000) ? raw_xzq_d_2k : raw_xzq_d);
            map.put("XZQDM", regionCode);
            Page featurePage = this.esAttributeQueryClient.exactQuery(map, searchConditionName);
            Feature.Geometry tempGeometry = null;
            String geometry = "";
            if (featurePage != null && !CollectionUtils.isEmpty((Collection)featurePage.getContent())) {
                tempGeometry = ((Feature)featurePage.getContent().get(0)).getGeometry();
                geometry = tempGeometry != null ? JSONObject.toJSONString((Object)tempGeometry) : "";
            }
            if (!StringUtils.isNotBlank((String)geometry)) continue;
            geometryList.add(geometry);
        }
        return geometryList;
    }

    @RequestMapping(value={"/query/getShapeFileSpatialUrl"})
    public Object getShapeFileSpatialUrl() {
        String shapefileSpatialUrl = ((ServiceInstance)this.discoveryClient.getInstances("resource-ui").get(0)).getUri().toString();
        List dictList = new ArrayList();
        try {
            dictList = this.dictClient.findDefaultDicts(this.dictClient.findValueByKey("serverMapping").getId());
        }
        catch (Exception e) {
            this.logger.error("\u8bf7\u786e\u8ba4serverMapping\u5b57\u5178\u9879\u662f\u5426\u914d\u7f6e\u6b63\u786e:", (Throwable)e);
        }
        return ResourceRestController.mappingUrl((String)shapefileSpatialUrl, dictList);
    }

    @PostMapping(value={"/query/getShapeFileSpatial"})
    public Object getShapeFileSpatial(@RequestParam(name="file") MultipartFile file) {
        MultipartDto multipartDto = new MultipartDto();
        multipartDto.setName(file.getName());
        multipartDto.setOriginalFilename(file.getOriginalFilename());
        multipartDto.setContentType(file.getContentType());
        multipartDto.setSize(file.getSize());
        try {
            multipartDto.setData(file.getBytes());
        }
        catch (IOException e) {
            this.logger.error("errorMsg\uff1a", (Throwable)e);
        }
        multipartDto.setSpaceCode("tddc");
        multipartDto.setClientId(this.resourceUiClientId);
        StorageDto storages = this.storageClient.multipartUpload(multipartDto);
        String path = Paths.get("upload/", new String[0]).toAbsolutePath().toString();
        String zippath = path + File.separator + UUID.randomUUID().toString();
        Map<String, String> resMap = new HashMap<String, String>(16);
        File tempFile = new File(path);
        if (!tempFile.exists()) {
            tempFile.mkdirs();
        }
        path = path + File.separator + file.getOriginalFilename();
        if (!file.isEmpty()) {
            try {
                file.transferTo(new File(path));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        File downloadFile = new File(path);
        List files = ZipUtil.upzipFile((File)downloadFile, (String)zippath);
        for (File f : files) {
            String fileName = f.getName();
            if (!f.isFile() || !".shp".equals(fileName.substring(fileName.lastIndexOf(".")))) continue;
            resMap = this.getShapeFile(f);
        }
        if (!FileUtil.deleteDir((File)new File(zippath))) {
            this.logger.warn("\u5220\u9664ZIP\u89e3\u538b\u6587\u4ef6\u5939\u65f6\u53ef\u80fd\u5b58\u5728\u9519\u8bef");
        }
        resMap.put("storageId", storages.getId());
        return resMap;
    }

    private Map getShapeFile(File file) {
        String result = "outOfSize";
        Shp2Geojson shp2GeoJson = new Shp2Geojson();
        FeatureCollection featureCollection = shp2GeoJson.getFromShpFile(file);
        String tempfeatureCollection = featureCollection.toJson();
        int geoJsonLength = tempfeatureCollection.length();
        HashMap<String, String> map = new HashMap<String, String>(16);
        if (geoJsonLength <= this.geoJsonLengthConfig.getGeoJsonLength()) {
            map.put("result", tempfeatureCollection);
        } else {
            map.put("result", result);
        }
        return map;
    }

    @RequestMapping(value={"/getShapleZipStorageId"})
    public Object getShapleZipStorageId(@RequestParam(name="taskIds") String taskIds) {
        List resultBeanList = this.sdeClient.getQueryResult(taskIds);
        return resultBeanList;
    }

    @RequestMapping(value={"/sde/getDataSourceList"})
    public List<String> getDataSourceList() {
        return this.sdeClient.getDataSourceList();
    }

    @PostMapping(value={"/query/getShapeFileByRegionCode"})
    public Object getShapeFileByRegionCode(@RequestBody Map params) {
        try {
            String regionCode = params.get("regionCode").toString();
            String ndType = params.get("ndType").toString();
            String startNd = params.get("startNd").toString();
            String endNd = params.get("endNd").toString();
            String layerNames = params.get("layerNames").toString();
            String fileNames = params.get("fileNames").toString();
            Map whereMap = this.getWhereMap(layerNames, regionCode, ndType, startNd, endNd);
            String wheres = JSONObject.toJSONString((Object)whereMap);
            String dataSource = params.get("dataSource").toString();
            String resourceId = params.get("resId").toString();
            ResourceView resourceView = this.resourceClient.queryResourceById(resourceId);
            List capableViewList = resourceView.getCapables();
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < capableViewList.size() - 1; ++i) {
                if (StringUtils.isNotBlank((String)stringBuilder.toString())) {
                    stringBuilder.append(",").append(((CapableView)capableViewList.get(i)).getId());
                    continue;
                }
                stringBuilder.append(((CapableView)capableViewList.get(i)).getId());
            }
            ResultBean resultBean = this.sdeClient.queryDownloadByAttribute(stringBuilder.toString(), layerNames, fileNames, wheres, null, dataSource);
            return resultBean.isSuccess();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "success";
        }
    }

    @PostMapping(value={"/query/getShapeFileByGeometry"})
    public Object getShapeFileByGeometry(@RequestBody Map params) {
        try {
            String regionCode = params.get("regionCode").toString();
            String nd = params.get("nd").toString();
            String ndType = params.get("ndType").toString();
            String startNd = params.get("startNd").toString();
            String endNd = params.get("endNd").toString();
            String layerNames = params.get("layerNames").toString();
            Map whereMap = this.getWhereMap(layerNames, regionCode, ndType, startNd, endNd);
            params.put("wheres", JSONObject.toJSON((Object)whereMap).toString());
            params.put("columns", null);
            String resourceId = params.get("resId").toString();
            ResourceView resourceView = this.resourceClient.queryResourceById(resourceId);
            List capableViewList = resourceView.getCapables();
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < capableViewList.size() - 1; ++i) {
                if (StringUtils.isNotBlank((String)stringBuilder.toString())) {
                    stringBuilder.append(",").append(((CapableView)capableViewList.get(i)).getId());
                    continue;
                }
                stringBuilder.append(((CapableView)capableViewList.get(i)).getId());
            }
            params.put("taskIds", stringBuilder.toString());
            ResultBean resultBean = this.sdeClient.queryDownloadBySpaceAttribute(params);
            return resultBean.isSuccess();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "fail";
        }
    }

    @RequestMapping(value={"/updateResourceCapablesForStorageIds"})
    public Object updateResourceCapablesForStorageIds(@RequestParam(value="resId") String resId, @RequestParam(value="capableId") String capableId, @RequestParam(name="storageId", required=false) String storageId, @RequestParam(name="code") String code) {
        String tempStorageUrl;
        String storageUrl = ((ServiceInstance)this.discoveryClient.getInstances("storage-app").get(0)).getUri().toString();
        List dictList = new ArrayList();
        try {
            dictList = this.dictClient.findDefaultDicts(this.dictClient.findValueByKey("serverMapping").getId());
        }
        catch (Exception e) {
            this.logger.error("\u8bf7\u786e\u8ba4serverMapping\u5b57\u5178\u9879\u662f\u5426\u914d\u7f6e\u6b63\u786e\uff1a", (Throwable)e);
        }
        storageUrl = ResourceRestController.mappingUrl((String)storageUrl, dictList) + "/storage/rest/files/download/";
        ResourceView resourceView = this.resourceClient.queryResourceById(resId);
        List capableViewList = resourceView.getCapables();
        String[] tempCapableIdArrs = capableId.split(",");
        String[] storageIdArrs = storageId.split(",");
        String[] codeArrs = code.split(",");
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < tempCapableIdArrs.length; ++i) {
            if (!((CapableView)capableViewList.get(i)).getId().equals(tempCapableIdArrs[i])) continue;
            tempStorageUrl = storageUrl + storageIdArrs[i];
            if (!TaskStatusCode.NO_DATA.getCode().equals(codeArrs[i]) || !TaskStatusCode.RUNNING.getCode().equals(codeArrs[i])) {
                if (StringUtils.isNotBlank((String)stringBuilder.toString())) {
                    stringBuilder.append(",").append(storageIdArrs[i]);
                } else {
                    stringBuilder.append(storageIdArrs[i]);
                }
                ((CapableView)capableViewList.get(i)).setInfo((Object)tempStorageUrl);
                ((CapableView)capableViewList.get(i)).setUrl(tempStorageUrl);
            }
            ((CapableView)capableViewList.get(i)).setCode(codeArrs[i]);
        }
        if (stringBuilder.length() > 0) {
            String finalStorageId = this.storageClient.zipStorages(stringBuilder.toString(), "", "", "").getId();
            tempStorageUrl = storageUrl + finalStorageId;
            ((CapableView)capableViewList.get(capableViewList.size() - 1)).setInfo((Object)tempStorageUrl);
            ((CapableView)capableViewList.get(capableViewList.size() - 1)).setUrl(tempStorageUrl);
            ((CapableView)capableViewList.get(capableViewList.size() - 1)).setCode(TaskStatusCode.SUCCESS.getCode());
        }
        resourceView.setCapables(capableViewList);
        return this.resourceClient.saveResource(resourceView);
    }

    private Map getWhereMap(String layerNames, String regionCode, String ndType, String startNd, String endnd) {
        HashMap<String, String> whereMap = new HashMap<String, String>(16);
        String[] aLayerNames = layerNames.split(",");
        String ndCondition = "";
        for (String tempStr : aLayerNames) {
            String str = tempStr.split("\\.")[1];
            if ("tdzz_320000".equals(str)) {
                if ("1".equals(ndType)) {
                    ndCondition = "";
                } else if ("2".equals(ndType)) {
                    ndCondition = startNd.equals(endnd) ? "to_char(YSRQ,'yyyy-mm-dd') = '" + startNd + "'" : "'" + startNd + "'" + " <= to_char(YSRQ,'yyyy--mm-dd') and to_char(YSRQ,'yyyy--mm-dd') <= " + "'" + endnd + "'";
                }
                whereMap.put(str, ndCondition);
                continue;
            }
            if ("bpdk_320000".equals(str)) {
                if ("1".equals(ndType)) {
                    ndCondition = "";
                } else if ("2".equals(ndType)) {
                    ndCondition = startNd.equals(endnd) ? "to_char(PZRQ,'yyyy-mm-dd') = '" + startNd + "'" : "'" + startNd + "'" + " <= to_char(PZRQ,'yyyy-mm-dd') and to_char(PZRQ,'yyyy-mm-dd') <= " + "'" + endnd + "'";
                }
                whereMap.put(str, ndCondition);
                continue;
            }
            if (!"gddk_320000".equals(str)) continue;
            if ("1".equals(ndType)) {
                ndCondition = "";
            } else if ("2".equals(ndType)) {
                ndCondition = startNd.equals(endnd) ? "to_char(QD_RQ,'yyyy-mm-dd') = '" + startNd + "'" : "'" + startNd + "'" + " <= to_char(QD_RQ,'yyyy-mm-dd') and to_char(QD_RQ,'yyyy-mm-dd') <= " + "'" + endnd + "'";
            }
            whereMap.put(str, ndCondition);
        }
        return whereMap;
    }

    @GetMapping(value={"/getAnnouncementByPage"})
    Page<Announcement> getAnnouncementByPage(@RequestParam(name="title") String title, Pageable pageable) {
        return this.announcementClient.getAnnouncementByPage(title, pageable);
    }

    @GetMapping(value={"/getAnnouncementByPublisher"})
    Page<Announcement> getAnnouncementByPublisher(@RequestParam(name="title") String title, Principal principal, Pageable pageable) {
        return this.announcementClient.getAnnouncementByPublisher(title, principal.getName(), pageable);
    }

    @RequestMapping(value={"/saveAnnouncement"})
    public Boolean saveAnnouncement(@RequestBody Announcement announcement, Principal principal) {
        announcement.setUsername(principal.getName());
        return this.announcementClient.saveAnnouncement(announcement);
    }

    @RequestMapping(value={"/deleteAnnouncement"})
    public Boolean deleteAnnouncement(@RequestParam(name="id") String id) {
        return this.announcementClient.deleteAnnouncement(id);
    }

    @RequestMapping(value={"/findAnnouncement"})
    public Announcement findAnnouncement(@RequestParam(name="id") String id) {
        return this.announcementClient.findAnnouncement(id);
    }

    @RequestMapping(value={"/updateAnnouncement"})
    public boolean updateAnnouncement(@RequestBody Announcement announcement) {
        return this.announcementClient.updateAnnouncement(announcement);
    }

    @RequestMapping(value={"/query/getSystemUrls"})
    public Object getSystemUrls() {
        ArrayList<String> appList = new ArrayList<String>();
        appList.add(this.systemUrlsConfig.getAccountApp());
        appList.add(this.systemUrlsConfig.getAdminApp());
        appList.add(this.systemUrlsConfig.getCollectorApp());
        appList.add(this.systemUrlsConfig.getDev());
        appList.add(this.systemUrlsConfig.getGatewayApp());
        appList.add(this.systemUrlsConfig.getGisCluster());
        appList.add(this.systemUrlsConfig.getGisSde());
        appList.add(this.systemUrlsConfig.getGisSearch());
        appList.add(this.systemUrlsConfig.getLogApp());
        appList.add(this.systemUrlsConfig.getRegionApp());
        appList.add(this.systemUrlsConfig.getResourceAggregate());
        appList.add(this.systemUrlsConfig.getResourceCore());
        appList.add(this.systemUrlsConfig.getResourceDbh());
        appList.add(this.systemUrlsConfig.getResourceProxy());
        appList.add(this.systemUrlsConfig.getResourceUi());
        appList.add(this.systemUrlsConfig.getStorageApp());
        appList.add(this.systemUrlsConfig.getWorkflowApp());
        return this.getUrlsByApps(appList);
    }

    private Map getUrlsByApps(List<String> appLists) {
        HashMap<String, String> resMap = new HashMap<String, String>(16);
        for (String app : appLists) {
            List list = this.discoveryClient.getInstances(app);
            if (CollectionUtils.isEmpty((Collection)list)) continue;
            String url = ((ServiceInstance)this.discoveryClient.getInstances(app).get(0)).getUri().toString();
            List dictList = new ArrayList();
            try {
                dictList = this.dictClient.findDefaultDicts(this.dictClient.findValueByKey("serverMapping").getId());
            }
            catch (Exception e) {
                this.logger.error("\u8bf7\u786e\u8ba4serverMapping\u5b57\u5178\u9879\u662f\u5426\u914d\u7f6e\u6b63\u786e:", (Throwable)e);
            }
            resMap.put(app.replaceAll("-", ""), ResourceRestController.mappingUrl((String)url, dictList));
        }
        return resMap;
    }

    @RequestMapping(value={"/redictToAdmin"})
    public String redictToAdmin() {
        String client = "account-ui";
        String url = "";
        List instances = this.discoveryClient.getInstances(client);
        List dictList = new ArrayList();
        try {
            dictList = this.dictClient.findDefaultDicts(this.dictClient.findValueByKey("serverMapping").getId());
        }
        catch (Exception e) {
            this.logger.error("\u8bf7\u786e\u8ba4serverMapping\u5b57\u5178\u9879\u662f\u5426\u914d\u7f6e\u6b63\u786e:", (Throwable)e);
        }
        if (instances.size() > 0) {
            url = ((ServiceInstance)instances.get(0)).getUri().toString();
        }
        return ResourceRestController.mappingUrl((String)url, dictList);
    }

    private String mapUrlForSt(String url) {
        if (url.contains("172.18.2.19")) {
            url = url.replaceAll("172.18.2.19", "172.23.22.21");
        } else if (url.contains("172.18.2.91")) {
            url = url.replaceAll("172.18.2.91", "172.23.22.22");
        } else if (url.contains("172.18.2.92")) {
            url = url.replaceAll("172.18.2.92", "172.23.22.23");
        }
        return url;
    }

    @GetMapping(value={"/getdownloadUrl/{id}"})
    public String getdownloadUrl(@PathVariable(name="id") String id) {
        String storageUrl = ((ServiceInstance)this.discoveryClient.getInstances("storage-app").get(0)).getUri().toString();
        List dictList = new ArrayList();
        try {
            dictList = this.dictClient.findDefaultDicts(this.dictClient.findValueByKey("serverMapping").getId());
        }
        catch (Exception e) {
            this.logger.error("\u8bf7\u786e\u8ba4serverMapping\u5b57\u5178\u9879\u662f\u5426\u914d\u7f6e\u6b63\u786e:", (Throwable)e);
        }
        storageUrl = ResourceRestController.mappingUrl((String)storageUrl, dictList) + "/storage/rest/files/download/" + id;
        return storageUrl;
    }

    @PostMapping(value={"/upload"}, produces={"application/json;charset=UTF-8"}, consumes={"multipart/form-data"})
    StorageDto[] upload(@RequestPart(name="file") MultipartFile files) {
        MultipartDto multipartDto = new MultipartDto();
        multipartDto.setName(files.getName());
        multipartDto.setOriginalFilename(files.getOriginalFilename());
        multipartDto.setContentType(files.getContentType());
        multipartDto.setSize(files.getSize());
        try {
            multipartDto.setData(files.getBytes());
        }
        catch (IOException e) {
            this.logger.error("errorMsg\uff1a", (Throwable)e);
        }
        return new StorageDto[]{this.storageClient.multipartUpload(multipartDto)};
    }

    @GetMapping(value={"/getStorage/{id}"})
    public List<StorageDto> getStorage(@PathVariable(name="id") String id) {
        ArrayList<StorageDto> storageDtoList = new ArrayList<StorageDto>();
        for (String arr : id.split(",")) {
            StorageDto storageDto = this.storageClient.findById(arr);
            storageDtoList.add(storageDto);
        }
        return storageDtoList;
    }

    @RequestMapping(value={"/query/getSpatialCoverageRefList"})
    public List<SpatialCoverageRef> getSpatialCoverageRefList() {
        return this.resourceClient.getSpatialCoverageRefList();
    }

    @RequestMapping(value={"/query/getDefaultRegionCode"})
    public String getDefaultRegionCode() {
        String regioncode = "";
        try {
            if (this.dictClient.findValueByKey("regioncodeconfig") != null) {
                regioncode = this.dictClient.findValueByKey("regioncodeconfig").getValue();
            }
        }
        catch (Exception e) {
            this.logger.error("error:", (Throwable)e);
        }
        return regioncode;
    }

    @RequestMapping(value={"/query/getDefaultLogoAndTItle"})
    public Object getDefaultLogoAndTItle() {
        HashMap<String, String> resMap = new HashMap<String, String>(16);
        resMap.put("title", this.appBrand.getTitle());
        resMap.put("subTitle", this.appBrand.getSubTitle());
        resMap.put("logo", this.appBrand.getLogo());
        return resMap;
    }

    @GetMapping(value={"/query/queryMapResourceByCondition"})
    public Page<ResourceLayer> queryMapResourceByCondition(@RequestParam(name="keyword", required=false) String keyword, @RequestParam(name="catalogId", required=false) String catalogId, @RequestParam(name="type", required=false) String type, Pageable pageable) {
        return this.resourceClient.queryMapResourceByCondition(keyword, catalogId, type, pageable);
    }

    @RequestMapping(value={"/check/checkLayerNamesExist"})
    public Object checkLayerNamesExist(@RequestParam(name="bussinessTypeData[]", required=false) String[] bussinessTypeData) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("result", true);
        for (String str : bussinessTypeData) {
            boolean res = this.sdeClient.checkLayer(str.split(":")[1]);
            if (res) continue;
            map.put("message", "\u56fe\u5c42\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u786e\u8ba4\u4e1a\u52a1\u56fe\u5c42\u662f\u5426\u6b63\u786e\u914d\u7f6e:" + str.split(":")[0]);
            map.put("result", false);
            return map;
        }
        return map;
    }

    @RequestMapping(value={"/getLayers"})
    public List<String> getLayers(@RequestParam(value="dataSource") String dataSource) {
        return this.sdeClient.getLayers(dataSource);
    }

    @RequestMapping(value={"/getTables"})
    public List<String> getTables(@RequestParam(value="dataSource") String dataSource) {
        return this.sdeClient.getTables(dataSource, 4);
    }

    private static String mappingUrl(String mappingUrl, List<Dict> dictList) {
        ArrayList<String> urlList = new ArrayList<String>();
        if (!CollectionUtils.isEmpty(dictList)) {
            for (Dict dict : dictList) {
                urlList.add(dict.getValue());
            }
        }
        return Utils.urlMapping((String)mappingUrl, urlList);
    }

    @RequestMapping(value={"/head/getUserPermissions"})
    public Map headUserPermissions(Principal principal, @RequestParam(name="type", required=false) String type) {
        return this.getCurrentUserPermissions(principal, type);
    }
}

