/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtcc.gis.resource.ui.web.rest;

import cn.gtmap.gtc.clients.RegionManagerClient;
import cn.gtmap.gtc.sso.domain.dto.RegionDto;
import cn.gtmap.gtcc.gis.resource.ui.config.RegionConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
@RequestMapping(value={"/rest/region"})
public class RegionController {
    @Autowired
    private RegionManagerClient regionManagerClient;
    @Autowired
    private RegionConfig regionConfig;

    @Autowired
    public RegionController(RegionManagerClient regionManagerClient) {
        this.regionManagerClient = regionManagerClient;
    }

    @RequestMapping(value={"/getAllRegions"})
    public Object getAllCatalog(@RequestParam(name="regionCode", required=false) String regionCode) {
        if (StringUtils.isBlank((String)regionCode)) {
            regionCode = this.regionConfig.getRegioncode();
        }
        List regionList = this.regionManagerClient.findJuniorRegionsEnabled(this.regionManagerClient.findRegionByCode(regionCode).getId());
        RegionDto tempRegion = new RegionDto();
        List mapList = new ArrayList();
        if (regionCode.length() == 4) {
            tempRegion = this.regionManagerClient.findRegionByCode(regionCode);
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            map.put("value", tempRegion.getCode());
            map.put("label", tempRegion.getName());
            map.put("children", this.getAllRegions(regionList));
            mapList.add(map);
        } else {
            mapList = this.getAllRegions(regionList);
        }
        return mapList;
    }

    private List<Map> getAllRegions(List<RegionDto> regionList) {
        ArrayList<Map> mapList = new ArrayList<Map>();
        if (!CollectionUtils.isEmpty(regionList)) {
            for (RegionDto region : regionList) {
                if (region.getEnabled() != 1) continue;
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("value", region.getCode());
                map.put("label", region.getName());
                map.put("checked", false);
                List tempRegionList = this.regionManagerClient.findJuniorRegionsEnabled(region.getId());
                if (!CollectionUtils.isEmpty((Collection)tempRegionList) && tempRegionList.size() > 0) {
                    map.put("children", this.getAllRegions(tempRegionList));
                }
                mapList.add(map);
            }
            return mapList;
        }
        return new ArrayList<Map>();
    }

    @RequestMapping(value={"/getAllRegionsFilterMunicipalDistrict"})
    public Object getAllRegionsFilterMunicipalDistrict(@RequestParam(name="regionCode", required=false) String regionCode) {
        if (StringUtils.isBlank((String)regionCode)) {
            regionCode = this.regionConfig.getRegioncode();
        }
        List regionList = this.regionManagerClient.findJuniorRegionsEnabled(this.regionManagerClient.findRegionByCode(regionCode).getId());
        List mapList = this.getAllRegionsFilter01(regionList);
        return mapList;
    }

    private List<Map> getAllRegionsFilter01(List<RegionDto> regionList) {
        ArrayList<Map> mapList = new ArrayList<Map>();
        List tempRegionList = new ArrayList();
        List<Object> resList = new ArrayList();
        if (!CollectionUtils.isEmpty(regionList)) {
            for (RegionDto region : regionList) {
                if (region.getEnabled() != 1 || "01".equals(region.getCode().substring(4, 6))) continue;
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("value", region.getCode());
                map.put("label", region.getName());
                map.put("checked", false);
                tempRegionList = this.regionManagerClient.findJuniorRegionsEnabled(region.getId());
                if (!CollectionUtils.isEmpty(tempRegionList) && tempRegionList.size() > 0) {
                    resList = tempRegionList.stream().filter(r -> !"01".equals(r.getCode().substring(4, 6))).collect(Collectors.toList());
                    map.put("children", this.getAllRegions(resList));
                }
                mapList.add(map);
            }
            return mapList;
        }
        return new ArrayList<Map>();
    }

    @RequestMapping(value={"/findRegionNameByCode"})
    public Object findRegionNameByCode(@RequestParam(name="regionCode", required=false) String regionCode) {
        String cityName = "";
        String countyName = "";
        if (regionCode.length() == 2) {
            return this.regionManagerClient.findRegionByCode(regionCode).getName();
        }
        if (regionCode.length() == 4) {
            return this.regionManagerClient.findRegionByCode(regionCode).getName();
        }
        cityName = this.regionManagerClient.findRegionByCode(regionCode.substring(0, 4)).getName();
        countyName = this.regionManagerClient.findRegionByCode(regionCode).getName();
        return cityName + countyName;
    }

    @RequestMapping(value={"/queryRegionByRegionCode"})
    public Object queryRegionByRegionCode(@RequestParam(name="regionCode", required=false) String regionCode) {
        if (StringUtils.isBlank((String)regionCode)) {
            regionCode = this.regionConfig.getRegioncode();
        }
        ArrayList<RegionDto> regionList = new ArrayList<RegionDto>();
        RegionDto region = this.regionManagerClient.findRegionByCode(regionCode);
        if (region != null) {
            regionList.add(region);
        }
        List mapList = this.getAllRegionsFilter01(regionList);
        return mapList;
    }

    @RequestMapping(value={"/queryRegionsByRegionCodes"})
    public String queryRegionsByRegionCodes(@RequestParam(name="regionCodes[]", required=false) String[] regionCodes) {
        StringBuilder stringBuilder = new StringBuilder();
        List<String> regions = Arrays.asList(regionCodes);
        regions.forEach(r -> stringBuilder.append(this.regionManagerClient.findRegionByCode(r).getName()).append("  "));
        return stringBuilder.toString();
    }
}

