/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtcc.gis.resource.ui.web.rest;

import cn.gtmap.gtc.clients.RoleManagerClient;
import cn.gtmap.gtcc.gis.resource.ui.domain.RoleView;
import cn.gtmap.gtcc.gis.resource.ui.domain.RoleViewBuilder;
import cn.gtmap.gtcc.tddc.domain.resource.dto.resource.MenuView;
import cn.gtmap.gtcc.tddc.domain.resource.metadata.Menu;
import cn.gtmap.gtcc.tddc.service.clients.resource.MenuClient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
@RequestMapping(value={"/rest/menu"})
public class MenuController {
    @Autowired
    private MenuClient menuClient;
    @Autowired
    private RoleManagerClient roleManagerClient;
    @Autowired
    private RoleViewBuilder roleViewBuilder;

    @RequestMapping(value={"saveMenu"})
    public Menu saveMenu(Menu menu) {
        return this.menuClient.saveMenu(menu);
    }

    @RequestMapping(value={"/findMenuById/{id}"})
    public MenuView findMenuById(@PathVariable(name="id") String id) {
        return this.menuClient.findMenuById(id);
    }

    @RequestMapping(value={"saveMenuParams"})
    public Menu saveMenuParams(@RequestParam(name="parentId", required=false) String parentId, @RequestParam(name="id", required=false) String id, @RequestParam(name="name", required=false) String name, @RequestParam(name="type", required=false) String type, @RequestParam(name="url", required=false) String url, @RequestParam(name="remark", required=false) String remark, @RequestParam(name="isAdd", required=false) boolean isAdd, @RequestParam(name="icon", required=false) String icon, @RequestParam(name="css", required=false) String css) {
        return this.menuClient.saveMenuParams(parentId, id, name, type, url, remark, isAdd, icon, css);
    }

    @RequestMapping(value={"/deleteMenu/{id}"})
    public void deleteMenu(@PathVariable(name="id") String id) {
        this.menuClient.deleteMenu(id);
    }

    @RequestMapping(value={"/query/findRoleByAlias"})
    public List<RoleView> findRoleByAlias(@RequestParam(name="alias", required=false) String alias) {
        PageRequest pageable = new PageRequest(0, 1000);
        Page roleDtoPage = this.roleManagerClient.listRoleRecords((Pageable)pageable, null, alias, Integer.valueOf(1));
        return this.roleViewBuilder.build(roleDtoPage.getContent());
    }

    @RequestMapping(value={"/updateMenu"})
    public Object updateMenu(@RequestParam(name="nodeArr[]") String[] nodeArr, @RequestParam(name="type") String type) {
        try {
            return this.menuClient.updateMenu(nodeArr, type);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @RequestMapping(value={"/query/getAllMenus"})
    public List<Map> getAllMenus() {
        List mapList = this.getMenuList(this.menuClient.getAllMenus());
        return mapList;
    }

    @RequestMapping(value={"/associate/associateMenuAndRoles"})
    public Object associateMenuAndRoles(@RequestParam(name="menuId") String menuId, @RequestParam(name="roleIds[]") String[] roles, @RequestParam(name="replaceAll", required=false) boolean replace) {
        try {
            return this.menuClient.associateMenuAndRoles(menuId, roles, replace);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @RequestMapping(value={"/remove/removeMenuAndRole"})
    public Object removeMenuAndRole(@RequestParam(name="menuId") String menuId, @RequestParam(name="roleId") String roleId) {
        return this.menuClient.removeMenuAndRole(menuId, roleId);
    }

    @RequestMapping(value={"/queryMenuRoleRefsByMenuId/{menuId}"})
    public List<RoleView> queryMenuRoleRefsByMenuId(@PathVariable(name="menuId") String menuId) {
        List roleIds = this.menuClient.queryMenuRoleRefsByMenuId(menuId);
        if (CollectionUtils.isEmpty((Collection)roleIds)) {
            return new ArrayList<RoleView>();
        }
        return this.roleViewBuilder.build(this.roleManagerClient.queryRolesByIds(roleIds));
    }

    private List<Map> getMenuList(List<MenuView> menuViews) {
        ArrayList<Map> mapList = new ArrayList<Map>();
        if (!CollectionUtils.isEmpty(menuViews)) {
            for (MenuView menuView : menuViews) {
                HashMap<String, Object> map = new HashMap<String, Object>(16);
                map.put("value", menuView.getId());
                map.put("label", menuView.getName());
                map.put("url", menuView.getUrl());
                map.put("type", menuView.getType());
                map.put("status", "0");
                map.put("weight", menuView.getWeight());
                if (!CollectionUtils.isEmpty((Collection)menuView.getChildren()) && menuView.getChildren().size() > 0) {
                    map.put("children", this.getMenuList(menuView.getChildren()));
                } else {
                    map.put("children", new ArrayList());
                }
                mapList.add(map);
            }
            return mapList;
        }
        return new ArrayList<Map>();
    }
}

