/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtcc.gis.resource.ui.web.rest;

import cn.gtmap.gtcc.tddc.domain.gis.data.search.IndexView;
import cn.gtmap.gtcc.tddc.domain.gis.data.search.ResultBean;
import cn.gtmap.gtcc.tddc.service.clients.gis.data.search.EsRestClient;
import cn.gtmap.gtcc.tddc.service.clients.gis.search.EsCustomQueryClient;
import cn.gtmap.gtcc.tddc.service.clients.gis.search.EsDataManageClient;
import cn.gtmap.gtcc.tddc.service.clients.gis.search.EsViewManageClient;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
@RequestMapping(value={"/rest/index"})
public class IndexRestController {
    @Autowired
    private EsViewManageClient esViewManageClient;
    @Autowired
    private EsDataManageClient esDataManageClient;
    @Autowired
    private EsCustomQueryClient esCustomQueryClient;
    @Autowired
    private EsRestClient esRestClient;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @GetMapping(value={"/query/all"})
    public Page<IndexView> findIndices(Pageable pageable) {
        return this.esViewManageClient.getIndices(pageable);
    }

    @PostMapping(value={"/add"})
    public ResultBean addIndex(@RequestBody IndexView indexView) {
        return this.esViewManageClient.addIndex(indexView);
    }

    @PostMapping(value={"/update"})
    public ResultBean updateIndex(@RequestBody IndexView indexView) {
        return this.esViewManageClient.updateIndex(indexView);
    }

    @GetMapping(value={"/delete"})
    public ResultBean deleteIndex(@RequestParam(name="index") String index) {
        return this.esViewManageClient.deleteIndex(index);
    }

    @GetMapping(value={"/refresh"})
    public ResultBean refresh(@RequestParam(name="index") String index) {
        return this.esViewManageClient.refreshIndex(index);
    }

    @GetMapping(value={"/{name}/upload"})
    public ResultBean uploadData(@RequestParam Map<String, String> params, @PathVariable(value="name") String name) {
        return this.esDataManageClient.importFromWeb(params, name);
    }

    @PostMapping(value={"/{name}/test"})
    public String test(@RequestBody(required=false) String queryJson, @PathVariable(value="name") String name) {
        String query = "";
        if (StringUtils.isNotEmpty((String)queryJson)) {
            try {
                query = URLDecoder.decode(queryJson, "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                this.logger.error("\u5bf9\u81ea\u5b9a\u4e49\u67e5\u8be2\u8f93\u5165\u8fdb\u884c\u8f6c\u4e49\u65f6\u53d1\u751f\u9519\u8bef");
            }
        }
        return "r=" + this.esCustomQueryClient.customQuery(query, name);
    }

    @PostMapping(value={"/{name}/checkGeometry"})
    public boolean checkGeometry(@RequestBody Map params, @PathVariable(value="name") String name) {
        return this.esRestClient.checkGeometry(params, name);
    }

    @GetMapping(value={"/getLastUploadInfo"})
    ResponseEntity getLastUploadInfo(@RequestParam(name="index") String index) {
        String info = this.esViewManageClient.getLastUploadInfo(index);
        String html = "<html><head></head><body><pre style=\"word-wrap: break-word; white-space: pre-wrap;\">" + (StringUtils.isEmpty((String)info) ? "" : info) + "</pre></body></html>";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.TEXT_HTML);
        return new ResponseEntity((Object)html, (MultiValueMap)headers, HttpStatus.OK);
    }
}

